interface Api {
  sendMessage(message: string, threadID: string, messageID: string): Promise<any>;
}

interface Models {
  // Define model types if known
}

interface UsersController {
  // Define Users controller methods if known
}

interface ThreadsController {
  // Define Threads controller methods if known
}

interface CurrenciesController {
  // Define Currencies controller methods if known
}

interface Event {
  messageID: string;
  threadID: string;
  // Add other event properties as needed
}

interface OnReactionData {
  messageID: string;
  name: string;
  // Add other properties of onReaction data if known
}

interface CommandModule {
  onReaction?: (options: { api: Api; event: Event; models: Models; Users: UsersController; Threads: ThreadsController; Currencies: CurrenciesController; onReaction: OnReactionData }) => void;
}

export default function ({ api, models, Users, Threads, Currencies }: { api: Api; models: Models; Users: UsersController; Threads: ThreadsController; Currencies: CurrenciesController }) {
  return function ({ event }: { event: Event }) {
    const { onReaction, commands } = global.zuckbot;
    if (onReaction.length === 0) return;

    const indexOfHandle = onReaction.findIndex((e: OnReactionData) => e.messageID === event.messageID);
    if (indexOfHandle < 0) return;

    const reactionData: OnReactionData = onReaction[indexOfHandle];
    const commandModule: CommandModule | undefined = commands.get(reactionData.name);

    if (!commandModule) {
      api.sendMessage(`Thiếu dữ liệu để có thể thực thi phản hồi lại câu trả lời của bạn`, event.threadID, event.messageID);
      return;
    }

    try {
      if (commandModule.onReaction) {
        commandModule.onReaction({ api, event, models, Users, Threads, Currencies, onReaction: reactionData });
      }
    } catch (error) {
      api.sendMessage(`Đã xảy ra lỗi không mong muốn khi đang thực thi trả lời câu hỏi bạn, lỗi: ${error}`, event.threadID, event.messageID);
    }
  };
}


