import { join } from "path";
import * as fs from "fs-extra";

interface Api {
  // Define API methods if known
}

interface Models {
  // Define model types if known
}

interface UsersController {
  // Define Users controller methods if known
}

interface ThreadsController {
  // Define Threads controller methods if known
}

interface CurrenciesController {
  // Define Currencies controller methods if known
}

interface Event {
  logMessageType: string;
  // Add other event properties as needed
}

interface CommandModule {
  zuckbotconfig: { name: string; eventType: string[] };
  onRun?: (options: { api: Api; event: Event; models: Models; Users: UsersController; Threads: ThreadsController; Currencies: CurrenciesController }) => void;
}

export default function ({ api, models, Users, Threads, Currencies }: { api: Api; models: Models; Users: UsersController; Threads: ThreadsController; Currencies: CurrenciesController }) {
  const logger = global.loading;
  return function ({ event }: { event: Event }) {
    const { events } = global.zuckbot;

    // Assuming short.js will also be converted to TS and exported as default
    const shortJsPath = join(process.cwd(), "cmds/short.js");
    if (fs.existsSync(shortJsPath)) {
      require(shortJsPath).events({ api, event, models, Users, Threads, Currencies });
    }

    for (const [key, value] of events.entries()) {
      const commandModule: CommandModule = value;
      if (commandModule.zuckbotconfig.eventType.includes(event.logMessageType)) {
        if (commandModule.onRun) {
          try {
            commandModule.onRun({ api, event, models, Users, Threads, Currencies });
          } catch (error: any) {
            logger(`Đã xảy ra lỗi không mong muốn trong khi thực thi event ${commandModule.zuckbotconfig.name}, lỗi: ${JSON.stringify(error)}`, "error");
          }
        }
      }
    }
    return;
  };
}


