interface Api {
  setMessageReactionMqtt(emoji: string, messageID: string, threadID: string): Promise<any>;
  sendMessage(message: string | object, threadID: string, callback?: (err: any, res: any) => void, messageID?: string): Promise<any>;
  addUserToGroup(uid: string, threadID: string): Promise<any>;
  removeUserFromGroup(uid: string, threadID: string): Promise<any>;
}

interface Models {
  // Define model types if known
}

interface UsersController {
  // Define Users controller methods if known
}

interface ThreadsController {
  // Define Threads controller methods if known
}

interface CurrenciesController {
  // Define Currencies controller methods if known
}

interface Event {
  senderID: string;
  threadID: string;
  messageID: string;
  // Add other event properties as needed
}

interface Box {
  react(emoji: string): Promise<any>;
  reply(msg: string | object): Promise<any>;
  add(uid: string): Promise<any>;
  kick(uid: string): Promise<any>;
  send(msg: string | object, id?: string): Promise<any>;
}

interface CommandModule {
  zuckbotconfig: { name: string };
  onEvent?: (options: { send: Function; event: Event; api: Api; models: Models; Users: UsersController; Threads: ThreadsController; Currencies: CurrenciesController; box: Box }) => void;
}

export default function ({ api, models, Users, Threads, Currencies }: { api: Api; models: Models; Users: UsersController; Threads: ThreadsController; Currencies: CurrenciesController }) {
  const logger = global.loading;
  return function ({ event }: { event: Event }) {
    const { commands, eventRegistered } = global.zuckbot;
    const { senderID, threadID, messageID } = event;
    const box: Box = {
      react: (emoji: string) => api.setMessageReactionMqtt(emoji, messageID, threadID),
      reply: (msg: string | object) => api.sendMessage(msg, threadID, messageID),
      add: (uid: string) => api.addUserToGroup(uid, threadID),
      kick: (uid: string) => api.removeUserFromGroup(uid, threadID),
      send: (msg: string | object, id?: string) => api.sendMessage(msg, id || threadID),
    };
    const send = (msg: string | object, callback?: (err: any, res: any) => void) => new Promise<any>(r =>
      api.sendMessage(msg, threadID, (err: any, res: any) => {
        if (callback) callback(err, res);
        r(res || err);
      },
        messageID
      )
    );
    if ((senderID === threadID))
      return;

    for (const eventReg of eventRegistered) {
      try {
        const commandModule: CommandModule | undefined = commands.get(eventReg);
        if (commandModule && commandModule.onEvent) {
          commandModule.onEvent({ send, event, api, models, Users, Threads, Currencies, box });
        }
      } catch (error: any) {
        const cmdName = commands.get(eventReg)?.zuckbotconfig?.name || eventReg;
        logger(
          `Đã xảy ra lỗi không mong muốn tại lệnh ${cmdName}, lỗi: ${error.message}`,
          "error",
        );
      }
    }
  };
}


