import { Sequelize, Model, DataTypes } from "sequelize";

interface UsersAttributes {
  num?: number;
  userID: number;
  name?: string;
  data?: object;
}

export default function ({ sequelize, Sequelize }: { sequelize: Sequelize; Sequelize: typeof Sequelize }) {
  class Users extends Model<UsersAttributes> implements UsersAttributes {
    public num!: number;
    public userID!: number;
    public name?: string;
    public data?: object;
  }

  Users.init(
    {
      num: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
      },
      userID: {
        type: DataTypes.BIGINT,
        unique: true,
      },
      name: {
        type: DataTypes.STRING,
      },
      data: {
        type: DataTypes.JSON,
      },
    },
    {
      sequelize,
      tableName: "Users",
      modelName: "Users",
    }
  );

  return Users;
}


