import { Sequelize, Model, DataTypes } from "sequelize";

interface ThreadsAttributes {
  num?: number;
  threadID: number;
  threadInfo?: object;
  data?: object;
}

export default function ({ sequelize, Sequelize }: { sequelize: Sequelize; Sequelize: typeof Sequelize }) {
  class Threads extends Model<ThreadsAttributes> implements ThreadsAttributes {
    public num!: number;
    public threadID!: number;
    public threadInfo?: object;
    public data?: object;
  }

  Threads.init(
    {
      num: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
      },
      threadID: {
        type: DataTypes.BIGINT,
        unique: true,
      },
      threadInfo: {
        type: DataTypes.JSON,
      },
      data: {
        type: DataTypes.JSON,
      },
    },
    {
      sequelize,
      tableName: "Threads",
      modelName: "Threads",
    }
  );

  return Threads;
}


