import { Sequelize, Model, DataTypes } from "sequelize";

interface CurrenciesAttributes {
  num?: number;
  userID: number;
  coins: number;
  exp: number;
  data?: object;
}

export default function ({ sequelize, Sequelize }: { sequelize: Sequelize; Sequelize: typeof Sequelize }) {
  class Currencies extends Model<CurrenciesAttributes> implements CurrenciesAttributes {
    public num!: number;
    public userID!: number;
    public coins!: number;
    public exp!: number;
    public data?: object;
  }

  Currencies.init(
    {
      num: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
      },
      userID: {
        type: DataTypes.BIGINT,
        unique: true,
      },
      coins: {
        type: DataTypes.BIGINT,
        defaultValue: 0,
      },
      exp: {
        type: DataTypes.BIGINT,
        defaultValue: 0,
      },
      data: {
        type: DataTypes.JSON,
      },
    },
    {
      sequelize,
      tableName: "Currencies",
      modelName: "Currencies",
    }
  );

  return Currencies;
}


