import { Sequelize, Model, DataTypes } from "sequelize";

interface DatabaseModels {
  Users: typeof Model & (new () => any);
  Threads: typeof Model & (new () => any);
  Currencies: typeof Model & (new () => any);
}

interface DatabaseInput {
  Sequelize: typeof Sequelize;
  sequelize: Sequelize;
}

export default function (input: DatabaseInput) {
  const force = false;

  const Users = require("./models/users").default(input); // Assuming models will export default
  const Threads = require("./models/threads").default(input);
  const Currencies = require("./models/currencies").default(input);

  Users.sync({ force });
  Threads.sync({ force });
  Currencies.sync({ force });

  return {
    model: {
      Users,
      Threads,
      Currencies,
    },
    use: function (modelName: keyof DatabaseModels) {
      return this.model[modelName];
    },
  };
}


