import axios from "axios";
import stringSimilarity from "string-similarity";

interface ZuckbotConfig {
  name: string;
  aliases?: string[];
  version: string;
  author: string;
  role: number;
  info: string;
  Category: string;
  image: string[];
  shadowPrefix: boolean;
  cd: number;
}

interface Event {
  threadID: string;
  messageID: string;
  senderID: string;
}

interface OnRunParams {
  api: any;
  event: Event;
  args: string[];
}

interface CommandCategory {
  cmdCategory: string;
  permission: number;
  nameModule: string[];
}

export const zuckbotconfig: ZuckbotConfig = {
  name: "help",
  version: "2.3.1.2",
  author: "Nguyễn Thanh Tuấn",
  role: 0,
  info: "Xem danh sách lệnh và info",
  Category: "Tiện ích",
  image: [],
  shadowPrefix: false,
  cd: 5,
};

export const onRun = async function ({ api, event, args }: OnRunParams) {
  const { threadID: tid, messageID: mid, senderID: sid } = event;
  const type = !args[0] ? "" : args[0].toLowerCase();
  let msg = "";
  const array: CommandCategory[] = [];
  const cmds = global.zuckbot.commands;
  const TIDdata = global.db.threadData.get(parseInt(tid)) || {};
  const admin = global.settings.botAdmins;
  const NameBot = global.settings.NameBots;
  const prefix = TIDdata.boxPrefix || global.settings.botPrefix;

  if (type === "all") {
    let i = 0;
    for (const cmd of cmds.values()) {
      msg += `${++i}. ${cmd.zuckbotconfig.name}\n→ Mô tả: ${cmd.zuckbotconfig.info}\n────────────────\n`;
    }
    return api.sendMessage(msg, tid, mid);
  }

  if (type) {
    const allCommandNames: string[] = [];
    for (const cmd of cmds.values()) {
      allCommandNames.push(cmd.zuckbotconfig.name.toString());
    }

    if (!allCommandNames.includes(args[0].toLowerCase())) {
      const commandName = args[0].toLowerCase();
      const checker = stringSimilarity.findBestMatch(commandName, allCommandNames);
      if (checker.bestMatch.rating >= 0.5) {
        const command = cmds.get(checker.bestMatch.target);
        if (!command) {
          msg = `Không tìm thấy lệnh '${type}' trong hệ thống.\n➝ Lệnh gần giống được tìm thấy '${checker.bestMatch.target}' nhưng không tồn tại.`;
          return api.sendMessage(msg, tid, mid);
        }
        msg = `Không tìm thấy lệnh '${type}' trong hệ thống.\n➝ Lệnh gần giống được tìm thấy '${checker.bestMatch.target}'`;
        return api.sendMessage(msg, tid, mid);
      }
    }

    const cmd = cmds.get(type);
    if (!cmd) {
      msg = `Không tìm thấy lệnh '${type}' trong hệ thống.`;
      return api.sendMessage(msg, tid, mid);
    }

    const cmdConfig: ZuckbotConfig = cmd.zuckbotconfig;
    const imageStreams: any[] = [];
    for (const imgUrl of cmdConfig.image) {
      try {
        const response = await axios.get(imgUrl, { responseType: "stream" });
        imageStreams.push(response.data);
      } catch (error) {
        console.error(`Error fetching image ${imgUrl}:`, error);
      }
    }

    api.sendMessage(
      {
        body:
          `[ HƯỚNG DẪN SỬ DỤNG ]\n────────────────\n→ Tên lệnh: ${cmdConfig.name}\n→ Phiên bản: ${cmdConfig.version}\n→ Quyền Hạn: ${cmdConfig.role === 0 ? "Thành Viên" : cmdConfig.role === 1 ? "Quản Trị Viên" : cmdConfig.role === 2 ? "Admin Bot" : "Toàn Quyền"}\n→ Mô Tả: ${cmdConfig.info}\n→ Nhóm: ${cmdConfig.Category}\n→ Cooldowns: ${cmdConfig.cd}s`,
        attachment: imageStreams,
      },
      tid,
      mid,
    );
  } else {
    CmdCategory();
    array.sort(S("nameModule"));
    for (const cmdCategory of array) {
      msg += `[ ${cmdCategory.cmdCategory.toUpperCase()} ]\n→ Tổng lệnh: ${cmdCategory.nameModule.length} lệnh\n${cmdCategory.nameModule.join(", ")}\n────────────────\n`;
    }
    msg += `→ Tổng số lệnh: ${cmds.size} lệnh\n→ Tổng số admin bot: ${admin.length}\n→ Tên Bot: ${NameBot}\n${prefix}help + tên lệnh để xem chi tiết\n${prefix}help + all để xem tất cả lệnh`;
    api.sendMessage(msg, tid, mid);
  }

  function CmdCategory() {
    for (const cmd of cmds.values()) {
      const { Category, role, name: nameModule } = cmd.zuckbotconfig;
      const existingCategory = array.find((i) => i.cmdCategory === Category);
      if (!existingCategory) {
        array.push({
          cmdCategory: Category,
          permission: role,
          nameModule: [nameModule],
        });
      } else {
        existingCategory.nameModule.push(nameModule);
      }
    }
  }
};

function S(k: keyof CommandCategory) {
  return function (a: CommandCategory, b: CommandCategory) {
    let i = 0;
    if (a[k].length > b[k].length) {
      i = 1;
    } else if (a[k].length < b[k].length) {
      i = -1;
    }
    return i * -1;
  };
}


