import path from "path";
import fs from "fs-extra";
import FormData from "form-data";
import axios from "axios";

interface ZuckbotConfig {
  name: string;
  aliases: string[];
  version: string;
  author: string;
  role: number;
  info: string;
  Category: string;
  cd: number;
  shadowPrefix: boolean;
  image: any[];
}

interface Event {
  threadID: string;
  messageID: string;
  senderID: string;
  messageReply?: { attachments: any[] };
  body?: string;
}

interface OnRunOptions {
  api: any;
  event: Event;
  args: string[];
  box: any;
  sendVD: (msg: string, callback?: (err: any, res: any) => void) => void;
}

interface OnReplyOptions {
  onReply: { type: string; author: string; messageID: string; data?: any; fileName?: string; livelink?: string; };
  event: Event;
  api: any;
}

const folder = path.join(process.cwd(), "db", "data");
const apiFile = path.join(folder, "api.json");

if (!fs.existsSync(folder)) fs.mkdirSync(folder);

let data: { [key: string]: string[] } = {};

const save = () => fs.writeFileSync(apiFile, JSON.stringify(data, null, 2));

if (!fs.existsSync(apiFile)) {
  save();
} else {
  data = fs.readJsonSync(apiFile);
}

export const zuckbotconfig: ZuckbotConfig = {
  name: "api",
  aliases: ["shadow"],
  version: "2.3.1.2",
  author: "Nguyễn Thanh Tuấn",
  role: 2,
  info: "API",
  Category: "Admin",
  cd: 3,
  shadowPrefix: false,
  image: [],
};

export const onRun = async function (o: OnRunOptions) {
  const send = (msg: string, callback?: (err: any, res: any) => void) =>
    o.api.sendMessage(msg, o.event.threadID, callback, o.event.messageID);

  if (o.args.length === 0) {
    return send(
      "[ Api - Hướng Dẫn Sử Dụng ]\n\napi add [name] [reply+ảnh, video, GIF]: Thêm data cho api\napi create [name]: Tạo thêm data api\napi list: Kiểm tra Api hiện có\n\n📌 Sử dụng api + [tag] cần dùng!",
    );
  }

  if (o.args[0] === "cre" || o.args[0] === "create") {
    if (o.args.length < 2 || o.args.length > 3) return send("⚠️ Vui lòng nhập tên file");
    const name = o.args[1];
    if (data.hasOwnProperty(name)) {
      send(`Đã có API ${name}`);
    } else {
      fs.writeFileSync(path.join(folder, `${name}.json`), "[]");
      data[name] = [];
      send(`Tạo Thành Công API ${name}`);
    }
  } else if (o.args[0] === "add") {
    const name = o.args[1];
    const attachments = o.event.messageReply?.attachments;
    const links: string[] = [];

    if (!attachments || attachments.length === 0) {
      return send("Vui lòng reply tin nhắn kèm ảnh, video hoặc GIF để thêm vào API.");
    }

    for (const attachment of attachments) {
      const validTypes = ["photo", "video", "audio", "animated_image"];
      if (!validTypes.includes(attachment.type)) continue;

      const url = attachment.url;
      try {
        const response = await axios.get(url, { responseType: "arraybuffer" });
        const buffer = Buffer.from(response.data, "binary");

        const form = new FormData();
        form.append("reqtype", "fileupload");
        form.append("userhash", "");
        form.append("fileToUpload", buffer, {
          filename:
            `upload.${attachment.type === "photo" ? "png" :
            attachment.type === "animated_image" ? "gif" :
            attachment.type === "video" ? "mp4" : "mp3"}`,
        });

        const uploadResponse = await axios.post("https://catbox.moe/user/api.php", form, {
          headers: form.getHeaders(),
        });

        const uploadData = uploadResponse.data;
        if (uploadData.startsWith("Error:")) {
          return o.sendVD("Có lỗi xảy ra khi up ảnh: " + uploadData);
        }
        links.push(uploadData);
      } catch (error) {
        console.error("Error uploading attachment:", error);
        return o.sendVD("Đã xảy ra lỗi khi tải lên tệp đính kèm.");
      }
    }
    if (!data.hasOwnProperty(name)) {
      return send(`API "${name}" không tồn tại. Vui lòng tạo API trước.`);
    }
    data[name] = data[name].concat(links);
    fs.writeFileSync(path.join(folder, `${name}.json`), JSON.stringify(data[name], null, 2));
    o.box.send("✅");
    save();
  } else if (o.args[0] === "list") {
    const apiList = Object.keys(data);
    let listMessage = "[ Danh Sách ]\n\n";
    apiList.forEach((apiName, index) => {
      const numLinks = data[apiName].length;
      listMessage += `${index + 1}. ${apiName}: ${numLinks} link(s)\n`;
    });
    o.sendVD(`${listMessage}\nreply tin nhắn kèm stt để xem thông tin`, (err: any, res: any) => {
      res.name = zuckbotconfig.name;
      res.author = o.event.senderID;
      res.event = o.event;
      res.type = "list";
      res.data = data;
      global.zuckbot.onReply.push(res);
    });
  }
  save();
};

export const onReply = async function (o: OnReplyOptions) {
  const { type, author } = o.onReply;
  const send = function (a: any) {
    if (typeof a === "object" || Array.isArray(a)) {
      if (Object.keys(a).length !== 0) a = JSON.stringify(a, null, 4);
      else a = "";
    }
    if (typeof a === "number") a = a.toString();
    return o.api.sendMessage(a, o.event.threadID, o.event.messageID);
  };

  if (o.event.senderID !== author) {
    return send("Bạn không có quyền để trả lời tin nhắn này.");
  }

  if (type === "list") {
    const bodyAsNumber = parseInt(o.event.body || "");
    if (bodyAsNumber >= 1 && bodyAsNumber <= Object.keys(o.onReply.data).length) {
      const fileName = Object.keys(o.onReply.data)[bodyAsNumber - 1];
      const numLinks = o.onReply.data[fileName].length;
      const filePath = path.join(folder, `${fileName}.json`);
      const fileContent = fs.readFileSync(filePath, "utf8");
      const linksArray: string[] = JSON.parse(fileContent);
      let solinklive = 0;
      let solinkdie = 0;
      const linkdie: string[] = [];
      const soluong = 10;
      const OwO: string[][] = [];

      for (let i = 0; i < linksArray.length; i += soluong) {
        OwO.push(linksArray.slice(i, i + soluong));
      }

      const checkLinkPromises = OwO.map(async (chunk) => {
        await Promise.all(
          chunk.map(async (link) => {
            try {
              const response = await axios.head(link);
              if (response.status === 200) {
                solinklive++;
              } else {
                solinkdie++;
                linkdie.push(link);
              }
            } catch (error) {
              solinkdie++;
              linkdie.push(link);
            }
          }),
        );
      });

      await Promise.all(checkLinkPromises);

      const updatedLinksArray = linksArray.filter((link) => !linkdie.includes(link));
      const livelink = JSON.stringify(updatedLinksArray, null, 4);

      o.api.sendMessage(
        `[ API - (${fileName}) ]\n🌐 Số link hiện có: ${numLinks}\nLive: ${solinklive}\nDie: ${solinkdie}\nReply tin nhắn và chọn [loc/xoa]`,
        o.event.threadID,
        (error: any, res: any) => {
          global.zuckbot.onReply.push({
            name: zuckbotconfig.name,
            messageID: res.messageID,
            author: o.event.senderID,
            type: "chon",
            fileName,
            livelink,
          });
        },
        o.event.messageID,
      );
      return o.api.unsendMessage(o.onReply.messageID);
    } else {
      send("stt không hợp lệ");
    }
  } else if (type === "chon") {
    const fileName = o.onReply.fileName;
    const livelink = JSON.parse(o.onReply.livelink || "[]");

    if (o.event.body === "xoa" || o.event.body === "Xoa") {
      if (fileName && data.hasOwnProperty(fileName)) {
        fs.unlinkSync(path.join(folder, `${fileName}.json`));
        delete data[fileName];
        send(`Đã xóa API "${fileName}"`);
        save();
      } else {
        send(`API "${fileName}" không tồn tại.`);
      }
    } else if (o.event.body?.toLowerCase() === "loc") {
      try {
        if (fileName) {
          const filePath = path.join(folder, `${fileName}.json`);
          data[fileName] = livelink;
          save();
          fs.writeFileSync(filePath, JSON.stringify(livelink, null, 4));
          send(`Đã cập nhật API "${fileName}" với các link sống.`);
        }
      } catch (error) {
        console.error(error);
        send("Đã xảy ra lỗi khi cập nhật link API.");
      }
    }
  }
  save();
};


