import chalk from "chalk";

const logger = (data: string, option?: "warn" | "error") => {
  switch (option) {
    case "warn":
      console.log(chalk.yellow("[ ❕ Lỗi rồi ] » ") + data);
      break;
    case "error":
      console.log(chalk.red("[ ❕ Lỗi rồi ] » ") + data);
      break;
    default:
      console.log(chalk.magenta(`[ Shadow ] » `) + data);
      break;
  }
};

logger.loader = (data: string, option?: "warn" | "error") => {
  switch (option) {
    case "warn":
      console.log(chalk.yellow("[ Shadow ] » ") + data);
      break;
    case "error":
      console.log(chalk.red("[ Shadow ] » ") + data);
      break;
    default:
      console.log(chalk.green(`[ Shadow ] » `) + data);
      break;
  }
};

logger.bold = (data: string) => {
  console.log(chalk.bold(chalk.green(data)));
};

logger.autoLogin = async (onBot: Function, botData: any) => {
  onBot(botData);
};

export default logger;


