/* eslint-disable no-prototype-builtins */

import { CookieJar } from "tough-cookie";
import request from "request";
import { Stream } from "stream";
import * as querystring from "querystring";
import { URL } from "url";

const getRandom = <T>(arr: T[]): T => arr[Math.floor(Math.random() * arr.length)];

export function randomUserAgent(): string {
  const platform = {
    platform: ["Windows NT 10.0; Win64; x64", "Macintosh; Intel Mac OS X 14.7; rv:132.0"],
    browsers: {
      chrome: ["122.0.0.0", "121.0.0.0"],
      firefox: ["123.0", "122.0"],
      edge: ["122.0.2365.92"],
    },
  };
  const browserName = getRandom(Object.keys(platform.browsers));
  const version = getRandom((platform.browsers as any)[browserName]);
  const plat = getRandom(platform.platform);
  const userAgentArray = [
    defaultUserAgent,
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.3",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.1.1 Safari/605.1.15",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.12; rv:45.0) Gecko/20100101 Firefox/45.0",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:66.0) Gecko/20100101 Firefox/66.0",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/601.7.7 (KHTML, like Gecko) Version/9.1.2 Safari/601.7.7",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.1.2 Safari/603.3.8",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.140 Safari/537.3",
  ];
  const ua = getRandom([
    browserName === "firefox" ? `Mozilla/5.0 (${plat}) Gecko/20100101 Firefox/${version}` : `Mozilla/5.0 (${plat}) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/${version} Safari/537.36`,
    getRandom(userAgentArray),
  ]);
  return ua;
}

const defaultUserAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 14.7; rv:132.0) Gecko/20100101 Firefox/132.0";
const headers = {
  "content-type": "application/x-www-form-urlencoded",
  referer: "https://www.facebook.com/",
  origin: "https://www.facebook.com",
  connection: "keep-alive",
  "Sec-Fetch-Site": "same-origin",
  "Sec-Fetch-User": "?1",
  "User-Agent": defaultUserAgent,
};

let currentRequest = request.defaults({
  jar: true,
});

export function setProxy(proxy?: string) {
  currentRequest = request.defaults({
    jar: true,
    ...(proxy && { proxy }),
  });
}

interface CustomHeader {
  customUserAgent?: string;
  noRef?: boolean;
  [key: string]: any;
}

interface Options {
  userAgent?: string;
  [key: string]: any;
}

interface Context {
  region?: string;
  [key: string]: any;
}

function getHeaders(url: string, options?: Options, ctx?: Context, customHeader?: CustomHeader) {
  const headers1 = {
    host: new URL(url).hostname,
    ...headers,
  };
  if (headers1["User-Agent"]) {
    delete headers1["User-Agent"];
    headers1["User-Agent"] = customHeader?.customUserAgent ?? options?.userAgent ?? defaultUserAgent;
  }
  if (ctx && ctx.region) headers1["X-MSGR-Region"] = ctx.region;
  if (customHeader) {
    Object.assign(headers1, customHeader);
    if (customHeader.noRef) delete headers1.referer;
  }
  return headers1;
}

export function isReadableStream(obj: any): obj is Stream {
  return obj instanceof Stream && typeof obj._read === "function" && getType(obj._readableState) === "Object";
}

export function get(url: string, jar: CookieJar, qs: any, options?: Options, ctx?: Context, customHeader?: CustomHeader): Promise<any> {
  return new Promise((resolve, reject) => {
    if (getType(qs) === "Object") {
      for (const prop in qs) {
        if (getType(qs[prop]) === "Object") qs[prop] = JSON.stringify(qs[prop]);
      }
    }
    const op = {
      headers: getHeaders(url, options, ctx, customHeader),
      timeout: 60000,
      qs,
      jar,
      gzip: true,
    };

    currentRequest.get(url, op, (error: any, res: any) => (error ? reject(error) : resolve(res)));
  });
}

export function post(url: string, jar: CookieJar, form: any, options?: Options, ctx?: Context, customHeader?: CustomHeader): Promise<any> {
  return new Promise((resolve, reject) => {
    const op = {
      headers: getHeaders(url, options, ctx, customHeader),
      timeout: 60000,
      form,
      jar,
      gzip: true,
    };

    currentRequest.post(url, op, (error: any, res: any) => (error ? reject(error) : resolve(res)));
  });
}

export function postFormData(url: string, jar: CookieJar, form: any, qs?: any, options?: Options, ctx?: Context): Promise<any> {
  return new Promise((resolve, reject) => {
    if (getType(qs) === "Object") {
      for (const prop in qs) {
        if (getType(qs[prop]) === "Object") qs[prop] = JSON.stringify(qs[prop]);
      }
    }
    const op = {
      headers: getHeaders(url, options, ctx, {
        "content-type": "multipart/form-data",
      }),
      timeout: 60000,
      formData: form,
      qs,
      jar,
      gzip: true,
    };

    currentRequest.post(url, op, (error: any, res: any) => (error ? reject(error) : resolve(res)));
  });
}

export function padZeros(val: string | number, len: number = 2): string {
  val = String(val);
  while (val.length < len) val = "0" + val;
  return val;
}

export function generateThreadingID(clientID: string): string {
  const k = Date.now();
  const l = Math.floor(Math.random() * 4294967295);
  const m = clientID;
  return `<${k}:${l}-${m}@mail.projektitan.com>`;
}

export function binaryToDecimal(data: string): string {
  let ret = "";
  while (data !== "0") {
    let end = 0;
    let fullName = "";
    let i = 0;
    for (; i < data.length; i++) {
      end = 2 * end + parseInt(data[i], 10);
      if (end >= 10) {
        fullName += "1";
        end -= 10;
      } else {
        fullName += "0";
      }
    }
    ret = end.toString() + ret;
    data = fullName.slice(fullName.indexOf("1"));
  }
  return ret;
}

export function generateOfflineThreadingID(): string {
  const ret = Date.now();
  const value = Math.floor(Math.random() * 4294967295);
  const str = ("0000000000000000000000" + value.toString(2)).slice(-22);
  const msgs = ret.toString(2) + str;
  return binaryToDecimal(msgs);
}

let h: RegExp;
const i: { [key: string]: string } = {};
const j: { [key: string]: string } = {
  _: "%",
  A: "%2",
  B: "000",
  C: "%7d",
  D: "%7b%22",
  E: "%2c%22",
  F: "%22%3a",
  G: "%2c%22ut%22%3a1",
  H: "%2c%22bls%22%3a",
  I: "%2c%22n%22%3a%22%",
  J: "%22%3a%7b%22i%22%3a0%7d",
  K: "%2c%22pt%22%3a0%2c%22vis%22%3a",
  L: "%2c%22ch%22%3a%7b%22h%22%3a%22",
  M: "%7b%22v%22%3a2%2c%22time%22%3a1",
  N: ".channel%22%2c%22sub%22%3a%5b",
  O: "%2c%22sb%22%3a1%2c%22t%22%3a%5b",
  P: "%2c%22ud%22%3a100%2c%22lc%22%3a0",
  Q: "%5d%2c%22f%22%3anull%2c%22uct%22%3a",
  R: ".channel%22%2c%22sub%22%3a%5b1%5d",
  S: "%22%2c%22m%22%3a0%7d%2c%7b%22i%22%3a",
  T: "%2c%22blc%22%3a1%2c%22snd%22%3a1%2c%22ct%22%3a",
  U: "%2c%22blc%22%3a0%2c%22snd%22%3a1%2c%22ct%22%3a",
  V: "%2c%22blc%22%3a0%2c%22snd%22%3a0%2c%22ct%22%3a",
  W: "%2c%22s%22%3a0%2c%22blo%22%3a0%7d%2c%22bl%22%3a%7b%22ac%22%3a",
  X: "%2c%22ri%22%3a0%7d%2c%22state%22%3a%7b%22p%22%3a0%2c%22ut%22%3a1",
  Y: "%2c%22pt%22%3a0%2c%22vis%22%3a1%2c%22bls%22%3a0%2c%22blc%22%3a0%2c%22snd%22%3a1%2c%22ct%22%3a",
  Z: "%2c%22sb%22%3a1%2c%22t%22%3a%5b%5d%2c%22f%22%3anull%2c%22uct%22%3a0%2c%22s%22%3a0%2c%22blo%22%3a0%7d%2c%22bl%22%3a%7b%22ac%22%3a",
};
(() => {
  const l: string[] = [];
  for (const m in j) {
    i[(j as any)[m]] = m;
    l.push((j as any)[m]);
  }
  l.reverse();
  h = new RegExp(l.join("|"), "g");
})();

export function presenceEncode(str: string): string {
  return encodeURIComponent(str)
    .replace(/([_A-Z])|%../g, function (m, n) {
      return n ? "%" + n.charCodeAt(0).toString(16) : m;
    })
    .toLowerCase()
    .replace(h, function (m) {
      return i[m];
    });
}

// eslint-disable-next-line no-unused-vars
export function presenceDecode(str: string): string {
  return decodeURIComponent(
    str.replace(/[_A-Z]/g, function (m) {
      return (j as any)[m];
    }),
  );
}

export function generatePresence(userID: string): string {
  const time = Date.now();
  return (
    "E" +
    presenceEncode(
      JSON.stringify({
        v: 3,
        time: parseInt((time / 1000).toString(), 10),
        user: userID,
        state: {
          ut: 0,
          t2: [],
          lm2: null,
          uct2: time,
          tr: null,
          tw: Math.floor(Math.random() * 4294967295) + 1,
          at: time,
        },
        ch: {
          [`p_${userID}`]: 0,
        },
      }),
    )
  );
}

export function generateAccessiblityCookie(): string {
  const time = Date.now();
  return encodeURIComponent(
    JSON.stringify({
      sr: 0,
      "sr-ts": time,
      jk: 0,
      "jk-ts": time,
      kb: 0,
      "kb-ts": time,
      hcm: 0,
      "hcm-ts": time,
    }),
  );
}

export function getGUID(): string {
  /** @type {number} */
  let sectionLength: number = Date.now();
  /** @type {string} */
  const id = "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function (c) {
    /** @type {number} */
    const r = Math.floor((sectionLength + Math.random() * 16) % 16);
    /** @type {number} */
    sectionLength = Math.floor(sectionLength / 16);
    /** @type {string} */
    const _guid = (c === "x" ? r : (r & 7) | 8).toString(16);
    return _guid;
  });
  return id;
}

export function getExtension(original_extension: string, fullFileName: string = ""): string {
  if (original_extension) {
    return original_extension;
  } else {
    const extension = fullFileName.split(".").pop();
    if (extension === fullFileName) {
      return "";
    } else {
      return extension || "";
    }
  }
}

export function _formatAttachment(attachment1: any, attachment2: any) {
  // TODO: THIS IS REALLY BAD
  // This is an attempt at fixing Facebook's inconsistencies. Sometimes they give us
  // two attachment objects, but sometimes only one. They each contain part of the
  // data that you'd want so we merge them for convenience.
  // Instead of having a bunch of if statements guarding every access to image_data,
  // we set it to empty object and use the fact that it'll return undefined.
  const fullFileName = attachment1.filename;
  const fileSize = Number(attachment1.fileSize || 0);
  const durationVideo = attachment1.genericMetadata ? Number(attachment1.genericMetadata.videoLength) : undefined;
  const durationAudio = attachment1.genericMetadata ? Number(attachment1.genericMetadata.duration) : undefined;
  const mimeType = attachment1.mimeType;

  attachment2 = attachment2 || { id: "", image_data: {} };
  attachment1 = attachment1.mercury || attachment1;
  let blob = attachment1.blob_attachment || attachment1.sticker_attachment;
  let type = blob && blob.__typename ? blob.__typename : attachment1.attach_type;
  if (!type && attachment1.sticker_attachment) {
    type = "StickerAttachment";
    blob = attachment1.sticker_attachment;
  } else if (!type && attachment1.extensible_attachment) {
    if (
      attachment1.extensible_attachment.story_attachment &&
      attachment1.extensible_attachment.story_attachment.target &&
      attachment1.extensible_attachment.story_attachment.target.__typename &&
      attachment1.extensible_attachment.story_attachment.target.__typename === "MessageLocation"
    ) {
      type = "MessageLocation";
    } else {
      type = "ExtensibleAttachment";
    }

    blob = attachment1.extensible_attachment;
  }
  // TODO: Determine whether "sticker", "photo", "file" etc are still used
  // KEEP IN SYNC WITH getThreadHistory
  switch (type) {
    case "sticker":
      return {
        type: "sticker",
        ID: attachment1.metadata.stickerID.toString(),
        url: attachment1.url,

        packID: attachment1.metadata.packID.toString(),
        spriteUrl: attachment1.metadata.spriteURI,
        spriteUrl2x: attachment1.metadata.spriteURI2x,
        width: attachment1.metadata.width,
        height: attachment1.metadata.height,

        caption: attachment2.caption,
        description: attachment2.description,

        frameCount: attachment1.metadata.frameCount,
        frameRate: attachment1.metadata.frameRate,
        framesPerRow: attachment1.metadata.framesPerRow,
        framesPerCol: attachment1.metadata.framesPerCol,

        stickerID: attachment1.metadata.stickerID.toString(), // @Legacy
        spriteURI: attachment1.metadata.spriteURI, // @Legacy
        spriteURI2x: attachment1.metadata.spriteURI2x, // @Legacy
      };
    case "file":
      return {
        type: "file",
        ID: attachment2.id.toString(),
        fullFileName: fullFileName,
        filename: attachment1.name,
        fileSize: fileSize,
        original_extension: getExtension(attachment1.original_extension, fullFileName),
        mimeType: mimeType,
        url: attachment1.url,

        isMalicious: attachment2.is_malicious,
        contentType: attachment2.mime_type,

        name: attachment1.name, // @Legacy
      };
    case "photo":
      return {
        type: "photo",
        ID: attachment1.metadata.fbid.toString(),
        filename: attachment1.fileName,
        fullFileName: fullFileName,
        fileSize: fileSize,
        original_extension: getExtension(attachment1.original_extension, fullFileName),
        mimeType: mimeType,
        thumbnailUrl: attachment1.thumbnail_url,

        previewUrl: attachment1.preview_url,
        previewWidth: attachment1.preview_width,
        previewHeight: attachment1.preview_height,

        largePreviewUrl: attachment1.large_preview_url,
        largePreviewWidth: attachment1.large_preview_width,
        largePreviewHeight: attachment1.large_preview_height,

        url: attachment1.metadata.url, // @Legacy
        width: attachment1.metadata.dimensions.split(",")[0], // @Legacy
        height: attachment1.metadata.dimensions.split(",")[1], // @Legacy
        name: fullFileName, // @Legacy
      };
    case "animated_image":
      return {
        type: "animated_image",
        ID: attachment2.id.toString(),
        filename: attachment2.filename,
        fullFileName: fullFileName,
        original_extension: getExtension(attachment2.original_extension, fullFileName),
        mimeType: mimeType,

        previewUrl: attachment1.preview_url,
        previewWidth: attachment1.preview_width,
        previewHeight: attachment1.preview_height,

        url: attachment2.image_data.url,
        width: attachment2.image_data.width,
        height: attachment2.image_data.height,

        name: attachment1.name, // @Legacy
        facebookUrl: attachment1.url, // @Legacy
        thumbnailUrl: attachment1.thumbnail_url, // @Legacy
        rawGifImage: attachment2.image_data.raw_gif_image, // @Legacy
        rawWebpImage: attachment2.image_data.raw_webp_image, // @Legacy
        animatedGifUrl: attachment2.image_data.animated_gif_url, // @Legacy
        animatedGifPreviewUrl: attachment2.image_data.animated_gif_preview_url, // @Legacy
        animatedWebpUrl: attachment2.image_data.animated_webp_url, // @Legacy
        animatedWebpPreviewUrl: attachment2.image_data.animated_webp_preview_url, // @Legacy
      };
    case "share":
      return {
        type: "share",
        ID: attachment1.share.share_id.toString(),
        url: attachment2.href,

        title: attachment1.share.title,
        description: attachment1.share.description,
        source: attachment1.share.source,

        image: attachment1.share.media.image,
        width: attachment1.share.media.image_size.width,
        height: attachment1.share.media.image_size.height,
        playable: attachment1.share.media.playable,
        duration: attachment1.share.media.duration,

        subattachments: attachment1.share.subattachments,
        properties: {},

        animatedImageSize: attachment1.share.media.animated_image_size, // @Legacy
        facebookUrl: attachment1.share.uri, // @Legacy
        target: attachment1.share.target, // @Legacy
        styleList: attachment1.share.style_list, // @Legacy
      };
    case "video":
      return {
        type: "video",
        ID: attachment1.metadata.fbid.toString(),
        filename: attachment1.name,
        fullFileName: fullFileName,
        original_extension: getExtension(attachment1.original_extension, fullFileName),
        mimeType: mimeType,
        duration: durationVideo,

        previewUrl: attachment1.preview_url,
        previewWidth: attachment1.preview_width,
        previewHeight: attachment1.preview_height,

        url: attachment1.url,
        width: attachment1.metadata.dimensions.width,
        height: attachment1.metadata.dimensions.height,

        videoType: "unknown",

        thumbnailUrl: attachment1.thumbnail_url, // @Legacy
      };
    case "error":
      return {
        type: "error",

        // Save error attachments because we're unsure of their format,
        // and whether there are cases where it's useful for the user.
        error: attachment1.error,
      };
    case "MessageLocation":
      return {
        type: "MessageLocation",
        ID: attachment1.extensible_attachment.story_attachment.target.id,
        latitude: attachment1.extensible_attachment.story_attachment.target.latitude,
        longitude: attachment1.extensible_attachment.story_attachment.target.longitude,
        image: attachment1.extensible_attachment.story_attachment.url,
        address: attachment1.extensible_attachment.story_attachment.target.address,
        sourceUrl: attachment1.extensible_attachment.story_attachment.url,
        description: attachment1.extensible_attachment.story_attachment.description,
        is_sponsored: attachment1.extensible_attachment.story_attachment.is_sponsored,
        title: attachment1.extensible_attachment.story_attachment.title,
        properties: attachment1.extensible_attachment.story_attachment.properties,
      };
    case "ExtensibleAttachment":
      return {
        type: "ExtensibleAttachment",
        ID: attachment1.extensible_attachment.legacy_attachment_id,
        url: attachment1.extensible_attachment.story_attachment.url,
        title: attachment1.extensible_attachment.story_attachment.title,
        description: attachment1.extensible_attachment.story_attachment.description,
        source: attachment1.extensible_attachment.story_attachment.source,
        image: attachment1.extensible_attachment.story_attachment.media.image,
        width: attachment1.extensible_attachment.story_attachment.media.image_size.width,
        height: attachment1.extensible_attachment.story_attachment.media.image_size.height,
        playable: attachment1.extensible_attachment.story_attachment.media.playable,
        duration: attachment1.extensible_attachment.story_attachment.media.duration,
        properties: attachment1.extensible_attachment.story_attachment.properties,
      };
    case "Audio":
      return {
        type: "Audio",
        ID: attachment1.metadata.fbid.toString(),
        filename: attachment1.name,
        fullFileName: fullFileName,
        original_extension: getExtension(attachment1.original_extension, fullFileName),
        mimeType: mimeType,
        duration: durationAudio,
        url: attachment1.url,
        is_playable: attachment1.is_playable,
        title: attachment1.title,
        thumbnailUrl: attachment1.thumbnailUrl,
      };
    default:
      return {
        type: "unsupported",
        ID: attachment1.id,
        url: attachment1.url,
        rawAttachment: attachment1,
      };
  }
}

export function getAppState(jar: CookieJar): any[] {
  return jar.getCookies("https://www.facebook.com").map((c) => ({
    key: c.key,
    value: c.value,
    domain: c.domain,
    path: c.path,
    expires: c.expires.getTime(),
    secure: c.secure,
    httpOnly: c.httpOnly,
    hostOnly: c.hostOnly,
    creation: c.creation.getTime(),
    lastAccessed: c.lastAccessed.getTime(),
  }));
}

export function getFrom(html: string, start: string, end: string): string | null {
  if (html.indexOf(start) < 0) return null;
  const data = html.split(start)[1].split(end)[0];
  return data;
}

export function makeDefaults(html: string, userID: string, ctx: Context) {
  const reqCounter = 1;
  const _defaultFuncs = {
    get: (url: string, jar: CookieJar, qs: any, options?: Options, customHeader?: CustomHeader) => get(url, jar, qs, options, ctx, customHeader),
    post: (url: string, jar: CookieJar, form: any, options?: Options, customHeader?: CustomHeader) => post(url, jar, form, options, ctx, customHeader),
    postFormData: (url: string, jar: CookieJar, form: any, qs?: any, options?: Options) => postFormData(url, jar, form, qs, options, ctx),
    // ... other functions that use ctx
  };
  return _defaultFuncs;
}

export function saveCookies(jar: CookieJar) {
  return (res: any) => {
    const cookies = res.headers["set-cookie"];
    if (cookies) {
      cookies.forEach((cookie: string) => {
        jar.setCookie(cookie, res.request.uri.href);
      });
    }
    return res;
  };
}

export function getType(obj: any): string {
  return Object.prototype.toString.call(obj).slice(8, -1);
}

export function getJar(): CookieJar {
  return new CookieJar();
}


