
const { readdirSync, writeFileSync } = require("fs-extra");
const { join, resolve } = require("path");
const logger = require("./FB-API/logger.js");
const login = require("./FB-API/API/index.js");
global.urls = {
  gai: require(process.cwd() + "/db/data/vdgai.json"),
  cosplay: require(process.cwd() + "/db/data/vdcosplay.json"),
};
global.zuckbot = {
  commands: new Map(),
  events: new Map(),
  cd: new Map(),
  eventRegistered: [],
  onReaction: [],
  onReply: [],
  mainPath: process.cwd(),
  configPath: ""
};
global.db = {
  threadInfo: new Map(),
  threadData: new Map(),
  userName: new Map(),
  allUserID: [],
  allCurrenciesID: [],
  allThreadID: []
};
//require("./a.js")
global.utils = require("./utils.js");
global.api = require("./FB-API/api.js");
global.loading = require("./FB-API/logger.js");
global.settings = {};
global.moduleData = [];
global.account = {};
global.queues = [];
global.games = {}
global.zuckbot.configPath = join(global.zuckbot.mainPath, "settings.json");
global.settings = require(process.cwd() + "/settings.json");
global.uploadMode = global.settings.uploadMode || "all";
const { getStreamFromURL } = global.utils;
const { sequelize } = require("./db/index.js");
const database = (input) => {
  const force = false;
  const Users = require("./db/models/users.js")(input);
  const Threads = require("./db/models/threads.js")(input);
  const Currencies = require("./db/models/currencies.js")(input);
  Users.sync({ force });
  Threads.sync({ force });
  Currencies.sync({ force });
  return {
    model: { Users, Threads, Currencies },
    use(modelName) {
      return this.model[modelName];
    },
  };
};
const appStateFile = resolve(join(global.zuckbot.mainPath, "appstate.json"));
const appState = require(appStateFile);
async function onBot({ models }) {
  let status = false;
  async function upload(api, url, retryCount = 3) {
    try {
      const stream = await getStreamFromURL(url);
      const response = await api.postFormData('https://upload.facebook.com/ajax/mercury/upload.php', { upload_1024: stream });
      const result = JSON.parse(response.body.replace('for (;;);', ''));
      const metadata = result.payload?.metadata?.[0];
      return metadata ? Object.entries(metadata)[0] : null;
    } catch (error) {
      if (retryCount > 0) {
        console.error(`Failed to upload ${url}, retrying... (${3 - retryCount + 1})`);
        return upload(api, url, retryCount - 1);
      } else {
        console.error(`Failed to upload ${url} after multiple attempts:`, error);
        return null;
      }
    }
  }
  function getUploadURL() {
    const mode = global.uploadMode;
    if (mode === "off") return null;
    if (mode === "gai") return global.urls.gai[Math.floor(Math.random() * global.urls.gai.length)];
    if (mode === "cosplay") return global.urls.cosplay[Math.floor(Math.random() * global.urls.cosplay.length)];
    const source = Math.random() < 0.5 ? global.urls.gai : global.urls.cosplay;
    return source[Math.floor(Math.random() * source.length)];
  }
  function startUploadProcess(api) {
    if (!global.zuckbot.xx) {
      global.zuckbot.xx = setInterval(async () => {
        if (status || global.queues.length >= 20) return;
        status = true;
        try {
          const numUploads = 20 - global.queues.length;
          const uploadPromises = Array.from({ length: numUploads }, () => {
            const url = getUploadURL();
            return url ? upload(api, url) : null;
          });
          const res = await Promise.all(uploadPromises);
          global.queues.push(...res.filter(Boolean));
        } catch (error) {
          console.error("Error during upload process:", error);
        } finally {
          status = false;
        }
      }, 5000);
    }
  }
  let account;

  if (fs.existsSync('./appstate.json')) {
    account = JSON.parse(fs.readFileSync('./appstate.json', 'utf8'));
    logger.loader(global.getText('mirai', 'foundPathAppstate'));
  } else if (fs.existsSync('./cookie.txt')) {
    account = fs.readFileSync('./cookie.txt', 'utf8').trim();
    logger.loader(global.getText('mirai', 'foundPathCookie'));
  } else {
    return logger.loader(global.getText("mirai", "notFoundPathCookie"), "error");
  }

  const api = await new Promise((resolve, reject) => {
    login(account, (err, api) => {
      if (err) return reject(err);
      resolve(api);
    });
  });
  global.account.cookie = api.getAppState().map(i => `${i.key}=${i.value}`).join(";");
  global.zuckbot.api = api;
  global.settings.version = '1.0.0';
  global.zuckbot.timeStart = Date.now();
  const listCommand = readdirSync(join(global.zuckbot.mainPath, 'cmds'))
    .filter(command => command.endsWith('.js') && !command.includes('example'));
  for (const command of listCommand) {
    const module = require(join(global.zuckbot.mainPath, 'cmds', command));
    if (!module.zuckbotconfig || !module.onRun || !module.zuckbotconfig.Category) {
      throw new Error(`Module không đúng định dạng: ${command}`);
    }
    if (global.zuckbot.commands.has(module.zuckbotconfig.name)) {
      throw new Error(`Tên module bị trùng: ${module.zuckbotconfig.name}`);
    }
    if (module.onLoad) {
      try {
        module.onLoad({ api, models });
      } catch (error) {
        throw new Error(`Không thể khởi chạy setup của module ${module.zuckbotconfig.name}: ${error.message}`);
      }
    }
    if (module.onEvent) global.zuckbot.eventRegistered.push(module.zuckbotconfig.name);
    global.zuckbot.commands.set(module.zuckbotconfig.name, module);
  }
  startUploadProcess(api);
  const Action = require("./bot/handler/Action.js")({ api, models });
  function handleMqttEvents(error, message) {
    if (error) {
      
      return logger('Lỗi khi lắng nghe sự kiện: ' + JSON.stringify(error), 'error');

    } else if (JSON.stringify(error).includes('Not logged in')) {
      console.log("Bot bị đăng xuất, đang khởi động lại...");
      process.exit(1); // để cho PM2 tự khởi động lại
    } else if (JSON.stringify(error).includes('ECONNRESET')) {
      api.stopListenMqtt();
      api.listenMqtt(handleMqttEvents);
    }
    if (message && !['presence', 'typ', 'read_receipt'].includes(message.type)) {
      Action(message);
    }
  }
  setInterval(() => {
    api.stopListenMqtt();
    api.listenMqtt(handleMqttEvents);
    console.log("suusss")
  }, 1000 * 60 * 30)
  api.listenMqtt(handleMqttEvents);
}
(async () => {
  try {
    const { Sequelize } = require("sequelize");
    await sequelize.authenticate();
    const authentication = {};
    authentication.Sequelize = Sequelize;
    authentication.sequelize = sequelize;
    const models = database(authentication);
    logger(`Kết nối đến cơ sở dữ liệu thành công`, "");
    const botData = {};
    botData.models = models;
    logger.autoLogin(onBot, botData);
  } catch (error) {
    logger(`Kết nối đến cơ sở dữ liệu thất bại, lỗi: ${JSON.stringify(error)}`, '[ DATABASE ]');
  }
})();