module.exports.zuckbotconfig = {
    name: "load",
    version: '2.3.1.2',
    author: "Nguyễn Thanh Tuấn",
    role: 2,
    info: "Load lệnh giống cmd nhưng nhanh hơn",
    Category: "Admin",
    cd: 0,
    aliases: ["tai"],
    shadowPrefix: false,
    image: []
};
const loadCommand = function ({box, moduleList, threadID, messageID }) {

    const { configPath } = global.zuckbot;
    const logger = global.loading

    var errorList = [];
    delete require.resolve[require.resolve(configPath)];
    var configValue = require(configPath);
    for (const nameModule of moduleList) {
        try {
            const dirModule = __dirname + '/' + nameModule + '.js';
            delete require.cache[require.resolve(dirModule)];
            const command = require(dirModule);
            global.zuckbot.commands.delete(nameModule);
            if (!command.zuckbotconfig || !command.onRun || !command.zuckbotconfig.Category)
                throw new Error('Module không đúng định dạng!');
            global.zuckbot.eventRegistered = global.zuckbot.eventRegistered.filter(info => info != command.zuckbotconfig.name);
            if (command.onLoad) try {
                const onLoads = {};
                onLoads.configValue = configValue;
                command.onLoad(onLoads);
            } catch (error) {
                throw new Error('⚠️ Không thể onload module, lỗi: ' + JSON.stringify(error), 'error');
            }
            if (command.onEvent) global.zuckbot.eventRegistered.push(command.zuckbotconfig.name);
            global.zuckbot.commands.set(command.zuckbotconfig.name, command)
            logger.loader('Loaded command ' + command.zuckbotconfig.name + '!');
        } catch (error) {
            errorList.push('- ' + nameModule + ' reason:' + error + ' at ' + error['stack']);
        };
    }
    if (errorList.length != 0) box.send('⚠️ Những lệnh vừa xảy ra sự cố khi hệ thống loading: ' + errorList.join(' '));
    if (moduleList.length - errorList.length == 1) return box.send("✅")
    if (moduleList.length - errorList.length == 0) return box.send("❎")
    api.sendMessage((moduleList.length - errorList.length) + " ✅", threadID, messageID)
    return;
};
module.exports.onRun = async function ({ box, api, event, args }) {
    const { threadID, messageID } = event;

    var moduleList = args.splice(0, args.length);
    if (moduleList.length === 0) return box.send("⚠️", event.messageID, event.threadID)
    else return loadCommand({ box,moduleList, threadID, messageID });
}