const cron = require('node-cron');
const fs = require('fs');
const moment = require('moment-timezone');
const path = require('path');
module.exports = function ({ api, Threads }) {
  cron.schedule('0 */3 * * *', async () => {
    const dataPath = path.join(process.cwd(), 'db', 'databot', 'check_data.json');
    const currentTime = moment().tz('Asia/Ho_Chi_Minh').format('YYYY-MM-DD HH:mm:ss');
    let lastRunTime = null;
    if (fs.existsSync(dataPath)) {
      try {
        const data = JSON.parse(fs.readFileSync(dataPath, 'utf-8'));
        lastRunTime = data.datetime;
      } catch (error) {
        console.error('Lỗi đọc tệp JSON:', error.message);
      }
    }
    if (!lastRunTime || moment(currentTime).diff(moment(lastRunTime), 'minutes') >= 10) {
      try {
        const groupList = (await api.getThreadList(100, null, ['INBOX']))
          .filter(group => group.isSubscribed && group.isGroup);
        for (const { threadID } of groupList) {
          const threadInfo = await api.getThreadInfo(threadID);
          await Threads.setData(threadID, { threadInfo });
        }
        fs.writeFileSync(dataPath, JSON.stringify({ datetime: currentTime }), 'utf-8');
        console.log(`Tự động cập nhật dữ liệu của ${groupList.length} box vào ${currentTime}`);
      } catch (error) {
        console.error('Lỗi trong quá trình cập nhật dữ liệu:', error.message);
      }
    }
  });
};
