module.exports = function ({ api, models, Users, Threads, Currencies }) {
  const logger = global.loading;
  return function ({ event }) {
    const { commands, eventRegistered } = global.zuckbot;
    const { senderID, threadID, messageID } = event;
    const box = {
                react: (emoji) => api.setMessageReactionMqtt(emoji, messageID, threadID),
                reply: (msg) => api.sendMessage(msg, threadID, messageID),
                add: (uid) => api.addUserToGroup(uid, threadID),
                kick: (uid) => api.removeUserFromGroup(uid, threadID),
                send: (msg, id) => api.sendMessage(msg, id || threadID),
            };
    const send = (msg, callback) => new Promise(r =>
      api.sendMessage(msg, threadID, (err, res) => {
        if (callback) callback(err, res);
        r(res || err);
      },
        messageID
      )
    );
    if ((senderID === threadID))
      return;

    for (const eventReg of eventRegistered) {
      try {
        if (commands.get(eventReg)) commands.get(eventReg).onEvent({ send, event, api, models, Users, Threads, Currencies ,box });
      } catch (error) {
        logger(
          `Đã xảy ra lỗi không mong muốn tại lệnh ${cmd.zuckbotconfig.name}, lỗi: ${error}`,
          "error",
        );
      }
    }
  };
};