const log = require('npmlog');
const utils = require('../../../helpers');

module.exports = (def, api, ctx, delta, globalCallback) => {
    if (!delta?.threadKey || !delta.messageId || !delta.threadKey.threadFbId) return;
    const mid = delta.messageId;
    const tid = delta.threadKey.threadFbId;
    const headers = {
        'Content-Type': 'application/x-www-form-urlencoded',
        'Origin': 'https://www.facebook.com',
        'Referer': 'https://www.facebook.com/',
        'User-Agent': ctx.globalOptions.userAgent,
        'Sec-Fetch-Site': 'same-origin',
        'Sec-Fetch-Mode': 'cors'
    };

    const form = {
        av: ctx.globalOptions.pageID,
        queries: JSON.stringify({
            o0: {
                doc_id: "2848441488556444",
                query_params: { thread_and_message_id: { thread_id: tid.toString(), message_id: mid } }
            }
        })
    };

    def.post("https://www.facebook.com/api/graphqlbatch/", ctx.jar, form, headers)
        .then(utils.parseAndCheckLogin(ctx, def))
        .then(res => {
            const last = res[res.length - 1];
            if (last.error_results > 0) throw res[0]?.o0?.errors;
            if (last.successful_results === 0) throw { error: "forcedFetch: no successful_results", res };

            const data = res[0]?.o0?.data?.message;
            if (utils.getType(data) !== "Object") return log.error("forcedFetch", data);
            if (data.__typename !== "ThreadImageMessage") return log.warn("forcedFetch: unknown typename", data.__typename);

            globalCallback(null, {
                type: "event",
                threadID: utils.formatID(tid.toString()),
                messageID: data.message_id,
                logMessageType: "log:thread-image",
                logMessageData: {
                    attachmentID: data.image_with_metadata?.legacy_attachment_id,
                    width: data.image_with_metadata?.original_dimensions?.x,
                    height: data.image_with_metadata?.original_dimensions?.y,
                    url: data.image_with_metadata?.preview?.uri
                },
                logMessageBody: data.snippet,
                timestamp: data.timestamp_precise,
                author: data.message_sender?.id
            });
        })
        .catch(err => log.error("forcedFetch error", err));
};