const log = require('npmlog');
const utils = require('../../../helpers');

module.exports = (def, api, ctx, delta, globalCallback) => {
    try {
        const threadID = utils.formatID(
            delta.threadKey?.threadFbId || delta.messageMetadata?.threadKey?.threadFbId
        );

        const author = delta.messageMetadata?.actorFbId?.toString() || null;

        globalCallback(null, {
            type: 'event',
            threadID,
            messageID: delta.messageMetadata?.messageId,
            logMessageType: 'log:subscribe',
            logMessageBody: delta.messageMetadata?.adminText || '',
            timestamp: delta.messageMetadata?.timestamp,
            author,
            participants: delta.participants
        });
    } catch (err) {
        log.error('parseSubscribe error', err);
    }
};
