const utils = require('../../../helpers');
const log = require('npmlog');

module.exports = (def, api, ctx, delta, callback) => {
  try {
    const threadID = utils.formatID(
      delta.messageMetadata?.threadKey?.threadFbId || delta.messageMetadata?.threadKey?.otherUserFbId || ''
    );

    const eventData = {
      type: 'event',
      threadID,
      logMessageType: 'log:approval-queue',
      logMessageData: {
        action: delta.action,
        recipientFbId: delta.recipientFbId,
        inviterFbId: delta.inviterFbId || null,
        requestSource: delta.requestSource || null,
        requestTimestamp: delta.requestTimestamp || null
      },
      logMessageBody: delta.messageMetadata?.adminText || '',
      author: delta.messageMetadata?.actorFbId?.toString() || null,
      timestamp: delta.messageMetadata?.timestamp || Date.now().toString()
    };

    callback(null, eventData);
  } catch (err) {
    log.error('approvalQueue', err);
    callback(err);
  }
};
