const utils = require('../../../helpers');

module.exports = (_def, _api, _ctx, delta, callback) => {
    const handledTypes = new Set([
        "change_thread_theme",
        "change_thread_nickname",
        "change_thread_icon",
        "change_thread_quick_reaction",
        "change_thread_admins",
        "group_poll",
        "joinable_group_link_mode_change",
        "magic_words",
        "change_thread_approval_mode",
        "messenger_call_log",
        "participant_joined_group_call",
        "joinable_group_link_reset"
    ]);

    try {
        if ((delta.class === "AdminTextMessage" && handledTypes.has(delta.type)) || (delta.class === "JoinableMode" && !!delta.link)) {
            try {
                const fmtMsg = utils.formatDeltaEvent(delta);
                return callback(null, fmtMsg);
            } catch (err) {
                return callback({
                    error: "Problem parsing message object.",
                    detail: err,
                    res: delta,
                    type: "parse_error"
                });
            }
        }
    } catch (err) {
        console.error('Error in activities.js:', err);
        return callback(err);
    }
};
