SELECT movies.movie_title FROM movies WHERE movie_release_year = 1945 ORDER BY movie_popularity DESC; 
SELECT MAX(movies.movie_popularity) AS most_popular_movie_popularity, movies.movie_title AS most_popular_movie_title, movies.movie_release_year AS most_popular_movie_release_year, movies.director_name AS most_popular_movie_director FROM movies INNER JOIN ratings ON movies.movie_id = ratings.movie_id GROUP BY movies.movie_id ORDER BY most_popular_movie_popularity DESC LIMIT 1;
SELECT MAX(movie_title) AS longest_movie_title, movie_release_year AS release_year FROM movies WHERE LENGTH(movie_title) = (SELECT MAX(LENGTH(movie_title)) FROM movies);
SELECT movies.movie_title FROM     movies JOIN     ratings ON     movies.movie_id = ratings.movie_id GROUP BY     movies.movie_title ORDER BY     SUM(ratings.rating_score) DESC LIMIT 1;
SELECT AVG(movie_popularity) FROM     movies JOIN     directors ON movies.director_id = directors.director_id WHERE     director_name = 'Stanley Kubrick';
SELECT AVG(rating_score) AS average_rating FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id WHERE movie_title = 'When Will I Be Loved';
SELECT lists_users.user_avatar_image_url FROM lists_users WHERE lists_users.user_id = 41579158 ORDER BY ratings.rating_date_utc DESC LIMIT 1;
SELECT (SELECT (COUNT(DISTINCT ratings.rating_id) * 100.0) / (SELECT COUNT(*) FROM ratings)  FROM ratings JOIN ratings_users ON ratings.user_id = ratings_users.user_id WHERE ratings_users.user_subscriber = 1) as percent; 
SELECT movies.movie_title FROM movies JOIN ratings ON movies.movie_id = ratings.movie_id JOIN ratings_users ON ratings.user_id = ratings_users.user_id WHERE ratings.rating_timestamp_utc LIKE '%2020-04-%' AND ratings_users.user_trialist = 1;
SELECT users.user_id FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id JOIN lists ON ratings.user_id = lists.user_id JOIN lists_users ON lists_users.user_id = lists.user_id JOIN users ON users.user_id = lists_users.user_id WHERE movies.movie_title = 'Love Will Tear Us Apart' AND ratings.rating_score = 1;
SELECT movies.movie_title, COUNT(ratings.user_id) AS mubi_user_loves FROM movies JOIN ratings ON movies.movie_id = ratings.movie_id WHERE ratings.rating_score = 5 GROUP BY movies.movie_title ORDER BY mubi_user_loves DESC; 
SELECT movies.movie_title FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id WHERE ratings.rating_timestamp_utc LIKE '%2020%' AND ratings.rating_score >= 4;
SELECT movies.movie_title, ratings_users.user_id, ratings.rating_score, ratings.critic_comments FROM movies JOIN ratings ON movies.movie_id = ratings.movie_id JOIN ratings_users ON ratings.user_id = ratings_users.user_id WHERE ratings.critic IS NOT NULL;
SELECT 100 * SUM(CASE WHEN ratings.rating_score = 5 THEN 1 ELSE 0 END) / COUNT(ratings.rating_id) AS highest_score_percentage FROM     ratings JOIN     movies ON ratings.movie_id = movies.movie_id WHERE     movies.movie_title = 'Welcome to the Dollhouse';
SELECT ROUND((COUNT(DISTINCT ratings.movie_id) * 100.0) / (SELECT COUNT(*) FROM ratings), 2) AS percent FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id WHERE movies.movie_release_year = 2021;
SELECT director_name FROM movies WHERE movie_title = 'Sex, Drink and Bloodshed';
SELECT MAX(list_title) FROM lists WHERE list_followers = (     SELECT MAX(list_followers)     FROM lists );
SELECT lists.list_url FROM lists JOIN lists_users ON lists.list_id = lists_users.list_id WHERE lists.list_followers BETWEEN 1 AND 2 AND lists.list_update_timestamp_utc BETWEEN '2012-01-01' AND '2012-12-31';
SELECT lists.list_id FROM lists JOIN lists_users ON lists.list_id = lists_users.list_id WHERE lists_users.user_id = 85981819 ORDER BY lists.list_creation_timestamp_utc LIMIT 1;
SELECT COUNT(DISTINCT ratings.user_id) FROM     ratings JOIN     movies ON ratings.movie_id = movies.movie_id JOIN     ratings_users ON ratings.user_id = ratings_users.user_id JOIN     lists_users ON ratings.user_id = lists_users.user_id WHERE     ratings.movie_id = 1269     AND ratings.rating_score <= 2     AND ratings_users.user_has_payment_method = 1     AND ratings_users.user_eligible_for_trial = 1;
SELECT movies.movie_title, movies.movie_popularity FROM movies JOIN directors ON movies.director_id = directors.director_id WHERE movies.movie_release_year = 2021 AND directors.director_name = 'Steven Spielberg';
SELECT MIN(movie_release_year) AS first_movie_release_year, director_name AS first_movie_director FROM movies JOIN (     SELECT movie_id, director_name     FROM movies     WHERE movie_release_year = (         SELECT MIN(movie_release_year)         FROM movies     ) ) AS first_movie_info ON movies.movie_id = first_movie_info.movie_id;
SELECT DISTINCT lists_users.user_id FROM     lists_users JOIN     lists ON lists_users.list_id = lists.list_id WHERE     lists_users.user_subscriber = 1 GROUP BY     lists_users.user_id HAVING     COUNT(DISTINCT strftime('%Y', list_creation_timestamp_utc)) >= 10;
SELECT COUNT(DISTINCT ratings.user_id) AS rating_count FROM     ratings JOIN     movies ON ratings.movie_id = movies.movie_id WHERE     movies.movie_title = "Pavee Lackeen: The Traveller Girl" AND     ratings.rating_score = 4;
SELECT  lists.list_followers, lists_users.user_eligible_for_trial FROM lists JOIN lists_users ON lists.list_id = lists_users.list_id JOIN ratings_users ON lists_users.user_id = ratings_users.user_id WHERE lists.list_title = "World War 2 and Kids"; 
SELECT ratings.user_id FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id JOIN (     SELECT    movie_id,     movie_release_year,     ROW_NUMBER() OVER (PARTITION BY director_name ORDER BY movie_release_year) AS rn     FROM     movies     WHERE     director_name = 'Quentin Tarantino' ) AS tarantino_movies ON movies.movie_id = tarantino_movies.movie_id WHERE tarantino_movies.rn = 3 AND ratings.rating_score = 4;
SELECT movies.director_url FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id WHERE ratings.user_id = 2452551 AND ratings.critic_likes = 39;
SELECT AVG(rating_score) AS average_rating_score, director_name FROM movies JOIN ratings ON movies.movie_id = ratings.movie_id JOIN lists ON ratings.movie_id = lists.movie_id JOIN lists_users ON lists.list_id = lists_users.list_id JOIN ratings_users ON ratings_users.user_id = lists_users.user_id JOIN directors ON movies.director_id = directors.director_id WHERE movie_title = "When Will I Be Loved";
SELECT COUNT(movies.movie_id) AS number_of_movies_added, CASE      WHEN lists_users.user_has_payment_method = 1 THEN 'Paying Subscriber'     WHEN lists_users.user_has_payment_method = 0 THEN 'Non-Paying Subscriber' END AS subscriber_status FROM lists JOIN lists_users ON lists.list_id = lists_users.list_id JOIN movies ON lists.list_id = movies.movie_id WHERE lists.list_movie_number = (SELECT MAX(list_movie_number) FROM lists) GROUP BY lists_users.user_id, lists_users.user_has_payment_method;
SELECT movies.movie_title FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id WHERE ratings.critic_likes = (     SELECT MAX(critic_likes)     FROM ratings )
SELECT MAX(movie_popularity) AS highest_popularity, MIN(rating_timestamp_utc) AS first_rating_timestamp_utc FROM movies JOIN ratings ON movies.movie_id = ratings.movie_id JOIN ratings_users ON ratings.user_id = ratings_users.user_id WHERE movie_release_year BETWEEN 1920 AND 1929 AND rating_score = 1 AND user_has_payment_method = 1;
SELECT COUNT(movies.movie_id) AS number_of_movies, MAX(ratings.critic_likes) AS max_critic_likes FROM movies JOIN ratings ON movies.movie_id = ratings.movie_id JOIN directors ON movies.director_id = directors.director_id WHERE directors.director_name = 'Francis Ford Coppola' AND movies.movie_popularity > 1000;
SELECT lists_users.user_avatar_image_url FROM ratings JOIN ratings_users ON ratings.user_id = ratings_users.user_id JOIN movies ON ratings.movie_id = movies.movie_id JOIN lists ON lists.list_id = lists_users.list_id JOIN lists_users ON lists_users.user_id = ratings_users.user_id AND lists_users.list_id = lists.list_id WHERE ratings.movie_id = 1103 AND ratings.rating_score = 5 AND ratings.rating_date_utc = '2020-04-19';
SELECT MAX(list_followers) AS highest_followers_count, CASE WHEN user_subscriber = 1 THEN 'Subscriber' ELSE 'Non-Subscriber' END AS user_subscription_status FROM lists JOIN lists_users ON lists.user_id = lists_users.user_id WHERE lists.user_id = 4208563 GROUP BY lists.list_id ORDER BY highest_followers_count DESC LIMIT 1;
SELECT MIN(movie_release_year) AS least_movies_year, (SELECT movie_title  FROM movies  JOIN ratings ON movies.movie_id = ratings.movie_id  WHERE movie_release_year = (SELECT MIN(movie_release_year) FROM movies)  GROUP BY movie_title  HAVING MAX(SUM(CASE WHEN rating_score = '1' THEN 1 ELSE 0 END))  ORDER BY MAX(SUM(CASE WHEN rating_score = '1' THEN 1 ELSE 0 END)) DESC  LIMIT 1) AS highest_rating_movie_title;
SELECT COUNT(DISTINCT ratings_users.user_id) AS user_count FROM ratings_users JOIN ratings ON ratings_users.user_id = ratings.user_id JOIN movies ON ratings.movie_id = movies.movie_id JOIN lists ON ratings.movie_id = lists.list_movie_number JOIN lists_users ON lists.list_id = lists_users.list_id WHERE ratings.rating_score = 5 AND movies.movie_release_year = 1924 AND movies.director_name = 'Erich von Stroheim' AND ratings_users.user_subscriber = 1
SELECT AVG(list_movie_number) AS average_movies_added, (SELECT user_avatar_image_url FROM lists_users WHERE user_id = 8516503) AS user_profile_image_url FROM lists JOIN lists_users ON lists.user_id = lists_users.user_id WHERE lists_users.user_id = 8516503;
SELECT COUNT(DISTINCT ratings_users.user_id), ratings.rating_url FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id JOIN ratings_users ON ratings.user_id = ratings_users.user_id WHERE movies.movie_title = 'The Magnificent Ambersons' AND ratings.rating_score <= 2;
SELECT COUNT(DISTINCT lists_users.user_id) AS eligible_users_count FROM     lists_users JOIN     lists ON lists_users.list_id = lists.list_id WHERE     lists.list_creation_date_utc BETWEEN '2016-02-01' AND '2016-02-29' AND     lists_users.user_eligible_for_trial = 1;
SELECT ratings.rating_url FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id JOIN (     SELECT        ratings.movie_id,         MAX(ratings.rating_score) AS max_rating_score     FROM         ratings     JOIN lists_users ON ratings.user_id = lists_users.user_id     WHERE         lists_users.user_id = 22030372     GROUP BY         ratings.movie_id ) AS max_ratings ON ratings.movie_id = max_ratings.movie_id AND ratings.rating_score = max_ratings.max_rating_score WHERE     movies.movie_title = 'Riff-Raff';
SELECT COUNT(DISTINCT director_id) AS director_count, director_name, movie_title FROM directors JOIN movies ON directors.director_id = movies.director_id JOIN ratings ON movies.movie_id = ratings.movie_id WHERE movie_release_year BETWEEN 1960 AND 1985 GROUP BY director_id HAVING COUNT(DISTINCT movie_id) >= 10 AND MAX(rating_score) = 5;
SELECT COUNT(DISTINCT ratings_users.user_id) AS num_users FROM ratings JOIN ratings_users ON ratings.user_id = ratings_users.user_id JOIN movies ON ratings.movie_id = movies.movie_id WHERE movies.movie_title = "The South" AND ratings.rating_score <= 2 AND ratings_users.user_trialist = 0;
SELECT SUM(r.critic_likes) AS likes_received FROM     ratings r JOIN     movies m ON r.movie_id = m.movie_id WHERE     m.movie_title = 'Apocalypse Now'     AND r.rating_score = '5';
SELECT AVG(rating_score), director_name FROM movies JOIN ratings ON movies.movie_id = ratings.movie_id WHERE movie_title = "The Crowd";
SELECT MIN(movies.movie_release_year) AS first_movie_release_year, (SELECT user_id  FROM     (SELECT user_id, COUNT(critic_comments) AS comment_count      FROM ratings      WHERE critic = 1      GROUP BY user_id      ORDER BY comment_count DESC      LIMIT 1) ) AS user_id_with_most_comments FROM movies JOIN (SELECT director_id, COUNT(movie_id) AS movie_count       FROM movies       GROUP BY director_id       ORDER BY movie_count DESC       LIMIT 1) AS top_director ON movies.director_id = top_director.director_id;
SELECT movies.movie_title, MAX(ratings.rating_score) AS highest_rating_score FROM movies JOIN ratings ON movies.movie_id = ratings.movie_id WHERE movies.movie_popularity BETWEEN 400 AND 500 GROUP BY movies.movie_title;
SELECT ratings.rating_url FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id WHERE ratings.user_id = '45579900' AND movies.movie_title = 'The Vertical Ray of the Sun' AND ratings.critic_likes = '20';
SELECT movies.movie_id, movies.movie_title, AVG(movies.movie_popularity) AS average_popularity FROM movies JOIN ratings ON movies.movie_id = ratings.movie_id JOIN lists ON lists.list_id = lists_users.list_id JOIN lists_users ON lists_users.user_id = ratings.user_id JOIN directors ON directors.director_id = movies.director_id WHERE directors.director_name = 'Christopher Nolan' GROUP BY movies.movie_id ORDER BY average_popularity DESC LIMIT 1;
SELECT movies.movie_title FROM     movies JOIN     ratings ON movies.movie_id = ratings.movie_id JOIN     lists_users ON ratings.user_id = lists_users.user_id JOIN     lists ON lists_users.list_id = lists.list_id WHERE     lists.list_title = '100 Greatest Living American Filmmakers' AND     ratings.rating_timestamp_utc BETWEEN '2013-01-01' AND '2013-12-31' GROUP BY     movies.movie_title HAVING     AVG(ratings.rating_score) 
SELECT AVG(rating_score) AS average_rating_score, movie_release_year AS release_year FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id WHERE movie_title = 'Pavee Lackeen: The Traveller Girl';
SELECT COUNT(DISTINCT lists.list_id) AS updated_lists_count FROM lists JOIN lists_users ON lists.list_id = lists_users.list_id WHERE (lists.list_update_timestamp_utc > (lists.list_creation_timestamp_utc + 10 * 365 * 24 * 60 * 60));
SELECT list_description FROM lists WHERE list_title = "Short and pretty damn sweet";
SELECT lists.list_url FROM lists WHERE lists.list_title = "Short and pretty damn sweet";
SELECT COUNT(DISTINCT lists.list_id) FROM     lists JOIN     lists_users ON lists.list_id = lists_users.list_id WHERE     lists.list_update_timestamp_utc > '2010-01-01' GROUP BY     lists.list_id HAVING     SUM(list_followers) > 200;
SELECT COUNT(lists.list_id) AS total_lists_created FROM     lists JOIN     lists_users ON lists_users.list_id = lists.list_id WHERE     lists_users.user_id = 83373278     AND lists_users.user_subscriber = 1;
SELECT movie_release_year FROM movies WHERE movie_title = 'La Antena';
SELECT movies.movie_url FROM movies WHERE movies.movie_title = 'La Antena';
SELECT movies.movie_title, MAX(movies.movie_popularity) AS popularity FROM movies WHERE movies.movie_title IN ('The General', 'Il grido') GROUP BY movies.movie_title;
SELECT COUNT(DISTINCT movies.movie_id)  FROM      movies  JOIN      directors ON movies.director_id = directors.director_id  WHERE      directors.director_name = 'Hong Sang-soo';
SELECT CASE      WHEN lists.list_title = "250 Favourite Films" AND lists_users.user_trialist = 1 THEN "Yes"     ELSE "No" END AS trialist_when_created FROM lists JOIN lists_users ON lists.list_id = lists_users.list_id WHERE lists.list_title = "250 Favourite Films";
SELECT lists.list_title FROM lists JOIN lists_users ON lists.list_id = lists_users.list_id WHERE lists_users.user_id = 32172230 AND lists_users.user_eligible_for_trial = 1; 
SELECT COUNT(lists.list_id) AS number_of_lists FROM lists JOIN lists_users ON lists.list_id = lists_users.list_id WHERE lists.list_movie_number > 100 AND lists_users.user_id = 85981819 AND lists_users.user_has_payment_method = 1;
SELECT lists.list_description FROM lists JOIN lists_users ON lists.list_id = lists_users.list_id WHERE lists_users.user_id = 85981819 ORDER BY lists.list_followers DESC LIMIT 1;
SELECT MAX(list_update_date_utc) AS last_update_date_utc FROM lists WHERE list_title = "250 Favourite Films";
SELECT lists_users.user_avatar_image_url FROM lists JOIN lists_users ON lists.list_id = lists_users.list_id WHERE lists.list_title = "250 Favourite Films" LIMIT 1;
SELECT COUNT(lists.list_id) AS num_more_lists_created FROM     lists JOIN     lists_users ON lists_users.list_id = lists.list_id JOIN     lists AS original_list ON original_list.user_id = lists_users.user_id WHERE     original_list.list_title = "250 Favourite Films"     AND lists.list_creation_timestamp_utc > original_list.list_creation_timestamp_utc     AND lists.user_id = original_list.user_id;
SELECT COUNT(DISTINCT ratings_users.user_id) FROM     ratings JOIN     movies ON ratings.movie_id = movies.movie_id JOIN     ratings_users ON ratings.user_id = ratings_users.user_id WHERE     movies.movie_title = "A Way of Life"     AND ratings.rating_score = 5;
SELECT critic FROM     ratings WHERE     movie_id = (         SELECT            movie_id         FROM             movies         WHERE             movie_title = "A Way of Life"     );
SELECT COUNT(DISTINCT critic) AS num_critics_with_more_than_one_like FROM     ratings JOIN     movies ON ratings.movie_id = movies.movie_id WHERE     movie_title = "Imitation of Life"     AND critic_likes > 1;
SELECT ratings.user_id FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id WHERE movies.movie_title = "When Will I Be Loved" AND ratings.critic_comments = 2;
SELECT ratings.rating_timestamp_utc FROM ratings JOIN ratings_users ON ratings.user_id = ratings_users.user_id JOIN movies ON ratings.movie_id = movies.movie_id WHERE ratings_users.user_id = 39115684 AND movies.movie_title = "A Way of Life" 
SELECT ratings.rating_url FROM ratings JOIN ratings_users ON ratings.user_id = ratings_users.user_id JOIN movies ON ratings.movie_id = movies.movie_id WHERE ratings_users.user_id = 39115684 AND movies.movie_title = 'When Will I Be Loved';
SELECT COUNT(*) FROM     ratings JOIN     movies ON ratings.movie_id = movies.movie_id JOIN     ratings_users ON ratings.user_id = ratings_users.user_id WHERE     ratings_users.user_id = 39115684     AND ratings.movie_id = (SELECT movie_id FROM movies WHERE movie_title = "A Way of Life")     AND ratings_users.user_trialist = 1;
SELECT COUNT(DISTINCT ratings_users.user_id) FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id JOIN ratings_users ON ratings.user_id = ratings_users.user_id WHERE movies.movie_title = "A Way of Life" AND ratings_users.user_trialist = 1;
SELECT ratings.rating_url FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id WHERE movies.movie_title = 'A Way of Life' AND ratings.critic IS NOT NULL;
SELECT COUNT(DISTINCT ratings_users.user_id) AS num_users_rated_most_popular_movie FROM ratings JOIN ratings_users ON ratings.user_id = ratings_users.user_id JOIN movies ON ratings.movie_id = movies.movie_id WHERE movies.movie_popularity = (SELECT MAX(movie_popularity) FROM movies);
SELECT     movies.movie_title FROM     ratings JOIN     movies ON ratings.movie_id = movies.movie_id WHERE     ratings.user_id = 58149469     AND ratings.critic_likes = 1     AND ratings.critic_comments = 2;
SELECT COUNT(ratings.rating_id) AS num_users_rated_one FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id JOIN ratings_users ON ratings.user_id = ratings_users.user_id WHERE movies.movie_title = "When Will I Be Loved" AND ratings.rating_score = 1 AND ratings_users.user_trialist = 1;
SELECT COUNT(ratings.rating_id) FROM     ratings JOIN     movies ON ratings.movie_id = movies.movie_id WHERE     movies.movie_title = 'A Way of Life'     AND ratings.rating_timestamp_utc > '2011';
SELECT ratings.rating_score FROM ratings JOIN lists ON ratings.user_id = lists.user_id JOIN lists_users ON lists.list_id = lists_users.list_id AND lists.user_id = lists_users.user_id JOIN movies ON ratings.movie_id = movies.movie_id WHERE movies.movie_title = "Innocence Unprotected" AND lists.list_title = "250 Favourite Films";
SELECT movies.movie_title FROM lists JOIN lists_users ON lists.list_id = lists_users.list_id JOIN ratings_users ON lists_users.user_id = ratings_users.user_id JOIN ratings ON ratings_users.user_id = ratings.user_id AND ratings.movie_id = movies.movie_id WHERE lists.list_title = '250 Favourite Films';
SELECT AVG(ratings.rating_score) FROM     ratings JOIN     movies ON ratings.movie_id = movies.movie_id WHERE     movies.movie_title = "A Way of Life";
SELECT (CAST((SELECT COUNT(rating_id) FROM ratings WHERE movie_id = (SELECT movie_id FROM movies WHERE movie_title = 'When Will I Be Loved') AND rating_score = 1) AS FLOAT) /  CAST((SELECT COUNT(rating_id) FROM ratings WHERE movie_id = (SELECT movie_id FROM movies WHERE movie_title = 'When Will I Be Loved')) AS FLOAT)) * 100 AS percentage_of_users_rated_1 
SELECT ROUND((SELECT AVG(rating_score) FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id WHERE movie_title = "Innocence Unprotected"), 2) - ROUND((SELECT AVG(rating_score) FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id WHERE movie_title = "When Will I Be Loved"), 2) AS rating_difference;
SELECT director_name FROM     movies JOIN     ratings ON movies.movie_id = ratings.movie_id WHERE     movie_title = "Tokyo Eyes";
SELECT COUNT(*) FROM     movies WHERE     movie_release_year = 2007;
SELECT movies.movie_title FROM movies JOIN ratings ON movies.movie_id = ratings.movie_id WHERE movies.movie_release_year = 2006 ORDER BY movies.movie_popularity DESC LIMIT 1;
SELECT COUNT(movies.movie_id) FROM     movies JOIN     directors ON movies.director_id = directors.director_id WHERE     directors.director_name = "Åke Sandgren";
SELECT movies.movie_title FROM movies JOIN directors ON movies.director_id = directors.director_id WHERE directors.director_name = 'Álex de la Iglesia' ORDER BY movies.movie_popularity DESC LIMIT 1;
SELECT movies.movie_release_year FROM movies WHERE movies.movie_title = 'Cops';
SELECT director_id FROM movies WHERE movie_title = "It's Winter";
SELECT MAX(list_followers) AS max_followers FROM lists;
SELECT MAX(list_comments) AS max_comments, list_title FROM lists GROUP BY list_title ORDER BY max_comments DESC LIMIT 1;
SELECT movies.movie_title FROM movies JOIN ratings ON movies.movie_id = ratings.movie_id WHERE movies.movie_release_year = 2008 ORDER BY ratings.rating_score DESC LIMIT 1;
SELECT movies.movie_title, MAX(ratings.critic_likes) AS top_likes FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id GROUP BY movies.movie_title ORDER BY top_likes DESC LIMIT 3;
SELECT COUNT(DISTINCT lists_users.user_id) AS users_with_more_than_100_followers FROM     lists_users JOIN     lists ON lists_users.list_id = lists.list_id WHERE     list_creation_date_utc = '2009' AND     list_followers > 100;
SELECT COUNT(DISTINCT ratings_users.user_id) FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id JOIN ratings_users ON ratings.user_id = ratings_users.user_id WHERE movies.movie_title = 'White Night Wedding' AND ratings.rating_score = 5;
SELECT lists.user_cover_image_url FROM lists JOIN lists_users ON lists.list_id = lists_users.list_id WHERE lists.list_title = 'Georgia related films' AND lists_users.list_creation_date_utc = (     SELECT MIN(list_creation_date_utc)     FROM lists     WHERE list_title = 'Georgia related films' );
SELECT COUNT(list_followers) FROM lists JOIN lists_users ON lists.list_id = lists_users.list_id WHERE lists_users.user_avatar_image_url = 'https://assets.mubicdn.net/images/avatars/74983/images-w150.jpg?1523895214';
SELECT movie_title FROM     movies JOIN     ratings ON movies.movie_id = ratings.movie_id WHERE     ratings.user_id = 94978     AND ratings.rating_score = 5;
SELECT movies.movie_title FROM movies JOIN ratings ON movies.movie_id = ratings.movie_id WHERE ratings.user_id = 2941 AND movies.movie_release_year = 2003;
SELECT COUNT(DISTINCT ratings.user_id) FROM     ratings JOIN     movies ON ratings.movie_id = movies.movie_id JOIN     lists ON ratings.user_id = lists.user_id JOIN     lists_users ON lists_users.user_id = lists.user_id AND lists_users.list_id = lists.list_id WHERE     movies.movie_title = 'Patti Smith: Dream of Life'     AND ratings.user_trialist = 0;
SELECT movies.movie_title FROM movies JOIN ratings ON movies.movie_id = ratings.movie_id GROUP BY movies.movie_id ORDER BY AVG(ratings.rating_score) DESC LIMIT 1; 
SELECT movies.movie_title FROM     movies JOIN     ratings ON movies.movie_id = ratings.movie_id WHERE     critic_comments IS NOT NULL ORDER BY     critic_comments DESC LIMIT     3; 
SELECT lists.list_title, lists.user_avatar_image_url FROM lists JOIN lists_users ON lists.list_id = lists_users.list_id WHERE lists_users.user_id = 85981819 ORDER BY lists.list_creation_timestamp_utc ASC LIMIT 1;
SELECT movie_title FROM     movies JOIN     ratings ON movies.movie_id = ratings.movie_id WHERE     rating_timestamp_utc LIKE '2020%' GROUP BY     movies.movie_id ORDER BY     COUNT(*) DESC LIMIT 1;
SELECT AVG(rating_score) FROM     ratings JOIN     movies ON ratings.movie_id = movies.movie_id WHERE     movie_title = 'Versailles Rive-Gauche';
SELECT movies.movie_title FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id WHERE ratings.user_id = 59988436 AND ratings.critic_comments = 21;
SELECT movies.movie_title FROM movies JOIN ratings ON movies.movie_id = ratings.movie_id WHERE ratings.critic_likes > 20; 
SELECT AVG(rating_score)  FROM ratings  JOIN movies ON ratings.movie_id = movies.movie_id  WHERE movie_title = "The Fall of Berlin" AND strftime('%Y', rating_timestamp_utc) = '2019';
SELECT ROUND((SELECT COUNT(DISTINCT user_id) FROM ratings WHERE movie_id = (SELECT movie_id FROM movies WHERE movie_title = "Patti Smith: Dream of Life") AND rating_score > 3) * 100.0 / (SELECT COUNT(DISTINCT user_id) FROM ratings WHERE movie_id = (SELECT movie_id FROM movies WHERE movie_title = "Patti Smith: Dream of Life")), 2) AS percentage_of_users_rated_above_3
SELECT movies.movie_title FROM movies JOIN ratings ON movies.movie_id = ratings.movie_id JOIN lists ON movies.movie_id = lists.list_movie_number JOIN lists_users ON lists.list_id = lists_users.list_id JOIN ratings_users ON ratings_users.user_id = lists_users.user_id WHERE director_name = 'Abbas Kiarostami' GROUP BY movies.movie_title ORDER BY AVG(rating_score) DESC LIMIT 1;
SELECT movie_release_year, COUNT(movie_id) AS num_movies FROM movies GROUP BY movie_release_year ORDER BY num_movies DESC LIMIT 1;
SELECT director_id FROM movies GROUP BY director_id ORDER BY COUNT(movie_id) DESC LIMIT 1;
SELECT COUNT(movies.movie_id) FROM     movies WHERE     movies.director_id = (         SELECT            director_id         FROM             movies         WHERE             movie_popularity = (                 SELECT                    MAX(movie_popularity)                 FROM                     movies             )     );
SELECT COUNT(DISTINCT lists_users.user_id) FROM     ratings_users JOIN     lists_users ON ratings_users.user_id = lists_users.user_id WHERE     ratings_users.user_has_payment_method = 1     AND ratings_users.rating_date_utc > '2014%'
SELECT MIN(lists_users.user_id) FROM lists_users LEFT JOIN lists ON lists_users.list_id = lists.list_id WHERE list_followers = 0 ORDER BY list_creation_date_utc ASC LIMIT 1;
SELECT MAX(lists.list_followers) FROM     lists INNER JOIN     lists_users ON lists.list_id = lists_users.list_id GROUP BY     lists_users.user_id ORDER BY     COUNT(lists.list_id) DESC LIMIT 1;
SELECT COUNT(lists.list_followers) AS followers_count FROM lists JOIN lists_users ON lists.list_id = lists_users.list_id WHERE lists.list_title = 'Non-American Films about World War II';
SELECT COUNT(DISTINCT ratings_users.user_id) FROM ratings JOIN ratings_users ON ratings.user_id = ratings_users.user_id JOIN movies ON ratings.movie_id = movies.movie_id WHERE movies.movie_title = 'Downfall' AND ratings.rating_score = 4;
SELECT movies.movie_title FROM movies JOIN ratings ON movies.movie_id = ratings.movie_id WHERE ratings.rating_score = 5 GROUP BY movies.movie_title ORDER BY COUNT(*) DESC LIMIT 1;
SELECT movies.movie_title FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id ORDER BY ratings.critic_comments DESC LIMIT 1;
SELECT ratings.user_avatar_image_url FROM ratings WHERE ratings.rating_timestamp_utc = '2019-10-17 01:36:36' 
SELECT lists_users.user_avatar_image_url FROM lists JOIN lists_users ON lists.list_id = lists_users.list_id WHERE lists.list_title = 'Vladimir Vladimirovich Nabokov'; 
SELECT MAX(list_movie_number) AS max_movie_number, user_has_payment_method FROM lists JOIN lists_users ON lists.user_id = lists_users.user_id AND lists.list_id = lists_users.list_id WHERE user_has_payment_method = 1 GROUP BY user_id ORDER BY max_movie_number DESC LIMIT 1;
SELECT lists_users.user_avatar_image_url FROM     lists_users JOIN     ratings_users ON lists_users.user_id = ratings_users.user_id JOIN     ratings ON ratings_users.user_id = ratings.user_id WHERE     ratings.rating_score = 5 GROUP BY     lists_users.user_id ORDER BY     COUNT(ratings.rating_id) DESC LIMIT     1;
SELECT COUNT(critic) AS critic_count FROM     ratings JOIN     movies ON ratings.movie_id = movies.movie_id WHERE     movies.movie_popularity = (SELECT MAX(movie_popularity) FROM movies);
SELECT ratings.user_id FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id WHERE movies.movie_title = 'Freaks' AND ratings.rating_score = 4 AND ratings.rating_timestamp_utc = '2013-05-04 06:33:32';
SELECT movies.movie_url FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id WHERE ratings.rating_score = 5 AND ratings.rating_timestamp_utc = '2013-05-03 05:11:17';
SELECT COUNT(ratings.rating_score) FROM     ratings JOIN     movies ON ratings.movie_id = movies.movie_id WHERE     movies.movie_release_year = '1998'     AND movies.movie_popularity = (SELECT MAX(movie_popularity) FROM movies WHERE movie_release_year = '1998')     AND ratings.rating_score = 4;
SELECT movies.movie_id, movies.movie_title, MIN(ratings.rating_score) AS min_rating FROM movies JOIN ratings ON movies.movie_id = ratings.movie_id WHERE movies.movie_popularity > 13000 GROUP BY movies.movie_id ORDER BY min_rating LIMIT 1;
SELECT COUNT(DISTINCT ratings_users.user_id) AS paying_subscribers_ratings FROM ratings JOIN ratings_users ON ratings.user_id = ratings_users.user_id JOIN movies ON ratings.movie_id = movies.movie_id WHERE ratings_users.user_subscriber = 1 AND movies.movie_title = "One Flew Over the Cuckoo's Nest";
SELECT COUNT(DISTINCT lists_users.user_id) AS paying_subscribers FROM lists JOIN lists_users ON lists.list_id = lists_users.list_id WHERE lists.list_followers > 3000 AND lists_users.user_has_payment_method = 1;
SELECT movies.movie_title FROM movies JOIN ratings ON movies.movie_id = ratings.movie_id WHERE movies.movie_release_year = '1988' GROUP BY movies.movie_id ORDER BY MAX(ratings.rating_score) DESC LIMIT 1;
SELECT COUNT(ratings.rating_score) AS lower_than_3_ratings FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id WHERE movies.movie_release_year = '1995' AND ratings.rating_score < 3 AND movies.movie_popularity = (     SELECT        MAX(movie_popularity)     FROM         movies     WHERE         movie_release_year = '1995' );
SELECT ROUND((SELECT COUNT(*) FROM ratings INNER JOIN movies ON ratings.movie_id = movies.movie_id WHERE movies.movie_title = 'Go Go Tales' AND ratings.rating_score = 5) * 100.0 / (SELECT COUNT(*) FROM ratings), 2) AS "Percentage of users gave '5' to the movie 'Go Go Tales'"
SELECT 100 * (     SELECT COUNT(DISTINCT lists_users.user_id)      FROM lists_users      INNER JOIN lists ON lists_users.list_id = lists.list_id      INNER JOIN ratings_users ON lists_users.user_id = ratings_users.user_id      INNER JOIN ratings ON ratings_users.user_id = ratings.user_id      INNER JOIN movies ON ratings.movie_id = movies.movie_id      WHERE movies.movie_title = 'G.I. Jane' AND ratings_users.user_subscriber = 1 ) / (     SELECT COUNT(DISTINCT lists_users.user_id)      FROM lists_users      INNER JOIN ratings_users ON lists_users.user_id = ratings_users.user_id      WHERE ratings_users.user_subscriber = 1 ) AS Percentage_Subscribers_Rated_GI_Jane;
SELECT COUNT(DISTINCT CASE WHEN movie_title = 'A Shot in the Dark' THEN user_id END) AS total_users, 100.0 * COUNT(DISTINCT CASE WHEN movie_title = 'A Shot in the Dark' AND user_has_payment_method = 1 THEN user_id END) / COUNT(DISTINCT CASE WHEN movie_title = 'A Shot in the Dark' THEN user_id END) AS percentage_paying_subscribers FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id JOIN ratings_users ON ratings.user_id = ratings_users.user_id
SELECT lists.list_title FROM lists JOIN lists_users ON lists.list_id = lists_users.list_id WHERE lists_users.user_id = 4208563;
SELECT MAX(lists.list_update_timestamp_utc) AS most_recent_update, lists.list_id, lists.list_title FROM lists JOIN lists_users ON lists.list_id = lists_users.list_id WHERE lists.list_creation_timestamp_utc LIKE '2016%' GROUP BY lists.list_id ORDER BY most_recent_update DESC LIMIT 1;
SELECT (CAST(COUNT(DISTINCT lists.list_id) AS FLOAT) / COUNT(DISTINCT lists_users.list_id)) * 100 AS percentage_subscriber_lists
SELECT lists.list_title FROM lists JOIN lists_users ON lists.list_id = lists_users.list_id WHERE lists_users.user_subscriber = 1;
SELECT lists.list_title FROM lists JOIN lists_users ON lists.list_id = lists_users.list_id WHERE lists_users.user_eligible_for_trial = 1
SELECT COUNT(DISTINCT lists.list_id) AS number_of_lists_created_by_subscribers FROM lists JOIN lists_users ON lists.user_id = lists_users.user_id WHERE lists.list_followers >= 1 AND lists_users.user_subscriber = 1;
SELECT AVG(list_followers) AS average_followers FROM lists WHERE list_movie_number > 200;
SELECT list_title FROM lists JOIN lists_users ON lists.list_id = lists_users.list_id WHERE lists.list_movie_number < 50 AND lists_users.user_subscriber = 1; 
SELECT lists.list_title, CURRENT_TIMESTAMP - MIN(lists.list_update_timestamp_utc) AS time_since_last_update FROM lists GROUP BY lists.list_title ORDER BY time_since_last_update DESC LIMIT 1;
SELECT lists_users.user_id, lists_users.user_subscriber FROM lists JOIN lists_users ON lists.list_id = lists_users.list_id WHERE lists.list_title = 'Sound and Vision'
SELECT lists.list_title, CURRENT_TIMESTAMP - list_creation_timestamp_utc AS list_age FROM lists WHERE lists.list_followers > 200;
SELECT (1 - COUNT(DISTINCT main_ratings.movie_id) * 1.0 / COUNT(DISTINCT main_movies.movie_id)) * 100 AS percentage_never_rated FROM movies AS main_movies LEFT JOIN ratings AS main_ratings ON main_movies.movie_id = main_ratings.movie_id;
SELECT movies.movie_title, ratings.rating_timestamp_utc AS rating_date, ratings.rating_score FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id WHERE ratings.user_id = 39115684;
SELECT COUNT(movies.movie_id)  FROM     movies WHERE     movie_release_year BETWEEN 1970 AND 1980     AND movie_popularity > 11000;
SELECT COUNT(movies.movie_id) FROM movies JOIN directors ON movies.director_id = directors.director_id WHERE directors.director_name = 'Felipe Cazals' AND movies.movie_release_year = 1976;
SELECT movies.movie_url FROM movies JOIN directors ON movies.director_id = directors.director_id WHERE movies.movie_title = 'Red Blooded American Girl';
SELECT MAX(list_title) AS latest_updated_list_name FROM lists ORDER BY list_update_timestamp_utc DESC LIMIT 1;
SELECT lists.user_id FROM lists WHERE lists.list_comments = 142;
SELECT movies.movie_title, MAX(movies.movie_popularity) AS most_popular_movie_popularity, AVG(ratings.rating_score) AS average_rating_score FROM movies JOIN directors ON movies.director_id = directors.director_id JOIN ratings ON movies.movie_id = ratings.movie_id WHERE directors.director_name = 'Jeannot Szwarc';
SELECT director_name, MAX(movie_count) AS max_movie_count, MAX(highest_rating_score) AS max_highest_rating_score FROM (SELECT director_name, COUNT(DISTINCT movies.movie_id) AS movie_count, MAX(rating_score) AS highest_rating_score FROM directors JOIN movies ON directors.director_id = movies.director_id JOIN ratings ON movies.movie_id = ratings.movie_id WHERE movies.movie_release_year BETWEEN 1970 AND 1979 GROUP BY directors.director_id) AS T1 GROUP BY director_name HAVING movie_count = (SELECT MAX(movie_count) FROM (SELECT COUNT(DISTINCT movies.movie_id) AS movie_count FROM directors JOIN movies ON directors.director_id = movies.director_id WHERE movies.movie_release_year BETWEEN 1970 AND 1979 GROUP BY directors.director_id))
SELECT COUNT(DISTINCT lists_users.user_id) FROM lists_users JOIN ratings_users ON lists_users.user_id = ratings_users.user_id JOIN ratings ON ratings_users.user_id = ratings.user_id JOIN movies ON ratings.movie_id = movies.movie_id WHERE lists_users.user_trialist = 1 AND movies.movie_title = 'The Secret Life of Words' AND ratings.rating_score = 3 AND ratings.rating_timestamp_utc BETWEEN '2010-01-01%' AND '2020-12-31%';
SELECT movies.movie_title, ratings.rating_url FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id WHERE ratings.critic_likes = (SELECT MAX(critic_likes) FROM ratings);
SELECT movies.movie_title, COUNT(ratings.rating_id) AS number_of_users_with_rating_5 FROM movies JOIN ratings ON movies.movie_id = ratings.movie_id WHERE movies.movie_release_year >= 2000 AND ratings.rating_score = 5 GROUP BY movies.movie_id ORDER BY MAX(movies.movie_popularity) DESC LIMIT 5; 
SELECT AVG(list_followers) AS average_followers FROM lists JOIN lists_users ON lists.list_id = lists_users.list_id JOIN ratings_users ON lists_users.user_id = ratings_users.user_id JOIN ratings ON ratings_users.user_id = ratings.user_id JOIN movies ON ratings.movie_id = movies.movie_id WHERE movies.movie_title = 'Pavee Lackeen: The Traveller Girl' AND ratings.rating_timestamp_utc = '2011-03-27 02:06:34' GROUP BY lists.user_id;
SELECT COUNT(DISTINCT ratings_users.user_id) AS eligible_users_count, movies.movie_image_url AS movie_image_url FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id JOIN ratings_users ON ratings.user_id = ratings_users.user_id JOIN lists_users ON ratings.user_id = lists_users.user_id JOIN lists ON lists_users.list_id = lists.list_id WHERE ratings.rating_timestamp_utc BETWEEN '2017-01-01 00:00:00' AND '2017-12-31 00:00:00' AND movies.movie_title = 'Patti Smith: Dream of Life' AND lists_users.user_eligible_for_trial = 1;
SELECT AVG(list_movie_number) AS average_movies_added, COUNT(CASE WHEN rating_score = 5 THEN 1 ELSE NULL END) AS count_movies_rated_5 FROM lists JOIN lists_users ON lists.user_id = lists_users.user_id JOIN ratings_users ON lists_users.user_id = ratings_users.user_id JOIN ratings ON ratings_users.user_id = ratings.user_id AND ratings.movie_id = lists.movie_id WHERE lists_users.user_id = 8516503;
SELECT director_name, movie_release_year, AVG(rating_score) AS average_rating_score FROM movies JOIN ratings ON movies.movie_id = ratings.movie_id WHERE movie_popularity = (SELECT MAX(movie_popularity) FROM movies) AND user_trialist = 1;
SELECT movies.movie_title FROM ratings JOIN movies ON ratings.movie_id = movies.movie_id WHERE ratings.user_id = 57756708 ORDER BY ratings.rating_timestamp_utc DESC LIMIT 1;
SELECT movies.movie_title, movies.movie_release_year, director_name, AVG(ratings.rating_score) AS average_rating_score FROM movies INNER JOIN ratings ON movies.movie_id = ratings.movie_id INNER JOIN directors ON movies.director_id = directors.director_id GROUP BY movies.movie_title, movies.movie_release_year, director_name ORDER BY MIN(ratings.rating_timestamp_utc) ASC LIMIT 10;
SELECT  ord_date AS date_with_most_ordered_quantity, MAX(sum_qty) AS total_order_quantity_on_that_day FROM (     SELECT ord_date, SUM(qty) AS sum_qty     FROM sales     GROUP BY ord_date ) AS daily_sales ORDER BY sum_qty DESC LIMIT 1; 
SELECT titles.title, SUM(sales.qty) AS total_quantity FROM sales JOIN titles ON sales.title_id = titles.title_id WHERE YEAR(sales.ord_date) = 1992 GROUP BY titles.title_id ORDER BY total_quantity DESC LIMIT 1;
SELECT titles.title, titles.price, titles.pubdate FROM sales JOIN titles ON sales.title_id = titles.title_id WHERE sales.payterms = 'ON invoice';
SELECT titles.title FROM titles JOIN roysched ON titles.title_id = roysched.title_id WHERE royalty >= 10 AND lorange <> 0;
SELECT title, royaltyper FROM titles JOIN titleauthor ON titles.title_id = titleauthor.title_id WHERE titles.title_id = 'BU2075' AND titleauthor.royaltyper >= 10000 AND titleauthor.royaltyper <= 50000;
SELECT MAX(titleauthor.royaltyper) AS max_royalty_percentage,   roysched.lorange AS minimum_range FROM   titleauthor JOIN   roysched ON titleauthor.title_id = roysched.title_id;
SELECT titles.title, publishers.pub_name FROM titles JOIN publishers ON titles.pub_id = publishers.pub_id WHERE publishers.country = 'USA';
SELECT MAX(royaltyper) FROM     titleauthor JOIN     titles ON titleauthor.title_id = titles.title_id JOIN     roysched ON titles.title_id = roysched.title_id WHERE     roysched.hirange < 20000
SELECT titles.title, titles.notes, publishers.pub_name FROM titles JOIN publishers ON titles.pub_id = publishers.pub_id WHERE YEAR(titles.pubdate) = 1991;
SELECT titles.title FROM titles JOIN sales ON titles.title_id = sales.title_id JOIN stores ON sales.stor_id = stores.stor_id WHERE sales.qty > 20 AND stores.state = 'CA';
SELECT stores.stor_name, MIN(sales.qty) AS least_quantity_title FROM stores JOIN sales ON stores.stor_id = sales.stor_id GROUP BY stores.stor_name ORDER BY MAX(sales.qty) DESC LIMIT 1;
SELECT titles.title, publishers.pub_name, roysched.royalty FROM titles JOIN publishers ON titles.pub_id = publishers.pub_id JOIN roysched ON titles.title_id = roysched.title_id WHERE titles.title_id = 'BU 2075';
SELECT stores.stor_name, (SUM(CASE WHEN sales.payterms = 'Net 30' THEN sales.qty ELSE 0 END) / SUM(sales.qty)) * 100 AS percentage_net_30 FROM stores JOIN sales ON stores.stor_id = sales.stor_id WHERE stores.stor_id = '7066';
SELECT pub_name, AVG(ytd_sales) AS avg_ytd_sales FROM publishers JOIN titles ON publishers.pub_id = titles.pub_id JOIN sales ON titles.title_id = sales.title_id WHERE publishers.pub_id = '877';
SELECT  emp_id, fname, lname FROM employee WHERE YEAR(hire_date) < 1990;
SELECT emp_id, fname, lname, hire_date FROM employee WHERE job_lvl = (     SELECT MIN(job_lvl) FROM employee );
SELECT strftime('%Y', hire_date) AS hired_year, COUNT(emp_id) AS total_hired FROM employee GROUP BY hired_year ORDER BY total_hired DESC LIMIT 1;
SELECT employee.emp_id, employee.fname, employee.lname FROM employee JOIN jobs ON employee.job_id = jobs.job_id GROUP BY employee.emp_id HAVING MAX(employee.job_lvl) = MAX(jobs.max_lvl)
SELECT emp.fname, emp.lname, emp.hire_date FROM employee emp JOIN jobs ON emp.job_id = jobs.job_id WHERE jobs.job_desc = 'Chief Executive Officer';
SELECT employee.fname, employee.lname, publishers.pub_name FROM employee JOIN publishers ON employee.pub_id = publishers.pub_id WHERE publishers.country != 'USA';
SELECT employee.fname, employee.lname, jobs.job_desc FROM employee JOIN publishers ON employee.pub_id = publishers.pub_id JOIN jobs ON employee.job_id = jobs.job_id WHERE publishers.pub_name = 'GGG&G';
SELECT pub_name, type FROM publishers JOIN titles ON publishers.pub_id = titles.pub_id ORDER BY pub_name;
SELECT pub_name FROM publishers JOIN titles ON publishers.pub_id = titles.pub_id WHERE strftime('%Y', pubdate) = '1991' GROUP BY publishers.pub_id ORDER BY COUNT(titles.title_id) DESC LIMIT 1;
SELECT titles.title FROM titles JOIN publishers ON titles.pub_id = publishers.pub_id WHERE publishers.pub_name = 'Binnet & Hardley' ORDER BY titles.price DESC LIMIT 1;
SELECT employee.fname, employee.lname, jobs.job_desc FROM employee JOIN jobs ON employee.job_id = jobs.job_id WHERE employee.job_lvl > 200;
SELECT authors.au_id, authors.au_fname, authors.au_lname FROM authors JOIN titleauthor ON authors.au_id = titleauthor.au_id JOIN titles ON titleauthor.title_id = titles.title_id WHERE titles.type = 'business';
SELECT titles.title_id, titles.title, authors.au_id, authors.au_lname, authors.au_fname, SUM(sales.qty) AS ytd_sales FROM titles INNER JOIN titleauthor ON titles.title_id = titleauthor.title_id INNER JOIN authors ON titleauthor.au_id = authors.au_id LEFT JOIN sales ON titles.title_id = sales.title_id WHERE authors.contract = 0 GROUP BY titles.title_id, titles.title, authors.au_id, authors.au_lname, authors.au_fname
SELECT MAX(titles.title) AS title_with_max_sales FROM     authors JOIN     titleauthor ON authors.au_id = titleauthor.au_id JOIN     titles ON titleauthor.title_id = titles.title_id JOIN     sales ON titles.title_id = sales.title_id WHERE     authors.state = 'CA' AND     authors.contract = 0 GROUP BY     authors.au_id;
SELECT au_fname, au_lname FROM     authors JOIN     titleauthor ON authors.au_id = titleauthor.au_id JOIN     titles ON titleauthor.title_id = titles.title_id WHERE     titles.title = 'Sushi, Anyone?';
SELECT (      COUNT(CASE WHEN job_desc = 'Editor' OR job_desc = 'Designer' THEN emp_id END) * 100.0 / COUNT(emp_id) ) AS percentage_of_editors_and_designers FROM employee INNER JOIN jobs ON employee.job_id = jobs.job_id WHERE job_desc = 'Editor' OR job_desc = 'Designer';
SELECT titles.title FROM titles JOIN publishers ON titles.pub_id = publishers.pub_id WHERE titles.ytd_sales > (SELECT AVG(ytd_sales) FROM titles) ORDER BY publishers.pub_name;
SELECT COUNT(*) FROM publishers WHERE country = 'USA';
SELECT pub_info.logo, pub_info.pr_info FROM pub_info JOIN publishers ON pub_info.pub_id = publishers.pub_id WHERE publishers.pub_name = 'New Moon Books';
SELECT emp.fname FROM employee emp JOIN jobs ON emp.job_id = jobs.job_id WHERE jobs.job_desc = 'Managing Editor';
SELECT MAX(job_lvl) AS highest_job_level FROM employee WHERE hire_date = (SELECT MIN(hire_date) FROM employee)
SELECT MAX(sales.qty), stores.city FROM     sales JOIN     stores ON sales.stor_id = stores.stor_id GROUP BY     stores.city ORDER BY     MAX(sales.qty) DESC LIMIT 1;
SELECT MAX(titles.price)  FROM      titles  JOIN      sales ON titles.title_id = sales.title_id  GROUP BY      titles.title_id  ORDER BY      SUM(sales.qty) DESC  LIMIT 1;
SELECT stores.stor_name FROM     stores JOIN     sales ON stores.stor_id = sales.stor_id JOIN     titles ON sales.title_id = titles.title_id WHERE     titles.title = "Life Without Fear";
SELECT COUNT(DISTINCT stores.stor_id) FROM     stores JOIN     sales ON stores.stor_id = sales.stor_id JOIN     titles ON sales.title_id = titles.title_id WHERE     titles.title = "Life Without Fear" AND     stores.state = "Massachusetts";
SELECT pub_name, country FROM publishers JOIN titles ON publishers.pub_id = titles.pub_id WHERE title = 'Life Without Fear';
SELECT pub_name FROM publishers JOIN titles ON publishers.pub_id = titles.pub_id WHERE price = (     SELECT MAX(price) FROM titles );
SELECT COUNT(DISTINCT publishers.pub_id) FROM     publishers JOIN     titles ON publishers.pub_id = titles.pub_id WHERE     publishers.country = 'USA' AND     titles.price > 15;
SELECT title_id, title, type, pub_id, price, advance, royalty, ytd_sales, notes, pubdate FROM titles ORDER BY ytd_sales DESC LIMIT 3;
SELECT COUNT(sales.qty) FROM     sales JOIN stores ON sales.stor_id = stores.stor_id JOIN titles ON sales.title_id = titles.title_id JOIN publishers ON titles.pub_id = publishers.pub_id WHERE     stores.state = 'Massachusetts'     AND titles.type = 'business';
SELECT AVG(sales.qty) AS avg_order_quantity FROM titles JOIN sales ON titles.title_id = sales.title_id WHERE titles.title = "Life Without Fear";
SELECT AVG(job_lvl) AS avg_level, (MAX(max_lvl) - AVG(job_lvl)) AS levels_between FROM employee JOIN jobs ON employee.job_id = jobs.job_id WHERE jobs.job_desc = 'Managing Editor';
SELECT MIN(price) AS cheapest_business_book_price FROM titles WHERE type = 'business';
SELECT type FROM titles WHERE advance = (SELECT MAX(advance) FROM titles) 
SELECT MAX(titleauthor.royaltyper) AS "Royalty for the Bestseller Book" FROM     titleauthor JOIN     sales ON titleauthor.title_id = sales.title_id GROUP BY     titleauthor.title_id ORDER BY     SUM(sales.qty) DESC LIMIT 1;
SELECT job_lvl FROM employee WHERE lname = 'O''Rourke';
SELECT MAX(emp_id) FROM employee WHERE minit IS NULL;
SELECT au_id, au_lname, au_fname, contract FROM authors JOIN titleauthor ON authors.au_id = titleauthor.au_id JOIN titles ON titleauthor.title_id = titles.title_id WHERE title = 'Sushi, Anyone?'; 
SELECT pub_name, fname, lname FROM publishers JOIN employee ON publishers.pub_id = employee.pub_id JOIN jobs ON employee.job_id = jobs.job_id WHERE job_lvl = (SELECT MAX(job_lvl) FROM employee)
SELECT job_desc FROM     employee JOIN     jobs ON employee.job_id = jobs.job_id WHERE     fname = 'Pedro' AND lname = 'Afonso';
SELECT COUNT(DISTINCT max_lvl - job_lvl) AS levels_left FROM employee JOIN authors ON employee.emp_id = authors.au_id WHERE employee.fname = 'Diego' AND employee.lname = 'W Roel';
SELECT `notes` FROM     sales INNER JOIN     titles ON sales.title_id = titles.title_id WHERE     ord_date = '1994-09-14';
SELECT titles.type FROM sales INNER JOIN titles ON sales.title_id = titles.title_id WHERE sales.ord_date = '1993-05-29';
SELECT pub_name, city, state, country FROM publishers WHERE country = 'France';
SELECT pub_name FROM    publishers JOIN    titles ON publishers.pub_id = titles.pub_id WHERE    title = "Silicon Valley Gastronomic Treats";
SELECT city FROM employee JOIN authors ON employee.emp_id = authors.au_id WHERE au_fname = 'Victoria' AND au_lname = 'P Ashworth'; 
SELECT COUNT(sales.ord_num) AS sales_count FROM sales INNER JOIN stores ON sales.stor_id = stores.stor_id WHERE stores.city = 'Remulade';
SELECT DIVIDE(     SUBTRACT(         SUM(CASE WHEN city = 'Fremont' AND strftime('%Y', ord_date) = '1993' THEN qty ELSE 0 END),         SUM(CASE WHEN city = 'Portland' AND strftime('%Y', ord_date) = '1993' THEN qty ELSE 0 END)     ),     SUM(CASE WHEN city = 'Fremont' AND strftime('%Y', ord_date) = '1993' THEN qty ELSE 0 END) ) * 100 AS percent_more_sold 
SELECT 100 * (     (SELECT SUM(CASE WHEN job_desc = 'publisher' THEN 1 ELSE 0 END) FROM employee INNER JOIN jobs ON employee.job_id = jobs.job_id)     -     (SELECT SUM(CASE WHEN job_desc = 'designer' THEN 1 ELSE 0 END) FROM employee INNER JOIN jobs ON employee.job_id = jobs.job_id) ) /  (SELECT COUNT(*) FROM employee) AS percent_more_publisher_than_designer;
SELECT employee.fname || ' ' || employee.minit || ' ' || employee.lname AS full_name FROM employee WHERE YEAR(employee.hire_date) BETWEEN 1990 AND 1995 ORDER BY employee.job_lvl DESC;
SELECT title, type, price FROM titles WHERE royalty > (     SELECT    AVG(royalty)     FROM     titles )
SELECT titles.title, titles.type, titles.price FROM titles JOIN sales ON titles.title_id = sales.title_id WHERE YEAR(sales.ord_date) = 1994 GROUP BY titles.title_id HAVING SUM(sales.qty) < (SELECT SUM(qty) / COUNT(title_id) FROM sales WHERE YEAR(ord_date) = 1994);
SELECT titles.title, titles.type, titles.price FROM titles JOIN publishers ON titles.pub_id = publishers.pub_id WHERE publishers.pub_name = 'New Moon Books' ORDER BY titles.price ASC; 
SELECT titles.title, MAX(titleauthor.royaltyper) AS highest_royalty FROM titles JOIN publishers ON titles.pub_id = publishers.pub_id JOIN titleauthor ON titles.title_id = titleauthor.title_id JOIN authors ON titleauthor.au_id = authors.au_id WHERE publishers.country = 'USA' GROUP BY titles.title ORDER BY highest_royalty DESC;
SELECT AVG(CASE WHEN publishers.country = 'USA' THEN titleauthor.royaltyper ELSE 0 END) - AVG(CASE WHEN publishers.country != 'USA' THEN titleauthor.royaltyper ELSE 0 END) AS royalty_difference FROM titleauthor JOIN titles ON titleauthor.title_id = titles.title_id JOIN publishers ON titles.pub_id = publishers.pub_id;
SELECT AVG(ABS(e1.job_lvl - e2.job_lvl)) FROM     employee AS e1     INNER JOIN publishers AS p ON e1.pub_id = p.pub_id     INNER JOIN jobs AS j1 ON e1.job_id = j1.job_id     INNER JOIN titles AS t ON p.pub_id = t.pub_id     INNER JOIN titleauthor AS ta ON t.title_id = ta.title_id     INNER JOIN authors AS a ON ta.au_id = a.au_id     INNER JOIN jobs AS j2 ON a.au_id = j2.job_id     INNER JOIN employee AS e2 ON j2.job_id = e2.job_id WHERE     j1.job_desc = 'Marketing Manager'     AND p.country = 'USA'     AND e1.job_lvl IS NOT NULL     AND e2.job_lvl IS NOT NULL;
SELECT titles.title, publishers.pub_name, titles.price FROM titles JOIN publishers ON titles.pub_id = publishers.pub_id WHERE titles.notes LIKE '%helpful hints on how to use your electronic resources%';
SELECT titles.title, publishers.pub_name, titles.ytd_sales FROM titles JOIN publishers ON titles.pub_id = publishers.pub_id WHERE titles.notes = 'Carefully researched study of the effects of strong emotions on the body';
SELECT title, SUM(qty) AS total_sales FROM sales JOIN titles ON sales.title_id = titles.title_id JOIN stores ON sales.stor_id = stores.stor_id WHERE stores.state = 'CA' GROUP BY titles.title_id HAVING SUM(qty) > (SELECT AVG(qty) FROM sales) ORDER BY total_sales DESC LIMIT 5;
SELECT MAX(ser_time) AS max_ser_time, date_received AS day_received FROM callcenterlogs GROUP BY day_received ORDER BY max_ser_time DESC LIMIT 1;
SELECT MIN(callcenterlogs.ser_start) AS earliest_complaint_start FROM     callcenterlogs JOIN     events ON callcenterlogs.complaint_id = events.complaint_id WHERE     events.date_received = '2017-03-22';
SELECT MAX(priority) FROM callcenterlogs WHERE complaint_id IN ('CR2400594', 'CR2405641');
SELECT client.first || ' ' || client.middle || ' ' || client.last AS full_name FROM client WHERE client.sex = 'Male' AND client.year > 1990;
SELECT COUNT(*) FROM     events JOIN     client ON events.client_id = client.client_id WHERE     client.first = 'Diesel' AND client.last = 'Galloway';
SELECT events.sub-product FROM events JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id JOIN client ON events.client_id = client.client_id JOIN district ON client.district_id = district.district_id WHERE client.first = 'Diesel' AND client.last = 'Galloway' AND strftime('%Y-%m-%d', callcenterlogs.date_received) = '2014-07-03'; 
SELECT  CASE     WHEN events.tags = 'Matthew Pierce' AND events."date received" = '2016-10-28' AND events."consumer consent provided?" NOT IN (NULL, 'N/A', 'Empty') THEN 'Approved by Matthew Pierce'     ELSE 'Not approved by Matthew Pierce' END AS Approval_Status 
SELECT strftime('%s', events.date_sent_to_company) - strftime('%s', events.date_received) AS delay FROM events JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id JOIN client ON events.client_id = client.client_id WHERE client.first = 'Matthew' AND client.last = 'Pierce' AND events.date_received = '2016-10-28';
SELECT client.first, client.middle, client.last FROM callcenterlogs JOIN events ON callcenterlogs.complaint_id = events.complaint_id JOIN client ON events.client_id = client.client_id WHERE callcenterlogs.date_received = '2017-03-27' AND callcenterlogs.server = 'MICHAL';
SELECT SUM(callcenterlogs.ser_time) FROM     callcenterlogs JOIN     events ON callcenterlogs.complaint_id = events.complaint_id JOIN     client ON events.client_id = client.client_id WHERE     events."Date received" = '2017-03-27'     AND client.first = 'Rachel'     AND client.last = 'Hicks';
SELECT COUNT(DISTINCT client.client_id) FROM client JOIN district ON client.district_id = district.district_id JOIN state ON district.state_abbrev = state.statecode JOIN events ON events.client_id = client.client_id JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id WHERE district.city = 'New York' AND events.issue = 'Deposits and withdrawals';
SELECT client.first || ' ' || client.middle || ' ' || client.last AS full_name FROM client JOIN callcenterlogs ON callcenterlogs.rand_client = client.client_id JOIN events ON events.client_id = client.client_id WHERE events.company_response_to_consumer = 'In progress';
SELECT COUNT(DISTINCT client.client_id) FROM   client JOIN   events ON client.client_id = events.client_id JOIN   callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id JOIN   district ON client.district_id = district.district_id WHERE   callcenterlogs.timely_response = 'Yes'   AND district.city = 'New York';
SELECT COUNT(DISTINCT events.complaint_id) FROM     events JOIN     client ON events.client_id = client.client_id JOIN     callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id WHERE     events.product = 'Credit card'     AND strftime('%Y', events.date_received) = '2016'     AND client.sex = 'Male';
SELECT division FROM district JOIN client ON client.district_id = district.district_id JOIN events ON events.client_id = client.client_id JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id WHERE first = 'Diesel' AND last = 'Galloway';
SELECT client.first || ' ' || client.middle || ' ' || client.last AS full_name FROM client JOIN district ON client.district_id = district.district_id JOIN state ON district.state_abbrev = state.statecode WHERE client.sex = 'Male' AND state.region = 'Pacific';
SELECT AVG(events.complaint_id) AS average_complaints FROM     events JOIN     client ON events.client_id = client.client_id JOIN     callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id JOIN     district ON client.district_id = district.district_id JOIN     state ON district.state_abbrev = state.statecode WHERE     events.product = 'Credit card'     AND district.city = 'New York'     AND strftime('%Y', events.date_received) BETWEEN '2015' AND '2017';
SELECT MULTIPLY(     DIVIDE(         SUBTRACT(             (SELECT COUNT(*) FROM events               JOIN callcenterlogs ON events."complaint id" = callcenterlogs."complaint id"               JOIN client ON events.client_id = client.client_id               JOIN district ON client.district_id = district.district_id               JOIN state ON district.state_abbrev = state.statecode               WHERE city = 'New York' AND year("Date received") = 2017),             (SELECT COUNT(*) FROM events               JOIN callcenterlogs ON events."complaint id" = callcenterlogs."complaint id"               JOIN client ON events.client_id = client.client_id               JOIN district ON client.district_id = district.district_id               JOIN state ON district.state_abbrev = state.statecode               WHERE city = 'New York' AND year("Date received") = 2016)         ),         (SELECT COUNT(*) FROM events           JOIN callcenterlogs ON events."complaint id" = callcenterlogs."complaint id"           JOIN client ON events.client_id = client.client_id           JOIN district ON client.district_id = district.district_id           JOIN state ON district.state_abbrev = state.statecode           WHERE city = 'New York' AND year("Date received") = 2016)     ),     1.0 ); 
SELECT SUM(ser_time) FROM callcenterlogs JOIN client ON callcenterlogs.rand_client = client.client_id JOIN events ON events.complaint_id = callcenterlogs.complaint_id WHERE client.client_id = 'C00007127' AND events.date_received = '2017-02-22';
SELECT state.state FROM state JOIN district ON state.statecode = district.state_abbrev JOIN client ON client.district_id = district.district_id WHERE client.email = "wyatt.collins@gmail.com";
SELECT events.sub-product FROM events JOIN callcenterlogs ON events.complaint id = callcenterlogs.complaint id JOIN client ON events.client_id = client.client_id WHERE client.sex = 'Male' AND client.first = 'Lennox' AND client.middle = 'Oliver' AND client.last = 'Drake';
SELECT events.sub-issue FROM events JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id JOIN client ON events.client_id = client.client_id WHERE client.sex = 'Male' AND client.first = 'Gunner' AND client.middle = 'Omer' AND client.last = 'Fuller';
SELECT CASE     WHEN events."consumer consent provided?" NOT IN (NULL, 'N/A', 'Empty') THEN 'Yes'     ELSE 'No' END AS "Consent Provided" FROM events JOIN client ON events.client_id = client.client_id JOIN callcenterlogs ON events."complaint id" = callcenterlogs."complaint id" WHERE client.first = 'Lyric' AND client.middle = 'Emely' AND client.last = 'Taylor' AND events."date received" = '2016-05-20'; 
SELECT COUNT(DATE(events.date_sent_to_company, 'start of day') - DATE(callcenterlogs.date_received, 'start of day')) AS days_delay FROM events JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id JOIN client ON events.client_id = client.client_id WHERE client.first = 'Brantley' AND client.middle = 'Julian' AND client.last = 'Stanley' AND client.sex = 'Male' AND DATE(callcenterlogs.date_received, 'start of day') = '2012-05-18';
SELECT district.city FROM reviews JOIN district ON reviews.district_id = district.district_id WHERE reviews.date = '2017-07-22';
SELECT events.consumer_complaint_narrative FROM events JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id JOIN client ON events.client_id = client.client_id JOIN district ON client.district_id = district.district_id JOIN reviews ON reviews.district_id = district.district_id WHERE district.city = 'Jacksonville' AND events.date_received = '2017-07-22';
SELECT events.product FROM events JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id JOIN client ON events.client_id = client.client_id JOIN district ON client.district_id = district.district_id JOIN reviews ON district.district_id = reviews.district_id JOIN state ON district.state_abbrev = state.statecode WHERE district.city = 'Indianapolis' AND events.date_received = '2016-10-07';
SELECT COUNT(reviews.stars) FROM     reviews JOIN     district ON reviews.district_id = district.district_id JOIN     state ON district.state_abbrev = state.statecode JOIN     events ON reviews.district_id = events.district_id JOIN     client ON events.client_id = client.client_id JOIN     callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id WHERE     events.product = 'Eagle Capital'     AND district.city = 'Little Rock'     AND events.date_received = '2013-04-04';
SELECT client.year, client.month, client.day FROM     client JOIN     callcenterlogs ON client.client_id = callcenterlogs.rand_client JOIN     events ON events.client_id = client.client_id WHERE     callcenterlogs.complaint_id = 'CR0217298';
SELECT phone FROM     client JOIN     callcenterlogs ON client.client_id = callcenterlogs.rand_client WHERE     callcenterlogs.complaint_id = "CR0100432";
SELECT (MULTIPLY(DIVIDE((SELECT COUNT(DISTINCT client_id) FROM events WHERE date_received = '2017-03-27' AND sex = 'Female'), (SELECT COUNT(DISTINCT client_id) FROM events WHERE date_received = '2017-03-27')), 1.0) * 100) AS percentage_female_clients;
SELECT      (COUNT(*) * 100.0) /      (SELECT COUNT(*)       FROM callcenterlogs       WHERE client_id = (          SELECT client_id           FROM client           WHERE first = 'Mason'             AND middle = 'Javen'             AND last = 'Lopez'             AND sex = 'Male'      )       AND "Consumer consent provided?" = 'Consent provided')  AS percentage FROM callcenterlogs  WHERE client_id = (     SELECT client_id      FROM client      WHERE first = 'Mason'        AND middle = 'Javen'        AND last = 'Lopez'        AND sex = 'Male' ); 
SELECT COUNT(callcenterlogs.complaint_id) AS num_urgent_complaints, GROUP_CONCAT(callcenterlogs.complaint_id) AS urgent_complaint_ids FROM callcenterlogs JOIN events ON events.complaint_id = callcenterlogs.complaint_id WHERE callcenterlogs.priority = 2 AND events.date_received BETWEEN '2017-03-01' AND '2017-03-31';
SELECT client.first || ' ' || client.middle || ' ' || client.last AS full_name, client.year || '-' || client.month || '-' || client.day AS date_of_birth, client.email AS email_id FROM client WHERE (client.year < strftime('%Y', 'now', '-65 years')) OR (client.year = strftime('%Y', 'now', '-65 years') AND client.month < strftime('%m', 'now')) OR (client.year = strftime('%Y', 'now', '-65 years') AND client.month = strftime('%m', 'now') AND client.day <= strftime('%d', 'now')) ORDER BY client.year DESC, client.month DESC, client.day DESC; 
SELECT MAX(COUNT(stars = 5)) AS max_five_stars, product FROM reviews WHERE stars = 5 GROUP BY product;
SELECT state.statecode FROM state JOIN district ON state.statecode = district.state_abbrev WHERE district.division = 'South';
SELECT client.email FROM client JOIN callcenterlogs ON client.client_id = callcenterlogs.rand_client WHERE callcenterlogs.outcome = 'Hang';
SELECT AVG(client.age)  FROM      client  JOIN      district ON client.district_id = district.district_id  JOIN      state ON district.state_abbrev = state.statecode  WHERE      state.region = 'Midwest';
SELECT client.first || ' ' || client.middle || ' ' || client.last AS full_name, client.phone AS phone_number FROM client JOIN events ON events.client_id = client.client_id JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id WHERE events.submitted_via = 'fax';
SELECT DISTINCT district.city, district.state_abbrev FROM     district JOIN     reviews ON district.district_id = reviews.district_id JOIN     events ON events.district_id = district.district_id JOIN     client ON events.client_id = client.client_id JOIN     callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id WHERE     reviews.product = 'Eagle Capital' GROUP BY     district.city, district.state_abbrev HAVING     AVG(reviews.stars) < (SELECT AVG(stars) FROM reviews WHERE product = 'Eagle Capital');
SELECT COUNT(*) FROM callcenterlogs JOIN events ON events.complaint_id = callcenterlogs.complaint_id JOIN client ON client.client_id = events.client_id JOIN district ON district.district_id = client.district_id JOIN state ON state.statecode = district.state_abbrev WHERE district.division = 'Mountain' AND client.age BETWEEN 12 AND 20;
SELECT COUNT(events.complaint_id) AS num_complaints FROM events JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id JOIN client ON events.client_id = client.client_id JOIN district ON client.district_id = district.district_id WHERE events.product = 'Credit card' AND client.sex = 'female';
SELECT client.first, client.middle, client.last FROM client JOIN events ON client.client_id = events.client_id WHERE client.sex = 'Male' AND client.year BETWEEN 1980 AND 2000 AND events.submitted via = 'Referral';
SELECT MAX(Submitted via) FROM events JOIN client ON events.client_id = client.client_id JOIN callcenterlogs ON events.complaint id = callcenterlogs.complaint id JOIN district ON client.district_id = district.district_id JOIN state ON district.state_abbrev = state.statecode WHERE state.state = 'florida';
SELECT AVG(COUNT(events."Complaint ID")) AS average_complaints_per_year FROM     events JOIN     client ON events.client_id = client.client_id JOIN     district ON client.district_id = district.district_id JOIN     state ON district.state_abbrev = state.statecode WHERE     district.city = 'New Bedford'     AND events."Company response to consumer" = 'Closed with explanation' GROUP BY     strftime('%Y', events."Date received");
SELECT (MULTIPLY(DIVIDE(SUM("Consumer disputed?" = 'Yes' AND city = 'Houston'), COUNT(client_id)), 1.0)) AS "Percentage of Houston Consumers Disputing Complaints" FROM events JOIN client ON events.client_id = client.client_id WHERE city = 'Houston';
SELECT COUNT(DISTINCT client.client_id) FROM     client JOIN     district ON client.district_id = district.district_id JOIN     state ON district.state_abbrev = state.statecode JOIN     events ON events.client_id = client.client_id JOIN     callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id WHERE     district.city = 'Syracuse';
SELECT 100.0 * SUM(callcenterlogs.priority = 1) / COUNT(callcenterlogs.complaint id) FROM     callcenterlogs     INNER JOIN state ON district.state_abbrev = state.statecode WHERE     state.state = 'California'
SELECT ABS(   (SELECT AVG(age) FROM client     JOIN district ON client.district_id = district.district_id     JOIN state ON district.state_abbrev = state.statecode     WHERE state.region = 'Northeast' AND age BETWEEN 35 AND 55) -   (SELECT AVG(age) FROM client     JOIN district ON client.district_id = district.district_id     JOIN state ON district.state_abbrev = state.statecode     WHERE state.region = 'Northeast' AND age > 65) ) AS "Difference in Average Age" 
SELECT complaint_id FROM     callcenterlogs ORDER BY     ser_time DESC LIMIT 3; 
SELECT COUNT(DISTINCT client_id) FROM client WHERE email NOT LIKE '%@gmail.com';
SELECT client.client_id FROM client LEFT JOIN events ON client.client_id = events.client_id WHERE events."consumer consent provided?" IS NULL OR events."consumer consent provided?" = 'N/A' OR events."consumer consent provided?" = '';
SELECT   complaint_id FROM   events WHERE   "Date sent to company" = '2014-09-25' GROUP BY   complaint_id ORDER BY   JULIANDAY("Date sent to company") - JULIANDAY("Date received") DESC LIMIT 1; 
SELECT c.date_received, c.complaint_id FROM callcenterlogs AS c JOIN events AS e ON e.complaint_id = c.complaint_id WHERE c.priority = 2 ORDER BY c.date_received; 
SELECT COUNT(*) FROM     callcenterlogs WHERE     outcome != 'AGENT';
SELECT COUNT(*) FROM     callcenterlogs AS c     JOIN events AS e ON c.complaint_id = e.complaint_id     JOIN client AS cl ON c.rand_client = cl.client_id     JOIN district AS d ON cl.district_id = d.district_id     JOIN state AS s ON d.state_abbrev = s.statecode WHERE     c.server = 'SHARON'     AND e.product = 'Credit Card';
SELECT region, MAX(COUNT(stars = 1)) AS most_1_star_reviews FROM reviews JOIN district ON reviews.district_id = district.district_id JOIN state ON district.state_abbrev = state.statecode GROUP BY region;
SELECT DISTINCT year FROM client JOIN events ON client.client_id = events.client_id JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id WHERE events.sub_product = '(CD) Certificate of deposit' GROUP BY year ORDER BY COUNT(events.sub_product) DESC; 
SELECT COUNT(*) FROM     events JOIN     callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id JOIN     client ON events.client_id = client.client_id JOIN     district ON client.district_id = district.district_id JOIN     state ON district.state_abbrev = state.statecode WHERE     district.division = 'Mountain'     AND events.issue = 'Billing disputes';
SELECT COUNT(client.client_id) FROM client JOIN district ON client.district_id = district.district_id JOIN state ON district.state_abbrev = state.statecode WHERE client.sex = 'Male' AND state.state = 'Massachusetts';
SELECT client.last FROM client JOIN events ON client.client_id = events.client_id JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id WHERE events.type = 'PS' AND callcenterlogs.server = 'TOVA';
SELECT COUNT(DISTINCT client.client_id) FROM     client JOIN     events ON client.client_id = events.client_id JOIN     callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id JOIN     reviews ON reviews.district_id = client.district_id WHERE     client.age < 35     AND events.product = 'Eagle National Mortgage'     AND reviews.stars = 1;
SELECT COUNT(*) FROM     client JOIN     callcenterlogs ON client.client_id = callcenterlogs.rand_client JOIN     events ON events.client_id = client.client_id AND events.complaint_id = callcenterlogs.complaint_id WHERE     client.sex = 'Male'     AND strftime('%Y', client.year) = '1977'     AND callcenterlogs.priority = 0;
SELECT client.first FROM client JOIN events ON events.client_id = client.client_id WHERE events.tags LIKE '%Older American%' AND events."Consumer consent provided?" NOT IN ('N/A', null, 'empty');
SELECT state.state FROM state JOIN district ON state.statecode = district.state_abbrev JOIN client ON district.district_id = client.district_id JOIN events ON client.client_id = events.client_id JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id WHERE callcenterlogs.priority = 0 GROUP BY state.state ORDER BY COUNT(callcenterlogs."Complaint ID") DESC LIMIT 1;
SELECT COUNT(DISTINCT events.complaint_id) FROM     events     JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id     JOIN client ON events.client_id = client.client_id     JOIN district ON client.district_id = district.district_id WHERE     client.sex = 'Female'     AND callcenterlogs.ser_time BETWEEN '15:00:01' AND '23:59:59'     AND events."Timely response?" = 'Yes';
SELECT COUNT(*) FROM     events JOIN     callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id JOIN     client ON events.client_id = client.client_id JOIN     district ON client.district_id = district.district_id WHERE     callcenterlogs.server = 'DORIT'     AND callcenterlogs.ser_time < '00:05:00'     AND events."Company response to consumer" = 'Closed with explanation'     AND events."Submitted via" = 'Phone';
SELECT COUNT(client.client_id) FROM client JOIN district ON client.district_id = district.district_id JOIN state ON district.state_abbrev = state.statecode WHERE client.last = 'Alvarado' AND state.state = 'Maryland';
SELECT COUNT(reviews.review) FROM     reviews JOIN     district ON reviews.district_id = district.district_id JOIN     client ON client.district_id = district.district_id WHERE     client.age BETWEEN 30 AND 50 AND     reviews.reviews LIKE '%Great%';
SELECT client.address_1 || ', ' || client.address_2 AS full_address FROM client JOIN events ON events.client_id = client.client_id JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id WHERE callcenterlogs.timely_response = 'Yes' AND events.consumer_disputed = 'Yes';
SELECT COUNT(*) FROM events JOIN client ON events.client_id = client.client_id WHERE client.sex = 'Female' AND strftime('%Y', client.birthdate) = '2000' AND events.submitted_via != 'Web';
SELECT events.consumer complaint narrative FROM events JOIN client ON events.client_id = client.client_id WHERE client.first = 'Brenda' AND client.last = 'Mayer';
SELECT COUNT(*) FROM events JOIN client ON events.client_id = client.client_id WHERE events.date_received BETWEEN '2017-01-02' AND '2017-02-28' AND client.email LIKE '%gmail.com';
SELECT AVG(stars) AS average_stars FROM     reviews JOIN     district ON reviews.district_id = district.district_id JOIN     state ON district.state_abbrev = state.statecode WHERE     state.state = 'Oregon';
SELECT (     SELECT         (COUNT(DISTINCT client_id) * 1.0 / (SELECT COUNT(*) FROM client WHERE "Submitted via" = 'Postal mail')) * 100 AS percentage      FROM          events      WHERE          "Submitted via" = 'Postal mail'          AND strftime('%Y', 'now') - year > 50 ) AS percentage; 
SELECT AVG(age)  FROM      client  JOIN      district ON client.district_id = district.district_id  JOIN      state ON district.state_abbrev = state.statecode  WHERE      district.city = 'Norwalk';
SELECT COUNT(DISTINCT client.client_id) AS num_clients FROM     client JOIN     district ON client.district_id = district.district_id JOIN     state ON district.state_abbrev = state.statecode JOIN     reviews ON district.district_id = reviews.district_id WHERE     district.city = 'Kansas City'     AND reviews.stars = 1;
SELECT state.statecode FROM state JOIN district ON state.statecode = district.state_abbrev JOIN client ON client.district_id = district.district_id JOIN reviews ON reviews.district_id = district.district_id WHERE reviews.stars = 5 GROUP BY state.statecode ORDER BY COUNT(client.client_id) DESC LIMIT 1;
SELECT region FROM client JOIN district ON client.district_id = district.district_id JOIN state ON district.state_abbrev = state.statecode WHERE client.first = 'Noah' AND client.last = 'Thompson';
SELECT submitted_via FROM     events JOIN     client ON events.client_id = client.client_id JOIN     callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id JOIN     district ON client.district_id = district.district_id WHERE     client.first = 'Kyran' AND client.last = 'Muller';
SELECT events.product FROM events JOIN client ON events.client_id = client.client_id WHERE client.year > 2005;
SELECT ser_time FROM     events JOIN     client ON events.client_id = client.client_id JOIN     callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id JOIN     district ON client.district_id = district.district_id WHERE     client.first = 'Kendall' AND client.last = 'Allen'     AND events.product = 'Credit Card';
SELECT events.issue FROM events JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id WHERE callcenterlogs.ser_time = (     SELECT MAX(ser_time) FROM callcenterlogs )
SELECT COUNT(DISTINCT client.client_id) FROM client JOIN district ON client.district_id = district.district_id JOIN state ON district.state_abbrev = state.statecode JOIN events ON events.client_id = client.client_id JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id WHERE district.city = 'New York City' AND events.submitted_via = 'Fax';
SELECT (MULTIPLY(DIVIDE((SELECT COUNT(DISTINCT c.client_id) FROM client c JOIN events e ON e.client_id = c.client_id JOIN callcenterlogs cl ON cl.complaint_id = e.complaint_id WHERE c.sex = 'Male' AND e.product = 'Credit card'), (SELECT COUNT(DISTINCT c.client_id) FROM client c)), 1.0) AS percentage_male_complaining_credit_cards;
SELECT client.first, client.middle, client.last FROM events JOIN client ON events.client_id = client.client_id JOIN callcenterlogs ON events.complaint id = callcenterlogs.complaint id WHERE events.tags LIKE '%Older American%' AND events.consumer consent provided? IN (null, 'N/A', 'empty')
SELECT MAX(year || '-' || month || '-' || day) AS birth_date FROM client;
SELECT COUNT(*) FROM     events WHERE     consumer_disputed = 'No'     AND timely_response = 'No';
SELECT COUNT(*)  FROM callcenterlogs WHERE ser_time > '00:15:00';
SELECT MAX(count(issue)) AS most_common_issue FROM events JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id WHERE callcenterlogs.priority = 2 GROUP BY events.issue
SELECT client.first || ' ' || client.last AS full_name FROM client JOIN district ON client.district_id = district.district_id JOIN state ON district.state_abbrev = state.statecode WHERE state.region = 'Pacific';
SELECT MAX(client.social) AS social_number FROM     events JOIN     client ON events.client_id = client.client_id GROUP BY     events.client_id ORDER BY     COUNT(events.complaint_id) DESC LIMIT 1;
SELECT city FROM   district JOIN   reviews ON district.district_id = reviews.district_id WHERE   stars = 1 GROUP BY   city ORDER BY   COUNT(state_abbrev) DESC LIMIT 1;
SELECT client.address_1, client.address_2, client.city, client.state, client.zipcode FROM client JOIN events ON client.client_id = events.client_id JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id WHERE events.submitted_via = 'Postal mail' AND callcenterlogs.date_received = '2012-03-14';
SELECT COUNT(DISTINCT client.client_id) FROM     client JOIN     events ON events.client_id = client.client_id JOIN     callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id WHERE     client.sex = 'Female'     AND callcenterlogs.priority = 1;
SELECT server FROM callcenterlogs JOIN events ON callcenterlogs.complaint_id = events.complaint_id WHERE events.submitted_via = 'Phone' AND events.timely_response = 'No';
SELECT issue FROM     events JOIN     client ON events.client_id = client.client_id WHERE     client.first = 'Kaitlyn' AND client.middle = 'Eliza' AND client.last = 'Elliott';
SELECT state.state FROM state JOIN district ON district.state_abbrev = state.statecode JOIN client ON client.district_id = district.district_id WHERE client.email = 'skylar.ramirez@gmail.com'; 
SELECT region, COUNT(client.client_id) AS client_count FROM region JOIN district ON region.region = district.division JOIN client ON district.district_id = client.district_id GROUP BY region ORDER BY client_count DESC LIMIT 1 OFFSET 1;
SELECT client.first, client.middle, client.last FROM callcenterlogs JOIN client ON callcenterlogs.rand_client = client.client_id JOIN events ON events.complaint_id = callcenterlogs.complaint_id JOIN state ON state.statecode = district.state_abbrev JOIN district ON district.district_id = client.district_id WHERE callcenterlogs.server = 'MORIAH' AND callcenterlogs.date_received = '2013-09-11';
SELECT ROUND(AVG(CASE                  WHEN age BETWEEN 13 AND 19 THEN ser_time                 ELSE NULL             END) / 60, 2) AS teenager_avg_time,        ROUND(AVG(CASE                  WHEN age > 19 AND age <= 65 THEN ser_time                 ELSE NULL             END) / 60, 2) AS adult_avg_time,        ROUND(AVG(CASE                  WHEN age > 65 THEN ser_time                 ELSE NULL             END) / 60, 2) AS elder_avg_time FROM callcenterlogs JOIN client ON callcenterlogs.rand_client = client.client_id JOIN district ON client.district_id = district.district_id JOIN state ON district.state_abbrev = state.statecode JOIN events ON events.client_id = client.client_id AND events.complaint_id = callcenterlogs.complaint_id GROUP BY CASE              WHEN age BETWEEN 13 AND 19 THEN 'Teenager'             WHEN age > 19 AND age <= 65 THEN 'Adult'             WHEN age > 65 THEN 'Elder'             ELSE 'Unknown'         END;
SELECT ROUND((SUM(CASE WHEN age <= 65 THEN 1 ELSE 0 END) * 100.0 / COUNT(client_id)), 2) AS percentage_of_elderly_complaints FROM events JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id JOIN client ON events.client_id = client.client_id JOIN district ON client.district_id = district.district_id JOIN state ON district.state_abbrev = state.statecode;
SELECT ROUND((COUNT(client.client_id) * 100.0) / (SELECT COUNT(client.client_id) FROM client INNER JOIN district ON client.district_id = district.district_id WHERE district.city = 'Indianapolis'), 2) AS "Percentage of Male Clients from Indianapolis City" FROM client  INNER JOIN district ON client.district_id = district.district_id  WHERE client.sex = 'Male' AND district.city = 'Indianapolis';
SELECT COUNT(CASE WHEN client.age > 13 AND client.age <= 19 AND client.email LIKE '%@gmail.com' THEN client.client_id END) AS google_accounts, COUNT(CASE WHEN client.age > 13 AND client.age <= 19 AND client.email LIKE '%@outlook.com' THEN client.client_id END) AS microsoft_accounts FROM client WHERE client.age > 13 AND client.age <= 19;
SELECT client.first || ' ' || client.middle || ' ' || client.last AS full_name FROM client WHERE client.email = 'emily.garcia43@outlook.com';
SELECT client.first FROM client JOIN callcenterlogs ON callcenterlogs.rand_client = client.client_id WHERE callcenterlogs.priority = 2 ORDER BY client.first LIMIT 1;
SELECT client.email FROM client JOIN events ON events.client_id = client.client_id JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id WHERE callcenterlogs.type = 'PS'; 
SELECT client.last FROM     client JOIN     events ON client.client_id = events.client_id JOIN     callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id WHERE     client.age <= 65     AND callcenterlogs.server = 'YIFAT'
SELECT COUNT(DISTINCT client.client_id) FROM     client JOIN     district ON client.district_id = district.district_id JOIN     state ON district.state_abbrev = state.statecode JOIN     callcenterlogs ON client.client_id = callcenterlogs.rand_client JOIN     events ON events.client_id = client.client_id WHERE     district.city = 'New York City'     AND callcenterlogs.outcome = 'AGENT';
SELECT client.first || ' ' || client.middle || ' ' || client.last AS full_name FROM client JOIN events ON events.client_id = client.client_id JOIN callcenterlogs ON events.complaint id = callcenterlogs.complaint id WHERE callcenterlogs.outcome = 'Yes';
SELECT events.complaint_id FROM client JOIN events ON client.client_id = events.client_id WHERE client.year = 1931; 
SELECT (COUNT(events.complaint_id) * 100.0 / COUNT(callcenterlogs.complaint_id)) AS percentage_of_complaints FROM events JOIN client ON events.client_id = client.client_id JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id WHERE client.email LIKE '%@gmail.com' AND callcenterlogs.server = 'ZOHARI';
SELECT client.first || ' ' || client.middle || ' ' || client.last AS full_name FROM callcenterlogs JOIN client ON callcenterlogs.rand_client = client.client_id WHERE callcenterlogs.ser_time > '00:20:00';
SELECT client.last FROM client JOIN callcenterlogs ON client.client_id = callcenterlogs.rand_client WHERE callcenterlogs.priority = 0 LIMIT 5;
SELECT call_id FROM     callcenterlogs JOIN client ON callcenterlogs.rand_client = client.client_id WHERE     client.first LIKE 'B%' 
SELECT product FROM events JOIN client ON events.client_id = client.client_id JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id JOIN district ON client.district_id = district.district_id WHERE client.first = 'Alexander' AND client.middle = 'Bronx' AND client.last = 'Lewis';
SELECT client.first FROM client JOIN callcenterlogs ON client.client_id = callcenterlogs.rand_client JOIN events ON client.client_id = events.client_id WHERE client.sex = 'Male' AND callcenterlogs.timely_response? = 'No'
SELECT product, COUNT(*) AS complaint_count FROM events JOIN client ON events.client_id = client.client_id WHERE client.age > 65 GROUP BY product ORDER BY complaint_count DESC LIMIT 1;
SELECT COUNT(CASE     WHEN client.age > 13 AND client.age <= 19 THEN 1     ELSE 0 END) AS teenager_count, COUNT(CASE     WHEN client.age > 19 AND client.age <= 65 THEN 1     ELSE 0 END) AS adult_count, COUNT(CASE     WHEN client.age > 65 THEN 1     ELSE 0 END) AS elder_count FROM     events JOIN     callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id JOIN     client ON events.client_id = client.client_id WHERE     events.product = 'Credit Card';
SELECT events.issue FROM events JOIN callcenterlogs ON events.complaint id = callcenterlogs.complaint id WHERE callcenterlogs.ser_time < '00:10:00'; 
SELECT events.date_received FROM events JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id WHERE events.submitted_via = 'Fax'; 
SELECT client.first || ' ' || client.middle || ' ' || client.last AS full_name FROM events JOIN client ON events.client_id = client.client_id WHERE events.issue = 'Balance transfer';
SELECT client.email FROM client JOIN events ON client.client_id = events.client_id WHERE events.submitted via = 'Postal mail';
SELECT AVG(client.age)  FROM      client  JOIN      events ON client.client_id = events.client_id  JOIN      callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id  WHERE      callcenterlogs.outcome = 'Closed with relief';
SELECT AVG(age) FROM     client WHERE     client_id IN (         SELECT            client_id         FROM             events         JOIN             callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id         WHERE             events.type = 'TT'     );
SELECT complaint_id, call_id, phonefinal FROM     callcenterlogs WHERE     server = 'AVIDAN' AND     date_received BETWEEN '2014-01-01' AND '2014-12-30';
SELECT AVG(ser_time) FROM callcenterlogs WHERE server = 'DARMON' AND date_received BETWEEN '2017-01-01' AND '2017-04-01';
SELECT COUNT(DISTINCT strftime('%Y', date_received)) AS "Complaints Per Year" FROM     events WHERE     product = 'Credit card'     AND issue = 'Overlimit fee';
SELECT COUNT(DISTINCT client.client_id) FROM     client JOIN     district ON client.district_id = district.district_id JOIN     state ON district.state_abbrev = state.statecode WHERE     district.division = 'Middle Atlantic'     AND client.sex = 'Female'     AND client.age <= 18;
SELECT client.year || '-' || client.month || '-' || client.day AS full_birthdate, client.email, client.phone FROM client JOIN district ON client.district_id = district.district_id WHERE district.city = 'Indianapolis' ORDER BY client.year DESC, client.month DESC, client.day DESC LIMIT 1;
SELECT city, COUNT(stars) AS num_5_star_ratings FROM reviews JOIN district ON reviews.district_id = district.district_id WHERE stars = 5 AND date LIKE '2016%' GROUP BY city ORDER BY num_5_star_ratings DESC LIMIT 5; 
SELECT MAX(ser_time) FROM callcenterlogs JOIN events ON events.complaint_id = callcenterlogs.complaint_id WHERE events.issue = 'arbitration'
SELECT social, state FROM client JOIN district ON client.district_id = district.district_id JOIN state ON district.state_abbrev = state.statecode WHERE client.phone = '100-121-8371';
SELECT client.first || ' ' || client.middle || ' ' || client.last AS full_name, client.phone AS phone FROM client JOIN district ON client.district_id = district.district_id JOIN state ON district.state_abbrev = state.statecode WHERE district.division = 'Pacific';
SELECT MAX(Social) AS Social_Number, MAX(julianday(Date_Sent_to_Company) - julianday(Date_Received)) AS Days_of_Delay, Company_Response_to_Consumer FROM events JOIN callcenterlogs ON events.Complaint_ID = callcenterlogs.Complaint_ID WHERE Date_Sent_to_Company IS NOT NULL GROUP BY Social_Number, Company_Response_to_Consumer ORDER BY Days_of_Delay DESC LIMIT 1;
SELECT COUNT(DISTINCT client.client_id) FROM     client WHERE     client.sex = 'Female'     AND client.age > 30;
SELECT client.first, client.last FROM client JOIN district ON client.district_id = district.district_id JOIN state ON district.state_abbrev = state.statecode WHERE district.city = 'New York City';
SELECT MAX(age)  FROM      client  WHERE      sex = 'Male';
SELECT COUNT(client.client_id) AS client_count, state.division FROM client JOIN district ON client.district_id = district.district_id JOIN state ON district.state_abbrev = state.statecode GROUP BY state.division;
SELECT ROUND((COUNT(client.client_id) * 100.0) / (SELECT COUNT(client.client_id) FROM client INNER JOIN district ON client.district_id = district.district_id INNER JOIN state ON district.state_abbrev = state.statecode WHERE district.division = 'Middle Atlantic'), 2) AS percentage_female_clients FROM client INNER JOIN district ON client.district_id = district.district_id INNER JOIN state ON district.state_abbrev = state.statecode WHERE client.sex = 'Female' AND district.division = 'Middle Atlantic';
SELECT AVG(age) FROM client JOIN district ON client.district_id = district.district_id JOIN state ON district.state_abbrev = state.statecode WHERE district.division = 'South Atlantic';
SELECT city FROM   district JOIN   state ON district.state_abbrev = state.statecode WHERE   region = 'Midwest' GROUP BY   city ORDER BY   COUNT(client_id) LIMIT   1; 
SELECT COUNT(DISTINCT client.client_id) FROM client JOIN district ON client.district_id = district.district_id JOIN state ON district.state_abbrev = state.statecode WHERE state.region = 'Northeast' AND client.email LIKE '%@outlook.com';
SELECT MAX(city) AS city_with_highest_customers_over_60 FROM     (     SELECT        city,         COUNT(client.client_id) AS num_customers_over_60     FROM         client     JOIN         district ON client.district_id = district.district_id     JOIN         state ON district.state_abbrev = state.statecode     WHERE         state.region = 'North Central'         AND client.age > 60     GROUP BY         city     ) AS city_customers_over_60;
SELECT (ROUND(CAST(COUNT(DISTINCT callcenterlogs.complaint_id) AS FLOAT) / COUNT(DISTINCT events.complaint_id), 4) * 100) AS percentage_of_late_fee_complaints_2017 FROM     callcenterlogs JOIN     events ON callcenterlogs.complaint_id = events.complaint_id WHERE     callcenterlogs.priority = 2 AND     strftime('%Y', callcenterlogs.date_received) = '2017' AND     events.issue = 'Late fee';
SELECT state.statecode AS state_abbrev, COUNT(DISTINCT district.city) AS num_cities FROM state JOIN district ON district.state_abbrev = state.statecode GROUP BY state.statecode ORDER BY num_cities DESC LIMIT 1;
SELECT client.first, client.phone FROM client JOIN callcenterlogs ON client.client_id = callcenterlogs.rand_client WHERE callcenterlogs.complaint_id = 'CR0922485';
SELECT client.email FROM     client JOIN     events ON client.client_id = events.client_id JOIN     callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id WHERE     callcenterlogs.date_received = '2014-07-03';
SELECT COUNT(*) FROM events JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id JOIN client ON events.client_id = client.client_id JOIN district ON client.district_id = district.district_id JOIN state ON district.state_abbrev = state.statecode WHERE events.product = 'Credit card' AND events.date_received LIKE '2012%' AND district.city = 'Omaha';
SELECT COUNT(*)  FROM      events      JOIN client ON events.client_id = client.client_id  WHERE      events.date_received BETWEEN '2012-01-01' AND '2015-12-31'      AND client.sex = 'Female'      AND events.submitted_via = 'Email';
SELECT client.phone, events.complaint_id FROM     client JOIN     events ON client.client_id = events.client_id JOIN     callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id WHERE     callcenterlogs.outcome = 'In progress';
SELECT COUNT(events.complaint id) FROM events JOIN client ON events.client_id = client.client_id JOIN callcenterlogs ON events.complaint id = callcenterlogs.complaint id JOIN district ON client.district_id = district.district_id WHERE events.date received LIKE '2015%' AND events.issue = 'Billing disputes' AND district.city = 'Portland';
SELECT 100 * (     SELECT COUNT(*)      FROM events      JOIN client ON events.client_id = client.client_id      JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id      JOIN district ON client.district_id = district.district_id      WHERE district.city = 'Houston'      AND events.date_received LIKE '2014%'      AND (julianday(callcenterlogs.date_sent_to_company) - julianday(events.date_received)) > 5 ) / (     SELECT COUNT(*)      FROM events      JOIN client ON events.client_id = client.client_id      JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id      JOIN district ON client.district_id = district.district_id      WHERE district.city = 'Houston'      AND events.date_received LIKE '2014%' ) AS percentage_of_delayed_complaints;
SELECT COUNT(*) FROM     events WHERE     Date_received LIKE '2012%'     AND     Submitted_via = 'Email';
SELECT events.client_id FROM events JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id WHERE events.date_received = '2014-04-16' AND events.submitted_via = 'Fax';
SELECT events.date_received FROM events JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id JOIN client ON events.client_id = client.client_id JOIN district ON client.district_id = district.district_id JOIN reviews ON district.district_id = reviews.district_id WHERE events.product = 'Eagle Capital' AND district.city = 'Indianapolis' AND district.state_abbrev = 'IN';
SELECT COUNT(*) FROM     events WHERE     Date_Received LIKE '2015%'     AND "Timely response?" = 'Yes'     AND "Company response to consumer" = 'Closed with explanation';
SELECT date received FROM     events JOIN     client ON events.client_id = client.client_id WHERE     client.sex = 'Female'     AND client.age BETWEEN 20 AND 40;
SELECT events.product FROM events JOIN reviews ON events.client_id = reviews.district_id JOIN district ON reviews.district_id = district.district_id WHERE reviews.stars = 1 AND events.date_received = '2016-03-14' AND district.city = 'Newton' AND district.state_abbrev = 'MA';
SELECT COUNT(*) FROM reviews JOIN district ON reviews.district_id = district.district_id WHERE reviews.stars = 5 AND reviews.product = 'Eagle National Bank' AND district.city = 'Nashville' AND district.state_abbrev = 'TN';
SELECT events.issue FROM events JOIN client ON events.client_id = client.client_id WHERE client.sex = 'Male' AND client.age < 25 
SELECT events.product FROM events JOIN callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id JOIN client ON events.client_id = client.client_id JOIN district ON client.district_id = district.district_id JOIN state ON district.state_abbrev = state.statecode JOIN reviews ON district.district_id = reviews.district_id WHERE state.region = 'midwest' AND reviews.stars = 1;
SELECT DISTINCT events.product FROM   events JOIN   callcenterlogs ON events.complaint id = callcenterlogs.complaint id WHERE   callcenterlogs.date received LIKE '%03%2017%'   AND callcenterlogs.server = 'TOVA';
SELECT division FROM     reviews JOIN district ON reviews.district_id = district.district_id WHERE     stars = 5     AND date = '2017-12-17'     AND product = 'Eagle National Mortgage';
SELECT client.phone FROM     client JOIN     events ON client.client_id = events.client_id JOIN     callcenterlogs ON events.complaint_id = callcenterlogs.complaint_id WHERE     events.product = 'credit card' ORDER BY     client.age DESC LIMIT     1;
SELECT COUNT(*) FROM     events WHERE     date_received LIKE '2014%'     AND submitted_via = 'Phone';
SELECT events.product, events.issue FROM events INNER JOIN client ON events.client_id = client.client_id WHERE client.age > (SELECT AVG(age) * 0.6 FROM client)
SELECT 100 * COUNT(*) / (SELECT COUNT(*) FROM reviews WHERE stars = 5 AND district_id IN (SELECT district_id FROM district WHERE division = 'East North Central')) FROM reviews WHERE stars = 5;
SELECT production_company.company_name FROM movie JOIN movie_company ON movie.movie_id = movie_company.movie_id JOIN production_company ON movie_company.company_id = production_company.company_id WHERE movie.title = 'Four Rooms';
SELECT COUNT(DISTINCT movie_company.company_id) AS production_company_count FROM     movie JOIN     movie_company ON movie.movie_id = movie_company.movie_id WHERE     movie.title = 'Four Rooms';
SELECT movie.title FROM movie JOIN movie_company ON movie.movie_id = movie_company.movie_id JOIN production_company ON movie_company.company_id = production_company.company_id WHERE production_company.company_name = 'Universal Pictures'; 
SELECT movie.title FROM movie JOIN movie_company ON movie.movie_id = movie_company.movie_id JOIN production_company ON movie_company.company_id = production_company.company_id WHERE production_company.company_name = 'Universal Pictures' ORDER BY movie.release_date DESC LIMIT 1;
SELECT person.person_name FROM     person JOIN     movie_crew ON person.person_id = movie_crew.person_id JOIN     movie ON movie_crew.movie_id = movie.movie_id JOIN     department ON movie_crew.department_id = department.department_id WHERE     movie.title = 'Pirates of the Caribbean: At World''s End'     AND department.department_name = 'Camera'     AND movie_crew.job = 'Director of Photography';
SELECT job FROM     movie_crew JOIN     movie ON movie_crew.movie_id = movie.movie_id JOIN     person ON movie_crew.person_id = person.person_id WHERE     movie.title = 'Pirates of the Caribbean: At World''s End'     AND person.person_name = 'Dariusz Wolski'
SELECT person.person_name FROM movie JOIN movie_crew ON movie.movie_id = movie_crew.movie_id JOIN person ON movie_crew.person_id = person.person_id WHERE movie.title = 'Pirates of the Caribbean: At World''s End';
SELECT COUNT(DISTINCT movie_crew.person_id) AS num_producers FROM     movie_crew JOIN     movie ON movie_crew.movie_id = movie.movie_id JOIN     person ON movie_crew.person_id = person.person_id WHERE     movie.title = 'Pirates of the Caribbean: At World''s End'     AND movie_crew.job = 'Producer';
SELECT person.person_name FROM movie JOIN movie_crew ON movie.movie_id = movie_crew.movie_id JOIN person ON movie_crew.person_id = person.person_id WHERE movie.title = 'Pirates of the Caribbean: At World''s End' AND movie_crew.job = 'Producer';
SELECT COUNT(DISTINCT movie.movie_id) FROM     movie_crew     JOIN movie ON movie_crew.movie_id = movie.movie_id     JOIN person ON movie_crew.person_id = person.person_id     JOIN department ON movie_crew.department_id = department.department_id WHERE     person.person_name = 'Dariusz Wolski'     AND department.department_name = 'Director of Photography';
SELECT movie.title FROM     movie JOIN     movie_crew ON movie.movie_id = movie_crew.movie_id JOIN     person ON movie_crew.person_id = person.person_id WHERE     person.person_name = 'Dariusz Wolski'     AND movie_crew.job = 'Director of Photography' GROUP BY     movie.title ORDER BY     AVG(movie.vote_average) DESC LIMIT 1;
SELECT MAX(movie.release_date) FROM     movie JOIN     movie_crew ON movie.movie_id = movie_crew.movie_id JOIN     person ON movie_crew.person_id = person.person_id WHERE     person.person_name = 'Dariusz Wolski'
SELECT ROUND((CAST((SELECT COUNT(DISTINCT mc.movie_id) FROM movie_crew mc JOIN person p ON mc.person_id = p.person_id JOIN department d ON mc.department_id = d.department_id WHERE p.person_name = 'Dariusz Wolski' AND mc.job = 'Director of Photography' AND mc.movie_id IN (     SELECT movie_id     FROM movie     WHERE vote_average > 5.0 )) AS REAL) / (SELECT COUNT(DISTINCT mc.movie_id) FROM movie_crew mc JOIN person p ON mc.person_id = p.person_id JOIN department d ON mc.department_id = d.department_id WHERE p.person_name = 'Dariusz Wolski' AND mc.job = 'Director of Photography') * 100, 2) AS percentage; 
SELECT AVG(m.revenue) AS average_revenue FROM movie AS m JOIN movie_crew AS mc ON m.movie_id = mc.movie_id JOIN person AS p ON mc.person_id = p.person_id JOIN department AS d ON mc.department_id = d.department_id WHERE p.person_name = 'Dariusz Wolski' AND d.department_name = 'Director of Photography';
SELECT title FROM movie WHERE revenue = '559852396';
SELECT job FROM     movie_crew JOIN     movie ON movie_crew.movie_id = movie.movie_id JOIN     person ON movie_crew.person_id = person.person_id WHERE     movie.title = 'Days of Thunder'     AND person.person_name = 'David Rubin';
SELECT COUNT(DISTINCT movie.movie_id) FROM     movie_crew JOIN     movie ON movie_crew.movie_id = movie.movie_id JOIN     person ON movie_crew.person_id = person.person_id WHERE     person.person_name = 'Michael Bay'     AND movie_crew.job = 'Director';
SELECT COUNT(keyword_id) AS total_keywords FROM movie JOIN movie_keywords ON movie.movie_id = movie_keywords.movie_id JOIN keyword ON movie_keywords.keyword_id = keyword.keyword_id WHERE title = 'I Hope They Serve Beer in Hell';
SELECT person.person_name FROM     person JOIN     movie_crew ON person.person_id = movie_crew.person_id JOIN     movie ON movie_crew.movie_id = movie.movie_id WHERE     movie.title = 'Land of the Dead' AND     movie_crew.job = 'Director';
SELECT COUNT(movie_company.movie_id) FROM     movie_company JOIN     production_company ON movie_company.company_id = production_company.company_id WHERE     production_company.company_name = 'Paramount Animation';
SELECT COUNT(movie_cast.person_id) FROM     movie_cast JOIN     movie ON movie_cast.movie_id = movie.movie_id JOIN     person ON movie_cast.person_id = person.person_id JOIN     gender ON movie_cast.gender_id = gender.gender_id WHERE     movie.title = 'Spider-Man 3'     AND gender.gender = 'Female';
SELECT keyword_name FROM     keyword GROUP BY     keyword_name ORDER BY     COUNT(*) DESC LIMIT 1;
SELECT COUNT(DISTINCT movie_crew.person_id) AS num_producers FROM     movie JOIN     movie_crew ON movie.movie_id = movie_crew.movie_id JOIN     person ON movie_crew.person_id = person.person_id WHERE     movie.title = 'The Amityville Horror'     AND movie_crew.job = 'Producer';
SELECT production_company.company_name FROM movie JOIN movie_company ON movie.movie_id = movie_company.movie_id JOIN production_company ON movie_company.company_id = production_company.company_id WHERE movie.title = 'Crazy Heart';
SELECT COUNT(movie_keywords.movie_id) FROM     movie_keywords JOIN     keyword ON movie_keywords.keyword_id = keyword.keyword_id WHERE     keyword.keyword_name = 'saving the world';
SELECT movie.title FROM movie JOIN movie_company ON movie.movie_id = movie_company.movie_id JOIN production_company ON movie_company.company_id = production_company.company_id WHERE production_company.company_name = 'Cruel and Unusual Films' ORDER BY movie.popularity DESC LIMIT 1;
SELECT department.department_name FROM movie JOIN movie_crew ON movie.movie_id = movie_crew.movie_id JOIN person ON movie_crew.person_id = person.person_id JOIN department ON movie_crew.department_id = department.department_id WHERE movie.title = 'Reign of Fire' AND person.person_name = 'Marcia Ross';
SELECT AVG(movie.budget) AS average_budget FROM movie JOIN movie_crew ON movie.movie_id = movie_crew.movie_id JOIN person ON movie_crew.person_id = person.person_id WHERE person.person_name = 'Jaume Collet-Serra' AND movie_crew.job = 'Director';
SELECT ((COUNT(CASE WHEN movie.title = 'Bride Wars' AND movie_cast.gender_id = gender.gender_id AND gender.gender = 'Male' THEN 1 END)) / COUNT(movie_cast.gender_id)) * 100 AS percentage
SELECT title FROM movie WHERE budget = (     SELECT        MAX(budget)     FROM         movie ); 
SELECT COUNT(DISTINCT movie.movie_id) FROM     movie WHERE     revenue > 1000000000;
SELECT MIN(release_date) AS first_movie_release_date FROM movie;
SELECT COUNT(*) FROM     movie_crew JOIN     person ON movie_crew.person_id = person.person_id WHERE     person.person_name = 'John Young'; 
SELECT title FROM movie ORDER BY popularity DESC LIMIT 1; 
SELECT person_name FROM     person WHERE     person_id = 1325273;
SELECT company_name FROM production_company GROUP BY company_name ORDER BY COUNT(*) DESC LIMIT 1; 
SELECT person.person_name FROM     person JOIN     movie_cast ON person.person_id = movie_cast.person_id JOIN     movie ON movie_cast.movie_id = movie.movie_id WHERE     movie.title LIKE 'Pirates of the Caribbean%'     AND movie_cast.character_name = 'Captain Jack Sparrow';
SELECT MAX(movie.popularity) AS max_popularity FROM     movie JOIN     movie_company ON movie.movie_id = movie_company.movie_id JOIN     production_company ON movie_company.company_id = production_company.company_id WHERE     production_company.company_name = 'Walt Disney Pictures';
SELECT COUNT(DISTINCT movie.movie_id) AS total_movies FROM     movie JOIN     movie_company ON movie.movie_id = movie_company.movie_id JOIN     production_company ON movie_company.company_id = production_company.company_id WHERE     production_company.company_name = 'Universal Studios';
SELECT production_company.company_name FROM     production_company JOIN     movie_company ON production_company.company_id = movie_company.company_id JOIN     movie ON movie_company.movie_id = movie.movie_id WHERE     movie.revenue = (         SELECT            MAX(revenue)         FROM             movie     );
SELECT COUNT(*) FROM     movie_crew JOIN person ON movie_crew.person_id = person.person_id JOIN gender ON movie_crew.gender_id = gender.gender_id JOIN movie ON movie_crew.movie_id = movie.movie_id WHERE     movie.title = 'Mr. Smith Goes to Washington'     AND gender.gender = 'Female'     AND movie_crew.job IS NOT NULL;
SELECT company_name FROM     production_company JOIN     movie_company ON production_company.company_id = movie_company.company_id GROUP BY     company_name HAVING     COUNT(movie_id) >= 200; 
SELECT COUNT(*) FROM     movie_cast JOIN person ON movie_cast.person_id = person.person_id WHERE     person.person_name = 'Harrison Ford';
SELECT title FROM     movie JOIN     movie_cast ON movie.movie_id = movie_cast.movie_id JOIN     person ON movie_cast.person_id = person.person_id WHERE     person.person_name = 'Jamie Foxx' ORDER BY     release_date DESC LIMIT 1;
SELECT COUNT(DISTINCT movie.movie_id) FROM     movie JOIN     movie_cast ON movie.movie_id = movie_cast.movie_id JOIN     person ON movie_cast.person_id = person.person_id WHERE     person.person_name = 'Quentin Tarantino'     AND movie.release_date LIKE '1995%'
SELECT title FROM     movie JOIN     movie_genres ON movie.movie_id = movie_genres.movie_id JOIN     genre ON movie_genres.genre_id = genre.genre_id WHERE     genre.genre_name = 'Crime' ORDER BY     release_date LIMIT     1;
SELECT COUNT(*) FROM     movie JOIN     movie_genres ON movie.movie_id = movie_genres.movie_id JOIN     genre ON movie_genres.genre_id = genre.genre_id WHERE     genre.genre_name = 'Horror';
SELECT movie_crew.person_id FROM movie_crew WHERE movie_crew.movie_id = 12 AND movie_crew.job = 'Second Film Editor' ORDER BY movie_crew.cast_order LIMIT 1 OFFSET 1; 
SELECT COUNT(*) AS animator_count FROM movie_crew WHERE movie_id = 129 AND job = 'Animation';
SELECT COUNT(*), job FROM movie_crew WHERE movie_id = 19 AND department_id = 7 GROUP BY job;
SELECT person.person_id, movie_cast.character_name FROM movie_cast JOIN person ON movie_cast.person_id = person.person_id WHERE movie_cast.movie_id = 285 AND movie_cast.cast_order BETWEEN 2 AND 9;
SELECT COUNT(*) FROM     movie_crew JOIN     person ON movie_crew.person_id = person.person_id WHERE     person.person_name = 'Bob Peterson';
SELECT COUNT(movie_cast.movie_id) AS movie_count, movie_cast.character_name FROM movie_cast JOIN person ON movie_cast.person_id = person.person_id WHERE person.person_name = 'Jim Carrey' GROUP BY movie_cast.movie_id, movie_cast.character_name; 
SELECT person.person_name FROM     person JOIN     movie_cast ON person.person_id = movie_cast.person_id JOIN     gender ON movie_cast.gender_id = gender.gender_id WHERE     movie_cast.movie_id = 1865     AND gender.gender = 'Female';
SELECT title FROM     movie INNER JOIN     movie_cast ON movie.movie_id = movie_cast.movie_id INNER JOIN     person ON movie_cast.person_id = person.person_id WHERE     person.person_name = 'Jim Carrey';
SELECT person.person_name FROM movie JOIN movie_crew ON movie.movie_id = movie_crew.movie_id JOIN person ON movie_crew.person_id = person.person_id WHERE movie_crew.job = 'Director' AND movie.release_date BETWEEN '1916-01-02' AND '1925-12-30';
SELECT COUNT(DISTINCT movie.movie_id) FROM     movie INNER JOIN     movie_cast ON movie.movie_id = movie_cast.movie_id INNER JOIN     person ON movie_cast.person_id = person.person_id WHERE     movie.release_date BETWEEN '1990-01-02' AND '2000-12-30'     AND person.person_name = 'Uma Thurman';
SELECT title FROM movie JOIN movie_genres ON movie.movie_id = movie_genres.movie_id JOIN genre ON movie_genres.genre_id = genre.genre_id WHERE genre_name = 'Horror' AND vote_average > 7; 
SELECT genre.genre_name, movie.popularity FROM movie INNER JOIN movie_genres ON movie.movie_id = movie_genres.movie_id INNER JOIN genre ON movie_genres.genre_id = genre.genre_id WHERE movie.revenue >= 120000000 AND movie.release_date BETWEEN '2012-01-01' AND '2015-12-31';
SELECT COUNT(DISTINCT movie.movie_id) FROM     movie     JOIN production_country ON movie.movie_id = production_country.movie_id     JOIN country ON production_country.country_id = country.country_id WHERE     country.country_name = 'India'     AND movie.release_date BETWEEN '1990-01-02' AND '2003-12-30'     AND movie.revenue > 75000000     AND movie.popularity >= 20;
SELECT   movie.title, movie.budget, country.country_name, movie.revenue FROM movie JOIN production_country ON movie.movie_id = production_country.movie_id JOIN country ON production_country.country_id = country.country_id WHERE movie.budget = (SELECT MAX(budget) FROM movie); 
SELECT title FROM     movie JOIN     movie_languages ON movie.movie_id = movie_languages.movie_id JOIN     language ON movie_languages.language_id = language.language_id WHERE     language.language_name = 'Latin'     AND movie.release_date BETWEEN '1990-01-01' AND '1995-12-31'; 
SELECT AVG(revenue) FROM     movie JOIN     production_country ON movie.movie_id = production_country.movie_id JOIN     country ON production_country.country_id = country.country_id WHERE     country.country_name = 'United States of America'     AND release_date LIKE '2006%'
SELECT (     SELECT         AVG(CASE WHEN country_name = 'United States of America' THEN revenue ELSE 0 END) -          AVG(CASE WHEN country_name = 'India' THEN revenue ELSE 0 END) AS revenue_gap     FROM          movie     WHERE          release_date LIKE '2016%' ) AS revenue_gap_2016;
SELECT (CAST(SUM(CASE WHEN g.genre_name = 'Romance' THEN 1 ELSE 0 END) AS FLOAT) / COUNT(m.movie_id)) * 100 AS percentage FROM movie AS m JOIN production_country AS pc ON m.movie_id = pc.movie_id JOIN country AS c ON pc.country_id = c.country_id JOIN movie_genres AS mg ON m.movie_id = mg.movie_id JOIN genre AS g ON mg.genre_id = g.genre_id WHERE c.country_name = 'India' AND m.release_date BETWEEN '2015-01-01' AND '2015-01-31'
SELECT person.person_name FROM person JOIN movie_cast ON person.person_id = movie_cast.person_id JOIN movie ON movie_cast.movie_id = movie.movie_id WHERE movie_cast.character_name = 'Optimus Prime (voice)'
SELECT gender.gender FROM movie_cast JOIN person ON movie_cast.person_id = person.person_id JOIN gender ON movie_cast.gender_id = gender.gender_id WHERE movie_cast.character_name = 'USAF Master Sgt. Epps';
SELECT production_company.company_name FROM production_company JOIN movie_company ON production_company.company_id = movie_company.company_id JOIN movie ON movie_company.movie_id = movie.movie_id WHERE movie.title = 'Ultramarines: A Warhammer 40,000 Movie';
SELECT movie.title FROM movie INNER JOIN movie_company ON movie.movie_id = movie_company.movie_id INNER JOIN production_company ON movie_company.company_id = production_company.company_id WHERE production_company.company_name = 'Radiant Film GmbH';
SELECT genre.genre_name FROM movie JOIN movie_genres ON movie.movie_id = movie_genres.movie_id JOIN genre ON movie_genres.genre_id = genre.genre_id WHERE movie.title = 'Sky Captain and the World of Tomorrow'; 
SELECT keyword.keyword_name FROM movie JOIN movie_keywords ON movie.movie_id = movie_keywords.movie_id JOIN keyword ON movie_keywords.keyword_id = keyword.keyword_id WHERE movie.title = 'Sky Captain and the World of Tomorrow';
SELECT country.country_name FROM     movie     JOIN production_country ON movie.movie_id = production_country.movie_id     JOIN country ON production_country.country_id = country.country_id WHERE     movie.title = 'Gojira ni-sen mireniamu';
SELECT movie.title FROM movie JOIN movie_keywords ON movie.movie_id = movie_keywords.movie_id JOIN keyword ON movie_keywords.keyword_id = keyword.keyword_id WHERE keyword.keyword_name = 'extremis';
SELECT title FROM movie INNER JOIN production_country ON movie.movie_id = production_country.movie_id INNER JOIN country ON production_country.country_id = country.country_id WHERE country.country_name = 'France' LIMIT 10; 
SELECT person.person_name FROM movie_crew JOIN movie ON movie_crew.movie_id = movie.movie_id JOIN person ON movie_crew.person_id = person.person_id JOIN department ON movie_crew.department_id = department.department_id WHERE movie.title = 'Transformers' AND department.department_name = 'Director';
SELECT person.person_name, movie_crew.job FROM movie JOIN movie_crew ON movie.movie_id = movie_crew.movie_id JOIN person ON movie_crew.person_id = person.person_id WHERE movie.title = 'Mad Max: Fury Road' LIMIT 10;
SELECT 100 * (     SELECT COUNT(*)      FROM movie     INNER JOIN production_country ON movie.movie_id = production_country.movie_id     INNER JOIN country ON production_country.country_id = country.country_id     INNER JOIN movie_genres ON movie.movie_id = movie_genres.movie_id     INNER JOIN genre ON movie_genres.genre_id = genre.genre_id     WHERE country.country_name = 'Japan'     AND genre.genre_name = 'animation' ) / (     SELECT COUNT(*)      FROM movie     INNER JOIN production_country ON movie.movie_id = production_country.movie_id     INNER JOIN country ON production_country.country_id = country.country_id     WHERE country.country_name = 'Japan' ) as percentage;
SELECT COUNT(CASE WHEN movie.title = 'Iron Man' AND movie_cast.gender_id = (SELECT gender_id FROM gender WHERE gender = 'Female') THEN 1 END) / COUNT(CASE WHEN movie.title = 'Iron Man' AND movie_cast.gender_id = (SELECT gender_id FROM gender WHERE gender = 'Male') THEN 1 END) AS gender_ratio, COUNT(CASE WHEN movie.title = 'Iron Man' AND movie_cast.gender_id IS NULL THEN 1 END) AS unspecified_gender_count FROM movie_cast JOIN movie ON movie_cast.movie_id = movie.movie_id JOIN person ON movie_cast.person_id = person.person_id JOIN gender ON movie_cast.gender_id = gender.gender_id;
SELECT title FROM movie WHERE release_date < '2000-01-01' LIMIT 5; 
SELECT keyword.keyword_id FROM movie JOIN movie_keywords ON movie.movie_id = movie_keywords.movie_id JOIN keyword ON movie_keywords.keyword_id = keyword.keyword_id WHERE movie.title = 'Sin City';
SELECT movie.title FROM     movie JOIN     movie_keywords ON movie.movie_id = movie_keywords.movie_id JOIN     keyword ON movie_keywords.keyword_id = keyword.keyword_id WHERE     keyword.keyword_name = 'angel';
SELECT keyword.keyword_name FROM keyword JOIN movie_keywords ON keyword.keyword_id = movie_keywords.keyword_id JOIN movie ON movie_keywords.movie_id = movie.movie_id WHERE movie.popularity = (SELECT MAX(popularity) FROM movie);
SELECT genre.genre_id FROM movie JOIN movie_genres ON movie.movie_id = movie_genres.movie_id JOIN genre ON movie_genres.genre_id = genre.genre_id WHERE movie.title = 'The Dark Knight';
SELECT movie.title FROM movie JOIN movie_genres ON movie.movie_id = movie_genres.movie_id JOIN genre ON movie_genres.genre_id = genre.genre_id WHERE genre.genre_name = 'Thriller';
SELECT title FROM     movie JOIN     movie_genres ON movie.movie_id = movie_genres.movie_id JOIN     genre ON movie_genres.genre_id = genre.genre_id WHERE     movie_status = 'rumoured'     AND genre_name = 'Drama' LIMIT 5;
SELECT genre.genre_name FROM movie JOIN movie_genres ON movie.movie_id = movie_genres.movie_id JOIN genre ON movie_genres.genre_id = genre.genre_id WHERE movie.revenue = (SELECT MIN(revenue) FROM movie);
SELECT genre.genre_name FROM movie JOIN movie_genres ON movie.movie_id = movie_genres.movie_id JOIN genre ON movie_genres.genre_id = genre.genre_id WHERE movie.runtime = 14;
SELECT genre.genre_name FROM movie JOIN movie_genres ON movie.movie_id = movie_genres.movie_id JOIN genre ON movie_genres.genre_id = genre.genre_id WHERE movie.vote_average = (SELECT MAX(vote_average) FROM movie) AND movie.revenue = (SELECT MIN(revenue) FROM movie);
SELECT genre.genre_name FROM movie INNER JOIN movie_genres ON movie.movie_id = movie_genres.movie_id INNER JOIN genre ON movie_genres.genre_id = genre.genre_id WHERE movie.tagline = 'A long time ago in a galaxy far, far away…';
SELECT country.country_id FROM movie JOIN production_country ON movie.movie_id = production_country.movie_id JOIN country ON production_country.country_id = country.country_id WHERE movie.title = 'Pirates of the Caribbean: Dead Man''s Chest';
SELECT movie.title FROM movie JOIN production_country ON movie.movie_id = production_country.movie_id JOIN country ON production_country.country_id = country.country_id WHERE country.country_name = 'Canada'; 
SELECT SUM(movie.budget) FROM     movie JOIN     movie_keywords ON movie.movie_id = movie_keywords.movie_id JOIN     keyword ON movie_keywords.keyword_id = keyword.keyword_id WHERE     keyword.keyword_name = 'video game';
SELECT AVG(movie.revenue) AS average_revenue FROM movie JOIN movie_keywords ON movie.movie_id = movie_keywords.movie_id JOIN keyword ON movie_keywords.keyword_id = keyword.keyword_id WHERE keyword.keyword_name = 'civil war';
SELECT MAX(popularity) AS popularity FROM movie WHERE vote_count = (SELECT MAX(vote_count) FROM movie);
SELECT title FROM     movie WHERE     budget = 0 ORDER BY     revenue DESC LIMIT 1; 
SELECT company_id FROM movie JOIN movie_company ON movie.movie_id = movie_company.movie_id JOIN production_company ON movie_company.company_id = production_company.company_id WHERE title = 'Gladiator';
SELECT production_company.company_id FROM production_company JOIN movie_company ON production_company.company_id = movie_company.company_id JOIN movie ON movie_company.movie_id = movie.movie_id WHERE movie.release_date LIKE '1916%'
SELECT movie.title FROM movie JOIN movie_company ON movie.movie_id = movie_company.movie_id JOIN production_company ON movie_company.company_id = production_company.company_id WHERE production_company.company_name = 'Lucasfilm';
SELECT movie.title FROM movie JOIN movie_company ON movie.movie_id = movie_company.movie_id JOIN production_company ON movie_company.company_id = production_company.company_id WHERE production_company.company_name = 'Warner Bros. Pictures' ORDER BY movie.revenue DESC LIMIT 1; 
SELECT release_date FROM movie JOIN movie_company ON movie.movie_id = movie_company.movie_id JOIN production_company ON movie_company.company_id = production_company.company_id WHERE production_company.company_name = 'Twentieth Century Fox Film Corporation';
SELECT language.language_id FROM movie JOIN movie_languages ON movie.movie_id = movie_languages.movie_id JOIN language ON movie_languages.language_id = language.language_id WHERE movie.title = 'Walk the Line';
SELECT language_id FROM movie WHERE popularity = (SELECT MAX(popularity) FROM movie);
SELECT language.language_name FROM movie JOIN movie_languages ON movie.movie_id = movie_languages.movie_id JOIN language ON movie_languages.language_id = language.language_id WHERE movie.title = 'C''era una volta il West';
SELECT COUNT(*) FROM movie JOIN movie_languages ON movie.movie_id = movie_languages.movie_id JOIN language ON movie_languages.language_id = language.language_id WHERE movie_status = 'Post Production' AND language_name = 'Nederlands'; 
SELECT tagline FROM     movie JOIN     movie_languages ON movie.movie_id = movie_languages.movie_id JOIN     language ON movie_languages.language_id = language.language_id WHERE     language.language_name = 'Polski';
SELECT homepage FROM movie JOIN movie_languages ON movie.movie_id = movie_languages.movie_id JOIN language ON movie_languages.language_id = language.language_id WHERE language.language_name = 'Bahasa Indonesia';
SELECT SUM(CASE WHEN language_name = 'English' THEN revenue ELSE 0 END) - SUM(CASE WHEN language_name = 'Latin' THEN revenue ELSE 0 END) AS revenue_difference FROM movie JOIN movie_languages ON movie.movie_id = movie_languages.movie_id JOIN language ON movie_languages.language_id = language.language_id WHERE language_name IN ('English', 'Latin')
SELECT SUM(CASE      WHEN pc.company_name = 'Fantasy Films' THEN m.revenue      WHEN pc.company_name = 'Live Entertainment' THEN m.revenue      ELSE 0  END) AS total_revenue FROM movie_company mc JOIN production_company pc ON mc.company_id = pc.company_id JOIN movie m ON mc.movie_id = m.movie_id JOIN movie_genres mg ON m.movie_id = mg.movie_id JOIN genre g ON mg.genre_id = g.genre_id WHERE g.genre_name = 'Fantasy' OR g.genre_name = 'Live Entertainment'; 
SELECT AVG(revenue)  FROM      movie  JOIN      movie_languages ON movie.movie_id = movie_languages.movie_id  JOIN      language ON movie_languages.language_id = language.language_id  WHERE      language.language_name = 'Latin';
SELECT MAX(person_name) FROM (     SELECT person_name, COUNT(*) AS name_count     FROM person     GROUP BY person_name     ORDER BY name_count DESC ) AS name_counts;
SELECT AVG(COUNT(person_id) * 1.0 / COUNT(movie_id)) AS average_number_of_crews FROM movie_crew;
SELECT keyword_name FROM keyword WHERE keyword_name LIKE '%christmas%' 
SELECT MAX(runtime) AS longest_runtime FROM movie;
SELECT country_iso_code FROM country WHERE country_name = 'Kyrgyz Republic';
SELECT overview FROM movie WHERE title = 'The Pacifier';
SELECT COUNT(DISTINCT movie.movie_id) AS num_movies FROM movie JOIN movie_company ON movie.movie_id = movie_company.movie_id JOIN production_company ON movie_company.company_id = production_company.company_id WHERE production_company.company_name = 'Eddie Murphy Productions';
SELECT person.person_name FROM     person JOIN     movie_cast ON person.person_id = movie_cast.person_id WHERE     movie_cast.character_name LIKE '%captain%';
SELECT MAX(keyword_name) AS most_common_keyword FROM     movie_keywords JOIN     keyword ON movie_keywords.keyword_id = keyword.keyword_id JOIN     movie ON movie_keywords.movie_id = movie.movie_id WHERE     movie.release_date LIKE '%2006%'
SELECT COUNT(DISTINCT movie.movie_id) AS num_movies FROM     movie JOIN     movie_languages ON movie.movie_id = movie_languages.movie_id JOIN     language ON movie_languages.language_id = language.language_id WHERE     language.language_code = 'vi';
SELECT genre_name FROM   genre GROUP BY   genre_name ORDER BY   COUNT(genre_name) ASC LIMIT 1 OFFSET 2; 
SELECT language.language_name FROM movie JOIN movie_languages ON movie.movie_id = movie_languages.movie_id JOIN language ON movie_languages.language_id = language.language_id JOIN language_role ON movie_languages.language_role_id = language_role.role_id WHERE movie.tagline = "An offer you can't refuse." AND language_role.language_role = 'Original';
SELECT AVG(revenue) FROM     movie JOIN     production_country ON movie.movie_id = production_country.movie_id JOIN     country ON production_country.country_id = country.country_id WHERE     country.country_name = 'France';
SELECT character_name FROM movie_cast WHERE gender_id = (     SELECT gender_id     FROM gender     WHERE gender = 'Unspecified' ); 
SELECT person.person_name, COUNT(movie_crew.movie_id) AS movie_count FROM person JOIN movie_crew ON person.person_id = movie_crew.person_id WHERE movie_crew.job = 'Director' GROUP BY person.person_name ORDER BY movie_count DESC LIMIT 5; 
SELECT genre_name, title FROM (     SELECT        g.genre_name,         m.title,         m.budget,         ROW_NUMBER() OVER(PARTITION BY g.genre_name ORDER BY m.budget DESC) AS rn     FROM         movie m     JOIN movie_genres mg ON m.movie_id = mg.movie_id     JOIN genre g ON mg.genre_id = g.genre_id ) AS ranked WHERE rn = 1; 
SELECT movie.title FROM     movie JOIN     movie_keywords ON movie.movie_id = movie_keywords.movie_id GROUP BY     movie.movie_id ORDER BY     COUNT(movie_keywords.keyword_id) DESC LIMIT 1;
SELECT department.department_name, COUNT(movie_crew.person_id) AS num_people FROM movie_crew JOIN department ON movie_crew.department_id = department.department_id GROUP BY department.department_name ORDER BY num_people DESC LIMIT 1;
SELECT (CAST(COUNT(DISTINCT movie.movie_id) AS FLOAT) / (SELECT COUNT(DISTINCT movie_id) FROM production_country)) * 100 AS percentage FROM production_country JOIN country ON production_country.country_id = country.country_id WHERE country.country_iso_code = 'US';
SELECT AVG(     CAST(         SUM(CASE WHEN gender.gender = 'Female' THEN 1 ELSE 0 END) * 1.0         /         SUM(CASE WHEN gender.gender = 'Male' THEN 1 ELSE 0 END)     AS FLOAT) ) AS percentage 
SELECT title FROM movie WHERE release_date LIKE '1945%' 
SELECT country_id, country_iso_code FROM country WHERE country_name = 'Belgium';
SELECT character_name FROM     movie_cast JOIN     person ON movie_cast.person_id = person.person_id WHERE     person.person_name = 'Catherine Deneuve'; 
SELECT movie.title FROM movie JOIN movie_languages ON movie.movie_id = movie_languages.movie_id JOIN language ON movie_languages.language_id = language.language_id WHERE language.language_name = 'Somali'; 
SELECT movie.release_date, language.language_name FROM movie JOIN movie_languages ON movie.movie_id = movie_languages.movie_id JOIN language ON movie_languages.language_id = language.language_id WHERE movie.popularity = (     SELECT MAX(popularity)     FROM movie );
SELECT language.language_name FROM     movie JOIN     movie_languages ON movie.movie_id = movie_languages.movie_id JOIN     language ON movie_languages.language_id = language.language_id JOIN     language_role ON movie_languages.language_role_id = language_role.role_id WHERE     movie.title = 'Four Rooms'     AND language_role.language_role = 'Original';
SELECT character_name FROM movie_cast WHERE movie_id = (SELECT movie_id FROM movie WHERE title = 'Open Water');
SELECT person.person_name FROM     movie_cast JOIN     person ON movie_cast.person_id = person.person_id JOIN     movie ON movie_cast.movie_id = movie.movie_id WHERE     movie.title = 'Pirates of the Caribbean: At World''s End' AND     movie_cast.cast_order = (         SELECT            MIN(cast_order)         FROM             movie_cast         WHERE             movie_cast.movie_id = movie.movie_id     );
SELECT person.person_name FROM movie_crew JOIN person ON movie_crew.person_id = person.person_id JOIN department ON movie_crew.department_id = department.department_id WHERE department.department_name = 'Camera' AND movie_crew.job = 'Supervisor';
SELECT job FROM movie_crew JOIN person ON movie_crew.person_id = person.person_id WHERE person.person_name = 'Sally Menke';
SELECT person.person_name, department.department_name FROM movie JOIN movie_crew ON movie.movie_id = movie_crew.movie_id JOIN person ON movie_crew.person_id = person.person_id JOIN department ON movie_crew.department_id = department.department_id WHERE movie.title = 'Pirates of the Caribbean: At World''s End' AND movie_crew.job = 'Music Editor';
SELECT movie.title, movie.revenue FROM movie JOIN movie_company ON movie.movie_id = movie_company.movie_id JOIN production_company ON movie_company.company_id = production_company.company_id WHERE production_company.company_name = 'DreamWorks'
SELECT COUNT(DISTINCT movie.movie_id) AS movies_produced_in_canada FROM     movie JOIN     production_country ON movie.movie_id = production_country.movie_id JOIN     country ON production_country.country_id = country.country_id WHERE     country.country_name = 'Canada';
SELECT genre.genre_name FROM movie JOIN movie_genres ON movie.movie_id = movie_genres.movie_id JOIN genre ON movie_genres.genre_id = genre.genre_id WHERE movie.title = 'Forrest Gump'; 
SELECT production_company.company_name FROM     movie JOIN     movie_crew ON movie.movie_id = movie_crew.movie_id JOIN     production_company ON movie.movie_id = production_company.company_id WHERE     strftime('%Y', movie.release_date) = '2016' GROUP BY     movie.movie_id HAVING     (SUM(movie.runtime) - AVG(movie.runtime)) / AVG(movie.runtime) * 100 > 35;
SELECT ((COUNT(CASE WHEN keyword_name = 'woman director' THEN movie_id END) - COUNT(CASE WHEN keyword_name = 'independent film' THEN movie_id END)) * 100.0 / COUNT(movie_id)) AS percentage
SELECT genre.genre_name FROM movie JOIN movie_genres ON movie.movie_id = movie_genres.movie_id JOIN genre ON movie_genres.genre_id = genre.genre_id WHERE movie.title = 'Dancer in the Dark';
SELECT COUNT(*) FROM     movie JOIN     movie_genres ON movie.movie_id = movie_genres.movie_id JOIN     genre ON movie_genres.genre_id = genre.genre_id WHERE     genre.genre_name = 'Adventure'     AND movie.release_date LIKE '2000%'
SELECT movie.title FROM movie JOIN movie_company ON movie.movie_id = movie_company.movie_id JOIN production_company ON movie_company.company_id = production_company.company_id WHERE production_company.company_name = 'Paramount Pictures' AND release_date LIKE '2000%' 
SELECT keyword.keyword_name FROM movie JOIN movie_keywords ON movie.movie_id = movie_keywords.movie_id JOIN keyword ON movie_keywords.keyword_id = keyword.keyword_id WHERE movie.title = 'Finding Nemo';
SELECT movie.title FROM     movie JOIN     movie_genres ON movie.movie_id = movie_genres.movie_id JOIN     genre ON movie_genres.genre_id = genre.genre_id WHERE     genre.genre_name = 'horror'     AND movie.vote_average > 7;
SELECT COUNT(company_name) AS company_count FROM production_company GROUP BY company_name HAVING COUNT(company_name) > 150;
SELECT job FROM     movie_crew WHERE     person_id = (         SELECT            person_id         FROM             person         WHERE             person_name = 'Mark Hammel'     );
SELECT COUNT(DISTINCT movie_cast.person_id) FROM     movie_cast JOIN     movie ON movie_cast.movie_id = movie.movie_id JOIN     person ON movie_cast.person_id = person.person_id JOIN     gender ON movie_cast.gender_id = gender.gender_id WHERE     movie.title = 'Pirates of the Caribbean: At World''s End'     AND gender.gender = 'male'     AND movie_cast.cast_order = (         SELECT MIN(cast_order)         FROM movie_cast         WHERE movie_id = (             SELECT movie_id             FROM movie             WHERE title = 'Pirates of the Caribbean: At World''s End'         )     );
SELECT movie.title FROM     movie JOIN     movie_cast ON movie.movie_id = movie_cast.movie_id JOIN     person ON movie_cast.person_id = person.person_id WHERE     person.person_name = 'Harrison Ford';
SELECT character_name FROM     movie_cast JOIN     person ON movie_cast.person_id = person.person_id JOIN     movie ON movie_cast.movie_id = movie.movie_id WHERE     person.person_name = 'Orlando Bloom'     AND movie.title = 'Pirates of the Caribbean: The Curse of the Black Pearl';
SELECT AVG(CASE WHEN genre_name = 'horror' THEN 1 ELSE 0 END) AS average_horror_movies FROM movie_genres JOIN genre ON movie_genres.genre_id = genre.genre_id;
SELECT person.person_name FROM person JOIN movie_crew ON person.person_id = movie_crew.person_id JOIN movie ON movie_crew.movie_id = movie.movie_id JOIN department ON movie_crew.department_id = department.department_id WHERE movie.title = 'Pirates of the Caribbean: The Curse of the Black Pearl' AND movie_crew.job = 'Producer';
SELECT movie.title, AVG(movie.revenue) AS average_income FROM movie JOIN movie_keywords ON movie.movie_id = movie_keywords.movie_id JOIN keyword ON movie_keywords.keyword_id = keyword.keyword_id WHERE keyword.keyword_name = 'paris' GROUP BY movie.title;
SELECT COUNT(*) FROM method WHERE lang = 'en' AND commentisxml = 1;
SELECT method.summary FROM method WHERE method.nametokenized = "online median filter test median window filling"
SELECT MAX(SampledAt) AS TimeOfSampling, SolutionId AS IdOfSolution FROM sampledat;
SELECT MAX(forks) AS max_followers, url AS github_address FROM repo;
SELECT MAX(repo.id) AS repository_id FROM     solution JOIN     repo ON solution.repoid = repo.id GROUP BY     solution.repoid ORDER BY     COUNT(solution.path) DESC LIMIT 1;
SELECT repo.url, MAX(repo.stars) AS most_liked_stars FROM repo;
SELECT MAX(ProcessedTime) AS MaxProcessedTime FROM     solution;
SELECT MAX(processedtime) FROM repo ORDER BY watchers DESC LIMIT 1;
SELECT repo.url FROM solution JOIN repo ON solution.repoid = repo.id WHERE solution.path = "nofear_Mara\\Mara.sln";
SELECT repo.url, MAX(repo.processedtime) AS longest_processed_time, CASE WHEN solution.wascompiled = 1 THEN 'No compilation needed' ELSE 'Compilation needed' END AS compilation_status FROM repo JOIN solution ON repo.id = solution.repoid WHERE solution.wascompiled = 1 GROUP BY repo.url;
SELECT method.nametokenized FROM solution JOIN repo ON solution.repoid = repo.id WHERE solution.path = "maravillas_linq-to-delicious\tasty.sln";
SELECT repo.url FROM repo JOIN solution ON repo.id = solution.repoid WHERE repo.stars BETWEEN 6000 AND 9000 AND solution.wascompiled = 0 GROUP BY repo.id ORDER BY COUNT(solution.path) DESC LIMIT 1; 
SELECT apicalls FROM method JOIN solution ON method.solutionid = solution.id JOIN repo ON solution.repoid = repo.id WHERE repo.url = 'https://github.com/wallerdev/htmlsharp.git' 
SELECT COUNT(solution.path) AS solution_paths FROM (     SELECT        repo.id,         repo.url,         repo.watchers,         solution.path     FROM         repo     JOIN         solution ON repo.id = solution.repoid     ORDER BY         repo.watchers DESC     LIMIT 1 OFFSET 1 ) AS second_most_popular_repo JOIN     solution ON second_most_popular_repo.id = solution.repoid;
SELECT AVG(solution.processedtime) AS average_processed_time FROM     solution JOIN     repo ON solution.repoid = repo.id WHERE     repo.url = 'https://github.com/zphingphong/DiscardCustomerApp.git';
SELECT fullcomment FROM method JOIN solution ON method.solutionid = solution.id WHERE solution.path = "bmatzelle_nini\Source\Nini.sln" AND method.nametokenized = "alias text add alias"; 
SELECT apicalls FROM method JOIN solution ON method.solutionid = solution.id WHERE solution.path = "mauriciodeamorim_tdd.encontro2\Tdd.Encontro2.sln";
SELECT COUNT(solution.id) FROM     solution JOIN     repo ON solution.repoid = repo.id WHERE     repo.url = "https://github.com/jeffdik/tachy.git" AND     solution.wascompiled = 0;
SELECT processedtime, lang FROM method WHERE nametokenized = "about box1 dispose";
SELECT sampledat FROM method JOIN solution ON method.solutionid = solution.id JOIN repo ON solution.repoid = repo.id WHERE repo.url = 'maxild_playground\Playground.sln' AND method.name = 'GitHubRepo.Cli.GitHubClientWrapper.GetReleases'; 
SELECT method.lang FROM method JOIN solution ON method.solutionid = solution.id JOIN repo ON solution.repoid = repo.id WHERE solution.path = "opendns_diagnosticapp\windows\OpenDnsDiagnostic.sln" 
SELECT method.name, substr(method.nametokenized, instr(method.nametokenized, '.') + 1) AS task FROM method WHERE method.nametokenized = 'html parser feed';
SELECT CASE     WHEN commentisxml = 1 THEN 'Yes'     ELSE 'No' END AS CommentsXML FROM method WHERE name = 'HtmlSharp.HtmlParser.Feed'; 
SELECT * FROM method WHERE summary = 'Write a command to the log'; 
SELECT COUNT(DISTINCT solution.id) FROM solution JOIN repo ON solution.repoid = repo.id WHERE repo.stars = (SELECT MAX(stars) FROM repo);
SELECT solution.path FROM solution JOIN repo ON solution.repoid = repo.id WHERE repo.stars = (SELECT MAX(stars) FROM repo);
SELECT repo.url FROM solution INNER JOIN repo ON solution.repoid = repo.id WHERE solution.id = 12;
SELECT COUNT(DISTINCT solution.id) FROM solution JOIN repo ON solution.repoid = repo.id WHERE repo.forks > 1000 AND solution.wascompiled = 1;
SELECT solution.id FROM solution JOIN repo ON solution.repoid = repo.id WHERE solution.id = 18 AND repo.watchers > (     SELECT repo.watchers     FROM solution     JOIN repo ON solution.repoid = repo.id     WHERE solution.id = 19 );
SELECT COUNT(*) FROM solution WHERE processedtime = (     SELECT MAX(processedtime)     FROM solution ) AND wascompiled = 0;
SELECT MAX(repo.processedtime) FROM     solution JOIN     repo ON solution.repoid = repo.id WHERE     solution.path = 'jeffdik_tachy\src\Tachy.sln';
SELECT repo.url FROM solution JOIN repo ON solution.repoid = repo.id WHERE solution.id = 9; 
SELECT solution.path FROM solution JOIN repo ON solution.repoid = repo.id WHERE repo.url = "https://github.com/maxild/playground.git";
SELECT COUNT(DISTINCT repo.id) FROM repo JOIN solution ON repo.id = solution.repoid WHERE repo.stars > 200 AND solution.processedtime < 636439500080712000;
SELECT solution.id FROM solution INNER JOIN repo ON solution.repoid = repo.id ORDER BY repo.forks DESC LIMIT 3;
SELECT AVG(s.processedtime) FROM solution s JOIN repo r ON s.repoid = r.id WHERE r.url = "https://github.com/jeffdik/tachy.git";
SELECT ((SELECT forks FROM repo WHERE id = (SELECT repoid FROM solution WHERE id = 18)) -  (SELECT forks FROM repo WHERE id = (SELECT repoid FROM solution WHERE id = 19))) * 100.0 /  (SELECT forks FROM repo WHERE id = (SELECT repoid FROM solution WHERE id = 19));
SELECT `lang` FROM method WHERE name = 'PixieTests.SqlConnectionLayerTests.TestSqlCreateGuidColumn';
SELECT fullcomment FROM method WHERE name = 'DE2_UE_Fahrradkurier.de2_uebung_fahrradkurierDataSet1TableAdapters.TableAdapterManager.UpdateInsertedRows'; 
SELECT summary FROM method WHERE name = 'Castle.MonoRail.Framework.Test.StubViewComponentContext.RenderSection'; 
SELECT nametokenized FROM method WHERE name = 'Supay.Irc.Messages.KnockMessage.GetTokens'; 
SELECT COUNT(repo.stars) AS stars_count FROM     solution JOIN     repo ON solution.repoid = repo.id WHERE     solution.id = 45997;
SELECT COUNT(solution.id) AS solution_count FROM     repo JOIN     solution ON repo.id = solution.repoid WHERE     repo.stars = 8094;
SELECT solution.path FROM     solution JOIN     method ON solution.repoid = method.solutionid WHERE     method.name = 'IQ.Data.DbQueryProvider.CanBeEvaluatedLocally';
SELECT s.ProcessedTime FROM   method m   JOIN solution s ON m.SolutionId = s.Id WHERE   m.NameTokenized = 'interp parser expr'; 
SELECT repo.id FROM solution JOIN method ON method.id = solution.solutionid JOIN repo ON repo.id = solution.repoid WHERE method.name = 'SCore.Poisson.ngtIndex';
SELECT solution.path FROM     solution JOIN     method ON solution.repoid = method.solutionid WHERE     method.name = 'ExportToRTF.RTFStyleSheet.H6Write';
SELECT COUNT(DISTINCT solution.id) AS solution_count FROM     repo JOIN     solution ON repo.id = solution.repoid WHERE     repo.watchers = 8094;
SELECT repo.url FROM     repo JOIN     solution ON repo.id = solution.repoid GROUP BY     repo.id ORDER BY     COUNT(solution.id) DESC LIMIT 1; 
SELECT COUNT(s.id) FROM solution s JOIN repo r ON s.repoid = r.id WHERE r.forks = 1445;
SELECT s.path FROM (     SELECT        so.path,         COUNT(so.path) AS path_count     FROM         solution AS s     JOIN         method AS m ON s.solutionid = m.id     WHERE         m.lang = 'zh-cn'     GROUP BY         so.path     ORDER BY         path_count DESC     LIMIT 1 ) AS most_used_path; 
SELECT COUNT(repo.watchers) AS num_watchers FROM solution JOIN repo ON solution.repoid = repo.id WHERE solution.id = 338082;
SELECT COUNT(solution.id) AS compiled_solutions_count FROM     solution INNER JOIN     repo ON solution.repoid = repo.id WHERE     repo.stars = 189 AND     solution.wascompiled = 0;
SELECT solution.path FROM solution JOIN method ON solution.id = method.solutionid WHERE method.name = 'Mosa.Platform.x86.Instructions.IMul.EmitLegacy'; 
SELECT solution.ProcessedTime FROM     solution JOIN     method ON solution.repoid = method.solutionid WHERE     method.nametokenized = 't jadwal entity get single mpic';
SELECT repo.id FROM solution JOIN method ON solution.path = method.name WHERE method.name = 'Kalibrasi.Data.EntityClasses.THistoryJadwalEntity.GetSingleTjadwal';
SELECT solution.path FROM     method JOIN     solution ON method.solutionid = solution.id WHERE     method.summary = "Refetches the Entity from the persistent storage. Refetch is used to re-load an Entity which is marked 'Out-of-sync', due to a save action. Refetching an empty Entity has no effect.";
SELECT COUNT(solution.id) FROM     solution INNER JOIN     repo ON solution.repoid = repo.id WHERE     repo.stars = 3060;
SELECT s.path FROM     solution s JOIN     method m ON s.id = m.solutionid WHERE     m.lang = 'sw' GROUP BY     s.id ORDER BY     COUNT(*) DESC LIMIT 1; 
SELECT ROUND(     (         (             (                 SELECT                    repo.watchers                 FROM                     solution                 JOIN                     repo ON solution.repoid = repo.id                 WHERE                     solution.id = 83855             ) - (                 SELECT                    repo.watchers                 FROM                     solution                 JOIN                     repo ON solution.repoid = repo.id                 WHERE                     solution.id = 1502             )         ) * 100.0     ) / (         SELECT            repo.watchers         FROM             solution         JOIN             repo ON solution.repoid = repo.id         WHERE             solution.id = 1502     ), 2 ) AS percent_increase; 
SELECT ROUND(((   (SELECT stars FROM repo WHERE id = (SELECT repoid FROM solution WHERE id = 51424))   -    (SELECT stars FROM repo WHERE id = (SELECT repoid FROM solution WHERE id = 167053)) ) * 100.0) /    (SELECT stars FROM repo WHERE id = (SELECT repoid FROM solution WHERE id = 167053)), 2) AS percent_more;
SELECT ROUND(     (         (SELECT (SELECT forks FROM repo WHERE id = (SELECT repoid FROM solution WHERE id = 53546))) -         (SELECT (SELECT forks FROM repo WHERE id = (SELECT repoid FROM solution WHERE id = 1502)))     ) /     (SELECT (SELECT forks FROM repo WHERE id = (SELECT repoid FROM solution WHERE id = 1502))) * 100 ) AS percentage_more_forks; 
SELECT method.* FROM     method JOIN     solution ON method.solutionid = solution.id WHERE     solution.processedtime = "636449700980488000";
SELECT COUNT(solution.id) AS num_solutions FROM solution JOIN repo ON solution.repoid = repo.id WHERE repo.url = 'https://github.com/derickbailey/presentations-and-training.git';
SELECT AVG(s.processedtime)  FROM      solution s JOIN      repo r ON s.repoid = r.id GROUP BY      s.repoid ORDER BY      COUNT(r.forks) DESC LIMIT 1;
SELECT solution.path FROM solution INNER JOIN method ON solution.id = method.solutionid WHERE method.lang = "it";
SELECT solution.path FROM solution JOIN method ON solution.id = method.solutionid WHERE method.name = 'spinachLexer.mT__55';
SELECT method.name FROM method JOIN solution ON method.solutionid = solution.id WHERE method.lang = 'en' AND solution.repoid = 1093;
SELECT solution.path FROM solution INNER JOIN repo ON solution.repoid = repo.id WHERE repo.url = 'https://github.com/ecoffey/Bebop.git';
SELECT repo.id FROM solution JOIN repo ON solution.repoid = repo.id JOIN method ON solution.id = method.solutionid WHERE method.lang = 'ro'; 
SELECT repo.id FROM method INNER JOIN methodparameter ON method.id = methodparameter.methodid INNER JOIN solution ON method.solutionid = solution.id INNER JOIN repo ON solution.repoid = repo.id WHERE method.nametokenized = 'crc parameters get hash code';
SELECT COUNT(method.id) FROM method JOIN solution ON method.solutionid = solution.id WHERE solution.path = 'maravillas_linq-to-delicious\tasty.sln';
SELECT solution.id FROM solution JOIN repo ON solution.repoid = repo.id WHERE repo.processedtime = '636430969128176000';
SELECT  repo.url FROM solution JOIN repo ON solution.repoid = repo.id WHERE solution.processedtime = (     SELECT MAX(processedtime)     FROM solution ) 
SELECT solution.* FROM solution JOIN repo ON solution.repoid = repo.id WHERE repo.forks > (repo.watchers / 2); 
SELECT ROUND((forks * 100.0 / stars), 2) AS percentage_forks_to_stars FROM repo JOIN solution ON repo.id = solution.repoid WHERE solution.id = 104086; 
SELECT id FROM repo ORDER BY stars DESC LIMIT 1; 
SELECT solution.path FROM solution JOIN method ON solution.id = method.solutionid WHERE method.name = 'HtmlSharp.HtmlParser.Feed';
SELECT forks FROM repo WHERE id = (SELECT repoid FROM solution WHERE id = 35); 
SELECT Solution.Id FROM     Solution JOIN     Repo ON Solution.RepoId = Repo.Id ORDER BY     Repo.Watchers DESC LIMIT 1;
SELECT stars FROM repo WHERE id = (SELECT repoid FROM solution WHERE id = 20); 
SELECT COUNT(method.id) AS num_methods, CASE     WHEN solution.wascompiled = 0 THEN 'Yes'     ELSE 'No' END AS needs_compilation FROM method INNER JOIN solution ON method.solutionid = solution.id WHERE solution.id = 1;
SELECT 100 * SUM(CASE WHEN s.wascompiled = 0 THEN 1 ELSE 0 END) / COUNT(m.solutionid) AS percentage FROM method AS m JOIN solution AS s ON m.solutionid = s.id WHERE m.commentisxml = 1;
SELECT method.name FROM method JOIN solution ON method.solutionid = solution.id WHERE solution.path = 'wallerdev_htmlsharp\HtmlSharp.sln'; 
SELECT ROUND((COUNT(DISTINCT repoid) * 100.0) / (SELECT COUNT(DISTINCT repoid) FROM repo), 2) AS percentage_of_repositories_with_more_than_2000_stars FROM repo WHERE stars > 2000;
SELECT repo.url FROM solution JOIN repo ON solution.repoid = repo.id WHERE solution.id = 1; 
SELECT MAX(repo.id) FROM repo WHERE stars = 21 GROUP BY stars ORDER BY forks DESC LIMIT 1;
SELECT ROUND((COUNT(CASE WHEN method.lang = 'en' THEN 1 END) * 100.0) / COUNT(*), 2) AS english_method_percentage FROM method WHERE method.commentisxml = 1; 
SELECT solution.path FROM solution JOIN method ON solution.id = method.solutionid WHERE method.nametokenized = 'html' AND method.nametokenized = 'parser' AND method.nametokenized = 'feed';
SELECT solution.Id FROM repo JOIN solution ON repo.Id = solution.repoid WHERE repo.forks = 238;
SELECT method.NameTokenized FROM method JOIN solution ON method.id = solution.id WHERE method.lang = 'en' AND solution.wascompiled = 0;
SELECT COUNT(solution.id) FROM     solution JOIN     repo ON solution.repoid = repo.id WHERE     (repo.stars * 1.0 / 3) > repo.forks;
SELECT solution.path FROM solution JOIN method ON solution.id = method.solutionid WHERE method.fullcomment = 'Feeds data into the parser';
SELECT COUNT(*) FROM method WHERE repoId = 3 AND commentisxml = 1;
SELECT (    SELECT     (COUNT(s1.id) * 1.0 / COUNT(s2.id)) * 100   FROM      solution AS s1   JOIN      method AS m ON s1.methodid = m.id   JOIN      repo AS r ON s1.repoid = r.id   JOIN      (SELECT id FROM solution WHERE wascompiled = 0) AS s2 ON s1.id = s2.id   WHERE      m.lang = 'en' ) 
SELECT (SELECT ((SELECT stars FROM repo WHERE id = (SELECT repoid FROM solution WHERE id = 1)) - (SELECT stars FROM repo WHERE id = (SELECT repoid FROM solution WHERE id = 2))) * 100.0 / (SELECT stars FROM repo WHERE id = (SELECT repoid FROM solution WHERE id = 2));)
SELECT COUNT(DISTINCT solution.id) FROM solution JOIN repo ON solution.repoid = repo.id WHERE repo.stars > repo.forks / 3;
SELECT SUBSTR(name, INSTR(name, '.') + 1) AS task FROM method WHERE id = 2; 
SELECT commentisxml FROM method WHERE id = 8; 
SELECT url FROM repo ORDER BY watchers DESC LIMIT 1;
SELECT method.id, substr(method.name, instr(method.name, '.') + 1) AS task FROM method WHERE method.lang = 'cs';
SELECT solution.path FROM solution INNER JOIN method ON solution.id = method.solutionid WHERE method.id = 3; 
SELECT lang FROM method WHERE id = 28 AND repoId = 3;
SELECT solution.processedtime AS processing_time, COUNT(method.id) AS method_count FROM solution JOIN method ON solution.id = method.solutionid WHERE solution.id = 1;
SELECT COUNT(*) FROM method m JOIN solution s ON m.solutionid = s.id JOIN repo r ON s.repoid = r.id WHERE m.nametokenized LIKE 'query language%'
SELECT apicalls, path  FROM method  JOIN solution ON method.solutionid = solution.id  WHERE method.id = 10;
SELECT COUNT(*) FROM method WHERE repo_id = 150 AND fullcomment IS NULL AND summary IS NULL;
SELECT method.fullcomment FROM method JOIN solution ON method.solutionid = solution.id WHERE method.id = 50 AND solution.path = 'managedfusion_managedfusion\ManagedFusion.sln'; 
SELECT method.summary FROM method WHERE method.nametokenized = 'string extensions to pascal case';
SELECT nametokenized FROM method WHERE name = 'Sky.Excel.ExcelBook.TypeConvert';
SELECT COUNT(path) FROM solution JOIN repo ON solution.repoid = repo.id WHERE repo.url = 'https://github.com/jeffdik/tachy.git';
SELECT repo.watchers FROM solution JOIN repo ON solution.repoid = repo.id WHERE solution.path = "maff_se3ue7\\US7.sln"; 
SELECT repo.url FROM solution INNER JOIN repo ON solution.repoid = repo.id WHERE solution.wascompiled = 1 LIMIT 5;
SELECT solution.path FROM solution JOIN method ON solution.id = method.solutionid WHERE method.nametokenized = 'matrix multiply';
SELECT COUNT(*) FROM repo WHERE url = 'https://github.com/dogeth/vss2git.git' AND commentisxml = 1;
SELECT path FROM solution WHERE sampledat = '636431758961741000' LIMIT 5; 
SELECT repo.url FROM solution JOIN repo ON solution.repoid = repo.id WHERE solution.path = 'joeyrobert_bloomfilter\DataTypes.BloomFilter.sln';
SELECT method.name FROM method JOIN solution ON method.solutionid = solution.id WHERE solution.path = 'graffen_NLog.Targets.Syslog\src\NLog.Targets.Syslog.sln';
SELECT method.nameTokenized FROM solution JOIN method ON solution.id = method.solutionid WHERE solution.path = 'jurney_P4Backup\P4Backup\P4Backup.sln';
SELECT repo.url FROM solution INNER JOIN method ON solution.id = method.solutionid INNER JOIN repo ON solution.repoid = repo.id WHERE method.summary = 'A test for Decompose';
SELECT COUNT(repo.stars) AS liked_by_people FROM     solution JOIN     repo ON solution.repoid = repo.id WHERE     solution.path = 'ninject_Ninject\Ninject.sln';
SELECT COUNT(solution.path) AS solution_count FROM solution JOIN repo ON solution.repoid = repo.id WHERE repo.stars = 111 AND repo.forks = 58 AND repo.watchers = 111;
SELECT AVG(solution.processedtime) FROM solution JOIN repo ON solution.repoid = repo.id WHERE repo.stars = 254 AND repo.forks = 88 AND repo.watchers = 254;
SELECT COUNT(DISTINCT method.lang) AS language_code_count FROM method JOIN solution ON method.solutionid = solution.id JOIN repo ON solution.repoid = repo.id WHERE repo.url = 'https://github.com/managedfusion/managedfusion.git';
SELECT COUNT(*) FROM trains WHERE direction = 'east';
SELECT COUNT(*) FROM cars WHERE train_id = 1;
SELECT shape FROM cars WHERE train_id = 1 AND position = 4; 
SELECT DISTINCT trains.id FROM     trains JOIN     cars ON cars.train_id = trains.id WHERE     cars.shape IN ('elipse', 'bucket'); 
SELECT COUNT(*) FROM     cars WHERE     train_id = 1     AND roof = 'open';
SELECT cars.id FROM cars JOIN trains ON cars.train_id = trains.id WHERE trains.id = 1 AND cars.wheels = 2; 
SELECT COUNT(DISTINCT trains.id) FROM trains JOIN cars ON trains.id = cars.train_id WHERE trains.direction = 'east' AND cars.shape IN ('ellipse', 'bucket');
SELECT trains.id FROM trains JOIN (     SELECT train_id, COUNT(*) AS carsNum     FROM cars     GROUP BY train_id     HAVING carsNum < 4 ) AS train_cars ON trains.id = train_cars.train_id WHERE trains.direction = 'east'; 
SELECT cars.id FROM cars JOIN trains ON cars.train_id = trains.id WHERE trains.direction = 'west' AND cars.sides = 'double'; 
SELECT COUNT(*) FROM trains WHERE direction = 'east' AND (     SELECT COUNT(*)     FROM cars     WHERE cars.train_id = trains.id     AND len > 2 ) > 2; 
SELECT DISTINCT direction FROM trains INNER JOIN cars ON trains.id = cars.train_id WHERE load_num = 0; 
SELECT trains.direction FROM trains INNER JOIN cars ON cars.train_id = trains.id WHERE cars.shape = 'ellipse';
SELECT COUNT(*) FROM     cars JOIN     trains ON cars.train_id = trains.id WHERE     trains.direction = 'east' AND     cars.len = 'short' 
SELECT cars.shape FROM cars JOIN trains ON cars.train_id = trains.id WHERE cars.position = 1 AND trains.direction = 'east'; 
SELECT COUNT(cars.id) FROM cars JOIN trains ON cars.train_id = trains.id WHERE trains.direction = 'east' AND cars.roof = 'flat';
SELECT COUNT(*) FROM cars JOIN trains ON cars.train_id = trains.id WHERE trains.direction = 'east' AND cars.roof = 'flat' AND cars.load_shape = 'circle';
SELECT   direction, MAX(rectCarsNum) FROM (     SELECT        direction,         COUNT(*) AS rectCarsNum     FROM         trains     INNER JOIN         cars ON trains.id = cars.train_id     WHERE         shape = 'rectangle'     GROUP BY         direction ) GROUP BY     direction ORDER BY     MAX(rectCarsNum) DESC LIMIT 1; 
SELECT DISTINCT direction FROM trains WHERE id IN (     SELECT train_id     FROM cars     WHERE len = 'short' AND position = 4 ); 
SELECT AVG(cars) FROM cars JOIN trains ON cars.train_id = trains.id WHERE trains.direction = 'east' 
SELECT 100 * (     SELECT COUNT(DISTINCT trains.id)     FROM cars     JOIN trains ON cars.train_id = trains.id     WHERE cars.shape IN ('bucket', 'ellipse')       AND trains.direction = 'east' ) / (     SELECT COUNT(DISTINCT trains.id)     FROM cars     JOIN trains ON cars.train_id = trains.id     WHERE cars.shape IN ('bucket', 'ellipse') ) AS percentage_east_direction
SELECT COUNT(*) FROM cars WHERE len = 'short' AND shape = 'hexagon';
SELECT COUNT(*) FROM     trains WHERE     direction = 'west';
SELECT cars.load_shape FROM cars JOIN trains ON cars.train_id = trains.id WHERE cars.shape = 'ellipse' AND cars.len = 'short'; 
SELECT trains.id FROM trains WHERE trains.direction = 'east'; 
SELECT COUNT(wheels)  FROM cars  WHERE len = 'long';
SELECT direction FROM trains GROUP BY direction ORDER BY COUNT(id) DESC LIMIT 1; 
SELECT COUNT(DISTINCT trains.id) FROM trains JOIN cars ON cars.train_id = trains.id WHERE trains.direction = 'east' GROUP BY trains.id HAVING COUNT(cars.id) >= 4;
SELECT MAX(direction) FROM trains WHERE id IN (     SELECT train_id     FROM cars     WHERE shape = 'rectangle'     AND position = 2     GROUP BY train_id     ORDER BY COUNT(id) DESC     LIMIT 1 );
SELECT COUNT(*) FROM     cars JOIN     trains ON cars.train_id = trains.id WHERE     trains.direction = 'west'     AND cars.position = 3     AND cars.sides = 'double';
SELECT COUNT(*) FROM     cars JOIN     trains ON cars.train_id = trains.id WHERE     trains.direction = 'east'     AND cars.position = 1     AND cars.shape = 'rectangular';
SELECT COUNT(DISTINCT trains.id) FROM trains JOIN cars ON trains.id = cars.train_id WHERE trains.direction = 'west' GROUP BY trains.id HAVING SUM(CASE WHEN cars.roof = 'none' THEN 1 ELSE 0 END) <= 1; 
SELECT COUNT(trains.direction) AS direction_count, trains.direction FROM trains JOIN cars ON trains.id = cars.train_id GROUP BY trains.direction HAVING COUNT(cars.id) = 3 ORDER BY direction_count DESC LIMIT 1;
SELECT COUNT(DISTINCT trains.id) FROM trains JOIN cars ON trains.id = cars.train_id WHERE cars.position = 1 AND cars.load_num = 3 AND trains.direction = 'east';
SELECT COUNT(cars.id) AS num_double_sided_tail_cars FROM cars JOIN trains ON cars.train_id = trains.id WHERE trains.direction = 'east' AND cars.sides = 'double' AND cars.position = 'trailPosi'; 
SELECT DISTINCT trains.direction FROM trains JOIN cars ON cars.train_id = trains.id WHERE cars.load_num = 0; 
SELECT trains.direction FROM cars JOIN trains ON cars.train_id = trains.id WHERE cars.position = 2 AND cars.load_shape = 'diamond';
SELECT COUNT(DISTINCT trains.id) FROM cars JOIN trains ON cars.train_id = trains.id WHERE trains.direction = 'west' AND cars.wheels = 3 AND cars.roof = 'jagged';
SELECT trains.direction FROM trains JOIN cars ON trains.id = cars.train_id GROUP BY trains.id HAVING COUNT(cars.id) <= 2; 
SELECT (SELECT direction,          COUNT(*) * 100.0 / (SELECT COUNT(*) FROM trains WHERE EXISTS (SELECT 1 FROM cars WHERE cars.train_id = trains.id AND position >= 4)) FROM trains WHERE EXISTS (SELECT 1 FROM cars WHERE cars.train_id = trains.id AND position >= 4) GROUP BY direction); 
SELECT MAX(load_shape) AS highest_load_shape,        COUNT(CASE WHEN t.direction = 'east' THEN 1 END) * 100.0 / COUNT(t.id) AS percentage_east_trains FROM cars AS c JOIN trains AS t ON c.train_id = t.id WHERE c.position = 1 GROUP BY t.id;
SELECT character name FROM characters JOIN movie ON characters.movieid = movie.movieid WHERE movie.title = 'Look Who''s Talking';
SELECT characters.character_name FROM characters JOIN movie ON characters.movieid = movie.movieid WHERE movie.title = 'Batman' ORDER BY characters.screentime DESC LIMIT 1;
SELECT actor.name FROM actor JOIN characters ON actor.actorid = characters.actorid JOIN movie ON characters.movieid = movie.movieid WHERE characters.character_name = 'Joker' AND movie.title = 'Batman';
SELECT actor.name FROM characters JOIN actor ON characters.actorid = actor.actorid JOIN movie ON characters.movieid = movie.movieid WHERE movie.title = 'Batman';
SELECT movie.title FROM movie JOIN characters ON movie.movieid = characters.movieid JOIN actor ON characters.actorid = actor.actorid WHERE characters.character_name = 'Dr. Archibald ''Moonlight'' Graham';
SELECT title FROM movie JOIN characters ON movie.movieid = characters.movieid JOIN actor ON characters.actorid = actor.actorid WHERE actor.name = 'Tom Cruise';
SELECT COUNT(movie.movieid) FROM     movie JOIN     characters ON movie.movieid = characters.movieid JOIN     actor ON characters.actorid = actor.actorid WHERE     actor.name = 'Morgan Freeman'     AND movie.mpaa_rating = 'PG';
SELECT movie.title FROM movie JOIN characters ON movie.movieid = characters.movieid JOIN actor ON characters.actorid = actor.actorid WHERE actor.name = 'Tom Cruise' ORDER BY movie.rating DESC LIMIT 1;
SELECT character name FROM characters JOIN actor ON characters.actorid = actor.actorid JOIN movie ON characters.movieid = movie.movieid WHERE actor.name = 'Tom Cruise' AND movie.title = 'Born on the Fourth of July';
SELECT characters.character_name FROM characters JOIN actor ON characters.actorid = actor.actorid WHERE actor.name = 'Tom Cruise';
SELECT actor.name FROM actor JOIN characters ON actor.actorid = characters.actorid JOIN movie ON characters.movieid = movie.movieid WHERE movie.title = 'Batman' ORDER BY actor.height DESC LIMIT 1;
SELECT COUNT(DISTINCT movie.movieid) FROM     movie     JOIN characters ON movie.movieid = characters.movieid     JOIN actor ON characters.actorid = actor.actorid WHERE     actor.gender = 'Male'     AND actor.ethnicity = 'African American';
SELECT AVG(m.rating) AS average_rating FROM   movie m JOIN   characters c ON m.movieid = c.movieid JOIN   actor a ON c.actorid = a.actorid WHERE   a.name = 'Tom Cruise';
SELECT ((MAX(screentime) - MIN(screentime)) / MIN(screentime)) * 100 AS percentage_increase FROM characters JOIN movie ON characters.movieid = movie.movieid JOIN actor ON characters.actorid = actor.actorid WHERE movie.title = 'Batman';
SELECT MAX(budget) AS biggest_budget, title AS movie_with_biggest_budget FROM movie;
SELECT movie.mpaa_rating FROM movie JOIN characters ON movie.movieid = characters.movieid JOIN actor ON characters.actorid = actor.actorid WHERE characters.character_name = 'Peter Quill'; 
SELECT characters.character_name FROM characters JOIN movie ON characters.movieid = movie.movieid JOIN (     SELECT movieid, MAX(rating) AS max_rating     FROM movie     WHERE genre = 'Thriller' ) AS max_rating_thriller ON movie.movieid = max_rating_thriller.movieid WHERE characters.creditorder = '1'
SELECT actor.name FROM actor JOIN characters ON actor.actorid = characters.actorid JOIN movie ON characters.movieid = movie.movieid WHERE movie.title = 'Batman' AND characters.screentime = (     SELECT MAX(screentime)     FROM characters     JOIN movie ON characters.movieid = movie.movieid     WHERE movie.title = 'Batman' );
SELECT COUNT(*) FROM     characters     INNER JOIN actor ON characters.actorid = actor.actorid WHERE     actor.networth = (SELECT MAX(networth) FROM actor)
SELECT actor.name FROM actor JOIN characters ON actor.actorid = characters.actorid WHERE characters.character_name = "Chanice Kobolowski";
SELECT actor.date_of_birth FROM actor JOIN characters ON actor.actorid = characters.actorid WHERE characters.character_name = 'Sully'; 
SELECT actor.birth_city FROM characters JOIN actor ON characters.actorid = actor.actorid WHERE characters.character_name = 'Gabriel Martin';
SELECT actor.biography FROM actor JOIN characters ON actor.actorid = characters.actorid JOIN movie ON characters.movieid = movie.movieid WHERE characters.character_name = 'Michael Moscovitz';
SELECT actor.height FROM actor JOIN characters ON actor.actorid = characters.actorid JOIN movie ON characters.movieid = movie.movieid WHERE characters.character_name = 'Lurch';
SELECT characters.character_name FROM characters JOIN movie ON characters.movieid = movie.movieid WHERE movie.title = 'G.I. Joe: The Rise of Cobra' AND characters.creditorder = 3;
SELECT actor.name FROM actor JOIN characters ON actor.actorid = characters.actorid JOIN movie ON characters.movieid = movie.movieid WHERE movie.title = 'American Hustle' AND characters.creditorder = '2';
SELECT actor.name FROM characters JOIN actor ON characters.actorid = actor.actorid JOIN movie ON characters.movieid = movie.movieid WHERE characters.creditorder = 1 AND movie.release_date = '2015-10-26';
SELECT (CAST((COUNT(actor.actorid) * 100.0 / (SELECT COUNT(*) FROM characters INNER JOIN actor ON characters.actorid = actor.actorid))) AS DECIMAL(5,2))) FROM characters INNER JOIN actor ON characters.actorid = actor.actorid INNER JOIN movie ON characters.movieid = movie.movieid WHERE actor.birth_country = 'USA' AND movie.title = 'Mrs. Doubtfire';
SELECT (SELECT COUNT(actor.actorid) * 100.0 / (SELECT COUNT(actorid) FROM characters WHERE movieid = (SELECT movieid FROM movie WHERE title = 'Dawn of the Planet of the Apes')) FROM actor INNER JOIN characters ON actor.actorid = characters.actorid WHERE characters.movieid = (SELECT movieid FROM movie WHERE title = 'Dawn of the Planet of the Apes') AND actor.date_of_birth > '1970/1/1') AS percentage;
SELECT movie.movieid FROM movie WHERE budget = 15000000 AND rating BETWEEN 7 AND 8;
SELECT COUNT(*) FROM movie WHERE mpaa_rating = 'PG' AND release_date BETWEEN '1990-06-01' AND '1990-06-30';
SELECT name FROM actor WHERE actorid = 439 AND gender = 'Male' AND ethnicity = 'White';
SELECT movie.genre FROM     actor     JOIN characters ON actor.actorid = characters.actorid     JOIN movie ON characters.movieid = movie.movieid WHERE     actor.birth_city = 'New York City'     AND movie.rating > 5;
SELECT COUNT(*) FROM movie JOIN characters ON movie.movieid = characters.movieid JOIN actor ON characters.actorid = actor.actorid WHERE movie.genre = 'Romance' AND actor.name = 'John Travolta';
SELECT actor.height, actor.networth FROM actor JOIN characters ON actor.actorid = characters.actorid JOIN movie ON characters.movieid = movie.movieid WHERE movie.title = 'Three Men and a Little Lady';
SELECT genre FROM movie JOIN characters ON movie.movieid = characters.movieid JOIN actor ON characters.actorid = actor.actorid WHERE mpaa_rating = 'PG' AND networth = (SELECT MAX(networth) FROM actor);
SELECT actor.networth FROM actor JOIN characters ON actor.actorid = characters.actorid JOIN movie ON characters.movieid = movie.movieid WHERE movie.title = 'Misery' AND actor.height >= 60 AND actor.height <= 70;
SELECT COUNT(actor.actorid) FROM     actor JOIN     characters ON actor.actorid = characters.actorid JOIN     movie ON characters.movieid = movie.movieid WHERE     actor.gender = 'Male'     AND actor.birth_country = 'USA'     AND movie.title = 'Ghost';
SELECT movie.mpaa_rating, movie.title FROM movie JOIN characters ON movie.movieid = characters.movieid JOIN actor ON characters.actorid = actor.actorid WHERE actor.name = 'Leonardo DiCaprio' ORDER BY movie.budget DESC LIMIT 1; 
SELECT actor.networth, actor.date_of_birth FROM actor JOIN characters ON actor.actorid = characters.actorid JOIN movie ON characters.movieid = movie.movieid WHERE movie.title = 'Die Hard 2' AND actor.height BETWEEN 60 AND 65;
SELECT movie.runtime FROM movie JOIN characters ON movie.movieid = characters.movieid JOIN actor ON characters.actorid = actor.actorid WHERE actor.ethnicity = 'African American' AND actor.date_of_birth = '1954-12-28'; 
SELECT actor.name FROM actor JOIN characters ON actor.actorid = characters.actorid JOIN movie ON characters.movieid = movie.movieid WHERE characters.character_name = 'Don Altobello' AND movie.genre = 'Drama' AND movie.gross = 136766062;
SELECT SUM(movie.gross) AS gross FROM movie JOIN characters ON movie.movieid = characters.movieid JOIN actor ON characters.actorid = actor.actorid WHERE movie.genre = 'Comedy' AND movie.rating < 7 AND actor.networth > '$375,000,000.00';
SELECT runtime FROM movie JOIN characters ON movie.movieid = characters.movieid JOIN actor ON characters.actorid = actor.actorid WHERE actor.name = 'Jackie Chan' AND movie.rating > 7; 
SELECT (CAST(COUNT(actor.actorid) AS FLOAT) / (SELECT COUNT(*) FROM characters INNER JOIN movie ON characters.movieid = movie.movieid WHERE genre = 'Drama')) * 100 AS percentage FROM actor INNER JOIN characters ON actor.actorid = characters.actorid INNER JOIN movie ON characters.movieid = movie.movieid WHERE movie.genre = 'Drama' AND actor.networth > '$400,000,000.00';
SELECT characters.character_name FROM characters JOIN actor ON characters.actorid = actor.actorid JOIN movie ON characters.movieid = movie.movieid WHERE actor.gender = 'Female' AND actor.birth_city = 'Sherman Oaks' AND movie.title = 'Bruce Almighty' AND actor.height > (SELECT 0.5 * AVG(height) FROM actor)
SELECT COUNT(*) FROM     twitter WHERE     lang = 'en';
SELECT text FROM twitter WHERE isreshare = 'TRUE'; 
SELECT COUNT(DISTINCT tweetid) FROM twitter WHERE reach > 1000;
SELECT COUNT(*) FROM     twitter JOIN     location ON twitter.locationid = location.locationid JOIN     user ON twitter.userid = user.userid WHERE     sentiment > 0     AND weekday = 'Thursday';
SELECT  text FROM twitter WHERE likes = (SELECT MAX(likes) FROM twitter); 
SELECT city FROM location WHERE country = 'Argentina';
SELECT COUNT(twitter.tweetid) FROM twitter JOIN user ON twitter.userid = user.userid JOIN location ON twitter.locationid = location.locationid WHERE location.country = 'Argentina';
SELECT MAX(COUNT(tweet.tweetid)) AS max_tweet_count, location.city FROM twitter JOIN user ON twitter.userid = user.userid JOIN location ON twitter.locationid = location.locationid WHERE location.country = 'Argentina' GROUP BY location.city;
SELECT COUNT(*) FROM     twitter JOIN     location ON twitter.locationid = location.locationid JOIN     user ON twitter.userid = user.userid WHERE     twitter.isreshare = 'TRUE'     AND location.city = 'Buenos Aires';
SELECT twitter.text FROM twitter JOIN location ON twitter.locationid = location.locationid WHERE location.city = 'Buenos Aires' AND twitter.sentiment > 0; 
SELECT country FROM     twitter JOIN     location ON twitter.locationid = location.locationid WHERE     likes = (SELECT MAX(likes) FROM twitter); 
SELECT country, COUNT(tweetid) AS positive_tweets FROM twitter JOIN location ON twitter.locationid = location.locationid WHERE sentiment > 0 GROUP BY country ORDER BY positive_tweets DESC LIMIT 1;
SELECT COUNT(*) FROM     twitter JOIN     location ON twitter.locationid = location.locationid WHERE     location.city = 'Buenos Aires'     AND twitter.weekday = 'Thursday';
SELECT COUNT(DISTINCT user.userid) FROM     user JOIN     twitter ON user.userid = twitter.userid WHERE     twitter.likes > 1000     AND user.gender = 'Male';
SELECT COUNT(t.tweetid) FROM twitter AS t INNER JOIN user AS u ON t.userid = u.userid WHERE u.gender = 'Male';
SELECT user.gender FROM user JOIN twitter ON user.userid = twitter.userid WHERE twitter.reach = (     SELECT MAX(reach)     FROM twitter ) 
SELECT COUNT(twitter.tweetid) FROM twitter JOIN user ON twitter.userid = user.userid JOIN location ON twitter.locationid = location.locationid WHERE user.gender = 'Male' AND location.country = 'Argentina';
SELECT twitter.text FROM twitter JOIN user ON twitter.userid = user.userid JOIN location ON twitter.locationid = location.locationid WHERE user.gender = 'Male' AND location.city = 'Buenos Aires';
SELECT AVG(COUNT(twitter.tweetid)) FROM     twitter JOIN     location ON twitter.locationid = location.locationid WHERE     location.country = 'Argentina' GROUP BY     location.city;
SELECT 100.0 * COUNT(t.tweetid) / (SELECT COUNT(*) FROM twitter AS t WHERE t.sentiment > 0) FROM twitter AS t INNER JOIN user AS u ON t.userid = u.userid WHERE u.gender = 'Male' AND t.sentiment > 0;
SELECT COUNT(*) FROM     user WHERE     gender = 'Unknown';
SELECT COUNT(DISTINCT state) FROM     location WHERE     country = 'United Kingdom';
SELECT statecode FROM location WHERE state = 'Gwynedd'; 
SELECT locationid FROM location WHERE state = 'West Sussex'; 
SELECT COUNT(*) FROM     twitter JOIN     location ON twitter.locationid = location.locationid WHERE     location.state = 'Texas' AND     twitter.isreshare = 'TRUE';
SELECT location.country FROM twitter JOIN location ON twitter.locationid = location.locationid WHERE twitter.reach = 547851;
SELECT COUNT(twitter.tweetid) FROM twitter JOIN location ON twitter.locationid = location.locationid WHERE location.state = 'Ha Noi' AND twitter.sentiment > 0;
SELECT text FROM     twitter JOIN     user ON twitter.userid = user.userid JOIN     location ON twitter.locationid = location.locationid WHERE     location.state = 'Connecticut' ORDER BY     klout DESC LIMIT 1; 
SELECT COUNT(*) FROM user INNER JOIN location ON user.locationid = location.locationid WHERE user.gender = 'Female' AND location.state = 'Wisconsin';
SELECT user.gender FROM twitter INNER JOIN user ON twitter.userid = user.userid WHERE twitter.tweetid = 'tw-715909161071091712';
SELECT location.city FROM twitter JOIN user ON twitter.userid = user.userid JOIN location ON twitter.locationid = location.locationid WHERE twitter.text = 'One of our favorite stories is @FINRA_News\'s move to the cloud with AWS Enterprise Support! https://amp.twimg.com/v/991837f1-4815-4edc-a88f-e68ded09a02a';
SELECT user.gender FROM twitter JOIN user ON twitter.userid = user.userid WHERE twitter.retweetcount = 535;
SELECT user.gender FROM     user JOIN     twitter ON user.userid = twitter.userid WHERE     twitter.weekday = 'Wednesday' ORDER BY     twitter.klout DESC LIMIT 1; 
SELECT user.gender FROM     twitter JOIN     user ON twitter.userid = user.userid WHERE     twitter.likes = (SELECT MAX(likes) FROM twitter);
SELECT COUNT(t.tweetid) FROM     twitter AS t JOIN     location AS l ON t.locationid = l.locationid WHERE     l.state = 'Michigan'     AND t.weekday = 'Thursday';
SELECT location.statecode FROM twitter JOIN location ON twitter.locationid = location.locationid WHERE twitter.tweetid = 'tw-685681052912873473';
SELECT (CAST((SELECT COUNT(user.userid) FROM user JOIN location ON user.locationid = location.locationid WHERE location.state = 'Florida' AND user.gender = 'Male') AS REAL) /  CAST((SELECT COUNT(user.userid) FROM user JOIN location ON user.locationid = location.locationid WHERE location.state = 'Florida') AS REAL)) * 100;
SELECT (CAST((SELECT COUNT(tweetid) FROM twitter WHERE sentiment > 0 AND locationid IN (SELECT locationid FROM location WHERE state = 'California')) AS REAL) /   CAST((SELECT COUNT(tweetid) FROM twitter WHERE locationid IN (SELECT locationid FROM location WHERE state = 'California')) AS REAL)) * 100 AS percentage_positive_tweets_from_california;
SELECT weekday FROM twitter WHERE tweetid = 'tw-682712873332805633';
SELECT COUNT(DISTINCT twitter.userid) AS unique_users_seen FROM     twitter JOIN     location ON twitter.locationid = location.locationid JOIN     user ON twitter.userid = user.userid WHERE     twitter.text = 'Happy New Year to all those AWS instances of ours!';
SELECT COUNT(tweetid) FROM twitter WHERE lang = 'en';
SELECT CASE     WHEN location.locationid = 3751 THEN 'Yes'     ELSE 'No' END AS is_location_id_3751 FROM twitter JOIN location ON twitter.locationid = location.locationid WHERE twitter.tweetid = 'tw-682714048199311366';
SELECT COUNT(*) FROM     twitter WHERE     weekday = 'Wednesday';
SELECT text FROM twitter WHERE weekday = 'Thursday'; 
SELECT user.gender FROM twitter JOIN user ON twitter.userid = user.userid WHERE twitter.tweetid = 'tw-682714583044243456';
SELECT text FROM     twitter JOIN     user ON twitter.userid = user.userid WHERE     user.gender = 'Unknown'; 
SELECT COUNT(twitter.tweetid) FROM twitter JOIN user ON twitter.userid = user.userid WHERE user.gender = 'Male' 
SELECT user.gender FROM twitter JOIN user ON twitter.userid = user.userid WHERE twitter.lang = 'en' GROUP BY user.gender ORDER BY COUNT(twitter.text) DESC LIMIT 1; 
SELECT user.gender FROM twitter JOIN user ON twitter.userid = user.userid WHERE twitter.retweetcount > 30 
SELECT COUNT(DISTINCT user.userid) FROM     twitter JOIN     user ON twitter.userid = user.userid WHERE     user.gender = 'Female' AND     twitter.isreshare = 'TRUE';
SELECT country, SUM(likes) AS total_likes FROM twitter JOIN location ON twitter.locationid = location.locationid GROUP BY country ORDER BY total_likes DESC LIMIT 1; 
SELECT location.country FROM twitter JOIN location ON twitter.locationid = location.locationid WHERE twitter.tweetid = 'tw-682723090279841798';
SELECT text FROM     twitter JOIN     location ON twitter.locationid = location.locationid WHERE     location.country = 'Australia'; 
SELECT text FROM     twitter JOIN     location ON twitter.locationid = location.locationid WHERE     location.city = 'Rawang'     AND location.state = 'Selangor'     AND location.country = 'Malaysia';
SELECT lang FROM twitter JOIN location ON twitter.locationid = location.locationid WHERE location.country = 'Brazil'; 
SELECT location.country FROM     location JOIN     twitter ON location.locationid = twitter.locationid WHERE     twitter.sentiment > 0 GROUP BY     location.country ORDER BY     COUNT(twitter.sentiment) DESC LIMIT 1;
SELECT SUM(twitter.likes) FROM twitter JOIN user ON twitter.userid = user.userid WHERE user.gender = 'Male' AND twitter.lang = 'ru';
SELECT AVG(CASE WHEN user.gender = 'Male' THEN 1 ELSE 0 END) FROM twitter JOIN user ON twitter.userid = user.userid GROUP BY strftime('%W', twitter.day);
SELECT COUNT(*) FROM     twitter WHERE     klout > 50;
SELECT text FROM twitter WHERE lang <> 'en'; 
SELECT user.userid FROM     user JOIN     twitter ON user.userid = twitter.userid GROUP BY     user.userid ORDER BY     COUNT(twitter.tweetid) DESC LIMIT 1; 
SELECT COUNT(*) FROM     twitter WHERE     weekday = 'Monday'     AND isreshare = 'TRUE';
SELECT text FROM     twitter ORDER BY     reach DESC LIMIT 3; 
SELECT COUNT(*) FROM     twitter WHERE     isreshare = 'TRUE' AND likes > 100;
SELECT COUNT(twitter.tweetid) FROM     twitter JOIN     user ON twitter.userid = user.userid WHERE     user.gender = 'Male'     AND twitter.weekday = 'Monday';
SELECT MAX(user.gender)  FROM twitter  JOIN user ON twitter.userid = user.userid  WHERE likes = (SELECT MAX(likes) FROM twitter);
SELECT text FROM     twitter     JOIN user ON twitter.userid = user.userid WHERE     user.gender = 'Male'     AND twitter.lang = 'fr'; 
SELECT COUNT(*) FROM     twitter JOIN     location ON twitter.locationid = location.locationid WHERE     location.country = 'Australia'     AND twitter.lang = 'fr';
SELECT COUNT(*) FROM     twitter JOIN     user ON twitter.userid = user.userid JOIN     location ON twitter.locationid = location.locationid WHERE     user.gender = 'Male'     AND location.country = 'Australia'     AND twitter.sentiment > 0;
SELECT COUNT(t1.tweetid) - COUNT(t2.tweetid) AS difference FROM twitter AS t1 JOIN twitter AS t2 ON t1.userid = t2.userid JOIN user AS u ON t1.userid = u.userid WHERE t1.sentiment > 0 AND t2.sentiment = 0 AND u.gender = 'Male';
SELECT city FROM     twitter JOIN     location ON twitter.locationid = location.locationid WHERE     retweetcount = (SELECT MAX(retweetcount) FROM twitter); 
SELECT COUNT(*), city FROM twitter JOIN location ON twitter.locationid = location.locationid WHERE city IN ('Bangkok', 'Chiang Mai') GROUP BY city;
SELECT COUNT(*) FROM     twitter JOIN     location ON twitter.locationid = location.locationid WHERE     location.state = 'Santa Fe'     AND location.country = 'Argentina'     AND twitter.day = 31;
SELECT city, COUNT(tweetid) AS tweet_count FROM     location JOIN     twitter ON location.locationid = twitter.locationid WHERE     country = 'Canada' GROUP BY     city ORDER BY     tweet_count DESC LIMIT 3;
SELECT city FROM     twitter JOIN     location ON twitter.locationid = location.locationid WHERE     sentiment = 0; 
SELECT text FROM     twitter JOIN     user ON twitter.userid = user.userid JOIN     location ON twitter.locationid = location.locationid WHERE     user.gender = 'Male'     AND location.country = 'Argentina' ORDER BY     likes DESC LIMIT     1;
SELECT AVG(likes) FROM     twitter JOIN     user ON twitter.userid = user.userid WHERE     user.gender = 'Male'     AND twitter.weekday = 'Monday';
SELECT AVG(likes) AS avg_likes, city FROM twitter JOIN location ON twitter.locationid = location.locationid WHERE city IN ('Bangkok', 'Chiang Mai') GROUP BY city;
SELECT MAX(diff) AS max_diff, CASE      WHEN course_id = 'Intro to BlockChain' THEN 'Intro to BlockChain'     WHEN course_id = 'Computer Network' THEN 'Computer Network' END AS more_difficult_course FROM course WHERE course_id IN ('Intro to BlockChain', 'Computer Network');
SELECT course.name FROM course WHERE course.credit < (SELECT credit FROM course WHERE name = 'Machine Learning Theory'); 
SELECT COUNT(*) FROM prof WHERE popularity > (     SELECT popularity     FROM prof     WHERE last_name = 'Zhou' AND first_name = 'Zhihua' );
SELECT phone_number FROM     student WHERE     f_name = 'Kerry' AND l_name = 'Pryor';
SELECT prof.first_name || ' ' || prof.last_name AS Adviser_Full_Name FROM prof JOIN ra ON ra.prof_id = prof.prof_id JOIN student ON ra.student_id = student.student_id WHERE student.f_name = 'Faina' AND student.l_name = 'Mallinar';
SELECT COUNT(*) FROM     ra JOIN     student ON ra.student_id = student.student_id JOIN     prof ON ra.prof_id = prof.prof_id WHERE     prof.last_name = 'Skyme'     AND prof.first_name = 'Sauveur';
SELECT student.f_name || ' ' || student.l_name AS full_name FROM ra JOIN student ON ra.student_id = student.student_id WHERE ra.capability = 5;
SELECT COUNT(ra.student_id) FROM     ra JOIN     student ON ra.student_id = student.student_id JOIN     prof ON ra.prof_id = prof.prof_id WHERE     prof.last_name = 'Zywicki'     AND prof.first_name = 'Ogdon'     AND ra.salary = 'med';
SELECT student.f_name || ' ' || student.l_name AS full_name FROM student JOIN registration ON student.student_id = registration.student_id JOIN course ON registration.course_id = course.course_id WHERE course.name = 'Machine Learning Theory';
SELECT COUNT(student.student_id) FROM     registration JOIN     course ON registration.course_id = course.course_id JOIN     student ON registration.student_id = student.student_id WHERE     course.name = 'Machine Learning Theory'     AND registration.grade = 'B'     AND student.gpa > 3;
SELECT course.name FROM student JOIN registration ON student.student_id = registration.student_id JOIN course ON registration.course_id = course.course_id WHERE student.f_name = 'Laughton' AND student.l_name = 'Antonio';
SELECT student.f_name, student.l_name FROM     registration JOIN     student ON registration.student_id = student.student_id JOIN     course ON registration.course_id = course.course_id WHERE     course.name = 'Intro to Database 2'     AND registration.grade IS NULL;
SELECT student.f_name, student.l_name FROM registration JOIN student ON registration.student_id = student.student_id JOIN course ON registration.course_id = course.course_id WHERE course.name = 'Machine Learning Theory' AND registration.sat = (     SELECT MAX(sat)     FROM registration     JOIN course ON registration.course_id = course.course_id     WHERE course.name = 'Machine Learning Theory' );
SELECT COUNT(DISTINCT prof.prof_id) FROM     prof JOIN     ra ON ra.prof_id = prof.prof_id GROUP BY     prof.prof_id HAVING     COUNT(ra.student_id) > 3 AND     prof.gender = 'male';
SELECT COUNT(student.student_id) FROM     student JOIN     registration ON student.student_id = registration.student_id JOIN     course ON registration.course_id = course.course_id WHERE     course.name = 'Machine Learning Theory'     AND student.type = 'UG';
SELECT prof.first_name || ' ' || prof.last_name AS Advising_Professor FROM prof JOIN ra ON prof.prof_id = ra.prof_id JOIN student ON ra.student_id = student.student_id WHERE student.f_name = 'Willie' AND student.l_name = 'Rechert';
SELECT AVG(student.gpa)  FROM      student  JOIN      ra ON student.student_id = ra.student_id  JOIN      prof ON ra.prof_id = prof.prof_id  WHERE      prof.last_name = 'Zywicki' AND prof.first_name = 'Ogdon';
SELECT AVG(sat) AS average_satisfying_degree FROM registration WHERE course_id = (SELECT course_id FROM course WHERE name = 'Machine Learning Theory');
SELECT COUNT(*) FROM     student WHERE     type = 'RPG';
SELECT student.f_name || ' ' || student.l_name AS full_name FROM student WHERE student.gpa = (SELECT MAX(gpa) FROM student);
SELECT COUNT(registration.student_id) FROM     registration JOIN     course ON registration.course_id = course.course_id WHERE     course.credit = '3' AND course.diff = 1 AND registration.grade = 'A';
SELECT COUNT(DISTINCT registration.student_id) FROM     registration JOIN     course ON registration.course_id = course.course_id WHERE     course.diff = 5;
SELECT prof.first_name || ' ' || prof.last_name AS full_name FROM prof JOIN ra ON prof.prof_id = ra.prof_id JOIN student ON ra.student_id = student.student_id WHERE student.f_name = 'Oliy' AND student.l_name = 'Spratling';
SELECT prof.popularity FROM prof INNER JOIN ra ON prof.prof_id = ra.prof_id INNER JOIN student ON ra.student_id = student.student_id WHERE student.f_name = "Harrietta" AND student.l_name = "Lydford";
SELECT COUNT(ra.student_id) AS num_research_assistants FROM     ra JOIN     prof ON ra.prof_id = prof.prof_id WHERE     prof.gender = 'female'     AND prof.teachingability = '1';
SELECT prof.first_name || ' ' || prof.last_name AS full_name FROM prof JOIN ra ON prof.prof_id = ra.prof_id GROUP BY prof.prof_id HAVING COUNT(ra.student_id) > 2 ORDER BY MAX(prof.teachingability) DESC LIMIT 1; 
SELECT grade FROM     registration JOIN     student ON registration.student_id = student.student_id JOIN     course ON registration.course_id = course.course_id WHERE     student.f_name = 'Rik' AND student.l_name = 'Unsworth'     AND course.name = 'Computer Network';
SELECT COUNT(course.name) FROM     student JOIN     registration ON student.student_id = registration.student_id JOIN     course ON registration.course_id = course.course_id WHERE     student.f_name = 'Alvera' AND student.l_name = 'McQuillin';
SELECT student.f_name, student.l_name FROM student JOIN ra ON student.student_id = ra.student_id JOIN prof ON ra.prof_id = prof.prof_id WHERE prof.last_name = 'Zhou' AND student.type = 'RPG'
SELECT COUNT(DISTINCT registration.student_id) FROM registration JOIN course ON registration.course_id = course.course_id WHERE course.name = "Statistical Learning"; 
SELECT student.f_name || ' ' || student.l_name AS full_name FROM registration JOIN student ON registration.student_id = student.student_id JOIN course ON registration.course_id = course.course_id WHERE course.name = 'Applied Deep Learning' AND (registration.grade IS NULL OR registration.grade = '');
SELECT student.phone_number FROM     student JOIN     registration ON student.student_id = registration.student_id JOIN     course ON registration.course_id = course.course_id WHERE     course.name = 'Intro to BlockChain'     AND registration.grade = 'A';
SELECT (CAST((SELECT COUNT(ra.student_id)  FROM ra  JOIN prof ON ra.prof_id = prof.prof_id  JOIN student ON ra.student_id = student.student_id  WHERE prof.first_name = 'Ogdon'  AND prof.last_name = 'Zywicki'  AND student.type = 'TPG') AS REAL) /  CAST((SELECT COUNT(ra.student_id)  FROM ra  JOIN prof ON ra.prof_id = prof.prof_id  WHERE prof.first_name = 'Ogdon'  AND prof.last_name = 'Zywicki') AS REAL)) * 100 AS percentage;
SELECT ROUND((CAST((SELECT COUNT(student.student_id) FROM registration JOIN course ON registration.course_id = course.course_id WHERE course.name = 'Computer Network' AND registration.grade = 'B') AS FLOAT) / (SELECT COUNT(student.student_id) FROM registration JOIN course ON registration.course_id = course.course_id WHERE course.name = 'Computer Network')) * 100, 2) AS percentage;
SELECT COUNT(*) FROM course WHERE diff = 5;
SELECT prof.first_name || ' ' || prof.last_name AS full_name FROM prof WHERE prof.graduate_from IN ('Brown University', 'Columbia University', 'Cornell University', 'Dartmouth College', 'Harvard University', 'Princeton University', 'University of Pennsylvania', 'Yale University');
SELECT MAX(course.name) FROM course WHERE course.credit = (SELECT MAX(credit) FROM course) AND course.diff = (SELECT MAX(diff) FROM course);
SELECT COUNT(*) FROM     student WHERE     type = 'UG' AND     intelligence = (SELECT MAX(intelligence) FROM student WHERE type = 'UG');
SELECT COUNT(*) FROM     prof WHERE     popularity = (SELECT MAX(popularity) FROM prof)     AND gender = 'female';
SELECT COUNT(*) FROM     student WHERE     type = 'RPG';
SELECT COUNT(DISTINCT registration.student_id) FROM     registration JOIN     course ON registration.course_id = course.course_id WHERE     course.name = 'Applied Deep Learning'     AND registration.grade = 'A';
SELECT student.gpa FROM ra JOIN student ON ra.student_id = student.student_id WHERE ra.salary = 'free';
SELECT course.name FROM course JOIN registration ON course.course_id = registration.course_id WHERE course.diff = 1 AND registration.grade = 'A' GROUP BY course.name ORDER BY COUNT(*) DESC LIMIT 1;
SELECT COUNT(registration.course_id) FROM     registration WHERE     student_id = (         SELECT            student_id         FROM             student         WHERE             gpa = (                 SELECT                    MAX(gpa)                 FROM                     student             )     );
SELECT COUNT(DISTINCT student_id)  FROM      ra  WHERE      prof_id = (SELECT prof_id FROM prof WHERE last_name = 'Zywicki' AND first_name = 'Ogdon');
SELECT MAX(course.name) FROM course INNER JOIN registration ON course.course_id = registration.course_id WHERE registration.sat = 5;
SELECT course.name FROM     course JOIN     registration ON course.course_id = registration.course_id JOIN     student ON registration.student_id = student.student_id WHERE     student.intelligence = 1     AND registration.sat = 1; 
SELECT COUNT(registration.grade) AS A_count, course.name FROM registration JOIN course ON registration.course_id = course.course_id WHERE registration.grade = 'A' AND (course.name = 'Advanced Operating System' OR course.name = 'Intro to BlockChain') GROUP BY course.name ORDER BY A_count DESC LIMIT 1;
SELECT MAX(prof.popularity) AS popularity FROM     prof JOIN     ra ON prof.prof_id = ra.prof_id JOIN     (         SELECT            prof_id,             COUNT(student_id) AS advise_count         FROM             ra         WHERE             capability = (SELECT MAX(capability) FROM ra)         GROUP BY             prof_id         ORDER BY             advise_count DESC         LIMIT 1     ) AS max_advise ON prof.prof_id = max_advise.prof_id;
SELECT AVG(student_count) FROM (     SELECT        COUNT(student_id) AS student_count     FROM         registration     JOIN         course ON registration.course_id = course.course_id     WHERE         course.diff = 4     GROUP BY         registration.course_id );
SELECT COUNT(DISTINCT student.student_id) FROM     student JOIN     registration ON student.student_id = registration.student_id JOIN     course ON registration.course_id = course.course_id WHERE     student.gpa BETWEEN 3 AND 4     AND (registration.grade IS NULL OR registration.grade = '');
SELECT COUNT(DISTINCT student.student_id) FROM student JOIN registration ON student.student_id = registration.student_id JOIN course ON registration.course_id = course.course_id WHERE student.type = 'UG' AND registration.grade = 'A';
SELECT AVG(student.gpa) AS average_gpa, student.f_name || ' ' || student.l_name AS full_name FROM ra JOIN student ON ra.student_id = student.student_id WHERE ra.capability = 5 AND ra.salary = 'high'
SELECT prof.prof_id, student.student_id FROM ra JOIN prof ON ra.prof_id = prof.prof_id JOIN student ON ra.student_id = student.student_id WHERE ra.capability = (SELECT MIN(capability) FROM ra);
SELECT prof.first_name || ' ' || prof.last_name AS "Name" FROM prof WHERE prof.graduate_from = "University of Boston";
SELECT course.course_id, student.student_id FROM registration INNER JOIN course ON registration.course_id = course.course_id INNER JOIN student ON registration.student_id = student.student_id WHERE registration.grade IS NULL OR registration.grade = '';
SELECT COUNT(CASE WHEN gender = 'Male' THEN prof_id END) AS male_count, COUNT(CASE WHEN gender = 'Female' THEN prof_id END) AS female_count FROM prof;
SELECT name, credit FROM course WHERE diff = (SELECT MIN(diff) FROM course); 
SELECT student.f_name || ' ' || student.l_name AS full_name, student.gpa FROM student JOIN registration ON student.student_id = registration.student_id JOIN course ON registration.course_id = course.course_id JOIN prof ON course.course_id = prof.prof_id WHERE prof.popularity = (SELECT MAX(popularity) FROM prof); 
SELECT student.f_name || ' ' || student.l_name AS full_name, student.email FROM ra JOIN student ON ra.student_id = student.student_id WHERE ra.salary = 'free';
SELECT student.f_name || ' ' || student.l_name AS full_name, ra.capability, student.gpa FROM ra JOIN student ON ra.student_id = student.student_id JOIN prof ON ra.prof_id = prof.prof_id WHERE prof.first_name = 'Merwyn' AND prof.last_name = 'Conkay';
SELECT student.f_name || ' ' || student.l_name AS full_name, registration.grade FROM student JOIN registration ON student.student_id = registration.student_id JOIN course ON registration.course_id = course.course_id WHERE course.name = 'Intro to BlockChain';
SELECT student.f_name, student.l_name FROM registration JOIN course ON registration.course_id = course.course_id JOIN student ON registration.student_id = student.student_id WHERE registration.grade = 'A' AND course.diff = (SELECT MAX(diff) FROM course)
SELECT prof.first_name || ' ' || prof.last_name AS full_name, prof.graduate_from AS graduated_university FROM ra JOIN prof ON ra.prof_id = prof.prof_id JOIN student ON ra.student_id = student.student_id WHERE student.f_name = 'Olia' AND student.l_name = 'Rabier';
SELECT student.f_name, student.l_name FROM registration JOIN student ON registration.student_id = student.student_id JOIN course ON registration.course_id = course.course_id WHERE course.name = 'Advanced Database Systems' AND registration.sat = (     SELECT MAX(sat)     FROM registration     JOIN course ON registration.course_id = course.course_id     WHERE course.name = 'Advanced Database Systems' );
SELECT SUM(course.credit *      CASE          WHEN registration.grade = 'A' THEN 4         WHEN registration.grade = 'B' THEN 3         WHEN registration.grade = 'C' THEN 2         WHEN registration.grade = 'D' THEN 1     END ) / SUM(course.credit) FROM     student JOIN     registration ON student.student_id = registration.student_id JOIN     course ON registration.course_id = course.course_id WHERE     student.f_name = 'Laughton' AND student.l_name = 'Antonio';
SELECT course.name FROM registration JOIN student ON registration.student_id = student.student_id JOIN course ON registration.course_id = course.course_id WHERE student.type = 'UG' AND student.gpa > 3.7; 
SELECT student.f_name, student.l_name, ra.capability FROM student JOIN ra ON ra.student_id = student.student_id JOIN prof ON ra.prof_id = prof.prof_id WHERE prof.graduate_from = 'University of Washington';
SELECT student.f_name || ' ' || student.l_name AS full_name, student.email, student.intelligence FROM student JOIN ra ON ra.student_id = student.student_id WHERE ra.capability = (SELECT MAX(capability) FROM ra) AND ra.salary = 'high';
SELECT course.name, course.credit FROM course JOIN registration ON course.course_id = registration.course_id JOIN ra ON registration.student_id = ra.student_id JOIN prof ON ra.prof_id = prof.prof_id WHERE prof.gender = 'Female' AND prof.teachingability = (SELECT MAX(teachingability) FROM prof WHERE gender = 'Female');
SELECT COUNT(*) FROM prof WHERE gender = 'Female';
SELECT name FROM course WHERE diff = (     SELECT        MAX(diff)     FROM         course ); 
SELECT COUNT(student_id) FROM student WHERE gpa BETWEEN 3.1 AND 3.7 AND type = 'UG';
SELECT credit  FROM course  WHERE name = "Computer Vision"; 
SELECT student.student_id FROM student JOIN registration ON student.student_id = registration.student_id JOIN course ON registration.course_id = course.course_id WHERE student.gpa = 2.5 AND course.name = 'C for Programmers'; 
SELECT student.l_name FROM     registration JOIN student ON registration.student_id = student.student_id WHERE     registration.course_id = (SELECT course_id FROM course WHERE name = 'Intro to Database 2') AND     registration.sat = (SELECT MAX(sat) FROM registration WHERE course_id = (SELECT course_id FROM course WHERE name = 'Intro to Database 2'));
SELECT COUNT(DISTINCT ra.student_id) AS total_students FROM     ra JOIN     student ON ra.student_id = student.student_id WHERE     ra.salary = 'high'     AND student.gpa > 3;
SELECT course.name FROM course JOIN registration ON course.course_id = registration.course_id JOIN student ON registration.student_id = student.student_id WHERE student.type = 'UG' GROUP BY course.name ORDER BY MAX(registration.sat) DESC LIMIT 1;
SELECT ra.capability FROM ra JOIN student ON ra.student_id = student.student_id WHERE student.type = 'RPG' AND student.intelligence >= 4;
SELECT COUNT(DISTINCT student.student_id) FROM     registration JOIN     student ON registration.student_id = student.student_id WHERE     registration.grade = 'B'     AND student.intelligence = 3;
SELECT course.difficulty FROM course JOIN registration ON course.course_id = registration.course_id JOIN student ON registration.student_id = student.student_id WHERE student.intelligence = 5 AND registration.grade = 'A';
SELECT COUNT(*) FROM     registration JOIN     student ON registration.student_id = student.student_id JOIN     prof ON student.student_id = prof.prof_id JOIN     ra ON prof.prof_id = ra.prof_id WHERE     ra.capability = 5 AND     prof.popularity = (SELECT MAX(popularity) FROM prof)
SELECT course.name FROM course JOIN registration ON course.course_id = registration.course_id WHERE registration.grade = 'D'; 
SELECT capability FROM ra JOIN student ON ra.student_id = student.student_id WHERE student.f_name = 'Alvera' AND student.l_name = 'McQuillin';
SELECT COUNT(DISTINCT student_id)  FROM registration  JOIN student ON registration.student_id = student.student_id  JOIN course ON registration.course_id = course.course_id  WHERE course.credit = 3 AND student.gpa = 3.2;
SELECT COUNT(DISTINCT student.student_id) FROM     ra     JOIN student ON ra.student_id = student.student_id WHERE     ra.salary = 'low'     AND student.gpa = 3.5;
SELECT student.email FROM student JOIN registration ON student.student_id = registration.student_id JOIN course ON registration.course_id = course.course_id WHERE registration.grade = 'B' AND course.diff > (SELECT 0.8 * AVG(diff) FROM course);
SELECT ROUND((COUNT(DISTINCT ra.student_id, salary = 'low') * 1.0 / COUNT(DISTINCT ra.student_id)) * 100, 2) AS percentage_low_salary FROM ra JOIN prof ON ra.prof_id = prof.prof_id WHERE prof.teachingability <= 3;
SELECT MAX(credit) AS most_important_course, MAX(diff) AS most_difficult_course FROM course;
SELECT AVG(teachingability)  FROM  prof  WHERE  popularity = (SELECT MAX(popularity) FROM prof);
SELECT AVG(sat) AS average_satisfaction FROM registration JOIN student ON registration.student_id = student.student_id WHERE grade = 'B'; 
SELECT student.f_name || ' ' || student.l_name AS full_name, student.phone_number FROM student WHERE student.intelligence < 4 AND student.gpa > 3;
SELECT student.f_name, student.l_name FROM student JOIN ra ON student.student_id = ra.student_id WHERE ra.capability > (SELECT AVG(capability) FROM ra);
SELECT student.f_name || ' ' || student.l_name AS full_name, course.name AS course_taken FROM student JOIN registration ON student.student_id = registration.student_id JOIN course ON registration.course_id = course.course_id WHERE student.intelligence = 5 AND student.gpa < 3;
SELECT AVG(capability) FROM ra JOIN student ON ra.student_id = student.student_id WHERE student.gpa < 2.5;
SELECT prof.first_name || ' ' || prof.last_name AS full_name FROM prof JOIN ra ON prof.prof_id = ra.prof_id JOIN student ON ra.student_id = student.student_id WHERE student.intelligence = 1;
SELECT (SELECT AVG(gpa) FROM registration JOIN course ON registration.course_id = course.course_id WHERE course.diff = (SELECT MAX(diff) FROM course)) -  (SELECT AVG(gpa) FROM registration JOIN course ON registration.course_id = course.course_id WHERE course.diff = (SELECT MIN(diff) FROM course)); 
SELECT student.f_name || ' ' || student.l_name AS full_name, ra.capability FROM student JOIN ra ON ra.student_id = student.student_id JOIN registration ON registration.student_id = student.student_id JOIN course ON registration.course_id = course.course_id WHERE registration.grade IS NULL;
SELECT COUNT(DISTINCT registration.student_id) FROM     registration JOIN     ra ON registration.student_id = ra.student_id JOIN     course ON registration.course_id = course.course_id WHERE     ra.salary = 'High'     AND course.name = 'computer vision';
SELECT prof.first_name || ' ' || prof.last_name AS full_name, MAX(prof.popularity) AS popularity FROM prof INNER JOIN ra ON prof.prof_id = ra.prof_id GROUP BY prof.prof_id ORDER BY COUNT(ra.student_id) DESC LIMIT 1; 
SELECT course.name, student.f_name, student.l_name FROM registration JOIN course ON registration.course_id = course.course_id JOIN student ON registration.student_id = student.student_id WHERE registration.grade = 'A' GROUP BY course.name ORDER BY COUNT(*) DESC LIMIT 1;
SELECT AVG(CASE WHEN ra.salary = 'high' THEN registration.sat ELSE NULL END) - AVG(CASE WHEN ra.salary = 'free' THEN registration.sat ELSE NULL END) AS satisfaction_difference 
SELECT graduate_from FROM prof WHERE prof_id = (     SELECT prof_id     FROM (         SELECT prof_id, COUNT(*) AS num_students         FROM ra         JOIN prof ON ra.prof_id = prof.prof_id         JOIN student ON ra.student_id = student.student_id         WHERE student.type = 'UG'         GROUP BY prof_id         ORDER BY num_students DESC         LIMIT 1     ) AS advised_most ) 
SELECT prof.first_name || ' ' || prof.last_name AS full_name, prof.email FROM prof INNER JOIN ra ON prof.prof_id = ra.prof_id GROUP BY ra.prof_id HAVING prof.teachingability > (SELECT AVG(teachingability) FROM prof) AND COUNT(ra.student_id) >= 2; 
SELECT  ROUND((COUNT(CASE WHEN sat = (SELECT MAX(sat) FROM registration WHERE course_id = (SELECT course_id FROM course WHERE name = 'Intro to Database 2')) THEN 1 END) * 100.0) / COUNT(student_id), 2) AS percentage FROM registration WHERE course_id = (SELECT course_id FROM course WHERE name = 'Intro to Database 2'); 
SELECT student.f_name, student.l_name FROM student WHERE student.gpa = (SELECT MAX(gpa) FROM student);
SELECT COUNT(*) FROM     ra JOIN     prof ON ra.prof_id = prof.prof_id JOIN     student ON ra.student_id = student.student_id WHERE     prof.teachingability = (SELECT MAX(teachingability) FROM prof)     AND ra.salary = 'high';
SELECT MIN(ra.salary) AS min_salary, MAX(ra.salary) AS max_salary FROM ra JOIN student ON ra.student_id = student.student_id WHERE student.email = 'grosellg@hku.hk';
SELECT COUNT(DISTINCT registration.student_id) FROM     registration     JOIN student ON registration.student_id = student.student_id     JOIN course ON registration.course_id = course.course_id WHERE     course.name = "Statistical Learning"     AND registration.grade = 4     AND student.gpa = 3.8;
SELECT COUNT(DISTINCT student.student_id) FROM     registration JOIN course ON registration.course_id = course.course_id JOIN student ON registration.student_id = student.student_id WHERE     course.diff = 3     AND student.intelligence = 2;
SELECT student.f_name, student.l_name FROM student JOIN registration ON student.student_id = registration.student_id JOIN course ON registration.course_id = course.course_id WHERE course.name = 'Applied Deep Learning' AND registration.grade = 'C';
SELECT course.name FROM course JOIN registration ON course.course_id = registration.course_id JOIN student ON registration.student_id = student.student_id WHERE student.type = 'RPG' AND registration.sat = 1;
SELECT COUNT(CASE WHEN student.type = 'UG' THEN 1 ELSE NULL END) - COUNT(CASE WHEN student.type = 'RPG' THEN 1 ELSE NULL END) AS difference FROM ra JOIN student ON ra.student_id = student.student_id WHERE ra.capability < 3;
SELECT AVG(COUNT(advisedby.p_id)) FROM advisedby GROUP BY p_id_dummy;
SELECT COUNT(DISTINCT professor) FROM taughtby WHERE course_id = 18;
SELECT course.course_id FROM course WHERE course.courselevel = 'Level_500'; 
SELECT COUNT(course.course_id) FROM     course WHERE     course.courseLevel = 'Level_300';
SELECT person.p_id, taughtby.course_id FROM person JOIN taughtby ON person.p_id = taughtby.p_id WHERE person.professor = 1 AND person.p_id NOT IN (SELECT p_id FROM hasposition WHERE hasposition = 1) 
SELECT taughtby.p_id FROM taughtby JOIN course ON taughtby.course_id = course.course_id WHERE (course.courselevel = 'Level_400' OR course.courselevel = 'Harder') 
SELECT course.course_id FROM course JOIN taughtby ON course.course_id = taughtby.course_id JOIN person ON taughtby.p_id = person.p_id JOIN advisedby ON person.p_id = advisedby.p_id_dummy WHERE advisedby.p_id = 376; 
SELECT person.professor FROM advisedby JOIN person ON advisedby.p_id_dummy = person.p_id JOIN person ON advisedby.p_id = person.p_id JOIN hasposition ON person.p_id = hasposition.p_id JOIN inphase ON hasposition.p_id = inphase.p_id WHERE inphase.yearsinprogram = 'Year_3' AND hasposition.professor = 1;
SELECT course.courselevel FROM course JOIN taughtby ON course.course_id = taughtby.course_id WHERE taughtby.p_id = 297; 
SELECT course.courselevel, person.professor FROM course JOIN taughtby ON course.course_id = taughtby.course_id JOIN person ON taughtby.p_id = person.p_id WHERE course.course_id = 165;
SELECT person.p_id, person.yearsinprogram FROM person JOIN taughtby ON person.p_id = taughtby.p_id JOIN advisedby ON person.p_id = advisedby.p_id WHERE advisedby.p_id_dummy = 5 AND person.student = 1; 
SELECT course.course_id, course.courselevel FROM course JOIN taughtby ON course.course_id = taughtby.course_id JOIN person ON taughtby.p_id = person.p_id WHERE person.professor = 1 AND person.hasposition = 'Faculty_eme'; 
SELECT advisedby.p_id_dummy AS advisor_id, course.courselevel AS course_level FROM advisedby JOIN person ON advisedby.p_id_dummy = person.p_id JOIN taughtby ON person.p_id = taughtby.p_id JOIN course ON taughtby.course_id = course.course_id WHERE advisedby.p_id = 80;
SELECT DISTINCT taughtby.p_id FROM     taughtby JOIN     course ON taughtby.course_id = course.course_id WHERE     course.courselevel = 'Level_400'     AND taughtby.p_id IN (         SELECT            p_id         FROM             taughtby         JOIN             course ON taughtby.course_id = course.course_id         WHERE             course.courselevel = 'Level_500'     );
SELECT DISTINCT person.professor FROM person JOIN advisedby ON person.p_id = advisedby.p_id_dummy JOIN person AS student ON advisedby.p_id = student.p_id WHERE student.yearsInProgram = 'Year_12'; 
SELECT course.course_id, course.courselevel FROM course JOIN taughtby ON course.course_id = taughtby.course_id GROUP BY course.course_id, course.courselevel ORDER BY COUNT(taughtby.p_id) DESC LIMIT 1; 
SELECT COUNT(*) AS num_courses FROM course WHERE courselevel IN ('Basic', 'Medium') AND course_id LIKE 'U%';
SELECT COUNT(*) FROM taughtby WHERE course_id = 11;
SELECT MAX(course16) AS course16_teacher_count, MAX(course18) AS course18_teacher_count FROM (     SELECT COUNT(taughtby.p_id) AS course16     FROM taughtby     WHERE course_id = 16 ), (     SELECT COUNT(taughtby.p_id) AS course18     FROM taughtby     WHERE course_id = 18 );
SELECT COUNT(DISTINCT person.p_id) FROM person JOIN advisedby ON person.p_id = advisedby.p_id JOIN hasposition ON person.p_id = hasposition.p_id WHERE professor = 1 AND hasposition = 'Faculty_eme';
SELECT advisedby.p_id_dummy FROM advisedby GROUP BY advisedby.p_id_dummy HAVING COUNT(advisedby.p_id) > 4; 
SELECT COUNT(DISTINCT taughtby.course_id) FROM     taughtby JOIN     course ON taughtby.course_id = course.course_id JOIN     person ON taughtby.p_id = person.p_id WHERE     course.courselevel IN ('basic', 'medium')     AND     course.professor = 1     AND     course.courselevel = 'Level_300';
SELECT DISTINCT person.p_id FROM person JOIN taughtby ON person.p_id = taughtby.p_id JOIN course ON taughtby.course_id = course.course_id WHERE course.courseLevel IN ('Level_200', 'Level_300') AND person.hasPosition = 'Faculty_eme'; 
SELECT COUNT(*)  FROM taughtby  JOIN hasposition ON taughtby.p_id = hasposition.p_id  WHERE taughtby.course_id = 9 AND hasposition != 0; 
SELECT course.courselevel FROM taughtby JOIN course ON taughtby.course_id = course.course_id WHERE taughtby.p_id = 79;
SELECT advisedby.p_id_dummy FROM advisedby JOIN person ON advisedby.p_id = person.p_id JOIN inphase ON person.p_id = inphase.p_id WHERE inphase.yearsinprogram = 'Year_5'
SELECT COUNT(DISTINCT advisedby.p_id) AS advised_students FROM advisedby JOIN person ON advisedby.p_id = person.p_id JOIN taughtby ON person.p_id = taughtby.p_id JOIN course ON taughtby.course_id = course.course_id WHERE course.courselevel = 'Level_300'
SELECT COUNT(DISTINCT taughtby.course_id) FROM     course JOIN     taughtby ON course.course_id = taughtby.course_id JOIN     person ON taughtby.p_id = person.p_id WHERE     course.courselevel IN ('Level_100', 'Level_200')     AND person.hasposition != 0;
SELECT course.course_id FROM course JOIN taughtby ON course.course_id = taughtby.course_id JOIN person ON taughtby.p_id = person.p_id JOIN advisedby ON person.p_id_dummy = advisedby.p_id WHERE advisedby.p_id = 6 AND person.professor = 1; 
SELECT MAX(course.courselevel) FROM     course WHERE     course.course_id IN (         SELECT            course_id         FROM             taughtby         GROUP BY             course_id         ORDER BY             COUNT(p_id) DESC         LIMIT 1     );
SELECT p_id FROM taughtby WHERE p_id IN (     SELECT p_id     FROM taughtby     WHERE p_id IN (         SELECT p_id         FROM person         WHERE professor = 1     )     GROUP BY p_id     HAVING COUNT(course_id) > 3 ); 
SELECT taughtby.p_id, COUNT(taughtby.course_id) AS num_courses_taught FROM taughtby JOIN person ON taughtby.p_id = person.p_id WHERE person.professor = 1 GROUP BY taughtby.p_id ORDER BY num_courses_taught DESC LIMIT 3; 
SELECT COUNT(DISTINCT advisedby.p_id_dummy) AS total_professors_advising_3rd_year_students FROM     advisedby JOIN     person ON advisedby.p_id = person.p_id JOIN     person AS p ON advisedby.p_id_dummy = p.p_id JOIN     hasposition ON p.p_id = hasposition.p_id JOIN     yearsinprogram ON person.p_id = yearsinprogram.p_id WHERE     yearsinprogram.yearsInProgram = 'Year_3'     AND hasposition.position = 'professor'     AND person.student = 1;
SELECT AVG(CASE WHEN professor = 1 THEN 1 ELSE 0 END) FROM taughtby;
SELECT COUNT(CASE WHEN professor = 1 THEN person.p_id END) * 1.0 / COUNT(CASE WHEN student = 1 THEN person.p_id END) FROM person;
SELECT 100 * COUNT(course.course_id) / (SELECT COUNT(*) FROM course) FROM course WHERE courseLevel = 'Level_400';
SELECT p_id FROM taughtby WHERE course_id = 18; 
SELECT hasposition.position, person.p_id_dummy FROM person JOIN advisedby ON advisedby.p_id = person.p_id JOIN hasposition ON hasposition.p_id = person.p_id WHERE advisedby.p_id_dummy = 303; 
SELECT person.p_id, course.courselevel FROM person JOIN advisedby ON person.p_id = advisedby.p_id JOIN taughtby ON person.p_id = taughtby.p_id JOIN course ON taughtby.course_id = course.course_id WHERE person.professor = 1 AND person.hasposition = 'Faculty_aff';
SELECT MAX(yearsinprogram) AS year_in_program, MAX(inphase) AS in_phase FROM person JOIN advisedby ON person.p_id = advisedby.p_id_dummy WHERE person.p_id IN (     SELECT student     FROM person     JOIN advisedby ON person.p_id = advisedby.p_id     GROUP BY student     ORDER BY COUNT(p_id_dummy) DESC     LIMIT 1 );
SELECT person.p_id AS advised_student_id, person.p_id_dummy AS employing_professor_id FROM advisedby JOIN person ON advisedby.p_id = person.p_id WHERE person.hasposition = 'Faculty_eme';
SELECT course.course_id, course.courselevel FROM course JOIN taughtby ON course.course_id = taughtby.course_id WHERE taughtby.p_id BETWEEN 40 AND 50;
SELECT course.courselevel, person.p_id FROM course JOIN taughtby ON course.course_id = taughtby.course_id JOIN person ON taughtby.p_id = person.p_id WHERE course.course_id = 147; 
SELECT person.p_id, course.courselevel FROM     person JOIN     taughtby ON person.p_id = taughtby.p_id JOIN     course ON taughtby.course_id = course.course_id WHERE     course.course_id = 104 AND     person.professor = 1 AND     person.hasposition != 0;
SELECT person.p_id, person.hasPosition FROM taughtby JOIN course ON taughtby.course_id = course.course_id JOIN person ON taughtby.p_id = person.p_id WHERE course.courselevel = 'Level_400' AND course.course_id < 10 AND person.professor = 1; 
SELECT taughtby.p_id FROM taughtby JOIN course ON taughtby.course_id = course.course_id WHERE course.courselevel = 'Level_300' AND course.course_id BETWEEN 121 AND 130; 
SELECT advisedby.p_id_dummy FROM advisedby JOIN person ON advisedby.p_id = person.p_id WHERE person.student = 1 AND person.yearsinprogram = 'Year_8' AND person.hasposition = 1;
SELECT course.course_id, taughtby.p_id FROM taughtby JOIN course ON taughtby.course_id = course.course_id JOIN person ON taughtby.p_id = person.p_id WHERE course.courselevel = 'Level_500' LIMIT 5; 
SELECT COUNT(DISTINCT student) FROM     advisedby     JOIN person ON advisedby.p_id = person.p_id WHERE     advisedby.p_id_dummy = 415;
SELECT COUNT(*)  FROM course  WHERE courseLevel = 'Level_500';
SELECT COUNT(DISTINCT person.p_id)  FROM      person  LEFT JOIN      hasposition ON person.p_id = hasposition.p_id  LEFT JOIN      inphase ON person.p_id = inphase.p_id  WHERE      hasposition.professor IS NULL      AND inphase.inphase IS NULL
SELECT professor, COUNT(course_id) AS num_courses_taught FROM taughtby GROUP BY professor ORDER BY num_courses_taught ASC LIMIT 1; 
SELECT COUNT(*) FROM person JOIN advisedby ON person.p_id = advisedby.p_id WHERE advisedby.p_id_dummy = 5 AND person.yearsinprogram = 'Year_5';
SELECT  SELECT professor, COUNT(course_id) AS course_count FROM taughtby JOIN course ON taughtby.course_id = course.course_id WHERE courselevel = 'Level_500' GROUP BY professor ORDER BY course_count DESC LIMIT 1; 
SELECT COUNT(DISTINCT person.p_id) FROM     person JOIN     advisedby ON person.p_id = advisedby.p_id JOIN     taughtby ON person.p_id = taughtby.p_id JOIN     course ON taughtby.course_id = course.course_id WHERE     person.professor = 1     AND person.hasposition = 'Faculty_aff'     AND course.courselevel = 'Level_500';
SELECT person.professor, COUNT(course.course_id) AS num_courses FROM person JOIN taughtby ON person.p_id = taughtby.p_id JOIN course ON taughtby.course_id = course.course_id WHERE course.courselevel IN ('Professional', 'Master', 'Undergraduate') GROUP BY person.professor ORDER BY num_courses DESC LIMIT 5; 
SELECT COUNT(DISTINCT advisedby.p_id_dummy) AS num_advisors FROM advisedby JOIN person ON advisedby.p_id_dummy = person.p_id JOIN inphase ON person.p_id = inphase.p_id WHERE inphase.student = 1 AND inphase.yearsinprogram = 'Year_1';
SELECT COUNT(DISTINCT taughtby.p_id) FROM taughtby JOIN course ON taughtby.course_id = course.course_id WHERE course.courselevel >= 'Level_400' GROUP BY taughtby.p_id HAVING COUNT(taughtby.course_id) <= 2;
SELECT COUNT(DISTINCT person.p_id) FROM     person JOIN     hasposition ON person.p_id = hasposition.p_id JOIN     taughtby ON person.p_id = taughtby.p_id JOIN     course ON taughtby.course_id = course.course_id WHERE     hasposition.professor = 1     AND hasposition.hasposition = 'Faculty_eme'     AND course.courselevel = 'Level_400';
SELECT MAX(hasposition) FROM   person JOIN   taughtby ON person.p_id = taughtby.p_id WHERE   professor = 1 GROUP BY   person.p_id ORDER BY   COUNT(taughtby.course_id) DESC LIMIT 1;
SELECT yearsinprogram FROM person WHERE student = 1 GROUP BY yearsinprogram HAVING COUNT(DISTINCT advisedby.p_id_dummy) > 2; 
SELECT COUNT(DISTINCT taughtby.p_id) FROM     taughtby     JOIN course ON taughtby.course_id = course.course_id WHERE     course.courselevel IN ('Level_100', 'Level_200');
SELECT advisedby.p_id, MAX(COUNT(yearsinprogram)) FROM advisedby JOIN person ON advisedby.p_id = person.p_id WHERE person.student = 1 GROUP BY advisedby.p_id; 
SELECT COUNT(DISTINCT person.p_id)  FROM      person  JOIN      inphase ON person.p_id = inphase.p_id  JOIN      student ON person.p_id = student.p_id  JOIN      advisedby ON person.p_id = advisedby.p_id_dummy  WHERE      inphase.inphase = 'Pre-Quals';
SELECT AVG(CASE WHEN course.courselevel = 'Level_500' THEN 1 ELSE 0 END) FROM taughtby JOIN course ON taughtby.course_id = course.course_id GROUP BY taughtby.p_id
SELECT COUNT(DISTINCT course_id) AS num_courses FROM taughtby GROUP BY course_id HAVING COUNT(p_id) > 4; 
SELECT COUNT(course.course_id) AS total_courses, GROUP_CONCAT(course.course_id) AS course_ids FROM course WHERE course.courselevel = 'Level_500'; 
SELECT SUM(CASE WHEN yearsinprogram = 'Year_1' THEN 1 ELSE 0 END) + SUM(CASE WHEN yearsinprogram = 'Year_2' THEN 1 ELSE 0 END) FROM person WHERE student = 1;
SELECT COUNT(DISTINCT taughtby.course_id) AS num_courses_taught_by_faculty FROM taughtby JOIN person ON taughtby.p_id = person.p_id WHERE person.professor = 1 AND person.hasposition <> 0;
SELECT MAX(taughtby.p_id) AS professor_id, hasposition.position FROM taughtby JOIN person ON taughtby.p_id = person.p_id JOIN hasposition ON person.p_id = hasposition.p_id GROUP BY hasposition.position ORDER BY COUNT(taughtby.course_id) DESC LIMIT 1;
SELECT course.course_id FROM taughtby INNER JOIN course ON taughtby.course_id = course.course_id INNER JOIN person ON taughtby.p_id = person.p_id WHERE person.professor = 1 AND person.hasposition = 0;
SELECT MAX(COUNT(course.course_id)) AS max_course_count,  person.professor AS faculty_member,  course.courselevel AS general_course_level FROM person JOIN hasposition ON person.p_id = hasposition.p_id JOIN taughtby ON person.p_id = taughtby.p_id JOIN course ON taughtby.course_id = course.course_id GROUP BY person.professor ORDER BY max_course_count DESC LIMIT 1;
SELECT MAX(gender_age.age) AS max_age FROM     gender_age;
SELECT COUNT(*) FROM     events_relevant WHERE     longitude = 97 AND latitude = 40;
SELECT COUNT(*) FROM gender_age WHERE gender = 'M' AND "group" = 'M32-38';
SELECT COUNT(DISTINCT gender_age.device_id) FROM gender_age WHERE gender = 'F' AND age > 50;
SELECT COUNT(DISTINCT gender_age.device_id) AS active_users FROM     events_relevant JOIN     app_events_relevant ON events_relevant.event_id = app_events_relevant.event_id JOIN     gender_age ON events_relevant.device_id = gender_age.device_id WHERE     app_events_relevant.event_id = 2 AND     app_events_relevant.is_active = 1;
SELECT gender FROM gender_age WHERE age = (SELECT MIN(age) FROM gender_age);
SELECT MAX(category) FROM     (     SELECT        lc.category,         COUNT(DISTINCT ga.device_id) AS user_count     FROM         gender_age ga     INNER JOIN         phone_brand_device_model2 pb ON ga.device_id = pb.device_id     INNER JOIN         events_relevant er ON ga.device_id = er.device_id     INNER JOIN         app_events_relevant aer ON er.event_id = aer.event_id     INNER JOIN         app_all aa ON aer.app_id = aa.app_id     INNER JOIN         app_labels al ON aa.app_id = al.app_id     INNER JOIN         label_categories lc ON al.label_id = lc.label_id     GROUP BY         lc.category     ) ORDER BY     user_count DESC;
SELECT phone_brand_device_model2.device_model FROM gender_age_train JOIN phone_brand_device_model2 ON gender_age_train.device_id = phone_brand_device_model2.device_id WHERE age = (SELECT MAX(age) FROM gender_age_train);
SELECT COUNT(DISTINCT gender_age.device_id) FROM     gender_age JOIN     phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id JOIN     events_relevant ON gender_age.device_id = events_relevant.device_id JOIN     app_events_relevant ON events_relevant.event_id = app_events_relevant.event_id JOIN     app_all ON app_events_relevant.app_id = app_all.app_id JOIN     app_labels ON app_all.app_id = app_labels.app_id JOIN     label_categories ON app_labels.label_id = label_categories.label_id WHERE     label_categories.category = 'Home Decoration';
SELECT COUNT(DISTINCT gender_age.device_id) FROM     gender_age JOIN     events_relevant ON gender_age.device_id = events_relevant.device_id WHERE     gender_age.gender = 'M'     AND events_relevant.timestamp LIKE '2016-05-01%'     AND events_relevant.is_active = 1;
SELECT COUNT(DISTINCT gender_age.device_id) FROM     gender_age JOIN     phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE     gender_age.gender = 'F'     AND phone_brand_device_model2.device_model = 'ZenFone 5';
SELECT MAX(age) FROM     gender_age_train WHERE     device_id IN (         SELECT            gender_age.device_id         FROM             gender_age             INNER JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id             INNER JOIN events_relevant ON gender_age.device_id = events_relevant.device_id         WHERE             events_relevant.timestamp LIKE '2016-05-06%'             AND events_relevant.longitude = 121             AND events_relevant.latitude = 31             AND gender_age.is_active = 1     );
SELECT MAX(device_model) FROM     phone_brand_device_model2 WHERE     device_id IN (         SELECT            ga.device_id         FROM             gender_age AS ga         JOIN             gender_age_train AS gat ON ga.device_id = gat.device_id         WHERE             ga.gender = 'F' AND ga.group = 'F27-28'     );
SELECT label_categories.category FROM     events_relevant JOIN     app_events_relevant ON events_relevant.event_id = app_events_relevant.event_id JOIN     app_all ON app_events_relevant.app_id = app_all.app_id JOIN     app_labels ON app_all.app_id = app_labels.app_id JOIN     label_categories ON app_labels.label_id = label_categories.label_id WHERE     events_relevant.timestamp IN (         SELECT            timestamp         FROM             events_relevant         ORDER BY             timestamp ASC         LIMIT             2     ); 
SELECT gender FROM gender_age JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE phone_brand = 'vivo' GROUP BY gender ORDER BY COUNT(*) DESC LIMIT 1;
SELECT MAX(category) FROM     label_categories GROUP BY     label_id ORDER BY     COUNT(app_id) DESC LIMIT 1;
SELECT COUNT(DISTINCT gender_age.device_id) FROM     gender_age JOIN     phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id JOIN     events_relevant ON gender_age.device_id = events_relevant.device_id JOIN     app_events_relevant ON events_relevant.event_id = app_events_relevant.event_id JOIN     app_labels ON app_events_relevant.app_id = app_labels.app_id JOIN     label_categories ON app_labels.label_id = label_categories.label_id WHERE     label_categories.category = 'MOBA';
SELECT DIVIDE(     MULTIPLY(         CONCAT(             COUNT(gender_age.device_id WHERE phone_brand = 'OPPO' AND gender = 'F'), 100),         COUNT(gender_age.device_id)),     '%') AS 'the percentage of female OPPO users', DIVIDE(     MULTIPLY(         CONCAT(             COUNT(gender_age.device_id WHERE phone_brand = 'OPPO' AND gender = 'M'), 100),         COUNT(gender_age.device_id)),     '%') AS 'the percentage of male OPPO users' 
SELECT events.longitude, events.latitude FROM events WHERE events.timestamp LIKE '2016-05-08%';
SELECT app_all.app_id, CASE WHEN app_events.is_installed = 1 THEN 1 ELSE 0 END AS is_installed FROM app_events JOIN app_all ON app_events.app_id = app_all.app_id WHERE app_events.event_id = 844;
SELECT COUNT(*) FROM events WHERE timestamp LIKE '2016-04-30%';
SELECT COUNT(DISTINCT gender_age.device_id) FROM gender_age JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE phone_brand_device_model2.phone_brand = 'vivo' AND phone_brand_device_model2.device_model = 'Xplay3S';
SELECT COUNT(CASE WHEN gender = 'M' AND `group` = 'M27-28' THEN device_id END) AS male_count, COUNT(CASE WHEN gender = 'F' AND `group` = 'F27-28' THEN device_id END) AS female_count, CAST(COUNT(CASE WHEN gender = 'M' AND `group` = 'M27-28' THEN device_id END) AS REAL) / CAST(COUNT(CASE WHEN gender = 'F' AND `group` = 'F27-28' THEN device_id END) AS REAL) AS ratio FROM gender_age WHERE `group` = 'F27-28';
SELECT label_id FROM label_categories WHERE category = 'Online Shopping' OR category = 'Online Malls'; 
SELECT phone_brand, 	device_model FROM 	events_relevant JOIN 	gender_age ON events_relevant.device_id = gender_age.device_id JOIN 	phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE 	events_relevant.timestamp LIKE '2016-05-05%' 	AND events_relevant.longitude = 112 	AND events_relevant.latitude = 44;
SELECT app_all.app_id, events.timestamp FROM app_all JOIN app_events ON app_all.app_id = app_events.app_id JOIN events ON app_events.event_id = events.event_id WHERE events.event_id = 82;
SELECT gender_age.gender, gender_age.age FROM events_relevant JOIN gender_age ON events_relevant.device_id = gender_age.device_id WHERE events_relevant.event_id = 15251;
SELECT COUNT(*) AS event_count FROM     events_relevant WHERE     device_id IN (SELECT device_id FROM gender_age WHERE age = 88 AND gender = 'M')     AND timestamp LIKE '2016-05-04%';
SELECT COUNT(gender_age.gender) AS num_events, gender_age.gender, gender_age.age FROM events_relevant JOIN gender_age ON events_relevant.device_id = gender_age.device_id WHERE events_relevant.longitude = -102 AND events_relevant.latitude = 38 GROUP BY gender_age.gender, gender_age.age;
SELECT phone_brand, device_model FROM phone_brand_device_model2 WHERE device_id IN (     SELECT    device_id     FROM     gender_age     WHERE     device_id IN (         SELECT        device_id         FROM         events_relevant         WHERE         longitude = 80 AND latitude = 44     ) )
SELECT category FROM label_categories JOIN app_labels ON label_categories.label_id = app_labels.label_id JOIN app_events ON app_labels.app_id = app_events.app_id WHERE app_events.event_id = 155; 
SELECT events_relevant.device_id FROM phone_brand_device_model2 INNER JOIN gender_age ON phone_brand_device_model2.device_id = gender_age.device_id INNER JOIN events_relevant ON gender_age.device_id = events_relevant.device_id WHERE phone_brand_device_model2.phone_brand = 'HTC' AND phone_brand_device_model2.device_model = 'Butterfly' AND gender_age.gender = 'F' LIMIT 5;
SELECT COUNT(DISTINCT app_labels.app_id) FROM     app_labels JOIN     label_categories ON app_labels.label_id = label_categories.label_id WHERE     label_categories.category = 'science fiction'
SELECT gender_age_train.gender, gender_age_train.age FROM gender_age_train JOIN phone_brand_device_model2 ON gender_age_train.device_id = phone_brand_device_model2.device_id WHERE phone_brand_device_model2.phone_brand = 'LG' AND phone_brand_device_model2.device_model = 'L70';
SELECT (MULTIPLY(CONCAT(COUNT(app_id) * 100 / (SELECT COUNT(app_id) FROM app_all WHERE app_id IN (SELECT app_id FROM app_labels WHERE label_id IN (SELECT label_id FROM label_categories WHERE category = 'Industry tag')))), '%')) AS percentage FROM app_all WHERE app_id IN (SELECT app_id FROM app_labels WHERE label_id IN (SELECT label_id FROM label_categories WHERE category = 'Industry tag'));
SELECT 100 * COUNT(DISTINCT CASE WHEN phone_brand = 'LG' THEN device_id END) / COUNT(DISTINCT device_id) AS percentage_Nexus_5_users, DIVIDE(COUNT(DISTINCT CASE WHEN phone_brand = 'LG' AND device_model = 'Nexus 5' AND gender = 'M' THEN device_id END), COUNT(DISTINCT CASE WHEN phone_brand = 'LG' AND device_model = 'Nexus 5' AND gender = 'F' THEN device_id END)) AS male_to_female_ratio_Nexus_5_users FROM phone_brand_device_model2 JOIN gender_age ON phone_brand_device_model2.device_id = gender_age.device_id;
SELECT COUNT(DISTINCT gender_age.device_id) FROM     gender_age LEFT JOIN     events_relevant ON gender_age.device_id = events_relevant.device_id WHERE     events_relevant.event_id = 2 AND     events_relevant.is_active = 0;
SELECT COUNT(*) FROM events WHERE timestamp LIKE '2016%';
SELECT COUNT(*) FROM     events WHERE     device_id = '29182687948017100'     AND timestamp LIKE '2016%'
SELECT COUNT(DISTINCT gender_age.device_id) FROM gender_age WHERE gender = 'M';
SELECT MAX(age) FROM gender_age;
SELECT COUNT(DISTINCT gender_age.device_id) FROM     gender_age WHERE     gender = 'F'     AND age < 30;
SELECT COUNT(gender_age.device_id) FROM gender_age JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE phone_brand_device_model2.device_model = 'Galaxy Note 2' AND gender_age.gender = 'F';
SELECT age FROM gender_age JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE phone_brand_device_model2.device_model = 'Galaxy Note 2';
SELECT phone_brand_device_model2.device_model FROM gender_age JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE gender_age.age = (SELECT MAX(age) FROM gender_age)
SELECT MAX(COUNT(group)) FROM     gender_age JOIN     phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE     phone_brand = 'vivo' GROUP BY     gender_age.group;
SELECT COUNT(DISTINCT gender_age.device_id) FROM     gender_age JOIN     phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id JOIN     app_events_relevant ON gender_age.device_id = app_events_relevant.device_id JOIN     app_all ON app_events_relevant.app_id = app_all.app_id JOIN     app_labels ON app_all.app_id = app_labels.app_id JOIN     label_categories ON app_labels.label_id = label_categories.label_id WHERE     label_categories.category = 'Securities'
SELECT label_categories.category FROM     app_labels JOIN     label_categories ON app_labels.label_id = label_categories.label_id WHERE     app_labels.app_id = 1977658975649780000;
SELECT label_categories.category FROM     label_categories JOIN     app_labels ON label_categories.label_id = app_labels.label_id JOIN     app_all ON app_labels.app_id = app_all.app_id LEFT JOIN     app_events_relevant ON app_all.app_id = app_events_relevant.app_id LEFT JOIN     events_relevant ON app_events_relevant.event_id = events_relevant.event_id WHERE     events_relevant.event_id = 2     AND events_relevant.is_active = 0;
SELECT events_relevant.longitude, events_relevant.latitude FROM events_relevant JOIN app_events_relevant ON events_relevant.event_id = app_events_relevant.event_id WHERE app_events_relevant.is_active = 0 AND app_events_relevant.app_id IN (     SELECT app_id FROM app_events WHERE event_id = 2 );
SELECT MIN(events_relevant.timestamp) FROM     events_relevant JOIN     app_events_relevant ON events_relevant.event_id = app_events_relevant.event_id WHERE     app_events_relevant.is_active = 0     AND app_events_relevant.app_id = 2;
SELECT event_id FROM     events_relevant JOIN     phone_brand_device_model2 ON events_relevant.device_id = phone_brand_device_model2.device_id WHERE     phone_brand = 'vivo';
SELECT COUNT(*) FROM     events_relevant JOIN     phone_brand_device_model2 ON events_relevant.device_id = phone_brand_device_model2.device_id WHERE     events_relevant.event_id = 2     AND phone_brand_device_model2.phone_brand = 'vivo';
SELECT events.timestamp FROM events JOIN events_relevant ON events.event_id = events_relevant.event_id JOIN phone_brand_device_model2 ON events_relevant.device_id = phone_brand_device_model2.device_id WHERE events.event_id = '2' AND phone_brand_device_model2.phone_brand = 'vivo';
SELECT COUNT(*) FROM     events JOIN     phone_brand_device_model2 ON events.device_id = phone_brand_device_model2.device_id WHERE     phone_brand_device_model2.phone_brand = 'vivo' AND     strftime('%Y', events.timestamp) = '2016';
SELECT COUNT(*) FROM     gender_age JOIN     phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE     phone_brand = 'vivo'     AND gender = 'F'     AND age < 30;
SELECT category FROM     label_categories JOIN     app_labels ON label_categories.label_id = app_labels.label_id GROUP BY     category ORDER BY     COUNT(DISTINCT app_labels.app_id) DESC LIMIT 1;
SELECT phone_brand FROM     phone_brand_device_model2 JOIN     gender_age ON     phone_brand_device_model2.device_id = gender_age.device_id WHERE     gender_age.gender = 'F' AND     gender_age.age = (SELECT MIN(age) FROM gender_age WHERE gender = 'F');
SELECT COUNT(DISTINCT gender_age.device_id) FROM     gender_age JOIN     phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE     gender_age.group = 'M23-26'     AND phone_brand_device_model2.phone_brand = 'vivo';
SELECT 100 * (     SELECT COUNT(DISTINCT g.device_id)     FROM gender_age_train AS g     JOIN phone_brand_device_model2 AS p ON g.device_id = p.device_id     WHERE g.group = 'M23-26' AND p.phone_brand = 'vivo' ) / (     SELECT COUNT(DISTINCT p.device_id)     FROM phone_brand_device_model2 AS p     WHERE p.phone_brand = 'vivo' );
SELECT SUM(CASE WHEN phone_brand = 'vivo' THEN 1 ELSE 0 END) * 100.0 / COUNT(device_id) FROM events_relevant JOIN phone_brand_device_model2 ON events_relevant.device_id = phone_brand_device_model2.device_id WHERE events_relevant.event_id = '2';
SELECT AVG(age)  FROM      gender_age  JOIN      phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id  WHERE      phone_brand = 'vivo';
SELECT COUNT(DISTINCT gender_age.device_id) FROM     gender_age WHERE     gender = 'F'     AND group = 'F27-28';
SELECT MAX(age)  FROM gender_age_train  WHERE gender = 'M'
SELECT COUNT(DISTINCT gender_age.device_id) FROM     app_events JOIN     app_all ON app_events.app_id = app_all.app_id LEFT JOIN     app_events_relevant ON app_all.app_id = app_events_relevant.app_id LEFT JOIN     events_relevant ON app_events_relevant.event_id = events_relevant.event_id JOIN     gender_age ON events_relevant.device_id = gender_age.device_id WHERE     app_events.is_installed = 1     AND app_events.is_active = 0;
SELECT MIN(age) FROM gender_age WHERE gender = 'F'
SELECT COUNT(DISTINCT device_model) FROM phone_brand_device_model2 WHERE phone_brand = 'VIVO';
SELECT DISTINCT device_model FROM phone_brand_device_model2 WHERE phone_brand = 'OPPO' LIMIT 15; 
SELECT phone_brand_device_model2.device_model FROM phone_brand_device_model2 INNER JOIN gender_age ON phone_brand_device_model2.device_id = gender_age.device_id WHERE gender_age.gender = 'M' AND gender_age.group = 'M39+' LIMIT 10;
SELECT phone_brand_device_model2.device_model FROM phone_brand_device_model2 INNER JOIN gender_age ON phone_brand_device_model2.device_id = gender_age.device_id INNER JOIN events_relevant ON gender_age.device_id = events_relevant.device_id INNER JOIN app_events_relevant ON events_relevant.event_id = app_events_relevant.event_id WHERE app_events_relevant.is_installed = 1 AND app_events_relevant.is_active = 1 LIMIT 5;
SELECT COUNT(DISTINCT gender_age.device_id) FROM     gender_age JOIN     phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id JOIN     events_relevant ON gender_age.device_id = events_relevant.device_id JOIN     app_events_relevant ON events_relevant.event_id = app_events_relevant.event_id JOIN     app_all ON app_events_relevant.app_id = app_all.app_id JOIN     app_labels ON app_all.app_id = app_labels.app_id JOIN     label_categories ON app_labels.label_id = label_categories.label_id WHERE     label_categories.category = 'Financial Information';
SELECT COUNT(DISTINCT gender_age.device_id) FROM     app_labels JOIN     label_categories ON app_labels.label_id = label_categories.label_id JOIN     app_all ON app_labels.app_id = app_all.app_id JOIN     app_events_relevant ON app_all.app_id = app_events_relevant.app_id JOIN     events_relevant ON app_events_relevant.event_id = events_relevant.event_id JOIN     gender_age ON events_relevant.device_id = gender_age.device_id JOIN     phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE     label_categories.category = 'game-Art Style';
SELECT COUNT(DISTINCT gender_age.device_id) FROM     gender_age JOIN     phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE     gender_age.gender = 'Male'     AND phone_brand_device_model2.phone_brand = 'OPPO';
SELECT phone_brand FROM phone_brand_device_model2 JOIN gender_age ON phone_brand_device_model2.device_id = gender_age.device_id WHERE age = (SELECT MIN(age) FROM gender_age);
SELECT label_categories.category FROM label_categories LEFT JOIN app_labels ON label_categories.label_id = app_labels.label_id LEFT JOIN app_all ON app_labels.app_id = app_all.app_id LEFT JOIN gender_age ON app_all.device_id = gender_age.device_id LEFT JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id GROUP BY label_categories.category ORDER BY COUNT(DISTINCT phone_brand_device_model2.device_id) LIMIT 3; 
SELECT COUNT(*) FROM     gender_age JOIN     phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE     gender_age.gender = 'M' AND     phone_brand_device_model2.device_model = 'Galaxy Ace Plus';
SELECT MAX(group)  FROM gender_age_train  WHERE device_id IN      (SELECT device_id       FROM phone_brand_device_model2       WHERE phone_brand = 'OPPO');
SELECT phone_brand_device_model2.device_model FROM phone_brand_device_model2 JOIN gender_age ON phone_brand_device_model2.device_id = gender_age.device_id WHERE gender_age.gender = 'F' GROUP BY phone_brand_device_model2.device_model ORDER BY COUNT(phone_brand_device_model2.device_model) DESC LIMIT 5;
SELECT 100 * (     (SELECT 100.0 * SUM(IF(category = '80s Japanese comic', 1, 0)) / COUNT(DISTINCT app_id) FROM app_labels      INNER JOIN label_categories ON app_labels.label_id = label_categories.label_id) /     (SELECT 100.0 * SUM(IF(category = '90s Japanese comic', 1, 0)) / COUNT(DISTINCT app_id) FROM app_labels      INNER JOIN label_categories ON app_labels.label_id = label_categories.label_id) ) AS 'Ratio_80s_to_90s'; 
SELECT SUM(CASE WHEN gender = 'F' THEN 1 ELSE 0 END) * 100.0 / COUNT(*) AS percentage FROM gender_age JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE phone_brand = 'OPPO' AND device_model = 'R815T';
SELECT phone_brand FROM phone_brand_device_model2 WHERE device_model = '坚果手机';
SELECT COUNT(DISTINCT device_model) FROM phone_brand_device_model2 WHERE phone_brand = '中兴';
SELECT group FROM gender_age_train WHERE age = 24;
SELECT timestamp FROM events WHERE event_id = '887711'; 
SELECT COUNT(*) AS event_count FROM events WHERE timestamp LIKE '2016/5/6%';
SELECT phone_brand_device_model2.device_model FROM     phone_brand_device_model2 JOIN     gender_age ON phone_brand_device_model2.device_id = gender_age.device_id JOIN     events_relevant ON gender_age.device_id = events_relevant.device_id WHERE     events_relevant.timestamp = '2016/5/7 23:55:16'     AND events_relevant.longitude = '113'     AND events_relevant.latitude = '28';
SELECT COUNT(*) FROM     app_labels JOIN     label_categories ON app_labels.label_id = label_categories.label_id WHERE     category = 'game-Fishing';
SELECT COUNT(DISTINCT gender_age.device_id) FROM     gender_age JOIN     phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE     phone_brand_device_model2.device_model = '魅蓝Note 2' AND     gender_age.group = 'F29-32';
SELECT COUNT(DISTINCT gender_age.device_id) FROM     gender_age JOIN     events_relevant ON gender_age.device_id = events_relevant.device_id WHERE     gender_age.age = '30'     AND events_relevant.timestamp LIKE '2016/5/2%'       AND events_relevant.is_active = 1;
SELECT COUNT(DISTINCT app_events.app_id) AS installed_apps_involved FROM     app_events JOIN     events ON app_events.event_id = events.event_id WHERE     events.timestamp = '2016/5/6 23:33:34'     AND app_events.is_installed = '1';
SELECT COUNT(DISTINCT gender_age.device_id) FROM     gender_age JOIN     phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE     gender_age.gender = 'F' AND phone_brand_device_model2.phone_brand = 'E派';
SELECT COUNT(gender_age.device_id) FROM gender_age JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE gender_age.gender = 'M' AND phone_brand_device_model2.device_model = 'Galaxy S5';
SELECT COUNT(DISTINCT gender_age.device_id) FROM     gender_age JOIN     events_relevant ON gender_age.device_id = events_relevant.device_id WHERE     gender_age.group = 'F29-32'     AND events_relevant.is_active = '1'     AND events_relevant.timestamp LIKE '2016/5/7%'
SELECT label_categories.category FROM     app_labels     JOIN label_categories ON app_labels.label_id = label_categories.label_id WHERE     app_labels.app_id = 894384172610331000;
SELECT COUNT(DISTINCT app_events.app_id) FROM     app_events     JOIN events ON app_events.event_id = events.event_id WHERE     events.timestamp = '2016/5/6 14:09:49'     AND events.longitude = '116'     AND events.latitude = '40'     AND app_events.is_active = '1';
SELECT DIVIDE(     SUM(CASE WHEN events_relevant.timestamp = '2016/5/2 7:50:28' AND app_events_relevant.is_active = '1' THEN 1 ELSE 0 END),     SUM(CASE WHEN events_relevant.timestamp = '2016/5/2 7:41:03' AND app_events_relevant.is_active = '1' THEN 1 ELSE 0 END) ); 
SELECT COUNT(DISTINCT phone_brand_device_model2.device_id) FROM     phone_brand_device_model2 WHERE     phone_brand_device_model2.phone_brand = 'vivo';
SELECT ABS(     (SELECT COUNT(DISTINCT device_id) FROM phone_brand_device_model2 WHERE phone_brand = 'vivo') -     (SELECT COUNT(DISTINCT device_id) FROM phone_brand_device_model2 WHERE phone_brand = 'LG') ) AS device_difference 
SELECT MIN(gender_age.age) as min_age FROM gender_age ORDER BY min_age LIMIT 1;
SELECT COUNT(DISTINCT gender_age.device_id) FROM     gender_age JOIN     phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE     gender_age.gender = 'F'     AND gender_age.age > 30;
SELECT MAX(age) AS max_age, CASE     WHEN gender = 'M' THEN 'male'     WHEN gender = 'F' THEN 'female' END AS oldest_device_user_gender FROM gender_age;
SELECT MIN(age) AS youngest_female_age FROM gender_age WHERE gender = 'F';
SELECT MIN(age) FROM     gender_age JOIN     phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE     phone_brand = 'vivo';
SELECT app_all.app_id FROM app_all JOIN app_labels ON app_all.app_id = app_labels.app_id JOIN label_categories ON app_labels.label_id = label_categories.label_id WHERE label_categories.category = 'Securities' 
SELECT gender FROM     gender_age WHERE     device_id = (         SELECT            device_id         FROM             events_relevant         WHERE             timestamp = '2016-05-01 00:55:25'     );
SELECT COUNT(DISTINCT gender_age.device_id) FROM     events_relevant JOIN     gender_age ON events_relevant.device_id = gender_age.device_id WHERE     strftime('%Y', events_relevant.timestamp) = '2016'     AND gender_age.group = 'M23-26';
SELECT phone_brand_device_model2.phone_brand FROM phone_brand_device_model2 JOIN gender_age_train ON phone_brand_device_model2.device_id = gender_age_train.device_id WHERE gender_age_train.group = 'M23-26' GROUP BY phone_brand_device_model2.phone_brand ORDER BY COUNT(*) DESC LIMIT 1;
SELECT events_relevant.longitude, events_relevant.latitude FROM events_relevant JOIN gender_age ON events_relevant.device_id = gender_age.device_id JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE phone_brand_device_model2.device_model = 'Galaxy Note 2';
SELECT phone_brand_device_model2.device_model FROM phone_brand_device_model2 JOIN gender_age ON phone_brand_device_model2.device_id = gender_age.device_id WHERE gender_age.gender = 'F';
SELECT label_categories.category FROM app_labels JOIN label_categories ON app_labels.label_id = label_categories.label_id WHERE app_labels.app_id = 7324884708820020000;
SELECT COUNT(DISTINCT gender_age.device_id) FROM     gender_age JOIN     phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id JOIN     events_relevant ON gender_age.device_id = events_relevant.device_id JOIN     app_events_relevant ON events_relevant.event_id = app_events_relevant.event_id JOIN     app_labels ON app_events_relevant.app_id = app_labels.app_id JOIN     label_categories ON app_labels.label_id = label_categories.label_id WHERE     app_events_relevant.is_active = 0     AND events_relevant.event_id = 2     AND label_categories.category = 'Property Industry 1.0';
SELECT COUNT(DISTINCT label_categories.category) AS total_categories FROM     app_labels     JOIN app_all ON app_labels.app_id = app_all.app_id     JOIN app_events_relevant ON app_all.app_id = app_events_relevant.app_id     JOIN events_relevant ON app_events_relevant.event_id = events_relevant.event_id     LEFT JOIN events ON events_relevant.device_id = events.device_id     LEFT JOIN label_categories ON app_labels.label_id = label_categories.label_id WHERE     events.event_id = 2     AND events.is_active = 0;
SELECT phone_brand_device_model2.device_model FROM phone_brand_device_model2 JOIN gender_age ON phone_brand_device_model2.device_id = gender_age.device_id WHERE gender_age.gender = 'F' AND gender_age.age > 30 GROUP BY phone_brand_device_model2.device_model ORDER BY COUNT(*) DESC LIMIT 1;
SELECT phone_brand_device_model2.device_model FROM phone_brand_device_model2 INNER JOIN gender_age ON gender_age.device_id = phone_brand_device_model2.device_id INNER JOIN events_relevant ON events_relevant.device_id = gender_age.device_id WHERE events_relevant.longitude = 121 AND events_relevant.latitude = 31;
SELECT label_categories.category, COUNT(DISTINCT app_all.app_id) AS user_count FROM label_categories JOIN app_labels ON label_categories.label_id = app_labels.label_id JOIN app_all ON app_labels.app_id = app_all.app_id GROUP BY label_categories.category ORDER BY user_count DESC LIMIT 3;
SELECT event_id FROM     events_relevant WHERE     device_id IN (SELECT device_id FROM gender_age WHERE age = (SELECT MAX(age) FROM gender_age))
SELECT COUNT(*) AS events_count FROM     events_relevant JOIN     gender_age ON events_relevant.device_id = gender_age.device_id WHERE     gender_age.gender = 'F' AND     gender_age.age = (SELECT MIN(age) FROM gender_age WHERE gender = 'F');
SELECT COUNT(DISTINCT events_relevant.device_id) FROM     events_relevant JOIN     gender_age ON events_relevant.device_id = gender_age.device_id WHERE     events_relevant.timestamp = '2016-05-01'     AND gender_age.gender = 'M';
SELECT IF(SUM(CASE WHEN label_categories.category = 'Securities' THEN 1 ELSE 0 END) > SUM(CASE WHEN label_categories.category = 'Finance' THEN 1 ELSE 0 END),    'Securities',     'Finance' ) AS more FROM app_labels JOIN label_categories ON app_labels.label_id = label_categories.label_id; 
SELECT phone_brand_device_model2.device_model FROM gender_age JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE gender_age.group = 'M23-26';
SELECT AVG(age) FROM gender_age JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE gender_age.gender = 'F' AND phone_brand_device_model2.phone_brand = 'vivo';
SELECT SUM(CASE WHEN gender = 'F' AND phone_brand = 'vivo' THEN 1 ELSE 0 END) / SUM(CASE WHEN gender = 'M' AND phone_brand = 'vivo' THEN 1 ELSE 0 END) AS ratio_female_to_male_vivo_users FROM gender_age JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id;
SELECT SUM(CASE WHEN lc.category = 'Securities' THEN 1 ELSE 0 END) / SUM(CASE WHEN lc.category = 'Finance' THEN 1 ELSE 0 END) FROM app_labels AS al JOIN label_categories AS lc ON al.label_id = lc.label_id;
SELECT label_id FROM     label_categories WHERE     category = "Third-party card management"; 
SELECT SUM(CASE WHEN ae.is_active = 1 THEN 1 ELSE 0 END) / SUM(CASE WHEN ae.is_active = 0 THEN 1 ELSE 0 END) AS ratio FROM app_events_relevant AS aer JOIN app_events AS ae ON aer.event_id = ae.event_id WHERE ae.event_id = 58;
SELECT COUNT(*) FROM events_relevant WHERE device_id = '3915082290673130000';
SELECT (SUM(CASE WHEN gender = 'M' THEN 1 ELSE 0 END) * 100.0) / COUNT(device_id) AS percentage_male_users FROM gender_age;
SELECT COUNT(*) FROM     events WHERE     longitude = "-156";
SELECT COUNT(DISTINCT gender_age.device_id) FROM     app_labels JOIN     label_categories ON app_labels.label_id = label_categories.label_id JOIN     app_all ON app_labels.app_id = app_all.app_id JOIN     app_events_relevant ON app_all.app_id = app_events_relevant.app_id JOIN     events_relevant ON app_events_relevant.event_id = events_relevant.event_id JOIN     gender_age ON events_relevant.device_id = gender_age.device_id JOIN     phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE     label_categories.label_id = "48";
SELECT COUNT(DISTINCT category) FROM label_categories WHERE category LIKE 'game%'
SELECT COUNT(*) AS event_count FROM     events_relevant WHERE     longitude = 80 AND latitude = 37;
SELECT app_labels.label_id, label_categories.category FROM app_labels JOIN label_categories ON app_labels.label_id = label_categories.label_id WHERE app_labels.app_id = '5758400314709850000'; 
SELECT app_all.app_id FROM app_labels JOIN label_categories ON app_labels.label_id = label_categories.label_id JOIN app_all ON app_labels.app_id = app_all.app_id WHERE label_categories.category = 'game-Rowing'; 
SELECT label_id, app_id FROM app_labels JOIN label_categories ON app_labels.label_id = label_categories.label_id WHERE label_categories.category = 'Chinese Classical Mythology' 
SELECT COUNT(DISTINCT app_all.app_id) AS num_app_ids, events.longitude AS event_longitude, events.latitude AS event_latitude FROM app_all JOIN app_events ON app_all.app_id = app_events.app_id JOIN events ON app_events.event_id = events.event_id WHERE events.event_id = 79641;
SELECT events_relevant.longitude, events_relevant.latitude, events_relevant.timestamp FROM events_relevant JOIN app_events_relevant ON events_relevant.event_id = app_events_relevant.event_id WHERE app_events_relevant.app_id = '8715964299802120000';
SELECT COUNT(DISTINCT phone_brand_device_model2.device_id) FROM     phone_brand_device_model2 JOIN     gender_age ON phone_brand_device_model2.device_id = gender_age.device_id JOIN     events_relevant ON gender_age.device_id = events_relevant.device_id WHERE     phone_brand_device_model2.phone_brand = 'OPPO'     AND strftime('%H', events_relevant.timestamp) = '00'     AND strftime('%Y-%m-%d', events_relevant.timestamp) = '2016-05-01';
SELECT ROUND(   CAST(     (SELECT COUNT(*)       FROM gender_age       JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id       WHERE phone_brand = 'vivo' AND device_model = 'X5Pro' AND gender = 'M') AS REAL) /     NULLIF(     (SELECT COUNT(*)       FROM gender_age       JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id       WHERE phone_brand = 'vivo' AND device_model = 'X5Pro' AND gender = 'F'), 0),   2 ) AS male_to_female_ratio; 
SELECT COUNT(*) FROM gender_age JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE gender_age.gender = 'F' AND phone_brand_device_model2.phone_brand = 'ZUK' AND phone_brand_device_model2.device_model = 'Z1' AND gender_age.group = 'F23-';
SELECT phone_brand, device_model FROM gender_age JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE age < 10;
SELECT 100 * SUM(gender_age.gender = 'F' AND gender_age.age > 80 AND phone_brand_device_model2.phone_brand = 'HTC') / COUNT(DISTINCT gender_age.device_id) FROM gender_age JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE phone_brand_device_model2.phone_brand = 'HTC'
SELECT phone_brand_device_model2.phone_brand, phone_brand_device_model2.device_model FROM events_relevant JOIN gender_age ON events_relevant.device_id = gender_age.device_id JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE events_relevant.event_id = 6701;
SELECT MAX(COUNT(events_relevant.event_id)) AS max_events_count, gender_age.age AS max_events_age, gender_age.gender AS max_events_gender FROM events_relevant JOIN gender_age ON events_relevant.device_id = gender_age.device_id WHERE events_relevant.device_id BETWEEN '-9215352913819630000' AND '-9222956879900150000' GROUP BY gender_age.age, gender_age.gender ORDER BY max_events_count DESC LIMIT 1;
SELECT timestamp FROM events WHERE event_id = 12;
SELECT COUNT(DISTINCT events_relevant.device_id) FROM     events_relevant WHERE     events_relevant.is_active = 1;
SELECT COUNT(DISTINCT gender_age.device_id) FROM gender_age JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE phone_brand_device_model2.device_model = 'A51';
SELECT gender FROM gender_age JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE phone_brand_device_model2.device_id = -9222956879900150000;
SELECT COUNT(*) FROM     label_categories WHERE     category = 'game-card';
SELECT group FROM gender_age_train JOIN phone_brand_device_model2 ON gender_age_train.device_id = phone_brand_device_model2.device_id WHERE phone_brand = 'vivo';
SELECT COUNT(DISTINCT gender_age.device_id) FROM     gender_age JOIN     phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE     age < 30     AND phone_brand = 'Galaxy'     AND device_model = 'Note 2';
SELECT (SELECT (1.0 * COUNT(gender_age.device_id) FILTER (WHERE gender_age.age < 50 AND phone_brand_device_model2.phone_brand = 'OPPO')) / COUNT(gender_age.device_id) FROM gender_age INNER JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE phone_brand_device_model2.phone_brand = 'OPPO'; 
SELECT AVG(age) FROM gender_age JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE device_model = 'R7';
SELECT label_categories.category FROM     label_categories JOIN     app_labels ON label_categories.label_id = app_labels.label_id WHERE     app_labels.app_id = 5902120154267990000;
SELECT group FROM     gender_age WHERE     device_id IN (SELECT device_id FROM phone_brand_device_model2 WHERE phone_brand = 'LG'); 
SELECT category FROM     label_categories JOIN     app_labels ON label_categories.label_id = app_labels.label_id WHERE     app_labels.app_id = 4955831798976240000;
SELECT COUNT(DISTINCT gender_age.device_id) FROM     gender_age JOIN     phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE     gender_age.gender = 'F'     AND phone_brand_device_model2.device_model = 'MI 3';
SELECT COUNT(DISTINCT gender_age.device_id) FROM     gender_age JOIN     phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE     gender_age.gender = 'M'     AND phone_brand_device_model2.device_model = 'Desire 820';
SELECT COUNT(DISTINCT gender_age.device_id) FROM     gender_age JOIN     phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE     gender_age.age > 20     AND phone_brand_device_model2.device_model = 'ELIFE E7 Mini';
SELECT COUNT(DISTINCT gender_age.device_id) FROM     gender_age JOIN     phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE     phone_brand_device_model2.device_model = 'Galaxy Premier'     AND age BETWEEN 20 AND 50;
SELECT COUNT(DISTINCT gender_age.device_id) FROM gender_age JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE gender_age.gender = 'M' AND phone_brand_device_model2.phone_brand = 'HTC';
SELECT COUNT(DISTINCT gender_age.device_id) FROM gender_age JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE age BETWEEN 20 AND 60 AND phone_brand = 'TCL';
SELECT 100.0 * SUM(CASE WHEN ga.age > 20 THEN 1 ELSE 0 END) / COUNT(DISTINCT ga.device_id) AS percentage FROM     gender_age ga JOIN     phone_brand_device_model2 pb ON ga.device_id = pb.device_id WHERE     pb.phone_brand = 'SUGAR';
SELECT events.longitude, events.latitude FROM events WHERE events.timestamp BETWEEN '2016-04-30 00:00:00' AND '2016-04-30 23:59:59';
SELECT COUNT(DISTINCT device_model) FROM phone_brand_device_model2 WHERE phone_brand = 'HTC';
SELECT app_id FROM app_events WHERE is_installed = 1 AND is_active = 1 
SELECT COUNT(*) FROM     app_labels WHERE     label_id = 7;
SELECT device_id FROM     gender_age WHERE     gender = 'F'     AND age BETWEEN 29 AND 31;
SELECT app_all.app_id FROM app_all JOIN app_labels ON app_all.app_id = app_labels.app_id JOIN label_categories ON app_labels.label_id = label_categories.label_id WHERE label_categories.category = 'game-stress reliever';
SELECT MAX(timestamp) AS most_events_date FROM     events_relevant AS er JOIN     gender_age AS ga ON er.device_id = ga.device_id WHERE     ga.age = 40     AND ga.gender = 'M';
SELECT phone_brand, MAX(installed_count) AS max_installed_count FROM (     SELECT    pb.phone_brand,     COUNT(CASE WHEN ae.is_installed = 1 THEN 1 ELSE NULL END) AS installed_count     FROM     phone_brand_device_model2 pb     JOIN gender_age ga ON pb.device_id = ga.device_id     JOIN events_relevant er ON ga.device_id = er.device_id     JOIN app_events_relevant aer ON er.event_id = aer.event_id     JOIN app_all aa ON aer.app_id = aa.app_id     JOIN app_events ae ON aa.app_id = ae.app_id     GROUP BY pb.phone_brand ) GROUP BY phone_brand ORDER BY max_installed_count DESC LIMIT 1;
SELECT COUNT(DISTINCT gender_age.device_id) AS num_men_under_23_with_apps_installed_not_active FROM     gender_age JOIN     phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id JOIN     events_relevant ON gender_age.device_id = events_relevant.device_id JOIN     app_events_relevant ON events_relevant.event_id = app_events_relevant.event_id WHERE     gender_age.gender = 'M'     AND gender_age.age < 23     AND app_events_relevant.is_installed = 1     AND app_events_relevant.is_active = 0;
SELECT COUNT(DISTINCT gender_age.device_id) FROM     gender_age JOIN     phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id JOIN     events_relevant ON gender_age.device_id = events_relevant.device_id JOIN     app_events_relevant ON events_relevant.event_id = app_events_relevant.event_id JOIN     app_all ON app_events_relevant.app_id = app_all.app_id JOIN     app_labels ON app_all.app_id = app_labels.app_id JOIN     label_categories ON app_labels.label_id = label_categories.label_id WHERE     gender_age.gender = 'F'     AND label_categories.category = 'game-Finding fault'     AND app_events_relevant.is_installed = 1;
SELECT MAX(gender) AS most_logged_in_gender FROM     (     SELECT        gender     FROM         gender_age     JOIN         events_relevant ON gender_age.device_id = events_relevant.device_id     WHERE         events_relevant.timestamp BETWEEN '2016-05-01 00:00:00' AND '2016-05-10 23:59:59'     GROUP BY         gender     ORDER BY         COUNT(*) DESC     LIMIT 1     );
SELECT MAX(group) AS most_used_age_group FROM gender_age_train WHERE device_id IN (     SELECT device_id     FROM phone_brand_device_model2     WHERE device_model = 'SM-T2558' );
SELECT COUNT(DISTINCT gender_age.device_id) FROM     gender_age WHERE     age > 50     AND NOT EXISTS (         SELECT 1         FROM             phone_brand_device_model2         WHERE             gender_age.device_id = phone_brand_device_model2.device_id             AND phone_brand = 'HTC'             AND device_model = 'One M8 Eye'     );
SELECT events.longitude, events.latitude FROM events JOIN gender_age ON events.device_id = gender_age.device_id WHERE gender_age.gender = 'F' AND gender_age.age < 30;
SELECT 100.0 * SUM(CASE WHEN gender = 'F' THEN 1 ELSE 0 END AND is_installed = 0) / SUM(CASE WHEN gender = 'M' THEN 1 ELSE 0 END) FROM gender_age LEFT JOIN events_relevant ON gender_age.device_id = events_relevant.device_id
SELECT AVG(age) FROM gender_age WHERE device_id IN (     SELECT DISTINCT gender_age.device_id     FROM gender_age     INNER JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id     INNER JOIN events_relevant ON gender_age.device_id = events_relevant.device_id     INNER JOIN app_events_relevant ON events_relevant.event_id = app_events_relevant.event_id     WHERE app_events_relevant.is_installed = 1     AND app_events_relevant.is_active = 0 );
SELECT events.event_id FROM events WHERE events.timestamp LIKE '2016-05-01%' AND events.latitude = 31 LIMIT 3;
SELECT event_id FROM events WHERE longitude = 0 AND latitude = 0 LIMIT 3; 
SELECT SUM(CASE WHEN events_relevant.device_id = -9222956879900150000 AND events_relevant.latitude != 0 AND events_relevant.longitude != 0 THEN 1 ELSE 0 END) - SUM(CASE WHEN events_relevant.device_id = -9222956879900150000 AND events_relevant.latitude = 0 AND events_relevant.longitude = 0 THEN 1 ELSE 0 END) AS difference FROM events_relevant WHERE events_relevant.device_id = -9222956879900150000;
SELECT phone_brand, device_model FROM gender_age JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE gender = 'F' LIMIT 3;
SELECT label_categories.category, app_labels.label_id FROM label_categories JOIN app_labels ON label_categories.label_id = app_labels.label_id WHERE label_categories.category LIKE '%game%' LIMIT 5;
SELECT device_model FROM phone_brand_device_model2 WHERE phone_brand = 'OPPO' LIMIT 3; 
SELECT 100.0 * SUM(CASE WHEN app_events_relevant.is_installed = 1 AND app_events_relevant.is_active = 0 THEN 1 ELSE 0 END) / COUNT(DISTINCT app_events_relevant.app_id) FROM app_events_relevant JOIN events_relevant ON app_events_relevant.event_id = events_relevant.event_id WHERE events_relevant.event_id = 6;
SELECT SUM(CASE WHEN phone_brand = 'Galaxy' AND device_model = 'Note 2' AND gender = 'M' THEN 1 ELSE 0 END) - SUM(CASE WHEN phone_brand = 'Galaxy' AND device_model = 'Note 2' AND gender = 'F' THEN 1 ELSE 0 END) AS More_Gender_Owners FROM gender_age JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE phone_brand = 'Galaxy' AND device_model = 'Note 2';
SELECT `timestamp`, COUNT(DISTINCT `device_id`) FROM     events_relevant WHERE     event_id = 2     AND is_active = 1;
SELECT category FROM     app_labels JOIN     label_categories ON app_labels.label_id = label_categories.label_id WHERE     app_labels.app_id = 5902120154267990000;
SELECT COUNT(DISTINCT gender_age.device_id) AS users_with_comics_behavior FROM     gender_age JOIN     phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id JOIN     events_relevant ON gender_age.device_id = events_relevant.device_id JOIN     app_events_relevant ON events_relevant.event_id = app_events_relevant.event_id JOIN     app_labels ON app_events_relevant.app_id = app_labels.app_id JOIN     label_categories ON app_labels.label_id = label_categories.label_id WHERE     label_categories.category = 'comics';
SELECT gender_age.gender, gender_age.age FROM gender_age INNER JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id INNER JOIN events_relevant ON gender_age.device_id = events_relevant.device_id WHERE events_relevant.event_id = 1 AND gender_age.device_id = 29182687948017100;
SELECT COUNT(DISTINCT gender_age.device_id) FROM     events_relevant JOIN     gender_age ON events_relevant.device_id = gender_age.device_id WHERE     gender_age.gender = 'M'     AND events_relevant.longitude = 114;
SELECT timestamp FROM events_relevant WHERE event_id = 7 AND device_id = (SELECT device_id FROM phone_brand_device_model2 WHERE app_id = -8022267440849930000);
SELECT label_categories.category FROM app_labels JOIN label_categories ON app_labels.label_id = label_categories.label_id WHERE app_labels.app_id = -9222198347540750000;
SELECT  group FROM     gender_age JOIN     phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE     phone_brand = 'LG' AND device_model = 'Nexus 4'; 
SELECT gender FROM gender_age JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE phone_brand_device_model2.phone_brand = 'HTC' AND phone_brand_device_model2.device_model = 'Desire 826';
SELECT ((SELECT (COUNT(DISTINCT gender_age.device_id) * 1.0) FROM gender_age)  /  (SELECT COUNT(DISTINCT app_events_relevant.app_id) FROM app_events_relevant)  ) *  (SELECT COUNT(DISTINCT app_labels.app_id) FROM app_labels  INNER JOIN label_categories ON app_labels.label_id = label_categories.label_id  WHERE label_categories.category = 'Academic Information');
SELECT (MULTIPLY(DIVIDE(SUM(`group` = 'F27-28'), COUNT(device_id)), 1.0) * 100) AS percentage FROM gender_age JOIN events_relevant ON gender_age.device_id = events_relevant.device_id WHERE age BETWEEN 27 AND 28 AND timestamp LIKE '2016-05-03%';
SELECT COUNT(*) FROM phone_brand_device_model2 WHERE phone_brand = 'OPPO';
SELECT MAX(group) AS most_common_age_group FROM gender_age;
SELECT COUNT(*) FROM events_relevant WHERE device_id = '4069764298338760000';
SELECT COUNT(DISTINCT app_all.app_id) FROM     app_all JOIN     app_labels ON app_all.app_id = app_labels.app_id JOIN     label_categories ON app_labels.label_id = label_categories.label_id WHERE     label_categories.category = "Equity Fund";
SELECT events_relevant.longitude, events_relevant.latitude FROM events_relevant JOIN gender_age ON events_relevant.device_id = gender_age.device_id WHERE gender_age.gender = 'F' AND gender_age.group = 'F24-26';
SELECT COUNT(DISTINCT gender_age.device_id) FROM gender_age JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE gender_age.gender = 'M' AND phone_brand_device_model2.device_model = 'Galaxy Note 3';
SELECT phone_brand_device_model2.phone_brand, phone_brand_device_model2.device_model FROM events_relevant INNER JOIN gender_age ON events_relevant.device_id = gender_age.device_id INNER JOIN phone_brand_device_model2 ON gender_age.device_id = phone_brand_device_model2.device_id WHERE events_relevant.timestamp = '2016-05-07 06:03:22';
SELECT phone_brand, COUNT(phone_brand) AS brand_count FROM gender_age_train JOIN phone_brand_device_model2 ON gender_age_train.device_id = phone_brand_device_model2.device_id WHERE age BETWEEN 20 AND 29 GROUP BY phone_brand ORDER BY brand_count DESC LIMIT 1;
SELECT 100.0 * SUM(CASE WHEN gender IS NULL AND age IS NULL AND `group` IS NULL THEN 1 ELSE 0 END) / COUNT(device_id) AS percentage FROM gender_age WHERE device_id IN (     SELECT device_id     FROM phone_brand_device_model2     WHERE phone_brand = 'vivo' );
SELECT keyword.keyword FROM keyword JOIN episode ON keyword.episode_id = episode.episode_id WHERE episode.title = 'Refuge: Part 1'; 
SELECT COUNT(*)  FROM keyword  JOIN episode ON keyword.episode_id = episode.episode_id  WHERE episode.series = 'law_and_order'  AND episode.season = 9  AND episode.episode = 23; 
SELECT episode.title FROM episode JOIN keyword ON episode.episode_id = keyword.episode_id WHERE keyword.keyword = 'laundering money';
SELECT keyword.keyword FROM keyword JOIN episode ON keyword.episode_id = episode.episode_id WHERE episode.rating > 8; 
SELECT COUNT(*) FROM     vote JOIN     episode ON vote.episode_id = episode.episode_id WHERE     stars = 10     AND title = 'Cherished';
SELECT SUM(votes) AS total_votes FROM episode WHERE title = 'Cherished';
SELECT episode.title FROM episode JOIN vote ON episode.episode_id = vote.episode_id WHERE vote.stars = 10 ORDER BY vote.votes DESC LIMIT 1; 
SELECT role FROM credit JOIN episode ON credit.episode_id = episode.episode_id JOIN person ON credit.person_id = person.person_id WHERE person.name = 'Park Dietz' AND episode.title = 'Cherished' AND credit.credited = 'true';
SELECT COUNT(DISTINCT person_id) FROM credit WHERE episode_id = (     SELECT episode_id     FROM episode     WHERE title = 'Cherished' )
SELECT person.name FROM credit JOIN person ON credit.person_id = person.person_id JOIN episode ON credit.episode_id = episode.episode_id WHERE credit.role = 'technical advisor' AND episode.title = 'Cherished' AND credit.credited = 'true';
SELECT COUNT(*) FROM   credit JOIN   person ON credit.person_id = person.person_id WHERE   person.name = 'Park Dietz' AND   credited = 'true'; 
SELECT episode.title FROM episode JOIN credit ON episode.episode_id = credit.episode_id JOIN person ON credit.person_id = person.person_id WHERE person.name = 'Park Dietz' AND credit.credited = 'true'; 
SELECT CASE     WHEN credit.credited = 'true' THEN 'Yes'     ELSE 'No' END AS credited_in_end_credits FROM     credit JOIN     episode ON credit.episode_id = episode.episode_id JOIN     person ON credit.person_id = person.person_id WHERE     person.name = 'Anthony Azzara'     AND episode.episode_id = 'tt0629204';
SELECT COUNT(keyword.keyword) AS keyword_count FROM episode JOIN keyword ON episode.episode_id = keyword.episode_id WHERE episode.title = 'Disciple'; 
SELECT episode.title FROM     episode JOIN     vote ON episode.episode_id = vote.episode_id WHERE     vote.stars = '1' ORDER BY     vote.votes DESC LIMIT 1;
SELECT COUNT(award_id) FROM award JOIN episode ON award.episode_id = episode.episode_id WHERE episode.series = 'Law and Order' AND episode.season = 9 AND episode.episode = 20;
SELECT COUNT(*) AS num_roles FROM credit JOIN episode ON credit.episode_id = episode.episode_id WHERE episode.series = 'Law and Order' AND episode.season = 9 AND episode.episode = 17 AND credit.credited = 'true';
SELECT episode.summary FROM episode JOIN award ON episode.episode_id = award.episode_id WHERE award.award_id = '296';
SELECT role FROM     credit JOIN     person ON credit.person_id = person.person_id WHERE     person.name = 'Joseph Blair';
SELECT COUNT(*) FROM award WHERE person_id = (     SELECT person_id     FROM person     WHERE name = 'Rene Balcer' ); 
SELECT MAX(air_date) FROM   episode JOIN   vote ON episode.episode_id = vote.episode_id WHERE   votes = (SELECT MAX(votes) FROM vote)
SELECT person.name FROM     person JOIN     award ON person.person_id = award.person_id WHERE     award.award_id = '313'; 
SELECT COUNT(episode.episode_id) FROM episode JOIN credit ON episode.episode_id = credit.episode_id JOIN person ON credit.person_id = person.person_id WHERE person.name = 'J.K. Simmons' AND credit.role = 'actor' 
SELECT COUNT(vote.episode_id) FROM     episode JOIN     vote ON episode.episode_id = vote.episode_id WHERE     episode.title = 'Sideshow' AND     vote.stars = '9';
SELECT (SELECT COUNT(keyword.keyword) FROM episode JOIN keyword ON episode.episode_id = keyword.episode_id WHERE episode.title = 'Refuge: Part 1') /  (SELECT COUNT(keyword.keyword) FROM episode JOIN keyword ON episode.episode_id = keyword.episode_id WHERE episode.title = 'Shield') 
SELECT AVG(CASE WHEN category = 'Cast' AND credited = 'TRUE' THEN 1 ELSE 0 END) AS avg_cast_members FROM credit JOIN episode ON credit.episode_id = episode.episode_id WHERE number_in_series BETWEEN 185 AND 193;
SELECT person.name FROM person JOIN credit ON person.person_id = credit.person_id WHERE credit.episode_id = 'tt0629391' AND credit.credited = ''; 
SELECT COUNT(person.person_id) FROM person JOIN award ON person.person_id = award.person_id WHERE award.result = 'Winner' GROUP BY person.person_id HAVING COUNT(*) >= 3;
SELECT person.name FROM person JOIN credit ON person.person_id = credit.person_id WHERE credit.role = 'script supervisor' AND credit.episode_id = 'tt0629204';
SELECT COUNT(*) AS nominated_awards FROM     award WHERE     person_id = (SELECT person_id FROM person WHERE name = 'Julia Roberts')     AND result = 'Nominee';
SELECT person.name FROM person JOIN credit ON person.person_id = credit.person_id WHERE credit.role = 'camera operator' ORDER BY person.height_meters DESC LIMIT 1; 
SELECT COUNT(DISTINCT person.person_id) FROM     person JOIN     award ON person.person_id = award.person_id WHERE     person.birth_country = 'Canada' AND award.year = 1999;
SELECT COUNT(DISTINCT vote.person_id) AS "Number of people who gave the most enjoyed episode a 10-star rating" FROM     vote INNER JOIN     episode ON vote.episode_id = episode.episode_id WHERE     episode.rating = (SELECT MAX(rating) FROM episode)     AND vote.stars = 10;
SELECT keyword.keyword FROM episode JOIN keyword ON episode.episode_id = keyword.episode_id WHERE episode.title = 'Shield'; 
SELECT 100 * (     SELECT COUNT(*)      FROM vote      WHERE stars = 1      AND episode_id = (         SELECT episode_id          FROM episode          WHERE title = 'True North'     ) ) / (     SELECT COUNT(*)      FROM vote      WHERE episode_id = (         SELECT episode_id          FROM episode          WHERE title = 'True North'     ) ) AS percentage
SELECT episode.title FROM episode JOIN (     SELECT    episode_id,     COUNT(*) AS num_keywords     FROM     keyword     GROUP BY     episode_id     ORDER BY     num_keywords DESC     LIMIT 1 ) AS max_keywords ON episode.episode_id = max_keywords.episode_id; 
SELECT COUNT(DISTINCT episode.episode_id) FROM     episode JOIN     award ON episode.episode_id = award.episode_id WHERE     episode.air_date LIKE '1998%'     AND award.organization = 'International Monitor Awards'     AND award.result = 'Winner';
SELECT COUNT(*) FROM     award JOIN     episode ON award.episode_id = episode.episode_id WHERE     episode.title = 'Agony' AND     award.result = 'Winner';
SELECT COUNT(episode_id) FROM episode WHERE series = 'Law and Order' AND season = 9;  SELECT AVG(cast_count) FROM (     SELECT COUNT(person_id) AS cast_count     FROM credit     WHERE category = 'Cast'     GROUP BY series, season ) AS cast_counts WHERE series = 'Law and Order';
SELECT keyword.keyword FROM     episode     JOIN keyword ON episode.episode_id = keyword.episode_id WHERE     episode.episode_id = (         SELECT            episode_id         FROM             episode         ORDER BY             votes DESC         LIMIT 1 OFFSET 1     ) 
SELECT COUNT(*) FROM award JOIN episode ON award.episode_id = episode.episode_id WHERE episode.title = 'Agony' AND award.result = 'Winner';
SELECT person.name FROM     person JOIN     credit ON person.person_id = credit.person_id JOIN     episode ON credit.episode_id = episode.episode_id WHERE     episode.title = 'Flight'     AND credit.role = 'Narrator';
SELECT organization FROM     award JOIN     person ON award.person_id = person.person_id WHERE     person.name = 'Constantine Makris' AND award.result = 'Winner' GROUP BY     award.organization ORDER BY     COUNT(award.award_id) DESC LIMIT 1; 
SELECT person.name FROM     person JOIN     credit ON person.person_id = credit.person_id JOIN     episode ON credit.episode_id = episode.episode_id WHERE     episode.episode_id = 3     AND credit.role = 'stunt coordinator';
SELECT COUNT(person.person_id) FROM person LEFT JOIN credit ON person.person_id = credit.person_id LEFT JOIN episode ON credit.episode_id = episode.episode_id WHERE episode.title = 'Admissions' AND credit.credited = '';
SELECT episode.title FROM episode JOIN credit ON episode.episode_id = credit.episode_id WHERE credit.category = 'Art Department' GROUP BY episode.title ORDER BY COUNT(credit.person_id) DESC LIMIT 1;
SELECT COUNT(DISTINCT credit.role) FROM credit JOIN person ON credit.person_id = person.person_id WHERE person.name = 'Julia Roberts';
SELECT episode.title FROM     episode JOIN     vote ON episode.episode_id = vote.episode_id WHERE     vote.stars = 10     AND vote.votes >= 30 ORDER BY     vote.votes DESC LIMIT 3;
SELECT person.name FROM credit JOIN person ON credit.person_id = person.person_id WHERE credit.role = 'Clerk' ORDER BY person.birthdate ASC LIMIT 1; 
SELECT COUNT(*)  FROM vote WHERE episode_id = 24 AND stars = 1;
SELECT person.name FROM     person JOIN     credit ON person.person_id = credit.person_id WHERE     credit.category = 'Cast' 
SELECT name, COUNT(person_id) * 100.0 / (SELECT COUNT(*) FROM credit) AS appearance_percentage FROM person JOIN credit ON person.person_id = credit.person_id GROUP BY person.name ORDER BY COUNT(person_id) DESC LIMIT 1;
SELECT episode.title FROM episode JOIN award ON episode.episode_id = award.episode_id WHERE award.award_category = 'Primetime Emmy'
SELECT COUNT(DISTINCT episode.episode_id) FROM     episode WHERE     episode.episode_id NOT IN (         SELECT DISTINCT award.episode_id         FROM award         WHERE award.result = 'Winner'         AND award.series LIKE 'Law & Order%'     );
SELECT DISTINCT role FROM     person WHERE     person.person_id NOT IN (         SELECT DISTINCT person_id FROM credit WHERE credited = ''     ) 
SELECT title FROM     episode WHERE     rating IN (         SELECT            rating         FROM             episode         ORDER BY             rating ASC         LIMIT 3     );
SELECT birth_place || ', ' || birth_region || ', ' || birth_country AS full_place_of_birth FROM person WHERE birth_name = 'Rene Chenevert Balcer';
SELECT name FROM person WHERE birth_country = 'USA';
SELECT title FROM episode JOIN (     SELECT    episode_id     FROM     vote     WHERE     stars = 1     ORDER BY     votes ASC     LIMIT 1 ) AS least_enjoyed ON episode.episode_id = least_enjoyed.episode_id; 
SELECT   person.name FROM     person JOIN     award ON person.person_id = award.person_id WHERE     award.result = 'Winner'     AND award.role = 'director'; 
SELECT COUNT(vote.votes) FROM     episode JOIN     vote ON episode.episode_id = vote.episode_id WHERE     episode.title = 'Juvenile';
SELECT episode.title FROM episode LEFT JOIN credit ON episode.episode_id = credit.episode_id AND credit.person_id = (SELECT person_id FROM person WHERE name = 'Anthony Azzara') WHERE credit.credited = '' AND credit.person_id IS NULL; 
SELECT DISTINCT year FROM   episode JOIN   award ON episode.episode_id = award.episode_id WHERE   episode.title = 'DWB'   AND award.result = 'Winner'; 
SELECT person.birth_region FROM     person JOIN     credit ON person.person_id = credit.person_id JOIN     episode ON credit.episode_id = episode.episode_id WHERE     credit.role = 'assistant location manager'; 
SELECT SUM(vote.stars) FROM     episode JOIN     credit ON episode.episode_id = credit.episode_id JOIN     person ON credit.person_id = person.person_id JOIN     vote ON episode.episode_id = vote.episode_id WHERE     person.name = 'Donna Villella'; 
SELECT role FROM award WHERE result = 'Nominee' AND person_id = (SELECT person_id FROM person WHERE name = 'Julia Roberts')
SELECT role FROM person WHERE height_meters = (SELECT MAX(height_meters) FROM person) 
SELECT title FROM     episode WHERE     episode_id IN (         SELECT            episode_id         FROM             award         WHERE             result = 'Nominee'         GROUP BY             episode_id         ORDER BY             COUNT(*) DESC         LIMIT 1     );
SELECT rating FROM episode JOIN credit ON episode.episode_id = credit.episode_id JOIN person ON credit.person_id = person.person_id WHERE person.name = 'Jace Alexander'; 
SELECT name FROM person JOIN credit ON person.person_id = credit.person_id JOIN episode ON episode.episode_id = credit.episode_id WHERE episode.season = 9 AND episode.number_in_series = 19; 
SELECT AVG(vote.stars) AS average_star_rating FROM     vote JOIN     episode ON vote.episode_id = episode.episode_id JOIN     credit ON credit.episode_id = episode.episode_id JOIN     person ON person.person_id = credit.person_id WHERE     person.name = 'Jim Bracchitta'; 
SELECT (COUNT(DISTINCT person_id) * 100.0) / (SELECT COUNT(*) FROM credit WHERE episode_id IN (SELECT episode_id FROM episode WHERE title = 'True North')) FROM credit WHERE role = 'Additional Crew' AND episode_id IN (SELECT episode_id FROM episode WHERE title = 'True North');
SELECT title, summary, air_date FROM episode INNER JOIN vote ON episode.episode_id = vote.episode_id WHERE vote.stars = 10 AND vote.votes = 72;
SELECT episode.air_date, episode.rating, COUNT(vote.stars) AS six_star_votes FROM episode JOIN vote ON episode.episode_id = vote.episode_id WHERE episode.episode_id = 12 AND vote.stars = 6;
SELECT person.name, award.role FROM award JOIN person ON award.person_id = person.person_id WHERE award.award_category = 'Edgar' AND award.year = 2000 AND award.award = 'Best Television Episode' AND award.result = 'Winner';
SELECT organization, year, award, award_category FROM award WHERE person_id = (     SELECT person_id     FROM person     WHERE name = 'Rene Balcer' ) AND result = 'Winner';
SELECT DISTINCT year, episode_id FROM award JOIN person ON award.person_id = person.person_id JOIN episode ON award.episode_id = episode.episode_id WHERE name = 'Constantine Makris' AND organization = 'American Bar Association Silver Gavel Awards for Media and the Arts' AND award_category = 'Silver Gavel Award' AND result = 'Winner' GROUP BY year, episode_id HAVING COUNT(DISTINCT year) >= 2; 
SELECT person.name FROM person JOIN (     SELECT    person_id     FROM     award     WHERE     result = 'Winner'     AND     award_category = 'Silver Gavel Award'     AND     organization = 'American Bar Association Silver Gavel Awards for Media and the Arts'     GROUP BY     person_id     HAVING     COUNT(DISTINCT year) = 2 ) AS silver_gavel_winners ON person.person_id = silver_gavel_winners.person_id JOIN (     SELECT    person_id     FROM     credit     WHERE     role = 'writer'     AND     category = 'series' ) AS series_writers ON person.person_id = series_writers.person_id JOIN (     SELECT    episode_id     FROM     episode     WHERE     series = 'Law and Order' ) AS law_and_order_episodes ON law_and_order_episodes.episode_id = series_writers.episode_id;
SELECT COUNT(*) FROM     episode JOIN     award ON episode.episode_id = award.episode_id JOIN     series ON episode.series = series.series WHERE     series.series = 'Law and Order'     AND episode.number_in_series = 20     AND award.organization = 'Primetime Emmy Awards'     AND award.year = 1999     AND award.result = 'nominee';
SELECT episode.title, award.role FROM episode JOIN award ON episode.episode_id = award.episode_id JOIN person ON award.person_id = person.person_id WHERE person.name = 'Julia Roberts' AND award.result = 'Winner' AND award.award_category = 'Outstanding Guest Actress in a Drama Series' AND award.year = 1999 AND award.organization = 'Primetime Emmy Awards';
SELECT episode.title, episode.air_date FROM episode JOIN credit ON episode.episode_id = credit.episode_id JOIN person ON credit.person_id = person.person_id WHERE person.name = 'Billy Fox' AND credit.role = 'producer';
SELECT COUNT(*) AS uncredited_american_cast FROM credit JOIN person ON credit.person_id = person.person_id WHERE credit.episode_id = 'tt0629228' AND person.birth_country = 'USA' AND credit.category = 'Cast' AND credit.credited = ''
SELECT role FROM credit JOIN person ON credit.person_id = person.person_id JOIN episode ON credit.episode_id = episode.episode_id WHERE person.name = 'Jason Kuschner' AND episode.number_in_series = 9; 
SELECT person.name FROM credit JOIN person ON credit.person_id = person.person_id WHERE credit.role = 'president of NBC West Coast' AND credit.episode_id = 1; 
SELECT episode.title FROM episode JOIN (     SELECT episode_id, SUM(stars * percent / 100) AS weighted_stars     FROM vote     GROUP BY episode_id     ORDER BY weighted_stars DESC     LIMIT 3 ) AS top_episodes ON episode.episode_id = top_episodes.episode_id 
SELECT COUNT(person_id) / (     SELECT COUNT(*)     FROM credit     WHERE episode_id = 2 AND category = 'Cast' ) AS ratio, role FROM credit JOIN person ON credit.person_id = person.person_id WHERE episode_id = 2 AND category = 'Cast' AND birth_country = 'USA' GROUP BY role;
SELECT COUNT(DISTINCT person_id) FROM     person WHERE     birth_country = 'Canada'     AND person_id IN (         SELECT DISTINCT person_id         FROM award         WHERE award IS NOT NULL     );
SELECT COUNT(DISTINCT episode_id) FROM credit WHERE person_id = (     SELECT person_id     FROM person     WHERE name = 'Jerry Orbach' ); 
SELECT person.name FROM credit JOIN person ON credit.person_id = person.person_id WHERE credit.episode_id = 9; 
SELECT award.title FROM award WHERE award.episode_id = 20 AND (award.result = 'Winner' OR award.result = 'Nominee'); 
SELECT role FROM (     SELECT        role,         COUNT(DISTINCT award_id) AS num_awards     FROM         award     GROUP BY         role     HAVING         num_awards >= 2 ) AS roles_with_multiple_awards; 
SELECT person.name, episode.number_in_series FROM person JOIN credit ON person.person_id = credit.person_id JOIN episode ON credit.episode_id = episode.episode_id JOIN award ON person.person_id = award.person_id AND episode.episode_id = award.episode_id WHERE credit.role = 'director' AND award.result = 'Winner';
SELECT episode.* FROM episode INNER JOIN award ON episode.episode_id = award.episode_id WHERE award.result = 'Nominee'
SELECT episode.season, episode.episode, AVG(episode.rating) AS average_rating FROM episode WHERE episode.season = 9 GROUP BY episode.season, episode.episode;
SELECT SUM(CASE WHEN episode.episode_id = 1 THEN vote.votes ELSE 0 END) - SUM(CASE WHEN episode.episode_id = 24 THEN vote.votes ELSE 0 END) AS difference FROM vote JOIN episode ON vote.episode_id = episode.episode_id WHERE vote.stars = 10;
SELECT episode.rating FROM episode JOIN award ON episode.episode_id = award.episode_id WHERE award.result = 'Winner' ORDER BY COUNT(award.award_id) DESC LIMIT 1; 
SELECT COUNT(*) FROM credit WHERE episode_id BETWEEN 1 AND 10 AND credited = 'true';
SELECT episode.title FROM episode JOIN keyword ON episode.episode_id = keyword.episode_id WHERE keyword.keyword = 'mafia';
SELECT AVG(stars) AS average_star_with_highest_percentage FROM     episode JOIN     award ON episode.episode_id = award.episode_id JOIN     vote ON episode.episode_id = vote.episode_id WHERE     award.result = 'Winner' GROUP BY     episode.episode_id HAVING     MAX(percent);
SELECT AVG(episode.rating) FROM     episode JOIN     award ON episode.episode_id = award.episode_id;
SELECT COUNT(DISTINCT award.person_id) FROM award WHERE award_category = 'Television'  AND organization = 'American Bar Association Silver Gavel Awards for Media and the Arts'  AND result = 'Winner';
SELECT birth_region FROM person WHERE name = 'Michael Preston';
SELECT person.name FROM     person JOIN     credit ON person.person_id = credit.person_id JOIN     episode ON credit.episode_id = episode.episode_id JOIN     award ON person.person_id = award.person_id WHERE     credit.role = 'Katrina Ludlow'     AND award.result = 'Nominee'     AND episode.series = 'Law & Order'; 
SELECT person.name FROM person JOIN credit ON person.person_id = credit.person_id JOIN award ON credit.episode_id = award.episode_id AND credit.role = 'teleplay' WHERE award.award_category = 'Best Television Episode' AND award.result = 'Winner';
SELECT person.birthdate FROM     person JOIN     credit ON person.person_id = credit.person_id WHERE     credit.role = 'writer' 
SELECT episode.title FROM episode INNER JOIN award ON episode.episode_id = award.episode_id WHERE award.award_category = 'Outstanding Costume Design for a Series'
SELECT episode.title FROM episode JOIN vote ON episode.episode_id = vote.episode_id GROUP BY episode.title ORDER BY SUM(vote.votes) DESC LIMIT 1;
SELECT person.name FROM     person JOIN     credit ON person.person_id = credit.person_id WHERE     credit.role = 'Alex Brown'     AND credit.credited = 'true';
SELECT person.birth_place FROM person LEFT JOIN credit ON person.person_id = credit.person_id WHERE person.person_id = 'nm0007064' AND credit.role != 'narrator' AND credit.credited = '' 
SELECT keyword.keyword FROM keyword JOIN episode ON keyword.episode_id = episode.episode_id WHERE episode.title = 'Shield';
SELECT person.name FROM person JOIN credit ON person.person_id = credit.person_id JOIN episode ON credit.episode_id = episode.episode_id JOIN award ON episode.episode_id = award.episode_id WHERE person.height_meters > 1.80 AND award.result = 'Winner'; 
SELECT episode.title FROM episode JOIN keyword ON episode.episode_id = keyword.episode_id WHERE keyword.keyword = 'nun' OR keyword.keyword = 'priest' GROUP BY episode.title HAVING COUNT(DISTINCT keyword.keyword) = 2; 
SELECT MAX(episode.episode_id) FROM   episode JOIN   award   ON episode.episode_id = award.episode_id JOIN   vote   ON episode.episode_id = vote.episode_id WHERE   award.award_category = 'Best Television Episode'   AND award.result = 'Winner'   AND episode.rating = 8.5   AND vote.stars > 0   AND vote.stars = (     SELECT      DISTINCT stars     FROM       vote     WHERE       stars < (         SELECT          MAX(stars)         FROM           vote         WHERE           stars < (             SELECT              MAX(stars)             FROM               vote           )       )   );
SELECT episode.title FROM     episode JOIN     vote ON episode.episode_id = vote.episode_id WHERE     vote.stars = 10 ORDER BY     vote.votes DESC LIMIT 3;
SELECT MAX(value) AS "Height" FROM observations JOIN patients ON observations.patient = patients.patient JOIN encounters ON observations.encounter = encounters.id WHERE patients.first = 'Elly' AND patients.last = 'Koss' AND observations.date = '2008-03-11' AND observations.description = 'Body Height';
SELECT ROUND((o2.value - o1.value), 2) AS weight_increase FROM observations o1 JOIN observations o2 ON o1.patient = o2.patient AND o1.code = o2.code JOIN patients p ON o1.patient = p.patient WHERE o1.description = 'Body Weight' AND o2.description = 'Body Weight' AND o1.date LIKE '2008%' AND o2.date LIKE '2009%' AND p.first = 'Elly' AND p.last = 'Koss';
SELECT MAX(value) AS highest_systolic_blood_pressure FROM     observations WHERE     patient = (SELECT patient FROM patients WHERE first = 'Elly' AND last = 'Koss');
SELECT COUNT(*)  FROM observations JOIN patients ON observations.patient = patients.patient JOIN encounters ON observations.encounter = encounters.id WHERE patients.first = 'Elly' AND patients.last = 'Koss' AND observations.description = 'Systolic Blood Pressure';
SELECT MAX(observations.value) AS "Highest Systolic Blood Pressure", patients.first || ' ' || patients.last AS "Patient Full Name" FROM observations JOIN patients ON observations.patient = patients.patient WHERE observations.description = 'Systolic Blood Pressure'
SELECT SUM(MULTIPLY(365, SUBTRACT(strftime('%Y', medications.stop), strftime('%Y', medications.start))),     MULTIPLY(30, SUBTRACT(strftime('%m', medications.stop), strftime('%m', medications.start))),     SUBTRACT(strftime('%d', medications.stop), strftime('%d', medications.start))) FROM medications JOIN patients ON medications.patient = patients.patient WHERE patients.first = 'Elly' AND patients.last = 'Koss' AND medications.description LIKE 'Acetaminophen%';
SELECT medications.description FROM medications JOIN patients ON medications.patient = patients.patient WHERE patients.first = 'Elly' AND patients.last = 'Koss';
SELECT reasondescription FROM medications WHERE description LIKE 'Acetaminophen%' AND patient = (     SELECT patient     FROM patients     WHERE first = 'Elly'     AND last = 'Koss' );
SELECT medications.description FROM     medications JOIN     patients ON medications.patient = patients.patient JOIN     encounters ON medications.encounter = encounters.id JOIN     conditions ON conditions.encounter = encounters.id JOIN     all_prevalences ON conditions.description = all_prevalences.item WHERE     patients.first = 'Elly' AND patients.last = 'Koss'     AND conditions.reasondescription LIKE 'Streptococcal sore throat%' ;
SELECT first || ' ' || last AS full_name FROM patients INNER JOIN medications ON patients.patient = medications.patient WHERE medications.description LIKE 'Acetaminophen%' 
SELECT conditions.description FROM     conditions JOIN     patients ON conditions.patient = patients.patient WHERE     patients.first = 'Elly' AND patients.last = 'Koss' AND conditions.start = '2009-01-08';
SELECT SUM(MULTIPLY(365, SUBTRACT(strftime('%Y', conditions.stop), strftime('%Y', conditions.start))), MULTIPLY(30, SUBTRACT(strftime('%m', conditions.stop), strftime('%m', conditions.start))), SUBTRACT(strftime('%d', conditions.stop), strftime('%d', conditions.start))) FROM conditions JOIN patients ON conditions.patient = patients.patient WHERE patients.first = 'Elly' AND patients.last = 'Koss' AND conditions.description = 'Cystitis';
SELECT DIVIDE(SUM(value), COUNT(value))  FROM observations  WHERE description = 'Body Weight'  AND patient = (SELECT patient FROM patients WHERE first = 'Elly' AND last = 'Koss');
SELECT (DIVIDE(COUNT(patients.marital = 'M'), COUNT(patients.patient)) * 100) AS percentage FROM patients JOIN conditions ON patients.patient = conditions.patient JOIN all_prevalences ON conditions.description = all_prevalences.item WHERE all_prevalences.description = 'Cystitis';
SELECT MAX(o.value) AS body_height_status FROM observations o JOIN patients p ON o.patient = p.patient JOIN encounters e ON o.encounter = e.id WHERE p.first = 'Vincent' AND p.last = 'Wyman' AND o.description = 'Body Height' AND e.date = '2010-08-02';
SELECT COUNT(*) FROM     careplans JOIN     patients ON careplans.patient = patients.patient WHERE     patients.last = 'Berge' AND patients.first = 'Norman' AND patients.gender = 'F'
SELECT careplans.reasondescription FROM careplans JOIN medications ON careplans.encounter = medications.encounter JOIN patients ON careplans.patient = patients.patient JOIN encounters ON careplans.encounter = encounters.id WHERE medications.description = 'Leucovorin 100 MG Injection' AND medications.start = '1970-12-19' AND patients.first = 'Annabelle' AND patients.last = 'Pouros'; 
SELECT ROUND((COUNT(conditions.patient) * 100.0) / (SELECT COUNT(*) FROM conditions), 2) AS "Prevalence Percentage" FROM conditions WHERE conditions.code = '64859006';
SELECT SUM(CASE WHEN conditions.code = '368581000119106' THEN 1 ELSE 0 END) * 1.0 / COUNT(DISTINCT patients.patient) AS prevalence_rate FROM conditions
SELECT procedures.description FROM     procedures JOIN     patients ON procedures.patient = patients.patient JOIN     encounters ON procedures.encounter = encounters.id WHERE     patients.first = 'Jacquelyn' AND patients.last = 'Shanahan'     AND encounters.date = '2009-08-09';
SELECT COUNT(claims.id) FROM claims JOIN patients ON claims.patient = patients.patient WHERE patients.first = 'Abbie' AND patients.last = 'Cole' AND claims.billableperiod BETWEEN '2010-12-31' AND '2012-01-01';
SELECT COUNT(*) FROM allergies JOIN patients ON allergies.patient = patients.patient WHERE patients.first = 'Saundra' AND patients.last = 'Monahan' AND patients.gender = 'F'
SELECT patients.first, patients.last FROM claims JOIN patients ON claims.patient = patients.patient WHERE claims.billableperiod = '1947-09-11';
SELECT description FROM encounters JOIN patients ON encounters.patient = patients.patient WHERE patients.first = 'Hubert' AND patients.last = 'Baumbach' AND encounters.date = '2008-10-25';
SELECT conditions.description FROM conditions JOIN patients ON conditions.patient = patients.patient WHERE patients.first = 'Keven' AND patients.last = 'Kuhn' AND conditions.start = '2016-09-24' AND conditions.stop = '2016-10-10';
SELECT encounters.date FROM encounters JOIN procedures ON encounters.id = procedures.encounter JOIN patients ON encounters.patient = patients.patient WHERE patients.last = 'Deckow' AND patients.first = 'Ira' AND procedures.description = 'Standard pregnancy test';
SELECT AVG((julianday(careplans.stop) - julianday(careplans.start))) AS average_period FROM     careplans JOIN     patients ON careplans.patient = patients.patient WHERE     patients.last = 'Lemke' AND patients.first = 'Wesley';
SELECT AVG(DIVIDE(SUBTRACT(stop time - start time), COUNT(DESCRIPTION = 'Normal pregnancy')))  FROM patients  WHERE first = 'Angelena' AND last = 'Kertzmann';
SELECT MAX(SUBTRACT((SUBSTR(allergies.stop, -2, 1) != '9' THEN CAST(SUBSTR(allergies.stop, LENGTH(allergies.stop) - 1) AS INTEGER) + 2000 ELSE NULL END), (SUBSTR(allergies.start, -2, 1) = '9' THEN CAST(SUBSTR(allergies.start, LENGTH(allergies.start) - 1) AS INTEGER) + 1900 ELSE CAST(SUBSTR(allergies.start, LENGTH(allergies.start) - 1) AS INTEGER) + 2000 END))) AS longest_allergy_period FROM allergies WHERE allergies.stop IS NOT NULL;
SELECT COUNT(DISTINCT patients.patient) FROM conditions JOIN patients ON conditions.patient = patients.patient WHERE conditions.description = 'Diabetes' AND conditions.start LIKE '1988%'
SELECT COUNT(DISTINCT patients.patient) FROM     allergies JOIN     patients ON allergies.patient = patients.patient WHERE     allergies.description = 'Allergy to eggs';
SELECT MAX(conditions.start) AS latest_start FROM conditions WHERE conditions.description = 'Hypertension';
SELECT MAX(description) AS most_common_allergy FROM allergies GROUP BY description ORDER BY COUNT(description) DESC LIMIT 1;
SELECT patients.patient FROM observations JOIN patients ON observations.patient = patients.patient WHERE observations.description = 'Body Height' AND observations.value = (     SELECT MAX(value)     FROM observations     WHERE description = 'Body Height' ); 
SELECT MAX(description) AS most_common_condition FROM conditions JOIN patients ON conditions.patient = patients.patient WHERE gender = 'F' AND ethnicity = 'american' GROUP BY description ORDER BY COUNT(description) DESC LIMIT 1;
SELECT COUNT(DISTINCT patients.patient) FROM medications JOIN patients ON medications.patient = patients.patient JOIN encounters ON medications.encounter = encounters.id WHERE medications.description = 'Ibuprofen 200 MG Oral Tablet' AND medications.start LIKE '2016%' AND patients.ethnicity = 'dominican' AND (strftime('%m', medications.stop) - strftime('%m', medications.start)) = 1;
SELECT COUNT(DISTINCT patients.patient) FROM   patients JOIN   conditions ON patients.patient = conditions.patient JOIN   all_prevalences ON conditions.description = all_prevalences.item WHERE   patients.birthdate LIKE '192%'   AND all_prevalences.description = 'Pneumonia';
SELECT patients.first || ' ' || patients.last AS full_name FROM patients JOIN medications ON patients.patient = medications.patient JOIN encounters ON medications.encounter = encounters.id WHERE medications.description = 'Yaz 28 Day Pack' AND medications.start LIKE '2011%' 
SELECT COUNT(DISTINCT patients.patient) FROM     patients JOIN     immunizations ON patients.patient = immunizations.patient JOIN     encounters ON immunizations.encounter = encounters.id WHERE     patients.race = 'black'     AND immunizations.description = 'DTaP'     AND immunizations.date LIKE '2013%'
SELECT COUNT(immunizations.date) FROM     immunizations WHERE     patient = (         SELECT            patients.patient         FROM             patients         JOIN             conditions ON patients.patient = conditions.patient         JOIN             all_prevalences ON conditions.description = all_prevalences.item         WHERE             conditions.start = (                 SELECT                    MAX(start)                 FROM                     conditions             )         ORDER BY             all_prevalences.prevalence_rate DESC         LIMIT 1     );
SELECT COUNT(DISTINCT patients.patient) FROM     conditions JOIN     all_prevalences ON conditions.description = all_prevalences.item GROUP BY     conditions.description HAVING     all_prevalences.prevalence_rate = (         SELECT            MAX(prevalence_rate)         FROM             all_prevalences     );
SELECT MAX(conditions.description) FROM conditions JOIN patients ON conditions.patient = patients.patient JOIN immunizations ON patients.patient = immunizations.patient JOIN encounters ON patients.patient = encounters.patient WHERE immunizations.description = 'Influenza seasonal injectable preservative free'
SELECT patients.patient FROM conditions JOIN all_prevalences ON conditions.description = all_prevalences.item WHERE all_prevalences.prevalence_percentage = 18.8; 
SELECT COUNT(conditions.code) FROM   conditions JOIN   patients ON conditions.patient = patients.patient WHERE   patients.first = 'Tyree' AND patients.last = 'Eichmann';
SELECT COUNT(DISTINCT patients.patient) FROM patients JOIN immunizations ON patients.patient = immunizations.patient JOIN conditions ON patients.patient = conditions.patient AND immunizations.encounter = conditions.encounter WHERE immunizations.description = 'meningococcal MCV4P' AND conditions.description = 'Viral sinusitis (disorder)';
SELECT COUNT(DISTINCT patients.patient) FROM patients JOIN conditions ON patients.patient = conditions.patient JOIN all_prevalences ON conditions.description = all_prevalences.item WHERE conditions.description = 'Prediabetes' AND patients.gender = 'F';
SELECT patients.first || ' ' || patients.last AS full_name FROM patients JOIN observations ON patients.patient = observations.patient JOIN encounters ON patients.patient = encounters.patient WHERE observations.description = 'Body Mass Index' AND observations.units = 'kg/m2' AND observations.value = (     SELECT MIN(value)     FROM observations     WHERE description = 'Body Mass Index'     AND units = 'kg/m2'     ) ;
SELECT strftime('%Y', patients.deathdate) - strftime('%Y', patients.birthdate) AS age FROM patients JOIN conditions ON patients.patient = conditions.patient JOIN all_prevalences ON conditions.description = all_prevalences.item WHERE patients.first = 'Giovanni' AND patients.last = 'Russel' AND all_prevalences.description = 'Hypertension';
SELECT COUNT(DISTINCT patients.patient) AS asian_female_patients_with_oxaliplatin FROM     patients JOIN     encounters ON patients.patient = encounters.patient JOIN     medications ON patients.patient = medications.patient AND encounters.id = medications.encounter JOIN     all_prevalences ON medications.description = all_prevalences.item WHERE     patients.gender = 'F'     AND patients.ethnicity = 'Asian'     AND medications.description = 'oxaliplatin 5 MG/ML [Eloxatin]';
SELECT COUNT(DISTINCT patients.patient) FROM patients JOIN conditions ON patients.patient = conditions.patient JOIN all_prevalences ON conditions.description = all_prevalences.item WHERE conditions.description = 'Stroke' AND patients.deathdate IS NULL;
SELECT COUNT(DISTINCT allergies.patient) FROM allergies JOIN patients ON allergies.patient = patients.patient JOIN encounters ON allergies.encounter = encounters.id WHERE patients.race LIKE 'asian%' AND allergies.description = 'Allergy to peanuts';
SELECT AVG(observations.value) AS average_diastolic_blood_pressure FROM patients JOIN conditions ON patients.patient = conditions.patient JOIN observations ON patients.patient = observations.patient AND conditions.encounter = observations.encounter WHERE conditions.description = 'Hypertension' AND observations.description = 'Diastolic Blood Pressure';
SELECT medications.description FROM medications JOIN patients ON medications.patient = patients.patient WHERE patients.ssn = '999-94-3751';
SELECT ssn FROM     patients JOIN     allergies ON patients.patient = allergies.patient JOIN     encounters ON allergies.encounter = encounters.id WHERE     patients.gender = 'F'     AND patients.ethnicity = 'irish'     AND allergies.description = 'Allergy to grass pollen';
SELECT DISTINCT patients.patient FROM careplans JOIN patients ON careplans.patient = patients.patient WHERE careplans.code = '311791003'; 
SELECT MAX(conditions.description) AS condition FROM     conditions JOIN     patients ON conditions.patient = patients.patient WHERE     patients.deathdate IS NOT NULL AND     conditions.stop = (         SELECT            MAX(conditions.stop)         FROM             conditions         JOIN             patients ON conditions.patient = patients.patient         WHERE             patients.deathdate IS NOT NULL         AND             conditions.patient = (                 SELECT                    patients.patient                 FROM                     patients                 WHERE                     strftime('%Y', patients.birthdate) = (                         SELECT                            MAX(SUBTRACT(strftime('%Y', patients.deathdate), strftime('%Y', patients.birthdate)))                         FROM                             patients                         WHERE                             deathdate IS NOT NULL                     )             )     );
SELECT MAX(all_prevalences.occurrences) AS max_occurrences FROM all_prevalences;
SELECT observations.value, observations.units FROM observations JOIN patients ON observations.patient = patients.patient JOIN encounters ON observations.encounter = encounters.id WHERE observations.description = 'Glucose' AND patients.address = '365 Della Crossroad Suite 202 Deerfield MA 01342 US';
SELECT patients.ssn FROM patients JOIN conditions ON patients.patient = conditions.patient JOIN all_prevalences ON conditions.description = all_prevalences.item WHERE all_prevalences.prevalence_percentage < 0.3 * (     SELECT AVG(prevalence_percentage)     FROM all_prevalences ) LIMIT 5; 
SELECT COUNT(DISTINCT patients.patient) as total_patients, COUNT(DISTINCT CASE WHEN patients.gender = 'F' AND patients.race = 'asian' THEN patients.patient END) as asian_women, (CAST(COUNT(DISTINCT CASE WHEN patients.gender = 'F' AND patients.race = 'asian' THEN patients.patient END) AS FLOAT) / CAST(COUNT(DISTINCT patients.patient) AS FLOAT)) * 100 as percentage FROM patients JOIN conditions ON patients.patient = conditions.patient JOIN encounters ON conditions.encounter = encounters.id WHERE conditions.description = 'Acute bronchitis (disorder)';
SELECT COUNT(encounters.id) FROM encounters JOIN patients ON encounters.patient = patients.patient WHERE patients.last = 'D''Amore' AND patients.first = 'Major';
SELECT procedures.description FROM procedures JOIN encounters ON procedures.encounter = encounters.id JOIN patients ON encounters.patient = patients.patient WHERE patients.first = 'Emmy' AND patients.last = 'Waelchi';
SELECT patients.first, patients.last FROM patients JOIN procedures ON patients.patient = procedures.patient WHERE procedures.description = 'Extraction of wisdom tooth'; 
SELECT observations.value AS body_weight, observations.units AS weight_units FROM observations JOIN patients ON observations.patient = patients.patient WHERE patients.first = 'Elly' AND patients.last = 'Koss' AND observations.description = 'Body Weight'; 
SELECT patients.first, patients.last FROM patients JOIN allergies ON patients.patient = allergies.patient JOIN encounters ON allergies.encounter = encounters.id WHERE allergies.description = 'Allergy to soya'; 
SELECT COUNT(*) FROM     immunizations JOIN     patients ON immunizations.patient = patients.patient WHERE     patients.first = 'Keven' AND patients.last = 'Kuhn'     AND immunizations.description = 'DTaP';
SELECT  DISTINCT patients.first || ' ' || patients.last AS "Patient Name" FROM medications JOIN patients ON medications.patient = patients.patient JOIN encounters ON medications.encounter = encounters.id WHERE medications.description = 'Clopidogrel 75 MG Oral Tablet' AND (strftime('%Y', medications.stop) - strftime('%Y', medications.start)) > 10; 
SELECT medications.description, procedures.description FROM conditions JOIN patients ON conditions.patient = patients.patient JOIN encounters ON conditions.encounter = encounters.id LEFT JOIN medications ON medications.patient = patients.patient AND medications.encounter = encounters.id LEFT JOIN procedures ON procedures.patient = patients.patient AND procedures.encounter = encounters.id WHERE conditions.description = 'Third degree burn'
SELECT medications.description FROM     medications JOIN     patients ON medications.patient = patients.patient JOIN     allergies ON medications.patient = allergies.patient JOIN     encounters ON medications.encounter = encounters.id WHERE     allergies.description = 'Allergy to mould'     AND allergies.start = '6/6/16'
SELECT description FROM careplans JOIN conditions ON careplans.patient = conditions.patient AND careplans.encounter = conditions.encounter WHERE conditions.description = 'Secondary malignant neoplasm of colon'; 
SELECT SUM(CASE WHEN conditions.start = '5/9/2014' THEN all_prevalences.prevalence_rate ELSE 0 END) AS prevalence_rate FROM conditions JOIN all_prevalences ON conditions.description = all_prevalences.item;
SELECT patients.first || ' ' || patients.last AS name, CASE      WHEN patients.deathdate IS NULL THEN strftime('%Y', 'now') - strftime('%Y', patients.birthdate)     ELSE strftime('%Y', patients.deathdate) - strftime('%Y', patients.birthdate) END AS age FROM observations JOIN patients ON observations.patient = patients.patient WHERE observations.date LIKE '2011%' AND observations.description = 'Systolic Blood Pressure' AND observations.value = 200 AND observations.units = 'mmHg'; 
SELECT DIVIDE(   COUNT(DISTINCT immunizations.patient) FILTER (WHERE strftime('%Y', immunizations.date) = '2017' AND immunizations.description = 'Influenza seasonal injectable preservative free'),   COUNT(DISTINCT immunizations.patient) FILTER (WHERE strftime('%Y', immunizations.date) = '2017') ) as percentage, COUNT(DISTINCT immunizations.patient) FILTER (WHERE strftime('%Y', immunizations.date) = '2017' AND patients.ethnicity = 'english') as english_patients FROM immunizations JOIN encounters ON immunizations.encounter = encounters.id JOIN patients ON immunizations.patient = patients.patient;
SELECT patients.first FROM patients JOIN encounters ON patients.patient = encounters.patient WHERE encounters.reasondescription = 'Normal pregnancy'; 
SELECT patients.birthdate FROM patients JOIN encounters ON patients.patient = encounters.patient JOIN careplans ON patients.patient = careplans.patient AND encounters.id = careplans.encounter WHERE careplans.description = 'Outpatient Encounter';
SELECT patients.first FROM patients JOIN conditions ON patients.patient = conditions.patient WHERE conditions.description = 'Cystitis';
SELECT COUNT(DISTINCT patients.patient) FROM     patients JOIN     conditions ON patients.patient = conditions.patient JOIN     encounters ON conditions.encounter = encounters.id WHERE     conditions.description = 'Stroke'     AND patients.marital = 'M';
SELECT DISTINCT patients.address FROM patients JOIN claims ON patients.patient = claims.patient WHERE claims.billableperiod LIKE '2010%' 
SELECT patients.last FROM patients JOIN allergies ON patients.patient = allergies.patient JOIN encounters ON allergies.encounter = encounters.id WHERE allergies.description = 'Allergy to dairy product'; 
SELECT start FROM allergies JOIN patients ON allergies.patient = patients.patient WHERE patients.first = 'Angelo' AND patients.last = 'Buckridge'; 
SELECT COUNT(DISTINCT patients.patient) FROM patients JOIN allergies ON patients.patient = allergies.patient JOIN encounters ON allergies.encounter = encounters.id WHERE patients.gender = 'M' AND allergies.description = 'House dust mite allergy';
SELECT MAX(description) FROM allergies JOIN patients ON allergies.patient = patients.patient WHERE patients.race = 'white';
SELECT patients.first FROM patients JOIN immunizations ON patients.patient = immunizations.patient JOIN encounters ON immunizations.encounter = encounters.id WHERE immunizations.description = 'Influenza seasonal injectable preservative free'; 
SELECT COUNT(DISTINCT patients.patient) AS num_female_patients_accepted_HPV_quadrivalent_immunization FROM     patients JOIN     immunizations ON patients.patient = immunizations.patient JOIN     encounters ON immunizations.encounter = encounters.id WHERE     patients.gender = 'F' AND     immunizations.description = 'HPV quadrivalent';
SELECT encounters.description FROM encounters JOIN patients ON encounters.patient = patients.patient WHERE patients.birthplace = 'Pittsfield MA US';
SELECT COUNT(DISTINCT allergies.description) AS total_type_of_allergies FROM allergies JOIN patients ON allergies.patient = patients.patient WHERE patients.ethnicity = 'german';
SELECT AVG((julianday(careplans.stop) - julianday(patients.birthdate))/365.25) AS average_age FROM careplans JOIN patients ON careplans.patient = patients.patient WHERE careplans.reasondescription = 'Prediabetes'; 
SELECT COUNT(DISTINCT patients.patient) FROM     patients JOIN     medications ON patients.patient = medications.patient LEFT JOIN     conditions ON patients.patient = conditions.patient AND conditions.description = 'coronary heart disease' WHERE     medications.reasondescription = 'Coronary Heart Disease'     AND medications.stop IS NOT NULL     AND patients.deathdate IS NULL;
SELECT COUNT(DISTINCT patients.patient) FROM procedures JOIN patients ON procedures.patient = patients.patient WHERE procedures.description = 'Bone immobilization' AND patients.drivers IS NOT NULL;
SELECT   first || ' ' || last AS full_name FROM patients WHERE patient IN (     SELECT patient     FROM allergies     GROUP BY patient     HAVING COUNT(DISTINCT description) = 3 ) 
SELECT COUNT(DISTINCT patients.patient) FROM patients JOIN allergies ON patients.patient = allergies.patient JOIN encounters ON patients.patient = encounters.patient JOIN immunizations ON patients.patient = immunizations.patient AND encounters.id = immunizations.encounter WHERE allergies.description = 'Allergy to eggs' AND immunizations.description = 'Td (adult) preservative free';
SELECT COUNT(DISTINCT patients.patient) FROM     patients JOIN     observations ON patients.patient = observations.patient JOIN     careplans ON patients.patient = careplans.patient AND observations.encounter = careplans.encounter WHERE     observations.description = 'Body Weight'     AND observations.value > 100     AND observations.units = 'kg'     AND careplans.description = 'Diabetes self management plan';
SELECT MAX(Gender) FROM     (     SELECT        Gender,         COUNT(*) AS GenderCount     FROM         patients     JOIN         allergies ON patients.patient = allergies.patient     WHERE         allergies.description = 'Dander (animal) allergy'     GROUP BY         Gender     );
SELECT claims.billableperiod FROM claims JOIN patients ON claims.patient = patients.patient WHERE patients.last = 'Dickinson'; 
SELECT patients.first || ' ' || patients.last AS full_name FROM conditions JOIN patients ON conditions.patient = patients.patient WHERE conditions.description = 'Otitis media'; 
SELECT COUNT(DISTINCT patients.patient) FROM     patients JOIN     medications ON medications.patient = patients.patient JOIN     conditions ON conditions.patient = patients.patient JOIN     all_prevalences ON conditions.description = all_prevalences.item WHERE     patients.ethnicity = 'Irish'     AND medications.reasondescription = 'Myocardial Infarction';
SELECT COUNT(DISTINCT patients.patient) FROM careplans JOIN patients ON careplans.patient = patients.patient WHERE careplans.description = 'Concussion with loss of consciousness' AND patients.marital = 'M';
SELECT COUNT(DISTINCT immunizations.patient) FROM   immunizations JOIN   careplans ON immunizations.patient = careplans.patient JOIN   encounters ON immunizations.encounter = encounters.id WHERE   immunizations.description = 'rotavirus monovalent'   AND careplans.stop = '2013-11-23';
SELECT COUNT(DISTINCT patients.patient) AS women_nitroglycerin FROM patients JOIN medications ON patients.patient = medications.patient JOIN encounters ON medications.encounter = encounters.id WHERE patients.gender = 'F' AND medications.description = 'Nitroglycerin 0.4 MG/ACTUAT [Nitrolingual]'
SELECT ((SELECT COUNT(DISTINCT patients.patient)    FROM patients    WHERE birthplace = 'Pembroke MA US')  * 100.0) / (SELECT COUNT(DISTINCT patients.patient)  FROM patients  JOIN allergies ON patients.patient = allergies.patient  JOIN encounters ON allergies.encounter = encounters.id  WHERE allergies.description = 'Allergy to grass pollen');
SELECT AVG(observations.value) AS average_body_weight FROM observations JOIN patients ON observations.patient = patients.patient WHERE observations.description = 'Body Weight' AND observations.units = 'kg' AND patients.race = 'asian';
SELECT ssn FROM patients JOIN allergies ON patients.patient = allergies.patient WHERE allergies.description = 'Latex allergy'; 
SELECT MAX(allergies.stop - allergies.start) AS allergy_duration,     allergies.description AS allergy_type FROM     allergies     JOIN patients ON allergies.patient = patients.patient WHERE     patients.first = 'Isadora' AND patients.last = 'Moen';
SELECT COUNT(*) FROM     careplans JOIN     patients ON careplans.patient = patients.patient WHERE     patients.first = 'Elly' AND patients.last = 'Koss'     AND careplans.start BETWEEN '2009-11-01' AND '2010-10-23';
SELECT patients.first, patients.last FROM careplans JOIN patients ON careplans.patient = patients.patient WHERE year(careplans.start) = 2009 AND patients.marital = 'M' AND (julianday(careplans.stop) - julianday(careplans.start)) > 60; 
SELECT DATE FROM     immunizations     JOIN patients ON immunizations.patient = patients.patient WHERE     patients.first = 'Elly' AND patients.last = 'Koss'     AND immunizations.description = 'Influenza seasonal injectable preservative free';
SELECT COUNT(*)  FROM immunizations JOIN patients ON immunizations.patient = patients.patient JOIN encounters ON immunizations.encounter = encounters.id WHERE immunizations.date BETWEEN '2010-07-09' AND '2013-10-29' AND patients.race = 'black' AND immunizations.description = 'meningococcal MCV4P';
SELECT immunizations.code, immunizations.date FROM immunizations JOIN patients ON immunizations.patient = patients.patient JOIN encounters ON immunizations.encounter = encounters.id WHERE patients.first = 'Jacquelyn' AND patients.last = 'Shanahan' AND immunizations.description = 'Influenza seasonal injectable preservative free';
SELECT   CAST((julianday(medications.stop) - julianday(medications.start)) AS INTEGER) AS duration FROM   patients JOIN   medications ON patients.patient = medications.patient JOIN   conditions ON patients.patient = conditions.patient AND medications.encounter = conditions.encounter JOIN   encounters ON medications.encounter = encounters.id WHERE   patients.first = 'Berry' AND patients.last = 'Keebler'   AND medications.description = 'Acetaminophen 160 MG'   AND medications.reasondescription = 'Acute bronchitis (disorder)'; 
SELECT COUNT(DISTINCT medications.patient) FROM medications JOIN encounters ON medications.encounter = encounters.id WHERE substr(medications.start, 1, 4) = '2010' AND substr(medications.stop, 1, 4) = '2010' AND medications.description = 'Nitrofurantoin 5 MG/ML [Furadantin]' AND medications.reasondescription = 'Cystitis';
SELECT reasondescription FROM encounters JOIN patients ON encounters.patient = patients.patient WHERE patients.last = 'Vandervort' AND patients.first = 'Lavelle' AND encounters.date = '2013-11-20';
SELECT COUNT(DISTINCT patients.patient) FROM     patients JOIN     encounters ON patients.patient = encounters.patient WHERE     patients.ethnicity = 'german'     AND encounters.date BETWEEN '2011-09-01' AND '2012-08-29'     AND encounters.description = 'Outpatient Encounter';
SELECT patients.ssn, patients.address FROM patients JOIN encounters ON patients.patient = encounters.patient WHERE encounters.date = '2008-06-13' AND encounters.reasondescription = 'Viral sinusitis (disorder)';
SELECT medications.reasondescription AS reason, medications.description AS drug_name, (julianday(medications.stop) - julianday(medications.start)) AS duration, CASE     WHEN patients.deathdate IS NULL THEN 'Patient is alive'     ELSE 'Patient is not alive' END AS patient_status FROM medications JOIN encounters ON medications.encounter = encounters.id JOIN patients ON medications.patient = patients.patient WHERE encounters.id = '23c293ec-dbae-4a22-896e-f12cf3c8bac3';
SELECT COUNT(patients.first || ' ' || patients.last) AS num_patients, patients.first || ' ' || patients.last AS full_name FROM patients JOIN allergies ON patients.patient = allergies.patient JOIN encounters ON allergies.encounter = encounters.id WHERE allergies.description = 'Shellfish allergy' AND (julianday(patients.deathdate) - julianday(patients.birthdate)) / 365 < 12;
SELECT julianday(medications.STOP) - julianday(medications.START) AS prescription_duration FROM medications JOIN patients ON medications.patient = patients.patient JOIN encounters ON medications.encounter = encounters.id WHERE patients.first = 'Major' AND patients.last = 'D''Amore' AND medications.description = 'Amoxicillin 250 MG / Clavulanate 125 MG [Augmentin]';
SELECT COUNT(DISTINCT medications.description) AS num_medication_types FROM medications JOIN patients ON medications.patient = patients.patient WHERE patients.last = 'D\'Amore' AND patients.first = 'Major';
SELECT observations.description, observations.value, observations.units FROM observations JOIN patients ON observations.patient = patients.patient WHERE patients.first = 'Bella' AND patients.last = 'Rolfson';
SELECT patients.first, patients.last FROM patients JOIN observations ON patients.patient = observations.patient WHERE observations.description = 'Calcium' AND observations.value < 8.6; 
SELECT conditions.description, COUNT(conditions.description) AS condition_count FROM conditions JOIN observations ON conditions.patient = observations.patient AND conditions.encounter = observations.encounter WHERE observations.description = 'Body Mass Index' AND observations.value < 18.5 GROUP BY conditions.description ORDER BY condition_count DESC LIMIT 5; 
SELECT COUNT(DISTINCT patients.patient) FROM patients JOIN encounters ON patients.patient = encounters.patient JOIN immunizations ON patients.patient = immunizations.patient AND encounters.id = immunizations.encounter WHERE encounters.reasondescription = 'Normal pregnancy';
SELECT * FROM careplans JOIN patients ON careplans.patient = patients.patient WHERE patients.first = 'Elly' AND patients.last = 'Koss' AND substr(careplans.start, 1, 4) = '1970' AND substr(careplans.stop, 1, 4) = '1970'; 
SELECT careplans.description AS care_plan, procedures.description AS procedure, medications.description AS medication, patients.first || ' ' || patients.last AS full_name FROM careplans JOIN patients ON careplans.patient = patients.patient JOIN encounters ON careplans.encounter = encounters.id JOIN procedures ON procedures.encounter = encounters.id JOIN medications ON medications.encounter = encounters.id WHERE encounters.id = '6f2e3935-b203-493e-a9c0-f23e847b9798';
SELECT COUNT(CASE WHEN patients.gender = 'M' AND conditions.description = 'Hypertension' THEN patients.patient END) AS male_patients_with_hypertension, COUNT(CASE WHEN patients.gender = 'F' AND conditions.description = 'Hypertension' THEN patients.patient END) AS female_patients_with_hypertension FROM patients JOIN conditions ON patients.patient = conditions.patient;
SELECT COUNT(DISTINCT patients.patient) AS unmarried_women_checked_for_normal_pregnancy FROM patients JOIN encounters ON patients.patient = encounters.patient JOIN conditions ON conditions.encounter = encounters.id WHERE patients.marital = 'S' AND patients.gender = 'F' AND conditions.description = 'normal pregnancy';
SELECT procedures.description AS procedure, medications.description AS medicine FROM procedures JOIN encounters ON procedures.encounter = encounters.id JOIN medications ON medications.encounter = encounters.id WHERE encounters.reasondescription = 'Drug overdose';
SELECT AVG(observations.value) AS average_bmi FROM observations JOIN patients ON observations.patient = patients.patient WHERE observations.description = 'Body Mass Index' AND patients.patient IN (     SELECT DISTINCT patients.patient     FROM observations     JOIN patients ON observations.patient = patients.patient     WHERE observations.description = 'Total Cholesterol'     AND observations.value >= 200 );
SELECT SUM(CASE WHEN strftime('%Y', t2.date) - strftime('%Y', t1.birthdate) BETWEEN 20 AND 29 THEN t2.value ELSE 0 END) / COUNT(CASE WHEN strftime('%Y', t2.date) - strftime('%Y', t1.birthdate) BETWEEN 20 AND 29 THEN t2.patient ELSE NULL END) - SUM(CASE WHEN strftime('%Y', t2.date) - strftime('%Y', t1.birthdate) BETWEEN 50 AND 59 THEN t2.value ELSE 0 END) / COUNT(CASE WHEN strftime('%Y', t2.date) - strftime('%Y', t1.birthdate) BETWEEN 50 AND 59 THEN t2.patient ELSE NULL END)
SELECT ROUND((CAST((SELECT COUNT(*) FROM conditions             WHERE strftime('%Y', 'now') - strftime('%Y', birthdate) > 60             GROUP BY description             ORDER BY COUNT(description) DESC LIMIT 1) AS FLOAT) /             (SELECT COUNT(*) FROM conditions             GROUP BY description             ORDER BY COUNT(description) DESC LIMIT 1) * 100), 2) AS percentage 
SELECT reasondescription FROM encounters WHERE patient = (SELECT patient FROM patients WHERE first = 'Walter' AND last = 'Bahringer') AND substr(date, 1, 7) = '2009-07';
SELECT MIN(strftime('%Y', encounters.date)) - strftime('%Y', patients.birthdate) AS age_at_first_admission FROM encounters JOIN patients ON encounters.patient = patients.patient WHERE encounters.reasondescription = 'Drug overdose' AND patients.first = 'Stacy' AND patients.last = 'Morar' AND encounters.date = (SELECT MIN(date) FROM encounters WHERE patient = patients.patient AND reasondescription = 'Drug overdose');
SELECT MAX(medications.description) AS most_administered_drug FROM medications JOIN conditions ON medications.encounter = conditions.encounter AND medications.patient = conditions.patient WHERE conditions.description = 'Child attention deficit disorder';
SELECT patients.first || ' ' || patients.last AS full_name FROM procedures JOIN patients ON procedures.patient = patients.patient WHERE procedures.description = 'Transplant of lung (procedure)';
SELECT AVG(CASE      WHEN procedures.description = 'Combined chemotherapy and radiation therapy (procedure)'      THEN 1      ELSE 0      END) FROM procedures WHERE substr(procedures.date, 1, 4) IS NOT NULL;
SELECT MAX(careplans.START),     careplans.STOP,     careplans.DESCRIPTION FROM     careplans JOIN     patients ON careplans.PATIENT = patients.PATIENT WHERE     patients.LAST = 'Shanahan' AND patients.FIRST = 'Jacquelyn';
SELECT SUBTRACT(allergies.START, allergies.STOP) AS allergy_period, allergies.DESCRIPTION AS trigger FROM allergies JOIN patients ON allergies.patient = patients.patient WHERE patients.first = 'Isadora' AND patients.last = 'Moen';
SELECT strftime('%Y', 'now') - strftime('%Y', p.birthdate) - (strftime('%m-%d', 'now') < strftime('%m-%d', p.birthdate)) AS age FROM patients p JOIN encounters e ON p.patient = e.patient WHERE p.last = 'Bernier' AND p.first = 'Laronda' ORDER BY e.date DESC LIMIT 1;
SELECT conditions.description FROM conditions JOIN patients ON conditions.patient = patients.patient JOIN encounters ON conditions.encounter = encounters.id WHERE patients.first = 'Joye' AND patients.last = 'Homenick' AND substr(conditions.start, 1, 4) = '2017';
SELECT MAX(immunizations.date) FROM     immunizations JOIN     patients ON immunizations.patient = patients.patient JOIN     encounters ON immunizations.encounter = encounters.id WHERE     patients.last = 'Homenick'     AND patients.first = 'Joye'     AND immunizations.description = 'Influenza seasonal injectable preservative free';
SELECT julianday(medications.stop) - julianday(medications.start) AS duration FROM medications JOIN patients ON medications.patient = patients.patient WHERE patients.first = 'Elly' AND patients.last = 'Koss' AND medications.description = 'Acetaminophen 160 MG';
SELECT COUNT(DISTINCT encounters.patient), careplans.description FROM encounters JOIN allergies ON allergies.encounter = encounters.id JOIN careplans ON careplans.encounter = encounters.id WHERE encounters.reasondescription = 'Second degree burn';
SELECT   MULTIPLY(     DIVIDE(         COUNT(DISTINCT encounters.patient) FILTER (WHERE gender = 'F' AND substr(encounters.date, 1, 4) = '2010'),         COUNT(DISTINCT encounters.patient) FILTER (WHERE encounters.reasondescription = 'Contact dermatitis' AND substr(encounters.date, 1, 4) = '2010')     ),     100.0 ) AS percentage_of_females_with_contact_dermatitis_in_2010 FROM encounters  
SELECT COUNT(encounters.id) AS total_interactions, ROUND((COUNT(CASE WHEN substr(encounters.date, 1, 4) BETWEEN '2010' AND '2017' THEN encounters.id END) * 1.0 / COUNT(encounters.id)) * 100, 2) AS prenatal_visits_percentage FROM encounters JOIN patients ON encounters.patient = patients.patient WHERE patients.first = 'Lorri' AND patients.last = 'Simons';
SELECT medications.description FROM medications INNER JOIN patients ON medications.patient = patients.patient WHERE patients.first = 'Joe' AND patients.last = 'Homenick';
SELECT careplans.start FROM careplans JOIN patients ON careplans.patient = patients.patient WHERE patients.maiden = 'Adams';
SELECT patients.first || ' ' || patients.last AS patient_name, MIN(careplans.start) AS earliest_careplan_start FROM patients JOIN careplans ON patients.patient = careplans.patient WHERE patients.gender = 'M' GROUP BY patients.patient ORDER BY earliest_careplan_start LIMIT 1;
SELECT 100.0 * (     SELECT        COUNT(DISTINCT careplans.patient) AS HispanicPatients     FROM         careplans     INNER JOIN         patients ON careplans.patient = patients.patient     WHERE         patients.ethnicity = 'hispanic' ) / (     SELECT        COUNT(DISTINCT careplans.patient) AS TotalPatients     FROM         careplans     INNER JOIN         patients ON careplans.patient = patients.patient ) AS PercentageHispanicPatientsStoppedCarePlanIn2011;
SELECT careplans.reasondescription FROM careplans INNER JOIN patients ON careplans.patient = patients.patient WHERE patients.first = 'Angelo' AND patients.last = 'Buckridge';
SELECT description FROM     careplans JOIN     patients ON careplans.patient = patients.patient WHERE     patients.ethnicity = 'american';
SELECT encounters.id FROM encounters JOIN patients ON encounters.patient = patients.patient WHERE patients.birthplace = 'Pembroke MA US';
SELECT careplans.start FROM careplans JOIN patients ON careplans.patient = patients.patient WHERE patients.deathdate IS NULL; 
SELECT COUNT(DISTINCT patients.patient) FROM     patients JOIN     careplans ON patients.patient = careplans.patient JOIN     encounters ON careplans.encounter = encounters.id WHERE     patients.race = 'white'     AND careplans.reasoncode = '10509002';
SELECT patients.first || ' ' || patients.last AS full_name FROM patients JOIN careplans ON patients.patient = careplans.patient WHERE careplans.description = 'Diabetic diet';
SELECT careplans.stop FROM careplans INNER JOIN patients ON careplans.patient = patients.patient WHERE patients.deathdate IS NOT NULL; 
SELECT COUNT(DISTINCT patients.patient) FROM   patients JOIN   careplans ON patients.patient = careplans.patient WHERE   patients.ethnicity = 'italian'   AND careplans.code = '304510005';
SELECT ROUND((CAST((SELECT COUNT(DISTINCT patients.patient) FROM patients WHERE gender = 'F') AS FLOAT) / (SELECT COUNT(DISTINCT patients.patient) FROM careplans WHERE substr(start, 1, 4) = '2010') * 100), 2) AS percentage_of_female_patients 
SELECT COUNT(DISTINCT patients.patient) FROM     patients JOIN     careplans ON patients.patient = careplans.patient WHERE     patients.race = 'black' AND     substr(careplans.stop, 1, 4) = '2017';
SELECT COUNT(DISTINCT patients.patient) FROM patients JOIN conditions ON patients.patient = conditions.patient JOIN all_prevalences ON conditions.description = all_prevalences.item WHERE patients.gender = 'M' AND conditions.description = 'Prediabetes';
SELECT patients.first || ' ' || patients.last AS full_name FROM patients JOIN allergies ON patients.patient = allergies.patient JOIN encounters ON allergies.encounter = encounters.id WHERE allergies.description = 'Allergy to nut'; 
SELECT conditions.description, conditions.start, conditions.stop FROM conditions JOIN patients ON conditions.patient = patients.patient WHERE patients.first = 'Wilmer' AND patients.last = 'Koepp'; 
SELECT COUNT(patients.gender) AS gender_count, patients.gender FROM conditions JOIN patients ON conditions.patient = patients.patient WHERE conditions.description = 'Viral sinusitis (disorder)' GROUP BY patients.gender ORDER BY gender_count DESC LIMIT 1;
SELECT patients.first || ' ' || patients.last AS full_name FROM medications JOIN patients ON medications.patient = patients.patient WHERE medications.description = 'Penicillin V Potassium 250 MG' AND substr(medications.start, 1, 4) >= '1948'; 
SELECT COUNT(*) AS white_patients_with_stroke FROM     patients JOIN     conditions ON patients.patient = conditions.patient JOIN     all_prevalences ON conditions.description = all_prevalences.item WHERE     patients.race = 'white'     AND substr(patients.birthdate, 1, 4) = '1935'     AND conditions.description = 'Stroke';
SELECT conditions.description FROM conditions JOIN immunizations ON conditions.patient = immunizations.patient JOIN encounters ON immunizations.encounter = encounters.id WHERE immunizations.description = 'IPV';
SELECT DISTINCT patients.patient FROM   patients JOIN   conditions ON patients.patient = conditions.patient JOIN   all_prevalences ON conditions.description = all_prevalences.item WHERE   all_prevalences.occurrences = (     SELECT      MAX(occurrences)     FROM       all_prevalences   );
SELECT patients.first || ' ' || patients.last AS full_name FROM patients JOIN conditions ON patients.patient = conditions.patient WHERE conditions.description = 'Cystitis'; 
SELECT COUNT(DISTINCT patients.patient) FROM patients JOIN immunizations ON patients.patient = immunizations.patient JOIN encounters ON immunizations.encounter = encounters.id WHERE patients.gender = 'M' AND immunizations.description = 'HPV quadrivalent';
SELECT start FROM careplans JOIN patients ON careplans.patient = patients.patient WHERE patients.first = 'Walter' AND patients.last = 'Bahringer';
SELECT careplans.description FROM careplans JOIN patients ON careplans.patient = patients.patient WHERE patients.last = 'D\'Amore' AND patients.first = 'Major'; 
SELECT 100.0 * (     SELECT         COUNT(DISTINCT p.patient)     FROM          patients p     JOIN          conditions c ON p.patient = c.patient     WHERE          p.gender = 'M'      AND          c.description = 'Viral sinusitis (disorder)' ) / (     SELECT         COUNT(DISTINCT patient)     FROM          patients ) AS percentage_of_male_patients_with_viral_sinusitis;
SELECT COUNT(DISTINCT patients.patient) * 100.0 / (SELECT COUNT(DISTINCT patients.patient) FROM patients JOIN medications ON patients.patient = medications.patient WHERE medications.description = 'Penicillin V Potassium 250 MG' AND patients.gender = 'F') FROM patients JOIN medications ON patients.patient = medications.patient WHERE medications.description = 'Penicillin V Potassium 250 MG';
SELECT AVG(observations.value) AS average_body_height FROM observations JOIN patients ON observations.patient = patients.patient JOIN encounters ON observations.encounter = encounters.id WHERE patients.race = 'white' AND observations.description = 'Body Height';
SELECT careplans.description FROM careplans JOIN patients ON careplans.patient = patients.patient JOIN encounters ON careplans.encounter = encounters.id WHERE patients.address = '179 Sydni Roads Taunton MA 02780 US';
SELECT allergies.description FROM allergies JOIN patients ON allergies.patient = patients.patient WHERE patients.first = 'Dirk' AND patients.last = 'Languish' AND patients.race = 'Dominican';
SELECT COUNT(DISTINCT allergies.patient) FROM allergies JOIN conditions ON allergies.patient = conditions.patient JOIN all_prevalences ON conditions.description = all_prevalences.item WHERE allergies.description = 'Allergy to peanuts' AND all_prevalences.description = 'Asthma';
SELECT patients.first, patients.last FROM patients JOIN conditions ON patients.patient = conditions.patient JOIN encounters ON conditions.encounter = encounters.id WHERE conditions.description = 'drug overdose' AND ROUND((julianday(conditions.start) - julianday(patients.birthdate)) / 365) = 44;
SELECT patients.ssn FROM observations JOIN patients ON observations.patient = patients.patient JOIN encounters ON observations.encounter = encounters.id WHERE observations.description = 'Systolic Blood Pressure' AND observations.value = (     SELECT MAX(observations.value)     FROM observations     WHERE observations.description = 'Systolic Blood Pressure' );
SELECT MAX(all_prevalences.prevalence_percentage) AS max_prevalence_percentage FROM all_prevalences;
SELECT careplans.description FROM careplans JOIN patients ON careplans.patient = patients.patient WHERE patients.ssn = '999-15-3685';
SELECT AVG(DIVIDE(SUBTRACT(julianday(substr(datetime('now'), 1, 10)), julianday(patients.birthdate)), 365)) FROM patients JOIN conditions ON conditions.patient = patients.patient JOIN all_prevalences ON conditions.description = all_prevalences.item WHERE patients.gender = 'M' AND conditions.description = 'Hypertension';
SELECT first || ' ' || last AS patient_name FROM patients JOIN medications ON patients.patient = medications.patient JOIN conditions ON patients.patient = conditions.patient AND medications.encounter = conditions.encounter WHERE conditions.description = 'Streptococcal sore throat (disorder)' LIMIT 5; 
SELECT patients.patient FROM observations JOIN patients ON observations.patient = patients.patient JOIN encounters ON observations.encounter = encounters.id WHERE observations.description = 'Body Weight' AND observations.value = 61.97 AND observations.units = 'kg';
SELECT patients.birthdate FROM patients JOIN medications ON patients.patient = medications.patient JOIN encounters ON medications.encounter = encounters.id WHERE patients.gender = 'M' AND medications.description = 'Penicillin V Potassium 250 MG' LIMIT 5; 
SELECT DISTINCT patients.first || ' ' || patients.last AS full_name FROM patients JOIN conditions ON patients.patient = conditions.patient JOIN all_prevalences ON conditions.description = all_prevalences.item WHERE patients.ethnicity = 'irish' GROUP BY patients.patient HAVING COUNT(conditions.description) > (SELECT AVG(all_prevalences.occurrences) * 0.96 FROM all_prevalences); 
SELECT COUNT(DISTINCT CASE WHEN patients.marital = 'M' THEN patients.patient END) - COUNT(DISTINCT CASE WHEN patients.marital = 'S' AND conditions.description = 'Diabetes' THEN patients.patient END) AS difference FROM patients LEFT JOIN conditions ON patients.patient = conditions.patient WHERE conditions.description = 'Diabetes';
SELECT country, COUNT(*) AS customer_count FROM customers GROUP BY country; 
SELECT DISTINCT products.productvendor, SUM(orderdetails.quantityordered * (products.msrp - products.buyprice)) AS estimated_earnings FROM products JOIN orderdetails ON products.productcode = orderdetails.productcode GROUP BY products.productvendor ORDER BY SUM(orderdetails.quantityordered) DESC LIMIT 1;
SELECT employees.firstname, employees.lastname FROM     employees JOIN     customers ON employees.employeenumber = customers.salesrepemployeenumber JOIN     payments ON customers.customernumber = payments.customernumber WHERE     strftime('%Y', payments.paymentdate) = '2004' GROUP BY     customers.customernumber ORDER BY     SUM(payments.amount) DESC LIMIT 1;
SELECT SUM(quantityOrdered * priceEach) AS total_price FROM     orders JOIN     customers ON orders.customerNumber = customers.customerNumber JOIN     orderdetails ON orders.orderNumber = orderdetails.orderNumber JOIN     products ON orderdetails.productCode = products.productCode WHERE     customers.customerName = 'Rovelli Gifts Distributors Ltd.'     AND orders.shippedDate BETWEEN '2003-01-01' AND '2003-12-31';
SELECT COUNT(*) FROM   employees JOIN   offices ON employees.officecode = offices.officecode WHERE   offices.city = 'Sydney';
SELECT employees.employeenumber FROM employees JOIN offices ON employees.officecode = offices.officecode WHERE employees.jobtitle = 'Sales Rep' AND offices.city = 'New York' AND employees.reportsto = 1143;
SELECT AVG(amount) AS average_annual_payment, MAX(amount) AS highest_annual_payment, MIN(amount) AS lowest_annual_payment FROM payments WHERE paymentDate BETWEEN '2003-01-01' AND '2005-12-31';
SELECT MAX(amount), addressline1 || ' ' || addressline2 || ', ' || city || ', ' || state || ', ' || country AS full_address FROM (SELECT    p.amount,     c.addressline1,     c.addressline2,     c.city,     c.state,     c.country FROM     payments p JOIN     customers c ON p.customernumber = c.customernumber ORDER BY     p.amount DESC LIMIT 5);
SELECT COUNT(payments.checknumber) FROM     payments JOIN     customers ON payments.customernumber = customers.customernumber WHERE     customers.customername = 'Euro+ Shopping Channel'     AND strftime('%Y', paymentdate) = '2004';
SELECT products.productname FROM products JOIN orderdetails ON products.productcode = orderdetails.productcode JOIN orders ON orderdetails.ordernumber = orders.ordernumber JOIN customers ON orders.customernumber = customers.customernumber WHERE products.productline = 'Classic Cars' AND products.productscale = '1:18' GROUP BY products.productname ORDER BY SUM(orderdetails.quantityordered) DESC LIMIT 1;
SELECT COUNT(*) AS num_customers, customernumber FROM customers WHERE creditlimit <= 100000 AND customernumber IN (     SELECT         customernumber     FROM payments     WHERE strftime('%Y', paymentdate) = '2004'     GROUP BY customernumber     ORDER BY SUM(amount) DESC     LIMIT 1 );
SELECT customers.customername, customers.contactlastname, customers.contactfirstname, SUM(payments.amount) AS total_payments FROM customers JOIN employees ON customers.salesrepemployeenumber = employees.employeenumber JOIN payments ON customers.customernumber = payments.customernumber WHERE employees.officecode = (     SELECT officecode     FROM offices     WHERE city = 'Tokyo' ) AND employees.reportsto = 1056 GROUP BY customers.customername ORDER BY total_payments DESC LIMIT 1;
SELECT (SELECT productname, (quantityordered * priceeach) AS total_price FROM orderdetails JOIN products ON orderdetails.productcode = products.productcode ORDER BY total_price DESC LIMIT 2)  UNION  (SELECT productname, (quantityordered * priceeach) AS total_price FROM orderdetails JOIN products ON orderdetails.productcode = products.productcode ORDER BY total_price ASC LIMIT 2)
SELECT COUNT(DISTINCT orders.ordernumber) AS num_cancelled_orders FROM orders JOIN orderdetails ON orders.ordernumber = orderdetails.ordernumber WHERE orders.status = 'Cancelled' AND (orderdetails.quantityordered * orderdetails.priceeach) > 4000;
SELECT COUNT(DISTINCT ordernumber) FROM orders JOIN orderdetails ON orders.ordernumber = orderdetails.ordernumber WHERE strftime('%Y', orderdate) = '2003' AND quantityordered < 30;
SELECT SUM(quantityordered * priceeach) AS total_value_cancelled_orders FROM     orders JOIN     orderdetails ON orders.ordernumber = orderdetails.ordernumber WHERE     orders.status = 'Cancelled';
SELECT SUM(quantityordered * priceeach) AS total_value FROM     orders JOIN     orderdetails ON orders.ordernumber = orderdetails.ordernumber JOIN     products ON orderdetails.productcode = products.productcode JOIN     productlines ON products.productline = productlines.productline WHERE     productlines.productline = 'Motorcycles';
SELECT COUNT(orders.ordernumber) FROM     orders JOIN     orderdetails ON orders.ordernumber = orderdetails.ordernumber JOIN     products ON orderdetails.productcode = products.productcode JOIN     productlines ON products.productline = productlines.productline WHERE     productlines.productline = 'Planes';
SELECT COUNT(DISTINCT ordernumber) FROM orders JOIN orderdetails ON orders.ordernumber = orderdetails.ordernumber JOIN products ON orderdetails.productcode = products.productcode WHERE (products.msrp - products.buyprice) > 100;
SELECT AVG(SUM(od.quantityordered * od.priceeach) / COUNT(o.ordernumber)) AS average_total_price FROM     orders o JOIN     orderdetails od ON o.ordernumber = od.ordernumber JOIN     products p ON od.productcode = p.productcode WHERE     p.productvendor = 'Exoto Designs' AND     strftime('%Y', o.orderdate) = '2005';
SELECT COUNT(*) FROM employees WHERE jobtitle = 'Sales Rep' AND officecode = 1;
SELECT customers.customername, SUM(payments.amount) AS total_payment_amount FROM customers JOIN payments ON customers.customernumber = payments.customernumber GROUP BY customers.customername HAVING total_payment_amount > 50000;
SELECT SUM(amount) FROM     payments     JOIN customers ON payments.customernumber = customers.customernumber WHERE     customers.country = 'USA';
SELECT SUM(payments.amount) AS total_payments FROM payments JOIN customers ON payments.customerNumber = customers.customerNumber WHERE customers.creditLimit = 0 AND strftime('%Y', payments.paymentDate) = '2003';
SELECT customers.customername, customers.phone FROM customers JOIN orders ON customers.customernumber = orders.customernumber WHERE orders.status = 'Cancelled';
SELECT COUNT(DISTINCT customers.customernumber) FROM     customers JOIN     orders ON customers.customernumber = orders.customernumber WHERE     customers.country = 'France'     AND orders.status = 'Cancelled' GROUP BY     customers.customernumber HAVING     COUNT(DISTINCT orders.ordernumber) >= 2;
SELECT AVG(od.quantityordered * od.priceeach) AS average_total_price FROM     orders o     JOIN orderdetails od ON o.ordernumber = od.ordernumber     JOIN customers c ON o.customernumber = c.customernumber WHERE     c.country = 'Germany'     AND o.status = 'Shipped';
SELECT employees.firstname || ' ' || employees.lastname AS full_name FROM employees JOIN offices ON employees.officecode = offices.officecode WHERE offices.city = 'Tokyo';
SELECT COUNT(employees.email), employees.firstname || ' ' || employees.lastname AS full_name, employees.email FROM employees JOIN offices ON employees.officecode = offices.officecode WHERE employees.jobtitle = 'Sales Rep' AND offices.city = 'Tokyo';
SELECT employees.email FROM employees JOIN offices ON employees.officecode = offices.officecode WHERE employees.reportsto = 1002 AND employees.firstname = 'Diane' AND employees.lastname = 'Murphy' AND offices.city = 'San Francisco';
SELECT employees.email, employees.employeenumber FROM employees JOIN offices ON employees.officecode = offices.officecode WHERE offices.country = 'USA' AND offices.state = 'MA';
SELECT COUNT(*), email FROM employees WHERE jobtitle = 'Sales Manager' AND officecode = (     SELECT    officecode     FROM     offices     WHERE     city = 'Sydney' );
SELECT employees.email, offices.country FROM employees JOIN offices ON employees.officecode = offices.officecode WHERE employees.country = 'Australia' AND employees.creditlimit < 20000;
SELECT employees.email FROM employees JOIN customers ON employees.employeenumber = customers.salesrepemployeenumber WHERE customers.country = 'UK' AND employees.jobtitle = 'Sales Rep' ORDER BY customers.creditlimit LIMIT 10;
SELECT COUNT(*) FROM customers WHERE country = 'Australia' AND creditlimit < 220000;
SELECT MAX(customernumber) AS customer_number FROM payments GROUP BY amount ORDER BY amount DESC LIMIT 3;
SELECT employees.email, employees.employeenumber FROM employees JOIN offices ON employees.officecode = offices.officecode WHERE offices.country = 'USA' AND offices.state = 'CA';
SELECT employees.firstname || ' ' || employees.lastname AS full_name FROM employees JOIN offices ON employees.officecode = offices.officecode WHERE offices.city = 'Boston';
SELECT MAX(customers.creditlimit) AS max_credit_limit, employees.email FROM customers JOIN employees ON customers.salesrepemployeenumber = employees.employeenumber WHERE customers.country = 'UK' AND employees.jobtitle = 'Sales Rep' GROUP BY employees.email ORDER BY max_credit_limit DESC LIMIT 3;
SELECT COUNT(customernumber) FROM customers WHERE country = 'Norway' AND creditlimit < 220000;
SELECT employees.firstname || ' ' || employees.lastname AS full_name, employees.email FROM employees JOIN offices ON employees.officecode = offices.officecode WHERE offices.city = 'Paris';
SELECT products.productcode FROM products JOIN productlines ON products.productline = productlines.productline WHERE productlines.productline = 'Motorcycles' ORDER BY products.quantityinstock DESC LIMIT 5;
SELECT COUNT(*) FROM customers JOIN employees ON customers.salesrepemployeenumber = employees.employeenumber WHERE customers.country = 'Germany' AND customers.creditlimit = 0;
SELECT COUNT(DISTINCT payments.customernumber) AS num_customers FROM     payments WHERE     paymentdate BETWEEN '2003-01-01' AND '2004-12-31' GROUP BY     payments.customernumber HAVING     COUNT(payments.customernumber) > 3;
SELECT AVG(priceEach - buyPrice) AS average_actual_profit FROM     products JOIN     orderdetails ON products.productcode = orderdetails.productcode WHERE     productname = '1937 Lincoln Berline';
SELECT MAX(products.productname) AS most_ordered_motorcycle FROM     products JOIN     orderdetails ON products.productcode = orderdetails.productcode JOIN     orders ON orderdetails.ordernumber = orders.ordernumber JOIN     customers ON orders.customernumber = customers.customernumber WHERE     products.productline = 'Motorcycles'     AND products.productscale = '1:10'     AND customers.country = 'USA'
SELECT COUNT(payments.checknumber), payments.checknumber FROM payments JOIN customers ON payments.customernumber = customers.customernumber WHERE customers.customername = 'Mini Gifts Distributors Ltd.' AND payments.paymentdate BETWEEN '2003-08-01' AND '2004-08-30';
SELECT MAX(MULTIPLY(quantityordered, priceeach)) - AVG(priceeach) FROM     orderdetails JOIN     products ON orderdetails.productcode = products.productcode JOIN     productlines ON products.productline = productlines.productline WHERE     productlines.productline = 'Planes';
SELECT SUM(orderdetails.quantityordered * orderdetails.priceeach) AS total_value FROM     orderdetails     JOIN orders ON orderdetails.ordernumber = orders.ordernumber     JOIN products ON orderdetails.productcode = products.productcode     JOIN productlines ON products.productline = productlines.productline WHERE     orders.status = 'Shipped'     AND productlines.productline = 'Vintage Cars'     AND strftime('%Y', orders.orderdate) BETWEEN '2003' AND '2004';
SELECT employees.firstname || ' ' || employees.lastname AS "Sales Agent", supervisor.firstname || ' ' || supervisor.lastname AS "Supervisor" FROM employees JOIN customers ON employees.employeenumber = customers.salesrepemployeenumber JOIN payments ON customers.customernumber = payments.customernumber JOIN (     SELECT customernumber, MAX(amount) AS max_payment     FROM payments ) AS max_payment ON payments.customernumber = max_payment.customernumber AND payments.amount = max_payment.max_payment JOIN employees AS supervisor ON employees.reportsto = supervisor.employeenumber;
SELECT MAX(quantityordered * priceeach) AS highest_order_amount, products.productname AS product_name FROM orders JOIN customers ON orders.customernumber = customers.customernumber JOIN employees ON customers.salesrepemployeenumber = employees.employeenumber JOIN offices ON employees.officecode = offices.officecode JOIN orderdetails ON orders.ordernumber = orderdetails.ordernumber JOIN products ON orderdetails.productcode = products.productcode WHERE offices.city = 'Boston';
SELECT SUM((od.priceeach - p.buyprice) * od.quantityordered) AS total_profit FROM     orders o JOIN     customers c ON o.customernumber = c.customernumber JOIN     orderdetails od ON o.ordernumber = od.ordernumber JOIN     products p ON od.productcode = p.productcode WHERE     c.country = 'USA'     AND o.orderdate BETWEEN '2003-01-06' AND '2005-05-09';
SELECT offices.addressline1 || ', ' || offices.addressline2 || ', ' || offices.city || ', ' || offices.state || ', ' || offices.country || ', ' || offices.postalcode || ', ' || offices.phone AS branch_address_phone FROM employees JOIN customers ON employees.employeenumber = customers.salesrepemployeenumber JOIN orders ON customers.customernumber = orders.customernumber JOIN offices ON employees.officecode = offices.officecode WHERE orders.orderdate BETWEEN '2005-01-01' AND '2005-12-31' GROUP BY employees.employeenumber ORDER BY SUM(orders.quantityordered * orderdetails.priceeach) DESC LIMIT 1;
SELECT officecode, phone FROM offices JOIN customers ON offices.officecode = customers.officecode WHERE contactlastname LIKE 'M%' AND country <> 'Germany';
SELECT AVG(amount)  FROM      payments  WHERE      paymentdate >= '2004-01-01' AND paymentdate < '2004-07-01';
SELECT DIVIDE(     (SELECT COUNT(*) FROM orders WHERE status = 'Shipped' AND strftime('%Y', shippeddate) = '2005' AND customernumber = 186),     (SELECT COUNT(*) FROM orders WHERE status = 'Shipped' AND strftime('%Y', shippeddate) = '2005') ) AS percentage; 
SELECT COUNT(DISTINCT customers.customernumber) FROM     customers JOIN     orders ON customers.customernumber = orders.customernumber WHERE     orders.status = 'cancelled'     AND customers.creditlimit > 115000;
SELECT MIN(paymentdate) AS payment_date FROM payments JOIN customers ON payments.customernumber = customers.customernumber JOIN employees ON customers.salesrepemployeenumber = employees.employeenumber WHERE employees.lastname = 'Jones' AND employees.firstname = 'Barry' ORDER BY creditlimit ASC LIMIT 1;
SELECT employees.firstname, employees.lastname FROM     employees JOIN     customers ON employees.employeenumber = customers.salesrepemployeenumber JOIN     offices ON employees.officecode = offices.officecode WHERE     customers.country = 'France';
SELECT customers.addressline1 || ' ' || customers.addressline2 AS full_address FROM customers JOIN orders ON customers.customernumber = orders.customernumber WHERE orders.shippeddate = '2005-04-04' AND orders.comments LIKE '%DHL%'
SELECT offices.addressline1 || ', ' || offices.addressline2 AS full_address FROM offices JOIN employees ON offices.officecode = employees.officecode JOIN customers ON employees.employeenumber = customers.salesrepemployeenumber WHERE customers.city = 'New York' OR customers.city = 'NYC' AND employees.jobtitle = 'Sales Representative';
SELECT offices.addressline1 || ', ' || offices.addressline2 AS full_address FROM employees JOIN offices ON employees.officecode = offices.officecode WHERE employees.jobtitle = 'Sales Manager' GROUP BY employees.officecode HAVING COUNT(*) = 4;
SELECT SUM(products.msrp - products.buyprice) AS profit FROM     products JOIN     productlines ON products.productline = productlines.productline WHERE     productlines.textdescription = 'The perfect holiday or anniversary gift for executives' AND     products.productvendor = 'Carousel DieCast Legends';
SELECT MAX(customername) AS customer_with_highest_avg_payment FROM (     SELECT        c.customername,         AVG(p.amount) AS avg_payment     FROM         customers c     JOIN         payments p ON c.customernumber = p.customernumber     WHERE         c.city = 'Boston'     GROUP BY         c.customernumber ) subquery;
SELECT SUM(orderdetails.quantityordered) AS total_quantity_ordered, AVG(orderdetails.priceeach) AS average_price FROM orderdetails JOIN products ON orderdetails.productcode = products.productcode WHERE products.productname = '18th Century Vintage Horse Carriage';
SELECT COUNT(DISTINCT products.productcode) AS num_products FROM     orderdetails JOIN     orders ON orderdetails.ordernumber = orders.ordernumber JOIN     products ON orderdetails.productcode = products.productcode WHERE     orders.ordernumber = 10252;
SELECT employees.firstname, employees.lastname FROM employees JOIN customers ON customers.salesrepemployeenumber = employees.employeenumber JOIN orders ON orders.customernumber = customers.customernumber WHERE orders.shippeddate IS NOT NULL AND customers.addressline1 = '25 Maiden Lane' AND customers.addressline2 = 'Floor No. 4';
SELECT offices.addressline1, offices.addressline2, offices.city, offices.state, offices.country, offices.postalcode FROM employees JOIN offices ON employees.officecode = offices.officecode WHERE employees.firstname = 'Foon' AND employees.lastname = 'Yue' AND employees.firstname = 'Tseng';
SELECT MAX(order_value) AS highest_order_value FROM (     SELECT        orderdate,         SUM(quantityordered * priceeach) AS order_value     FROM         orders     INNER JOIN         orderdetails ON orders.ordernumber = orderdetails.ordernumber     WHERE         orderdate IN ('2005-04-08', '2005-04-10')     GROUP BY         orderdate );
SELECT COUNT(*) AS total_products FROM     (     SELECT        productcode,         (msrp - buyprice) AS expected_profit     FROM         products     ORDER BY         expected_profit DESC     LIMIT 1     ) AS max_profit_product;
SELECT SUM(amount) AS total_payment FROM payments JOIN customers ON payments.customernumber = customers.customernumber WHERE customers.customername = 'Petit Auto' AND paymentdate = '2004-08-09';
SELECT customers.contactlastname, customers.contactfirstname FROM payments JOIN customers ON payments.customernumber = customers.customernumber WHERE payments.checknumber = 'NR157385';
SELECT customers.contactlastname, customers.contactfirstname FROM orders JOIN customers ON orders.customernumber = customers.customernumber WHERE orders.ordernumber = 10160;
SELECT customers.addressline1, customers.addressline2, customers.city, customers.state, customers.country, customers.postalcode FROM orders INNER JOIN customers ON orders.customernumber = customers.customernumber WHERE orders.ordernumber = 10383;
SELECT pl.textdescription FROM products p JOIN productlines pl ON p.productline = pl.productline WHERE p.productcode = 'S18_2949'; 
SELECT employees.email FROM employees JOIN customers ON employees.employeenumber = customers.salesrepemployeenumber WHERE customers.customername = 'Dragon Souveniers, Ltd.';
SELECT COUNT(DISTINCT customers.customernumber) FROM     employees JOIN     customers ON employees.employeenumber = customers.salesrepemployeenumber WHERE     employees.lastname = 'Hernandez'     AND employees.firstname = 'Gerard'     AND customers.country = 'France';
SELECT products.productname FROM orders JOIN orderdetails ON orders.ordernumber = orderdetails.ordernumber JOIN products ON orderdetails.productcode = products.productcode WHERE orders.customernumber = 114 ORDER BY orders.orderdate DESC LIMIT 1;
SELECT (SUBTRACT(products.msrp, orderdetails.priceeach) / products.msrp) AS discount FROM     orders JOIN     orderdetails ON orders.ordernumber = orderdetails.ordernumber JOIN     products ON orderdetails.productcode = products.productcode WHERE     orders.ordernumber = 10108     AND products.productcode = 'S18_3482';
SELECT CONCAT(e2.firstname, ' ', e2.lastname) AS supervisor_name FROM employees AS e1 JOIN employees AS e2 ON e1.reportsto = e2.employeenumber WHERE e1.firstname = 'Steve' AND e1.lastname = 'Patterson'; 
SELECT firstname, lastname, phone, email FROM employees WHERE jobtitle = 'President';
SELECT employees.firstname || ' ' || employees.lastname AS "Sales Representative" FROM employees JOIN customers ON customers.salesrepemployeenumber = employees.employeenumber WHERE customers.customername = 'Muscle Machine Inc';
SELECT employees.email FROM     employees JOIN     customers ON employees.employeenumber = customers.salesrepemployeenumber JOIN     offices ON employees.officecode = offices.officecode WHERE     customers.customername = 'Muscle Machine Inc';
SELECT customers.customername FROM customers JOIN employees ON customers.salesrepemployeenumber = employees.employeenumber WHERE employees.firstname = 'Steve' AND employees.lastname = 'Patterson';
SELECT COUNT(DISTINCT customers.customernumber) AS num_customers FROM     customers JOIN     employees ON customers.salesrepemployeenumber = employees.employeenumber JOIN     employees AS managers ON employees.reportsto = managers.employeenumber WHERE     managers.lastname = 'Patterson' AND managers.firstname = 'William';
SELECT c.phone FROM customers c JOIN employees e ON c.salesrepemployeenumber = e.employeenumber WHERE e.lastname = 'Jennings' ORDER BY c.creditlimit DESC LIMIT 3; 
SELECT COUNT(DISTINCT employees.employeenumber) FROM     employees JOIN     offices ON employees.officecode = offices.officecode WHERE     employees.jobtitle = 'Sales Rep'     AND offices.country = 'USA';
SELECT offices.addressline1, offices.addressline2, offices.city, offices.state, offices.country, offices.postalcode FROM offices JOIN employees ON offices.officecode = employees.officecode WHERE employees.jobtitle = 'President';
SELECT postalCode FROM offices JOIN employees ON offices.officeCode = employees.officeCode WHERE employees.jobTitle = 'VP Sales';
SELECT SUM(orderdetails.quantityordered * orderdetails.priceeach) AS total_price FROM orders JOIN customers ON orders.customernumber = customers.customernumber JOIN orderdetails ON orders.ordernumber = orderdetails.ordernumber WHERE orders.orderdate = '2003-03-03' AND customers.customername = 'Cruz & Sons Co.';
SELECT products.productname FROM orders JOIN customers ON orders.customernumber = customers.customernumber JOIN orderdetails ON orders.ordernumber = orderdetails.ordernumber JOIN products ON orderdetails.productcode = products.productcode WHERE customers.customername = 'Cruz & Sons Co.' AND orders.orderdate = '2003-03-03';
SELECT products.productname FROM     products JOIN     orderdetails ON products.productcode = orderdetails.productcode JOIN     orders ON orderdetails.ordernumber = orders.ordernumber JOIN     customers ON orders.customernumber = customers.customernumber WHERE     customers.customername = 'Cruz & Sons Co.' GROUP BY     products.productname ORDER BY     SUM(orderdetails.quantityordered) DESC LIMIT 1;
SELECT orders.shippeddate FROM orders JOIN customers ON orders.customernumber = customers.customernumber WHERE customers.customername = 'Cruz & Sons Co.' AND orders.orderdate = '2003-03-03';
SELECT COUNT(*) AS customer_count FROM orders JOIN customers ON orders.customernumber = customers.customernumber JOIN orderdetails ON orders.ordernumber = orderdetails.ordernumber JOIN products ON orderdetails.productcode = products.productcode WHERE products.productname = '1957 Chevy Pickup' AND strftime('%Y-%m', orders.orderdate) = 'YYYY-MM'
SELECT products.productname FROM products JOIN productlines ON products.productline = productlines.productline WHERE productlines.productline = 'Classic Cars' ORDER BY (products.msrp - products.buyprice) DESC LIMIT 1;
SELECT customers.customername FROM customers JOIN orders ON customers.customernumber = orders.customernumber WHERE orders.status = 'In Process';
SELECT (CAST(COUNT(CASE WHEN julianday(shippeddate) - julianday(requireddate) > 3 THEN ordernumber END) AS FLOAT) / COUNT(ordernumber)) * 100 AS percentage FROM orders WHERE status = 'Shipped';
SELECT customers.customername FROM payments JOIN customers ON payments.customernumber = customers.customernumber WHERE strftime('%Y', payments.paymentdate) = '2005' GROUP BY customers.customername ORDER BY SUM(payments.amount) DESC LIMIT 1;
SELECT productName, MAX(quantityOrdered) AS mostOrderedQuantity, (MSRP - buyPrice) AS expectedProfitMarginPerPiece FROM products JOIN orderdetails ON products.productCode = orderdetails.productCode GROUP BY productName;
SELECT customers.customername FROM orders JOIN orderdetails ON orders.ordernumber = orderdetails.ordernumber JOIN customers ON orders.customernumber = customers.customernumber GROUP BY orders.ordernumber ORDER BY SUM(orderdetails.quantityordered * orderdetails.priceeach) DESC LIMIT 1;
SELECT customers.customername FROM customers JOIN orders ON customers.customernumber = orders.customernumber WHERE orders.status = 'Disputed';
SELECT (CAST(COUNT(*) AS FLOAT) / (SELECT COUNT(*) FROM employees WHERE officecode IN (SELECT officecode FROM offices WHERE city = 'Paris'))) * 100 AS percentage FROM employees WHERE officecode IN (SELECT officecode FROM offices WHERE city = 'Paris');
SELECT employees.firstname, employees.lastname, offices.officecode, offices.city FROM employees JOIN offices ON employees.officecode = offices.officecode WHERE employees.jobtitle = 'Sales Manager' AND employees.territory = 'EMEA'; 
SELECT employees.firstname, employees.lastname, reports_to.firstname || ' ' || reports_to.lastname AS supervisor FROM employees JOIN offices ON employees.officecode = offices.officecode JOIN employees AS reports_to ON employees.reportsto = reports_to.employeenumber WHERE offices.country = 'Japan';
SELECT customers.customername FROM     customers JOIN     orders ON customers.customernumber = orders.customernumber JOIN     orderdetails ON orders.ordernumber = orderdetails.ordernumber JOIN     products ON orderdetails.productcode = products.productcode WHERE     products.productname = '1939 Chevrolet Deluxe Coupe' GROUP BY     customers.customername ORDER BY     MAX(orderdetails.priceeach) DESC LIMIT 1;
SELECT ROUND((SELECT SUM(p.amount)        FROM payments p        JOIN customers c ON p.customernumber = c.customernumber        WHERE c.customername = 'Atelier graphique'        AND strftime('%Y', p.paymentdate) = '2004')       /       (SELECT SUM(amount)        FROM payments        WHERE strftime('%Y', paymentdate) = '2004') * 100, 2) AS percentage; 
SELECT SUM(quantityOrdered * (priceEach - buyPrice)) AS actual_profit FROM     orderdetails WHERE     ordernumber = 10100;
SELECT SUM(amount) FROM     payments WHERE     customernumber = 103;
SELECT SUM(orderdetails.quantityordered * orderdetails.priceeach) AS total_price FROM     orders JOIN     orderdetails ON orders.ordernumber = orderdetails.ordernumber WHERE     orders.ordernumber = 10100;
SELECT productname FROM products ORDER BY priceeach DESC LIMIT 3; 
SELECT customers.contactfirstname || ' ' || customers.contactlastname AS contact_person_full_name FROM customers WHERE customers.salesrepemployeenumber = '1370' ORDER BY customers.creditlimit DESC LIMIT 1;
SELECT COUNT(quantityOrdered) FROM     orderdetails JOIN     products ON orderdetails.productcode = products.productcode WHERE     products.productname = '2003 Harley-Davidson Eagle Drag Bike';
SELECT MAX(orders.shippeddate)  FROM      orderdetails  JOIN      products ON orderdetails.productcode = products.productcode  WHERE      orderdetails.priceeach = (SELECT MAX(priceeach) FROM orderdetails)
SELECT COUNT(*) AS "Total Motorcycles Ordered in 2004" FROM     orders JOIN     orderdetails ON orders.ordernumber = orderdetails.ordernumber JOIN     products ON orderdetails.productcode = products.productcode JOIN     productlines ON products.productline = productlines.productline WHERE     productlines.productline = 'Motorcycles'     AND strftime('%Y', orders.orderdate) = '2004';
SELECT orders.ordernumber FROM customers JOIN orders ON customers.customernumber = orders.customernumber WHERE customers.creditlimit = 45300;
SELECT customers.customername, MAX((orderdetails.quantityordered * (orderdetails.priceeach - products.buyprice))) AS profit FROM orders JOIN customers ON orders.customernumber = customers.customernumber JOIN orderdetails ON orders.ordernumber = orderdetails.ordernumber JOIN products ON orderdetails.productcode = products.productcode GROUP BY orders.ordernumber ORDER BY profit DESC LIMIT 1;
SELECT YEAR(paymentDate) AS payment_year, COUNT(*) AS transaction_count FROM payments WHERE amount < 10000 GROUP BY payment_year;
SELECT productname,        SUM(quantityordered) AS total_quantity_sold FROM     orders JOIN     orderdetails ON orders.ordernumber = orderdetails.ordernumber JOIN     products ON orderdetails.productcode = products.productcode WHERE     strftime('%Y', orderdate) = '2003' GROUP BY     productname ORDER BY     total_quantity_sold DESC LIMIT 3;
SELECT employees.firstname, employees.lastname, SUM(orderdetails.quantityordered) AS total_quantity_sold FROM employees JOIN customers ON employees.employeenumber = customers.salesrepemployeenumber JOIN orders ON customers.customernumber = orders.customernumber JOIN orderdetails ON orders.ordernumber = orderdetails.ordernumber JOIN products ON orderdetails.productcode = products.productcode WHERE products.productname = '1969 Harley Davidson Ultimate Chopper' AND strftime('%Y', orders.orderdate) = '2003' GROUP BY employees.firstname, employees.lastname;
SELECT employees.firstname, employees.lastname FROM employees JOIN offices ON employees.officecode = offices.officecode WHERE employees.jobtitle = 'Sales Rep' AND offices.city = 'NYC';
SELECT customers.customername, customers.country FROM customers JOIN payments ON customers.customernumber = payments.customernumber WHERE payments.checknumber = 'GG31455'; 
SELECT COUNT(*) FROM     orderdetails JOIN     products ON orderdetails.productcode = products.productcode WHERE     products.productname = '2001 Ferrari Enzo';
SELECT productname FROM products LEFT JOIN orderdetails ON products.productcode = orderdetails.productcode GROUP BY products.productcode ORDER BY COUNT(orderdetails.productcode) LIMIT 5;
SELECT customername FROM customers INNER JOIN orders ON customers.customernumber = orders.customernumber WHERE orders.status = 'Disputed'; 
SELECT COUNT(DISTINCT customers.country) AS "Number of countries with 'USA' having 'In Process' order status" FROM customers JOIN orders ON customers.customernumber = orders.customernumber WHERE customers.country = 'USA' AND orders.status = 'In Process';
SELECT SUM(MULTIPLY(orderdetails.quantityordered, orderdetails.priceeach)) FROM     orders JOIN     customers ON orders.customernumber = customers.customernumber JOIN     orderdetails ON orders.ordernumber = orderdetails.ordernumber JOIN     products ON orderdetails.productcode = products.productcode WHERE     customers.customername = 'Land of Toys Inc'     AND products.productline = 'Classic Cars'     AND orders.status = 'Shipped';
SELECT COUNT(DISTINCT generalinfo.id_restaurant) FROM     generalinfo WHERE     generalinfo.review < 3;
SELECT food_type FROM generalinfo WHERE review = 4 LIMIT 4; 
SELECT COUNT(generalinfo.id_restaurant) FROM generalinfo JOIN geographic ON generalinfo.city = geographic.city WHERE generalinfo.food_type = 'mediterranean' AND geographic.city = 'Richmond';
SELECT geographic.city FROM geographic WHERE geographic.county = 'Sonoma'; 
SELECT geographic.county FROM geographic LEFT JOIN generalinfo ON generalinfo.city = geographic.city LEFT JOIN location ON location.city = geographic.city AND location.id_restaurant = generalinfo.id_restaurant WHERE geographic.region != 'Bay Area'
SELECT geographic.city FROM geographic WHERE geographic.region = 'Northern California'; 
SELECT generalinfo.id_restaurant FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant JOIN geographic ON generalinfo.city = geographic.city WHERE location.street_name = '11th street' AND geographic.city = 'oakland'; 
SELECT COUNT(generalinfo.id_restaurant) AS num_restaurants FROM     generalinfo JOIN     location ON generalinfo.id_restaurant = location.id_restaurant WHERE     location.street_num = 871;
SELECT location.street_num FROM location JOIN geographic ON location.city = geographic.city WHERE location.street_name = '9th avenue' AND geographic.city = 'san francisco';
SELECT generalinfo.food_type FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant JOIN geographic ON generalinfo.city = geographic.city WHERE location.street_name = 'adeline st' AND location.city = 'berkeley';
SELECT geographic.region FROM geographic WHERE geographic.city NOT IN (     SELECT    generalinfo.city     FROM     generalinfo     WHERE     generalinfo.food_type = 'african' );
SELECT geographic.county FROM geographic JOIN generalinfo ON geographic.city = generalinfo.city WHERE generalinfo.label = 'a & w root beer';
SELECT location.street_name, location.street_num FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant WHERE generalinfo.label = 'adelitas taqueria';
SELECT food_type FROM     generalinfo JOIN     location ON generalinfo.id_restaurant = location.id_restaurant JOIN     geographic ON generalinfo.city = geographic.city WHERE     location.street_num = 3140     AND location.street_name = 'Alpine Road'     AND geographic.county = 'San Mateo County';
SELECT location.street_name FROM location JOIN generalinfo ON location.id_restaurant = generalinfo.id_restaurant JOIN geographic ON generalinfo.city = geographic.city WHERE generalinfo.food_type = 'seafood' AND geographic.city = 'San Francisco';
SELECT DISTINCT geographic.county FROM geographic LEFT JOIN generalinfo ON generalinfo.city = geographic.city WHERE generalinfo.label <> 'Bakers Square Restaurant & Pie Shop' OR generalinfo.label IS NULL; 
SELECT COUNT(DISTINCT geographic.county) FROM geographic JOIN location ON geographic.city = location.city WHERE location.street_name = 'Appian Way';
SELECT review FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant JOIN geographic ON generalinfo.city = geographic.city WHERE location.street_name = 'atlantic ave';
SELECT generalinfo.id_restaurant FROM generalinfo JOIN geographic ON generalinfo.city = geographic.city WHERE geographic.county = 'Contra Costa'; 
SELECT generalinfo.label FROM generalinfo JOIN geographic ON generalinfo.city = geographic.city JOIN location ON location.id_restaurant = generalinfo.id_restaurant WHERE geographic.county = 'Yolo'; 
SELECT generalinfo.label FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant JOIN geographic ON generalinfo.city = geographic.city WHERE location.street_name = 'Drive Street' AND geographic.city = 'San Rafael' AND generalinfo.food_type <> 'American';
SELECT location.street_name FROM     location JOIN     generalinfo ON location.id_restaurant = generalinfo.id_restaurant JOIN     geographic ON location.city = geographic.city WHERE     geographic.city = 'San Francisco'     AND generalinfo.review = 1.7;
SELECT generalinfo.label FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant JOIN geographic ON generalinfo.city = geographic.city WHERE location.street_name = 'Alameda de las Pulgas' AND geographic.city = 'Menlo Park' AND generalinfo.review = (     SELECT MIN(review)     FROM generalinfo     JOIN location ON generalinfo.id_restaurant = location.id_restaurant     JOIN geographic ON generalinfo.city = geographic.city     WHERE location.street_name = 'Alameda de las Pulgas'     AND geographic.city = 'Menlo Park' )
SELECT location.street_name FROM location JOIN generalinfo ON location.id_restaurant = generalinfo.id_restaurant JOIN geographic ON generalinfo.city = geographic.city WHERE generalinfo.label = 'Good Heavens' AND geographic.county = 'Tuolumne';
SELECT location.street_num FROM location JOIN generalinfo ON location.id_restaurant = generalinfo.id_restaurant JOIN geographic ON generalinfo.city = geographic.city WHERE generalinfo.label = 'aux delices vietnamese restaurant';
SELECT generalinfo.id_restaurant FROM generalinfo JOIN geographic ON generalinfo.city = geographic.city WHERE geographic.county = 'Marin'; 
SELECT geographic.region FROM geographic WHERE geographic.city NOT IN (     SELECT    generalinfo.city     FROM     generalinfo     WHERE     generalinfo.food_type = 'pizza' )
SELECT AVG(review) FROM generalinfo JOIN geographic ON generalinfo.city = geographic.city WHERE county = 'Santa Cruz County';
SELECT (CAST(SUM(CASE WHEN food_type = 'mexican' THEN 1 ELSE 0 END) AS FLOAT) / COUNT(id_restaurant)) * 100 FROM generalinfo JOIN geographic ON generalinfo.city = geographic.city WHERE county = 'Monterey County';
SELECT ((COUNT(*) * 1.0) / (SELECT COUNT(*) FROM location WHERE city IN (SELECT city FROM geographic WHERE county = 'Alameda County'))) * 100 FROM location WHERE street_name = '11th st' AND city IN (SELECT city FROM geographic WHERE county = 'Alameda County');
SELECT generalinfo.label AS restaurant FROM generalinfo WHERE generalinfo.food_type = 'european'; 
SELECT geographic.city FROM geographic WHERE geographic.region = 'northern california';
SELECT generalinfo.label FROM generalinfo WHERE generalinfo.food_type = '24 hour diner'
SELECT geographic.city FROM geographic WHERE geographic.county = 'unknown' AND geographic.region = 'unknown' LIMIT 5; 
SELECT county, region FROM geographic WHERE city = 'Davis City'; 
SELECT DISTINCT street_name FROM location WHERE city = 'Clayton'; 
SELECT label FROM     generalinfo WHERE     city = 'San Francisco' ORDER BY     review DESC LIMIT 5; 
SELECT COUNT(*) FROM   generalinfo JOIN   location ON generalinfo.id_restaurant = location.id_restaurant JOIN   geographic ON generalinfo.city = geographic.city WHERE   generalinfo.food_type = 'american' AND   geographic.city = 'Carmel' AND   generalinfo.review = (     SELECT      MIN(review)     FROM       generalinfo     WHERE       food_type = 'american'     AND       geographic.city = 'Carmel'   );
SELECT COUNT(generalinfo.id_restaurant) * 100.0 / (SELECT COUNT(generalinfo.id_restaurant) FROM generalinfo INNER JOIN location ON generalinfo.id_restaurant = location.id_restaurant INNER JOIN geographic ON generalinfo.city = geographic.city WHERE generalinfo.food_type = 'american food' AND geographic.city = 'dublin') as percentage FROM generalinfo INNER JOIN location ON generalinfo.id_restaurant = location.id_restaurant INNER JOIN geographic ON generalinfo.city = geographic.city WHERE geographic.city = 'dublin';
SELECT location.street_num, location.street_name, location.city FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant WHERE generalinfo.label = 'Albert\'s Café';
SELECT generalinfo.label FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant JOIN geographic ON generalinfo.city = geographic.city WHERE location.street_name = '19th St' AND location.city = 'Oakland';
SELECT food_type FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant JOIN geographic ON location.city = geographic.city WHERE location.street_name = 'E 25th Ave';
SELECT label FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant JOIN geographic ON generalinfo.city = geographic.city WHERE region = 'unknown'; 
SELECT label FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant WHERE generalinfo.food_type = 'chinese' AND location.street_num = 104 AND location.street_name = 'San Tomas Aquino Road' AND location.city = 'Campbell';
SELECT COUNT(*) FROM     generalinfo AS G     JOIN location AS L ON G.id_restaurant = L.id_restaurant     JOIN geographic AS G2 ON G.city = G2.city WHERE     G.food_type = 'thai'     AND L.street_name = 'san pablo ave'     AND G2.city = 'albany';
SELECT geographic.county, geographic.region FROM geographic JOIN generalinfo ON generalinfo.city = geographic.city JOIN location ON location.id_restaurant = generalinfo.id_restaurant WHERE generalinfo.label = 'plearn-thai cuisine';
SELECT label FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant JOIN geographic ON generalinfo.city = geographic.city WHERE geographic.county = 'El Dorado' AND geographic.region = 'Lake Tahoe';
SELECT geographic.county, geographic.region FROM geographic JOIN location ON geographic.city = location.city WHERE location.street_name = 'E. El Camino Real';
SELECT MIN(review) AS least_popular, label AS restaurant_name FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant JOIN geographic ON generalinfo.city = geographic.city WHERE food_type = 'Indian restaurant' AND street_name = 'Shattuck Ave' AND city = 'Berkeley';
SELECT 100 * (     SELECT COUNT(g.id_restaurant)     FROM generalinfo AS g     JOIN geographic AS geo ON g.city = geo.city     WHERE geo.region = 'Bay Area' AND g.review > 4 ) / (     SELECT COUNT(g.id_restaurant)     FROM generalinfo AS g     JOIN geographic AS geo ON g.city = geo.city     WHERE geo.region = 'Bay Area' );
SELECT geographic.city FROM geographic WHERE geographic.county = 'San Mateo'; 
SELECT COUNT(DISTINCT generalinfo.id_restaurant) FROM     generalinfo WHERE     generalinfo.review > 4;
SELECT MAX(street_name) AS street_with_most_restaurants FROM     location GROUP BY     street_name ORDER BY     COUNT(id_restaurant) DESC LIMIT 1;
SELECT MAX(generalinfo.review) AS highest_review, generalinfo.label AS chicken_restaurant FROM generalinfo WHERE generalinfo.food_type = 'chicken';
SELECT geographic.county FROM geographic JOIN generalinfo ON generalinfo.city = geographic.city WHERE generalinfo.label = 'El Cerrito';
SELECT COUNT(*) FROM     location WHERE     street_name = 'irving';
SELECT generalinfo.label FROM generalinfo JOIN geographic ON generalinfo.city = geographic.city WHERE geographic.county = 'Marin';
SELECT location.street_num, location.street_name FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant WHERE generalinfo.label = 'Peking Duck restaurant';
SELECT location.street_name FROM location JOIN generalinfo ON location.id_restaurant = generalinfo.id_restaurant JOIN geographic ON generalinfo.city = geographic.city WHERE geographic.county = 'Alameda' GROUP BY location.street_name HAVING COUNT(location.id_restaurant) > 10;
SELECT geographic.region FROM geographic JOIN generalinfo ON geographic.city = generalinfo.city WHERE generalinfo.food_type = 'greek';
SELECT location.street_num, location.street_name FROM location JOIN generalinfo ON location.id_restaurant = generalinfo.id_restaurant JOIN geographic ON generalinfo.city = geographic.city WHERE geographic.region = 'unknown';
SELECT review FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant WHERE location.street_num = 8440 AND location.street_name = 'Murray Ave';
SELECT MAX(food_type) AS most_common_type FROM   generalinfo JOIN   geographic ON generalinfo.city = geographic.city WHERE   county = 'Monterey';
SELECT MAX(street_name) AS most_burger_street FROM     location JOIN     generalinfo ON location.id_restaurant = generalinfo.id_restaurant JOIN     geographic ON location.city = geographic.city WHERE     generalinfo.food_type = 'burgers'     AND geographic.city = 'san francisco' GROUP BY     location.street_name ORDER BY     COUNT(*) DESC LIMIT 1;
SELECT geographic.region FROM geographic JOIN location ON location.city = geographic.city WHERE location.street_num = 1149 AND location.street_name = 'El Camino Real';
SELECT geographic.county FROM geographic JOIN generalinfo ON generalinfo.city = geographic.city WHERE generalinfo.label = 'sankee';
SELECT COUNT(DISTINCT location.street_name) FROM     location JOIN     generalinfo ON location.id_restaurant = generalinfo.id_restaurant JOIN     geographic ON location.city = geographic.city WHERE     geographic.region = 'Northern California';
SELECT generalinfo.label FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant WHERE location.street_name = 'Park St'; 
SELECT 100 * COUNT(DISTINCT generalinfo.id_restaurant) / COUNT(DISTINCT location.id_restaurant) FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant JOIN geographic ON generalinfo.city = geographic.city WHERE geographic.region = 'bay area';
SELECT AVG(generalinfo.review) AS average_review, geographic.county FROM generalinfo INNER JOIN geographic ON generalinfo.city = geographic.city WHERE generalinfo.food_type = 'chinese' GROUP BY geographic.county ORDER BY average_review DESC;
SELECT street_name FROM location WHERE city = 'San Francisco'; 
SELECT generalinfo.id_restaurant FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant JOIN geographic ON generalinfo.city = geographic.city WHERE geographic.city = 'Danville'; 
SELECT COUNT(DISTINCT geographic.city) FROM geographic WHERE region = 'bay area';
SELECT COUNT(DISTINCT generalinfo.label) FROM     generalinfo JOIN     geographic ON generalinfo.city = geographic.city WHERE     geographic.county = 'unknown';
SELECT DISTINCT location.street_name FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant WHERE generalinfo.food_type = 'American'; 
SELECT label FROM generalinfo JOIN geographic ON generalinfo.city = geographic.city WHERE geographic.county = 'Santa Cruz county';
SELECT review FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant WHERE location.street_num = 430 AND location.street_name = 'Broadway';
SELECT location.street_num, location.street_name FROM     location JOIN     generalinfo ON location.id_restaurant = generalinfo.id_restaurant JOIN     geographic ON location.city = geographic.city WHERE     generalinfo.review = (         SELECT MAX(review) FROM generalinfo     );
SELECT COUNT(*) AS num_restaurants, geographic.region AS country FROM generalinfo JOIN geographic ON generalinfo.city = geographic.city WHERE generalinfo.food_type = 'Italian' GROUP BY geographic.region ORDER BY num_restaurants DESC LIMIT 1;
SELECT 100 * (SELECT COUNT(id_restaurant) FROM generalinfo WHERE city IN (SELECT city FROM geographic WHERE region = 'Napa Valley')) / (SELECT COUNT(id_restaurant) FROM generalinfo);
SELECT COUNT(DISTINCT geographic.city) FROM geographic WHERE region = 'bay area';
SELECT DISTINCT geographic.city FROM geographic WHERE geographic.county = 'unknown'; 
SELECT geographic.city FROM geographic WHERE geographic.region = 'bay area' AND geographic.county = 'santa clara county';
SELECT generalinfo.id_restaurant FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant JOIN geographic ON generalinfo.city = geographic.city WHERE geographic.city = 'sunnyvale'; 
SELECT COUNT(*) FROM     location WHERE     street_num < 1000     AND street_name = 'Railroad St.';
SELECT label FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant JOIN geographic ON generalinfo.city = geographic.city WHERE generalinfo.food_type = '24 hour diner' AND geographic.city = 'san francisco';
SELECT review FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant JOIN geographic ON generalinfo.city = geographic.city WHERE location.street_name = 'ocean st' AND geographic.city = 'santa cruz';
SELECT location.street_num FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant JOIN geographic ON generalinfo.city = geographic.city WHERE generalinfo.food_type = 'bar' AND generalinfo.review = 2.7 AND geographic.city = 'oakland';
SELECT COUNT(*) AS total_bakeries_at_university_ave_palo_alto FROM   generalinfo JOIN   location ON generalinfo.id_restaurant = location.id_restaurant JOIN   geographic ON generalinfo.city = geographic.city WHERE   generalinfo.food_type = 'bakery'   AND location.street_name = 'university ave.'   AND geographic.city = 'palo alto';
SELECT location.street_num FROM location JOIN generalinfo ON location.id_restaurant = generalinfo.id_restaurant WHERE generalinfo.food_type = 'winery' AND generalinfo.label = 'Tulocay Winery';
SELECT review, label FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant WHERE location.street_name = 'Mission Blvd.' AND location.city = 'Hayward';
SELECT COUNT(*) FROM generalinfo JOIN geographic ON generalinfo.city = geographic.city JOIN location ON location.id_restaurant = generalinfo.id_restaurant WHERE generalinfo.food_type = 'indian' AND location.street_name = 'castro st' AND geographic.city = 'mountainview' AND generalinfo.label LIKE '%cookhouse%';
SELECT COUNT(DISTINCT generalinfo.id_restaurant) FROM     generalinfo JOIN     location ON generalinfo.id_restaurant = location.id_restaurant JOIN     geographic ON generalinfo.city = geographic.city WHERE     generalinfo.review = 2 AND     location.street_num < 500;
SELECT COUNT(DISTINCT generalinfo.id_restaurant) FROM     generalinfo JOIN     location ON generalinfo.id_restaurant = location.id_restaurant JOIN     geographic ON generalinfo.city = geographic.city WHERE     generalinfo.food_type = 'asian'     AND location.street_name = 'n milpitas blvd'     AND geographic.city = 'milpitas'     AND generalinfo.id_restaurant > 385;
SELECT generalinfo.id_restaurant, generalinfo.label FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant JOIN geographic ON generalinfo.city = geographic.city WHERE location.street_name = 'Ocean Avenue' AND geographic.city = 'San Francisco';
SELECT geographic.city, location.street_num, location.street_name FROM geographic JOIN generalinfo ON geographic.city = generalinfo.city JOIN location ON location.id_restaurant = generalinfo.id_restaurant WHERE generalinfo.label = 'Sanuki Restaurant';
SELECT food_type FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant WHERE location.street_num = 22779 AND location.street_name = '6th St' AND location.city = 'Hayward City';
SELECT COUNT(*) FROM     generalinfo JOIN     location ON generalinfo.id_restaurant = location.id_restaurant JOIN     geographic ON generalinfo.city = geographic.city WHERE     generalinfo.food_type = 'american'     AND location.street_name = 'front'     AND geographic.city = 'san francisco';
SELECT DISTINCT generalinfo.id_restaurant FROM     generalinfo JOIN     location ON generalinfo.id_restaurant = location.id_restaurant JOIN     geographic ON generalinfo.city = geographic.city WHERE     generalinfo.food_type = 'american'     AND location.street_num > 2000     AND generalinfo.review > (         SELECT            AVG(review) * 0.7         FROM             generalinfo         WHERE             generalinfo.food_type = 'american'     );
SELECT (100.0 * (     SELECT COUNT(generalinfo.id_restaurant)     FROM generalinfo     JOIN location ON generalinfo.id_restaurant = location.id_restaurant     WHERE generalinfo.food_type = 'afghani'     AND CAST(location.street_num AS INTEGER) >= 1000     AND CAST(location.street_num AS INTEGER) <= 2000   ) / (     SELECT COUNT(generalinfo.id_restaurant)     FROM generalinfo     JOIN location ON generalinfo.id_restaurant = location.id_restaurant     WHERE CAST(location.street_num AS INTEGER) >= 1000     AND CAST(location.street_num AS INTEGER) <= 2000   )) as percentage_of_afghani_restaurants
SELECT MAX(review) AS max_review FROM   generalinfo WHERE   food_type = 'asian'   AND city = 'san francisco';
SELECT COUNT(DISTINCT geographic.city) AS num_cities FROM geographic WHERE region = 'monterey';
SELECT COUNT(*) FROM generalinfo JOIN geographic ON generalinfo.city = geographic.city JOIN location ON location.id_restaurant = generalinfo.id_restaurant AND location.city = geographic.city WHERE generalinfo.food_type = 'deli' AND geographic.city = 'Belmont' AND generalinfo.review >= 2;
SELECT geographic.county FROM geographic WHERE geographic.region = 'northern california' GROUP BY geographic.county ORDER BY COUNT(geographic.city) DESC LIMIT 1;
SELECT COUNT(DISTINCT generalinfo.id_restaurant) FROM generalinfo JOIN location ON generalinfo.id_restaurant = location.id_restaurant JOIN geographic ON generalinfo.city = geographic.city WHERE geographic.city = 'Concord';
SELECT geographic.region FROM geographic JOIN generalinfo ON geographic.city = generalinfo.city ORDER BY generalinfo.review DESC LIMIT 4;
SELECT COUNT(*) FROM     generalinfo JOIN     location ON generalinfo.id_restaurant = location.id_restaurant WHERE     generalinfo.food_type = 'chinese'     AND location.street_name = '1st st'     AND generalinfo.city = 'livermore';
SELECT COUNT(*) FROM     generalinfo JOIN     geographic ON generalinfo.city = geographic.city WHERE     generalinfo.food_type = 'indian'     AND geographic.region = 'los angeles area';
SELECT food_type FROM generalinfo JOIN geographic ON generalinfo.city = geographic.city WHERE geographic.region = 'bay area' GROUP BY food_type ORDER BY COUNT(food_type) DESC LIMIT 1;
SELECT COUNT(*) FROM     generalinfo JOIN     location ON generalinfo.id_restaurant = location.id_restaurant JOIN     geographic ON generalinfo.city = geographic.city WHERE     location.street_name = 'broadway'     AND geographic.city = 'oakland'     AND generalinfo.review <= 3;
SELECT geographic.region FROM geographic JOIN generalinfo ON geographic.city = generalinfo.city JOIN location ON generalinfo.id_restaurant = location.id_restaurant WHERE generalinfo.label = 'baskin robbins' GROUP BY geographic.region ORDER BY COUNT(location.city) DESC LIMIT 1;
SELECT location.street_name FROM location JOIN generalinfo ON location.id_restaurant = generalinfo.id_restaurant JOIN geographic ON generalinfo.city = geographic.city WHERE generalinfo.food_type = 'pizza' AND geographic.city = 'san jose';
SELECT COUNT(DISTINCT generalinfo.food_type) FROM generalinfo JOIN geographic ON generalinfo.city = geographic.city WHERE geographic.region IN ('Yosemite', 'Mono Lake');
SELECT location.street_num, location.street_name, location.city FROM location JOIN generalinfo ON location.id_restaurant = generalinfo.id_restaurant WHERE generalinfo.review = (     SELECT MAX(review)     FROM generalinfo )
SELECT geographic.county FROM geographic JOIN generalinfo ON geographic.city = generalinfo.city JOIN location ON generalinfo.id_restaurant = location.id_restaurant GROUP BY geographic.county ORDER BY COUNT(DISTINCT generalinfo.label) DESC LIMIT 1;
SELECT geographic.region, COUNT(generalinfo.id_restaurant) AS num_restaurants FROM geographic JOIN generalinfo ON geographic.city = generalinfo.city GROUP BY geographic.region ORDER BY num_restaurants DESC LIMIT 1;
SELECT location.street_num || ' ' || location.street_name || ', ' || location.city AS full_address FROM generalinfo JOIN geographic ON generalinfo.city = geographic.city JOIN location ON location.id_restaurant = generalinfo.id_restaurant WHERE generalinfo.food_type = 'american' AND generalinfo.review > 4
SELECT COUNT(*) FROM player WHERE SUBSTR(dob, 1, 4) > 1985;
SELECT COUNT(*) FROM match WHERE SUBSTR(Match_Date, 1, 4) = '2008' AND SUBSTR(Match_Date, 6, 2) = '05';
SELECT COUNT(*)  FROM match  WHERE man_of_the_match = 41;
SELECT match.match_id FROM match WHERE SUBSTR(match.match_date, 1, 4) = '2008';
SELECT COUNT(*) FROM player WHERE country_name = 'Australia';
SELECT country.country_name FROM player JOIN country ON player.country_name = country.country_id WHERE player.dob = (SELECT MIN(dob) FROM player)
SELECT bowling_style.bowling_skill FROM player INNER JOIN bowling_style ON player.bowling_skill = bowling_style.bowling_id WHERE player.player_name = 'SC Ganguly';
SELECT COUNT(player.player_id) FROM player WHERE player.batting_hand = (SELECT batting_id FROM batting_style WHERE batting_hand = 'Right-hand bat') AND SUBSTR(player.dob, 1, 4) > 1985;
SELECT player.player_name FROM player JOIN country ON player.country_name = country.country_id JOIN batting_style ON player.batting_hand = batting_style.batting_id WHERE country.country_name = 'Australia' AND batting_style.batting_hand = 'Right-hand bat';
SELECT bowling_style.bowling_skill FROM player JOIN bowling_style ON player.bowling_skill = bowling_style.bowling_id JOIN country ON player.country_name = country.country_id WHERE country.country_name = 'Australia';
SELECT MIN(dob) AS oldest_birth_date FROM player WHERE bowling_skill = (     SELECT bowling_id     FROM bowling_style     WHERE bowling_skill = 'Legbreak' )
SELECT MAX(COUNT(bowling_skill)) AS most_used_bowling_skill FROM player GROUP BY bowling_skill;
SELECT player.player_name FROM     player INNER JOIN     match ON match.man_of_the_match = player.player_id WHERE     match.match_date = '2008-04-18';
SELECT COUNT(*) AS times_played_as_captain FROM player_match JOIN player ON player_match.player_id = player.player_id JOIN team ON player_match.team_id = team.team_id JOIN rolee ON player_match.role_id = rolee.role_id WHERE player.player_name = 'SC Ganguly' AND rolee.role_desc = 'Captain';
SELECT role_desc FROM player_match JOIN player ON player_match.player_id = player.player_id JOIN match ON player_match.match_id = match.match_id JOIN rolee ON player_match.role_id = rolee.role_id WHERE player.player_name = 'SC Ganguly' AND match.match_date = '2008-04-18';
SELECT MAX(match.win_margin) FROM match JOIN player_match ON match.match_id = player_match.match_id JOIN player ON player_match.player_id = player.player_id WHERE player.player_name = 'SC Ganguly';
SELECT AVG(win_margin) AS average_winning_margin FROM match WHERE match_winner = (     SELECT team_id     FROM team     WHERE team_name = (         SELECT team_name         FROM player         WHERE player_name = 'SC Ganguly'     ) );
SELECT ((COUNT(player.player_id) FILTER (WHERE SUBSTR(player.dob, 1, 4) > 1985 AND batting_style.batting_hand = 'Right-hand bat')) * 100.0) / COUNT(player.player_id) as percentage_right_hand_batsmen FROM player JOIN batting_style ON player.batting_hand = batting_style.batting_id;
SELECT player_name FROM player ORDER BY dob DESC LIMIT 1;
SELECT COUNT(*)  FROM match  WHERE toss_winner = (     SELECT team_id      FROM team      WHERE team_name = 'Sunrisers Hyderabad' );
SELECT player.player_name FROM     ball_by_ball JOIN player ON ball_by_ball.striker = player.player_id WHERE     ball_by_ball.match_id = 419169     AND ball_by_ball.over_id = 3     AND ball_by_ball.ball_id = 2     AND ball_by_ball.innings_no = 2;
SELECT venue.venue_name FROM match JOIN venue ON match.venue_id = venue.venue_id WHERE match.win_margin = 138;
SELECT player.player_name AS man_of_the_match FROM   match JOIN   player ON match.man_of_the_match = player.player_id WHERE   match.match_date = '2008-05-12';
SELECT player.player_name FROM player_match INNER JOIN player ON player_match.player_id = player.player_id INNER JOIN rolee ON player_match.role_id = rolee.role_id WHERE player_match.match_id = '419117' AND rolee.role_desc = 'CaptainKeeper';
SELECT player.player_name FROM     player JOIN     match ON match.man_of_the_series = player.player_id JOIN     season ON match.season_id = season.season_id WHERE     season.season_year = 2013;
SELECT player.dob FROM player JOIN player_match ON player.player_id = player_match.player_id JOIN season ON player_match.season_id = season.season_id WHERE season.season_year = 2014 AND season.orange_cap IS NOT NULL; 
SELECT country.country_name FROM     player JOIN     country ON player.country_name = country.country_id JOIN     season ON season.purple_cap IS NOT NULL WHERE     season.season_id = 7
SELECT country.country_name FROM city JOIN country ON city.country_id = country.country_id WHERE city.city_name = 'Ranchi';
SELECT COUNT(DISTINCT city.city_id) FROM     city JOIN     country ON city.country_id = country.country_id WHERE     country.country_name = 'India';
SELECT city.city_name FROM     city JOIN     venue ON city.city_id = venue.city_id GROUP BY     city.city_name ORDER BY     COUNT(venue.venue_id) DESC LIMIT 1;
SELECT batting_style.batting_hand FROM player JOIN batting_style ON player.batting_hand = batting_style.batting_id WHERE player.player_name = 'MK Pandey';
SELECT COUNT(CASE WHEN country_name = 'India' THEN city_id END) / COUNT(CASE WHEN country_name = 'South Africa' THEN city_id END) AS city_ratio FROM city JOIN country ON city.country_id = country.country_id;
SELECT COUNT(match_id) / (SELECT COUNT(match_id) FROM match WHERE venue_id = (SELECT venue_id FROM venue WHERE venue_name = 'Maharashtra Cricket Association Stadium')) AS stadium_frequency_ratio FROM match WHERE venue_id = (SELECT venue_id FROM venue WHERE venue_name = 'M Chinnaswamy Stadium');
SELECT player_name FROM player ORDER BY dob ASC LIMIT 1;
SELECT COUNT(*) AS matches_played FROM match WHERE SUBSTR(match_date, 1, 4) = '2008' AND SUBSTR(match_date, 6, 2) = '05';
SELECT COUNT(*) FROM player WHERE dob BETWEEN '1990-01-01' AND '1999-12-31';
SELECT COUNT(*) AS total_matches FROM     match WHERE     (team_1 = 10 OR team_2 = 10)     AND SUBSTR(match_date, 1, 4) = '2012';
SELECT player.player_id FROM     season JOIN match ON season.season_id = match.season_id JOIN player ON match.man_of_the_series = player.player_id WHERE     player.orange_cap = 1 GROUP BY     player.player_id HAVING     COUNT(DISTINCT season.season_year) > 1;
SELECT COUNT(match_id) FROM match WHERE season_id = 7;
SELECT COUNT(*) FROM umpire WHERE umpire_country = (     SELECT country_id     FROM country     WHERE country_name = 'South Africa' );
SELECT MAX(COUNT(player.player_name)) AS player_name FROM player JOIN match ON match.man_of_the_match = player.player_id GROUP BY player.player_id ORDER BY COUNT(player.player_name) DESC LIMIT 1;
SELECT country_name FROM player GROUP BY country_name ORDER BY COUNT(*) DESC LIMIT 1;
SELECT COUNT(season.orange_cap) FROM season WHERE season.orange_cap = (SELECT player_id FROM player WHERE player_name = 'CH Gayle');
SELECT season.season_id FROM match JOIN venue ON match.venue_id = venue.venue_id WHERE venue.venue_name = 'M Chinnaswamy Stadium' GROUP BY match.season_id ORDER BY COUNT(*) DESC LIMIT 1;
SELECT Team.Team_Name FROM   Team JOIN   Match ON Team.Team_Id = Match.Match_Winner WHERE   Match.Season_Id = 1 GROUP BY   Match.Match_Winner ORDER BY   COUNT(Match.Match_Winner) DESC LIMIT 1;
SELECT venue.venue_name FROM     match JOIN     team ON match.team_1 = team.team_id JOIN     venue ON match.venue_id = venue.venue_id WHERE     team.team_name = 'Kolkata Knight Riders' GROUP BY     match.venue_id ORDER BY     COUNT(match.venue_id) DESC LIMIT 1;
SELECT MAX(team_losses) FROM (     SELECT         Team_Id,         SUM(CASE WHEN Team_Id = Team_1 AND Team_Id <> Match_Winner THEN 1 ELSE 0 END)          + SUM(CASE WHEN Team_Id = Team_2 AND Team_Id <> Match_Winner THEN 1 ELSE 0 END) AS team_losses     FROM match     GROUP BY Team_Id ) AS team_loss_counts;
SELECT player.player_name FROM match JOIN player ON match.man_of_the_match = player.player_id WHERE match.match_date = (SELECT MIN(match_date) FROM match)
SELECT MIN(match_date) FROM match JOIN team ON match.team_1 = team.team_id WHERE team_name = 'Chennai Super Kings';
SELECT COUNT(player.player_id) FROM player JOIN batting_style ON player.batting_hand = batting_style.batting_id JOIN country ON player.country_name = country.country_id WHERE batting_style.batting_hand = 'Left-hand bat' AND country.country_name = 'India';
SELECT player.player_name FROM player JOIN player_match ON player.player_id = player_match.player_id JOIN team ON player_match.team_id = team.team_id JOIN rolee ON player_match.role_id = rolee.role_id WHERE team.team_name = 'Deccan Chargers' AND rolee.role_desc = 'Captain' GROUP BY player.player_name ORDER BY COUNT(player_match.role_id) DESC LIMIT 1;
SELECT 100 * COUNT(player.player_id) / (SELECT COUNT(*) FROM player) FROM player WHERE player.batting_hand = 'Right-hand bat';
SELECT player_name FROM player WHERE dob = '1981-07-07';
SELECT COUNT(*) AS matches_played FROM player_match WHERE player_id = 2;
SELECT team.team_name FROM match JOIN team ON match.team_1 = team.team_id WHERE match.win_margin = (     SELECT MAX(win_margin)     FROM match );
SELECT country.country_name FROM venue INNER JOIN city ON venue.city_id = city.city_id INNER JOIN country ON city.country_id = country.country_id WHERE venue.venue_name = 'St George''s Park';
SELECT player.player_name FROM player JOIN team ON player.country_name = team.team_id JOIN match ON team.team_id = match.team_1 OR team.team_id = match.team_2 WHERE team.team_name = 'Mumbai Indians' AND match.match_id = 335990;
SELECT team.team_name FROM     match JOIN     team ON match.match_winner = team.team_id WHERE     match.match_date = '2009-05-07'     AND match.win_margin = 7;
SELECT COUNT(*) FROM     match WHERE     outcome_type = (SELECT outcome_id FROM outcome WHERE outcome_type = 'Superover');
SELECT city.city_name FROM city INNER JOIN country ON city.country_id = country.country_id WHERE country.country_name = 'U.A.E';
SELECT COUNT(*) AS total_wins FROM match JOIN team ON match.match_winner = team.team_id WHERE team.team_name = 'Pune Warriors';
SELECT team.team_name FROM match INNER JOIN team ON match.match_winner = team.team_id WHERE match.match_id = 829768 AND match.match_date LIKE '2015%'
SELECT role_desc FROM player_match JOIN player ON player_match.player_id = player.player_id JOIN rolee ON player_match.role_id = rolee.role_id WHERE player.player_name = 'K Goel' AND player_match.match_id = 335992;
SELECT COUNT(DISTINCT city.city_id) FROM city JOIN country ON city.country_id = country.country_id WHERE country.country_name = 'South Africa';
SELECT COUNT(*) FROM     match JOIN     venue ON match.venue_id = venue.venue_id WHERE     venue_name = 'Newlands';
SELECT win_margin FROM     match WHERE     (team_1 = (SELECT team_id FROM team WHERE team_name = 'Mumbai Indians'))     AND     (team_2 = (SELECT team_id FROM team WHERE team_name = 'Royal Challengers Bangalore'))     AND     (match_date = '2008-05-28');
SELECT team.team_name FROM     match JOIN     team ON match.team_1 = team.team_id WHERE     match.match_date LIKE '2011%'     AND match.win_margin < (         SELECT            AVG(win_margin) * 0.3         FROM             match         WHERE             match.match_date LIKE '2011%'     ) UNION SELECT    team.team_name FROM     match JOIN     team ON match.team_2 = team.team_id WHERE     match.match_date LIKE '2011%'     AND match.win_margin < (         SELECT            AVG(win_margin) * 0.3         FROM             match         WHERE             match.match_date LIKE '2011%'     );
SELECT (CAST(COUNT(player_match.role_id) AS REAL) / (SELECT COUNT(player_match.role_id) FROM player_match INNER JOIN player ON player_match.player_id = player.player_id WHERE player.dob LIKE '1977%')) * 100 AS percentage_of_captains FROM player_match INNER JOIN player ON player_match.player_id = player.player_id INNER JOIN rolee ON player_match.role_id = rolee.role_id WHERE rolee.role_desc = 'Captain' AND player.dob LIKE '1977%'; 
SELECT COUNT(DISTINCT over_id) AS overs_count FROM ball_by_ball WHERE match_id = 335996 AND innings_no = 1;
SELECT OVER_ID, BALL_ID, INNINGS_NO FROM BATSMAAN_SCORED WHERE MATCH_ID = 336004 AND RUNS_SCORED = (     SELECT MAX(RUNS_SCORED)     FROM BATSMAAN_SCORED     WHERE MATCH_ID = 336004 );
SELECT match_id FROM ball_by_ball WHERE over_id > 20 LIMIT 5;
SELECT COUNT(DISTINCT player_out) AS num_players_out FROM wicket_taken WHERE match_id = 548335 AND innings_no = 1;
SELECT player_name FROM player WHERE dob LIKE '1971%'
SELECT match_id FROM match WHERE DATE(match_date) = '2015-04-18';
SELECT match.match_id FROM match JOIN wicket_taken ON match.match_id = wicket_taken.match_id JOIN out_type ON wicket_taken.kind_out = out_type.out_id WHERE out_type.out_name = 'hit wicket'; 
SELECT COUNT(*)  FROM wicket_taken  WHERE kind_out = (SELECT out_id FROM out_type WHERE out_name = 'stumped')  AND innings_no = 2;
SELECT COUNT(match.man_of_the_match) FROM     match JOIN     player ON match.man_of_the_match = player.player_id WHERE     player.player_name = 'Yuvraj Singh';
SELECT player_name, dob FROM player WHERE dob LIKE '1977%' AND country_name = 'England';
SELECT player.player_name FROM     player INNER JOIN     match ON     player.player_id = match.man_of_the_match INNER JOIN     season ON     match.season_id = season.season_id WHERE     season.season_year = 2010;
SELECT ROUND((COUNT(CASE WHEN match_winner = 3 THEN match_id END) * 100.0 / COUNT(match_id)), 2) AS win_rate FROM match WHERE team_1 = (SELECT team_id FROM team WHERE team_name = 'Chennai Super Kings') OR team_2 = (SELECT team_id FROM team WHERE team_name = 'Chennai Super Kings');
SELECT player.player_name, country.country_name FROM player JOIN player_match ON player.player_id = player_match.player_id JOIN match ON player_match.match_id = match.match_id JOIN team ON match.team_1 = team.team_id OR match.team_2 = team.team_id JOIN country ON player.country_name = country.country_id WHERE team.team_name = 'Gujarat Lions' AND match.match_date = '2016-04-11';
SELECT player_name, dob FROM player WHERE bowling_skill = 'Left-arm fast';
SELECT country.country_name FROM umpire JOIN country ON umpire.umpire_country = country.country_id WHERE umpire.umpire_name = 'BR Doctrove';
SELECT player.player_name AS Captain_Name FROM player JOIN player_match ON player.player_id = player_match.player_id JOIN team ON player_match.team_id = team.team_id JOIN match ON match.match_winner = team.team_id JOIN rolee ON player_match.role_id = rolee.role_id WHERE rolee.role_desc = 'Captain' AND match.match_date = '2008-06-01'
SELECT team.team_name, COUNT(player_match.match_id) AS matches_played FROM player JOIN player_match ON player.player_id = player_match.player_id JOIN team ON player_match.team_id = team.team_id WHERE player.player_name = 'CK Kapugedera';
SELECT ROUND((COUNT(*) * 100.0) / (SELECT COUNT(*) FROM match WHERE venue_id = (SELECT venue_id FROM venue WHERE venue_name = 'Wankhede Stadium')), 2) AS percentage_wankhede_stadium FROM match WHERE venue_id = (SELECT venue_id FROM venue WHERE venue_name = 'Wankhede Stadium') AND venue_id IN (SELECT venue_id FROM venue WHERE city_id = (SELECT city_id FROM city WHERE city_name = 'Mumbai'));
SELECT ((COUNT(player_out) * 1.0) / (SELECT COUNT(player_out) FROM wicket_taken WHERE match_id = 392187)) * 100 AS percentage_bowled FROM wicket_taken WHERE match_id = 392187 AND kind_out = (SELECT out_id FROM out_type WHERE out_name = 'bowled');
SELECT (COUNT(CASE WHEN toss_decision.toss_name = 'field' THEN 1 END) * 100.0) / COUNT(match.toss_id) FROM match WHERE match.match_date BETWEEN '2010-01-01' AND '2016-12-31'
SELECT  Toss_winner FROM match WHERE toss_decide = 2 
SELECT match_id FROM match WHERE man_of_the_match = (     SELECT player_id     FROM player     WHERE player_name = 'BB McCullum' ); 
SELECT player.dob FROM player JOIN match ON match.man_of_the_match = player.player_id; 
SELECT team.team_name FROM match JOIN team ON match.toss_winner = team.team_id WHERE match.match_id BETWEEN 336010 AND 336020;
SELECT COUNT(*) FROM match WHERE match_winner = (SELECT team_id FROM team WHERE team_name = 'Mumbai Indians');
SELECT team.team_name FROM     match JOIN     team ON match.team_2 = team.team_id WHERE     match.team_1 = (SELECT team_id FROM team WHERE team_name = 'Pune Warriors');
SELECT team.team_name FROM match JOIN team ON match.match_winner = team.team_id WHERE match.match_id = 336000;
SELECT match.match_id FROM     match JOIN     venue ON match.venue_id = venue.venue_id WHERE     venue.venue_name = 'Brabourne Stadium';
SELECT venue.venue_name FROM venue INNER JOIN match ON venue.venue_id = match.venue_id WHERE match.season_id = 2;
SELECT city.city_name FROM venue JOIN city ON venue.city_id = city.city_id WHERE venue.venue_name = 'M Chinnaswamy Stadium';
SELECT venue.venue_name FROM venue INNER JOIN city ON venue.city_id = city.city_id WHERE city.city_name = 'Mumbai';
SELECT team.team_id FROM match JOIN venue ON match.venue_id = venue.venue_id JOIN team ON match.match_winner = team.team_id WHERE venue.venue_name LIKE 'St George%'
SELECT venue.venue_name, city.city_name, CASE     WHEN city.city_name = 'Centurion' THEN 'Yes'     ELSE 'No' END AS Is_SuperSport_Park_in_Centurion FROM venue JOIN city ON venue.city_id = city.city_id WHERE venue.venue_name = 'SuperSport Park';
SELECT SUM(CASE WHEN team.team_name = 'Deccan Chargers' THEN 1 ELSE 0 END) AS total_wins FROM match JOIN team ON match.match_winner = team.team_id WHERE team.team_name = 'Deccan Chargers';
SELECT COUNT(venue.venue_id) FROM venue JOIN city ON venue.city_id = city.city_id WHERE city.city_name = 'Pune';
SELECT MAX(non_striker) AS player_id FROM ball_by_ball WHERE match_id = 501219;
SELECT AVG(runs_scored) AS average_runs_scored_first_half_first_innings FROM batsman_scored WHERE innings_no = 1 AND over_id > 1 AND over_id < 25;
SELECT AVG(extra_runs) FROM extra_runs WHERE innings_no = 2;
SELECT 100.0 * COUNT(match.match_id) / (SELECT COUNT(match.match_id) FROM match WHERE win_margin > 100) AS percentage FROM match WHERE win_margin > 100;
SELECT player_name FROM player WHERE dob BETWEEN '1970-01-01' AND '1990-12-31' ORDER BY dob DESC;
SELECT COUNT(*) FROM wicket_taken WHERE over_id = 3 AND fielders = '';
SELECT country.country_name AS country_name, COUNT(umpire.umpire_id) AS umpire_count FROM umpire JOIN country ON umpire.umpire_country = country.country_id GROUP BY country.country_name ORDER BY umpire_count DESC LIMIT 1;
SELECT (COUNT(DISTINCT player.player_id) * 100) / (SELECT COUNT(DISTINCT player.player_id) FROM player_match WHERE role_id = (SELECT role_id FROM rolee WHERE role_desc = 'CaptainKeeper')) AS percentage FROM player_match WHERE role_id = (SELECT role_id FROM rolee WHERE role_desc = 'CaptainKeeper');
SELECT COUNT(player.player_id) FROM     player JOIN     wicket_taken ON player.player_id = wicket_taken.player_out JOIN     out_type ON wicket_taken.kind_out = out_type.out_id WHERE     out_type.out_name = 'hit wicket';
SELECT AVG(CASE WHEN batting_hand = 'Right-hand bat' THEN 1 ELSE 0 END) AS average_players_right_hand FROM player GROUP BY country_name;
SELECT (Could you please provide the columns you'd like to select?)
SELECT COUNT(DISTINCT match_winner) FROM match WHERE win_margin < 50 AND win_type = 'wickets';
SELECT COUNT(DISTINCT match.venue_id) AS venues_count FROM     match WHERE     match.toss_winner = match.team_2     AND match.match_winner = match.team_1;
SELECT player.player_name, player.country_name FROM player INNER JOIN season ON player.player_id = season.man_of_the_series WHERE season.season_year = 2012;
SELECT Venue_Name FROM     venue JOIN     match ON     venue.venue_id = match.venue_id GROUP BY     venue.venue_id ORDER BY     COUNT(match.match_id) DESC LIMIT 1;
SELECT city.city_name FROM     city JOIN     venue ON city.city_id = venue.city_id JOIN     match ON venue.venue_id = match.venue_id WHERE     match.win_type = (SELECT                          win_id                       FROM                           win_by                       WHERE                           win_type = 'NoResult') GROUP BY     city.city_name ORDER BY     COUNT(match.win_type) LIMIT 1;
SELECT Player.player_name FROM Player JOIN match ON match.man_of_the_series = Player.player_id GROUP BY Player.player_name HAVING COUNT(match.man_of_the_series) > 1;
SELECT player.player_name, country.country_name FROM player JOIN country ON player.country_name = country.country_id JOIN wicket_taken ON player.player_id = wicket_taken.fielders JOIN out_type ON wicket_taken.kind_out = out_type.out_id WHERE out_type.out_name = 'caught' GROUP BY player.player_id HAVING COUNT(wicket_taken.fielders) > (     SELECT        COUNT(wicket_taken.fielders) / COUNT(player.player_id)     FROM         wicket_taken     JOIN         out_type ON wicket_taken.kind_out = out_type.out_id     WHERE         out_type.out_name = 'caught' )  ORDER BY COUNT(wicket_taken.fielders) ASC;
SELECT 100.0 * (     SELECT COUNT(*)     FROM match     WHERE win_type = (SELECT win_id FROM win_by WHERE win_type = 'runs')     AND match_winner = team_1     AND toss_winner = team_1     AND toss_decide = (SELECT toss_id FROM toss_decision WHERE toss_name = 'field') ) / (     SELECT COUNT(*)     FROM match     WHERE win_type = (SELECT win_id FROM win_by WHERE win_type = 'runs')     AND match_winner = team_1 ) AS percentage;
SELECT AVG(CASE WHEN kind_out = 4 THEN 1 ELSE 0 END) - AVG(CASE WHEN kind_out = 3 THEN 1 ELSE 0 END) AS difference FROM wicket_taken;
SELECT ball_by_ball.over_id FROM ball_by_ball WHERE ball_by_ball.striker = 7;
SELECT COUNT(*) AS num_first_teams_bat_after_win_toss FROM match WHERE team_1 = toss_winner AND toss_decide = 2;
SELECT COUNT(*) FROM match WHERE match_date LIKE '2010-03%'
SELECT COUNT(player_id) FROM player WHERE dob < '1990-06-29' AND player_name != 'Gurkeerat Singh';
SELECT COUNT(*) FROM match JOIN player ON match.man_of_the_match = player.player_id WHERE player.player_name = 'SR Watson';
SELECT MAX(COUNT(player_match.role_id)) AS versatile_count, player.player_name FROM player JOIN player_match ON player.player_id = player_match.player_id JOIN team ON player_match.team_id = team.team_id WHERE team.team_name = 'Delhi Daredevils' GROUP BY player.player_name ORDER BY versatile_count DESC LIMIT 1;
SELECT player.player_name FROM     player JOIN     match ON match.man_of_the_series = player.player_id GROUP BY     player.player_name ORDER BY     COUNT(match.man_of_the_series) DESC LIMIT 1;
SELECT season.season_year FROM player AS p JOIN player_match AS pm ON p.player_id = pm.player_id JOIN season AS s ON pm.match_id = s.match_id WHERE p.player_name = 'SP Narine' AND s.orange_cap = p.player_id;
SELECT team.team_name FROM     team JOIN     player_match ON team.team_id = player_match.team_id JOIN     player ON player_match.player_id = player.player_id JOIN     season ON player_match.season_id = season.season_id WHERE     (season.purple_cap IS NOT NULL AND season.orange_cap IS NOT NULL);
SELECT player.player_name FROM player INNER JOIN country ON player.country_name = country.country_id WHERE country.country_name = 'Zimbabwea';
SELECT COUNT(*) FROM player WHERE batting_hand = 'Left-hand bat';
SELECT COUNT(*) FROM match WHERE win_type != 'runs';
SELECT umpire_name FROM umpire JOIN country ON umpire.umpire_country = country.country_id WHERE country_name = 'New Zealand';
SELECT country.country_name FROM player JOIN bowling_style ON player.bowling_skill = bowling_style.bowling_id JOIN country ON player.country_name = country.country_id WHERE bowling_style.bowling_skill = 'Slow left-arm chinaman' GROUP BY country.country_name ORDER BY COUNT(player.player_id) DESC LIMIT 1;
SELECT venue_name FROM    venue JOIN match ON venue.venue_id = match.venue_id JOIN team ON match.team_1 = team.team_id OR match.team_2 = team.team_id WHERE    team.team_name = 'Kochi Tuskers Kerala' GROUP BY    venue_name ORDER BY    COUNT(match.match_id) DESC LIMIT 1;
SELECT COUNT(DISTINCT match.match_id) FROM match JOIN ball_by_ball ON match.match_id = ball_by_ball.match_id WHERE (match.team_1 = (SELECT team_id FROM team WHERE team_name = 'Delhi Daredevils') AND ball_by_ball.team_batting = 1) OR (match.team_2 = (SELECT team_id FROM team WHERE team_name = 'Delhi Daredevils') AND ball_by_ball.team_batting = 2) AND ball_by_ball.runs_scored = 0;
SELECT 100 * (     SELECT COUNT(*)      FROM match      WHERE venue_id = (         SELECT venue_id          FROM venue          WHERE venue_name = 'Dr DY Patil Sports Academy'     )      AND win_margin < 10 ) / (     SELECT COUNT(*)      FROM match      WHERE venue_id = (         SELECT venue_id          FROM venue          WHERE venue_name = 'Dr DY Patil Sports Academy'     ) ) AS percentage
SELECT AVG(extra_runs) FROM   extra_runs JOIN   extra_type ON extra_runs.extra_type_id = extra_type.extra_id WHERE   extra_type.extra_name = 'noballs';
SELECT player.player_id FROM player ORDER BY player.bowling_skill DESC LIMIT 5;
SELECT COUNT(*)  FROM player  WHERE dob < '1975-10-16' AND bowling_skill < 3;
SELECT player_name FROM player ORDER BY dob DESC LIMIT 1;
SELECT DISTINCT season.man_of_the_series FROM season WHERE season.season_year BETWEEN 2011 AND 2015; 
SELECT SUM(runs_scored) AS total_runs_scored FROM batsman_scored WHERE match_id = 335988 AND innings_no = 2;
SELECT COUNT(*) FROM batsman_scored JOIN ball_by_ball ON batsman_scored.match_id = ball_by_ball.match_id AND batsman_scored.over_id = ball_by_ball.over_id AND batsman_scored.ball_id = ball_by_ball.ball_id AND batsman_scored.innings_no = ball_by_ball.innings_no WHERE batsman_scored.runs_scored > 3 AND batsman_scored.over_id = 1 AND batsman_scored.ball_id = 1 AND batsman_scored.innings_no = 1 AND batsman_scored.match_id BETWEEN 335989 AND 337000;
SELECT match.match_id, match.match_date FROM match INNER JOIN venue ON match.venue_id = venue.venue_id WHERE venue.venue_name = 'Kingsmead' AND (     SELECT COUNT(DISTINCT match_date)     FROM match AS m     INNER JOIN venue AS v ON m.venue_id = v.venue_id     WHERE v.venue_name = 'Kingsmead'     AND m.match_date BETWEEN date(match.match_date, '-2 day') AND date(match.match_date, '+2 day') ) >= 3; 
SELECT COUNT(match.match_id) AS match_count FROM     match JOIN     venue ON match.venue_id = venue.venue_id WHERE     venue.venue_name = 'MA Chidambaram Stadium'     AND match.match_date BETWEEN '2009-05-09' AND '2011-08-08';
SELECT venue.venue_name, city.city_name FROM match JOIN venue ON match.venue_id = venue.venue_id JOIN city ON venue.city_id = city.city_id WHERE match.match_id = '336005';
SELECT team.team_name AS toss_winner, toss_decision.toss_name AS decision FROM match JOIN team ON match.toss_winner = team.team_id JOIN toss_decision ON match.toss_decide = toss_decision.toss_id WHERE match.match_id = 336011;
SELECT COUNT(*) FROM player WHERE country_name = 'South Africa' AND dob < '1980-04-11';
SELECT player.player_name FROM player JOIN bowling_style ON player.bowling_skill = bowling_style.bowling_id WHERE bowling_style.bowling_skill = 'Legbreak';
SELECT MIN(match.match_date) AS first_match_date, player_role.role_desc AS first_match_role FROM player_match JOIN match ON player_match.match_id = match.match_id JOIN player ON player_match.player_id = player.player_id JOIN rolee AS player_role ON player_match.role_id = player_role.role_id WHERE player.dob = ( SELECT MAX(dob) FROM player ) GROUP BY player.player_id;
SELECT COUNT(match_id) AS match_count FROM match WHERE man_of_the_match = (SELECT player_id FROM player WHERE player_name = 'V Kohli'); 
SELECT COUNT(DISTINCT match.man_of_the_match) FROM     match JOIN     player ON match.man_of_the_match = player.player_id JOIN     country ON player.country_name = country.country_id WHERE     match.match_date LIKE '2011%' OR match.match_date LIKE '2012%'     AND country.country_name = 'Australia';
SELECT player.player_name FROM player JOIN player_match ON player.player_id = player_match.player_id JOIN match ON player_match.match_id = match.match_id JOIN season ON match.season_id = season.season_id WHERE season.man_of_the_series = player.player_id AND season.orange_cap = player.player_id;
SELECT MIN(match.match_date) FROM match JOIN team ON match.match_winner = team.team_id WHERE team.team_name = 'Sunrisers Hyderabad';
SELECT player.player_id, player.player_name FROM umpire JOIN country ON umpire.umpire_country = country.country_id JOIN player ON umpire.umpire_name = player.player_name WHERE country.country_name = 'England';
SELECT SUM(batsman_scored.runs_scored) / 17 FROM     batsman_scored INNER JOIN     ball_by_ball ON batsman_scored.match_id = ball_by_ball.match_id WHERE     ball_by_ball.match_id = 335987     AND ball_by_ball.over_id <= 17     AND ball_by_ball.innings_no = 1
SELECT SUM(CASE WHEN toss_decision.toss_name = 'field' THEN over_id ELSE 0 END) / NULLIF(SUM(CASE WHEN toss_decision.toss_name = 'bat' THEN runs_scored ELSE 0 END), 0) AS run_rate, player.player_name AS man_of_the_match FROM match JOIN player ON match.man_of_the_match = player.player_id JOIN ball_by_ball ON ball_by_ball.match_id = match.match_id JOIN toss_decision ON match.toss_decide = toss_decision.toss_id WHERE match.match_id = 335999 GROUP BY player.player_name;
SELECT team_id, COUNT(match_winner) AS matches_won FROM match GROUP BY match_winner ORDER BY matches_won DESC LIMIT 1;
SELECT strftime('%Y', dob) AS birth_year, COUNT(player_id) AS player_count FROM player GROUP BY birth_year ORDER BY player_count DESC LIMIT 1;
SELECT MAX(match.match_date) FROM   match WHERE   match.win_margin = (     SELECT      MAX(win_margin)     FROM       match   );
SELECT season_id, COUNT(match_id) AS match_count FROM match GROUP BY season_id ORDER BY match_count LIMIT 1;
SELECT COUNT(player.player_id) FROM player JOIN match ON match.man_of_the_match = player.player_id GROUP BY player.player_id HAVING COUNT(match.match_id) >= 5;
SELECT player.player_name FROM     player JOIN     match ON match.man_of_the_match = player.player_id WHERE     match.match_date = (SELECT MAX(match_date) FROM match WHERE season_id = 9)
SELECT team.team_name FROM   team JOIN   match ON team.team_id = match.match_winner WHERE   match.match_date = (     SELECT      MIN(match_date)     FROM       match   );
SELECT COUNT(DISTINCT city.city_id) FROM city JOIN country ON city.country_id = country.country_id WHERE country.country_name = 'U.A.E';
SELECT umpire.umpire_name FROM umpire JOIN country ON umpire.umpire_country = country.country_id WHERE country.country_name = 'England';
SELECT COUNT(*) FROM player WHERE bowling_skill = (SELECT bowling_id FROM bowling_style WHERE bowling_skill = 'Legbreak');
SELECT COUNT(*) AS matches_played FROM match WHERE team_1 = (SELECT team_id FROM team WHERE team_name = 'Rajasthan Royals')    OR team_2 = (SELECT team_id FROM team WHERE team_name = 'Rajasthan Royals')    AND season_id = 8;
SELECT country.country_name FROM umpire JOIN country ON umpire.umpire_country = country.country_id WHERE umpire_name = 'TH Wijewardene';
SELECT venue_name FROM venue INNER JOIN city ON venue.city_id = city.city_id WHERE city_name = 'Abu Dhabi';
SELECT country.country_name FROM player JOIN country ON player.country_name = country.country_id WHERE player.dob = (SELECT MAX(dob) FROM player)
SELECT player.player_name FROM player JOIN player_match ON player.player_id = player_match.player_id JOIN match ON player_match.match_id = match.match_id WHERE match.season_id = 1 AND match.match_date = (SELECT MIN(match_date) FROM match WHERE season_id = 1) AND match.match_winner = (     SELECT match_winner     FROM match     WHERE season_id = 1     AND match_date = (SELECT MIN(match_date) FROM match WHERE season_id = 1) )
SELECT MIN(subtract(season.season_year, player.dob)) AS youngest_age FROM player_match JOIN player ON player_match.player_id = player.player_id JOIN season ON player_match.season_id = season.season_id WHERE season.purple_cap = player.player_id;
SELECT venue.venue_name, city.city_name, country.country_name FROM match JOIN venue ON match.venue_id = venue.venue_id JOIN city ON venue.city_id = city.city_id JOIN country ON city.country_id = country.country_id WHERE match.match_date = (SELECT MAX(match_date) FROM match)
SELECT COUNT(DISTINCT over_id) AS overs_per_innings FROM ball_by_ball WHERE match_id = 336011 GROUP BY innings_no;
SELECT ball_by_ball.ball_id, batsman_scored.runs_scored, ball_by_ball.innings_no FROM ball_by_ball JOIN batsman_scored ON ball_by_ball.match_id = batsman_scored.match_id AND ball_by_ball.over_id = batsman_scored.over_id AND ball_by_ball.ball_id = batsman_scored.ball_id WHERE ball_by_ball.match_id = "335988" AND ball_by_ball.over_id = 20;
SELECT COUNT(*) FROM match JOIN season ON match.season_id = season.season_id WHERE season.season_year = 2011;
SELECT SUBTRACT(2022, SUBSTR(DOB, 1, 4)) AS Ishan_Kishan_Age FROM player WHERE player_name = 'Ishan Kishan';
SELECT CAST((SELECT COUNT(*) FROM match WHERE Match_Date LIKE '2012%' AND Toss_Winner = Match_Winner) AS FLOAT) /  CAST((SELECT COUNT(*) FROM match WHERE Match_Date LIKE '2012%') AS FLOAT) AS win_rate;
SELECT COUNT(*) FROM match WHERE match_date LIKE '2009%' AND win_margin < 10;
SELECT player.player_name FROM     match JOIN     team ON match.team_1 = team.team_id OR match.team_2 = team.team_id JOIN     player_match ON player_match.match_id = match.match_id AND player_match.team_id = team.team_id JOIN     player ON player.player_id = player_match.player_id JOIN     season ON match.season_id = season.season_id WHERE     SUBSTR(match.match_date, 7, 1) = '6'     AND SUBSTR(match.match_date, 1, 4) = '2014';
SELECT COUNT(*) AS matches_played FROM player_match JOIN player ON player_match.player_id = player.player_id WHERE player.player_name = 'Mohammad Hafeez';
SELECT player.player_name FROM player INNER JOIN country ON player.country_name = country.country_id WHERE country.country_name = 'South Africa' AND player.dob LIKE '1984%'
SELECT COUNT(match_winner) * 100.0 / (SELECT COUNT(match_id) FROM match WHERE match_date LIKE '2009%' AND (team_1 = (SELECT team_id FROM team WHERE team_name = 'Mumbai Indians') OR team_2 = (SELECT team_id FROM team WHERE team_name = 'Mumbai Indians'))) as win_percentage FROM match WHERE match_winner = (SELECT team_id FROM team WHERE team_name = 'Mumbai Indians') AND match_date LIKE '2009%';
SELECT COUNT(CASE WHEN player.batting_hand = 'Right-hand bat' THEN 1 END) * 1.0 / COUNT(CASE WHEN player.batting_hand = 2 THEN 1 END) AS ratio FROM player;
SELECT player_name, country_name FROM player WHERE dob = (     SELECT MIN(dob)      FROM player )
SELECT bowling_style.bowling_skill FROM player JOIN country ON player.country_name = country.country_id JOIN bowling_style ON player.bowling_skill = bowling_style.bowling_id WHERE country.country_name = 'Zimbabwea';
SELECT umpire_id, umpire_name FROM umpire WHERE umpire_country = (SELECT country_id FROM country WHERE country_name = 'New Zealand');
SELECT player.player_name FROM player JOIN player_match ON player.player_id = player_match.player_id JOIN team ON player_match.team_id = team.team_id JOIN rolee ON player_match.role_id = rolee.role_id WHERE team.team_name = 'Rising Pune Supergiants' AND rolee.role_desc = 'CaptainKeeper';
SELECT COUNT(match.match_id) FROM   match WHERE   match.match_winner = (SELECT team_id FROM team WHERE team_name = 'Sunrisers Hyderabad')   AND match.match_date LIKE '2013%'
SELECT match_id FROM extra_runs WHERE extra_type_id = (SELECT extra_id FROM extra_type WHERE extra_name = 'penalty');
SELECT team.team_name FROM match JOIN team ON match.team_1 = team.team_id OR match.team_2 = team.team_id WHERE match.win_type = (SELECT win_id FROM win_by WHERE win_type = 'Tie') AND SUBSTR(match.match_date, 1, 4) = 2015;
SELECT AVG(CASE WHEN wicket_taken.innings_no = 1 THEN 1 ELSE 0 END) AS avg_players_out_first_innings, COUNT(CASE WHEN wicket_taken.kind_out = 'lbw' AND wicket_taken.innings_no = 1 THEN 1 ELSE NULL END) AS lbw_first_innings FROM wicket_taken JOIN match ON match.match_id = wicket_taken.match_id; 
SELECT COUNT(*) FROM match WHERE match_date LIKE '2008%'
SELECT COUNT(DISTINCT match_id) FROM ball_by_ball WHERE innings_no = 2;
SELECT country.country_name FROM city JOIN country ON city.country_id = country.country_id WHERE city.city_name = 'Rajkot';
SELECT COUNT(*) FROM match WHERE win_type = 'Superover';
SELECT team.team_name FROM match JOIN team ON match.team_1 = team.team_id OR match.team_2 = team.team_id WHERE match.win_margin = 38 AND match.match_date = '2009-04-30';
SELECT team.team_name FROM     match JOIN     player_match ON match.match_id = player_match.match_id JOIN     player ON player_match.player_id = player.player_id JOIN     team ON player_match.team_id = team.team_id WHERE     player.player_name = 'T Kohli'     AND match.match_id = 335989;
SELECT COUNT(venue_id) FROM venue JOIN city ON venue.city_id = city.city_id JOIN country ON city.country_id = country.country_id WHERE city_name = 'Centurion' AND country_name = 'South Africa';
SELECT COUNT(*) AS num_won_matches FROM match WHERE (team_1 = (SELECT team_id FROM team WHERE team_name = 'Delhi Daredevils') OR team_2 = (SELECT team_id FROM team WHERE team_name = 'Delhi Daredevils')) AND match_winner = (SELECT team_id FROM team WHERE team_name = 'Delhi Daredevils') AND match_date LIKE '%2014%';
SELECT MAX(match_id) FROM     match WHERE     (team_1 = (SELECT team_id FROM team WHERE team_name = 'Royal Challengers Bangalore')     OR team_2 = (SELECT team_id FROM team WHERE team_name = 'Royal Challengers Bangalore')) AND win_margin = (SELECT MAX(win_margin) FROM match                   WHERE                       (team_1 = (SELECT team_id FROM team WHERE team_name = 'Royal Challengers Bangalore')                       OR team_2 = (SELECT team_id FROM team WHERE team_name = 'Royal Challengers Bangalore')))
SELECT COUNT(*) FROM player_match WHERE player_id = (     SELECT player_id     FROM player     WHERE player_name = 'K Goel' ) AND role_id = 3;
SELECT AVG(win_margin) AS average_winning_margin FROM match JOIN venue ON match.venue_id = venue.venue_id WHERE venue_name = 'Newlands';
SELECT team.team_name FROM     team JOIN     match ON team.team_id = match.team_1 OR team.team_id = match.team_2 WHERE     match.match_id = 336039     AND team.team_id != match.match_winner;
SELECT venue.venue_name FROM     match INNER JOIN     venue ON match.venue_id = venue.venue_id WHERE     match.match_id = 829768;
SELECT team.team_name FROM     match JOIN     team ON match.team_2 = team.team_id WHERE     match.win_margin = (SELECT MIN(win_margin) FROM match);
SELECT COUNT(CASE WHEN match_winner = 7 THEN 1 END) * 100.0 / COUNT(*) FROM match WHERE match_date LIKE '2013%'
SELECT COUNT(CASE WHEN player.player_name = 'SC Ganguly' AND player_match.role_id = 1 THEN 1 END) - COUNT(CASE WHEN player.player_name = 'SC Ganguly' AND player_match.role_id > 1 THEN 1 END) FROM player_match JOIN player ON player_match.player_id = player.player_id WHERE player.player_name = 'SC Ganguly';
SELECT COUNT(DISTINCT player_id) FROM player WHERE bowling_skill > 2;
SELECT COUNT(*) FROM player WHERE dob LIKE '1970%'
SELECT COUNT(player.player_id) AS player_count FROM player WHERE player.dob LIKE '198%' AND player.bowling_skill = 2;
SELECT COUNT(*) AS total_matches FROM match WHERE match_date LIKE '2008-04%'
SELECT city.city_name FROM city WHERE city.country_id = 3;
SELECT COUNT(match.match_id) FROM     match WHERE     match.match_winner IS NOT NULL     AND match.season_id = (         SELECT season_id FROM season WHERE season_year LIKE '2008%'     );
SELECT country.country_id FROM city WHERE city.city_name = 'East London';
SELECT CAST((2008 - strftime('%Y', dob)) AS INTEGER) AS age_in_2008 FROM player WHERE player_name = 'SC Ganguly';
SELECT player.player_name FROM player WHERE player.batting_hand = 'Left-hand bat';
SELECT COUNT(player.player_id) FROM player JOIN country ON player.country_name = country.country_id WHERE country.country_name = 'India';
SELECT player.player_name FROM player INNER JOIN country ON player.country_name = country.country_id WHERE country.country_name = 'England';
SELECT venue.venue_name FROM venue JOIN city ON venue.city_id = city.city_id WHERE city.city_name = 'Bangalore';
SELECT player.player_name FROM player INNER JOIN player_match ON player.player_id = player_match.player_id INNER JOIN match ON player_match.match_id = match.match_id INNER JOIN season ON match.season_id = season.season_id WHERE season.season_year = 2008;
SELECT player.player_name FROM batsman_scored JOIN player ON batsman_scored.match_id = player_match.match_id AND batsman_scored.innings_no = player_match.match_id WHERE batsman_scored.runs_scored < 3;
SELECT role_desc FROM     player JOIN     player_match ON player.player_id = player_match.player_id JOIN     rolee ON player_match.role_id = rolee.role_id WHERE     player_name = 'SC Ganguly';
SELECT player.player_name FROM player JOIN player_match ON player.player_id = player_match.player_id JOIN rolee ON player_match.role_id = rolee.role_id WHERE rolee.role_desc = 'Keeper';
SELECT player.player_name FROM player JOIN player_match ON player.player_id = player_match.player_id JOIN match ON player_match.match_id = match.match_id WHERE match.team_1 = 1;
SELECT COUNT(DISTINCT player.player_id) FROM player_match JOIN player ON player_match.player_id = player.player_id JOIN rolee ON player_match.role_id = rolee.role_id JOIN match ON player_match.match_id = match.match_id JOIN season ON match.season_id = season.season_id WHERE rolee.role_desc = 'Captain' AND season.season_year LIKE '2008%'
SELECT team.team_name FROM     player JOIN     player_match ON player.player_id = player_match.player_id JOIN     match ON player_match.match_id = match.match_id JOIN     team ON match.match_winner = team.team_id JOIN     season ON match.season_id = season.season_id WHERE     player.player_name = 'SC Ganguly'     AND season.season_year = 2008;
SELECT win_by.win_type FROM     match WHERE     match.match_id = 336000;
SELECT country.country_name FROM player JOIN country ON player.country_name = country.country_id WHERE player.player_name = 'SB Joshi';
SELECT COUNT(*) FROM player WHERE bowling_skill = (SELECT bowling_id FROM bowling_style WHERE bowling_skill = 'Left-arm fast');
SELECT outcome_type FROM match WHERE match_id = 392195; 
SELECT MIN(player.dob) AS youngest_dob, city.city_name AS city_of_youngest_player FROM player JOIN city ON player.country_name = city.country_id;
SELECT COUNT(match.match_id) AS matches_won FROM     match WHERE     match.match_winner = (SELECT team_id FROM team WHERE team_name = 'Kings XI Punjab')     AND match.season_id = (SELECT season_id FROM season WHERE season_year = 2008);
SELECT COUNT(DISTINCT season.season_id) FROM     team JOIN     match ON team.team_id = match.team_1 OR team.team_id = match.team_2 JOIN     season ON match.season_id = season.season_id WHERE     team.team_name = 'Pune Warriors';
SELECT player.dob, rolee.role_desc FROM player JOIN player_match ON player.player_id = player_match.player_id JOIN rolee ON player_match.role_id = rolee.role_id WHERE player.player_name = 'R Dravid';
SELECT COUNT(*) AS times_man_of_the_match FROM     match JOIN     player ON match.man_of_the_match = player.player_id WHERE     player.player_name = 'SC Ganguly';
SELECT COUNT(*) FROM match WHERE match_winner = (SELECT team_id FROM team WHERE team_name = 'Mumbai Indians') AND match_date LIKE '2008%'
SELECT team.team_name FROM     match JOIN     team ON match.match_winner = team.team_id WHERE     match.match_id = 335993     AND match.win_type = (SELECT win_id FROM win_by WHERE win_type = 'wickets');
SELECT COUNT(*) FROM match WHERE win_type = (SELECT win_id FROM win_by WHERE win_type = 'wickets');
SELECT role_desc FROM     player_match JOIN player ON player_match.player_id = player.player_id JOIN rolee ON player_match.role_id = rolee.role_id JOIN season ON player_match.season_id = season.season_id WHERE     player.player_name = 'W Jaffer'     AND season.season_year = 2012;
SELECT player.player_name FROM     player JOIN     match ON match.man_of_the_match = player.player_id JOIN     season ON match.season_id = season.season_id WHERE     season.season_year = 2008 GROUP BY     player.player_name HAVING     COUNT(match.man_of_the_match) > 5;
SELECT AVG(CASE WHEN player.country_name = 'India' AND strftime('%Y', player.dob) BETWEEN '1975' AND '1985' THEN 1 ELSE 0 END) FROM player;
SELECT ROUND((COUNT(CASE WHEN batting_hand = 'Left-hand bat' THEN 1 END) * 100.0) / COUNT(player_id), 2) AS percentage_left_hand_batsmen FROM player;
SELECT ROUND((CAST((SELECT COUNT(*) FROM match WHERE win_type = (SELECT win_id FROM win_by WHERE win_type = 'runs')) AS FLOAT) / CAST((SELECT COUNT(*) FROM match) AS FLOAT)) * 100, 2) AS percentage_of_matches_won_by_runs 
SELECT COUNT(*) AS total_matches FROM     match WHERE     win_margin = 7;
SELECT COUNT(*) FROM player WHERE strftime('%Y', dob) BETWEEN '1970' AND '1975';
SELECT team.team_name FROM match JOIN team ON match.match_winner = team.team_id WHERE match.match_date = '2009-04-26' AND match.win_margin = 6;
SELECT team.team_name AS "Winner", match.win_margin AS "Margin" FROM match JOIN team ON match.match_winner = team.team_id WHERE match.match_id = 419135;
SELECT MAX(match.match_id) FROM   match JOIN   venue ON match.venue_id = venue.venue_id WHERE   venue.venue_name = 'St George''s Park';
SELECT COUNT(*) FROM player JOIN country ON player.country_name = country.country_id WHERE country.country_name = 'Sri Lanka';
SELECT player.player_name FROM player JOIN player_match ON player.player_id = player_match.player_id JOIN rolee ON player_match.role_id = rolee.role_id WHERE rolee.role_desc = 'captain';
SELECT venue.venue_name, team.team_name FROM match JOIN venue ON match.venue_id = venue.venue_id JOIN team ON match.match_winner = team.team_id WHERE match.match_id = 392194;
SELECT COUNT(*) * 100.0 / (     SELECT COUNT(*)     FROM match     WHERE match_winner = (         SELECT team_id         FROM team         WHERE team_name = 'Delhi Daredevils'     ) AND match_date LIKE '2009%' AND win_type = (         SELECT win_id         FROM win_by         WHERE win_type = 'wickets'     ) ) AS percentage_won_by_wickets FROM match WHERE match_winner = (     SELECT team_id     FROM team     WHERE team_name = 'Delhi Daredevils' ) AND match_date LIKE '2009%' AND win_type = (     SELECT win_id     FROM win_by     WHERE win_type = 'wickets' );
SELECT groupName FROM torrents WHERE artist = 'Ron Hunt' AND groupYear = 1979 AND releaseType = 'single' AND totalSnatched = 239; 
SELECT COUNT(torrents.id) AS downloads FROM torrents WHERE torrents.artist = 'blowfly' AND torrents.groupyear = 1980;
SELECT tags.tag FROM tags JOIN (     SELECT    torrents.id,     torrents.groupname,     MAX(torrents.totalsnatched) AS max_snatched     FROM     torrents     WHERE     torrents.releasetype = 'album'     GROUP BY     torrents.id,     torrents.groupname ) AS max_downloads ON tags.id = max_downloads.id; 
SELECT tags.tag, MAX(torrents.totalSnatched) AS total_downloads FROM torrents JOIN tags ON torrents.id = tags.id GROUP BY tags.tag ORDER BY total_downloads DESC LIMIT 5; 
SELECT t.groupName FROM torrents AS t JOIN tags AS tg ON t.id = tg.id WHERE tg.tag = 'funk' AND t.releaseType = 'single' AND t.groupYear = (     SELECT MIN(groupYear)     FROM torrents     WHERE releaseType = 'single' ); 
SELECT DISTINCT groupname FROM torrents WHERE releasetype = 'ep' AND groupid IN (     SELECT id     FROM tags     WHERE tag = 'alternative' ); 
SELECT tags.tag FROM tags JOIN torrents ON tags.id = torrents.id WHERE torrents.releasetype = 'album' AND torrents.groupyear LIKE '%live%' ORDER BY torrents.totalsnatched ASC LIMIT 5;
SELECT tags.tag, torrents.artist FROM torrents JOIN tags ON torrents.id = tags.id WHERE torrents.releaseType = 'single' AND torrents.totalSnatched = (SELECT MAX(totalSnatched) FROM torrents WHERE releaseType = 'single');
SELECT COUNT(DISTINCT groupid) AS num_releases FROM tags WHERE tag = '1980s'; 
SELECT COUNT(*)  FROM torrents  WHERE groupName = 'city funk';
SELECT groupname FROM torrents WHERE totalsnatched > 20000; 
SELECT tags.tag FROM torrents JOIN tags ON torrents.id = tags.id WHERE torrents.groupname = 'sugarhill gang'; 
SELECT COUNT(*) FROM tags WHERE id IN (     SELECT id     FROM torrents     WHERE groupname = 'city funk' );
SELECT torrents.groupname FROM torrents JOIN tags ON torrents.id = tags.id WHERE tags.tag = '1980s'; 
SELECT torrents.groupname AS title FROM torrents JOIN tags ON torrents.id = tags.id WHERE tags.tag = "1980s" ORDER BY torrents.totalsnatched DESC LIMIT 1; 
SELECT COUNT(*) FROM torrents JOIN tags ON torrents.id = tags.id WHERE torrents.artist = 'michael jackson' AND tags.tag = 'pop';
SELECT COUNT(*) FROM torrents WHERE groupyear = 2000 AND releasetype = 'album' AND groupid IN (SELECT id FROM tags WHERE tag = 'pop');
SELECT AVG(totalsnatched) AS average_download_time FROM torrents JOIN tags ON torrents.id = tags.id WHERE tags.tag = '1980s';
SELECT groupname AS title FROM torrents ORDER BY totalsnatched DESC LIMIT 3; 
SELECT artist, groupName FROM torrents WHERE groupYear = 2012 AND releaseType = 'single' ORDER BY totalSnatched DESC LIMIT 1; 
SELECT COUNT(DISTINCT t.groupid) AS num_albums, COUNT(DISTINCT t.groupid) AS num_singles FROM torrents t WHERE t.artist = '50 cent' AND t.groupyear BETWEEN 2010 AND 2015 AND (t.releasetype = 'album' OR t.releasetype = 'single');
SELECT COUNT(DISTINCT groupid) - 1 AS years_passed FROM   torrents WHERE   artist = '2Pac'   AND groupyear > 1991
SELECT AVG(totalsnatched) AS avg_downloads FROM torrents WHERE artist = '2Pac' AND releasetype = 'single' AND groupyear BETWEEN 2001 AND 2013;
SELECT groupName AS title, groupYear AS release_year, tag AS tag FROM torrents JOIN tags ON torrents.id = tags.id WHERE releaseType = 'live album' ORDER BY totalSnatched DESC LIMIT 1; 
SELECT artist FROM torrents WHERE groupyear = 2016 AND releasetype = 'bootleg' GROUP BY artist HAVING COUNT(releasetype) >= 2; 
SELECT DISTINCT artist FROM torrents WHERE releasetype = 'single' AND groupyear BETWEEN 1980 AND 1982; 
SELECT groupname FROM torrents WHERE groupid BETWEEN 10 AND 20 AND releasetype = 'single' AND totalsnatched >= 20; 
SELECT DISTINCT torrents.artist FROM torrents JOIN tags ON torrents.id = tags.id WHERE torrents.groupyear BETWEEN 1980 AND 1982 AND tags.tag = 'disco'; 
SELECT artist FROM torrents WHERE totalsnatched <= 100 AND groupyear = 1980 AND groupid IN (     SELECT id     FROM tags     WHERE tag = 'funk' ); 
SELECT artist FROM (     SELECT        artist,         COUNT(releasetype) AS single_count     FROM         torrents     WHERE         releasetype = 'single'     GROUP BY         artist ) AS single_counts JOIN     tags ON     single_counts.groupid = tags.id WHERE     tag = 'soul' ORDER BY     single_count DESC LIMIT 1; 
SELECT torrents.artist FROM torrents JOIN tags ON torrents.id = tags.id WHERE torrents.artist IS NOT NULL AND torrents.groupyear = 1980 AND tags.tag = "funk" AND torrents.id BETWEEN 10 AND 30; 
SELECT groupname FROM   torrents WHERE   groupyear >= 1982   AND releasetype = 'jazz' GROUP BY   groupname ORDER BY   MAX(totalsnatched) DESC LIMIT 1; 
SELECT tags.tag FROM torrents INNER JOIN tags ON torrents.id = tags.id WHERE torrents.artist = "16"; 
SELECT torrents.artist, MAX(torrents.totalSnatched) AS max_downloads FROM torrents JOIN tags ON torrents.id = tags.id WHERE tags.tag = 'new.york' AND torrents.id BETWEEN 10 AND 50 GROUP BY torrents.artist ORDER BY max_downloads DESC LIMIT 1; 
SELECT DISTINCT artist FROM torrents WHERE groupyear BETWEEN 1980 AND 1985 AND releasetype IN ('album', 'mixtape') AND groupid IN (     SELECT id     FROM tags     WHERE tag = 'dance' );
SELECT COUNT(DISTINCT torrents.id) FROM     torrents INNER JOIN     tags ON torrents.id = tags.id WHERE     torrents.releasetype = 'single'     AND torrents.groupyear BETWEEN 1979 AND 1981     AND tags.tag = 'soul';
SELECT COUNT(*) FROM torrents WHERE releaseType = 'single' AND groupYear = 1979;
SELECT COUNT(*) FROM torrents WHERE artist = 'sugar daddy' AND releaseType = 'single' AND groupYear = 1980;
SELECT COUNT(*) FROM     torrents WHERE     groupyear = 2004     AND releasetype = 'album'     AND groupid IN (SELECT id FROM tags WHERE tag = 'christmas');
SELECT t.tag FROM torrents AS tor JOIN tags AS t ON tor.id = t.id WHERE tor.artist = 'kurtis blow' AND tor.groupyear BETWEEN 2000 AND 2010; 
SELECT torrents.groupname, tags.tag FROM torrents JOIN tags ON torrents.id = tags.id WHERE torrents.artist = 'millie jackson' AND torrents.releasetype = 'album' AND torrents.groupyear = 1980; 
SELECT groupname FROM torrents WHERE groupyear = 2005 AND groupid IN (SELECT id FROM tags WHERE tag = 'jazz'); 
SELECT artist, COUNT(id) AS num_releases FROM torrents JOIN tags ON torrents.id = tags.id WHERE groupYear BETWEEN 1980 AND 2000 AND tag = 'disco' GROUP BY artist ORDER BY num_releases DESC LIMIT 1; 
SELECT DISTINCT torrents.artist FROM torrents JOIN tags ON torrents.id = tags.id WHERE tags.tag = '1970s' AND torrents.releasetype = 'single'; 
SELECT (DIVIDE(CAST(COUNT(CASE WHEN torrents.releasetype = 'album' AND tags.tag = 'united.states' THEN 1 END) AS REAL), COUNT(CASE WHEN torrents.releasetype = 'album' THEN 1 END)) * 100) AS percentage FROM torrents LEFT JOIN tags ON torrents.id = tags.id WHERE torrents.groupyear BETWEEN 1979 AND 1982; 
SELECT COUNT(DISTINCT country.countrycode) FROM     country JOIN     indicators ON country.countrycode = indicators.countrycode JOIN     series ON indicators.indicatorcode = series.seriescode WHERE     country.othergroups = 'HIPC'     AND country.lendingcategory = 'IDA';
SELECT country.ShortName FROM country WHERE country.lendingcategory = 'IDA' AND country.externaldebtreportingstatus = 'Estimate';
SELECT seriesnotes.description FROM seriesnotes JOIN series ON seriesnotes.seriescode = series.seriescode JOIN country ON country.countrycode = 'ABW' WHERE series.seriescode = 'SM.POP.TOTL';
SELECT country.shortname, country.countrycode, country.region, countrynotes.description FROM country JOIN countrynotes ON country.countrycode = countrynotes.countrycode JOIN series ON countrynotes.seriescode = series.seriescode WHERE country.region = 'Latin America & Caribbean' AND series.seriescode = 'SM.POP.TOTL';
SELECT COUNT(DISTINCT country.countrycode) FROM country JOIN countrynotes ON country.countrycode = countrynotes.countrycode JOIN series ON countrynotes.seriescode = series.seriescode WHERE series.seriescode = 'SM.POP.TOTL' AND country.incomegroup = 'Low income' AND countrynotes.description IS NOT NULL;
SELECT seriesnotes.description FROM series JOIN seriesnotes ON series.seriescode = seriesnotes.seriescode JOIN country ON series.countrycode = country.countrycode WHERE series.seriescode = 'SM.POP.TOTL' AND country.lendingcategory = 'IDA';
SELECT COUNT(country.countrycode) FROM country JOIN indicators ON country.countrycode = indicators.countrycode JOIN series ON indicators.indicatorcode = series.seriescode JOIN countrynotes ON country.countrycode = countrynotes.countrycode AND series.seriescode = countrynotes.seriescode WHERE country.incomegroup = 'Low income' AND country.lendingcategory = 'International Development Association' AND series.seriescode = 'SM.POP.TOTL';
SELECT COUNT(DISTINCT country.countrycode) FROM country JOIN indicators ON country.countrycode = indicators.countrycode JOIN series ON indicators.indicatorcode = series.seriescode LEFT JOIN countrynotes ON country.countrycode = countrynotes.countrycode AND series.seriescode = countrynotes.seriescode WHERE incomegroup = 'High' AND currencyunit = 'Euro' AND description IS NOT NULL AND series.seriescode = 'SP.DYN.AMRT.FE'
SELECT country.longname FROM country JOIN countrynotes ON country.countrycode = countrynotes.countrycode JOIN series ON countrynotes.seriescode = series.seriescode WHERE series.seriescode = 'SM.POP.TOTL' AND countrynotes.description = 'Estimates are derived from data on foreign-born population.';
SELECT footnotes.description FROM footnotes JOIN country ON footnotes.countrycode = country.countrycode JOIN series ON footnotes.seriescode = series.seriescode WHERE series.seriescode = 'AG.LND.FRST.K2' AND footnotes.year = 1990 AND country.shortname = 'Aruba'; 
SELECT footnotes.year FROM footnotes JOIN country ON footnotes.countrycode = country.countrycode JOIN series ON footnotes.seriescode = series.seriescode WHERE country.shortname = 'Aruba' AND series.seriescode = 'AG.LND.FRST.K2'; 
SELECT country.countryname FROM country JOIN footnotes ON country.countrycode = footnotes.countrycode JOIN series ON footnotes.seriescode = series.seriescode WHERE footnotes.description = 'Data are classified as official aid' AND series.seriescode = 'DC.DAC.AUSL.CD' AND footnotes.year = 2002;
SELECT COUNT(footnotes.description) FROM     footnotes JOIN     country ON footnotes.countrycode = country.countrycode JOIN     series ON footnotes.seriescode = series.seriescode WHERE     country.shortname = 'Aruba' AND     footnotes.year = 2002;
SELECT COUNT(DISTINCT footnotes.year) FROM     country     JOIN footnotes ON country.countrycode = footnotes.countrycode     JOIN series ON footnotes.seriescode = series.seriescode WHERE     country.shortname = 'Aruba'     AND series.seriescode = 'BX.KLT.DINV.CD.WD';
SELECT AVG(indicators.value) AS average_adolescent_fertility_rate FROM     indicators JOIN     country ON indicators.countrycode = country.countrycode JOIN     series ON indicators.indicatorcode = series.seriescode WHERE     country.alpha2code = '1A' AND     series.indicatorname LIKE 'adolescent fertility rate%'
SELECT country.specialnotes FROM country JOIN (     SELECT    countrycode,     AVG(value) AS avg_adolescent_fertility_rate     FROM     indicators     WHERE     indicatorname LIKE 'adolescent fertility rate%'     GROUP BY     countrycode     ORDER BY     avg_adolescent_fertility_rate DESC     LIMIT 1 ) AS max_avg_af ON country.countrycode = max_avg_af.countrycode;
SELECT country.alpha2code FROM country WHERE country.region = 'East Asia & Pacific' AND country.incomegroup = 'High income: nonOECD';
SELECT country.longname, country.alpha2code FROM country JOIN indicators ON country.countrycode = indicators.countrycode JOIN series ON country.countrycode = series.countrycode WHERE indicators.indicatorname = 'Trade Data' AND indicators.year = 2013 AND series.indicatorname = 'Water Withdrawal Data' AND series.year = 2013;
SELECT AVG(value)  FROM      indicators  WHERE      countrycode = (SELECT countrycode FROM country WHERE countryname = 'Algeria')      AND indicatorname = 'Adjusted net enrolment rate, primary, both sexes (%)'      AND year BETWEEN 1975 AND 1980;
SELECT indicatorname, aggregationmethod FROM series WHERE topic = 'Economic Policy & Debt' AND shortdefinition LIKE '%Balance of payments: Capital & financial account%'; 
SELECT series.seriescode, country.alpha2code FROM series JOIN country ON country.countrycode = indicators.countrycode WHERE series.topic = 'Environment: Emissions' AND series.licensetype = 'Restricted'; 
SELECT COUNT(country.countrycode) FROM     country JOIN     indicators ON country.countrycode = indicators.countrycode JOIN     series ON indicators.indicatorname = series.indicatorname WHERE     year = 1970     AND region = 'Middle East & North Africa'     AND indicatorname = 'CO2 emissions from gaseous fuel consumption (kt)'     AND value > 600;
SELECT country.countrycode, country.longname, MAX(indicators.value) AS highest_value, indicators.year FROM country JOIN indicators ON country.countrycode = indicators.countrycode WHERE country.region IN ('Latin America', 'Caribbean') AND indicators.indicatorname = 'CO2 emissions from gaseous fuel consumption (kt)' AND indicators.year > 1965 GROUP BY country.countrycode ORDER BY AVG(indicators.value) DESC LIMIT 3; 
SELECT seriesnotes.description FROM series JOIN seriesnotes ON series.seriescode = seriesnotes.seriescode WHERE series.seriescode = 'SP.DYN.TO65.MA.ZS' AND series.topic = 'Health: Mortality' AND seriesnotes.year = 'YR1967';
SELECT footnotes.description FROM     footnotes JOIN     country ON footnotes.countrycode = country.countrycode WHERE     country.countryname = 'Albania'     AND footnotes.year = 1981;
SELECT footnotes.description FROM     footnotes JOIN     country ON footnotes.countrycode = country.countrycode JOIN     series ON footnotes.seriescode = series.seriescode WHERE     country.countryname = 'The Bahamas'     AND series.seriescode = 'SH.DTH.IMRT'     AND footnotes.year = 1984;
SELECT country.shortname FROM country JOIN indicators ON country.countrycode = indicators.countrycode JOIN series ON indicators.indicatorname = series.indicatorname WHERE series.indicatorname = 'Net bilateral aid flows from DAC donors, Sweden (current US$)' AND indicators.year = 1970 AND indicators.value > 570000;
SELECT country.wb2code, country.lendingcategory FROM country JOIN countrynotes ON country.countrycode = countrynotes.countrycode WHERE countrynotes.description = 'Data source : Human Mortality Database by University of California, Berkeley, and Max Planck Institute for Demographic Research.';
SELECT series.topic, series.seriescode, series.licensetype FROM     series JOIN     indicators ON series.seriescode = indicators.indicatorcode JOIN     country ON indicators.countrycode = country.countrycode WHERE     country.countryname = 'Haiti'     AND indicators.year = 1961     AND indicators.value = 3000000     AND indicators.indicatorname = 'Total reserves minus gold (current US$)';
SELECT COUNT(DISTINCT country.countrycode) FROM country JOIN indicators ON country.countrycode = indicators.countrycode LEFT JOIN footnotes ON country.countrycode = footnotes.countrycode AND indicators.seriescode = footnotes.seriescode WHERE indicators.indicatorname = 'Adjusted net national income per capita (constant 2005 US$)' AND indicators.value > 1000 AND country.externaldebtreportingstatus = 'Preliminary';
SELECT country.countryname FROM country JOIN indicators ON country.countrycode = indicators.countrycode WHERE indicators.indicatorname = 'Fertility rate, total (births per woman)' AND indicators.value BETWEEN 4 AND 5 AND indicators.year = 1979;
SELECT country.longname, country.tablename, country.sourceofmostrecentincomeandexpendituredata FROM country WHERE country.region = 'South Asia' AND country.incomegroup = 'Low income';
SELECT country.longname AS Country, country.sourceofmostrecentincomeandexpendituredata AS Source FROM country JOIN indicators ON country.countrycode = indicators.countrycode WHERE country.region = 'Latin America & Caribbean' AND indicators.indicatorname = 'Out-of-school children of primary school age, both sexes (number)';
SELECT source FROM     indicators WHERE     countryname LIKE '%South America%'     AND year = '2002'     AND indicatorname = 'Net migration';
SELECT country.longname AS Country, country.alpha2code AS Country_Code, series.source AS Source FROM country JOIN indicators ON country.countrycode = indicators.countrycode JOIN series ON indicators.indicatorcode = series.seriescode WHERE country.region = 'North America' AND series.indicatorname = 'Out-of-school children of primary school age, both sexes (number)';
SELECT country.countrycode, country.longname, indicators.value AS gdp_growth_2014 FROM country JOIN indicators ON country.countrycode = indicators.countrycode WHERE indicators.indicatorname = 'GDP growth (annual %)' AND indicators.year = 2014 AND country.latesttradedata = 2013 ORDER BY gdp_growth_2014 ASC;
SELECT country.countryname, indicators.value, series.shortdefinition, source.description FROM country JOIN indicators ON country.countrycode = indicators.countrycode JOIN series ON indicators.indicatorname = series.indicatorname JOIN source ON series.seriescode = source.seriescode WHERE indicators.year = 2005 AND series.indicatorname = 'Out-of-pocket health expenditure (% of private expenditure on health)' AND source.description IS NOT NULL AND country.region = 'Europe' ORDER BY indicators.value DESC LIMIT 10; 
SELECT COUNT(DISTINCT country.countrycode) FROM country WHERE country.region = 'South Asia' AND country.incomegroup = 'Low income';
SELECT country.shortname FROM country JOIN indicators ON country.countrycode = indicators.countrycode WHERE indicators.indicatorname = 'LatestTradeData' AND indicators.value > 2010;
SELECT COUNT(country.CountryCode) * 100.0 / (     SELECT COUNT(country.CountryCode)     FROM country     WHERE country.Region = 'Sub-Saharan Africa' ) AS percentage FROM country WHERE country.Region = 'Sub-Saharan Africa' AND country.SystemOfTrade = 'Special trade system';
SELECT AVG(indicators.value) AS average_arms_imports FROM     indicators JOIN     country ON indicators.countrycode = country.countrycode JOIN     series ON indicators.indicatorname = series.indicatorname WHERE     country.region = 'Europe & Central Asia' AND     series.indicatorname = 'Arms imports (SIPRI trend indicator values)';
SELECT country.countryname FROM country JOIN indicators ON country.countrycode = indicators.countrycode JOIN series ON indicators.indicatorcode = series.seriescode WHERE country.incomegroup = 'Upper middle income' AND series.indicatorname = 'CO2 emissions (kt)' AND indicators.value = (     SELECT MIN(value)     FROM indicators     JOIN country ON indicators.countrycode = country.countrycode     JOIN series ON indicators.indicatorcode = series.seriescode     WHERE country.incomegroup = 'Upper middle income'     AND series.indicatorname = 'CO2 emissions (kt)' );
SELECT MIN(indicators.value) FROM     indicators JOIN     country ON indicators.countrycode = country.countrycode JOIN     series ON indicators.indicatorname = series.indicatorname WHERE     series.othergroups LIKE '%HIPC%'     AND series.indicatorname = 'International migrant stock, total';
SELECT indicatorname FROM series JOIN indicators ON series.seriescode = indicators.indicatorcode WHERE series.topic = 'Education: Inputs' AND indicators.year = 'YR2000'; 
SELECT COUNT(indicators.indicatorname) FROM     indicators JOIN     series ON indicators.indicatorcode = series.seriescode WHERE     series.aggregationmethod = 'Sum'     AND indicators.periodicity = 'Annual'     AND (indicators.year = 'YR2001' OR indicators.year = 'YR2002' OR indicators.year = 'YR2003');
SELECT series.seriescode FROM series JOIN indicators ON series.seriescode = indicators.seriescode WHERE indicators.source LIKE '%International Monetary Fund, Balance of Payments Statistics Yearbook and data files%' AND indicators.year = '2005';
SELECT COUNT(DISTINCT country.countrycode) * 100.0 / (     SELECT COUNT(DISTINCT country.countrycode)     FROM country     WHERE region = 'South Asia' ) AS percentage FROM country JOIN indicators ON country.countrycode = indicators.countrycode WHERE indicators.indicatorname = 'Life expectancy at birth, female (years)' AND indicators.value > 50 AND country.region = 'South Asia';
SELECT MAX(indicators.value) AS max_death_rate, country.countryname FROM indicators JOIN country ON indicators.countrycode = country.countrycode JOIN series ON indicators.indicatorname = series.indicatorname WHERE series.indicatorname = 'Death rate, crude (per 1,000 people)' AND indicators.year BETWEEN '1960' AND '1965' GROUP BY country.countryname ORDER BY max_death_rate DESC LIMIT 1;
SELECT indicatorname FROM indicators WHERE countryname = 'Arab World' AND year = '1960' AND value > 50;
SELECT MAX(indicators.value) AS max_value, country.countryname AS country_with_highest_imports FROM indicators JOIN country ON indicators.countrycode = country.countrycode WHERE indicators.indicatorname = 'Merchandise imports by the reporting economy (current US$)';
SELECT indicatorname FROM indicators WHERE periodicity = 'Annual' AND value > 100 AND year = '1965'; 
SELECT indicatorname FROM indicators INNER JOIN series ON indicators.indicatorcode = series.seriescode WHERE year BETWEEN '1968' AND '1970' AND licensetype = 'open' AND value < 100;
SELECT country.countryname, series.indicatorname FROM country JOIN indicators ON country.countrycode = indicators.countrycode JOIN series ON indicators.indicatorcode = series.seriescode WHERE series.topic = 'Private Sector & Trade: Exports' AND indicators.value = (SELECT MAX(value) FROM indicators WHERE series.topic = 'Private Sector & Trade: Exports');
SELECT indicatorname FROM indicators JOIN series ON indicators.indicatorcode = series.seriescode WHERE aggregationmethod = 'Weighted average' ORDER BY value ASC LIMIT 1; 
SELECT indicatorname FROM indicators WHERE countryname = 'Sudan' AND periodicity = 'Annual' AND year = '1961';
SELECT MIN(indicators.value) AS min_value, country.countryname AS country FROM indicators JOIN country ON indicators.countrycode = country.countrycode JOIN series ON indicators.indicatorcode = series.seriescode WHERE series.topic = 'Health: Population: Structure' AND indicators.year BETWEEN 1960 AND 1965 GROUP BY country.countryname ORDER BY min_value LIMIT 1;
SELECT COUNT(DISTINCT country.countrycode) * 100.0 /      (SELECT COUNT(DISTINCT country.countrycode)     FROM country     WHERE country.incomegroup = 'Upper middle income') FROM country JOIN indicators ON country.countrycode = indicators.countrycode JOIN series ON indicators.indicatorname = 'CO2 emissions from liquid fuel consumption (% of total)'     AND series.seriescode = indicators.indicatorcode WHERE indicators.value < 80 AND country.incomegroup = 'Upper middle income';
SELECT indicators.indicatorcode FROM indicators JOIN series ON indicators.seriescode = series.seriescode WHERE series.indicatorname = 'Rural population';
SELECT COUNT(country.tablename), country.tablename FROM country WHERE country.systemofnationalaccounts = '2008' 
SELECT DISTINCT series.seriescode FROM country JOIN indicators ON country.countrycode = indicators.countrycode JOIN series ON indicators.indicatorcode = series.seriescode WHERE country.currencyunit = 'Euro'; 
SELECT country.longname FROM country JOIN indicators ON country.countrycode = indicators.countrycode JOIN series ON indicators.indicatorcode = series.seriescode WHERE series.seriescode = 'DT.DOD.DSTC.CD'; 
SELECT series.seriescode FROM country JOIN indicators ON country.countrycode = indicators.countrycode JOIN series ON indicators.indicatorcode = series.seriescode WHERE country.currencyunit = 'Hong Kong dollar';
SELECT country 
SELECT country.longname FROM country WHERE country.incomegroup = 'Low income';
SELECT series.seriescode, country.countrycode FROM country JOIN indicators ON country.countrycode = indicators.countrycode JOIN series ON indicators.indicatorcode = series.seriescode WHERE country.region = 'Latin America & Caribbean' AND country.incomegroup = 'Low income';
SELECT series.seriescode FROM country JOIN indicators ON country.countrycode = indicators.countrycode JOIN series ON indicators.indicatorcode = series.seriescode WHERE country.currencyunit = 'Australian dollar' AND country.incomegroup = 'Low middle income';
SELECT country.longname, country.region FROM country WHERE country.incomegroup = 'Upper middle income' AND country.nationalaccountsbaseyear = (     SELECT MIN(nationalaccountsbaseyear)     FROM country     WHERE incomegroup = 'Upper middle income' );
SELECT country.countrycode, country.longname FROM country WHERE country.currencyunit = 'Euro' AND country.incomegroup = 'High income'
SELECT country.tablename, country.currencyunit FROM country JOIN indicators ON country.countrycode = indicators.countrycode JOIN series ON indicators.seriescode = series.seriescode WHERE series.seriescode = 'FP.CPI.TOTL'; 
SELECT country.longname, indicators.indicatorcode FROM country JOIN indicators ON country.countrycode = indicators.countrycode WHERE country.incomegroup = 'High income: nonOECD'
SELECT series.seriescode FROM country JOIN indicators ON country.countrycode = indicators.countrycode JOIN series ON indicators.indicatorcode = series.seriescode WHERE country.currencyunit = 'pound sterling' AND country.incomegroup = 'High income'
SELECT country.countrycode, country.shortname FROM country LIMIT 10; 
SELECT COUNT(country.shortname) AS number_of_countries, GROUP_CONCAT(country.alpha2code) AS alpha2codes FROM country WHERE country.shortname LIKE 'A%';
SELECT country.tablename FROM country WHERE country.currencyunit = 'Euro';
SELECT COUNT(country.longname) FROM country WHERE country.specialnotes IS NULL;
SELECT country.shortname FROM country WHERE country.region = 'Asia' AND country.incomegroup = 'High income'
SELECT country.longname FROM country WHERE country.nationalaccountsbaseyear < 1980;
SELECT country.countrycode FROM country JOIN indicators ON country.countrycode = indicators.countrycode WHERE country.incomegroup = 'Low income' AND indicators.seriescode = 'DT.DOD.DECT.CD';
SELECT country.countrycode 
SELECT series.shortdefinition, series.seriescode FROM country JOIN countrynotes ON country.countrycode = countrynotes.countrycode JOIN series ON countrynotes.seriescode = series.seriescode WHERE country.shortname = 'Benin' AND countrynotes.description = 'YR2005';
SELECT footnotes.description FROM footnotes JOIN country ON footnotes.countrycode = country.countrycode JOIN series ON footnotes.seriescode = series.seriescode WHERE country.shortname = 'Finland' AND series.year = 'YR2000';
SELECT DISTINCT country.tablename, indicators.year FROM country JOIN indicators ON country.countrycode = indicators.countrycode JOIN series ON indicators.indicatorname = series.indicatorname WHERE series.indicatorname = 'Air transport, passengers carried'; 
SELECT country.longname FROM country INNER JOIN indicators ON country.countrycode = indicators.countrycode WHERE indicators.year = '1980'
SELECT currencyunit FROM country WHERE country.countrycode = 'MYS';  SELECT DISTINCT indicators.indicatorcode FROM indicators JOIN country ON indicators.countrycode = country.countrycode WHERE country.countryname = 'Malaysia' AND indicators.year = '1970';
SELECT country.countrycode, country.region FROM indicators JOIN country ON indicators.countrycode = country.countrycode WHERE indicators.value = (     SELECT MAX(value)     FROM indicators ) LIMIT 5; 
SELECT COUNT(DISTINCT country.countrycode) AS num_countries, country.currencyunit AS currency FROM country JOIN countrynotes ON country.countrycode = countrynotes.countrycode WHERE countrynotes.description = "Sources: UN Energy Statistics (2014)" GROUP BY country.currencyunit;
SELECT COUNT(footnotes.description) AS footnote_count, GROUP_CONCAT(DISTINCT country.tablename) AS country_table_names FROM footnotes JOIN country ON footnotes.countrycode = country.countrycode WHERE footnotes.year = 'YR1980';
SELECT series.seriescode, country.wb2code FROM country JOIN countrynotes ON country.countrycode = countrynotes.countrycode JOIN series ON countrynotes.seriescode = series.seriescode WHERE countrynotes.description = "Data sources : Eurostat"; 
SELECT country.countryname FROM country JOIN indicators ON country.countrycode = indicators.countrycode JOIN series ON indicators.indicatorname = series.indicatorname WHERE country.incomegroup = 'Low income' AND series.shortdefinition = 'Adolescent fertility rate (births per 1,000 women ages 15-19)' AND indicators.value = (     SELECT    MIN(value)     FROM     indicators     JOIN     country ON indicators.countrycode = country.countrycode     WHERE     country.incomegroup = 'Low income'     AND     series.shortdefinition = 'Adolescent fertility rate (births per 1,000 women ages 15-19)' ) 
SELECT SUM(indicators.value) AS total_urban_population FROM     indicators JOIN     country ON indicators.countrycode = country.countrycode JOIN     series ON indicators.indicatorname = series.indicatorname WHERE     country.incomegroup = 'Middle income'     AND indicators.year = 1960     AND series.topic = 'Urban population'
SELECT country.longname AS country_name, country.currencyunit AS currency_used FROM indicators JOIN country ON indicators.countrycode = country.countrycode WHERE indicators.indicatorname = 'Adjusted net national income (annual % growth)' AND indicators.year = '1980' AND indicators.value = (SELECT MAX(value) FROM indicators WHERE indicatorname = 'Adjusted net national income (annual % growth)' AND year = '1980');
SELECT COUNT(DISTINCT country.countrycode) FROM country WHERE country.systemofnationalaccounts = '1993 System of National Accounts methodology';
SELECT country.shortname FROM country WHERE country.vitalregistrationcomplete = 'Yes';
SELECT country.ShortName || ' ' || country.LongName AS CountryName FROM country INNER JOIN indicators ON country.countrycode = indicators.countrycode WHERE indicators.latestpopulationcensus BETWEEN '2010' AND '2012' AND country.vitalregistrationcomplete = 'Yes';
SELECT MAX(indicators.value) AS max_co2_emissions,     country.countryname AS country_with_highest_co2_emissions FROM     indicators JOIN     country ON indicators.countrycode = country.countrycode JOIN     series ON indicators.seriescode = series.seriescode WHERE     indicators.year = '1960'     AND series.indicatorname = 'CO2 emissions (metric tons per capita)'
SELECT MAX(value) AS highest_infant_deaths, MIN(value) AS lowest_infant_deaths, MAX(value) / MIN(value) AS infant_death_ratio FROM indicators WHERE indicatorname = 'Number of infant deaths' AND year = '1971';
SELECT country.ShortName FROM country JOIN indicators ON country.countrycode = indicators.countrycode JOIN series ON indicators.indicatorcode = series.seriescode WHERE series.seriescode = 'SP.DYN.CBRT.IN';
SELECT country.ShortName FROM country INNER JOIN countrynotes ON country.countrycode = countrynotes.countrycode INNER JOIN series ON countrynotes.seriescode = series.seriescode WHERE countrynotes.description = 'Data are classified as official aid.';
SELECT country.longname FROM country JOIN countrynotes ON country.countrycode = countrynotes.countrycode JOIN series ON countrynotes.seriescode = series.seriescode WHERE countrynotes.description = 'Estimates are based on regression.';
SELECT country.LongName FROM country JOIN indicators ON country.countrycode = indicators.countrycode JOIN series ON indicators.indicatorcode = series.seriescode WHERE country.Region = 'East Asia & Pacific' AND indicators.indicatorname = 'Urban population' AND indicators.year = '1970' AND indicators.value > 2000000;
SELECT MAX(value) AS largest_population FROM indicators JOIN country ON indicators.countrycode = country.countrycode WHERE year = '1960'  AND incomegroup = 'Upper middle income' AND indicatorname = 'Population, total';
SELECT COUNT(country.countrycode) FROM country WHERE systemofnationalaccounts = '1968 System of National Accounts methodology';
SELECT country.shortname FROM country JOIN indicators ON country.countrycode = indicators.countrycode JOIN series ON indicators.indicatorname = series.indicatorname WHERE country.incomegroup = 'Upper middle income' AND country.region = 'East Asia & Pacific' AND series.topic = 'Social Protection & Labor: Migration';
SELECT country.longname FROM country JOIN countrynotes ON country.countrycode = countrynotes.countrycode JOIN series ON countrynotes.seriescode = series.seriescode WHERE series.topic = 'Poverty: Shared Prosperity'; 
SELECT country.tablename FROM country JOIN indicators ON country.countrycode = indicators.countrycode WHERE indicators.indicatorcode = 'SP.DYN.CDRT.IN' AND indicators.year = '2013';
SELECT country.longname FROM country JOIN indicators ON country.countrycode = indicators.countrycode WHERE indicators.indicatorcode = "SP.DYN.AMRT.FE" AND country.region = "Sub-Saharan Africa"; 
SELECT COUNT(DISTINCT currencyunit) AS num_countries_same_currency, GROUP_CONCAT(DISTINCT shortname) AS three_countries FROM country GROUP BY currencyunit HAVING num_countries_same_currency > 3;
SELECT country.longname FROM country WHERE region = 'South Asia' AND incomegroup = 'Low income';
SELECT country.longname FROM country WHERE country.systemoftrade = 'Special trade system' LIMIT 2;
SELECT country.countryname FROM indicators JOIN country ON indicators.countrycode = country.countrycode WHERE indicatorname = 'CO2 emissions from transport (% of total fuel combustion)' AND value = (     SELECT MAX(value)     FROM indicators     WHERE indicatorname = 'CO2 emissions from transport (% of total fuel combustion)' )
SELECT countryname FROM     indicators WHERE     indicatorname = 'Arable land (% of land area)' ORDER BY     value ASC LIMIT 1;
SELECT topic FROM series WHERE licensetype = 'Restricted';
SELECT country.countrycode FROM country JOIN indicators ON country.countrycode = indicators.countrycode WHERE country.incomegroup = 'Upper middle income' AND indicators.externaldebtreportingstatus = 'Preliminary'
SELECT (      (SELECT COUNT(countrycode)       FROM country       WHERE region = 'Middle East & North Africa'       AND ExternalDebtReportingStatus = 'Actual')      * 100.0 /      (SELECT COUNT(countrycode)       FROM country       WHERE region = 'Middle East & North Africa') ) AS percentage_countries_finished_reporting_external_debt;
SELECT COUNT(*) AS government_count,     SystemOfGovernmentAccountingConcept FROM     Country WHERE     ExternalDebtReportingStatus = 'Actual' GROUP BY     SystemOfGovernmentAccountingConcept;
SELECT COUNT(DISTINCT country.countrycode) FROM     country JOIN     footnotes ON country.countrycode = footnotes.countrycode JOIN     series ON footnotes.seriescode = series.seriescode WHERE     region = 'East Asia & Pacific'     AND externaldebtreportingstatus = 'Estimate';
SELECT 100 * (     SELECT         COUNT(DISTINCT c.countrycode)      FROM          country c     WHERE          c.region = 'Sub-Saharan Africa'          AND c.incomegroup = 'Lower middle income' ) / (     SELECT         COUNT(DISTINCT c.countrycode)      FROM          country c     WHERE          c.region = 'Sub-Saharan Africa' ) AS proportion_of_lower_middle_income_countries
SELECT MAX(value) AS highest_percentage_of_agricultural_land FROM     indicators WHERE     indicatorname = 'Agricultural land (% of land area)'     AND countryname = 'Republic of Benin'     AND year BETWEEN 1961 AND 1980;
SELECT country.longname FROM country JOIN countrynotes ON country.countrycode = countrynotes.countrycode JOIN series ON countrynotes.seriescode = series.seriescode WHERE series.description = 'UN Energy Statistics (2014)'
SELECT indicators.value FROM indicators JOIN country ON indicators.countrycode = country.countrycode JOIN series ON indicators.indicatorname = series.indicatorname WHERE country.longname = 'Commonwealth of Australia' AND series.topic = 'Interest rates' AND indicators.year = 1979;
SELECT series.seriescode, seriesnotes.description FROM country JOIN countrynotes ON country.countrycode = countrynotes.countrycode JOIN series ON countrynotes.seriescode = series.seriescode JOIN seriesnotes ON series.seriescode = seriesnotes.seriescode WHERE country.shortname = 'Germany';
SELECT topic FROM series WHERE series.shortname = 'Austria';
SELECT topic, description FROM series WHERE seriescode = 'SP.DYN.AMRT.MA';
SELECT COUNT(DISTINCT country.LongName) AS CountryCount,     country.LongName FROM     country JOIN     footnotes ON country.countrycode = footnotes.countrycode JOIN     series ON footnotes.seriescode = series.seriescode WHERE     footnotes.description = 'Not specified' GROUP BY     country.LongName;
SELECT country.countryname FROM country JOIN indicators ON country.countrycode = indicators.countrycode WHERE indicators.year = 1980 AND indicators.value = 3018500 AND country.externaldebtreportingstatus = 'Actual';
SELECT COUNT(CountryName) * 100.0 / COUNT(*) FROM     indicators JOIN     country ON indicators.countrycode = country.countrycode JOIN     series ON indicators.indicatorcode = series.seriescode WHERE     country.region = 'Latin America & Caribbean'     AND series.indicatorname = 'Agricultural land (% of land area)'     AND indicators.year = '1961'     AND indicators.value > 50;
SELECT country.longname FROM country WHERE country.region = 'South Asia' AND country.incomegroup = 'Low income';
SELECT indicators.indicatorcode FROM indicators JOIN country ON indicators.countrycode = country.countrycode WHERE country.countryname = 'Brazil' AND indicators.indicatorname = 'Mobile cellular subscriptions';
SELECT COUNT(country.longname) AS country_count, GROUP_CONCAT(country.longname, ', ') AS country_names FROM country WHERE country.region = 'Europe & Central Asia'  AND country.currencyunit = 'Danish krone';
SELECT country.countryname, MAX(indicators.value) AS rural_population_percentage FROM country JOIN indicators ON country.countrycode = indicators.countrycode WHERE indicators.indicatorname = 'Rural population (% of total population)'
SELECT COUNT(*) AS "Number of Countries", LongName AS "Full Name" FROM country WHERE LatestPopulationCensus = '2011';
SELECT agricultural land area FROM indicators JOIN country ON indicators.countrycode = country.countrycode JOIN series ON indicators.indicatorcode = series.seriescode WHERE country.countryname = 'Italy' AND indicators.year = '1968' AND series.indicatorname = 'Agricultural land (sq. km)';
SELECT COUNT(indicators.value), MAX(indicators.year) FROM country JOIN indicators ON country.countrycode = indicators.countrycode JOIN series ON indicators.indicatorcode = series.seriescode WHERE country.region = 'Sub-Saharan Africa' AND series.indicatorname = 'Out-of-school children of primary school age, female (number)' AND indicators.value = (SELECT MAX(value) FROM indicators WHERE series.indicatorname = 'Out-of-school children of primary school age, female (number)')
SELECT series.seriescode FROM indicators JOIN country ON indicators.countrycode = country.countrycode JOIN series ON indicators.indicatorname = series.indicatorname AND indicators.year = '1965' AND country.longname = 'Islamic State of Afghanistan' AND indicators.value = 'Number of infant deaths'
SELECT COUNT(country.countrycode) FROM country JOIN indicators ON country.countrycode = indicators.countrycode WHERE country.systemofnationalaccounts = '1968 System of National Accounts methodology' AND country.region = 'Middle East & North Africa';  SELECT country.countryname FROM country JOIN indicators ON country.countrycode = indicators.countrycode WHERE indicators.indicatorname = 'CO2 emissions from solid fuel consumption (kt)' ORDER BY indicators.value DESC LIMIT 1;
SELECT indicatorcode FROM indicators JOIN country ON indicators.countrycode = country.countrycode WHERE country.longname = 'Republic of Albania' AND indicators.year = '1960';
SELECT      lendingcategory FROM     country JOIN     indicators ON country.countrycode = indicators.countrycode JOIN     series ON indicators.indicatorcode = series.seriescode WHERE     indicatorname = 'Cereal production (metric tons)'     AND value = 6140000     AND year = '1966';
SELECT country.countryname, country.region FROM indicators JOIN country ON indicators.countrycode = country.countrycode WHERE indicators.indicatorname = 'Population in largest city' AND indicators.year BETWEEN '1960' AND '1979' AND indicators.value = (     SELECT MAX(value)     FROM indicators     WHERE indicatorname = 'Population in largest city'     AND year BETWEEN '1960' AND '1979' )
SELECT SUM(value) AS total_CO2_emission_kiloton, MAX(value) AS highest_CO2_emission, year FROM indicators WHERE indicatorname LIKE 'CO2%' AND year BETWEEN 1975 AND 1980;
SELECT country.countryname, MIN(indicators.value) AS min_land_area, country.incomegroup FROM indicators JOIN country ON indicators.countrycode = country.countrycode JOIN series ON indicators.indicatorcode = series.seriescode WHERE series.indicatorname LIKE 'Land area (sq. km)' AND indicators.year BETWEEN 1961 AND 1979 GROUP BY country.countryname ORDER BY min_land_area ASC LIMIT 1;
SELECT AVG(value) AS average_passengers_carried, systemoftrade FROM indicators JOIN country ON indicators.countrycode = country.countrycode JOIN series ON indicators.indicatorcode = series.seriescode WHERE country.countryname = 'Bulgaria' AND series.indicatorname = 'Air transport, passengers carried' AND indicators.year BETWEEN 1970 AND 1980;
SELECT latesthouseholdsurvey, latesthouseholdsurveyyear FROM country WHERE shortname = 'Angola';
SELECT COUNT(country.countrycode) FROM country WHERE country.region = 'North America' AND country.vitalregistrationcomplete = 'Yes';
SELECT DISTINCT indicators.year FROM     indicators JOIN     country ON indicators.countrycode = country.countrycode JOIN     series ON indicators.indicatorname = series.indicatorname WHERE     country.alpha2code = '1A'     AND series.indicatorname = 'Adolescent fertility rate (births per 1,000 women ages 15-19)';
SELECT country.longname FROM country JOIN indicators ON country.countrycode = indicators.countrycode JOIN series ON indicators.indicatorcode = series.seriescode WHERE indicators.indicatorname = 'Arms exports (SIPRI trend indicator values)' AND indicators.year = 1960 AND indicators.value = 3000000;
SELECT country.alpha2code FROM indicators JOIN country ON indicators.countrycode = country.countrycode JOIN series ON indicators.indicatorcode = series.seriescode WHERE indicators.year = '1960' AND series.indicatorname = 'Rural population';
SELECT country.longname, country.specialnotes FROM indicators JOIN country ON indicators.countrycode = country.countrycode WHERE indicators.indicatorname = 'Adolescent fertility rate (births per 1,000 women ages 15-19)' AND indicators.year = '1960' AND indicators.value = (SELECT MAX(value) FROM indicators WHERE indicatorname = 'Adolescent fertility rate (births per 1,000 women ages 15-19)' AND year = '1960');
SELECT SUM(indicators.value) AS increase FROM     indicators JOIN     country ON indicators.countrycode = country.countrycode JOIN     series ON indicators.indicatorname = series.indicatorname WHERE     country.alpha2code = '1A'     AND series.indicatorname = 'Adolescent fertility rate (births per 1,000 women ages 15-19)%'     AND indicators.year = 1961     OR indicators.year = 1960
SELECT description FROM     countrynotes JOIN     country ON countrynotes.countrycode = country.countrycode JOIN     series ON countrynotes.seriescode = series.seriescode WHERE     country.shortname = 'Australia'     AND series.seriescode = 'SP.ADO.TFRT';
SELECT country.shortname, indicators.indicatorname, countrynotes.description FROM country JOIN indicators ON country.countrycode = indicators.countrycode JOIN series ON indicators.indicatorcode = series.seriescode JOIN countrynotes ON country.countrycode = countrynotes.countrycode JOIN seriesnotes ON series.seriescode = seriesnotes.seriescode WHERE country.shortname = 'Aruba' AND series.topic = 'Environment: Energy production & use';
SELECT country.countryname FROM country INNER JOIN countrynotes ON country.countrycode = countrynotes.countrycode INNER JOIN series ON countrynotes.seriescode = series.seriescode WHERE series.seriescode = 'BX.KLT.DINV.CD.WD';
SELECT country.region FROM country JOIN countrynotes ON country.countrycode = countrynotes.countrycode JOIN series ON countrynotes.seriescode = series.seriescode WHERE series.indicatorname = 'Inflation, consumer prices (annual %)';
SELECT COUNT(DISTINCT country.countrycode) AS num_countries FROM     country JOIN     countrynotes ON country.countrycode = countrynotes.countrycode JOIN     series ON countrynotes.seriescode = series.seriescode WHERE     series.indicatorname = 'Stocks traded, turnover ratio of domestic shares (%)';
SELECT aggregationmethod FROM     indicators JOIN     country ON     indicators.countrycode = country.countrycode JOIN     series ON     indicators.indicatorcode = series.seriescode WHERE     indicators.value = 133     AND indicators.year = 1960     AND country.countryname = 'Arab World';
SELECT   indicators.value FROM indicators JOIN series ON indicators.indicatorcode = series.seriescode JOIN country ON indicators.countrycode = country.countrycode WHERE series.longdefinition = "Adolescent fertility rate is the number of births per 1,000 women ages 15-19." AND country.countryname = 'Arab World' AND indicators.year = 1960; 
SELECT   ((SELECT SUM(value) FROM indicators WHERE indicatorname = 'Adolescent fertility rate (births per 1,000 women ages 15-19)%' AND year = 1961 AND countrycode = (SELECT countrycode FROM country WHERE alpha2code = '1A')) - (SELECT SUM(value) FROM indicators WHERE indicatorname = 'Adolescent fertility rate (births per 1,000 women ages 15-19)%' AND year = 1960 AND countrycode = (SELECT countrycode FROM country WHERE alpha2code = '1A'))) /  (SELECT SUM(value) FROM indicators WHERE indicatorname = 'Adolescent fertility rate (births per 1,000 women ages 15-19)%' AND year = 1960 AND countrycode = (SELECT countrycode FROM country WHERE alpha2code = '1A'))) * 100; 
SELECT AVG(value) FROM     indicators WHERE     countrycode = (SELECT countrycode FROM country WHERE alpha2code = '1A')     AND indicatorname = 'Adolescent fertility rate (births per 1,000 women ages 15-19)';
SELECT DISTINCT directors.directorid FROM directors JOIN movies2directors ON directors.directorid = movies2directors.directorid JOIN u2base ON movies2directors.movieid = u2base.movieid WHERE u2base.rating > 4; 
SELECT COUNT(*) FROM     u2base JOIN     users ON u2base.userid = users.userid WHERE     rating = 5     AND u_gender = 'M';
SELECT DISTINCT m2d.genre FROM movies2actors m2a JOIN movies2directors m2d ON m2a.movieid = m2d.movieid WHERE m2a.actorid = 851; 
SELECT COUNT(*)  FROM      movies  JOIN      u2base ON movies.movieid = u2base.movieid  WHERE      movies.country = 'USA' AND u2base.rating < 3;
SELECT COUNT(*) FROM     movies WHERE     country = 'France'     AND genre = 'drama';
SELECT AVG(occupation) FROM users WHERE userid IN (SELECT userid FROM u2base WHERE rating <= 2);
SELECT movies.movieid, movies.year, movies.runningtime FROM movies WHERE movies.country = 'USA' ORDER BY u2base.rating DESC LIMIT 10; 
SELECT AVG(cast_num) FROM movies JOIN movies2actors ON movies.movieid = movies2actors.movieid WHERE country = 'USA';
SELECT movies.movieid, movies.year, movies.country, movies.runningtime FROM movies WHERE movies.isEnglish = 'F' ORDER BY movies.runningtime DESC LIMIT 5;
SELECT COUNT(*)  FROM actors  WHERE a_quality = 'best'  AND actorid IN (     SELECT actorid      FROM movies2actors      JOIN u2base ON movies2actors.movieid = u2base.movieid      WHERE rating = 5 ); 
SELECT AVG(u2base.rating) FROM     u2base JOIN     movies ON u2base.movieid = movies.movieid WHERE     movies.country = 'France'     AND movies.year = (SELECT MAX(year) FROM movies WHERE country = 'France');
SELECT COUNT(*)  FROM movies  JOIN u2base ON movies.movieid = u2base.movieid  WHERE country = 'UK' AND runningtime < 120
SELECT users.userid FROM     users JOIN     u2base ON users.userid = u2base.userid JOIN     movies ON u2base.movieid = movies.movieid WHERE     users.u_gender = 'M'     AND movies.country = 'France'     AND movies.runningtime = 2     AND u2base.rating < 3;
SELECT COUNT(*) FROM actors WHERE a_quality = 0 AND actorid IN (     SELECT actorid     FROM movies2actors     JOIN u2base ON movies2actors.movieid = u2base.movieid     WHERE rating > 3 );
SELECT MAX(userid) AS max_rating_audience_id FROM     u2base WHERE     rating = 5;
SELECT actors.actorid, movies2directors.genre FROM actors JOIN movies2actors ON actors.actorid = movies2actors.actorid JOIN movies2directors ON movies2actors.movieid = movies2directors.movieid WHERE movies2directors.directorid = 22397; 
SELECT actors.actorid FROM actors INNER JOIN movies2actors ON actors.actorid = movies2actors.actorid INNER JOIN movies2directors ON movies2actors.movieid = movies2directors.movieid WHERE movies2directors.genre = 'action'; 
SELECT COUNT(DISTINCT actors.actorid) FROM     actors JOIN     movies2actors ON actors.actorid = movies2actors.actorid JOIN     movies ON movies2actors.movieid = movies.movieid WHERE     movies.year = 4 AND     actors.a_gender = 'F';
SELECT actors.actorid FROM actors JOIN movies2actors ON actors.actorid = movies2actors.actorid JOIN movies ON movies2actors.movieid = movies.movieid WHERE actors.a_quality = 3 AND movies.isenglish = 'T' AND movies.country = 'USA';
SELECT movieid FROM movies JOIN movies2directors ON movies.movieid = movies2directors.movieid JOIN directors ON movies2directors.directorid = directors.directorid WHERE runningtime = 3 AND avg_revenue = 1; 
SELECT genre FROM movies JOIN movies2directors ON movies.movieid = movies2directors.movieid WHERE country = 'UK';
SELECT genre FROM movies2directors AS md JOIN movies AS m ON md.movieid = m.movieid JOIN u2base AS u ON m.movieid = u.movieid WHERE u.age = 18 GROUP BY genre ORDER BY COUNT(*) DESC LIMIT 1;
SELECT actors.actorid FROM     actors JOIN     movies2actors ON actors.actorid = movies2actors.actorid JOIN     movies ON movies2actors.movieid = movies.movieid JOIN     u2base ON movies.movieid = u2base.movieid WHERE     u2base.userid IN (SELECT userid FROM users WHERE occupation = 5) GROUP BY     actors.actorid ORDER BY     COUNT(*) DESC LIMIT 1;
SELECT DISTINCT users.age FROM     users JOIN     u2base ON users.userid = u2base.userid WHERE     u2base.rating = 3;
SELECT directors.country FROM directors JOIN movies2directors ON directors.directorid = movies2directors.directorid JOIN movies ON movies2directors.movieid = movies.movieid WHERE movies.genre = 'Action' GROUP BY directors.country ORDER BY COUNT(*) DESC LIMIT 1; 
SELECT movieid FROM (     SELECT movieid     FROM movies2actors     INNER JOIN actors ON movies2actors.actorid = actors.actorid     ORDER BY a_quality DESC     LIMIT 5 ) AS top_actors; 
SELECT movies.movieid FROM movies JOIN movies2directors ON movies.movieid = movies2directors.movieid JOIN directors ON movies2directors.directorid = directors.directorid WHERE movies.isenglish = 'F' AND movies.country = 'UK' AND movies2directors.genre = 'Adventure' LIMIT 5;
SELECT 100 * (     SELECT COUNT(*)      FROM u2base      JOIN users ON u2base.userid = users.userid      WHERE rating = 2 AND u_gender = 'F' ) / (     SELECT COUNT(*)      FROM u2base      JOIN users ON u2base.userid = users.userid      WHERE rating = 2 ) AS percentage_female_viewers;
SELECT COUNT(CASE WHEN u_gender = 'F' THEN 1 ELSE 0 END) - COUNT(CASE WHEN u_gender = 'M' THEN 1 ELSE 0 END) AS audience_difference FROM movies JOIN u2base ON movies.movieid = u2base.movieid JOIN users ON u2base.userid = users.userid JOIN movies2directors ON movies.movieid = movies2directors.movieid WHERE movies2directors.genre = 'horror'
SELECT genre FROM movies2directors INNER JOIN movies ON movies2directors.movieid = movies.movieid WHERE movies.year = 4 AND movies.isenglish = 'T'; 
SELECT COUNT(*) FROM     movies WHERE     country = 'USA'     AND genre = 'action'     AND isEnglish = 'F';
SELECT COUNT(*) FROM u2base JOIN users ON u2base.userid = users.userid WHERE u_gender = 'M' AND age <= 18 AND rating = (SELECT MAX(rating) FROM u2base)
SELECT movies.movieid FROM movies JOIN u2base ON movies.movieid = u2base.movieid JOIN users ON u2base.userid = users.userid WHERE users.u_gender = 'F' GROUP BY movies.movieid ORDER BY COUNT(*) DESC LIMIT 1;
SELECT COUNT(movies.movieid) FROM     movies JOIN     movies2directors ON movies.movieid = movies2directors.movieid JOIN     directors ON movies2directors.directorid = directors.directorid JOIN     u2base ON movies.movieid = u2base.movieid WHERE     movies.country = 'UK' AND     movies.isenglish = 1 AND     movies.year >= 2014 GROUP BY     movies.movieid HAVING     MAX(u2base.rating) >= 9.0
SELECT movieid FROM     movies WHERE     year = 4 AND     movieid IN (SELECT movieid FROM u2base WHERE rating = 1)
SELECT COUNT(*) FROM movies JOIN u2base ON movies.movieid = u2base.movieid WHERE isenglish = 'T' AND year = 1 AND rating = 1;
SELECT COUNT(DISTINCT u.userid) FROM users u JOIN u2base u2 ON u.userid = u2.userid JOIN movies m ON u2.movieid = m.movieid WHERE u.u_gender = 'F' AND m.country = 'France';
SELECT COUNT(DISTINCT directors.directorid) FROM directors JOIN movies2directors ON directors.directorid = movies2directors.directorid WHERE directors.d_quality = 4 AND movies2directors.genre = 'action'
SELECT genre FROM movies2directors WHERE directorid IN (     SELECT directorid     FROM directors     WHERE avg_revenue = (         SELECT MAX(avg_revenue)         FROM directors     ) ); 
SELECT COUNT(DISTINCT movies.movieid) FROM     movies     JOIN movies2actors ON movies.movieid = movies2actors.movieid     JOIN actors ON movies2actors.actorid = actors.actorid WHERE     actors.a_gender = 'M'     AND movies.isenglish = 'T'     AND actors.a_quality = (SELECT MAX(a_quality) FROM actors WHERE a_gender = 'M')
SELECT movies.country FROM movies JOIN movies2actors ON movies.movieid = movies2actors.movieid JOIN actors ON movies2actors.actorid = actors.actorid WHERE actors.a_quality = 0;
SELECT MAX(avg_rating) FROM (     SELECT AVG(u2base.rating) AS avg_rating     FROM u2base     JOIN movies ON u2base.movieid = movies.movieid     JOIN movies2directors ON movies.movieid = movies2directors.movieid     WHERE movies2directors.genre = 'action' AND movies.country = 'USA'     GROUP BY movies.movieid ) AS avg_ratings;
SELECT COUNT(movies.movieid) FROM movies JOIN movies2directors ON movies.movieid = movies2directors.movieid JOIN directors ON movies2directors.directorid = directors.directorid WHERE directors.d_quality = 5 GROUP BY directors.directorid HAVING AVG(u2base.rating) > 3.5;
SELECT m.movieid, AVG(u.rating) AS avg_rating FROM movies m JOIN movies2directors md ON m.movieid = md.movieid JOIN u2base u ON m.movieid = u.movieid WHERE md.genre = 'adventure' GROUP BY m.movieid ORDER BY avg_rating DESC LIMIT 1; 
SELECT COUNT(*) FROM     users JOIN     u2base ON users.userid = u2base.userid WHERE     u2base.movieid = '2462959'     AND users.u_gender = 'F';
SELECT movieid, COUNT(DISTINCT rating) AS distinct_ratings FROM movies JOIN u2base ON movies.movieid = u2base.movieid WHERE runningtime = 0 GROUP BY movieid ORDER BY distinct_ratings DESC LIMIT 1; 
SELECT actors.actorid, u2base.rating FROM actors JOIN movies2actors ON actors.actorid = movies2actors.actorid JOIN u2base ON movies2actors.movieid = u2base.movieid WHERE movies2actors.movieid = 1722327; 
SELECT DISTINCT directors.directorid, directors.d_quality, COUNT(movies2directors.movieid) AS num_films_directed FROM directors JOIN movies2directors ON directors.directorid = movies2directors.directorid WHERE directors.d_quality = 5 GROUP BY directors.directorid ORDER BY num_films_directed DESC;
SELECT COUNT(*) FROM     movies JOIN     movies2directors ON movies.movieid = movies2directors.movieid JOIN     directors ON movies2directors.directorid = directors.directorid JOIN     movies2actors ON movies.movieid = movies2actors.movieid JOIN     actors ON movies2actors.actorid = actors.actorid JOIN     u2base ON movies.movieid = u2base.movieid WHERE     genre = 'drama' AND rating = 3;
SELECT COUNT(DISTINCT movies.movieid) FROM     movies     JOIN u2base ON movies.movieid = u2base.movieid     JOIN users ON u2base.userid = users.userid WHERE     u2base.rating = 5     AND users.age BETWEEN 25 AND 35;
SELECT movies.movieid FROM movies JOIN movies2directors ON movies.movieid = movies2directors.movieid JOIN directors ON movies2directors.directorid = directors.directorid JOIN u2base ON movies.movieid = u2base.movieid WHERE movies2directors.genre = 'horror' AND u2base.rating = 1; 
SELECT directorid FROM directors JOIN movies2directors ON directors.directorid = movies2directors.directorid JOIN movies ON movies2directors.movieid = movies.movieid WHERE movies.country = 'France';
SELECT u.userid, u.age FROM users u JOIN u2base u2b ON u.userid = u2b.userid WHERE u2b.movieid = 1695219; 
SELECT COUNT(*) AS num_non_english_films, genre FROM movies2directors JOIN movies ON movies2directors.movieid = movies.movieid WHERE isEnglish = 'F' GROUP BY genre ORDER BY num_non_english_films DESC LIMIT 1;
SELECT actors.actorid, actors.a_gender, actors.a_quality, directors.directorid, directors.d_quality FROM movies JOIN movies2actors ON movies.movieid = movies2actors.movieid JOIN actors ON movies2actors.actorid = actors.actorid JOIN movies2directors ON movies.movieid = movies2directors.movieid JOIN directors ON movies2directors.directorid = directors.directorid WHERE movies.movieid = 1949144; 
SELECT 100.0 * SUM(CASE WHEN u2.rating >= 3 THEN 1 ELSE 0 END) / COUNT(DISTINCT actors.actorid) FROM     movies     JOIN movies2actors ON movies.movieid = movies2actors.movieid     JOIN actors ON movies2actors.actorid = actors.actorid     JOIN u2base ON movies.movieid = u2base.movieid WHERE     movies.country = 'UK';
SELECT ROUND(     (         SELECT COUNT(*)          FROM movies2directors md          JOIN directors d ON md.directorid = d.directorid          WHERE md.genre = 'action'              AND d.avg_revenue > d.d_quality      ) * 100.0 / (         SELECT COUNT(*)          FROM movies2directors md          JOIN directors d ON md.directorid = d.directorid          WHERE md.genre = 'action'     ),      2 ) AS proportion_of_action_directors_successful
SELECT actors.actorid FROM actors JOIN movies2actors ON actors.actorid = movies2actors.actorid JOIN movies ON movies2actors.movieid = movies.movieid WHERE movies.year = 4;
SELECT actors.actorid FROM movies JOIN movies2actors ON movies.movieid = movies2actors.movieid JOIN actors ON movies2actors.actorid = actors.actorid WHERE movies.isenglish = 'T' AND movies.runningtime = 2;
SELECT actors.actorid FROM actors JOIN movies2actors ON actors.actorid = movies2actors.actorid JOIN movies ON movies2actors.movieid = movies.movieid WHERE movies.country = 'France' GROUP BY actors.actorid HAVING COUNT(movies.movieid) >= 2;
SELECT COUNT(*) FROM     movies WHERE     country = 'USA'     AND movieid IN (         SELECT movieid         FROM movies2actors         GROUP BY movieid         HAVING COUNT(cast_num) > 1     );
SELECT movies.movieid FROM movies LEFT JOIN movies2actors ON movies.movieid = movies2actors.movieid WHERE movies.year = 1 AND movies2actors.cast_num = 0;
SELECT COUNT(DISTINCT actorid) FROM actors INNER JOIN movies2actors ON actors.actorid = movies2actors.actorid INNER JOIN movies ON movies2actors.movieid = movies.movieid WHERE movies.country IN ('US', 'UK');
SELECT COUNT(DISTINCT directors.directorid) FROM directors JOIN movies2directors ON directors.directorid = movies2directors.directorid JOIN movies ON movies2directors.movieid = movies.movieid WHERE directors.avg_revenue = 4 AND movies2directors.genre IN ('action', 'adventure');
SELECT directorid FROM directors WHERE d_quality >= 3 GROUP BY directorid HAVING COUNT(DISTINCT genre) >= 2; 
SELECT COUNT(*) FROM     movies WHERE     country = 'USA'     AND genre = 'Comedy';
SELECT COUNT(*) FROM movies WHERE year = (SELECT MAX(year) FROM movies) AND genre IN ('drama', 'action');
SELECT movies.movieid FROM movies WHERE movies.genre = 'Horror' AND movies.runningtime >= 120;
SELECT COUNT(m.movieid) * 100.0 / (SELECT COUNT(*) FROM movies AS m WHERE m.isenglish = 1 AND m.country = 'USA') AS negative_critical_reception FROM movies AS m JOIN u2base AS u ON m.movieid = u.movieid WHERE m.isenglish = 1 AND m.country = 'USA' AND u.rating = 1;
SELECT COUNT(DISTINCT movies.movieid) AS disparate_number FROM movies JOIN u2base ON movies.movieid = u2base.movieid WHERE movies.genre = 'comedy' AND u2base.rating = 1; 
SELECT d_quality, AVG(avg_revenue) AS average_revenue_status FROM directors JOIN movies2directors ON directors.directorid = movies2directors.directorid JOIN (     SELECT movieid     FROM u2base     WHERE rating = 1     GROUP BY movieid     ORDER BY COUNT(*) DESC     LIMIT 1 ) AS top_rated_movie ON movies2directors.movieid = top_rated_movie.movieid GROUP BY d_quality; 
SELECT COUNT(*)  FROM      movies  WHERE      country = 'France'      AND movieid IN (SELECT movieid FROM u2base WHERE rating = (SELECT MAX(rating) FROM u2base))
SELECT m.movieid, COUNT(u.userid) AS num_ratings FROM movies m JOIN u2base u ON m.movieid = u.movieid JOIN users usr ON u.userid = usr.userid WHERE usr.age = 25 GROUP BY m.movieid ORDER BY num_ratings DESC LIMIT 1; 
SELECT COUNT(DISTINCT users.userid) FROM     users JOIN     u2base ON users.userid = u2base.userid JOIN     movies ON u2base.movieid = movies.movieid WHERE     users.age = 35 AND     movies.country = 'UK';
SELECT userid, age FROM users JOIN u2base ON users.userid = u2base.userid WHERE movieid = 2409051 AND rating = 2; 
SELECT movieid FROM movies WHERE year = (     SELECT MIN(year) FROM movies ) ORDER BY (     SELECT COUNT(*) FROM u2base WHERE u2base.movieid = movies.movieid ) DESC LIMIT 1; 
SELECT DISTINCT movies.movieid FROM     movies WHERE     movies.country = 'France' ORDER BY     SUM(u2base.rating) LIMIT 1;
SELECT COUNT(DISTINCT actors.actorid) FROM     actors JOIN     movies2actors ON actors.actorid = movies2actors.actorid JOIN     movies ON movies2actors.movieid = movies.movieid WHERE     (movies.country = 'French' OR movies.country = 'USA') AND     actors.a_gender = 'F';
SELECT COUNT(DISTINCT actors.actorid) FROM     actors     JOIN movies2actors ON actors.actorid = movies2actors.actorid     JOIN movies ON movies2actors.movieid = movies.movieid WHERE     movies.movieid IN (         SELECT            movieid         FROM             u2base         WHERE             rating = 5         GROUP BY             movieid         ORDER BY             COUNT(movieid) DESC         LIMIT 1     );
SELECT movies.movieid, AVG(u2base.rating) AS avg_rating FROM movies JOIN movies2directors ON movies.movieid = movies2directors.movieid JOIN directors ON movies2directors.directorid = directors.directorid JOIN u2base ON movies.movieid = u2base.movieid WHERE movies2directors.genre = 'Crime' GROUP BY movies.movieid ORDER BY avg_rating LIMIT 1; 
SELECT COUNT(CASE WHEN a_gender = 'M' THEN 1 END) / COUNT(CASE WHEN a_gender = 'F' THEN 1 END) AS gender_ratio FROM actors JOIN movies2actors ON actors.actorid = movies2actors.actorid JOIN movies ON movies2actors.movieid = movies.movieid WHERE movies.country = 'UK'
SELECT COUNT(*) FROM     users u     JOIN u2base u2 ON u.userid = u2.userid WHERE     u.age = 35     AND u.u_gender = 'F'     AND u2.movieid = 1711133     AND u2.rating = 3;
SELECT COUNT(u.userid) FROM     users u JOIN     u2base u2 ON u.userid = u2.userid JOIN     movies m ON u2.movieid = m.movieid WHERE     u2.rating = 1     AND m.country = 'UK'     AND m.year = (SELECT MAX(year) - 1 FROM movies WHERE country = 'UK')     AND m.runningtime = 2;
SELECT COUNT(DISTINCT directors.directorid) FROM directors LEFT JOIN movies2directors ON directors.directorid = movies2directors.directorid WHERE directors.avg_revenue = 2 AND directors.d_quality = 3 AND movies2directors.genre <> 'comedy'; 
SELECT (CAST(     (SELECT COUNT(*)       FROM actors       INNER JOIN movies2actors ON actors.actorid = movies2actors.actorid       WHERE actors.a_gender = 'F' AND actors.a_quality = 2 AND movies2actors.cast_num = 2     ) AS FLOAT)   /      (SELECT COUNT(*)       FROM actors       WHERE a_gender = 'F') ) * 100 AS percentage_female_actors_quality_2_appeared_twice FROM movies2actors WHERE movieid = 1672580;
SELECT COUNT(CASE WHEN a_quality = 0 AND a_gender = 'M' THEN 1 END) AS men_worst_actors, COUNT(CASE WHEN a_quality = 0 AND a_gender = 'F' THEN 1 END) AS women_worst_actors FROM actors;
SELECT actors.actorid, COUNT(*) AS appearances FROM actors JOIN movies2actors ON actors.actorid = movies2actors.actorid GROUP BY actors.actorid ORDER BY appearances DESC LIMIT 1; 
SELECT MAX(genre) AS most_popular_genre FROM (     SELECT        genre,         COUNT(movieid) AS movie_count     FROM         movies2directors     GROUP BY         genre     ORDER BY         movie_count DESC     LIMIT 1 ) subquery;
SELECT genre FROM movies2directors AS md JOIN directors AS d ON md.directorid = d.directorid WHERE d.d_quality = 0 GROUP BY md.genre ORDER BY COUNT(*) DESC;
SELECT movies.movieid FROM movies JOIN movies2directors ON movies.movieid = movies2directors.movieid JOIN directors ON movies2directors.directorid = directors.directorid JOIN u2base ON movies.movieid = u2base.movieid WHERE movies.isenglish = 'F' AND movies.country = 'USA' ORDER BY u2base.rating LIMIT 1;
SELECT AVG(m.runningtime) AS total_avg_movie FROM directors d JOIN movies2directors md ON d.directorid = md.directorid JOIN movies m ON md.movieid = m.movieid WHERE d.d_quality = 4 AND d.avg_revenue = 4; 
SELECT movies.movieid FROM movies JOIN u2base ON movies.movieid = u2base.movieid JOIN users ON u2base.userid = users.userid WHERE users.u_gender = 'F' AND users.occupation = 3 ORDER BY u2base.rating DESC;
SELECT COUNT(*) AS female_actresses_count, movies.country AS movie_country, movies.runningtime AS movie_running_time FROM movies JOIN movies2actors ON movies.movieid = movies2actors.movieid JOIN actors ON movies2actors.actorid = actors.actorid WHERE movies.movieid = 2312852 AND actors.a_gender = 'F';
SELECT COUNT(movies.movieid) FROM     movies JOIN     movies2directors ON movies.movieid = movies2directors.movieid JOIN     directors ON movies2directors.directorid = directors.directorid WHERE     directors.d_quality = 0 AND     movies2directors.genre = 'horror';
SELECT movies.genre FROM movies WHERE movies.isEnglish = 'F' AND movies.runningtime <= 120;
SELECT COUNT(movies.movieid), movies.movieid FROM movies JOIN movies2directors ON movies.movieid = movies2directors.movieid JOIN directors ON movies2directors.directorid = directors.directorid JOIN movies2actors ON movies.movieid = movies2actors.movieid JOIN actors ON movies2actors.actorid = actors.actorid JOIN u2base ON movies.movieid = u2base.movieid JOIN users ON u2base.userid = users.userid WHERE movies.isenglish = 1 AND movies.country = 'UK' AND movies.runningtime = 3 AND movies2directors.genre = 'comedy' AND users.age >= 45 AND users.age <= 50 AND u2base.rating = (     SELECT MAX(rating)     FROM u2base ) GROUP BY movies.movieid;
SELECT 100 * (     (SELECT COUNT(*) FROM movies WHERE isenglish = 'T' AND genre = 'crime' AND country != 'USA' AND year = 3) -     (SELECT COUNT(*) FROM movies WHERE isenglish = 'F' AND genre = 'crime' AND country != 'USA' AND year = 3) ) /  (SELECT COUNT(*) FROM movies WHERE genre = 'crime' AND country != 'USA' AND year = 3) as percentage_difference
SELECT COUNT(CASE WHEN a_gender = 'M' THEN 1 END) AS male_actors, COUNT(CASE WHEN a_gender = 'F' THEN 1 END) AS female_actors, (MAX(a_quality) - MIN(a_quality)) * 100.0 / (SELECT COUNT(*) FROM actors WHERE movieid = 1684910) AS quality_proportion, directors.directorid, movies2directors.genre FROM movies2actors JOIN actors ON movies2actors.actorid = actors.actorid JOIN movies2directors ON movies2actors.movieid = movies2directors.movieid JOIN directors ON movies2directors.directorid = directors.directorid WHERE movies2actors.movieid = 1684910;
SELECT product.product name FROM central_superstore JOIN product ON central_superstore.product id = product.product id WHERE central_superstore.order id = 'CA-2011-112326' AND central_superstore.region = 'Central'; 
SELECT MAX(SUM(julianday("Ship Date") - julianday("Order Date")), 1) AS longest_shipment_time FROM central_superstore JOIN people ON central_superstore.customer_id = people.customer_id WHERE people.customer_name = 'Aimee Bixby';
SELECT COUNT(*) FROM     central_superstore JOIN     people ON central_superstore.customer_id = people.customer_id WHERE     people.customer_name = 'Aimee Bixby' AND     central_superstore.ship_mode = 'Standard Class';
SELECT COUNT(central_superstore.order id) FROM central_superstore JOIN people ON central_superstore.customer id = people.customer id WHERE people.customer name = 'Aimee Bixby';
SELECT central_superstore.order id FROM central_superstore JOIN people ON central_superstore.customer id = people.customer id WHERE people.customer name = 'Aimee Bixby' GROUP BY central_superstore.order id HAVING COUNT(DISTINCT central_superstore.product id) > 3; 
SELECT COUNT(DISTINCT central_superstore.order id) FROM     central_superstore JOIN     people ON central_superstore.customer id = people.customer id JOIN     product ON central_superstore.product id = product.product id WHERE     people.customer name = 'Aimee Bixby'     AND product.category = 'Furniture';
SELECT product.product name FROM     central_superstore JOIN     people ON central_superstore.customer id = people.customer id AND central_superstore.region = people.region JOIN     product ON central_superstore.product id = product.product id AND central_superstore.region = product.region WHERE     people.customer name = 'Aimee Bixby'     AND strftime('%Y', central_superstore.order date) = '2016';
SELECT SUM(quantity) FROM central_superstore JOIN product ON central_superstore.product_id = product.product_id WHERE product.product_name = 'Telescoping Adjustable Floor Lamp' AND central_superstore.region = 'Central';
SELECT people.customer name FROM people JOIN central_superstore ON central_superstore.customer id = people.customer id JOIN product ON central_superstore.product id = product.product id WHERE product.product name = "Telescoping Adjustable Floor Lamp";
SELECT COUNT(DISTINCT people.customer_id) AS consumers_count FROM central_superstore JOIN product ON central_superstore.product_id = product.product_id AND central_superstore.region = product.region JOIN people ON central_superstore.customer_id = people.customer_id AND central_superstore.region = people.region WHERE product.product_name = 'Telescoping Adjustable Floor Lamp' AND people.segment = 'Consumer';
SELECT SUM(quantity) FROM central_superstore JOIN product ON central_superstore.product id = product.product id AND central_superstore.region = product.region JOIN people ON central_superstore.customer id = people.customer id AND central_superstore.region = people.region WHERE product.product name = 'Xerox 1952' AND people.customer name = 'Aimee Bixby' AND central_superstore.order date = date('2014-09-10');
SELECT COUNT(*) AS order_count FROM central_superstore JOIN product ON central_superstore.product_id = product.product_id JOIN people ON central_superstore.customer_id = people.customer_id WHERE people.customer_name = 'Aimee Bixby' AND product.product_name = 'Xerox 1952';
SELECT ROUND(Sales / (1 - discount), 2) AS "Original Price" FROM central_superstore JOIN product ON central_superstore.product id = product.product id JOIN people ON central_superstore.customer id = people.customer id WHERE product.product name = 'Xerox 1952' AND people.customer name = 'Aimee Bixby' AND central_superstore.order date = date('2014-09-10');
SELECT SUM((sales / (1 - discount)) * quantity - profit) AS total_cost FROM central_superstore JOIN product ON central_superstore.product_id = product.product_id AND central_superstore.region = product.region JOIN people ON central_superstore.customer_id = people.customer_id AND central_superstore.region = people.region WHERE product.product_name = 'Xerox 1952' AND people.customer_name = 'Aimee Bixby' AND DATE(central_superstore.order_date) = DATE('2014-09-10'); 
SELECT COUNT(*) FROM east_superstore JOIN product ON east_superstore.product id = product.product id AND east_superstore.region = product.region WHERE strftime('%Y', "Order Date") = '2013' AND "Sub-Category" = 'Art';
SELECT MAX(customer_name) FROM (     SELECT        p.customer_name,         SUM((s.sales / (1 - s.discount)) * s.quantity - s.profit) AS total_cost     FROM         people p     JOIN         central_superstore s ON p.customer_id = s.customer_id AND p.region = s.region     GROUP BY         s.order_id ) AS order_total_costs;
SELECT MAX(DIVIDE(sales, SUBTRACT(1, discount))) AS original_price, product_name FROM central_superstore JOIN product ON central_superstore.product_id = product.product_id GROUP BY product_name ORDER BY original_price DESC LIMIT 1;
SELECT product.product_name FROM people JOIN central_superstore ON people.customer_id = central_superstore.customer_id JOIN product ON central_superstore.product_id = product.product_id WHERE people.customer_name = 'Darren Powers' ORDER BY central_superstore.order_date DESC LIMIT 1;
SELECT SUM(quantity) FROM central_superstore JOIN product ON central_superstore.product_id = product.product_id WHERE product.product_name = 'Advantus plastic paper clips';
SELECT MAX(SUBTRACT(MULTIPLY(DIVIDE(sales, SUBTRACT(1, discount)), quantity), profit)) AS total_cost FROM     central_superstore JOIN     product ON central_superstore.product_id = product.product_id WHERE     product.product_name = 'Logitech G600 MMO Gaming Mouse';
SELECT product.product name FROM central_superstore JOIN product ON central_superstore.product id = product.product id JOIN people ON central_superstore.customer id = people.customer id WHERE people.customer name = 'Alejandro Grove';
SELECT COUNT(DISTINCT central_superstore.customer_id) FROM central_superstore JOIN product ON central_superstore.product_id = product.product_id AND central_superstore.region = product.region JOIN people ON central_superstore.customer_id = people.customer_id AND central_superstore.region = people.region WHERE people.city = 'Chicago' AND product.product_name = 'Cardinal EasyOpen D-Ring Binders' AND central_superstore.quantity >= 10;
SELECT product.product name FROM central_superstore JOIN product ON central_superstore.product id = product.product id WHERE central_superstore.profit >= 1000 GROUP BY central_superstore.order id HAVING SUM(central_superstore.profit) >= 1000; 
SELECT product.product_name FROM east_superstore JOIN product ON east_superstore.product_id = product.product_id WHERE east_superstore.ship_mode = 'First Class' AND east_superstore.region = 'East' LIMIT 10;
SELECT product.product_name FROM central_superstore JOIN people ON central_superstore.customer_id = people.customer_id JOIN product ON central_superstore.product_id = product.product_id WHERE people.customer_name = 'Becky Martin' AND people.region = 'Central';
SELECT customer_name FROM     people WHERE     region = 'West'     AND customer_id IN (         SELECT            customer_id         FROM             west_superstore         WHERE             ship_mode = 'Second Class'     ) LIMIT 5;
SELECT SUM(profit) AS total_profit FROM central_superstore JOIN people ON central_superstore.customer_id = people.customer_id WHERE people.customer_name = 'Patrick Gardner' AND people.region = 'Central';
SELECT product.product_name FROM south_superstore JOIN product ON south_superstore.product_id = product.product_id WHERE south_superstore.order_date = date('2013-03-04') AND south_superstore.ship_mode = 'Same Day';
SELECT SUM(central_superstore.sales) AS total_sales FROM central_superstore JOIN product ON central_superstore.product_id = product.product_id JOIN people ON central_superstore.customer_id = people.customer_id WHERE product.product_name = 'Avery Hi-Liter EverBold Pen Style Fluorescent Highlighters, 4/Pack' AND central_superstore.region = 'Central';
SELECT product.product name FROM east_superstore JOIN product ON east_superstore.product id = product.product id JOIN people ON east_superstore.customer id = people.customer id WHERE people.customer name = 'Jonathan Doherty' AND east_superstore.region = 'East' ORDER BY east_superstore.quantity DESC LIMIT 1;
SELECT SUM(quantity) AS total_quantity, product.product_name FROM east_superstore JOIN product ON east_superstore.product_id = product.product_id WHERE east_superstore.region = 'East' AND east_superstore.ship_date = Date('2015-03-25') GROUP BY product.product_name;
SELECT people.customer_name FROM     people JOIN     east_superstore ON people.customer_id = east_superstore.customer_id JOIN     product ON east_superstore.product_id = product.product_id WHERE     product.product_name = 'Global High-Back Leather Tilter, Burgundy'     AND east_superstore.order_date = Date('2013-10-13')     AND people.region = 'East';
SELECT category FROM     central_superstore JOIN     product ON central_superstore.product id = product.product id JOIN     people ON central_superstore.customer id = people.customer id WHERE     people.customer name = 'Katherine Murray'     AND central_superstore.region = 'South'     AND central_superstore.order date = Date('2018-11-04');
SELECT ((SELECT SUM(quantity) FROM west_superstore WHERE category = 'Furniture' AND ship_mode = 'Standard Class') * 1.0 / (SELECT SUM(quantity) FROM west_superstore WHERE ship_mode = 'Standard Class')) * 100.0 as percentage
SELECT ship_date FROM central_superstore JOIN people ON central_superstore.customer_id = people.customer_id WHERE people.customer_name = 'Ann Chong' AND people.region = 'Central';
SELECT segment FROM people INNER JOIN west_superstore ON people.customer_id = west_superstore.customer_id WHERE west_superstore.order_id = 'CA-2011-108189';
SELECT SUM(sales) AS total_sales FROM west_superstore JOIN product ON west_superstore.product_id = product.product_id JOIN people ON west_superstore.customer_id = people.customer_id WHERE product.product_name = 'Hon Valutask Swivel Chairs' AND west_superstore.region = 'West';
SELECT order_id FROM     south_superstore JOIN     people ON south_superstore.customer_id = people.customer_id WHERE     people.customer_name = 'Frank Olsen';
SELECT product.product_name FROM central_superstore JOIN product ON central_superstore.product_id = product.product_id WHERE central_superstore.region = 'Central' AND central_superstore.order_date = date('2018-04-26') AND central_superstore.ship_date = date('2018-04-27');
SELECT people.city, people.state FROM people JOIN central_superstore ON central_superstore.customer_id = people.customer_id JOIN product ON central_superstore.product_id = product.product_id WHERE central_superstore.sales = (     SELECT MAX(sales) FROM central_superstore ); 
SELECT MAX(profit), customer_id FROM east_superstore WHERE profit = (SELECT MAX(profit) FROM east_superstore) GROUP BY customer_id;
SELECT MAX(quantity) FROM     central_superstore JOIN     people ON central_superstore.customer id = people.customer id WHERE     city = 'Chicago' AND state = 'Illinois';
SELECT central_superstore.order date, product.product name FROM central_superstore JOIN product ON central_superstore.product id = product.product id WHERE central_superstore.order id = 'CA-2011-137274' AND central_superstore.region = 'Central'; 
SELECT people.customer_name FROM people JOIN south_superstore ON people.customer_id = south_superstore.customer_id JOIN product ON south_superstore.product_id = product.product_id WHERE product.product_name = 'Xerox 23' AND people.region = 'South';
SELECT product.product_name FROM central_superstore JOIN product ON central_superstore.product_id = product.product_id WHERE product.category = 'Office Supplies' AND central_superstore.region = 'Central' ORDER BY central_superstore.sales DESC LIMIT 1;
SELECT MAX(discount) AS highest_discount, customer_name AS customer FROM west_superstore JOIN people ON west_superstore.customer_id = people.customer_id WHERE region = 'West';
SELECT product.product name FROM product INNER JOIN east_superstore ON product.product id = east_superstore.product id WHERE east_superstore.profit > (SELECT 0.98 * AVG(profit) FROM east_superstore) 
SELECT people.customer_name FROM people JOIN east_superstore ON people.customer_id = east_superstore.customer_id AND people.region = east_superstore.region JOIN product ON east_superstore.product_id = product.product_id AND east_superstore.region = product.region WHERE ((east_superstore.sales / (1 - east_superstore.discount) * east_superstore.quantity) - east_superstore.profit) > 80000; 
SELECT COUNT(*) AS total_orders FROM     people JOIN     central_superstore ON people.customer id = central_superstore.customer id WHERE     people.customer name = 'Maxwell Schwartz'     AND strftime('%Y', central_superstore.order date) = '2015';
SELECT people.customer_name FROM people JOIN central_superstore ON people.customer_id = central_superstore.customer_id JOIN product ON central_superstore.product_id = product.product_id WHERE product.product_name = 'Bush Mission Pointe Library' AND central_superstore.region = 'Central';
SELECT SUM(profit) FROM     central_superstore     JOIN product ON central_superstore.product_id = product.product_id AND central_superstore.region = product.region WHERE     product.product_name = 'Cisco SPA301' UNION ALL SELECT    SUM(profit) FROM     east_superstore     JOIN product ON east_superstore.product_id = product.product_id AND east_superstore.region = product.region WHERE     product.product_name = 'Cisco SPA301' UNION ALL SELECT    SUM(profit) FROM     south_superstore     JOIN product ON south_superstore.product_id = product.product_id AND south_superstore.region = product.region WHERE     product.product_name = 'Cisco SPA301' UNION ALL SELECT    SUM(profit) FROM     west_superstore     JOIN product ON west_superstore.product_id = product.product_id AND west_superstore.region = product.region WHERE     product.product_name = 'Cisco SPA301';
SELECT product.product_name FROM people JOIN west_superstore ON people.customer_id = west_superstore.customer_id AND people.region = west_superstore.region JOIN product ON west_superstore.product_id = product.product_id AND west_superstore.region = product.region WHERE people.customer_name = 'Anne McFarland';
SELECT product.product_name FROM people JOIN central_superstore ON central_superstore.customer_id = people.customer_id AND central_superstore.region = people.region JOIN product ON central_superstore.product_id = product.product_id WHERE people.city = 'Coachella';
SELECT COUNT(east_superstore.order id) AS east_orders_2015, COUNT(west_superstore.order id) AS west_orders_2015 FROM east_superstore JOIN west_superstore ON east_superstore.order id = west_superstore.order id WHERE strftime('%Y', east_superstore.order date) = '2015' AND strftime('%Y', west_superstore.order date) = '2015';
SELECT product.product_name FROM central_superstore JOIN product ON central_superstore.product_id = product.product_id AND central_superstore.region = product.region JOIN people ON central_superstore.customer_id = people.customer_id AND central_superstore.region = people.region WHERE people.customer_name = 'Matt Abelman' AND central_superstore.region = 'West' AND central_superstore.order_date LIKE '2013%'
SELECT SUM((Sales / (1 - Discount)) * Quantity) AS total_cost FROM central_superstore JOIN people ON central_superstore.customer_id = people.customer_id WHERE people.customer_name = 'Brad Thomas' AND strftime('%Y', "Order Date") = '2016';
SELECT people.customer_name, people.city, people.country FROM central_superstore JOIN product ON central_superstore.product_id = product.product_id AND central_superstore.region = product.region JOIN people ON central_superstore.customer_id = people.customer_id AND central_superstore.region = people.region WHERE product.product_name = 'Plantronics Single Ear Headset'; 
SELECT ship_date, product_name FROM     central_superstore JOIN     people ON central_superstore.customer_id = people.customer_id JOIN     product ON central_superstore.product_id = product.product_id WHERE     people.customer_name = 'Gene Hale';
SELECT COUNT(*) FROM south_superstore JOIN product ON south_superstore.product_id = product.product_id AND south_superstore.region = product.region WHERE south_superstore.ship_mode = 'First Class' AND product.category = 'Furniture';
SELECT COUNT(*) FROM south_superstore AS s JOIN product AS p ON s.product_id = p.product_id AND s.region = p.region JOIN people AS pe ON s.customer_id = pe.customer_id AND s.region = pe.region WHERE pe.customer_name = 'Cindy Stewart' AND p.category = 'Office Supplies';
SELECT MAX(category) AS highest_profit_category FROM   product JOIN   south_superstore ON product.product_id = south_superstore.product_id GROUP BY   category ORDER BY   SUM(profit) DESC LIMIT 1;
SELECT product.product_name FROM     product JOIN     east_superstore ON product.product_id = east_superstore.product_id JOIN     people ON east_superstore.customer_id = people.customer_id WHERE     people.customer_name = 'Cindy Stewart';
SELECT product.product name FROM west_superstore JOIN product ON west_superstore.product id = product.product id WHERE west_superstore.ship mode = 'Same Day' AND west_superstore.ship date BETWEEN '2013-01-01' AND '2013-12-31';
SELECT DISTINCT product.category FROM people JOIN central_superstore ON people.customer_id = central_superstore.customer_id JOIN product ON central_superstore.product_id = product.product_id AND central_superstore.region = product.region WHERE people.customer_name = 'Sam Craven' UNION SELECT DISTINCT product.category FROM people JOIN east_superstore ON people.customer_id = east_superstore.customer_id JOIN product ON east_superstore.product_id = product.product_id AND east_superstore.region = product.region WHERE people.customer_name = 'Sam Craven'; 
SELECT SUM(quantity) FROM south_superstore JOIN product ON south_superstore.product id = product.product id JOIN people ON south_superstore.customer id = people.customer id WHERE people.customer name = 'Cindy Stewart' AND product.product name = 'Lexmark X 9575 Professional All-in-One Color Printer';
SELECT product.product name FROM central_superstore JOIN product ON central_superstore.product id = product.product id WHERE central_superstore.quantity >= 10 AND central_superstore.ship mode = 'Standard Class'; 
SELECT MIN(product.category) FROM   west_superstore JOIN product ON west_superstore.product_id = product.product_id WHERE   west_superstore.sales = (     SELECT MIN(sales) FROM west_superstore   );
SELECT SUM(profit) AS total_profit FROM south_superstore JOIN product ON south_superstore.product_id = product.product_id WHERE product.product_name = "Memorex Froggy Flash Drive 8 GB";
SELECT SUM(sales) AS total_sales FROM east_superstore JOIN product ON east_superstore.product_id = product.product_id WHERE product.category = 'Furnitures' AND east_superstore.order_date BETWEEN '2016-01-01' AND '2016-12-31';
SELECT AVG(sales) AS average_sales FROM   east_superstore JOIN product ON east_superstore.product_id = product.product_id WHERE   product.product_name = "Sharp AL-1530CS Digital Copier"  UNION  SELECT  AVG(sales) AS average_sales FROM   west_superstore JOIN product ON west_superstore.product_id = product.product_id WHERE   product.product_name = "Sharp AL-1530CS Digital Copier";
SELECT (      SELECT         (COUNT(*) * 100) /          (SELECT COUNT(*) FROM central_superstore WHERE region = 'Central')      FROM          central_superstore      WHERE          product_id IN          (SELECT product_id FROM product WHERE category = 'Office Supplies') ) AS central_office_supplies_percentage,  (     SELECT         (COUNT(*) * 100) /          (SELECT COUNT(*) FROM south_superstore WHERE region = 'South')      FROM          south_superstore      WHERE          product_id IN          (SELECT product_id FROM product WHERE category = 'Office Supplies') ) AS south_office_supplies_percentage;
SELECT   CAST((SELECT COUNT(*) FROM people WHERE state = 'Texas') AS FLOAT) / CAST((SELECT COUNT(*) FROM people WHERE state = 'Indiana') AS FLOAT) AS ratio; 
SELECT product.product_name FROM central_superstore JOIN product ON central_superstore.product_id = product.product_id WHERE product.sub_category = 'Art' GROUP BY product.product_id ORDER BY COUNT(*) DESC LIMIT 1; 
SELECT DISTINCT people.customer_name FROM south_superstore JOIN people ON south_superstore.customer_id = people.customer_id WHERE south_superstore.order_date BETWEEN '2015-01-01' AND '2015-12-31' GROUP BY people.customer_name HAVING COUNT(south_superstore.order_id) > 3; 
SELECT MAX(central_superstore.profit) AS highest_profit FROM central_superstore JOIN people ON central_superstore.customer_id = people.customer_id WHERE people.customer_name = 'Anna Chung' AND central_superstore.region = people.region AND people.region = 'Central';
SELECT COUNT(*) FROM     central_superstore JOIN     people ON central_superstore.customer id = people.customer id WHERE     people.customer name = 'Corey Roper'     AND strftime('%Y', central_superstore.order date) = '2015'
SELECT SUM(CASE WHEN region = 'East' THEN sales ELSE 0 END) - SUM(CASE WHEN region = 'West' THEN sales ELSE 0 END) AS sales_difference FROM east_superstore JOIN product ON east_superstore.product_id = product.product_id AND east_superstore.region = product.region JOIN people ON east_superstore.customer_id = people.customer_id AND east_superstore.region = people.region;
SELECT product.product_name FROM central_superstore JOIN product ON central_superstore.product_id = product.product_id WHERE central_superstore.profit < 0;
SELECT product.product name, west_superstore.ship mode FROM west_superstore JOIN product ON west_superstore.product id = product.product id WHERE (julianday(west_superstore.ship date) - julianday(west_superstore.order date)) = (     SELECT MIN(julianday(west_superstore.ship date) - julianday(west_superstore.order date))     FROM west_superstore )
SELECT COUNT(*)  FROM central_superstore  JOIN product ON central_superstore.product id = product.product id AND central_superstore.region = product.region  JOIN people ON central_superstore.customer id = people.customer id AND central_superstore.region = people.region  WHERE people.customer name = 'O'Sullivan Plantations'  AND product.product name = '2-Door Library in Landvery Oak'  AND central_superstore.ship mode = 'First Class';
SELECT MAX(people.customer name) FROM people JOIN east_superstore ON people.customer id = east_superstore.customer id WHERE people.segment = 'Corporate' AND people.state = 'Rhode Island' AND east_superstore.order date BETWEEN '2016-01-01' AND '2016-12-31'
SELECT COUNT(*) FROM west_superstore JOIN people ON west_superstore.customer id = people.customer id AND west_superstore.region = people.region WHERE west_superstore.sales >= 5000 AND people.state = 'California';
SELECT people.segment FROM people JOIN east_superstore ON people.customer_id = east_superstore.customer_id JOIN product ON east_superstore.product_id = product.product_id WHERE east_superstore.sales / (1 - east_superstore.discount) = (SELECT MAX(sales / (1 - discount)) FROM east_superstore)
SELECT strftime('%d', central_superstore.ship date) - strftime('%d', central_superstore.order date) AS shipment_duration FROM central_superstore WHERE central_superstore.order id = 'CA-2011-134103';
SELECT COUNT(*)  FROM      central_superstore WHERE      quantity > 5      AND ship mode = 'First Class'  
SELECT central_superstore.order_id, central_superstore.order_date, central_superstore.profit FROM central_superstore WHERE central_superstore.profit < 0 LIMIT 3;
SELECT product.product_name FROM people JOIN central_superstore ON people.customer_id = central_superstore.customer_id JOIN product ON central_superstore.product_id = product.product_id WHERE people.customer_name = 'Phillina Ober';
SELECT people.customer_name FROM south_superstore JOIN product ON south_superstore.product_id = product.product_id JOIN people ON south_superstore.customer_id = people.customer_id WHERE product.product_name = "Hon Multipurpose Stacking Arm Chairs" AND south_superstore.region = "South"  ORDER BY south_superstore.quantity DESC LIMIT 1;
SELECT SUM(profit) FROM central_superstore JOIN product ON central_superstore.product_id = product.product_id WHERE product.product_name = "O'Sullivan Living Dimensions 2-Shelf Bookcases";
SELECT SUM(quantity) FROM west_superstore JOIN product ON west_superstore.product id = product.product id WHERE product product name = 'Hon Pagoda Stacking Chairs';
SELECT COUNT(*) FROM     people JOIN     central_superstore ON people.customer_id = central_superstore.customer_id WHERE     people.customer_name = 'Aaron Bergman'     AND central_superstore.ship_mode = 'Standard Class';
SELECT Sales / (1 - Discount) AS original_price FROM     central_superstore JOIN     product ON central_superstore.product_id = product.product_id WHERE     product.product_name = "Black Avery Flip-Chart Easel Binder";
SELECT product.product name FROM central_superstore JOIN people ON central_superstore.customer id = people.customer id JOIN product ON central_superstore.product id = product.product id WHERE people.customer name = 'Aimee Bixby';
SELECT profit FROM central_superstore JOIN product ON central_superstore.product_id = product.product_id WHERE product.product_name = 'Sauder Camden County Barrister Bookcase, Planked Cherry Finish';
SELECT COUNT(*) FROM east_superstore JOIN product ON east_superstore.product_id = product.product_id WHERE product.category = 'Furniture' AND east_superstore.ship_mode = 'Standard Class';
SELECT MAX(profit) FROM     east_superstore JOIN     people ON east_superstore.customer_id = people.customer_id WHERE     people.city = 'Houston'     AND people.state = 'Texas';
SELECT COUNT(*) FROM central_superstore JOIN product ON central_superstore.product_id = product.product_id WHERE product.category = 'Furniture';
SELECT product.product name FROM central_superstore JOIN product ON central_superstore.product id = product.product id WHERE central_superstore.ship date LIKE '2013-03%' 
SELECT COUNT(central_superstore.order id) FROM central_superstore JOIN people ON central_superstore.customer id = people.customer id WHERE people.state = 'Texas'
SELECT COUNT(*) FROM central_superstore JOIN people ON central_superstore.customer id = people.customer id AND central_superstore.region = people.region WHERE people.customer name = 'Alan Barnes' AND central_superstore.order date LIKE '2015%'
SELECT product.product_name FROM east_superstore JOIN product ON east_superstore.product_id = product.product_id WHERE east_superstore.order_id = 'CA-2011-115791';
SELECT ROUND(     (         SELECT COUNT(DISTINCT cs.order_id) * 100.0         FROM central_superstore cs         JOIN people p ON cs.customer_id = p.customer_id         WHERE cs.discount = 0.2 AND p.state = 'Texas'     ) /     (         SELECT COUNT(DISTINCT cs.order_id)         FROM central_superstore cs         WHERE cs.discount = 0.2     ),     2 ) AS percentage; 
SELECT ROUND(     (CAST(         SUM(CASE WHEN product.category = 'Furniture' AND central_superstore.ship mode = 'First Class' AND central_superstore.ship date LIKE '2013%' THEN 1 ELSE 0 END) AS FLOAT) /     CAST(         SUM(CASE WHEN central_superstore.ship date LIKE '2013%' THEN 1 ELSE 0 END) AS FLOAT)     ) * 100, 2) AS percentage FROM     central_superstore JOIN     product ON central_superstore.product id = product.product id WHERE     central_superstore.region = 'Central';
SELECT people.customer_name FROM west_superstore JOIN people ON west_superstore.customer_id = people.customer_id WHERE west_superstore.region = 'West' AND west_superstore.order_date = '2013-08-12' AND west_superstore.discount = 0.2;
SELECT order_id FROM central_superstore JOIN product ON central_superstore.product_id = product.product_id JOIN people ON central_superstore.customer_id = people.customer_id WHERE product.product_name = 'Security-Tint Envelopes' AND central_superstore.order_date = '2013-06-03' AND people.region = 'Central';
SELECT product.product_name FROM people JOIN central_superstore ON central_superstore.customer_id = people.customer_id JOIN product ON central_superstore.product_id = product.product_id WHERE people.customer_name = 'Bill Shonely' AND people.region = 'Central';
SELECT Customer_Name FROM     west_superstore JOIN     people ON west_superstore.customer_id = people.customer_id WHERE     west_superstore.quantity = 8     AND people.region = 'West';
SELECT SUM(central_superstore.profit) AS total_profit FROM central_superstore JOIN people ON central_superstore.customer_id = people.customer_id WHERE people.city = 'Houston' AND people.state = 'Texas' AND central_superstore.region = 'Central';
SELECT customer_name FROM     people JOIN     east_superstore ON people.customer_id = east_superstore.customer_id WHERE     east_superstore.ship_date = '2013-03-05'     AND people.region = 'East';
SELECT MIN(product.product name) AS product_with_lowest_profit FROM central_superstore JOIN product ON central_superstore.product id = product.product id WHERE central_superstore.region = 'Central' AND central_superstore.order date LIKE '2016%'
SELECT customer_name FROM people JOIN east_superstore ON people.customer_id = east_superstore.customer_id WHERE east_superstore.order_id = 'CA-2011-118976';
SELECT MAX(product.product_name) FROM     south_superstore JOIN product ON south_superstore.product_id = product.product_id WHERE     south_superstore.sales = (         SELECT            MAX(sales)         FROM             south_superstore     );
SELECT sales, profit, sub-category FROM east_superstore JOIN product ON east_superstore.product id = product.product id AND east_superstore.region = product.region WHERE east_superstore.order id = 'US-2011-126571' AND east_superstore.region = 'East'; 
SELECT MAX(quantity) AS highest_quantity, product.product_name FROM central_superstore INNER JOIN product ON central_superstore.product_id = product.product_id GROUP BY product.product_name ORDER BY highest_quantity DESC LIMIT 1;
SELECT people.customer_name FROM south_superstore JOIN people ON south_superstore.customer_id = people.customer_id WHERE south_superstore.ship_mode = 'Standard Class' AND south_superstore.sales > (     SELECT AVG(sales) * 0.88      FROM south_superstore );
SELECT ROUND((COUNT(*) FILTER (WHERE state = 'Indiana' AND central_superstore.region = 'Central' AND discount = 0) * 100.0) / COUNT(*) FILTER (WHERE state = 'Indiana' AND central_superstore.region = 'Central'), 2) AS percentage 
SELECT (CAST((SELECT COUNT(*) FROM officers WHERE gender = 'M' AND race = 'W') AS FLOAT) / (SELECT COUNT(*) FROM officers WHERE gender = 'M')) * 100 AS percentage_white_male_officers;
SELECT (SELECT (COUNT(DISTINCT incidents.case_number) * 1.0 / (SELECT COUNT(DISTINCT incidents.case_number) FROM incidents WHERE date BETWEEN '2010-01-01' AND '2015-12-31')) * 100 FROM incidents JOIN (     SELECT case_number, COUNT(*) AS officer_count     FROM officers     GROUP BY case_number     HAVING officer_count > 3 ) AS officer_counts ON incidents.case_number = officer_counts.case_number WHERE incidents.date BETWEEN '2010-01-01' AND '2015-12-31') AS percentage_of_cases_with_more_than_3_officers;
SELECT  strftime('%Y', date) AS year, COUNT(*) AS case_count FROM incidents WHERE subject_weapon = 'Handgun' GROUP BY year ORDER BY case_count DESC LIMIT 1; 
SELECT ROUND((COUNT(CASE WHEN incidents.grand_jury_disposition = 'No Bill' AND incidents.subject_statuses = 'injured' THEN 1 END) * 100.0) / COUNT(CASE WHEN incidents.grand_jury_disposition = 'No Bill' THEN 1 END), 2) AS percentage_injured_cases FROM incidents 
SELECT COUNT(CASE WHEN subject_weapon = 'Vehicle' AND date BETWEEN '2007-01-01' AND '2007-12-31' THEN case_number END) AS cases_2007, COUNT(CASE WHEN subject_weapon = 'Vehicle' AND date BETWEEN '2008-01-01' AND '2008-12-31' THEN case_number END) AS cases_2008, COUNT(CASE WHEN subject_weapon = 'Vehicle' AND date BETWEEN '2008-01-01' AND '2008-12-31' THEN case_number END) - COUNT(CASE WHEN subject_weapon = 'Vehicle' AND date BETWEEN '2007-01-01' AND '2007-12-31' THEN case_number END) AS difference FROM incidents;
SELECT COUNT(*) * 100.0 / (SELECT COUNT(*) FROM incidents WHERE subject_weapon = 'Handgun') FROM incidents WHERE subject_statuses = 'Shoot and Miss' AND subject_weapon = 'Handgun';
SELECT officers.last_name, officers.gender FROM officers JOIN incidents ON officers.case_number = incidents.case_number WHERE incidents.grand_jury_disposition = 'No Bill';
SELECT incidents.case_number, incidents.subject_statuses, incidents.subject_weapon FROM incidents JOIN subjects ON incidents.case_number = subjects.case_number WHERE subjects.gender = 'F'; 
SELECT incidents.case_number, incidents.location, incidents.subject_statuses FROM incidents JOIN subjects ON incidents.case_number = subjects.case_number WHERE subjects.gender = 'M'; 
SELECT incidents.case_number, incidents.grand_jury_disposition FROM incidents INNER JOIN officers ON incidents.case_number = officers.case_number WHERE officers.full_name = 'Evenden, George'; 
SELECT officers.last_name, incidents.subject_statuses FROM officers JOIN incidents ON officers.case_number = incidents.case_number JOIN subjects ON incidents.case_number = subjects.case_number WHERE incidents.case_number = '134472-2015'; 
SELECT subjects.last_name, subjects.gender, subjects.race, incidents.case_number FROM subjects JOIN incidents ON subjects.case_number = incidents.case_number WHERE subjects.subject_statuses = 'Deceased' 
SELECT (SELECT (COUNT(CASE WHEN subject_weapon = 'Vehicle' THEN case_number END) * 100.0) / COUNT(case_number) FROM incidents JOIN subjects ON incidents.case_number = subjects.case_number WHERE subjects.gender = 'F') AS percentage_female_vehicle_weapon;
SELECT CAST(     (         SELECT             COUNT(CASE WHEN subject_weapon = 'knife' THEN case_number END)          FROM              incidents          WHERE              subject_statuses = 'Injured'     ) AS FLOAT ) /  (     SELECT         COUNT(CASE WHEN subject_weapon = 'handgun' THEN case_number END)      FROM          incidents      WHERE          subject_statuses = 'Injured' ); 
SELECT incidents.case_number FROM incidents JOIN subjects ON incidents.case_number = subjects.case_number WHERE substr(incidents.date, 1, 4) = '2012' AND subjects.subject_statuses = 'Deceased'; 
SELECT 100 * (     SELECT COUNT(*)      FROM officers      WHERE gender = 'M' AND race = 'B' ) / (     SELECT COUNT(*)      FROM officers      WHERE gender = 'M' ) as percentage_black_male_officers;
SELECT COUNT(DISTINCT incidents.case_number) FROM incidents JOIN officers ON incidents.case_number = officers.case_number JOIN subjects ON incidents.case_number = subjects.case_number WHERE subject_weapon = 'Vehicle' AND officers.gender = 'F';
SELECT COUNT(*) FROM incidents JOIN subjects ON incidents.case_number = subjects.case_number WHERE subjects.gender = 'F' AND incidents.subject_statuses = 'Deceased';
SELECT COUNT(DISTINCT officers.full_name) AS black_officers_investigated_cases_between_2010_and_2015 FROM officers JOIN incidents ON officers.case_number = incidents.case_number WHERE officers.race = 'B' AND incidents.date BETWEEN '2010-01-01' AND '2015-12-31';
SELECT COUNT(*) FROM incidents WHERE date BETWEEN '2015-06-01' AND '2015-06-30';
SELECT COUNT(DISTINCT subjects.full_name) AS num_injured FROM incidents JOIN subjects ON incidents.case_number = subjects.case_number WHERE incidents.date BETWEEN '2006-01-01' AND '2013-12-31' AND subjects.subject_statuses = 'injured' AND incidents.subject_weapon = 'handgun';
SELECT MAX(subject_weapon) AS most_common_weapon FROM incidents WHERE subject_statuses = 'Deceased';
SELECT (SELECT     (COUNT(*) * 100) / (SELECT COUNT(*) FROM officers)  FROM      officers  WHERE      race = 'W' AND gender = 'M') AS proportion_of_white_males,  (SELECT     (COUNT(*) * 100) / (SELECT COUNT(*) FROM officers)  FROM      officers  WHERE      race = 'W' AND gender = 'F') AS proportion_of_white_females;
SELECT COUNT(CASE WHEN subjects.race = 'B' AND subjects.gender = 'F' THEN 1 ELSE 0 END) - COUNT(CASE WHEN subjects.race = 'W' AND subjects.gender = 'F' THEN 1 ELSE 0 END) AS "More Black Female Victims Than White Female Victims" FROM incidents JOIN subjects ON incidents.case_number = subjects.case_number;
SELECT 100 * (     SELECT COUNT(*)     FROM incidents     WHERE subject_statuses = 'Deceased' AND subject_weapon = 'rifles' ) / (     SELECT COUNT(*)     FROM incidents     WHERE subject_statuses = 'Deceased' ) AS percentage_of_deaths_caused_by_rifles;
SELECT subject_weapon, subjects.race, subjects.gender FROM incidents JOIN subjects ON incidents.case_number = subjects.case_number WHERE incidents.case_number = '031347-2015'; 
SELECT incidents.case_number, incidents.location, subjects.race, subjects.gender FROM incidents JOIN officers ON incidents.case_number = officers.case_number JOIN subjects ON incidents.case_number = subjects.case_number WHERE officers.full_name = 'Ruben Fredirick' AND incidents.subject_statuses = 'Deceased Injured'; 
SELECT COUNT(DISTINCT officers.case_number) * 100.0 / COUNT(DISTINCT incidents.case_number) FROM officers JOIN incidents ON officers.case_number = incidents.case_number JOIN subjects ON incidents.case_number = subjects.case_number WHERE officers.gender = 'M' AND subjects.subject_statuses = 'Injured';
SELECT COUNT(DISTINCT genes.chromosome) AS num_chromosomes FROM genes JOIN classification ON genes.geneid = classification.geneid WHERE classification.localization = 'plasma membrane'; 
SELECT COUNT(*)  FROM genes  JOIN classification ON genes.geneid = classification.geneid  WHERE genes.essential = 'no' AND classification.localization = 'nucleus'; 
SELECT COUNT(DISTINCT genes.geneid) FROM   genes JOIN   classification ON genes.geneid = classification.geneid WHERE   classification.class = 'nucleic acid metabolism' AND   classification.localization = 'vacuole';
SELECT genes.localization FROM genes GROUP BY genes.localization ORDER BY COUNT(DISTINCT genes.chromosome) DESC LIMIT 1; 
SELECT MAX(expression_corr)  FROM interactions JOIN classification AS c1 ON interactions.geneid1 = c1.geneid JOIN classification AS c2 ON interactions.geneid2 = c2.geneid WHERE c1.localization = 'nucleus' AND c2.localization = 'nucleus'; 
SELECT genes.function FROM interactions JOIN genes ON interactions.geneid1 = genes.geneid JOIN classification ON genes.geneid = classification.geneid WHERE interactions.expression_corr = (     SELECT MIN(expression_corr) FROM interactions ); 
SELECT COUNT(*) FROM interactions JOIN genes AS g1 ON interactions.geneid1 = g1.geneid JOIN genes AS g2 ON interactions.geneid2 = g2.geneid WHERE g1.class != 'motorproteins' AND g2.class != 'motorproteins' AND expression_corr < 0;
SELECT MAX(expression_corr) FROM interactions WHERE      (geneid1 IN (SELECT geneid FROM genes WHERE chromosome = 8))     AND     (geneid2 IN (SELECT geneid FROM genes WHERE chromosome = 6))     OR     (geneid1 IN (SELECT geneid FROM genes WHERE chromosome = 6))     AND     (geneid2 IN (SELECT geneid FROM genes WHERE chromosome = 8)); 
SELECT motif FROM genes JOIN classification ON genes.geneid = classification.geneid WHERE genes.localization = 'cytoplasm' AND genes.chromosome = 7; 
SELECT COUNT(DISTINCT genes.geneid)  FROM genes  JOIN classification ON genes.geneid = classification.geneid  WHERE genes.essential = 0 AND genes.function = 'transcription' AND classification.localization != 'cytoplasm'; 
SELECT COUNT(*) FROM interactions JOIN genes AS gene1 ON interactions.geneid1 = gene1.geneid JOIN genes AS gene2 ON interactions.geneid2 = gene2.geneid JOIN classification AS class1 ON gene1.geneid = class1.geneid JOIN classification AS class2 ON gene2.geneid = class2.geneid WHERE gene1.essential = 'no' AND gene2.essential = 'no' AND interactions.expression_corr > 0;
SELECT COUNT(DISTINCT interactions.geneid1, interactions.geneid2) * 1.0 / COUNT(DISTINCT CASE WHEN genes1.chromosome > 10 AND genes2.chromosome > 10 THEN interactions.geneid1 END, CASE WHEN genes1.chromosome > 10 AND genes2.chromosome > 10 THEN interactions.geneid2 END) AS possibility FROM interactions JOIN genes AS genes1 ON interactions.geneid1 = genes1.geneid JOIN genes AS genes2 ON interactions.geneid2 = genes2.geneid WHERE interactions.expression_corr > 0;
SELECT AVG(expression_corr) AS avg_expression_corr FROM interactions JOIN genes AS gene1 ON interactions.geneid1 = gene1.geneid JOIN genes AS gene2 ON interactions.geneid2 = gene2.geneid WHERE gene1.class = 'ATPases' AND gene2.class = 'ATPases'; 
SELECT genes.geneid FROM genes JOIN classification ON genes.geneid = classification.geneid WHERE classification.localization = 'cytoplasm' AND genes.function = 'metabolism'; 
SELECT COUNT(DISTINCT genes.geneid) FROM genes JOIN classification ON genes.geneid = classification.geneid WHERE classification.localization IN ('plasma', 'nucleus'); 
SELECT COUNT(interactions.expression_corr) AS expression_corr_count, 100.0 * SUM(CASE WHEN interactions.expression_corr < 0 THEN 1 ELSE 0 END) / COUNT(interactions.expression_corr) AS percentage_negative_correlation FROM interactions WHERE interactions.type = 'physical';
SELECT COUNT(genes.geneid) FROM genes JOIN classification ON genes.geneid = classification.geneid WHERE genes.localization = 'cytoskeleton' AND classification.class IS NULL;  SELECT COUNT(genes.geneid) FROM genes JOIN classification ON genes.geneid = classification.geneid WHERE genes.localization = 'cytoskeleton' AND classification.class IS NULL AND genes.phenotype != 'conditional';
SELECT DISTINCT interactions.type FROM genes JOIN classification ON genes.geneid = classification.geneid JOIN interactions ON classification.geneid = interactions.geneid2 WHERE genes.function IN ('cellular transport', 'transport medicine') AND classification.essential = 'non-essential'; 
SELECT genes.geneid FROM genes JOIN interactions ON genes.geneid = interactions.geneid1 JOIN classification ON interactions.geneid2 = classification.geneid WHERE classification.localization = 'nucleus' AND interactions.expression_corr > 0;
SELECT COUNT(*)  FROM genes  JOIN classification ON genes.geneid = classification.geneid  JOIN interactions ON genes.geneid = interactions.geneid1  WHERE genes.essential = 1  AND classification.class = 'transcription factors'  AND classification.localization = 'nucleus'  AND interactions.type = 'genetic'; 
SELECT COUNT(DISTINCT genes.geneid) FROM genes JOIN classification ON genes.geneid = classification.geneid LEFT JOIN interactions ON genes.geneid = interactions.geneid1 AND classification.geneid = interactions.geneid2 WHERE genes.essential = 'no' AND genes.class != 'motorprotein' AND genes.phenotype = 'cell cycle defects' AND interactions.type IS NULL; 
SELECT 100 * (     SELECT COUNT(DISTINCT genes.geneid)     FROM genes     JOIN classification ON genes.geneid = classification.geneid     WHERE phenotype = 'nucleic acid metabolism defects'     AND motif = 'PS00107' ) / (     SELECT COUNT(DISTINCT genes.geneid)     FROM genes     JOIN classification ON genes.geneid = classification.geneid     JOIN interactions ON genes.geneid = interactions.geneid1 OR genes.geneid = interactions.geneid2     WHERE phenotype = 'nucleic acid metabolism defects'     AND motif = 'PS00107' )
SELECT ( COUNT(DISTINCT interactions.geneid1) * 1.0 / (SELECT COUNT(DISTINCT interactions.geneid1) FROM interactions JOIN genes ON interactions.geneid1 = genes.geneid WHERE genes.essential = 'yes')) * 100 AS Percentage_of_Essensity FROM interactions JOIN genes ON interactions.geneid1 = genes.geneid JOIN classification ON genes.geneid = classification.geneid WHERE interactions.expression_corr < 0 AND classification.essential = 'no'; 
SELECT COUNT(*) AS num_apps_updated_in_jan_2018, user_reviews.translated_review AS one_positive_review FROM playstore JOIN user_reviews ON playstore.app = user_reviews.app WHERE playstore.LastUpdated BETWEEN '2018-01-01' AND '2018-01-31' AND user_reviews.sentiment = 'Positive' LIMIT 1;
SELECT COUNT(*) AS "Number of Users Mildly Liking 7 Minute Workout App", MAX(playstore.last_updated) AS "Last Updated Date" FROM playstore INNER JOIN user_reviews ON playstore.app = user_reviews.app WHERE playstore.app = '7 Minute Workout' AND user_reviews.sentiment_polarity >= 0 AND user_reviews.sentiment_polarity < 0.5;
SELECT COUNT(user_reviews.app) AS neutral_users, playstore.rating FROM user_reviews INNER JOIN playstore ON user_reviews.app = playstore.app WHERE user_reviews.sentiment = 'Neutral' AND user_reviews.app = 'HTC Weather';
SELECT playstore.app, playstore.category FROM playstore JOIN (     SELECT        app,         COUNT(*) AS count_neg_one_sentiment     FROM         user_reviews     WHERE         sentiment_polarity = -1.0     GROUP BY         app     ORDER BY         count_neg_one_sentiment DESC     LIMIT 1 ) AS max_neg_one_sentiment ON playstore.app = max_neg_one_sentiment.app;
SELECT AVG(sentiment_polarity), content_rating FROM     user_reviews JOIN     playstore ON user_reviews.app = playstore.app WHERE     playstore.app = 'Cooking Fever';
SELECT MIN(sentiment_polarity) AS lowest_sentiment_polarity, installs AS number_of_downloads FROM playstore JOIN user_reviews ON playstore.app = user_reviews.app WHERE playstore.app = 'Basketball Stars' AND sentiment = 'Negative' AND sentiment_polarity < -0.5;
SELECT COUNT(user_reviews.translated_review) AS review_count, playstore.app AS current_version FROM playstore JOIN user_reviews ON playstore.app = user_reviews.app WHERE playstore.app = 'Akinator' AND user_reviews.sentiment_subjectivity <= 0.5;
SELECT COUNT(*) FROM playstore WHERE rating = 5;
SELECT app FROM playstore WHERE type = 'Free' ORDER BY installs DESC LIMIT 5;
SELECT app FROM playstore ORDER BY reviews DESC LIMIT 10; 
SELECT COUNT(user_reviews.sentiment) AS neutral_attitude_count, playstore.category FROM user_reviews JOIN playstore ON user_reviews.app = playstore.app WHERE user_reviews.app = "10 Best Foods for You" AND user_reviews.sentiment = 'Neutral';
SELECT playstore.app, SUM(CAST(playstore.installs AS INTEGER)) AS total_installs FROM playstore JOIN user_reviews ON playstore.app = user_reviews.app WHERE user_reviews.sentiment_polarity = 'Positive' GROUP BY playstore.app;
SELECT playstore.app, user_reviews.translated_review FROM playstore JOIN user_reviews ON playstore.app = user_reviews.app WHERE playstore.rating = 3.9; 
SELECT COUNT(playstore.app) AS num_apps, user_reviews.sentiment FROM playstore INNER JOIN user_reviews ON playstore.app = user_reviews.app WHERE playstore."Android Ver" = '8.0 and up' GROUP BY user_reviews.sentiment;
SELECT playstore.app, SUM(user_reviews.sentiment_subjectivity) AS total_sentiment_subjectivity FROM playstore JOIN user_reviews ON playstore.app = user_reviews.app GROUP BY playstore.app HAVING COUNT(playstore.genres) > 1; 
SELECT playstore.app, user_reviews.sentiment, user_reviews.sentiment_polarity, user_reviews.sentiment_subjectivity FROM playstore JOIN user_reviews ON playstore.app = user_reviews.app WHERE playstore.LastUpdated < '2015-01-01';
SELECT SUM(Installs), translated_review FROM playstore JOIN user_reviews ON playstore.app = user_reviews.app WHERE playstore.content_rating = 'Adults only 18+' GROUP BY playstore.app;
SELECT playstore.app, MAX(price * CAST(REPLACE(installs, ',', '') AS INTEGER)) AS revenue FROM playstore;
SELECT AVG(rating) AS average_rating, SUM(CASE WHEN sentiment = 'Positive' THEN 1 ELSE 0 END) AS positive_attitude_count FROM playstore JOIN user_reviews ON playstore.app = user_reviews.app WHERE category = 'COMICS';
SELECT rating FROM playstore WHERE app = 'Draw A Stickman';
SELECT COUNT(*) FROM     user_reviews WHERE     app = 'Brit + Co'     AND translated_review IS NOT NULL;
SELECT playstore.app, MAX(playstore.reviews) AS max_reviews FROM playstore WHERE playstore.genres = 'Shopping' GROUP BY playstore.app ORDER BY max_reviews DESC LIMIT 5; 
SELECT COUNT(*) FROM     user_reviews WHERE     app = 'Dino War: Rise of Beasts'     AND sentiment = 'Neutral';
SELECT app FROM playstore WHERE installs = '5,000+'; 
SELECT translated_review FROM user_reviews WHERE app = 'Dog Run - Pet Dog Simulator' AND sentiment = 'Negative'; 
SELECT playstore.app FROM playstore JOIN user_reviews ON playstore.app = user_reviews.app WHERE playstore.type = 'Free' AND user_reviews.sentiment = 'Negative' GROUP BY playstore.app ORDER BY COUNT(user_reviews.sentiment) DESC LIMIT 1; 
SELECT COUNT(*) FROM     user_reviews WHERE     app IN (SELECT app FROM playstore WHERE installs = '100,000,000+')     AND sentiment = 'Negative';
SELECT playstore.content_rating FROM playstore JOIN user_reviews ON playstore.app = user_reviews.app WHERE user_reviews.translated_review LIKE '%gr8%';
SELECT SUM(user_reviews.sentiment_polarity) FROM     playstore     JOIN user_reviews ON playstore.app = user_reviews.app WHERE     playstore.price = (         SELECT            MAX(price)         FROM             playstore     );
SELECT playstore.rating, user_reviews.translated_review FROM playstore JOIN user_reviews ON playstore.app = user_reviews.app WHERE playstore.app = 'Garden Coloring Book'; 
SELECT MAX(sum(Sentiment_Subjectivity)) AS total_subjectivity_score, app FROM (SELECT    p.app AS app,     SUM(ur.sentiment_subjectivity) AS sum_subjectivity FROM     playstore AS p JOIN     user_reviews AS ur ON p.app = ur.app WHERE     p.genres = 'Photography' GROUP BY     p.app) AS subquery;
SELECT translated_review FROM   user_reviews WHERE   app IN (     SELECT      app     FROM       playstore     WHERE       rating = 1       AND content_rating = 'Mature 17+'   ); 
SELECT SUM(installs) AS total_installs FROM     playstore WHERE     app IN (         SELECT            app         FROM             user_reviews         GROUP BY             app         ORDER BY             SUM(sentiment_polarity) DESC         LIMIT 1     )
SELECT COUNT(*) FROM     user_reviews JOIN     playstore ON user_reviews.app = playstore.app WHERE     playstore.genres = 'Weather'     AND user_reviews.sentiment = 'Neutral';
SELECT playstore.app, COUNT(user_reviews.translated_review) AS no_comment_reviews FROM playstore JOIN user_reviews ON playstore.app = user_reviews.app WHERE playstore.installs LIKE '1,000,000,000+' AND user_reviews.translated_review = 'nan' GROUP BY playstore.app ORDER BY no_comment_reviews DESC LIMIT 1;
SELECT playstore.rating, SUM(user_reviews.sentiment_subjectivity) AS total_sentiment_subjectivity FROM playstore JOIN user_reviews ON playstore.app = user_reviews.app WHERE playstore.app = 'Onefootball - Soccer Scores'; 
SELECT (DIVIDE((SELECT COUNT(*) FROM user_reviews WHERE translated_review = 'nan' AND app IN (SELECT app FROM playstore WHERE content_rating = 'Teen')), (SELECT COUNT(*) FROM user_reviews WHERE translated_review = 'nan')) * 100) AS percentage_of_no_comment_reviews_from_teen_apps;
SELECT app FROM playstore WHERE rating = 5; 
SELECT playstore.app FROM playstore JOIN user_reviews ON playstore.app = user_reviews.app WHERE playstore.reviews > 75000000 AND playstore.content_rating = 'Teen'; 
SELECT DISTINCT genres FROM playstore WHERE installs = '1,000,000,000+';
SELECT AVG(price) FROM playstore WHERE genres = 'Dating';
SELECT AVG(installs) FROM playstore WHERE category = 'ENTERTAINMENT' AND size <= '1.0M';
SELECT AVG(reviews) AS average_review_number FROM playstore WHERE rating = 5; 
SELECT genres, COUNT(*) AS genre_count FROM playstore JOIN user_reviews ON playstore.app = user_reviews.app WHERE sentiment_polarity > 0.5 GROUP BY genres ORDER BY genre_count DESC LIMIT 3; 
SELECT ROUND(     (         SELECT             COUNT(*) * 100.0 / (SELECT COUNT(*) FROM playstore WHERE rating = 4.7)          FROM              user_reviews          WHERE              app IN (SELECT app FROM playstore WHERE rating = 4.7)              AND sentiment = 'Positive'              AND sentiment_polarity > 0              AND sentiment_subjectivity > 0      ),     2 ) AS percentage; 
SELECT app, AVG(rating) AS average_rating FROM playstore LEFT JOIN user_reviews ON playstore.app = user_reviews.app WHERE sentiment != 'Negative' GROUP BY app;
SELECT app FROM playstore WHERE LastUpdated < '2015' 
SELECT (DIVIDE(SUM(CASE WHEN type = 'Free' AND rating >= 4.5 AND substr(last_updated, -4) <= '2018' THEN 1 ELSE 0 END), COUNT(app)) * 100) AS percent FROM playstore;
SELECT genres FROM playstore WHERE app = 'Honkai Impact 3rd'; 
SELECT rating FROM playstore WHERE app = 'Learn C++';
SELECT AVG(price) FROM playstore WHERE category = 'GAME' AND genres LIKE '%Arcade%' AND content_rating = 'Everyone 10+';
SELECT SUM(playstore.size) AS size_of_browser_4g, COUNT(user_reviews.sentiment_polarity) AS pretty_positive_users FROM playstore JOIN user_reviews ON playstore.app = user_reviews.app WHERE playstore.app = 'Browser 4G' AND user_reviews.sentiment_polarity = 0.5;
SELECT playstore.app, playstore.installs FROM playstore INNER JOIN user_reviews ON playstore.app = user_reviews.app WHERE user_reviews.sentiment_subjectivity = 0.3; 
SELECT AVG(sentiment_polarity) AS average_sentiment_polarity, playstore.rating FROM user_reviews JOIN playstore ON user_reviews.app = playstore.app WHERE playstore.app = 'Golf GPS Rangefinder: Golf Pad';
SELECT playstore.app, COUNT(user_reviews.sentiment) AS negative_sentiments FROM playstore JOIN user_reviews ON playstore.app = user_reviews.app WHERE playstore.genres LIKE '%Puzzle%' GROUP BY playstore.app ORDER BY MIN(playstore.rating) ASC LIMIT 5; 
SELECT  (SELECT ((SUM(CASE WHEN sentiment = 'Positive' THEN 1 ELSE 0 END) * 1.0) / (SUM(CASE WHEN sentiment = 'Negative' THEN 1 ELSE 0 END)) * 100) AS ratio, (SELECT MAX(app) FROM user_reviews WHERE app = 'Fate/Grand Order') AS current_version FROM user_reviews WHERE app = 'Fate/Grand Order'; 
SELECT SUM(CASE WHEN user_reviews.app = 'FREEDOME VPN Unlimited anonymous Wifi Security' AND user_reviews.sentiment = 'Positive' THEN 1 ELSE 0 END) AS positive_reviews_count, COUNT(*) AS total_reviews_count, playstore.installs FROM playstore JOIN user_reviews ON playstore.app = user_reviews.app WHERE playstore.app = 'FREEDOME VPN Unlimited anonymous Wifi Security';
SELECT MAX(sentiment_polarity) AS highest_sentiment_polarity, playstore.genres FROM user_reviews JOIN playstore ON user_reviews.app = playstore.app WHERE playstore.app = 'Honkai Impact 3rd';
SELECT rating, COUNT(*) AS disliked_users FROM playstore JOIN user_reviews ON playstore.app = user_reviews.app WHERE playstore.app = 'Dragon Ball Legends' AND user_reviews.sentiment_polarity < -0.5; 
SELECT app, translated_review FROM playstore JOIN user_reviews ON playstore.app = user_reviews.app WHERE category = 'EDUCATION' AND rating = 1 ORDER BY rating DESC LIMIT 1; 
SELECT user_reviews.translated_review, playstore.app FROM user_reviews INNER JOIN playstore ON user_reviews.app = playstore.app WHERE playstore.type = 'Free' AND playstore.category = 'SPORTS'; 
SELECT COUNT(playstore.app), AVG(sentiment_polarity) FROM playstore JOIN user_reviews ON playstore.app = user_reviews.app WHERE playstore.genres LIKE '%Role Playing%' AND playstore.content_rating = 'Teen';
SELECT AVG(rating) AS average_rating, (SUM(CASE WHEN sentiment = 'Positive' THEN 1 ELSE 0 END) * 100 / COUNT(*)) AS positive_sentiment_percentage FROM playstore INNER JOIN user_reviews ON playstore.app = user_reviews.app WHERE genres LIKE '%Racing%'; 
SELECT regions.region FROM sales_team JOIN regions ON sales_team.region = regions.statecode GROUP BY regions.region ORDER BY COUNT(sales_team.salesteamid) DESC LIMIT 1;
SELECT customers.customerid, customers.customername FROM customers WHERE customers.customername LIKE '%Group%'; 
SELECT AVG(store_locations."median income")  FROM      store_locations WHERE      store_locations.type = 'City';
SELECT sales_team.sales_team, sales_team.region FROM sales_orders JOIN sales_team ON sales_orders._salesteamid = sales_team.salesteamid WHERE sales_orders.ordernumber = 'SO - 000137';
SELECT sales_orders.ordernumber, products.product_name FROM sales_orders JOIN products ON sales_orders._productid = products.productid JOIN sales_team ON sales_orders._salesteamid = sales_team.salesteamid WHERE sales_team.sales_team = 'Douglas Tucker'; 
SELECT customers.customername FROM sales_orders JOIN products ON sales_orders._productid = products.productid JOIN customers ON sales_orders._customerid = customers.customerid WHERE products.productname = 'Cocktail Glasses' AND sales_orders.orderdate BETWEEN '2020-01-01' AND '2020-12-31' AND sales_orders.discountapplied = (     SELECT MAX(discountapplied)     FROM sales_orders     JOIN products ON sales_orders._productid = products.productid     WHERE products.productname = 'Cocktail Glasses'     AND sales_orders.orderdate BETWEEN '2020-01-01' AND '2020-12-31' ); 
SELECT sales_orders.ordernumber, store_locations.cityname FROM sales_orders JOIN store_locations ON sales_orders._storeid = store_locations.storeid WHERE sales_orders.saleschannel = 'In-Store';
SELECT MAX(unit_cost) AS max_unit_cost, customer_names AS customer_name, orderdate AS order_date FROM sales_orders JOIN customers ON sales_orders._customerid = customers.customerid WHERE unit_cost = (SELECT MAX(unit_cost) FROM sales_orders)
SELECT sales_orders.ordernumber FROM sales_orders JOIN customers ON sales_orders._customerid = customers.customerid WHERE customers.customername = 'Rochester Ltd' AND SUBSTR(sales_orders.orderdate, -2) = '18';
SELECT sales_orders.ordernumber, products.productname, sales_team.salesteam FROM sales_orders JOIN products ON sales_orders._productid = products.productid JOIN sales_team ON sales_orders._salesteamid = sales_team.salesteamid WHERE sales_orders.warehousecode = 'WARE-NMK1003';
SELECT customers.customer_name FROM sales_orders JOIN customers ON sales_orders._customerid = customers.customerid WHERE sales_orders.sales_channel = 'Online';
SELECT AVG(unit price - unit cost) AS average_net_profit FROM sales_orders JOIN products ON sales_orders._productid = products.productid WHERE product name = 'Bakeware';
SELECT MAX(sales_team.sales_team) AS top_sales_team_name FROM sales_orders JOIN sales_team ON sales_orders._salesteamid = sales_team.salesteamid WHERE orderdate LIKE '%/20' GROUP BY _salessteamid HAVING SUM(unit_price - unit_cost) = (     SELECT    MAX(total_profit)     FROM     (SELECT        _salesteamid,         SUM(unit_price - unit_cost) AS total_profit     FROM         sales_orders     WHERE         orderdate LIKE '%/20'     GROUP BY         _salesteamid) AS profits )
SELECT sales_orders.ordernumber, (sales_orders.unitprice - sales_orders.unitcost) AS net_profit FROM sales_orders JOIN sales_team ON sales_orders._salesteamid = sales_team.salesteamid JOIN customers ON sales_orders._customerid = customers.customerid WHERE sales_team.salesteam = 'Joshua Bennett';
SELECT (SELECT     (COUNT(so.ordernumber) * 100.0 /          (SELECT COUNT(so2.ordernumber)           FROM sales_orders AS so2           WHERE SUBSTR(so2.shipdate, -2) = '18' AND strftime('%m', so2.shipdate) = '07'))      AS percentage  FROM      sales_orders AS so  JOIN      products AS p ON so._productid = p.productid  WHERE      p.productname = 'Home Fragrances' AND strftime('%m', so.orderdate) = '07'      AND strftime('%Y', so.shipdate) = '2018'); 
SELECT customers.customerid, customers.customername FROM customers WHERE customers.customername LIKE 'W%';
SELECT products.productid, products.productname FROM products WHERE products.productname LIKE '%Outdoor%'
SELECT COUNT(sales_orders._productid) AS shipped_products FROM sales_orders INNER JOIN products ON sales_orders._productid = products.productid INNER JOIN store_locations ON sales_orders._storeid = store_locations.storeid WHERE sales_orders.discount_applied = 0.4 AND sales_orders.sales_channel = 'In-Store' AND sales_orders.warehousecode = 'WARE-NMK1003';
SELECT MAX(population) AS most_populated_city, median_income FROM store_locations WHERE statecode = 'FL';
SELECT storeid, cityname, region FROM storelocations JOIN regions ON storelocations.statecode = regions.statecode WHERE county = 'Allen';
SELECT store_locations.storeid, store_locations.city_name, store_locations.statecode, regions.region FROM store_locations JOIN regions ON store_locations.statecode = regions.statecode WHERE store_locations.type IN ('Borough', 'CDP') GROUP BY store_locations.type ORDER BY COUNT(store_locations.storeid) ASC LIMIT 1;
SELECT regions.region, sales_team.sales_team FROM sales_orders JOIN customers ON sales_orders._customerid = customers.customerid JOIN sales_team ON sales_orders._salesteamid = sales_team.salesteamid JOIN store_locations ON sales_orders._storeid = store_locations.storeid JOIN regions ON store_locations.statecode = regions.statecode WHERE sales_orders._salesteamid = 18 GROUP BY regions.region, sales_team.sales_team HAVING COUNT(CASE WHEN sales_orders.sales_channel = 'In-Store' THEN sales_orders.ordernumber END) > COUNT(CASE WHEN sales_orders.sales_channel = 'Online' THEN sales_orders.ordernumber END);
SELECT ROUND(     (COUNT(CASE WHEN sales_orders.sales_channel = 'In-Store' THEN sales_orders.ordernumber END) * 100.0 / COUNT(sales_orders.ordernumber)),     2 ) AS percentage FROM sales_orders JOIN customers ON sales_orders._customerid = customers.customerid WHERE customers.customer_names = 'Medline';
SELECT customers.customerid, customers.customername, strftime('%d', deliverydate, '-' || substr(orderdate, 1, 7)) - strftime('%d', orderdate) AS delivery_period FROM sales_orders JOIN products ON sales_orders._productid = products.productid JOIN customers ON sales_orders._customerid = customers.customerid WHERE sales_orders.saleschannel = 'Wholesale' AND products.productname = 'Bedroom Furniture' AND substr(sales_orders.orderdate, -2) = '19'; 
SELECT customers.customername, products.productname FROM customers JOIN sales_orders ON customers.customerid = sales_orders._customerid JOIN products ON sales_orders._productid = products.productid WHERE (sales_orders.unitprice - sales_orders.unitcost) * sales_orders.orderquantity > 3800; 
SELECT store locations.city_name, regions.region FROM store locations JOIN regions ON store locations.statecode = regions.statecode WHERE store locations.state = 'California' AND store locations.water_area = 0;
SELECT (     (SELECT COUNT(ordernumber)       FROM sales_orders       WHERE _salesteamid = (SELECT salesteamid                             FROM sales_team                             WHERE sales_team = 'Carlos Miller')     ) * 100.0 ) / (     SELECT COUNT(ordernumber)      FROM sales_orders ) as percentage;
SELECT COUNT(ordernumber)  FROM sales_orders  WHERE _productid IN (SELECT productid FROM products WHERE productname = 'Platters') > COUNT(ordernumber)  FROM sales_orders  WHERE _productid IN (SELECT productid FROM products WHERE productname = 'Serveware');
SELECT SUM((unit_price - unit_cost) * order_quantity) AS total_net_profit FROM     store_locations JOIN     sales_orders ON store_locations.storeid = sales_orders._storeid JOIN     regions ON store_locations.statecode = regions.statecode JOIN     customers ON sales_orders._customerid = customers.customerid JOIN     sales_team ON sales_orders._salesteamid = sales_team.salesteamid WHERE     store_locations.city_name = (         SELECT            city_name         FROM             store_locations         WHERE             household_income = (                 SELECT                    MAX(median_income)                 FROM                     store_locations             )     );
SELECT COUNT(ordernumber) AS num_orders FROM     sales_orders WHERE     _salesteamid BETWEEN 1 AND 9     AND _salesteamid IN (         SELECT            salesteamid         FROM             sales_team         WHERE             region = 'South'     );
SELECT COUNT(*) FROM sales_orders WHERE orderdate = '2018-05-31';
SELECT ordernumber FROM sales orders WHERE deliverydate = '2018-06-13'; 
SELECT COUNT(ordernumber) FROM sales_orders WHERE order_quantity > 5;
SELECT state FROM regions WHERE statecode = 'GA'; 
SELECT COUNT(DISTINCT regions.state)  FROM regions  WHERE region = 'Midwest';
SELECT products.productname FROM salesorders JOIN products ON salesorders._productid = products.productid WHERE salesorders.unitcost = 781.22; 
SELECT deliverydate FROM sales_orders JOIN products ON sales_orders._productid = products.productid WHERE products.product_name = 'Cookware';
SELECT COUNT(*) FROM     sales_orders JOIN     products ON sales_orders._productid = products.productid WHERE     products.productname = 'Furniture Cushions'     AND SUBSTR(OrderDate, -2) = '18';
SELECT products.product_name FROM sales_orders JOIN products ON sales_orders._productid = products.productid WHERE sales_orders.discount_applied = 0.1;
SELECT AVG(UnitPrice - UnitCost) AS average_net_profit FROM sales_orders JOIN products ON sales_orders._productid = products.productid WHERE products.productname = 'Phones' AND sales_orders.saleschannel = 'Distributor';
SELECT AVG(UnitPrice - UnitCost) AS avg_net_profit FROM sales_orders JOIN products ON sales_orders._productid = products.productid WHERE products.productname = 'Bar Tools' AND orderquantity > 5;
SELECT cityname FROM storelocations JOIN regions ON storelocations.statecode = regions.statecode WHERE regions.region = 'South'; 
SELECT region FROM store_locations JOIN regions ON store_locations.statecode = regions.statecode WHERE type = "Town";
SELECT COUNT(*) FROM     sales_orders JOIN     customers ON sales_orders._customerid = customers.customerid WHERE     customers.customername = 'Medsep Group';
SELECT DISTINCT discount_applied FROM sales_orders JOIN customers ON sales_orders._customerid = customers.customerid WHERE customers.customer_name = 'Ole Group' AND discount_applied IS NOT NULL; 
SELECT customers.customername FROM sales_orders INNER JOIN customers ON sales_orders._customerid = customers.customerid WHERE sales_orders.shipdate = '7/8/18';
SELECT COUNT(*)  FROM sales_orders  JOIN customers ON sales_orders._customerid = customers.customerid  WHERE customers.customer_name = 'Ei' AND order_quantity > 4;
SELECT COUNT(*) AS num_orders_with_discount FROM     sales_orders AS so     JOIN customers AS c ON so._customerid = c.customerid WHERE     c.customer_names = 'Pacific Ltd'     AND so.discount_applied = 0.05;
SELECT customers.customername FROM sales_orders JOIN customers ON sales_orders._customerid = customers.customerid WHERE sales_orders.unit_cost > 4000;
SELECT storeid, latitude, longitude FROM store_locations WHERE city_name = 'Birmingham';
SELECT MAX(city_name) FROM     store_locations WHERE     population = (SELECT MAX(population) FROM store_locations);
SELECT COUNT(DISTINCT storeid) FROM     store_locations WHERE     state = 'California'     AND type = 'CDP';
SELECT sales_orders.ordernumber, products.productname FROM sales_orders JOIN products ON sales_orders._productid = products.productid WHERE sales_orders.unitprice = (     SELECT MIN(unitprice)     FROM sales_orders )
SELECT MAX((UnitPrice - UnitCost)) AS NetProfit, ProductID FROM salesorders WHERE OrderDate LIKE '%/19' GROUP BY ProductID ORDER BY NetProfit DESC LIMIT 1;
SELECT AVG(unit price)  FROM sales orders  JOIN products ON sales orders._productid = products.productid  WHERE product name = 'Cookware';
SELECT sales_team.sales_team FROM sales_orders INNER JOIN sales_team ON sales_orders._salesteamid = sales_team.salesteamid WHERE sales_orders.orderdate = '5/31/18';
SELECT MIN(sales_team.sales_team) FROM     sales_orders JOIN     sales_team ON sales_orders._salesteamid = sales_team.salesteamid WHERE     SUBSTR(sales_orders.orderdate, -2) = '19' GROUP BY     sales_team.sales_team;
SELECT COUNT(SalesOrders.OrderNumber) AS OrderCount, SUBSTR(SalesOrders.OrderDate, -2) AS Year FROM SalesOrders JOIN SalesTeam ON SalesOrders._Salesteamid = SalesTeam.Salesteamid WHERE SalesTeam.SalesTeam = 'George Lewis' AND SUBSTR(SalesOrders.OrderDate, -2) IN ('18', '19', '20') GROUP BY SUBSTR(SalesOrders.OrderDate, -2) ORDER BY OrderCount DESC LIMIT 1;
SELECT (DIVIDE(COUNT(ordernumber), (SELECT COUNT(ordernumber) FROM sales_orders WHERE SUBSTR(orderdate, -2) = '18'))) AS percentage FROM sales_orders JOIN store_locations ON sales_orders._storeid = store_locations.storeid WHERE store_locations.county = 'Orange County' AND SUBSTR(orderdate, -2) = '18';
SELECT MAX(ordernumber) FROM sales orders WHERE unit price = ( SELECT MAX(unit price) FROM sales orders )
SELECT MAX(_salesteamid) AS highest_sales_team_id FROM (     SELECT _salesteamid, COUNT(ordernumber) AS num_orders     FROM sales_orders     WHERE SUBSTR(orderdate, -2) = '18'     GROUP BY _salesteamid ) as order_counts;
SELECT unit_cost FROM sales_orders WHERE ordernumber = 'SO - 000103';
SELECT COUNT(ordernumber) AS total_orders FROM sales_orders JOIN store_locations ON sales_orders._storeid = store_locations.storeid JOIN regions ON store_locations.statecode = regions.statecode WHERE county = 'Maricopa' AND SUBSTR(orderdate, -2) = '20';
SELECT store_locations.latitude, store_locations.longitude, store_locations.city_name, store_locations.county, store_locations.state, store_locations.type FROM store_locations JOIN sales_orders ON store_locations.storeid = sales_orders._storeid WHERE sales_orders.ordernumber = 'SO - 000115';
SELECT store_locations.city_name, COUNT(sales_orders.ordernumber) AS total_orders FROM store_locations JOIN sales_orders ON store_locations.storeid = sales_orders._storeid WHERE sales_orders.orderdate BETWEEN '2019-01-01' AND '2019-12-31' GROUP BY store_locations.city_name; 
SELECT customers.customername FROM customers JOIN sales_orders ON customers.customerid = sales_orders._customerid WHERE SUBSTR(sales_orders.orderdate, -2) = '18' GROUP BY customers.customerid HAVING COUNT(sales_orders.ordernumber) > 3;
SELECT COUNT(ordernumber) AS total_orders FROM sales_orders JOIN customers ON sales_orders._customerid = customers.customerid WHERE customers.customername = 'Medsep Group' AND SUBSTR(orderdate, -2) IN ('18', '19', '20');
SELECT customers.customername FROM     customers JOIN     sales_orders ON customers.customerid = sales_orders._customerid WHERE     sales_orders.orderquantity > 5     AND sales_orders.orderdate = '2018-06-01';
SELECT COUNT(CASE WHEN (s.unit_price - s.unit_cost) > 1000 THEN s.ordernumber END) * 100.0 / COUNT(s.ordernumber) FROM sales_orders s JOIN sales_team st ON s._salesteamid = st.salesteamid WHERE st.sales_team = 'Stephen Payne';
SELECT COUNT(DISTINCT sales_team.salesteamid)  FROM      sales_team  JOIN      regions ON sales_team.region = regions.region  WHERE      regions.region = 'Northeast';
SELECT city_name, latitude, longitude FROM store_locations WHERE county = 'Maricopa'; 
SELECT MAX(ordernumber) FROM sales_orders WHERE unit_cost = (     SELECT MAX(unit_cost)     FROM sales_orders );
SELECT product name FROM products WHERE productid BETWEEN 30 AND 40;
SELECT DIVIDE(MAX(unit_cost), MIN(unit_cost)) AS cost_ratio FROM sales_orders;
SELECT MAX(product_name) FROM     (SELECT        products.product_name,         COUNT(sales_orders.ordernumber) AS order_count     FROM         sales_orders     JOIN products ON sales_orders._productid = products.productid     WHERE         SUBSTR(sales_orders.orderdate, -2) = '18'     GROUP BY         products.product_name     ORDER BY         order_count DESC     LIMIT 1);
SELECT SUM(order_quantity) FROM sales_orders JOIN sales_team ON sales_orders._salesteamid = sales_team.salesteamid WHERE sales_team.sales_team = 'Adam Hernandez';
SELECT sales_orders.ordernumber FROM sales_orders JOIN store_locations ON sales_orders._storeid = store_locations.storeid WHERE store_locations.cityname = 'Daly City';
SELECT COUNT(ordernumber) AS "Number of Orders Made by Rochester Ltd" FROM     sales_orders JOIN     customers ON sales_orders._customerid = customers.customerid WHERE     customers.customername = 'Rochester Ltd';
SELECT sales_orders.ordernumber FROM     sales_orders JOIN     customers ON sales_orders._customerid = customers.customerid WHERE     customers.customername = 'Qualitest' ORDER BY     sales_orders.orderquantity DESC LIMIT 1;
SELECT sales_orders.ordernumber, products.product_name FROM sales_orders JOIN products ON sales_orders._productid = products.productid WHERE sales_orders.sales_channel = 'In-Store';
SELECT COUNT(*) AS online_sales_may_2018_from_norman FROM     sales_orders AS so JOIN     store_locations AS sl ON so._storeid = sl.storeid WHERE     so.sales_channel = 'Online'     AND so.orderdate LIKE '5/%/18'     AND sl.city_name = 'Norman';
SELECT products.productname FROM products JOIN sales_orders ON products.productid = sales_orders._productid JOIN store_locations ON sales_orders._storeid = store_locations.storeid JOIN regions ON store_locations.statecode = regions.statecode WHERE regions.county = 'Maricopa County' GROUP BY products.productname ORDER BY SUM(sales_orders.orderquantity) ASC LIMIT 1;
SELECT ordernumber FROM sales orders JOIN sales team ON sales orders._salesteamid = sales team.salesteamid WHERE sales team.sales team = 'Samuel Fowler' 
SELECT COUNT(sales_orders.orderquantity) AS baseball_orders FROM     sales_orders JOIN     products ON sales_orders._productid = products.productid WHERE     products.productname = 'Baseball'     AND sales_orders.orderdate LIKE '12/%/17';
SELECT AVG(order_quantity / 12) AS average_ornaments_sold_per_month_2018 FROM sales_orders JOIN products ON sales_orders._productid = products.productid WHERE products.product_name = 'Ornaments' AND orderdate LIKE '%/18';
SELECT (ROUND((CAST((SELECT SUM("Order Quantity") FROM sales_orders  WHERE _storeid IN (SELECT storeid FROM store_locations WHERE "City Name" = 'Burbank')  AND SUBSTR(OrderDate, -4) = '2018') AS REAL) /  (CAST((SELECT SUM("Order Quantity") FROM sales_orders WHERE SUBSTR(OrderDate, -4) = '2018') AS REAL)) * 100), 2)) as percentage;
SELECT COUNT(CASE WHEN warehousecode = 'WARE-MKL1006' THEN ordernumber END) - COUNT(CASE WHEN warehousecode = 'WARE-NBV1002' THEN ordernumber END) AS difference_in_order_number
SELECT products.product name FROM sales orders JOIN products ON sales orders._productid = products.productid JOIN customers ON sales orders._customerid = customers.customerid WHERE customers.customer names = 'Sundial' AND deliverydate LIKE '%/21'; 
SELECT store locations.storeid, regions.region FROM store locations JOIN regions ON store locations.statecode = regions.statecode WHERE regions.state = "Michigan";
SELECT COUNT(sales_orders.ordernumber) FROM     sales_orders     INNER JOIN customers ON sales_orders._customerid = customers.customerid WHERE     customers.customername = 'Apollo Ltd'     OR customers.customername = 'Pacific Ltd';
SELECT MAX(Count(ordernumber)) AS max_orders, _storeid FROM sales_orders JOIN store_locations ON sales_orders._storeid = store_locations.storeid WHERE city_name IN ('Aurora (Township)', 'Babylon (Town)') GROUP BY _storeid ORDER BY max_orders DESC LIMIT 1;
SELECT customers.customername, products.productname FROM sales_orders JOIN customers ON sales_orders._customerid = customers.customerid JOIN products ON sales_orders._productid = products.productid JOIN sales_team ON sales_orders._salesteamid = sales_team.salesteamid WHERE sales_team.salesteam = 'Anthony Torres' AND sales_orders.saleschannel = 'Distributor';
SELECT customers.customerid, customers.customername FROM customers JOIN sales_orders ON customers.customerid = sales_orders._customerid JOIN sales_team ON sales_orders._salesteamid = sales_team.salesteamid WHERE sales_orders.saleschannel = 'online' GROUP BY customers.customerid, customers.customername HAVING SUM((sales_orders.unitprice - sales_orders.unitcost) * sales_orders.orderquantity) > 5000;
SELECT SUM((UnitPrice - UnitCost) * OrderQuantity) AS net_profit FROM     sales_orders JOIN     products ON sales_orders._productid = products.productid WHERE     products.productname = 'Floral'     AND deliverydate LIKE '%/21'
SELECT COUNT(ordernumber) AS order_count FROM sales_orders INNER JOIN store_locations ON sales_orders._storeid = store_locations.storeid WHERE population BETWEEN 3000000 AND 4000000;
SELECT products.product_name FROM sales_orders JOIN products ON sales_orders._productid = products.productid JOIN store_locations ON sales_orders._storeid = store_locations.storeid JOIN regions ON store_locations.statecode = regions.statecode WHERE sales_orders.sales_channel = 'Wholesale' AND regions.time_zone = 'Pacific/Honolulu';
SELECT sales_orders.ordernumber, products.productname FROM sales_orders JOIN products ON sales_orders._productid = products.productid WHERE sales_orders.orderdate = '6/5/18';
SELECT AVG(COUNT(ordernumber) / 3) AS average_yearly_order FROM sales_orders JOIN customers ON sales_orders._customerid = customers.customerid WHERE customers.customer_names = 'Weimei Corp' AND SUBSTR(orderdate, -2) IN ('18', '19', '20') GROUP BY customers.customerid;
SELECT AVG(CASE WHEN SUBSTR(OrderDate, -2) = '19' THEN 1 ELSE 0 END) AS average_monthly_order, (COUNT(CASE WHEN WarehouseCode = 'WARE-NMK1003' AND SUBSTR(OrderDate, -2) = '19' THEN 1 END) / COUNT(OrderNumber)) * 100 AS warehouse_percentage, COUNT(CASE WHEN ProductName = 'Floor Lamps' THEN OrderNumber END) AS floor_lamps_orders FROM sales_orders WHERE SUBSTR(OrderDate, -2) = '19';
SELECT procureddate FROM sales_orders WHERE _customerid = 11;
SELECT COUNT(*) FROM sales_orders WHERE sales_channel = 'Distributor' AND order_quantity = (SELECT MIN(order_quantity) FROM sales_orders);
SELECT sales_team.salesteamid FROM sales_team INNER JOIN sales_orders ON sales_team.salesteamid = sales_orders._salesteamid INNER JOIN products ON sales_orders._productid = products.productid INNER JOIN store_locations ON sales_orders._storeid = store_locations.storeid WHERE sales_orders.discount_applied = 0.1 AND sales_orders.sales_channel = 'In-Store';
SELECT COUNT(storeid) FROM store_locations WHERE city_name = 'Brooklyn' AND type = 'Borough' AND population < 3000000;
SELECT COUNT(DISTINCT state) FROM regions WHERE region = 'Midwest';
SELECT products.product_name, MAX((sales_orders.unit_price - sales_orders.unit_cost) * sales_orders.order_quantity) AS net_profit FROM sales_orders JOIN products ON sales_orders._productid = products.productid GROUP BY products.product_name ORDER BY net_profit DESC LIMIT 10; 
SELECT customers.customername FROM customers JOIN sales_orders ON customers.customerid = sales_orders._customerid WHERE sales_orders.orderquantity = 3 AND sales_orders.orderdate LIKE '2/%/18';
SELECT sales_team.sales_team FROM sales_team JOIN sales_orders ON sales_team.salesteamid = sales_orders._salesteamid JOIN customers ON sales_orders._customerid = customers.customerid WHERE customers.customer_names = 'Apotheca, Ltd';
SELECT regions.region FROM regions JOIN store_locations ON regions.statecode = store_locations.statecode JOIN sales_orders ON store_locations.storeid = sales_orders._storeid WHERE sales_orders.warehousecode = 'WARE-UHY1004' GROUP BY regions.region;
SELECT store_locations.city_name FROM sales_orders JOIN sales_team ON sales_orders._salesteamid = sales_team.salesteamid JOIN store_locations ON sales_orders._storeid = store_locations.storeid JOIN products ON sales_orders._productid = products.productid WHERE sales_team.sales_team = 'Shawn Torres' AND products.product_name = 'Audio';
SELECT products.productname, customers.customername FROM salesorders JOIN products ON salesorders._productid = products.productid JOIN customers ON salesorders._customerid = customers.customerid WHERE salesorders.orderdate = '10/21/18' AND salesorders.deliverydate = '11/21/19';
SELECT COUNT(DISTINCT storeid) FROM     sales_orders JOIN     store_locations ON sales_orders._storeid = store_locations.storeid WHERE     procureddate = '10/27/18'     AND state = 'Oregon';
SELECT salesorders.saleschannel FROM salesorders JOIN storelocations ON salesorders._storeid = storelocations.storeid JOIN regions ON storelocations.statecode = regions.statecode WHERE regions.state IN ( SELECT regions.state FROM regions ORDER BY regions.medianincome DESC LIMIT 3 )
SELECT sales_team, SUM((unit_price - unit_cost) * order_quantity * (1 - discount_applied)) AS net_profit FROM sales_orders GROUP BY _salesteamid ORDER BY net_profit DESC LIMIT 5; 
SELECT MAX(discount_applied) AS highest_discount FROM     sales_orders JOIN     store_locations ON sales_orders._storeid = store_locations.storeid JOIN     regions ON store_locations.statecode = regions.statecode WHERE     regions.state = 'Colorado'     AND store_locations.land_area = 111039036;
SELECT COUNT(DISTINCT time_zone)  FROM regions  JOIN sales_team ON regions.region = sales_team.region  JOIN store_locations ON regions.statecode = store_locations.statecode  WHERE regions.region = 'Northeast';
SELECT MAX(COUNT(type)) AS popular_store_type FROM     store_locations WHERE     statecode IN (         SELECT            statecode         FROM             regions         WHERE             region = 'South'     ) GROUP BY     type;
SELECT regions.region FROM sales_orders JOIN sales_team ON sales_orders._salesteamid = sales_team.salesteamid JOIN store_locations ON sales_orders._storeid = store_locations.storeid JOIN regions ON store_locations.statecode = regions.statecode WHERE sales_orders.warehousecode = 'WARE-MKL1006' GROUP BY regions.region ORDER BY COUNT(*) DESC LIMIT 1;
SELECT MAX(store_locations.city_name) FROM   store_locations JOIN   sales_orders ON store_locations.storeid = sales_orders._storeid WHERE   sales_orders.unit_price = (SELECT MAX(unit_price) FROM sales_orders)
SELECT COUNT(*) FROM     sales_orders JOIN     customers ON sales_orders._customerid = customers.customerid WHERE     customers.customer_names = 'Ole Group'     AND sales_orders.sales_channel = 'Online'     AND sales_orders.orderdate LIKE '5/%/19';
SELECT COUNT(DISTINCT storeid) AS num_stores FROM sales_orders JOIN store_locations ON sales_orders._storeid = store_locations.storeid JOIN regions ON store_locations.statecode = regions.statecode WHERE order_quantity = 1 AND sales_channel = 'Distributor' AND county = 'Washtenaw County';
SELECT MIN(products.product_name) FROM     sales_orders JOIN     store_locations ON sales_orders._storeid = store_locations.storeid JOIN     products ON sales_orders._productid = products.productid WHERE     store_locations.city_name = 'Santa Clarita' GROUP BY     products.product_name ORDER BY     COUNT(*) ASC LIMIT 1;
SELECT store locations.latitude, store locations.longitude FROM store locations JOIN sales orders ON store locations.storeid = sales orders._storeid WHERE sales orders.warehousecode = 'WARE-PUJ1005' GROUP BY store locations.latitude, store locations.longitude ORDER BY COUNT(sales orders.warehousecode) LIMIT 1;
SELECT (SUM(CASE WHEN store_locations.state = 'New York' AND sales_orders.orderdate = '4/4/20' THEN 1 ELSE 0 END) / COUNT(sales_orders.ordernumber)) * 100 AS percentage_sold_in_NY_on_04042020 FROM sales_orders JOIN store_locations ON sales_orders._storeid = store_locations.storeid WHERE sales_orders.orderdate = '4/4/20';
SELECT AVG(land area)  FROM      store locations JOIN      sales orders ON store locations.storeid = sales orders._storeid JOIN      products ON sales orders._productid = products.productid WHERE      products.unit price = 998.30;
SELECT AVG(household_income) AS average_household_income FROM     store_locations JOIN regions ON store_locations.statecode = regions.statecode WHERE     regions.state = 'New Hampshire' AND store_locations.type = 'city';
SELECT COUNT(DISTINCT sales_team.salesteamid) AS num_sales_teams FROM sales_team JOIN regions ON sales_team.region = regions.region WHERE regions.region = 'Midwest';
SELECT ordernumber FROM sales orders WHERE orderdate > '2018-01-01'; 
SELECT COUNT(DISTINCT sales_orders.sales_channel) FROM     sales_team JOIN     regions ON sales_team.region = regions.region JOIN     sales_orders ON sales_team.salesteamid = sales_orders._salesteamid WHERE     regions.region = 'Midwest';
SELECT sales_team.sales_team FROM sales_team INNER JOIN sales_orders ON sales_team.salesteamid = sales_orders._salesteamid WHERE sales_orders.unit_price = (SELECT MAX(unit_price) FROM sales_orders)
SELECT regions.state FROM regions JOIN sales_team ON regions.statecode = sales_team.region JOIN sales_orders ON sales_team.salesteamid = sales_orders._salesteamid WHERE sales_orders.sales_channel = 'online' GROUP BY regions.state ORDER BY MAX(sales_orders.discount_applied) DESC;
SELECT customers.customername, salesorders.ordernumber, MAX(salesorders.unitprice) AS max_unit_price, salesorders.orderdate FROM customers JOIN salesorders ON customers.customerid = salesorders._customerid JOIN products ON salesorders._productid = products.productid WHERE customers.customername = 'Apollo Ltd' GROUP BY customers.customername ORDER BY max_unit_price DESC LIMIT 1;
SELECT sales_orders.ordernumber, sales_orders.warehousecode FROM sales_orders JOIN customers ON sales_orders._customerid = customers.customerid WHERE customers.customername = 'Elorac, Corp';
SELECT customers.customername FROM customers JOIN sales_orders ON customers.customerid = sales_orders._customerid JOIN products ON sales_orders._productid = products.productid WHERE products.productname = 'Cocktail Glasses' AND sales_orders.saleschannel = 'online';
SELECT storeid, MAX((unitprice - unitcost) * orderquantity) AS net_profit FROM salesorders JOIN storelocations ON salesorders._storeid = storelocations.storeid JOIN regions ON storelocations.statecode = regions.statecode WHERE regions.state = 'Arizona' GROUP BY storeid;
SELECT ROUND((     SELECT unit_price     FROM sales_orders     JOIN store_locations ON sales_orders._storeid = store_locations.storeid     WHERE state = 'Florida' AND products._productid = sales_orders._productid ) - (     SELECT unit_price     FROM sales_orders     JOIN store_locations ON sales_orders._storeid = store_locations.storeid     WHERE state = 'Texas' AND products._productid = sales_orders._productid ), 2) AS price_difference;
SELECT sales_team.sales_team, SUM(sales_orders.order_quantity) AS total_order_quantity FROM sales_team JOIN regions ON sales_team.region = regions.region JOIN sales_orders ON sales_team.salesteamid = sales_orders._salesteamid WHERE regions.region = 'Midwest' GROUP BY sales_team.sales_team HAVING total_order_quantity > 5;
SELECT storeid FROM store_locations JOIN regions ON store_locations.statecode = regions.statecode JOIN sales_orders ON store_locations.storeid = sales_orders._storeid JOIN sales_team ON sales_orders._salesteamid = sales_team.salesteamid WHERE regions.state = 'California' AND sales_orders.sales_channel = 'In-Store' AND sales_orders.discount_applied = 0.2;
SELECT MAX(customers.customer_name) FROM     customers JOIN     sales_orders ON customers.customerid = sales_orders._customerid WHERE     sales_orders.orderdate BETWEEN '2018-01-01' AND '2020-12-31' GROUP BY     customers.customerid HAVING     SUM(sales_orders.order_quantity) >= 8;
SELECT SUM(order_quantity) AS total_order_quantity_candles,        (SUM(CASE WHEN products.product_name = 'Candles' THEN order_quantity ELSE 0 END) / SUM(order_quantity)) * 100 AS percentage_candles_orders FROM sales_orders JOIN products ON sales_orders._productid = products.productid;
SELECT region FROM sales_team WHERE sales_team = 'Joshua Bennett';
SELECT MAX(population) AS max_population, _storeid AS store_id FROM store_locations GROUP BY county ORDER BY max_population DESC LIMIT 1;
SELECT COUNT(DISTINCT sales_team.salesteamid) FROM     sales_team JOIN     regions ON sales_team.region = regions.region WHERE     regions.region = 'Midwest';
SELECT type FROM     store_locations WHERE     water_area = (SELECT MAX(water_area) FROM store_locations)
SELECT COUNT(*) FROM sales_orders WHERE sales_channel = 'Online' AND SUBSTR(ShipDate, 1, 1) = '6' AND SUBSTR(ShipDate, -2) = '18';
SELECT MAX(discount_applied) FROM sales_orders WHERE unit_price = (SELECT MAX(unit_price) FROM sales_orders);
SELECT MAX(products.productname) FROM     (     SELECT        products.productname,         (salesorders.unitprice - salesorders.unitcost) AS net_profit     FROM         salesorders     INNER JOIN products ON salesorders._productid = products.productid     ) AS max_profit_product;
SELECT store_locations.city_name, AVG(store_locations.household_income) AS average_household_income FROM store_locations JOIN regions ON store_locations.statecode = regions.statecode JOIN sales_orders ON sales_orders._storeid = store_locations.storeid JOIN customers ON sales_orders._customerid = customers.customerid JOIN sales_team ON sales_orders._salesteamid = sales_team.salesteamid WHERE regions.region = 'Northeast' AND regions.statecode = (     SELECT    statecode     FROM     (         SELECT        statecode,         COUNT(storeid) AS store_count         FROM         store_locations         GROUP BY         statecode         ORDER BY         store_count DESC         LIMIT 1     ) AS subquery ) GROUP BY store_locations.city_name; 
SELECT regions.region FROM regions JOIN store_locations ON regions.statecode = store_locations.statecode WHERE store_locations.median_income < 30000;
SELECT COUNT(DISTINCT storeid)  FROM      store_locations WHERE      region = 'West'      AND land_area < 20000000;
SELECT customers.customer_name FROM customers JOIN sales_orders ON customers.customerid = sales_orders._customerid JOIN products ON sales_orders._productid = products.productid JOIN (     SELECT        _customerid,         MAX((unit_price - unit_cost) * order_quantity) AS net_profit     FROM         sales_orders     GROUP BY         _customerid ) AS max_profit ON sales_orders._customerid = max_profit._customerid AND (unit_price - unit_cost) * order_quantity = max_profit.net_profit LIMIT 1;
SELECT COUNT(ordernumber) AS num_orders_shipped, sales_team.sales_team FROM sales_orders JOIN sales_team ON sales_orders._salesteamid = sales_team.salesteamid WHERE SUBSTR(shipdate, -2) = '19' AND SUBSTR(orderdate, -2) = '19' GROUP BY sales_team.sales_team ORDER BY num_orders_shipped DESC LIMIT 1;
SELECT MIN(products.productname) AS product_name FROM     salesorders INNER JOIN products ON salesorders._productid = products.productid INNER JOIN storelocations ON salesorders._storeid = storelocations.storeid INNER JOIN customers ON salesorders._customerid = customers.customerid INNER JOIN salesteam ON salesorders._salesteamid = salesteam.salesteamid WHERE     salesorders.orderquantity >= 5     AND salesorders.shipdate LIKE '5/%/19' GROUP BY     products.productid ORDER BY     (salesorders.unitprice - salesorders.unitcost) LIMIT 1;
SELECT store locations.latitude, store locations.longitude FROM sales orders JOIN products ON sales orders._productid = products.productid JOIN store locations ON sales orders._storeid = store locations.storeid ORDER BY ((sales orders.unit price - sales orders.unit cost) * sales orders.order quantity) DESC LIMIT 1 OFFSET 3;
SELECT COUNT(ordernumber) AS shipped_orders, sales_team.sales_team FROM sales_orders JOIN sales_team ON sales_orders._salesteamid = sales_team.salesteamid WHERE SUBSTR(shipdate, -2) = '20' GROUP BY _salessteamid ORDER BY shipped_orders DESC LIMIT 1;
SELECT AVG(COUNT(ordernumber) / 3) AS average_shipped_orders_per_year FROM     sales_orders     INNER JOIN sales_team ON sales_orders._salesteamid = sales_team.salesteamid WHERE     sales_team.sales_team = 'Carl Nguyen'     AND SUBSTR(shipdate, -2) IN ('18', '19', '20') GROUP BY     SUBSTR(shipdate, -2)
SELECT MAX(unit_price - unit_cost) AS max_net_profit, (SELECT product_name FROM products WHERE productid = (SELECT _productid FROM sales_orders WHERE unit_price - unit_cost = (SELECT MAX(unit_price - unit_cost) FROM sales_orders))) AS product_name, discount_applied FROM sales_orders
SELECT customers.customer names FROM     customers JOIN     sales orders ON customers.customerid = sales orders._customerid GROUP BY     customers.customerid ORDER BY     MAX((sales orders.unit price * sales orders.order quantity) - sales orders.discount applied) DESC LIMIT 3; 
SELECT sales_channel, COUNT(ordernumber) AS order_count FROM sales_orders WHERE substr(orderdate, 1, 1) = '1' AND substr(orderdate, -2) = '20' GROUP BY sales_channel ORDER BY order_count DESC LIMIT 1;
SELECT products.productname FROM salesorders JOIN products ON salesorders._productid = products.productid WHERE salesorders.ordernumber = 'SO - 0005951';
SELECT store_locations.city_name, sales_team.sales_team FROM sales_orders JOIN store_locations ON sales_orders._storeid = store_locations.storeid JOIN sales_team ON sales_orders._salesteamid = sales_team.salesteamid WHERE sales_orders.ordernumber = 'SO - 0001004';
SELECT MAX((UnitPrice - UnitCost) * OrderQuantity) AS NetProfit, Customers.CustomerName AS TopCustomer FROM SalesOrders JOIN StoreLocations ON SalesOrders._StoreID = StoreLocations.StoreID JOIN Regions ON StoreLocations.StateCode = Regions.StateCode JOIN Customers ON SalesOrders._CustomerID = Customers.CustomerID WHERE StoreLocations.CityName = 'Gilbert' AND Regions.State = 'Arizona' AND ProcuredDate LIKE '%/19' GROUP BY Customers.CustomerName ORDER BY NetProfit DESC LIMIT 1;
SELECT COUNT(sales_orders.ordernumber) AS total_orders FROM     sales_orders JOIN     store_locations ON sales_orders._storeid = store_locations.storeid WHERE     store_locations.city_name = 'Chandler'     AND substr(sales_orders.orderdate, -2) = '20';
SELECT AVG(household_income) FROM     store_locations WHERE     city_name = 'Glendale';
SELECT MAX(discount_applied) FROM     sales_orders WHERE     substr(orderdate, -2) = '20';
SELECT MAX(running_count) AS max_consecutive_tied_games FROM (     SELECT        *,         ROW_NUMBER() OVER (ORDER BY date) - ROW_NUMBER() OVER (PARTITION BY ftr ORDER BY date) AS running_count     FROM         matchs     WHERE         awayteam = 'Ebbsfleet' AND season = 2008 AND ftr = 'D' ) AS subquery;
SELECT 100 * (SELECT COUNT(division) FROM divisions WHERE country = 'England') / (SELECT COUNT(division) FROM divisions);
SELECT DIVIDE(     COUNT(CASE WHEN FTR = 'H' THEN 1 ELSE NULL END),     COUNT(DISTINCT div) ) AS games_won_percentage,  DIVIDE(     COUNT(CASE WHEN FTR = 'A' THEN 1 ELSE NULL END),     COUNT(DISTINCT div) ) AS games_lost_percentage,  DIVIDE(     COUNT(CASE WHEN FTR = 'D' THEN 1 ELSE NULL END),     COUNT(DISTINCT div) ) AS games_drawn_percentage  FROM matchs WHERE hometeam = 'Cittadella'; 
SELECT MAX(DIVIDE(COUNT(CASE WHEN FTR = 'A' THEN 1 END), COUNT(*)) * 100.0) AS percentage FROM matchs WHERE season = '2010' AND div IN (SELECT division FROM divisions WHERE name = 'Caen');
SELECT (COUNT(CASE WHEN div = 'F1' AND date = '2005/07/30' THEN 1 END) * 100.0) / COUNT(CASE WHEN date = '2005/07/30' THEN 1 END) FROM matchs WHERE date = '2005/07/30';
SELECT ROUND((CAST((SELECT COUNT(*) FROM matchs WHERE (HomeTeam = 'Sassuolo' OR AwayTeam = 'Sassuolo') AND FTR = 'D') AS REAL) / CAST((SELECT COUNT(*) FROM matchs WHERE HomeTeam = 'Sassuolo' OR AwayTeam = 'Sassuolo') AS REAL)) * 100, 2) AS percentage; 
SELECT ROUND(     (CAST((SELECT COUNT(*) FROM matchs WHERE season = '2017' AND ftag = '2') AS FLOAT) /     CAST((SELECT COUNT(*) FROM matchs WHERE season = '2017') AS FLOAT))     * 100,     2 ) AS percentage; 
SELECT DISTINCT hometeam FROM matchs WHERE div = 'E2' UNION SELECT DISTINCT awayteam FROM matchs WHERE div = 'E2';
SELECT COUNT(DISTINCT hometeam)  FROM matchs  WHERE ftag >= 4  AND div IN (SELECT division FROM divisions WHERE country = 'Greece');
SELECT COUNT(*) FROM matchs WHERE season = 2019 AND div IN (SELECT division FROM divisions WHERE name = 'Scottish Championship') AND fthg = 2 AND ftag = 2;
SELECT hometeam, season FROM matchs WHERE fthg = 10 AND div IN (SELECT division FROM divisions WHERE country = 'Scotland'); 
SELECT MAX(wins.local_wins) AS most_local_wins, ROUND(MAX(wins.local_wins) * 100.0 / (SELECT COUNT(*) FROM matchs WHERE div IN (SELECT division FROM divisions WHERE name = 'LaLiga' AND country = 'Spain' AND season = 2017)), 2) AS percentage FROM (SELECT COUNT(*) AS local_wins FROM matchs WHERE div IN (SELECT division FROM divisions WHERE name = 'LaLiga' AND country = 'Spain' AND season = 2017) AND ftr = 'H' GROUP BY hometeam) AS wins;
SELECT COUNT(DISTINCT m.hometeam) AS total_teams,        d.name AS division_name,        ROUND(CAST(COUNT(DISTINCT m.hometeam) AS FLOAT) / (SELECT COUNT(DISTINCT hometeam) FROM matchs WHERE season = 2012 AND div IN (SELECT division FROM divisions WHERE country = 'England')) * 100, 2) AS percentage FROM matchs AS m JOIN divisions AS d ON m.div = d.division WHERE m.season = 2012 AND d.country = 'England' GROUP BY d.name; 
SELECT MAX(fthg + ftag) AS highest_score, CASE     WHEN fthg > ftag THEN hometeam     ELSE awayteam END AS team FROM matchs WHERE season = 2021;
SELECT homeTeam FROM   matchs JOIN   divisions ON   matchs.div = divisions.division WHERE   divisions.division = 'P1' GROUP BY   matchs.season ORDER BY   MAX(matchs.fthg) DESC LIMIT 1; 
SELECT (SELECT     divisions.division,     (SUM(CASE WHEN matchs.ftr = 'H' THEN 1 ELSE 0 END) * 1.0 / COUNT(*)) - (SUM(CASE WHEN matchs.ftr = 'A' THEN 1 ELSE 0 END) * 1.0 / COUNT(*)) AS percentage FROM      matchs JOIN      divisions ON matchs.div = divisions.division WHERE      matchs.season = 2010 GROUP BY      divisions.division)
SELECT div FROM   matchs WHERE   season = 2008   AND ftr = 'D' GROUP BY   div ORDER BY   COUNT(div) DESC LIMIT 1; 
SELECT hometeam FROM matchs WHERE Div = 'EC' AND Date = '2008-01-20' AND FTR = 'H';
SELECT divisions.name FROM divisions INNER JOIN matchs ON divisions.division = matchs.div WHERE matchs.date = '2009-09-13' AND (matchs.hometeam = 'Club Brugge' OR matchs.awayteam = 'Club Brugge') AND (matchs.hometeam = 'Genk' OR matchs.awayteam = 'Genk');
SELECT COUNT(*) FROM matchs WHERE div = 'Scottish Premiership' AND season BETWEEN 2006 AND 2008;
SELECT divisions.division, divisions.country FROM matchs JOIN divisions ON matchs.div = divisions.division WHERE hometeam = 'Hearts' AND awayteam = 'Hibernian'; 
SELECT awayteam FROM matchs WHERE div = 'Bundesliga' GROUP BY awayteam ORDER BY MAX(ftag) DESC LIMIT 1; 
SELECT awayteam FROM matchs WHERE div IN (SELECT division FROM divisions WHERE country = 'Italy') LIMIT 3;
SELECT divisions.name FROM divisions JOIN matchs ON matchs.div = divisions.division WHERE matchs.season = '2019' GROUP BY divisions.division ORDER BY COUNT(CASE WHEN matchs.ftr = 'D' THEN 1 END) ASC LIMIT 1; 
SELECT COUNT(*) FROM     matchs JOIN     divisions ON matchs.div = divisions.division WHERE     divisions.name = 'LaLiga'     AND matchs.hometeam = 'Valencia'     AND matchs.ftr = 'H';
SELECT COUNT(*) FROM matchs WHERE div = 'Seria A' AND fthg = ftag AND ftr = 'D';
SELECT COUNT(*) FROM divisions WHERE country = 'England';
SELECT divisions.name FROM divisions WHERE divisions.country = 'Netherlands'; 
SELECT CASE      WHEN ftr = 'A' THEN awayteam     ELSE hometeam END AS winner FROM matchs WHERE date = '2009/10/10' AND hometeam = 'East Fife' AND awayteam = 'Dumbarton';
SELECT fthg, ftag FROM matchs WHERE hometeam = 'Bursaspor' AND awayteam = 'Denizlispor' AND date = '2009-04-26';
SELECT MIN(date) FROM matchs WHERE fthg + ftag > 10;
SELECT MAX(SUM(FTHG + FTAG)) AS max_goals,     hometeam,     awayteam,     CASE         WHEN ftr = 'H' THEN hometeam         WHEN ftr = 'A' THEN awayteam         ELSE 'Draw'     END AS winner FROM     matchs WHERE     div = 'Ligue 2' GROUP BY     div, hometeam, awayteam HAVING     max_goals = (         SELECT            MAX(SUM(FTHG + FTAG))         FROM             matchs         WHERE             div = 'Ligue 2'         GROUP BY             div, hometeam, awayteam     ) LIMIT     1;
SELECT COUNT(*) FROM matchs JOIN divisions ON matchs.div = divisions.division WHERE divisions.name = 'LaLiga 2' AND matchs.date = '2016-03-27' AND matchs.ftr = 'A';
SELECT COUNT(*) FROM matchs WHERE div = 'National League' AND date = '2018-08-07' AND ftr = 'D';
SELECT divisions.country FROM matchs JOIN divisions ON matchs.div = divisions.division GROUP BY divisions.country ORDER BY MAX(matchs.ftag) DESC LIMIT 1; 
SELECT divisions.name FROM matchs JOIN divisions ON matchs.div = divisions.division WHERE matchs.fthg = '1' AND matchs.ftag = '8' AND matchs.season = '2011'; 
SELECT divisions.name AS division_name FROM divisions JOIN matchs ON matchs.div = divisions.division WHERE matchs.date = '2020-02-22' GROUP BY divisions.division HAVING SUM(matchs.fthg + matchs.ftag) > 5 ORDER BY COUNT(*) DESC LIMIT 1; 
SELECT divisions.name FROM divisions JOIN matchs ON divisions.division = matchs.div WHERE matchs.fthg = '0' AND matchs.ftag = '0' GROUP BY divisions.name ORDER BY COUNT(*) DESC LIMIT 1; 
SELECT COUNT(*) FROM matchs WHERE div = 'Scottish League One' AND date = (     SELECT date     FROM matchs     WHERE hometeam = 'Pro Vercelli'     AND awayteam = 'Pescara'     AND fthg = 5     AND ftag = 2 ) AND (hometeam = 'Pro Vercelli' OR awayteam = 'Pro Vercelli') AND (hometeam = 'Pescara' OR awayteam = 'Pescara');
SELECT COUNT(*) FROM matchs WHERE fthg = '5' AND ftag = '0' AND div IN (SELECT division FROM divisions WHERE country = 'Greece');
SELECT country FROM divisions WHERE division IN (     SELECT        div     FROM         matchs     WHERE         hometeam = 'Bradford'     OR         awayteam = 'Bradford' );
SELECT COUNT(DISTINCT hometeam) FROM matchs WHERE div = 'Eredivisie' AND season = 2008;
SELECT DIVIDE(     COUNT(matchs.div) FILTER (WHERE matchs.ftr = 'H' AND matchs.season = '2021' AND divisions.name = 'Bundesliga'),     COUNT(matchs.div) FILTER (WHERE matchs.season = '2021' AND divisions.name = 'Bundesliga') ) AS percentage; 
SELECT ROUND((CAST((SELECT COUNT(*) FROM matchs WHERE fthg = '1' AND ftag = '1' AND div IN (SELECT division FROM divisions WHERE name = 'Liga NOS')) AS FLOAT) / CAST((SELECT COUNT(*) FROM matchs WHERE fthg = '1' AND ftag = '1') AS FLOAT)) * 100, 2) AS percentage;
SELECT COUNT(*) FROM matchs WHERE div = 'Premier League' AND season = '2021';
SELECT hometeam FROM matchs WHERE div = 'Bundesliga' AND date = '2020/10/2'; 
SELECT   hometeam FROM matchs WHERE div = 'Bundesliga' AND date = '2020/10/2' AND ftr = 'H'; 
SELECT MAX(home_team) AS team FROM (     SELECT        hometeam AS home_team,         COUNT(*) AS victories     FROM         matchs     JOIN         divisions ON matchs.div = divisions.division     WHERE         divisions.name = 'Bundesliga' AND ftr = 'H'     GROUP BY         hometeam );
SELECT COUNT(*) FROM matchs WHERE div = 'Bundesliga' AND awayteam = 'Werder Bremen' AND ftr = 'A';
SELECT COUNT(*) FROM matchs WHERE div = 'Bundesliga' AND season = '2021' AND ftr = 'A';
SELECT COUNT(*) FROM matchs WHERE div = 'Bundesliga' AND ftr = 'D';
SELECT COUNT(CASE WHEN matchs.ftr = 'H' AND matchs.season = 2021 AND divisions.name = 'Bundesliga' THEN 1 ELSE 0 END) - COUNT(CASE WHEN matchs.ftr = 'H' AND matchs.season = 2021 AND divisions.name = 'Premier League' THEN 1 ELSE 0 END) FROM matchs INNER JOIN divisions ON matchs.div = divisions.division;
SELECT hometeam FROM matchs WHERE div = 'Bundesliga' AND ftr = 'H' AND season = 2021; 
SELECT MAX(CASE WHEN hometeam = 'Augsburg' THEN 1 ELSE 0 END) AS Augsburg_home_victories, MAX(CASE WHEN hometeam = 'Mainz' THEN 1 ELSE 0 END) AS Mainz_home_victories FROM matchs JOIN divisions ON matchs.div = divisions.division WHERE season = '2021' AND divisions.name = 'Bundesliga';
SELECT MAX(FTHG) AS MaxFinalTimeHomeTeamGoals FROM matchs WHERE div = 'Bundesliga' AND season = 2021;
SELECT SUM(fthg) FROM matchs WHERE div = 'Bundesliga' AND season = 2021;
SELECT      (         (SELECT COUNT(*) FROM matchs WHERE HomeTeam = 'Club Brugge' AND FTR = 'H' AND div = (SELECT division FROM divisions WHERE name = 'Premier League' AND season = 2021))         +         (SELECT COUNT(*) FROM matchs WHERE AwayTeam = 'Club Brugge' AND FTR = 'A' AND div = (SELECT division FROM divisions WHERE name = 'Premier League' AND season = 2021))     ) * 1.0 /     (SELECT COUNT(*) FROM matchs WHERE div = (SELECT division FROM divisions WHERE name = 'Premier League' AND season = 2021))     AS winning_rate; 
SELECT (SUM(homewon) / SUM(won)) * 100 AS percentage_of_home_wins FROM teams;
SELECT teams.tmid FROM teams WHERE CAST(teams.lost AS FLOAT) / teams.games > 0.75;
SELECT teams.name,  SUM(CASE WHEN teams.year = 2005 THEN teams.won ELSE 0 END) AS total_wins_2005 FROM teams WHERE teams.year IN (2004, 2005) GROUP BY teams.tmid HAVING total_wins_2005 > (     SELECT SUM(teams.won)      FROM teams      WHERE teams.year = 2004     AND teams.tmid = teams.tmid )
SELECT teams.name, teams.o_pts FROM teams WHERE (teams.homewon - teams.homelost) > (0.8 * teams.games);
SELECT 100.0 * COUNT(DISTINCT teams.tmid) / COUNT(teams.tmid) FROM teams WHERE teams.playoff IS NOT NULL AND teams.rank = 1;
SELECT coaches.coachid, coaches.won, coaches.lost FROM coaches JOIN teams ON coaches.tmid = teams.tmid AND coaches.year = teams.year WHERE teams.tmid = 'BOS' AND teams.year = 1950;
SELECT MAX(Count(coachID)) AS tenure, coachid AS coach_id, GROUP_CONCAT(DISTINCT tmid) AS team_served FROM coaches WHERE year BETWEEN 1970 AND 1980 GROUP BY coachid ORDER BY tenure DESC LIMIT 1;
SELECT coaches.coachid, teams.name, coaches.homewon FROM coaches JOIN teams ON coaches.tmid = teams.tmid AND coaches.year = teams.year WHERE coaches.year = 2000 AND coaches.homewon > 50;
SELECT   coaches.coachid, teams.name, coaches.year FROM coaches JOIN teams ON coaches.tmid = teams.tmid AND coaches.year = teams.year WHERE coaches.year BETWEEN 2000 AND 2010 GROUP BY coaches.coachid, teams.name, coaches.year HAVING SUM(coaches.lost) > SUM(coaches.won) 
SELECT teams.name, teams.year, teams.o_fgm FROM coaches JOIN teams ON coaches.tmid = teams.tmid AND coaches.year = teams.year WHERE coaches.coachid = 'adelmri01' AND teams.year BETWEEN 1990 AND 1995;
SELECT coaches.coachid, coaches.year FROM coaches JOIN teams ON coaches.tmid = teams.tmid AND coaches.year = teams.year WHERE CAST(teams.won AS REAL) / teams.games > 0.9;
SELECT ((COUNT(DISTINCT awards_players.playerid) FILTER (WHERE awards_players.award = 'All-Defensive First Team' AND players.birthstate = 'NY' AND players.birthdate BETWEEN '1980-01-01' AND '2000-12-31')) * 100.0) / COUNT(DISTINCT awards_players.playerid) AS percentage_of_winners_from_NY
SELECT WHERE awards_coaches.year = 1977 AND awards_coaches.award = 'NBA Coach of the Year' AND coaches.year = 1976;
SELECT coaches.coachid FROM coaches JOIN teams ON coaches.tmid = teams.tmid AND coaches.year = teams.year WHERE teams.name = 'Chicago Bulls' AND coaches.year = 1981 AND coaches.award = 'NBA Coach of the Year' AND coaches.year BETWEEN 1970 AND 1979;
SELECT players.namenick FROM players JOIN players_teams ON players.playerid = players_teams.playerid JOIN teams ON players_teams.tmid = teams.tmid AND players_teams.year = teams.year WHERE teams.confid = 'West' AND teams.year = 2006 AND players_teams.blocks = 2;
SELECT MIN(teams.rank) AS lowest_rank FROM series_post JOIN teams ON series_post.tmidwinner = teams.tmid AND series_post.year = teams.year WHERE series_post.round = 'DSF' AND series_post.tmidloser = 'HSM';
SELECT MAX(players.birthdate) FROM     player_allstar JOIN     players ON player_allstar.playerid = players.playerid WHERE     player_allstar.season_id = 1985;
SELECT players.firstname, players.lastname FROM players JOIN player_allstar ON players.playerid = player_allstar.playerid WHERE players.birthcity = 'Winter Haven' AND player_allstar.season_id BETWEEN 1980 AND 1989 AND player_allstar.minutes = 12;
SELECT COUNT(DISTINCT player_allstar.playerid) FROM player_allstar JOIN players ON player_allstar.playerid = players.playerid WHERE player_allstar.conference = 'East' AND player_allstar.minutes < 5 AND players.college = 'Illinois College';
SELECT SUM(CASE WHEN players_teams.year BETWEEN 1990 AND 2007 THEN      CASE WHEN (players_teams.drebounds / players_teams.rebounds) * 100 > 75 THEN 1 ELSE 0 END     ELSE 0 END) AS total_rebounds_exceed_75_percent_defensive FROM players_teams INNER JOIN teams ON players_teams.tmid = teams.tmid AND players_teams.year = teams.year GROUP BY players_teams.playerid;
SELECT MAX(won / (won + lost)) AS balance, year FROM (     SELECT    coaches.year,     SUM(coaches.won) AS won,     SUM(coaches.lost) AS lost     FROM     coaches     WHERE     coachid = 'costela01'     GROUP BY     coaches.year ) AS balance_table;
SELECT SUM(player_allstar.minutes) AS total_minutes FROM player_allstar JOIN players ON player_allstar.playerid = players.playerid WHERE players.birthcity = 'Brooklyn' AND players.namenick LIKE '%Superman%';
SELECT teams.name FROM coaches JOIN awards_coaches ON coaches.coachid = awards_coaches.coachid JOIN teams ON coaches.tmid = teams.tmid AND coaches.year = teams.year WHERE awards_coaches.year = 1994 AND awards_coaches.award = 'NBA Coach of the Year' ORDER BY teams.homelost DESC LIMIT 1;
SELECT teams.name FROM series_post JOIN teams ON series_post.tmidwinner = teams.tmid AND series_post.year = teams.year WHERE series_post.round = 'CSF' AND series_post.lgidwinner = 'NBA' AND series_post.tmidloser = 'LAL' AND series_post.year = 1996 AND teams.won > 60;
SELECT lgid FROM players WHERE weight = (     SELECT MAX(weight) * 0.6     FROM players ) AND height = 80;
SELECT coaches.coachid FROM coaches WHERE coaches.lgid = 'NBA' GROUP BY coaches.coachid HAVING COUNT(DISTINCT coaches.tmid) > 2;
SELECT coaches.coachid AS coachID FROM coaches JOIN teams ON coaches.tmid = teams.tmid AND coaches.year = teams.year ORDER BY teams.post_wins DESC LIMIT 1;
SELECT MIN(coaches.post_losses) AS min_post_losses FROM     coaches WHERE     coaches.tmid IN (         SELECT            coachid         FROM             coaches         GROUP BY             coachid         HAVING             COUNT(DISTINCT tmid) >= 2     )
SELECT COUNT(DISTINCT players.playerid) FROM players JOIN players_teams ON players.playerid = players_teams.playerid JOIN teams ON players_teams.tmid = teams.tmid AND players_teams.year = teams.year WHERE teams.lgid = 'ABA' AND (players.pos = 'C' OR players.pos = 'F-C');
SELECT players.firstname FROM players JOIN players_teams ON players.playerid = players_teams.playerid WHERE players_teams.year IN (SELECT DISTINCT year FROM teams WHERE lgid = 'NBA') AND (players.pos = 'F' OR players.pos = 'F-C');
SELECT COUNT(DISTINCT players.playerid) FROM     players JOIN     players_teams ON players.playerid = players_teams.playerid JOIN     teams ON players_teams.tmid = teams.tmid AND players_teams.year = teams.year WHERE     players.hsCity = 'Chicago'     AND teams.divID = 'WE';
SELECT players.college FROM players JOIN player_allstar ON players.playerid = player_allstar.playerid JOIN teams ON teams.tmid = player_allstar.tmid WHERE teams.divid = 'EA';
SELECT COUNT(*) FROM players WHERE players.playerid IN (     SELECT playerid     FROM players_teams     WHERE tmid IN (         SELECT tmid         FROM teams         WHERE lgid = 'NBL'     ) ) AND birthcity = 'Spencer';
SELECT players.birthdate FROM     awards_players JOIN     players ON awards_players.playerid = players.playerid WHERE     awards_players.award = 'Most Valuable Player' GROUP BY     awards_players.playerid ORDER BY     COUNT(*) DESC LIMIT 1; 
SELECT COUNT(DISTINCT players.playerid) FROM     players JOIN     awards_players ON players.playerid = awards_players.playerid WHERE     players.birthcity = 'Whitestone'     AND awards_players.award = 'Most Valuable Player';
SELECT MAX(height) FROM     players WHERE     playerid IN (         SELECT            playerid         FROM             awards_players         WHERE             award = 'Rookie of the Year'     );
SELECT AVG(players.weight) FROM     awards_players JOIN players ON awards_players.playerid = players.playerid WHERE     awards_players.award = 'Rookie of the Year';
SELECT AVG(height) FROM     players WHERE     highschool LIKE '%New York%'      AND playerid IN (         SELECT playerid          FROM awards_players          WHERE award = 'Most Valuable Player'     );
SELECT teams.name, MAX(o_pts) AS highest_score FROM teams WHERE year = 2000 GROUP BY teams.name ORDER BY highest_score DESC LIMIT 10;
SELECT teams.name FROM teams WHERE CAST(teams.won AS REAL) / (teams.won + teams.lost) < 0.5;
SELECT coaches.coachid FROM coaches JOIN teams ON coaches.tmid = teams.tmid AND coaches.year = teams.year GROUP BY coaches.coachid HAVING SUM(teams.won) * 1.0 / (SUM(teams.won) + SUM(teams.lost)) > 0.8;
SELECT DISTINCT coachid FROM coaches WHERE lgid = 'NBA' GROUP BY coachid HAVING (MAX(year) - MIN(year)) > 10;
SELECT COUNT(DISTINCT teams.tmid) FROM teams JOIN players_teams ON teams.tmid = players_teams.tmid AND teams.year = players_teams.year JOIN awards_players ON players_teams.playerid = awards_players.playerid WHERE awards_players.award = "Most Valuable Player" GROUP BY teams.tmid HAVING SUM(players_teams.points) >= 3800;
SELECT players.firstname,     players.lastname,     players.height FROM     players JOIN     players_teams ON players.playerid = players_teams.playerid JOIN     teams ON players_teams.tmid = teams.tmid WHERE     teams.name = "AFS" ORDER BY     players.height DESC LIMIT 1;
SELECT players.lastname FROM players JOIN players_teams ON players.playerid = players_teams.playerid JOIN teams ON teams.tmid = players_teams.tmid WHERE teams.name = "BLB";
SELECT COUNT(DISTINCT coaches.coachid) AS total_awarded_coaches FROM   coaches JOIN teams ON coaches.tmid = teams.tmid AND coaches.year = teams.year WHERE   coaches.year BETWEEN 1962 AND 1975;
SELECT coachid FROM awards_coaches WHERE year BETWEEN 1970 AND 1990 GROUP BY coachid HAVING COUNT(coachid) = 2;
SELECT COUNT(DISTINCT coachid) AS coaches_count FROM awards_coaches WHERE year BETWEEN 1962 AND 2011 AND award LIKE 'NBA%' AND coachid IN (     SELECT coachid     FROM awards_coaches     WHERE year BETWEEN 1962 AND 2011     AND award LIKE 'ABA%' )
SELECT AVG(player_allstar.points) AS average_points FROM player_allstar JOIN players ON player_allstar.playerid = players.playerid WHERE player_allstar.season_id = 1975 AND players.birthcountry = 'USA';
SELECT player_allstar.last_name, player_allstar.first_name FROM player_allstar INNER JOIN players ON player_allstar.playerid = players.playerid WHERE players.height > 75;
SELECT MIN(players.weight) FROM     players JOIN     player_allstar ON players.playerid = player_allstar.playerid WHERE     players.college = 'UCLA';
SELECT MAX(weight)  FROM      player_allstar  JOIN      players ON player_allstar.playerid = players.playerid  WHERE      birthcountry = 'USA';
SELECT SUM(player_allstar.points) AS total_points FROM player_allstar JOIN players ON player_allstar.playerid = players.playerid WHERE player_allstar.season_id BETWEEN 1960 AND 1970 AND players.deathdate = '0000-00-00';
SELECT players.lastname, players.firstname FROM players JOIN player_allstar ON players.playerid = player_allstar.playerid WHERE players.birthdate >= '1950-01-01' AND (CAST(player_allstar.o_rebounds AS FLOAT) / CAST(player_allstar.rebounds AS FLOAT)) > 0.3;
SELECT COUNT(DISTINCT awards_players.playerid) AS num_players_received_rotY_award FROM awards_players JOIN players ON awards_players.playerid = players.playerid WHERE award = 'Rookie of the Year' AND year BETWEEN 1969 AND 2010;
SELECT teams.name FROM teams JOIN players_teams ON teams.tmid = players_teams.tmid AND teams.year = players_teams.year JOIN player_allstar ON players_teams.playerid = player_allstar.playerid GROUP BY teams.tmid HAVING COUNT(DISTINCT player_allstar.playerid) >= 3;
SELECT MAX(player_points) FROM (     SELECT         MAX(points) AS player_points     FROM          players_teams     JOIN          players ON players_teams.playerid = players.playerid     JOIN          teams ON players_teams.tmid = teams.tmid AND players_teams.year = teams.year     WHERE          teams.rank = 1 AND teams.year BETWEEN 1950 AND 1970 ) AS max_player_points;
SELECT player_allstar.last_name, player_allstar.first_name FROM player_allstar JOIN players ON player_allstar.playerid = players.playerid JOIN teams ON player_allstar.tmid = teams.tmid WHERE teams.year BETWEEN 1937 AND 1940 GROUP BY player_allstar.playerid HAVING COUNT(CASE WHEN teams.rank = 1 THEN 1 END) >= 3;
SELECT teams.name FROM teams JOIN players_teams ON teams.tmid = players_teams.tmid AND teams.year = players_teams.year WHERE teams.rank = 3 AND teams.year BETWEEN 1937 AND 1940 GROUP BY teams.name ORDER BY MAX(players_teams.points) DESC LIMIT 1;
SELECT COUNT(DISTINCT teams.tmid) FROM     teams JOIN     players_teams ON teams.tmid = players_teams.tmid AND teams.year = players_teams.year WHERE     teams.year = 1937 GROUP BY     teams.tmid HAVING     SUM(players_teams.points) >= 500;
SELECT COUNT(DISTINCT players.playerid) FROM players JOIN players_teams ON players.playerid = players_teams.playerid JOIN teams ON players_teams.tmid = teams.tmid AND players_teams.year = teams.year WHERE teams.year = 1990 GROUP BY players.playerid HAVING SUM(teams.won) / SUM(teams.games) > 0.75;
SELECT playerid, firstname, lastname, height FROM players WHERE race = 'B' ORDER BY height ASC LIMIT 3;
SELECT COUNT(*) FROM     draft WHERE     firstname = 'Joe' AND draftyear = 1970;
SELECT SUM(players_teams.fgmade) FROM     players_teams JOIN     players ON players_teams.playerid = players.playerid WHERE     players.firstname = 'George' AND players.lastname = 'Mikan'     AND players_teams.year BETWEEN 1951 AND 1953;
SELECT players.playerid, players.firstname, players.lastname, players.height, players.weight, ROUND((players.weight / (players.height * players.height)) * 703, 2) AS bmi FROM players;
SELECT  name FROM teams ORDER BY homelost / (homewon + homelost) DESC LIMIT 1; 
SELECT strftime('%Y', draftyear) - strftime('%Y', birthdate) AS age_when_first_drafted FROM     draft JOIN     players ON draft.playerid = players.playerid WHERE     lastname = 'Ajinca' AND     firstname = 'Alexis';
SELECT players.firstname, players.lastname FROM players JOIN players_teams ON players.playerid = players_teams.playerid JOIN teams ON players_teams.tmid = teams.tmid WHERE teams.name = 'Denver Nuggets' AND teams.year > 1980 ORDER BY players.height DESC LIMIT 1;
SELECT players.playerid, COUNT(awards_players.award) AS award_count FROM players LEFT JOIN awards_players ON players.playerid = awards_players.playerid WHERE players.deathdate IS NOT NULL GROUP BY players.playerid ORDER BY award_count DESC LIMIT 1; 
SELECT teams.name FROM     players_teams JOIN     teams ON players_teams.tmid = teams.tmid JOIN     players ON players_teams.playerid = players.playerid WHERE     players.college = "UCLA" GROUP BY     players_teams.tmid ORDER BY     COUNT(players.playerid) DESC LIMIT 1;
SELECT AVG((weight / (height * height)) * 703) AS average_bmi FROM player_allstar JOIN players ON player_allstar.playerid = players.playerid;
SELECT MAX((SELECT teams.name FROM teams WHERE teams.lgid = 'ABA' AND teams.year = 1973 AND (teams.won / (teams.won + teams.lost)) -     (SELECT SUM(teams.won) / SUM(teams.won + teams.lost)     FROM teams     WHERE teams.lgid = 'ABA'     AND teams.year = 1972) ORDER BY (teams.won / (teams.won + teams.lost)) -     (SELECT SUM(teams.won) / SUM(teams.won + teams.lost)     FROM teams     WHERE teams.lgid = 'ABA'     AND teams.year = 1972) DESC LIMIT 1));
SELECT players.firstname FROM players JOIN players_teams ON players.playerid = players_teams.playerid JOIN teams ON players_teams.tmid = teams.tmid AND players_teams.year = teams.year WHERE teams.lgid = 'NBL' GROUP BY players.firstname ORDER BY COUNT(players_teams.pf) DESC LIMIT 1; 
SELECT AVG(players.height) FROM player_allstar JOIN players ON player_allstar.playerid = players.playerid WHERE player_allstar.conference = 'East';
SELECT MAX(Count(coaches.won)) FROM     coaches JOIN     awards_coaches ON coaches.coachid = awards_coaches.coachid AND coaches.year = awards_coaches.year WHERE     awards_coaches.award = 'ABA Coach of the Year'
SELECT teams.name FROM awards_coaches JOIN coaches ON awards_coaches.coachid = coaches.coachid AND awards_coaches.year = coaches.year JOIN teams ON coaches.tmid = teams.tmid AND coaches.year = teams.year WHERE awards_coaches.award = 'NBA Coach of the Year' AND awards_coaches.year = 1992;
SELECT players.firstname, players.lastname FROM players_teams JOIN players ON players_teams.playerid = players.playerid JOIN teams ON players_teams.tmid = teams.tmid AND players_teams.year = teams.year WHERE teams.year = 1973 GROUP BY players.playerid ORDER BY CAST(players_teams.fgmade AS FLOAT) / CAST(players_teams.fgattempted AS FLOAT) DESC LIMIT 1;
SELECT teams.name FROM draft JOIN teams ON draft.tmid = teams.tmid JOIN players ON draft.playerid = players.playerid WHERE players.lastname = 'Lynn' AND players.firstname = 'Mike';
SELECT COUNT(DISTINCT players.playerid) FROM     awards_players     JOIN players ON awards_players.playerid = players.playerid WHERE     awards_players.award = 'Most Improved Player'     AND awards_players.year BETWEEN 1985 AND 1990     AND players.birthcountry = 'USA';
SELECT players.firstname, players.lastname FROM players JOIN player_allstar ON players.playerid = player_allstar.playerid WHERE players.college = 'California'
SELECT COUNT(coaches.coachid) AS num_coaches FROM coaches JOIN awards_coaches ON coaches.coachid = awards_coaches.coachid AND coaches.year = awards_coaches.year WHERE coaches.year BETWEEN 1950 AND 1970 GROUP BY coaches.coachid HAVING COUNT(awards_coaches.award) > 1;
SELECT COUNT(DISTINCT awards_players.playerid) AS mvp_players FROM awards_players JOIN players ON awards_players.playerid = players.playerid WHERE award = 'Most Valuable Player' AND year BETWEEN 1969 AND 1975;
SELECT teams.name FROM players JOIN players_teams ON players.playerid = players_teams.playerid JOIN teams ON players_teams.tmid = teams.tmid WHERE players.birthstate IS NOT NULL GROUP BY teams.name HAVING COUNT(DISTINCT players.birthstate) >= 5;
SELECT COUNT(DISTINCT teams.tmid) FROM teams JOIN players_teams ON teams.tmid = players_teams.tmid AND teams.year = players_teams.year JOIN player_allstar ON players_teams.playerid = player_allstar.playerid WHERE teams.lgid = 'NBA' GROUP BY teams.tmid HAVING COUNT(DISTINCT player_allstar.playerid) >= 3;
SELECT MAX(state_count) AS max_players_state FROM (     SELECT birthstate AS state, COUNT(playerid) AS state_count     FROM players     INNER JOIN player_allstar ON players.playerid = player_allstar.playerid     GROUP BY birthstate );
SELECT COUNT(DISTINCT players.playerid) AS num_players FROM     players_teams JOIN     players ON players_teams.playerid = players.playerid JOIN     teams ON players_teams.tmid = teams.tmid AND players_teams.year = teams.year WHERE     teams.rank = 6 AND teams.year = 1937;
SELECT COUNT(DISTINCT awards_players.playerid) AS num_players FROM     awards_players JOIN     players_teams ON awards_players.playerid = players_teams.playerid JOIN     teams ON players_teams.tmid = teams.tmid AND players_teams.year = teams.year WHERE     teams.year = 1950 GROUP BY     awards_players.playerid HAVING     CAST(teams.lost AS FLOAT) / (teams.won + teams.lost) < 0.2;
SELECT players.fullgivenname FROM players WHERE players.birthcountry != 'USA';
SELECT DISTINCT coachid FROM coaches GROUP BY coachid HAVING COUNT(DISTINCT tmid) > 2;
SELECT coaches.coachid FROM coaches WHERE coaches.year = 1988 GROUP BY coaches.coachid HAVING MAX(coaches.won - coaches.lost) > 0;
SELECT teams.name FROM coaches JOIN awards_coaches ON coaches.coachid = awards_coaches.coachid AND coaches.year = awards_coaches.year JOIN teams ON coaches.tmid = teams.tmid WHERE awards_coaches.award = 'NBA Coach of the Year' AND coaches.year = 2010;
SELECT players.firstname, players.lastname, players.height, players.weight FROM players INNER JOIN players_teams ON players.playerid = players_teams.playerid WHERE players_teams.ftattempted > 0 AND players_teams.ftattempted = players_teams.ftmade;
SELECT players.firstname, players.lastname, teams.name FROM draft JOIN players ON draft.playerid = players.playerid JOIN teams ON draft.tmid = teams.tmid WHERE draft.draftfrom = 'Seattle' AND draft.draftyear BETWEEN 1965 AND 1970;
SELECT players.fullgivenname || ' ' || (2003 - strftime('%Y', players.birthdate)) AS "Full Name and Age" FROM players JOIN awards_players ON players.playerid = awards_players.playerid WHERE awards_players.award = 'Finals MVP' AND strftime('%Y', awards_players.year) = '2003';
SELECT teams.name AS champion, series_post.year FROM teams JOIN series_post ON teams.tmid = series_post.tmidwinner AND teams.year = series_post.year WHERE series_post.round = 'F' AND series_post.year BETWEEN 1950 AND 1960;
SELECT teams.name AS team_name, coaches.coachid AS coach FROM teams JOIN coaches ON teams.tmid = coaches.tmid AND teams.year = coaches.year JOIN series_post ON teams.tmid = series_post.tmidloser AND teams.year = series_post.year WHERE series_post.round = 'QF' AND teams.year = 1946;
SELECT players.fullgivenname FROM     players JOIN     players_teams ON players.playerid = players_teams.playerid JOIN     series_post ON players_teams.tmid = series_post.tmidwinner AND players_teams.year = series_post.year WHERE     series_post.round = 'F'     AND series_post.year = 1970;
SELECT players.college FROM awards_players JOIN players ON awards_players.playerid = players.playerid WHERE awards_players.year = 1970 GROUP BY players.college ORDER BY COUNT(awards_players.award) DESC LIMIT 1;
SELECT players.firstname || ' ' || players.lastname AS youngest_rookie_of_the_year_winner FROM players JOIN awards_players ON players.playerid = awards_players.playerid WHERE awards_players.award = 'Rookie of the Year' AND players.birthdate = (SELECT MIN(birthdate) FROM players)
SELECT players.fullgivenname FROM     players JOIN     draft ON players.playerid = draft.playerid WHERE     draft.draftround = 1     AND draft.draftyear = 1973     AND players.birthcountry <> 'USA';
SELECT ROUND((SUM(player_allstar.o_rebounds) * 100.0) / SUM(player_allstar.rebounds), 2) AS percentage_of_offense_rebounds FROM player_allstar JOIN players ON player_allstar.playerid = players.playerid WHERE player_allstar.season_id = 2000; 
SELECT teams.year, teams.name AS team, coaches.coachid AS coach FROM coaches JOIN teams ON coaches.tmid = teams.tmid AND coaches.year = teams.year WHERE CAST(teams.won AS REAL) / (teams.won + teams.lost) > 0.75 
SELECT coaches.coachid FROM coaches JOIN teams ON coaches.tmid = teams.tmid AND coaches.year = teams.year WHERE teams.name = 'Oklahoma City Thunder';
SELECT COUNT(DISTINCT playerid) FROM players_teams WHERE year = 1990 AND orebounds <= drebounds * 0.5;
SELECT COUNT(DISTINCT players.playerid) FROM     players LEFT JOIN     player_allstar ON players.playerid = player_allstar.playerid LEFT JOIN     players_teams ON players.playerid = players_teams.playerid LEFT JOIN     teams ON players_teams.tmid = teams.tmid AND players_teams.year = teams.year LEFT JOIN     series_post ON teams.tmid = series_post.tmidloser AND teams.year = series_post.year LEFT JOIN     awards_players ON players.playerid = awards_players.playerid WHERE     players_teams.steals <= 10     AND player_allstar.season_id BETWEEN 2000 AND 2005;
SELECT players.firstname, players.lastname FROM players JOIN draft ON players.playerid = draft.playerid JOIN awards_players ON players.playerid = awards_players.playerid WHERE draft.draftround = 2 AND draft.draftyear = 1971 AND awards_players.award = 'Rookie of the Year' AND draft.tmid = 'POR';
SELECT COUNT(DISTINCT player_allstar.playerid) FROM     player_allstar JOIN     players ON player_allstar.playerid = players.playerid WHERE     player_allstar.season_id = 1973     AND players.race = 'B';
SELECT teams.name FROM series_post JOIN teams ON series_post.tmidwinner = teams.tmid AND series_post.year = teams.year WHERE series_post.round = 'QF' AND teams.d_pts >= 3513 AND series_post.year = 1947;
SELECT ROUND((SUM(teams.lost) * 100.0) / SUM(teams.games), 2) AS percentage_of_games_lost FROM teams WHERE teams.name = 'Houston Mavericks';
SELECT players.playerid FROM awards_players JOIN players ON awards_players.playerid = players.playerid WHERE awards_players.award = 'Most Valuable Player' AND awards_players.year > 1990;
SELECT COUNT(*)  FROM players_teams  WHERE playerid = 'abdulka01'  AND tmid = 'LAL'  AND year BETWEEN 1975 AND 1980;
SELECT 100 * COUNT(awards_coaches.coachid) / COUNT(coaches.coachid) FROM awards_coaches JOIN coaches ON awards_coaches.coachid = coaches.coachid WHERE coaches.year = 1969 AND awards_coaches.award = 'NBA Coach of the Year';
SELECT 100 * ((     SELECT COUNT(*)     FROM series_post     WHERE year = 1947 AND tmidwinner = 'CHS' ) / (     SELECT COUNT(*)     FROM series_post     WHERE year = 1947 ) - (     SELECT COUNT(*)     FROM series_post     WHERE year = 1946 AND tmidwinner = 'CHS' ) / (     SELECT COUNT(*)     FROM series_post     WHERE year = 1946 )) AS difference_percentage;
SELECT COUNT(award) FROM awards_players JOIN players ON awards_players.playerid = players.playerid WHERE year = 2010 AND highschool LIKE '%Chicago%'
SELECT 100.0 * COUNT(DISTINCT awards_players.playerid) / COUNT(DISTINCT players.playerid) FROM awards_players JOIN players ON awards_players.playerid = players.playerid WHERE players.college = 'Auburn' AND awards_players.award = 'All-Defensive Second Team';
SELECT players.firstname || ' ' || players.middlename || ' ' || players.lastname AS full_name FROM players JOIN players_teams ON players.playerid = players_teams.playerid WHERE players_teams.year = 1997 ORDER BY players_teams.steals DESC LIMIT 5;
SELECT college FROM     players JOIN     draft ON players.playerid = draft.playerid JOIN     awards_players ON players.playerid = awards_players.playerid WHERE     awards_players.award = 'Finals MVP'     AND awards_players.year = 1990     AND draft.lgid = 'NBA'
SELECT playerid FROM     player_allstar WHERE     league_id = 'NBA'     AND season_id = 1996     AND ft_attempted > 0     AND ft_made > 0     AND (ft_made / ft_attempted) > 0.7;
SELECT COUNT(*)  FROM player_allstar JOIN players ON player_allstar.playerid = players.playerid WHERE season_id BETWEEN 1980 AND 1983 AND league_id = 'NBA' AND (three_made / three_attempted) > 0.6;
SELECT awards_coaches.coachid FROM awards_coaches JOIN coaches ON awards_coaches.coachid = coaches.coachid AND awards_coaches.year = coaches.year JOIN teams ON coaches.tmid = teams.tmid AND coaches.year = teams.year WHERE teams.lgid = 'NBA' AND teams.tmid = 'STL'
SELECT COUNT(awards_coaches.id) FROM awards_coaches JOIN coaches ON awards_coaches.coachid = coaches.coachid AND awards_coaches.year = coaches.year JOIN teams ON coaches.tmid = teams.tmid WHERE teams.franchid = 'CHI' AND awards_coaches.award = 'Coach of the Year' AND teams.lgid = 'NBA';
SELECT players.firstname, players.lastname FROM     players JOIN     draft ON players.playerid = draft.playerid JOIN     player_allstar ON players.playerid = player_allstar.playerid WHERE     player_allstar.league_id = 'NBA'     AND draft.draftyear BETWEEN 1990 AND 2000 GROUP BY     players.playerid ORDER BY     MAX(player_allstar.points) DESC LIMIT 1;
SELECT players.first_name || ' ' || players.middlename || ' ' || players.last_name AS full_name FROM     players JOIN     player_allstar ON players.playerid = player_allstar.playerid WHERE     players.college = 'Wake Forest college' GROUP BY     players.playerid HAVING     MAX(player_allstar.o_rebounds - player_allstar.d_rebounds) = (         SELECT MAX(player_allstar.o_rebounds - player_allstar.d_rebounds)         FROM players         JOIN player_allstar ON players.playerid = player_allstar.playerid         WHERE players.college = 'Wake Forest college'     );
SELECT players.fullgivenname AS player_name, teams.name AS team_name FROM players JOIN players_teams ON players.playerid = players_teams.playerid JOIN teams ON players_teams.tmid = teams.tmid WHERE players.birthcity = 'Atlanta' AND players_blocks = (     SELECT    MAX(blocks)     FROM     players     WHERE     birthcity = 'Atlanta' )
SELECT teams.name FROM teams WHERE teams.year BETWEEN 1980 AND 2000 GROUP BY teams.franchid HAVING COUNT(CASE WHEN teams.rank = 1 THEN 1 END) >= 5 AND SUM(CASE WHEN teams.lost > 2 THEN 1 ELSE 0 END) >= 2;
SELECT players_teams.playerid, players_teams.tmid, MAX(players_teams.points / players_teams.minutes) AS points_per_minute FROM players_teams JOIN teams ON players_teams.tmid = teams.tmid AND players_teams.year = teams.year WHERE teams.lgid = 'NBA' AND teams.year BETWEEN 1991 AND 2000 GROUP BY players_teams.playerid ORDER BY points_per_minute DESC LIMIT 1;
SELECT AVG(     CASE         WHEN draft.lgid = 'ABA' THEN 1970 - strftime('%Y', players.birthdate)         ELSE NULL     END ) - AVG(     CASE         WHEN draft.lgid = 'NBA' THEN 1970 - strftime('%Y', players.birthdate)         ELSE NULL     END ) FROM     draft JOIN players ON draft.playerid = players.playerid WHERE     draft.draftyear BETWEEN 1970 AND 1970;
SELECT players.firstname || ' ' || players.lastname AS player_name, MAX(players_teams.gp) AS max_games_played FROM players JOIN players_teams ON players.playerid = players_teams.playerid JOIN teams ON players_teams.tmid = teams.tmid AND players_teams.year = teams.year WHERE teams.year = 2011 AND teams.lgid = 'NBA' GROUP BY players.playerid ORDER BY max_games_played DESC LIMIT 1;
SELECT COUNT(DISTINCT players.playerid) FROM     draft JOIN     player_allstar ON draft.playerid = player_allstar.playerid WHERE     draft.draftyear = 1996     AND draft.draftround = 1     AND draft.lgid = 'NBA';
SELECT teams.name FROM awards_players JOIN players ON awards_players.playerid = players.playerid JOIN teams ON players_teams.tmid = teams.tmid AND players_teams.year = teams.year WHERE awards_players.award LIKE '%MVP' AND awards_players.year = 1997 AND teams.lgid = 'NBA';
SELECT SUM(teams.won) FROM teams INNER JOIN (     SELECT    tmid,     MAX(o_pts) AS max_pts     FROM     teams     WHERE     year = 2001 AND lgid = 'NBA'     GROUP BY     year ) AS scoring_champion ON teams.tmid = scoring_champion.tmid AND teams.o_pts = scoring_champion.max_pts WHERE teams.year = 2001 AND teams.lgid = 'NBA';
SELECT AVG(turnovers) AS turnovers_per_game FROM players_teams JOIN players ON players_teams.playerid = players.playerid WHERE players_teams.year = 2003 AND players_teams.lgid = 'NBA' AND players_teams.assists = (     SELECT MAX(assists)     FROM players_teams     JOIN players ON players_teams.playerid = players.playerid     WHERE players_teams.year = 2003     AND players_teams.lgid = 'NBA' );
SELECT COUNT(*) FROM     players_teams     JOIN players ON players_teams.playerid = players.playerid     JOIN teams ON players_teams.tmid = teams.tmid AND players_teams.year = teams.year WHERE     players.firstname = 'Ray' AND players.lastname = 'Allen' AND teams.lgid = 'NBA'
SELECT SUM(won) / (SUM(won) + SUM(lost)) AS win_rate_2004, (SUM(won) - (SELECT SUM(won) FROM teams WHERE year = 2002)) / ((SUM(won) + SUM(lost)) - (SELECT (SUM(won) + SUM(lost)) FROM teams WHERE year = 2002)) AS win_rate_increase FROM teams WHERE year = 2004;
SELECT COUNT(DISTINCT awards_coaches.coachid) FROM     awards_coaches     JOIN coaches ON awards_coaches.coachid = coaches.coachid     JOIN teams ON coaches.tmid = teams.tmid AND coaches.year = teams.year WHERE     awards_coaches.award = 'NBA coach of the year'     AND coaches.year BETWEEN 1971 AND 1975     AND teams.franchid = 'POR';
SELECT 100.0 * (SELECT COUNT(playerID) FROM players_teams WHERE steals > 0 AND lgid = 'NBA' AND tmid = 'LAL') / (SELECT COUNT(playerID) FROM players_teams WHERE lgid = 'NBA' AND tmid = 'LAL') AS percentage_steals_points;
SELECT players.first_name || ' ' || players.lastname AS player_name FROM players JOIN players_teams ON players.playerid = players_teams.playerid WHERE players_teams.year = 1996 AND players_teams.playoff IS NULL ORDER BY players_teams.steals DESC LIMIT 1;
SELECT players_teams.playerid FROM players_teams JOIN teams ON players_teams.tmid = teams.tmid AND players_teams.year = teams.year WHERE teams.playoff = 0 AND teams.year = 1988 AND players_teams.turnovers = (     SELECT MAX(turnovers)     FROM players_teams     JOIN teams ON players_teams.tmid = teams.tmid AND players_teams.year = teams.year     WHERE teams.playoff = 0     AND teams.year = 1988 );
SELECT teams.name FROM teams LEFT JOIN (     SELECT        tmid,         SUM(won) AS total_won,         SUM(lost) AS total_lost     FROM teams     WHERE lgid = 'NBA' AND year = 2000 AND playoff = 0     GROUP BY tmid ) AS team_stats ON teams.tmid = team_stats.tmid ORDER BY total_won / (total_won + total_lost) DESC LIMIT 1;
SELECT teams.name FROM teams LEFT JOIN (     SELECT tmid, year, MAX(o_pts) AS max_points     FROM players_teams     WHERE year = 1998 AND postgp = 0     GROUP BY tmid, year ) AS max_points_table ON teams.tmid = max_points_table.tmid AND teams.year = max_points_table.year WHERE max_points_table.max_points IS NOT NULL ORDER BY max_points_table.max_points DESC LIMIT 1;
SELECT teams.name FROM teams WHERE year = 2001 AND playoff = 0 AND won = (SELECT MAX(won) FROM teams WHERE year = 2001 AND playoff = 0);
SELECT teams.name FROM teams LEFT JOIN (     SELECT    tmid,     SUM(rebounds) AS total_rebounds     FROM     players_teams     WHERE     year = 1997     GROUP BY     tmid ) AS team_rebounds ON teams.tmid = team_rebounds.tmid LEFT JOIN (     SELECT    tmid,     COUNT(*) AS playoff_appearances     FROM     series_post     WHERE     year = 1997     GROUP BY     tmid ) AS playoff_counts ON teams.tmid = playoff_counts.tmid WHERE teams.playoff = 0 AND team_rebounds.total_rebounds = (     SELECT    MAX(total_rebounds)     FROM     (         SELECT        tmid,         SUM(rebounds) AS total_rebounds         FROM         players_teams         WHERE         year = 1997         GROUP BY         tmid     ) AS max_rebounds ) AND playoff_counts.playoff_appearances = 0;
SELECT players.namegiven FROM     players JOIN     draft ON players.playerid = draft.playerid JOIN     teams ON draft.tmid = teams.tmid WHERE     draft.draftyear = 1976     AND draft.draftround = 1     AND draft.draftselection = 6     AND teams.year = 1976;
SELECT SUM(teams.homewon) FROM     teams JOIN     draft ON teams.year = draft.draftyear AND teams.tmid = draft.tmid WHERE     teams.year = 1998     AND draft.draftround = 1     AND draft.draftselection = 12;
SELECT MAX(players.height) AS height, MAX(players.weight) AS weight FROM players JOIN player_allstar ON players.playerid = player_allstar.playerid GROUP BY players.playerid ORDER BY MAX(player_allstar.rebounds) DESC LIMIT 1;
SELECT players.highschool FROM player_allstar JOIN players ON player_allstar.playerid = players.playerid WHERE player_allstar.rebounds = (     SELECT MAX(rebounds)     FROM player_allstar )
SELECT MAX(player_allstar.rebounds) AS max_rebounds,     player_allstar.playerid,     teams.tmid FROM     player_allstar JOIN     teams ON player_allstar.tmid = teams.tmid AND player_allstar.season_id = teams.year WHERE     player_allstar.season_id = 1997 GROUP BY     player_allstar.playerid;
SELECT SUM(player_allstar.points) AS career_points FROM player_allstar JOIN players ON player_allstar.playerid = players.playerid WHERE player_allstar.season_id = (SELECT MAX(season_id) FROM player_allstar) AND players.pos LIKE '%C%' OR players.pos LIKE '%F%' OR players.pos LIKE '%G%';
SELECT teams.name FROM players_teams JOIN players ON players_teams.playerid = players.playerid JOIN teams ON players_teams.tmid = teams.tmid AND players_teams.year = teams.year WHERE players.pos LIKE '%F-G' AND teams.lgid = 'NBA' AND players.birthdate = (SELECT MAX(birthdate) FROM players WHERE pos LIKE '%F-G')
SELECT MAX(player_allstar.games_played), player_allstar.first_name, player_allstar.last_name FROM player_allstar JOIN players ON player_allstar.playerid = players.playerid WHERE players.college = 'Central Missouri State';
SELECT teams.name FROM players_teams JOIN teams ON players_teams.tmid = teams.tmid AND players_teams.year = teams.year WHERE players_teams.year = 2000 AND players_teams.gp = 82 ORDER BY players_teams.minutes ASC LIMIT 1;
SELECT players.first_name || ' ' || players.last_name AS player_name FROM players_teams JOIN players ON players_teams.playerid = players.playerid WHERE players_teams.year = 1995 AND players_teams.gp = 82 ORDER BY players_teams.turnovers DESC LIMIT 1;
SELECT teams.tmid FROM players_teams JOIN players ON players.playerid = players_teams.playerid JOIN teams ON teams.tmid = players_teams.tmid AND teams.year = players_teams.year WHERE players_teams.year = 2011 AND players_teams.gs = players_teams.gp AND players_teams.steals = (     SELECT MAX(steals)     FROM players_teams     WHERE year = 2011 )
SELECT teams.name FROM teams JOIN (     SELECT        tmid,         COUNT(*) AS same_starting_players_count     FROM         players_teams     WHERE         gp = gs     GROUP BY         tmid     ORDER BY         same_starting_players_count DESC     LIMIT 1 ) AS starting_players_count ON teams.tmid = starting_players_count.tmid;
SELECT MAX(players.rebounds), players.birthdate FROM players JOIN players_teams ON players.playerid = players_teams.playerid JOIN teams ON players_teams.tmid = teams.tmid AND players_teams.year = teams.year WHERE teams.year = 2001 GROUP BY players.birthdate ORDER BY MAX(players.rebounds) DESC LIMIT 1;
SELECT teams.name FROM     players JOIN     player_allstar ON players.playerid = player_allstar.playerid JOIN     players_teams ON players.playerid = players_teams.playerid JOIN     teams ON players_teams.tmid = teams.tmid AND players_teams.year = teams.year WHERE     players_teams.year = 1997 ORDER BY     player_allstar.rebounds DESC LIMIT 1;
SELECT teams.name FROM     teams JOIN     players_teams ON teams.tmid = players_teams.tmid AND teams.year = players_teams.year JOIN     players ON players_teams.playerid = players.playerid WHERE     teams.year = 2011 GROUP BY     teams.name HAVING     COUNT(players.playerid) > 1 AND SUM(players_teams.rebounds) > 600;
SELECT COUNT(*) FROM works WHERE date < 1602;
SELECT COUNT(chapters.scene) FROM chapters JOIN works ON chapters.work_id = works.id WHERE chapters.act = 1 AND works.title = 'Twelfth Night';
SELECT `paragraphs`.`plaintext` FROM `paragraphs` INNER JOIN `chapters` ON `paragraphs`.`chapter_id` = `chapters`.`id` INNER JOIN `works` ON `chapters`.`work_id` = `works`.`id` WHERE `works`.`title` = 'Twelfth Night' AND `chapters`.`act` = 1 AND `chapters`.`scene` = 2;
SELECT COUNT(DISTINCT CASE WHEN act = 1 THEN scene END) - COUNT(DISTINCT CASE WHEN act = 5 THEN scene END) AS "Difference in Scenes" FROM chapters WHERE work_id = (SELECT id FROM works WHERE title = 'Twelfth Night');
SELECT works.title FROM characters JOIN works ON characters.id = works.id WHERE characters.charname = 'Lord Abergavenny';
SELECT charname FROM characters WHERE id IN (     SELECT    character_id     FROM     paragraphs     WHERE     chapter_id IN (         SELECT        id         FROM         chapters         WHERE         work_id = (             SELECT            id             FROM             works             WHERE             title = 'Twelfth Night'         )     ) )
SELECT COUNT(paragraphs.id) FROM     paragraphs JOIN     chapters ON paragraphs.chapter_id = chapters.id JOIN     works ON chapters.work_id = works.id WHERE     works.title = 'Twelfth Night'     AND chapters.act = 1     AND chapters.scene = 1;
SELECT paragraphs.plaintext FROM   paragraphs JOIN chapters ON paragraphs.chapter_id = chapters.id JOIN works ON chapters.work_id = works.id WHERE   chapters.act = 1   AND chapters.scene = 1   AND works.title = 'Twelfth Night';
SELECT COUNT(paragraphs.id) FROM     paragraphs JOIN     characters ON paragraphs.character_id = characters.id WHERE     characters.charname = 'Lord Abergavenny';
SELECT paragraphs.id FROM paragraphs JOIN characters ON paragraphs.character_id = characters.id WHERE characters.description = 'son to Tamora';
SELECT COUNT(*) FROM     chapters JOIN     works ON chapters.work_id = works.id WHERE     works.title = 'Twelfth Night' AND     chapters.description = 'OLIVIA’S house.';
SELECT COUNT(DISTINCT characters.id) FROM characters JOIN paragraphs ON characters.id = paragraphs.character_id JOIN chapters ON paragraphs.chapter_id = chapters.id JOIN works ON chapters.work_id = works.id WHERE works.title = 'Twelfth Night';
SELECT MAX(w.title) AS title FROM works w JOIN chapters c ON w.id = c.work_id JOIN paragraphs p ON c.id = p.chapter_id JOIN characters ch ON p.character_id = ch.id GROUP BY w.id ORDER BY COUNT(DISTINCT ch.id) DESC LIMIT 1;
SELECT AVG(characters.id)  FROM      characters  JOIN      paragraphs ON characters.id = paragraphs.character_id  JOIN      chapters ON paragraphs.chapter_id = chapters.id  JOIN      works ON chapters.work_id = works.id  WHERE      works.genretype = 'Shakespeare';
SELECT ROUND(AVG(scene), 2) AS average_scenes_per_act FROM (     SELECT COUNT(DISTINCT scene) AS scene     FROM chapters     WHERE act IN (         SELECT id         FROM chapters         WHERE work_id = (             SELECT id             FROM works             WHERE title = 'Twelfth Night'         )     )     GROUP BY act ) subquery;
SELECT COUNT(*) FROM works WHERE genretype = 'Comedy';
SELECT MIN(date) FROM     works WHERE     genretype = 'Poem'
SELECT abbrev FROM characters WHERE charname = 'Earl of Westmoreland';
SELECT MAX(chapter_count) AS max_paragraphs, (SELECT description FROM chapters WHERE id = chapter_id) AS chapter_description FROM (     SELECT chapter_id, COUNT(*) AS chapter_count     FROM paragraphs     GROUP BY chapter_id ) AS paragraph_counts;
SELECT characters.charname FROM paragraphs INNER JOIN characters ON paragraphs.character_id = characters.id WHERE paragraphs.plaintext = 'Would he do so, I'ld beg your precious mistress, Which he counts but a trifle.'
SELECT COUNT(DISTINCT characters.id) FROM     characters JOIN     paragraphs ON characters.id = paragraphs.character_id JOIN     chapters ON paragraphs.chapter_id = chapters.id JOIN     works ON chapters.work_id = works.id WHERE     works.title = 'Titus Andronicus';
SELECT COUNT(DISTINCT act) AS num_acts FROM chapters JOIN works ON chapters.work_id = works.id WHERE longtitle = 'Two Gentlemen of Verona';
SELECT paragraphs.character_id, characters.description FROM paragraphs JOIN characters ON paragraphs.character_id = characters.id WHERE paragraphs.id = '640171';
SELECT works.title FROM works JOIN chapters ON works.id = chapters.work_id JOIN paragraphs ON chapters.id = paragraphs.chapter_id JOIN characters ON paragraphs.character_id = characters.id WHERE characters.charname = 'Shylock';
SELECT COUNT(scene) FROM chapters WHERE work_id = (SELECT id FROM works WHERE title = 'King John')
SELECT COUNT(DISTINCT chapters.id) FROM     chapters JOIN characters ON chapters.work_id = characters.id WHERE     characters.charname = 'Demetrius';
SELECT title FROM works WHERE id IN (     SELECT    work_id     FROM     chapters     WHERE     id IN (         SELECT        chapter_id         FROM         paragraphs         WHERE         character_id = 324         AND         plaintext LIKE '%this friend of Caesar%'     ) ); 
SELECT description FROM     chapters WHERE     act = '2'     AND scene = '2'     AND work_id = (         SELECT id FROM works WHERE title = 'Midsummer Night''s Dream'     ); 
SELECT works.longtitle FROM works JOIN chapters ON works.id = chapters.work_id WHERE works.genretype = 'Tragedy' GROUP BY works.longtitle ORDER BY COUNT(chapters.scene) DESC LIMIT 1; 
SELECT COUNT(paragraphs.id) FROM     paragraphs JOIN     chapters ON paragraphs.chapter_id = chapters.id WHERE     chapters.scene = "A Sea-port in Cyprus. An open place near the quay."
SELECT ROUND((COUNT(scenes.id) * 100.0) / (SELECT COUNT(*) FROM chapters INNER JOIN works ON chapters.work_id = works.id WHERE works.date = '1594' AND works.genretype = 'Tragedy'), 2) AS percentage FROM chapters INNER JOIN works ON chapters.work_id = works.id WHERE works.date = '1594' AND works.genretype = 'Tragedy' AND chapters.scene IS NOT NULL; 
SELECT AVG(CASE WHEN works.date = '1599' THEN COUNT(chapters.id) ELSE 0 END) / COUNT(DISTINCT works.id) FROM chapters INNER JOIN works ON chapters.work_id = works.id;
SELECT COUNT(*) FROM     characters WHERE     description = 'servant to Timon';
SELECT w.title FROM works w WHERE w.date = (SELECT MIN(date) FROM works);
SELECT COUNT(*) FROM works WHERE genretype = 'Poem' AND author = 'Shakespeare';
SELECT COUNT(DISTINCT scene) AS scene_count FROM chapters WHERE work_id = 7 AND act = 1; 
SELECT COUNT(*) AS num_tragedies FROM works WHERE date BETWEEN 1500 AND 1599 AND genretype = 'Tragedy';
SELECT characters.charname FROM characters JOIN works ON characters.work_id = works.id WHERE characters.description = 'Daughter to Capulet' AND works.title = 'Romeo and Juliet';
SELECT COUNT(paragraphs.id) FROM     paragraphs JOIN     chapters ON paragraphs.chapter_id = chapters.id WHERE     chapters.description = 'Ay, surely, mere the truth: I know his lady.';
SELECT (SELECT w.longtitle  FROM works w  INNER JOIN chapters c ON w.id = c.work_id  WHERE c.act = 1  GROUP BY w.id  ORDER BY COUNT(c.scene) DESC  LIMIT 1) 
SELECT MAX(description) FROM chapters WHERE id = (     SELECT chapter_id     FROM (         SELECT chapter_id, COUNT(*) as paragraph_count         FROM paragraphs         GROUP BY chapter_id         ORDER BY paragraph_count DESC         LIMIT 1     ) AS max_paragraphs )
SELECT `description` FROM     chapters WHERE     act = 2     AND scene = 2     AND work_id = (         SELECT            id         FROM             works         WHERE             longtitle = 'Twelfth Night, Or What You Will'     );
SELECT chapters.description FROM chapters JOIN paragraphs ON chapters.id = paragraphs.chapter_id WHERE paragraphs.paragraphnum < 150;
SELECT w.title FROM works w JOIN chapters c ON w.id = c.work_id WHERE c.description = "A field near Windsor"; 
SELECT COUNT(paragraphs.id) FROM     chapters JOIN     paragraphs ON chapters.id = paragraphs.chapter_id WHERE     chapters.act = 1 GROUP BY     chapters.id ORDER BY     COUNT(DISTINCT chapters.scene) DESC LIMIT 1;
SELECT charname FROM characters JOIN paragraphs ON characters.id = paragraphs.character_id JOIN chapters ON paragraphs.chapter_id = chapters.id WHERE chapters.description = 'The sea-coast.' AND characters.charname != '(stage directions)' GROUP BY characters.charname HAVING COUNT(character_id) = 5; 
SELECT COUNT(DISTINCT chapters.id) FROM chapters JOIN works ON chapters.work_id = works.id JOIN paragraphs ON paragraphs.chapter_id = chapters.id WHERE works.title = 'As You Like It' AND paragraphs.paragraphnum < 50;
SELECT characters.id FROM characters JOIN paragraphs ON characters.id = paragraphs.character_id JOIN chapters ON paragraphs.chapter_id = chapters.id WHERE chapters.description = 'Florence. Without the walls. A tucket afar off' AND paragraphs.plaintext = 'His name, I pray you.';
SELECT COUNT(DISTINCT characters.id) FROM characters JOIN works ON characters.id = works.id WHERE works.title = 'Hamlet';
SELECT COUNT(*) FROM chapters WHERE act = 5 AND work_id = (     SELECT id     FROM works     WHERE longtitle = 'History of Henry VIII' );
SELECT COUNT(DISTINCT w.id) FROM works w JOIN chapters c ON w.id = c.work_id WHERE w.genretype = 'History' AND c.act = 1 GROUP BY w.id HAVING COUNT(DISTINCT c.scene) <= 2;
SELECT COUNT(DISTINCT act) FROM chapters WHERE work_id = (SELECT id FROM works WHERE title = 'Sonnets');
SELECT `description` FROM     chapters WHERE     id = (         SELECT            chapter_id         FROM             paragraphs         WHERE             character_id = (                 SELECT                    id                 FROM                     characters                 WHERE                     abbrev = '1Play'             )         ORDER BY             chapter_id         LIMIT 1     );
SELECT title, genretype FROM works WHERE act = 1; 
SELECT COUNT(paragraphs.id) AS paragraph_count FROM     chapters JOIN     paragraphs ON chapters.id = paragraphs.chapter_id JOIN     characters ON paragraphs.character_id = characters.id WHERE     characters.charname = 'Sir Richard Ratcliff' AND     chapters.id = (         SELECT            chapter_id         FROM             paragraphs         WHERE             character_id = (                 SELECT                    id                 FROM                     characters                 WHERE                     charname = 'Sir Richard Ratcliff'             )         GROUP BY             chapter_id         ORDER BY             COUNT(id) DESC         LIMIT 1     );
SELECT description FROM chapters WHERE act = 1 AND scene = 1 AND work_id = (     SELECT id FROM works WHERE title = 'A Lover''s Complaint' );
SELECT date FROM works WHERE genretype = 'Shakespeare' AND id IN (     SELECT    work_id     FROM     chapters     GROUP BY     work_id     HAVING     COUNT(DISTINCT scene) = 154 ); 
SELECT AVG(scenes_per_comedy) FROM (     SELECT        COUNT(DISTINCT scene) AS scenes_per_comedy     FROM         chapters     INNER JOIN         works ON chapters.work_id = works.id     WHERE         works.genretype = 'Comedy'     GROUP BY         works.id ) subquery;
SELECT (SELECT    ((SELECT COUNT(*) FROM paragraphs         JOIN characters ON paragraphs.character_id = characters.id         JOIN works ON paragraphs.work_id = works.id         WHERE characters.charname = 'Romeo'         AND works.longtitle = 'The Tragedy of Romeo and Juliet') * 100.0) /     (SELECT COUNT(*) FROM paragraphs         JOIN works ON paragraphs.work_id = works.id         WHERE works.longtitle = 'The Tragedy of Romeo and Juliet')) AS Romeo_percentage,     ((SELECT COUNT(*) FROM paragraphs         JOIN characters ON paragraphs.character_id = characters.id         JOIN works ON paragraphs.work_id = works.id         WHERE characters.charname = 'Juliet'         AND works.longtitle = 'The Tragedy of Romeo and Juliet') * 100.0) /     (SELECT COUNT(*) FROM paragraphs         JOIN works ON paragraphs.work_id = works.id         WHERE works.longtitle = 'The Tragedy of Romeo and Juliet')) AS Juliet_percentage)
SELECT paragraphnum FROM paragraphs WHERE plaintext = "This is Illyria, lady";
SELECT COUNT(*) FROM     paragraphs WHERE     chapter_id = 18881;
SELECT title FROM works WHERE genretype = 'History' LIMIT 5;
SELECT COUNT(*) FROM scenes WHERE act = 5 AND work_id = 9;
SELECT charactername, description FROM characters INNER JOIN paragraphs ON characters.id = paragraphs.character_id WHERE paragraphs.chapter_id = 18710;
SELECT COUNT(*) FROM   chapters JOIN   works ON chapters.work_id = works.id WHERE   works.title = 'Midsummer Night\'s Dream';
SELECT COUNT(paragraphs.id) FROM     paragraphs JOIN     chapters ON paragraphs.chapter_id = chapters.id JOIN     works ON chapters.work_id = works.id WHERE     works.title = 'Comedy of Errors'     AND chapters.act = 5     AND chapters.scene = 1;
SELECT charname, description FROM characters WHERE id IN (     SELECT    character_id     FROM     paragraphs     WHERE     chapter_id IN (         SELECT        id         FROM         chapters         WHERE         work_id IN (             SELECT            id             FROM             works             WHERE             title = 'Venus and Adonis'         )     ) );
SELECT works.title FROM works JOIN characters ON works.id = characters.work_id WHERE characters.charname = 'Froth';
SELECT COUNT(DISTINCT chapters.id) AS chapter_count FROM     chapters JOIN     characters ON chapters.id = characters.chapter_id WHERE     characters.charname = 'First Witch';
SELECT description FROM chapters WHERE act = 1 AND work_id = (     SELECT id     FROM works     WHERE longtitle = 'Pericles, Prince of Tyre' ); 
SELECT works.longtitle FROM works JOIN chapters ON works.id = chapters.work_id JOIN paragraphs ON chapters.id = paragraphs.chapter_id JOIN characters ON paragraphs.character_id = characters.id WHERE characters.description = 'Servant to Montague';
SELECT chapters.scene, chapters.act, works.title FROM chapters JOIN works ON chapters.work_id = works.id WHERE chapters.description = "The house of ANTIPHOLUS of Ephesus"; 
SELECT characters.charname, paragraphs.paragraphnum, paragraphs.plaintext FROM characters JOIN paragraphs ON characters.id = paragraphs.character_id JOIN chapters ON paragraphs.chapter_id = chapters.id WHERE chapters.description = "cousin to the king";
SELECT SUM(scene) / COUNT(DISTINCT act) AS avg_scene_per_act FROM chapters WHERE work_id = (     SELECT id     FROM works     WHERE title = 'Antony and Cleopatra' );
SELECT (CAST((SELECT COUNT(paragraphs.id) FROM paragraphs INNER JOIN chapters ON paragraphs.chapter_id = chapters.id INNER JOIN works ON chapters.work_id = works.id WHERE works.title = 'All''s Well That Ends Well') AS FLOAT) / (SELECT COUNT(paragraphs.id) FROM paragraphs INNER JOIN chapters ON paragraphs.chapter_id = chapters.id INNER JOIN works ON chapters.work_id = works.id WHERE works.title = 'All''s Well That Ends Well')) * 100 AS percentage 
SELECT COUNT(*) FROM     characters WHERE     charname LIKE '%all%' AND abbrev = 'all';
SELECT title FROM works WHERE genretype = 'comedy' LIMIT 3;
SELECT COUNT(CASE WHEN GenreType = 'comedy' THEN 1 ELSE 0 END) - COUNT(CASE WHEN GenreType = 'History' THEN 1 ELSE 0 END) AS difference FROM works WHERE date > 1593;
SELECT MAX(longtitle) FROM works WHERE genretype = 'History'
SELECT works.id FROM works WHERE title LIKE '%Henry%';
SELECT characters.charname FROM characters WHERE characters.description = 'a senator of Venice';
SELECT charname FROM     characters JOIN     paragraphs ON characters.id = paragraphs.character_id WHERE     paragraphs.chapter_id = 18820     AND paragraphs.paragraphnum = 8;
SELECT description FROM chapters WHERE id = 18704 AND id IN (     SELECT chapter_id     FROM paragraphs     WHERE character_id IN (         SELECT id         FROM characters         WHERE charname = 'Orsino'     ) );
SELECT COUNT(DISTINCT chapters.scene) FROM chapters JOIN works ON chapters.work_id = works.id WHERE works.longtitle = "Twelfth Night, Or What You Will";
SELECT characters.description FROM characters JOIN paragraphs ON characters.id = paragraphs.character_id WHERE paragraphs.paragraphnum = 20; 
SELECT COUNT(DISTINCT chapters.id) FROM     chapters JOIN     characters ON chapters.id = paragraphs.chapter_id JOIN     paragraphs ON characters.id = paragraphs.character_id WHERE     characters.charname = 'Gratiano'     AND characters.description = 'friend to Antonio and Bassiano';
SELECT description FROM chapters WHERE work_id = (     SELECT    id     FROM     works     WHERE     title = 'All''s Well That Ends Well' ) AND id = 18706;
SELECT characters.charname FROM paragraphs JOIN characters ON paragraphs.character_id = characters.id WHERE paragraphs.paragraphnum = 3;
SELECT paragraphs.plaintext FROM     paragraphs JOIN     characters ON paragraphs.character_id = characters.id WHERE     characters.charname = 'Aedile';
SELECT characters.charname FROM characters INNER JOIN paragraphs ON characters.id = paragraphs.character_id WHERE paragraphs.chapter_id = 18708 GROUP BY characters.charname HAVING COUNT(*) >= 2;
SELECT COUNT(DISTINCT act) FROM works JOIN chapters ON works.id = chapters.work_id WHERE works.genretype = 'comedy' AND works.title = 'Two Gentlemen of Verona';
SELECT COUNT(works.id) * 100.0 / (SELECT COUNT(works.id) FROM works WHERE genretype = 'history') AS percentage FROM works JOIN chapters ON works.id = chapters.work_id WHERE works.genretype = 'history' AND chapters.scene >= 5 AND works.date >= 1500 AND works.date <= 1599;
SELECT (SELECT (COUNT(*) * 100.0) / (SELECT COUNT(*) FROM chapters WHERE chapters.work_id = works.id) AS percentage  FROM chapters  JOIN works ON chapters.work_id = works.id  WHERE chapters.act = 5 AND works.title = 'Titus Andronicus') 
SELECT COUNT(*) FROM works WHERE genretype = 'Tragedy';
SELECT COUNT(*) FROM     works WHERE     title LIKE '%Henry%';
SELECT characters.id FROM paragraphs JOIN characters ON paragraphs.character_id = characters.id WHERE paragraphs.plaintext = 'O my poor brother! and so perchance may he be.';
SELECT paragraphs.paragraphnum, paragraphs.plaintext FROM paragraphs JOIN characters ON paragraphs.character_id = characters.id WHERE characters.charname = 'Sir Andrew Aguecheek';
SELECT   works.title, characters.charname FROM works JOIN chapters ON works.id = chapters.work_id JOIN paragraphs ON chapters.id = paragraphs.chapter_id JOIN characters ON paragraphs.character_id = characters.id WHERE works.date = (SELECT MAX(date) FROM works WHERE genretype = 'Shakespeare'); 
SELECT PlainText FROM     paragraphs JOIN     characters ON paragraphs.character_id = characters.id JOIN     chapters ON paragraphs.chapter_id = chapters.id WHERE     paragraphs.paragraphnum BETWEEN 1900 AND 1950     AND characters.description = 'a sea captain, friend to Sebastian';
SELECT works.longtitle FROM works JOIN chapters ON works.id = chapters.work_id WHERE works.title = 'Shakespeare' AND chapters.act = 4 AND chapters.scene = 5 AND chapters.description = 'Mytilene. A street before the brothel.';
SELECT characters.charname FROM characters JOIN paragraphs ON characters.id = paragraphs.character_id WHERE paragraphs.plaintext = 'This is Illyria, lady.';
SELECT COUNT(DISTINCT works.id) FROM     works JOIN     chapters ON works.id = chapters.work_id JOIN     paragraphs ON chapters.id = paragraphs.chapter_id JOIN     characters ON paragraphs.character_id = characters.id WHERE     works.date >= 1600     AND works.date <= 1610     AND characters.charname = 'Third Servingman';
SELECT paragraphs.plaintext FROM     paragraphs JOIN chapters ON paragraphs.chapter_id = chapters.id JOIN works ON chapters.work_id = works.id WHERE     works.title = 'Venus and Adonis' AND     chapters.scene = (         SELECT            MAX(scene)         FROM             chapters         WHERE             chapters.work_id = works.id     );
SELECT COUNT(paragraphs.id) AS total_lines FROM     paragraphs JOIN     characters ON paragraphs.character_id = characters.id JOIN     chapters ON paragraphs.chapter_id = chapters.id JOIN     works ON chapters.work_id = works.id WHERE     chapters.act = 1     AND chapters.scene = 2     AND characters.charname = 'Viola'     AND works.title = 'Twelfth Night';
SELECT characters.id, characters.charname, works.id AS work_id FROM     paragraphs JOIN     characters ON paragraphs.character_id = characters.id JOIN     chapters ON paragraphs.chapter_id = chapters.id JOIN     works ON chapters.work_id = works.id WHERE     paragraphs.plaintext = 'Fear not thou, man, thou shalt lose nothing here.';
SELECT chapters.description FROM chapters JOIN paragraphs ON chapters.id = paragraphs.chapter_id WHERE paragraphs.plaintext = 'What, wilt thou hear some music, my sweet love?';
SELECT chapters.scene FROM chapters JOIN characters ON chapters.id = characters.id JOIN paragraphs ON chapters.id = paragraphs.chapter_id JOIN works ON chapters.work_id = works.id WHERE characters.charname = 'Sir Toby Belch' AND works.title = 'Twelfth Night'; 
SELECT title FROM works WHERE date < 1600 AND genretype = 'Tragedy' AND id IN (     SELECT work_id     FROM chapters     WHERE id IN (         SELECT chapter_id         FROM paragraphs         WHERE character_id IN (             SELECT id             FROM characters             WHERE charname = 'Tybalt'         )     ) ); 
SELECT chapters.id FROM chapters JOIN works ON chapters.work_id = works.id WHERE works.date > (SELECT AVG(date) * 0.89 FROM works WHERE works.genretype = 'Shakespeare'); 
SELECT (CAST(COUNT(DISTINCT w.id) AS FLOAT) / COUNT(DISTINCT w.id)) * 100 AS percentage FROM works w JOIN chapters c ON w.id = c.work_id JOIN paragraphs p ON c.id = p.chapter_id JOIN characters ch ON p.character_id = ch.id WHERE w.genretype = 'Comedy' AND ch.charname = 'antonio'; 
SELECT car_name FROM data JOIN price ON data.id = price.id JOIN production ON production.id = data.id JOIN country ON production.country = country.origin WHERE cylinders = 8 ORDER BY price DESC LIMIT 1;
SELECT COUNT(*) FROM     data JOIN     production ON data.id = production.id JOIN     price ON data.id = price.id JOIN     country ON production.country = country.origin WHERE     data.weight > 3000 AND     price.price < 30000;
SELECT MAX(data.acceleration) FROM     data JOIN     price ON data.id = price.id JOIN     production ON production.id = price.id JOIN     country ON production.country = country.origin WHERE     price.price = (         SELECT            MAX(price.price)         FROM             price     );
SELECT price.price FROM price JOIN data ON price.id = data.id JOIN production ON production.id = price.id JOIN country ON production.country = country.origin WHERE data.car_name = 'ford torino'
SELECT country.origin FROM production JOIN price ON production.id = price.id JOIN data ON production.id = data.id JOIN country ON production.country = country.country WHERE data.car_name = 'ford torino' AND production.model_year = 1970;
SELECT COUNT(DISTINCT data.model) FROM     data JOIN     production ON data.id = production.id JOIN     country ON production.country = country.origin WHERE     production.model_year = 1970     AND country.country = 'USA';
SELECT car_name FROM data JOIN production ON data.id = production.id JOIN country ON production.country = country.origin WHERE country = 'USA';
SELECT car_name FROM data JOIN price ON data.id = price.id ORDER BY price DESC LIMIT 3; 
SELECT production.model_year FROM production JOIN data ON production.id = data.id JOIN country ON production.country = country.origin WHERE country.country = 'USA' AND data.car_name = 'chevrolet impala'; 
SELECT COUNT(DISTINCT data.id) FROM   data INNER JOIN   price ON data.id = price.id INNER JOIN   production ON data.id = production.id INNER JOIN   country ON production.country = country.origin WHERE   data.acceleration > 10   AND   price.price > 20000   AND   price.price < 30000;
SELECT weight FROM data JOIN price ON data.id = price.id JOIN production ON production.id = price.id JOIN country ON production.country = country.origin WHERE price.price > 40000; 
SELECT MAX(acceleration) FROM data JOIN price ON data.id = price.id JOIN production ON production.id = price.id JOIN country ON production.country = country.origin WHERE price.price > 40000;
SELECT AVG(price.price) AS average_price FROM price JOIN data ON price.id = data.id WHERE data.cylinders = 8; 
SELECT MAX(displacement / cylinders) AS max_sweep_volume FROM     data JOIN     price ON data.id = price.id JOIN     production ON data.id = production.id JOIN     country ON production.country = country.origin WHERE     price.price < 30000;
SELECT COUNT(DISTINCT data.id) FROM   data JOIN   production ON data.id = production.id JOIN   country ON production.country = country.origin WHERE   country.country = 'Europe';
SELECT country.origin FROM country JOIN production ON country.origin = production.country JOIN data ON production.id = data.id WHERE data.car_name = 'chevrolet malibu';
SELECT MAX(data.mpg) AS "Miles per Gallon" FROM     data JOIN     price ON data.id = price.id JOIN     production ON production.id = price.id JOIN     country ON production.country = country.origin WHERE     price.price = (         SELECT MAX(price.price)         FROM price     );
SELECT country.origin FROM production JOIN country ON production.country = country.country WHERE production.id = 382;
SELECT country.origin FROM price JOIN data ON price.id = data.id JOIN production ON price.id = production.id JOIN country ON production.country = country.country WHERE price.price = 44274.40748;
SELECT price.price FROM price JOIN data ON price.id = data.id JOIN production ON price.id = production.id JOIN country ON production.country = country.origin WHERE data.car_name = 'volkswagen dasher' AND data.acceleration = 14.1;
SELECT displacement FROM     data JOIN     price ON data.id = price.id JOIN     production ON production.id = price.id JOIN     country ON production.country = country.origin WHERE     price.price = 37443.85589;
SELECT MAX(production.model_year) FROM production JOIN price ON production.id = price.id WHERE price.price = 32650.65157;
SELECT price.price FROM price JOIN data ON price.id = data.id JOIN production ON production.id = price.id JOIN country ON production.country = country.origin WHERE data.car_name = 'toyota corona hardtop';
SELECT COUNT(data.cylinders) FROM     data JOIN     price ON data.id = price.id WHERE     price.price = (SELECT MIN(price) FROM price);
SELECT MAX(weight) AS best_crash_protection_weight, car_name, price FROM data JOIN production ON data.id = production.id JOIN country ON production.country = country.origin JOIN price ON data.id = price.id GROUP BY car_name ORDER BY best_crash_protection_weight DESC LIMIT 1;
SELECT country.origin FROM data JOIN production ON data.id = production.id JOIN price ON data.id = price.id JOIN country ON production.country = country.country WHERE data.horsepower = ( SELECT MAX(horsepower) FROM data )
SELECT (SELECT (COUNT(DISTINCT data.id) * 100.0) / COUNT(DISTINCT production.id) AS percentage_japanese_cars FROM production JOIN data ON production.id = data.id JOIN country ON production.country = country.origin WHERE country.country = 'Japan')
SELECT ROUND(data.displacement / data.cylinders, 2) AS swept_volume FROM data JOIN price ON data.id = price.id WHERE price.price = 34538.97449;
SELECT car_name FROM data JOIN price ON data.id = price.id ORDER BY price DESC LIMIT 1; 
SELECT COUNT(data.id) FROM     data JOIN     production ON data.id = production.id JOIN     country ON production.country = country.origin WHERE     country.country = 'USA'     AND production.model_year = 1981;
SELECT MAX(price.price) AS highest_sweep_volume_cost FROM     data JOIN     production ON data.id = production.id JOIN     price ON data.id = price.id JOIN     country ON production.country = country.origin ORDER BY     (data.displacement / data.cylinders) DESC LIMIT     1;
SELECT MAX(data.horsepower) AS max_horsepower, data.car_name FROM data JOIN production ON data.id = production.id JOIN country ON production.country = country.origin WHERE country.country = 'Japan' GROUP BY data.car_name ORDER BY max_horsepower DESC LIMIT 1;
SELECT COUNT(production.id) FROM production JOIN data ON production.id = data.id JOIN country ON production.country = country.origin WHERE car_name = 'ford maverick';
SELECT MAX(country.country) AS "Country" FROM     data JOIN     production ON data.id = production.id JOIN     country ON production.country = country.origin WHERE     data.mpg = (SELECT MAX(mpg) FROM data)
SELECT car_name FROM data JOIN price ON data.id = price.id JOIN production ON production.id = data.id JOIN country ON production.country = country.origin WHERE car_name LIKE 'dodge%' ORDER BY price ASC LIMIT 1;
SELECT MAX(price.price) AS max_price FROM price JOIN data ON price.id = data.id JOIN production ON price.id = production.id JOIN country ON production.country = country.origin WHERE country.country = 'USA';
SELECT COUNT(DISTINCT data.id) FROM data JOIN price ON data.id = price.id JOIN production ON production.id = price.id JOIN country ON production.country = country.origin WHERE data.displacement > 400 AND price.price >= 30000;
SELECT MAX(model_year) AS year FROM     production WHERE     country = 'Europe';
SELECT price.price FROM price JOIN data ON price.id = data.id JOIN production ON production.id = data.id JOIN country ON production.country = country.origin WHERE data.car_name = 'peugeot 505s turbo diesel';
SELECT MIN(data.acceleration) AS miles_per_square_hour FROM     data     JOIN price ON data.id = price.id     JOIN production ON price.id = production.id     JOIN country ON production.country = country.origin WHERE     country.country = 'USA' ORDER BY     price.price ASC LIMIT 1;
SELECT MAX(country) AS highest_producing_country, COUNT(data.id) / COUNT(DISTINCT production.model_year) AS annual_average_number_of_cars FROM production JOIN country ON production.country = country.origin;
SELECT 100 * (     SELECT COUNT(DISTINCT production.id)     FROM production     JOIN country ON production.country = country.origin     JOIN data ON production.id = data.id     JOIN price ON production.id = price.id     WHERE country.country = 'Japan' ) / (     SELECT COUNT(DISTINCT production.id)     FROM production     JOIN country ON production.country = country.origin     JOIN data ON production.id = data.id     JOIN price ON production.id = price.id     WHERE displacement / cylinders > 30 ) AS percentage_of_cars_produced_by_Japan;
SELECT car_name FROM data JOIN production ON data.id = production.id WHERE production.model_year = 1975; 
SELECT AVG(price.price) FROM   price JOIN   data ON price.id = data.id JOIN   production ON price.id = production.id JOIN   country ON production.country = country.origin WHERE   country.country = 'Europe';
SELECT price.price FROM price JOIN data ON price.id = data.id JOIN production ON production.id = price.id JOIN country ON production.country = country.origin WHERE data.id = 15; 
SELECT COUNT(*) FROM     data JOIN     production ON data.id = production.id JOIN     country ON production.country = country.origin WHERE     country.country = 'Japan' AND     data.weight < 3000;
SELECT COUNT(*)  FROM     data JOIN     production ON data.id = production.id WHERE     production.model_year = 1973 AND     data.horsepower < 100;
SELECT data.id FROM data JOIN price ON data.id = price.id JOIN production ON production.id = price.id JOIN country ON production.country = country.origin WHERE country.country = 'Japan' AND price.price > 35000 AND data.acceleration = 14;
SELECT MAX(model_year)  FROM data  WHERE weight = (SELECT MAX(weight) FROM data)
SELECT data.horsepower, production.model_year FROM data JOIN production ON data.id = production.id JOIN country ON production.country = country.origin WHERE data.car_name = 'subaru dl';
SELECT car_name FROM   data JOIN   country ON data.origin = country.origin JOIN   price ON data.id = price.id JOIN   production ON data.id = production.id WHERE   country.country = 'Japan' ORDER BY   price.price DESC LIMIT 1; 
SELECT car_name FROM data JOIN price ON data.id = price.id WHERE price = 20000;
SELECT COUNT(DISTINCT data.id) AS num_cars FROM     price JOIN     data ON price.id = data.id JOIN     production ON price.id = production.id JOIN     country ON production.country = country.origin WHERE     price.price > 40000     AND country.country = 'USA';
SELECT price.price, country.origin FROM price JOIN data ON price.id = data.id JOIN production ON production.id = price.id JOIN country ON production.country = country.origin WHERE data.car_name = 'ford maverick';
SELECT car_name FROM   data JOIN   price ON data.id = price.id WHERE   price > (SELECT AVG(price) * 0.85 FROM price); 
SELECT COUNT(DISTINCT CASE     WHEN production.model_year = 1970 AND data.horsepower = 130 THEN data.id     ELSE NULL END) - COUNT(DISTINCT CASE     WHEN production.model_year = 1976 AND data.horsepower = 130 THEN data.id     ELSE NULL END) AS difference;
SELECT data.id FROM data JOIN production ON data.id = production.id JOIN country ON production.country = country.origin WHERE country.country = 'Japan' AND production.model_year = 1979;
SELECT country.origin FROM country JOIN production ON country.origin = production.country JOIN data ON production.id = data.id WHERE data.mpg = (SELECT MIN(mpg) FROM data);
SELECT data.car_name, data.model, ROUND(data.displacement / data.cylinders, 2) AS sweep_volume, production.model_year FROM data JOIN production ON data.id = production.id WHERE data.weight = (SELECT MAX(weight) FROM data)
SELECT data.horsepower, data.car_name FROM data JOIN production ON data.id = production.id JOIN country ON production.country = country.origin WHERE production.model_year = 1977 AND country.country = 'Europe';
SELECT car_name, model FROM data JOIN price ON data.id = price.id JOIN production ON production.id = price.id JOIN country ON production.country = country.origin WHERE price.price = (SELECT MAX(price.price) FROM price)
SELECT price.price FROM price JOIN data ON price.id = data.id JOIN production ON price.id = production.id JOIN country ON production.country = country.origin WHERE data.car_name = 'chevrolet bel air';
SELECT AVG(price.price) FROM     price JOIN     production ON price.id = production.id JOIN     country ON production.country = country.origin WHERE     country.country = 'Japan'; 
SELECT MIN(country.origin) AS lowest_price_country FROM     country JOIN     production ON country.origin = production.country JOIN     price ON production.id = price.id JOIN     data ON production.id = data.id;
SELECT data.id, data.car_name, country.country FROM data JOIN production ON data.id = production.id JOIN country ON production.country = country.origin WHERE production.model_year = 1975 AND data.cylinders = (SELECT MAX(cylinders) FROM data WHERE data.id IN (SELECT id FROM production WHERE model_year = 1975)) 
SELECT data.acceleration, data.cylinders, production.model_year, data.car_name FROM data JOIN price ON data.id = price.id JOIN production ON production.id = price.id JOIN country ON production.country = country.origin WHERE price.price = (   SELECT MIN(price)   FROM price );
SELECT car_name, price FROM data JOIN production ON data.id = production.id JOIN price ON data.id = price.id JOIN country ON production.country = country.origin WHERE model = 82 AND mpg > 30; 
SELECT COUNT(DISTINCT production.model) FROM production JOIN data ON production.id = data.id WHERE data.car_name = 'ford maverick';
SELECT (Count(*) * 100.0) / (SELECT Count(*) FROM production) AS percentage_of_USA_cars FROM production JOIN country ON production.country = country.origin WHERE country.country = 'USA';
SELECT AVG(COUNT(data.id) / 9) AS average_production_rate_per_year, car_name FROM data JOIN production ON data.id = production.id JOIN price ON data.id = price.id JOIN country ON production.country = country.origin WHERE model_year BETWEEN 1971 AND 1980 AND weight < 1800 GROUP BY car_name;
SELECT AVG(price.price) AS average_price FROM price JOIN production ON price.id = production.id JOIN data ON price.id = data.id JOIN country ON production.country = country.origin WHERE data.model = 70;
SELECT price.price FROM price JOIN data ON price.id = data.id JOIN production ON price.id = production.id JOIN country ON production.country = country.origin WHERE data.car_name = 'chevrolet vega 2300';
SELECT country.origin FROM country JOIN production ON country.origin = production.country JOIN data ON production.id = data.id WHERE data.car_name = 'chevy c20';
SELECT price.price FROM     price JOIN     data ON price.id = data.id JOIN     production ON production.id = price.id JOIN     country ON production.country = country.origin WHERE     data.model >= 1970 AND data.model <= 1980     AND data.car_name LIKE 'ford%'
SELECT car_name FROM data JOIN production ON data.id = production.id JOIN country ON production.country = country.origin WHERE model_year = 1975 ORDER BY mpg DESC LIMIT 1; 
SELECT data.car_name FROM data JOIN production ON data.id = production.id JOIN price ON data.id = price.id JOIN country ON production.country = country.origin WHERE data.mpg = (SELECT MIN(mpg) FROM data) AND price.price = (SELECT MAX(price) FROM price) 
SELECT COUNT(*) FROM     data JOIN     production ON data.id = production.id JOIN     country ON production.country = country.origin WHERE     country.country = 'USA' AND     data.acceleration < 12;
SELECT COUNT(*) FROM data JOIN production ON data.id = production.id JOIN country ON production.country = country.origin WHERE country.country = 'Japan' AND data.weight > 2000;
SELECT car_name FROM     data JOIN     price ON data.id = price.id ORDER BY     price.price DESC LIMIT 1;
SELECT DISTINCT production.model_year FROM     production JOIN     data ON production.id = data.id JOIN     country ON production.country = country.origin WHERE     data.car_name = 'buick skylark 320';
SELECT country.country FROM   country INNER JOIN   production ON country.origin = production.country INNER JOIN   price ON production.id = price.id INNER JOIN   data ON price.id = data.id WHERE   data.model_year = 1970 AND   price.price = (     SELECT      MAX(price)     FROM       price     INNER JOIN       data ON price.id = data.id     WHERE       data.model_year = 1970   ); 
SELECT COUNT(*) FROM     production JOIN     data ON production.id = data.id WHERE     data.horsepower > 200     AND production.model_year = 1975;
SELECT 100 * (SELECT COUNT(DISTINCT data.id) FROM data JOIN production ON data.id = production.id JOIN country ON production.country = country.origin WHERE country.country = 'USA') / (SELECT COUNT(DISTINCT data.id) FROM data)
SELECT AVG(weight) FROM     data JOIN     production ON data.id = production.id JOIN     country ON production.country = country.origin WHERE     country.country = 'Japan'     AND data.cylinders = 4     AND production.model_year BETWEEN 1975 AND 1980; 
SELECT SUM(donation_total) AS total_donations_2012 FROM donations WHERE donation_timestamp LIKE '2012%'
SELECT MAX(donation_total) AS highest_donation_amount, donation_timestamp AS donation_date FROM donations;
SELECT SUM(donation_total) FROM donations WHERE donation_timestamp LIKE '2011%' AND for_honoree = 't' AND via_giving_page = 't';
SELECT donor_acctid, (donation_optional_support / donation_total) * 100 AS percentage_of_optional_support FROM donations WHERE is_teacher_acct = 'f';
SELECT projects.title FROM projects WHERE projects.primary_focus_subject = 'Literacy'; 
SELECT projects.title FROM projects JOIN essays ON projects.projectid = essays.projectid WHERE projects.poverty_level = 'highest poverty'
SELECT primary_focus_subject FROM projects WHERE title = 'Toot Your Flute!';
SELECT title FROM     projects WHERE     teacher_prefix = 'Dr.';
SELECT title, total_price_excluding_optional_support FROM projects WHERE students_reached = 320;
SELECT donations.donation_message, projects.title FROM donations JOIN projects ON donations.projectid = projects.projectid WHERE donor_city = 'Texas City';
SELECT vendor_name, item_name, item_unit_price FROM resources WHERE projectid = (     SELECT projectid     FROM projects     WHERE title = 'Lights, Camera, Action!' );
SELECT SUM(donation_to_project) AS total_donations_collected FROM donations JOIN projects ON donations.projectid = projects.projectid WHERE projects.title = 'Whistle While We Work!';
SELECT projects.title AS project_name, projects.short_description AS project_description FROM projects WHERE projects.teacher_ny_teaching_fellow = 't' AND projects.school_state = 'NY';
SELECT projects.title, projects.total_price_excluding_optional_support AS project_cost FROM projects JOIN donations ON projects.projectid = donations.projectid WHERE projects.poverty_level = 'moderate poverty' AND projects.students_reached >= 600;
SELECT ((SUM(donation_total) FILTER (WHERE projects.school_metro = 'rural')) / SUM(donation_total)) * 100 AS percentage_rural_donations
SELECT projects.title AS project_name, MAX(projects.total_price_excluding_optional_support) AS max_cost, SUM(donations.donation_to_project) AS total_collected, ((MAX(projects.total_price_excluding_optional_support) - SUM(donations.donation_to_project)) / SUM(donations.donation_to_project)) * 100 AS percentage_lacking FROM projects JOIN donations ON projects.projectid = donations.projectid GROUP BY projects.projectid ORDER BY max_cost DESC LIMIT 1;
SELECT COUNT(DISTINCT projects.schoolid) FROM     projects WHERE     projects.school_district = 'West New York School District'     AND projects.poverty_level = 'highest poverty';
SELECT COUNT(*) FROM donations JOIN projects ON donations.projectid = projects.projectid WHERE is_teacher_acct = 't' AND donor_state = 'CO-Colorado';
SELECT projects.projectid FROM projects ORDER BY total_price_including_optional_support DESC LIMIT 1;
SELECT MAX(donor_state) AS state_with_highest_paypal_donations FROM donations WHERE payment_method = 'paypal'  AND for_honoree = 't'  AND payment_included_campaign_gift_card = 't';
SELECT donationid, MAX(donation_total) as total_amount FROM donations;
SELECT MAX(donation_optional_support) AS highest_optional_tip, projectid FROM donations GROUP BY projectid ORDER BY highest_optional_tip DESC LIMIT 1;
SELECT resources.item_name, resources.item_quantity,  CASE WHEN teacher_prefix = 'Dr. ' THEN 'Yes' ELSE 'No' END AS acquired_phd_or_doctor_degree FROM resources JOIN projects ON resources.projectid = projects.projectid WHERE projects.projectid = 'd6ef27c07c30c81f0c16c32b6acfa2ff';
SELECT SUM(projects.total_price_including_optional_support) AS total_price FROM projects JOIN essays ON projects.projectid = essays.projectid WHERE essays.title = "Recording Rockin' Readers" 
SELECT projects.school_latitude, projects.school_longitude FROM projects JOIN essays ON projects.projectid = essays.projectid WHERE essays.title = 'Smile for the Camera!!!';
SELECT SUM(donation_total) AS total_amount, (SELECT title FROM essays WHERE projectid = (     SELECT projectid FROM donations      WHERE donation_total = (SELECT MAX(donation_total) FROM donations) )) AS essay_title FROM donations;
SELECT MAX(d.donation_total) AS max_donation_total,        d.donor_acctid,        r.project_resource_type FROM donations d JOIN projects p ON d.projectid = p.projectid JOIN resources r ON p.projectid = r.projectid GROUP BY d.donor_acctid ORDER BY max_donation_total DESC LIMIT 10;
SELECT MIN(date_posted) AS first_project_date, GROUP_CONCAT(item_name) AS requested_resources FROM projects JOIN resources ON projects.projectid = resources.projectid WHERE date_posted = (SELECT MIN(date_posted) FROM projects);
SELECT vendor_name FROM resources JOIN projects ON resources.projectid = projects.projectid WHERE projects.title = 'iMath';
SELECT MAX(item_quantity) AS max_quantity, grade_level, date_posted FROM projects JOIN resources ON projects.projectid = resources.projectid GROUP BY grade_level ORDER BY max_quantity DESC LIMIT 1;
SELECT AVG(donation_total) FROM donations WHERE projectid IN (     SELECT projectid     FROM projects     WHERE title = 'Recording Rockin\' Readers' );
SELECT MAX(essays.title) AS essay_title, donations.donor_acctid AS biggest_donor, ROUND((SUM(donations.donation_to_project) / MAX(projects.total_price_excluding_optional_support)) * 100, 2) AS donation_percent FROM donations JOIN projects ON donations.projectid = projects.projectid JOIN essays ON projects.projectid = essays.projectid GROUP BY essays.title ORDER BY donation_percent DESC LIMIT 1;
SELECT MAX(donor_state) AS state,     donor_acctid,     AVG(donation_optional_support) AS avg_optional_support,     project_resource_type FROM     donations JOIN     projects ON donations.projectid = projects.projectid JOIN     resources ON donations.projectid = resources.projectid GROUP BY     donor_acctid ORDER BY     avg_optional_support DESC LIMIT     5;
SELECT projects.projectid, T1.item_name FROM (     SELECT    projects.projectid,     resources.item_name,     COUNT(resources.item_name) AS item_count     FROM     projects     INNER JOIN resources ON projects.projectid = resources.projectid     WHERE     projects.school_city = 'Brooklyn'     GROUP BY     projects.projectid,     resources.item_name ) AS T1 JOIN projects ON T1.projectid = projects.projectid WHERE T1.item_count = (     SELECT    MAX(item_count)     FROM     (         SELECT        projects.projectid,         resources.item_name,         COUNT(resources.item_name) AS item_count         FROM         projects         INNER JOIN resources ON projects.projectid = resources.projectid         WHERE         projects.school_city = 'Brooklyn'         GROUP BY         projects.projectid,         resources.item_name     ) AS T2 )
SELECT COUNT(DISTINCT projects.schoolid) FROM projects JOIN resources ON projects.projectid = resources.projectid WHERE projects.school_metro = 'urban' AND resources.project_resource_type = 'Books';
SELECT MAX(schoolid) FROM     projects WHERE     schoolid IN (         SELECT            schoolid         FROM             resources         WHERE             vendor_name = 'Amazon'         GROUP BY             schoolid         ORDER BY             COUNT(*) DESC         LIMIT 1     );
SELECT COUNT(DISTINCT donations.donor_acctid) FROM     donations JOIN projects ON donations.projectid = projects.projectid WHERE     donations.donor_city = 'Los Angeles'     AND projects.school_city != 'Los Angeles';
SELECT teacher_prefix FROM projects WHERE title = 'Reading About Other Cultures';
SELECT SUM(students_reached) AS total_students_impacted FROM projects WHERE title = 'Fit Firsties!';
SELECT projects.title, donations.donor_acctid FROM projects JOIN donations ON projects.projectid = donations.projectid WHERE projects.school_city = 'Chicago';
SELECT title FROM     projects WHERE     teacher_prefix = 'Dr.'     AND students_reached > 300; 
SELECT vendor_name FROM resources WHERE projectid IN (     SELECT    projectid     FROM     projects     WHERE     primary_focus_subject = 'Literacy' ) AND project_resource_type = 'Books';
SELECT projects.title FROM projects JOIN resources ON projects.projectid = resources.projectid ORDER BY (resources.item_unit_price * resources.item_quantity) DESC LIMIT 1;
SELECT COUNT(*) FROM donations WHERE donor_city = 'New York' AND is_teacher_acct = 't';
SELECT COUNT(DISTINCT donor_acctid) FROM donations WHERE donor_state = 'NJ' AND for_honoree = 't';
SELECT donation_message  FROM donations  WHERE donationid = 'a84dace1ff716f6f0c7af8ef9090a5d5';
SELECT project_resource_type FROM resources WHERE vendor_name = 'Lakeshore Learning Materials';
SELECT item_name FROM     resources WHERE     vendor_name = 'Lakeshore Learning Materials' GROUP BY     item_name ORDER BY     SUM(item_quantity) DESC LIMIT 1;
SELECT COUNT(DISTINCT projects.projectid) FROM projects JOIN donations ON projects.projectid = donations.projectid WHERE projects.teacher_state = 'NY' AND donations.donor_city = 'New York' AND projects.teacher_ny_teaching_fellow = 't';
SELECT COUNT(projects.projectid) FROM projects JOIN resources ON projects.projectid = resources.projectid WHERE resources.vendor_name = 'Lakeshore Learning Materials' AND projects.teacher_prefix = 'Dr.';
SELECT vendor_name FROM resources JOIN projects ON resources.projectid = projects.projectid WHERE projects.schoolid IN (     SELECT        schoolid     FROM         projects     WHERE         poverty_level = 'highest poverty' ) GROUP BY vendor_name ORDER BY COUNT(*) DESC LIMIT 1;
SELECT projects.schoolid FROM projects JOIN resources ON projects.projectid = resources.projectid WHERE resources.vendor_name = 'Lakeshore Learning Materials' ORDER BY projects.fulfillment_labor_materials DESC LIMIT 1;
SELECT vendor_name FROM resources JOIN projects ON resources.projectid = projects.projectid WHERE total_price_including_optional_support - total_price_excluding_optional_support = (     SELECT MAX(total_price_including_optional_support - total_price_excluding_optional_support)     FROM projects );
SELECT SUM(donation_total) AS total_donated_amount FROM donations JOIN projects ON donations.projectid = projects.projectid WHERE projects.school_city = 'Brooklyn'
SELECT donations.donation_message FROM donations JOIN projects ON donations.projectid = projects.projectid WHERE projects.school_city = 'Brooklyn' AND projects.school_magnet = 't';
SELECT COUNT(DISTINCT donations.donationid) FROM donations JOIN projects ON donations.projectid = projects.projectid WHERE payment_included_acct_credit = 't'  AND school_year_round = 't'  AND teacher_prefix = 'Teacher';
SELECT SUM(donation_total) AS total_donation_amount FROM donations JOIN projects ON donations.projectid = projects.projectid WHERE primary_focus_area = 'Literacy & Language';
SELECT MAX(donor_acctid) FROM donations WHERE projectid IN (     SELECT projectid FROM projects     WHERE primary_focus_area = 'Literacy & Language' )
SELECT MAX(item_quantity) AS max_quantity, item_name FROM resources JOIN projects ON resources.projectid = projects.projectid WHERE primary_focus_area = 'Literacy & Language' AND project_resource_type = 'Supplies' GROUP BY item_name ORDER BY max_quantity DESC LIMIT 1;
SELECT MAX(item_unit_price) AS highest_unit_price FROM     resources WHERE     projectid IN (         SELECT            projectid         FROM             projects         WHERE             primary_focus_area = 'Literacy & Language'     );
SELECT AVG(donation_total) FROM donations JOIN projects ON donations.projectid = projects.projectid WHERE projects.school_city = 'Brooklyn'
SELECT donor_city FROM donations WHERE donor_acctid = '22cbc920c9b5fa08dfb331422f5926b5';
SELECT CASE      WHEN is_teacher_acct = 1 THEN 'Yes'     ELSE 'No' END AS is_teacher FROM donations WHERE donor_acctid = '22cbc920c9b5fa08dfb331422f5926b5';
SELECT teacher_prefix FROM projects WHERE teacher_acctid = '42d43fa6f37314365d08692e08680973';
SELECT CASE     WHEN teacher_state = 'NY' THEN 'Yes'     ELSE 'No' END AS is_new_york_teacher FROM projects WHERE teacher_acctid = '42d43fa6f37314365d08692e08680973';
SELECT projects.title FROM projects JOIN donations ON projects.projectid = donations.projectid WHERE projects.school_city = 'Abington';
SELECT resources.item_name FROM resources JOIN projects ON resources.projectid = projects.projectid WHERE projects.teacher_acctid = '822b7b8768c17456fdce78b65abcc18e'; 
SELECT COUNT(DISTINCT projects.schoolid) FROM     projects JOIN     donations ON donations.projectid = projects.projectid WHERE     projects.school_magnet = 't'     AND donations.payment_included_acct_credit = 'f';
SELECT resources.project_resource_type FROM donations JOIN resources ON donations.projectid = resources.projectid WHERE donations.donationid = 'b39547f29dfc25fb13c6e9e8d940dc43'; 
SELECT 100 * (     SELECT COUNT(DISTINCT projects.schoolid)     FROM projects     WHERE projects.school_magnet = 't' ) / (     SELECT COUNT(DISTINCT projects.schoolid)     FROM projects     WHERE EXISTS (         SELECT 1         FROM resources         WHERE resources.projectid = projects.projectid         AND resources.project_resource_type = 'Books'     ) )
SELECT COUNT(DISTINCT projects.schoolid) FROM projects JOIN resources ON projects.projectid = resources.projectid WHERE resources.vendor_name = 'ABC School Supply' AND projects.school_magnet = 't';
SELECT COUNT(DISTINCT projects.schoolid) FROM projects JOIN donations ON projects.projectid = donations.projectid WHERE donations.donor_acctid = '000eebf28658900e63b538cf8a73afbd' AND projects.poverty_level = 'highest poverty';
SELECT essays.short_description FROM projects JOIN donations ON projects.projectid = donations.projectid JOIN essays ON projects.projectid = essays.projectid WHERE projects.schoolid = '301c9bf0a45d159d162b65a93fddd74e';
SELECT projects.school_city FROM projects JOIN donations ON projects.projectid = donations.projectid WHERE projects.title = "iMath";
SELECT donations.donationid, donations.projectid, donations.donor_acctid, donations.donor_city, donations.donor_state, donations.donor_zip, donations.is_teacher_acct, donations.donation_timestamp, donations.donation_to_project, donations.donation_optional_support, donations.donation_total, donations.dollar_amount, donations.donation_included_optional_support, donations.payment_method, donations.payment_included_acct_credit, donations.payment_included_campaign_gift_card, donations.payment_included_web_purchased_gift_card, donations.payment_was_promo_matched, donations.via_giving_page, donations.for_honoree, donations.donation_message FROM donations INNER JOIN projects ON donations.projectid = projects.projectid WHERE projects.teacher_acctid = '822b7b8768c17456fdce78b65abcc18e';
SELECT SUM(donation_total) FROM donations JOIN projects ON donations.projectid = projects.projectid WHERE projects.teacher_acctid = '822b7b8768c17456fdce78b65abcc18e';
SELECT CASE      WHEN EXISTS (         SELECT 1          FROM donations          JOIN projects ON donations.projectid = projects.projectid          WHERE projects.schoolid = 'd4af834b1d3fc8061e1ee1b3f1a77b85'          AND donations.is_teacher_acct = 't'     ) THEN 'Yes'     ELSE 'No' END AS Is_teacher_donor;
SELECT 100 * COUNT(CASE WHEN school_city = 'Brooklyn' THEN 1 END) / COUNT(*) FROM projects WHERE teacher_acctid IN (SELECT donor_acctid FROM donations WHERE is_teacher_acct = 't');
SELECT 100.0 * SUM(CASE WHEN p.students_reached > 30 THEN 1 ELSE 0 END) / COUNT(*) AS percentage_of_projects_affecting_more_than_30_students FROM projects p INNER JOIN donations d ON p.projectid = d.projectid WHERE d.is_teacher_acct = 't';
SELECT COUNT(DISTINCT projects.schoolid) FROM projects WHERE projects.school_city = 'Bethlehem' AND projects.school_metro = 'suburban';
SELECT COUNT(DISTINCT projects.schoolid) AS num_year_round_schools FROM     projects WHERE     projects.school_city = 'Los Angeles'     AND projects.school_year_round = 't';
SELECT COUNT(*)  FROM projects  WHERE school_magnet = 't' AND school_city = 'New York' AND school_state = 'NY' AND school_county = 'Manhattan';
SELECT COUNT(DISTINCT projects.teacher_acctid) AS num_teachers FROM projects WHERE projects.school_city = 'Twin Falls' AND projects.primary_focus_area = 'Math & Science';
SELECT COUNT(DISTINCT projects.teacher_acctid) FROM projects WHERE primary_focus_subject = 'Literature & Writing' AND teacher_prefix = 'Mr';
SELECT COUNT(DISTINCT projects.projectid) FROM projects JOIN essays ON projects.projectid = essays.projectid WHERE essays.grade_level = 'Grades 3-5' AND projects.school_district = 'Boston Public School District';
SELECT projects.school_city FROM projects INNER JOIN essays ON projects.projectid = essays.projectid WHERE essays.title = 'ABC Read';
SELECT teacher_prefix FROM projects WHERE title = 'Creating Memories and Inspiring Dreams';
SELECT Donations.is_teacher_acct FROM donations JOIN projects ON donations.projectid = projects.projectid WHERE projects.title = 'Calculate, Financial Security For Tomorrow Starts Today!' LIMIT 1;
SELECT title FROM projects JOIN donations ON projects.projectid = donations.projectid WHERE donation_message = "Donation on behalf of Matt Carpenter because I'm a strong believer in education"; 
SELECT COUNT(donations.donationid) FROM donations JOIN projects ON donations.projectid = projects.projectid WHERE projects.title = 'A Rug For Reaching Readers';
SELECT SUM(donation_total) FROM donations JOIN projects ON donations.projectid = projects.projectid WHERE projects.title = 'Engaging Young Readers with a Leveled Classroom Library'
SELECT donation_optional_support FROM projects JOIN donations ON projects.projectid = donations.projectid WHERE title = 'Armenian Genocide'; 
SELECT short_description FROM projects JOIN donations ON projects.projectid = donations.projectid WHERE donation_timestamp = '2012/9/6 14:44:29';
SELECT COUNT(d.donationid) AS tip_received FROM projects p JOIN donations d ON p.projectid = d.projectid WHERE p.title = 'I Can\'t See It...Can You Help Me???' AND d.donation_included_optional_support = 't'
SELECT projects.teacher_acctid FROM donations JOIN projects ON donations.projectid = projects.projectid WHERE donations.donation_timestamp = '2008/7/29 11:38:43';
SELECT projects.schoolid FROM projects JOIN essays ON projects.projectid = essays.projectid WHERE essays.title = 'Virtual Aquarium Needs Help!';
SELECT MAX(donation_total) FROM donations;
SELECT ROUND((donation_optional_support / donation_total) * 100, 2) AS percentage_tip FROM donations WHERE projectid = (     SELECT projectid     FROM projects     WHERE title = 'Awesome Audiobooks Make Avid Readers' );
SELECT ROUND((COUNT(CASE WHEN donations.payment_method = 'creditcard' THEN 1 ELSE NULL END) * 100.0) / COUNT(donations.projectid), 2) AS percentage_credit_card_payment FROM donations JOIN projects ON donations.projectid = projects.projectid WHERE projects.title = 'Bringing Drama to Life';
SELECT short_description  FROM essays  WHERE title = 'Future Einsteins Of America'; 
SELECT need_statement FROM     essays JOIN     projects ON essays.projectid = projects.projectid WHERE     title = 'Family History Project';
SELECT COUNT(DISTINCT projects.school_metro)  FROM projects  WHERE projects.school_district = 'Livingston Parish School District'  AND projects.school_metro = 'suburban';
SELECT vendor_name FROM resources WHERE item_name = 'Classroom Keepers Management Center';
SELECT DISTINCT project_resource_type FROM resources WHERE vendor_name = 'Sax Arts & Crafts'; 
SELECT projects.school_county FROM projects WHERE projects.school_state = 'NY' AND projects.poverty_level = 'low poverty' GROUP BY projects.school_county ORDER BY COUNT(*) DESC LIMIT 1;
SELECT school_district FROM projects WHERE title = 'Future Einsteins Of America';
SELECT payment_method FROM donations JOIN projects ON donations.projectid = projects.projectid WHERE projects.title = 'Needed Resource Materials For My Students';
SELECT COUNT(donationid) FROM donations JOIN projects ON donations.projectid = projects.projectid WHERE projects.school_district = 'Memphis City School District' AND donations.payment_method = 'creditcard';
SELECT school_district FROM projects JOIN resources ON projects.projectid = resources.projectid WHERE resources.vendor_name = 'Barnes and Noble';
SELECT projects.school_latitude, projects.school_longitude FROM projects JOIN resources ON projects.projectid = resources.projectid WHERE resources.vendor_name = 'Benchmark Education' AND resources.item_name = 'R & A Plant Genetics';
SELECT payment_method FROM donations JOIN projects ON donations.projectid = projects.projectid WHERE projects.school_state = 'GA' GROUP BY payment_method ORDER BY COUNT(*) DESC LIMIT 1;
SELECT projects.school_latitude, projects.school_longitude, resources.resource_type FROM projects JOIN donations ON projects.projectid = donations.projectid JOIN resources ON projects.projectid = resources.projectid WHERE projects.title = 'Look, Look, We Need a Nook!';
SELECT donations.donation_message FROM donations JOIN projects ON donations.projectid = projects.projectid WHERE projects.school_latitude = 40.735332 AND projects.school_longitude = -74.196014 AND projects.school_district = 'Newark School District';
SELECT MAX(date_posted) FROM projects WHERE title = 'Lets Share Ideas essay';
SELECT donation_message FROM donations JOIN projects ON donations.projectid = projects.projectid WHERE projects.title = 'Lets Share Ideas' AND donations.payment_method = 'credit_card';
SELECT COUNT(project_resource_type) AS count, project_resource_type FROM resources JOIN projects ON resources.projectid = projects.projectid WHERE school_district = 'Los Angeles Unif Sch Dist' GROUP BY project_resource_type ORDER BY count DESC LIMIT 1;
SELECT projects.school_city FROM projects JOIN resources ON projects.projectid = resources.projectid WHERE projects.school_district = 'Los Angeles Unified School District' AND resources.vendor_name = 'Quill.com';
SELECT SUM(item_unit_price * item_quantity) AS total_price, school_latitude, school_longitude, school_district FROM projects JOIN resources ON projects.projectid = resources.projectid WHERE vendor_name = 'ABC School Supply' AND project_resource_type = 'Other' GROUP BY school_latitude, school_longitude, school_district; 
SELECT SUM(donation_total) AS total_donation, school_city, poverty_level FROM donations JOIN projects ON donations.projectid = projects.projectid JOIN essays ON projects.projectid = essays.projectid WHERE essays.title = 'Lets Share Ideas' AND donations.payment_method = 'paypal' GROUP BY school_city, poverty_level;
SELECT COUNT(DISTINCT donor_acctid)  FROM donations  WHERE donor_city = 'Pocatello' AND is_teacher_acct = 'f';
SELECT COUNT(DISTINCT projects.schoolid)  FROM projects  JOIN essays ON projects.projectid = essays.projectid  WHERE projects.school_county = 'Suffolk' AND essays.teacher_prefix = 'Dr.';
SELECT SUM(donation_to_project + donation_optional_support) FROM donations WHERE payment_method = 'Amazon';
SELECT COUNT(*) FROM donations WHERE dollar_amount > 100 AND for_honoree = 't';
SELECT COUNT(*), vendorid FROM resources WHERE item_unit_price <= 15 AND project_resource_type != 'technology' GROUP BY vendorid;
SELECT COUNT(DISTINCT projects.projectid) FROM projects JOIN resources ON projects.projectid = resources.projectid WHERE resources.item_quantity BETWEEN 5 AND 10 AND resources.vendor_name = 'Quill.com';
SELECT projects.projectid, projects.schoolid, projects.school_district, projects.teacher_ny_teaching_fellow FROM projects WHERE projects.school_district = 'Union Pub School District I-9' AND projects.teacher_ny_teaching_fellow = 't';
SELECT projects.school_city FROM projects WHERE projects.school_county = 'Los Angeles' AND projects.school_metro = 'suburban';
SELECT projects.projectid, resources.vendor_name FROM projects JOIN resources ON projects.projectid = resources.projectid WHERE resources.project_resource_type = 'Books';
SELECT 100.0 * SUM(CASE WHEN d.payment_method = 'no_cash_received' THEN 1 ELSE 0 END) / COUNT(*) AS percentage FROM projects p LEFT JOIN donations d ON p.projectid = d.projectid WHERE d.payment_included_campaign_gift_card = 't';
SELECT COUNT(*) * 100.0 / (     SELECT COUNT(*)     FROM projects     WHERE school_city = 'Santa Barbara' ) AS percentage_suburban_metro FROM projects WHERE school_city = 'Santa Barbara' AND school_metro = 'suburban';
SELECT SUM(CASE WHEN substr(donation_timestamp, 1, 7) = '2013-03' THEN 1 ELSE 0 END) * 100.0 / COUNT(*) as percentage_of_payment_methods_in_march_2013 FROM donations;
SELECT AVG(item_unit_price) AS average_unit_price FROM resources WHERE vendor_name = 'AKJ Books';
SELECT COUNT(DISTINCT projects.schoolid) FROM projects JOIN donations ON projects.projectid = donations.projectid JOIN resources ON projects.projectid = resources.projectid WHERE projects.school_city = 'Brooklyn' AND projects.school_metro = 'urban' AND donations.for_honoree = 't' AND resources.item_name = 'TT992 - Refill Pack for Safety Name Tags';
SELECT COUNT(DISTINCT projects.schoolid) AS num_schools_highest_poverty_with_corporate_gift_card_donation FROM projects JOIN donations ON projects.projectid = donations.projectid WHERE projects.poverty_level = 'highest' AND donations.payment_included_campaign_gift_card = 't';
SELECT COUNT(school_city) AS num_schools, school_city FROM projects JOIN donations ON projects.projectid = donations.projectid WHERE dollar_amount = 'under_10' GROUP BY school_city ORDER BY num_schools DESC;
SELECT title FROM projects WHERE school_latitude = 42003718 AND school_longitude = -87668289;
SELECT CASE     WHEN teacher_ny_teaching_fellow = 't' THEN 'Yes'     ELSE 'No' END AS has_new_york_teaching_fellow FROM projects WHERE title = 'Team More Books!'; 
SELECT vendor_name FROM resources JOIN projects ON resources.projectid = projects.projectid WHERE projects.primary_focus_area = 'Literature';
SELECT vendor_name FROM resources JOIN projects ON resources.projectid = projects.projectid WHERE grade_level = 'Grades 9-12'
SELECT COUNT(DISTINCT donations.donor_acctid) FROM donations JOIN projects ON donations.projectid = projects.projectid WHERE projects.school_city = 'Chicago' AND donations.is_teacher_acct = 't';
SELECT COUNT(DISTINCT projects.projectid) FROM     projects JOIN     donations ON donations.projectid = projects.projectid WHERE     projects.school_city = 'Rock Hill'     AND donations.is_teacher_acct = 't';
SELECT SUM(d.donation_total) FROM donations d JOIN projects p ON d.projectid = p.projectid WHERE d.donation_included_optional_support = 't' AND p.students_reached > 300;
SELECT COUNT(resources.item_number) AS total_items_requested FROM projects JOIN resources ON projects.projectid = resources.projectid WHERE projects.school_district = 'Onslow Co School District' AND projects.school_metro = 'urban';
SELECT AVG((donation_optional_support + donation_to_project) / donation_total) FROM donations JOIN projects ON donations.projectid = projects.projectid WHERE school_county = 'Fresno';
SELECT COUNT(DISTINCT CASE WHEN title = 'ABC Read' THEN school_county END) * 100.0 / COUNT(DISTINCT school_county) FROM projects
SELECT AVG(item_quantity) AS average_resources_per_honoree
SELECT MIN(date_posted) AS project_go_live FROM projects WHERE title = 'Photojournalists Want to Exhibit Their Best Works';
SELECT resources.item_name FROM resources JOIN projects ON resources.projectid = projects.projectid WHERE projects.primary_focus_subject = 'Mathematics' ORDER BY resources.item_unit_price DESC LIMIT 1;
SELECT projects.school_latitude, projects.school_longitude FROM projects JOIN resources ON projects.projectid = resources.projectid WHERE resources.item_name = 'Viewscreen LCD from Texas Instruments, TI-84 Plus';
SELECT COUNT(donations.donationid) FROM donations JOIN projects ON donations.projectid = projects.projectid WHERE projects.title = 'Look, Look, We Need a Nook!';
SELECT poverty_level FROM projects JOIN donations ON projects.projectid = donations.projectid WHERE donor_zip = '7079';
SELECT vendor_name FROM resources WHERE projectid = (SELECT projectid FROM projects WHERE title = 'Bloody Times');
SELECT resources.item_name, projects.school_zip FROM resources JOIN projects ON resources.projectid = projects.projectid WHERE resources.vendor_name = 'Sax Arts & Crafts';
SELECT projects.school_longitude, projects.school_latitude FROM projects WHERE projects.title = 'Wiping Away Bad Grades';
SELECT primary_focus_subject FROM donations JOIN projects ON donations.projectid = projects.projectid WHERE payment_included_campaign_gift_card = 't';
SELECT projects.title, projects.short_description, resources.item_name, MAX(resources.item_unit_price) AS max_item_price FROM projects JOIN resources ON projects.projectid = resources.projectid WHERE resources.project_resource_type = 'Books' GROUP BY projects.title, projects.short_description ORDER BY max_item_price DESC LIMIT 1;
SELECT grade_level FROM projects WHERE title = 'Too Close for Comfort';
SELECT SUM(projects.students_reached) FROM projects JOIN donations ON projects.projectid = donations.projectid WHERE donations.donor_zip = '22205';
SELECT ROUND((COUNT(CASE WHEN d.via_giving_page = 't' THEN d.donationid ELSE NULL END) * 1.0 / COUNT(d.donationid)) * 100, 2) AS percentage_via_page, p.primary_focus_area FROM donations d JOIN projects p ON d.projectid = p.projectid GROUP BY p.primary_focus_area;
SELECT ROUND(     (         SUM(CASE WHEN project_resource_type = 'Technology' AND vendor_name = 'Best Buy for Business' THEN 1 ELSE 0 END)         /         COUNT(projectid)     ) * 100,      2 ) AS percentage, date_posted FROM projects JOIN resources ON projects.projectid = resources.projectid WHERE project_resource_type = 'Technology' GROUP BY date_posted; 
SELECT (SELECT SUM(num_sales) FROM region_sales WHERE game_platform_id = 50 AND region_id = 1) - (SELECT SUM(num_sales) FROM region_sales WHERE game_platform_id = 51 AND region_id = 1); 
SELECT game.game_name FROM game JOIN genre ON game.genre_id = genre.id WHERE genre.genre_name = (     SELECT genre.genre_name     FROM game     JOIN genre ON game.genre_id = genre.id     WHERE game.game_name = '3D Lemmings' );
SELECT COUNT(*) FROM     game JOIN     genre ON game.genre_id = genre.id WHERE     genre.genre_name = 'Action';
SELECT genre.genre_name FROM     genre INNER JOIN     game ON genre.id = game.genre_id WHERE     game.game_name = '3D Lemmings';
SELECT publisher.publisher_name FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id WHERE game.game_name = '3D Lemmings';
SELECT game.game_name FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id WHERE publisher.publisher_name = '10TACLE Studios';
SELECT COUNT(*) FROM     game JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id JOIN genre ON game.genre_id = genre.id WHERE     publisher.publisher_name = '10TACLE Studios'     AND genre.genre_name = 'Puzzle';
SELECT game.game_name FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id JOIN genre ON game.genre_id = genre.id WHERE publisher.publisher_name = '10TACLE Studios' AND genre.genre_name = 'Puzzle';
SELECT publisher.publisher_name FROM publisher JOIN game_publisher ON publisher.id = game_publisher.publisher_id GROUP BY publisher.publisher_name ORDER BY COUNT(game_publisher.game_id) DESC LIMIT 1;
SELECT platform.platform_name FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id JOIN game_platform ON game.id = game_platform.game_publisher_id JOIN platform ON game_platform.platform_id = platform.id WHERE game.game_name = 'Panzer Tactics' AND game_platform.release_year = 2007;
SELECT release_year FROM game_platform JOIN game_publisher ON game_platform.game_publisher_id = game_publisher.id JOIN game ON game_publisher.game_id = game.id JOIN platform ON game_platform.platform_id = platform.id WHERE game.game_name = 'Panzer Tactics' AND platform.platform_name = 'DS';
SELECT publisher.publisher_name FROM game JOIN genre ON game.genre_id = genre.id JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id WHERE genre.genre_name = 'Puzzle'; 
SELECT publisher.publisher_name FROM publisher JOIN game_publisher ON publisher.id = game_publisher.publisher_id JOIN game ON game_publisher.game_id = game.id JOIN genre ON game.genre_id = genre.id WHERE genre.genre_name = 'Puzzle' GROUP BY publisher.publisher_name ORDER BY COUNT(game.id) DESC LIMIT 1; 
SELECT COUNT(DISTINCT game_publisher.publisher_id) FROM     game_publisher INNER JOIN     game ON game.id = game_publisher.game_id INNER JOIN     genre ON game.genre_id = genre.id WHERE     genre.genre_name = 'Puzzle' GROUP BY     game_publisher.publisher_id HAVING     COUNT(game.id) > 3;
SELECT ROUND(     (SELECT COUNT(DISTINCT gp.game_id)     FROM game_publisher gp     JOIN publisher p ON gp.publisher_id = p.id     WHERE p.publisher_name = 'Nintendo'     AND gp.game_id IN (         SELECT game_id         FROM game         WHERE genre_id = (             SELECT id             FROM genre             WHERE genre_name = 'Sports'         )     )) * 100.0 /     (SELECT COUNT(DISTINCT gp.game_id)     FROM game_publisher gp     JOIN publisher p ON gp.publisher_id = p.id     WHERE p.publisher_name = 'Nintendo') , 2) AS percentage; 
SELECT AVG(num_sales * 100000 / 4) AS average_games_sold_on_DS FROM game_platform JOIN platform ON game_platform.platform_id = platform.id JOIN region_sales ON game_platform.id = region_sales.game_platform_id JOIN region ON region_sales.region_id = region.id WHERE platform.platform_name = 'DS';
SELECT COUNT(game.id) AS num_games FROM game_publisher WHERE game_publisher.publisher_id = 352; 
SELECT genre.id FROM game JOIN genre ON game.genre_id = genre.id WHERE game.game_name = 'Pro Evolution Soccer 2012';
SELECT region.id FROM region WHERE region_name = 'Japan';
SELECT MAX(gp.id) FROM     game_platform gp JOIN     region_sales rs ON gp.id = rs.game_platform_id WHERE     rs.region_id = '2' GROUP BY     rs.region_id;
SELECT genre_id FROM (     SELECT genre_id, COUNT(game.id) AS num_games     FROM genre     JOIN game ON genre.id = game.genre_id     GROUP BY genre_id     ORDER BY num_games DESC     LIMIT 1 );
SELECT game.id FROM game WHERE game.game_name = 'Resident Evil Archives: Resident Evil';
SELECT COUNT(game.id) FROM     game JOIN     game_platform ON game.id = game_platform.game_id JOIN     platform ON game_platform.platform_id = platform.id WHERE     platform.platform_name = 'X360'     AND game_platform.release_year = '2010';
SELECT publisher.publisher_name FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id WHERE game.game_name = 'ModNation Racers';
SELECT game_platform_id FROM region_sales JOIN region ON region_sales.region_id = region.id WHERE region.region_name = 'Japan' GROUP BY game_platform_id ORDER BY SUM(num_sales) DESC LIMIT 1;
SELECT COUNT(DISTINCT platform.id) FROM     game JOIN game_publisher ON game.id = game_publisher.game_id JOIN game_platform ON game_publisher.id = game_platform.game_publisher_id JOIN platform ON game_platform.platform_id = platform.id WHERE     game.game_name = 'Pro Evolution Soccer 2016';
SELECT COUNT(*) FROM     game JOIN     genre ON game.genre_id = genre.id WHERE     genre.genre_name = 'Sports';
SELECT publisher.publisher_name FROM game_publisher JOIN publisher ON game_publisher.publisher_id = publisher.id WHERE game_publisher.game_id = '10031';
SELECT publisher.publisher_name FROM     publisher JOIN     game_publisher ON publisher.id = game_publisher.publisher_id GROUP BY     publisher.publisher_name ORDER BY     COUNT(game_publisher.game_id) DESC LIMIT 1;
SELECT SUM(CASE WHEN g.genre_name = 'Sports' THEN 1 ELSE 0 END) - SUM(CASE WHEN g.genre_name = 'Simulation' THEN 1 ELSE 0 END) AS difference FROM game g JOIN genre gn ON g.genre_id = gn.id;
SELECT genre.genre_name FROM game INNER JOIN genre ON game.genre_id = genre.id WHERE game.game_name = 'Resident Evil: Revelations';
SELECT SUM(num_sales * 100000) AS total_sales FROM     region_sales JOIN     region ON region.id = region_sales.region_id JOIN     game_platform ON game_platform.id = region_sales.game_platform_id WHERE     game_platform.platform_id = 3871     AND region.region_name = 'Europe';
SELECT COUNT(game.id) FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id WHERE publisher.publisher_name = 'Ascaron Entertainment GmbH';
SELECT MIN(platform.platform_name) FROM     platform JOIN     game_platform ON platform.id = game_platform.platform_id WHERE     game_platform.release_year = (SELECT MIN(release_year) FROM game_platform);
SELECT (SELECT    COUNT(game.id) * 100.0 / (         SELECT COUNT(game.id)         FROM game         INNER JOIN game_publisher ON game.id = game_publisher.game_id         INNER JOIN publisher ON game_publisher.publisher_id = publisher.id         WHERE publisher.publisher_name = 'Namco Bandai Games'     ) AS percentage FROM game INNER JOIN game_publisher ON game.id = game_publisher.game_id INNER JOIN publisher ON game_publisher.publisher_id = publisher.id INNER JOIN genre ON game.genre_id = genre.id WHERE publisher.publisher_name = 'Namco Bandai Games' AND genre.genre_name = 'Adventure'); 
SELECT SUM(CASE WHEN publisher_name = 'Atari' THEN 1 ELSE 0 END) / SUM(CASE WHEN publisher_name = 'Athena' THEN 1 ELSE 0 END) FROM game_publisher JOIN publisher ON game_publisher.publisher_id = publisher.id WHERE publisher_name IN ('Atari', 'Athena')
SELECT COUNT(game.id) FROM     game JOIN     game_publisher ON game.id = game_publisher.game_id JOIN     publisher ON game_publisher.publisher_id = publisher.id WHERE     publisher.publisher_name = 'Electronic Arts';
SELECT genre.genre_name FROM game INNER JOIN genre ON game.genre_id = genre.id WHERE game.game_name = 'Advent Rising';
SELECT COUNT(*) FROM     game JOIN     game_publisher ON game.id = game_publisher.game_id JOIN     publisher ON game_publisher.publisher_id = publisher.id JOIN     genre ON game.genre_id = genre.id WHERE     publisher.publisher_name = 'Microsoft Game Studios'     AND genre.genre_name = 'Role-Playing';
SELECT publisher.publisher_name FROM publisher JOIN game_publisher ON publisher.id = game_publisher.publisher_id GROUP BY game_publisher.publisher_id ORDER BY COUNT(game_publisher.publisher_id) DESC LIMIT 1; 
SELECT platform.platform_name FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id JOIN game_platform ON game_publisher.id = game_platform.game_publisher_id JOIN platform ON game_platform.platform_id = platform.id WHERE publisher.publisher_name = 'Codemasters' AND game_platform.release_year = 2004;
SELECT COUNT(game.id) FROM     game JOIN     game_platform ON game.id = game_platform.game_id JOIN     platform ON game_platform.platform_id = platform.id WHERE     platform.platform_name = 'PS4'     AND game_platform.release_year = 2014;
SELECT publisher.publisher_name FROM publisher JOIN game_publisher ON publisher.id = game_publisher.publisher_id JOIN game ON game_publisher.game_id = game.id JOIN game_platform ON game.id = game_platform.game_publisher_id WHERE game_platform.release_year = (SELECT MIN(release_year) FROM game_platform)
SELECT COUNT(DISTINCT game_publisher.publisher_id) FROM     region     JOIN region_sales ON region.id = region_sales.region_id     JOIN game_platform ON region_sales.game_platform_id = game_platform.id     JOIN platform ON game_platform.platform_id = platform.id     JOIN game_publisher ON game_platform.game_publisher_id = game_publisher.id WHERE     region.region_name = 'Japan'     AND platform.platform_name = 'X360'     AND game_platform.release_year = 2011;
SELECT MAX(num_sales), platform.platform_name FROM region_sales JOIN game_platform ON region_sales.game_platform_id = game_platform.id JOIN platform ON game_platform.platform_id = platform.id JOIN region ON region_sales.region_id = region.id WHERE region.region_name = 'Europe';
SELECT release_year FROM     game_platform JOIN     platform ON game_platform.platform_id = platform.id WHERE     platform.platform_name = 'PC' GROUP BY     release_year ORDER BY     COUNT(game_platform.id) DESC LIMIT 1; 
SELECT publisher.publisher_name FROM publisher JOIN game_publisher ON publisher.id = game_publisher.publisher_id GROUP BY publisher.publisher_name HAVING COUNT(game_publisher.publisher_id) = 1; 
SELECT game.game_name FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id WHERE publisher.publisher_name = '505 Games';
SELECT genre.id FROM game JOIN genre ON game.genre_id = genre.id WHERE game.game_name = '25 to Life';
SELECT game.id FROM game WHERE game.genre_id = 2;
SELECT game_platform.release_year FROM game_platform WHERE game_platform.game_publisher_id IN (     SELECT    game_publisher.id     FROM     game_publisher     WHERE     game_publisher.game_id BETWEEN 1 AND 10 ) LIMIT 10;
SELECT game_publisher.id FROM game_publisher JOIN game_platform ON game_publisher.id = game_platform.game_publisher_id WHERE game_platform.platform_id = 15;
SELECT game.id FROM game JOIN game_platform ON game.id = game_platform.game_id WHERE game_platform.release_year BETWEEN 2000 AND 2003;
SELECT SUM(num_sales * 100000) AS total_sales FROM     region_sales WHERE     region_id = 2     AND game_platform_id = 9615;
SELECT platform.platform_name FROM game_platform JOIN platform ON game_platform.platform_id = platform.id WHERE game_platform.release_year = 2016;
SELECT release_year FROM game_platform JOIN game_publisher ON game_platform.game_publisher_id = game_publisher.id JOIN game ON game_publisher.game_id = game.id WHERE game.game_name = '3DS Classic Collection';
SELECT AVG(num_sales) * 100000 AS average_sales_in_japan FROM region_sales JOIN region ON region.id = region_sales.region_id WHERE region.region_name = 'Japan'; 
SELECT genre.genre_name FROM game JOIN game_platform ON game.id = game_platform.game_id JOIN genre ON game.genre_id = genre.id WHERE game_platform.release_year BETWEEN 2000 AND 2002;
SELECT game.game_name FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id WHERE publisher.publisher_name = '3DO';
SELECT COUNT(*) FROM     game JOIN     genre ON game.genre_id = genre.id WHERE     genre.genre_name = 'Role-Playing';
SELECT region.region_name FROM region JOIN region_sales ON region_sales.region_id = region.id WHERE region_sales.num_sales > 300000;
SELECT publisher.publisher_name FROM publisher JOIN game_publisher ON publisher.id = game_publisher.publisher_id JOIN game ON game_publisher.game_id = game.id JOIN game_platform ON game.id = game_platform.game_publisher_id JOIN region_sales ON game_platform.id = region_sales.game_platform_id JOIN region ON region_sales.region_id = region.id WHERE region.region_name = 'North America' ORDER BY region_sales.num_sales DESC LIMIT 1; 
SELECT game_platform.release_year FROM     game_platform JOIN     region_sales ON game_platform.id = region_sales.game_platform_id JOIN     region ON region.id = region_sales.region_id WHERE     region.region_name = 'North America'     AND region_sales.num_sales = 3.5;
SELECT platform.platform_name FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id JOIN game_platform ON game_platform.game_publisher_id = game_publisher.id JOIN platform ON game_platform.platform_id = platform.id WHERE game.game_name = '15 Days';
SELECT publisher.publisher_name FROM game_publisher JOIN publisher ON game_publisher.publisher_id = publisher.id WHERE game_publisher.game_id = 75;
SELECT game.game_name FROM     game JOIN     game_publisher ON game.id = game_publisher.game_id JOIN     game_platform ON game_publisher.id = game_platform.game_publisher_id JOIN     region_sales ON game_platform.id = region_sales.game_platform_id JOIN     region ON region_sales.region_id = region.id WHERE     region.region_name = 'Japan' GROUP BY     game.game_name ORDER BY     SUM(region_sales.num_sales) DESC LIMIT 1;
SELECT publisher.publisher_name FROM region_sales JOIN region ON region_sales.region_id = region.id JOIN game_platform ON region_sales.game_platform_id = game_platform.id JOIN game_publisher ON game_platform.game_publisher_id = game_publisher.id JOIN publisher ON game_publisher.publisher_id = publisher.id WHERE region.region_name = 'Japan' AND region_sales.num_sales > 0.9 * (     SELECT AVG(region_sales.num_sales)     FROM region_sales     JOIN region ON region_sales.region_id = region.id     WHERE region.region_name = 'Japan' ); 
SELECT (CAST(SUM(CASE WHEN p.platform_name = 'PSP' THEN 1 ELSE 0 END) AS FLOAT) / COUNT(gm_plt.platform_id)) * 100 AS percentage_of_games_on_PSP FROM game_platform AS gm_plt JOIN platform AS p ON gm_plt.platform_id = p.id WHERE gm_plt.release_year = 2004;
SELECT COUNT(game.id) FROM game_platform WHERE release_year = 1981;
SELECT genre.id FROM game JOIN genre ON game.genre_id = genre.id WHERE game.game_name = '2Xtreme';
SELECT SUM(num_sales * 100000) AS total_sales, region_id FROM region_sales INNER JOIN game_platform ON region_sales.game_platform_id = game_platform.id WHERE game_platform.platform_id = 9658 GROUP BY region_id;
SELECT id FROM publisher WHERE publisher_name = '1C Company'; 
SELECT genre_name  FROM genre  WHERE id = 3; 
SELECT game.id FROM game_platform WHERE game_platform.release_year = 2017;
SELECT game_platform.release_year FROM     game JOIN     game_platform ON game.id = game_platform.game_id WHERE     game.game_name = 'Adventure Island';
SELECT COUNT(*) FROM     game JOIN     genre ON game.genre_id = genre.id WHERE     genre.genre_name = 'Puzzle';
SELECT game.game_name FROM game INNER JOIN game_platform ON game.id = game_platform.game_id INNER JOIN platform ON game_platform.platform_id = platform.id WHERE platform.platform_name = 'SCD';
SELECT COUNT(game.id) FROM     game_publisher JOIN     publisher ON game_publisher.publisher_id = publisher.id WHERE     publisher.publisher_name = 'Acclaim Entertainment';
SELECT publisher.publisher_name FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id WHERE game.game_name = 'Chronicles of the Sword';
SELECT SUM(num_sales * 100000) AS total_sales FROM region_sales JOIN region ON region_sales.region_id = region.id JOIN game_platform ON region_sales.game_platform_id = game_platform.id JOIN platform ON game_platform.platform_id = platform.id WHERE region.region_name = 'North America' AND platform.platform_name = 'PS4';
SELECT game_platform_id FROM region_sales JOIN region ON region_sales.region_id = region.id WHERE region.region_name = 'Europe' ORDER BY num_sales DESC LIMIT 1;
SELECT game.game_name FROM game_platform INNER JOIN game_publisher ON game_platform.game_publisher_id = game_publisher.id INNER JOIN game ON game_publisher.game_id = game.id WHERE game_platform.release_year = 2011;
SELECT COUNT(DISTINCT game.id) FROM     game JOIN     game_platform ON game.id = game_platform.game_id JOIN     platform ON game_platform.platform_id = platform.id WHERE     platform.platform_name = 'Wii';
SELECT game.game_name, game_platform.release_year FROM game JOIN game_genre ON game_genre.game_id = game.id JOIN genre ON genre.id = game_genre.genre_id JOIN game_platform ON game_platform.game_id = game.id WHERE genre.genre_name = 'Sports' LIMIT 5;
SELECT genre.genre_name FROM game JOIN genre ON game.genre_id = genre.id WHERE game.game_name = '2Xtreme';
SELECT platform.platform_name FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id JOIN game_platform ON game_publisher.id = game_platform.game_publisher_id JOIN platform ON game_platform.platform_id = platform.id WHERE game.game_name = 'Panzer Tactics';
SELECT 100 * (SELECT SUM(num_sales)  FROM region_sales  WHERE region_id = (SELECT id FROM region WHERE region_name = 'North America')  AND game_platform_id = 9577) /  (SELECT AVG(num_sales)  FROM region_sales  WHERE game_platform_id = 9577) - 100;
SELECT game_name FROM game ORDER BY LENGTH(game_name) DESC LIMIT 1; 
SELECT COUNT(game.id) FROM     game_platform WHERE     release_year = 2001;
SELECT SUM(num_sales) AS total_sales FROM region_sales;
SELECT AVG(cnt_games) AS average_games_published FROM (     SELECT        publisher_id,         COUNT(DISTINCT game_id) AS cnt_games     FROM         game_publisher     GROUP BY         publisher_id ) AS publisher_game_counts;
SELECT MIN(release_year) AS first_year_of_release FROM game_platform;
SELECT MIN(genre_count) AS least_common_genre_count FROM   (SELECT     COUNT(genre_id) AS genre_count    FROM      game    GROUP BY      genre_id) AS genre_counts;
SELECT publisher.publisher_name FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id WHERE game.game_name = 'Prism: Light the Way';
SELECT platform.platform_name, MAX(COUNT(game_publisher_id)) AS max_games_per_year FROM game_platform JOIN platform ON game_platform.platform_id = platform.id GROUP BY game_platform.release_year;
SELECT COUNT(DISTINCT game.id) FROM     game LEFT JOIN     game_platform ON game.id = game_platform.game_id LEFT JOIN     region_sales ON game_platform.id = region_sales.game_platform_id LEFT JOIN     region ON region_sales.region_id = region.id WHERE     region.region_name = 'Europe'     AND (region_sales.num_sales IS NULL OR region_sales.num_sales = 0);
SELECT game.game_name FROM game INNER JOIN game_platform ON game.id = game_platform.game_id WHERE game_platform.release_year = 2006;
SELECT genre.genre_name FROM game INNER JOIN genre ON game.genre_id = genre.id WHERE game.game_name = 'Mario vs. Donkey Kong';
SELECT publisher.publisher_name FROM publisher JOIN game_publisher ON publisher.id = game_publisher.publisher_id GROUP BY publisher.publisher_name ORDER BY COUNT(game_publisher.game_id) DESC LIMIT 1;
SELECT game.game_name FROM     game JOIN     genre ON game.genre_id = genre.id WHERE     genre.genre_name = 'Platform';
SELECT MIN(release_year) AS first_release_year, MAX(release_year) AS last_release_year FROM game_platform INNER JOIN platform ON game_platform.platform_id = platform.id WHERE platform.platform_name = 'WiiU';
SELECT game.game_name FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN game_platform ON game_publisher.id = game_platform.game_publisher_id JOIN region_sales ON game_platform.id = region_sales.game_platform_id JOIN region ON region_sales.region_id = region.id WHERE region.region_name = 'Japan' GROUP BY game.game_name ORDER BY SUM(region_sales.num_sales) DESC LIMIT 1;
SELECT game.game_name FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id WHERE publisher.publisher_name = 'Activision';
SELECT COUNT(DISTINCT publisher.id) FROM   publisher JOIN   game_publisher ON publisher.id = game_publisher.publisher_id JOIN   game ON game_publisher.game_id = game.id WHERE   game.game_name LIKE 'Marvel%'
SELECT (SUM(CASE WHEN genre_name = 'sport' THEN 1 ELSE 0 END) * 1.0 / COUNT(*)) * 100.0 FROM game JOIN genre ON game.genre_id = genre.id;
SELECT SUM(CASE WHEN r.region_name = 'North America' THEN rs.num_sales ELSE 0 END) / SUM(CASE WHEN r.region_name = 'Japan' THEN rs.num_sales ELSE 0 END) AS sales_ratio FROM region_sales rs JOIN region r ON rs.region_id = r.id;
SELECT MAX(release_year) AS most_releases_year FROM game_platform GROUP BY release_year ORDER BY COUNT(release_year) DESC LIMIT 1;
SELECT COUNT(DISTINCT game_publisher.publisher_id) FROM   game_publisher JOIN   publisher ON game_publisher.publisher_id = publisher.id WHERE   publisher.publisher_name LIKE '%Interactive%';
SELECT platform.platform_name, SUM(region_sales.num_sales) AS total_sales FROM platform JOIN game_platform ON platform.id = game_platform.platform_id JOIN region_sales ON game_platform.id = region_sales.game_platform_id JOIN region ON region_sales.region_id = region.id WHERE region.region_name = 'North America' GROUP BY platform.platform_name ORDER BY total_sales DESC LIMIT 2;
SELECT COUNT(game.id) FROM     game JOIN     game_publisher ON game.id = game_publisher.game_id JOIN     publisher ON game_publisher.publisher_id = publisher.id JOIN     game_platform ON game.id = game_platform.game_publisher_id WHERE     publisher.publisher_name = 'BMG Interactive Entertainment'     AND game_platform.release_year = 2012;
SELECT publisher.publisher_name FROM publisher JOIN game_publisher ON publisher.id = game_publisher.publisher_id JOIN game ON game_publisher.game_id = game.id JOIN game_platform ON game.id = game_platform.game_id WHERE game_platform.release_year = 2007 GROUP BY publisher.publisher_name ORDER BY COUNT(game.id) DESC LIMIT 1;
SELECT COUNT(DISTINCT publisher.id) FROM     publisher JOIN     game_publisher ON publisher.id = game_publisher.publisher_id JOIN     game ON game_publisher.game_id = game.id WHERE     game.game_name = 'Minecraft';
SELECT publisher.publisher_name FROM publisher JOIN game_publisher ON publisher.id = game_publisher.publisher_id JOIN game ON game_publisher.game_id = game.id JOIN genre ON game.genre_id = genre.id WHERE genre.genre_name = 'Action' GROUP BY publisher.publisher_name ORDER BY COUNT(*) DESC LIMIT 1; 
SELECT COUNT(*) FROM     game JOIN     genre ON game.genre_id = genre.id JOIN     game_publisher ON game.id = game_publisher.game_id JOIN     publisher ON game_publisher.publisher_id = publisher.id WHERE     genre.genre_name = 'Sports'     AND publisher.publisher_name = 'Nintendo';
SELECT genre.genre_name FROM game INNER JOIN genre ON game.genre_id = genre.id WHERE game.game_name = '2 Games in 1: Sonic Advance & ChuChu Rocket!';
SELECT COUNT(region_sales.num_sales) AS total_sales FROM region_sales JOIN region ON region_sales.region_id = region.id JOIN game_platform ON region_sales.game_platform_id = game_platform.id JOIN platform ON game_platform.platform_id = platform.id JOIN region AS other_region ON other_region.region_name = 'Other' WHERE platform.platform_name = 'DS' AND other_region.region_name = 'Other' AND region_sales.num_sales > 0;
SELECT game.game_name FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id WHERE publisher.publisher_name = 'American Softworks';
SELECT COUNT(*) FROM     game INNER JOIN genre ON game.genre_id = genre.id WHERE     genre.genre_name = 'Strategy';
SELECT publisher.publisher_name FROM publisher JOIN game_publisher ON publisher.id = game_publisher.publisher_id JOIN game ON game_publisher.game_id = game.id WHERE game.game_name = 'Overwatch';
SELECT genre.genre_name FROM     genre JOIN     game ON genre.id = game.genre_id GROUP BY     genre.genre_name ORDER BY     COUNT(game.id) DESC LIMIT 1;
SELECT SUM(num_sales * 100000) AS total_games_sold_in_europe FROM     region_sales JOIN     region ON region_sales.region_id = region.id JOIN     game_platform ON region_sales.game_platform_id = game_platform.id WHERE     region.region_name = 'Europe'     AND game_platform.id = 26;
SELECT COUNT(game.id) FROM     game JOIN     game_platform ON game.id = game_platform.game_id WHERE     game_platform.release_year = 2001;
SELECT COUNT(*) FROM     game WHERE     game_name LIKE '%Box%'; 
SELECT game.game_name FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN game_platform ON game_publisher.id = game_platform.game_publisher_id JOIN region_sales ON game_platform.id = region_sales.game_platform_id ORDER BY region_sales.num_sales DESC LIMIT 3;
SELECT MIN(release_year) AS first_game_release_year FROM game_platform;
SELECT publisher_name FROM publisher WHERE publisher_name LIKE '%Entertainment%'; 
SELECT game.game_name FROM game INNER JOIN genre ON game.genre_id = genre.id WHERE genre.genre_name = 'Adventure';
SELECT game.game_name FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id WHERE publisher.publisher_name = 'Pioneer LDC';
SELECT game.game_name FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id JOIN game_platform ON game.id = game_platform.game_publisher_id JOIN platform ON game_platform.platform_id = platform.id WHERE platform.platform_name = 'SCD';
SELECT game.game_name FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id JOIN game_platform ON game.id = game_platform.game_publisher_id JOIN region_sales ON game_platform.id = region_sales.game_platform_id JOIN region ON region_sales.region_id = region.id WHERE region.region_name = 'Japan';
SELECT genre.genre_name FROM genre INNER JOIN game ON genre.id = game.genre_id INNER JOIN game_publisher ON game.id = game_publisher.game_id INNER JOIN publisher ON game_publisher.publisher_id = publisher.id WHERE publisher.publisher_name = 'Agatsuma Entertainment';
SELECT COUNT(DISTINCT game.id) FROM     game LEFT JOIN genre ON game.genre_id = genre.id WHERE     genre.genre_name NOT IN ('Role-Playing', 'Shooter', 'Simulation');
SELECT region.region_name, platform.platform_name, MAX(SUM(region_sales.num_sales)) AS max_sales FROM region_sales JOIN region ON region.id = region_sales.region_id JOIN game_platform ON game_platform.id = region_sales.game_platform_id JOIN platform ON platform.id = game_platform.platform_id GROUP BY region.region_name;
SELECT MAX(publisher_name) AS most_games_publisher FROM (     SELECT        publisher.publisher_name,         COUNT(game_publisher.id) AS game_count     FROM         publisher     INNER JOIN         game_publisher ON publisher.id = game_publisher.publisher_id     INNER JOIN         game ON game_publisher.game_id = game.id     INNER JOIN         genre ON game.genre_id = genre.id     WHERE         genre.genre_name = 'Puzzle'     GROUP BY         publisher.publisher_name ) puzzle_publishers;
SELECT game.game_name FROM game JOIN game_platform ON game.id = game_platform.game_id JOIN region_sales ON game_platform.id = region_sales.game_platform_id GROUP BY game.id ORDER BY MIN(region_sales.num_sales) LIMIT 1;
SELECT publisher.publisher_name FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id WHERE game.game_name = 'Pachi-Slot Kanzen Kouryaku 3: Universal Koushiki Gaido Volume 3';
SELECT region.region_name FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id JOIN game_platform ON game_publisher.id = game_platform.game_publisher_id JOIN platform ON game_platform.platform_id = platform.id JOIN region_sales ON game_platform.id = region_sales.game_platform_id JOIN region ON region_sales.region_id = region.id WHERE game.game_name = 'Pengo';
SELECT game.game_name FROM game_platform JOIN game_publisher ON game_platform.game_publisher_id = game_publisher.id JOIN game ON game_publisher.game_id = game.id WHERE game_platform.release_year = 2010;
SELECT AVG(num_sales * 100000) FROM   game_platform JOIN   platform ON game_platform.platform_id = platform.id JOIN   region_sales ON game_platform.id = region_sales.game_platform_id JOIN   region ON region_sales.region_id = region.id WHERE   platform.platform_name = 'PS2';
SELECT ((SELECT COUNT(game_id) FROM game_publisher WHERE publisher_id = (SELECT id FROM publisher WHERE publisher_name = 'Brash Entertainment')) * 1.0 / (SELECT COUNT(game_id) FROM game_publisher)) * 100.0;
SELECT SUM(rs.num_sales) * 100000 AS total_games_sold FROM region_sales rs JOIN game_platform gp ON rs.game_platform_id = gp.id WHERE rs.region_id = 1; 
SELECT COUNT(game.id) FROM     game JOIN     game_publisher ON game.id = game_publisher.game_id JOIN     publisher ON game_publisher.publisher_id = publisher.id WHERE     game.game_name LIKE '%FIFA%';
SELECT platform.platform_name FROM     platform JOIN     game_platform ON platform.id = game_platform.platform_id JOIN     region_sales ON game_platform.id = region_sales.game_platform_id JOIN     region ON region.id = region_sales.region_id WHERE     region.region_name = 'Europe' GROUP BY     platform.platform_name ORDER BY     SUM(region_sales.num_sales) DESC LIMIT 1;
SELECT publisher.publisher_name FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id WHERE game.game_name = '2002 FIFA World Cup';
SELECT platform.platform_name FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id JOIN game_platform ON game.id = game_platform.game_publisher_id JOIN platform ON game_platform.platform_id = platform.id WHERE game.game_name = '3Xtreme';
SELECT genre.genre_name FROM game JOIN genre ON game.genre_id = genre.id WHERE game.game_name = '2010 FIFA World Cup South Africa';
SELECT region.region_name FROM region_sales JOIN region ON region_sales.region_id = region.id GROUP BY region_sales.region_id ORDER BY SUM(region_sales.num_sales) DESC LIMIT 1;
SELECT SUM(num_sales) * 100000 FROM     region_sales JOIN     game_platform ON region_sales.game_platform_id = game_platform.id JOIN     platform ON game_platform.platform_id = platform.id JOIN     region ON region_sales.region_id = region.id WHERE     platform.platform_name = 'PS3'     AND region.region_name = 'Japan';
SELECT game.game_name FROM game INNER JOIN game_platform ON game.id = game_platform.game_id WHERE game_platform.release_year = 2007;
SELECT COUNT(*) FROM game_publisher JOIN publisher ON game_publisher.publisher_id = publisher.id WHERE publisher_name = 'Activision';
SELECT game_platform.release_year FROM     game_platform JOIN     region_sales ON game_platform.id = region_sales.game_platform_id JOIN     region ON region.id = region_sales.region_id WHERE     region.region_name = 'Japan' GROUP BY     game_platform.release_year HAVING     SUM(region_sales.num_sales) > 200000;
SELECT COUNT(game.id) FROM     game JOIN     game_platform ON game.id = game_platform.game_id JOIN     platform ON game_platform.platform_id = platform.id WHERE     platform.platform_name = 'PS3' AND     game_platform.release_year = 2010;
SELECT publisher.publisher_name FROM     publisher JOIN     game_publisher ON publisher.id = game_publisher.publisher_id GROUP BY     publisher.publisher_name ORDER BY     COUNT(game_publisher.publisher_id) DESC LIMIT 1;
SELECT COUNT(*) FROM     game INNER JOIN genre ON game.genre_id = genre.id WHERE     genre.genre_name = 'shooter';
SELECT 100 * (     SELECT         COUNT(*)      FROM          game_platform      INNER JOIN          platform ON game_platform.platform_id = platform.id      WHERE          platform.platform_name = 'PS4'      AND          game_platform.release_year = 2014 ) / (     SELECT         COUNT(*)      FROM          game_platform      WHERE          release_year = 2014 );
SELECT SUM(num_sales)  FROM      region_sales  WHERE      region_id = 4;
SELECT game_platform_id FROM region_sales WHERE region_id = 1; 
SELECT SUM(CASE WHEN region_id = 2 THEN num_sales ELSE 0 END) - SUM(CASE WHEN region_id = 3 THEN num_sales ELSE 0 END) AS sales_difference FROM region_sales JOIN game_platform ON region_sales.game_platform_id = game_platform.id; 
SELECT game_platform.platform_id FROM game_platform WHERE game_platform.release_year = 2007;
SELECT DISTINCT game_publisher_id  FROM game_platform  WHERE platform_id = 16; 
SELECT COUNT(DISTINCT game_publisher.id) FROM game_publisher JOIN game ON game.id = game_publisher.game_id JOIN game_platform ON game_platform.game_publisher_id = game_publisher.id WHERE game_platform.release_year = 1984;
SELECT game_platform.platform_id FROM region_sales JOIN game_platform ON region_sales.game_platform_id = game_platform.id WHERE region_sales.region_id = 3; 
SELECT SUM(rs.num_sales) AS total_sales FROM     region_sales rs     JOIN region r ON rs.region_id = r.id     JOIN game_platform gp ON rs.game_platform_id = gp.id     JOIN game_publisher gpublisher ON gp.game_publisher_id = gpublisher.id     JOIN game g ON gpublisher.game_id = g.id     JOIN genre genre ON g.genre_id = genre.id WHERE     r.region_name = 'Japan';
SELECT COUNT(DISTINCT game_publisher_id) FROM     game_platform     JOIN platform ON game_platform.platform_id = platform.id     JOIN game_publisher ON game_platform.game_publisher_id = game_publisher.id WHERE     platform_name = 'X360';
SELECT platform.platform_name FROM game_platform JOIN platform ON game_platform.platform_id = platform.id WHERE game_platform.release_year = 2000;
SELECT SUM(CASE WHEN platform_name = 'PS3' THEN 1 ELSE 0 END) - SUM(CASE WHEN platform_name = 'X360' THEN 1 ELSE 0 END) AS publisher_difference FROM game_platform JOIN platform ON game_platform.platform_id = platform.id JOIN game_publisher ON game_platform.game_publisher_id = game_publisher.id
SELECT game.id FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id WHERE publisher.publisher_name = 'Bethesda Softworks';
SELECT COUNT(game.id) FROM     game     JOIN game_publisher ON game.id = game_publisher.game_id     JOIN publisher ON game_publisher.publisher_id = publisher.id WHERE     publisher.publisher_name IN ('Capcom', 'Sony Computer Entertainment');
SELECT genre.genre_name FROM game INNER JOIN genre ON game.genre_id = genre.id WHERE game.game_name = 'Grand Theft Auto V';
SELECT game.game_name FROM game JOIN genre ON game.genre_id = genre.id WHERE genre.genre_name = 'Racing';
SELECT COUNT(*) FROM     game WHERE     genre_id = (SELECT id FROM genre WHERE genre_name = 'Fighting');
SELECT genre.genre_name FROM   genre INNER JOIN   game ON   genre.id = game.genre_id INNER JOIN   game_publisher ON   game.id = game_publisher.game_id WHERE   game_publisher.publisher_id = 464;
SELECT platform.platform_name FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN game_platform ON game_publisher.id = game_platform.game_publisher_id JOIN platform ON game_platform.platform_id = platform.id WHERE game.game_name = 'Final Fantasy XIII-2';
SELECT SUM(rs.num_sales) AS total_sales FROM     region_sales rs     JOIN game_platform gp ON rs.game_platform_id = gp.id WHERE     gp.release_year = 2000;
SELECT SUM(CASE WHEN gp.release_year = 2000 THEN rs.num_sales ELSE 0 END) -  SUM(CASE WHEN gp.release_year = 1990 THEN rs.num_sales ELSE 0 END) AS sales_difference FROM region_sales rs JOIN game_platform gp ON rs.game_platform_id = gp.id;
SELECT game_platform.platform_id FROM game_platform WHERE game_platform.release_year = 2006;
SELECT AVG(num_sales * 100000) AS average_sales FROM region_sales JOIN game_platform ON region_sales.game_platform_id = game_platform.id WHERE region_sales.region_id = 3;
SELECT release_year FROM game_platform WHERE id = 19;
SELECT MULTIPLY(SUM(rs.num_sales), 100000) AS total_sales FROM     region_sales rs JOIN     game_platform gp ON rs.game_platform_id = gp.id WHERE     gp.id = 66; 
SELECT game.game_name FROM game WHERE game.id = 44;
SELECT game.game_name FROM game JOIN game_platform ON game.id = game_platform.game_id JOIN platform ON game_platform.platform_id = platform.id WHERE platform.platform_name = 'Wii';
SELECT game.game_name FROM game_platform JOIN game_publisher ON game_platform.game_publisher_id = game_publisher.id JOIN game ON game_publisher.game_id = game.id WHERE game_platform.release_year = 2015;
SELECT COUNT(*) FROM     game JOIN     genre ON game.genre_id = genre.id JOIN     game_platform ON game.id = game_platform.game_id WHERE     genre.genre_name = 'Adventure'     AND game_platform.release_year = 2005;
SELECT publisher.publisher_name FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id WHERE game.game_name = 'Adventure Time: Explore the Dungeon Because I Don''t Know!';
SELECT game_platform.id, region.region_name FROM region_sales JOIN game_platform ON region_sales.game_platform_id = game_platform.id JOIN region ON region_sales.region_id = region.id WHERE region_sales.num_sales < 0.2;
SELECT game.game_name FROM game JOIN game_publisher ON game.id = game_publisher.game_id JOIN publisher ON game_publisher.publisher_id = publisher.id JOIN game_platform ON game.id = game_platform.game_publisher_id WHERE publisher.publisher_name = '505 Games' AND game_platform.release_year = 2006;
SELECT genre.genre_name FROM genre JOIN game ON genre.id = game.genre_id WHERE game.id = 119;
SELECT game.id FROM     game JOIN     game_publisher ON game.id = game_publisher.game_id JOIN     publisher ON game_publisher.publisher_id = publisher.id WHERE     publisher.publisher_name = 'Abylight';
SELECT region.region_name FROM region_sales JOIN region ON region_sales.region_id = region.id WHERE region_sales.num_sales = (     SELECT MIN(num_sales) FROM region_sales );
SELECT game.game_name FROM game JOIN genre ON game.genre_id = genre.id WHERE genre.genre_name = 'Strategy';
SELECT platform.platform_name FROM game JOIN game_platform ON game.id = game_platform.game_id JOIN platform ON game_platform.platform_id = platform.id WHERE game.id = 178;
SELECT genre.genre_name FROM game JOIN genre ON game.genre_id = genre.id WHERE game.game_name IN ('Airlock', 'Airline Tycoon', 'Airblade'); 
SELECT SUM(num_sales) * 100000 FROM     region_sales JOIN     region ON region_sales.region_id = region.id WHERE     region.region_name = 'North America';
SELECT publisher.publisher_name, COUNT(region_sales.num_sales) AS sales_count FROM publisher JOIN game_publisher ON publisher.id = game_publisher.publisher_id JOIN game ON game_publisher.game_id = game.id JOIN game_platform ON game.id = game_platform.game_id JOIN region_sales ON game_platform.id = region_sales.game_platform_id WHERE region_sales.num_sales < 10000 GROUP BY publisher.publisher_name HAVING sales_count >= 5; 
SELECT game_platform.platform_id FROM     game JOIN     game_platform ON game.id = game_platform.game_id JOIN     game_publisher ON game.id = game_publisher.game_id JOIN     publisher ON game_publisher.publisher_id = publisher.id WHERE     game.game_name = 'Airborne Troops: Countdown to D-Day';
SELECT COUNT(game.id) FROM     game JOIN game_platform ON game.id = game_platform.game_id JOIN platform ON game_platform.platform_id = platform.id WHERE     platform.platform_name = 'PSP' AND     game_platform.release_year = 2004;
SELECT genre.genre_name FROM game JOIN genre ON game.genre_id = genre.id WHERE game.game_name = '999: Nine Hours, Nine Persons, Nine Doors';
SELECT release_year FROM game_platform WHERE game_publisher_id = (     SELECT id     FROM game_publisher     WHERE game_id = 156 );
SELECT (SUM(CASE WHEN platform.platform_name = 'SNES' THEN 1 ELSE 0 END) - SUM(CASE WHEN platform.platform_name = 'DS' THEN 1 ELSE 0 END)) AS difference FROM     game JOIN     game_publisher ON game.id = game_publisher.game_id JOIN     publisher ON game_publisher.publisher_id = publisher.id JOIN     game_platform ON game.id = game_platform.game_publisher_id JOIN     platform ON game_platform.platform_id = platform.id WHERE     publisher.publisher_name = 'Culture Brain'; 
SELECT 100.0 * SUM(CASE WHEN game_platform_id IN (SELECT id FROM game_platform WHERE platform_id IN (SELECT id FROM platform WHERE platform_name = 'Wii')) AND release_year = 2007 THEN 1 ELSE 0 END) / COUNT(*) FROM game_platform;
SELECT game_platform.platform_id FROM game_platform INNER JOIN region_sales ON game_platform.id = region_sales.game_platform_id INNER JOIN region ON region_sales.region_id = region.id WHERE region.region_name = 'Europe' GROUP BY game_platform.platform_id HAVING SUM(region_sales.num_sales) < AVG(region_sales.num_sales) * 0.3;
SELECT COUNT(DISTINCT author.id) AS "Number of Authors Affiliated with University of California Berkeley" FROM     author WHERE     author.affiliation = 'University of California Berkeley';
SELECT title, keyword FROM paper WHERE title = "Stitching videos streamed by mobile phones in real-time";
SELECT paper.title FROM paper INNER JOIN journal ON paper.journalid = journal.id WHERE journal.fullname = 'Concepts in Magnetic Resonance Part A' AND paper.year = 2008;
SELECT COUNT(*) FROM     paper WHERE     journalid = (SELECT id FROM journal WHERE fullname = 'Concepts in Magnetic Resonance Part A');
SELECT journal.homepage FROM paper JOIN journal ON paper.journalid = journal.id WHERE paper.title = 'Area Effects in Cepaea';
SELECT COUNT(paper.id) FROM     paper JOIN     journal ON paper.journalid = journal.id WHERE     journal.fullname = "Molecular Brain"     AND paper.year = 2011;
SELECT COUNT(*) FROM paper JOIN journal ON paper.journalid = journal.id WHERE paper.year = 2011 AND journal.shortname = 'Mol Brain';
SELECT COUNT(DISTINCT author.id) AS author_count FROM     paper JOIN     paperauthor ON paper.id = paperauthor.paperid JOIN     author ON paperauthor.authorid = author.id WHERE     paper.title = "Equation Solving in Geometrical Theories";
SELECT paperauthor.name FROM paperauthor JOIN paper ON paperauthor.paperid = paper.id WHERE paper.title = "Area Effects in Cepaea";
SELECT COUNT(DISTINCT paperauthor.authorid) FROM     paperauthor WHERE     paperauthor.paperid IN (         SELECT            paper.id         FROM             paper         WHERE             paper.title = 'Stitching videos streamed by mobile phones in real-time'     )     AND paperauthor.affiliation = 'Cairo Microsoft Innovation Lab';
SELECT paper.title FROM paper JOIN paperauthor ON paper.id = paperauthor.paperid JOIN author ON paperauthor.authorid = author.id WHERE author.name = 'Klaus Zimmermann';
SELECT paperauthor.name FROM paperauthor JOIN paper ON paperauthor.paperid = paper.id JOIN author ON paperauthor.authorid = author.id WHERE paper.title = "Incremental Extraction of Keyterms for Classifying Multilingual Documents in the Web" AND paperauthor.affiliation = "National Taiwan University Department of Computer Science and Information Engineering Taiwan";
SELECT paper.title FROM paper JOIN paperauthor ON paper.id = paperauthor.paperid JOIN author ON paperauthor.authorid = author.id WHERE paper.year = 1995 AND author.name = 'Thomas Wiegand';
SELECT COUNT(*) FROM paper JOIN paperauthor ON paper.id = paperauthor.paperid JOIN author ON paperauthor.authorid = author.id WHERE author.name = 'Thomas Wiegand' AND paper.year = 1995;
SELECT AVG(num_papers) FROM (     SELECT COUNT(id) AS num_papers     FROM paper     WHERE journalid = (         SELECT id         FROM journal         WHERE fullname = 'Molecular Brain'     )     AND year BETWEEN 2008 AND 2011     GROUP BY year );
SELECT (COUNT(CASE WHEN journal.fullname = 'Cases Journal' THEN paper.id END) - COUNT(CASE WHEN journal.fullname = 'Molecular Brain' THEN paper.id END)) * 100.0 / COUNT(CASE WHEN journal.fullname = 'Molecular Brain' THEN paper.id END) AS percentage_more_papers FROM paper JOIN journal ON paper.journalid = journal.id;
SELECT COUNT(*) FROM journal WHERE fullname LIKE '%computing%';
SELECT paper.id, paperauthor.authorid FROM paper JOIN paperauthor ON paper.id = paperauthor.paperid WHERE paperauthor.affiliation = "Cairo Microsoft Innovation Lab";
SELECT shortname, fullname FROM conference WHERE homepage = "http://www.informatik.uni-trier.de/~ley/db/conf/ices/index.html"; 
SELECT author.id FROM author WHERE author.name = "Peter"; 
SELECT paper.title, conference.shortname FROM paper JOIN conference ON paper.conferenceid = conference.id WHERE conference.id BETWEEN 160 AND 170;
SELECT paper.title, journal.homepage FROM paper JOIN journal ON paper.journalid = journal.id WHERE paper.year = (SELECT MAX(year) FROM paper); 
SELECT paper.title, conference.shortname FROM paper JOIN paperauthor ON paper.id = paperauthor.paperid JOIN conference ON paper.conferenceid = conference.id JOIN author ON paperauthor.authorid = author.id WHERE paper.year = 1999 AND author.name LIKE 'Philip%'
SELECT COUNT(paper.id) AS total_number_of_papers, conference.homepage AS conference_homepage FROM paper JOIN conference ON paper.conferenceid = conference.id WHERE paper.conferenceid = 187 AND paper.year BETWEEN 1990 AND 2000;
SELECT paper.title FROM paper JOIN paperauthor ON paper.id = paperauthor.paperid JOIN author ON paperauthor.authorid = author.id WHERE paper.year = 2003 AND author.affiliation = 'Department of Network Science, Graduate School of Information Systems, The University of Electro-Communications';
SELECT paperauthor.name, journal.shortname FROM paperauthor JOIN paper ON paperauthor.paperid = paper.id JOIN journal ON paper.journalid = journal.id WHERE paper.title LIKE 'chemiluminescence%' AND journal.id BETWEEN 245 AND 250; 
SELECT paperauthor.name, paperauthor.affiliation FROM paperauthor JOIN paper ON paperauthor.paperid = paper.id WHERE paper.conferenceid = 0 AND paper.journalid < 100; 
SELECT paper.title, paperauthor.authorid FROM paper JOIN paperauthor ON paper.id = paperauthor.paperid WHERE paper.year = 2006 AND paper.conferenceid < 100;
SELECT paper.id FROM paper JOIN conference ON paper.conferenceid = conference.id WHERE conference.homepage LIKE 'http://www.informatik.uni-trier.de/~ley/db/conf/%';
SELECT journal.homepage, paperauthor.authorid FROM paper JOIN journal ON paper.journalid = journal.id JOIN paperauthor ON paper.id = paperauthor.paperid WHERE paper.year BETWEEN 2000 AND 2005 AND paper.title LIKE '%SOCIAL%';
SELECT paperauthor.authorid, paperauthor.affiliation FROM paperauthor JOIN paper ON paperauthor.paperid = paper.id WHERE paper.year = 2009 AND paper.journalid = 0; 
SELECT (CAST(     (SELECT COUNT(*)       FROM paper       WHERE journalid BETWEEN 200 AND 300       AND shortname LIKE 'A%'      AND conferenceid = 0) AS FLOAT) /   (SELECT COUNT(*)    FROM paper    WHERE journalid BETWEEN 200 AND 300    AND shortname LIKE 'A%')) * 100 
SELECT (COUNT(CASE WHEN paper.year = 2001 THEN paper.id END) * 100.0) / COUNT(CASE WHEN paper.year BETWEEN 2001 AND 2010 THEN paper.id END) AS paper_published_rate_2001
SELECT fullname, homepage FROM conference WHERE shortname = 'ICWE'; 
SELECT MAX(COUNT(paperauthor.authorid)) AS max_affiliated_authors FROM     author JOIN     paperauthor ON author.id = paperauthor.authorid WHERE     author.affiliation IN ('Stanford University', 'Massachusetts Institute of Technology') GROUP BY     author.affiliation;
SELECT COUNT(CASE WHEN author.affiliation IS NOT NULL THEN author.id END) AS authors_with_affiliation, COUNT(CASE WHEN author.affiliation IS NULL THEN author.id END) AS authors_without_affiliation FROM author;
SELECT author.id, author.name FROM author INNER JOIN paperauthor ON author.id = paperauthor.authorid WHERE paperauthor.affiliation = 'University of Oulu';
SELECT title, affiliation FROM paper JOIN paperauthor ON paper.id = paperauthor.paperid JOIN author ON paperauthor.authorid = author.id WHERE author.name = "Roger J. Marshall" AND paper.conferenceid = 0 AND paper.journalid = 0; 
SELECT paper.id, paper.title, paper.year, journal.fullname FROM paper JOIN journal ON paper.journalid = journal.id WHERE paper.id = (     SELECT    paperauthor.paperid     FROM     paperauthor     GROUP BY     paperauthor.paperid     ORDER BY     COUNT(paperauthor.paperid) DESC     LIMIT 1 )
SELECT paper.title, paper.year, conference.shortname, GROUP_CONCAT(paperauthor.name, ', ') AS author_names FROM paper JOIN conference ON paper.conferenceid = conference.id JOIN paperauthor ON paper.id = paperauthor.paperid WHERE paper.id = 15;
SELECT paper.id, paper.year, paper.keyword FROM paperauthor JOIN paper ON paperauthor.paperid = paper.id WHERE paperauthor.authorid < 1000 AND paperauthor.affiliation = 'Zurich, ETH';
SELECT paperauthor.authorid, paperauthor.name FROM paperauthor INNER JOIN paper ON paperauthor.paperid = paper.id WHERE paper.title = "Inspection resistant memory: Architectural support for security from physical examination" AND paperauthor.affiliation = "Microsoft Research, USA";
SELECT author.name, author.affiliation, journal.shortname, journal.fullname FROM paper JOIN paperauthor ON paper.id = paperauthor.paperid JOIN author ON paperauthor.authorid = author.id JOIN journal ON paper.journalid = journal.id WHERE paper.title = "Decreased Saliva Secretion and Down-Regulation of AQP5 in Submandibular Gland in Irradiated Rats";
SELECT paper.title, paper.journalid FROM paper JOIN conference ON paper.conferenceid = conference.id WHERE conference.fullname = 'International Symposium of Robotics Research';
SELECT paper.title, paper.year, paper.keyword FROM paper JOIN paperauthor ON paper.id = paperauthor.paperid WHERE paperauthor.authorid = 661002 AND paperauthor.affiliation = "Scientific Computing and Imaging Institute, University of Utah, UT 84112, USA";
SELECT COUNT(paper.id) - (SELECT COUNT(paper.id) FROM paper JOIN journal ON paper.journalid = journal.id WHERE journal.shortname = 'IWC' AND paper.year = 2010) FROM paper JOIN journal ON paper.journalid = journal.id WHERE journal.shortname = 'IWC' AND paper.year = 2000;
SELECT journal.id, journal.shortname, journal.fullname, paper.title FROM paper JOIN journal ON paper.journalid = journal.id WHERE paper.year = 2013 AND journal.id != 0 AND journal.id != -1 LIMIT 4; 
SELECT COUNT(p1.id) AS num_needed_papers, AVG(p2.year) AS avg_year, GROUP_CONCAT(p1.title) AS paper_titles, GROUP_CONCAT(a.name) AS author_names FROM paper AS p1 JOIN conference AS c ON p1.conferenceid = c.id JOIN paperauthor AS pa ON p1.id = pa.paperid JOIN author AS a ON pa.authorid = a.id JOIN (     SELECT p.id, p.year     FROM paper AS p     JOIN conference AS c ON p.conferenceid = c.id     WHERE c.shortname = 'MICRO' AND p.year BETWEEN '1971' AND '1980' ) AS p2 ON p1.id = p2.id WHERE c.shortname = 'MICRO' AND p1.year BETWEEN '1991' AND '2000' GROUP BY c.shortname;
SELECT COUNT(*) FROM paper WHERE year = 0;
SELECT conference.fullname FROM paper JOIN conference ON paper.conferenceid = conference.id WHERE paper.title = "The Dissimilarity Representation as a Tool for Three-Way Data Classification: A 2D Measure";
SELECT journal.homepage FROM paper JOIN journal ON paper.journalid = journal.id WHERE paper.title = "Energy-efficiency bounds for noise-tolerant dynamic circuits";
SELECT paperauthor.name FROM paperauthor INNER JOIN paper ON paperauthor.paperid = paper.id WHERE paper.id BETWEEN 101 AND 105;
SELECT conference.shortname FROM   paper JOIN   conference ON   paper.conferenceid = conference.id WHERE   paper.year = 2009 LIMIT   10;
SELECT journal.homepage FROM paper JOIN journal ON paper.journalid = journal.id WHERE paper.title = '364: Induction of Mixed Chimerism and Transplantation Tolerance in a Non-Human Primate Lung Allograft Model: Early Results'; 
SELECT paper.title FROM paper JOIN conference ON paper.conferenceid = conference.id WHERE conference.fullname = 'International Conference on Internet Computing';
SELECT paperauthor.name FROM paperauthor JOIN paper ON paperauthor.paperid = paper.id WHERE paper.year = '2005' AND paper.keyword = 'LOAD; IDE; SNP; haplotype; asso- ciation studies'; 
SELECT COUNT(DISTINCT author.id) FROM     author JOIN     paperauthor ON author.id = paperauthor.authorid JOIN     paper ON paperauthor.paperid = paper.id WHERE     paper.title LIKE '%145 GROWTH HORMONE RECEPTORS AND THE ONSET OF HYPERINSULINEMIA IN THE OBESE ZUCKER RAT:%';
SELECT paperauthor.name, paperauthor.affiliation, paper.title FROM paperauthor JOIN paper ON paperauthor.paperid = paper.id WHERE paperauthor.name = 'Jei Keon Chae'; 
SELECT conference.fullname, journal.fullname, paperauthor.name, paper.title FROM paper JOIN paperauthor ON paper.id = paperauthor.paperid JOIN author ON paperauthor.authorid = author.id JOIN conference ON paper.conferenceid = conference.id JOIN journal ON paper.journalid = journal.id WHERE author.name = "Shueh-Lin Yau";
SELECT COUNT(paper.id) FROM paper WHERE paper.year BETWEEN '1990' AND '2000' AND paper.keyword = 'preprinted';
SELECT name FROM author WHERE affiliation = 'Birkbeck University of London'; 
SELECT conference.shortname FROM conference WHERE conference.fullname LIKE 'International Symposium%' 
SELECT COUNT(*) FROM journal WHERE homepage = '';
SELECT author.name FROM author INNER JOIN paperauthor ON author.id = paperauthor.authorid INNER JOIN paper ON paperauthor.paperid = paper.id WHERE paper.year = 0 
SELECT paperauthor.affiliation FROM paperauthor JOIN paper ON paperauthor.paperid = paper.id WHERE paper.keyword = 'Quantum Physics';
SELECT conference.fullname, paper.title FROM conference JOIN paper ON conference.id = paper.conferenceid WHERE paper.journalid = 0 AND paper.conferenceid != 0 AND paper.year != 0;
SELECT paper.title FROM paper JOIN conference ON paper.conferenceid = conference.id WHERE conference.homepage IS NULL OR conference.homepage = '' 
SELECT DISTINCT journal.fullname FROM   paper JOIN   journal ON paper.journalid = journal.id WHERE   journal.shortname IS NULL OR journal.shortname = '' GROUP BY   paper.year; 
SELECT paperauthor.affiliation FROM paperauthor JOIN paper ON paperauthor.paperid = paper.id JOIN journal ON paper.journalid = journal.id WHERE paper.title = 'A combined search for the standard model Higgs boson at s = 1.96 Â TeV' 
SELECT journal.FullName FROM paper JOIN journal ON paper.journalid = journal.id WHERE paper.year = 2001;
SELECT paperauthor.name FROM paperauthor JOIN paper ON paperauthor.paperid = paper.id WHERE paper.title = 'Particle identification using the time-over-threshold method in the ATLAS Transition Radiation Tracker'; 
SELECT COUNT(*) AS "Number of Papers", GROUP_CONCAT(DISTINCT year) AS "Years" FROM paper INNER JOIN conference ON paper.conferenceid = conference.id WHERE conference.fullname = 'International Conference on Database Theory' AND year != 0;
SELECT journal.fullname FROM journal JOIN paper ON paper.journalid = journal.id WHERE paper.keyword = 'Sustainability';
SELECT author.name FROM author JOIN paperauthor ON author.id = paperauthor.authorid JOIN paper ON paperauthor.paperid = paper.id JOIN conference ON paper.conferenceid = conference.id WHERE conference.fullname LIKE '%Workshop%' 
SELECT (SELECT COUNT(pa.affiliation LIKE '%INFN%') * 100.0 / COUNT(pa.authorid) AS percentage FROM paperauthor AS pa JOIN paper AS p ON pa.paperid = p.id WHERE p.title LIKE '%Charged particle multiplicity%';)
SELECT (      SELECT         (COUNT(journal.id) * 1.0 / (SELECT COUNT(id) FROM journal)) * 100 AS percentage     FROM          journal      JOIN          paper ON journal.id = paper.journalid      WHERE          journal.shortname LIKE 'ANN%'          AND paper.year = 1989 ) AS result;
SELECT COUNT(DISTINCT author.id) AS num_authors FROM     author JOIN     paperauthor ON author.id = paperauthor.authorid WHERE     paperauthor.paperid = 1     AND paperauthor.affiliation LIKE '%Microsoft Research%';
SELECT title, year, keyword FROM paper WHERE title = 'A Formal Approach to Service Component Architecture';
SELECT 100 * (     SELECT        COUNT(*)     FROM         paper     WHERE         conferenceid = 0 AND journalid = 0 AND year > 2000 ) / (     SELECT        COUNT(*)     FROM         paper ) AS percentage_of_preprinted_papers_after_2000;
SELECT author.name FROM author JOIN paperauthor ON author.id = paperauthor.authorid JOIN paper ON paperauthor.paperid = paper.id WHERE paper.title = 'Hypermethylation of the <I>TPEF/HPP1</I> Gene in Primary and Metastatic Colorectal Cancers'; 
SELECT fullname FROM journal JOIN paper ON journal.id = paper.journalid WHERE paper.title = 'Multiple paternity in a natural population of a salamander with long-term sperm storage';
SELECT COUNT(paper.id) FROM paper JOIN journal ON paper.journalid = journal.id WHERE journal.fullname = 'Iet Software/iee Proceedings - Software';
SELECT conference.fullname FROM conference JOIN paper ON paper.conferenceid = conference.id WHERE paper.id = 5;
SELECT paper.title FROM     paper JOIN     paperauthor ON paper.id = paperauthor.paperid JOIN     author ON paperauthor.authorid = author.id WHERE     author.name LIKE '%Jun du%' LIMIT 2;
SELECT paper.title FROM     paper JOIN     paperauthor ON paper.id = paperauthor.paperid JOIN     author ON paperauthor.authorid = author.id WHERE     author.name = 'Cheng Huang'     AND paperauthor.affiliation LIKE 'Microsoft %';
SELECT conference.fullname FROM conference JOIN paper ON paper.conferenceid = conference.id JOIN paperauthor ON paperauthor.paperid = paper.id JOIN author ON author.id = paperauthor.authorid WHERE author.name = 'Jean-luc Hainaut';
SELECT journal.fullname FROM journal JOIN paper ON paper.journalid = journal.id JOIN paperauthor ON paperauthor.paperid = paper.id WHERE paperauthor.name = 'Andrew Cain' GROUP BY journal.fullname;
SELECT paperauthor.affiliation FROM paperauthor JOIN paper ON paperauthor.paperid = paper.id WHERE paper.title = 'FIBER: A Generalized Framework for Auto-tuning Software'; 
SELECT paper.title, journal.fullname FROM paper JOIN journal ON paper.journalid = journal.id WHERE paper.year = 0;
SELECT journal.shortname, journal.fullname FROM journal INNER JOIN paper ON paper.journalid = journal.id WHERE paper.keyword = 'Materials';
SELECT paperauthor.name FROM paperauthor INNER JOIN author ON paperauthor.authorid = author.id WHERE paperauthor.affiliation = 'University of Oxford' ORDER BY paperauthor.name ASC; 
SELECT conference.shortname, conference.homepage FROM conference WHERE conference.fullname LIKE 'International Conference on Artificial Intelligence%'
SELECT title FROM paper WHERE year = 1996; 
SELECT paper.title, author.name FROM paper JOIN paperauthor ON paper.id = paperauthor.paperid JOIN author ON paperauthor.authorid = author.id JOIN journal ON paper.journalid = journal.id WHERE paper.year = 2007 AND journal.fullname = 'Neoplasia';
SELECT paperauthor.name, paper.title FROM paperauthor JOIN paper ON paperauthor.paperid = paper.id WHERE paperauthor.affiliation = 'Soongsil University' AND paper.year = 2000; 
SELECT paper.title, author.name FROM paper JOIN paperauthor ON paper.id = paperauthor.paperid JOIN author ON paperauthor.authorid = author.id WHERE paper.year BETWEEN 2000 AND 2005 AND paper.keyword LIKE '%optical properties%';
SELECT AVG(papers_per_year) FROM     (SELECT        COUNT(*) AS papers_per_year     FROM         paper     JOIN         conference ON paper.conferenceid = conference.id     WHERE         conference.fullname = 'World Computer Congress'     GROUP BY         paper.year) AS subquery;
SELECT paper.title, author.name FROM paper JOIN paperauthor ON paper.id = paperauthor.paperid JOIN author ON paperauthor.authorid = author.id WHERE paper.year = 1997 AND paper.conferenceid = 0 AND paper.journalid = 0;
SELECT paper.title, journal.fullname FROM paper JOIN journal ON paper.journalid = journal.id JOIN paperauthor ON paper.id = paperauthor.paperid JOIN author ON paperauthor.authorid = author.id WHERE author.name = 'Adam Jones' AND paper.year BETWEEN 2005 AND 2010;
SELECT COUNT(DISTINCT author.id) FROM     author JOIN     paperauthor ON author.id = paperauthor.authorid WHERE     paperauthor.affiliation = "Otterbein University";
SELECT COUNT(DISTINCT author.id) FROM   paper JOIN   paperauthor ON paper.id = paperauthor.paperid JOIN   author ON paperauthor.authorid = author.id WHERE   paper.title = 'Subcellular localization of nuclease in barley aleurone';
SELECT conference.fullname FROM paper JOIN conference ON paper.conferenceid = conference.id WHERE paper.title = 'Extended Fuzzy Regression Models';
SELECT COUNT(paper.id) FROM paper JOIN conference ON paper.conferenceid = conference.id WHERE conference.fullname = 'Mathematics of Program Construction';
SELECT paperauthor.name FROM paperauthor JOIN paper ON paperauthor.paperid = paper.id WHERE paper.title = "Open Sourcing Social Solutions (Building Communities of Change)";
SELECT paper.title FROM paperauthor JOIN author ON paperauthor.authorid = author.id JOIN paper ON paperauthor.paperid = paper.id WHERE author.name = 'Jianli Hua';
SELECT paperauthor.name, paperauthor.affiliation FROM paperauthor JOIN paper ON paperauthor.paperid = paper.id WHERE paper.title = "Testing timed automata";
SELECT COUNT(paper.id) FROM paper INNER JOIN conference ON paper.conferenceid = conference.id WHERE paper.year = 2000 AND conference.shortname = "SSPR";
SELECT paper.title FROM paper JOIN journal ON paper.journalid = journal.id WHERE journal.fullname = 'Theoretical Computer Science' AND paper.year = 2003;
SELECT conference.homepage FROM paper JOIN conference ON paper.conferenceid = conference.id WHERE paper.title = "Quality evaluation of long duration audiovisual content";
SELECT author.name FROM author JOIN paperauthor ON author.id = paperauthor.authorid JOIN paper ON paperauthor.paperid = paper.id WHERE paper.title = "A Randomized Comparison of Sirolimus- Versus Paclitaxel-Eluting Stent Implantation in Patients With Diabetes Mellitus" AND paperauthor.affiliation = "Asan Medical Center, University of Ulsan College of Medicine, Seoul, Korea" 
SELECT COUNT(*) FROM     paper JOIN     journal ON paper.journalid = journal.id WHERE     journal.fullname = 'Software - Practice and Experience';
SELECT paper.title FROM paper JOIN conference ON paper.conferenceid = conference.id WHERE conference.homepage = 'http://www.irma-international.org/';
SELECT ROUND(CAST((SELECT COUNT(id) FROM paper WHERE year BETWEEN 2002 AND 2010 AND conferenceid = (SELECT id FROM conference WHERE fullname = 'Information and Knowledge Engineering')) AS REAL) / 9, 2) AS "Average Number of Papers"
SELECT SUM(   CASE WHEN conference.fullname = 'International Conference on Supercomputing' THEN 1 ELSE 0 END ) - SUM(   CASE WHEN conference.fullname = 'Informatik & Schule' THEN 1 ELSE 0 END ) AS difference FROM paper JOIN conference ON paper.conferenceid = conference.id WHERE paper.year BETWEEN 1991 AND 2000;
SELECT journal.shortname FROM journal JOIN paper ON paper.journalid = journal.id WHERE paper.title = "Software - Concepts and Tools / Structured Programming";
SELECT journal.fullname FROM paper JOIN journal ON paper.journalid = journal.id WHERE paper.title = 'Education, democracy and growth';
SELECT COUNT(paper.id) FROM paper JOIN journal ON paper.journalid = journal.id WHERE journal.fullname = 'IEEE Transactions on Nuclear Science' AND paper.year = '1999';
SELECT paper.title FROM paper JOIN journal ON paper.journalid = journal.id WHERE journal.fullname = 'IEEE Transactions on Pattern Analysis and Machine Intelligence' AND paper.year = '2011';
SELECT paper.keyword FROM paper JOIN journal ON paper.journalid = journal.id WHERE journal.fullname = 'Modeling Identification and Control' AND paper.year = '1994' 
SELECT paper.title FROM paper JOIN paperauthor ON paper.id = paperauthor.paperid JOIN author ON paperauthor.authorid = author.id WHERE author.name = "Zvezdan Protić"
SELECT conference.fullname FROM paper JOIN conference ON paper.conferenceid = conference.id WHERE paper.title = 'Skew-Circulant Preconditioners for Systems of LMF-Based ODE Codes';
SELECT COUNT(paper.id) FROM paper JOIN conference ON paper.conferenceid = conference.id WHERE conference.fullname = 'International Symposium on Software Testing and Analysis';
SELECT conference.homepage FROM conference JOIN paper ON conference.id = paper.conferenceid WHERE paper.title = 'Increasing the Concurrency in Estelle';
SELECT COUNT(paperauthor.authorid) FROM   paperauthor JOIN   paper ON paperauthor.paperid = paper.id WHERE   paper.title = "An Improved Active Suspension Model for Attitude Control of Electric Vehicles"
SELECT MAX(conference.shortname) FROM     conference JOIN     paper ON conference.id = paper.conferenceid WHERE     paper.year = 2012 GROUP BY     conference.id ORDER BY     COUNT(paper.id) DESC LIMIT 1;
SELECT COUNT(paper.id) AS paper_count FROM paper JOIN conference ON paper.conferenceid = conference.id WHERE conference.shortname = 'ECSQARU' AND paper.year = '2003';
SELECT paper.keyword FROM paper JOIN conference ON paper.conferenceid = conference.id WHERE conference.fullname = 'International Radar Symposium' AND paper.year = '2012';
SELECT (SELECT COUNT(*) FROM paper WHERE conferenceid = (SELECT id FROM conference WHERE fullname = 'International Conference on Thermoelectrics')) - (SELECT COUNT(*) FROM paper WHERE conferenceid = (SELECT id FROM conference WHERE fullname = 'International Conference on Wireless Networks, Communications and Mobile Computing')) 
SELECT 100 * (     SELECT         CAST(COUNT(paper.id) AS REAL)      FROM          paper      INNER JOIN          paperauthor ON paper.id = paperauthor.paperid      INNER JOIN          author ON paperauthor.authorid = author.id      WHERE          author.name = 'John Van Reenen'          AND paper.conferenceid = 0          AND paper.journalid = 0 ) / (     SELECT         CAST(COUNT(paper.id) AS REAL)      FROM          paper      INNER JOIN          paperauthor ON paper.id = paperauthor.paperid      INNER JOIN          author ON paperauthor.authorid = author.id      WHERE          author.name = 'John Van Reenen' ) AS "Percentage of Preprints"
SELECT MIN(year) AS oldest_published_year, title AS oldest_published_book FROM paper WHERE journalid IS NOT NULL AND year = (SELECT MIN(year) FROM paper WHERE journalid IS NOT NULL)
SELECT fullname FROM conference ORDER BY LENGTH(fullname) DESC LIMIT 1; 
SELECT COUNT(DISTINCT author.id) AS num_authors FROM     author INNER JOIN     paperauthor ON author.id = paperauthor.authorid WHERE     paperauthor.affiliation = 'NASA Langley Research Center';
SELECT COUNT(*) FROM journal WHERE ShortName IS NULL;
SELECT COUNT(*) FROM     paper WHERE     year = 0;
SELECT MAX(paper.title) FROM     paper JOIN     paperauthor ON paper.id = paperauthor.paperid GROUP BY     paper.title ORDER BY     COUNT(paperauthor.authorid) DESC LIMIT 1;
SELECT paper.title FROM paper JOIN journal ON paper.journalid = journal.id WHERE journal.shortname = "TUBERCLE LUNG DIS" ORDER BY paper.year LIMIT 1;
SELECT paper.title FROM paperauthor JOIN author ON paperauthor.authorid = author.id JOIN paper ON paperauthor.paperid = paper.id WHERE author.name = "Karin Rengefors";
SELECT COUNT(paper.id) FROM paper JOIN conference ON paper.conferenceid = conference.id WHERE conference.fullname = 'Virtual Reality, IEEE Annual International Symposium' AND paper.year = 2012;
SELECT journal.shortname FROM journal INNER JOIN paper ON journal.id = paper.journalid WHERE paper.title = 'A Case of Unilateral Ashy Dermatosis';
SELECT paperauthor.affiliation FROM paperauthor JOIN author ON paperauthor.authorid = author.id WHERE author.name = "Mark A. Musen" UNION SELECT author.affiliation FROM author WHERE author.name = "Mark A. Musen"; 
SELECT paperauthor.name, paperauthor.affiliation FROM paperauthor JOIN paper ON paperauthor.paperid = paper.id WHERE paper.title = "Determination of Planetary Meteorology from Aerobot Flight Sensors";
SELECT paper.title, journal.fullname FROM paper JOIN journal ON paper.journalid = journal.id WHERE paper.year BETWEEN 1960 AND 1969; 
SELECT MAX(year) FROM     paper WHERE     conferenceid = (         SELECT            id         FROM             conference         WHERE             fullname = 'Internet, Multimedia Systems and Applications'     ) GROUP BY     year ORDER BY     COUNT(*) DESC LIMIT 1;
SELECT DISTINCT paperauthor.name FROM paperauthor JOIN author ON paperauthor.authorid = author.id WHERE author.name = 'Randall Davis';
SELECT DISTINCT conference.shortname, conference.fullname FROM conference JOIN paper ON paper.conferenceid = conference.id WHERE paper.year = 2008; 
SELECT MAX(journal.homepage) AS homepage_url FROM     paper JOIN     journal ON paper.journalid = journal.id GROUP BY     journal.id ORDER BY     COUNT(paper.id) DESC LIMIT 1;
SELECT COUNT(*) * 1.0 / (SELECT COUNT(*) FROM paper) AS proportion, paperauthor.name, paperauthor.affiliation FROM paperauthor JOIN paper ON paperauthor.paperid = paper.id WHERE paper.keyword = 'cancer' GROUP BY paperauthor.name, paperauthor.affiliation;
SELECT author.name FROM author WHERE author.id = 1722;
SELECT COUNT(*) FROM paper WHERE year = 0;
SELECT paperauthor.name FROM paperauthor WHERE paperauthor.affiliation = 'University of Illinois Chicago';
SELECT (SELECT COUNT(*) FROM paper WHERE year = 2005) - (SELECT COUNT(*) FROM paper WHERE year = 2004); 
SELECT paper.title FROM paper JOIN journal ON paper.journalid = journal.id WHERE journal.fullname = 'Ibm Journal of Research and Development'; 
SELECT paperauthor.name, paperauthor.affiliation FROM paperauthor JOIN paper ON paperauthor.paperid = paper.id WHERE paper.title = 'Education, democracy and growth';
SELECT COUNT(DISTINCT paperauthor.authorid) AS "Number of Authors" FROM paperauthor JOIN paper ON paperauthor.paperid = paper.id JOIN journal ON paper.journalid = journal.id WHERE journal.fullname = 'IEEE Computer';
SELECT conference.fullname FROM paper JOIN conference ON paper.conferenceid = conference.id WHERE paper.title = 'A context-based navigation paradigm for accessing Web data';
SELECT COUNT(paper.id) FROM     paper JOIN     conference ON paper.conferenceid = conference.id WHERE     conference.fullname = 'International Workshop on Inductive Logic Programming'     AND paper.year BETWEEN 2001 AND 2009;
SELECT paper.title, AVG(author_count) AS average_authors FROM paper JOIN (     SELECT paperid, COUNT(authorid) AS author_count     FROM paperauthor     WHERE paperid IN (         SELECT id FROM paper WHERE year BETWEEN 1990 AND 2000     )     GROUP BY paperid ) AS author_counts ON paper.id = author_counts.paperid WHERE paper.year BETWEEN 1990 AND 2000 GROUP BY paper.id; 
SELECT paper.year, journal.fullname FROM paper JOIN journal ON paper.journalid = journal.id WHERE paper.title = 'Area Effects in Cepaea'; 
SELECT author.name, author.affiliation FROM author JOIN paperauthor ON author.id = paperauthor.authorid JOIN paper ON paperauthor.paperid = paper.id WHERE paper.title = 'Real-Time Automata';
SELECT paperauthor.name FROM paperauthor JOIN author ON paperauthor.authorid = author.id WHERE paperauthor.affiliation = 'ABB Electrical Machines'; 
SELECT COUNT(*) FROM   paper JOIN   journal ON paper.journalid = journal.id WHERE   journal.fullname = 'Academic Medicine' AND   paper.year BETWEEN 2005 AND 2010;
SELECT paper.title FROM paper JOIN paperauthor ON paper.id = paperauthor.paperid JOIN author ON paperauthor.authorid = author.id WHERE author.name = 'Zuliang Du' AND paper.year = (     SELECT MAX(year) FROM paper ); 
SELECT COUNT(paper.id) FROM paper JOIN conference ON paper.conferenceid = conference.id WHERE conference.fullname = 'Adaptive Multimedia Retrieval' AND paper.year = 2007;
SELECT AVG(CASE WHEN journal.fullname = 'Information Sciences' THEN 1 ELSE 0 END) AS average_papers FROM paper JOIN journal ON paper.journalid = journal.id;
SELECT COUNT(*)  FROM      paperauthor  WHERE      name = 'Howard F. Lipson';
SELECT (SUM(keyword = 'Turbulent Fluids') * 100.0 / (SELECT COUNT(*) FROM paper WHERE journalid = (SELECT id FROM journal WHERE fullname = 'Physics of Fluids'))) AS percentage
SELECT COUNT(DISTINCT author.id) FROM author JOIN paperauthor ON author.id = paperauthor.authorid WHERE paperauthor.affiliation = 'Arizona State University';
SELECT conference.fullname, conference.homepage FROM conference WHERE conference.shortname = 'ICCI';
SELECT title FROM     paper JOIN     paperauthor ON paper.id = paperauthor.paperid JOIN     author ON paperauthor.authorid = author.id WHERE     author.name = 'Joe Lograsso';
SELECT COUNT(DISTINCT paper.id) FROM   paperauthor WHERE   affiliation = 'University of Hong Kong';
SELECT paper.year, paper.title FROM paper JOIN paperauthor ON paper.id = paperauthor.paperid JOIN author ON paperauthor.authorid = author.id WHERE author.name = 'Barrasa'; 
SELECT author.name, paper.year FROM paper JOIN paperauthor ON paper.id = paperauthor.paperid JOIN author ON paperauthor.authorid = author.id WHERE paper.id = 2;
SELECT author.name, paper.keyword FROM paperauthor JOIN author ON paperauthor.authorid = author.id JOIN paper ON paperauthor.paperid = paper.id WHERE paper.id = 5;
SELECT conference.fullname FROM paper JOIN conference ON paper.conferenceid = conference.id WHERE paper.title = '2004 YD5';
SELECT institution_details.chronname FROM institution_details JOIN institution_grads ON institution_details.unitid = institution_grads.unitid JOIN state_sector_grads ON institution_details.state = state_sector_grads.state JOIN state_sector_details ON institution_details.state = state_sector_details.state WHERE institution_grads.year = '2007' AND institution_grads.race = 'Ai' GROUP BY institution_details.chronname ORDER BY COUNT(institution_grads.race = 'Ai') DESC LIMIT 1;
SELECT institution_details.chronname, institution_details.site FROM institution_details JOIN institution_grads ON institution_details.unitid = institution_grads.unitid JOIN state_sector_grads ON institution_details.state = state_sector_grads.state JOIN state_sector_details ON institution_details.state = state_sector_details.state WHERE institution_grads.year = '2011' AND institution_grads.grad_cohort = 209;
SELECT SUM(institution_grads.grad_cohort) FROM institution_grads JOIN institution_details ON institution_grads.unitid = institution_details.unitid JOIN state_sector_grads ON state_sector_grads.state = institution_details.state JOIN state_sector_details ON state_sector_details.state = institution_details.state WHERE institution_details.chronname = 'Gateway Community College' AND institution_grads.year BETWEEN 2011 AND 2013 AND institution_grads.gender = 'F';
SELECT SUM(state_sector_grads.grad_100) AS total_male_graduates_2012 FROM institution_details JOIN institution_grads ON institution_details.unitid = institution_grads.unitid JOIN state_sector_grads ON institution_details.state = state_sector_grads.state JOIN state_sector_details ON state_sector_grads.stateid = state_sector_details.stateid WHERE institution_grads.gender = 'M' AND institution_grads.year = 2012 AND state_sector_details.state = (     SELECT state     FROM institution_details     GROUP BY state     ORDER BY AVG(aid_value) DESC     LIMIT 1 )
SELECT AVG(med_sat_value) AS average_median_sat_value FROM institution_details JOIN institution_grads ON institution_details.unitid = institution_grads.unitid JOIN state_sector_details ON institution_details.state = state_sector_details.state JOIN state_sector_grads ON state_sector_details.stateid = state_sector_grads.stateid AND institution_details.state = state_sector_grads.state WHERE institution_grads.year = 2013 AND institution_grads.gender = 'M' GROUP BY institution_details.state ORDER BY COUNT(institution_grads.grad_cohort) DESC LIMIT 1;
SELECT institution_details.chronname, institution_details.state FROM institution_details JOIN institution_grads ON institution_details.unitid = institution_grads.unitid JOIN state_sector_grads ON institution_details.state = state_sector_grads.state JOIN state_sector_details ON institution_details.state = state_sector_details.state WHERE institution_grads.year = 2012 AND institution_details.control = 'Private for-profit' GROUP BY institution_details.state ORDER BY SUM(institution_grads.grad_cohort) DESC LIMIT 1;
SELECT institution_details.chronname FROM institution_details JOIN state_sector_details ON institution_details.state = state_sector_details.state JOIN institution_grads ON institution_details.unitid = institution_grads.unitid JOIN state_sector_grads ON state_sector_details.state = state_sector_grads.state WHERE institution_details.control = 'Public' AND institution_grads.year = 2013 GROUP BY institution_details.chronname ORDER BY MIN(state_sector_grads.grad_cohort) LIMIT 1;
SELECT institution_details.chronname, institution_details.fte_value FROM institution_details JOIN institution_grads ON institution_details.unitid = institution_grads.unitid WHERE institution_grads.cohort = 2013 AND institution_grads.race = 'X' AND institution_grads.gender = 'B' AND institution_grads.grad_cohort < 200;
SELECT COUNT(*) FROM     institution_grads WHERE     unitid IN (SELECT unitid FROM institution_details WHERE chronname = 'Oakwood University')     AND year = 2013     AND gender = 'F'     AND race = 'X';
SELECT COUNT(*) FROM     institution_grads JOIN     institution_details ON institution_grads.unitid = institution_details.unitid WHERE     institution_grads.year = 2012     AND institution_grads.gender = 'F'     AND institution_grads.race = 'A'     AND institution_grads.cohort = '4y other'     AND institution_details.chronname = 'University of Alaska at Anchorage';
SELECT unitid, year, grad_cohort, grad_100, grad_150, grad_100_rate, grad_150_rate FROM institution_grads WHERE unitid = (SELECT unitid FROM institution_details WHERE chronname = 'Auburn University') AND year IN (2011, 2012, 2013) AND gender = 'B' AND race = 'X' AND cohort IN ('4y other', '4y bach'); 
SELECT 100.0 * SUM(CASE WHEN institution_details.control = 'Private for-profit' AND institution_grads.race = 'B' THEN 1 ELSE 0 END) / SUM(CASE WHEN institution_details.control = 'Private for-profit' THEN institution_grads.grad_cohort ELSE 0 END) FROM institution_grads JOIN institution_details ON institution_grads.unitid = institution_details.unitid;
SELECT SUM(CASE WHEN race = 'A' THEN 1 ELSE 0 END) * 100.0 / SUM(grad_cohort) FROM institution_grads JOIN institution_details ON institution_grads.unitid = institution_details.unitid WHERE institution_details.state = 'Alabama' AND institution_grads.year = 2013 AND grad_100_rate = 100;
SELECT SUM(CASE WHEN gender = 'M' THEN grad_cohort ELSE 0 END) / SUM(CASE WHEN gender = 'F' THEN grad_cohort ELSE 0 END) * 1.0 AS ratio FROM institution_grads JOIN institution_details ON institution_grads.unitid = institution_details.unitid WHERE institution_details.chronname = 'Harvard University' AND institution_grads.year = 2013 AND institution_grads.race = 'A';
SELECT MIN(grad_100_value) FROM institution_details JOIN institution_grads ON institution_details.unitid = institution_grads.unitid WHERE chronname IN ('Amridge University', 'Auburn University') GROUP BY chronname;
SELECT COUNT(*) FROM institution_details WHERE control = 'Private not-for-profit';
SELECT COUNT(*) FROM institution_grads WHERE unitid IN (     SELECT unitid     FROM institution_details     WHERE chronname = 'Amridge University' ) AND gender = 'M' AND race = 'H';
SELECT COUNT(institution_grads.unitid) AS num_students FROM     institution_grads JOIN     institution_details ON institution_grads.unitid = institution_details.unitid WHERE     institution_details.chronname = 'Lincoln College'     AND institution_grads.year = 2011     AND institution_grads.cohort = '4y bach';
SELECT COUNT(*) FROM     institution_grads JOIN     institution_details ON institution_grads.unitid = institution_details.unitid WHERE     institution_details.chronname = 'Central Alabama Community College'     AND institution_grads.year = 2011     AND institution_grads.gender = 'M'     AND institution_grads.race = 'H'     AND institution_grads.grad_100 = 1;
SELECT SUM(institution_grads.grad_cohort) AS total_graduates FROM institution_grads JOIN institution_details ON institution_grads.unitid = institution_details.unitid WHERE institution_details.chronname = 'Central Alabama Community College' AND institution_grads.year = 2011;
SELECT SUM(CASE WHEN gender = 'F' THEN grad_150 ELSE 0 END) AS female, SUM(CASE WHEN gender = 'M' THEN grad_150 ELSE 0 END) AS male FROM institution_grads JOIN institution_details ON institution_grads.unitid = institution_details.unitid WHERE institution_details.chronname = 'Central Alabama Community College' AND institution_grads.year = 2011 AND institution_grads.race = 'w';
SELECT institution_details.chronname FROM institution_details JOIN institution_grads ON institution_details.unitid = institution_grads.unitid WHERE institution_grads.year = 2011 AND institution_grads.gender = 'M' AND institution_grads.race = 'w' ORDER BY institution_grads.grad_150_rate DESC LIMIT 1;
SELECT institution_details.chronname FROM institution_details JOIN institution_grads ON institution_details.unitid = institution_grads.unitid WHERE institution_grads.year = 2011 AND institution_grads.gender = 'M' AND institution_grads.race = 'w' AND institution_grads.grad_150 > 20; 
SELECT SUM(ig.grad_100 + ig.grad_150) AS total_students FROM institution_grads AS ig JOIN institution_details AS id ON ig.unitid = id.unitid JOIN state_sector_details AS ssd ON id.state = ssd.state JOIN state_sector_grads AS ssg ON ssd.stateid = ssg.stateid AND ssg.state = id.state WHERE id.state = 'Alabama'  AND ig.year = 2011  AND ig.cohort = '2y all'  AND ssg.gender = 'B';
SELECT SUM(grad_cohort) FROM institution_grads WHERE unitid = (     SELECT unitid     FROM institution_details     WHERE chronname = 'Central Alabama Community College' ) AND year = 2012  -   SELECT SUM(grad_cohort) FROM institution_grads WHERE unitid = (     SELECT unitid     FROM institution_details     WHERE chronname = 'Central Alabama Community College' ) AND year = 2011;
SELECT COUNT(*) FROM     institution_details JOIN     institution_grads ON institution_details.unitid = institution_grads.unitid JOIN     state_sector_details ON institution_details.state = state_sector_details.state JOIN     state_sector_grads ON state_sector_details.stateid = state_sector_grads.stateid AND state_sector_details.state = state_sector_grads.state WHERE     institution_details.state = 'Alabama'     AND med_sat_percentile = 77     AND grad_cohort > 500     AND year = 2011;
SELECT COUNT(*) FROM   institution_details WHERE   control = 'Public'   AND state = 'Alabama'   AND grad_100 > 30   AND year = 2011;
SELECT institution_details.chronname FROM institution_details JOIN institution_grads ON institution_details.unitid = institution_grads.unitid WHERE institution_details.state = 'AL' AND institution_grads.year = 2011 AND institution_grads.race = 'X' GROUP BY institution_details.unitid HAVING SUM(institution_grads.grad_cohort) > 500;
SELECT AVG(grad_cohort) FROM institution_grads JOIN institution_details ON institution_grads.unitid = institution_details.unitid WHERE chronname = 'Central Alabama Community College' AND year BETWEEN 2011 AND 2013; 
SELECT AVG(grad_100_rate)  FROM      institution_grads  WHERE      unitid IN (SELECT unitid FROM institution_details WHERE chronname = 'Central Alabama Community College');
SELECT site FROM institution_details WHERE chronname = 'Swarthmore College';
SELECT institution_details.state FROM institution_details WHERE institution_details.chronname = 'Mercer University';
SELECT city FROM institution_details WHERE chronname = 'Rensselaer Polytechnic Institute';
SELECT state_sector_details.state_post FROM state_sector_details WHERE state_sector_details.state = "Delaware";
SELECT COUNT(*) FROM institution_details WHERE level = '2-year' AND control = 'public' AND state = 'California';
SELECT state_post FROM state_sector_details WHERE state = 'Idaho';
SELECT institution_details.chronname FROM institution_details JOIN state_sector_details ON institution_details.state = state_sector_details.state WHERE institution_details.state = 'NJ' AND institution_details.level = '4-year' AND institution_details.student_count = (     SELECT MAX(student_count)     FROM institution_details     WHERE state = 'NJ'     AND level = '4-year' )
SELECT `site`  FROM      institution_details  WHERE      state_abbr = 'PA'  ORDER BY      lat_y DESC  LIMIT 1;
SELECT COUNT(institution_details.unitid) FROM institution_details JOIN state_sector_details ON institution_details.state = state_sector_details.state JOIN state_sector_grads ON state_sector_details.stateid = state_sector_grads.stateid AND institution_details.state = state_sector_grads.state WHERE institution_details.level = '4-year'  AND institution_details.control = 'Public'  AND institution_details.state = 'UT'  AND institution_details.awards_per_value > state_sector_details.awards_per_state_value;
SELECT COUNT(*) FROM institution_details JOIN state_sector_details ON institution_details.state = state_sector_details.state JOIN institution_grads ON institution_details.unitid = institution_grads.unitid JOIN state_sector_grads ON institution_details.state = state_sector_grads.state WHERE institution_details.level = '2-year' AND institution_details.control = 'Private not-for-profit' AND institution_details.state = 'CT' AND institution_grads.grad_100_rate < state_sector_details.grad_rate_rank;
SELECT institution_details.chronname FROM institution_details JOIN state_sector_details ON institution_details.state = state_sector_details.state JOIN state_sector_grads ON state_sector_details.stateid = state_sector_grads.stateid AND institution_details.state = state_sector_grads.state JOIN institution_grads ON institution_details.unitid = institution_grads.unitid WHERE institution_details.state_abbr = 'ID' AND institution_details.control = 'Public' AND institution_details.level = '4-year' AND institution_grads.grad_100_value = (     SELECT MIN(grad_100_value)     FROM institution_grads     JOIN institution_details ON institution_grads.unitid = institution_details.unitid     WHERE institution_details.state_abbr = 'ID'     AND institution_details.control = 'Public'     AND institution_details.level = '4-year' );
SELECT institution_details.unitid FROM institution_details WHERE institution_details.state = 'KY' AND institution_details.level = '4-year' AND institution_details.control = 'Private for-profit' ORDER BY institution_details.grad_150_value DESC LIMIT 1;
SELECT COUNT(*) FROM     institution_grads JOIN     institution_details ON institution_grads.unitid = institution_details.unitid WHERE     institution_details.chronname = 'Pennsylvania State University-Altoona'     AND institution_grads.gender = 'F'     AND institution_grads.race = 'H'     AND institution_grads.grad_100 = 1;
SELECT cohort FROM institution_details WHERE cohort_size = (SELECT MAX(cohort_size) FROM institution_details);
SELECT COUNT(*) FROM   institution_details WHERE   chronname = 'Brevard Community College'   AND level = '4-year'   AND control = 'Private not-for-profit'   AND state = (     SELECT      state     FROM       institution_details     WHERE       chronname = 'Brevard Community College'   )
SELECT SUM(institution_grads.grad_cohort) FROM     institution_grads JOIN     institution_details ON institution_grads.unitid = institution_details.unitid JOIN     state_sector_grads ON state_sector_grads.state = institution_details.state JOIN     state_sector_details ON state_sector_details.state = institution_details.state WHERE     institution_details.level = '2-year'     AND institution_details.control = 'Public'     AND institution_details.state = 'Alabama'     AND institution_grads.year = '2011'     AND institution_grads.race = 'X';
SELECT SUM(state_sector_grads.grad_100) FROM state_sector_grads JOIN state_sector_details ON state_sector_grads.stateid = state_sector_details.stateid WHERE state_sector_details.schools_count = 113 AND state_sector_details.level = '2-year' AND state_sector_details.control = 'public' AND state_sector_grads.race = 'A' AND state_sector_grads.cohort = '2y all' AND state_sector_grads.year = 2013;
SELECT 100 * (     SELECT COUNT(*)     FROM institution_details     WHERE level = '4-year' AND control = 'Public' AND state = (         SELECT state         FROM institution_details         WHERE chronname = 'Madison Area Technical College'     ) AND state = 'Alabama' ) / (     SELECT COUNT(*)     FROM institution_details     WHERE level = '4-year' AND control = 'Public' AND state = (         SELECT state         FROM institution_details         WHERE chronname = 'Madison Area Technical College'     ) );
SELECT institution_details.state, institution_details.chronname FROM institution_details JOIN institution_grads ON institution_details.unitid = institution_grads.unitid JOIN state_sector_grads ON institution_details.state = state_sector_grads.state AND institution_grads.year = state_sector_grads.year WHERE institution_grads.year BETWEEN 2010 AND 2012 AND institution_grads.race = 'B';
SELECT state FROM institution_details INNER JOIN state_sector_details ON institution_details.state = state_sector_details.state WHERE year = '2011' AND awards_per_natl_value < 20;
SELECT control, level FROM institution_details WHERE race = 'X' ORDER BY student_count DESC LIMIT 1;
SELECT race FROM state_sector_grads JOIN state_sector_details ON state_sector_grads.stateid = state_sector_details.stateid JOIN institution_details ON state_sector_details.state = institution_details.state WHERE institution_details.control = 'Public' AND state_sector_details.schools_count < 20;
SELECT basic FROM institution_details INNER JOIN institution_grads ON institution_details.unitid = institution_grads.unitid WHERE institution_grads.year = '2012' AND institution_grads.gender = 'M' AND institution_grads.race = 'X';
SELECT SUM(state_sector_grads.grad_cohort_ct) AS white_students_count FROM state_sector_grads JOIN institution_details ON state_sector_grads.state = institution_details.state JOIN institution_grads ON institution_details.unitid = institution_grads.unitid WHERE institution_details.state = 'Alaska' AND institution_details.schools_count = 1 AND state_sector_grads.year BETWEEN '2011' AND '2013' AND institution_grads.race = 'W';
SELECT institution_details.chronname AS institution_name FROM institution_details JOIN institution_grads ON institution_details.unitid = institution_grads.unitid WHERE institution_grads.race = 'Ai' AND institution_grads.grad_cohort <= 3;
SELECT COUNT(institution_grads.grad_cohort) AS cohort_count FROM institution_grads JOIN institution_details ON institution_grads.unitid = institution_details.unitid JOIN state_sector_grads ON institution_details.state = state_sector_grads.state JOIN state_sector_details ON state_sector_grads.state = state_sector_details.state WHERE institution_details.state LIKE 'A%' AND state_sector_details.awards_per_natl_value = 16.5 AND institution_grads.year = '2012';
SELECT institution_details.site FROM institution_details INNER JOIN institution_grads ON institution_details.unitid = institution_grads.unitid WHERE institution_details.student_count BETWEEN 500 AND 1000 AND institution_grads.year = (SELECT MAX(year) FROM institution_grads)
SELECT institution_details.state FROM institution_grads JOIN institution_details ON institution_grads.unitid = institution_details.unitid WHERE institution_grads.gender = 'M' AND institution_grads.year = '2011' AND institution_details.control = 'Private for-profit' AND institution_grads.race = 'B';
SELECT institution_details.site, institution_details.chronname FROM institution_details JOIN institution_grads ON institution_details.unitid = institution_grads.unitid WHERE institution_grads.race = 'B' AND institution_grads.year = '2011' AND institution_grads.grad_cohort BETWEEN 20 AND 30;
SELECT COUNT(institution_grads.unitid) AS female_students_count FROM institution_grads JOIN institution_details ON institution_grads.unitid = institution_details.unitid JOIN state_sector_details ON institution_details.state = state_sector_details.state JOIN state_sector_grads ON state_sector_details.stateid = state_sector_grads.stateid WHERE institution_grads.gender = 'F' AND institution_grads.year = 2012 AND state_sector_details.schools_count BETWEEN 10 AND 20;
SELECT race FROM institution_details WHERE state = 'Alabama' AND student_count > (SELECT 0.9 * AVG(student_count) FROM institution_details);
SELECT 100.0 * SUM(CASE WHEN level = '2-year' THEN 1 ELSE 0 END) / COUNT(*) AS percentage_of_associates_degrees FROM institution_details WHERE state = 'Hawaii' AND year = 2010;
SELECT institution_details.chronname FROM institution_details JOIN state_sector_details ON institution_details.state = state_sector_details.state JOIN institution_grads ON institution_details.unitid = institution_grads.unitid JOIN state_sector_grads ON institution_details.state = state_sector_grads.state WHERE state_sector_details.state = "Connecticut" AND institution_details.ft_fac_percentile = (     SELECT MAX(ft_fac_percentile)     FROM institution_details     JOIN state_sector_details ON institution_details.state = state_sector_details.state     WHERE state_sector_details.state = "Connecticut" )
SELECT MAX(institution_details.site) AS website_address FROM institution_details JOIN institution_grads ON institution_details.unitid = institution_grads.unitid WHERE institution_grads.gender = 'W' AND institution_grads.race = 'W' AND institution_grads.cohort = '2y all' AND institution_grads.year = '2008';
SELECT MAX(year) FROM     institution_grads JOIN     institution_details ON institution_grads.unitid = institution_details.unitid WHERE     chronname = 'Harvard University';
SELECT institution_details.chronname FROM institution_details JOIN state_sector_details ON institution_details.state = state_sector_details.state WHERE state_sector_details.state_appr_value = (     SELECT MAX(state_appr_value)      FROM state_sector_details      WHERE year = 2011 ) AND institution_details.student_count = (     SELECT MIN(student_count)      FROM institution_details      WHERE year = 2010 )
SELECT AVG(CASE WHEN institution_details.chronname = 'Yale University' AND institution_grads.race = 'B' AND institution_grads.cohort = '4y bach' AND institution_grads.year BETWEEN 2002 AND 2005 THEN 1 ELSE 0 END) AS average_black_students_per_year;
SELECT institution_details.chronname, MAX(institution_grads.grad_cohort) AS max_hispanic_graduates FROM institution_details JOIN institution_grads ON institution_details.unitid = institution_grads.unitid WHERE institution_details.chronname IN ('Brown University', 'Columbia University', 'Cornell University', 'Dartmouth College', 'Harvard University', 'Princeton University', 'University of Pennsylvania', 'Yale University') AND institution_grads.race = 'H' GROUP BY institution_details.chronname ORDER BY max_hispanic_graduates DESC LIMIT 1;
SELECT institution_details.chronname FROM institution_details JOIN state_sector_details ON institution_details.state = state_sector_details.state WHERE institution_details.level = '4-year' AND institution_details.control = 'Public' AND institution_details.state = 'FL';
SELECT MIN(state_appr_value) AS lowest_state_appropriations FROM   institution_details JOIN   state_sector_details ON institution_details.state = state_sector_details.state WHERE   chronname IN ('Brown University', 'Columbia University', 'Cornell University', 'Dartmouth College', 'Harvard University', 'Princeton University', 'University of Pennsylvania', 'Yale University') AND   state_sector_details.state_post IS NOT NULL AND   year = 2011;
SELECT COUNT(institution_details.chronname) FROM institution_details JOIN state_sector_details ON institution_details.state = state_sector_details.state WHERE institution_details.ft_pct >= 90 AND state_sector_details.schools_count = (     SELECT MAX(schools_count) FROM state_sector_details )
SELECT AVG(institution_details.med_sat_value) FROM institution_details JOIN state_sector_details ON institution_details.state = state_sector_details.state WHERE state_sector_details.state_appr_value = (SELECT MIN(state_appr_value) FROM state_sector_details WHERE year = 2011)
SELECT MAX(institution_details.chronname) AS school_name FROM institution_grads JOIN institution_details ON institution_grads.unitid = institution_details.unitid WHERE institution_grads.gender = 'F' AND institution_grads.cohort != '4y other' AND institution_grads.grad_cohort = (     SELECT MAX(grad_cohort)     FROM institution_grads     WHERE gender = 'F'     AND cohort != '4y other' )
SELECT institution_details.chronname, MAX(institution_grads.grad_150) AS max_grad_150 FROM institution_details JOIN institution_grads ON institution_details.unitid = institution_grads.unitid WHERE institution_details.chronname IN ('Brown University', 'Columbia University', 'Cornell University', 'Dartmouth College', 'Harvard University', 'Princeton University', 'University of Pennsylvania', 'Yale University') AND institution_grads.year = '2013' AND institution_grads.race = 'B' AND institution_grads.cohort = '4y bach' GROUP BY institution_details.chronname ORDER BY max_grad_150 DESC;
SELECT AVG(institution_grads.grad_150) FROM institution_grads JOIN institution_details ON institution_grads.unitid = institution_details.unitid WHERE institution_details.chronname = 'United Education Institute-Huntington Park Campus' AND institution_details.level = '2-year' AND institution_grads.year BETWEEN '2011' AND '2013' AND institution_grads.gender = 'M' AND institution_grads.race = 'H';
SELECT institution_details.chronname AS school_name, state_sector_details.state_appr_value FROM institution_details JOIN state_sector_details ON institution_details.state = state_sector_details.state WHERE awards_per_value - awards_per_natl_value = (     SELECT MAX(awards_per_value - awards_per_natl_value)     FROM institution_details );
SELECT COUNT(*) FROM business WHERE state = 'AZ' AND stars < 3;
SELECT COUNT(*) FROM business WHERE state = 'AZ' AND active = 'False';
SELECT COUNT(reviews.review_id) FROM reviews WHERE reviews.user_id = 36139 AND reviews.review_length = 'long';
SELECT COUNT(*) FROM users WHERE user_fans = 'uber';
SELECT COUNT(business_id) FROM business_attributes WHERE attribute_id IN (     SELECT attribute_id     FROM attributes     WHERE attribute_name = 'Open 24 Hours' ) AND attribute_value = 'true';
SELECT business_attributes.attribute_value FROM business_attributes JOIN attributes ON business_attributes.attribute_id = attributes.attribute_id JOIN business ON business_attributes.business_id = business.business_id WHERE business.business_id = '10172' AND attributes.attribute_name = 'Wi-Fi';
SELECT COUNT(*)  FROM business_categories  JOIN categories ON business_categories.category_id = categories.category_id  WHERE categories.category_name = 'Bars';
SELECT COUNT(*) AS buffet_gym_difference FROM business_categories WHERE category_id IN (     SELECT category_id FROM categories WHERE category_name = 'Buffets' )  -  (     SELECT COUNT(*)     FROM business_categories     WHERE category_id IN (         SELECT category_id FROM categories WHERE category_name = 'Gyms'     ) );
SELECT categories.category_name FROM     categories JOIN     business_categories ON categories.category_id = business_categories.category_id JOIN     reviews ON business_categories.business_id = reviews.business_id WHERE     reviews.review_stars = 5 GROUP BY     categories.category_name ORDER BY     COUNT(*) DESC LIMIT 1; 
SELECT MAX(actual_year) FROM     years JOIN     users ON years.year_id = users.user_yelping_since_year JOIN     reviews ON users.user_id = reviews.user_id WHERE     review_stars = 5 GROUP BY     users.user_id ORDER BY     COUNT(*) DESC LIMIT 1;
SELECT MAX(number_of_long_reviews) as max_long_reviews, AVG(review_stars) as average_ratings FROM (     SELECT user_id, COUNT(*) as number_of_long_reviews     FROM reviews     WHERE review_length = 'long'     GROUP BY user_id ) as long_reviews;
SELECT business_categories.category_id FROM business_categories JOIN business ON business_categories.business_id = business.business_id JOIN reviews ON business.business_id = reviews.business_id WHERE reviews.review_length = 'long' GROUP BY business_categories.category_id ORDER BY COUNT(reviews.review_length = 'long') DESC LIMIT 1;
SELECT business_categories.category_id FROM business JOIN tips ON business.business_id = tips.business_id JOIN business_categories ON business.business_id = business_categories.business_id WHERE tips.tip_length = 'short' GROUP BY business.business_id ORDER BY COUNT(tips.tip_length = 'short') DESC LIMIT 1; 
SELECT MAX(user_yelping_since_year) FROM (     SELECT        user_yelping_since_year,         COUNT(*) AS short_tip_count     FROM         tips     WHERE         tip_length = 'Short'     GROUP BY         user_id ) AS tip_counts;
SELECT categories.category_name FROM tips JOIN business ON tips.business_id = business.business_id JOIN categories ON business.business_id = categories.business_id WHERE tips.user_id = 70271 AND tips.tip_length = 'short' LIMIT 1;
SELECT business.stars FROM tips JOIN business ON tips.business_id = business.business_id WHERE tips.user_id = 69722 AND tips.tip_length = 'short' LIMIT 1;
SELECT (MULTIPLY(DIVIDE((SELECT COUNT(*) FROM business_categories WHERE category_id = (SELECT category_id FROM categories WHERE category_name = 'Automotive')), (SELECT COUNT(*) FROM business)), 1.0)) AS percentage 
SELECT 100 * (     (SELECT COUNT(*) FROM business_categories WHERE category_id = (SELECT category_id FROM categories WHERE category_name = 'Women''s Clothing')) -      (SELECT COUNT(*) FROM business_categories WHERE category_id = (SELECT category_id FROM categories WHERE category_name = 'Men''s Clothing')) ) / (SELECT COUNT(*) FROM business_categories WHERE category_id = (SELECT category_id FROM categories WHERE category_name = 'Men''s Clothing'));
SELECT COUNT(user_id) FROM users WHERE user_yelping_since_year >= 2004;
SELECT COUNT(*) FROM users WHERE user_yelping_since_year = 2005 AND user_fans = 'None';
SELECT COUNT(*) FROM business WHERE city = 'Tolleson' AND active = 'TRUE';
SELECT COUNT(*) FROM reviews WHERE user_id = '21679';
SELECT COUNT(*) FROM reviews WHERE business_id = '10682' AND review_stars = 5;
SELECT business_id FROM business WHERE city = 'Sun City' AND active = 'False' GROUP BY business_id ORDER BY COUNT(user_id) DESC LIMIT 1;
SELECT COUNT(reviews.review_id) FROM     reviews JOIN     business ON reviews.business_id = business.business_id WHERE     business.city = 'Yuma'     AND reviews.review_length = 'Medium';
SELECT CASE     WHEN ba.attribute_value = 'Yes' THEN 1     ELSE 0 END AS has_tv FROM business_attributes AS ba JOIN attributes AS a ON ba.attribute_id = a.attribute_id WHERE ba.business_id = '4960' AND a.attribute_name = 'Has TV'; 
SELECT COUNT(DISTINCT business.business_id) FROM business_attributes JOIN attributes ON business_attributes.attribute_id = attributes.attribute_id JOIN business ON business_attributes.business_id = business.business_id WHERE attributes.attribute_name = 'Dogs Allowed' AND business_attributes.attribute_value = 'true';
SELECT COUNT(business_hours.closing_time - business_hours.opening_time) AS Saturday_open_hours FROM business_hours JOIN days ON business_hours.day_id = days.day_id WHERE business_hours.business_id = "5734" AND days.day_of_week = 'Saturday';
SELECT COUNT(*) FROM business_categories JOIN categories ON business_categories.category_id = categories.category_id WHERE categories.category_name = 'Hair Removal';
SELECT ABS(     (SELECT COUNT(*) FROM business_categories WHERE category_id = (SELECT category_id FROM categories WHERE category_name = 'Chinese')) -     (SELECT COUNT(*) FROM business_categories WHERE category_id = (SELECT category_id FROM categories WHERE category_name = 'Filipino')) ) AS difference 
SELECT business.city FROM tips JOIN business ON tips.business_id = business.business_id WHERE tips.user_id = '63469' AND tips.likes = 1;
SELECT COUNT(DISTINCT attribute_name) AS num_music_types FROM business_attributes WHERE business_id = "1141" AND attribute_name LIKE '%music%' AND attribute_value = 'true';
SELECT COUNT(*) FROM     users_compliments WHERE     user_id = 57400     AND compliment_id IN (SELECT compliment_id FROM compliments WHERE compliment_type = 'cute');
SELECT users.user_id FROM     users_compliments JOIN     compliments ON users_compliments.compliment_id = compliments.compliment_id WHERE     compliments.compliment_type = 'funny' GROUP BY     users_compliments.user_id ORDER BY     COUNT(users_compliments.number_of_compliments) DESC LIMIT 1;
SELECT COUNT(DISTINCT business.business_id) FROM business JOIN business_attributes ON business.business_id = business_attributes.business_id JOIN attributes ON business_attributes.attribute_id = attributes.attribute_id WHERE attributes.attribute_name = 'Drive-Thru' AND attributes.attribute_value = 'true' AND business.city = 'Scottsdale' AND business.business_id < 1000;
SELECT AVG(b.stars) AS average_rating FROM business AS b JOIN business_attributes AS ba ON b.business_id = ba.business_id WHERE ba.attribute_id IN (SELECT attribute_id FROM attributes WHERE attribute_name = 'Open 24 Hours') AND ba.attribute_value = 'true';
SELECT 100.0 * SUM(city = 'Phoenix') / COUNT(business_id) FROM business_attributes WHERE attribute_name = 'BYOB' AND attribute_value = 'TRUE';
SELECT business.business_id FROM business WHERE business.state = 'AZ' AND business.stars = 5;
SELECT COUNT(*) FROM business WHERE active = 'true' AND review_count = 'Low' AND city = 'city';
SELECT COUNT(u.user_id) FROM users u LEFT JOIN (     SELECT user_id     FROM users     WHERE user_fans = 'None' ) nf ON u.user_id = nf.user_id LEFT JOIN (     SELECT user_id     FROM users     WHERE user_review_count = 'Low' ) lr ON u.user_id = lr.user_id WHERE u.user_id BETWEEN 1 AND 20 AND nf.user_id IS NOT NULL AND lr.user_id IS NOT NULL;
SELECT business_hours.opening_time FROM business_hours JOIN business_categories ON business_hours.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id WHERE categories.category_name = 'fashion';
SELECT COUNT(DISTINCT business.business_id) FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id JOIN business_hours ON business.business_id = business_hours.business_id WHERE categories.category_name = 'Shopping' AND substr(business_hours.opening_time, 1, 2) < '08';
SELECT business.business_id FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id JOIN business_hours ON business.business_id = business_hours.business_id WHERE categories.category_name = 'pets' AND business_hours.closing_time > '9:00PM';
SELECT COUNT(DISTINCT business.business_id) FROM     business JOIN     business_categories ON business.business_id = business_categories.business_id JOIN     business_hours ON business.business_id = business_hours.business_id JOIN     days ON business_hours.day_id = days.day_id WHERE     business_hours.opening_time IS NOT NULL     AND business_hours.closing_time IS NOT NULL     AND days.day_of_week BETWEEN 'Monday' AND 'Thursday'     AND business_categories.category_id = <desired_category_id>;
SELECT COUNT(reviews.review_id) FROM     business JOIN     business_categories ON business.business_id = business_categories.business_id JOIN     categories ON business_categories.category_id = categories.category_id JOIN     reviews ON business.business_id = reviews.business_id WHERE     categories.category_name = 'Active Life'     AND business.city = 'Phoenix';
SELECT business.business_id FROM business JOIN business_categories ON business.business_id = business_categories.business_id WHERE business.stars < 5 AND business_categories.category_id = (     SELECT category_id FROM categories WHERE category_name = "men's clothing" );
SELECT business_id FROM business WHERE active = 'False' AND review_votes_useful = 'Low';
SELECT business.business_id, business.business_name FROM business JOIN reviews ON business.business_id = reviews.business_id WHERE reviews.review_length = 'Long' AND business.business_id BETWEEN 1 AND 20;
SELECT business_attributes.attribute_value FROM business_attributes JOIN business_categories ON business_attributes.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id JOIN business ON business_attributes.business_id = business.business_id WHERE categories.category_name = 'Fashion' AND business.city = 'Scottsdale';
SELECT COUNT(users_compliments.compliment_id) FROM users_compliments JOIN users ON users_compliments.user_id = users.user_id JOIN business ON users.user_id = business.business_id WHERE users_compliments.number_of_compliments = 'Medium' AND business.city = 'Phoenix';
SELECT business.business_id, business.business_name FROM business INNER JOIN business_hours ON business.business_id = business_hours.business_id WHERE business.city = 'Tempe' AND business_hours.opening_time < '8:00AM';
SELECT COUNT(business.business_id) FROM business JOIN business_hours ON business.business_id = business_hours.business_id WHERE business.city = 'Glendale' AND business.active = 'true' AND business_hours.opening_time = '8AM' AND business_hours.closing_time = '6PM';
SELECT COUNT(business_id) AS phoenix_business_count, ROUND((COUNT(business_id) * 100.0) / (SELECT COUNT(business_id) FROM business), 2) AS phoenix_business_percentage FROM business WHERE city = 'Phoenix';
SELECT COUNT(DISTINCT business.city) AS city_count, ROUND(     (         SUM(             CASE                  WHEN business_categories.category_id = (                     SELECT category_id                      FROM categories                      WHERE category_name = 'Active Life'                 )                  THEN 1                  ELSE 0              END         )          /          (             SELECT COUNT(*)              FROM business              WHERE business_categories.business_id = business.business_id         )     )      *     (         SUM(             CASE                  WHEN business.review_count <= (                     SELECT AVG(review_count)                      FROM business                 )                  THEN 1                  ELSE 0              END         )          /         (             SELECT COUNT(*)              FROM business              WHERE business_categories.business_id = business.business_id         )     )      * 100.0,      2 ) AS low_review_percentage FROM business JOIN business_categories ON business.business_id = business_categories.business_id;
SELECT COUNT(*) FROM business WHERE city = 'Phoenix' AND active = 'true';
SELECT COUNT(DISTINCT business.business_id) FROM     business JOIN     reviews ON business.business_id = reviews.business_id WHERE     business.city = 'Scottsdale'     AND reviews.review_stars > 3;
SELECT AVG(stars) AS average_rating_of_inactive_businesses FROM business WHERE active = 'False'; 
SELECT COUNT(business_id) FROM business_attributes JOIN business ON business_attributes.business_id = business.business_id WHERE business.state = 'AZ' AND business_attributes.attribute_value = 'beer_and_wine';
SELECT city FROM (     SELECT        city,         COUNT(DISTINCT business_id) AS num_businesses     FROM         business_attributes ba     JOIN         business b ON ba.business_id = b.business_id     WHERE         ba.attribute_value = 'full_bar'     GROUP BY         city     ORDER BY         num_businesses DESC     LIMIT 1 ) 
SELECT COUNT(b.business_id) FROM business b JOIN business_categories bc ON b.business_id = bc.business_id WHERE bc.category_id = (     SELECT category_id FROM categories WHERE category_name = 'Fashion' ) AND b.stars = 5;
SELECT MAX(b.city) FROM business AS b JOIN business_categories AS bc ON b.business_id = bc.business_id JOIN categories AS c ON bc.category_id = c.category_id WHERE c.category_name = 'Food' AND b.review_count = 'High';
SELECT business.business_id FROM business WHERE business.city = 'Mesa' AND reviews.review_stars > 3;
SELECT city FROM business WHERE business_id IN (     SELECT    business_id     FROM     reviews     WHERE     review_votes_funny = 'Low' ) GROUP BY city ORDER BY COUNT(*) ASC LIMIT 1; 
SELECT 100.0 * (     SELECT         COUNT(b.business_id)      FROM          business AS b          JOIN business_categories AS bc ON b.business_id = bc.business_id      WHERE          bc.category_id = (             SELECT                 category_id              FROM                  categories              WHERE                  category_name = 'Real Estate'         )          AND          b.stars = 5          AND          b.city = 'Chandler' ) / (     SELECT         COUNT(business_id)      FROM          business      WHERE          city = 'Chandler' );
SELECT COUNT(users.user_id) FROM     users WHERE     users.user_yelping_since_year = '2012'     AND users.user_votes_funny = 'High';
SELECT SUM(review_votes_useful) AS useful_votes_received FROM reviews WHERE user_id = 52592 AND business_id = 2;
SELECT attribute_id FROM attributes WHERE attribute_name LIKE '%payment%';
SELECT review_length FROM reviews WHERE business_id = 2 AND user_id = 612;
SELECT COUNT(*) FROM business WHERE city = 'Gilbert' AND active = 'true';
SELECT COUNT(*) FROM business WHERE state = 'AZ' AND review_count = 'low';
SELECT business.business_id FROM business JOIN reviews ON business.business_id = reviews.business_id WHERE business.state = 'AZ' AND reviews.review_stars = 5 LIMIT 3;
SELECT attribute_name FROM     attributes WHERE     attribute_id NOT IN (         SELECT            attribute_id         FROM             business_attributes         WHERE             business_id = 2             AND attribute_value = 'none'     );
SELECT COUNT(*) FROM     compliments WHERE     compliment_type = 'cool'     AND user_id = 33;
SELECT business_hours.opening_time FROM business_hours JOIN days ON business_hours.day_id = days.day_id WHERE business_hours.business_id = 53 AND days.day_of_week = 'Friday';
SELECT attributes.attribute_name FROM business_attributes JOIN attributes ON business_attributes.attribute_id = attributes.attribute_id WHERE business_attributes.business_id = 56 AND business_attributes.attribute_value = 'true';
SELECT categories.category_name FROM business_categories JOIN categories ON business_categories.category_id = categories.category_id WHERE business_categories.business_id = 15;
SELECT COUNT(business.business_id) FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id WHERE business.city = 'Scottsdale' AND categories.category_name = 'Beauty & Spas';
SELECT users.user_id FROM users_compliments JOIN users ON users_compliments.user_id = users.user_id JOIN compliments ON users_compliments.compliment_id = compliments.compliment_id WHERE compliments.compliment_type = 'cute' AND users_compliments.number_of_compliments = 'Uber' LIMIT 2;
SELECT COUNT(DISTINCT business.business_id) FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id JOIN reviews ON business.business_id = reviews.business_id JOIN compliments ON reviews.user_id = compliments.user_id WHERE categories.category_name = 'Accessories' AND reviews.review_stars > 3 AND compliments.compliment_type = 'wonderful experience';
SELECT opening_time, closing_time FROM business_hours WHERE business_id = 12 AND day_id = 3 AND city = 'Scottsdale';
SELECT COUNT(DISTINCT business.business_id) FROM business LEFT JOIN business_hours ON business.business_id = business_hours.business_id LEFT JOIN days ON business_hours.day_id = days.day_id WHERE business.state = 'AZ' AND (days.day_of_week = 'Thursday' AND business_hours.label_time_4 = 'None');
SELECT COUNT(*) FROM business WHERE city = 'Scottsdale';
SELECT COUNT(*) FROM business WHERE state = 'AZ' AND active = 'true';
SELECT COUNT(DISTINCT business.business_id) FROM business JOIN reviews ON business.business_id = reviews.business_id JOIN elite ON reviews.user_id = elite.user_id WHERE business.city = 'Scottsdale' AND reviews.review_stars > 3;
SELECT MAX(business.review_count), business.city FROM business WHERE business.city = 'Scottsdale' OR business.city = 'Anthem' GROUP BY business.city;
SELECT COUNT(business_id) FROM business WHERE state = 'AZ' AND stars > 4;
SELECT COUNT(*) FROM business WHERE state = 'AZ';
SELECT business.city FROM business JOIN elite ON business.business_id = elite.business_id WHERE business.stars = 5;
SELECT COUNT(*) FROM reviews WHERE user_id = 3; 
SELECT COUNT(*) FROM reviews WHERE user_id = 3 AND review_length = 'Long';
SELECT COUNT(reviews.review_id) FROM     reviews WHERE     reviews.user_id = 3     AND reviews.review_length = 'Long'     AND reviews.review_votes_useful = 'medium';
SELECT COUNT(*) FROM users WHERE user_yelping_since_year = '2012';
SELECT users.user_id FROM users WHERE users.user_fans = 'High';
SELECT COUNT(DISTINCT business_id) FROM business_attributes WHERE attribute_name = 'Alcohol' AND attribute_value = 'none';
SELECT COUNT(DISTINCT business.business_id) FROM business LEFT JOIN business_attributes ON business.business_id = business_attributes.business_id LEFT JOIN attributes ON business_attributes.attribute_id = attributes.attribute_id WHERE business.state = 'AZ' AND (attributes.attribute_name = 'Alcohol' AND attributes.attribute_value = 'none') AND business.business_id NOT IN (     SELECT business_id     FROM business_attributes     WHERE attribute_id = (         SELECT attribute_id         FROM attributes         WHERE attribute_name = 'Alcohol'     ) );
SELECT business.business_id FROM business JOIN business_attributes ON business.business_id = business_attributes.business_id JOIN attributes ON business_attributes.attribute_id = attributes.attribute_id WHERE attributes.attribute_name = 'Good for Kids' AND business_attributes.attribute_value = 'true';
SELECT COUNT(DISTINCT business.business_id) FROM business_categories JOIN categories ON business_categories.category_id = categories.category_id JOIN business ON business_categories.business_id = business.business_id WHERE categories.category_name = 'Shopping';
SELECT categories.category_name FROM business_categories JOIN categories ON business_categories.category_id = categories.category_id WHERE business_categories.business_id = 1;
SELECT COUNT(*) FROM business b JOIN business_categories bc ON b.business_id = bc.business_id JOIN categories c ON bc.category_id = c.category_id WHERE b.active = 'true' AND c.category_name = 'Food';
SELECT COUNT(b.business_id) FROM business b JOIN business_categories bc ON b.business_id = bc.business_id JOIN categories c ON bc.category_id = c.category_id WHERE b.city = 'Anthem' AND c.category_name = 'Food';
SELECT business.business_id FROM     business JOIN     business_categories ON business.business_id = business_categories.business_id JOIN     elite ON business.business_id = elite.business_id JOIN     categories ON business_categories.category_id = categories.category_id WHERE     categories.category_name = 'Food' ORDER BY     elite.year_id DESC LIMIT 1;
SELECT COUNT(DISTINCT business.business_id) FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id JOIN business_attributes ON business.business_id = business_attributes.business_id JOIN attributes ON business_attributes.attribute_id = attributes.attribute_id WHERE categories.category_name = 'Food' AND attributes.attribute_name = 'Good for Kids' AND attributes.attribute_value = 'true';
SELECT COUNT(*) FROM business b JOIN reviews r ON b.business_id = r.business_id WHERE b.state = 'AZ' AND r.user_id = 3;
SELECT categories.category_name FROM business_categories JOIN categories ON business_categories.category_id = categories.category_id JOIN business ON business_categories.business_id = business.business_id WHERE business.state = 'AZ';
SELECT strftime('%H:%M:%S', business_hours.closing_time, '-6 hours') - strftime('%H:%M:%S', business_hours.opening_time, '-6 hours') AS opening_hours_on_Tuesdays FROM business_hours JOIN days ON business_hours.day_id = days.day_id WHERE business_hours.business_id = 1 AND days.day_of_week = 'Tuesday';
SELECT business_hours.opening_time FROM business_hours JOIN days ON business_hours.day_id = days.day_id WHERE business_hours.business_id = 1 AND days.day_of_week = 'Tuesday';
SELECT COUNT(*) FROM     business_hours AS bh JOIN     days AS d ON bh.day_id = d.day_id WHERE     d.day_of_week = 'Monday'     AND (         bh.closing_time = '9PM'         OR bh.closing_time = '10PM'         OR bh.closing_time = '11PM'         OR bh.closing_time = '12PM'     );
SELECT business_hours.opening_time FROM business_hours JOIN days ON business_hours.day_id = days.day_id JOIN business ON business_hours.business_id = business.business_id WHERE days.day_of_week = 'Monday' AND business.city = 'Anthem' AND business.active = 'true';
SELECT COUNT(*)  FROM business_hours  JOIN business ON business_hours.business_id = business.business_id JOIN days ON business_hours.day_id = days.day_id WHERE business.state = 'AZ'  AND business_hours.closing_time = '12PM'  AND days.day_of_week = 'Sunday';
SELECT categories.category_name FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN business_hours ON business.business_id = business_hours.business_id JOIN days ON business_hours.day_id = days.day_id JOIN categories ON business_categories.category_id = categories.category_id WHERE business_hours.closing_time = '12PM' AND days.day_of_week = 'Sunday';
SELECT COUNT(DISTINCT business_id)  FROM business_attributes AS ba JOIN business_hours AS bh ON ba.business_id = bh.business_id WHERE ba.attribute_id IN (SELECT attribute_id FROM attributes WHERE attribute_name = 'Good for Kids' AND attribute_value = 'true') AND bh.day_id BETWEEN 1 AND 7;
SELECT COUNT(users.user_id) FROM users JOIN elite ON users.user_id = elite.user_id WHERE users.user_yelping_since_year = elite.year_id;
SELECT MAX(strftime('%H:%M:%S', business_hours.closing_time, '-'||business_hours.opening_time)) AS longest_business_time FROM business_hours JOIN business_categories ON business_hours.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id JOIN days ON business_hours.day_id = days.day_id WHERE days.day_of_week = 'Monday' AND categories.category_name = 'Shopping';
SELECT business.business_id FROM business_hours JOIN business ON business_hours.business_id = business.business_id JOIN days ON business_hours.day_id = days.day_id WHERE days.day_of_week = 'Sunday' AND strftime('%H:%M', business_hours.closing_time) - strftime('%H:%M', business_hours.opening_time) > 12;
SELECT COUNT(users.user_id) AS elite_users_reviewing_Yelp_Business_1 FROM elite JOIN users ON elite.user_id = users.user_id JOIN reviews ON elite.user_id = reviews.user_id WHERE reviews.business_id = 1;
SELECT COUNT(DISTINCT elite.user_id) FROM elite JOIN reviews ON elite.user_id = reviews.user_id GROUP BY elite.user_id HAVING COUNT(reviews.user_id) > 10;
SELECT business.business_id FROM business WHERE business.state = 'AZ' GROUP BY business.business_id ORDER BY COUNT(reviews.business_id) DESC LIMIT 1;
SELECT AVG(review_stars) FROM business WHERE city = 'Anthem';
SELECT AVG(review_stars) FROM reviews WHERE user_id = 3 AND business_id IN (     SELECT business_id     FROM business     WHERE state = 'AZ' ); 
SELECT AVG((julianday(business_hours.closing_time) - julianday(business_hours.opening_time)) / 2) FROM business_hours JOIN days ON business_hours.day_id = days.day_id WHERE business_hours.business_id = 1 AND (days.day_of_week = 'Saturday' OR days.day_of_week = 'Sunday');
SELECT AVG(r.stars) AS average_elitestar_rating FROM business AS b JOIN business_hours AS bh ON b.business_id = bh.business_id JOIN reviews AS r ON b.business_id = r.business_id JOIN days AS d ON bh.day_id = d.day_id JOIN years AS y ON bh.year_id = y.year_id JOIN elite AS e ON r.user_id = e.user_id WHERE bh.closing_time = '12PM' AND d.day_of_week = 'Sunday'
SELECT COUNT(*) FROM business WHERE city = 'Casa Grande';
SELECT COUNT(*) FROM business WHERE active = 'true' AND state = 'AZ' AND review_count < 10;
SELECT business.business_id FROM business WHERE business.stars >= 2 AND business.stars < 4 AND business.city = 'Mesa';
SELECT COUNT(user_id) FROM users WHERE user_yelping_since_year BETWEEN 2011 AND 2013 AND user_fans > 100
SELECT reviews.review_length FROM reviews WHERE reviews.user_id = 35026 AND reviews.business_id = 2;
SELECT business_attributes.attribute_name FROM business JOIN business_attributes ON business.business_id = business_attributes.business_id WHERE business.city = 'Chandler' ORDER BY business.review_count ASC LIMIT 1;
SELECT COUNT(DISTINCT business.business_id) FROM     business JOIN     business_categories ON business.business_id = business_categories.business_id WHERE     business_categories.category_id = (         SELECT category_id         FROM categories         WHERE category_name = 'Mexican'     )     AND business.stars < 4;
SELECT business.business_id, business.stars FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id WHERE business.active = 'true' AND categories.category_name = 'Fashion';
SELECT categories.category_name FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id WHERE business.stars = (     SELECT MAX(stars)     FROM business ) 
SELECT categories.category_name FROM     categories JOIN     business_categories ON categories.category_id = business_categories.category_id JOIN     reviews ON business_categories.business_id = reviews.business_id WHERE     reviews.review_length = (SELECT MAX(review_length) FROM reviews WHERE reviews.business_id BETWEEN 6 AND 9)     AND reviews.review_stars = (SELECT MAX(review_stars) FROM reviews WHERE reviews.business_id BETWEEN 6 AND 9);
SELECT COUNT(DISTINCT business.business_id) FROM business JOIN business_attributes ON business.business_id = business_attributes.business_id WHERE business.active = 'true' AND business_attributes.attribute_value = 'True' AND business_attributes.attribute_id = (     SELECT attribute_id     FROM attributes     WHERE attribute_name = 'Caters' ) AND business.review_count < 10;
SELECT business.business_id, business.city, business.opening_time, business.closing_time FROM business WHERE business.city = 'Tempe' AND business.stars = (SELECT MAX(stars) FROM business WHERE city = 'Tempe');
SELECT categories.category_name, business_attributes.attribute_name FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id JOIN business_attributes ON business.business_id = business_attributes.business_id WHERE business.active = 'true' AND business.city = 'Chandler' AND business.state = 'AZ' AND business.review_count BETWEEN 25 AND 50;
SELECT categories.category_name FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id WHERE business.active = 'true' AND business.city = 'Surprise' AND business.state = 'AZ';
SELECT business.city, business.state FROM business JOIN business_hours ON business.business_id = business_hours.business_id JOIN days ON business_hours.day_id = days.day_id WHERE days.day_of_week = 'Friday' AND business_hours.opening_time = '8AM' AND business_hours.closing_time = '9PM';
SELECT business_attributes.attribute_value FROM business JOIN business_attributes ON business.business_id = business_attributes.business_id WHERE business.active = 'true' AND business.stars = 3 AND business.city = 'Mesa' AND business.state = 'AZ' AND business.review_count > 100;
SELECT business_hours.opening_time FROM business JOIN business_hours ON business.business_id = business_hours.business_id WHERE business.active = 'true' AND business.city = 'Chandler' AND business.review_count >= 20 AND business.review_count <= 50;
SELECT COUNT(Business.business_id) * 100.0 / COUNT(*) AS percentage_of_businesses_with_less_than_4_stars FROM business JOIN business_categories ON business.business_id = business_categories.business_id WHERE business_categories.category_id = (     SELECT category_id     FROM categories     WHERE category_name = 'Accessories' ) AND business.stars < 4;
SELECT business_hours.closing_time, days.day_of_week FROM business JOIN business_hours ON business.business_id = business_hours.business_id JOIN days ON business_hours.day_id = days.day_id WHERE business.active = 'true' AND business.city = 'Tempe' AND business.stars > (     SELECT        AVG(business.stars) * 0.7     FROM         business ) 
SELECT COUNT(*) FROM business WHERE active = 'true' AND city = 'Phoenix' AND state = 'Arizona';
SELECT COUNT(*) FROM business WHERE review_count = 'High';
SELECT COUNT(DISTINCT business_id) FROM business_attributes WHERE attribute_value = 'beer_and_wine';
SELECT COUNT(attribute_id) FROM business_attributes WHERE business_id = 2;
SELECT COUNT(DISTINCT users.user_id) FROM     users JOIN     users_compliments ON users.user_id = users_compliments.user_id JOIN     compliments ON users_compliments.compliment_id = compliments.compliment_id WHERE     users_compliments.number_of_compliments = 'High'     AND compliments.compliment_type = 'photo';
SELECT COUNT(DISTINCT business.business_id) FROM business JOIN business_attributes ON business.business_id = business_attributes.business_id JOIN attributes ON business_attributes.attribute_id = attributes.attribute_id WHERE business.city = 'Phoenix' AND business.state = 'Arizona' AND attributes.attribute_name = 'waiter_service';
SELECT business.business_id, business_attributes.attribute_value FROM business JOIN business_hours ON business.business_id = business_hours.business_id JOIN business_attributes ON business.business_id = business_attributes.business_id WHERE      business_hours.opening_time = business_hours.closing_time     AND (         SELECT COUNT(DISTINCT day_id)         FROM business_hours AS bh         WHERE bh.business_id = business.business_id     ) = 7;
SELECT business.business_id, business.city, business.state, MAX(COUNT(reviews.user_id)) AS max_reviews FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id JOIN reviews ON business.business_id = reviews.business_id WHERE categories.category_name = 'Fashion' GROUP BY business.business_id ORDER BY max_reviews DESC LIMIT 1;
SELECT business_categories.category_id, COUNT(reviews.review_id) AS review_count FROM business_categories JOIN business ON business_categories.business_id = business.business_id JOIN reviews ON business.business_id = reviews.business_id WHERE business.state = 'AZ' AND reviews.review_count >= 3 GROUP BY business_categories.category_id ORDER BY review_count DESC;
SELECT COUNT(CASE WHEN users.user_average_stars = 5 AND elite.year_id = 2013 THEN users.user_id END) * 1.0 / COUNT(CASE WHEN users.user_average_stars = 1 AND elite.year_id = 2013 THEN users.user_id END) AS ratio FROM users JOIN elite ON users.user_id = elite.user_id;
SELECT (actual_year - 2015) * 100.0 / (SELECT COUNT(DISTINCT user_id) FROM elite WHERE year_id = 2015) AS increment_percentage, actual_year FROM years WHERE actual_year BETWEEN 2005 AND 2014 GROUP BY actual_year 
SELECT COUNT(DISTINCT business_id), strftime('%Y', 'now') - user_yelping_since_year AS years_with_yelp FROM reviews WHERE user_id = 3;
SELECT AVG(r.review_stars) AS yearly_average_review FROM     reviews r JOIN     users u ON r.user_id = u.user_id WHERE     u.user_id = 3 GROUP BY     u.user_yelping_since_year;
SELECT AVG(COUNT(user_id) / COUNT(business_id)) AS average_review_received FROM elite JOIN reviews ON elite.user_id = reviews.user_id GROUP BY elite.user_id
SELECT users.user_id, AVG(users.user_average_stars) AS average_star, SUM(tips.likes) AS total_likes FROM elite JOIN users ON elite.user_id = users.user_id JOIN tips ON users.user_id = tips.user_id GROUP BY users.user_id HAVING COUNT(elite.year_id) >= 5;
SELECT business.business_id, business.city, business.state, MAX(review_count) AS max_review_count, ROUND(AVG(reviews.review_stars), 2) AS average_star_per_user, ROUND(SQRT(AVG(reviews.review_stars * reviews.review_stars) - AVG(reviews.review_stars) * AVG(reviews.review_stars)), 2) AS standard_deviation FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id JOIN reviews ON business.business_id = reviews.business_id WHERE categories.category_name = 'Hotel & Travel' GROUP BY business.business_id ORDER BY max_review_count DESC LIMIT 1;
SELECT  ROUND(AVG(reviews.review_stars), 2) AS avg_review_stars, ROUND(AVG(business.stars), 2) AS avg_business_stars, ROUND(CORR(reviews.review_stars, business.stars), 2) AS correlation FROM reviews INNER JOIN business ON reviews.business_id = business.business_id;
SELECT COUNT(*) FROM business WHERE active = 'true';
SELECT business.business_id FROM business WHERE business.city = 'Phoenix' AND business.review_count = 'Low';
SELECT COUNT(DISTINCT business_id) FROM business WHERE state = 'AZ' AND active = 'true' AND review_count = 'High';
SELECT business.business_id FROM business WHERE business.stars >= 3 AND business.stars < 5 AND business.city = 'Tempe';
SELECT COUNT(*) FROM     users WHERE     user_yelping_since_year >= '2010' AND user_yelping_since_year < '2013'     AND user_fans = 'Low';
SELECT review_length FROM reviews WHERE user_id = 60776 AND business_id = 1;
SELECT business_attributes.attribute_name FROM business_attributes INNER JOIN business ON business_attributes.business_id = business.business_id WHERE business.city = 'Scottsdale' AND business.review_count = 'High';
SELECT COUNT(*) FROM     business b JOIN     business_categories bc ON b.business_id = bc.business_id WHERE     bc.category_id = (SELECT category_id FROM categories WHERE category_name = 'Automotive')     AND b.stars < 3;
SELECT business.business_id, business.stars FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id WHERE categories.category_name = 'Pets' AND business.active = 'true';
SELECT MAX(b.stars) AS highest_star_rating, a.attribute_name AS attribute_of_business FROM business AS b JOIN business_attributes AS ba ON b.business_id = ba.business_id JOIN attributes AS a ON ba.attribute_id = a.attribute_id GROUP BY a.attribute_name ORDER BY highest_star_rating DESC LIMIT 1;
SELECT categories.category_name FROM business JOIN reviews ON business.business_id = reviews.business_id JOIN categories ON business.business_id = categories.business_id WHERE reviews.review_length = 'Short' AND business.business_id BETWEEN 5 AND 10 AND reviews.review_stars = (SELECT MAX(review_stars) FROM reviews WHERE business_id BETWEEN 5 AND 10 AND review_length = 'Short');
SELECT COUNT(DISTINCT business.business_id) FROM business JOIN business_attributes ON business.business_id = business_attributes.business_id WHERE business.active = 'true' AND business_attributes.attribute_id IN (SELECT attribute_id FROM attributes WHERE attribute_name = 'Wi-Fi') AND business.review_count = 'Medium';
SELECT business_hours.opening_time, business_hours.closing_time FROM business JOIN business_hours ON business.business_id = business_hours.business_id WHERE business.city = 'Gilbert' AND business.stars = (SELECT MAX(stars) FROM business WHERE city = 'Gilbert');
SELECT business_categories.category_id, business_attributes.attribute_id FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN business_attributes ON business.business_id = business_attributes.business_id WHERE business.active = 'true' AND business.city = 'Mesa' AND business.state = 'AZ' AND business.review_count = 'Low';
SELECT categories.category_name FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id WHERE business.active = 'FALSE' AND business.state = 'AZ';
SELECT business.city FROM business JOIN business_hours ON business.business_id = business_hours.business_id JOIN days ON business_hours.day_id = days.day_id WHERE days.day_of_week = 'Saturday' AND business_hours.opening_time = '9AM' AND business_hours.closing_time = '9PM';
SELECT business_attributes.attribute_value FROM business JOIN business_attributes ON business.business_id = business_attributes.business_id WHERE business.active = 'FALSE' AND business.city = 'Phoenix' AND business.state = 'AZ' AND business.stars = 3.5 AND business.review_count = 'Medium';
SELECT business_hours.opening_time FROM business JOIN business_hours ON business.business_id = business_hours.business_id WHERE business.active = 'true' AND business.city = 'Surprise' AND business.review_count = 'Low';
SELECT ROUND((COUNT(business.business_id) * 100.0 / (SELECT COUNT(*) FROM business_categories WHERE category_id = (SELECT category_id FROM categories WHERE category_name = 'Local Services'))) * 100) / 100.0 FROM business JOIN business_categories ON business.business_id = business_categories.business_id WHERE business.stars < 3 AND business_categories.category_id = (SELECT category_id FROM categories WHERE category_name = 'Local Services');
SELECT business_hours.closing_time, days.day_of_week FROM business JOIN business_hours ON business.business_id = business_hours.business_id JOIN days ON business_hours.day_id = days.day_id WHERE business.active = 'true' AND business.city = 'Scottsdale' AND business.stars > (SELECT AVG(stars) * 0.6 FROM business);
SELECT COUNT(users.user_id) FROM users WHERE user_yelping_since_year = 2014 AND user_fans = 'None';
SELECT users.user_id FROM users_compliments JOIN users ON users_compliments.user_id = users.user_id WHERE users_compliments.number_of_compliments < 5
SELECT users.user_id FROM users WHERE users.user_average_stars = 4 LIMIT 10;
SELECT business.city FROM business JOIN business_hours ON business.business_id = business_hours.business_id JOIN days ON business_hours.day_id = days.day_id WHERE business_hours.opening_time = '10AM' AND business_hours.closing_time = '12PM' AND days.day_of_week = 'Sunday';
SELECT COUNT(DISTINCT business.business_id) FROM business JOIN business_attributes ON business.business_id = business_attributes.business_id WHERE attribute_name = 'Open 24 Hours' AND attribute_value = 'true';
SELECT business.business_id FROM business JOIN business_attributes ON business.business_id = business_attributes.business_id JOIN attributes ON business_attributes.attribute_id = attributes.attribute_id WHERE attributes.attribute_name = 'Good for Groups' AND business.active = 1 AND business.business_id IN (     SELECT    business_id     FROM     business_attributes     JOIN attributes ON business_attributes.attribute_id = attributes.attribute_id     WHERE     attributes.attribute_name = 'Good for Dancing' ) LIMIT 5;
SELECT business.business_id FROM business INNER JOIN business_hours ON business.business_id = business_hours.business_id INNER JOIN days ON business_hours.day_id = days.day_id WHERE business.active = 'true' AND business.city = 'Ahwatukee' AND days.day_of_week = 'Sunday';
SELECT categories.category_name FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id WHERE business.active = 'true' AND business.state != 'AZ';
SELECT categories.category_name FROM business JOIN categories ON business.business_id = business_categories.business_id WHERE business.stars = 2 AND business.review_count = 'High';
SELECT COUNT(DISTINCT business_id) FROM business_attributes WHERE attribute_id IN (     SELECT attribute_id     FROM attributes     WHERE attribute_name = 'ambience_romantic' ) AND attribute_value = 'true';
SELECT business.city FROM business JOIN business_hours ON business.business_id = business_hours.business_id JOIN days ON business_hours.day_id = days.day_id WHERE days.day_of_week = 'Saturday' AND business_hours.opening_time = '1PM' AND business_hours.closing_time = '6PM';
SELECT SUM(users.user_fans) AS total_fans_or_followers FROM users JOIN tips ON users.user_id = tips.user_id GROUP BY tips.business_id ORDER BY MAX(tips.likes) DESC LIMIT 1;
SELECT business.city FROM business JOIN business_hours ON business.business_id = business_hours.business_id JOIN days ON business_hours.day_id = days.day_id WHERE business_hours.opening_time = '12AM' AND business_hours.closing_time = '1AM' AND days.day_of_week = 'Saturday' GROUP BY business.city HAVING COUNT(*) > 20;
SELECT COUNT(DISTINCT business.business_id) FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id WHERE categories.category_name = 'Shopping Centers' AND business.review_count = 'High';
SELECT COUNT(DISTINCT business_id) FROM business_attributes WHERE attribute_id IN (SELECT attribute_id FROM attributes WHERE attribute_name = 'Accepts Insurance') AND attribute_value = 'true';
SELECT AVG(reviews.review_stars) FROM     reviews     INNER JOIN business ON reviews.business_id = business.business_id WHERE     business.state IN ('SC', 'CA')
SELECT COUNT(DISTINCT CASE WHEN day_of_week = 'Monday' AND opening_time = '10AM' AND closing_time = '9PM' THEN business_id ELSE NULL END) - COUNT(DISTINCT CASE WHEN day_of_week = 'Tuesday' AND opening_time = '10AM' AND closing_time = '9PM' THEN business_id ELSE NULL END) AS difference_count FROM business_hours;
SELECT attribute_id FROM attributes WHERE attribute_name = "Accepts Insurance";
SELECT COUNT(*) FROM business WHERE city = 'Phoenix' AND active = 'true';
SELECT COUNT(*) FROM     business WHERE     stars = '4'     AND city = 'Mesa';
SELECT COUNT(business_id) FROM business WHERE city = 'Gilbert' AND review_count = 'High';
SELECT business_id FROM business WHERE city = 'Gilbert' AND active = 'true' ORDER BY review_count DESC LIMIT 1;
SELECT COUNT(reviews.review_length) FROM business JOIN reviews ON business.business_id = reviews.business_id WHERE business.city = 'Tempe' AND business.stars = 3.5 AND business.review_count = 'Uber' AND reviews.review_length = 'Long';
SELECT     business_attributes.attribute_value AS noise_level FROM     business JOIN     business_attributes ON business.business_id = business_attributes.business_id JOIN     categories ON business.business_id = categories.business_id JOIN     reviews ON business.business_id = reviews.business_id WHERE     categories.category_name = 'Uber'     AND business.city = 'Mesa';
SELECT CASE     WHEN ba.attribute_value = 'True' THEN 'Yes'     ELSE 'No' END AS is_good_for_supper FROM business_attributes AS ba WHERE ba.business_id = 14033 AND ba.attribute_id IN (     SELECT attribute_id     FROM attributes     WHERE attribute_name = 'good_for_dinner' ); 
SELECT     business_hours.closing_time - business_hours.opening_time AS opening_duration FROM     business_hours JOIN     days ON business_hours.day_id = days.day_id WHERE     business_hours.business_id = '15098'     AND days.day_of_week = 'Monday';
SELECT business.business_id FROM business JOIN reviews ON business.business_id = reviews.business_id WHERE business.city = 'Phoenix' AND reviews.review_stars = 5 AND reviews.review_votes_funny = 'Uber';
SELECT business.city FROM tips JOIN business ON tips.business_id = business.business_id WHERE tips.tip_length = 'Medium' AND tips.likes = 3;
SELECT COUNT(users_compliments.number_of_compliments) FROM users_compliments JOIN users ON users_compliments.user_id = users.user_id WHERE users.user_yelping_since_year = '2010' AND users.user_average_stars = '4.5' AND users.user_fans > 1000 AND users_compliments.compliment_id = (     SELECT compliment_id FROM compliments WHERE compliment_type = 'funny' );
SELECT COUNT(*) FROM     compliments WHERE     compliment_type = 'cool'     AND user_id = 41717;
SELECT CASE      WHEN EXISTS (         SELECT 1         FROM business_attributes         WHERE business_id = '12476' AND attribute_value = 'parking_lot'     ) THEN 'Yes'     ELSE 'No' END AS has_parking_lot FROM business WHERE business_id = '12476';
SELECT business_attributes.attribute_value FROM business_attributes JOIN business ON business_attributes.business_id = business.business_id WHERE business.business_id = '12476' AND business_attributes.attribute_value = 'payment_types_mastercard';
SELECT 100.0 * COUNT(business_id) / (SELECT COUNT(*) FROM business) AS percentage_pets FROM business_categories WHERE category_id = (SELECT category_id FROM categories WHERE category_name = 'Pets');
SELECT COUNT(CASE WHEN categories.category_name = 'Women''s Clothing' THEN 1 END) / COUNT(CASE WHEN categories.category_name = 'Men''s Clothing' THEN 1 END) AS ratio_of_womens_to_mens_clothing FROM categories;
SELECT business_id, active, city FROM business WHERE state = 'CA';
SELECT 100.0 * SUM(CASE WHEN active = 'true' THEN 1 ELSE 0 END) / COUNT(business_id) AS percentage_running_business FROM business;
SELECT attribute_id, attribute_name FROM attributes WHERE attribute_name LIKE 'music%'
SELECT COUNT(user_id) AS elite_user_count, year_id FROM elite WHERE year_id BETWEEN 2006 AND 2007 GROUP BY year_id ORDER BY elite_user_count DESC LIMIT 1;
SELECT (CAST(COUNT(number_of_compliments = 'Low') AS REAL) / COUNT(user_id)) * 100 AS percentage_of_low_compliments FROM users_compliments;
SELECT business_id, user_id FROM reviews WHERE review_votes_cool = 'Uber';
SELECT users.user_id, business.business_id, tips.tip_length FROM users JOIN tips ON users.user_id = tips.user_id WHERE users.user_yelping_since_year = '2004' AND users.user_fans = 'High';
SELECT business.business_id, business.active, reviews.user_id, users.user_yelping_since_year FROM business JOIN reviews ON business.business_id = reviews.business_id JOIN users ON reviews.user_id = users.user_id WHERE reviews.review_votes_funny = 'Uber' AND reviews.review_votes_cool = 'Uber' AND reviews.review_length > 100;
SELECT `attributes.attribute_id, business_attributes.business_id, business.city, business.active`   FROM     attributes JOIN     business_attributes ON attributes.attribute_id = business_attributes.attribute_id JOIN     business ON business_attributes.business_id = business.business_id WHERE     attributes.attribute_name = 'music_playlist'; 
SELECT (CAST(COUNT(*) AS FLOAT) / (SELECT COUNT(*) FROM business_attributes WHERE attribute_value = 'Accepts Credit Cards')) * 100 AS percentage_accepts_credit_cards FROM business_attributes WHERE attribute_value = 'Accepts Credit Cards';
SELECT   reviews.user_id, reviews.review_length FROM reviews JOIN business ON reviews.business_id = business.business_id WHERE business.active = 'false' AND business.city = 'San Tan Valley' AND reviews.review_stars = 5; 
SELECT users.user_average_stars, elite.year_id, compliments.compliment_type FROM users JOIN elite ON users.user_id = elite.user_id JOIN users_compliments ON users.user_id = users_compliments.user_id JOIN compliments ON users_compliments.compliment_id = compliments.compliment_id WHERE users.user_id = 6027 AND users_compliments.number_of_compliments = 'Uber';
SELECT b.business_id, b.state, b.city FROM business b JOIN business_categories bc ON b.business_id = bc.business_id JOIN categories c ON bc.category_id = c.category_id WHERE c.category_name = 'Coffee & Tea' LIMIT 5; 
SELECT categories.category_name FROM business_categories JOIN categories ON business_categories.category_id = categories.category_id GROUP BY categories.category_name HAVING (COUNT(business_categories.business_id) / (SELECT COUNT(*) FROM business_categories)) * 100 > 10; 
SELECT users.user_id, users.user_fans FROM business JOIN reviews ON business.business_id = reviews.business_id JOIN users ON reviews.user_id = users.user_id WHERE business.city = 'Sun Lakes' AND business.stars = 5;
SELECT COUNT(DISTINCT bc_men.business_id) AS men_business_count, COUNT(DISTINCT bc_women.business_id) AS women_business_count FROM business_categories AS bc_men JOIN categories AS c_men ON bc_men.category_id = c_men.category_id AND c_men.category_name = 'Men''s Clothing' JOIN business_categories AS bc_women ON bc_men.business_id = bc_women.business_id JOIN categories AS c_women ON bc_women.category_id = c_women.category_id AND c_women.category_name = 'Women''s Clothing';
SELECT users.user_id, compliments.compliment_type, MAX(users.follower_count) as max_follower_count FROM users JOIN users_compliments ON users.user_id = users_compliments.user_id JOIN compliments ON users_compliments.compliment_id = compliments.compliment_id WHERE users.user_id < 100 AND users_compliments.number_of_compliments = 'Uber' GROUP BY users.user_id ORDER BY max_follower_count DESC LIMIT 1;
SELECT business.business_id, business.city, business.state FROM business JOIN business_hours ON business.business_id = business_hours.business_id WHERE business_hours.closing_time = '8PM' AND business.active = 0;
SELECT COUNT(*) FROM     business WHERE     stars = 2     AND city = 'Phoenix'     AND state = 'AZ';
SELECT COUNT(business_id) FROM business WHERE city = 'Tempe' AND stars > 3
SELECT users.user_id FROM users WHERE users.user_yelping_since_year = 2012 AND users.user_average_stars < 3;
SELECT 100.0 * COUNT(CASE WHEN reviews.review_stars = 5 THEN 1 END) / COUNT(reviews.business_id) AS percentage_of_5_star_business FROM reviews
SELECT MAX(review_count) - MIN(review_count) AS review_count_difference FROM business;
SELECT business.business_id FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id JOIN business_hours ON business.business_id = business_hours.business_id JOIN days ON business_hours.day_id = days.day_id WHERE categories.category_name = 'Tires' GROUP BY business.business_id HAVING COUNT(DISTINCT business_hours.opening_time) = 7;
SELECT users.user_id FROM elite INNER JOIN users ON elite.user_id = users.user_id INNER JOIN years ON elite.year_id = years.year_id WHERE years.actual_year = 2012 
SELECT business.business_id FROM business JOIN business_categories ON business.business_id = business_categories.business_id WHERE business_categories.category_id = (SELECT category_id FROM categories WHERE category_name = 'Shopping') AND business.stars = 4;
SELECT COUNT(DISTINCT business_id) FROM business_hours JOIN days ON business_hours.day_id = days.day_id JOIN checkins ON business_hours.business_id = checkins.business_id AND business_hours.day_id = checkins.day_id WHERE day_of_week = 'Sunday' AND label_time_10 = 'Low';
SELECT COUNT(DISTINCT business.business_id) FROM     business JOIN     reviews ON business.business_id = reviews.business_id WHERE     business.city = 'Glendale'     AND reviews.user_id = 20241;
SELECT business.city FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id WHERE categories.category_name = 'Pet Services';
SELECT COUNT(users_compliments.compliment_id) AS num_photos_compliments FROM     users_compliments JOIN     compliments ON users_compliments.compliment_id = compliments.compliment_id JOIN     users ON users_compliments.user_id = users.user_id WHERE     compliments.compliment_type = 'photos' AND     users.user_votes_cool = 'High';
SELECT COUNT(DISTINCT business_id) FROM business WHERE active = 'false' AND business_id IN (     SELECT business_id     FROM business_attributes     GROUP BY business_id     HAVING COUNT(attribute_id) > 10 );
SELECT business.business_id FROM business JOIN business_attributes ON business.business_id = business_attributes.business_id JOIN attributes ON business_attributes.attribute_id = attributes.attribute_id WHERE business.city = 'Mesa' AND attributes.attribute_name = 'Alcohol';
SELECT COUNT(business_id) * 100.0 / (SELECT COUNT(business_id) FROM business WHERE city = 'Phoenix' AND review_votes_funny = 'Low') AS percentage_of_business_with_low_funny_votes FROM business WHERE city = 'Phoenix'
SELECT COUNT(DISTINCT CASE WHEN bc.category_id IN (SELECT category_id FROM categories WHERE category_name = 'Shopping') THEN b.business_id END) * 1.0 / COUNT(DISTINCT CASE WHEN bc.category_id IN (SELECT category_id FROM categories WHERE category_name = 'Pets') THEN b.business_id END) FROM business_categories bc JOIN business b ON bc.business_id = b.business_id;
SELECT COUNT(b.business_id) FROM business b JOIN business_categories bc ON b.business_id = bc.business_id JOIN categories c ON bc.category_id = c.category_id WHERE c.category_name = 'Banks & Credit Unions';
SELECT COUNT(*) FROM business WHERE active = 'true' AND city = 'Casa Grande';
SELECT business_hours.opening_time FROM business_hours JOIN days ON business_hours.day_id = days.day_id WHERE business_hours.business_id = 12 AND days.day_of_week = 'Monday';
SELECT COUNT(DISTINCT business.business_id) FROM business JOIN business_attributes ON business.business_id = business_attributes.business_id JOIN attributes ON business_attributes.attribute_id = attributes.attribute_id WHERE attributes.attribute_name = 'Good for Kids' AND business_attributes.attribute_value = 'true';
SELECT business_id FROM business WHERE city = 'Gilbert' AND active = 'true' AND review_count = 'High' AND stars = (SELECT MAX(stars) FROM business WHERE city = 'Gilbert' AND active = 'true' AND review_count = 'High')
SELECT business.business_id, business_categories.category_id, categories.category_name FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id WHERE business.stars = 5 AND business.city = 'Ahwatukee' LIMIT 1;
SELECT 100 * COUNT(b.business_id) / (SELECT COUNT(*) FROM business b WHERE b.city = 'Avondale' AND b.active = 'false' AND b.stars > 3) FROM business b WHERE b.city = 'Avondale' AND b.active = 'false' AND b.stars > 3;
SELECT users.user_id, users.user_yelping_since_year, elite.user_id FROM users LEFT JOIN elite ON users.user_id = elite.user_id WHERE users.user_yelping_since_year = 2004;
SELECT (      SELECT         (COUNT(reviews.business_id) * 1.0 / (SELECT COUNT(*) FROM reviews WHERE review_stars = 5)) * 100      FROM          reviews      WHERE          review_stars = 5 AND          review_length = 'Long' ) AS percent_long_reviews_5_stars;
SELECT 100 * COUNT(u.user_id) / SUM(CASE WHEN u.user_fans = 'None' THEN 1 ELSE 0 END) FROM users u WHERE u.user_average_stars >= 4;
SELECT COUNT(tips.tip_length) AS short_tips FROM tips JOIN business ON tips.business_id = business.business_id WHERE tips.tip_length = 'Short' AND business.business_id = 2;
SELECT users.user_id FROM users WHERE users.user_average_stars = 5 ORDER BY users.user_yelping_since_year LIMIT 1;
SELECT business_id, opening_time, closing_time FROM business_hours AS bh JOIN (     SELECT AVG(review_count) AS avg_review_count     FROM business AS b     WHERE b.city = 'Black Canyon City' ) AS T1 ON bh.business_id = b.business_id WHERE b.city = 'Black Canyon City' AND b.review_count > T1.avg_review_count;
SELECT 100 * (     SELECT COUNT(uc.user_id)     FROM users_compliments AS uc     WHERE uc.compliment_id = (         SELECT compliment_id         FROM compliments         WHERE compliment_type = 'cute'     ) AND uc.number_of_compliments = 'High' ) / (     SELECT COUNT(user_id)     FROM users )
SELECT COUNT(DISTINCT business_id) FROM business WHERE business_id NOT IN (     SELECT DISTINCT business_id     FROM business_attributes     WHERE attribute_value IN ('none', 'no', 'false') );
SELECT `opening_time`, `closing_time` FROM business_hours WHERE business_id = 1 AND day_id = 2;
SELECT business.city FROM reviews JOIN business ON reviews.business_id = business.business_id WHERE reviews.review_length = 'Medium';
SELECT business_hours.closing_time FROM business_hours JOIN days ON business_hours.day_id = days.day_id WHERE business_hours.business_id = 4 AND days.day_of_week = 'Sunday';
SELECT business.business_id FROM business JOIN reviews ON business.business_id = reviews.business_id WHERE reviews.review_length = 'Short' AND business.city = 'Phoenix';
SELECT COUNT(users.user_id) FROM     users JOIN     users_compliments ON users.user_id = users_compliments.user_id WHERE     users.user_fans = 'Medium'     AND users_compliments.number_of_compliments = 'High';
SELECT users.user_id FROM users JOIN users_compliments ON users.user_id = users_compliments.user_id WHERE users_compliments.number_of_compliments = 'Low' AND users.user_yelping_since_year = 2012; 
SELECT COUNT(*) FROM business WHERE city = 'Gilbert' AND business_id NOT IN (     SELECT DISTINCT business_id     FROM business_attributes     WHERE attribute_value = 'None' );
SELECT COUNT(DISTINCT business.business_id) FROM     business WHERE     business.stars = (SELECT AVG(stars) FROM business)     AND business.business_id IN (SELECT business_id FROM business_attributes WHERE attribute_value = 'full_bar');
SELECT business.state FROM business_hours WHERE opening_time = '01:00:00';
SELECT categories.category_name FROM business_categories JOIN categories ON business_categories.category_id = categories.category_id WHERE business_categories.business_id = 5; 
SELECT users.user_id FROM users_compliments JOIN compliments ON users_compliments.compliment_id = compliments.compliment_id WHERE compliments.compliment_type = 'photos';
SELECT COUNT(tips.user_id) FILTER (WHERE tip_length = 'Medium') * 100.0 / COUNT(tips.user_id), users.user_yelping_since_year FROM tips JOIN users ON tips.user_id = users.user_id WHERE tips.tip_length = 'Medium' GROUP BY users.user_yelping_since_year; 
SELECT 100 * (SELECT COUNT(*) FROM business WHERE city = 'Mesa') / (SELECT COUNT(*) FROM business) as percentage, (SELECT attribute_value FROM business_attributes WHERE business_id IN (SELECT business_id FROM business WHERE city = 'Mesa')) as attribute_value;
SELECT business.state FROM business_hours WHERE closing_time = '12:00 AM';
SELECT COUNT(business.business_id) FROM business JOIN business_attributes ON business.business_id = business_attributes.business_id WHERE business_attributes.attribute_value = 'beer_and_wine' AND business.city = 'Peoria';
SELECT users.user_id FROM users_compliments JOIN users ON users_compliments.user_id = users.user_id WHERE users_compliments.number_of_compliments = 'High' GROUP BY users.user_id ORDER BY MIN(users.user_yelping_since_year) LIMIT 10;
SELECT business_id, COUNT(*) AS review_count FROM reviews GROUP BY business_id ORDER BY review_count DESC LIMIT 1;
SELECT MAX(year_id) FROM elite;
SELECT COUNT(*) FROM     business b JOIN     reviews r ON b.business_id = r.business_id WHERE     r.review_stars = 5.0     AND r.review_votes_funny = 'uber';
SELECT COUNT(DISTINCT users.user_id) FROM users JOIN reviews ON users.user_id = reviews.user_id WHERE reviews.review_votes_funny = 'uber';
SELECT MIN(business_hours.business_id) FROM business_hours GROUP BY business_hours.business_id ORDER BY MIN(ABS(julianday(closing_time) - julianday(opening_time))) LIMIT 1;
SELECT business_id FROM business_hours WHERE day_id BETWEEN 1 AND 7 AND opening_time = closing_time;
SELECT SUM(tips.likes) AS total_likes, AVG(tips.tip_length) AS average_tip_length FROM tips JOIN business_categories ON tips.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id WHERE categories.category_name = 'Hotels & Travel';
SELECT COUNT(u.user_id) AS total_users_with_uber_votes, AVG(u.user_average_stars) AS average_star_for_users_with_uber_votes FROM users u JOIN reviews r ON u.user_id = r.user_id WHERE r.review_votes_funny = 'uber' AND r.review_votes_useful = 'uber' AND r.review_votes_cool = 'uber';
SELECT COUNT(CASE WHEN stars BETWEEN 3.5 AND 5 THEN 1 END) * 1.0 / NULLIF(COUNT(CASE WHEN stars BETWEEN 1 AND 2.5 THEN 1 END), 0) FROM business JOIN business_hours ON business.business_id = business_hours.business_id WHERE day_id BETWEEN 1 AND 7 AND opening_time = closing_time;
SELECT business_id FROM reviews GROUP BY business_id ORDER BY COUNT(user_id) DESC LIMIT 10; 
SELECT COUNT(business_id) FROM business WHERE state = 'Arizona' AND       (SELECT AVG(review_stars) FROM reviews WHERE reviews.business_id = business.business_id) < 3.0;
SELECT (DIVIDE(SUBTRACT(COUNT(users.user_id), COUNT(elite.user_id)), COUNT(users.user_id)) * 100) AS percentage FROM users LEFT JOIN elite ON users.user_id = elite.user_id; 
SELECT MAX(compliment_type) AS most_common_compliment_type FROM     users JOIN     users_compliments ON users.user_id = users_compliments.user_id WHERE     users.user_fans = 'uber' GROUP BY     users.user_id ORDER BY     COUNT(compliment_id) DESC LIMIT 1;
SELECT AVG(years.actual_year) FROM users JOIN years ON users.user_yelping_since_year = years.year_id WHERE users.user_fans = 'uber';
SELECT AVG(user_yelping_since_year)  FROM elite;
SELECT COUNT(business_id) AS number_of_business_opened_for_more_than_8_hours, ROUND(     (COUNT(CASE WHEN active = 'true' AND city = 'Mesa' AND (closing_time - opening_time) > 8 THEN business_id END) * 1.0) /     COUNT(CASE WHEN city = 'Mesa' AND (closing_time - opening_time) > 8 THEN business_id END)     * 100,     2 ) AS percentage FROM business_hours JOIN business ON business_hours.business_id = business.business_id WHERE city = 'Mesa' AND (closing_time - opening_time) > 8;
SELECT COUNT(DISTINCT business.business_id) AS num_active_businesses, categories.category_name FROM business JOIN business_hours ON business.business_id = business_hours.business_id JOIN business_categories ON business.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id WHERE business.active = 'true' AND business.city = 'Phoenix' AND CAST(REPLACE(business_hours.opening_time, 'AM', '') AS INTEGER) >= 5 AND CAST(REPLACE(business_hours.opening_time, 'AM', '') AS INTEGER) < 12 GROUP BY categories.category_name ORDER BY num_active_businesses DESC LIMIT 3;
SELECT users.user_id FROM reviews JOIN business ON reviews.business_id = business.business_id JOIN business_attributes ON business.business_id = business_attributes.business_id JOIN users ON reviews.user_id = users.user_id WHERE business_attributes.attribute_value = 'Delivery' GROUP BY users.user_id ORDER BY COUNT(reviews.review_id) DESC LIMIT 1; 
SELECT AVG(user_review_count) AS average_reviews FROM business JOIN business_hours ON business.business_id = business_hours.business_id WHERE active = 'true' GROUP BY business.business_id HAVING SUM(CAST(strftime('%H', closing_time) AS INTEGER) - CAST(strftime('%H', opening_time) AS INTEGER)) <= 30;
SELECT COUNT(DISTINCT business_id) FROM business_hours WHERE opening_time = '8AM' AND closing_time = '6PM';
SELECT business_id FROM business_hours WHERE opening_time = '10AM' AND day_id = 6;
SELECT business_id, day_id FROM business_hours WHERE opening_time = '8AM' AND closing_time = '6PM';
SELECT COUNT(business_id) FROM business WHERE stars > 4;
SELECT DISTINCT categories.category_name FROM business JOIN business_hours ON business.business_id = business_hours.business_id JOIN categories ON business.business_id = categories.business_id JOIN days ON business_hours.day_id = days.day_id WHERE days.day_of_week = 'Sunday';
SELECT business_hours.business_id, days.day_of_week AS opening_day FROM business_hours JOIN days ON business_hours.day_id = days.day_id JOIN business_categories ON business_hours.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id WHERE categories.category_name = 'Pets'; 
SELECT business_id, day_id, closing_time FROM business_hours WHERE business_id IN (     SELECT    business_id     FROM     business_categories     WHERE     category_id IN (         SELECT        category_id         FROM         categories         WHERE         category_name = 'Doctors'     ) );
SELECT business_id, COUNT(DISTINCT day_id) AS working_days_count FROM business_hours WHERE day_id BETWEEN 2 AND 7 GROUP BY business_id ORDER BY working_days_count DESC LIMIT 1; 
SELECT business_id FROM business_hours INNER JOIN business_categories ON business_hours.business_id = business_categories.business_id INNER JOIN categories ON business_categories.category_id = categories.category_id INNER JOIN days ON business_hours.day_id = days.day_id WHERE days.day_of_week = 'Sunday' AND categories.category_name = 'Arts & Entertainment' AND closing_time IS NOT NULL;
SELECT COUNT(b.business_id) FROM business AS b JOIN business_categories AS bc ON b.business_id = bc.business_id WHERE bc.category_id = (     SELECT category_id     FROM categories     WHERE category_name = 'DJs' ) AND b.stars < 5;
SELECT business_id FROM business_hours WHERE opening_time = '7AM' AND closing_time = '8PM' AND business_id IN (SELECT business_id FROM business WHERE active = 'true');
SELECT COUNT(*) FROM     business WHERE     category_id IN (SELECT category_id FROM categories WHERE category_name = 'Stadiums & Arenas')     AND stars = (SELECT MAX(stars) FROM business WHERE category_id IN (SELECT category_id FROM categories WHERE category_name = 'Stadiums & Arenas'));
SELECT COUNT(DISTINCT categories.category_id) FROM     categories JOIN     business_categories ON categories.category_id = business_categories.category_id JOIN     business ON business_categories.business_id = business.business_id WHERE     business.stars > 2 GROUP BY     categories.category_id HAVING     COUNT(business.business_id) < 10;
SELECT business.business_id FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN business_hours ON business.business_id = business_hours.business_id JOIN categories ON business_categories.category_id = categories.category_id WHERE categories.category_name = 'Accessories' AND business_hours.opening_time < '7:00AM';
SELECT COUNT(DISTINCT business_id) FROM business_hours JOIN business ON business_hours.business_id = business.business_id WHERE business.state = 'Arizona' AND business.active = 'true' AND substr(opening_time, 1, 2) > '12';
SELECT business.category_name FROM business JOIN reviews ON business.business_id = reviews.business_id WHERE reviews.user_id = 16328;
SELECT COUNT(business_id) AS num_businesses_with_food_category, business.business_id, business.stars FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id WHERE categories.category_name = 'Food' GROUP BY business.business_id HAVING business.stars < 2;
SELECT (DIVIDE(COUNT(b.business_id) WHERE c.category_name = 'Food' AND bh.opening_time = '7AM' AND bh.closing_time = '8PM', COUNT(b.business_id) WHERE bh.opening_time = '7AM' AND bh.closing_time = '8PM')) * 100 AS percentage FROM business AS b JOIN business_categories AS bc ON b.business_id = bc.business_id JOIN categories AS c ON bc.category_id = c.category_id JOIN business_hours AS bh ON b.business_id = bh.business_id;
SELECT review_count, COUNT(b.business_id) AS number_of_running_business FROM business b WHERE b.city = 'Cave Creek' AND b.active = 'true' GROUP BY b.review_count; 
SELECT AVG(user_id) AS yearly_average_users FROM users WHERE user_yelping_since_year BETWEEN '2005' AND '2014';
SELECT COUNT(CASE WHEN review_count = 'Low' AND active = 'true' THEN business_id END) * 1.0 / COUNT(CASE WHEN review_count = 'Low' AND active = 'false' THEN business_id END) FROM business;
SELECT user_id FROM elite WHERE year_id = '2006' LIMIT 5; 
SELECT category_id, category_name FROM categories WHERE category_name LIKE 'P%'
SELECT users.user_id, reviews.review_stars FROM users JOIN reviews ON users.user_id = reviews.user_id WHERE reviews.review_length = 'medium' AND reviews.business_id = 35;
SELECT business_id, attribute_value FROM business_attributes WHERE attribute_id = (     SELECT attribute_id     FROM attributes     WHERE attribute_name = 'payment_types_visa' ); 
SELECT business.business_id, business.active FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id WHERE categories.category_name = 'Diagnostic Imaging';
SELECT users.user_id, users.user_yelping_since_year FROM reviews JOIN users ON reviews.user_id = users.user_id WHERE reviews.business_id = 143 AND reviews.review_stars = 5;
SELECT users.user_id, users.user_yelping_since_year FROM users JOIN users_compliments ON users.user_id = users_compliments.user_id JOIN compliments ON users_compliments.compliment_id = compliments.compliment_id WHERE compliments.compliment_type = 'profile' AND compliments.number_of_compliments = 'Uber' LIMIT 5; 
SELECT users.user_id, tips.business_id, reviews.review_length FROM tips JOIN reviews ON tips.business_id = reviews.business_id WHERE tips.likes = (     SELECT MAX(likes)     FROM tips )
SELECT users.user_id, SUM(users_compliments.number_of_compliments) AS num_compliments_photos FROM elite JOIN users ON elite.user_id = users.user_id JOIN users_compliments ON users.user_id = users_compliments.user_id WHERE elite.year_id BETWEEN 2005 AND 2014 AND users_compliments.compliment_id = (     SELECT        compliment_id     FROM         compliments     WHERE         compliment_type = 'photos' ) GROUP BY users.user_id; 
SELECT ROUND((CAST((SELECT COUNT(*) FROM business_hours WHERE opening_time = '9AM' AND closing_time = '9PM' AND day_id = 1) AS FLOAT) / CAST((SELECT COUNT(*) FROM business_hours WHERE opening_time IS NOT NULL AND closing_time IS NOT NULL AND day_id = 1) AS FLOAT)) * 100, 2) AS percentage; 
SELECT business.business_id, business_hours.day_id FROM business JOIN business_hours ON business.business_id = business_hours.business_id JOIN days ON business_hours.day_id = days.day_id WHERE business.city = 'Black Canyon City' AND business.active = 'true';
SELECT users.user_id, reviews.review_length FROM users JOIN reviews ON users.user_id = reviews.user_id WHERE users.user_yelping_since_year = 2014 AND users.user_average_stars = 5;
SELECT business.business_id FROM business JOIN reviews ON business.business_id = reviews.business_id GROUP BY business.business_id HAVING SUM(CASE WHEN reviews.review_stars > 4 THEN 1 ELSE 0 END) * 1.0 / COUNT(reviews.business_id) = 0.65 
SELECT SUM(CASE WHEN city = 'Glendale' THEN 1 ELSE 0 END) - SUM(CASE WHEN city = 'Mesa' THEN 1 ELSE 0 END) AS difference_in_business_count FROM business WHERE active = 'true';
SELECT SUM(t.likes) FROM tips t JOIN users u ON t.user_id = u.user_id WHERE u.user_yelping_since_year = 2010 AND t.tip_length = 'Short';
SELECT MAX(COUNT(t.tip_length)) AS most_common_tip_length FROM     users u JOIN     tips t ON u.user_id = t.user_id WHERE     u.user_average_stars = 3 GROUP BY     t.tip_length;
SELECT SUM(t.likes) FROM     tips t     JOIN business b ON t.business_id = b.business_id WHERE     b.city = 'Goodyear'     AND t.tip_length = 'Short';
SELECT business.state FROM business JOIN reviews ON business.business_id = reviews.business_id WHERE reviews.review_length = 'Long';
SELECT AVG(SUM(strftime('%s', closing_time) - strftime('%s', opening_time))) FROM business JOIN business_hours ON business.business_id = business_hours.business_id WHERE business.city = 'El Mirage' AND business.state = 'AZ'
SELECT days.day_of_week FROM business_hours JOIN days ON business_hours.day_id = days.day_id JOIN business ON business_hours.business_id = business.business_id WHERE business.state = 'SC' AND closing_time IS NULL;
SELECT categories.category_name FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id WHERE business.stars = 5;
SELECT business.state FROM business JOIN business_attributes ON business.business_id = business_attributes.business_id WHERE business_attributes.attribute_value = 'beer_and_wine';
SELECT COUNT(users_compliments.user_id) FROM users_compliments JOIN compliments ON users_compliments.compliment_id = compliments.compliment_id WHERE compliments.compliment_type = 'photo' AND users_compliments.number_of_compliments = 'Medium';
SELECT business.business_id FROM business JOIN business_attributes ON business.business_id = business_attributes.business_id JOIN attributes ON business_attributes.attribute_id = attributes.attribute_id WHERE attributes.attribute_name = 'Wi-Fi' AND attributes.attribute_value = 'true' AND business.state = 'SC';
SELECT COUNT(DISTINCT business_id) FROM business_attributes WHERE attribute_id IN (SELECT attribute_id FROM attributes WHERE attribute_name = 'ambience_romantic' AND attribute_value = 'true');
SELECT ROUND((SELECT COUNT(DISTINCT business_id) FROM business_attributes WHERE attribute_id IN (SELECT attribute_id FROM attributes WHERE attribute_name = 'Good for Kids' AND attribute_value = 'true')) * 100.0 / (SELECT COUNT(DISTINCT business_id) FROM business_attributes), 2) AS percentage_good_for_kids 
SELECT COUNT(*) FROM business WHERE city = 'Mesa' AND active = 'true';
SELECT COUNT(DISTINCT business_id) FROM reviews WHERE review_stars = 1 OR review_stars = 2;
SELECT business_id FROM business WHERE city = 'Paradise Valley' AND review_count = 'Low' AND stars > 3;
SELECT COUNT(DISTINCT business_id) FROM business_attributes GROUP BY business_id HAVING COUNT(DISTINCT attribute_value) > 1; 
SELECT COUNT(business_id) FROM business_hours GROUP BY business_id HAVING COUNT(DISTINCT SUBTRACT(closing_time, opening_time)) = 1;
SELECT COUNT(reviews.review_id) FROM reviews JOIN business ON reviews.business_id = business.business_id WHERE business.active = 'true' AND reviews.review_votes_funny = 'Uber';
SELECT COUNT(DISTINCT users.user_id) FROM users_compliments LEFT JOIN users ON users_compliments.user_id = users.user_id WHERE users_compliments.number_of_compliments = 'High' AND users.user_fans = 'None';
SELECT MAX(compliment_type) AS most_common_compliment FROM     users_compliments GROUP BY     user_id ORDER BY     COUNT(compliment_type) DESC LIMIT 1;
SELECT users.user_id, users.user_average_stars FROM users ORDER BY users.user_review_count DESC LIMIT 3;
SELECT category_name FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id WHERE business.city = 'Arcadia';
SELECT business.business_id FROM business JOIN business_hours ON business.business_id = business_hours.business_id JOIN days ON business_hours.day_id = days.day_id WHERE days.day_of_week = 'Sunday';
SELECT COUNT(*) FROM business JOIN business_attributes ON business.business_id = business_attributes.business_id WHERE attribute_id IN (SELECT attribute_id FROM attributes WHERE attribute_name = 'music_karaoke') AND attribute_value = 'true' AND active = 'false';
SELECT COUNT(DISTINCT business.business_id) FROM business JOIN reviews ON business.business_id = reviews.business_id WHERE business.city = 'Phoenix' AND business.active = 'true' AND reviews.review_length = 'Long';
SELECT COUNT(DISTINCT users.user_id) FROM     users JOIN     reviews ON users.user_id = reviews.user_id WHERE     users.user_votes_cool = 'Low' AND     reviews.review_votes_cool = 'Low';
SELECT COUNT(DISTINCT users.user_id) FROM tips JOIN users ON tips.user_id = users.user_id WHERE tip_length = 'Long' AND likes = 2 AND user_fans = 'High';
SELECT COUNT(DISTINCT business_id) FROM business_attributes WHERE attribute_id IN (SELECT attribute_id FROM attributes WHERE attribute_name = 'ambience_trendy') AND attribute_value = 'false';
SELECT COUNT(b.business_id) FROM business b JOIN business_hours bh ON b.business_id = bh.business_id JOIN days d ON bh.day_id = d.day_id WHERE b.city = 'Scottsdale' AND d.day_of_week = 'Sunday' AND bh.opening_time = '12PM';
SELECT AVG(b.stars) FROM business b JOIN business_categories bc ON b.business_id = bc.business_id JOIN categories c ON bc.category_id = c.category_id WHERE c.category_name = 'Obstetricians & Gynecologists'
SELECT ROUND(     (SELECT COUNT(DISTINCT elite.user_id) * 100     FROM elite     INNER JOIN users ON elite.user_id = users.user_id     WHERE users.user_fans = 'High' AND elite.year_id = (SELECT year_id FROM years WHERE actual_year = 2011))     /     (SELECT COUNT(DISTINCT elite.user_id)     FROM elite     WHERE elite.year_id = (SELECT year_id FROM years WHERE actual_year = 2011)), 2) AS percentage_of_users
SELECT COUNT(*) FROM business WHERE city = 'Surprise';
SELECT business.business_id FROM business WHERE business.city = 'Tempe' AND business.review_count = 'High';
SELECT COUNT(*) FROM business WHERE state = 'AZ' AND active = 'true' AND review_count = 'Medium';
SELECT business.business_id FROM business WHERE business.stars BETWEEN 3 AND 5 AND business.city = 'Chandler';
SELECT COUNT(users.user_id) FROM users WHERE user_yelping_since_year BETWEEN 2009 AND 2011 AND user_fans = 'Low';
SELECT reviews.review_length FROM reviews WHERE reviews.user_id = 11021 AND reviews.business_id = 3;
SELECT business_attributes.attribute_value FROM business_attributes JOIN business ON business_attributes.business_id = business.business_id WHERE business.city = 'Tempe' AND business.review_count = 'Medium';
SELECT COUNT(DISTINCT business.business_id) FROM     business JOIN     business_categories ON business.business_id = business_categories.business_id WHERE     business_categories.category_id IN (SELECT category_id FROM categories WHERE category_name = 'Food')     AND business.stars < 3;
SELECT business.business_id, business.stars FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id WHERE business.active = 'true' AND categories.category_name = 'Food';
SELECT categories.category_name, attributes.attribute_name FROM business INNER JOIN business_categories ON business.business_id = business_categories.business_id INNER JOIN categories ON business_categories.category_id = categories.category_id INNER JOIN business_attributes ON business.business_id = business_attributes.business_id INNER JOIN attributes ON business_attributes.attribute_id = attributes.attribute_id WHERE business.stars = (     SELECT MAX(stars)     FROM business ) LIMIT 1;
SELECT categories.category_name FROM business JOIN reviews ON business.business_id = reviews.business_id JOIN categories ON business.business_id = categories.business_id WHERE reviews.review_length = 'Short' AND business.business_id BETWEEN 7 AND 14 GROUP BY categories.category_name ORDER BY MAX(reviews.review_stars) DESC LIMIT 1;
SELECT COUNT(b.business_id) FROM business b JOIN business_attributes ba ON b.business_id = ba.business_id JOIN categories c ON b.business_id = c.business_id WHERE b.active = 'true' AND c.category_name = 'Food' AND ba.attribute_value = 'BYOB' AND b.review_count = 'High';
SELECT business.business_id, business.opening_time, business.closing_time FROM business WHERE business.city = 'Glendale' AND business.stars = ( SELECT MAX(stars) FROM business WHERE city = 'Glendale' );
SELECT business_categories.category_id, business_attributes.attribute_id FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN business_attributes ON business.business_id = business_attributes.business_id WHERE business.active = 'true' AND business.city = 'Goodyear' AND business.state = 'AZ' AND business.review_count = 'High';
SELECT categories.category_name FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id WHERE business.active = 'true' AND business.city = 'Glendale' AND business.state = 'AZ';
SELECT business.city FROM business JOIN business_hours ON business.business_id = business_hours.business_id JOIN days ON business_hours.day_id = days.day_id WHERE days.day_of_week = 'Wednesday' AND business_hours.opening_time = '7AM' AND business_hours.closing_time = '7PM';
SELECT business_attributes.attribute_value FROM business JOIN business_attributes ON business.business_id = business_attributes.business_id WHERE business.active = 'true' AND business.review_count = 'Low' AND business.stars = 3 AND business.city = 'Goodyear' AND business.state = 'AZ';
SELECT business_hours.opening_time FROM business JOIN business_hours ON business.business_id = business_hours.business_id WHERE business.active = 'true' AND business.city = 'Glendale' AND business.review_count = 'Medium';
SELECT ROUND(CAST(SUM(CASE WHEN stars > 3 THEN 1 ELSE 0 END) AS FLOAT) / CAST(COUNT(*) AS FLOAT), 2) AS percentage_of_business_with_greater_than_3_stars FROM business JOIN business_categories ON business.business_id = business_categories.business_id JOIN categories ON business_categories.category_id = categories.category_id WHERE categories.category_name = 'Food'; 
SELECT business_hours.closing_time, days.day_of_week FROM business JOIN business_hours ON business.business_id = business_hours.business_id JOIN days ON business_hours.day_id = days.day_id WHERE business.active = 'true' AND business.city = 'Goodyear' AND business.stars > (SELECT AVG(stars) * 0.8 FROM business)
SELECT (SELECT (COUNT(DISTINCT paper.paper_id) * 100.0) / COUNT(DISTINCT cites.cited_paper_id) FROM paper JOIN content ON paper.paper_id = content.paper_id JOIN cites ON content.paper_id = cites.cited_paper_id WHERE paper.class_label = 'Agents') 
SELECT word_cited_id, COUNT(DISTINCT paper_id) AS cited_in_papers FROM content GROUP BY word_cited_id ORDER BY cited_in_papers DESC LIMIT 1; 
SELECT COUNT(DISTINCT word_cited_id) FROM content JOIN paper ON content.paper_id = paper.paper_id WHERE paper.class_label = 'AI'; 
SELECT DISTINCT cites.citing_paper_id, paper.class_label FROM cites JOIN content ON content.word_cited_id = cites.cited_paper_id JOIN paper ON paper.paper_id = cites.citing_paper_id WHERE content.paper_id != 315017;
SELECT word_cited_id FROM     cites JOIN     paper ON cites.citing_paper_id = paper.paper_id JOIN     content ON content.paper_id = paper.paper_id WHERE     paper.class_label = 'DB' GROUP BY     word_cited_id ORDER BY     COUNT(word_cited_id) DESC LIMIT 1; 
SELECT (SELECT (COUNT(word_cited_id) * 100.0) / (SELECT COUNT(word_cited_id) FROM content JOIN paper ON content.paper_id = paper.paper_id WHERE class_label = 'Agents') FROM content JOIN paper ON content.paper_id = paper.paper_id WHERE class_label = 'Agents') 
SELECT citing_paper_id, class_label FROM (     SELECT        cites.citing_paper_id,         paper.class_label,         COUNT(content.word_cited_id) AS word_count     FROM         cites     JOIN paper ON cites.citing_paper_id = paper.paper_id     JOIN content ON content.paper_id = cites.citing_paper_id     GROUP BY         cites.citing_paper_id     ORDER BY         word_count DESC     LIMIT 1 ) AS most_cited_paper; 
SELECT cites.citing_paper_id, paper.class_label FROM cites JOIN content ON cites.citing_paper_id = content.paper_id JOIN paper ON cites.citing_paper_id = paper.paper_id WHERE content.word_cited_id = 'word1002';
SELECT word_cited_id FROM content JOIN paper ON content.paper_id = paper.paper_id WHERE paper.class_label = 'AI'; 
SELECT p.class_label, COUNT(c.word_cited_id) AS cited_words_count FROM paper p JOIN content c ON p.paper_id = c.paper_id WHERE p.paper_id = 'chakrabarti01integrating'; 
SELECT paper_id, class_label FROM paper JOIN content ON paper.paper_id = content.paper_id GROUP BY paper.paper_id, class_label HAVING COUNT(word_cited_id) > 20; 
SELECT DISTINCT c1.word_cited_id FROM content c1 JOIN cites ci ON c1.paper_id = ci.cited_paper_id JOIN content c2 ON ci.citing_paper_id = c2.paper_id JOIN paper p1 ON c1.paper_id = p1.paper_id JOIN paper p2 ON c2.paper_id = p2.paper_id WHERE p1.class_label = 'AI' AND p2.class_label = 'IR'; 
SELECT paper.paper_id, COUNT(cites.cited_paper_id) AS cited_count FROM cites INNER JOIN paper ON cites.cited_paper_id = paper.paper_id GROUP BY paper.paper_id ORDER BY cited_count DESC LIMIT 1;  SELECT paper.paper_id, COUNT(cites.cited_paper_id) AS cited_count FROM cites INNER JOIN paper ON cites.cited_paper_id = paper.paper_id GROUP BY paper.paper_id ORDER BY cited_count ASC LIMIT 1; 
SELECT ROUND(AVG(CASE WHEN class_label = 'ML' THEN 1 ELSE 0 END), 2) AS average_ml_papers FROM paper;
SELECT DISTINCT content.word_cited_id FROM content JOIN cites ON content.paper_id = cites.cited_paper_id WHERE cites.citing_paper_id = 'sima01computational'; 
SELECT COUNT(DISTINCT cites.cited_paper_id) FROM cites JOIN content ON cites.citing_paper_id = content.paper_id WHERE content.word_cited_id = 'word3555';
SELECT DISTINCT p.class_label FROM cites c JOIN paper p ON c.citing_paper_id = p.paper_id JOIN content ct ON p.paper_id = ct.paper_id WHERE ct.word_cited_id = 'word1163'; 
SELECT paper.paper_id, SUM(COUNT(content.word_cited_id)) AS num_words_cited FROM paper JOIN content ON paper.paper_id = content.paper_id JOIN cites ON paper.paper_id = cites.citing_paper_id WHERE paper.class_label = 'DB' GROUP BY paper.paper_id ORDER BY num_words_cited DESC LIMIT 1; 
SELECT COUNT(*) FROM   paper JOIN   cites ON paper.paper_id = cites.cited_paper_id WHERE   paper.class_label = 'ML' AND   cites.citing_paper_id = 'butz01algorithmic';
SELECT person.name FROM credit JOIN episode ON credit.episode_id = episode.episode_id JOIN person ON credit.person = person.name WHERE episode.season = '20' ORDER BY person.birthdate ASC LIMIT 1;
SELECT nickname FROM person WHERE name = "Dan Castellaneta";
SELECT COUNT(DISTINCT person.name) FROM     credit     JOIN person ON credit.person = person.name WHERE     credit.category = 'crew'     AND person.birth_region = 'New York'     AND strftime('%Y', person.birthdate) > '1970';
SELECT person.birth_country FROM     person JOIN     award ON award.person = person.name JOIN     character_award ON character_award.award_id = award.award_id WHERE     award.award_category = 'Outstanding Voice-Over Performance'     AND award.year = 2009     AND character_award.result = 'Winner';
SELECT award.award FROM award JOIN person ON award.person = person.name WHERE person.nickname = 'Doofus' AND award.result = 'Winner';
SELECT COUNT(DISTINCT credit.person) FROM     credit JOIN     person ON credit.person = person.name JOIN     award ON credit.episode_id = award.episode_id WHERE     award.year = 2009     AND award.award_category = 'Outstanding Animated Program (For Programming Less Than One Hour)'     AND person.birth_country = 'USA'     AND award.result = 'Nominee';
SELECT character_award.character FROM character_award JOIN award ON character_award.award_id = award.award_id WHERE award.award_category = 'Outstanding Voice-Over Performance' AND award.year = 2009 AND award.result = 'Winner';
SELECT keyword.keyword FROM episode JOIN keyword ON episode.episode_id = keyword.episode_id WHERE episode.title = "Lost Verizon";
SELECT COUNT(keyword.keyword) FROM     episode JOIN     keyword ON episode.episode_id = keyword.episode_id WHERE     episode.air_date = '2008-10-19';
SELECT episode.rating FROM episode JOIN award ON episode.episode_id = award.episode_id JOIN person ON award.person = person.name WHERE person.name = 'Dan Castellaneta' AND award.year = 2009 AND award.result = 'Winner';
SELECT COUNT(*) FROM vote JOIN episode ON vote.episode_id = episode.episode_id WHERE episode.title = 'Lost Verizon' AND vote.stars = 7;
SELECT MAX(stars)  FROM vote  WHERE episode_id = (SELECT episode_id FROM episode WHERE title = "Lost Verizon")
SELECT episode.title FROM episode JOIN vote ON episode.episode_id = vote.episode_id WHERE vote.stars = 10 AND vote.votes > 200;
SELECT COUNT(*)  FROM episode  JOIN vote ON episode.episode_id = vote.episode_id  WHERE air_date LIKE '2009%' AND stars = 10 AND percent > 15;
SELECT episode.title FROM     episode JOIN     vote ON episode.episode_id = vote.episode_id WHERE     vote.stars = 7 GROUP BY     episode.title ORDER BY     MAX(vote.votes) DESC LIMIT 1;
SELECT AVG(stars) AS average_stars FROM     vote JOIN     episode ON vote.episode_id = episode.episode_id WHERE     episode.title = "Lost Verizon"
SELECT 100 * (     SELECT COUNT(DISTINCT e.episode_id)      FROM episode e      JOIN award a ON e.episode_id = a.episode_id      WHERE a.award_category = 'Primetime Emmy' AND e.rating > 7 ) / (     SELECT COUNT(DISTINCT episode_id)      FROM episode      WHERE rating > 7 );
SELECT title FROM     episode WHERE     episode_id IN (         SELECT            episode_id         FROM             credit         WHERE             person = 'Pamela Hayden'             AND role = 'Ruthie'     );
SELECT role, episode.episode, episode.number_in_series FROM credit JOIN episode ON credit.episode_id = episode.episode_id JOIN person ON credit.person = person.name WHERE person.name = 'Matt Groening' AND episode.title = 'In the Name of the Grandfather';
SELECT title, summary FROM episode WHERE episode_id IN (     SELECT episode_id     FROM keyword     WHERE keyword = 'eviction' ); 
SELECT AVG(stars) FROM   episode JOIN   vote ON episode.episode_id = vote.episode_id WHERE   episode.title = 'Wedding for Disaster';
SELECT episode.title, keyword.keyword FROM episode JOIN keyword ON episode.episode_id = keyword.episode_id WHERE episode.air_date = '2009-03-22';
SELECT person.birth_name FROM     person JOIN     credit ON person.name = credit.person JOIN     episode ON credit.episode_id = episode.episode_id WHERE     credit.role = 'Helen Lovejoy';
SELECT episode.title, (SELECT     COUNT(credit.person)  FROM      credit  WHERE      credit.episode_id = episode.episode_id  AND      credit.credited = '') AS uncredited_roles, (SELECT     COUNT(credit.person)  FROM      credit  WHERE      credit.episode_id = episode.episode_id  AND      credit.credited = 'true') AS credited_roles, (((SELECT         COUNT(credit.person)     FROM          credit     WHERE          credit.episode_id = episode.episode_id     AND          credit.credited = '')     /     (SELECT         COUNT(credit.person)     FROM          credit     WHERE          credit.episode_id = episode.episode_id     AND          credit.credited = 'true')) * 100) AS percentage_ratio FROM     episode JOIN      award  ON      award.episode_id = episode.episode_id WHERE      award.year = 2017 AND      award.award_category = 'Jupiter Award' AND      award.award = 'Best International TV Series' AND      award.result = 'Winner';
SELECT COUNT(*) FROM episode WHERE votes > 1000;
SELECT COUNT(*) FROM person WHERE birth_place = 'New York' AND birth_region = 'USA';
SELECT award.award, award.award_category FROM award JOIN person ON award.person = person.name WHERE person.name = "Marc Wilmore";
SELECT person.name, person.nickname FROM person WHERE person.nickname IS NOT NULL;
SELECT person.name, AVG(person.height_meters) AS average_height FROM person GROUP BY person.name;
SELECT MAX(votes) - MIN(votes) AS vote_difference FROM vote;
SELECT character_award.character FROM     character_award JOIN     award ON character_award.award_id = award.award_id WHERE     award.award_category = 'Outstanding Voice-Over Performance'     AND award.year = 2009;
SELECT COUNT(DISTINCT person.name) FROM award JOIN person ON award.person = person.name WHERE award.result = 'Nominee' AND award.year = 2009 AND person.birth_place = 'California';
SELECT episode.title FROM episode JOIN award ON award.episode_id = episode.episode_id WHERE award.award_category = 'Best International TV Series Award' AND award.year = 2017 AND award.result = 'Winner';
SELECT person.name FROM person WHERE person.name NOT IN (     SELECT credit.person     FROM credit     INNER JOIN episode ON credit.episode_id = episode.episode_id     WHERE episode.title = 'How the Test Was Won'     AND credit.credited = ' ' ); 
SELECT episode.title FROM episode JOIN keyword ON episode.episode_id = keyword.episode_id WHERE keyword.keyword = 'riot' AND keyword.keyword = 'cake';
SELECT episode.episode_id FROM vote JOIN episode ON vote.episode_id = episode.episode_id WHERE vote.stars = 10 ORDER BY vote.votes DESC LIMIT 1;
SELECT person.name FROM person JOIN credit ON person.name = credit.person JOIN episode ON credit.episode_id = episode.episode_id WHERE episode.title LIKE 'simpson 20s%' AND strftime('%m', episode.air_date) BETWEEN '10' AND '11'; 
SELECT person.name FROM episode JOIN credit ON episode.episode_id = credit.episode_id JOIN person ON credit.person = person.name WHERE episode.title = 'Treehouse of Horror XIX' AND credit.role = 'director';
SELECT COUNT(DISTINCT credit.role) FROM credit WHERE credit.episode_id = 5;
SELECT keyword.keyword FROM keyword JOIN episode ON keyword.episode_id = episode.episode_id WHERE episode.title = 'Take My Life, Please'; 
SELECT COUNT(DISTINCT episode.episode_id) * 100.0 / (SELECT COUNT(DISTINCT episode.episode_id) FROM episode JOIN award ON episode.episode_id = award.episode_id WHERE year = 2009 AND award_category = 'Outstanding Voice-Over Performance' AND votes > 950) AS percentage FROM episode JOIN award ON episode.episode_id = award.episode_id WHERE year = 2009 AND award_category = 'Outstanding Voice-Over Performance' AND result = 'Nominee' AND votes > 950;
SELECT CAST((SELECT votes FROM vote WHERE episode_id = (SELECT episode_id FROM episode WHERE title = 'No Loan Again, Naturally') AND stars = 5) AS FLOAT) / CAST((SELECT votes FROM vote WHERE episode_id = (SELECT episode_id FROM episode WHERE title = 'Coming to Homerica') AND stars = 5) AS FLOAT)
SELECT COUNT(*) FROM award WHERE person = 'Ian Maxtone-Graham' AND organization = 'Writers Guild of America, USA' AND result = 'Nominee';
SELECT person.name FROM award JOIN person ON award.person = person.name WHERE award.result = 'Nominee' GROUP BY person.name HAVING COUNT(*) = (     SELECT MAX(nominated_count)     FROM (         SELECT COUNT(*) as nominated_count         FROM award         WHERE result = 'Nominee'         GROUP BY person     ) )
SELECT title FROM episode WHERE rating = (SELECT MIN(rating) FROM episode);
SELECT MIN(year) FROM award WHERE award_category = 'People\'s Choice Award' AND award = 'Favorite Animated Comedy' AND result = 'Winner' AND person = 'The Simpsons';
SELECT COUNT(DISTINCT episode.episode_id) FROM     episode LEFT JOIN     credit ON episode.episode_id = credit.episode_id AND credit.person = 'Dell Hake' WHERE     credit.credited = '' OR credit.credited IS NULL;
SELECT SUBTRACT(award.year, SUBSTR(person.birthdate, 0, 5)) AS age_at_award FROM     award JOIN     person ON award.person = person.name WHERE     award.award_category = 'Outstanding Voice-Over Performance'     AND award.organization = 'Primetime Emmy Awards'     AND award.result = 'Winner' ORDER BY     award.year LIMIT 1;
SELECT character_award.character FROM     character_award JOIN     award ON character_award.award_id = award.award_id JOIN     person ON award.person = person.name WHERE     person.name = 'Dan Castellaneta'     AND award.award_category = 'Outstanding Voice-Over Performance'     AND award.organization = 'Primetime Emmy Awards'     AND award.year = 2009     AND award.result = 'Winner';
SELECT COUNT(DISTINCT episode.episode_id) FROM     episode INNER JOIN award ON episode.episode_id = award.episode_id WHERE     SUBSTR(episode.air_date, 6, 2) = '04'     AND SUBSTR(episode.air_date, 0, 5) = '2009';
SELECT person.birth_place FROM     person JOIN     award ON person.name = award.person JOIN     character_award ON award.award_id = character_award.award_id JOIN     credit ON person.name = credit.person WHERE     award.award_category = 'Best Voice-Over Performance'     AND award.organization = 'Online Film & Television Association'     AND award.year = 2009     AND character_award.result = 'Winner';
SELECT COUNT(*) FROM     vote WHERE     stars = 10     AND episode_id IN (         SELECT            episode_id         FROM             episode         ORDER BY             rating DESC         LIMIT 4     );
SELECT SUM(stars) AS total_stars FROM     episode JOIN     vote ON episode.episode_id = vote.episode_id WHERE     episode.title = "No Loan Again, Naturally" AND     vote.votes <= 50;
SELECT COUNT(DISTINCT person.name) FROM     award JOIN     person ON award.person = person.name WHERE     award.result = 'Winner' AND     person.birth_country = 'USA';
SELECT COUNT(*) FROM credit WHERE episode_id = 'S20-E11' AND person IN (SELECT name FROM person WHERE nickname = 'Doofus') AND credited = 'true';
SELECT MIN(year), person.name FROM award JOIN person ON award.person = person.name WHERE result = 'Winner'
SELECT AVG(percent) FROM     vote WHERE     episode_id = (         SELECT            episode_id         FROM             episode         WHERE             title = "Sex, Pies and Idiot Scrapes"     ) AND     stars = 9;
SELECT award, person.name FROM award JOIN person ON award.person = person.name WHERE award.result = 'Winner' AND award.year = 2009;
SELECT person.name, person.birthdate FROM person WHERE person.birth_place = 'Los Angeles' AND person.height_meters >= 1.8; 
SELECT episode.episode, episode.title, episode.rating FROM episode WHERE Substr(episode.air_date, 6, 2) = '10' AND Substr(episode.air_date, 0, 5) = '2008';
SELECT award.award_id, award.award, award.person FROM award JOIN character_award ON award.award_id = character_award.award_id JOIN person ON award.person = person.name WHERE character_award.character = "Homer simpson 20" AND award.result = "Winner";
SELECT award.award,     award.result,     credit.category,     credit.credited FROM     award JOIN     person ON award.person = person.name JOIN     credit ON credit.person = person.name WHERE     person.name = 'Billy Kimball';
SELECT person.name, award.award, award.organization, award.result, credit.credited  FROM person JOIN credit ON person.name = credit.person JOIN episode ON credit.episode_id = episode.episode_id JOIN award ON award.episode_id = episode.episode_id  WHERE credit.role = 'assistant director' AND episode.episode_id = 'S20-E13' AND credit.credited = 'true';
SELECT person.name, person.birth_country, person.height_meters FROM person LEFT JOIN credit ON person.name = credit.person WHERE credit.person IS NULL AND credit.category = 'Casting Department';
SELECT person.name AS nominee, keyword.keyword, episode.episode_id FROM episode JOIN award ON award.episode_id = episode.episode_id JOIN person ON award.person = person.name JOIN keyword ON keyword.episode_id = episode.episode_id WHERE episode.title = 'The Good, the Sad and the Drugly';
SELECT MAX(votes) AS max_votes, MAX(percent) AS max_percent FROM vote JOIN episode ON vote.episode_id = episode.episode_id JOIN keyword ON episode.episode_id = keyword.episode_id WHERE keyword.keyword = "arab stereotype"
SELECT award.award_category, episode.air_date, episode.rating FROM award JOIN episode ON award.episode_id = episode.episode_id WHERE award.organization = 'Jupiter Award' AND award.result = 'Winner' 
SELECT episode.episode_id, episode.title, GROUP_CONCAT(keyword.keyword) AS keywords FROM episode JOIN vote ON episode.episode_id = vote.episode_id JOIN keyword ON episode.episode_id = keyword.episode_id WHERE vote.stars = 1 GROUP BY episode.episode_id, episode.title ORDER BY MAX(vote.votes) DESC LIMIT 1;
SELECT episode.title, episode.episode_image, award.award, award.person FROM episode JOIN award ON award.episode_id = episode.episode_id WHERE episode.air_date LIKE '2008%' AND episode.rating >= 7 AND episode.rating <= 10 AND award.result = 'Nominee';
SELECT award.title, award.person, character_award.character FROM award JOIN character_award ON award.award_id = character_award.award_id WHERE award.award_id = 326; 
SELECT person.name, person.birth_country, credit.role, 2022 - substr(person.birthdate, 0, 5) AS age_in_2022 FROM person JOIN credit ON person.name = credit.person ORDER BY person.birthdate ASC LIMIT 1; 
SELECT COUNT(credit.person) AS number_of_credits, credit.category, credit.role, person.birth_place FROM credit JOIN person ON credit.person = person.name WHERE person.birth_country = 'North Korea';
SELECT COUNT(award.result = 'winner') * 1.0 / COUNT(*), person.name, award.award, episode.title, award.role FROM award JOIN person ON award.person = person.name JOIN episode ON award.episode_id = episode.episode_id WHERE award.year = 2010 AND award.result = 'winner' GROUP BY person.name;
SELECT episode.title FROM episode JOIN vote ON episode.episode_id = vote.episode_id WHERE vote.stars = (SELECT MAX(stars) FROM vote) AND vote.votes = (SELECT MAX(votes) FROM vote);
SELECT COUNT(award.award_id) AS total_awards_won FROM     award WHERE     award.episode_id IN (         SELECT            episode_id         FROM             episode         WHERE             season = 20             AND title LIKE '%The simpson 20s%'     )     AND result = 'Winner';
SELECT episode.title FROM episode JOIN award ON episode.episode_id = award.episode_id WHERE award.award_category = 'Outstanding Animated Program (For Programming Less Than One Hour)' AND award.award = 'Primetime Emmy Awards' AND award.result = 'Nominee' GROUP BY episode.title HAVING COUNT(award.episode_id) = 21;
SELECT AVG(stars) FROM vote WHERE episode_id = 'S20-E12';
SELECT person.name FROM person JOIN award ON person.name = award.person JOIN character_award ON award.award_id = character_award.award_id WHERE award.award_category = 'Outstanding Voice-Over Performance' AND award.organization = 'Primetime Emmy Awards' AND character_award.character = 'Homer simpson 20' AND award.result = 'Winner'; 
SELECT person.birth_name, credit.role FROM person JOIN credit ON person.name = credit.person JOIN episode ON credit.episode_id = episode.episode_id WHERE person.name = 'Al Jean' AND episode.season = 20 
SELECT COUNT(*) FROM     award JOIN     person ON award.person = person.name JOIN     episode ON award.episode_id = episode.episode_id WHERE     person.name = 'Billy Kimball'     AND award.year = 2010     AND award.result = 'Nominee'     AND episode.season = '20'     AND episode.title = 'The simpson 20s: Season 20';
SELECT keyword.keyword FROM episode JOIN keyword ON episode.episode_id = keyword.episode_id WHERE episode.title = 'Take My Life, Please';
SELECT award.award, award.award_category FROM award INNER JOIN episode ON award.episode_id = episode.episode_id WHERE award.result = 'Winner' ORDER BY award.year DESC LIMIT 1;
SELECT ROUND(     (SELECT SUM(CASE WHEN result = 'winner' THEN 1 ELSE 0 END)       FROM award       WHERE season = 20) /     (SELECT COUNT(award_id)       FROM award       WHERE season = 20),      2) AS average_awards_winning_rate;
SELECT COUNT(*) FROM episode WHERE air_date BETWEEN '2008-10-01' AND '2008-11-30';
SELECT episode.title FROM episode WHERE episode.air_date LIKE '2009%' ORDER BY episode.rating ASC LIMIT 1;
SELECT category, role FROM credit WHERE person = 'Bonita Pietila'; 
SELECT person.name FROM person INNER JOIN credit ON person.name = credit.person INNER JOIN episode ON credit.episode_id = episode.episode_id WHERE episode.season = 20 AND (episode.title LIKE '%The simpson 20s%' OR episode.title LIKE '%The Simpsons Season 20%') AND person.birthdate = '1957-10-29' AND person.birth_place = 'Chicago' AND person.birth_region = 'Illinois'; 
SELECT person.name FROM credit JOIN episode ON credit.episode_id = episode.episode_id JOIN person ON credit.person = person.name WHERE episode.title = 'The Simpsons 20s' AND episode.season = 20 AND credit.role = 'producer';
SELECT person.name, 2009 - person.birthdate AS age FROM award JOIN person ON award.person = person.name WHERE award.organization = 'Primetime Emmy Awards' AND award.year = 2009 AND award.result = 'Nominee' AND award.award_category = 'Outstanding Music Composition for a Series (Original Dramatic Score)' AND award.role = 'composer';
SELECT episode.title FROM episode JOIN award ON award.episode_id = episode.episode_id WHERE episode.season = 20 AND episode.title LIKE 'The simpson 20s%' GROUP BY episode.title ORDER BY COUNT(award.episode_id) DESC LIMIT 1; 
SELECT person.birth_place FROM person WHERE person.name = 'Dan Castellaneta'; 
SELECT COUNT(DISTINCT person.name) FROM     person WHERE     person.birth_country = 'USA';
SELECT name FROM person WHERE birthdate < '1970-01-01'; 
SELECT person.name FROM person WHERE person.birth_place = 'California' AND person.birth_country = 'USA' AND person.birthdate BETWEEN '1958-01-01' AND '1969-12-31' 
SELECT episode.episode_id FROM episode JOIN vote ON episode.episode_id = vote.episode_id WHERE vote.stars = 5 AND vote.votes > 100;
SELECT keyword.keyword FROM episode JOIN keyword ON episode.episode_id = keyword.episode_id WHERE episode.title = "Double, Double, Boy in Trouble"; 
SELECT episode_id FROM episode JOIN vote ON episode.episode_id = vote.episode_id WHERE episode.episode_id BETWEEN 10 AND 20 GROUP BY episode.episode_id HAVING COUNT(vote.votes) > 200;
SELECT keyword.keyword FROM keyword JOIN episode ON keyword.episode_id = episode.episode_id JOIN award ON award.episode_id = episode.episode_id WHERE award.award_category = 'Primetime Emmy'
SELECT MAX(votes) as max_votes, person.name as recipient FROM award JOIN person ON award.person = person.name WHERE award_category = 'Primetime Emmy' GROUP BY award_id;
SELECT episode.episode_id FROM award JOIN episode ON award.episode_id = episode.episode_id JOIN vote ON award.episode_id = vote.episode_id WHERE award.award = 'Outstanding Animated Program (For Programming Less Than One Hour)' AND vote.stars = 10;
SELECT person.name FROM     person JOIN     award ON award.person = person.name JOIN     credit ON credit.person = person.name AND credit.episode_id = award.episode_id JOIN     episode ON episode.episode_id = credit.episode_id WHERE     award.award_category = 'Outstanding Animated Program (For Programming Less Than One Hour)'     AND episode.title = 'No Loan Again, Naturally'     AND credit.role = 'director';
SELECT person.name FROM person JOIN credit ON person.name = credit.person JOIN episode ON credit.episode_id = episode.episode_id JOIN vote ON episode.episode_id = vote.episode_id WHERE credit.role = 'writer' AND vote.stars > 5 AND vote.year = 2009; 
SELECT COUNT(DISTINCT award.person)  FROM      award     JOIN person ON award.person = person.name WHERE      award_category = 'WGA Award (TV)'      AND person.birth_country = 'USA'      AND strftime('%Y', person.birthdate) BETWEEN '2009' AND '2010';
SELECT episode.title FROM episode JOIN award ON episode.episode_id = award.episode_id JOIN credit ON episode.episode_id = credit.episode_id JOIN person ON credit.person = person.name WHERE award.award_category = 'Outstanding Music Composition for a Series (Original Dramatic Score)' AND award.role = 'composer' AND vote.votes > 200;
SELECT episode.title FROM episode JOIN award ON award.episode_id = episode.episode_id JOIN person ON award.person = person.name WHERE person.name = 'Al Jean' AND award.award_category = 'Primetime Emmy Award' AND award.year = 2009;
SELECT SUM(CASE WHEN episode.episode_id = 1 THEN vote.votes ELSE 0 END) - SUM(CASE WHEN episode.episode_id = 5 THEN vote.votes ELSE 0 END) AS more_votes FROM episode LEFT JOIN vote ON episode.episode_id = vote.episode_id;
SELECT award.award FROM     award JOIN     character_award ON award.award_id = character_award.award_id JOIN     person ON award.person = person.name WHERE     character_award.character = 'Homer Simpson 20'     AND award.year = 2009;
SELECT COUNT(DISTINCT episode.episode_id) AS total_episodes,     COUNT(DISTINCT CASE WHEN award.award_category = 'Outstanding Animated Program (Programming Under One Hour)' AND vote.votes < 100 THEN episode.episode_id END) AS episodes_with_less_than_100_votes,     (COUNT(DISTINCT CASE WHEN award.award_category = 'Outstanding Animated Program (Programming Under One Hour)' AND vote.votes < 100 THEN episode.episode_id END) / COUNT(DISTINCT episode.episode_id)) * 100 AS percentage_of_episodes_with_less_than_100_votes FROM     episode JOIN award ON award.episode_id = episode.episode_id JOIN vote ON vote.episode_id = episode.episode_id;
SELECT COUNT(DISTINCT person) FROM award JOIN person ON award.person = person.name WHERE award_category = 'Primetime Emmy Award' AND person.birth_country = 'USA';
SELECT person.name FROM award JOIN person ON award.person = person.name WHERE award.award_category = 'Outstanding Voice-Over Performance' AND award.season LIKE 'S20%' 
SELECT COUNT(DISTINCT credit.person) AS num_executive_producers FROM     credit JOIN     award ON credit.episode_id = award.episode_id WHERE     award.award_category = 'Outstanding Animated Program (For Programming Less Than One Hour)'     AND award.result = 'Nominee'     AND credit.role = 'executive producer';
SELECT person.name FROM person WHERE year(birthdate) = 1962 AND birth_region = 'California';
SELECT COUNT(DISTINCT credit.person) FROM credit JOIN person ON credit.person = person.name WHERE person.height_meters > 1.70 AND person.birth_country = 'Canada';
SELECT COUNT(DISTINCT person.name) FROM award JOIN person ON award.person = person.name WHERE award_category = 'Animation' AND result = 'Nominee';
SELECT episode.title FROM episode WHERE episode.rating > 7 AND episode.rating <= 10 LIMIT 3; 
SELECT episode_id, MAX(votes) AS max_votes FROM vote GROUP BY episode_id ORDER BY max_votes DESC LIMIT 5;
SELECT episode.title,   MAX(vote.votes) AS max_votes FROM   episode JOIN   vote ON episode.episode_id = vote.episode_id WHERE   vote.stars = 1 GROUP BY   episode.title ORDER BY   max_votes DESC LIMIT   3;
SELECT character_award.character FROM character_award JOIN award ON character_award.award_id = award.award_id JOIN person ON award.person = person.name WHERE person.name = 'Dan Castellaneta' AND award.award_category LIKE '%Voice-Over%';
SELECT episode.title FROM episode JOIN vote ON episode.episode_id = vote.episode_id WHERE vote.stars = 10 AND vote.votes = (     SELECT    MAX(votes)     FROM     vote     WHERE     stars = 10 ) AND episode.air_date LIKE '2008%'
SELECT keyword.keyword FROM keyword JOIN episode ON keyword.episode_id = episode.episode_id WHERE episode.title = 'Take My Life, Please';
SELECT e1.title FROM episode e1 JOIN keyword k1 ON e1.episode_id = k1.episode_id JOIN episode e2 ON k1.keyword = e2.keyword WHERE e2.title <> e1.title AND k1.keyword = "1930s to 2020s"; 
SELECT episode.title FROM award JOIN episode ON award.episode_id = episode.episode_id JOIN person ON award.person = person.name WHERE award.year = 2010 AND person.name = 'Joel H. Cohen';
SELECT COUNT(vote.episode_id) FROM     vote JOIN     episode ON vote.episode_id = episode.episode_id WHERE     episode.title = 'Lisa the Drama Queen' AND     vote.stars = 5;
SELECT COUNT(vote.votes) FROM     vote JOIN     episode ON vote.episode_id = episode.episode_id JOIN     keyword ON episode.episode_id = keyword.episode_id WHERE     keyword.keyword = "reference to the fantastic four" AND     vote.stars = 10;
SELECT SUM(CASE WHEN stars = 1 THEN votes ELSE 0 END) - SUM(CASE WHEN stars = 10 THEN votes ELSE 0 END) AS "Difference" FROM vote JOIN episode ON vote.episode_id = episode.episode_id WHERE episode.title = 'The Burns and the Bees';
SELECT keyword.keyword FROM keyword JOIN episode ON keyword.episode_id = episode.episode_id JOIN vote ON episode.episode_id = vote.episode_id WHERE vote.votes = (SELECT MIN(votes) FROM vote)
SELECT episode_id, season, episode, number_in_series, title, summary, air_date, episode_image, rating, votes FROM episode WHERE rating > 5 AND rating <= 7 AND votes > 20 AND stars = 2; 
SELECT episode.title FROM episode ORDER BY votes DESC LIMIT 1;
SELECT MIN(birthdate) as oldest_birthdate FROM person;
SELECT episode.title FROM episode JOIN credit ON episode.episode_id = credit.episode_id JOIN person ON credit.person = person.name WHERE person.name = 'Oscar Cervantes' AND credit.credited = 'true';
SELECT person.name, person.birth_country, credit.role FROM person JOIN credit ON person.name = credit.person WHERE person.birth_country != 'USA' 
SELECT COUNT(*) FROM vote JOIN episode ON vote.episode_id = episode.episode_id WHERE episode.rating = (SELECT MIN(rating) FROM episode) AND vote.stars = 1;
SELECT character_award.character FROM character_award JOIN award ON character_award.award_id = award.award_id WHERE award.award_category = 'Outstanding Voice-Over Performance' AND award.award = 'Winner';
SELECT summary FROM episode WHERE episode_id IN (     SELECT episode_id     FROM credit     WHERE person = 'Emily Blunt' ); 
SELECT person.name AS character FROM     credit JOIN     person ON credit.person = person.name JOIN     episode ON credit.episode_id = episode.episode_id WHERE     person.nickname = 'The Tiny Canadian';
SELECT episode.title, MAX(vote.percent) AS highest_percent_5_star_votes FROM episode JOIN award ON award.episode_id = episode.episode_id JOIN vote ON vote.episode_id = episode.episode_id WHERE vote.stars = 5 GROUP BY episode.title;
SELECT credit.person FROM credit JOIN episode ON credit.episode_id = episode.episode_id WHERE episode.title = 'In the Name of the Grandfather' AND credit.category = 'Cast' AND credit.credited = 'true'; 
SELECT person.birthdate FROM award JOIN person ON award.person = person.name WHERE award.result = 'Winner' 
SELECT person.name FROM     person JOIN     credit ON person.name = credit.person JOIN     episode ON credit.episode_id = episode.episode_id JOIN     vote ON episode.episode_id = vote.episode_id WHERE     credit.role = 'Writer' AND     vote.stars = 10 AND     vote.votes = (SELECT MAX(votes) FROM vote WHERE stars = 10)
SELECT award.award_category FROM award JOIN episode ON award.episode_id = episode.episode_id WHERE episode.air_date = '11/30/2008' AND award.result = 'Winner';
SELECT episode.title, person.name, person.role FROM credit JOIN episode ON credit.episode_id = episode.episode_id JOIN person ON credit.person = person.name WHERE credit.category = 'Music Department';
SELECT keyword.keyword FROM keyword JOIN episode ON keyword.episode_id = episode.episode_id WHERE episode.number_in_series = 426;
SELECT episode.title FROM episode JOIN (     SELECT    season,     AVG(CASE WHEN stars = 7 THEN votes ELSE 0 END) AS avg_seven_star_votes     FROM     vote     GROUP BY     season ) AS season_avg ON episode.season = season_avg.season JOIN (     SELECT    episode_id,     SUM(CASE WHEN stars = 7 THEN votes ELSE 0 END) AS seven_star_votes     FROM     vote     GROUP BY     episode_id ) AS episode_votes ON episode.episode_id = episode_votes.episode_id WHERE episode_votes.seven_star_votes > season_avg.avg_seven_star_votes; 
SELECT DIVIDE(SUM(CASE WHEN result = 'Nominee' THEN votes ELSE 0 END), SUM(votes)) AS percentage 
SELECT name FROM person WHERE nickname IS NOT NULL; 
SELECT MAX(height_meters), birth_country FROM person GROUP BY birth_country ORDER BY MAX(height_meters) DESC LIMIT 1;
SELECT AVG(height_meters)  FROM      person  WHERE      birth_country = 'USA';
SELECT 100 * (   SELECT COUNT(*)    FROM person    WHERE birthdate > 1970 AND birth_region = 'California' ) / (   SELECT COUNT(*)    FROM person )
SELECT COUNT(DISTINCT name) FROM person WHERE birth_region != 'Connecticut' AND birth_country != 'USA';
SELECT title FROM episode WHERE episode_id IN ('S20-E1', 'S20-E2', 'S20-E3');
SELECT episode.episode_image FROM episode WHERE episode.episode_id = 5;
SELECT COUNT(vote.episode_id) FROM     episode JOIN     vote ON episode.episode_id = vote.episode_id WHERE     episode.rating > 7.0;
SELECT COUNT(DISTINCT credit.person) FROM     credit WHERE     category = 'Casting Department';
SELECT COUNT(DISTINCT person.name)  FROM person  JOIN credit ON person.name = credit.person  WHERE credit.role = 'additional timer'  AND person.birth_country = 'USA';
SELECT COUNT(DISTINCT person.name) FROM     person JOIN     credit ON person.name = credit.person JOIN     episode ON credit.episode_id = episode.episode_id WHERE     person.birthdate > 1970     AND     credit.role = 'animation executive producer';
SELECT episode.summary FROM episode LEFT JOIN credit ON episode.episode_id = credit.episode_id AND credit.credited != '' WHERE credit.episode_id IS NULL;
SELECT rating FROM episode WHERE episode_id IN (     SELECT    episode_id     FROM     award     WHERE     person = 'Jason Bikowski' );
SELECT AVG(person.height_meters)  FROM      credit  JOIN      person ON credit.person = person.name  WHERE      credit.category = 'Animation Department';
SELECT character_award.character FROM character_award JOIN award ON character_award.award_id = award.award_id WHERE award.award_category = 'Primetime Emmy' AND award.year = 2009;
SELECT character_award.character FROM character_award JOIN award ON character_award.award_id = award.award_id WHERE award.award_category = 'Primetime Emmy'  AND award.result = 'Nominee'  AND award.year >= '2009'  AND award.year <= '2010';
SELECT SUM(vote.votes) FROM     vote JOIN     episode ON vote.episode_id = episode.episode_id JOIN     credit ON episode.episode_id = credit.episode_id JOIN     person ON credit.person = person.name WHERE     person.name = 'Adam Kuhlman';
SELECT keyword.keyword, person.name FROM keyword JOIN episode ON keyword.episode_id = episode.episode_id JOIN credit ON episode.episode_id = credit.episode_id JOIN person ON credit.person = person.name WHERE episode.season = 'S20' AND episode.episode = 'E1'; 
SELECT episode.keyword FROM episode JOIN vote ON episode.episode_id = vote.episode_id WHERE vote.stars = 10 AND vote.percent > 29;
SELECT ROUND((CAST(SUM(CASE WHEN vote.stars = 5 THEN 1 ELSE 0 END) AS FLOAT) / CAST(COUNT(*) AS FLOAT)) * 100, 2) AS percentage FROM vote JOIN episode ON vote.episode_id = episode.episode_id WHERE episode.title = "Sex, Pies and Idiot Scrapes"; 
SELECT episode.title FROM episode JOIN keyword ON episode.episode_id = keyword.episode_id WHERE episode.title = "Dangerous Curves" AND keyword.keyword = "limbo dancing"; 
SELECT title FROM episode JOIN award ON episode.episode_id = award.episode_id WHERE award.year = '2017' AND award.award_category = 'Best International TV Series' AND result = 'Winner';
SELECT keyword.keyword FROM     keyword     JOIN episode ON keyword.episode_id = episode.episode_id     JOIN award ON award.episode_id = episode.episode_id WHERE     award.award_category = 'WGA Award (TV)'     AND award.result = 'Winner';
SELECT person.birth_place FROM     person     JOIN credit ON person.name = credit.person     JOIN episode ON credit.episode_id = episode.episode_id     JOIN award ON award.episode_id = episode.episode_id WHERE     credit.role = 'co-executive producer'     AND award.award_category = 'Outstanding Animated Program (For Programming Less Than One Hour)'     AND award.result = 'Nominee';
SELECT SUM(CASE WHEN vote.stars > 1 AND vote.stars <= 5 THEN vote.votes ELSE 0 END) AS total_votes FROM award JOIN character_award ON award.award_id = character_award.award_id JOIN credit ON award.episode_id = credit.episode_id JOIN vote ON award.episode_id = vote.episode_id WHERE award.award_category = 'Blimp Award' AND (result = 'Winner' OR result = 'Nominee');
SELECT SUM(award.rating) AS total_rating FROM award INNER JOIN episode ON award.episode_id = episode.episode_id WHERE award.award_category IN ('OFTA Television Award', 'WGA Award (TV)') AND award.result = 'Winner';
SELECT ROUND((SUM(percent) * 100) / (SELECT SUM(percent) FROM vote WHERE stars >= 5 AND stars <= 10), 2) AS percentage FROM vote JOIN episode ON vote.episode_id = episode.episode_id WHERE episode.title = "No Loan Again, Naturally"
SELECT COUNT(*) FROM episode JOIN vote ON episode.episode_id = vote.episode_id WHERE vote.stars > 8;
SELECT episode.title FROM     episode JOIN     vote ON episode.episode_id = vote.episode_id WHERE     vote.stars = (SELECT MAX(stars) FROM vote)
SELECT COUNT(DISTINCT episode_id)  FROM keyword  WHERE keyword = '2d animation'; 
SELECT organization FROM award WHERE award_id = 328;
SELECT COUNT(award_id) FROM award WHERE year = 2009;
SELECT COUNT(*) FROM award WHERE award_category = "Primetime Emmy";
SELECT DISTINCT person.birth_name FROM credit JOIN person ON credit.person = person.name WHERE credit.role = 'co-executive producer' AND person.height_meters > 1.60; 
SELECT The query calculates the percentage of nominees who were born in the USA. It first filters the count of distinct names of people who are nominees and were born in the USA, divides it by the count of distinct names of all people, and then multiplies by 100 to get the percentage. Finally, it rounds the result to two decimal places.
SELECT ROUND((COUNT(CASE WHEN result = 'Winner' AND height_meters > 1.75 THEN 1 END) * 100.0) / COUNT(CASE WHEN result = 'Winner' THEN 1 END), 2) AS percentage_of_winners_above_1_75 
SELECT title FROM     episode JOIN     vote ON episode.episode_id = vote.episode_id WHERE     stars = 2;
SELECT stars FROM     vote JOIN     episode ON vote.episode_id = episode.episode_id WHERE     episode.title = "How the Test Was Won";
SELECT COUNT(DISTINCT episode.episode_id) FROM episode JOIN vote ON episode.episode_id = vote.episode_id WHERE vote.stars > 5 AND episode.air_date LIKE '2008%'
SELECT character FROM character_award JOIN award ON character_award.award_id = award.award_id WHERE award.year = 2009;
SELECT DISTINCT year FROM award JOIN character_award ON award.award_id = character_award.award_id JOIN person ON award.person = person.name WHERE character_award.character = 'Mr. Burns'; 
SELECT award_category FROM     award JOIN     character_award ON award.award_id = character_award.award_id JOIN     person ON award.person = person.name WHERE     character_award.character = 'Lenny'; 
SELECT person.name FROM credit JOIN person ON credit.person = person.name WHERE credit.role = 'Smithers';
SELECT keyword.keyword FROM episode JOIN keyword ON episode.episode_id = keyword.episode_id WHERE episode.title = 'Dangerous Curves'; 
SELECT keyword.keyword FROM keyword JOIN episode ON keyword.episode_id = episode.episode_id WHERE episode.air_date LIKE '2008%'
SELECT COUNT(DISTINCT episode_id) FROM episode WHERE rating < 8 AND air_date LIKE '2009%'
SELECT person.birth_name FROM person JOIN credit ON person.name = credit.person WHERE credit.role = 'director' AND person.birth_country = 'South Korea';
SELECT COUNT(*) FROM     award WHERE     person = 'simpson 20'     AND year = 2009     AND result = 'Winner';
SELECT COUNT(*) FROM episode WHERE rating < 7;
SELECT name FROM person WHERE birth_region = 'California' AND birth_country = 'USA';
SELECT COUNT(DISTINCT credit.person) FROM credit JOIN episode ON credit.episode_id = episode.episode_id WHERE episode.season = 2 AND episode.number_in_series BETWEEN 5 AND 10 AND credit.role = 'casting';
SELECT episode.episode_id FROM vote WHERE stars = 2 AND votes = 9;
SELECT title FROM episode JOIN award ON episode.episode_id = award.episode_id WHERE award.award_category = 'Primetime Emmy Awards' AND award.year = 2009 AND award.result = 'Winner';
SELECT episode.episode_id FROM episode JOIN vote ON episode.episode_id = vote.episode_id WHERE episode.air_date LIKE '2008%' AND vote.stars < 5;
SELECT category FROM credit JOIN episode ON credit.episode_id = episode.episode_id JOIN person ON credit.person = person.name WHERE person.name = 'Carlton Batten' AND episode.episode_id IN (     SELECT episode_id     FROM vote     WHERE votes = (         SELECT MAX(votes)         FROM vote     ) );
SELECT percent FROM   episode JOIN   vote ON episode.episode_id = vote.episode_id WHERE   episode.air_date LIKE '2008%'   AND vote.votes BETWEEN 920 AND 950;
SELECT episode.episode_id, episode.title FROM credit JOIN episode ON credit.episode_id = episode.episode_id JOIN person ON credit.person = person.name WHERE credit.credited = 'true' AND person.name = 'Bonita Pietila';
SELECT COUNT(DISTINCT episode.episode_id) FROM     episode JOIN     award ON episode.episode_id = award.episode_id WHERE     award.organization = 'Annie Awards'     AND award.result = 'Nominee'     AND EXISTS (         SELECT 1         FROM             vote         WHERE             vote.episode_id = episode.episode_id             AND vote.percent > 6     );
SELECT episode.title FROM episode JOIN award ON episode.episode_id = award.episode_id WHERE award.award_category = 'WGA Award (TV)' AND award.result = 'Nominee' AND award.votes > 1000;
SELECT person.name FROM credit JOIN episode ON credit.episode_id = episode.episode_id JOIN person ON credit.person = person.name WHERE credit.category = 'Animation Department' AND credit.credited = 'true' AND episode.title = 'How the Test Was Won' AND credit.role = 'additional timer' 
SELECT person.name FROM     episode JOIN     credit ON episode.episode_id = credit.episode_id JOIN     person ON credit.person = person.name WHERE     episode.air_date LIKE '2008-11%'
SELECT episode.title FROM episode JOIN award ON award.episode_id = episode.episode_id JOIN vote ON vote.episode_id = episode.episode_id WHERE vote.stars = 5 AND award.award_category = 'Prism Award' AND award.result = 'Nominee' AND episode.air_date = '2009-04-19';
SELECT award_category FROM award WHERE episode_id = (SELECT episode_id FROM vote ORDER BY votes DESC LIMIT 1); 
SELECT COUNT(*) AS "Number of episodes credited to Sam Im for additional timer" FROM     credit WHERE     episode_id IN (         SELECT            episode_id         FROM             episode         WHERE             air_date LIKE '2009%'     )     AND person = 'Sam Im'     AND role = 'additional timer';
SELECT title FROM episode WHERE stars > (SELECT AVG(stars) * 0.7 FROM episode);
SELECT 100 * (SELECT COUNT(*) FROM vote           WHERE episode_id IN (SELECT episode_id FROM episode WHERE title = 'Gone Maggie Gone')            AND result = 'Nominee')           / (SELECT COUNT(*) FROM vote              WHERE episode_id IN (SELECT episode_id FROM episode WHERE air_date LIKE '%2009%')) as percentage;
SELECT COUNT(DISTINCT enrolled.name) AS num_students_never_absent FROM enrolled LEFT JOIN longest_absense_from_school ON enrolled.name = longest_absense_from_school.name WHERE longest_absense_from_school.month IS NULL OR longest_absense_from_school.month = 0;
SELECT MAX(month) AS longest_absence_months FROM     longest_absense_from_school;
SELECT COUNT(enlist.name) FROM enlist WHERE organ = 'navy';
SELECT COUNT(DISTINCT male.name) AS male_students_absent_more_than_5_months FROM     enrolled JOIN     male ON enrolled.name = male.name WHERE     enrolled.month >= 5;
SELECT person.name FROM male JOIN enlist ON male.name = enlist.name WHERE enlist.organ = 'navy';
SELECT COUNT(*) FROM filed_for_bankrupcy JOIN longest_absense_from_school ON filed_for_bankrupcy.name = longest_absense_from_school.name WHERE longest_absense_from_school.month > 5;
SELECT COUNT(DISTINCT enrolled.name) FROM enrolled JOIN enlist ON enlisted.name = enrolled.name JOIN no_payment_due ON no_payment_due.name = enrolled.name WHERE enlisted.organ = 'navy' AND no_payment_due.bool = 'pos';
SELECT person.name FROM     male     JOIN disabled ON male.name = disabled.name     JOIN filed_for_bankrupcy ON male.name = filed_for_bankrupcy.name;
SELECT COUNT(DISTINCT person.name) FROM     disabled JOIN     male ON disabled.name = male.name
SELECT COUNT(DISTINCT person.name) FROM unemployed JOIN no_payment_due ON unemployed.name = no_payment_due.name 
SELECT MAX(month)  FROM enlisted JOIN longest_absense_from_school ON enlisted.name = longest_absense_from_school.name WHERE enlisted.organ = 'navy';
SELECT COUNT(person.name) FROM   disabled INNER JOIN   longest_absense_from_school ON disabled.name = longest_absense_from_school.name WHERE   longest_absense_from_school.month = 0;
SELECT DISTINCT school FROM enrolled WHERE month = 9;
SELECT organ, COUNT(disabled.name) AS disabled_count FROM enlist JOIN disabled ON enlist.name = disabled.name GROUP BY organ ORDER BY disabled_count DESC LIMIT 1;
SELECT person.name FROM     person JOIN     filed_for_bankrupcy ON person.name = filed_for_bankrupcy.name JOIN     male ON person.name = male.name;
SELECT ROUND((CAST((SELECT COUNT(DISTINCT person.name) FROM enlist JOIN male ON enlist.name = male.name WHERE enlist.organ = 'navy') AS FLOAT) / CAST((SELECT COUNT(DISTINCT person.name) FROM enlist WHERE enlist.organ = 'navy') AS FLOAT)) * 100, 2) AS percentage_of_male_students_in_navy
SELECT DIVIDE(SUM(month), COUNT(name)) FROM     longest_absense_from_school WHERE     name IN (SELECT name FROM disabled)
SELECT person.name FROM enlist JOIN person ON enlist.name = person.name WHERE enlist.organ = 'foreign_legion';
SELECT CASE     WHEN bool = 'pos' THEN 'Yes'     WHEN bool = 'neg' THEN 'No'     ELSE 'Unknown' END AS payment_due FROM no_payment_due WHERE name = 'student348';
SELECT enrolled.school FROM enrolled WHERE enrolled.name = 'student829';
SELECT COUNT(month) FROM longest_absense_from_school WHERE name = 'student217';
SELECT person.name FROM longest_absense_from_school WHERE month = 6;
SELECT enlist.organ FROM enlist JOIN person ON enlist.name = person.name WHERE person.name = 'student285'; 
SELECT (SELECT d.name FROM disabled d WHERE d.name = 'student281') AS disabled, (SELECT e.school FROM enrolled e WHERE e.name = 'student281') AS enrolled_school; 
SELECT person.name, enrolled.school FROM person JOIN enrolled ON person.name = enrolled.name JOIN enlist ON person.name = enlist.name WHERE enlist.organ = 'air_force';
SELECT person.name FROM     person LEFT JOIN     no_payment_due ON person.name = no_payment_due.name LEFT JOIN     male ON person.name = male.name WHERE     no_payment_due.bool = 'neg'     AND male.name IS NULL LIMIT     10;
SELECT person.name, enlist.organ FROM person JOIN enlist ON person.name = enlist.name JOIN no_payment_due ON person.name = no_payment_due.name WHERE no_payment_due.bool = 'pos'; 
SELECT disabled.name FROM disabled JOIN enrolled ON disabled.name = enrolled.name WHERE enrolled.school = 'SMC';
SELECT person.name FROM filed_for_bankrupcy JOIN enlist ON filed_for_bankrupcy.name = enlist.name WHERE enlist.organ = 'foreign_legion';
SELECT COUNT(DISTINCT person.name) FROM     male JOIN     enrolled ON male.name = enrolled.name LEFT JOIN     no_payment_due ON enrolled.name = no_payment_due.name WHERE     no_payment_due.bool = 'neg';
SELECT person.name FROM     person INNER JOIN     enlist ON person.name = enlist.name INNER JOIN     longest_absense_from_school ON person.name = longest_absense_from_school.name WHERE     enlist.organ = 'marines'     AND longest_absense_from_school.month = 6;
SELECT COUNT(DISTINCT person.name) FROM     enrolled JOIN     person ON enrolled.name = person.name JOIN     unemployed ON person.name = unemployed.name WHERE     enrolled.school = 'smc';
SELECT COUNT(*) FROM unemployed JOIN longest_absense_from_school ON unemployed.name = longest_absense_from_school.name WHERE month = 6;
SELECT COUNT(*) FROM     enlist WHERE     organ = 'peace_corps'     AND name IN (         SELECT name FROM enrolled WHERE school = 'ucsd'     );
SELECT enlist.organ, longest_absense_from_school.month FROM enlist LEFT JOIN longest_absense_from_school ON enlist.name = longest_absense_from_school.name WHERE enlist.name = 'Student21'; 
SELECT 100 * (   SELECT     COUNT(DISTINCT enlist.name) * 1.0 /      COUNT(DISTINCT no_payment_due.name)   FROM     enlist   INNER JOIN     no_payment_due ON enlist.name = no_payment_due.name   WHERE     enlist.organ = 'foreign_legion' AND     no_payment_due.bool = 'pos' ) AS ratio_percentage;
SELECT (CAST((SELECT COUNT(DISTINCT name) FROM enlist WHERE organ = 'navy') AS REAL) / CAST((SELECT COUNT(DISTINCT name) FROM enrolled WHERE school = 'OCC') AS REAL)) * 100 AS percentage_of_navy_enlisted_in_OCC
SELECT person.name FROM longest_absense_from_school INNER JOIN person ON longest_absense_from_school.name = person.name WHERE longest_absense_from_school.month = (SELECT MAX(month) FROM longest_absense_from_school)
SELECT COUNT(DISTINCT person.name) FROM   enrolled;
SELECT MAX(month) FROM longest_absense_from_school;
SELECT COUNT(DISTINCT name) FROM longest_absense_from_school WHERE month = 4;
SELECT COUNT(DISTINCT unemployed.name) FROM unemployed JOIN filed_for_bankrupcy ON unemployed.name = filed_for_bankrupcy.name
SELECT person.name, enlist.organ FROM     person LEFT JOIN     enlist ON person.name = enlist.name LEFT JOIN     disabled ON person.name = disabled.name WHERE     disabled.name IS NOT NULL;
SELECT COUNT(DISTINCT person.name) FROM person JOIN unemployed ON person.name = unemployed.name JOIN filed_for_bankrupcy ON person.name = filed_for_bankrupcy.name JOIN no_payment_due ON person.name = no_payment_due.name WHERE no_payment_due.bool = 'pos';
SELECT CASE     WHEN EXISTS (SELECT 1 FROM disabled WHERE name = '124') THEN 'Yes'     ELSE 'No' END AS is_disabled, CASE     WHEN EXISTS (SELECT 1 FROM male WHERE name = '124') THEN 'Yes'     ELSE 'No' END AS is_male;
SELECT employment.name, disabled.name, male.name, no_payment_due.bool FROM person LEFT JOIN enrolled ON person.name = enrolled.name LEFT JOIN unemployed ON person.name = unemployed.name LEFT JOIN disabled ON person.name = disabled.name LEFT JOIN male ON person.name = male.name LEFT JOIN no_payment_due ON person.name = no_payment_due.name WHERE person.name IN ('student180', 'student117');
SELECT COUNT(DISTINCT person.name) AS female_students_joined FROM     person JOIN     male ON person.name = male.name JOIN     enlisted ON person.name = enlisted.name WHERE     enlisted.organ IN ('marines', 'air_force');
SELECT enlist.organ, enrolled.school FROM enlist JOIN enrolled ON enlist.name = enrolled.name WHERE enlist.name IN ('student27', 'student17', 'student101');
SELECT COUNT(DISTINCT CASE WHEN disabled.name IN (SELECT name FROM person WHERE name NOT IN (SELECT name FROM male)) THEN disabled.name END) / COUNT(DISTINCT CASE WHEN disabled.name IN (SELECT name FROM person WHERE name IN (SELECT name FROM male)) THEN disabled.name END) FROM disabled;
SELECT COUNT(DISTINCT enlist.name)  FROM enlist  LEFT JOIN male ON enlist.name = male.name  WHERE male.name IS NULL;
SELECT person.name FROM filed_for_bankrupcy JOIN person ON filed_for_bankrupcy.name = person.name JOIN enrolled ON person.name = enrolled.name JOIN no_payment_due ON person.name = no_payment_due.name WHERE no_payment_due.bool = 'neg'; 
SELECT AVG(month) FROM enrolled;
SELECT AVG(month) FROM     enrolled JOIN     person ON enrolled.name = person.name WHERE     person.name NOT IN (SELECT name FROM unemployed)
SELECT AVG(month) FROM disabled JOIN longest_absense_from_school ON disabled.name = longest_absense_from_school.name;
SELECT organ FROM enlist WHERE name = 'student 313';
SELECT COUNT(*) FROM     enlist WHERE     organ = 'fire_department';
SELECT COUNT(DISTINCT enrolled.name) FROM enrolled LEFT JOIN longest_absense_from_school ON enrolled.name = longest_absense_from_school.name WHERE longest_absense_from_school.month IS NULL OR longest_absense_from_school.month = 0;
SELECT COUNT(DISTINCT name) FROM longest_absense_from_school WHERE month > 2;
SELECT COUNT(DISTINCT person.name) FROM person LEFT JOIN no_payment_due ON person.name = no_payment_due.name WHERE no_payment_due.bool = 'neg';
SELECT COUNT(DISTINCT person.name) FROM person JOIN no_payment_due ON person.name = no_payment_due.name WHERE no_payment_due.bool = 'pos';
SELECT person.name FROM person LEFT JOIN disabled ON person.name = disabled.name LEFT JOIN longest_absense_from_school ON person.name = longest_absense_from_school.name WHERE disabled.name IS NOT NULL AND longest_absense_from_school.month = 0; 
SELECT COUNT(*) FROM     unemployed JOIN     enlist ON unemployed.name = enlist.name WHERE     enlist.organ = 'navy';
SELECT COUNT(DISTINCT male.name) FROM   male JOIN   enlist ON male.name = enlist.name WHERE   enlist.organ = 'foreign_legion';
SELECT COUNT(DISTINCT person.name) FROM person JOIN enlisted ON person.name = enlisted.name JOIN male ON person.name = male.name JOIN enlist ON person.name = enlist.name WHERE enlist.organ = 'air_force';
SELECT person.name FROM disabled JOIN longest_absense_from_school ON disabled.name = longest_absense_from_school.name WHERE longest_absense_from_school.month = (SELECT MAX(month) FROM longest_absense_from_school)
SELECT person.name FROM unemployed JOIN enlist ON unemployed.name = enlist.name WHERE enlist.organ = 'marines';
SELECT AVG(longest_absense_from_school.month) AS average_duration_absence_disabled_students
SELECT COUNT(DISTINCT CASE WHEN unemployed.name IN (SELECT name FROM longest_absense_from_school WHERE month > 5) THEN unemployed.name END) * 100.0 / COUNT(DISTINCT CASE WHEN unemployed.name IN (SELECT name FROM enrolled) THEN unemployed.name END) 
SELECT COUNT(*)  FROM unemployed  JOIN disabled ON unemployed.name = disabled.name  JOIN longest_absense_from_school ON unemployed.name = longest_absense_from_school.name  WHERE longest_absense_from_school.month = 8;
SELECT person.name FROM     unemployed JOIN     longest_absense_from_school ON unemployed.name = longest_absense_from_school.name JOIN     enrolled ON unemployed.name = enrolled.name WHERE     enrolled.school IS NOT NULL GROUP BY     unemployed.name HAVING     MAX(longest_absense_from_school.month) = MAX(enrolled.month);
SELECT person.name FROM unemployed LEFT JOIN longest_absense_from_school ON unemployed.name = longest_absense_from_school.name WHERE longest_absense_from_school.month IS NULL
SELECT COUNT(person.name) FROM     disabled JOIN     longest_absense_from_school ON disabled.name = longest_absense_from_school.name WHERE     longest_absense_from_school.month = 3;
SELECT person.name FROM filed_for_bankrupcy JOIN longest_absense_from_school ON filed_for_bankrupcy.name = longest_absense_from_school.name WHERE longest_absense_from_school.month = 0;
SELECT person.name FROM     filed_for_bankrupcy JOIN     longest_absense_from_school ON filed_for_bankrupcy.name = longest_absense_from_school.name 
SELECT CASE     WHEN male.name IS NOT NULL THEN 'Male'     ELSE 'Female' END AS gender FROM person LEFT JOIN male ON person.name = male.name WHERE person.name = 'student1000';
SELECT COUNT(person.name) FROM     person JOIN     disabled ON person.name = disabled.name;
SELECT COUNT(DISTINCT enrolled.name) FROM     enrolled WHERE     EXISTS (         SELECT 1         FROM             longest_absense_from_school         WHERE             enrolled.name = longest_absense_from_school.name             AND month > 6     );
SELECT person.name FROM longest_absense_from_school JOIN person ON longest_absense_from_school.name = person.name WHERE month = (SELECT MAX(month) FROM longest_absense_from_school)
SELECT COUNT(DISTINCT enlist.name) AS enlisted_students FROM enlist WHERE enlist.organ = 'army';
SELECT AVG(month) AS average_absences FROM longest_absense_from_school;
SELECT SUM(CASE     WHEN enlist.organ = 'foreign_legion' THEN 1     WHEN enlist.organ = 'peace_corps' THEN 1     WHEN enlist.organ = 'army' THEN 1     ELSE 0     END) AS total_enlisted_students FROM enlist;
SELECT COUNT(DISTINCT person.name) FROM enlist JOIN person ON enlist.name = person.name JOIN disabled ON person.name = disabled.name WHERE enlist.organ = 'marines';
SELECT COUNT(DISTINCT unemployed.name) FROM   unemployed INNER JOIN   enrolled ON unemployed.name = enrolled.name INNER JOIN   no_payment_due ON unemployed.name = no_payment_due.name WHERE   no_payment_due.bool = 'pos';
SELECT person.name FROM     person LEFT JOIN     enrolled ON person.name = enrolled.name LEFT JOIN     longest_absense_from_school ON person.name = longest_absense_from_school.name LEFT JOIN     male ON person.name = male.name WHERE     enrolled.school IS NOT NULL     AND enrolled.month = 0     AND male.name IS NULL;
SELECT MAX(school) AS school_with_highest_disabled_count FROM enrolled JOIN person ON enrolled.name = person.name JOIN disabled ON person.name = disabled.name GROUP BY school
SELECT organ FROM enlist JOIN filed_for_bankrupcy ON enlist.name = filed_for_bankrupcy.name;
SELECT COUNT(DISTINCT enlist.name) AS num_male_students_join_multiple_orgs FROM     enlist INNER JOIN     male ON enlist.name = male.name GROUP BY     enlist.name HAVING     COUNT(organ) > 1;
SELECT person.name FROM     person JOIN     enlist ON person.name = enlist.name JOIN     disabled ON person.name = disabled.name WHERE     enlist.organ = 'navy';
SELECT COUNT(enrolled.name) FROM enrolled WHERE school = 'smc' AND month = 7;
SELECT person.name FROM person JOIN disabled ON person.name = disabled.name JOIN male ON person.name = male.name JOIN enrolled ON person.name = enrolled.name WHERE enrolled.school = 'student'
SELECT COUNT(name) FROM unemployed / COUNT(name) FROM disabled
SELECT 100 * (SELECT COUNT(enlist.name) FROM enlist JOIN male ON enlist.name = male.name WHERE enlist.organ = 'fire_department') / (SELECT COUNT(name) FROM person JOIN male ON person.name = male.name)
SELECT COUNT(DISTINCT longest_absense_from_school.name) FROM     longest_absense_from_school WHERE     month = 5;
SELECT COUNT(DISTINCT enlist.name) AS num_enlisted_students FROM enlist WHERE enlist.organ = 'army';
SELECT COUNT(DISTINCT name) FROM enrolled WHERE school = 'UCLA';
SELECT name FROM longest_absense_from_school GROUP BY name ORDER BY MAX(month) DESC LIMIT 5; 
SELECT COUNT(DISTINCT enlist.name) FROM enlist GROUP BY enlist.name HAVING COUNT(organ) >= 2;
SELECT COUNT(DISTINCT enlist.name) FROM enlist WHERE organ = 'navy';
SELECT COUNT(DISTINCT male.name) FROM     male JOIN     no_payment_due ON male.name = no_payment_due.name WHERE     no_payment_due.bool = 'neg';
SELECT COUNT(DISTINCT enlist.name) FROM enlist JOIN enrolled ON enlist.name = enrolled.name WHERE enlist.organ = 'peace_corps' AND enrolled.school = 'UCSD';
SELECT COUNT(DISTINCT unemployed.name) FROM unemployed JOIN no_payment_due ON unemployed.name = no_payment_due.name WHERE no_payment_due.bool = 'neg';
SELECT COUNT(DISTINCT enrolled.name) FROM enrolled JOIN person ON enrolled.name = person.name LEFT JOIN male ON person.name = male.name LEFT JOIN no_payment_due ON person.name = no_payment_due.name LEFT JOIN bool ON no_payment_due.bool = bool.name WHERE bool = 'neg' AND male.name IS NULL;
SELECT COUNT(DISTINCT unemployed.name) FROM unemployed LEFT JOIN longest_absense_from_school ON unemployed.name = longest_absense_from_school.name WHERE longest_absense_from_school.month IS NULL;
SELECT enlist.name FROM enlist JOIN no_payment_due ON enlist.name = no_payment_due.name WHERE no_payment_due.bool = 'neg' AND enlist.organ = 'fire_department' LIMIT 10; 
SELECT COUNT(DISTINCT enlist.name) FROM enlist JOIN person ON enlist.name = person.name LEFT JOIN male ON enlist.name = male.name WHERE enlist.organ = 'navy' AND male.name IS NULL;
SELECT COUNT(DISTINCT unemployed.name) FROM unemployed JOIN enlist ON unemployed.name = enlist.name WHERE enlist.organ = 'army';
SELECT COUNT(*) FROM unemployed JOIN no_payment_due ON unemployed.name = no_payment_due.name WHERE no_payment_due.bool = 'pos' AND unemployed.name IN (     SELECT name     FROM enrolled );
SELECT person.name FROM person INNER JOIN no_payment_due ON person.name = no_payment_due.name INNER JOIN enlist ON person.name = enlist.name WHERE no_payment_due.bool = 'pos' AND enlist.organ = 'Peace Corps' LIMIT 5; 
SELECT COUNT(DISTINCT disabled.name) FROM disabled LEFT JOIN male ON disabled.name = male.name WHERE male.name IS NULL;
SELECT COUNT(DISTINCT disabled.name) FROM disabled JOIN person ON disabled.name = person.name JOIN no_payment_due ON person.name = no_payment_due.name WHERE no_payment_due.bool = 'pos';
SELECT AVG(CASE      WHEN disabled.name NOT IN (SELECT name FROM male) AND organ = 'Foreign Legion' THEN 1     ELSE 0      END)  FROM enlist  WHERE disabled.name IN (SELECT name FROM person);
SELECT CONCAT(MULTIPLY(DIVIDE(COUNT(enlist.name WHERE organ = 'fire_department' AND enlist.name NOT IN (SELECT name FROM male)), COUNT(enlist.name WHERE organ = 'fire_department')), '%')) AS FEMALE, CONCAT(MULTIPLY(DIVIDE(COUNT(enlist.name WHERE organ = 'fire_department' AND enlist.name IN (SELECT name FROM male)), COUNT(enlist.name WHERE organ = 'fire_department')), 100)) AS MALE;
SELECT COUNT(DISTINCT enlist.name) FROM enlist WHERE organ = 'navy';
SELECT CONCAT(     DIVIDE(         MULTIPLY(             COUNT(name WHERE month = 0),             100         ),         COUNT(name)     ),     '%' ) FROM enrolled WHERE month <> 0;
SELECT COUNT(DISTINCT enrolled.name) AS enrolled_count, COUNT(DISTINCT no_payment_due.name) AS no_payment_due_count, 1.0 * COUNT(DISTINCT no_payment_due.name) / NULLIF(COUNT(DISTINCT enrolled.name), 0) AS payment_due_ratio FROM enrolled LEFT JOIN no_payment_due ON enrolled.name = no_payment_due.name;
SELECT person.name, enrolled.school FROM enrolled WHERE enrolled.month = 15; 
SELECT AVG(CAST((SELECT COUNT(DISTINCT enlist.name) FROM enlist) AS REAL) / CAST((SELECT COUNT(DISTINCT organ) FROM enlist) AS REAL)) 
SELECT school, month FROM enrolled WHERE name = 'student214'; 
SELECT ROUND((COUNT(DISTINCT disabled.name) * 100.0) / COUNT(DISTINCT person.name), 2) AS "Percentage of Disabled Students"
SELECT COUNT(DISTINCT person.name) FROM     longest_absense_from_school     INNER JOIN person ON longest_absense_from_school.name = person.name     INNER JOIN disabled ON person.name = disabled.name WHERE     longest_absense_from_school.month = 9;
SELECT person.name FROM person LEFT JOIN filed_for_bankrupcy ON person.name = filed_for_bankrupcy.name WHERE filed_for_bankrupcy.name IS NULL;
SELECT enlist.name FROM enlist LEFT JOIN male ON enlist.name = male.name WHERE organ = 'air_force' AND male.name IS NULL LIMIT 5;
SELECT COUNT(person.name) FROM person LEFT JOIN disabled ON person.name = disabled.name WHERE disabled.name IS NULL;
SELECT CASE     WHEN EXISTS (SELECT 1 FROM male WHERE name = 'student995') THEN 'Male'     ELSE 'Female' END AS gender, GROUP_CONCAT(enrolled.school) AS enrolled_schools FROM enrolled WHERE name = 'student995';
SELECT person.name FROM     person JOIN     disabled ON person.name = disabled.name JOIN     unemployed ON person.name = unemployed.name LIMIT 5; 
SELECT COUNT(*) FROM unemployed JOIN filed_for_bankrupcy ON unemployed.name = filed_for_bankrupcy.name;
SELECT person.name, enlist.organ FROM longest_absense_from_school JOIN enlist ON longest_absense_from_school.name = enlist.name WHERE longest_absense_from_school.month = 4 LIMIT 5;
SELECT COUNT(DISTINCT unemployed.name) FROM person JOIN no_payment_due ON person.name = no_payment_due.name JOIN unemployed ON person.name = unemployed.name WHERE no_payment_due.bool = 'pos';
SELECT enlist.organ, no_payment_due.bool FROM enlist JOIN person ON enlist.name = person.name LEFT JOIN no_payment_due ON person.name = no_payment_due.name WHERE person.name = 'student160'; 
SELECT person.name FROM     male JOIN enlist ON male.name = enlist.name WHERE     enlist.organ = 'foreign_legion' LIMIT 10;
SELECT CONCAT(     DIVIDE(         MULTIPLY(             COUNT(person.name NOT IN (SELECT name FROM male)),             100         ),         COUNT(person.name IN (SELECT name FROM male))     ),     '%' ) AS percentage_female_students;
SELECT COUNT(DISTINCT filed_for_bankrupcy.name) AS num_students_filed_for_bankruptcy FROM filed_for_bankrupcy;
SELECT COUNT(enrolled.name) FROM enrolled WHERE enrolled.school = 'smc' AND enrolled.month = 1;
SELECT COUNT(DISTINCT enlist.name) FROM enlist WHERE enlist.organ = 'air_force';
SELECT organ FROM enlist WHERE name = 'student168';
SELECT COUNT(DISTINCT enlist.name) FROM     enlist JOIN     male ON enlist.name = male.name JOIN     disabled ON enlist.name = disabled.name;
SELECT COUNT(disabled.name) AS disability_count, enrolled.school FROM enrolled LEFT JOIN disabled ON enrolled.name = disabled.name GROUP BY enrolled.school;
SELECT COUNT(male.name) AS male_count, (COUNT(enlist.name) - COUNT(male.name)) AS female_count, enlist.organ FROM enlist LEFT JOIN male ON enlist.name = male.name GROUP BY enlist.organ;
SELECT person.name FROM     enrolled WHERE     (SELECT COUNT(DISTINCT school) FROM enrolled WHERE enrolled.name = person.name) = 2     AND     (SELECT COUNT(DISTINCT organ) FROM enlist WHERE enlist.name = person.name) = 2;
SELECT CONCAT(DIVIDE(MULTIPLY(SUBTRACT(COUNT(name) WHERE month = 0, COUNT(name) WHERE month = 9), 100), COUNT(name) WHERE month = 0),'%');
SELECT MAX(school) AS school_with_highest_enrollment, COUNT(CASE WHEN filed_for_bankrupcy.name IS NOT NULL THEN 1 END) AS students_filed_for_bankruptcy FROM enrolled GROUP BY school ORDER BY COUNT(name) DESC LIMIT 1;
SELECT COUNT(*) FROM     disabled JOIN     unemployed ON disabled.name = unemployed.name;
SELECT person.name FROM enrolled INNER JOIN person ON enrolled.name = person.name INNER JOIN enlist ON person.name = enlist.name WHERE enrolled.school = 'occ' AND enlist.organ = 'fire_department';
SELECT person.name FROM     person JOIN     male ON person.name = male.name JOIN     unemployed ON person.name = unemployed.name JOIN     disabled ON person.name = disabled.name JOIN     longest_absense_from_school ON person.name = longest_absense_from_school.name WHERE     longest_absense_from_school.month = 5;
SELECT enrolled.name FROM enrolled LEFT JOIN male ON enrolled.name = male.name WHERE male.name IS NULL AND enrolled.school IN ('occ', 'ulca');
SELECT enrolled.school, enlist.organ FROM enrolled JOIN enlist ON enrolled.name = enlist.name WHERE enrolled.name = 'student211'; 
SELECT COUNT(DISTINCT CASE WHEN male.name IS NOT NULL THEN filed_for_bankrupcy.name END) - COUNT(DISTINCT CASE WHEN male.name IS NULL THEN filed_for_bankrupcy.name END) FROM filed_for_bankrupcy LEFT JOIN male ON filed_for_bankrupcy.name = male.name;
SELECT AVG(longest_absense_from_school.month) FROM     longest_absense_from_school JOIN     enrolled ON enrolled.name = longest_absense_from_school.name JOIN     unemployed ON unemployed.name = enrolled.name JOIN     male ON male.name = enrolled.name;
SELECT 100 * (SELECT                 (COUNT(DISTINCT longest_absense_from_school.name) - COUNT(DISTINCT CASE WHEN longest_absense_from_school.name NOT IN (SELECT name FROM disabled) THEN longest_absense_from_school.name END))                  / COUNT(DISTINCT longest_absense_from_school.name)              FROM                  longest_absense_from_school              WHERE                  name IN (SELECT name FROM disabled))             AS percentage_difference;
SELECT AVG(longest_absense_from_school.month)  FROM      longest_absense_from_school  JOIN      person ON longest_absense_from_school.name = person.name  JOIN      disabled ON person.name = disabled.name  JOIN      male ON person.name = male.name;
SELECT CONCAT(DIVIDE(MULTIPLY(COUNT(unemployed.name WHERE month = 0), 100), COUNT(*)),'%') AS ratio FROM unemployed LEFT JOIN longest_absense_from_school ON unemployed.name = longest_absense_from_school.name WHERE longest_absense_from_school.month IS NULL;
SELECT COUNT(DISTINCT person.name) FROM     male JOIN     enrolled ON male.name = enrolled.name LEFT JOIN     no_payment_due ON enrolled.name = no_payment_due.name WHERE     no_payment_due.bool = 'neg';
SELECT COUNT(DISTINCT person.name) FROM filed_for_bankrupcy JOIN no_payment_due ON filed_for_bankrupcy.name = no_payment_due.name WHERE no_payment_due.bool = 'pos';
SELECT `bool` FROM   `no_payment_due` WHERE   `no_payment_due`.`name` = 'student124';
SELECT COUNT(DISTINCT disabled.name) FROM disabled JOIN no_payment_due ON disabled.name = no_payment_due.name WHERE no_payment_due.bool = 'pos';
SELECT person.name FROM longest_absense_from_school JOIN no_payment_due ON longest_absense_from_school.name = no_payment_due.name WHERE longest_absense_from_school.month = (SELECT MAX(month) FROM longest_absense_from_school) AND no_payment_due.bool = 'neg';
SELECT name FROM     longest_absense_from_school JOIN     no_payment_due ON longest_absense_from_school.name = no_payment_due.name WHERE     month = 5 AND bool = 'neg'; 
SELECT COUNT(disabled.name) FROM     disabled JOIN     enlist ON disabled.name = enlist.name WHERE     enlist.organ = 'marines';
SELECT COUNT(person.name) FROM longest_absense_from_school JOIN enlist ON longest_absense_from_school.name = enlist.name WHERE enlist.organ = 'peace_corps';
SELECT COUNT(person.name) AS num_students FROM filed_for_bankrupcy JOIN person ON filed_for_bankrupcy.name = person.name JOIN enlist ON person.name = enlist.name WHERE enlist.organ = 'navy';
SELECT COUNT(DISTINCT enlist.name) FROM enlist JOIN no_payment_due ON enlist.name = no_payment_due.name WHERE enlist.organ = 'marines' AND no_payment_due.bool = 'pos';
SELECT (DIVIDE(COUNT(DISTINCT disabled.name, CASE WHEN longest_absense_from_school.month IS NULL THEN 1 ELSE NULL END), COUNT(DISTINCT disabled.name)) * 100) AS ratio_disabled_never_absent FROM disabled LEFT JOIN longest_absense_from_school ON disabled.name = longest_absense_from_school.name;
SELECT COUNT(enlist.name) FROM enlist WHERE enlist.organ = 'air_force';
SELECT COUNT(enrolled.name) FROM enrolled WHERE enrolled.month < 4;
SELECT COUNT(DISTINCT enlist.name) FROM     enlist JOIN     person ON enlist.name = person.name LEFT JOIN     male ON enlist.name = male.name WHERE     organ = 'marines'     AND male.name IS NULL;
SELECT AVG(month) FROM longest_absense_from_school WHERE name NOT IN (SELECT name FROM male)
SELECT person.name FROM person JOIN filed_for_bankrupcy ON person.name = filed_for_bankrupcy.name LEFT JOIN male ON person.name = male.name WHERE male.name IS NULL; 
SELECT no_payment_due.bool FROM no_payment_due JOIN person ON no_payment_due.name = person.name WHERE person.name = 'student299';
SELECT COUNT(*)  FROM enlist  WHERE organ = 'air_force';
SELECT COUNT(DISTINCT name) FROM longest_absense_from_school WHERE month > 1;
SELECT person.name FROM enlist JOIN person ON enlist.name = person.name WHERE enlist.organ = 'fire_department';
SELECT COUNT(DISTINCT disabled.name) FROM disabled JOIN no_payment_due ON disabled.name = no_payment_due.name WHERE no_payment_due.bool = 'pos';
SELECT COUNT(DISTINCT person.name) FROM filed_for_bankruptcy JOIN enrolled ON filed_for_bankruptcy.name = enrolled.name WHERE enrolled.school = 'occ';
SELECT COUNT(disabled.name) FROM     disabled JOIN     male ON disabled.name = male.name;
SELECT person.name FROM     person JOIN     disabled ON person.name = disabled.name JOIN     enlist ON person.name = enlist.name WHERE     enlist.organ = 'navy';
SELECT person.name FROM     person JOIN     male ON person.name = male.name JOIN     no_payment_due ON person.name = no_payment_due.name WHERE     no_payment_due.bool = 'pos'; 
SELECT employment_status, payment_status FROM ( SELECT CASE     WHEN unemployed.name = 'student110' THEN 'unemployed'     ELSE 'employed' END AS employment_status, CASE     WHEN no_payment_due.bool = 'neg' THEN 'payment_due'     ELSE 'no_payment_due' END AS payment_status FROM person LEFT JOIN unemployed ON person.name = unemployed.name LEFT JOIN no_payment_due ON person.name = no_payment_due.name WHERE person.name = 'student110' );
SELECT (MULTIPLY(DIVIDE(COUNT(male.name), COUNT(person.name)), 100)) as percentage_of_male_students FROM male;
SELECT enrolled.school, CASE WHEN male.name = 'student34' THEN 'male' ELSE 'female' END AS gender FROM enrolled LEFT JOIN male ON enrolled.name = male.name WHERE enrolled.name = 'student34';
SELECT MAX(month) FROM longest_absense_from_school JOIN enlist ON longest_absense_from_school.name = enlist.name WHERE enlist.organ = 'fire_department';
SELECT COUNT(DISTINCT enlist.name) FROM longest_absense_from_school JOIN enlist ON longest_absense_from_school.name = enlist.name WHERE longest_absense_from_school.month = 1 AND enlist.organ = 'air_force';
SELECT disabled.name FROM disabled JOIN male ON disabled.name = male.name JOIN unemployed ON disabled.name = unemployed.name;
SELECT COUNT(*) FROM     enrolled JOIN     male ON enrolled.name = male.name WHERE     enrolled.school = 'occ';
SELECT MULTIPLY(DIVIDE(COUNT(male.name), COUNT(person.name)), 100) FROM enrolled JOIN male ON enrolled.name = male.name WHERE school = 'ucla' AND organ = 'air_force';
SELECT AVG(CASE WHEN person.name IN (SELECT disabled.name FROM disabled WHERE disabled.name NOT IN (SELECT name FROM male)) AND school = 'uci' THEN 1 ELSE 0 END) AS average_disabled_female_students_at_uci FROM enrolled WHERE school = 'uci';
SELECT COUNT(DISTINCT person.name) FROM person LEFT JOIN longest_absense_from_school ON person.name = longest_absense_from_school.name WHERE longest_absense_from_school.month IS NULL OR longest_absense_from_school.month = 0;
SELECT person.name FROM enlist WHERE enlist.organ = 'marines';
SELECT COUNT(DISTINCT enlist.name) FROM enlist WHERE enlist.organ = 'navy';
SELECT person.name FROM longest_absense_from_school WHERE month = (     SELECT    MAX(month)     FROM     longest_absense_from_school );
SELECT MAX(organ) FROM   enlist GROUP BY   organ ORDER BY   COUNT(name) DESC LIMIT 1;
SELECT COUNT(DISTINCT name) FROM enrolled WHERE month <= 3;
SELECT COUNT(DISTINCT unemployed.name) FROM no_payment_due JOIN unemployed ON no_payment_due.name = unemployed.name WHERE no_payment_due.bool = 'pos';
SELECT COUNT(DISTINCT enlist.name) AS female_students_enlisted_for_army FROM enlist LEFT JOIN male ON enlist.name = male.name WHERE enlist.organ = 'army' AND male.name IS NULL;
SELECT MIN(enlist.organ) AS organization FROM enlist LEFT JOIN male ON enlist.name = male.name GROUP BY enlist.organ ORDER BY COUNT(male.name);
SELECT COUNT(person.name) FROM disabled JOIN longest_absense_from_school ON disabled.name = longest_absense_from_school.name WHERE longest_absense_from_school.month = 0;
SELECT COUNT(*) FROM unemployed JOIN disabled ON unemployed.name = disabled.name;
SELECT person.name FROM disabled JOIN longest_absense_from_school ON disabled.name = longest_absense_from_school.name WHERE longest_absense_from_school.month > 5;
SELECT COUNT(person.name) FROM filed_for_bankrupcy JOIN enlist ON filed_for_bankrupcy.name = enlist.name JOIN organ ON enlist.organ = 'marines';
SELECT COUNT(person.name) FROM     filed_for_bankrupcy JOIN     person ON filed_for_bankrupcy.name = person.name JOIN     disabled ON person.name = disabled.name;
SELECT MAX(COUNT(month)) AS max_absence_months FROM     longest_absense_from_school WHERE     organ = 'air_force';
SELECT COUNT(DISTINCT enlist.name) AS num_enlisted_fire_dept FROM person JOIN filed_for_bankrupcy ON person.name = filed_for_bankrupcy.name JOIN longest_absense_from_school ON person.name = longest_absense_from_school.name JOIN enlist ON person.name = enlist.name WHERE longest_absense_from_school.month < 6 AND enlist.organ = 'fire_department';
SELECT COUNT(*) FROM     disabled JOIN     enrolled ON disabled.name = enrolled.name JOIN     longest_absense_from_school ON disabled.name = longest_absense_from_school.name JOIN     unemployed ON disabled.name = unemployed.name WHERE     enrolled.school = "student" AND     enrolled.month = 0
SELECT organ, ROUND(   (     COUNT(male.name) * 100.0 / COUNT(person.name)   ),   2 ) AS percentage_male_students FROM enlist JOIN male ON enlist.name = male.name GROUP BY organ ORDER BY COUNT(male.name) DESC LIMIT 1;
SELECT COUNT(*) FROM answer WHERE questionid = 19 AND answertext = 'No';
SELECT COUNT(DISTINCT userid) AS users_per_year,     CASE         WHEN surveyid = 2016 THEN '2016'         WHEN surveyid = 2017 THEN '2017'         WHEN surveyid = 2018 THEN '2018'         WHEN surveyid = 2019 THEN '2019'     END AS year FROM     answer WHERE     questionid = 13     AND surveyid BETWEEN 2016 AND 2019 GROUP BY     year;
SELECT COUNT(DISTINCT userid) FROM     answer WHERE     answertext BETWEEN 27 AND 35     AND questionid = 1     AND surveyid IN (SELECT surveyid FROM survey WHERE description = '2018')
SELECT COUNT(DISTINCT answer.userid) FROM answer JOIN question ON answer.questionid = question.questionid JOIN survey ON answer.surveyid = survey.surveyid WHERE survey.description = '2019' AND answer.answertext = 'United States' AND answer.questionid = 3 AND answer.answertext = 'Yes' AND answer.questionid = 6;
SELECT COUNT(answer.userid) AS num_people,     strftime('%Y', survey.description) AS year FROM     answer     JOIN survey ON answer.surveyid = survey.surveyid WHERE     survey.description BETWEEN '2016-01-01' AND '2019-12-31'     AND answer.answertext = 'Yes'     AND answer.questionid = 34 GROUP BY     year ORDER BY     num_people DESC LIMIT 1;
SELECT COUNT(DISTINCT answer.userid) FROM answer JOIN question ON answer.questionid = question.questionid JOIN survey ON answer.surveyid = survey.surveyid WHERE survey.description = 'mental health survey for 2017' AND answer.answertext = 'Yes' AND question.questiontext = 'Do you have a family history of mental illness?' AND (SELECT answertext FROM answer WHERE questionid = 2 AND answer.userid = answer.userid) = 'Female' AND (SELECT answertext FROM answer WHERE questionid = 4 AND answer.userid = answer.userid) = 'Nebraska';
SELECT COUNT(DISTINCT userid) FROM answer WHERE answertext = 'Yes' AND questionid = 54;
SELECT MAX(AnswerText) AS OldestAge, userid AS OldestUserId FROM answer WHERE questionid = 1 UNION SELECT MIN(AnswerText) AS YoungestAge, userid AS YoungestUserId FROM answer WHERE questionid = 1;
SELECT DISTINCT     CountryName FROM     (     SELECT        COUNT(answer.userid) AS UserCount,         CountryName     FROM         answer     INNER JOIN         user ON answer.userid = user.userid     WHERE         answer.questionid = 3     GROUP BY         CountryName     ) AS UserCounts WHERE     UserCount = (         SELECT            MIN(UserCount)         FROM             (             SELECT                COUNT(answer.userid) AS UserCount,                 CountryName             FROM                 answer             INNER JOIN                 user ON answer.userid = user.userid             WHERE                 answer.questionid = 3             GROUP BY                 CountryName             ) AS MinUserCount     )
SELECT AVG(CAST(answer.answertext AS INTEGER)) AS average_age FROM answer JOIN question ON answer.questionid = question.questionid WHERE answer.questionid = 1 AND answer.answertext = 'United States'; 
SELECT ( (SELECT COUNT(DISTINCT userid) FROM answer WHERE questionid = 12 AND answertext = 'Yes' OR answertext = 'Maybe') * 100 ) / (SELECT COUNT(DISTINCT userid) FROM answer WHERE questionid = 12) 
SELECT COUNT(q.questionid) FROM question q JOIN answer a ON q.questionid = a.questionid JOIN survey s ON a.surveyid = s.surveyid WHERE s.description = '2014' GROUP BY q.questionid HAVING COUNT(a.answertext) > 200; 
SELECT MAX(CAST(answer.answertext AS INTEGER)) FROM     answer     JOIN question ON answer.questionid = question.questionid     JOIN survey ON answer.surveyid = survey.surveyid WHERE     survey.description = '2014'     AND question.questiontext = 'what is your age?';
SELECT COUNT(answer.userid) FROM     answer     JOIN question ON answer.questionid = question.questionid     JOIN survey ON answer.surveyid = survey.surveyid WHERE     survey.description = '2014'     AND question.questiontext = 'Would you bring up a mental health issue with a potential employer in an interview?'     AND answer.answertext = 'No';
SELECT answer.userid FROM answer JOIN question ON answer.questionid = question.questionid JOIN survey ON answer.surveyid = survey.surveyid WHERE question.questiontext = 'Do you think that discussing a physical health issue with your employer would have negative consequences?' AND answer.answertext = 'Yes' AND survey.description = '2014' 
SELECT COUNT(DISTINCT userid) FROM answer WHERE surveyid = 2014;
SELECT answer.answertext FROM answer INNER JOIN question ON answer.questionid = question.questionid INNER JOIN survey ON answer.surveyid = survey.surveyid WHERE question.questiontext = "Any additional notes or comments" AND answer.answertext IS NOT NULL AND survey.description LIKE '%2014%' 
SELECT question.questiontext FROM question INNER JOIN survey ON question.questionid = survey.surveyid WHERE survey.surveyid = 2014 AND question.questionid IN (SELECT questionid FROM survey WHERE surveyid = 2016)
SELECT COUNT(DISTINCT userid) FROM answer WHERE questionid = 3 AND answertext = 'Canada' AND surveyid IN (     SELECT surveyid     FROM survey     WHERE description LIKE '%2018%' );
SELECT question.questiontext FROM question INNER JOIN survey ON question.questionid = survey.surveyid WHERE survey.surveyid = 2014;
SELECT COUNT(DISTINCT userid) FROM answer WHERE questionid = 32 AND answertext = 'Yes' AND surveyid = (SELECT surveyid FROM survey WHERE description = '2016 Survey');
SELECT COUNT(DISTINCT userid) FROM answer WHERE questionid = (SELECT questionid FROM question WHERE questiontext = 'Have you had a mental health disorder in the past?') AND surveyid IN (2016, 2017, 2018) AND answertext = 'Yes';
SELECT AVG(answer.answertext) AS average_result FROM answer JOIN question ON answer.questionid = question.questionid JOIN survey ON answer.surveyid = survey.surveyid WHERE question.questiontext = 'What is your age?' AND survey.surveyid = 2014; 
SELECT (SELECT (CAST((SELECT COUNT(*) FROM answer WHERE surveyid = 2019 AND questionid = 33 AND answertext = 'Yes') AS REAL) / CAST((SELECT COUNT(*) FROM answer WHERE surveyid = 2019 AND questionid = 33) AS REAL)) - (CAST((SELECT COUNT(*) FROM answer WHERE surveyid = 2016 AND questionid = 33 AND answertext = 'Yes') AS REAL) / CAST((SELECT COUNT(*) FROM answer WHERE surveyid = 2016 AND questionid = 33) AS REAL))) AS rate_of_increase;
SELECT questionid FROM question WHERE questiontext = "Would you bring up a physical health issue with a potential employer in an interview?";
SELECT COUNT(DISTINCT userid) FROM answer WHERE questionid = 20;
SELECT COUNT(*) FROM     answer WHERE     userid = 5;
SELECT COUNT(DISTINCT userid) AS num_users FROM answer WHERE surveyid = 2016; 
SELECT COUNT(*) AS num_questions FROM question WHERE questionid IN (     SELECT questionid     FROM survey     WHERE surveyid = 2018 );
SELECT COUNT(DISTINCT survey.surveyid) FROM question INNER JOIN answer ON question.questionid = answer.questionid INNER JOIN survey ON answer.surveyid = survey.surveyid WHERE question.questiontext = "What country do you work in?";
SELECT answer.answertext FROM     answer INNER JOIN     question ON answer.questionid = question.questionid WHERE     answer.userid = 2681     AND question.questiontext = "Do you currently have a mental health disorder?";
SELECT COUNT(DISTINCT userid) FROM answer WHERE surveyid = 2016;
SELECT ANSWERTEXT, COUNT(*) AS COUNT FROM ANSWER WHERE QUESTIONID = 3 GROUP BY ANSWERTEXT ORDER BY COUNT DESC LIMIT 1;
SELECT COUNT(DISTINCT answertext) FROM answer WHERE questionid = (SELECT questionid FROM question WHERE questiontext = "Describe the conversation you had with your previous employer about your mental health, including their reactions and actions taken to address your mental health issue/questions.")
SELECT COUNT(*) FROM     answer JOIN     question ON answer.questionid = question.questionid WHERE     question.questiontext = "What US state or territory do you work in?"     AND answer.answertext = "Kansas";
SELECT COUNT(DISTINCT userid) FROM answer WHERE questionid = 103 AND answertext != '-1';
SELECT COUNT(*) FROM answer JOIN question ON answer.questionid = question.questionid WHERE question.questiontext = 'Have you ever been diagnosed with a mental health disorder?' AND answer.answertext = 'Yes';
SELECT COUNT(DISTINCT userid) FROM     answer WHERE     surveyid = 2018;
SELECT COUNT(DISTINCT answer.userid) FROM answer JOIN question ON answer.questionid = question.questionid WHERE question.questiontext = "Overall, how much importance does your employer place on physical health?";
SELECT question.questiontext FROM answer JOIN question ON answer.questionid = question.questionid WHERE answer.answertext = "Mood Disorder (Depression, Bipolar Disorder, etc)" AND answer.userid = 2183;
SELECT 100 * (     SELECT COUNT(*)      FROM answer      WHERE questionid = (         SELECT questionid          FROM question          WHERE questiontext = "Has your employer ever formally discussed mental health (for example, as part of a wellness campaign or other official communication)?"     )      AND answertext = 'Yes' ) / (     SELECT COUNT(*)      FROM answer      WHERE questionid = (         SELECT questionid          FROM question          WHERE questiontext = "Has your employer ever formally discussed mental health (for example, as part of a wellness campaign or other official communication)?"     ) ) AS Percentage_yes;
SELECT Sure, here's the query:  (SELECT COUNT(DISTINCT UserID) FROM answer WHERE surveyid = 2017 AND questionid IN (SELECT questionid FROM question WHERE questiontext LIKE '%mental health%')) - (SELECT COUNT(DISTINCT UserID) FROM answer WHERE surveyid = 2018 AND questionid IN (SELECT questionid FROM question WHERE questiontext LIKE '%mental health%'))) AS times_more 
SELECT (COUNT(CASE WHEN surveyid = 2016 AND questionid = 32 AND answertext = 'Yes' THEN 1 END) * 100.0) / COUNT(CASE WHEN surveyid = 2016 AND questionid = 32 THEN 1 END) FROM answer;
SELECT COUNT(DISTINCT userid) FROM answer WHERE questionid = 1 AND surveyid = 2016 AND CAST(answertext AS INTEGER) < 25;
SELECT AVG(num_respondents) FROM (     SELECT COUNT(DISTINCT userid) AS num_respondents     FROM answer     WHERE surveyid IN (SELECT surveyid FROM survey WHERE description LIKE '%2014%')     UNION     SELECT COUNT(DISTINCT userid) AS num_respondents     FROM answer     WHERE surveyid IN (SELECT surveyid FROM survey WHERE description LIKE '%2019%') ); 
SELECT COUNT(DISTINCT userid) FROM answer WHERE surveyid = 2019 AND questionid = 7 AND answertext = 1;
SELECT COUNT(DISTINCT userid) FROM answer WHERE surveyid = 2014 AND questionid = 93 AND answertext = 'Yes';
SELECT COUNT(*) FROM question WHERE questionid IN (     SELECT questionid     FROM survey     WHERE description = 'mental health survey' ); 
SELECT COUNT(DISTINCT userid) FROM answer WHERE questionid = (     SELECT questionid     FROM question     WHERE questiontext = 'Substance Use Disorder' )
SELECT AnswerText, COUNT(*) AS ResponseCount FROM answer WHERE surveyid = 2017 AND questionid = 85 GROUP BY AnswerText ORDER BY ResponseCount DESC LIMIT 3; 
SELECT SUM(CASE WHEN year = 1998 THEN total ELSE 0 END) - SUM(CASE WHEN year = 1997 THEN total ELSE 0 END) AS revenue_difference FROM revenue; 
SELECT MAX(revenue.studio_entertainment) AS studio_entertainment_revenue, MAX(revenue.disney_media_networks) AS disney_media_networks_revenue FROM revenue WHERE year = 1998;
SELECT director.name FROM director INNER JOIN characters ON director.name = characters.movie_title WHERE characters.movie_title = 'Pinocchio';
SELECT villain FROM characters JOIN director ON director.name = characters.movie_title WHERE director.director = 'Wolfgang Reitherman';
SELECT COUNT(*)  FROM movies_total_gross WHERE director = 'Wolfgang Reitherman'  AND substr(release_date, instr(release_date, '-') + 1, 3) = 'Dec';
SELECT director.name FROM director JOIN characters ON director.name = characters.movie_title WHERE characters.song = "Once Upon a Dream";
SELECT voice_actors.voice_actor FROM voice_actors JOIN characters ON voice_actors.character = characters.villian WHERE characters.movie_title = 'Alice in Wonderland';
SELECT release_date FROM   characters JOIN   voice_actors ON characters.movie_title = voice_actors.movie AND characters.hero = voice_actors.character WHERE   voice_actors.voice_actor = 'Alan Tudyk';
SELECT COUNT(DISTINCT characters.movie_title) FROM     voice_actors JOIN     characters ON voice_actors.character = characters.hero JOIN     movies_total_gross ON characters.movie_title = movies_total_gross.movie_title WHERE     voice_actors.voice_actor = 'Alan Tudyk'     AND substr(characters.release_date, instr(characters.release_date, '-') + 1) > 12;
SELECT COUNT(*) FROM movies_total_gross WHERE movie_title IN (     SELECT movie_title     FROM director     JOIN movies_total_gross ON director.name = movies_total_gross.movie_title     WHERE director = 'Wolfgang Reitherman' ) AND genre = 'Comedy';
SELECT MAX(total_gross) AS highest_gross, movie_title FROM movies_total_gross WHERE director = 'Wolfgang Reitherman';
SELECT movies_total_gross.movie_title FROM movies_total_gross JOIN director ON movies_total_gross.movie_title = director.movie_title WHERE director.director = 'Wolfgang Reitherman' AND movies_total_gross.mpaa_rating = 'G'; 
SELECT characters.villian FROM characters JOIN movies_total_gross ON characters.movie_title = movies_total_gross.movie_title WHERE movies_total_gross.total_gross = (     SELECT MAX(total_gross) FROM movies_total_gross )
SELECT movies_total_gross.genre FROM movies_total_gross JOIN characters ON movies_total_gross.movie_title = characters.movie_title WHERE characters.villain = 'Commander Rourke';
SELECT villian FROM characters WHERE movie_title = 'Beauty and the Beast';
SELECT movies_total_gross.movie_title FROM characters JOIN movies_total_gross ON characters.movie_title = movies_total_gross.movie_title WHERE characters.hero = 'Robin Hood';
SELECT movie_title FROM characters WHERE song = "I Thought I Lost You";
SELECT voice_actors.voice_actor FROM voice_actors INNER JOIN characters ON voice_actors.character = characters.hero WHERE characters.hero = "Binkie Muddlefoot";
SELECT characters.hero FROM characters JOIN movies_total_gross ON characters.movie_title = movies_total_gross.movie_title WHERE movies_total_gross.total_gross = 222527828;
SELECT MAX(song) AS most_popular_song FROM     characters JOIN     movies_total_gross ON characters.movie_title = movies_total_gross.movie_title WHERE     CAST(SUBSTR(release_date, INSTR(release_date, ', ') + 1) AS INTEGER) BETWEEN 1970 AND 1979 ORDER BY     total_gross DESC LIMIT 1;
SELECT characters.hero FROM characters JOIN director ON director.name = characters.movie_title WHERE director.director = 'Will Finn';
SELECT voice_actors.voice_actor FROM voice_actors JOIN characters ON characters.hero = voice_actors.character WHERE characters.movie_title = 'The Little Mermaid';
SELECT director.name FROM director JOIN characters ON director.name = characters.movie_title JOIN voice-actors ON characters.movie_title = voice-actors.movie WHERE voice-actors.character = "Aunt Sarah" AND voice-actors.voice-actor = "Verna Felton";
SELECT movies_total_gross.release_date FROM voice_actors INNER JOIN characters ON voice_actors.character = characters.hero INNER JOIN movies_total_gross ON characters.movie_title = movies_total_gross.movie_title WHERE voice_actors.voice_actor = 'Tress MacNeille' AND characters.character = 'Hyacinth Hippo'; 
SELECT director.name FROM director JOIN movies_total_gross ON director.name = movies_total_gross.movie_title WHERE movies_total_gross.release_date = 'Mar 30, 2007' AND movies_total_gross.genre = 'Adventure';
SELECT movies_total_gross.movie_title FROM movies_total_gross JOIN director ON movies_total_gross.movie_title = director.name WHERE director.director = 'Wolfgang Reitherman' ORDER BY movies_total_gross.inflation_adjusted_gross DESC LIMIT 1;
SELECT characters.hero FROM characters JOIN movies_total_gross ON characters.movie_title = movies_total_gross.movie_title WHERE movies_total_gross.release_date = '4-Mar-16' AND movies_total_gross.genre = 'Adventure';
SELECT MAX(movies_total_gross.total_gross) AS max_gross, movies_total_gross.movie_title FROM characters JOIN movies_total_gross ON characters.movie_title = movies_total_gross.movie_title WHERE characters.hero = 'Donald Duck';
SELECT COUNT(*)  FROM director  WHERE director = 'Wolfgang Reitherman';
SELECT director.name FROM director JOIN characters ON director.name = characters.movie_title GROUP BY director.name ORDER BY COUNT(*) DESC LIMIT 1; 
SELECT COUNT(*) FROM movies_total_gross WHERE mpaa_rating = 'R' AND genre = 'Horror' AND cast(SUBSTR(release_date, instr(release_date, ', ') + 1) as int) BETWEEN 1990 AND 2015;
SELECT characters.movie_title, characters.character FROM voice-actors JOIN characters ON voice-actors.character = characters.hero WHERE voice-actors.voice_actor = 'Frank Welker';
SELECT SUM(movies_total_gross.total_gross) FROM     movies_total_gross JOIN     characters ON movies_total_gross.movie_title = characters.movie_title WHERE     characters.song = 'Little Wonders';
SELECT movies_total_gross.mpaa_rating FROM movies_total_gross JOIN characters ON movies_total_gross.movie_title = characters.movie_title WHERE characters.villain = 'Turbo'; 
SELECT COUNT(DISTINCT voice_actors.movie) AS num_movies FROM     voice_actors JOIN     characters ON characters.character = voice_actors.character JOIN     movies_total_gross ON movies_total_gross.movie_title = characters.movie_title WHERE     voice_actors.voice_actor = 'Bill Thompson'     AND movies_total_gross.mpaa_rating IN ('PG', 'PG-13');
SELECT COUNT(*) FROM   director AS d JOIN   characters AS c ON d.name = c.movie_title JOIN   movies_total_gross AS m ON c.movie_title = m.movie_title WHERE   d.director = 'Gary Trousdale'   AND m.genre = 'Adventure';
SELECT director.name, COUNT(*) AS collaborations FROM voice-actors JOIN characters ON voice-actors.character = characters.hero JOIN director ON director.name = characters.movie_title WHERE voice-actors.voice_actor = 'Bill Thompson' GROUP BY director.name ORDER BY collaborations DESC LIMIT 1;
SELECT movie_title FROM     director JOIN     characters ON director.name = characters.movie_title JOIN     movies_total_gross ON characters.movie_title = movies_total_gross.movie_title WHERE     director = 'Ron Clements' ORDER BY     total_gross DESC LIMIT 1; 
SELECT voice_actors.voice_actor FROM   voice_actors   JOIN characters ON voice_actors.character = characters.hero   JOIN director ON director.name = characters.movie_title WHERE   director.director = 'Ben Sharpsteen'   AND characters.release_date = 'Feb 9, 1940';
SELECT COUNT(*) FROM     movies_total_gross AS mtg JOIN     director AS d ON mtg.movie_title = d.name WHERE     d.director = 'Ron Clements' AND     mtg.mpaa_rating = 'PG' AND     mtg.genre = 'Adventure';
SELECT COUNT(*) FROM movies_total_gross WHERE genre = 'Horror';
SELECT villian FROM characters WHERE movie_title = 'The Great Mouse Detective';
SELECT voice_actor FROM voice-actors WHERE movie = 'Meet the Robinsons';
SELECT director.name, COUNT(dir