tables="/home/baaiks/cf/pycharm/spider-master/spider/tables.json"
dev_path="/home/baaiks/cf/pycharm/spider-master/spider-realistic/spider-realistic.json"
db_path="/home/baaiks/cf/pycharm/spider-master/spider/database"
cache_dir="/data/cf/LMs"
PROCESS_NUM=1
API_CALL_NUM=100
GPU_NUM=8

first_output_path="./intermediate_datasets_spider_realistic/first_round.sql"
second_output_path="./intermediate_datasets_spider_realistic/second_round.sql"
third_output_path="./intermediate_datasets_spider_realistic/third_round.sql"
processed_dataset_path="./generate_datasets_spider_realistic/preprocessed_data.json"
final_output_path="./intermediate_datasets_spider_realistic/predict_dev.json"

RETRY_NUM=30

directory="./intermediate_datasets_spider_realistic"
if [ ! -d "$directory" ]; then
  mkdir -p "$directory"
fi

directory="./generate_datasets_spider_realistic"
if [ ! -d "$directory" ]; then
  mkdir -p "$directory"
fi

current_time=$(date)
echo $current_time

echo "preprocessing..."
python preprocess/preprocessing.py \
    --mode "test" \
    --table_path $tables \
    --input_dataset_path $dev_path \
    --output_dataset_path $processed_dataset_path \
    --db_path $db_path \
    --target_type "sql" \
    --process_num $PROCESS_NUM

echo "first round..."
python src/first_round.py \
    --dev_path $dev_path \
    --data_path $processed_dataset_path \
    --output_path $first_output_path \
    --process_num $API_CALL_NUM

echo "second round..."
python src/second_round.py \
    --cache_dir $cache_dir \
    --dev_path $dev_path \
    --data_path $processed_dataset_path \
    --input_path $first_output_path \
    --output_path $second_output_path \
    --db_path $db_path \
    --num_gpus $GPU_NUM

echo "third round..."
python src/third_round.py \
    --dev_path $dev_path \
    --data_path $processed_dataset_path \
    --input_path $second_output_path \
    --output_path $third_output_path \
    --db_path $db_path \
    --retry_num $RETRY_NUM \
    --process_num $API_CALL_NUM

echo "generate standard output..."
python src/append_db_id.py \
    --dev_path $dev_path \
    --input_path $third_output_path \
    --output_path $final_output_path

if [ ! -d "$third_output_path" ]; then
    sleep 5
fi

pkill -f third_round.pys

current_time=$(date)
echo $current_time