SELECT AVG(points)  FROM driverstandings  JOIN drivers ON driverstandings.driverid = drivers.driverid  JOIN races ON driverstandings.raceid = races.raceid  WHERE drivers.forename = 'Eddie' AND drivers.surname = 'Irvine' AND races.year = 2000
SELECT races.name, results.points FROM drivers JOIN results ON drivers.driverid = results.driverid JOIN races ON results.raceid = races.raceid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' ORDER BY races.year ASC LIMIT 1;
SELECT races.name, circuits.country FROM races JOIN circuits ON races.circuitid = circuits.circuitid JOIN seasons ON races.year = seasons.year WHERE seasons.year = 2017 ORDER BY races.date ASC;
SELECT MAX(races.laps) AS max_laps, races.name AS race_name, races.year AS race_year, circuits.location AS circuit_location FROM races JOIN circuits ON races.circuitid = circuits.circuitid;
SELECT CAST(COUNT(CASE WHEN T1.country = 'Germany' THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T1.country) FROM circuits AS T1 INNER JOIN races AS T2 ON T1.circuitid = T2.circuitid WHERE T2.name = 'European Grand Prix'
SELECT circuits.lat, circuits.lng FROM circuits WHERE circuits.name = 'Silverstone Circuit'
SELECT name FROM circuits WHERE lat = (SELECT MAX(lat) FROM circuits)
SELECT circuits.circuitref FROM circuits WHERE circuits.name = 'Marina Bay Street Circuit'
SELECT circuits.country FROM circuits WHERE circuits.alt = (SELECT MAX(alt) FROM circuits)
SELECT COUNT(*) FROM drivers WHERE code IS NULL;
SELECT drivers.nationality FROM drivers WHERE drivers.dob = (SELECT MIN(dob) FROM drivers)
SELECT drivers.surname FROM drivers WHERE drivers.nationality = 'Italian'
SELECT drivers.url FROM drivers WHERE drivers.forename = 'Anthony' AND drivers.surname = 'Davidson'
SELECT driverref FROM drivers WHERE forename = 'Lewis' AND surname = 'Hamilton'
SELECT circuits.name FROM circuits JOIN races ON races.circuitid = circuits.circuitid JOIN seasons ON races.year = seasons.year WHERE races.name = 'Spanish Grand Prix' AND seasons.year = 2009;
