SELECT customers.customerid FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE yearmonth.date BETWEEN 201201 AND 201212 AND customers.segment = 'LAM' ORDER BY yearmonth.consumption ASC LIMIT 1;
SELECT AVG(consumption) / 12 FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE customers.segment = 'SME' AND yearmonth.date BETWEEN '201301' AND '201312'
SELECT customers.customerid FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE customers.currency = 'CZK' AND yearmonth.date BETWEEN '201101' AND '201112' ORDER BY yearmonth.consumption DESC LIMIT 1
SELECT COUNT(*)  FROM customers  JOIN yearmonth ON customers.customerid = yearmonth.customerid  WHERE segment = 'KAM' AND consumption < 30000 AND date BETWEEN 201201 AND 201212
SELECT SUM(CASE WHEN customers.currency = 'CZK' THEN yearmonth.consumption ELSE 0 END) - SUM(CASE WHEN customers.currency = 'EUR' THEN yearmonth.consumption ELSE 0 END) AS difference FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE yearmonth.date BETWEEN '201201' AND '201212'
SELECT STRFTIME('%Y', T2.Date) FROM customers AS T1 INNER JOIN transactions_1k AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.Currency = 'EUR' GROUP BY STRFTIME('%Y', T2.Date) ORDER BY SUM(T2.Amount) DESC LIMIT 1
SELECT MIN(segment) AS segment_with_least_consumption FROM (     SELECT         customers.segment,         SUM(yearmonth.consumption) AS total_consumption     FROM         customers     LEFT JOIN         yearmonth ON customers.customerid = yearmonth.customerid     GROUP BY         customers.segment ) AS consumption_summary;
SELECT MAX(SUBSTR(date, 1, 4)) AS year FROM yearmonth WHERE currency = 'CZK' GROUP BY SUBSTR(date, 1, 4) ORDER BY SUM(consumption) DESC LIMIT 1;
SELECT yearmonth.date FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE customers.segment = 'SME' AND yearmonth.date LIKE '2013%' ORDER BY yearmonth.consumption DESC LIMIT 1;
SELECT SUM(CASE WHEN T2.Segment = 'SME' THEN T1.Consumption ELSE 0 END) / COUNT(CASE WHEN T2.Segment = 'SME' THEN T1.CustomerID ELSE NULL END) - SUM(CASE WHEN T2.Segment = 'LAM' THEN T1.Consumption ELSE 0 END) / COUNT(CASE WHEN T2.Segment = 'LAM' THEN T1.CustomerID ELSE NULL END) AS SME_LAM , SUM(CASE WHEN T2.Segment = 'LAM' THEN T1.Consumption ELSE 0 END) / COUNT(CASE WHEN T2.Segment = 'LAM' THEN T1.CustomerID ELSE NULL END) - SUM(CASE WHEN T2.Segment = 'KAM' THEN T1.Consumption ELSE 0 END) / COUNT(CASE WHEN T2.Segment = 'KAM' THEN T1.CustomerID ELSE NULL END) AS LAM_KAM , SUM(CASE WHEN T2.Segment = 'KAM' THEN T1.Consumption ELSE 0 END) / COUNT(CASE WHEN T2.Segment = 'KAM' THEN T1.CustomerID ELSE NULL END) - SUM(CASE WHEN T2.Segment = 'SME' THEN T1.Consumption ELSE 0 END) / COUNT(CASE WHEN T2.Segment = 'SME' THEN T1.CustomerID ELSE NULL END) AS KAM_SME FROM yearmonth AS T1 INNER JOIN customers AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.Date LIKE '2013%' AND T2.Currency = 'CZK'
SELECT MAX((yt.consumption - ym.consumption) / yt.consumption * 100) AS max_increase_percentage, MIN((yt.consumption - ym.consumption) / yt.consumption * 100) AS min_increase_percentage, CASE     WHEN customers.segment = 'SME' THEN 'SME'     WHEN customers.segment = 'LAM' THEN 'LAM'     WHEN customers.segment = 'KAM' THEN 'KAM' END AS segment FROM yearmonth AS ym JOIN yearmonth AS yt ON ym.customerid = yt.customerid JOIN customers ON ym.customerid = customers.customerid WHERE ym.date LIKE '2012%' AND yt.date LIKE '2013%' AND customers.currency = 'EUR' GROUP BY segment;
SELECT SUM(consumption) FROM yearmonth WHERE customerid = 6 AND date >= '201308' AND date <= '201311'
SELECT SUM(CASE WHEN country = 'CZE' THEN 1 ELSE 0 END) - SUM(CASE WHEN country = 'SVK' THEN 1 ELSE 0 END) FROM gasstations WHERE segment = 'Discount'
SELECT SUM(y1.consumption) - SUM(y2.consumption) FROM yearmonth y1 JOIN yearmonth y2 ON y1.customerid = y2.customerid WHERE y1.customerid = 7 AND y1.date = 201304 AND y2.customerid = 5 AND y2.date = 201304;
SELECT SUM(CASE WHEN Currency = 'CZK' THEN 1 ELSE 0 END) - SUM(CASE WHEN Currency = 'EUR' THEN 1 ELSE 0 END) AS diff FROM customers WHERE Segment = 'SME'
