SELECT races.year, races.name, races.date, races.time FROM races JOIN qualifying ON races.raceid = qualifying.raceid JOIN drivers ON qualifying.driverid = drivers.driverid WHERE drivers.dob = (SELECT MIN(dob) FROM drivers)
SELECT COUNT(*)  FROM drivers  JOIN results ON drivers.driverid = results.driverid  JOIN status ON results.statusid = status.statusid  WHERE drivers.nationality = 'American' AND status.status = 'Disqualified'
SELECT constructors.name, constructors.url FROM constructors JOIN constructorstandings ON constructors.constructorid = constructorstandings.constructorid WHERE constructors.nationality = 'Italian' ORDER BY constructorstandings.points DESC LIMIT 1;
SELECT constructors.url FROM constructors JOIN constructorstandings ON constructors.constructorid = constructorstandings.constructorid GROUP BY constructors.constructorid ORDER BY SUM(constructorstandings.wins) DESC LIMIT 1;
SELECT drivers.forename, drivers.surname FROM drivers JOIN results ON drivers.driverid = results.driverid JOIN races ON results.raceid = races.raceid JOIN laptimes ON races.raceid = laptimes.raceid AND results.driverid = laptimes.driverid WHERE races.name = 'French Grand Prix' AND laptimes.lap = 3 ORDER BY laptimes.time DESC LIMIT 1;
SELECT races.name, laptimes.time, laptimes.milliseconds FROM races JOIN laptimes ON races.raceid = laptimes.raceid WHERE laptimes.lap = 1 ORDER BY laptimes.milliseconds ASC LIMIT 1;
SELECT AVG(results.fastestlaptime) FROM results JOIN races ON results.raceid = races.raceid WHERE races.name = 'United States Grand Prix' AND races.year = 2006 AND results.rank < 11;
SELECT T1.forename, T1.surname FROM drivers AS T1 INNER JOIN pitstops AS T2 ON T1.driverid = T2.driverid WHERE T1.nationality = 'German' AND T1.dob BETWEEN '1980-01-01' AND '1985-12-31' ORDER BY T2.duration ASC LIMIT 5
SELECT drivers.forename || ' ' || drivers.surname AS champion, results.time FROM results JOIN races ON results.raceid = races.raceid JOIN drivers ON results.driverid = drivers.driverid JOIN circuits ON races.circuitid = circuits.circuitid WHERE races.name = 'Canadian Grand Prix' AND races.year = 2008 AND results.position = 1;
SELECT constructors.constructorref, constructors.url FROM constructors JOIN constructorstandings ON constructors.constructorid = constructorstandings.constructorid JOIN races ON constructorstandings.raceid = races.raceid WHERE races.name = 'Singapore Grand Prix' AND races.year = 2009 AND constructorstandings.position = 1;
SELECT forename , surname , dob FROM drivers WHERE nationality = 'Austrian' AND dob BETWEEN '1981-01-01' AND '1991-12-31'
SELECT drivers.forename || ' ' || drivers.surname AS full_name, drivers.url, drivers.dob FROM drivers WHERE drivers.nationality = 'German' AND strftime('%Y', drivers.dob) BETWEEN '1971' AND '1985' ORDER BY drivers.dob DESC;
SELECT circuits.location, circuits.country, circuits.lat, circuits.lng FROM circuits WHERE circuits.name = 'Hungaroring'
SELECT constructorstandings.points, constructors.name, constructors.nationality FROM constructorstandings JOIN constructors ON constructorstandings.constructorid = constructors.constructorid JOIN races ON constructorstandings.raceid = races.raceid WHERE races.name = 'Monaco Grand Prix' AND races.year BETWEEN 1980 AND 2010 ORDER BY constructorstandings.points DESC LIMIT 1;
SELECT AVG(points) FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' AND races.name = 'Turkish Grand Prix'
SELECT CAST(COUNT(raceid) AS REAL) / 10 FROM races WHERE year BETWEEN 2001 AND 2010
