SELECT T2.year FROM circuits AS T1 INNER JOIN races AS T2 ON T1.circuitid = T2.circuitid WHERE T1.name = 'Brands Hatch' AND T2.name = 'British Grand Prix' ORDER BY T2.year DESC LIMIT 1
SELECT COUNT(DISTINCT seasons.year) FROM circuits JOIN races ON races.circuitid = circuits.circuitid JOIN seasons ON races.year = seasons.year WHERE circuits.name = 'Silverstone Circuit' AND races.name = 'British Grand Prix'
SELECT drivers.forename, drivers.surname FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid WHERE races.name = 'Singapore Grand Prix' AND races.year = 2010 ORDER BY driverstandings.position
SELECT drivers.forename , drivers.surname FROM driverstandings join drivers on driverstandings.driverid = drivers.driverid ORDER BY driverstandings.points DESC LIMIT 1
SELECT drivers.forename, drivers.surname, driverstandings.points FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid WHERE races.name = 'Chinese Grand Prix' AND races.year = 2017 ORDER BY driverstandings.points DESC LIMIT 3;
SELECT laptimes.time, drivers.forename, drivers.surname, races.name FROM laptimes JOIN drivers ON laptimes.driverid = drivers.driverid JOIN races ON laptimes.raceid = races.raceid WHERE laptimes.time = (SELECT MIN(time) FROM laptimes)
SELECT AVG(laptimes.time)  FROM laptimes  JOIN drivers ON laptimes.driverid = drivers.driverid  JOIN races ON laptimes.raceid = races.raceid  WHERE drivers.forename = 'Sebastian'  AND drivers.surname = 'Vettel'  AND races.year = 2009  AND races.name = 'Chinese Grand Prix';
SELECT CAST(SUM(CASE WHEN T1.position > 1 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.position) FROM results AS T1 INNER JOIN races AS T2 ON T1.raceid = T2.raceid INNER JOIN drivers AS T3 ON T1.driverid = T3.driverid WHERE T3.forename = 'Lewis' AND T3.surname = 'Hamilton' AND T2.year >= 2010
SELECT drivers.forename, drivers.surname, drivers.nationality, AVG(driverstandings.points) as average_point_scores FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid GROUP BY drivers.driverid ORDER BY COUNT(driverstandings.wins) DESC LIMIT 1;
SELECT MAX(2022 - strftime('%Y', dob) + 1) AS age, forename FROM drivers WHERE nationality = 'Japanese';
SELECT circuits.name FROM circuits JOIN races ON circuits.circuitid = races.circuitid WHERE races.year BETWEEN 1990 AND 2000 GROUP BY circuits.circuitid HAVING COUNT(races.raceid) = 4;
SELECT circuits.name, circuits.location, races.name FROM circuits JOIN races ON circuits.circuitid = races.circuitid JOIN seasons ON races.year = seasons.year WHERE circuits.country = 'USA' AND seasons.year = 2006
SELECT races.name, circuits.name, circuits.location FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE strftime('%m', races.date) = '09' AND races.year = 2005
SELECT races.name FROM races JOIN results ON races.raceid = results.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Alex' AND drivers.surname = 'Yoong' AND results.position < 10
SELECT COUNT(*)  FROM driverstandings ds  JOIN drivers d ON ds.driverid = d.driverid  JOIN races r ON ds.raceid = r.raceid  JOIN circuits c ON r.circuitid = c.circuitid  WHERE d.forename = 'Michael'  AND d.surname = 'Schumacher'  AND c.name = 'Sepang International Circuit'  AND ds.position = 1
SELECT races.name, races.year FROM races JOIN results ON races.raceid = results.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Michael' AND drivers.surname = 'Schumacher' ORDER BY results.milliseconds ASC LIMIT 1;
