SELECT SUM(CASE WHEN foreign_data.language = 'Japanese' THEN 1 ELSE 0 END) * 100.0 / SUM(1) as percentage_of_japanese_nonfoil FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.language = 'Japanese';
SELECT CAST(SUM(CASE WHEN T2.isOnlineOnly = 1 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM set_translations AS T1 INNER JOIN cards AS T2 ON T1.id = T2.uuid WHERE T1.language = 'Portuguese (Brazil)'
SELECT DISTINCT cards.availability FROM cards WHERE cards.artist = 'Aleksi Briclot' AND cards.istextless = 1;
SELECT sets.id FROM sets WHERE sets.basesetsize = (     SELECT MAX(sets.basesetsize)     FROM sets )
SELECT cards.artist FROM cards WHERE cards.side IS NULL ORDER BY cards.convertedmanacost DESC LIMIT 1;
SELECT MAX(frameeffects)  FROM cards  WHERE hasfoil = 1  AND cardkingdomfoilid IS NOT NULL  AND cardkingdomid IS NOT NULL
SELECT COUNT(*)  FROM cards  WHERE power IS NULL OR power = '*'  AND hasFoil = 0  AND duelDeck = 'a'
SELECT sets.id FROM sets WHERE sets.type = 'expansion' AND sets.totalsetsize = (     SELECT MAX(totalsetsize)     FROM sets     WHERE sets.type = 'expansion'     AND sets.code NOT LIKE '%AL%'     AND sets.code NOT LIKE '%C21%'     AND sets.code NOT LIKE '%C20%'     AND sets.code NOT LIKE '%C19%'     AND sets.code NOT LIKE '%C18%'     AND sets.code NOT LIKE '%C17%'     AND sets.code NOT LIKE '%C16%'     AND sets.code NOT LIKE '%C15%'     AND sets.code NOT LIKE '%C14%'     AND sets.code NOT LIKE '%C13%'     AND sets.code NOT LIKE '%C12%'     AND sets.code NOT LIKE '%C11%'     AND sets.code NOT LIKE '%C10%'     AND sets.code NOT LIKE '%C09%'     AND sets.code NOT LIKE '%C08%'     AND sets.code NOT LIKE '%C07%'     AND sets.code NOT LIKE '%C06%'     AND sets.code NOT LIKE '%C05%'     AND sets.code NOT LIKE '%C04%'     AND sets.code NOT LIKE '%C03%'     AND sets.code NOT LIKE '%C02%'     AND sets.code NOT LIKE '%C01%'     AND sets.code NOT LIKE '%C00%'     AND sets.code NOT LIKE '%C99%'     AND sets.code NOT LIKE '%C98%'     AND sets.code NOT LIKE '%C97%'     AND sets.code NOT LIKE '%C96%'     AND sets.code NOT LIKE '%C95%'     AND sets.code NOT LIKE '%C94%'     AND sets.code NOT LIKE '%C93%'     AND sets.code NOT LIKE '%C92%' )
SELECT name FROM cards WHERE convertedmanacost = ( SELECT MAX(convertedmanacost) FROM cards ) LIMIT 10
SELECT MIN(cards.originalreleasedate) AS oldest_release_date, legalities.format FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.rarity = 'mythic' AND legalities.status = 'Legal'
SELECT COUNT(*)  FROM cards  JOIN foreign_data ON cards.uuid = foreign_data.uuid  WHERE artist = 'Volkan Baga' AND language = 'French'
SELECT COUNT(*)  FROM cards  JOIN legalities ON cards.uuid = legalities.uuid  WHERE rarity = 'rare'  AND types = 'Enchantment'  AND name = 'Abundance'  AND status = 'Legal'
SELECT T1.format, T2.name FROM legalities AS T1 INNER JOIN cards AS T2 ON T1.uuid = T2.uuid WHERE T1.status = 'Banned' GROUP BY T1.format ORDER BY COUNT(T1.status) DESC LIMIT 1
SELECT sets.name, set_translations.language FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE sets.name = 'Battlebond'
SELECT artist, GROUP_CONCAT(DISTINCT legalities.format) AS formats FROM cards LEFT JOIN legalities ON cards.uuid = legalities.uuid GROUP BY artist ORDER BY COUNT(*) ASC LIMIT 1;
