SELECT AVG(bond_id_count) FROM (     SELECT COUNT(bond.bond_id) AS bond_id_count     FROM atom     JOIN connected ON atom.atom_id = connected.atom_id     JOIN bond ON connected.bond_id = bond.bond_id     WHERE atom.element = 'i'     GROUP BY atom.atom_id ) AS subquery;
SELECT bond.bond_type, bond.bond_id FROM atom JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON bond.bond_id = connected.bond_id WHERE SUBSTR(atom.atom_id, 7, 2) + 0 = 45
SELECT atom.element FROM atom WHERE atom.atom_id NOT IN (SELECT connected.atom_id FROM connected)
SELECT atom.atom_id FROM atom JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON bond.bond_id = connected.bond_id JOIN molecule ON molecule.molecule_id = atom.molecule_id WHERE molecule.molecule_id = 'TR447' AND bond.bond_type = '#';
SELECT atom.element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR144_8_19'
SELECT molecule.molecule_id FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE molecule.label = '+' AND bond.bond_type = '=' GROUP BY molecule.molecule_id ORDER BY COUNT(*) DESC LIMIT 1;
SELECT element FROM atom WHERE molecule_id IN (     SELECT molecule_id     FROM molecule     WHERE label = '+' ) GROUP BY element ORDER BY COUNT(*) ASC LIMIT 1;
SELECT atom_id FROM atom WHERE atom_id IN (     SELECT atom_id2     FROM connected     WHERE atom_id IN (         SELECT atom_id         FROM atom         WHERE element = 'pb'     ) )
SELECT atom.element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '#'
SELECT CAST(SUM(CASE WHEN T2.element = 'c' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.bond_id) FROM bond AS T1 INNER JOIN atom AS T2 ON T1.molecule_id = T2.molecule_id
SELECT CAST(SUM(CASE WHEN T2.bond_type = '=' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.molecule_id) FROM molecule AS T1 INNER JOIN bond AS T2 ON T1.molecule_id = T2.molecule_id
SELECT COUNT(DISTINCT atom.atom_id) FROM atom WHERE atom.element IN ('c', 'h')
SELECT connected.atom_id2 FROM atom JOIN connected ON connected.atom_id = atom.atom_id WHERE atom.element = 's'
SELECT bond.bond_type FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE atom.element = 'sn'
SELECT COUNT(DISTINCT atom.element) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_type = '-';
