SELECT MAX(frpm."percent (%) eligible free (k-12)") FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE schools.county = 'Alameda';
SELECT T2.Percent_Eligible_Free_Ages_5_17 FROM schools AS T1 INNER JOIN frpm AS T2 ON T1.CDSCode = T2.CDSCode WHERE T1.StatusType = 'Continuation' ORDER BY T2.Percent_Eligible_Free_Ages_5_17 LIMIT 3
SELECT zip FROM schools WHERE charter = 'Y' AND county = 'Fresno'
SELECT T2.mailstreet, T2.mailstrabr, T2.mailcity, T2.mailzip, T2.mailstate FROM frpm AS T1 INNER JOIN schools AS T2 ON T1.CDSCode = T2.CDSCode ORDER BY T1.FRPM_Count_K12 DESC LIMIT 1
SELECT phone FROM schools WHERE charter = 'Y' AND openDate > '2000-01-01'
SELECT COUNT(*) FROM     satscores JOIN     schools ON satscores.cds = schools.cdscode WHERE     avgscrmath < 400     AND virtual = 'F';
SELECT schools.school FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE satscores.numtsttakr > 500 AND schools.magnet = 1;
SELECT T2.phone FROM satscores AS T1 INNER JOIN schools AS T2 ON T1.CDS = T2.CDSCode WHERE T1.numtsttakr = ( SELECT MAX(numtsttakr) FROM satscores ) AND T1.AVGSCRREAD > 1500
SELECT T2.numtsttakr FROM frpm AS T1 INNER JOIN satscores AS T2 ON T1.CDSCode = T2.CDS WHERE T1.FRPMCountK12 = ( SELECT MAX(FRPMCountK12) FROM frpm )
SELECT COUNT(*) FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE satscores.avgscrmath > 560 AND schools.fundingtype = 'charter';
SELECT frpm."frpm count (ages 5-17)" FROM     frpm JOIN     schools ON frpm.cdscode = schools.cdscode JOIN     satscores ON satscores.cds = schools.cdscode ORDER BY     satscores.avgscrread DESC LIMIT 1;
SELECT cdscode FROM schools WHERE enroll12 > 500
SELECT MAX(T2.`Percent (%) Eligible Free (ages 5-17)`) FROM satscores AS T1 INNER JOIN frpm AS T2 ON T1.CDS = T2.CDSCode WHERE T1.NumGE1500 > 0 AND T1.NumTSTTAKR > 0 AND T1.NumGE1500 / T1.NumTSTTAKR > 0.3
SELECT schools.phone FROM     schools JOIN     satscores ON schools.cdscode = satscores.cds ORDER BY     satscores.numge1500 / satscores.numtsttakr DESC LIMIT 3;
SELECT schools.ncesschool FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode ORDER BY frpm."enrollment (ages 5-17)" DESC LIMIT 5;
SELECT schools.district,        AVG(satscores.avgscrread) AS average_reading_score FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE schools.statustype = 'Active' GROUP BY schools.district ORDER BY average_reading_score DESC LIMIT 1;
SELECT COUNT(*)  FROM schools AS s JOIN frpm AS f ON s.cdscode = f.cdscode JOIN satscores AS ss ON s.cdscode = ss.cds WHERE s.county = 'Alameda' AND ss.numtsttakr < 100;
SELECT schools.charternum FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode JOIN satscores ON frpm.cdscode = satscores.cds WHERE satscores.avgscrwrite = 499;
SELECT COUNT(*) FROM schools WHERE county = 'Contra Costa' AND fundingtype = 'Direct' AND numtsttakr <= 250
SELECT schools.phone FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE satscores.avgscrmath = (SELECT MAX(avgscrmath) FROM satscores);
SELECT COUNT(schools.school) FROM schools WHERE schools.county = 'Amador' AND schools."low grade" = 9 AND schools."high grade" = 12;
SELECT COUNT(T1.CDSCode) FROM frpm AS T1 INNER JOIN schools AS T2 ON T1.CDSCode = T2.CDSCode WHERE T2.City = 'Los Angeles' AND T1.`Free Meal Count (K-12)` > 500 AND T1.`Free Meal Count (K-12)` < 700
SELECT sname FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE cname = 'Contra Costa' ORDER BY numtsttakr DESC LIMIT 1;
SELECT T1.school, T1.street FROM schools AS T1 INNER JOIN frpm AS T2 ON T1.CDSCode = T2.CDSCode WHERE T2.Enrollment - T1.Enrollment > 30
SELECT T1.sname FROM satscores AS T1 INNER JOIN frpm AS T2 ON T1.cds = T2.CDSCode WHERE T1.numtsttakr >= 1500 AND T2.Percent_eligible_free_k_12 > 0.1
SELECT T2.FundingType FROM satscores AS T1 INNER JOIN schools AS T2 ON T1.CDS = T2.CDSCode WHERE T2.County = 'Riverside' AND T1.AvgScrMath > 400
SELECT T1.school, T1.street, T1.city, T1.state, T1.zip FROM schools AS T1 INNER JOIN frpm AS T2 ON T1.CDSCode = T2.CDSCode WHERE T2.county_name = 'Monterey' AND T2.percent_eligible_frpm_ages_5_17 > 800 AND T1.school_type = 'High'
SELECT AVG ( satscores.avgscrwrite ) , schools.school , schools.phone FROM satscores join schools on satscores.cds = schools.cdscode WHERE schools.opendate > 1991 or schools.closeddate < 2000 GROUP BY schools.school , schools.phone
SELECT T1.DOC, T1.DOCTYPE FROM schools AS T1 INNER JOIN frpm AS T2 ON T1.CDSCode = T2.CDSCode WHERE T1.FUNDINGTYPE = 'locally funded' AND T1.ENROLL12 - T1.GSSEVED > ( SELECT AVG(ENROLL12 - GSSEVED) FROM schools WHERE FUNDINGTYPE = 'locally funded' )
SELECT MAX(opendate) AS "Opening Date" FROM schools
SELECT city FROM schools ORDER BY enroll12 LIMIT 5;
SELECT CAST(SUM(CASE WHEN T2.`free meal count (k-12)` = 0 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.`free meal count (k-12)`) FROM schools AS T1 INNER JOIN frpm AS T2 ON T1.CDSCode = T2.CDSCode WHERE T1.`Enrollment (k-12)` IN ( SELECT `Enrollment (k-12)` FROM schools ORDER BY `Enrollment (k-12)` DESC LIMIT 10, 11 )
SELECT T2.Percent_Eligible_FRPM_K_12 FROM schools AS T1 INNER JOIN frpm AS T2 ON T1.CDSCode = T2.CDSCode WHERE T1.OwnershipCode = 66 ORDER BY T2.FRPM_Count_K_12 DESC LIMIT 5
SELECT schools.school, schools.website FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE frpm.free_meal_count_ages_5_17 BETWEEN 1900 AND 2000;
SELECT frpm."percent (%) eligible free (ages 5-17)" FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE schools.school = 'Kacey Gibson';
SELECT T1.admemail1 FROM schools AS T1 INNER JOIN frpm AS T2 ON T1.CDSCode = T2.CDSCode WHERE T2.Charter = 'Y' ORDER BY T1.Enrollment ASC LIMIT 1
SELECT T2.dname, T2.cname FROM satscores AS T1 INNER JOIN schools AS T2 ON T1.cds = T2.CDSCode WHERE T1.numtsttakr = ( SELECT MAX(numtsttakr) FROM satscores ) AND T1.numge1500 = 1500
SELECT schools.street, schools.city, schools.state, schools.zip FROM schools JOIN satscores ON schools.cdscode = satscores.cds ORDER BY (satscores.numge1500 / satscores.numtsttakr) ASC LIMIT 1;
SELECT schools.website FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE schools.county = 'Los Angeles County' AND satscores.numtsttakr BETWEEN 2000 AND 3000;
SELECT AVG(satscores.numtsttakr) FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE schools.city = 'Fresno' AND schools.opendate BETWEEN '1980-01-01' AND '1980-12-31';
SELECT schools.phone FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE schools.district = "Fresno Unified" ORDER BY satscores.avgscrread LIMIT 1;
SELECT T1.school FROM schools AS T1 INNER JOIN satscores AS T2 ON T1.CDSCode = T2.CDS WHERE T1.virtual = 'Y' ORDER BY T2.avgscrread DESC LIMIT 5
SELECT schools.edopsname FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE satscores.avgscrmath = (SELECT MAX(avgscrmath) FROM satscores);
SELECT AVG(satscores.avgscrmath) AS average_math_score, schools.county FROM satscores JOIN schools ON satscores.cds = schools.cdscode GROUP BY schools.county ORDER BY average_math_score LIMIT 1;
SELECT avgscrwrite, city FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE numge1500 >= (     SELECT MAX(numge1500)     FROM satscores ) ORDER BY numtsttakr DESC LIMIT 1;
SELECT schools.school, AVG(satscores.avgscrwrite) AS average_writing_score FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE schools.admfname1 = 'Ricci' AND schools.admlname1 = 'Ulrich' GROUP BY schools.school;
SELECT T1.State FROM schools AS T1 INNER JOIN frpm AS T2 ON T1.CDSCode = T2.CDSCode WHERE T1.DOC = '31' ORDER BY T1.Enroll12 DESC LIMIT 1
SELECT AVG(CASE WHEN strftime('%Y', schools.opendate) = '1980' AND schools.county = 'Alameda' AND schools.doc = 52 THEN 1 ELSE 0 END) FROM schools;
SELECT CAST(SUM(CASE WHEN T2.districtType = 'Unified' THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN T2.districtType = 'Elementary' THEN 1 ELSE 0 END) FROM schools AS T1 INNER JOIN frpm AS T2 ON T1.CDSCode = T2.CDSCode WHERE T1.county = 'Orange'
SELECT schools.county, schools.school, schools.closeddate FROM schools WHERE schools.statustype = 'Closed' GROUP BY schools.county ORDER BY COUNT(schools.school) DESC LIMIT 1;
SELECT schools.street FROM (SELECT    sname,     avgscrmath,     ROW_NUMBER() OVER (ORDER BY avgscrmath DESC) AS rank FROM     satscores) AS ranked_scores JOIN     schools ON ranked_scores.sname = schools.school WHERE     rank = 6;
SELECT schools.mailstreet, schools.school FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE satscores.avgscrread = (     SELECT MIN(avgscrread) FROM satscores );
SELECT COUNT(DISTINCT schools.cdscode) AS total_schools FROM     frpm JOIN     schools ON frpm.cdscode = schools.cdscode JOIN     satscores ON satscores.cds = schools.cdscode WHERE     satscores.avgscrread + satscores.avgscrmath + satscores.avgscrwrite >= 1500     AND schools.mailcity = 'Lakeport';
SELECT COUNT(satscores.numtsttakr) FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE schools.mailcity = 'Fresno';
SELECT schools.school, schools.mailzip FROM schools WHERE schools.admfname1 = 'Avetik' AND schools.admlname1 = 'Atoian'
SELECT CAST(SUM(CASE WHEN T1.county = 'Colusa' THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN T1.county = 'Humboldt' THEN 1 ELSE 0 END) FROM schools AS T1 INNER JOIN frpm AS T2 ON T1.CDSCode = T2.CDSCode WHERE T1.mailState = 'CA'
SELECT COUNT(*) FROM schools WHERE state = 'CA' AND city = 'San Joaquin' AND statustype = 'Active';
SELECT schools.phone, schools.ext FROM schools JOIN satscores ON schools.cdscode = satscores.cds ORDER BY satscores.avgscrwrite DESC LIMIT 1 OFFSET 332;
SELECT schools.phone, schools.ext, schools.school FROM schools WHERE schools.zip = '95203-3704';
SELECT website FROM schools WHERE     (admfname1 = 'Mike' AND admlname1 = 'Larson')     OR (admfname1 = 'Dante' AND admlname1 = 'Alvarez')     OR (admfname2 = 'Mike' AND admlname2 = 'Larson')     OR (admfname2 = 'Dante' AND admlname2 = 'Alvarez')     OR (admfname3 = 'Mike' AND admlname3 = 'Larson')     OR (admfname3 = 'Dante' AND admlname3 = 'Alvarez');
SELECT schools.website FROM schools INNER JOIN frpm ON frpm.cdscode = schools.cdscode INNER JOIN satscores ON satscores.cds = schools.cdscode WHERE schools.charter = 1 AND schools.virtual = 'P' AND schools.county = 'San Joaquin';
SELECT COUNT(*) FROM schools WHERE city = 'Hickman'  AND charter = '1' AND doc = '52';
SELECT COUNT(T1.CDSCode) FROM frpm AS T1 INNER JOIN schools AS T2 ON T1.CDSCode = T2.CDSCode WHERE T2.County = 'Los Angeles' AND T1.`Percent (%) Eligible FRPM (K-12)` < 0.18 AND T2.Charter = 'N'
SELECT T1.admfname1, T1.admlname1, T1.school, T1.city FROM schools AS T1 INNER JOIN satscores AS T2 ON T1.cdscode = T2.cds WHERE T1.charter = 'Y' AND T1.charterNum = '00D2'
SELECT COUNT(*) FROM schools WHERE mailcity = 'Hickman' AND charternum = '00D4';
SELECT CAST(SUM(CASE WHEN T2.fundingtype = 'locally funded' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.fundingtype) FROM frpm AS T1 INNER JOIN schools AS T2 ON T1.CDSCode = T2.CDSCode WHERE T2.county = 'Santa Clara'
SELECT COUNT(schools.cdscode) AS directly_funded_schools_opened FROM schools WHERE schools.opendate BETWEEN '2000-01-01' AND '2005-12-31' AND schools.county = 'Stanislaus' AND schools.fundingtype = 'Directly Funded';
SELECT SUM(T2.enroll12) FROM schools AS T1 INNER JOIN satscores AS T2 ON T1.CDSCode = T2.CDS WHERE T1.city = 'San Francisco' AND T1.opendate BETWEEN '1989-01-01' AND '1989-12-31'
SELECT T1.county FROM schools AS T1 INNER JOIN frpm AS T2 ON T1.CDSCode = T2.CDSCode WHERE T1.SOCode = 11 AND T1.opendate BETWEEN '1980-01-01' AND '1989-12-31' GROUP BY T1.county ORDER BY COUNT(T1.CDSCode) DESC LIMIT 1
SELECT schools.ncesdist FROM schools WHERE schools.soctype = '31';
SELECT COUNT(DISTINCT CASE WHEN schools.statustype = 'Active' AND schools.district = 'District Community Day' AND schools.county = 'Alpine' THEN schools.cdscode ELSE NULL END) AS active_schools, COUNT(DISTINCT CASE WHEN schools.statustype = 'Closed' AND schools.district = 'District Community Day' AND schools.county = 'Alpine' THEN schools.cdscode ELSE NULL END) AS closed_schools FROM schools WHERE schools.county = 'Alpine' AND schools.district = 'District Community Day';
SELECT district FROM schools WHERE city = 'Fresno' AND magnet = 'N'
SELECT T2.enrollment FROM schools AS T1 INNER JOIN frpm AS T2 ON T1.CDSCode = T2.CDSCode WHERE T1.school = 'State Special School' AND T2.`academic year` = '2014-2015' AND T1.city = 'Fremont' AND T1.EDOPSCode = 'SSS'
SELECT frpm."free meal count (ages 5-17)" FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE schools.mailstreet = 'PO Box 1040' AND schools.school = 'Youth Authority School';
SELECT T2.low_grade FROM schools AS T1 INNER JOIN frpm AS T2 ON T1.CDSCode = T2.CDSCode WHERE T1.NCESDist = 613360
SELECT T2.EDOPSName, T1.SchoolName FROM schools AS T1 INNER JOIN edops AS T2 ON T1.EDOPSCode = T2.EDOPSCode WHERE T1.CDSCode IN ( SELECT CDSCode FROM frpm WHERE CountyCode = 37 AND `NSLP Provision Status` = 'Breakfast Provision 2' )
SELECT T2.city FROM frpm AS T1 INNER JOIN schools AS T2 ON T1.CDSCode = T2.CDSCode WHERE T1.LunchProvision = '2' AND T1.LowGrade = 9 AND T1.HighGrade = 12 AND T2.county = 'Merced'
SELECT T1.Percent (%) Eligible FRPM (Ages 5-17), T2.School FROM frpm AS T1 INNER JOIN schools AS T2 ON T1.CDSCode = T2.CDSCode WHERE T2.County = 'Los Angeles' AND T2.GSOffered = 'KG-09'
SELECT T2.grade_span FROM schools AS T1 INNER JOIN frpm AS T2 ON T1.CDSCode = T2.CDSCode WHERE T1.city = 'Adelanto' GROUP BY T2.grade_span ORDER BY COUNT(T2.grade_span) DESC LIMIT 1
SELECT COUNT(schools.school) FROM schools JOIN frpm ON frpm.cdscode = schools.cdscode WHERE schools.county IN ('San Diego', 'Santa Barbara') AND schools.virtual = 'F';
SELECT schooltype, school, latitude FROM schools ORDER BY latitude DESC LIMIT 1
SELECT city, lowGrade FROM schools WHERE state = 'CA' ORDER BY latitude LIMIT 1
SELECT low_grade, high_grade FROM schools WHERE longitude = (SELECT MAX(longitude) FROM schools);
SELECT COUNT(DISTINCT schools.city) AS num_cities, COUNT(*) AS num_schools FROM schools WHERE schools.gsoffered LIKE '%K-8%' AND schools.magnet = 1;
SELECT admfname1, dname FROM schools GROUP BY admfname1 ORDER BY COUNT(admfname1) DESC LIMIT 2
SELECT T1.Percent% Eligible Free (K-12), T2.DistrictCode FROM frpm AS T1 INNER JOIN schools AS T2 ON T1.CDSCode = T2.CDSCode WHERE T2.AdmFName1 = 'Alusine'
SELECT schools.admlname1, schools.district, schools.county, schools.school FROM schools WHERE schools.charternum = 40;
SELECT schools.admemail1 FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode JOIN satscores ON satscores.cds = schools.cdscode WHERE schools.county = 'San Bernardino' AND schools.district = 'San Bernardino City Unified' AND schools.opendate BETWEEN '2009-01-01' AND '2010-12-31' AND (schools.soctype = 62 OR schools.doc = 54)
SELECT schools.admemail1, schools.school FROM schools join satscores on schools.cdscode = satscores.cds WHERE satscores.numge1500 = ( SELECT MAX(numge1500) FROM satscores )
SELECT COUNT(account.account_id) FROM     account JOIN     disp ON account.account_id = disp.account_id JOIN     card ON disp.disp_id = card.disp_id JOIN     client ON disp.client_id = client.client_id JOIN     district ON account.district_id = district.district_id WHERE     district.a3 = 'East Bohemia'     AND card.issued > account.date     AND card.type = 'POPLATEK PO OBRATU';
SELECT COUNT(DISTINCT account.account_id) FROM     account JOIN     district ON account.district_id = district.district_id WHERE     district.a3 = 'Prague' AND     account.account_id IN (SELECT DISTINCT account_id FROM loan);
SELECT CASE WHEN AVG ( a12 ) > AVG ( a13 ) THEN '1995' ELSE '1996' END FROM district
SELECT COUNT(T1.district_id) FROM client AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T1.gender = 'F' AND T2.a11 > 6000 AND T2.a11 < 10000
SELECT COUNT(T1.client_id) FROM client AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T1.gender = 'M' AND T2.a3 = 'North Bohemia' AND T1.average_salary > 8000
SELECT MAX(district.a11) - MIN(district.a11) FROM district JOIN client ON district.district_id = client.district_id WHERE client.gender = 'F'
SELECT account_id FROM client ORDER BY birth_date DESC , A11 DESC LIMIT 1
SELECT COUNT(DISTINCT client.client_id) FROM     client JOIN     disp ON client.client_id = disp.client_id JOIN     account ON disp.account_id = account.account_id JOIN     district ON client.district_id = district.district_id WHERE     account.frequency = 'POPLATEK TYDNE' AND     disp.type = 'OWNER';
SELECT client.client_id FROM client JOIN disp ON client.client_id = disp.client_id JOIN card ON disp.disp_id = card.disp_id WHERE card.type = 'VYDAJ POPLATKU'
SELECT account_id FROM loan WHERE date LIKE '1997%' ORDER BY amount ASC LIMIT 1
SELECT account_id FROM loan WHERE duration > 12 AND amount = ( SELECT MAX ( amount ) FROM loan WHERE duration > 12 ) AND account.date LIKE '1993%'
SELECT COUNT(client_id) FROM client WHERE gender = 'F' AND birth_date < '1950-01-01' AND district_id = 1
SELECT DISTINCT account_id FROM trans WHERE date LIKE '1995%' ORDER BY date LIMIT 1;
SELECT account.account_id FROM account WHERE account.date < '1997-01-01' AND account.account_id IN (     SELECT account_id     FROM trans     WHERE amount > 3000 );
SELECT client.client_id FROM client JOIN disp ON client.client_id = disp.client_id JOIN card ON disp.disp_id = card.disp_id WHERE card.issued = '1994-03-03';
SELECT MIN(account.date) FROM trans JOIN account ON trans.account_id = account.account_id WHERE trans.amount = 840 AND trans.date = '1998-10-14';
SELECT district.district_id FROM loan JOIN account ON loan.account_id = account.account_id JOIN district ON account.district_id = district.district_id WHERE loan.date = '1994-08-25'
SELECT MAX(trans.amount) AS max_transaction_amount FROM trans JOIN disp ON trans.account_id = disp.account_id JOIN card ON disp.disp_id = card.disp_id WHERE card.issued = '1996-10-21'
SELECT MAX(client.gender) FROM     client JOIN     account ON client.client_id = account.account_id JOIN     district ON account.district_id = district.district_id WHERE     account.date = (         SELECT            MIN(date)         FROM             account     ) AND     district.a11 = (         SELECT            MAX(a11)         FROM             district     )
SELECT T2.amount FROM loan AS T1 INNER JOIN trans AS T2 ON T1.account_id = T2.account_id ORDER BY T1.amount DESC LIMIT 1
SELECT COUNT(T1.client_id) FROM client AS T1 INNER JOIN account AS T2 ON T1.client_id = T2.client_id INNER JOIN district AS T3 ON T3.district_id = T1.district_id WHERE T3.a2 = 'Jesenik' AND T1.gender = 'F'
SELECT disp.disp_id FROM trans JOIN disp ON trans.account_id = disp.account_id WHERE trans.amount = 5100 AND trans.date = '1998-09-02';
SELECT COUNT(account.account_id) FROM     account JOIN     district ON account.district_id = district.district_id WHERE     district.a2 = 'Litomerice'     AND strftime('%Y', account.date) = '1996';
SELECT district.a2 FROM client JOIN district ON client.district_id = district.district_id JOIN account ON client.client_id = account.account_id WHERE client.gender = 'F' AND client.birth_date = '1976-01-29';
SELECT T1.birth_date FROM client AS T1 INNER JOIN loan AS T2 ON T1.client_id = T2.account_id WHERE T2.amount = 98832 AND T2.date = '1996-01-03'
SELECT account.account_id FROM account JOIN client ON account.client_id = client.client_id JOIN district ON client.district_id = district.district_id WHERE district.a3 = 'Prague' ORDER BY account.date LIMIT 1;
SELECT CAST(SUM(CASE WHEN T1.gender = 'M' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.client_id) FROM client AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T2.a2 = 'South Bohemia' AND T2.a4 = ( SELECT MAX(a4) FROM district WHERE a2 = 'South Bohemia' )
SELECT CAST(SUM(T2.balance) - SUM(T1.balance) AS REAL) * 100 / SUM(T1.balance) FROM account AS T1 INNER JOIN trans AS T2 ON T1.account_id = T2.account_id WHERE T2.date BETWEEN '1993-03-22' AND '1998-12-27' AND T2.type = 'credit' AND T1.district_id = ( SELECT district_id FROM loan WHERE date = '1993-07-05' )
SELECT CAST(SUM(CASE WHEN status = 'A' THEN amount ELSE 0 END) AS REAL) * 100 / SUM(amount) FROM loan
SELECT CAST(SUM(CASE WHEN T2.status = 'Y' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.account_id) FROM account AS T1 INNER JOIN loan AS T2 ON T1.account_id = T2.account_id WHERE T2.amount < 100000
SELECT T1.account_id, T2.district_name, T2.district_region FROM account AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T1.date = 1993 AND T1.account_id IN ( SELECT account_id FROM trans WHERE date > ( SELECT issued FROM card WHERE disp_id = ( SELECT disp_id FROM disp WHERE client_id = ( SELECT client_id FROM client WHERE district_id = T2.district_id ) ) ) )
SELECT account.account_id, account.frequency FROM account JOIN district ON account.district_id = district.district_id WHERE district.a2 = 'east Bohemia' AND account.date >= '1995-01-01' AND account.date <= '2000-12-31';
SELECT account.account_id, account.date FROM account JOIN district ON account.district_id = district.district_id WHERE district.a2 = 'Prachatice';
SELECT district.a2, district.a3 FROM loan JOIN account ON loan.account_id = account.account_id JOIN district ON account.district_id = district.district_id WHERE loan.loan_id = '4990';
SELECT account.account_id, district.district, district.a3 AS region FROM account JOIN district ON account.district_id = district.district_id JOIN loan ON account.account_id = loan.account_id WHERE loan.amount > 300000;
SELECT loan.loan_id, district.a3 AS district, AVG(district.a11) AS average_salary FROM loan JOIN account ON loan.account_id = account.account_id JOIN district ON account.district_id = district.district_id WHERE loan.duration = 60 GROUP BY loan.loan_id, district.a3;
SELECT DISTINCT district.district_id, ((district.a13 - district.a12) / district.a12) * 100 AS unemployment_increment_percentage FROM district JOIN client ON district.district_id = client.district_id JOIN disp ON client.client_id = disp.client_id JOIN account ON disp.account_id = account.account_id JOIN loan ON account.account_id = loan.account_id WHERE loan.status = 'D';
SELECT CAST(SUM(CASE WHEN T2.a2 = 'Decin' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.account_id) FROM account AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE STRFTIME('%Y', T1.date) = '1993'
SELECT account_id FROM account WHERE frequency = 'POPLATEK MESICNE';
SELECT district.a2 AS district_name, COUNT(DISTINCT client.client_id) AS female_account_holders FROM district JOIN client ON district.district_id = client.district_id JOIN disp ON client.client_id = disp.client_id JOIN account ON disp.account_id = account.account_id WHERE client.gender = 'F' GROUP BY district.district_id ORDER BY female_account_holders DESC LIMIT 10;
SELECT T2.district_id, SUM(T1.amount) FROM trans AS T1 INNER JOIN account AS T2 ON T1.account_id = T2.account_id WHERE T1.type = 'VYDAJ' AND T1.date LIKE '1996-01%' GROUP BY T2.district_id ORDER BY SUM(T1.amount) DESC LIMIT 10
SELECT COUNT(DISTINCT client.client_id) FROM     client JOIN     district ON client.district_id = district.district_id LEFT JOIN     disp ON client.client_id = disp.client_id LEFT JOIN     card ON disp.disp_id = card.disp_id WHERE     district.a3 = 'South Bohemia'     AND card.card_id IS NULL;
SELECT district.a3 AS district_name, COUNT(loan.loan_id) AS active_loans FROM district JOIN account ON district.district_id = account.district_id JOIN loan ON account.account_id = loan.account_id WHERE loan.status = 'C' GROUP BY district.a3 ORDER BY active_loans DESC LIMIT 1;
SELECT AVG(loan.amount) AS average_loan_amount FROM loan JOIN account ON loan.account_id = account.account_id JOIN client ON account.client_id = client.client_id WHERE client.gender = 'M';
SELECT DISTINCT district.a2 AS branch_location, district.a2 AS district_name FROM district WHERE district.a13 = (     SELECT        MAX(district.a13)     FROM         district     WHERE         district.a13 IS NOT NULL )
SELECT COUNT(account.account_id) AS num_of_accounts_opened FROM     account JOIN     district ON account.district_id = district.district_id WHERE     district.a16 = (         SELECT            MAX(a16)         FROM             district     )
SELECT COUNT(T1.account_id) FROM account AS T1 INNER JOIN trans AS T2 ON T1.account_id = T2.account_id WHERE T2.operation = 'VYBER KARTOU' AND T1.frequency = 'POPLATEK MESICNE' AND T2.amount < 0
SELECT COUNT(DISTINCT loan.account_id) FROM     loan JOIN     account ON loan.account_id = account.account_id WHERE     loan.amount >= 250000     AND loan.date BETWEEN '1995-01-01' AND '1997-12-31'     AND account.frequency = 'POPLATEK MESICNE'     AND loan.status = 'A';
SELECT COUNT(DISTINCT account.account_id) FROM     account JOIN     loan ON account.account_id = loan.account_id JOIN     district ON account.district_id = district.district_id WHERE     district.district_id = 1     AND (loan.status = 'C' OR loan.status = 'D');
SELECT COUNT(client.client_id) FROM     client JOIN     district ON client.district_id = district.district_id WHERE     district.district_id = (         SELECT            district_id         FROM             (                 SELECT                    district_id,                     ROW_NUMBER() OVER (ORDER BY A15 DESC) AS row_num                 FROM                     district             ) AS ranked_districts         WHERE             row_num = 2     )     AND client.gender = 'M';
SELECT COUNT(card.card_id) FROM     card JOIN     disp ON card.disp_id = disp.disp_id WHERE     card.type = 'gold' AND disp.type = 'disponent';
SELECT COUNT(account.account_id) FROM account JOIN district ON account.district_id = district.district_id WHERE district.a2 = 'Pisek';
SELECT DISTINCT district.district_id FROM     district INNER JOIN     account ON district.district_id = account.district_id INNER JOIN     trans ON account.account_id = trans.account_id WHERE     trans.amount > 10000     AND trans.date LIKE '1997%'
SELECT account.account_id FROM account JOIN order ON account.account_id = order.account_id JOIN district ON account.district_id = district.district_id WHERE order.k_symbol = 'SIPO' AND district.a2 = 'Pisek';
SELECT account.account_id FROM account JOIN disp ON account.account_id = disp.account_id JOIN card ON disp.disp_id = card.disp_id WHERE card.type = 'gold' AND account.account_id IN (     SELECT account_id     FROM card     JOIN disp ON card.disp_id = disp.disp_id     WHERE card.type = 'junior' )
SELECT AVG(amount) AS average_credit_card_amount FROM     trans WHERE     type = 'VYBER KARTOU'     AND strftime('%Y', date) = '2021';
SELECT account_id FROM trans WHERE STRFTIME('%Y', date) = '1998' AND amount < ( SELECT AVG(amount) FROM trans WHERE STRFTIME('%Y', date) = '1998' )
SELECT client.client_id FROM client JOIN disp ON client.client_id = disp.client_id JOIN card ON disp.disp_id = card.disp_id JOIN account ON disp.account_id = account.account_id JOIN loan ON account.account_id = loan.account_id WHERE client.gender = 'F'
SELECT COUNT(T1.client_id) FROM client AS T1 INNER JOIN account AS T2 ON T1.client_id = T2.client_id INNER JOIN district AS T3 ON T2.district_id = T3.district_id WHERE T1.gender = 'F' AND T3.a3 = 'South Bohemia'
SELECT account.account_id FROM account JOIN district ON account.district_id = district.district_id JOIN disp ON account.account_id = disp.account_id JOIN client ON disp.client_id = client.client_id WHERE district.a2 = 'Tabor' AND disp.type = 'OWNER'
SELECT account.type, AVG(district.a11) AS average_income FROM account JOIN district ON account.district_id = district.district_id WHERE account.type != 'OWNER' AND district.a11 > 8000 AND district.a11 <= 9000 GROUP BY account.type;
SELECT COUNT(DISTINCT account.account_id) FROM     account JOIN     trans ON account.account_id = trans.account_id JOIN     district ON account.district_id = district.district_id WHERE     district.a3 = 'North Bohemia'     AND trans.bank = 'AB';
SELECT district.a2 FROM district JOIN account ON district.district_id = account.district_id JOIN trans ON account.account_id = trans.account_id WHERE trans.type = 'VYDAJ' GROUP BY district.a2;
SELECT AVG(district.A15) AS avg_crimes_1995 FROM district JOIN account ON account.district_id = district.district_id WHERE district.A15 > 4000 AND account.date >= '1997-01-01';
SELECT COUNT(*) FROM     card JOIN     disp ON card.disp_id = disp.disp_id JOIN     account ON disp.account_id = account.account_id WHERE     card.type = 'classic'     AND disp.type = 'OWNER'
SELECT COUNT(DISTINCT client.client_id) FROM client JOIN district ON client.district_id = district.district_id WHERE district.a2 = 'Hl.m. Praha' AND client.gender = 'M';
SELECT CAST(SUM(CASE WHEN issued < '1998-01-01' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM card WHERE type = 'Gold'
SELECT client.client_id FROM     client JOIN     disp ON client.client_id = disp.client_id JOIN     account ON disp.account_id = account.account_id JOIN     loan ON account.account_id = loan.account_id WHERE     loan.amount = (SELECT MAX(amount) FROM loan)
SELECT COUNT(district.a15) AS num_committed_crimes_1995 FROM district JOIN account ON account.district_id = district.district_id WHERE account.account_id = 532;
SELECT district.district_id FROM     account JOIN     `order` ON account.account_id = `order`.account_id WHERE     `order`.order_id = 33333;
SELECT trans.amount, trans.date FROM trans JOIN client ON trans.account_id = client.account_id WHERE client.client_id = 3356 AND trans.operation = 'VYBER';
SELECT COUNT(DISTINCT account.account_id) FROM     account JOIN     loan ON account.account_id = loan.account_id WHERE     account.frequency = 'POPLATEK TYDNE'     AND loan.amount < 200000;
SELECT T2.type FROM client AS T1 INNER JOIN card AS T2 ON T1.client_id = T2.disp_id WHERE T1.client_id = 13539
SELECT a3 AS region FROM client JOIN district ON client.district_id = district.district_id WHERE client.client_id = 3541;
SELECT district.a1 AS district_name, COUNT(loan.loan_id) AS num_loans_finished_with_no_problems FROM district JOIN account ON district.district_id = account.district_id JOIN loan ON account.account_id = loan.account_id WHERE loan.status = 'A' GROUP BY district.a1 ORDER BY num_loans_finished_with_no_problems DESC LIMIT 1;
SELECT client.client_id, client.gender, client.birth_date FROM client JOIN disp ON client.client_id = disp.client_id JOIN account ON disp.account_id = account.account_id JOIN "order" ON account.account_id = "order".account_id WHERE "order".order_id = 32423;
SELECT trans.trans_id, trans.account_id, trans.date, trans.type, trans.operation, trans.amount, trans.balance, trans.k_symbol, trans.bank, trans.account FROM trans JOIN account ON trans.account_id = account.account_id JOIN district ON account.district_id = district.district_id WHERE district.district_id = 5;
SELECT COUNT(account.account_id) FROM     account JOIN     district ON account.district_id = district.district_id WHERE     district.a2 = 'Jesenik';
SELECT client.client_id FROM client JOIN disp ON client.client_id = disp.client_id JOIN card ON disp.disp_id = card.disp_id WHERE card.type = 'junior' AND card.issued >= '1997-01-01';
SELECT CAST(SUM(CASE WHEN T1.gender = 'F' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.client_id) FROM client AS T1 INNER JOIN account AS T2 ON T1.client_id = T2.client_id INNER JOIN district AS T3 ON T1.district_id = T3.district_id WHERE T3.a11 > 10000
SELECT CAST(SUM(CASE WHEN STRFTIME('%Y', T2.date) = '1997' THEN T2.amount ELSE 0 END) - SUM(CASE WHEN STRFTIME('%Y', T2.date) = '1996' THEN T2.amount ELSE 0 END) AS REAL) * 100 / SUM(CASE WHEN STRFTIME('%Y', T2.date) = '1996' THEN T2.amount ELSE 0 END) FROM client AS T1 INNER JOIN loan AS T2 ON T1.client_id = T2.account_id WHERE T1.gender = 'M'
SELECT COUNT(*) FROM trans WHERE type = 'VYBER KARTOU' AND date > '1995-01-01';
SELECT SUM(CASE WHEN d.a2 = 'North Bohemia' THEN d.a16 ELSE 0 END) - SUM(CASE WHEN d.a2 = 'East Bohemia' THEN d.a16 ELSE 0 END) AS difference_in_crimes_1996 FROM district d JOIN account a ON d.district_id = a.district_id JOIN trans t ON a.account_id = t.account_id WHERE t.date LIKE '1996%'
SELECT COUNT(*) FROM disp JOIN account ON disp.account_id = account.account_id WHERE account_id BETWEEN 1 AND 10
SELECT COUNT(*) FROM     trans WHERE     account_id = 3     AND type = 'PRIJEM'     AND operation = 'VYBER'     AND k_symbol = 'VYBER' ;
SELECT strftime('%Y', c.birth_date) AS birth_year FROM client c JOIN disp d ON c.client_id = d.client_id JOIN account a ON d.account_id = a.account_id WHERE a.account_id = 130;
SELECT COUNT(account.account_id) FROM     account JOIN     disp ON account.account_id = disp.account_id WHERE     disp.type = 'OWNER'     AND account.frequency = 'POPLATEK PO OBRATU';
SELECT (SELECT SUM(amount) FROM loan WHERE account_id = (SELECT account_id FROM disp WHERE client_id = 992)) AS total_debt, (SELECT status FROM loan WHERE account_id = (SELECT account_id FROM disp WHERE client_id = 992)) AS payment_status;
SELECT SUM(trans.amount), client.gender FROM trans JOIN account ON trans.account_id = account.account_id JOIN disp ON account.account_id = disp.account_id JOIN client ON disp.client_id = client.client_id WHERE trans.trans_id = 851 AND client.client_id = 4;
SELECT card.type FROM card JOIN disp ON card.disp_id = disp.disp_id JOIN client ON disp.client_id = client.client_id WHERE client.client_id = 9;
SELECT SUM(T2.amount) FROM client AS T1 INNER JOIN trans AS T2 ON T1.client_id = T2.account_id WHERE T1.client_id = 617 AND STRFTIME('%Y', T2.date) = '1998'
SELECT DISTINCT client.client_id FROM client JOIN district ON client.district_id = district.district_id JOIN account ON client.client_id = account.account_id WHERE client.birth_date BETWEEN '1983-01-01' AND '1987-12-31' AND district.a2 = 'East Bohemia';
SELECT client.client_id FROM client JOIN (     SELECT    loan.account_id,     MAX(amount) AS max_loan     FROM     loan     JOIN     client ON loan.account_id = client.account_id     WHERE     client.gender = 'F'     GROUP BY     loan.account_id     ORDER BY     max_loan DESC     LIMIT 3 ) AS max_loans ON client.account_id = max_loans.account_id
SELECT COUNT(T1.client_id) FROM client AS T1 INNER JOIN trans AS T2 ON T1.client_id = T2.account_id WHERE T1.gender = 'M' AND T1.birth_date BETWEEN '1974-01-01' AND '1976-12-31' AND T2.amount > 4000
SELECT COUNT(account.account_id) FROM account JOIN district ON account.district_id = district.district_id WHERE district.a2 = 'Beroun' AND account.date > '1996-01-01';
SELECT COUNT(*) FROM     client JOIN     disp ON client.client_id = disp.client_id JOIN     card ON disp.disp_id = card.disp_id WHERE     client.gender = 'F' AND     card.type = 'junior';
SELECT CAST(SUM(IIF(T1.gender = 'F', 1, 0)) AS REAL) * 100 / COUNT(T1.client_id) FROM client AS T1 INNER JOIN account AS T2 ON T1.client_id = T2.client_id INNER JOIN district AS T3 ON T2.district_id = T3.district_id WHERE T3.a3 = 'Prague'
SELECT CAST(SUM(CASE WHEN T1.gender = 'M' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.client_id) FROM client AS T1 INNER JOIN disp AS T2 ON T1.client_id = T2.client_id INNER JOIN account AS T3 ON T2.account_id = T3.account_id WHERE T2.type = 'STAVKA' AND T2.operation = 'VYBER' AND T2.k_symbol = 'POPLATEK TYDNE'
SELECT COUNT(DISTINCT client.client_id) AS client_count FROM     client JOIN     disp ON client.client_id = disp.client_id JOIN     account ON disp.account_id = account.account_id WHERE     account.frequency = 'POPLATEK TYDNE' AND     client.gender = 'F'
SELECT account_id FROM loan WHERE duration > 24 AND amount = (     SELECT MIN(amount)     FROM loan     WHERE duration > 24 ) AND date < '1997-01-01';
SELECT account.account_id FROM     account JOIN     client ON account.client_id = client.client_id JOIN     district ON client.district_id = district.district_id WHERE     client.gender = 'F' GROUP BY     account.account_id ORDER BY     MAX(client.birth_date) ASC,     AVG(district.a11) ASC LIMIT 1;
SELECT COUNT(DISTINCT client.client_id) FROM     client     JOIN district ON client.district_id = district.district_id WHERE     client.birth_date LIKE '1920%'     AND district.a3 = 'east Bohemia';
SELECT COUNT(DISTINCT loan.account_id) AS prepayment_loan_count FROM loan JOIN account ON loan.account_id = account.account_id JOIN district ON account.district_id = district.district_id JOIN disp ON account.account_id = disp.account_id JOIN card ON disp.disp_id = card.disp_id WHERE loan.duration = 24 AND card.type = 'VISA' AND account.frequency = 'POPLATEK TYDNE';
SELECT AVG ( loan.amount ) , trans.date FROM loan join trans on loan.account_id = trans.account_id WHERE loan.status = 'C' GROUP BY trans.date
SELECT client.client_id, client.district_id FROM client WHERE NOT EXISTS (     SELECT *     FROM disp     WHERE disp.client_id = client.client_id     AND disp.type = 'OWNER'     AND disp.account_id NOT IN (         SELECT loan.account_id         FROM loan         UNION         SELECT order.account_id         FROM order         WHERE order.k_symbol = 'SIPO' -- Assuming 'SIPO' represents permanent orders     ) );
SELECT client.client_id, client.birth_date FROM client JOIN disp ON client.client_id = disp.client_id JOIN card ON disp.disp_id = card.disp_id JOIN account ON disp.account_id = account.account_id JOIN loan ON account.account_id = loan.account_id WHERE card.type = 'gold' AND loan.status = 'A'
SELECT bond_type FROM bond GROUP BY bond_type ORDER BY COUNT ( * ) DESC LIMIT 1
SELECT COUNT(DISTINCT molecule.molecule_id) AS num_non_carcinogenic_molecules_with_chlorine FROM molecule JOIN atom ON molecule.molecule_id = atom.molecule_id WHERE molecule.label = '-' AND atom.element = 'cl';
SELECT AVG ( COUNT ( * ) ) FROM ( SELECT COUNT ( * ) FROM atom WHERE element = 'O' GROUP BY molecule_id HAVING COUNT ( * ) = 1 )
SELECT AVG(single_bonded_count) FROM (     SELECT COUNT(*) AS single_bonded_count     FROM bond     JOIN molecule ON bond.molecule_id = molecule.molecule_id     WHERE bond_type = '-' AND label = '+'     GROUP BY molecule.molecule_id )
SELECT COUNT(*) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'na' AND molecule.label = '-';
SELECT molecule.molecule_id FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = '#' AND molecule.label = '+';
SELECT CAST(SUM(CASE WHEN T1.element = 'C' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.atom_id) FROM atom AS T1 INNER JOIN connected AS T2 ON T1.atom_id = T2.atom_id INNER JOIN bond AS T3 ON T2.bond_id = T3.bond_id WHERE T3.bond_type = 'double'
SELECT COUNT(*) FROM     bond WHERE     bond_type = '#'
SELECT COUNT(DISTINCT atom.atom_id) FROM atom WHERE element != 'br';
SELECT COUNT(DISTINCT molecule.molecule_id) FROM     molecule WHERE     molecule.molecule_id BETWEEN 'TR000' AND 'TR099'     AND molecule.label = '+';
SELECT molecule.molecule_id FROM molecule JOIN atom ON molecule.molecule_id = atom.molecule_id WHERE atom.element = 'si';
SELECT element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR004_8_9';
SELECT element FROM     atom INNER JOIN     connected ON atom.atom_id = connected.atom_id INNER JOIN     bond ON connected.bond_id = bond.bond_id WHERE     bond.bond_type = '='
SELECT T2.label FROM atom AS T1 INNER JOIN molecule AS T2 ON T1.molecule_id = T2.molecule_id WHERE T1.element = 'H' GROUP BY T2.label ORDER BY COUNT(T1.atom_id) DESC LIMIT 1
SELECT bond.bond_type FROM bond JOIN atom ON bond.molecule_id = atom.molecule_id JOIN connected ON bond.bond_id = connected.bond_id WHERE atom.element = 'te';
SELECT DISTINCT a1.element, a2.element FROM connected AS c JOIN atom AS a1 ON c.atom_id = a1.atom_id JOIN atom AS a2 ON c.atom_id2 = a2.atom_id JOIN bond AS b ON c.bond_id = b.bond_id WHERE b.bond_type = '-';
SELECT atom_id, atom_id2 FROM connected JOIN bond ON connected.bond_id = bond.bond_id JOIN molecule ON bond.molecule_id = molecule.molecule_id JOIN atom ON connected.atom_id = atom.atom_id JOIN atom AS atom2 ON connected.atom_id2 = atom2.atom_id WHERE molecule.label = '-'
SELECT element FROM atom WHERE molecule_id NOT IN ( SELECT molecule_id FROM molecule WHERE label = 'carcinogenic' ) GROUP BY element ORDER BY COUNT ( * ) ASC LIMIT 1
SELECT bond.bond_type FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id = atom.atom_id JOIN atom AS a2 ON connected.atom_id2 = a2.atom_id WHERE atom.element = 'TR004_8' AND a2.element = 'TR004_20';
SELECT DISTINCT label FROM molecule WHERE molecule_id IN (     SELECT molecule_id     FROM atom     WHERE element != 'sn' );
SELECT COUNT(DISTINCT atom.atom_id) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id JOIN connected ON connected.bond_id = bond.bond_id AND connected.atom_id = atom.atom_id WHERE atom.element IN ('i', 's') AND bond.bond_type = '-';
SELECT atom.atom_id FROM     atom JOIN     connected ON atom.atom_id = connected.atom_id JOIN     bond ON connected.bond_id = bond.bond_id WHERE     bond.bond_type = '#';
SELECT atom.* FROM atom JOIN connected ON atom.atom_id = connected.atom_id2 JOIN bond ON connected.bond_id = bond.bond_id JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE molecule.label = 'TR181';
SELECT CAST(SUM(CASE WHEN T2.element = 'F' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.molecule_id) FROM molecule AS T1 INNER JOIN atom AS T2 ON T1.molecule_id = T2.molecule_id WHERE T1.label = 'carcinogenic'
SELECT CAST(SUM(CASE WHEN T2.bond_type = 'triple' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.molecule_id) FROM molecule AS T1 INNER JOIN bond AS T2 ON T1.molecule_id = T2.molecule_id WHERE T1.label = 'carcinogenic'
SELECT element FROM atom WHERE molecule_id = 'TR000' ORDER BY element LIMIT 3;
SELECT atom.element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id JOIN molecule ON atom.molecule_id = molecule.molecule_id AND bond.molecule_id = molecule.molecule_id WHERE molecule.label = 'TR001' AND bond.bond_id = 'TR001_2_6';
SELECT SUM(CASE WHEN molecule.label = '+' THEN 1 ELSE 0 END) - SUM(CASE WHEN molecule.label = '-' THEN 1 ELSE 0 END) AS difference FROM molecule;
SELECT atom.atom_id FROM bond JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id = atom.atom_id WHERE bond.bond_id = 'TR_000_2_5';
SELECT connected.bond_id FROM connected JOIN atom ON connected.atom_id2 = atom.atom_id WHERE atom.molecule_id = (SELECT molecule_id FROM molecule WHERE label = 'TR000_2')
SELECT molecule.label FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = ' = ' GROUP BY molecule.label ORDER BY molecule.label LIMIT 5;
SELECT CAST(SUM(CASE WHEN T2.bond_type = '=' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.molecule_id) FROM molecule AS T1 INNER JOIN bond AS T2 ON T1.molecule_id = T2.molecule_id WHERE T1.label = 'TR008'
SELECT CAST(SUM(CASE WHEN label = 'carcinogenic' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(molecule_id) FROM molecule
SELECT CAST(SUM(CASE WHEN element = 'H' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(atom_id) FROM atom WHERE molecule_id = 'TR206'
SELECT bond.bond_type FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE molecule.label = 'TR000';
SELECT atom.element, molecule.label FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR060';
SELECT T2.bond_type, CASE WHEN T1.label = '+' THEN 'Carcinogenic' ELSE 'Non-carcinogenic' END FROM molecule AS T1 INNER JOIN bond AS T2 ON T1.molecule_id = T2.molecule_id WHERE T1.molecule_id = 'TR018' GROUP BY T2.bond_type ORDER BY COUNT(T2.bond_type) DESC LIMIT 1
SELECT molecule.label FROM molecule join bond on molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = 'single' and molecule.label != 'carcinogenic' ORDER BY molecule.label ASC LIMIT 3
SELECT bond.bond_id FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE molecule.label = 'TR006' ORDER BY bond.bond_id LIMIT 2;
SELECT COUNT(bond.bond_id) FROM     connected     JOIN bond ON connected.bond_id = bond.bond_id     JOIN atom ON connected.atom_id = atom.atom_id OR connected.atom_id2 = atom.atom_id     JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE     (atom.atom_id = 'TR009_12' OR connected.atom_id2 = 'TR009_12')     AND molecule.label = 'TR009';
SELECT COUNT(DISTINCT molecule.molecule_id) AS num_carcinogenic_bromine_molecules FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON bond.bond_id = connected.bond_id WHERE molecule.label = '+' AND atom.element = 'br';
SELECT bond.bond_type, atom.atom_id, connected.atom_id2 FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id = atom.atom_id OR connected.atom_id2 = atom.atom_id WHERE molecule.label = 'TR001_6_9';
SELECT molecule.label,  CASE      WHEN molecule.label = '+' THEN 'carcinogenic'      ELSE 'not carcinogenic'  END AS carcinogenicity FROM molecule JOIN atom ON molecule.molecule_id = atom.molecule_id WHERE atom.atom_id = 'TR001_10';
SELECT COUNT(DISTINCT molecule.molecule_id) AS triple_bond_molecules FROM     molecule JOIN     bond ON molecule.molecule_id = bond.molecule_id WHERE     bond.bond_type = '#'
SELECT COUNT(connected.bond_id) FROM connected WHERE connected.atom_id = (SELECT atom_id FROM atom WHERE atom_id = 'TR%_19');
SELECT element FROM atom WHERE molecule_id = 'TR004';
SELECT COUNT(DISTINCT molecule.molecule_id) FROM     molecule WHERE     molecule.label = '-';
SELECT DISTINCT molecule.label FROM     atom     JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE     SUBSTRING(atom.atom_id, 7, 2) BETWEEN '21' AND '25'     AND molecule.label = '+';
SELECT bond_id FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id2 = atom.atom_id WHERE element = 'p' OR element = 'n';
SELECT molecule.label FROM molecule join bond on molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = 'double' GROUP BY molecule.label ORDER BY COUNT ( * ) DESC LIMIT 1
SELECT ROUND(AVG(bond_count), 2) AS average_bonds FROM (     SELECT COUNT(b.bond_id) AS bond_count     FROM atom AS a     JOIN molecule AS m ON a.molecule_id = m.molecule_id     JOIN bond AS b ON m.molecule_id = b.molecule_id     WHERE a.element = 'i'     GROUP BY a.atom_id ) AS subquery;
SELECT bond.bond_type, bond.bond_id FROM bond JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id2 = atom.atom_id WHERE atom.atom_id = 45;
SELECT element FROM atom WHERE atom_id NOT IN (SELECT atom_id FROM connected);
SELECT atom.element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE bond.bond_type = '#' AND molecule.label = 'TR447';
SELECT element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR144_8_19';
SELECT molecule.label FROM molecule join bond on molecule.molecule_id = bond.molecule_id WHERE molecule.label = 'carcinogenic' GROUP BY molecule.label ORDER BY COUNT ( * ) DESC LIMIT 1
SELECT MIN(element) AS least_common_element FROM     atom WHERE     molecule_id IN (         SELECT            molecule_id         FROM             molecule         WHERE             label = '+'     ) GROUP BY     element ORDER BY     COUNT(*) ASC LIMIT 1;
SELECT atom2.atom_id FROM atom AS atom1 JOIN connected ON atom1.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id JOIN atom AS atom2 ON connected.atom_id2 = atom2.atom_id WHERE atom1.element = 'pb';
SELECT DISTINCT atom.element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '#';
SELECT CAST(SUM(CASE WHEN T1.element = 'C' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.atom_id) FROM atom AS T1 INNER JOIN connected AS T2 ON T1.atom_id = T2.atom_id
SELECT CAST(SUM(CASE WHEN m.label = '+' THEN 1 ELSE 0 END) AS REAL) / COUNT(b.bond_id) AS proportion FROM bond b JOIN molecule m ON b.molecule_id = m.molecule_id WHERE b.bond_type = '-';
SELECT COUNT(DISTINCT atom.atom_id) FROM     atom JOIN     molecule ON atom.molecule_id = molecule.molecule_id JOIN     bond ON bond.molecule_id = molecule.molecule_id JOIN     connected ON connected.bond_id = bond.bond_id WHERE     atom.element IN ('c', 'h');
SELECT connected.atom_id2 FROM atom JOIN connected ON atom.atom_id = connected.atom_id WHERE atom.element = 's';
SELECT bond.bond_type FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id JOIN connected ON connected.atom_id = atom.atom_id AND connected.atom_id2 = atom.atom_id AND connected.bond_id = bond.bond_id WHERE atom.element = 'sn';
SELECT COUNT(DISTINCT atom.element) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id JOIN connected ON connected.bond_id = bond.bond_id AND connected.atom_id = atom.atom_id WHERE bond.bond_type = '-';
SELECT COUNT(DISTINCT atom.atom_id) FROM     atom     JOIN connected ON atom.atom_id = connected.atom_id     JOIN bond ON connected.bond_id = bond.bond_id     JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE     (atom.element = 'p' OR atom.element = 'br')     AND bond.bond_type = '#'
SELECT bond.bond_id FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON bond.bond_id = connected.bond_id WHERE molecule.label = '+';
SELECT molecule.molecule_id FROM molecule INNER JOIN bond ON molecule.molecule_id = bond.molecule_id INNER JOIN connected ON bond.bond_id = connected.bond_id INNER JOIN atom ON connected.atom_id = atom.atom_id WHERE bond.bond_type = '-' AND molecule.label = '-';
SELECT CAST(SUM(CASE WHEN T1.element = 'Cl' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.atom_id) FROM atom AS T1 INNER JOIN connected AS T2 ON T1.atom_id = T2.atom_id INNER JOIN bond AS T3 ON T2.bond_id = T3.bond_id WHERE T3.bond_type = 'single'
SELECT molecule.label FROM molecule WHERE molecule.molecule_id IN ('TR000', 'TR001', 'TR002');
SELECT molecule.molecule_id FROM molecule WHERE molecule.label = '-';
SELECT COUNT(DISTINCT molecule.molecule_id) FROM     molecule WHERE     label = '+'     AND molecule_id BETWEEN 'TR000' AND 'TR030';
SELECT bond.bond_type FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE molecule.label BETWEEN 'TR000' AND 'TR050';
SELECT element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR001_10_11';
SELECT COUNT(DISTINCT bond.bond_id) FROM     bond JOIN     molecule ON bond.molecule_id = molecule.molecule_id JOIN     atom ON atom.molecule_id = molecule.molecule_id WHERE     atom.element = 'i';
SELECT molecule.label, COUNT(*) AS count FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE element = 'Ca' GROUP BY molecule.label;
SELECT COUNT(*) FROM connected JOIN atom ON connected.atom_id = atom.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR001_1_8' AND (atom.element = 'cl' OR atom.element = 'c');
SELECT molecule.molecule_id FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id = atom.atom_id WHERE atom.element = 'c' AND bond.bond_type = '#' AND molecule.label = '-';
SELECT CAST(SUM(CASE WHEN T1.element = 'Cl' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.atom_id) FROM atom AS T1 INNER JOIN molecule AS T2 ON T1.molecule_id = T2.molecule_id WHERE T2.label = 'carcinogenic'
SELECT element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = 'TR001' AND atom.element IN ('mercury', 'lead', 'arsenic', 'cadmium');
SELECT molecule.molecule_id FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = '=';
SELECT atom.atom_id FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id = atom.atom_id WHERE bond.bond_type = '###'
SELECT element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR005_16_26'
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = '-' AND molecule.label = '-';
SELECT molecule.label FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE bond.bond_id = 'TR001_10_11';
SELECT bond_id FROM     bond WHERE     bond_type = '#' AND     molecule_id IN (         SELECT            molecule_id         FROM             molecule         WHERE             label = '+'     );
SELECT element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id JOIN connected ON connected.bond_id = bond.bond_id AND connected.atom_id2 = atom.atom_id WHERE substr(atom.atom_id, 7, 1) = 4 AND molecule.label = '+' AND element IN ('cl', 'c', 'h', 'o', 's', 'n', 'p', 'na', 'br', 'f', 'i', 'sn', 'pb', 'te', 'ca');
SELECT CAST(SUM(CASE WHEN element = 'H' THEN 1 ELSE 0 END) AS REAL) / COUNT(atom_id) , label FROM atom WHERE molecule_id = 'TR006' GROUP BY label
SELECT molecule.label FROM molecule JOIN atom ON molecule.molecule_id = atom.molecule_id WHERE atom.element = 'ca';
SELECT DISTINCT bond_type FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id JOIN atom ON bond.molecule_id = atom.molecule_id WHERE atom.element = 'te';
SELECT element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR001_10_11'
SELECT CAST(SUM(CASE WHEN T2.bond_type = 'triple' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.molecule_id) FROM molecule AS T1 INNER JOIN bond AS T2 ON T1.molecule_id = T2.molecule_id
SELECT CAST(SUM(CASE WHEN T2.bond_type = 'double' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.molecule_id) FROM molecule AS T1 INNER JOIN bond AS T2 ON T1.molecule_id = T2.molecule_id WHERE T1.label = 'TR047'
SELECT DISTINCT label FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE atom.atom_id = 'TR001_1' AND label = '+';
SELECT label FROM molecule WHERE molecule_id = 'TR151' AND label = '+';
SELECT DISTINCT element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = 'TR151';
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule WHERE molecule.label = '+';
SELECT atom.atom_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label BETWEEN 'TR010' AND 'TR050' AND atom.element = 'c';
SELECT COUNT(atom.atom_id) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '+';
SELECT bond.bond_id FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE molecule.label = '+' AND bond.bond_type = '=';
SELECT COUNT(atom.atom_id) FROM     atom JOIN     molecule ON atom.molecule_id = molecule.molecule_id WHERE     element = 'h' AND     label = '+';
SELECT molecule_id FROM connected WHERE atom_id = ( SELECT atom_id FROM atom WHERE element = 'TR00_1' ) AND atom_id2 = ( SELECT atom_id FROM atom WHERE element = 'TR00_1' )
SELECT atom.atom_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE atom.element = 'c' AND molecule.label = '-'
SELECT CAST(SUM(CASE WHEN T2.element = 'H' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.molecule_id) FROM molecule AS T1 INNER JOIN atom AS T2 ON T1.molecule_id = T2.molecule_id WHERE T1.label = '+'
SELECT COUNT(*) FROM molecule WHERE label = '+' AND molecule_id = 'TR124';
SELECT atom.element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = 'TR186';
SELECT bond.bond_type FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id2 = atom.atom_id WHERE molecule.label = 'TR007_4_19';
SELECT element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR001_2_4';
SELECT COUNT(bond.bond_id) FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE molecule.label = 'TR006' AND bond.bond_type = '= =' AND molecule.label = '+';
SELECT molecule.label, atom.element FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '+';
SELECT bond.bond_id, bond.bond_type, connected.atom_id, connected.atom_id2 FROM bond JOIN connected ON bond.bond_id = connected.bond_id WHERE bond.bond_type = '-';
SELECT molecule.label, GROUP_CONCAT(DISTINCT atom.element) AS elements FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id2 = atom.atom_id WHERE bond.bond_type = '#' GROUP BY molecule.label;
SELECT element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR000_2_3';
SELECT COUNT(bond.bond_id) FROM     bond JOIN     molecule ON bond.molecule_id = molecule.molecule_id JOIN     connected ON bond.bond_id = connected.bond_id JOIN     atom ON connected.atom_id2 = atom.atom_id WHERE     atom.element = 'cl';
SELECT atom.atom_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = 'TR346';  SELECT COUNT(DISTINCT bond_type) FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE molecule.label = 'TR346';
SELECT COUNT ( * ) , COUNT ( * ) FROM ( SELECT molecule.molecule_id , molecule.label FROM molecule join bond on molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = 'double' GROUP BY molecule.molecule_id , molecule.label )
SELECT COUNT ( * ) FROM molecule WHERE molecule.molecule_id NOT IN ( SELECT molecule.molecule_id FROM molecule join atom on molecule.molecule_id = atom.molecule_id WHERE atom.element = 'S' ) AND molecule.molecule_id NOT IN ( SELECT molecule.molecule_id FROM molecule join bond on molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = 'double' )
SELECT molecule.label FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_id = 'TR001_2_4' AND molecule.label = '+';
SELECT COUNT(atom.atom_id) AS num_atoms FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = 'TR005';
SELECT COUNT(*) FROM     bond WHERE     bond_type = '-';
SELECT molecule.label FROM molecule JOIN atom ON molecule.molecule_id = atom.molecule_id WHERE atom.element = 'cl' AND molecule.label = '+';
SELECT DISTINCT molecule_id FROM atom WHERE element = 'c' AND molecule_id NOT IN (     SELECT DISTINCT molecule_id     FROM molecule     WHERE label = '-' );
SELECT CAST(SUM(CASE WHEN T2.element = 'Cl' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.molecule_id) FROM molecule AS T1 INNER JOIN atom AS T2 ON T1.molecule_id = T2.molecule_id WHERE T1.label = 'carcinogenic'
SELECT molecule.molecule_id FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_id = 'TR001_1_7';
SELECT COUNT(DISTINCT element) FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR001_3_4';
SELECT bond.bond_type FROM bond JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id = atom.atom_id JOIN atom AS atom2 ON connected.atom_id2 = atom2.atom_id WHERE atom.element = 'TR000_1' AND atom2.element = 'TR000_2';
SELECT molecule.label FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.atom_id = 'TR000_2' INTERSECT SELECT molecule.label FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.atom_id = 'TR000_4';
SELECT element FROM atom WHERE atom_id = 'TR000_1';
SELECT m.label FROM molecule m WHERE m.molecule_id = 'TR000';
SELECT CAST(SUM(CASE WHEN bond_type = 'single' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(bond_id) FROM bond
SELECT COUNT(DISTINCT molecule.molecule_id) FROM     molecule JOIN     atom ON molecule.molecule_id = atom.molecule_id JOIN     connected ON atom.atom_id = connected.atom_id JOIN     bond ON connected.bond_id = bond.bond_id WHERE     element = 'n'     AND label = '+';
SELECT molecule.label FROM molecule JOIN atom ON molecule.molecule_id = atom.molecule_id JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE atom.element = 'S' AND bond.bond_type = '=';
SELECT molecule.label FROM molecule join atom on molecule.molecule_id = atom.molecule_id WHERE atom.atom_id > 5
SELECT DISTINCT atom.element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id JOIN connected ON connected.bond_id = bond.bond_id WHERE molecule.label = 'TR024' AND bond.bond_type = '=';
SELECT molecule.label FROM molecule join atom on molecule.molecule_id = atom.molecule_id WHERE molecule.label = 'carcinogenic' GROUP BY molecule.molecule_id ORDER BY COUNT ( * ) DESC LIMIT 1
SELECT CAST(SUM(CASE WHEN T2.bond_type = 'triple' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.molecule_id) FROM molecule AS T1 INNER JOIN bond AS T2 ON T1.molecule_id = T2.molecule_id WHERE T1.label = 'carcinogenic'
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule WHERE molecule.label = '+';
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE molecule.label BETWEEN 'TR004' AND 'TR010' AND bond.bond_type = '-';
SELECT COUNT(atom.atom_id) FROM     atom JOIN     molecule ON atom.molecule_id = molecule.molecule_id WHERE     molecule.label = 'TR008'     AND atom.element = 'c';
SELECT element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.atom_id = 'TR004_7' AND molecule.label = '-'
SELECT COUNT(DISTINCT molecule.molecule_id) FROM     atom     JOIN molecule ON atom.molecule_id = molecule.molecule_id     JOIN connected ON atom.atom_id = connected.atom_id     JOIN bond ON connected.bond_id = bond.bond_id WHERE     atom.element = 'o'     AND bond.bond_type = ' = ';
SELECT COUNT(DISTINCT molecule.molecule_id) FROM     molecule JOIN     bond ON molecule.molecule_id = bond.molecule_id WHERE     bond.bond_type = '#' AND     molecule.label = '-'
SELECT element, bond_type FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE molecule.label = 'TR016';
SELECT atom.atom_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id JOIN connected ON connected.bond_id = bond.bond_id AND connected.atom_id = atom.atom_id WHERE molecule.label = 'TR012' AND atom.element = 'c' AND bond.bond_type = ' = ';
SELECT atom.atom_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '+' AND atom.element = 'o';
SELECT cards.id, cards.name FROM cards WHERE cards.cardkingdomfoilid = cards.cardkingdomid AND cards.cardkingdomid IS NOT NULL;
SELECT cards.name FROM cards WHERE cards.bordercolor = 'borderless' AND cards.cardkingdomfoilid IS NULL AND cards.cardkingdomid IS NULL
SELECT cards.name FROM cards WHERE cards.convertedmanacost > cards.faceconvertedmanacost;
SELECT cards.name FROM cards WHERE cards.frameversion = 2015 AND cards.edhrecrank < 100;
SELECT cards.name FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.rarity = 'mythic' AND legalities.format = 'gladiator' AND legalities.status = 'Banned';
SELECT legalities.status FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.types = 'Artifact' AND cards.side IS NULL AND legalities.format = 'vintage';
SELECT cards.id, cards.artist FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE (cards.power = '*' OR cards.power IS NULL) AND legalities.format = 'commander' AND legalities.status = 'Legal';
SELECT T1.text FROM rulings AS T1 INNER JOIN cards AS T2 ON T1.uuid = T2.uuid WHERE T2.artist = 'Stephen Daniel'
SELECT rulings.text FROM cards INNER JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.name = 'Sublime Epiphany' AND cards.number = '74s';
SELECT T1.name, T1.artist, CASE WHEN T1.isPromo = 1 THEN 'Yes' ELSE 'No' END FROM cards AS T1 INNER JOIN rulings AS T2 ON T1.uuid = T2.uuid GROUP BY T1.name ORDER BY COUNT(T2.uuid) DESC LIMIT 1
SELECT language FROM foreign_data WHERE name = 'Annul' AND multiverseid = 29
SELECT cards.name FROM cards INNER JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.language = 'Japanese';
SELECT CAST(SUM(CASE WHEN T2.language = 'Chinese Simplified' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM cards AS T1 INNER JOIN set_translations AS T2 ON T1.uuid = T2.setcode WHERE T1.availability = 'normal'
SELECT sets.name, sets.totalsetsize AS total_cards_per_set FROM sets INNER JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.language = 'Italian';
SELECT COUNT(DISTINCT cards.type) AS card_types FROM cards WHERE cards.artist = 'Aaron Boyd';
SELECT keywords FROM cards WHERE name = 'Angel of Mercy';
SELECT COUNT(*) FROM cards WHERE power = '*';
SELECT promoTypes FROM cards WHERE name = 'Duress';
SELECT bordercolor FROM cards WHERE name = 'Ancestor''s Chosen'
SELECT Type FROM cards WHERE Name = 'Ancestor''s Chosen'
SELECT T2.language FROM cards AS T1 INNER JOIN set_translations AS T2 ON T1.setcode = T2.setcode WHERE T1.name = 'Angel of Mercy'
SELECT COUNT(DISTINCT cards.id) FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE legalities.status = 'restricted' AND cards.istextless = 0;
SELECT rulings.text FROM rulings JOIN cards ON rulings.uuid = cards.uuid WHERE cards.name = "Condemn";
SELECT COUNT(cards.id) FROM     cards JOIN     legalities ON cards.uuid = legalities.uuid WHERE     legalities.status = 'restricted'     AND cards.isStarter = 1;
SELECT status FROM legalities WHERE name = 'Cloudchaser Eagle'
SELECT type FROM cards WHERE name = 'Benalish Knight';
SELECT rulings.text FROM rulings join cards on rulings.uuid = cards.uuid WHERE cards.name = 'Benalish Knight'
SELECT artist FROM cards WHERE flavorname LIKE '%Phyrexian%';
SELECT CAST(SUM(CASE WHEN bordercolor = 'borderless' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(id) FROM cards
SELECT COUNT(cards.id) FROM   cards JOIN   foreign_data ON cards.uuid = foreign_data.uuid WHERE   foreign_data.language = 'German'   AND cards.isreprint = 1;
SELECT COUNT(cards.id) AS borderless_russian_cards FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.bordercolor = 'borderless' AND foreign_data.language = 'Russian';
SELECT CAST(SUM(CASE WHEN T2.language = 'French' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM cards AS T1 INNER JOIN foreign_data AS T2 ON T1.uuid = T2.uuid WHERE T1.isStorySpotlight = 1
SELECT COUNT(*) FROM cards WHERE toughness = 99;
SELECT cards.name FROM cards WHERE cards.artist = 'Aaron Boyd';
SELECT COUNT(*) FROM cards WHERE bordercolor = 'black' AND availability = 'mtgo';
SELECT cards.id FROM cards WHERE cards.convertedmanacost = 0;
SELECT cards.layout FROM cards WHERE cards.keywords LIKE '%flying%';
SELECT COUNT(DISTINCT cards.id) FROM cards WHERE cards.originaltype = "Summon - Angel" AND cards.subtypes NOT LIKE "%Angel%";
SELECT cards.id FROM cards WHERE cards.cardkingdomfoilid IS NOT NULL AND cards.cardkingdomid IS NOT NULL;
SELECT cards.id FROM cards WHERE cards.dueldeck = 'a';
SELECT edhrecrank FROM cards WHERE frameversion = 2015;
SELECT cards.artist FROM cards INNER JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.language = 'Chinese Simplified';
SELECT cards.name FROM cards INNER JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.availability = 'paper' AND foreign_data.language = 'Japanese';
SELECT COUNT(cards.id) FROM     cards JOIN     legalities ON cards.uuid = legalities.uuid WHERE     legalities.status = 'Banned' AND     cards.bordercolor = 'white';
SELECT cards.uuid FROM cards JOIN legalities ON cards.uuid = legalities.uuid JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE legalities.format = 'legacy';
SELECT rulings.text FROM rulings JOIN cards ON rulings.uuid = cards.uuid WHERE cards.name = 'Beacon of Immortality';
SELECT COUNT(cards.id) AS future_frame_cards_count, legalities.status AS legality_status FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.frameversion = 'future';
SELECT cards.name, cards.colors FROM cards JOIN sets ON cards.setcode = sets.code WHERE sets.code = 'OGW';
SELECT cards.name, set_translations.language FROM cards JOIN set_translations ON cards.setcode = set_translations.setcode WHERE cards.setcode = '10E' AND cards.convertedmanacost = 5;
SELECT cards.name, rulings.date FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.originaltype = 'Creature - Elf';
SELECT cards.colors, legalities.format FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.id BETWEEN 1 AND 20;
SELECT T1.name FROM cards AS T1 INNER JOIN set_translations AS T2 ON T1.uuid = T2.setcode WHERE T1.colors = 'B' AND T1.type = 'artifact' AND T2.language = 'foreign'
SELECT cards.name FROM cards INNER JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.rarity = 'uncommon' ORDER BY rulings.date ASC LIMIT 3;
SELECT COUNT(DISTINCT cards.id) FROM     cards WHERE     cards.artist = 'John Avon'     AND cards.hasfoil = 1     AND cards.cardkingdomfoilid IS NULL     AND cards.cardkingdomid IS NULL;
SELECT COUNT(*) FROM     cards WHERE     bordercolor = 'white'     AND cardkingdomfoilid = cardkingdomid     AND cardkingdomid IS NOT NULL
SELECT COUNT(cards.id) FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE artist = 'UDON' AND availability = 'mtgo' AND hand = -1;
SELECT COUNT(*) FROM cards WHERE frameversion = '1993' AND availability = 'paper' AND hascontentwarning = 1;
SELECT `manacost` FROM     cards WHERE     layout = 'normal'     AND frameversion = 2003     AND bordercolor = 'black'     AND availability IN ('paper', 'mtgo');
SELECT SUM(T1.convertedManaCost) FROM cards AS T1 INNER JOIN set_translations AS T2 ON T1.setCode = T2.setCode WHERE T2.language = 'en' AND T2.setCode = 'M19' AND T1.artist = 'Rob Alexander'
SELECT DISTINCT types FROM cards WHERE availability = 'arena';
SELECT sets.code FROM set_translations JOIN sets ON set_translations.setcode = sets.code WHERE set_translations.language = 'Spanish';
SELECT CAST(SUM(CASE WHEN Hand = '+3' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM cards WHERE FrameEffects = 'Legendary'
SELECT CAST(SUM(CASE WHEN T1.Text = '' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.Name) FROM cards AS T1 INNER JOIN legalities AS T2 ON T1.UUID = T2.UUID WHERE T2.Format = 'Story Spotlight'
SELECT CAST(COUNT(T1.name) AS REAL) * 100 / COUNT(T2.name) FROM cards AS T1 INNER JOIN foreign_data AS T2 ON T1.uuid = T2.uuid WHERE T2.language = 'Spanish'
SELECT language FROM     set_translations WHERE     setcode = (SELECT code FROM sets WHERE basesetsize = 309);
SELECT COUNT(DISTINCT sets.setcode) AS translated_sets_count FROM     sets JOIN     set_translations ON sets.code = set_translations.setcode WHERE     sets.block = 'Commander' AND     set_translations.language = 'Portuguese (Brasil)';
SELECT cards.id FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.types LIKE '%Creature%' AND legalities.status = 'legal';
SELECT DISTINCT types FROM cards WHERE types IS NOT NULL AND subtypes IS NOT NULL AND supertypes IS NOT NULL;
SELECT COUNT(*) FROM cards WHERE power IS NULL AND text LIKE '%triggered ability%';
SELECT COUNT(cards.id) AS num_cards FROM cards JOIN legalities ON cards.uuid = legalities.uuid JOIN rulings ON cards.uuid = rulings.uuid WHERE legalities.format = 'pre-modern' AND rulings.text = 'This is a triggered mana ability' AND cards.side IS NULL;
SELECT cards.id FROM cards INNER JOIN foreign_data ON cards.uuid = foreign_data.uuid INNER JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.artist = 'Erica Yang' AND legalities.format = 'pauper' AND cards.availability = 'paper';
SELECT artist FROM cards WHERE text = "Das perfekte Gegenmittel zu einer dichten Formation";
SELECT foreign_data.name FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid JOIN sets ON cards.setcode = sets.code WHERE cards.type = 'Creature' AND cards.layout = 'normal' AND cards.bordercolor = 'black' AND cards.artist = 'Matthew D. Wilson' AND foreign_data.language = 'French';
SELECT COUNT(cards.id) FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.rarity = 'rare' AND rulings.date = '2009-01-10';
SELECT T2.language FROM sets AS T1 INNER JOIN set_translations AS T2 ON T1.code = T2.setcode WHERE T1.block = 'Ravnica' AND T1.basesetsize = 180
SELECT CAST(SUM(CASE WHEN T2.hasContentWarning = 0 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM legalities AS T1 INNER JOIN cards AS T2 ON T1.uuid = T2.uuid WHERE T1.format = 'commander' AND T1.status = 'legal'
SELECT CAST(SUM(CASE WHEN T2.language = 'French' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.uuid) FROM cards AS T1 INNER JOIN foreign_data AS T2 ON T1.uuid = T2.uuid WHERE T1.power = 0
SELECT CAST(SUM(CASE WHEN T2.block = 'Expansion' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.setcode) FROM set_translations AS T1 INNER JOIN sets AS T2 ON T1.setcode = T2.code WHERE T1.language = 'Japanese'
SELECT availability FROM cards WHERE artist = 'Daren Bader';
SELECT COUNT(*) FROM cards WHERE bordercolor = 'borderless' AND edhrecrank > 12000
SELECT COUNT(*) FROM cards WHERE isoversized = 1 OR isreprint = 1 OR ispromo = 1;
SELECT cards.name FROM cards WHERE (cards.power IS NULL OR cards.power = '*') AND cards.promoTypes LIKE '%arenaleague%' ORDER BY cards.name LIMIT 3;
SELECT language FROM   foreign_data WHERE   multiverseid = 149934;
SELECT cardkingdomfoilid, cardkingdomid FROM cards ORDER BY cardkingdomfoilid ASC LIMIT 3
SELECT CAST(SUM(CASE WHEN layout = 'normal' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(name) FROM cards
SELECT cards.number FROM cards WHERE cards.side IS NULL AND cards.subtypes LIKE '%Angel%' AND cards.subtypes LIKE '%Wizard%'
SELECT sets.name FROM sets WHERE sets.isonlineonly = 0 AND (sets.mtgoCode IS NULL OR sets.mtgoCode = '') ORDER BY sets.name LIMIT 3;
SELECT `language` FROM   set_translations JOIN   sets ON set_translations.setcode = sets.code WHERE   sets.code = 'ARC' AND sets.name = 'Archenemy';
SELECT sets.name AS set_name, set_translations.translation AS set_translation FROM sets INNER JOIN set_translations ON sets.code = set_translations.setcode WHERE sets.id = 5;
SELECT language, type FROM     sets JOIN     set_translations ON sets.code = set_translations.setcode WHERE     sets.id = 206;
SELECT sets.name AS set_name, sets.id AS set_id FROM sets JOIN set_translations ON sets.code = set_translations.setcode JOIN cards ON cards.setcode = sets.code JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.language = 'Italian' AND sets.block = 'Shadowmoor' ORDER BY sets.name ASC LIMIT 2;
SELECT sets.id FROM sets JOIN cards ON sets.code = cards.setcode JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE sets.isforeignonly = 1 AND sets.isfoilonly = 1 AND foreign_data.language = 'Japanese';
SELECT sets.name FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.language = 'Russian' ORDER BY sets.basesetsize DESC LIMIT 1;
SELECT CAST(SUM(CASE WHEN T2.language = 'Chinese Simplified' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM cards AS T1 INNER JOIN foreign_data AS T2 ON T1.uuid = T2.uuid WHERE T1.isOnlineOnly = 1
SELECT COUNT(DISTINCT sets.id) AS sets_count FROM     sets JOIN     set_translations ON sets.code = set_translations.setcode LEFT JOIN     cards ON cards.setcode = sets.code WHERE     set_translations.language = 'Japanese'     AND (sets.isonlineonly = 0 OR sets.mtgocode IS NULL OR sets.mtgocode = '');
SELECT COUNT ( * ) , id FROM cards WHERE bordercolor = 'black' GROUP BY id
SELECT COUNT(id) FROM cards WHERE frameeffects = 'extendedart'
SELECT cards.name FROM cards WHERE cards.bordercolor = 'black' AND cards.isfullart = 1;
SELECT sets.id, set_translations.language FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE sets.id = 174;
SELECT sets.name FROM sets WHERE sets.code = "ALL";
SELECT language FROM foreign_data JOIN cards ON foreign_data.uuid = cards.uuid WHERE cards.name = 'A Pedra Fellwar';
SELECT sets.code FROM sets WHERE sets.releasedate = '2007-07-13';
SELECT sets.basesetsize, sets.code FROM sets WHERE sets.block = 'Masques' OR sets.block = 'Mirage';
SELECT sets.code FROM sets WHERE sets.type = 'expansion';
SELECT foreign_data.name AS foreign_name, cards.type AS card_type FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid JOIN sets ON cards.setcode = sets.code WHERE cards.watermark = 'Boros';
SELECT foreign_data.language, foreign_data.flavortext, cards.types FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.watermark = 'colorpie';
SELECT CAST(COUNT(CASE WHEN T1.convertedManaCost = 10 THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T1.name) FROM cards AS T1 INNER JOIN set_translations AS T2 ON T1.setCode = T2.setcode WHERE T2.setcode = 'AbyssalHorror'
SELECT sets.code FROM sets WHERE sets.type LIKE '%expansion commander%';
SELECT foreign_data.name, cards.types FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid JOIN sets ON cards.setcode = sets.code WHERE cards.watermark = 'abzan';
SELECT foreign_data.language, cards.type FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.watermark = 'Azorius';
SELECT COUNT(*) AS powerful_cards_count FROM cards WHERE artist = 'Aaron Miller' AND cardkingdomfoilid = cardkingdomid AND cardkingdomid IS NOT NULL;
SELECT COUNT(*) FROM cards WHERE availability LIKE '%paper%' AND hand LIKE '+%';
SELECT name FROM cards WHERE istextless = 0;
SELECT `convertedmanacost` FROM     cards WHERE     name = 'Ancestor`s Chosen';
SELECT COUNT(*) FROM cards WHERE bordercolor = 'white' AND (power = '*' OR power IS NULL);
SELECT cards.name FROM cards WHERE cards.ispromo = 1 AND cards.side IS NOT NULL;
SELECT `types` FROM     cards WHERE     name = 'Molimo, Maro-Sorcerer';
SELECT purchaseUrls FROM cards WHERE promotypes = 'bundle';
SELECT COUNT(DISTINCT cards.artist) FROM     cards WHERE     cards.bordercolor = 'black'     AND cards.availability LIKE '%arena,mtgo%';
SELECT MAX(convertedManaCost) AS max_converted_mana_cost FROM     cards WHERE     name IN ('Serra Angel', 'Shrine Keeper');
SELECT cards.artist FROM cards WHERE cards.flavorname = 'Battra, Dark Destroyer';
SELECT cards.name FROM cards WHERE cards.frameversion = '2003' ORDER BY cards.convertedmanacost DESC LIMIT 3;
SELECT T2.setCode FROM cards AS T1 INNER JOIN set_translations AS T2 ON T1.uuid = T2.setCode WHERE T1.name = 'Ancestor''s Chosen' AND T2.language = 'Italian'
SELECT COUNT(set_translations.translation) AS translation_count FROM     cards JOIN     set_translations ON cards.setcode = set_translations.setcode WHERE     cards.name = 'Angel of Mercy';
SELECT cards.name FROM cards JOIN set_translations ON cards.setcode = set_translations.setcode JOIN sets ON cards.setcode = sets.code WHERE set_translations.translation = 'Hauptset Zehnte Edition';
SELECT CASE     WHEN EXISTS (         SELECT 1         FROM cards         INNER JOIN foreign_data ON cards.uuid = foreign_data.uuid         WHERE cards.name = 'Ancestor''s Chosen'         AND foreign_data.language = 'Korean'     )     THEN 'Yes'     ELSE 'No' END AS Korean_Version_Available;
SELECT COUNT(*) FROM     cards JOIN     set_translations ON cards.setcode = set_translations.setcode JOIN     foreign_data ON cards.uuid = foreign_data.uuid WHERE     set_translations.translation = 'Hauptset Zehnte Edition'     AND cards.artist = 'Adam Rex';
SELECT COUNT(cards.id) AS num_cards FROM cards JOIN sets ON cards.setcode = sets.code JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.translation = 'Hauptset Zehnte Edition'
SELECT set_translations.translation FROM set_translations JOIN sets ON set_translations.setcode = sets.code WHERE sets.name = 'Eighth Edition' AND set_translations.language = 'Simplified Chinese';
SELECT T2.IsOnlineOnly FROM cards AS T1 INNER JOIN sets AS T2 ON T1.SetCode = T2.Code WHERE T1.Name = 'Angel of Mercy'
SELECT sets.releasedate FROM sets JOIN set_translations ON sets.code = set_translations.setcode JOIN cards ON set_translations.id = cards.setcode WHERE cards.name = 'Ancestor''s Chosen';
SELECT sets.type FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.translation = 'Hauptset Zehnte Edition';
SELECT COUNT(*)  FROM sets  JOIN set_translations ON sets.code = set_translations.setcode  WHERE block = 'Ice Age' AND language = 'Italian';
SELECT T2.IsForeignOnly FROM cards AS T1 INNER JOIN sets AS T2 ON T1.SetCode = T2.Code WHERE T1.Name = 'Adarkar Valkyrie'
SELECT COUNT(DISTINCT sets.id) FROM sets INNER JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.language = 'Italian' AND sets.basesetsize < 10;
SELECT COUNT(*) FROM     cards JOIN     sets ON cards.setcode = sets.code WHERE     sets.name = 'Coldsnap' AND     cards.bordercolor = 'black';
SELECT cards.name FROM cards JOIN sets ON cards.setcode = sets.code WHERE sets.name = 'Coldsnap' AND cards.convertedmanacost = (     SELECT MAX(convertedmanacost)     FROM cards     JOIN sets ON cards.setcode = sets.code     WHERE sets.name = 'Coldsnap' )
SELECT artist FROM cards INNER JOIN sets ON cards.setcode = sets.code WHERE sets.name = 'Coldsnap' AND artist IN ('Jeremy Jarvis', 'Aaron Miller', 'Chippy');
SELECT number FROM cards WHERE setcode = (     SELECT        code     FROM         sets     WHERE         name = 'Coldsnap' ) AND number = 4;
SELECT COUNT(*) FROM     cards WHERE     cards.setcode = (SELECT code FROM sets WHERE name = 'Coldsnap')     AND cards.convertedmanacost > 5     AND (cards.power = '*' OR cards.power IS NULL)
SELECT foreign_data.flavortext FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.name = 'Ancestor''s Chosen' AND foreign_data.language = 'Italian';
SELECT foreign_data.language FROM   cards JOIN   foreign_data ON cards.uuid = foreign_data.uuid WHERE   cards.name = 'Ancestor''s Chosen'   AND foreign_data.flavortext IS NOT NULL;
SELECT sets.name AS set_name, cards.type AS english_type, foreign_data.type AS german_type FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid JOIN sets ON cards.setcode = sets.code WHERE cards.name = 'Ancestor''s Chosen' AND foreign_data.language = 'German';
SELECT T2.Text FROM sets AS T1 INNER JOIN rulings AS T2 ON T1.Code = T2.SetCode WHERE T1.Name = 'Coldsnap' AND T2.Language = 'Italian'
SELECT cards.name FROM cards JOIN sets ON cards.setcode = sets.code JOIN set_translations ON sets.code = set_translations.setcode WHERE sets.name = 'Coldsnap' AND set_translations.language = 'Italian' ORDER BY cards.convertedmanacost DESC LIMIT 1;
SELECT rulings.date FROM rulings JOIN cards ON rulings.uuid = cards.uuid WHERE cards.name = 'Reminisce';
SELECT CAST(SUM(CASE WHEN T2.convertedManaCost = 7 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM sets AS T1 INNER JOIN cards AS T2 ON T1.code = T2.setCode WHERE T1.name = 'Coldsnap'
SELECT CAST(SUM(CASE WHEN T2.name = 'Coldsnap' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM cards AS T1 INNER JOIN sets AS T2 ON T1.setcode = T2.code WHERE T1.type = 'creature' AND T1.power > 10 AND T1.toughness > 10
SELECT sets.code FROM sets WHERE sets.releasedate = '2017-07-14';
SELECT `sets.keyrunecode`   FROM   `sets`   WHERE   `sets.code` = 'PKHC';
SELECT sets.mcmid FROM sets WHERE sets.code = 'SS2';
SELECT sets.mcmname FROM sets WHERE sets.releasedate = '2017-06-09';
SELECT `sets.type` FROM sets WHERE sets.name = "From the Vault: Lore";
SELECT sets.parentcode FROM sets WHERE sets.name = 'Commander 2014 Oversized';
SELECT cards.text AS card_text, rulings.text AS ruling_text, CASE     WHEN cards.hascontentwarning = 1 THEN 'Missing or degraded properties and values'     ELSE 'No missing or degraded properties and values' END AS property_status FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.artist = 'Jim Pavelec';
SELECT sets.releasedate FROM sets JOIN cards ON sets.code = cards.setcode WHERE cards.name = 'Evacuation';
SELECT COUNT(cards.id) FROM sets JOIN set_translations ON sets.code = set_translations.setcode JOIN cards ON sets.code = cards.setcode WHERE set_translations.translation = 'Rinascita di Alara';
SELECT `sets.type` FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.translation = 'Huitième édition';
SELECT T2.setcode FROM cards AS T1 INNER JOIN set_translations AS T2 ON T1.setcode = T2.setcode WHERE T1.name = 'Tendo Ice Bridge' AND T2.language = 'French'
SELECT COUNT(set_translations.translation) AS translation_count FROM set_translations JOIN sets ON set_translations.setcode = sets.code WHERE sets.name = 'Salvat 2011';
SELECT set_translations.translation FROM     set_translations     JOIN sets ON set_translations.setcode = sets.code     JOIN cards ON cards.setcode = sets.code WHERE     cards.name = 'Fellwar Stone'     AND set_translations.language = 'Japanese';
SELECT MAX(cards.name) FROM cards JOIN sets ON cards.setcode = sets.code WHERE sets.name = 'Journey into Nyx Hero''s Path' AND cards.convertedmanacost = (     SELECT        MAX(convertedmanacost)     FROM         cards     JOIN sets ON cards.setcode = sets.code     WHERE         sets.name = 'Journey into Nyx Hero''s Path' )
SELECT releasedate FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.translation = 'Ola de frío';
SELECT sets.type FROM cards JOIN sets ON cards.setcode = sets.code WHERE cards.name = 'Samite Pilgrim';
SELECT COUNT(cards.id) FROM cards JOIN sets ON cards.setcode = sets.code WHERE sets.name = 'World Championship Decks 2004' AND cards.convertedmanacost = 3;
SELECT set_translations.translation FROM set_translations JOIN sets ON set_translations.setcode = sets.code WHERE sets.name = 'Mirrodin' AND set_translations.language = 'Chinese Simplified';
SELECT CAST(SUM(CASE WHEN T1.isNonFoilOnly = 1 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM cards AS T1 INNER JOIN set_translations AS T2 ON T1.setCode = T2.setcode WHERE T2.language = 'Japanese'
SELECT CAST(SUM(CASE WHEN T1.isOnlineOnly = 1 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM cards AS T1 INNER JOIN set_translations AS T2 ON T1.setcode = T2.setcode WHERE T2.language = 'Portuguese (Brazil)'
SELECT DISTINCT availability FROM cards WHERE artist != 'Aleksi Briclot' AND istextless = 1
SELECT MAX(sets.id) AS set_id FROM sets WHERE sets.basesetsize = (     SELECT MAX(sets.basesetsize)     FROM sets )
SELECT cards.artist FROM cards WHERE cards.side IS NULL ORDER BY cards.convertedmanacost DESC LIMIT 1;
SELECT MAX(frameeffects) AS most_common_visual_frame_effects FROM cards WHERE cardkingdomfoilid IS NOT NULL AND cardkingdomid IS NOT NULL;
SELECT COUNT(*) FROM cards WHERE (power IS NULL OR power = '*')  AND hasFoil = 0 AND duelDeck = 'A';
SELECT MAX(sets.id) AS set_id FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE sets.type = 'Commander'
SELECT name FROM cards WHERE convertedmanacost > 10 ORDER BY convertedmanacost DESC LIMIT 10
SELECT MIN(c.originalreleasedate) AS oldest_release_date,     l.format AS legal_play_format FROM     cards c JOIN     legalities l ON c.uuid = l.uuid WHERE     c.rarity = 'mythic'     AND l.status = 'legal';
SELECT COUNT(cards.id) AS num_cards FROM     cards JOIN     foreign_data ON cards.uuid = foreign_data.uuid WHERE     cards.artist = 'Volkan Baga'     AND foreign_data.language = 'French';
SELECT COUNT(*) FROM cards WHERE rarity = 'rare' AND types LIKE '%Enchantment%' AND name = 'Abundance' AND id IN (     SELECT cards.id     FROM cards     JOIN legalities ON cards.uuid = legalities.uuid     WHERE legalities.format = 'Legal' );
SELECT legalities.format, cards.name FROM legalities JOIN cards ON legalities.uuid = cards.uuid WHERE legalities.status = 'banned' GROUP BY legalities.format ORDER BY COUNT(*) DESC LIMIT 1;
SELECT language FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE sets.name = 'Battlebond';
SELECT T2.illustrator, T1.format FROM legalities AS T1 INNER JOIN cards AS T2 ON T1.uuid = T2.uuid GROUP BY T2.illustrator ORDER BY COUNT(T2.illustrator) LIMIT 1
SELECT status FROM cards JOIN legalities ON cards.uuid = legalities.uuid JOIN sets ON cards.setcode = sets.code JOIN set_translations ON sets.code = set_translations.setcode WHERE frameversion = '1997' AND artist = 'D. Alexander Gregory' AND (hascontentwarning = 1 OR set_translations.translation = 'Wizards of the Coast') AND legalities.format = 'legacy';
SELECT cards.name, legalities.format AS banned_play_format FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.edhrecrank = 1 AND legalities.status = 'banned';
SELECT AVG(totalsetsize) AS annual_average_sets, MAX(COUNT(language)) AS common_language FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE releasedate BETWEEN '2012-01-01' AND '2015-12-31';
SELECT cards.artist FROM cards WHERE cards.bordercolor = 'black' AND cards.availability = 'arena';
SELECT cards.uuid FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE legalities.format = 'oldschool' AND (legalities.status = 'banned' OR legalities.status = 'restricted');
SELECT COUNT(*) FROM cards WHERE artist = 'Matthew D. Wilson' AND availability = 'paper';
SELECT rulings.text FROM   rulings JOIN   cards ON rulings.uuid = cards.uuid WHERE   cards.artist = 'Kev Walker' ORDER BY   rulings.date DESC;
SELECT cards.name FROM cards JOIN sets ON cards.setcode = sets.code JOIN legalities ON cards.uuid = legalities.uuid WHERE sets.name = 'Hour of Devastation' AND legalities.status = 'legal';
SELECT sets.name FROM sets LEFT JOIN set_translations ON sets.code = set_translations.setcode WHERE (set_translations.language != 'Japanese' OR set_translations.language IS NULL) AND set_translations.language = 'Korean';
SELECT frameversion, name FROM cards WHERE artist = 'Allen Williams';  SELECT name FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE status = 'banned';
SELECT MAX(reputation) AS max_reputation FROM users WHERE displayname = 'Harlan' OR displayname = 'Jarrod Dixon';
SELECT users.displayname FROM users WHERE strftime('%Y', CreationDate) = '2014';
SELECT COUNT(DISTINCT users.id) FROM     users WHERE     LastAccessDate > '2014-09-01 00:00:00';
SELECT users.displayname FROM users INNER JOIN posts ON users.id = posts.owneruserid WHERE posts.viewcount = (SELECT MAX(viewcount) FROM posts)
SELECT COUNT(DISTINCT users.id) FROM users WHERE users.upvotes > 100 AND users.downvotes > 1;
SELECT COUNT(DISTINCT users.id) FROM     users JOIN     posts ON users.id = posts.owneruserid WHERE     users.creationdate > '2013-01-01'     AND posts.viewcount > 10;
SELECT COUNT(*) AS post_count FROM     posts JOIN     users ON posts.owneruserid = users.id WHERE     users.displayname = 'csgillespie';
SELECT posts.title FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'csgillespie';
SELECT users.displayname FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.title = "Eliciting priors from experts";
SELECT     posts.title FROM     posts JOIN     users ON posts.owneruserid = users.id WHERE     users.displayname = 'csgillespie' ORDER BY     posts.viewcount DESC LIMIT 1;
SELECT T1.DisplayName FROM Users AS T1 INNER JOIN Posts AS T2 ON T1.Id = T2.OwnerUserId ORDER BY T2.FavoriteCount DESC LIMIT 1
SELECT SUM(posts.commentcount) AS total_comments FROM     posts JOIN     users ON posts.owneruserid = users.id WHERE     users.displayname = 'csgillespie';
SELECT COUNT(*) FROM     posts WHERE     ownerdisplayname = 'csgillespie' AND     answercount = (         SELECT MAX(answercount) FROM posts WHERE ownerdisplayname = 'csgillespie'     );
SELECT users.displayname FROM posts JOIN users ON posts.lasteditoruserid = users.id WHERE posts.title = "Examples for teaching: Correlation does not mean causation";
SELECT COUNT(*) FROM     posts JOIN     users ON posts.owneruserid = users.id WHERE     users.displayname = 'csgillespie' AND     posts.parentid IS NULL;
SELECT users.displayname FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.closeddate IS NOT NULL;
SELECT COUNT(DISTINCT posts.id) FROM     posts     JOIN users ON posts.owneruserid = users.id WHERE     users.age > 65     AND posts.score >= 20;
SELECT users.location FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.title = 'Eliciting priors from experts';
SELECT posts.body FROM posts JOIN tags ON tags.excerptpostid = posts.id WHERE tags.tagname = 'bayesian';
SELECT posts.body FROM posts JOIN tags ON tags.excerptpostid = posts.id GROUP BY tags.tagname ORDER BY COUNT(*) DESC LIMIT 1;
SELECT COUNT(badges.id) FROM badges JOIN users ON badges.userid = users.id WHERE users.displayname = 'csgillespie';
SELECT badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.displayname = "csgillespie";
SELECT COUNT(badges.id) AS num_badges_2011 FROM badges JOIN users ON badges.userid = users.id WHERE users.displayname = 'csgillespie' AND strftime('%Y', badges.date) = '2011';
SELECT users.displayname FROM     users JOIN     badges ON badges.userid = users.id GROUP BY     users.id ORDER BY     COUNT(badges.id) DESC LIMIT 1;
SELECT AVG(posts.score) AS average_score FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'csgillespie';
SELECT AVG(badges.id) AS average_badges FROM     badges JOIN     users ON badges.userid = users.id JOIN     posts ON posts.owneruserid = users.id WHERE     users.views > 200;
SELECT CAST(SUM(CASE WHEN T2.age > 65 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM posts AS T1 INNER JOIN users AS T2 ON T1.ownerUserID = T2.id WHERE T1.Score > 20
SELECT COUNT(*) FROM     votes WHERE     userid = 58     AND     creationdate >= '2010-07-19 00:00:00'     AND     creationdate <= '2010-07-19 23:59:59';
SELECT CreationDate FROM     votes GROUP BY     CreationDate ORDER BY     COUNT(id) DESC LIMIT 1;
SELECT COUNT(*) FROM badges WHERE name = 'Revival';
SELECT MAX(posts.title) AS title FROM     posts JOIN     comments ON posts.id = comments.postid WHERE     comments.score = (         SELECT            MAX(score)         FROM             comments     );
SELECT COUNT(comments.id) FROM     posts JOIN     comments ON posts.id = comments.postid WHERE     posts.viewcount = 1910;
SELECT T1.FavoriteCount FROM Posts AS T1 INNER JOIN Comments AS T2 ON T1.Id = T2.PostId WHERE T2.UserID = 3025 AND T2.CreationDate = '2014-04-23 20:29:39'
SELECT comments.text FROM comments JOIN posts ON comments.postid = posts.id WHERE posts.parentid = 107829 AND posts.commentcount = 1;
SELECT CASE     WHEN p.closeddate IS NULL THEN 'Well-finished'     ELSE 'Not well-finished' END AS post_status FROM     comments AS c     JOIN posts AS p ON c.postid = p.id WHERE     c.userid = 23853     AND c.creationdate = '2013-07-12 09:08:18.0';
SELECT users.reputation FROM posts INNER JOIN users ON posts.owneruserid = users.id WHERE posts.id = '65041';
SELECT COUNT(posts.id) FROM     users JOIN     posts ON posts.owneruserid = users.id WHERE     users.displayname = "Tiago Pasqualini";
SELECT users.displayname FROM     users JOIN     votes ON users.id = votes.userid WHERE     votes.id = 381800;
SELECT COUNT(votes.id) FROM     votes JOIN posts ON votes.postid = posts.id WHERE     posts.title LIKE '%data visualization%';
SELECT `badges.name`   FROM     `badges` JOIN     `users` ON `badges.userid` = `users.id` WHERE     `users.displayname` = "DatEpicCoderGuyWhoPrograms";
SELECT COUNT(DISTINCT posts.id) / COUNT(DISTINCT votes.id) AS post_to_vote_ratio FROM     posts LEFT JOIN     users ON posts.owneruserid = users.id LEFT JOIN     votes ON posts.id = votes.postid WHERE     users.id = 24;
SELECT SUM(viewcount) FROM posts WHERE title = 'Integration of Weka and/or RapidMiner into Informatica PowerCenter/Developer';
SELECT comments.text FROM comments WHERE comments.score = 17;
SELECT users.displayname FROM users WHERE users.websiteurl = 'http://stackoverflow.com';
SELECT badges.name FROM badges INNER JOIN users ON badges.userid = users.id WHERE users.displayname = 'SilentGhost';
SELECT users.displayname FROM     users JOIN     comments ON comments.userid = users.id WHERE     comments.text = 'thank you user93!';
SELECT comments.text FROM comments JOIN users ON comments.userid = users.id WHERE users.displayname = 'A Lion';
SELECT users.displayname, users.reputation FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.title = 'Understanding what Dassault iSight is doing?';
SELECT comments.text FROM     comments JOIN     posts ON comments.postid = posts.id WHERE     posts.title = 'How does gentle boosting differ from AdaBoost?';
SELECT users.displayname FROM badges JOIN users ON badges.userid = users.id WHERE badges.name = 'Necromancer' LIMIT 10;
SELECT users.displayname AS editor FROM posts JOIN users ON posts.lasteditoruserid = users.id WHERE posts.title = 'Open source tools for visualizing multi-dimensional data';
SELECT posts.title FROM posts INNER JOIN users ON posts.lasteditoruserid = users.id WHERE users.displayname = "Vebjorn Ljosa";
SELECT SUM(posts.score), users.websiteurl FROM     posts JOIN     users ON posts.lasteditoruserid = users.id WHERE     users.displayname = 'Yevgeny'
SELECT comments.text FROM     comments JOIN     posts ON comments.postid = posts.id JOIN     posthistory ON posts.id = posthistory.postid JOIN     users ON comments.userid = users.id WHERE     posts.title = 'Why square the difference instead of taking the absolute value in standard deviation?' AND     posthistory.userdisplayname = users.displayname;
SELECT SUM(votes.bountyamount) AS total_bounty_amount FROM     posts JOIN     votes ON votes.postid = posts.id WHERE     posts.title LIKE '%data%';
SELECT users.displayname FROM     users JOIN     votes ON votes.userid = users.id JOIN     posts ON votes.postid = posts.id WHERE     posts.title LIKE '%variance%' AND     votes.bountyamount = 50;
SELECT AVG(T1.ViewCount), T1.Title, T2.Text, T2.Score FROM Posts AS T1 INNER JOIN Comments AS T2 ON T1.Id = T2.PostId INNER JOIN PostTags AS T3 ON T1.Id = T3.PostId INNER JOIN Tags AS T4 ON T3.TagId = T4.Id WHERE T4.TagName = 'humor'
SELECT COUNT(comments.id) FROM comments WHERE comments.userid = 13;
SELECT MAX(users.id) AS highest_reputation_user_id FROM users;
SELECT MIN(id) AS lowest_view_user_id FROM     users ORDER BY     views ASC LIMIT 1;
SELECT COUNT(DISTINCT users.id) FROM     badges     JOIN users ON badges.userid = users.id WHERE     badges.name = 'Supporter'     AND strftime('%Y', badges.date) = '2011';
SELECT COUNT(users.id) AS "Users with More Than 5 Badges" FROM     users INNER JOIN     badges ON users.id = badges.userid GROUP BY     badges.userid HAVING     COUNT(badges.name) > 5;
SELECT COUNT(DISTINCT users.id) FROM     users JOIN     badges ON users.id = badges.userid WHERE     users.location = 'New York'     AND badges.name IN ('Supporter', 'Teacher');
SELECT users.displayname, users.reputation FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.id = 1;
SELECT T1.UserID FROM Posts AS T1 INNER JOIN PostHistory AS T2 ON T1.Id = T2.PostId WHERE T1.ViewCount > 1000 GROUP BY T1.UserID HAVING COUNT(T2.PostId) = 1
SELECT T1.UserID, T2.Name FROM Comments AS T1 INNER JOIN Badges AS T2 ON T1.UserID = T2.UserID GROUP BY T1.UserID ORDER BY COUNT(T1.PostID) DESC LIMIT 1
SELECT COUNT(DISTINCT users.id) FROM users JOIN badges ON users.id = badges.userid WHERE users.location = 'India' AND badges.name = 'Teacher';
SELECT CAST(SUM(CASE WHEN STRFTIME('%Y', Date) = '2010' THEN 1 ELSE 0 END) - SUM(CASE WHEN STRFTIME('%Y', Date) = '2011' THEN 1 ELSE 0 END) AS REAL) * 100 / SUM(CASE WHEN STRFTIME('%Y', Date) = '2011' THEN 1 ELSE 0 END) FROM Badges WHERE Name = 'Student'
SELECT posthistorytypeid, COUNT(DISTINCT comments.userid) FROM posthistory LEFT JOIN comments ON posthistory.postid = comments.postid WHERE posthistory.postid = 3720 GROUP BY posthistorytypeid;
SELECT T1.PostId, T1.ViewCount FROM Posts AS T1 INNER JOIN PostLinks AS T2 ON T1.Id = T2.PostId WHERE T2.RelatedPostId = 61217
SELECT posts.score, postlinks.linktypeid FROM posts JOIN postlinks ON posts.id = postlinks.postid WHERE posts.id = 395;
SELECT posts.id AS post_id, posts.owneruserid AS user_id FROM posts WHERE posts.score > 60;
SELECT SUM(T1.FavoriteCount) FROM Posts AS T1 INNER JOIN Votes AS T2 ON T1.Id = T2.PostId WHERE T1.OwnerUserId = 686 AND T1.CreationDate LIKE '2011%'
SELECT AVG(T1.UpVotes) , AVG(T1.Age) FROM Users AS T1 INNER JOIN Posts AS T2 ON T1.Id = T2.OwnerUserId GROUP BY T1.Id HAVING COUNT(T2.Id) > 10
SELECT COUNT(DISTINCT users.id) AS "Number of users with Announcer badge" FROM     badges JOIN users ON badges.userid = users.id WHERE     badges.name = "Announcer";
SELECT name FROM     badges WHERE     date = '2010-07-19 19:39:08';
SELECT COUNT(*) FROM comments WHERE score > 60;
SELECT comments.text FROM comments WHERE comments.creationdate = '2010-07-19 19:25:47'
SELECT COUNT(*) FROM     posts WHERE     score = 10;
SELECT badges.name FROM   badges JOIN   users ON badges.userid = users.id WHERE   users.reputation = (SELECT MAX(reputation) FROM users)
SELECT users.reputation FROM badges JOIN users ON badges.userid = users.id WHERE badges.date = '2010-07-19 19:39:08.0';
SELECT badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.displayname = "Pierre";
SELECT   badges.date FROM badges JOIN users ON badges.userid = users.id WHERE users.location = 'Rochester, NY'
SELECT CAST(COUNT(T1.UserID) AS REAL) * 100 / ( SELECT COUNT(UserID) FROM Users ) FROM Badges AS T1 INNER JOIN Users AS T2 ON T1.UserID = T2.ID WHERE T1.Name = 'Teacher'
SELECT CAST(SUM(CASE WHEN T2.age BETWEEN 13 AND 18 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.id) FROM badges AS T1 INNER JOIN users AS T2 ON T1.userid = T2.id WHERE T1.name = 'Organizer'
SELECT comments.score FROM comments INNER JOIN posts ON comments.postid = posts.id WHERE posts.creationdate = '2010-07-19 19:19:56.0';
SELECT T2.Text FROM Posts AS T1 INNER JOIN Comments AS T2 ON T1.Id = T2.PostId WHERE T1.CreationDate = '2010-07-19 19:37:33'
SELECT users.age FROM users JOIN badges ON badges.userid = users.id WHERE users.location = 'Vienna, Austria';
SELECT COUNT(DISTINCT users.id) FROM badges JOIN users ON badges.userid = users.id WHERE badges.name = 'Supporter' AND users.age BETWEEN 19 AND 65;
SELECT COUNT(DISTINCT views) FROM     users JOIN     badges ON users.id = badges.userid WHERE     badges.date = '2010-07-19 19:39:08.0';
SELECT badges.name FROM   badges JOIN   users ON badges.userid = users.id WHERE   users.reputation = (SELECT MIN(reputation) FROM users);
SELECT badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.displayname = "Sharpie";
SELECT COUNT(DISTINCT users.id) FROM     users JOIN     badges ON badges.userid = users.id WHERE     badges.name = "Supporter"     AND users.age > 65;
SELECT users.displayname FROM users WHERE users.id = 30;
SELECT COUNT(DISTINCT users.id) FROM     users WHERE     users.location = 'New York';
SELECT COUNT(*)  FROM votes  WHERE strftime('%Y', CreationDate) = '2010';
SELECT COUNT(DISTINCT users.id) FROM     users WHERE     age BETWEEN 19 AND 65;
SELECT users.displayname FROM users WHERE views = (     SELECT MAX(views)     FROM users );
SELECT CAST(SUM(CASE WHEN STRFTIME('%Y', CreationDate) = '2010' THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN STRFTIME('%Y', CreationDate) = '2011' THEN 1 ELSE 0 END) FROM Votes
SELECT tags.tagname FROM tags JOIN posts ON tags.excerptpostid = posts.id JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'John Stauffer';
SELECT COUNT(*) AS "Number of posts created by Daniel Vassallo" FROM     posts JOIN     users ON posts.owneruserid = users.id WHERE     users.displayname = 'Daniel Vassallo';
SELECT COUNT(votes.id) FROM     votes JOIN     users ON votes.userid = users.id WHERE     users.displayname = 'Harlan';
SELECT posts.id FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'slashnick' ORDER BY posts.answercount DESC LIMIT 1;
SELECT CASE WHEN T1.ViewCount > T2.ViewCount THEN T1.Title ELSE T2.Title END FROM Posts AS T1 INNER JOIN Users AS T2 ON T1.OwnerUserId = T2.Id WHERE T2.DisplayName IN ('Harvey Motulsky', 'Noah Snyder')
SELECT COUNT(posts.id) FROM     posts JOIN     users ON posts.owneruserid = users.id WHERE     users.displayname = 'Matt Parker'     AND posts.score > 4;
SELECT COUNT(comments.id) FROM     comments JOIN users ON comments.userid = users.id JOIN posts ON comments.postid = posts.id WHERE     users.displayname = 'Neil McGuigan'     AND comments.score < 60;
SELECT tags.tagname FROM     posts JOIN     users ON posts.owneruserid = users.id JOIN     tags ON posts.tags LIKE '%' || tags.tagname || '%' LEFT JOIN     comments ON posts.id = comments.postid WHERE     users.displayname = 'Mark Meckes'     AND comments.id IS NULL;
SELECT users.displayname FROM badges INNER JOIN users ON badges.userid = users.id WHERE badges.name = 'Organizer';
SELECT CAST(SUM(CASE WHEN T2.TagName = 'r' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.Id) FROM Posts AS T1 INNER JOIN Tags AS T2 ON T1.Id = T2.ExcerptPostId WHERE T1.OwnerDisplayName = 'Community'
SELECT SUM(CASE WHEN p.ownerdisplayname = 'Mornington' THEN p.viewcount ELSE 0 END) - SUM(CASE WHEN p.ownerdisplayname = 'Amos' THEN p.viewcount ELSE 0 END) FROM posts p JOIN users u ON p.owneruserid = u.id WHERE u.displayname IN ('Mornington', 'Amos');
SELECT COUNT(DISTINCT users.id) FROM     badges JOIN     users ON badges.userid = users.id WHERE     badges.name = 'commentator'     AND strftime('%Y', badges.date) = '2014';
SELECT COUNT(*) FROM     posts WHERE     creationdate BETWEEN '2010-07-21 00:00:00' AND '2010-07-21 23:59:59';
SELECT users.displayname, users.age FROM users WHERE users.views = (     SELECT MAX(views)     FROM users );
SELECT posts.lasteditdate, posts.lasteditoruserid FROM posts WHERE posts.title = 'Detecting a given face in a database of facial images';
SELECT COUNT(*) FROM     comments WHERE     userid = 13     AND score < 60;
SELECT posts.title, comments.userdisplayname FROM posts INNER JOIN comments ON posts.id = comments.postid WHERE comments.score > 60;
SELECT badges.name FROM badges JOIN users ON badges.userid = users.id WHERE badges.date LIKE '2011%' AND users.location LIKE '%North Pole%';
SELECT users.displayname, users.websiteurl FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.favoritecount > 150;
SELECT COUNT(posthistory.id) AS post_history_counts, MAX(posthistory.creationdate) AS last_edit_date FROM posts LEFT JOIN posthistory ON posts.id = posthistory.postid WHERE posts.title = "What is the best introductory Bayesian statistics textbook?";
SELECT users.lastaccessdate, users.location FROM users JOIN badges ON users.id = badges.userid WHERE badges.name = 'Outliers';
SELECT posts.title FROM posts JOIN postlinks ON posts.id = postlinks.relatedpostid WHERE postlinks.creationdate = (SELECT MAX(creationdate) FROM postlinks WHERE postid = (SELECT id FROM posts WHERE title = "How to tell if something happened in a data set which monitors a value over time"))
SELECT T1.PostId, T3.Name FROM Posts AS T1 INNER JOIN Users AS T2 ON T1.OwnerUserId = T2.Id INNER JOIN Badges AS T3 ON T2.Id = T3.UserID WHERE T2.DisplayName = 'Samuel' AND T1.CreationDate LIKE '2013%'
SELECT   posts.ownerdisplayname FROM posts WHERE posts.viewcount = (SELECT MAX(viewcount) FROM posts);
SELECT users.displayname, users.location FROM posts JOIN tags ON tags.excerptpostid = posts.id JOIN users ON posts.owneruserid = users.id WHERE tags.tagname = 'hypothesis-testing';
SELECT posts.title, postlinks.linktypeid FROM posts JOIN postlinks ON posts.id = postlinks.relatedpostid WHERE posts.title = 'What are principal component scores?';
SELECT T2.DisplayName FROM Posts AS T1 INNER JOIN Users AS T2 ON T1.OwnerUserId = T2.Id WHERE T1.ParentId = ( SELECT ParentId FROM Posts ORDER BY Score DESC LIMIT 1 )
SELECT users.displayname, users.websiteurl FROM     votes JOIN     users ON votes.userid = users.id WHERE     votes.votetypeid = 8 AND     votes.bountyamount = (         SELECT MAX(bountyamount) FROM votes WHERE votetypeid = 8     );
SELECT   Title FROM   posts ORDER BY   viewcount DESC LIMIT 5;
SELECT COUNT(T1.TagName) FROM tags AS T1 INNER JOIN posts AS T2 ON T1.ExcerptPostId = T2.Id WHERE T1.Count BETWEEN 5000 AND 7000
SELECT OwnerUserId FROM Posts ORDER BY Reputation DESC LIMIT 1
SELECT MAX(age) AS "Oldest Most Influential User Age" FROM     users WHERE     reputation = (SELECT MAX(reputation) FROM users);
SELECT COUNT(T1.PostId) FROM Votes AS T1 INNER JOIN Posts AS T2 ON T1.PostId = T2.Id WHERE T1.BountyAmount = 50 AND T2.CreationDate LIKE '2011%'
SELECT id FROM users ORDER BY age DESC LIMIT 1
SELECT MAX(p.viewcount) AS max_viewcount, p.score AS post_score FROM posts p JOIN postlinks pl ON p.id = pl.postid JOIN tags t ON pl.relatedpostid = t.excerptpostid;
SELECT AVG(MONTHLY_LINKS) AS average_monthly_links_created_2010 FROM (     SELECT         COUNT(postlinks.id) AS MONTHLY_LINKS     FROM          postlinks     JOIN          posts ON postlinks.postid = posts.id     WHERE          posts.answercount <= 2         AND strftime('%Y', postlinks.creationdate) = '2010'     GROUP BY          strftime('%m', postlinks.creationdate) ) AS monthly_links_2010
SELECT MAX(posts.id) AS most_valuable_post_id FROM     posts INNER JOIN     votes ON posts.id = votes.postid WHERE     votes.userid = 1465;
SELECT posts.title FROM postlinks JOIN posts ON postlinks.postid = posts.id WHERE postlinks.creationdate = (SELECT MIN(creationdate) FROM postlinks);
SELECT MAX(displayname) AS highest_badge_user FROM     (SELECT u.displayname, COUNT(b.name) AS badge_count      FROM users u      JOIN badges b ON u.id = b.userid      GROUP BY u.displayname      ORDER BY badge_count DESC      LIMIT 1) AS t;
SELECT MIN(votes.creationdate) AS "FirstVoteDate" FROM     votes JOIN     users ON votes.userid = users.id WHERE     users.displayname = 'chl';
SELECT MIN(posts.creationdate) AS first_post_date FROM     posts JOIN     users ON posts.owneruserid = users.id WHERE     users.age = (SELECT MIN(age) FROM users);
SELECT users.displayname FROM badges JOIN users ON badges.userid = users.id WHERE badges.name = 'Autobiographer' ORDER BY badges.date ASC LIMIT 1;
SELECT COUNT(DISTINCT users.id) FROM     users JOIN     posts ON posts.owneruserid = users.id WHERE     users.location = 'United Kingdom'     AND posts.favoritecount >= 4;
SELECT AVG(PostId) FROM     votes WHERE     userid IN (SELECT id FROM users WHERE age = (SELECT MAX(age) FROM users));
SELECT displayname FROM users ORDER BY reputation DESC LIMIT 1
SELECT COUNT(DISTINCT users.id) FROM users JOIN posts ON posts.owneruserid = users.id WHERE users.reputation > 2000 AND users.views > 1000;
SELECT users.displayname FROM users WHERE users.age BETWEEN 19 AND 65;
SELECT COUNT(posts.id) AS Jay_Stevens_Posts_2010 FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'Jay Stevens' AND STRFTIME('%Y', posts.creationdate) = '2010';
SELECT posts.id, posts.title FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'Harvey Motulsky' ORDER BY posts.viewcount DESC LIMIT 1;
SELECT     posts.id,     posts.title FROM     posts ORDER BY     posts.score DESC LIMIT 1;
SELECT AVG(posts.score) AS average_score FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'Stephen Turner';
SELECT T1.DisplayName FROM Users AS T1 INNER JOIN Posts AS T2 ON T1.Id = T2.OwnerUserId WHERE T2.ViewCount > 20000 AND T2.CreationDate LIKE '2011%'
SELECT T1.Id, T2.DisplayName FROM Posts AS T1 INNER JOIN Users AS T2 ON T1.OwnerUserId = T2.Id WHERE T1.CreationDate LIKE '2010%' ORDER BY T1.FavoriteCount DESC LIMIT 1
SELECT CAST(SUM(CASE WHEN T2.Reputation > 1000 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.PostTypeId) FROM Posts AS T1 INNER JOIN Users AS T2 ON T1.OwnerUserId = T2.Id WHERE T1.CreationDate LIKE '2011%'
SELECT CAST(SUM(CASE WHEN Age >= 13 AND Age <= 18 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(Id) FROM Users
SELECT SUM(posts.viewcount) AS total_views, users.displayname AS last_posted_by FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.title = 'Computer Game Datasets' AND posts.posttypeid = 1;
SELECT COUNT(*) FROM posts WHERE ViewCount > (SELECT AVG(ViewCount) FROM posts);
SELECT COUNT(comments.id) FROM     comments WHERE     comments.postid = (         SELECT            id         FROM             posts         ORDER BY             score DESC         LIMIT 1     );
SELECT COUNT(*) FROM posts WHERE viewcount > 35000 AND commentcount = 0;
SELECT users.displayname, users.location FROM     users JOIN     posts ON posts.lasteditoruserid = users.id WHERE     posts.id = 183;
SELECT Name FROM badges WHERE userid = (SELECT id FROM users WHERE displayname = 'Emmett') ORDER BY date DESC LIMIT 1;
SELECT COUNT(T1.Id) FROM Users AS T1 INNER JOIN Votes AS T2 ON T1.Id = T2.UserID WHERE T1.Age > 18 AND T2.VoteTypeId = 1 GROUP BY T1.Id HAVING COUNT(T2.Id) > 5000
SELECT strftime('%Y-%m-%d', MIN(strftime('%s', badges.date) - strftime('%s', users.creationdate)), 'unixepoch') AS time_to_badge FROM     badges JOIN     users ON badges.userid = users.id WHERE     users.displayname = 'Zolomon';
SELECT COUNT(DISTINCT posts.id) AS num_posts, COUNT(DISTINCT comments.id) AS num_comments FROM     users JOIN posts ON posts.owneruserid = users.id JOIN comments ON comments.userid = users.id WHERE     users.creationdate = (SELECT MAX(creationdate) FROM users);
SELECT comments.text, users.displayname FROM     comments JOIN     posts ON comments.postid = posts.id JOIN     users ON comments.userid = users.id WHERE     posts.title = 'Analysing wind data with R' ORDER BY     comments.creationdate DESC LIMIT 1;
SELECT COUNT(DISTINCT users.id) AS "Citizen Patrol Badge Winners" FROM badges JOIN users ON badges.userid = users.id WHERE badges.name = 'Citizen Patrol';
SELECT COUNT(*) FROM     posts JOIN     tags ON posts.id = tags.excerptpostid WHERE     tags.tagname = 'careers';
SELECT users.reputation, users.views FROM users WHERE users.displayname = 'Jarrod Dixon';
SELECT COUNT(DISTINCT comments.id) AS num_comments, COUNT(DISTINCT posts.id) AS num_answers FROM posts LEFT JOIN comments ON posts.id = comments.postid WHERE posts.title = 'Clustering 1D data' AND posts.posttypeid = 1;
SELECT creationdate FROM users WHERE displayname = 'IrishStat';
SELECT COUNT(DISTINCT posts.id) FROM     posts JOIN     votes ON posts.id = votes.postid WHERE     votes.bountyamount >= 30;
SELECT CAST(SUM(CASE WHEN T2.Score > 50 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.PostId) FROM Users AS T1 INNER JOIN Posts AS T2 ON T1.Id = T2.OwnerUserId ORDER BY T1.Reputation DESC LIMIT 1
SELECT COUNT(*) FROM     posts WHERE     score < 20;
SELECT COUNT(T1.TagName) FROM Tags AS T1 INNER JOIN Posts AS T2 ON T1.ExcerptPostId = T2.Id WHERE T1.Id < 15 AND T1.Count < 20
SELECT tags.excerptpostid, tags.wikipostid FROM tags WHERE tags.tagname = 'sample';
SELECT users.reputation, users.upvotes FROM     users JOIN     comments ON comments.userid = users.id WHERE     comments.text = 'fine, you win :)';
SELECT comments.text FROM     comments JOIN     posts ON comments.postid = posts.id WHERE     posts.title = 'How can I adapt ANOVA for binary data?' AND     posts.tags LIKE '%linear-regression%'
SELECT T2.Comment FROM posts AS T1 INNER JOIN posthistory AS T2 ON T1.Id = T2.PostId WHERE T1.Views BETWEEN 100 AND 150 ORDER BY T2.Score DESC LIMIT 1
SELECT comments.creationdate, users.age FROM comments JOIN users ON comments.userid = users.id WHERE comments.text LIKE '%http://%'
SELECT COUNT(DISTINCT posts.id) FROM     comments JOIN     posts ON comments.postid = posts.id WHERE     comments.score = 0     AND posts.viewcount < 5;
SELECT COUNT(*) AS "Comments with 0 score" FROM comments JOIN posts ON comments.postid = posts.id WHERE posts.commentcount = 1 AND comments.score = 0;
SELECT COUNT(DISTINCT u.id) FROM comments c JOIN users u ON c.userid = u.id WHERE c.score = 0 AND u.age = 40;
SELECT posts.id, comments.id FROM posts JOIN comments ON posts.id = comments.postid WHERE posts.title = 'Group differences on a five point Likert item';
SELECT SUM(votes.votetypeid = 2) AS upvote_number FROM     comments JOIN     users ON comments.userid = users.id JOIN     votes ON comments.postid = votes.postid AND votes.userid = users.id WHERE     comments.text = "R is also lazy evaluated."
SELECT comments.text FROM comments JOIN users ON comments.userid = users.id WHERE users.displayname = 'Harvey Motulsky';
SELECT users.displayname FROM comments JOIN users ON comments.userid = users.id WHERE comments.score BETWEEN 1 AND 5 AND users.downvotes = 0;
SELECT CAST(SUM(CASE WHEN T2.UpVotes = 0 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.UserID) FROM Comments AS T1 INNER JOIN Users AS T2 ON T1.UserID = T2.Id WHERE T1.Score BETWEEN 5 AND 10
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = '3-D Man';
SELECT COUNT(superhero.id) FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Super Strength';
SELECT COUNT(DISTINCT superhero.id) FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Super Strength' AND superhero.height_cm > 200;
SELECT superhero.full_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id GROUP BY superhero.id HAVING COUNT(superpower.id) > 15;
SELECT COUNT(DISTINCT superhero.id) AS num_superheroes FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE colour.colour = 'Blue';
SELECT colour.colour FROM superhero JOIN colour ON superhero.skin_colour_id = colour.id WHERE superhero.superhero_name = 'Apocalypse';
SELECT COUNT(superhero.id) FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE colour.colour = 'Blue' AND superpower.power_name = 'Agility';
SELECT superhero.superhero_name FROM superhero JOIN colour AS eye_colour ON superhero.eye_colour_id = eye_colour.id JOIN colour AS hair_colour ON superhero.hair_colour_id = hair_colour.id WHERE eye_colour.colour = 'Blue' AND hair_colour.colour = 'Blond';
SELECT COUNT(superhero.id) FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE publisher.publisher_name = 'Marvel Comics';
SELECT full_name FROM superhero WHERE publisher_id = ( SELECT id FROM publisher WHERE publisher_name = 'Marvel Comics' ) ORDER BY height_cm DESC LIMIT 1
SELECT publisher.publisher_name FROM publisher JOIN superhero ON superhero.publisher_id = publisher.id WHERE superhero.superhero_name = 'Sauron';
SELECT COUNT(superhero.id) FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id JOIN colour ON superhero.eye_colour_id = colour.id WHERE publisher.publisher_name = 'Marvel Comics' AND colour.colour = 'Blue';
SELECT AVG(height_cm) FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE publisher.publisher_name = 'Marvel Comics';
SELECT CAST(SUM(CASE WHEN T3.power_name = 'Super Strength' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM superhero AS T1 INNER JOIN hero_power AS T2 ON T1.id = T2.hero_id INNER JOIN superpower AS T3 ON T2.power_id = T3.id WHERE T1.publisher_id = ( SELECT id FROM publisher WHERE publisher_name = 'Marvel Comics' )
SELECT COUNT(superhero.id) FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE publisher.publisher_name = 'DC Comics';
SELECT publisher.publisher_name FROM publisher JOIN superhero ON publisher.id = superhero.publisher_id JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE attribute.attribute_name = 'Speed' ORDER BY hero_attribute.attribute_value LIMIT 1;
SELECT COUNT(superhero.id) FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id JOIN publisher ON superhero.publisher_id = publisher.id WHERE colour.colour = 'Gold' AND publisher.publisher_name = 'Marvel Comics';
SELECT publisher.publisher_name FROM superhero INNER JOIN publisher ON superhero.publisher_id = publisher.id WHERE superhero.superhero_name = 'Blue Beetle II';
SELECT COUNT(*) FROM superhero JOIN colour AS hair_color ON superhero.hair_colour_id = hair_color.id WHERE hair_color.colour = 'Blond';
SELECT superhero.superhero_name FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE attribute.attribute_name = 'Intelligence' ORDER BY hero_attribute.attribute_value LIMIT 1;
SELECT race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.superhero_name = 'Copycat';
SELECT COUNT(DISTINCT superhero.id) AS num_superheroes FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE attribute.attribute_name = 'Durability' AND hero_attribute.attribute_value < 50;
SELECT superhero.superhero_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Death Touch';
SELECT COUNT(DISTINCT superhero.id) FROM superhero JOIN gender ON superhero.gender_id = gender.id JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE gender.gender = 'Female' AND attribute.attribute_name = 'Strength' AND hero_attribute.attribute_value = 100;
SELECT superhero.superhero_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id GROUP BY superhero.superhero_name ORDER BY COUNT(hero_power.power_id) DESC LIMIT 1;
SELECT COUNT(superhero.id) FROM superhero INNER JOIN race ON superhero.race_id = race.id WHERE race.race = 'Vampire';
SELECT CAST(SUM(CASE WHEN T3.alignment = 'Good' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id), COUNT(CASE WHEN T4.publisher_name = 'Marvel Comics' THEN 1 ELSE NULL END) FROM superhero AS T1 INNER JOIN hero_power AS T2 ON T1.id = T2.hero_id INNER JOIN superpower AS T3 ON T2.power_id = T3.id INNER JOIN publisher AS T4 ON T1.publisher_id = T4.id
SELECT SUM(CASE WHEN T2.publisher_name = 'DC Comics' THEN 1 ELSE 0 END) - SUM(CASE WHEN T2.publisher_name = 'Marvel Comics' THEN 1 ELSE 0 END) FROM superhero AS T1 INNER JOIN publisher AS T2 ON T1.publisher_id = T2.id
SELECT publisher.id FROM publisher WHERE publisher.publisher_name = 'Star Trek';
SELECT AVG(attribute_value) FROM hero_attribute;
SELECT COUNT(*) FROM superhero WHERE full_name IS NULL;
SELECT colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.id = 75;
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = 'Deathlok';
SELECT AVG(weight_kg) AS average_weight FROM superhero WHERE gender_id = (     SELECT id     FROM gender     WHERE gender = 'female' );
SELECT power_name FROM superpower JOIN hero_power ON superpower.id = hero_power.power_id JOIN superhero ON hero_power.hero_id = superhero.id JOIN gender ON superhero.gender_id = gender.id WHERE gender.gender = 'Male';
SELECT superhero.superhero_name FROM superhero JOIN race ON superhero.race_id = race.id WHERE race.race = 'Alien';
SELECT superhero.superhero_name FROM superhero LEFT JOIN colour AS eye_color ON superhero.eye_colour_id = eye_color.id WHERE superhero.height_cm BETWEEN 170 AND 190 AND eye_color.id IS NULL;
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.id = 56;
SELECT superhero.full_name FROM superhero JOIN race ON superhero.race_id = race.id WHERE race.race = 'Demi-God';
SELECT COUNT(superhero.id) FROM superhero JOIN alignment ON superhero.alignment_id = alignment.id WHERE alignment.alignment = 'Bad';
SELECT race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.weight_kg = 169;
SELECT colour.colour FROM superhero JOIN colour ON superhero.hair_colour_id = colour.id JOIN race ON superhero.race_id = race.id WHERE superhero.height_cm = 185 AND race.race = 'human';
SELECT colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.weight_kg = (     SELECT MAX(weight_kg)     FROM superhero );
SELECT CAST(SUM(CASE WHEN T2.publisher_id = 13 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM superhero AS T1 INNER JOIN publisher AS T2 ON T1.publisher_id = T2.id WHERE T1.height_cm BETWEEN 150 AND 180
SELECT superhero.full_name FROM superhero INNER JOIN gender ON superhero.gender_id = gender.id WHERE gender.gender = 'male' AND superhero.weight_kg > (SELECT AVG(weight_kg) * 0.79 FROM superhero);
SELECT power_name FROM (     SELECT        power_name,         COUNT(*) AS power_count     FROM         hero_power     INNER JOIN         superpower ON hero_power.power_id = superpower.id     GROUP BY         power_name     ORDER BY         power_count DESC     LIMIT 1 );
SELECT attribute_value FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE superhero.superhero_name = 'Abomination';
SELECT superpower.power_name FROM superpower JOIN hero_power ON superpower.id = hero_power.power_id WHERE hero_power.hero_id = 1;
SELECT COUNT(DISTINCT superhero.id) AS num_heroes FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'stealth';
SELECT superhero.full_name FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE attribute.attribute_name = 'strength' AND hero_attribute.attribute_value = (     SELECT MAX(attribute_value)     FROM hero_attribute     JOIN attribute ON hero_attribute.attribute_id = attribute.id     WHERE attribute.attribute_name = 'strength' );
SELECT AVG(CASE WHEN superhero.skin_colour_id IS NULL THEN 1 ELSE 0 END) as average_no_skin_colour FROM superhero;
SELECT COUNT(superhero.id) FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE publisher.publisher_name = 'Dark Horse Comics';
SELECT T1.superhero_name FROM superhero AS T1 INNER JOIN hero_attribute AS T2 ON T1.id = T2.hero_id INNER JOIN attribute AS T3 ON T2.attribute_id = T3.id INNER JOIN publisher AS T4 ON T1.publisher_id = T4.id WHERE T3.attribute_name = 'durability' AND T4.publisher_name = 'Dark Horse Comics' ORDER BY T1.id DESC LIMIT 1
SELECT colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.superhero_name = 'Abraham Sapien';
SELECT superhero.superhero_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Flight';
SELECT T1.eye_colour_id, T1.hair_colour_id, T1.skin_colour_id FROM superhero AS T1 INNER JOIN publisher AS T2 ON T1.publisher_id = T2.id WHERE T2.publisher_name = 'Dark Horse Comics' AND T1.gender_id = ( SELECT id FROM gender WHERE gender = 'female' )
SELECT superhero.superhero_name, publisher.publisher_name FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id JOIN colour AS eye_colour ON superhero.eye_colour_id = eye_colour.id JOIN colour AS hair_colour ON superhero.hair_colour_id = hair_colour.id JOIN colour AS skin_colour ON superhero.skin_colour_id = skin_colour.id WHERE hair_colour.colour = skin_colour.colour AND hair_colour.colour = eye_colour.colour;
SELECT race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.superhero_name = 'A-Bomb';
SELECT CAST(SUM(CASE WHEN T2.gender = 'female' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM superhero AS T1 INNER JOIN gender AS T2 ON T1.gender_id = T2.id INNER JOIN colour AS T3 ON T1.skin_colour_id = T3.id WHERE T3.colour = 'blue'
SELECT superhero.superhero_name, race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.full_name = "Charles Chandler";
SELECT gender.gender FROM superhero JOIN gender ON superhero.gender_id = gender.id WHERE superhero.superhero_name = 'Agent 13';
SELECT superhero.superhero_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Adaptation';
SELECT COUNT(superpower.id) FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = 'Amazo';
SELECT power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = 'Hunter Zolomon';
SELECT height_cm FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE colour.colour = 'Amber';
SELECT superhero.superhero_name FROM superhero JOIN colour AS eye_colour ON superhero.eye_colour_id = eye_colour.id JOIN colour AS hair_colour ON superhero.hair_colour_id = hair_colour.id WHERE eye_colour.colour = 'Black' AND hair_colour.colour = 'Black';
SELECT colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.skin_colour_id = (SELECT id FROM colour WHERE colour = 'Gold');
SELECT superhero.full_name FROM superhero JOIN race ON superhero.race_id = race.id WHERE race.race = 'Vampire';
SELECT superhero.superhero_name FROM superhero INNER JOIN alignment ON superhero.alignment_id = alignment.id WHERE alignment.alignment = 'Neutral';
SELECT COUNT(DISTINCT superhero.id) FROM     superhero JOIN     hero_attribute ON superhero.id = hero_attribute.hero_id JOIN     attribute ON hero_attribute.attribute_id = attribute.id WHERE     attribute.attribute_name = 'Strength'     AND hero_attribute.attribute_value = (SELECT MAX(attribute_value) FROM hero_attribute WHERE attribute_id = attribute.id);
SELECT race.race, alignment.alignment FROM superhero JOIN race ON superhero.race_id = race.id JOIN alignment ON superhero.alignment_id = alignment.id WHERE superhero.superhero_name = 'Cameron Hicks';
SELECT CAST(SUM(CASE WHEN T3.gender = 'female' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM superhero AS T1 INNER JOIN publisher AS T2 ON T1.publisher_id = T2.id INNER JOIN gender AS T3 ON T3.id = T1.gender_id WHERE T2.publisher_name = 'Marvel Comics'
SELECT AVG(weight_kg) FROM superhero JOIN race ON superhero.race_id = race.id WHERE race.race = 'Alien';
SELECT ABS(   (SELECT weight_kg FROM superhero WHERE full_name = 'Emil Blonsky') -   (SELECT weight_kg FROM superhero WHERE full_name = 'Charles Chandler') ) as weight_difference;
SELECT AVG(height_cm) AS average_height, superhero_name FROM superhero GROUP BY superhero_name;
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = 'Abomination';
SELECT COUNT(superhero.id) FROM superhero JOIN gender ON superhero.gender_id = gender.id JOIN race ON superhero.race_id = race.id WHERE race.id = 21 AND gender.id = 1;
SELECT superhero.superhero_name FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE attribute.attribute_name = 'Speed' ORDER BY hero_attribute.attribute_value DESC LIMIT 1;
SELECT COUNT(*) FROM superhero WHERE alignment_id = 3;
SELECT attribute.attribute_name, hero_attribute.attribute_value FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE superhero.superhero_name = '3-D Man';
SELECT superhero.superhero_name FROM superhero JOIN colour AS eye_colour ON superhero.eye_colour_id = eye_colour.id JOIN colour AS hair_colour ON superhero.hair_colour_id = hair_colour.id WHERE eye_colour.colour = 'blue' AND hair_colour.colour = 'brown';
SELECT publisher.publisher_name FROM superhero INNER JOIN publisher ON superhero.publisher_id = publisher.id WHERE superhero.superhero_name IN ('Hawkman', 'Karate Kid', 'Speedy');
SELECT COUNT(*) FROM superhero WHERE publisher_id IS NULL;
SELECT CAST(SUM(CASE WHEN T2.eye_colour_id = 7 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM superhero AS T1 INNER JOIN colour AS T2 ON T1.eye_colour_id = T2.id WHERE T2.colour = 'blue'
SELECT CAST(SUM(CASE WHEN gender_id = 1 THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN gender_id = 2 THEN 1 ELSE 0 END) FROM superhero
SELECT superhero_name FROM superhero ORDER BY height_cm DESC LIMIT 1
SELECT superpower.id FROM superpower WHERE power_name = 'cryokinesis';
SELECT superhero.superhero_name FROM superhero WHERE superhero.id = 294;
SELECT superhero.full_name FROM superhero WHERE weight_kg = 0 OR weight_kg IS NULL;
SELECT colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.full_name = 'Karen Beecher-Duncan';
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.full_name = 'Helen Parr';
SELECT race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.weight_kg = 108 AND superhero.height_cm = 188;
SELECT publisher.publisher_name FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE superhero.id = 38;
SELECT race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.id = (     SELECT hero_attribute.hero_id     FROM hero_attribute     JOIN (         SELECT hero_id, MAX(attribute_value) AS max_value         FROM hero_attribute         GROUP BY hero_id     ) AS max_attribute ON hero_attribute.hero_id = max_attribute.hero_id AND hero_attribute.attribute_value = max_attribute.max_value ) LIMIT 1;
SELECT alignment.alignment, superpower.power_name FROM superhero JOIN alignment ON superhero.alignment_id = alignment.id JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = 'Atom IV';
SELECT superhero.full_name FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE colour.colour = 'Blue';
SELECT AVG(hero_attribute.attribute_value) FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id WHERE superhero.alignment_id = 3;
SELECT colour.colour FROM superhero JOIN colour ON superhero.skin_colour_id = colour.id JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE hero_attribute.attribute_value = 100;
SELECT COUNT(superhero.id) FROM superhero JOIN alignment ON superhero.alignment_id = alignment.id JOIN gender ON superhero.gender_id = gender.id WHERE alignment.id = 1 AND gender.id = 2;
SELECT superhero.superhero_name FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id WHERE hero_attribute.attribute_value BETWEEN 75 AND 80;
SELECT race.race FROM superhero JOIN colour ON superhero.hair_colour_id = colour.id JOIN gender ON superhero.gender_id = gender.id JOIN race ON superhero.race_id = race.id WHERE colour.colour = 'blue' AND gender.gender = 'male';
SELECT CAST(SUM(CASE WHEN T2.gender = 'female' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM superhero AS T1 INNER JOIN gender AS T2 ON T1.gender_id = T2.id WHERE T1.alignment_id = 2
SELECT SUM(CASE WHEN superhero.weight_kg = 0 OR superhero.weight_kg IS NULL THEN      CASE WHEN superhero.eye_colour_id = 7 THEN 1 ELSE 0 END ELSE      0  END)  -  SUM(CASE WHEN superhero.weight_kg = 0 OR superhero.weight_kg IS NULL THEN      CASE WHEN superhero.eye_colour_id = 1 THEN 1 ELSE 0 END ELSE      0  END) AS difference FROM superhero;
SELECT attribute_value FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE superhero.superhero_name = 'Hulk' AND attribute.attribute_name = 'Strength';
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = 'Ajax';
SELECT COUNT(superhero.id) FROM superhero JOIN colour ON superhero.skin_colour_id = colour.id JOIN alignment ON superhero.alignment_id = alignment.id WHERE colour.colour = 'Green' AND alignment.alignment = 'Bad';
SELECT COUNT(superhero.id) FROM superhero JOIN gender ON superhero.gender_id = gender.id JOIN publisher ON superhero.publisher_id = publisher.id WHERE gender.gender = 'Female' AND publisher.publisher_name = 'Marvel Comics';
SELECT superhero.superhero_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Wind Control' ORDER BY superhero.superhero_name ASC;
SELECT gender.gender FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id JOIN gender ON superhero.gender_id = gender.id WHERE superpower.power_name = 'Phoenix Force';
SELECT superhero_name FROM superhero WHERE publisher_id = ( SELECT id FROM publisher WHERE publisher_name = 'DC Comics' ) ORDER BY weight_kg DESC LIMIT 1
SELECT AVG(superhero.height_cm) FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id JOIN race ON superhero.race_id = race.id WHERE publisher.publisher_name = 'Dark Horse Comics' AND race.race <> 'Human';
SELECT COUNT(superhero.id) FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE attribute.attribute_name = 'Speed' AND hero_attribute.attribute_value = 100;
SELECT SUM(CASE WHEN publisher_name = 'DC Comics' THEN 1 ELSE 0 END) - SUM(CASE WHEN publisher_name = 'Marvel Comics' THEN 1 ELSE 0 END) AS difference FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id;
SELECT attribute.attribute_name FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE superhero.superhero_name = 'Black Panther' ORDER BY hero_attribute.attribute_value LIMIT 1;
SELECT colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.superhero_name = 'Abomination';
SELECT superhero.superhero_name FROM superhero WHERE superhero.height_cm = (     SELECT    MAX(height_cm)     FROM     superhero )
SELECT superhero.superhero_name FROM superhero WHERE superhero.full_name = 'Charles Chandler';
SELECT CAST(SUM(CASE WHEN T3.gender = 'Female' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM superhero AS T1 INNER JOIN publisher AS T2 ON T1.publisher_id = T2.id INNER JOIN gender AS T3 ON T3.id = T1.gender_id WHERE T2.publisher_name = 'George Lucas'
SELECT CAST(SUM(CASE WHEN T2.alignment = 'good' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM superhero AS T1 INNER JOIN alignment AS T2 ON T1.alignment_id = T2.id
SELECT COUNT(superhero.id) FROM superhero WHERE superhero_name LIKE 'John%';
SELECT hero_id FROM hero_attribute ORDER BY attribute_value ASC LIMIT 1
SELECT full_name FROM superhero WHERE superhero_name = 'Alien';
SELECT superhero.full_name FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.weight_kg < 100 AND colour.colour = 'brown';
SELECT attribute.attribute_value FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE superhero.superhero_name = 'Aquababy';
SELECT weight_kg, race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.id = 40;
SELECT AVG(height_cm)  FROM superhero  WHERE alignment_id = (SELECT id FROM alignment WHERE alignment = 'Neutral');
SELECT superhero.id FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Intelligence';
SELECT colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.superhero_name = 'Blackwulf';
SELECT superpower.power_name FROM superpower INNER JOIN hero_power ON superpower.id = hero_power.power_id INNER JOIN superhero ON hero_power.hero_id = superhero.id WHERE superhero.height_cm > (SELECT AVG(height_cm) * 0.8 FROM superhero);
SELECT driverref FROM qualifying WHERE raceid = 18 AND position = 1
SELECT drivers.surname FROM     drivers JOIN     laptimes ON drivers.driverid = laptimes.driverid JOIN     races ON races.raceid = laptimes.raceid JOIN     qualifying ON qualifying.driverid = laptimes.driverid AND qualifying.raceid = races.raceid WHERE     races.raceid = 19     AND qualifying.q2 = (         SELECT            MIN(q2)         FROM             qualifying         WHERE             raceid = 19     )
SELECT DISTINCT races.year FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.location = 'Shanghai';
SELECT races.url FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Circuit de Barcelona-Catalunya';
SELECT T1.Name FROM circuits AS T1 INNER JOIN races AS T2 ON T1.CircuitID = T2.CircuitID WHERE T1.Country = 'Germany'
SELECT position FROM circuits JOIN races ON circuits.circuitid = races.circuitid JOIN constructorresults ON races.raceid = constructorresults.raceid JOIN constructors ON constructorresults.constructorid = constructors.constructorid WHERE constructors.name = 'Renault';
SELECT COUNT(races.raceid) FROM races JOIN circuits ON races.circuitid = circuits.circuitid JOIN seasons ON races.year = seasons.year WHERE races.year = 2010 AND circuits.country NOT IN ('Asia', 'Europe');
SELECT races.name FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.country = 'Spain';
SELECT `circuits.lat`, `circuits.lng` FROM   circuits JOIN   races ON circuits.circuitid = races.circuitid JOIN   seasons ON races.year = seasons.year WHERE   races.name = 'Australian Grand Prix';
SELECT url FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Sepang International Circuit';
SELECT races.time FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Sepang International Circuit';
SELECT lat, lng FROM circuits WHERE name = 'Abu Dhabi Grand Prix';
SELECT T1.Country FROM Constructors AS T1 INNER JOIN ConstructorResults AS T2 ON T1.ConstructorID = T2.ConstructorID WHERE T2.RaceID = 24 AND T2.Points = 1
SELECT q1 FROM     qualifying JOIN     drivers ON qualifying.driverid = drivers.driverid JOIN     races ON qualifying.raceid = races.raceid WHERE     drivers.forename = 'Bruno'     AND drivers.surname = 'Senna'     AND races.raceid = 354;
SELECT drivers.nationality FROM qualifying JOIN drivers ON qualifying.driverid = drivers.driverid WHERE qualifying.q2 = '0:01:40' AND qualifying.raceid = 355;
SELECT drivers.number FROM qualifying JOIN drivers ON qualifying.driverid = drivers.driverid WHERE qualifying.position = 1 AND qualifying.q3 = '0:01:54' AND qualifying.raceid = 903;
SELECT COUNT(*) FROM races JOIN results ON races.raceid = results.raceid JOIN status ON results.statusid = status.statusid WHERE races.name = 'Bahrain Grand Prix' AND races.year = 2007 AND status.status != 'Finished'
SELECT seasons.year, seasons.url FROM races JOIN seasons ON races.year = seasons.year WHERE races.raceid = 901;
SELECT COUNT(DISTINCT results.driverid) AS finished_drivers FROM     races JOIN     results ON races.raceid = results.raceid WHERE     races.date = '2015-11-29'     AND results.time IS NOT NULL;
SELECT drivers.forename, drivers.surname, drivers.dob FROM results JOIN drivers ON results.driverid = drivers.driverid WHERE results.raceid = 592 AND results.time IS NOT NULL ORDER BY drivers.dob ASC LIMIT 1;
SELECT drivers.forename || ' ' || drivers.surname AS driver_name, drivers.url AS introduction_website FROM drivers JOIN laptimes ON drivers.driverid = laptimes.driverid WHERE laptimes.raceid = 161 AND laptimes.time = '0:01:27';
SELECT drivers.nationality FROM     drivers INNER JOIN     results ON results.driverid = drivers.driverid INNER JOIN     races ON results.raceid = races.raceid WHERE     races.raceid = 933 AND     results.fastestlapspeed = (         SELECT            MAX(fastestlapspeed)         FROM             results         WHERE             raceid = 933     );
SELECT lat, lng FROM circuits WHERE name = 'Sepang'
SELECT T2.Url FROM constructorstandings AS T1 INNER JOIN constructors AS T2 ON T1.ConstructorID = T2.ConstructorID WHERE T1.RaceID = 9 ORDER BY T1.Points DESC LIMIT 1
SELECT q1 FROM     qualifying WHERE     raceid = 345     AND driverid = (SELECT driverid FROM drivers WHERE forename = 'Lucas' AND surname = 'di Grassi');
SELECT drivers.nationality FROM qualifying JOIN races ON qualifying.raceid = races.raceid JOIN drivers ON qualifying.driverid = drivers.driverid WHERE races.raceid = 347 AND qualifying.q2 = '0:01:15';
SELECT drivers.code FROM     drivers JOIN     qualifying ON drivers.driverid = qualifying.driverid JOIN     races ON qualifying.raceid = races.raceid WHERE     races.raceid = 45     AND qualifying.q3 = '0:01:33';
SELECT time FROM results WHERE raceid = 743 AND driverid = (SELECT driverid FROM drivers WHERE forename = 'Bruce' AND surname = 'McLaren');
SELECT drivers.forename, drivers.surname FROM     races     INNER JOIN results ON races.raceid = results.raceid     INNER JOIN drivers ON results.driverid = drivers.driverid WHERE     races.name = 'San Marino Grand Prix' AND     races.year = 2006 AND     results.position = 2;
SELECT seasons.year, seasons.url FROM races JOIN seasons ON races.year = seasons.year WHERE races.raceid = 901;
SELECT COUNT(results.position) AS finished_drivers FROM results JOIN races ON results.raceid = races.raceid WHERE races.date = '2015-11-29'
SELECT drivers.forename, drivers.surname, drivers.dob FROM results JOIN drivers ON results.driverid = drivers.driverid WHERE results.raceid = 872 AND results.time IS NOT NULL ORDER BY drivers.dob DESC LIMIT 1;
SELECT drivers.forename , drivers.surname FROM laptimes join drivers on laptimes.driverid = drivers.driverid WHERE laptimes.raceid = 348 ORDER BY laptimes.time ASC LIMIT 1
SELECT drivers.nationality FROM drivers JOIN results ON drivers.driverid = results.driverid WHERE results.fastestlapspeed = (     SELECT MAX(fastestlapspeed)     FROM results )
SELECT CAST(T1.FastestLapSpeed - T2.FastestLapSpeed AS REAL) * 100 / T2.FastestLapSpeed FROM results AS T1 INNER JOIN results AS T2 ON T1.RaceID = 853 AND T2.RaceID = 854 WHERE T1.DriverID = ( SELECT DriverID FROM drivers WHERE Forename = 'Paul' AND Surname = 'di Resta' )
SELECT CAST(COUNT(T1.DriverID) AS REAL) * 100 / COUNT(DISTINCT T2.DriverID) FROM results AS T1 INNER JOIN drivers AS T2 ON T1.DriverID = T2.DriverID WHERE T1.RaceID = ( SELECT RaceID FROM races WHERE Date = '1983-07-16' )
SELECT MIN(year) AS "First Singapore Grand Prix Year" FROM races WHERE name = 'Singapore Grand Prix';
SELECT COUNT(*) FROM races WHERE year = 2005;  SELECT name FROM races WHERE year = 2005 ORDER BY date DESC;
SELECT MIN(date) AS first_race_date FROM races;
SELECT races.name, races.date FROM     races JOIN     seasons ON races.year = seasons.year WHERE     seasons.year = 1999     AND races.round = (         SELECT MAX(round) FROM races WHERE year = 1999     );
SELECT year FROM races GROUP BY year ORDER BY COUNT ( * ) DESC LIMIT 1
SELECT name FROM races WHERE year = 2017 AND circuitid NOT IN (SELECT circuitid FROM races WHERE year = 2000);
SELECT country, name, location FROM circuits WHERE circuitid = ( SELECT circuitid FROM races WHERE name = 'European Grand Prix' )
SELECT T2.Year FROM circuits AS T1 INNER JOIN races AS T2 ON T1.CircuitID = T2.CircuitID WHERE T1.Name = 'Brands Hatch' AND T2.Name = 'British Grand Prix' ORDER BY T2.Year DESC LIMIT 1
SELECT COUNT(DISTINCT seasons.year) FROM     races JOIN circuits ON races.circuitid = circuits.circuitid JOIN seasons ON races.year = seasons.year WHERE     circuits.name = 'Silverstone Circuit' AND races.name = 'British Grand Prix';
SELECT drivers.forename, drivers.surname FROM     drivers JOIN     driverstandings ON drivers.driverid = driverstandings.driverid JOIN     races ON driverstandings.raceid = races.raceid JOIN     circuits ON races.circuitid = circuits.circuitid JOIN     seasons ON races.year = seasons.year WHERE     circuits.name = 'Marina Bay Street Circuit' AND seasons.year = 2010 ORDER BY     driverstandings.position;
SELECT drivers.forename , drivers.surname FROM driverstandings join drivers on driverstandings.driverid = drivers.driverid ORDER BY driverstandings.points DESC LIMIT 1
SELECT drivers.forename , drivers.surname , driverstandings.points FROM driverstandings join races on driverstandings.raceid = races.raceid join drivers on driverstandings.driverid = drivers.driverid WHERE races.year = 2017 and races.name = 'Chinese Grand Prix' ORDER BY driverstandings.points DESC LIMIT 3
SELECT T1.DriverID, T2.Name FROM laptimes AS T1 INNER JOIN races AS T2 ON T1.RaceID = T2.RaceID ORDER BY T1.Time ASC LIMIT 1
SELECT AVG(laptimes.time)  FROM      laptimes      JOIN races ON laptimes.raceid = races.raceid     JOIN drivers ON laptimes.driverid = drivers.driverid WHERE      drivers.forename = 'Sebastian' AND drivers.surname = 'Vettel'     AND races.year = 2009      AND races.name = 'Chinese Grand Prix';
SELECT CAST(SUM(CASE WHEN T1.Name = 'Hamilton' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.Name) FROM drivers AS T1 INNER JOIN driverstandings AS T2 ON T1.DriverID = T2.DriverID WHERE T2.RaceID IN ( SELECT RaceID FROM races WHERE Year > 2010 )
SELECT drivers.forename , drivers.surname , AVG ( results.points ) FROM results join drivers on results.driverid = drivers.driverid WHERE results.position = 1 GROUP BY results.driverid
SELECT MIN(2022 - strftime('%Y', dob) + 1) AS "Age", forename || ' ' || surname AS "Name" FROM drivers WHERE nationality = 'Japanese'
SELECT DISTINCT circuits.name FROM     circuits JOIN races ON circuits.circuitid = races.circuitid JOIN seasons ON races.year = seasons.year WHERE seasons.year BETWEEN 1990 AND 2000 GROUP BY circuits.name HAVING COUNT(DISTINCT races.raceid) = 4;
SELECT circuits.name, circuits.location, races.name AS race_name FROM circuits JOIN races ON circuits.circuitid = races.circuitid JOIN seasons ON races.year = seasons.year WHERE circuits.country = 'USA' AND seasons.year = 2006;
SELECT races.name, circuits.name, circuits.location FROM races JOIN circuits ON races.circuitid = circuits.circuitid JOIN seasons ON races.year = seasons.year WHERE strftime('%m', races.date) = '09' AND races.year = 2005;
SELECT races.name FROM races JOIN results ON races.raceid = results.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Alex' AND drivers.surname = 'Yoong' AND results.position < 10;
SELECT COUNT(results.position) AS win_count FROM     results JOIN races ON results.raceid = races.raceid JOIN circuits ON races.circuitid = circuits.circuitid JOIN drivers ON results.driverid = drivers.driverid WHERE     drivers.surname = 'Schumacher'     AND circuits.name = 'Sepang International Circuit'     AND results.position = 1;
SELECT races.name, races.year FROM     races JOIN     results ON races.raceid = results.raceid JOIN     drivers ON results.driverid = drivers.driverid WHERE     drivers.forename = 'Michael' AND drivers.surname = 'Schumacher' ORDER BY     results.fastestlaptime ASC LIMIT 1;
SELECT AVG(results.points) AS average_points FROM     results JOIN     drivers ON results.driverid = drivers.driverid JOIN     races ON results.raceid = races.raceid WHERE     drivers.forename = 'Eddie' AND drivers.surname = 'Irvine'     AND races.year = 2000;
SELECT MIN(races.date) AS "First Race Date", results.points AS "Points Recorded" FROM drivers JOIN results ON drivers.driverid = results.driverid JOIN races ON results.raceid = races.raceid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton'
SELECT races.name, circuits.country FROM races JOIN circuits ON races.circuitid = circuits.circuitid JOIN seasons ON races.year = seasons.year WHERE races.year = 2017 ORDER BY races.date;
SELECT T1.Name, T1.Year, T2.Location FROM races AS T1 INNER JOIN circuits AS T2 ON T1.CircuitID = T2.CircuitID ORDER BY T1.Laps DESC LIMIT 1
SELECT CAST(COUNT(CASE WHEN T1.Country = 'Germany' THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T1.Country) FROM circuits AS T1 INNER JOIN races AS T2 ON T1.CircuitID = T2.CircuitID WHERE T2.Name = 'European Grand Prix'
SELECT Lat, Lng FROM circuits WHERE Name = 'Silverstone'
SELECT CASE WHEN MAX(Lat) THEN 'Silverstone Circuit' WHEN MAX(Lat) THEN 'Hockenheimring' WHEN MAX(Lat) THEN 'Hungaroring' END FROM circuits
SELECT circuits.circuitref FROM circuits WHERE circuits.name = 'Marina Bay Street Circuit';
SELECT country FROM circuits ORDER BY alt DESC LIMIT 1
SELECT COUNT(*) FROM drivers WHERE code IS NULL;
SELECT MIN(drivers.dob) AS oldest_dob, drivers.nationality AS oldest_driver_nationality FROM drivers;
SELECT surname FROM drivers WHERE nationality = 'Italian';
SELECT `url`   FROM   `drivers`   WHERE   `forename` = 'Anthony' AND `surname` = 'Davidson';
SELECT driverref FROM drivers WHERE forename = 'Lewis' AND surname = 'Hamilton';
SELECT circuits.name FROM races JOIN circuits ON races.circuitid = circuits.circuitid JOIN seasons ON races.year = seasons.year WHERE races.name = 'Spanish Grand Prix' AND seasons.year = 2009;
SELECT DISTINCT year FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Silverstone Circuit';
SELECT races.name, races.date, races.time, races.url FROM races INNER JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Silverstone Circuit';
SELECT T2.Time FROM circuits AS T1 INNER JOIN races AS T2 ON T1.CircuitID = T2.CircuitID WHERE T1.Name = 'Abu Dhabi' AND T2.Year = 2010
SELECT COUNT(races.raceid) FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.country = 'Italy';
SELECT DISTINCT date FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Barcelona-Catalunya';
SELECT circuits.url FROM races INNER JOIN circuits ON races.circuitid = circuits.circuitid INNER JOIN seasons ON races.year = seasons.year WHERE races.name = 'Spanish Grand Prix' AND seasons.year = 2009
SELECT MIN(results.fastestlaptime) AS fastest_lap_time FROM     results JOIN     drivers ON results.driverid = drivers.driverid WHERE     drivers.surname = 'Hamilton' AND drivers.forename = 'Lewis';
SELECT drivers.forename, drivers.surname FROM     drivers JOIN     results ON drivers.driverid = results.driverid WHERE     fastestlapspeed = (         SELECT            MAX(fastestlapspeed)         FROM             results         WHERE             fastestlapspeed IS NOT NULL             AND fastestlapspeed != ''     ) AND     results.raceid IN (         SELECT            raceid         FROM             races         WHERE             races.name LIKE '%Formula_1%'     );
SELECT drivers.driverref FROM     drivers JOIN     results ON drivers.driverid = results.driverid JOIN     races ON results.raceid = races.raceid WHERE     races.name = 'Australian Grand Prix' AND races.year = 2008 AND results.positionorder = 1;
SELECT races.name FROM races JOIN results ON races.raceid = results.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton';
SELECT raceid, name FROM     races WHERE     raceid = (         SELECT            raceid         FROM             results         WHERE             driverid = (                 SELECT                    driverid                 FROM                     drivers                 WHERE                     forename = 'Lewis' AND surname = 'Hamilton'             )         ORDER BY             positionorder ASC         LIMIT 1     );
SELECT MAX(fastestlapspeed) AS fastest_lap_speed FROM results JOIN races ON results.raceid = races.raceid WHERE races.year = 2009 AND races.name = 'Spanish Grand Prix';
SELECT DISTINCT year FROM races JOIN results ON races.raceid = results.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE forename = 'Lewis' AND surname = 'Hamilton';
SELECT results.positionOrder FROM     results JOIN races ON results.raceid = races.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE     drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton'     AND races.year = 2008     AND races.name = 'Australian Grand Prix';
SELECT drivers.forename, drivers.surname FROM     races     INNER JOIN results ON races.raceid = results.raceid     INNER JOIN drivers ON results.driverid = drivers.driverid WHERE     races.name = 'Australian Grand Prix'     AND races.year = 2008     AND results.grid = 4;
SELECT COUNT(DISTINCT results.driverid) FROM races JOIN results ON races.raceid = results.raceid WHERE races.year = 2008 AND races.name = 'Australian Grand Prix' AND results.time IS NOT NULL;
SELECT laptimes.time FROM     laptimes JOIN     races ON laptimes.raceid = races.raceid JOIN     drivers ON laptimes.driverid = drivers.driverid WHERE     drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton'     AND races.name = 'Australian Grand Prix' AND races.year = 2008 ORDER BY     laptimes.milliseconds LIMIT     1;
SELECT T1.Time FROM results AS T1 INNER JOIN races AS T2 ON T1.RaceID = T2.RaceID WHERE T2.Name = 'Australian Grand Prix' AND T2.Year = 2008 AND T1.Position = 2
SELECT drivers.forename, drivers.surname, drivers.url FROM driverstandings JOIN drivers ON driverstandings.driverid = drivers.driverid JOIN races ON driverstandings.raceid = races.raceid JOIN seasons ON races.year = seasons.year WHERE races.name = 'Australian Grand Prix' AND seasons.year = 2008 AND driverstandings.position = 1;
SELECT COUNT(DISTINCT drivers.driverid) FROM     drivers JOIN     driverstandings ON drivers.driverid = driverstandings.driverid JOIN     races ON driverstandings.raceid = races.raceid JOIN     circuits ON races.circuitid = circuits.circuitid WHERE     drivers.nationality = 'American'     AND races.year = 2008     AND circuits.country = 'Australia'     AND races.name = 'Australian Grand Prix';
SELECT COUNT(DISTINCT drivers.driverid) FROM drivers JOIN results ON drivers.driverid = results.driverid JOIN races ON results.raceid = races.raceid WHERE races.year = 2008 AND races.name = 'Australian Grand Prix' AND results.time IS NOT NULL;
SELECT SUM(results.points) AS total_points FROM     results JOIN     drivers ON results.driverid = drivers.driverid WHERE     drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton';
SELECT AVG(strftime('%s', fastestlaptime) - strftime('%s', '00:00.000')) FROM results JOIN races ON results.raceid = races.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton'
SELECT CAST(COUNT(CASE WHEN T1.Laps = T1.Grid THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T1.DriverID) FROM results AS T1 INNER JOIN races AS T2 ON T1.RaceID = T2.RaceID WHERE T2.Name = 'Australian Grand Prix' AND T2.Year = 2008
SELECT CAST(T1.Time - T3.Time AS REAL) * 100 / T3.Time FROM laptimes AS T1 INNER JOIN results AS T2 ON T1.DriverID = T2.DriverID INNER JOIN races AS T3 ON T1.RaceID = T3.RaceID WHERE T3.Name = 'Australian Grand Prix' AND T3.Year = 2008 AND T2.Position = 1 OR T2.Position = 20
SELECT COUNT(*) FROM circuits WHERE location = 'Melbourne' AND country = 'Australia';
SELECT circuits.lat, circuits.lng FROM circuits WHERE circuits.country = 'USA';
SELECT COUNT(*) FROM drivers WHERE nationality = 'British' AND strftime('%Y', dob) > '1980';
SELECT AVG(constructorresults.points) AS average_points FROM     constructorresults JOIN constructors ON constructorresults.constructorid = constructors.constructorid WHERE     constructors.nationality = 'British'
SELECT Name FROM constructors ORDER BY points DESC LIMIT 1
SELECT constructors.name FROM constructors LEFT JOIN constructorresults ON constructors.constructorid = constructorresults.constructorid LEFT JOIN races ON constructorresults.raceid = races.raceid WHERE races.raceid = 291 AND constructorresults.points IS NULL;
SELECT COUNT(DISTINCT constructors.constructorid)  FROM constructors LEFT JOIN constructorresults ON constructors.constructorid = constructorresults.constructorid LEFT JOIN races ON constructorresults.raceid = races.raceid LEFT JOIN seasons ON races.year = seasons.year WHERE seasons.year IN (     SELECT races.year     FROM races     GROUP BY races.year     HAVING COUNT(races.raceid) = 2 ) AND constructors.nationality = 'Japanese' AND constructorresults.points = 0;
SELECT constructors.name FROM constructorstandings JOIN constructors ON constructorstandings.constructorid = constructors.constructorid WHERE constructorstandings.position = 1
SELECT COUNT(DISTINCT constructors.constructorid) FROM     constructors JOIN     constructorresults ON constructors.constructorid = constructorresults.constructorid JOIN     races ON constructorresults.raceid = races.raceid JOIN     circuits ON races.circuitid = circuits.circuitid WHERE     circuits.country = 'France'     AND races.year > 50;
SELECT CAST(COUNT(CASE WHEN T1.Nationality = 'Japanese' THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T1.DriverID) FROM drivers AS T1 INNER JOIN results AS T2 ON T1.DriverID = T2.DriverID WHERE T2.Year BETWEEN 2007 AND 2009
SELECT AVG(SUBSTR(results.time, 1, 2) * 3600 + SUBSTR(results.time, 4, 2) * 60 + SUBSTR(results.time, 7, 2) + SUBSTR(results.time, 10) / 1000) FROM results JOIN races ON results.raceid = races.raceid JOIN seasons ON races.year = seasons.year JOIN driverstandings ON results.raceid = driverstandings.raceid AND results.driverid = driverstandings.driverid WHERE driverstandings.position = 1 AND results.time IS NOT NULL GROUP BY races.year;
SELECT forename, surname FROM     drivers WHERE     dob > '1975-01-01' AND     driverid IN (         SELECT            driverid         FROM             driverstandings         WHERE             position = 2     );
SELECT COUNT(*) AS italian_drivers_dnf FROM drivers WHERE nationality = 'Italian' AND driverid NOT IN (     SELECT driverid     FROM results     WHERE time IS NULL );
SELECT drivers.forename, drivers.surname FROM     drivers INNER JOIN     laptimes ON drivers.driverid = laptimes.driverid WHERE     laptimes.milliseconds = (         SELECT            MIN(milliseconds)         FROM             laptimes     );
SELECT MAX(laptimes.lap) FROM     laptimes JOIN     driverstandings ON laptimes.driverid = driverstandings.driverid JOIN     races ON laptimes.raceid = races.raceid JOIN     seasons ON races.year = seasons.year WHERE     driverstandings.position = 1     AND seasons.year = 2009
SELECT AVG(fastestlapspeed) FROM races JOIN results ON races.raceid = results.raceid WHERE races.name = 'Spanish Grand Prix' AND races.year = 2009;
SELECT races.name, races.year FROM races INNER JOIN results ON races.raceid = results.raceid WHERE results.milliseconds IS NOT NULL ORDER BY results.milliseconds ASC LIMIT 1;
SELECT CAST(COUNT(CASE WHEN T1.DOB < '1985-01-01' THEN T1.driverID ELSE NULL END) AS REAL) * 100 / COUNT(T1.driverID) FROM drivers AS T1 INNER JOIN laptimes AS T2 ON T1.driverID = T2.driverID WHERE T2.lap > 50 AND T2.raceID BETWEEN 2000 AND 2005
SELECT COUNT(*) FROM drivers JOIN laptimes ON drivers.driverid = laptimes.driverid WHERE drivers.nationality = 'French' AND laptimes.time < '02:00.00';
SELECT drivers.code FROM drivers WHERE drivers.nationality = 'American';
SELECT raceid FROM races WHERE year = 2009;
SELECT COUNT(DISTINCT driverid) AS participants FROM results WHERE raceid = 18;
SELECT code FROM drivers ORDER BY strftime('%Y', dob) DESC LIMIT 3; 
SELECT COUNT(code) FROM drivers WHERE nationality = 'Netherlands'
SELECT drivers.driverref FROM drivers WHERE drivers.forename = 'Robert' AND drivers.surname = 'Kubica';
SELECT COUNT(*) FROM drivers WHERE nationality = 'Australian' AND strftime('%Y', dob) = '1980';
SELECT forename, surname FROM drivers WHERE nationality = 'German' AND dob BETWEEN '1980-01-01' AND '1990-12-31' ORDER BY time LIMIT 3
SELECT driverref FROM drivers WHERE nationality = 'German' AND dob = ( SELECT MAX(DOB) FROM drivers WHERE nationality = 'German' )
SELECT drivers.driverid, drivers.code FROM     drivers JOIN     results ON drivers.driverid = results.driverid JOIN     races ON results.raceid = races.raceid WHERE     strftime('%Y', drivers.dob) = '1971'     AND results.fastestlaptime IS NOT NULL ORDER BY     results.fastestlaptime LIMIT 1;
SELECT T1.Forename, T1.Surname FROM drivers AS T1 INNER JOIN laptimes AS T2 ON T1.DriverID = T2.DriverID WHERE T1.Nationality = 'Spanish' AND T1.DOB < '1982-01-01' ORDER BY T2.Time DESC LIMIT 10
SELECT MAX(races.year) AS fastest_year FROM races JOIN results ON races.raceid = results.raceid WHERE fastestlaptime IS NOT NULL;
SELECT MIN(substr(time, 1, instr(time, ':') - 1)) AS slowest_lap_time FROM laptimes;
SELECT driverid FROM laptimes WHERE lap = 1 ORDER BY time ASC LIMIT 5
SELECT COUNT(T1.DriverID) FROM results AS T1 INNER JOIN races AS T2 ON T1.RaceID = T2.RaceID WHERE T2.Round BETWEEN 50 AND 100 AND T1.Status = 2
SELECT COUNT(circuits.circuitid), circuits.name, circuits.location, circuits.lat, circuits.lng FROM circuits WHERE circuits.country = 'Austria';
SELECT raceid FROM results GROUP BY raceid ORDER BY COUNT ( * ) DESC LIMIT 1
SELECT drivers.driverref, drivers.nationality, drivers.dob FROM qualifying JOIN drivers ON qualifying.driverid = drivers.driverid WHERE qualifying.raceid = 23 AND qualifying.q2 IS NOT NULL;
SELECT T1.Year, T1.Date, T1.Time FROM races AS T1 INNER JOIN qualifying AS T2 ON T1.raceid = T2.raceid INNER JOIN drivers AS T3 ON T2.driverid = T3.driverid ORDER BY T3.DOB LIMIT 1
SELECT COUNT(DISTINCT drivers.driverid) FROM     drivers JOIN     results ON results.driverid = drivers.driverid JOIN     races ON races.raceid = results.raceid JOIN     status ON results.statusid = status.statusid WHERE     nationality = 'American'     AND status.status = 'Disqualified';
SELECT MAX(constructorstandings.points) AS highest_points, constructors.name AS italian_constructor, constructors.url AS introduction_website FROM constructorstandings JOIN constructors ON constructorstandings.constructorid = constructors.constructorid WHERE constructors.nationality = 'Italian'
SELECT constructors.url FROM   constructors JOIN   (     SELECT      constructorid,       SUM(wins) AS total_wins     FROM       constructorstandings     GROUP BY       constructorid     ORDER BY       total_wins DESC     LIMIT 1   ) AS top_constructor ON   constructors.constructorid = top_constructor.constructorid;
SELECT drivers.forename, drivers.surname, MAX(laptimes.time) AS slowest_time FROM laptimes JOIN races ON laptimes.raceid = races.raceid JOIN drivers ON laptimes.driverid = drivers.driverid WHERE races.name = 'French Grand Prix' AND laptimes.lap = 3;
SELECT T1.RaceID, T1.Milliseconds FROM laptimes AS T1 INNER JOIN results AS T2 ON T1.RaceID = T2.RaceID WHERE T1.Lap = 1 ORDER BY T1.Time ASC LIMIT 1
SELECT AVG(fastestlaptime) FROM   (SELECT fastestlaptime    FROM results    WHERE raceid IN          (SELECT raceid           FROM races           WHERE name = 'United States Grand Prix' AND year = 2006)      AND rank < 11);
SELECT T1.Forename, T1.Surname FROM drivers AS T1 INNER JOIN pitstops AS T2 ON T1.DriverID = T2.DriverID WHERE T1.Nationality = 'German' AND T1.DOB BETWEEN '1980-01-01' AND '1985-12-31' ORDER BY T2.Duration ASC LIMIT 5
SELECT drivers.forename || ' ' || drivers.surname AS champion, results.time AS finish_time FROM results JOIN races ON results.raceid = races.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE races.name = 'Canadian Grand Prix' AND races.year = 2008 AND results.position = 1;
SELECT T1.ConstructorRef, T1.Url FROM Constructors AS T1 INNER JOIN ConstructorStandings AS T2 ON T1.ConstructorId = T2.ConstructorId WHERE T2.RaceId = ( SELECT RaceId FROM ConstructorStandings WHERE Year = 2009 AND Position = 1 )
SELECT forename , surname , dob FROM drivers WHERE nationality = 'Austrian' AND dob BETWEEN '1981-01-01' AND '1991-12-31'
SELECT drivers.forename || ' ' || drivers.surname AS full_name, drivers.url AS wikipedia_page, drivers.dob AS date_of_birth FROM drivers WHERE drivers.nationality = 'German' AND strftime('%Y', drivers.dob) BETWEEN '1971' AND '1985' ORDER BY drivers.dob DESC;
SELECT c.location, c.country, c.lat, c.lng FROM circuits c WHERE c.name = 'Hungaroring';
SELECT constructorstandings.constructorid, SUM(constructorstandings.points) AS total_points, constructors.name, constructors.nationality FROM constructorstandings JOIN constructors ON constructorstandings.constructorid = constructors.constructorid JOIN races ON constructorstandings.raceid = races.raceid WHERE races.name = 'Monaco Grand Prix' AND races.year BETWEEN 1980 AND 2010 GROUP BY constructorstandings.constructorid ORDER BY total_points DESC LIMIT 1;
SELECT AVG(results.points) AS average_score FROM     results JOIN races ON results.raceid = races.raceid JOIN drivers ON results.driverid = drivers.driverid JOIN circuits ON races.circuitid = circuits.circuitid WHERE     circuits.country = 'Turkey'     AND drivers.surname = 'Hamilton';
SELECT CAST(COUNT(T1.RaceID) AS REAL) / 10 FROM races AS T1 INNER JOIN seasons AS T2 ON T1.Year = T2.Year WHERE T2.Year BETWEEN 2000 AND 2009
SELECT MAX(nationality) AS majority_citizenship FROM drivers;
SELECT COUNT(driverstandings.wins) AS "Number of Victories" FROM driverstandings WHERE driverstandings.position = 91;
SELECT T1.Name FROM races AS T1 INNER JOIN results AS T2 ON T1.RaceID = T2.RaceID ORDER BY T2.FastestLapSpeed DESC LIMIT 1
SELECT circuits.name || ', ' || circuits.location || ', ' || circuits.country AS "Full Location" FROM     circuits JOIN     races ON races.circuitid = circuits.circuitid WHERE     races.date = (SELECT MAX(date) FROM races);
SELECT drivers.forename || ' ' || drivers.surname AS full_name FROM     drivers     JOIN qualifying ON drivers.driverid = qualifying.driverid     JOIN races ON qualifying.raceid = races.raceid     JOIN circuits ON races.circuitid = circuits.circuitid WHERE     races.year = 2008     AND circuits.name = 'Marina Bay Street Circuit'     AND qualifying.q3 = (SELECT MIN(q3) FROM qualifying WHERE raceid = races.raceid)     AND qualifying.position = 1;
SELECT drivers.forename , drivers.surname , races.name , drivers.nationality FROM races join results on races.raceid = results.raceid join drivers on results.driverid = drivers.driverid WHERE results.year = 2017 ORDER BY drivers.dob DESC LIMIT 1
SELECT COUNT(*) AS num_accidents FROM     results JOIN     races ON results.raceid = races.raceid JOIN     status ON results.statusid = status.statusid WHERE     races.name = 'Canadian Grand Prix'     AND status.status = 'Accident' GROUP BY     results.driverid ORDER BY     COUNT(*) DESC LIMIT 1;
SELECT MAX(wins), forename || ' ' || surname AS oldest_racer_name FROM driverstandings JOIN drivers ON driverstandings.driverid = drivers.driverid WHERE dob = (SELECT MIN(dob) FROM drivers);
SELECT MAX(duration)  FROM pitstops;
SELECT MAX(milliseconds) AS fastest_lap_time FROM laptimes;
SELECT MAX(duration) FROM pitstops JOIN drivers ON pitstops.driverid = drivers.driverid WHERE drivers.surname = 'Hamilton';
SELECT lap FROM pitstops WHERE driverid = ( SELECT driverid FROM drivers WHERE forename = 'Lewis' AND surname = 'Hamilton' ) AND raceid = ( SELECT raceid FROM races WHERE name = 'Australian Grand Prix' AND year = 2011 )
SELECT pitstops.time FROM     pitstops JOIN races ON pitstops.raceid = races.raceid JOIN drivers ON pitstops.driverid = drivers.driverid JOIN races ON races.year = 2011 AND races.name = 'Australian Grand Prix';
SELECT MAX(milliseconds) AS lap_record FROM     laptimes JOIN     drivers ON laptimes.driverid = drivers.driverid JOIN     races ON laptimes.raceid = races.raceid WHERE     drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton'     AND races.name LIKE 'Formula_1%'     AND milliseconds != 0;
SELECT drivers.forename , drivers.surname FROM laptimes join drivers on laptimes.driverid = drivers.driverid ORDER BY laptimes.time ASC LIMIT 1
SELECT circuits.name, results.position FROM circuits JOIN races ON circuits.circuitid = races.circuitid JOIN results ON races.raceid = results.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' AND results.fastestlaptime = (     SELECT MIN(fastestlaptime)     FROM results     WHERE driverid = drivers.driverid     AND fastestlaptime IS NOT NULL ) AND results.positionorder = 1;
SELECT MIN(milliseconds) AS lap_record FROM laptimes JOIN races ON laptimes.raceid = races.raceid JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Austrian Grand Prix Circuit';
SELECT MIN(milliseconds) AS lap_record_time FROM     laptimes     JOIN races ON laptimes.raceid = races.raceid     JOIN circuits ON races.circuitid = circuits.circuitid WHERE     circuits.country = 'Italy' GROUP BY     circuits.name;
SELECT raceid FROM laptimes WHERE raceid IN ( SELECT raceid FROM races WHERE name = 'Austrian Grand Prix' ) ORDER BY milliseconds ASC LIMIT 1
SELECT T2.Time FROM races AS T1 INNER JOIN pitstops AS T2 ON T1.RaceID = T2.RaceID INNER JOIN circuits AS T3 ON T1.CircuitID = T3.CircuitID WHERE T3.Name = 'Austrian Grand Prix' AND T2.Lap = 1
SELECT circuits.lat, circuits.lng FROM circuits INNER JOIN races ON races.circuitid = circuits.circuitid INNER JOIN laptimes ON laptimes.raceid = races.raceid WHERE laptimes.time = '1:29.488';
SELECT AVG(pitstops.duration) AS average_pitstop_time FROM     drivers JOIN     pitstops ON drivers.driverid = pitstops.driverid JOIN     races ON pitstops.raceid = races.raceid JOIN     results ON drivers.driverid = results.driverid AND races.raceid = results.raceid WHERE     drivers.surname = 'Hamilton'
SELECT AVG(laptimes.milliseconds) FROM     laptimes JOIN     races ON laptimes.raceid = races.raceid JOIN     circuits ON races.circuitid = circuits.circuitid WHERE     circuits.country = 'Italy';
SELECT player_api_id FROM player_attributes WHERE overall_rating = (     SELECT MAX(overall_rating)     FROM player_attributes )
SELECT player.player_name, MAX(player.height) AS tallest_player_height FROM player;
SELECT preferred_foot FROM player_attributes ORDER BY potential ASC LIMIT 1
SELECT COUNT(*) AS num_players FROM player_attributes WHERE overall_rating >= 60 AND overall_rating < 65 AND defensive_work_rate = 'low';
SELECT player_api_id FROM player_attributes ORDER BY crossing DESC LIMIT 5;
SELECT league.name FROM     league JOIN     match ON league.id = match.league_id WHERE     match.season = '2015/2016' GROUP BY     league.id ORDER BY     SUM(home_team_goal + away_team_goal) DESC LIMIT 1;
SELECT T1.team_long_name FROM team AS T1 INNER JOIN match AS T2 ON T1.team_api_id = T2.home_team_api_id WHERE T2.season = 2016 GROUP BY T1.team_long_name ORDER BY COUNT(T2.home_team_goal) ASC LIMIT 1
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id ORDER BY player_attributes.penalties DESC LIMIT 10;
SELECT T2.team_api_id FROM match AS T1 INNER JOIN team AS T2 ON T1.away_team_api_id = T2.team_api_id INNER JOIN league AS T3 ON T1.league_id = T3.id WHERE T3.name = 'Scotland Premier League' AND T1.season = 2010 GROUP BY T2.team_api_id ORDER BY COUNT(T1.away_team_goal) DESC LIMIT 1
SELECT T2.BuildUpPlaySpeed FROM Team AS T1 INNER JOIN Team_Attributes AS T2 ON T1.team_api_id = T2.team_api_id ORDER BY T2.BuildUpPlaySpeed DESC LIMIT 4
SELECT league.name FROM     match JOIN     league ON match.league_id = league.id WHERE     match.season = '2015/2016' GROUP BY     match.league_id ORDER BY     SUM(CASE WHEN match.home_team_goal = match.away_team_goal THEN 1 ELSE 0 END) DESC LIMIT 1;
SELECT ROUND((julianday('now') - julianday(player.birthday)) / 365, 1) AS player_age FROM     player_attributes JOIN     player ON player_attributes.player_api_id = player.player_api_id WHERE     player_attributes.sprint_speed >= 97 AND     player_attributes.date >= '2013-01-01 00:00:00' AND     player_attributes.date <= '2015-12-31 00:00:00';
SELECT league.name, COUNT(match.id) AS num_matches FROM match JOIN league ON match.league_id = league.id GROUP BY league.name ORDER BY num_matches DESC LIMIT 1;
SELECT AVG(height) AS average_height FROM player WHERE birthday >= '1990-01-01 00:00:00' AND birthday < '1996-01-01 00:00:00';
SELECT player_api_id FROM player_attributes WHERE substr(date,1,4) = '2010' GROUP BY player_api_id HAVING overall_rating > (SELECT AVG(overall_rating) FROM player_attributes WHERE substr(date,1,4) = '2010');
SELECT team_fifa_api_id FROM team_attributes WHERE buildupplayspeed BETWEEN 51 AND 59;
SELECT team.team_long_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.date LIKE '2012%'  AND team_attributes.buildUpPlayPassing > (SELECT AVG(buildUpPlayPassing) FROM team_attributes WHERE buildUpPlayPassing IS NOT NULL);
SELECT CAST(SUM(CASE WHEN T1.preferred_foot = 'left' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.player_fifa_api_id) FROM player_attributes AS T1 INNER JOIN player AS T2 ON T1.player_fifa_api_id = T2.player_fifa_api_id WHERE T2.birthday BETWEEN '1987-01-01' AND '1992-12-31'
SELECT league.name AS league_name, SUM(home_team_goal + away_team_goal) AS total_goals FROM match JOIN league ON match.league_id = league.id GROUP BY league_name ORDER BY total_goals ASC LIMIT 5;
SELECT AVG(long_shots) AS average_long_shots FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Ahmed Samir Farag';
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player.height > 180 GROUP BY player.player_name ORDER BY AVG(player_attributes.heading_accuracy) DESC LIMIT 10;
SELECT T1.team_long_name FROM team AS T1 INNER JOIN match AS T2 ON T1.team_api_id = T2.home_team_api_id OR T1.team_api_id = T2.away_team_api_id INNER JOIN team_attributes AS T3 ON T3.team_api_id = T1.team_api_id WHERE T3.buildupplaydribblingclass = 'Normal' AND T2.season = 2014 ORDER BY T2.chancecreationpassing DESC
SELECT league.name FROM     match JOIN     league ON match.league_id = league.id WHERE     match.season = '2009/2010' GROUP BY     match.league_id HAVING     AVG(match.home_team_goal) > AVG(match.away_team_goal);
SELECT team_short_name FROM team WHERE team_long_name = 'Queens Park Rangers';
SELECT player_name FROM player WHERE substr(birthday, 1, 4) = '1970' AND substr(birthday, 6, 2) = '10';
SELECT `attacking_work_rate` FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Franco Zennaro';
SELECT `buildupplaypositioningclass`   FROM   `team_attributes`   JOIN   `team`   ON   `team_attributes`.`team_api_id` = `team`.`team_api_id`   WHERE   `team`.`team_long_name` = 'ADO Den Haag';
SELECT player.player_name, player_attributes.heading_accuracy, player_attributes.finishing FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player.player_name = 'Francois Affolter' AND player_attributes.date = '2014-09-18 00:00:00';
SELECT player_attributes.overall_rating FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Gabriel Tamas' AND strftime('%Y', player_attributes.date) = '2011';
SELECT COUNT(match.id) FROM match JOIN league ON match.league_id = league.id WHERE league.name = 'Scotland Premier League' AND match.season = '2015/2016';
SELECT preferred_foot FROM player ORDER BY birthday DESC LIMIT 1;
SELECT player.player_name FROM player INNER JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.potential = (     SELECT MAX(potential)     FROM player_attributes );
SELECT COUNT(player.player_api_id) FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player.weight < 130 AND player_attributes.attacking_work_rate = 'left';
SELECT team.team_short_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.chancecreationpassingclass = 'Risky';
SELECT player_attributes.defensive_work_rate FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'David Wilson';
SELECT birthday FROM player_attributes ORDER BY overall_rating DESC LIMIT 1
SELECT name FROM league WHERE country_id = (     SELECT id     FROM country     WHERE name = 'Netherlands' );
SELECT AVG(T2.home_team_goal) FROM country AS T1 INNER JOIN match AS T2 ON T2.country_id = T1.id WHERE T1.name = 'Poland' AND T2.season = 2010 AND T2.season = 2011
SELECT T1.player_name FROM player AS T1 INNER JOIN player_attributes AS T2 ON T1.player_api_id = T2.player_api_id WHERE T2.finishing = ( SELECT MAX(finishing) FROM player_attributes ) OR T2.finishing = ( SELECT MIN(finishing) FROM player_attributes )
SELECT player.player_name FROM player WHERE player.height > 180;
SELECT COUNT(*) FROM player WHERE strftime('%Y', birthday) > '1990';
SELECT COUNT(*) FROM player WHERE player_name LIKE 'Adam%' AND weight > 170;
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.overall_rating > 80 AND strftime('%Y', player_attributes.date) BETWEEN '2008' AND '2010';
SELECT `potential` FROM     player JOIN     player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE     player.player_name = 'Aaron Doran';
SELECT player.player_name FROM player INNER JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.preferred_foot = 'left';
SELECT team.team_long_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.buildupplayspeedclass = 'Fast';
SELECT team_attributes.buildupplaypassingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_short_name = 'CLB';
SELECT T2.team_short_name FROM team_attributes AS T1 INNER JOIN team AS T2 ON T1.team_api_id = T2.team_api_id WHERE T1.buildupplaypassing > 70
SELECT AVG(overall_rating) AS average_overall_rating FROM player_attributes INNER JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE strftime('%Y', date) BETWEEN '2010' AND '2015' AND height > 170;
SELECT player_name FROM player ORDER BY height ASC LIMIT 1;
SELECT country.name FROM league JOIN country ON league.country_id = country.id WHERE league.name = 'Italy Serie A';
SELECT team_short_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE buildupplayspeed = 31 AND buildupplaydribbling = 53 AND buildupplaypassing = 32;
SELECT AVG(overall_rating) AS average_overall_rating FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player.player_name = 'Aaron Doran';
SELECT COUNT(match.id) FROM match JOIN league ON match.league_id = league.id WHERE league.name = 'Germany 1. Bundesliga' AND strftime('%Y-%m', match.date) BETWEEN '2008-08' AND '2008-10';
SELECT T1.team_short_name FROM team AS T1 INNER JOIN match AS T2 ON T1.team_api_id = T2.home_team_api_id WHERE T2.home_team_goal = 10
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.balance = (SELECT MAX(balance) FROM player_attributes WHERE potential = 61) AND player_attributes.potential = 61;
SELECT AVG(T1.ball_control) - AVG(T3.ball_control) FROM player AS T1 INNER JOIN player_attributes AS T2 ON T1.player_api_id = T2.player_api_id INNER JOIN player AS T3 ON T3.player_api_id = T2.player_api_id WHERE T1.player_name = 'Abdou Diallo' OR T1.player_name = 'Aaron Appindangoye'
SELECT team_long_name FROM team WHERE team_short_name = 'GEN';
SELECT player_name FROM player WHERE player_name IN ('Aaron Lennon', 'Abdelaziz Barrada') ORDER BY birthday DESC LIMIT 1
SELECT player_name FROM player ORDER BY height DESC LIMIT 1;
SELECT COUNT(*)  FROM player_attributes  WHERE preferred_foot = 'left' AND attacking_work_rate = 'low';
SELECT country.name FROM league JOIN country ON league.country_id = country.id WHERE league.name = 'Belgium Jupiler League';
SELECT name FROM league WHERE country_id = ( SELECT id FROM country WHERE name = 'Germany' )
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.strength = (     SELECT MAX(overall_rating) FROM player_attributes );
SELECT COUNT(*) AS num_defensive_players FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE strftime('%Y', birthday) < '1986' AND defensive_work_rate = 'high';
SELECT player.player_name FROM player join player_attributes on player.player_api_id = player_attributes.player_api_id WHERE player_attributes.crossing = ( SELECT MAX(crossing) FROM player_attributes )
SELECT heading_accuracy FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Ariel Borysiuk';
SELECT COUNT(*)  FROM player_attributes  JOIN player ON player_attributes.player_api_id = player.player_api_id  WHERE player.height > 180 AND player_attributes.volleys > 70;
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.volleys > 70 AND player_attributes.dribbling > 70;
SELECT COUNT(match.id) AS total_matches FROM match JOIN league ON match.league_id = league.id JOIN country ON league.country_id = country.id WHERE match.season = '2008/2009' AND country.name = 'Belgium';
SELECT T1.long_passing FROM player_attributes AS T1 INNER JOIN player AS T2 ON T1.player_fifa_api_id = T2.player_fifa_api_id ORDER BY T2.birthday DESC LIMIT 1
SELECT COUNT(match.id) AS matches_held FROM     match JOIN     league ON match.league_id = league.id WHERE     league.name = 'Belgium Jupiler League'     AND strftime('%Y', match.date) = '2009'     AND strftime('%m', match.date) = '04';
SELECT T2.name FROM match AS T1 INNER JOIN league AS T2 ON T1.league_id = T2.id WHERE T1.season = 2008 AND T2.country_id = 1 ORDER BY T1.id DESC LIMIT 1
SELECT AVG(overall_rating) AS average_overall_rating FROM player_attributes WHERE strftime('%Y', birthday) < '1986';
SELECT CAST(SUM(CASE WHEN T1.player_name = 'Ariel Borysiuk' THEN 1 ELSE 0 END) - SUM(CASE WHEN T1.player_name = 'Paulin Puel' THEN 1 ELSE 0 END) AS REAL) * 100 / SUM(CASE WHEN T1.player_name = 'Paulin Puel' THEN 1 ELSE 0 END) FROM player AS T1 INNER JOIN player_attributes AS T2 ON T1.player_api_id = T2.player_api_id
SELECT AVG(team_attributes.buildupplayspeed) AS average_build_up_play_speed FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'Heart of Midlothian';
SELECT AVG(player_attributes.overall_rating) AS average_overall_rating FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Pietro Marino';
SELECT SUM(player_attributes.crossing) AS total_crossing_score FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Aaron Lennox';
SELECT MAX(chancecreationpassing) AS highest_chance_creation_passing_score, chancecreationpassingclass AS passing_score_classification FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_long_name = 'Ajax';
SELECT preferred_foot FROM player WHERE player_name = 'Abdou Diallo';
SELECT MAX(player_attributes.overall_rating) AS highest_overall_rating FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Dorlan Pabon';
SELECT AVG(away_team_goal) FROM     match JOIN     team ON match.away_team_api_id = team.team_api_id WHERE     team.team_long_name = 'Parma' AND     match.country_id IN (SELECT id FROM country WHERE name = 'Italy');
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.overall_rating = 77 AND player_attributes.date = '2016-06-23' ORDER BY player.birthday ASC LIMIT 1;
SELECT player_attributes.overall_rating FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Aaron Mooy' AND player_attributes.date = '2016-02-04 00:00:00';
SELECT potential FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Francesco Parravicini' AND player_attributes.date = '2010-08-30 00:00:00';
SELECT player_attributes.attacking_work_rate FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Francesco Migliore' AND player_attributes.date = '2015-05-01 00:00:00';
SELECT T1.defensive_work_rate FROM player_attributes AS T1 INNER JOIN player AS T2 ON T1.player_fifa_api_id = T2.player_fifa_api_id WHERE T2.player_name = 'Kevin Berigaud' AND T1.date = '2013-02-22'
SELECT T2.date FROM player AS T1 INNER JOIN player_attributes AS T2 ON T1.player_api_id = T2.player_api_id WHERE T1.player_name = 'Kevin Constant' AND T2.crossing = 90
SELECT team_attributes.buildupplayspeedclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'Willem II' AND team_attributes.date = '2012-02-22 00:00:00';
SELECT team.team_short_name, team_attributes.buildupplaydribblingclass FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id JOIN match ON match.home_team_api_id = team.team_api_id WHERE team.team_short_name = 'LEI' AND match.date = '2015-09-10 00:00:00';
SELECT `buildupplaypassingclass` FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'FC Lorient' AND team_attributes.date = '2010-02-22';
SELECT team_attributes.chancecreationpassingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'PEC Zwolle' AND team_attributes.date = '2013-09-20 00:00:00';
SELECT `chancecreationcrossingclass` FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'Hull City' AND team_attributes.date = '2010-02-22 00:00:00';
SELECT team_attributes.defenceaggressionclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'Hannover 96' AND team_attributes.date = '2015-09-10 00:00:00';
SELECT AVG(player_attributes.overall_rating) AS average_overall_rating FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id AND player_attributes.player_fifa_api_id = player.player_fifa_api_id WHERE player.player_name = 'Marko Arnautovic' AND player_attributes.date BETWEEN '2007-02-22 00:00:00' AND '2016-04-21 00:00:00';
SELECT CAST(SUM(CASE WHEN T1.player_name = 'Landon Donovan' THEN 1 ELSE 0 END) - SUM(CASE WHEN T1.player_name = 'Jordan Bowery' THEN 1 ELSE 0 END) AS REAL) * 100 / SUM(CASE WHEN T1.player_name = 'Landon Donovan' THEN 1 ELSE 0 END) FROM player AS T1 INNER JOIN player_attributes AS T2 ON T1.player_api_id = T2.player_api_id WHERE T2.date = '2013-07-12'
SELECT player.player_name FROM player ORDER BY player.height DESC LIMIT 5;
SELECT player_api_id FROM player ORDER BY weight DESC LIMIT 10;
SELECT player.player_name FROM player WHERE strftime('%Y', 'now') - strftime('%Y', player.birthday) > 34;
SELECT COUNT(match.home_team_goal) AS home_goals FROM match JOIN player ON match.home_player_1 = player.player_api_id OR               match.home_player_2 = player.player_api_id OR               match.home_player_3 = player.player_api_id OR               match.home_player_4 = player.player_api_id OR               match.home_player_5 = player.player_api_id OR               match.home_player_6 = player.player_api_id OR               match.home_player_7 = player.player_api_id OR               match.home_player_8 = player.player_api_id OR               match.home_player_9 = player.player_api_id OR               match.home_player_10 = player.player_api_id OR               match.home_player_11 = player.player_api_id WHERE player.player_name = 'Aaron Lennon';
SELECT SUM(match.away_team_goal) FROM match JOIN player AS p1 ON match.away_player_11 = p1.player_api_id AND p1.player_name = 'Daan Smith' JOIN player AS p2 ON match.away_player_10 = p2.player_api_id AND p2.player_name = 'Filipe Ferreira';
SELECT SUM(home_team_goal) AS total_home_team_goals FROM match JOIN player ON match.home_player_1 = player.player_api_id OR                 match.home_player_2 = player.player_api_id OR                 match.home_player_3 = player.player_api_id OR                 match.home_player_4 = player.player_api_id OR                 match.home_player_5 = player.player_api_id OR                 match.home_player_6 = player.player_api_id OR                 match.home_player_7 = player.player_api_id OR                 match.home_player_8 = player.player_api_id OR                 match.home_player_9 = player.player_api_id OR                 match.home_player_10 = player.player_api_id OR                 match.home_player_11 = player.player_api_id WHERE strftime('%Y', 'now') - strftime('%Y', player.birthday) <= 30;
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id ORDER BY player_attributes.overall_rating DESC LIMIT 10;
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.potential = (SELECT MAX(potential) FROM player_attributes)
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.attacking_work_rate = 'high';
SELECT MAX(player.player_name) AS eldest_player_name FROM     player INNER JOIN     player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE     player_attributes.finishing = 1 ORDER BY     (strftime('%Y', 'now') - strftime('%Y', player.birthday)) DESC LIMIT 1;
SELECT player.player_name FROM player JOIN country ON player.player_fifa_api_id = country.id WHERE country.name = "Belgium";
SELECT T2.country_id FROM player_attributes AS T1 INNER JOIN country AS T2 ON T2.id = T1.player_country_id WHERE T1.vision > 90
SELECT T2.name FROM Player AS T1 INNER JOIN Country AS T2 ON T1.country_id = T2.id GROUP BY T2.name ORDER BY AVG(T1.weight) DESC LIMIT 1
SELECT team.team_long_name FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team_attributes.buildupplayspeedclass = 'Slow';
SELECT team.team_short_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.chancecreationpassingclass = 'Safe';
SELECT AVG(T2.height) FROM country AS T1 INNER JOIN player AS T2 ON T2.country_id = T1.id WHERE T1.name = 'Italy'
SELECT player.player_name FROM player WHERE player.height > 180 ORDER BY player.player_name LIMIT 3;
SELECT COUNT(player.player_name) AS "Number of Players" FROM     player WHERE     player.player_name LIKE 'Aaron%' AND     player.birthday > '1990-01-01';
SELECT ABS((SELECT jumping FROM player_attributes WHERE id = 6) - (SELECT jumping FROM player_attributes WHERE id = 23)) AS difference_jumping_scores;
SELECT player.player_api_id FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.potential IN (     SELECT MIN(potential)      FROM player_attributes      WHERE preferred_foot = 'right'     ) AND player_attributes.preferred_foot = 'right' LIMIT 3;
SELECT COUNT(*) AS num_players FROM player_attributes WHERE crossing = (SELECT MAX(crossing) FROM player_attributes) AND preferred_foot = 'left';
SELECT CAST(SUM(CASE WHEN strength > 80 AND stamina > 80 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(player_api_id) FROM player_attributes
SELECT country.name FROM country JOIN league ON country.id = league.country_id WHERE league.name = 'Poland Ekstraklasa';
SELECT home_team_goal, away_team_goal FROM match WHERE date = '2008-09-24%' AND league_id = (SELECT id FROM league WHERE name = 'Belgian Jupiler League');
SELECT player.player_name, player_attributes.sprint_speed, player_attributes.agility, player_attributes.acceleration FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player.player_name = 'Alexis Blin';
SELECT CASE     WHEN team.team_long_name = 'KSV Cercle Brugge' THEN team_attributes.buildupplayspeedclass     ELSE NULL END AS speed_class FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team.team_long_name = 'KSV Cercle Brugge';
SELECT COUNT(*) AS games_played FROM match JOIN league ON match.league_id = league.id WHERE league.name = 'Italy Serie A' AND match.season = '2015/2016';
SELECT MAX(home_team_goal)  FROM match  JOIN league ON match.league_id = league.id  JOIN country ON league.country_id = country.id  WHERE country.name = 'Netherlands'  AND league.name = 'Netherlands Eredivisie';
SELECT finishing, curve FROM player_attributes WHERE weight = (SELECT MAX(weight) FROM player);
SELECT league.name AS league_name, COUNT(match.id) AS num_games FROM match JOIN league ON match.league_id = league.id WHERE match.season = '2015/2016' GROUP BY league.name ORDER BY num_games DESC LIMIT 1;
SELECT team.team_long_name FROM     team JOIN     match ON team.team_api_id = match.away_team_api_id WHERE     match.away_team_goal = (         SELECT            MAX(away_team_goal)         FROM             match     );
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE overall_rating = (     SELECT MAX(overall_rating) FROM player_attributes );
SELECT CAST(SUM(CASE WHEN T1.height < 180 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.player_api_id) FROM player AS T1 INNER JOIN player_attributes AS T2 ON T1.player_api_id = T2.player_api_id WHERE T2.overall_rating > 70
SELECT CAST(SUM(CASE WHEN Admission = '+' THEN 1 ELSE 0 END) - SUM(CASE WHEN Admission = '-' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(Id) FROM patient WHERE Sex = 'M'
SELECT CAST(SUM(CASE WHEN sex = 'F' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(id) FROM patient WHERE strftime('%Y', birthday) > '1930'
SELECT CAST(SUM(CASE WHEN admission = '+' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(id) FROM patient WHERE birthday BETWEEN '1930-01-01' AND '1940-12-31'
SELECT CAST(SUM(CASE WHEN Admission = '+' THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN Admission = '-' THEN 1 ELSE 0 END) FROM patient WHERE Diagnosis = 'SLE'
SELECT diagnosis, date FROM patient JOIN examination ON patient.id = examination.id JOIN laboratory ON patient.id = laboratory.id WHERE patient.id = '30609';
SELECT T1.sex, T1.birthday, T2.`examination date`, T2.symptoms FROM patient AS T1 INNER JOIN examination AS T2 ON T1.id = T2.id WHERE T1.id = 163109
SELECT patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.ldh > 500;
SELECT id, age FROM patient WHERE id IN ( SELECT id FROM laboratory WHERE got = '+' )
SELECT patient.id, patient.sex, patient.diagnosis FROM patient JOIN examination ON examination.id = patient.id WHERE examination.thrombosis = 2;
SELECT patient.id FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE year(birthday) = '1937' AND t_cho > 250;
SELECT patient.id, patient.sex, patient.diagnosis FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.alb < 3.5;
SELECT CAST(SUM(CASE WHEN T1.sex = 'F' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T2.tp < 6 OR T2.tp > 8
SELECT AVG ( T2.ACL_IgG ) FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T1.Admission = '+' AND T1.Sex = 'M' AND T1.Birthday >= '1972-01-01'
SELECT COUNT(DISTINCT patient.id) FROM     patient WHERE     patient.sex = 'F'     AND strftime('%Y', patient.description) = '1997'     AND patient.admission = '-'
SELECT MIN(STRFTIME('%Y', `first date`) - STRFTIME('%Y', birthday)) AS "Age of Youngest Patient" FROM patient;
SELECT COUNT(DISTINCT patient.id) FROM     examination JOIN     patient ON examination.id = patient.id WHERE     thrombosis = '1'     AND examination_date LIKE '1997%'     AND sex = 'F';
SELECT MAX(strftime('%Y', birthday)) - MIN(strftime('%Y', birthday)) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE tg >= 200;
SELECT symptoms, diagnosis FROM examination JOIN patient ON examination.id = patient.id WHERE birthday = (SELECT MIN(birthday) FROM patient);
SELECT AVG(monthly_male_patients) FROM (     SELECT COUNT(patient.id) AS monthly_male_patients     FROM patient     JOIN laboratory ON patient.id = laboratory.id     WHERE SEX = 'M' AND date BETWEEN '1998-01-01' AND '1998-12-31'     GROUP BY strftime('%m', date) ) AS male_counts;
SELECT T2.`Laboratory Work Completed Date`, T1.Admission - T1.Birthday AS age FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.ID = T2.ID WHERE T1.Diagnosis = 'SJS' ORDER BY T1.Admission DESC LIMIT 1
SELECT CAST(SUM(CASE WHEN sex = 'M' THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN sex = 'F' THEN 1 ELSE 0 END) FROM patient WHERE ua > 8
SELECT COUNT(DISTINCT patient.id) FROM patient LEFT JOIN examination ON patient.id = examination.id WHERE examination_date IS NULL OR (strftime('%Y', examination_date) - strftime('%Y', first_date)) >= 1;
SELECT COUNT(DISTINCT patient.id) FROM     patient JOIN     examination ON examination.id = patient.id WHERE     strftime('%Y', birthday) > '1975' AND strftime('%Y', birthday) < '1976' AND examination_date BETWEEN '1990-01-01' AND '1993-12-31';
SELECT COUNT(patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'M' AND laboratory.t_bil > 2.0;
SELECT diagnosis FROM patient JOIN examination ON patient.id = examination.id WHERE examination_date BETWEEN '1985-01-01' AND '1995-12-31' GROUP BY diagnosis ORDER BY COUNT(diagnosis) DESC LIMIT 1;
SELECT AVG(strftime('%Y', 'now') - strftime('%Y', birthday)) AS average_age FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE date BETWEEN '1991-10-01' AND '1991-10-30';
SELECT T1.age, T1.diagnosis FROM patient AS T1 INNER JOIN examination AS T2 ON T1.id = T2.id INNER JOIN laboratory AS T3 ON T1.id = T3.id ORDER BY T3.hgb DESC LIMIT 1
SELECT T2.ana FROM patient AS T1 INNER JOIN examination AS T2 ON T1.id = T2.id WHERE T1.id = 3605340 AND T2.`examination date` = '1996-12-02'
SELECT CASE WHEN T.t_cho < 250 THEN 'Normal' ELSE 'Abnormal' END FROM laboratory AS T WHERE T.id = 2927464 AND T.`date` = '1995-09-04'
SELECT patient.sex FROM patient JOIN examination ON examination.id = patient.id WHERE patient.diagnosis = 'AORTITIS' ORDER BY patient.first_date LIMIT 1;
SELECT T2.ACL_IgM FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T1.diagnosis = 'SLE' AND T2.`Date` = '1993-11-12' AND T1.first_date = '1994-02-19'
SELECT patient.sex FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.date = '1992-06-12' AND laboratory.gpt = '9';
SELECT patient.age FROM patient join laboratory on patient.id = laboratory.id WHERE laboratory.ua = 8.4 and laboratory.`date` = '1991-10-21'
SELECT COUNT(T2.id) FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T1.first_date = '1991-06-13' AND T1.diagnosis = 'SJS' AND STRFTIME('%Y', T2.`date`) = '1995'
SELECT diagnosis FROM patient WHERE diagnosis = 'SLE' AND first_date = '1997-01-27';
SELECT T2.Symptoms FROM patient AS T1 INNER JOIN examination AS T2 ON T1.id = T2.id WHERE T1.Birthday = '1959-03-01' AND T2.`Examination Date` = '1993-09-27'
SELECT CAST((SUM(CASE WHEN T2.`Date` = '1981-12' THEN T1.T_Cho ELSE 0 END) - SUM(CASE WHEN T2.`Date` = '1981-11' THEN T1.T_Cho ELSE 0 END)) AS REAL) * 100 / SUM(CASE WHEN T2.`Date` = '1981-11' THEN T1.T_Cho ELSE 0 END) FROM laboratory AS T1 INNER JOIN examination AS T2 ON T1.Id = T2.Id WHERE T2.Birthday = '1959-02-18'
SELECT patient.id FROM patient JOIN examination ON patient.id = examination.id WHERE patient.diagnosis = 'Behcet' AND examination.examination_date BETWEEN '1977-01-01' AND '1998-12-31';
SELECT COUNT(DISTINCT patient.id) FROM     examination JOIN     patient ON examination.id = patient.id JOIN     laboratory ON patient.id = laboratory.id WHERE     examination_date BETWEEN '1987-07-06' AND '1996-01-31'     AND gpt > 30     AND alb < 4;
SELECT COUNT(patient.id), patient.id FROM     patient WHERE     patient.sex = 'F'     AND strftime('%Y', patient.birthday) = '1964'     AND patient.admission = '+';
SELECT COUNT(DISTINCT examination.id) AS num_patients FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON examination.id = laboratory.id WHERE thrombosis = 2 AND ana_pattern = 'S' AND acl_igm > (AVG(acl_igm) * 1.2)
SELECT CAST(SUM(CASE WHEN T2.ua < 6.5 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM examination AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T1.proteinuria BETWEEN 0 AND 1
SELECT CAST(SUM(CASE WHEN T1.diagnosis = 'BEHCET' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM patient AS T1 INNER JOIN examination AS T2 ON T1.id = T2.patient_id WHERE T1.sex = 'M' AND T1.first_date LIKE '1981%'
SELECT T1.id FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T2.`Date` LIKE '1991-10%' AND T2.T-Bil < 2
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE ana_pattern != 'P' AND sex = 'F' AND birthday BETWEEN '1980-01-01' AND '1989-12-31';
SELECT patient.sex FROM     examination     JOIN patient ON examination.id = patient.id     JOIN laboratory ON patient.id = laboratory.id WHERE     examination.diagnosis = 'PSS'     AND laboratory.crp > 2     AND laboratory.cre = 1     AND laboratory.ldh = 123;
SELECT AVG(alb) FROM     examination JOIN     patient ON examination.id = patient.id JOIN     laboratory ON patient.id = laboratory.id WHERE     patient.sex = 'F'     AND laboratory.plt > 400     AND patient.diagnosis = 'SLE';
SELECT symptoms FROM patient WHERE diagnosis = 'SLE' GROUP BY symptoms ORDER BY COUNT(symptoms) DESC LIMIT 1
SELECT first_date, diagnosis FROM patient WHERE id = 48473
SELECT COUNT(DISTINCT patient.id) FROM     patient JOIN     examination ON examination.id = patient.id WHERE     patient.sex = 'F'     AND examination.diagnosis = 'APS';
SELECT COUNT(DISTINCT patient.id) FROM     patient JOIN     examination ON examination.id = patient.id JOIN     laboratory ON laboratory.id = patient.id WHERE     YEAR(examination.date) = '1997'     AND (tp <= 6 OR tp >= 8.5);
SELECT CAST(SUM(CASE WHEN T1.diagnosis = 'SLE' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM patient AS T1 INNER JOIN examination AS T2 ON T1.id = T2.id WHERE T2.thrombosis = 1
SELECT CAST(SUM(CASE WHEN sex = 'F' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(id) FROM patient WHERE birthday LIKE '1980%' AND diagnosis = 'RA'
SELECT COUNT(DISTINCT patient.id) FROM     patient JOIN     examination ON patient.id = examination.id WHERE     patient.sex = 'M'     AND examination_date BETWEEN '1995-01-01' AND '1997-12-31'     AND patient.diagnosis = 'BEHCET'     AND patient.admission = '-'
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'F' AND laboratory.wbc < 3.5;
SELECT examination_date - admission FROM patient WHERE id = 821298
SELECT CASE WHEN T2.ua > 6.5 THEN 'Yes' ELSE 'No' END FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T1.id = 57266
SELECT date FROM laboratory WHERE id = '48473' AND got >= 60;
SELECT T1.sex, T1.birthday FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T2.GOT BETWEEN 10 AND 40 AND T2.date LIKE '1994%'
SELECT DISTINCT patient.id FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'M' AND laboratory.gpt >= 60
SELECT   diagnosis FROM patient JOIN (     SELECT id     FROM laboratory     WHERE gpt > 60 ) AS abnormal_gpt ON patient.id = abnormal_gpt.id ORDER BY birthday ASC;
SELECT AVG(ldh) AS average_ldh_index FROM laboratory WHERE ldh < 500;
SELECT patient.id, strftime('%Y', 'now') - strftime('%Y', patient.birthday) AS age FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE ldh BETWEEN 600 AND 800 AND age >= 100 AND age <= 300;
SELECT patient.admission, COUNT(patient.id) AS patient_count FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.alp < 300 GROUP BY patient.admission;
SELECT patient.id FROM patient WHERE birthday = '1982-04-01' AND (SELECT alp FROM laboratory WHERE laboratory.id = patient.id ORDER BY date DESC LIMIT 1) < 300;
SELECT patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.tp < 6.0;
SELECT T2.TP - 8.5 FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T1.sex = 'F' AND T2.TP > 8.5
SELECT * FROM patient WHERE sex = 'M' AND albumin NOT BETWEEN 3.5 AND 5.5 ORDER BY birthday DESC
SELECT CASE WHEN T2.alb BETWEEN 3.5 AND 5.5 THEN 'yes' ELSE 'no' END FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T1.birthday LIKE '1982%'
SELECT CAST(SUM(CASE WHEN T1.UA > 6.5 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.UA) FROM laboratory AS T1 INNER JOIN patient AS T2 ON T1.id = T2.id WHERE T2.Sex = 'F'
SELECT AVG(ua) AS average_ua_index FROM (     SELECT        p.id,         l.ua,         ROW_NUMBER() OVER(PARTITION BY p.id ORDER BY l.date DESC) AS rn     FROM         patient p     JOIN         laboratory l ON p.id = l.id     WHERE         l.ua < 8.0 AND p.sex = 'M'         OR l.ua < 6.5 AND p.sex = 'F' ) AS latest_lab WHERE     latest_lab.rn = 1;
SELECT patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.un = 29
SELECT patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.un < 30 AND patient.diagnosis = 'RA';
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.cre >= 1.5 AND patient.sex = 'M';
SELECT CASE WHEN SUM(CASE WHEN T2.sex = 'M' THEN 1 ELSE 0 END) - SUM(CASE WHEN T2.sex = 'F' THEN 1 ELSE 0 END) > 0 THEN 'TRUE' ELSE 'FALSE' END FROM laboratory AS T1 INNER JOIN patient AS T2 ON T1.id = T2.id WHERE T1.cre > 1.5
SELECT T1.id, T1.sex, T1.birthday FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id ORDER BY T2.t_bil DESC LIMIT 1
SELECT patient.sex, COUNT(patient.id) AS patient_count FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.t_bil >= 2.0 GROUP BY patient.sex;
SELECT patient.id, MAX(laboratory."t-cho") AS "T-CHO index" FROM patient JOIN laboratory ON patient.id = laboratory.id GROUP BY patient.id ORDER BY birthday ASC LIMIT 1;
SELECT AVG (CAST (strftime ('%Y', 'admission') - strftime ('%Y', 'birthday') AS REAL)) FROM patient WHERE sex = 'M' AND 'diagnosis' = 'high cholesterol'
SELECT   patient.id, patient.diagnosis FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.tg > 300;
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.tg >= 200 AND (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) > 50;
SELECT DISTINCT patient.id FROM     patient JOIN     examination ON patient.id = examination.id JOIN     laboratory ON patient.id = laboratory.id WHERE     patient.admission = '-' AND     laboratory.cpk < 250;
SELECT COUNT(T1.id) FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T1.sex = 'M' AND T1.birthday BETWEEN '1936-01-01' AND '1956-12-31' AND T2.cpk > 250
SELECT T1.ID, T1.SEX, T1.BIRTHDAY FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.ID = T2.ID WHERE T2.GLU > 180 AND T2.T-CHO < 250
SELECT patient.id, laboratory.glu FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE substr(patient.description, 1, 4) >= '1991' AND laboratory.glu < 180;
SELECT patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE (laboratory.wbc <= 3.5 OR laboratory.wbc >= 9.0) GROUP BY patient.sex ORDER BY date(patient.birthday) ASC;
SELECT T1.Diagnosis, T1.ID, T1.Sex, T1.Birthday FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.ID = T2.ID WHERE T2.RBC < 3.5
SELECT p.id, p.admission FROM patient p JOIN examination e ON p.id = e.id JOIN laboratory l ON p.id = l.id WHERE p.sex = 'F' AND strftime('%Y', 'now') - strftime('%Y', p.birthday) >= 50 AND (l.rbc <= 3.5 OR l.rbc >= 6.0)
SELECT patient.id, patient.sex FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.admission = '-' AND laboratory.hgb < 10;
SELECT T1.ID, T1.sex FROM patient AS T1 INNER JOIN examination AS T2 ON T1.ID = T2.ID WHERE T2.diagnosis = 'SLE' AND T1.hgb = 120
SELECT T1.id, T1.age FROM patient AS T1 INNER JOIN ( SELECT id, COUNT(id) AS num FROM laboratory WHERE hct > 45 GROUP BY id HAVING num > 2 ) AS T2 ON T1.id = T2.id
SELECT AVG(hct) AS average_hematoclit FROM laboratory WHERE date LIKE '1991%' AND hct < 29;
SELECT COUNT(CASE WHEN plt < 100 THEN 1 END) AS lower_than_normal, COUNT(CASE WHEN plt > 400 THEN 1 END) AS higher_than_normal FROM laboratory;
SELECT T1.id FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T2.`Date` LIKE '1984%' AND T1.birthday < '1984-01-01' AND T2.plt = 150
SELECT CAST(SUM(CASE WHEN T1.sex = 'F' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM patient AS T1 INNER JOIN examination AS T2 ON T1.id = T2.id WHERE T1.birthday > '1967-01-01' AND T2.PT > 14
SELECT T1.id FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T1.`First Date` > 1992 AND T2.PT BETWEEN 10 AND 14
SELECT COUNT(*) FROM examination WHERE examination_date > '1997-01-01' AND aptt > 45
SELECT COUNT(DISTINCT examination.id) FROM     examination JOIN     patient ON examination.id = patient.id JOIN     laboratory ON examination.id = laboratory.id WHERE     aptt > 45 AND     thrombosis = 3;
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'M' AND laboratory.wbc BETWEEN 3.5 AND 9.0 AND (laboratory.fg < 150 OR laboratory.fg > 450);
SELECT COUNT(DISTINCT patient.id) FROM     patient JOIN     examination ON patient.id = examination.id JOIN     laboratory ON patient.id = laboratory.id WHERE     patient.birthday > '1980-01-01'     AND laboratory.fg NOT BETWEEN 150 AND 450;
SELECT T2.diagnosis FROM laboratory AS T1 INNER JOIN patient AS T2 ON T1.id = T2.id WHERE T1.u_pro > 30
SELECT patient.id FROM patient INNER JOIN laboratory ON patient.id = laboratory.id WHERE patient.diagnosis = 'SLE' AND laboratory.u_pro > 0 AND laboratory.u_pro < 30;
SELECT COUNT(DISTINCT examination.id) FROM     examination JOIN     laboratory ON examination.id = laboratory.id JOIN     patient ON examination.id = patient.id WHERE     igg < 900     AND symptoms = 'abortion';
SELECT COUNT(*) FROM examination JOIN laboratory ON examination.id = laboratory.id JOIN patient ON examination.id = patient.id WHERE laboratory.igg BETWEEN 900 AND 2000 AND symptoms IS NOT NULL;
SELECT diagnosis FROM patient INNER JOIN laboratory ON patient.id = laboratory.id WHERE iga BETWEEN 80 AND 500 ORDER BY iga DESC LIMIT 1;
SELECT COUNT(DISTINCT patient.id) FROM     patient JOIN     laboratory ON patient.id = laboratory.id WHERE     laboratory.iga BETWEEN 80 AND 500     AND YEAR(patient.first_date) >= 1990;
SELECT diagnosis FROM patient JOIN examination ON patient.id = examination.id WHERE examination.igm NOT BETWEEN 40 AND 400 GROUP BY diagnosis ORDER BY COUNT(diagnosis) DESC LIMIT 1;
SELECT COUNT(*) FROM patient LEFT JOIN laboratory ON patient.id = laboratory.id WHERE (crp LIKE '+' OR crp LIKE '-' OR crp < 1.0) AND description IS NULL;
SELECT COUNT(DISTINCT patient.id)  FROM patient  JOIN laboratory ON patient.id = laboratory.id  WHERE crp NOT IN ('+-', '-') AND crp >= 1.0 AND (strftime('%Y', 'now') - strftime('%Y', birthday)) < 18;
SELECT COUNT(DISTINCT patient.id) FROM     examination JOIN     patient ON examination.id = patient.id JOIN     laboratory ON patient.id = laboratory.id WHERE     examination.rf IN ('-', '+-')     AND laboratory.kct = '+';
SELECT T2.Diagnosis FROM patient AS T1 INNER JOIN examination AS T2 ON T1.Id = T2.Patient_Id WHERE T1.Birthday > '1995-01-01' AND T2.RA = '+'
SELECT patient.id FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE rf < 20 AND strftime('%Y', 'now') - strftime('%Y', birthday) > 60;
SELECT COUNT(DISTINCT examination.id) FROM patient LEFT JOIN examination ON patient.id = examination.id LEFT JOIN laboratory ON patient.id = laboratory.id WHERE rf < 20 AND thrombosis = '0';
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN laboratory ON examination.id = laboratory.id WHERE c3 > 35 AND ana_pattern = 'P';
SELECT T1.id FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T2.HCT != 'normal' ORDER BY T2.ACL_IGA DESC LIMIT 1
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN laboratory ON examination.id = laboratory.id WHERE examination.thrombosis = 1 AND laboratory.c4 > 10;
SELECT COUNT(DISTINCT patient.id) FROM     examination JOIN     patient ON examination.id = patient.id JOIN     laboratory ON laboratory.id = patient.id WHERE     examination.rnp IN ('-', '+-')     AND patient.admission = '+';
SELECT MAX(p.birthday) AS "Date of Birth" FROM     patient p JOIN     examination e ON p.id = e.id JOIN     laboratory l ON p.id = l.id WHERE     l.rnp NOT IN ('-', '+-')
SELECT COUNT(T1.id) FROM patient AS T1 INNER JOIN examination AS T2 ON T1.id = T2.id WHERE T2.SM = '+' AND T2.thrombosis = '1'
SELECT patient.id FROM patient INNER JOIN examination ON examination.id = patient.id INNER JOIN laboratory ON laboratory.id = patient.id WHERE examination.sm NOT IN ('-', '+-') ORDER BY patient.birthday DESC LIMIT 3;
SELECT patient.id FROM patient JOIN examination ON patient.id = examination.id WHERE examination_date >= '1997-01-01' AND sc170 IN ('-', '+-');
SELECT COUNT(DISTINCT patient.id) FROM     patient JOIN     examination ON patient.id = examination.id JOIN     laboratory ON patient.id = laboratory.id WHERE     patient.sex = 'M'     AND examination.ssa = '-'     AND examination.symptoms = 'vertigo';
SELECT COUNT(DISTINCT patient.id) FROM     patient JOIN     examination ON examination.id = patient.id JOIN     laboratory ON laboratory.id = patient.id WHERE     examination.ssa IN ('-', '+-')     AND YEAR(patient.first_date) < 1990;
SELECT T1.id FROM patient AS T1 INNER JOIN examination AS T2 ON T1.id = T2.id WHERE T2.SSA = 'abnormal' ORDER BY T1.admission LIMIT 1
SELECT COUNT(DISTINCT patient.id) FROM examination JOIN patient ON examination.id = patient.id WHERE examination.diagnosis = 'SLE' AND laboratory.ssb IN ('negative', '0');
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON examination.id = laboratory.id WHERE laboratory.ssb IN ('-', '+-') AND examination.symptoms IS NOT NULL;
SELECT COUNT(DISTINCT patient.id) FROM     patient JOIN     examination ON patient.id = examination.id JOIN     laboratory ON patient.id = laboratory.id WHERE     centromea IN ('-', '+-')     AND ssb IN ('-', '+-')     AND sex = 'M';
SELECT patient.diagnosis FROM patient JOIN examination ON patient.id = examination.id JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.dna >= 8;
SELECT COUNT(DISTINCT patient.id) FROM patient LEFT JOIN laboratory ON patient.id = laboratory.id WHERE dna < 8 AND description IS NULL;
SELECT COUNT(DISTINCT patient.id) FROM     patient JOIN     laboratory ON patient.id = laboratory.id WHERE     laboratory."dna-ii" >= 8     AND patient.admission = '+';
SELECT CAST(SUM(CASE WHEN T2.diagnosis = 'SLE' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM laboratory AS T1 INNER JOIN patient AS T2 ON T1.id = T2.id WHERE T1.got > 40
SELECT COUNT(DISTINCT patient.id) FROM     patient JOIN     laboratory ON patient.id = laboratory.id WHERE     patient.sex = 'M' AND     laboratory.got < 60;
SELECT MAX(patient.birthday)  FROM      patient  JOIN      laboratory ON patient.id = laboratory.id  WHERE      laboratory.got >= 60;
SELECT patient.birthday FROM   patient JOIN   laboratory ON patient.id = laboratory.id WHERE   laboratory.gpt < 60 ORDER BY   laboratory.gpt DESC LIMIT   3;
SELECT COUNT(DISTINCT patient.id) FROM     patient JOIN     laboratory ON patient.id = laboratory.id WHERE     laboratory.got < 60     AND patient.sex = 'M';
SELECT T1.first_date FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T2.ldh BETWEEN 100 AND 200 ORDER BY T2.ldh DESC LIMIT 1
SELECT MAX(T1.Admission) FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.ID = T2.ID WHERE T2.LDH > 500
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE alp >= 300 AND patient.admission = '+';
SELECT COUNT(*) FROM patient p JOIN laboratory l ON p.id = l.id WHERE p.admission = '-' AND l.alp < 300;
SELECT DISTINCT patient.diagnosis FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.tp < 6.0;
SELECT COUNT(DISTINCT patient.id) FROM     patient JOIN     examination ON patient.id = examination.id JOIN     laboratory ON patient.id = laboratory.id WHERE     diagnosis = 'SJS'     AND tp > 6.0     AND tp < 8.5;
SELECT examination.examination_date FROM examination JOIN laboratory ON examination.id = laboratory.id WHERE laboratory.alb = (SELECT MAX(alb) FROM laboratory WHERE alb > 3.5 AND alb < 5.5);
SELECT COUNT(patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'M' AND laboratory.alb > 3.5 AND laboratory.alb < 5.5 AND laboratory.tp > 6.0 AND laboratory.tp < 8.5;
SELECT T2.ACL_IGG FROM patient AS T1 INNER JOIN examination AS T2 ON T1.id = T2.id WHERE T1.sex = 'F' AND T2.UA BETWEEN 2.5 AND 7.0
SELECT MAX(ana) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE cre < 1.5;
SELECT patient.id FROM     patient JOIN     laboratory ON patient.id = laboratory.id JOIN     examination ON patient.id = examination.id WHERE     laboratory.cre < 1.5 ORDER BY     examination.acl_iga DESC LIMIT 1;
SELECT COUNT(DISTINCT examination.id)  FROM      examination  JOIN      patient ON examination.id = patient.id  JOIN      laboratory ON examination.id = laboratory.id  WHERE      laboratory.t-bil >= 2.0      AND examination.ana_pattern LIKE '%P%';
SELECT ana FROM examination WHERE id = (SELECT id FROM laboratory WHERE t-bil = (SELECT MAX(t-bil) FROM laboratory WHERE t-bil < 2.0));
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN laboratory ON examination.id = laboratory.id WHERE laboratory.t_cho >= 250 AND examination.kct = '-';
SELECT COUNT(T1.id) FROM examination AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T2.`T-Cho` < 250 AND T1.`Ana Pattern` = 'P'
SELECT COUNT(DISTINCT examination.id) FROM     examination JOIN     patient ON examination.id = patient.id JOIN     laboratory ON examination.id = laboratory.id WHERE     tg < 200 AND     symptoms IS NOT NULL;
SELECT diagnosis FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE tg < 200 ORDER BY tg DESC LIMIT 1;
SELECT DISTINCT patient.id FROM patient JOIN examination ON patient.id = examination.id JOIN laboratory ON patient.id = laboratory.id WHERE thrombosis = 0 AND cpk > 250;
SELECT COUNT(DISTINCT patient.id) FROM     patient JOIN     laboratory ON patient.id = laboratory.id JOIN     examination ON patient.id = examination.id WHERE     laboratory.cpk < 250 AND     (examination.kct = '+' OR examination.rvvt = '+' OR examination.lac = '+');
SELECT MIN(patient.birthday) AS oldest_birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.glu > 180;
SELECT COUNT(DISTINCT patient.id) FROM     patient JOIN     laboratory ON patient.id = laboratory.id LEFT JOIN     examination ON patient.id = examination.id WHERE     glu < 180     AND (thrombosis IS NULL OR thrombosis = 0);
SELECT COUNT(patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.admission = '+' AND laboratory.wbc >= 3.5 AND laboratory.wbc <= 9.0;
SELECT COUNT(DISTINCT patient.id) FROM   patient JOIN   examination ON patient.id = examination.id JOIN   laboratory ON patient.id = laboratory.id WHERE   diagnosis = 'SLE'   AND wbc BETWEEN 3.5 AND 9.0;
SELECT patient.id FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE (laboratory.rbc < 3.5 OR laboratory.rbc >= 6.0) AND patient.admission = '-';
SELECT COUNT(DISTINCT patient.id) FROM     patient JOIN     examination ON patient.id = examination.id JOIN     laboratory ON patient.id = laboratory.id WHERE     laboratory.plt > 100 AND laboratory.plt < 400     AND patient.diagnosis IS NOT NULL;
SELECT plt FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE plt > 100 AND plt < 400 AND diagnosis = 'MCTD';
SELECT AVG(pt) FROM     examination JOIN     patient ON examination.id = patient.id JOIN     laboratory ON patient.id = laboratory.id WHERE     patient.sex = 'M'     AND laboratory.pt < 14;
SELECT COUNT(DISTINCT patient.id) FROM     examination JOIN     patient ON examination.id = patient.id JOIN     laboratory ON patient.id = laboratory.id WHERE     thrombosis IN (1, 2)     AND pt < 14;
SELECT major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Angela' AND member.last_name = 'Sanders';
SELECT COUNT(DISTINCT member.member_id) FROM     member JOIN     major ON member.link_to_major = major.major_id WHERE     major.college = 'College of Engineering';
SELECT member.first_name || ' ' || member.last_name AS full_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.department = 'Art and Design';
SELECT COUNT(DISTINCT member.member_id) AS num_attendees FROM event JOIN attendance ON event.event_id = attendance.link_to_event JOIN member ON attendance.link_to_member = member.member_id WHERE event.event_name = "Women's Soccer";
SELECT member.phone FROM attendance JOIN event ON attendance.link_to_event = event.event_id JOIN member ON attendance.link_to_member = member.member_id WHERE event.event_name = "Women's Soccer";
SELECT COUNT(T1.member_id) FROM member AS T1 INNER JOIN attendance AS T2 ON T1.member_id = T2.link_to_member INNER JOIN event AS T3 ON T2.link_to_event = T3.event_id WHERE T3.event_name = 'Women''s Soccer' AND T1.t_shirt_size = 'medium'
SELECT T1.event_name FROM event AS T1 INNER JOIN attendance AS T2 ON T1.event_id = T2.link_to_event INNER JOIN member AS T3 ON T2.link_to_member = T3.member_id WHERE T3.link_to_major = ( SELECT major_id FROM major WHERE college = 'Student_Club' ) ORDER BY T2.link_to_member DESC LIMIT 1
SELECT college.college FROM member JOIN college ON member.link_to_major = college.major_id WHERE member.position = 'Vice President' AND member.link_to_major = (     SELECT    major_id     FROM     major     WHERE     major_name = 'Student_Club' );
SELECT event.event_name FROM event JOIN attendance ON event.event_id = attendance.link_to_event JOIN member ON attendance.link_to_member = member.member_id WHERE member.first_name = 'Maya' AND member.last_name = 'Mclean';
SELECT COUNT(DISTINCT event.event_id) FROM     event JOIN     attendance ON event.event_id = attendance.link_to_event JOIN     member ON attendance.link_to_member = member.member_id WHERE     member.first_name = 'Sacha'     AND member.last_name = 'Harrison'     AND strftime('%Y', event.event_date) = '2019';
SELECT COUNT(*) FROM event JOIN attendance ON event.event_id = attendance.link_to_event WHERE event.type = 'Meeting' GROUP BY event.event_id HAVING COUNT(attendance.link_to_member) > 10;
SELECT event.event_name FROM event JOIN attendance ON event.event_id = attendance.link_to_event GROUP BY event.event_id HAVING COUNT(attendance.link_to_member) > 20;
SELECT AVG(attendance.link_to_event) FROM attendance JOIN event ON attendance.link_to_event = event.event_id WHERE event.type = 'Meeting' AND strftime('%Y', event.event_date) = '2020';
SELECT expense_description FROM expense ORDER BY cost DESC LIMIT 1
SELECT COUNT(*) FROM     member JOIN     major ON member.link_to_major = major.major_id WHERE     major.major_name = 'Environmental Engineering';
SELECT member.first_name , member.last_name FROM attendance join member on attendance.link_to_member = member.member_id join event on attendance.link_to_event = event.event_id WHERE event.event_name = 'Laugh Out Loud'
SELECT member.last_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Law and Constitutional Studies';
SELECT county FROM   member JOIN   zip_code ON member.zip = zip_code.zip_code WHERE   member.first_name = 'Sherri' AND member.last_name = 'Ramsey';
SELECT college.college_name FROM college JOIN major ON college.college_id = major.college JOIN member ON major.major_id = member.link_to_major WHERE member.first_name = 'Tyler' AND member.last_name = 'Hewitt';
SELECT SUM(income.amount) FROM income JOIN member ON income.link_to_member = member.member_id WHERE member.position = 'Vice President';
SELECT SUM(T2.cost) FROM budget AS T1 INNER JOIN expense AS T2 ON T1.budget_id = T2.link_to_budget WHERE T1.event_status = 'Food' AND T2.expense_date LIKE '2024-09%'
SELECT city, state FROM     member JOIN     zip_code ON member.zip = zip_code.zip_code WHERE     position = 'President';
SELECT member.first_name || ' ' || member.last_name AS full_name FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE zip_code.short_state = 'IL';
SELECT SUM(T2.cost) FROM event AS T1 INNER JOIN expense AS T2 ON T1.event_id = T2.link_to_event WHERE T1.event_name = 'September Meeting' AND T2.expense_description = 'Advertisement' AND T2.cost > 0 AND T2.approved = 1
SELECT department FROM major JOIN member ON major.major_id = member.link_to_major WHERE member.first_name = 'Pierce' AND member.last_name = 'Guidi';
SELECT SUM(amount) AS total_budgeted_amount FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'October Speaker';
SELECT T2.approved FROM event AS T1 INNER JOIN expense AS T2 ON T2.link_to_event = T1.event_id WHERE T1.event_name = 'October Meeting' AND T1.event_date = '2019-10-08'
SELECT AVG ( cost ) FROM expense WHERE link_to_member = ( SELECT member_id FROM member WHERE first_name = 'Elijah' AND last_name = 'Allen' ) AND expense_date LIKE '2019-09%' OR expense_date LIKE '2019-10%'
SELECT SUM(CASE WHEN strftime('%Y', event_date) = '2019' THEN spent ELSE 0 END) - SUM(CASE WHEN strftime('%Y', event_date) = '2020' THEN spent ELSE 0 END) FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE event_date BETWEEN '2019-01-01' AND '2019-12-31' OR event_date BETWEEN '2020-01-01' AND '2020-12-31';
SELECT location FROM event WHERE event_name = 'Spring Budget Review';
SELECT SUM(cost) AS total_cost FROM     expense WHERE     expense_description = 'Posters'     AND expense_date = '2019-09-04';
SELECT MAX(remaining) AS remaining_budget FROM budget WHERE category = 'Food'
SELECT notes FROM     income WHERE     source = 'Fundraising'     AND date_received = '2019-09-14';
SELECT COUNT(DISTINCT major_id)  FROM major  WHERE college = 'College of Humanities and Social Sciences';
SELECT phone FROM member WHERE first_name = "Carlo" AND last_name = "Jacobs";
SELECT county FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE first_name = "Adela" AND last_name = "O'Gallagher";
SELECT COUNT(*) FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'November Meeting' AND budget.remaining < 0;
SELECT SUM(amount) FROM     budget JOIN     event ON budget.link_to_event = event.event_id WHERE     event.event_name = 'September Speaker';
SELECT event.status FROM     event INNER JOIN     expense ON expense.link_to_budget = budget.budget_id INNER JOIN     budget ON budget.link_to_event = event.event_id WHERE     expense.expense_description = 'Post Cards, Posters'     AND expense.expense_date = '2019-8-20';
SELECT major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Brent' AND member.last_name = 'Thomason';
SELECT COUNT(*) FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Human Development and Family Studies' AND member.t_shirt_size = 'Large';
SELECT type FROM     zip_code JOIN     member ON member.zip = zip_code.zip_code WHERE     member.first_name = 'Christof' AND member.last_name = 'Nielson';
SELECT major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.position = 'Vice President';
SELECT T2.state FROM member AS T1 INNER JOIN zip_code AS T2 ON T1.zip = T2.zip_code WHERE T1.first_name = 'Sacha' AND T1.last_name = 'Harrison'
SELECT department FROM member WHERE position = 'President';
SELECT income.date_received FROM income JOIN member ON income.link_to_member = member.member_id WHERE member.first_name = 'Connor' AND member.last_name = 'Hilton' AND income.source = 'Dues';
SELECT first_name , last_name FROM member WHERE member_id = ( SELECT link_to_member FROM income ORDER BY date_received ASC LIMIT 1 )
SELECT COUNT(*) FROM ( SELECT CASE WHEN T2.event_name = 'Yearly Kickoff' THEN 1 ELSE 0 END AS num FROM budget AS T1 INNER JOIN event AS T2 ON T1.link_to_event = T2.event_id WHERE T1.category = 'Advertisement' ) WHERE num > ( SELECT CASE WHEN T2.event_name = 'October Meeting' THEN 1 ELSE 0 END AS num FROM budget AS T1 INNER JOIN event AS T2 ON T1.link_to_event = T2.event_id WHERE T1.category = 'Advertisement' )
SELECT CAST(SUM(CASE WHEN T2.category = 'Parking' THEN T2.amount ELSE 0 END) AS REAL) * 100 / SUM(T2.amount) FROM event AS T1 INNER JOIN budget AS T2 ON T2.link_to_event = T1.event_id WHERE T1.event_name = 'November Speaker'
SELECT SUM(cost) AS total_pizza_cost FROM     expense WHERE     expense_description = 'Pizza';
SELECT COUNT(DISTINCT city) FROM zip_code WHERE county = 'Orange' AND state = 'Virginia';
SELECT department FROM major WHERE college = 'College of Humanities and Social Sciences';
SELECT city, county, state FROM     member JOIN     zip_code ON member.zip = zip_code.zip_code WHERE     first_name = 'Amy' AND last_name = 'Firth';
SELECT expense.expense_description, expense.cost FROM     expense JOIN     budget ON expense.link_to_budget = budget.budget_id WHERE     budget.remaining = (SELECT MIN(remaining) FROM budget)
SELECT member.first_name, member.last_name FROM attendance JOIN event ON attendance.link_to_event = event.event_id JOIN member ON attendance.link_to_member = member.member_id WHERE event.event_name = 'October Meeting';
SELECT college FROM major GROUP BY college ORDER BY COUNT ( * ) DESC LIMIT 1
SELECT major.major_name FROM member JOIN zip_code ON member.zip = zip_code.zip_code JOIN major ON member.link_to_major = major.major_id WHERE member.phone = '809-555-3360';
SELECT event.event_name FROM     event INNER JOIN     budget ON event.event_id = budget.link_to_event ORDER BY     budget.amount DESC LIMIT 1;
SELECT expense.expense_description, expense.expense_date, expense.cost FROM expense INNER JOIN member ON expense.link_to_member = member.member_id WHERE member.position = 'Vice President';
SELECT COUNT(DISTINCT member.member_id) FROM     event JOIN     attendance ON event.event_id = attendance.link_to_event JOIN     member ON attendance.link_to_member = member.member_id WHERE     event.event_name = 'Women\'s Soccer';
SELECT income.date_received FROM income JOIN member ON income.link_to_member = member.member_id WHERE member.first_name = 'Casey' AND member.last_name = 'Mason';
SELECT COUNT(DISTINCT member.member_id) FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE zip_code.state = 'Maryland';
SELECT COUNT(event.event_id) FROM   event INNER JOIN   attendance ON event.event_id = attendance.link_to_event INNER JOIN   member ON attendance.link_to_member = member.member_id WHERE   member.phone = "954-555-6240";
SELECT member.first_name || ' ' || member.last_name AS full_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.department = 'School of Applied Sciences, Technology and Education';
SELECT event.event_name, MAX(CAST(budget.spent AS FLOAT) / CAST(budget.amount AS FLOAT)) AS spend_to_budget_ratio FROM event INNER JOIN budget ON event.event_id = budget.link_to_event WHERE event.status = 'Closed' GROUP BY event.event_name ORDER BY spend_to_budget_ratio DESC LIMIT 1;
SELECT COUNT(*) FROM     member WHERE     position = 'President';
SELECT MAX(spent) AS highest_budget_spend FROM budget
SELECT COUNT(*) FROM event WHERE type = 'Meeting' AND strftime('%Y', event_date) = '2020';
SELECT SUM(expense.cost) FROM expense JOIN budget ON expense.link_to_budget = budget.budget_id WHERE budget.category = 'Food';
SELECT first_name , last_name FROM attendance join member on attendance.link_to_member = member.member_id GROUP BY attendance.link_to_member HAVING COUNT ( * ) > 7
SELECT member.first_name, member.last_name FROM     member JOIN     major ON member.link_to_major = major.major_id JOIN     attendance ON member.member_id = attendance.link_to_member JOIN     event ON attendance.link_to_event = event.event_id WHERE     major.major_name = 'Interior Design'     AND event.event_name = 'Community Theater';
SELECT first_name, last_name FROM member JOIN zip_code ON member.zip = zip_code.zip_code JOIN city ON zip_code.city = city.city JOIN state ON zip_code.state = state.state WHERE city = 'Georgetown' AND state = 'South Carolina';
SELECT COUNT(income.income_id) AS income_count FROM income JOIN member ON income.link_to_member = member.member_id WHERE member.first_name = 'Grant' AND member.last_name = 'Gilmour';
SELECT member.first_name , member.last_name FROM income join member on income.link_to_member = member.member_id WHERE income.amount > 40
SELECT SUM(T2.cost) FROM event AS T1 INNER JOIN expense AS T2 ON T1.event_id = T2.link_to_event WHERE T1.event_name = 'Yearly Kickoff'
SELECT member.first_name, member.last_name FROM     member INNER JOIN     budget ON member.member_id = budget.link_to_event INNER JOIN     event ON budget.link_to_event = event.event_id WHERE     event.event_name = 'Yearly Kickoff';
SELECT T1.first_name, T1.last_name, T2.source FROM member AS T1 INNER JOIN income AS T2 ON T1.member_id = T2.link_to_member ORDER BY T2.amount DESC LIMIT 1
SELECT event.event_name FROM event INNER JOIN expense ON event.event_id = expense.link_to_budget ORDER BY expense.cost ASC LIMIT 1;
SELECT CAST(SUM(CASE WHEN T3.event_name = 'Yearly Kickoff' THEN T2.cost ELSE 0 END) AS REAL) * 100 / SUM(T2.cost) FROM expense AS T1 INNER JOIN budget AS T2 ON T1.link_to_budget = T2.budget_id INNER JOIN event AS T3 ON T2.link_to_event = T3.event_id
SELECT CAST(SUM(CASE WHEN major_name = 'Finance' THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN major_name = 'Physics' THEN 1 ELSE 0 END) FROM major
SELECT MAX(source) FROM income WHERE date_received BETWEEN '2019-09-01' AND '2019-09-30'
SELECT member.first_name || ' ' || member.last_name AS full_name, member.email AS email FROM member WHERE member.position = 'Secretary';
SELECT COUNT(*) FROM     member JOIN     major ON member.link_to_major = major.major_id WHERE     major.major_name = 'Physics Teaching'     AND member.position = 'Student_Club';
SELECT COUNT(DISTINCT attendance.link_to_member) AS attendance_count FROM attendance JOIN event ON attendance.link_to_event = event.event_id WHERE event.event_name = 'Community Theater' AND strftime('%Y', event.event_date) = '2019';
SELECT COUNT(event.event_id) AS events_attended, major.major_name AS major FROM attendance INNER JOIN event ON attendance.link_to_event = event.event_id INNER JOIN member ON attendance.link_to_member = member.member_id INNER JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Luisa' AND member.last_name = 'Guidi';
SELECT AVG ( spent ) FROM budget WHERE category = 'Food'
SELECT event.event_name FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE budget.category = 'Advertisement' ORDER BY budget.spent DESC LIMIT 1;
SELECT COUNT(*) FROM     attendance     JOIN event ON attendance.link_to_event = event.event_id     JOIN member ON attendance.link_to_member = member.member_id WHERE     event.event_name = 'Women\'s Soccer'     AND member.first_name = 'Maya'     AND member.last_name = 'Mclean';
SELECT CAST(SUM(CASE WHEN T2.type = 'Community Service' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.event_id) FROM event AS T1 INNER JOIN major AS T2 ON T1.link_to_major = T2.major_id WHERE T1.event_date LIKE '2019%'
SELECT SUM(expense.cost) AS "Poster Cost" FROM     expense JOIN     event ON expense.link_to_event = event.event_id WHERE     event.event_name = 'September Speaker'     AND expense.expense_description = 'Posters';
SELECT MAX(t_shirt_size) AS most_popular_t_shirt_size FROM member
SELECT event.event_name FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE event.status = 'Closed' AND budget.remaining < 0 ORDER BY budget.remaining ASC LIMIT 1;
SELECT T2.type, SUM(T2.cost) FROM event AS T1 INNER JOIN expense AS T2 ON T1.event_id = T2.link_to_event WHERE T1.event_name = 'October Meeting' GROUP BY T2.type
SELECT SUM(amount) AS total_budget,     category FROM     budget JOIN     event ON budget.link_to_event = event.event_id WHERE     event.event_name = 'April Speaker' GROUP BY     category ORDER BY     total_budget ASC;
SELECT budget_id, MAX(amount) AS highest_budgeted_amount FROM budget WHERE category = 'Food';
SELECT budget_id, category, MAX(amount) AS max_budget_amount FROM budget WHERE category = 'Advertising' GROUP BY budget_id ORDER BY max_budget_amount DESC LIMIT 3;
SELECT SUM(cost) AS total_cost_spent_for_parking FROM expense WHERE expense_description = 'Parking';
SELECT SUM(expense.cost) AS total_expense FROM     expense WHERE     expense.expense_date = '2019-08-20';
SELECT member.first_name || ' ' || member.last_name AS full_name, SUM(expense.cost) AS total_cost FROM member JOIN expense ON member.member_id = expense.link_to_member WHERE member.member_id = "rec4BLdZHS2Blfp4v" GROUP BY member.first_name, member.last_name;
SELECT expense.expense_description FROM expense JOIN member ON expense.link_to_member = member.member_id WHERE member.first_name = 'Sacha' AND member.last_name = 'Harrison';
SELECT expense.expense_description FROM expense JOIN member ON expense.link_to_member = member.member_id WHERE member.t_shirt_size = 'X-Large';
SELECT zip_code.zip_code FROM     expense     INNER JOIN member ON expense.link_to_member = member.member_id     INNER JOIN zip_code ON member.zip = zip_code.zip_code WHERE     expense.cost < 50;
SELECT major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Phillip' AND member.last_name = 'Cullen';
SELECT member.position FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Business';
SELECT COUNT(member.member_id) FROM     member JOIN     major ON member.link_to_major = major.major_id WHERE     major.major_name = 'Business'     AND member.t_shirt_size = 'Medium';
SELECT event.type FROM event INNER JOIN budget ON event.event_id = budget.link_to_event WHERE budget.remaining > 30;
SELECT category FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE event.location = 'MU 215';
SELECT event.event_id, event.event_name, event_date, budget.category FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE event.event_date = '2020-03-24T12:00:00';
SELECT major.major_name FROM major JOIN member ON major.major_id = member.link_to_major WHERE member.position = 'Vice President';
SELECT CAST(COUNT(CASE WHEN T2.major_name = 'Mathematics' THEN T1.member_id ELSE NULL END) AS REAL) * 100 / COUNT(T1.member_id) FROM member AS T1 INNER JOIN major AS T2 ON T1.link_to_major = T2.major_id
SELECT category FROM event WHERE location = 'MU 215';
SELECT COUNT(*) FROM     income WHERE     amount = 50;
SELECT COUNT(*) FROM     member WHERE     position = 'Member'     AND t_shirt_size = 'X-Large';
SELECT COUNT(*)  FROM major  WHERE college = 'College of Agriculture and Applied Sciences'  AND department = 'School of Applied Sciences, Technology and Education';
SELECT member.last_name, major.department, major.college FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Environmental Engineering';
SELECT budget.category FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE event.location = 'MU 215' AND event.type = 'Guest Speaker' AND budget.spent = 0;
SELECT city, state FROM member JOIN major ON member.link_to_major = major.major_id JOIN zip_code ON member.zip = zip_code.zip_code WHERE major.department = 'Electrical and Computer Engineering Department' AND member.position = 'Member';
SELECT event.event_name FROM event JOIN attendance ON event.event_id = attendance.link_to_event JOIN member ON attendance.link_to_member = member.member_id JOIN zip_code ON member.zip = zip_code.zip_code WHERE event.type = 'Social' AND member.position = 'Vice President' AND zip_code.city = '900 E. Washington St.';
SELECT member.last_name, member.position FROM expense JOIN member ON expense.link_to_member = member.member_id WHERE expense.expense_description = 'Pizza' AND expense.expense_date = '2019-09-10';
SELECT member.last_name FROM member JOIN attendance ON member.member_id = attendance.link_to_member JOIN event ON attendance.link_to_event = event.event_id WHERE event.event_name = 'Women\'s Soccer' AND member.position = 'Member';
SELECT CAST(SUM(CASE WHEN T2.amount = 50 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.member_id) FROM member AS T1 INNER JOIN income AS T2 ON T1.member_id = T2.link_to_member WHERE T1.t_shirt_size = 'medium' AND T2.source = 'Student_Club'
SELECT DISTINCT state FROM     zip_code WHERE     type = 'PO Box';
SELECT zip_code.zip_code FROM zip_code WHERE zip_code.type = 'PO Box' AND zip_code.city = 'San Juan' AND zip_code.state = 'Puerto Rico';
SELECT event.event_name FROM event WHERE event.type = 'Game' AND event.status = 'Closed' AND event.event_date BETWEEN '2019-03-15' AND '2020-03-20';
SELECT event.event_id, event.event_name, event.event_date, event.type, event.notes, event.location, event.status FROM event JOIN expense ON event.event_id = expense.link_to_budget JOIN budget ON event.event_id = budget.link_to_event WHERE expense.cost > 50
SELECT member.first_name, member.last_name, event.event_name FROM member JOIN attendance ON member.member_id = attendance.link_to_member JOIN event ON attendance.link_to_event = event.event_id JOIN expense ON member.member_id = expense.link_to_member WHERE expense.approved = 'true' AND expense.expense_date BETWEEN '2019-01-10' AND '2019-11-19';
SELECT major.college FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Katy' AND member.link_to_major = 'rec1N0upiVLy5esTO';
SELECT T1.phone FROM member AS T1 INNER JOIN major AS T2 ON T1.link_to_major = T2.major_id WHERE T2.department = 'Business' AND T2.college = 'Agriculture and Applied Sciences'
SELECT member.email FROM member JOIN expense ON expense.link_to_member = member.member_id WHERE expense.expense_date BETWEEN '2019-09-10' AND '2019-11-19' AND expense.cost > 20;
SELECT COUNT(member.member_id) FROM     member JOIN     major ON member.link_to_major = major.major_id WHERE     major.major_name = 'education'     AND major.department = 'College of Education & Human Services'     AND member.position = 'Member';
SELECT CAST(SUM(CASE WHEN T2.remaining < 0 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.event_id) FROM event AS T1 INNER JOIN budget AS T2 ON T1.event_id = T2.link_to_event
SELECT event_id, location, status FROM event WHERE event_date BETWEEN '2019-11-01' AND '2020-03-31';
SELECT expense_description FROM expense GROUP BY expense_description HAVING AVG ( cost ) > 50
SELECT first_name , last_name FROM member WHERE t_shirt_size = 'XL'
SELECT CAST(SUM(CASE WHEN type = 'PO Box' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(zip_code) FROM zip_code
SELECT event.event_name, event.location FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE budget.remaining > 0;
SELECT event.event_name, event.event_date FROM event JOIN expense ON expense.link_to_budget = budget.budget_id WHERE expense.expense_description = 'Pizza' AND expense.cost > 50 AND expense.cost < 100;
SELECT member.first_name , member.last_name , major.major_name FROM member join expense on member.member_id = expense.link_to_member join major on member.link_to_major = major.major_id WHERE expense.cost > 100
SELECT T1.city, T1.county FROM zip_code AS T1 INNER JOIN event AS T2 ON T1.zip_code = T2.location WHERE T2.event_id IN ( SELECT event_id FROM income GROUP BY event_id HAVING COUNT(event_id) > 40 )
SELECT T1.first_name, T1.last_name FROM member AS T1 INNER JOIN expense AS T2 ON T1.member_id = T2.link_to_member GROUP BY T1.member_id HAVING COUNT(T2.link_to_event) > 1 ORDER BY SUM(T2.cost) DESC LIMIT 1
SELECT AVG(cost) AS average_amount_paid FROM expense JOIN member ON expense.link_to_member = member.member_id WHERE member.position != 'Member';
SELECT event.event_name FROM event JOIN expense ON event.event_id = expense.link_to_budget WHERE expense.category = 'Parking' GROUP BY event.event_id HAVING expense.cost < (SELECT AVG(cost) FROM expense WHERE category = 'Parking');
SELECT CAST(SUM(T2.cost) AS REAL) * 100 / SUM(T1.spent) FROM event AS T1 INNER JOIN expense AS T2 ON T1.event_id = T2.link_to_budget WHERE T1.type = 'Game'
SELECT budget.budget_id, MAX(expense.cost) AS max_cost FROM budget JOIN expense ON budget.budget_id = expense.link_to_budget WHERE expense.expense_description = 'Water, chips, cookies' GROUP BY budget.budget_id ORDER BY max_cost DESC LIMIT 1;
SELECT member.first_name , member.last_name FROM member join expense on member.member_id = expense.link_to_member GROUP BY member.member_id ORDER BY SUM ( expense.cost ) DESC LIMIT 5
SELECT member.first_name , member.last_name , member.phone FROM member join expense on member.member_id = expense.link_to_member GROUP BY expense.cost HAVING AVG ( expense.cost )
SELECT CAST(SUM(CASE WHEN state = 'Maine' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(state) - CAST(SUM(CASE WHEN state = 'Vermont' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(state) FROM zip_code
SELECT major.major_name, major.department FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Garrett' AND member.last_name = 'Gerke';
SELECT member.first_name || ' ' || member.last_name AS "Full Name", expense.cost AS "Cost" FROM member JOIN expense ON member.member_id = expense.link_to_member WHERE expense.expense_description = 'Water, Veggie tray, supplies';
SELECT member.last_name, member.phone FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Elementary Education';
SELECT budget.category, budget.amount FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'January Speaker';
SELECT event.event_name FROM event INNER JOIN budget ON event.event_id = budget.link_to_event WHERE budget.category = 'Food';
SELECT member.first_name || ' ' || member.last_name AS full_name, income.amount AS amount_received FROM income JOIN member ON income.link_to_member = member.member_id WHERE income.date_received = '2019-09-09';
SELECT budget.category FROM expense JOIN budget ON expense.link_to_budget = budget.budget_id WHERE expense.expense_description = 'Posters';
SELECT member.first_name || ' ' || member.last_name AS full_name, major.college FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.position = 'Secretary';
SELECT SUM ( cost ) , event.event_name FROM expense join budget on expense.link_to_budget = budget.budget_id join event on budget.link_to_event = event.event_id WHERE budget.category = 'Speaker Gifts' GROUP BY event.event_name
SELECT city FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE member.first_name = 'Garrett' AND member.last_name = 'Girke';
SELECT member.first_name, member.last_name, member.position FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE zip_code.city = 'Lincolnton' AND zip_code.state = 'North Carolina' AND zip_code.zip_code = 28092;
SELECT COUNT(T2.GasStationID) FROM Products AS T1 INNER JOIN transactions_1k AS T2 ON T1.ProductID = T2.ProductID WHERE T1.Description = 'Premium gas' AND T2.GasStationID IN ( SELECT GasStationID FROM gasstations WHERE Country = 'CZE' )
SELECT CAST(SUM(CASE WHEN Currency = 'EUR' THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN Currency = 'CZK' THEN 1 ELSE 0 END) FROM customers
SELECT T1.CustomerID FROM customers AS T1 INNER JOIN yearmonth AS T2 ON T1.CustomerID = T2.CustomerID WHERE T2.`Date` LIKE '2012%' AND T1.Segment = 'LAM' ORDER BY T2.Consumption LIMIT 1
SELECT AVG(consumption) / 12 AS avg_monthly_consumption FROM yearmonth WHERE customerid IN (     SELECT customerid     FROM customers     WHERE segment = 'SME' ) AND date BETWEEN 201301 AND 201312;
SELECT customers.customerid, SUM(transactions_1k.amount) AS total_gas_consumption FROM customers JOIN transactions_1k ON customers.customerid = transactions_1k.customerid WHERE customers.currency = 'CZK' AND transactions_1k.date BETWEEN 201101 AND 201112 GROUP BY customers.customerid ORDER BY total_gas_consumption DESC LIMIT 1;
SELECT COUNT(DISTINCT customers.customerid) FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE yearmonth.date BETWEEN 201201 AND 201212 AND customers.segment = 'KAM' AND yearmonth.consumption < 30000;
SELECT SUM(CASE WHEN customers.currency = 'CZK' THEN yearmonth.consumption ELSE 0 END) -  SUM(CASE WHEN customers.currency = 'EUR' THEN yearmonth.consumption ELSE 0 END) AS difference FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE yearmonth.date BETWEEN 201201 AND 201212;
SELECT MAX(year) FROM (     SELECT strftime('%Y', date) AS year, SUM(amount * price) AS total_eur     FROM transactions_1k     JOIN customers ON transactions_1k.customerid = customers.customerid     WHERE currency = 'EUR'     GROUP BY year );
SELECT segment FROM (     SELECT customers.segment, SUM(yearmonth.consumption) AS total_consumption     FROM customers     JOIN yearmonth ON customers.customerid = yearmonth.customerid     GROUP BY customers.segment ) AS consumption_by_segment ORDER BY total_consumption ASC LIMIT 1;
SELECT STRFTIME('%Y', T2.Date) FROM transactions_1k AS T1 INNER JOIN yearmonth AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.Currency = 'CZK' GROUP BY STRFTIME('%Y', T2.Date) ORDER BY SUM(T1.Consumption) DESC LIMIT 1
SELECT MAX(yearmonth.date) AS peak_month FROM     yearmonth JOIN     customers ON yearmonth.customerid = customers.customerid WHERE     customers.segment = 'SME' AND     yearmonth.date LIKE '2013%' GROUP BY     yearmonth.date;
SELECT AVG(CASE WHEN T1.Segment = 'SME' THEN T2.Consumption ELSE 0 END) - AVG(CASE WHEN T1.Segment = 'LAM' THEN T2.Consumption ELSE 0 END) AS SME_LAM , AVG(CASE WHEN T1.Segment = 'LAM' THEN T2.Consumption ELSE 0 END) - AVG(CASE WHEN T1.Segment = 'KAM' THEN T2.Consumption ELSE 0 END) AS LAM_KAM , AVG(CASE WHEN T1.Segment = 'KAM' THEN T2.Consumption ELSE 0 END) - AVG(CASE WHEN T1.Segment = 'SME' THEN T2.Consumption ELSE 0 END) AS KAM_SME FROM customers AS T1 INNER JOIN yearmonth AS T2 ON T1.CustomerID = T2.CustomerID WHERE T2.Date LIKE '2013%' AND T1.Currency = 'CZK'
SELECT CASE WHEN SUM(CASE WHEN T1.Segment = 'SME' THEN T1.Consumption ELSE 0 END) - SUM(CASE WHEN T1.Segment = 'SME' THEN T2.Consumption ELSE 0 END) > 0 THEN 'SME' ELSE NULL END AS SME, CASE WHEN SUM(CASE WHEN T1.Segment = 'LAM' THEN T1.Consumption ELSE 0 END) - SUM(CASE WHEN T1.Segment = 'LAM' THEN T2.Consumption ELSE 0 END) > 0 THEN 'LAM' ELSE NULL END AS LAM, CASE WHEN SUM(CASE WHEN T1.Segment = 'KAM' THEN T1.Consumption ELSE 0 END) - SUM(CASE WHEN T1.Segment = 'KAM' THEN T2.Consumption ELSE 0 END) > 0 THEN 'KAM' ELSE NULL END AS KAM FROM yearmonth AS T1 INNER JOIN yearmonth AS T2 ON T1.CustomerID = T2.CustomerID AND T2.`Date` BETWEEN 201301 AND 201312 WHERE T1.`Date` BETWEEN 201201 AND 201212
SELECT SUM(T2.Consumption) FROM customers AS T1 INNER JOIN yearmonth AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.CustomerID = 6 AND T2.`Date` BETWEEN '2013-08' AND '2013-11'
SELECT SUM(CASE WHEN country = 'Czech Republic' THEN 1 ELSE 0 END) - SUM(CASE WHEN country = 'Slovakia' THEN 1 ELSE 0 END) FROM gasstations WHERE segment = 'discount'
SELECT SUM(CASE WHEN T1.CustomerID = 7 THEN T2.Consumption ELSE 0 END) - SUM(CASE WHEN T1.CustomerID = 5 THEN T2.Consumption ELSE 0 END) FROM customers AS T1 INNER JOIN yearmonth AS T2 ON T1.CustomerID = T2.CustomerID WHERE T2.`Date` LIKE '2013-04%'
SELECT COUNT(DISTINCT CASE WHEN segment = 'SME' AND currency = 'Czech koruna' THEN customerid END) - COUNT(DISTINCT CASE WHEN segment = 'SME' AND currency = 'Euro' THEN customerid END) AS difference FROM customers;
SELECT T1.CustomerID FROM customers AS T1 INNER JOIN yearmonth AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.Segment = 'LAM' AND T1.Currency = 'Euro' AND T2.`Date` = '201310' ORDER BY T2.Consumption DESC LIMIT 1
SELECT customers.customerid, MAX(yearmonth.consumption) AS max_consumption FROM customers JOIN yearmonth ON yearmonth.customerid = customers.customerid WHERE customers.segment = 'KAM' GROUP BY customers.customerid ORDER BY max_consumption DESC LIMIT 1;
SELECT SUM(transactions_1k.amount) FROM transactions_1k JOIN customers ON transactions_1k.customerid = customers.customerid JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE yearmonth.date = 201305 AND customers.segment = 'KAM';
SELECT CAST(SUM(CASE WHEN T2.Consumption > 46.73 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.CustomerID) FROM customers AS T1 INNER JOIN yearmonth AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.Segment = 'LAM'
SELECT gasstations.country, COUNT(*) AS value_for_money_gas_stations FROM gasstations WHERE gasstations.segment = 'value for money' GROUP BY gasstations.country;
SELECT CAST(SUM(CASE WHEN Currency = 'EUR' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(CustomerID) FROM Customers WHERE Segment = 'KAM'
SELECT CAST(SUM(CASE WHEN consumption > 528.3 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(customerid) FROM yearmonth WHERE `date` = '2012-02'
SELECT CAST(SUM(CASE WHEN Segment = 'Premium' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(GasStationID) FROM GasStations WHERE Country = 'Slovakia'
SELECT customerid FROM yearmonth WHERE date = '2013-09' ORDER BY consumption DESC LIMIT 1
SELECT T2.Segment FROM transactions_1k AS T1 INNER JOIN customers AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.Date LIKE '2013-09%' GROUP BY T2.Segment ORDER BY SUM(T1.Amount) ASC LIMIT 1
SELECT T1.CustomerID FROM customers AS T1 INNER JOIN yearmonth AS T2 ON T1.CustomerID = T2.CustomerID WHERE T2.`Date` = '2012-06' AND T1.Segment = 'SME' ORDER BY T2.Consumption ASC LIMIT 1
SELECT MAX(consumption) AS highest_monthly_consumption FROM yearmonth WHERE date LIKE '2012%'
SELECT MAX(monthly_consumption) FROM     (SELECT        SUM(consumption) / 12 AS monthly_consumption     FROM         yearmonth     JOIN         customers ON yearmonth.customerid = customers.customerid     WHERE         customers.currency = 'euro'     GROUP BY         yearmonth.customerid) as monthly_consumptions;
SELECT products.description FROM products JOIN transactions_1k ON products.productid = transactions_1k.productid WHERE substr(transactions_1k.date, 1, 6) = '201309';
SELECT DISTINCT gasstations.country FROM     transactions_1k JOIN     gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE     SUBSTR(transactions_1k.date, 1, 6) = '201306';
SELECT DISTINCT gasstations.chainid FROM gasstations INNER JOIN transactions_1k ON gasstations.gasstationid = transactions_1k.gasstationid INNER JOIN customers ON transactions_1k.customerid = customers.customerid WHERE customers.currency = 'euro';
SELECT products.description FROM transactions_1k INNER JOIN products ON transactions_1k.productid = products.productid INNER JOIN customers ON transactions_1k.customerid = customers.customerid WHERE customers.currency = 'euro';
SELECT AVG(amount * price) AS average_total_price FROM transactions_1k WHERE date LIKE '2012-01%'
SELECT COUNT(T1.CustomerID) FROM customers AS T1 INNER JOIN transactions_1k AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.Currency = 'EUR' AND T1.Segment = 'VIP' AND T1.MonthlyConsumption > 1000
SELECT products.description FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid JOIN products ON transactions_1k.productid = products.productid WHERE gasstations.country = 'CZE';
SELECT DISTINCT time FROM transactions_1k WHERE gasstationid IN (     SELECT gasstationid     FROM gasstations     WHERE chainid = 11 );
SELECT COUNT(*) FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE gasstations.country = 'CZE' AND transactions_1k.price > 1000;
SELECT COUNT(*) FROM     transactions_1k WHERE     gasstationid IN (SELECT gasstationid FROM gasstations WHERE country = 'CZE')     AND date > '2012-01-01';
SELECT AVG(amount * price) AS average_total_price FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE gasstations.country = 'CZE';
SELECT AVG(amount * price) AS avg_total_price FROM transactions_1k JOIN customers ON transactions_1k.customerid = customers.customerid WHERE customers.currency = 'euro';
SELECT T1.CustomerID FROM customers AS T1 INNER JOIN transactions_1k AS T2 ON T1.CustomerID = T2.CustomerID WHERE T2.Date = '2012-08-25' ORDER BY T2.Amount DESC LIMIT 1
SELECT gasstations.country FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE transactions_1k.date = '2012-08-25' ORDER BY transactions_1k.time LIMIT 1;
SELECT customers.currency FROM transactions_1k JOIN customers ON transactions_1k.customerid = customers.customerid WHERE transactions_1k.time = '16:25:00' AND transactions_1k.date = '2012-08-24';
SELECT customers.segment FROM customers JOIN transactions_1k AS T1 ON customers.customerid = T1.customerid WHERE T1.date = '2012-08-23' AND T1.time = '21:20:00';
SELECT COUNT(T1.TransactionID) FROM transactions_1k AS T1 INNER JOIN customers AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.Date = '2012-08-26' AND T1.Time < '13:00:00' AND T2.Currency = 'EUR'
SELECT MAX(segment) FROM customers WHERE customerid = (     SELECT MIN(customerid) FROM customers );
SELECT gasstations.country FROM transactions_1k AS T1 INNER JOIN gasstations ON T1.gasstationid = gasstations.gasstationid WHERE T1.date = '2012-08-24' AND T1.time = '12:42:00';
SELECT products.productid FROM transactions_1k AS T1 JOIN products ON T1.productid = products.productid WHERE T1.date = '2012-08-23' AND T1.time = '21:20:00';
SELECT SUM(t.amount * t.price) AS total_expenses,     t.date AS date_of_expenses FROM transactions_1k AS t JOIN yearmonth AS y ON t.customerid = y.customerid WHERE t.date BETWEEN '2012-01-01' AND '2012-01-31' AND t.customerid = (     SELECT customerid     FROM transactions_1k     WHERE amount = 124.05 AND date = '2012-08-24'     LIMIT 1 ) GROUP BY t.customerid;
SELECT COUNT(*) FROM transactions_1k WHERE strftime('%H:%M', time) BETWEEN '08:00' AND '09:00' AND date = '2012-08-26' AND gasstationid IN (SELECT gasstationid FROM gasstations WHERE country = 'CZE');
SELECT customers.currency FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid JOIN transactions_1k ON customers.customerid = transactions_1k.customerid WHERE yearmonth.date LIKE '201306' AND transactions_1k.amount = 214582.17;
SELECT T2.Country FROM transactions_1k AS T1 INNER JOIN gasstations AS T2 ON T1.GasStationID = T2.GasStationID WHERE T1.CardID = 667467
SELECT T1.Country FROM Customers AS T1 INNER JOIN transactions_1k AS T2 ON T1.CustomerID = T2.CustomerID WHERE T2.Date = '2012-08-24' AND T2.Amount = 548.4
SELECT CAST(SUM(CASE WHEN T2.Currency = 'EUR' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.CustomerID) FROM transactions_1k AS T1 INNER JOIN customers AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.Date = '2012-08-25'
SELECT CAST(SUM(CASE WHEN T2.`Date` BETWEEN '2012-01-01' AND '2012-12-31' THEN T1.Consumption ELSE 0 END) - SUM(CASE WHEN T2.`Date` BETWEEN '2013-01-01' AND '2013-12-31' THEN T1.Consumption ELSE 0 END) AS REAL) * 100 / SUM(CASE WHEN T2.`Date` BETWEEN '2012-01-01' AND '2012-12-31' THEN T1.Consumption ELSE 0 END) FROM yearmonth AS T1 INNER JOIN transactions_1k AS T2 ON T1.CustomerID = T2.CustomerID WHERE T2.`Date` = '2012-08-25' AND T2.Amount = 634.8
SELECT gasstations.chainid, SUM(transactions_1k.amount * transactions_1k.price) AS total_revenue FROM gasstations JOIN transactions_1k ON gasstations.gasstationid = transactions_1k.gasstationid GROUP BY gasstations.chainid ORDER BY total_revenue DESC LIMIT 1;
SELECT CAST(SUM(CASE WHEN T2.Segment = 'premium' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.Segment) FROM gasstations AS T1 INNER JOIN customers AS T2 ON T1.ChainID = T2.ChainID WHERE T1.Country = 'SVK'
SELECT SUM(amount * price) AS total_spent FROM transactions_1k WHERE customerid = '38508' AND date LIKE '201201%'
SELECT products.description FROM transactions_1k join products on transactions_1k.productid = products.productid GROUP BY transactions_1k.productid ORDER BY SUM ( transactions_1k.amount ) DESC LIMIT 5
SELECT T1.CustomerID, AVG(T2.Price) , T1.Currency FROM customers AS T1 INNER JOIN transactions_1k AS T2 ON T1.CustomerID = T2.CustomerID GROUP BY T1.CustomerID ORDER BY SUM(T2.Amount) DESC LIMIT 1
SELECT gasstations.country FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid JOIN products ON transactions_1k.productid = products.productid WHERE products.productid = 2 ORDER BY transactions_1k.price DESC LIMIT 1;
SELECT yearmonth.consumption AS consumption_status FROM yearmonth JOIN transactions_1k ON yearmonth.customerid = transactions_1k.customerid JOIN products ON transactions_1k.productid = products.productid WHERE transactions_1k.price / transactions_1k.amount > 29.00 AND yearmonth.date LIKE '201208%' AND products.productid = 5;
