const __vite__fileDeps=["./ddsTextureLoader.DUd-KOWO.js","./dds.D1ooFbHS.js","./abstractEngine.cubeTexture.DfokItof.js","./envTextureLoader.Cjhw_n9e.js","./environmentTextureTools.B0NSBysW.js","./preload-helper.DpQnamwV.js","./dumpTools.DN0ziOG5.js","./hdrTextureLoader.DEodtYmE.js","./hdr.D4QwhUr_.js","./ktxTextureLoader.HssuqEIa.js","./workerPool.DdmrBfgg.js","./rgbdDecode.fragment.rwq24wBt.js","./helperFunctions.COqGwMB7.js","./rgbdDecode.fragment.hUWhAROE.js","./helperFunctions.GtpVj9KP.js","./rgbdEncode.fragment.EftwisBz.js","./rgbdEncode.fragment.ByL2jtsN.js","./pbr.vertex.B2aBHyG0.js","./harmonicsFunctions.BVUQbHFt.js","./meshUboDeclaration.DZonAwdN.js","./vertexColorMixing.D7nEKUc1.js","./mainUVVaryingDeclaration.DfjOA8f6.js","./bakedVertexAnimation.D2hIR7GL.js","./logDepthVertex.Di847pEJ.js","./logDepthDeclaration.84Qe28Nq.js","./pbr.fragment.CnhGrVlS.js","./oitFragment.CKTLtubN.js","./fogFragment.1gDh0XSm.js","./hdrFilteringFunctions.CTdVXMtm.js","./decalFragment.IqIR910K.js","./pbr.vertex.DN_4Gg7_.js","./vertexColorMixing.BqK909l7.js","./harmonicsFunctions.XKJxmyZ1.js","./logDepthDeclaration.phBn9pYB.js","./mainUVVaryingDeclaration.DFFxJa-M.js","./logDepthVertex.CzXZCRdW.js","./pbr.fragment.DSHCHu0L.js","./oitFragment.CdHGiXZ3.js","./fogFragment.DC8Ql_nK.js","./hdrFilteringFunctions.DvWC8L2A.js","./EXT_lights_image_based.KsB9d1oN.js","./cubeTexture.-yQnoEhx.js","./glTFLoader.Dad9pWRB.js","./bone.Cjam1WWQ.js","./rawTexture.BDna2Gr7.js","./assetContainer.DOVT8xIJ.js","./objectModelMapping.DjjDrzc7.js","./EXT_mesh_gpu_instancing.CeOrvxnq.js","./thinInstanceMesh.DQHtGzA9.js","./EXT_meshopt_compression.JztFmjnR.js","./EXT_texture_avif.D254j8I8.js","./EXT_texture_webp.BktP8Dfw.js","./KHR_animation_pointer.CkZjMdvY.js","./glTFLoaderAnimation.DZpmrDZ9.js","./KHR_draco_mesh_compression.C8sTtP-a.js","./KHR_interactivity.DhQWS96m.js","./declarationMapper.ClcoZIzq.js","./KHR_lights_punctual.Ch6gil-q.js","./EXT_lights_ies.DTSn8U1_.js","./KHR_materials_anisotropy.Dv7q4jh9.js","./KHR_materials_clearcoat.BIba8WPr.js","./KHR_materials_diffuse_transmission.biE89Vxy.js","./KHR_materials_dispersion.BdbdOVcd.js","./KHR_materials_emissive_strength.CchLX5Z8.js","./KHR_materials_ior.B6KGjiUT.js","./KHR_materials_iridescence.CK7SmSQT.js","./KHR_materials_pbrSpecularGlossiness.gIAkImu1.js","./KHR_materials_sheen.CyXT883p.js","./KHR_materials_specular.BxQ_XxVQ.js","./KHR_materials_transmission.CBBlajab.js","./KHR_materials_unlit.z2Fhnnd3.js","./KHR_materials_variants.CQvMuw-f.js","./KHR_materials_volume.vny-C3Ny.js","./KHR_texture_basisu.eD0DXWdj.js","./KHR_texture_transform.BlCUKrds.js","./MSFT_audio_emitter.BlOqklNv.js","./audioEngine.BOewjxQa.js","./MSFT_lod.Cx7iO8vt.js","./MSFT_minecraftMesh.tX7qmXGJ.js","./MSFT_sRGBFactors.weo5O_yX.js","./KHR_node_visibility.DiCUegCt.js","./KHR_node_hoverability.D1CZbzEC.js","./KHR_node_selectability.CaldoXjK.js","./objFileLoader.BoeZYZET.js","./standardMaterial.6Qt26zeN.js","./splatFileLoader.stJy4Jcs.js","./ray.Bo9MF4YK.js","./stlFileLoader.M0a_gdUw.js","./hdrCubeTexture.BsHODBAD.js","./webgpuEngine.Bt3t0qpF.js","./fresnelFunction.IKBTx3ei.js"],__vite__mapDeps=i=>i.map(i=>__vite__fileDeps[i]);
var _a;
import { _ as __vitePreload } from "./preload-helper.DpQnamwV.js";
function __decorate(decorators, target, key, desc) {
  var c2 = arguments.length, r3 = c2 < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d2;
  if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
    r3 = Reflect.decorate(decorators, target, key, desc);
  else
    for (var i2 = decorators.length - 1; i2 >= 0; i2--)
      if (d2 = decorators[i2])
        r3 = (c2 < 3 ? d2(r3) : c2 > 3 ? d2(target, key, r3) : d2(target, key)) || r3;
  return c2 > 3 && r3 && Object.defineProperty(target, key, r3), r3;
}
const __mergedStore = {};
const __decoratorInitialStore = {};
function GetDirectStore(target) {
  const classKey = target.getClassName();
  if (!__decoratorInitialStore[classKey]) {
    __decoratorInitialStore[classKey] = {};
  }
  return __decoratorInitialStore[classKey];
}
function GetMergedStore(target) {
  const classKey = target.getClassName();
  if (__mergedStore[classKey]) {
    return __mergedStore[classKey];
  }
  __mergedStore[classKey] = {};
  const store = __mergedStore[classKey];
  let currentTarget = target;
  let currentKey = classKey;
  while (currentKey) {
    const initialStore = __decoratorInitialStore[currentKey];
    for (const property in initialStore) {
      store[property] = initialStore[property];
    }
    let parent;
    let done = false;
    do {
      parent = Object.getPrototypeOf(currentTarget);
      if (!parent.getClassName) {
        done = true;
        break;
      }
      if (parent.getClassName() !== currentKey) {
        break;
      }
      currentTarget = parent;
    } while (parent);
    if (done) {
      break;
    }
    currentKey = parent.getClassName();
    currentTarget = parent;
  }
  return store;
}
function generateSerializableMember(type, sourceName) {
  return (target, propertyKey) => {
    const classStore = GetDirectStore(target);
    if (!classStore[propertyKey]) {
      classStore[propertyKey] = { type, sourceName };
    }
  };
}
function generateExpandMember(setCallback, targetKey = null) {
  return (target, propertyKey) => {
    const key = targetKey || "_" + propertyKey;
    Object.defineProperty(target, propertyKey, {
      get: function() {
        return this[key];
      },
      set: function(value) {
        var _a2;
        if (typeof ((_a2 = this[key]) == null ? void 0 : _a2.equals) === "function") {
          if (this[key].equals(value)) {
            return;
          }
        }
        if (this[key] === value) {
          return;
        }
        this[key] = value;
        target[setCallback].apply(this);
      },
      enumerable: true,
      configurable: true
    });
  };
}
function expandToProperty(callback, targetKey = null) {
  return generateExpandMember(callback, targetKey);
}
function serialize(sourceName) {
  return generateSerializableMember(0, sourceName);
}
function serializeAsTexture(sourceName) {
  return generateSerializableMember(1, sourceName);
}
function serializeAsColor3(sourceName) {
  return generateSerializableMember(2, sourceName);
}
function serializeAsFresnelParameters(sourceName) {
  return generateSerializableMember(3, sourceName);
}
function serializeAsVector2(sourceName) {
  return generateSerializableMember(4, sourceName);
}
function serializeAsVector3(sourceName) {
  return generateSerializableMember(5, sourceName);
}
function serializeAsMeshReference(sourceName) {
  return generateSerializableMember(6, sourceName);
}
function serializeAsColorCurves(sourceName) {
  return generateSerializableMember(7, sourceName);
}
function serializeAsColor4(sourceName) {
  return generateSerializableMember(8, sourceName);
}
function serializeAsImageProcessingConfiguration(sourceName) {
  return generateSerializableMember(9, sourceName);
}
function serializeAsQuaternion(sourceName) {
  return generateSerializableMember(10, sourceName);
}
function serializeAsMatrix(sourceName) {
  return generateSerializableMember(12, sourceName);
}
function nativeOverride(target, propertyKey, descriptor, predicate) {
  const jsFunc = descriptor.value;
  descriptor.value = (...params) => {
    let func = jsFunc;
    if (typeof _native !== "undefined" && _native[propertyKey]) {
      const nativeFunc = _native[propertyKey];
      if (predicate) {
        func = (...params2) => predicate(...params2) ? nativeFunc(...params2) : jsFunc(...params2);
      } else {
        func = nativeFunc;
      }
    }
    target[propertyKey] = func;
    return func(...params);
  };
}
nativeOverride.filter = function(predicate) {
  return (target, propertyKey, descriptor) => nativeOverride(target, propertyKey, descriptor, predicate);
};
const isWeakRefSupported = typeof WeakRef !== "undefined";
class EventState {
  /**
   * Create a new EventState
   * @param mask defines the mask associated with this state
   * @param skipNextObservers defines a flag which will instruct the observable to skip following observers when set to true
   * @param target defines the original target of the state
   * @param currentTarget defines the current target of the state
   */
  constructor(mask, skipNextObservers = false, target, currentTarget) {
    this.initialize(mask, skipNextObservers, target, currentTarget);
  }
  /**
   * Initialize the current event state
   * @param mask defines the mask associated with this state
   * @param skipNextObservers defines a flag which will instruct the observable to skip following observers when set to true
   * @param target defines the original target of the state
   * @param currentTarget defines the current target of the state
   * @returns the current event state
   */
  initialize(mask, skipNextObservers = false, target, currentTarget) {
    this.mask = mask;
    this.skipNextObservers = skipNextObservers;
    this.target = target;
    this.currentTarget = currentTarget;
    return this;
  }
}
class Observer {
  /**
   * Creates a new observer
   * @param callback defines the callback to call when the observer is notified
   * @param mask defines the mask of the observer (used to filter notifications)
   * @param scope defines the current scope used to restore the JS context
   */
  constructor(callback, mask, scope = null) {
    this.callback = callback;
    this.mask = mask;
    this.scope = scope;
    this._willBeUnregistered = false;
    this.unregisterOnNextCall = false;
    this._remove = null;
  }
  /**
   * Remove the observer from its observable
   * This can be used instead of using the observable's remove function.
   */
  remove() {
    if (this._remove) {
      this._remove();
    }
  }
}
class Observable {
  /**
   * Create an observable from a Promise.
   * @param promise a promise to observe for fulfillment.
   * @param onErrorObservable an observable to notify if a promise was rejected.
   * @returns the new Observable
   */
  static FromPromise(promise, onErrorObservable) {
    const observable = new Observable();
    promise.then((ret) => {
      observable.notifyObservers(ret);
    }).catch((err) => {
      if (onErrorObservable) {
        onErrorObservable.notifyObservers(err);
      } else {
        throw err;
      }
    });
    return observable;
  }
  /**
   * Gets the list of observers
   * Note that observers that were recently deleted may still be present in the list because they are only really deleted on the next javascript tick!
   */
  get observers() {
    return this._observers;
  }
  /**
   * Creates a new observable
   * @param onObserverAdded defines a callback to call when a new observer is added
   * @param notifyIfTriggered If set to true the observable will notify when an observer was added if the observable was already triggered.
   */
  constructor(onObserverAdded, notifyIfTriggered = false) {
    this.notifyIfTriggered = notifyIfTriggered;
    this._observers = new Array();
    this._numObserversMarkedAsDeleted = 0;
    this._hasNotified = false;
    this._eventState = new EventState(0);
    if (onObserverAdded) {
      this._onObserverAdded = onObserverAdded;
    }
  }
  add(callback, mask = -1, insertFirst = false, scope = null, unregisterOnFirstCall = false) {
    if (!callback) {
      return null;
    }
    const observer2 = new Observer(callback, mask, scope);
    observer2.unregisterOnNextCall = unregisterOnFirstCall;
    if (insertFirst) {
      this._observers.unshift(observer2);
    } else {
      this._observers.push(observer2);
    }
    if (this._onObserverAdded) {
      this._onObserverAdded(observer2);
    }
    if (this._hasNotified && this.notifyIfTriggered) {
      if (this._lastNotifiedValue !== void 0) {
        this.notifyObserver(observer2, this._lastNotifiedValue);
      }
    }
    const observableWeakRef = isWeakRefSupported ? new WeakRef(this) : { deref: () => this };
    observer2._remove = () => {
      const observable = observableWeakRef.deref();
      if (observable) {
        observable._remove(observer2);
      }
    };
    return observer2;
  }
  addOnce(callback) {
    return this.add(callback, void 0, void 0, void 0, true);
  }
  /**
   * Remove an Observer from the Observable object
   * @param observer the instance of the Observer to remove
   * @returns false if it doesn't belong to this Observable
   */
  remove(observer2) {
    if (!observer2) {
      return false;
    }
    observer2._remove = null;
    const index2 = this._observers.indexOf(observer2);
    if (index2 !== -1) {
      this._deferUnregister(observer2);
      return true;
    }
    return false;
  }
  /**
   * Remove a callback from the Observable object
   * @param callback the callback to remove
   * @param scope optional scope. If used only the callbacks with this scope will be removed
   * @returns false if it doesn't belong to this Observable
   */
  removeCallback(callback, scope) {
    for (let index2 = 0; index2 < this._observers.length; index2++) {
      const observer2 = this._observers[index2];
      if (observer2._willBeUnregistered) {
        continue;
      }
      if (observer2.callback === callback && (!scope || scope === observer2.scope)) {
        this._deferUnregister(observer2);
        return true;
      }
    }
    return false;
  }
  /**
   * @internal
   */
  _deferUnregister(observer2) {
    if (observer2._willBeUnregistered) {
      return;
    }
    this._numObserversMarkedAsDeleted++;
    observer2.unregisterOnNextCall = false;
    observer2._willBeUnregistered = true;
    setTimeout(() => {
      this._remove(observer2);
    }, 0);
  }
  // This should only be called when not iterating over _observers to avoid callback skipping.
  // Removes an observer from the _observer Array.
  _remove(observer2, updateCounter = true) {
    if (!observer2) {
      return false;
    }
    const index2 = this._observers.indexOf(observer2);
    if (index2 !== -1) {
      if (updateCounter) {
        this._numObserversMarkedAsDeleted--;
      }
      this._observers.splice(index2, 1);
      return true;
    }
    return false;
  }
  /**
   * Moves the observable to the top of the observer list making it get called first when notified
   * @param observer the observer to move
   */
  makeObserverTopPriority(observer2) {
    this._remove(observer2, false);
    this._observers.unshift(observer2);
  }
  /**
   * Moves the observable to the bottom of the observer list making it get called last when notified
   * @param observer the observer to move
   */
  makeObserverBottomPriority(observer2) {
    this._remove(observer2, false);
    this._observers.push(observer2);
  }
  /**
   * Notify all Observers by calling their respective callback with the given data
   * Will return true if all observers were executed, false if an observer set skipNextObservers to true, then prevent the subsequent ones to execute
   * @param eventData defines the data to send to all observers
   * @param mask defines the mask of the current notification (observers with incompatible mask (ie mask & observer.mask === 0) will not be notified)
   * @param target defines the original target of the state
   * @param currentTarget defines the current target of the state
   * @param userInfo defines any user info to send to observers
   * @returns false if the complete observer chain was not processed (because one observer set the skipNextObservers to true)
   */
  notifyObservers(eventData, mask = -1, target, currentTarget, userInfo) {
    if (this.notifyIfTriggered) {
      this._hasNotified = true;
      this._lastNotifiedValue = eventData;
    }
    if (!this._observers.length) {
      return true;
    }
    const state = this._eventState;
    state.mask = mask;
    state.target = target;
    state.currentTarget = currentTarget;
    state.skipNextObservers = false;
    state.lastReturnValue = eventData;
    state.userInfo = userInfo;
    for (const obs of this._observers) {
      if (obs._willBeUnregistered) {
        continue;
      }
      if (obs.mask & mask) {
        if (obs.unregisterOnNextCall) {
          this._deferUnregister(obs);
        }
        if (obs.scope) {
          state.lastReturnValue = obs.callback.apply(obs.scope, [eventData, state]);
        } else {
          state.lastReturnValue = obs.callback(eventData, state);
        }
      }
      if (state.skipNextObservers) {
        return false;
      }
    }
    return true;
  }
  /**
   * Notify a specific observer
   * @param observer defines the observer to notify
   * @param eventData defines the data to be sent to each callback
   * @param mask is used to filter observers defaults to -1
   */
  notifyObserver(observer2, eventData, mask = -1) {
    if (this.notifyIfTriggered) {
      this._hasNotified = true;
      this._lastNotifiedValue = eventData;
    }
    if (observer2._willBeUnregistered) {
      return;
    }
    const state = this._eventState;
    state.mask = mask;
    state.skipNextObservers = false;
    if (observer2.unregisterOnNextCall) {
      this._deferUnregister(observer2);
    }
    observer2.callback(eventData, state);
  }
  /**
   * Gets a boolean indicating if the observable has at least one observer
   * @returns true is the Observable has at least one Observer registered
   */
  hasObservers() {
    return this._observers.length - this._numObserversMarkedAsDeleted > 0;
  }
  /**
   * Clear the list of observers
   */
  clear() {
    while (this._observers.length) {
      const o2 = this._observers.pop();
      if (o2) {
        o2._remove = null;
      }
    }
    this._onObserverAdded = null;
    this._numObserversMarkedAsDeleted = 0;
    this.cleanLastNotifiedState();
  }
  /**
   * Clean the last notified state - both the internal last value and the has-notified flag
   */
  cleanLastNotifiedState() {
    this._hasNotified = false;
    this._lastNotifiedValue = void 0;
  }
  /**
   * Clone the current observable
   * @returns a new observable
   */
  clone() {
    const result = new Observable();
    result._observers = this._observers.slice(0);
    return result;
  }
  /**
   * Does this observable handles observer registered with a given mask
   * @param mask defines the mask to be tested
   * @returns whether or not one observer registered with the given mask is handled
   **/
  hasSpecificMask(mask = -1) {
    for (const obs of this._observers) {
      if (obs.mask & mask || obs.mask === mask) {
        return true;
      }
    }
    return false;
  }
}
const ToGammaSpace = 1 / 2.2;
const ToLinearSpace = 2.2;
const Epsilon = 1e-3;
function BuildArray(size, itemBuilder) {
  const a2 = [];
  for (let i2 = 0; i2 < size; ++i2) {
    a2.push(itemBuilder());
  }
  return a2;
}
function BuildTuple(size, itemBuilder) {
  return BuildArray(size, itemBuilder);
}
function _observeArrayfunction(object, functionName, callback) {
  const oldFunction = object[functionName];
  if (typeof oldFunction !== "function") {
    return null;
  }
  const newFunction = function() {
    const previousLength = object.length;
    const returnValue = newFunction.previous.apply(object, arguments);
    callback(functionName, previousLength);
    return returnValue;
  };
  oldFunction.next = newFunction;
  newFunction.previous = oldFunction;
  object[functionName] = newFunction;
  return () => {
    const previous = newFunction.previous;
    if (!previous) {
      return;
    }
    const next = newFunction.next;
    if (next) {
      previous.next = next;
      next.previous = previous;
    } else {
      previous.next = void 0;
      object[functionName] = previous;
    }
    newFunction.next = void 0;
    newFunction.previous = void 0;
  };
}
const observedArrayFunctions = ["push", "splice", "pop", "shift", "unshift"];
function _ObserveArray(array, callback) {
  const unObserveFunctions = observedArrayFunctions.map((name2) => {
    return _observeArrayfunction(array, name2, callback);
  });
  return () => {
    unObserveFunctions.forEach((unObserveFunction) => {
      unObserveFunction == null ? void 0 : unObserveFunction();
    });
  };
}
const _RegisteredTypes = {};
function RegisterClass(className, type) {
  _RegisteredTypes[className] = type;
}
function GetClass(fqdn) {
  return _RegisteredTypes[fqdn];
}
class PerformanceConfigurator {
  /**
   * @internal
   */
  static SetMatrixPrecision(use64bits) {
    PerformanceConfigurator.MatrixTrackPrecisionChange = false;
    if (use64bits && !PerformanceConfigurator.MatrixUse64Bits) {
      if (PerformanceConfigurator.MatrixTrackedMatrices) {
        for (let m2 = 0; m2 < PerformanceConfigurator.MatrixTrackedMatrices.length; ++m2) {
          const matrix = PerformanceConfigurator.MatrixTrackedMatrices[m2];
          const values = matrix._m;
          matrix._m = new Array(16);
          for (let i2 = 0; i2 < 16; ++i2) {
            matrix._m[i2] = values[i2];
          }
        }
      }
    }
    PerformanceConfigurator.MatrixUse64Bits = use64bits;
    PerformanceConfigurator.MatrixCurrentType = PerformanceConfigurator.MatrixUse64Bits ? Array : Float32Array;
    PerformanceConfigurator.MatrixTrackedMatrices = null;
  }
}
PerformanceConfigurator.MatrixUse64Bits = false;
PerformanceConfigurator.MatrixTrackPrecisionChange = true;
PerformanceConfigurator.MatrixCurrentType = Float32Array;
PerformanceConfigurator.MatrixTrackedMatrices = [];
class EngineStore {
  /**
   * Gets the latest created engine
   */
  static get LastCreatedEngine() {
    if (this.Instances.length === 0) {
      return null;
    }
    return this.Instances[this.Instances.length - 1];
  }
  /**
   * Gets the latest created scene
   */
  static get LastCreatedScene() {
    return this._LastCreatedScene;
  }
}
EngineStore.Instances = [];
EngineStore.OnEnginesDisposedObservable = new Observable();
EngineStore._LastCreatedScene = null;
EngineStore.UseFallbackTexture = true;
EngineStore.FallbackTexture = "";
function ExtractAsInt(value) {
  return parseInt(value.toString().replace(/\W/g, ""));
}
function WithinEpsilon(a2, b2, epsilon = 1401298e-51) {
  return Math.abs(a2 - b2) <= epsilon;
}
function OutsideRange(num, min, max, epsilon = 1401298e-51) {
  return num < min - epsilon || num > max + epsilon;
}
function RandomRange(min, max) {
  if (min === max) {
    return min;
  }
  return Math.random() * (max - min) + min;
}
function Lerp(start, end, amount) {
  return start + (end - start) * amount;
}
function LerpAngle(start, end, amount) {
  let num = Repeat(end - start, 360);
  if (num > 180) {
    num -= 360;
  }
  return start + num * Clamp(amount);
}
function InverseLerp(a2, b2, value) {
  let result = 0;
  if (a2 != b2) {
    result = Clamp((value - a2) / (b2 - a2));
  } else {
    result = 0;
  }
  return result;
}
function Hermite(value1, tangent1, value2, tangent2, amount) {
  const squared = amount * amount;
  const cubed = amount * squared;
  const part1 = 2 * cubed - 3 * squared + 1;
  const part2 = -2 * cubed + 3 * squared;
  const part3 = cubed - 2 * squared + amount;
  const part4 = cubed - squared;
  return value1 * part1 + value2 * part2 + tangent1 * part3 + tangent2 * part4;
}
function Hermite1stDerivative(value1, tangent1, value2, tangent2, time) {
  const t2 = time * time;
  return (t2 - time) * 6 * value1 + (3 * t2 - 4 * time + 1) * tangent1 + (-t2 + time) * 6 * value2 + (3 * t2 - 2 * time) * tangent2;
}
function Clamp(value, min = 0, max = 1) {
  return Math.min(max, Math.max(min, value));
}
function NormalizeRadians(angle) {
  angle -= Math.PI * 2 * Math.floor((angle + Math.PI) / (Math.PI * 2));
  return angle;
}
function ToHex(i2) {
  const str = i2.toString(16);
  if (i2 <= 15) {
    return ("0" + str).toUpperCase();
  }
  return str.toUpperCase();
}
function ILog2(value) {
  if (Math.log2) {
    return Math.floor(Math.log2(value));
  }
  if (value < 0) {
    return NaN;
  } else if (value === 0) {
    return -Infinity;
  }
  let n3 = 0;
  if (value < 1) {
    while (value < 1) {
      n3++;
      value = value * 2;
    }
    n3 = -n3;
  } else if (value > 1) {
    while (value > 1) {
      n3++;
      value = Math.floor(value / 2);
    }
  }
  return n3;
}
function Repeat(value, length) {
  return value - Math.floor(value / length) * length;
}
function Normalize(value, min, max) {
  return (value - min) / (max - min);
}
function Denormalize(normalized, min, max) {
  return normalized * (max - min) + min;
}
function DeltaAngle(current, target) {
  let num = Repeat(target - current, 360);
  if (num > 180) {
    num -= 360;
  }
  return num;
}
function PingPong(tx, length) {
  const t2 = Repeat(tx, length * 2);
  return length - Math.abs(t2 - length);
}
function SmoothStep(from, to, tx) {
  let t2 = Clamp(tx);
  t2 = -2 * t2 * t2 * t2 + 3 * t2 * t2;
  return to * t2 + from * (1 - t2);
}
function MoveTowards(current, target, maxDelta) {
  let result = 0;
  if (Math.abs(target - current) <= maxDelta) {
    result = target;
  } else {
    result = current + Math.sign(target - current) * maxDelta;
  }
  return result;
}
function MoveTowardsAngle(current, target, maxDelta) {
  const num = DeltaAngle(current, target);
  let result = 0;
  if (-maxDelta < num && num < maxDelta) {
    result = target;
  } else {
    target = current + num;
    result = MoveTowards(current, target, maxDelta);
  }
  return result;
}
function RangeToPercent(number, min, max) {
  return (number - min) / (max - min);
}
function PercentToRange(percent, min, max) {
  return (max - min) * percent + min;
}
function HighestCommonFactor(a2, b2) {
  const r3 = a2 % b2;
  if (r3 === 0) {
    return b2;
  }
  return HighestCommonFactor(b2, r3);
}
const functions = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  Clamp,
  DeltaAngle,
  Denormalize,
  ExtractAsInt,
  Hermite,
  Hermite1stDerivative,
  HighestCommonFactor,
  ILog2,
  InverseLerp,
  Lerp,
  LerpAngle,
  MoveTowards,
  MoveTowardsAngle,
  Normalize,
  NormalizeRadians,
  OutsideRange,
  PercentToRange,
  PingPong,
  RandomRange,
  RangeToPercent,
  Repeat,
  SmoothStep,
  ToHex,
  WithinEpsilon
}, Symbol.toStringTag, { value: "Module" }));
const _ExtractAsInt = (value) => {
  return parseInt(value.toString().replace(/\W/g, ""));
};
class Vector2 {
  /**
   * Creates a new Vector2 from the given x and y coordinates
   * @param x defines the first coordinate
   * @param y defines the second coordinate
   */
  constructor(x2 = 0, y2 = 0) {
    this.x = x2;
    this.y = y2;
  }
  /**
   * Gets a string with the Vector2 coordinates
   * @returns a string with the Vector2 coordinates
   */
  toString() {
    return `{X: ${this.x} Y: ${this.y}}`;
  }
  /**
   * Gets class name
   * @returns the string "Vector2"
   */
  getClassName() {
    return "Vector2";
  }
  /**
   * Gets current vector hash code
   * @returns the Vector2 hash code as a number
   */
  getHashCode() {
    const x2 = _ExtractAsInt(this.x);
    const y2 = _ExtractAsInt(this.y);
    let hash = x2;
    hash = hash * 397 ^ y2;
    return hash;
  }
  // Operators
  /**
   * Sets the Vector2 coordinates in the given array or Float32Array from the given index.
   * Example Playground https://playground.babylonjs.com/#QYBWV4#15
   * @param array defines the source array
   * @param index defines the offset in source array
   * @returns the current Vector2
   */
  toArray(array, index2 = 0) {
    array[index2] = this.x;
    array[index2 + 1] = this.y;
    return this;
  }
  /**
   * Update the current vector from an array
   * Example Playground https://playground.babylonjs.com/#QYBWV4#39
   * @param array defines the destination array
   * @param offset defines the offset in the destination array
   * @returns the current Vector2
   */
  fromArray(array, offset = 0) {
    Vector2.FromArrayToRef(array, offset, this);
    return this;
  }
  /**
   * Copy the current vector to an array
   * Example Playground https://playground.babylonjs.com/#QYBWV4#40
   * @returns a new array with 2 elements: the Vector2 coordinates.
   */
  asArray() {
    return [this.x, this.y];
  }
  /**
   * Sets the Vector2 coordinates with the given Vector2 coordinates
   * Example Playground https://playground.babylonjs.com/#QYBWV4#24
   * @param source defines the source Vector2
   * @returns the current updated Vector2
   */
  copyFrom(source) {
    this.x = source.x;
    this.y = source.y;
    return this;
  }
  /**
   * Sets the Vector2 coordinates with the given floats
   * Example Playground https://playground.babylonjs.com/#QYBWV4#25
   * @param x defines the first coordinate
   * @param y defines the second coordinate
   * @returns the current updated Vector2
   */
  copyFromFloats(x2, y2) {
    this.x = x2;
    this.y = y2;
    return this;
  }
  /**
   * Sets the Vector2 coordinates with the given floats
   * Example Playground https://playground.babylonjs.com/#QYBWV4#62
   * @param x defines the first coordinate
   * @param y defines the second coordinate
   * @returns the current updated Vector2
   */
  set(x2, y2) {
    return this.copyFromFloats(x2, y2);
  }
  /**
   * Copies the given float to the current Vector2 coordinates
   * @param v defines the x and y coordinates of the operand
   * @returns the current updated Vector2
   */
  setAll(v2) {
    return this.copyFromFloats(v2, v2);
  }
  /**
   * Add another vector with the current one
   * Example Playground https://playground.babylonjs.com/#QYBWV4#11
   * @param otherVector defines the other vector
   * @returns a new Vector2 set with the addition of the current Vector2 and the given one coordinates
   */
  add(otherVector) {
    return new Vector2(this.x + otherVector.x, this.y + otherVector.y);
  }
  /**
   * Sets the "result" coordinates with the addition of the current Vector2 and the given one coordinates
   * Example Playground https://playground.babylonjs.com/#QYBWV4#12
   * @param otherVector defines the other vector
   * @param result defines the target vector
   * @returns result input
   */
  addToRef(otherVector, result) {
    result.x = this.x + otherVector.x;
    result.y = this.y + otherVector.y;
    return result;
  }
  /**
   * Set the Vector2 coordinates by adding the given Vector2 coordinates
   * Example Playground https://playground.babylonjs.com/#QYBWV4#13
   * @param otherVector defines the other vector
   * @returns the current updated Vector2
   */
  addInPlace(otherVector) {
    this.x += otherVector.x;
    this.y += otherVector.y;
    return this;
  }
  /**
   * Adds the given coordinates to the current Vector2
   * @param x defines the x coordinate of the operand
   * @param y defines the y coordinate of the operand
   * @returns the current updated Vector2
   */
  addInPlaceFromFloats(x2, y2) {
    this.x += x2;
    this.y += y2;
    return this;
  }
  /**
   * Gets a new Vector2 by adding the current Vector2 coordinates to the given Vector3 x, y coordinates
   * Example Playground https://playground.babylonjs.com/#QYBWV4#14
   * @param otherVector defines the other vector
   * @returns a new Vector2
   */
  addVector3(otherVector) {
    return new Vector2(this.x + otherVector.x, this.y + otherVector.y);
  }
  /**
   * Gets a new Vector2 set with the subtracted coordinates of the given one from the current Vector2
   * Example Playground https://playground.babylonjs.com/#QYBWV4#61
   * @param otherVector defines the other vector
   * @returns a new Vector2
   */
  subtract(otherVector) {
    return new Vector2(this.x - otherVector.x, this.y - otherVector.y);
  }
  /**
   * Sets the "result" coordinates with the subtraction of the given one from the current Vector2 coordinates.
   * Example Playground https://playground.babylonjs.com/#QYBWV4#63
   * @param otherVector defines the other vector
   * @param result defines the target vector
   * @returns result input
   */
  subtractToRef(otherVector, result) {
    result.x = this.x - otherVector.x;
    result.y = this.y - otherVector.y;
    return result;
  }
  /**
   * Sets the current Vector2 coordinates by subtracting from it the given one coordinates
   * Example Playground https://playground.babylonjs.com/#QYBWV4#88
   * @param otherVector defines the other vector
   * @returns the current updated Vector2
   */
  subtractInPlace(otherVector) {
    this.x -= otherVector.x;
    this.y -= otherVector.y;
    return this;
  }
  /**
   * Multiplies in place the current Vector2 coordinates by the given ones
   * Example Playground https://playground.babylonjs.com/#QYBWV4#43
   * @param otherVector defines the other vector
   * @returns the current updated Vector2
   */
  multiplyInPlace(otherVector) {
    this.x *= otherVector.x;
    this.y *= otherVector.y;
    return this;
  }
  /**
   * Returns a new Vector2 set with the multiplication of the current Vector2 and the given one coordinates
   * Example Playground https://playground.babylonjs.com/#QYBWV4#42
   * @param otherVector defines the other vector
   * @returns a new Vector2
   */
  multiply(otherVector) {
    return new Vector2(this.x * otherVector.x, this.y * otherVector.y);
  }
  /**
   * Sets "result" coordinates with the multiplication of the current Vector2 and the given one coordinates
   * Example Playground https://playground.babylonjs.com/#QYBWV4#44
   * @param otherVector defines the other vector
   * @param result defines the target vector
   * @returns result input
   */
  multiplyToRef(otherVector, result) {
    result.x = this.x * otherVector.x;
    result.y = this.y * otherVector.y;
    return result;
  }
  /**
   * Gets a new Vector2 set with the Vector2 coordinates multiplied by the given floats
   * Example Playground https://playground.babylonjs.com/#QYBWV4#89
   * @param x defines the first coordinate
   * @param y defines the second coordinate
   * @returns a new Vector2
   */
  multiplyByFloats(x2, y2) {
    return new Vector2(this.x * x2, this.y * y2);
  }
  /**
   * Returns a new Vector2 set with the Vector2 coordinates divided by the given one coordinates
   * Example Playground https://playground.babylonjs.com/#QYBWV4#27
   * @param otherVector defines the other vector
   * @returns a new Vector2
   */
  divide(otherVector) {
    return new Vector2(this.x / otherVector.x, this.y / otherVector.y);
  }
  /**
   * Sets the "result" coordinates with the Vector2 divided by the given one coordinates
   * Example Playground https://playground.babylonjs.com/#QYBWV4#30
   * @param otherVector defines the other vector
   * @param result defines the target vector
   * @returns result input
   */
  divideToRef(otherVector, result) {
    result.x = this.x / otherVector.x;
    result.y = this.y / otherVector.y;
    return result;
  }
  /**
   * Divides the current Vector2 coordinates by the given ones
   * Example Playground https://playground.babylonjs.com/#QYBWV4#28
   * @param otherVector defines the other vector
   * @returns the current updated Vector2
   */
  divideInPlace(otherVector) {
    this.x = this.x / otherVector.x;
    this.y = this.y / otherVector.y;
    return this;
  }
  /**
   * Updates the current Vector2 with the minimal coordinate values between its and the given vector ones
   * @param other defines the second operand
   * @returns the current updated Vector2
   */
  minimizeInPlace(other) {
    return this.minimizeInPlaceFromFloats(other.x, other.y);
  }
  /**
   * Updates the current Vector2 with the maximal coordinate values between its and the given vector ones.
   * @param other defines the second operand
   * @returns the current updated Vector2
   */
  maximizeInPlace(other) {
    return this.maximizeInPlaceFromFloats(other.x, other.y);
  }
  /**
   * Updates the current Vector2 with the minimal coordinate values between its and the given coordinates
   * @param x defines the x coordinate of the operand
   * @param y defines the y coordinate of the operand
   * @returns the current updated Vector2
   */
  minimizeInPlaceFromFloats(x2, y2) {
    this.x = Math.min(x2, this.x);
    this.y = Math.min(y2, this.y);
    return this;
  }
  /**
   * Updates the current Vector2 with the maximal coordinate values between its and the given coordinates.
   * @param x defines the x coordinate of the operand
   * @param y defines the y coordinate of the operand
   * @returns the current updated Vector2
   */
  maximizeInPlaceFromFloats(x2, y2) {
    this.x = Math.max(x2, this.x);
    this.y = Math.max(y2, this.y);
    return this;
  }
  /**
   * Returns a new Vector2 set with the subtraction of the given floats from the current Vector2 coordinates
   * @param x defines the x coordinate of the operand
   * @param y defines the y coordinate of the operand
   * @returns the resulting Vector2
   */
  subtractFromFloats(x2, y2) {
    return new Vector2(this.x - x2, this.y - y2);
  }
  /**
   * Subtracts the given floats from the current Vector2 coordinates and set the given vector "result" with this result
   * @param x defines the x coordinate of the operand
   * @param y defines the y coordinate of the operand
   * @param result defines the Vector2 object where to store the result
   * @returns the result
   */
  subtractFromFloatsToRef(x2, y2, result) {
    result.x = this.x - x2;
    result.y = this.y - y2;
    return result;
  }
  /**
   * Gets a new Vector2 with current Vector2 negated coordinates
   * @returns a new Vector2
   */
  negate() {
    return new Vector2(-this.x, -this.y);
  }
  /**
   * Negate this vector in place
   * Example Playground https://playground.babylonjs.com/#QYBWV4#23
   * @returns this
   */
  negateInPlace() {
    this.x *= -1;
    this.y *= -1;
    return this;
  }
  /**
   * Negate the current Vector2 and stores the result in the given vector "result" coordinates
   * Example Playground https://playground.babylonjs.com/#QYBWV4#41
   * @param result defines the Vector3 object where to store the result
   * @returns the result
   */
  negateToRef(result) {
    result.x = -this.x;
    result.y = -this.y;
    return result;
  }
  /**
   * Multiply the Vector2 coordinates by
   * Example Playground https://playground.babylonjs.com/#QYBWV4#59
   * @param scale defines the scaling factor
   * @returns the current updated Vector2
   */
  scaleInPlace(scale) {
    this.x *= scale;
    this.y *= scale;
    return this;
  }
  /**
   * Returns a new Vector2 scaled by "scale" from the current Vector2
   * Example Playground https://playground.babylonjs.com/#QYBWV4#52
   * @param scale defines the scaling factor
   * @returns a new Vector2
   */
  scale(scale) {
    return new Vector2(this.x * scale, this.y * scale);
  }
  /**
   * Scale the current Vector2 values by a factor to a given Vector2
   * Example Playground https://playground.babylonjs.com/#QYBWV4#57
   * @param scale defines the scale factor
   * @param result defines the Vector2 object where to store the result
   * @returns result input
   */
  scaleToRef(scale, result) {
    result.x = this.x * scale;
    result.y = this.y * scale;
    return result;
  }
  /**
   * Scale the current Vector2 values by a factor and add the result to a given Vector2
   * Example Playground https://playground.babylonjs.com/#QYBWV4#58
   * @param scale defines the scale factor
   * @param result defines the Vector2 object where to store the result
   * @returns result input
   */
  scaleAndAddToRef(scale, result) {
    result.x += this.x * scale;
    result.y += this.y * scale;
    return result;
  }
  /**
   * Gets a boolean if two vectors are equals
   * Example Playground https://playground.babylonjs.com/#QYBWV4#31
   * @param otherVector defines the other vector
   * @returns true if the given vector coordinates strictly equal the current Vector2 ones
   */
  equals(otherVector) {
    return otherVector && this.x === otherVector.x && this.y === otherVector.y;
  }
  /**
   * Gets a boolean if two vectors are equals (using an epsilon value)
   * Example Playground https://playground.babylonjs.com/#QYBWV4#32
   * @param otherVector defines the other vector
   * @param epsilon defines the minimal distance to consider equality
   * @returns true if the given vector coordinates are close to the current ones by a distance of epsilon.
   */
  equalsWithEpsilon(otherVector, epsilon = Epsilon) {
    return otherVector && WithinEpsilon(this.x, otherVector.x, epsilon) && WithinEpsilon(this.y, otherVector.y, epsilon);
  }
  /**
   * Returns true if the current Vector2 coordinates equals the given floats
   * @param x defines the x coordinate of the operand
   * @param y defines the y coordinate of the operand
   * @returns true if both vectors are equal
   */
  equalsToFloats(x2, y2) {
    return this.x === x2 && this.y === y2;
  }
  /**
   * Gets a new Vector2 from current Vector2 floored values
   * Example Playground https://playground.babylonjs.com/#QYBWV4#35
   * eg (1.2, 2.31) returns (1, 2)
   * @returns a new Vector2
   */
  floor() {
    return new Vector2(Math.floor(this.x), Math.floor(this.y));
  }
  /**
   * Gets the current Vector2's floored values and stores them in result
   * @param result the Vector2 to store the result in
   * @returns the result Vector2
   */
  floorToRef(result) {
    result.x = Math.floor(this.x);
    result.y = Math.floor(this.y);
    return result;
  }
  /**
   * Gets a new Vector2 from current Vector2 fractional values
   * Example Playground https://playground.babylonjs.com/#QYBWV4#34
   * eg (1.2, 2.31) returns (0.2, 0.31)
   * @returns a new Vector2
   */
  fract() {
    return new Vector2(this.x - Math.floor(this.x), this.y - Math.floor(this.y));
  }
  /**
   * Gets the current Vector2's fractional values and stores them in result
   * @param result the Vector2 to store the result in
   * @returns the result Vector2
   */
  fractToRef(result) {
    result.x = this.x - Math.floor(this.x);
    result.y = this.y - Math.floor(this.y);
    return result;
  }
  /**
   * Rotate the current vector into a given result vector
   * Example Playground https://playground.babylonjs.com/#QYBWV4#49
   * @param angle defines the rotation angle
   * @param result defines the result vector where to store the rotated vector
   * @returns result input
   */
  rotateToRef(angle, result) {
    const cos = Math.cos(angle);
    const sin = Math.sin(angle);
    const x2 = cos * this.x - sin * this.y;
    const y2 = sin * this.x + cos * this.y;
    result.x = x2;
    result.y = y2;
    return result;
  }
  // Properties
  /**
   * Gets the length of the vector
   * @returns the vector length (float)
   */
  length() {
    return Math.sqrt(this.x * this.x + this.y * this.y);
  }
  /**
   * Gets the vector squared length
   * @returns the vector squared length (float)
   */
  lengthSquared() {
    return this.x * this.x + this.y * this.y;
  }
  // Methods
  /**
   * Normalize the vector
   * Example Playground https://playground.babylonjs.com/#QYBWV4#48
   * @returns the current updated Vector2
   */
  normalize() {
    return this.normalizeFromLength(this.length());
  }
  /**
   * Normalize the current Vector2 with the given input length.
   * Please note that this is an in place operation.
   * @param len the length of the vector
   * @returns the current updated Vector2
   */
  normalizeFromLength(len) {
    if (len === 0 || len === 1) {
      return this;
    }
    return this.scaleInPlace(1 / len);
  }
  /**
   * Normalize the current Vector2 to a new vector
   * @returns the new Vector2
   */
  normalizeToNew() {
    const normalized = new Vector2();
    this.normalizeToRef(normalized);
    return normalized;
  }
  /**
   * Normalize the current Vector2 to the reference
   * @param result define the Vector to update
   * @returns the updated Vector2
   */
  normalizeToRef(result) {
    const len = this.length();
    if (len === 0) {
      result.x = this.x;
      result.y = this.y;
    }
    return this.scaleToRef(1 / len, result);
  }
  /**
   * Gets a new Vector2 copied from the Vector2
   * Example Playground https://playground.babylonjs.com/#QYBWV4#20
   * @returns a new Vector2
   */
  clone() {
    return new Vector2(this.x, this.y);
  }
  /**
   * Gets the dot product of the current vector and the vector "otherVector"
   * @param otherVector defines second vector
   * @returns the dot product (float)
   */
  dot(otherVector) {
    return this.x * otherVector.x + this.y * otherVector.y;
  }
  // Statics
  /**
   * Gets a new Vector2(0, 0)
   * @returns a new Vector2
   */
  static Zero() {
    return new Vector2(0, 0);
  }
  /**
   * Gets a new Vector2(1, 1)
   * @returns a new Vector2
   */
  static One() {
    return new Vector2(1, 1);
  }
  /**
   * Returns a new Vector2 with random values between min and max
   * @param min the minimum random value
   * @param max the maximum random value
   * @returns a Vector2 with random values between min and max
   */
  static Random(min = 0, max = 1) {
    return new Vector2(RandomRange(min, max), RandomRange(min, max));
  }
  /**
   * Sets a Vector2 with random values between min and max
   * @param min the minimum random value
   * @param max the maximum random value
   * @param ref the ref to store the values in
   * @returns the ref with random values between min and max
   */
  static RandomToRef(min = 0, max = 1, ref) {
    return ref.copyFromFloats(RandomRange(min, max), RandomRange(min, max));
  }
  /**
   * Gets a zero Vector2 that must not be updated
   */
  static get ZeroReadOnly() {
    return Vector2._ZeroReadOnly;
  }
  /**
   * Gets a new Vector2 set from the given index element of the given array
   * Example Playground https://playground.babylonjs.com/#QYBWV4#79
   * @param array defines the data source
   * @param offset defines the offset in the data source
   * @returns a new Vector2
   */
  static FromArray(array, offset = 0) {
    return new Vector2(array[offset], array[offset + 1]);
  }
  /**
   * Sets "result" from the given index element of the given array
   * Example Playground https://playground.babylonjs.com/#QYBWV4#80
   * @param array defines the data source
   * @param offset defines the offset in the data source
   * @param result defines the target vector
   * @returns result input
   */
  static FromArrayToRef(array, offset, result) {
    result.x = array[offset];
    result.y = array[offset + 1];
    return result;
  }
  /**
   * Sets the given vector "result" with the given floats.
   * @param x defines the x coordinate of the source
   * @param y defines the y coordinate of the source
   * @param result defines the Vector2 where to store the result
   * @returns the result vector
   */
  static FromFloatsToRef(x2, y2, result) {
    result.copyFromFloats(x2, y2);
    return result;
  }
  /**
   * Gets a new Vector2 located for "amount" (float) on the CatmullRom spline defined by the given four Vector2
   * Example Playground https://playground.babylonjs.com/#QYBWV4#65
   * @param value1 defines 1st point of control
   * @param value2 defines 2nd point of control
   * @param value3 defines 3rd point of control
   * @param value4 defines 4th point of control
   * @param amount defines the interpolation factor
   * @returns a new Vector2
   */
  static CatmullRom(value1, value2, value3, value4, amount) {
    const squared = amount * amount;
    const cubed = amount * squared;
    const x2 = 0.5 * (2 * value2.x + (-value1.x + value3.x) * amount + (2 * value1.x - 5 * value2.x + 4 * value3.x - value4.x) * squared + (-value1.x + 3 * value2.x - 3 * value3.x + value4.x) * cubed);
    const y2 = 0.5 * (2 * value2.y + (-value1.y + value3.y) * amount + (2 * value1.y - 5 * value2.y + 4 * value3.y - value4.y) * squared + (-value1.y + 3 * value2.y - 3 * value3.y + value4.y) * cubed);
    return new Vector2(x2, y2);
  }
  /**
   * Sets reference with same the coordinates than "value" ones if the vector "value" is in the square defined by "min" and "max".
   * If a coordinate of "value" is lower than "min" coordinates, the returned Vector2 is given this "min" coordinate.
   * If a coordinate of "value" is greater than "max" coordinates, the returned Vector2 is given this "max" coordinate
   * @param value defines the value to clamp
   * @param min defines the lower limit
   * @param max defines the upper limit
   * @param ref the reference
   * @returns the reference
   */
  static ClampToRef(value, min, max, ref) {
    ref.x = Clamp(value.x, min.x, max.x);
    ref.y = Clamp(value.y, min.y, max.y);
    return ref;
  }
  /**
   * Returns a new Vector2 set with same the coordinates than "value" ones if the vector "value" is in the square defined by "min" and "max".
   * If a coordinate of "value" is lower than "min" coordinates, the returned Vector2 is given this "min" coordinate.
   * If a coordinate of "value" is greater than "max" coordinates, the returned Vector2 is given this "max" coordinate
   * Example Playground https://playground.babylonjs.com/#QYBWV4#76
   * @param value defines the value to clamp
   * @param min defines the lower limit
   * @param max defines the upper limit
   * @returns a new Vector2
   */
  static Clamp(value, min, max) {
    const x2 = Clamp(value.x, min.x, max.x);
    const y2 = Clamp(value.y, min.y, max.y);
    return new Vector2(x2, y2);
  }
  /**
   * Returns a new Vector2 located for "amount" (float) on the Hermite spline defined by the vectors "value1", "value2", "tangent1", "tangent2"
   * Example Playground https://playground.babylonjs.com/#QYBWV4#81
   * @param value1 defines the 1st control point
   * @param tangent1 defines the outgoing tangent
   * @param value2 defines the 2nd control point
   * @param tangent2 defines the incoming tangent
   * @param amount defines the interpolation factor
   * @returns a new Vector2
   */
  static Hermite(value1, tangent1, value2, tangent2, amount) {
    const squared = amount * amount;
    const cubed = amount * squared;
    const part1 = 2 * cubed - 3 * squared + 1;
    const part2 = -2 * cubed + 3 * squared;
    const part3 = cubed - 2 * squared + amount;
    const part4 = cubed - squared;
    const x2 = value1.x * part1 + value2.x * part2 + tangent1.x * part3 + tangent2.x * part4;
    const y2 = value1.y * part1 + value2.y * part2 + tangent1.y * part3 + tangent2.y * part4;
    return new Vector2(x2, y2);
  }
  /**
   * Returns a new Vector2 which is the 1st derivative of the Hermite spline defined by the vectors "value1", "value2", "tangent1", "tangent2".
   * Example Playground https://playground.babylonjs.com/#QYBWV4#82
   * @param value1 defines the first control point
   * @param tangent1 defines the first tangent
   * @param value2 defines the second control point
   * @param tangent2 defines the second tangent
   * @param time define where the derivative must be done
   * @returns 1st derivative
   */
  static Hermite1stDerivative(value1, tangent1, value2, tangent2, time) {
    return this.Hermite1stDerivativeToRef(value1, tangent1, value2, tangent2, time, new Vector2());
  }
  /**
   * Returns a new Vector2 which is the 1st derivative of the Hermite spline defined by the vectors "value1", "value2", "tangent1", "tangent2".
   * Example Playground https://playground.babylonjs.com/#QYBWV4#83
   * @param value1 defines the first control point
   * @param tangent1 defines the first tangent
   * @param value2 defines the second control point
   * @param tangent2 defines the second tangent
   * @param time define where the derivative must be done
   * @param result define where the derivative will be stored
   * @returns result input
   */
  static Hermite1stDerivativeToRef(value1, tangent1, value2, tangent2, time, result) {
    const t2 = time * time;
    result.x = (t2 - time) * 6 * value1.x + (3 * t2 - 4 * time + 1) * tangent1.x + (-t2 + time) * 6 * value2.x + (3 * t2 - 2 * time) * tangent2.x;
    result.y = (t2 - time) * 6 * value1.y + (3 * t2 - 4 * time + 1) * tangent1.y + (-t2 + time) * 6 * value2.y + (3 * t2 - 2 * time) * tangent2.y;
    return result;
  }
  /**
   * Returns a new Vector2 located for "amount" (float) on the linear interpolation between the vector "start" adn the vector "end".
   * Example Playground https://playground.babylonjs.com/#QYBWV4#84
   * @param start defines the start vector
   * @param end defines the end vector
   * @param amount defines the interpolation factor
   * @returns a new Vector2
   */
  static Lerp(start, end, amount) {
    return Vector2.LerpToRef(start, end, amount, new Vector2());
  }
  /**
   * Sets the given vector "result" with the result of the linear interpolation from the vector "start" for "amount" to the vector "end"
   * @param start defines the start value
   * @param end defines the end value
   * @param amount max defines amount between both (between 0 and 1)
   * @param result defines the Vector2 where to store the result
   * @returns result input
   */
  static LerpToRef(start, end, amount, result) {
    result.x = start.x + (end.x - start.x) * amount;
    result.y = start.y + (end.y - start.y) * amount;
    return result;
  }
  /**
   * Gets the dot product of the vector "left" and the vector "right"
   * Example Playground https://playground.babylonjs.com/#QYBWV4#90
   * @param left defines first vector
   * @param right defines second vector
   * @returns the dot product (float)
   */
  static Dot(left, right) {
    return left.x * right.x + left.y * right.y;
  }
  /**
   * Returns a new Vector2 equal to the normalized given vector
   * Example Playground https://playground.babylonjs.com/#QYBWV4#46
   * @param vector defines the vector to normalize
   * @returns a new Vector2
   */
  static Normalize(vector) {
    return Vector2.NormalizeToRef(vector, new Vector2());
  }
  /**
   * Normalize a given vector into a second one
   * Example Playground https://playground.babylonjs.com/#QYBWV4#50
   * @param vector defines the vector to normalize
   * @param result defines the vector where to store the result
   * @returns result input
   */
  static NormalizeToRef(vector, result) {
    vector.normalizeToRef(result);
    return result;
  }
  /**
   * Gets a new Vector2 set with the minimal coordinate values from the "left" and "right" vectors
   * Example Playground https://playground.babylonjs.com/#QYBWV4#86
   * @param left defines 1st vector
   * @param right defines 2nd vector
   * @returns a new Vector2
   */
  static Minimize(left, right) {
    const x2 = left.x < right.x ? left.x : right.x;
    const y2 = left.y < right.y ? left.y : right.y;
    return new Vector2(x2, y2);
  }
  /**
   * Gets a new Vector2 set with the maximal coordinate values from the "left" and "right" vectors
   * Example Playground https://playground.babylonjs.com/#QYBWV4#86
   * @param left defines 1st vector
   * @param right defines 2nd vector
   * @returns a new Vector2
   */
  static Maximize(left, right) {
    const x2 = left.x > right.x ? left.x : right.x;
    const y2 = left.y > right.y ? left.y : right.y;
    return new Vector2(x2, y2);
  }
  /**
   * Gets a new Vector2 set with the transformed coordinates of the given vector by the given transformation matrix
   * Example Playground https://playground.babylonjs.com/#QYBWV4#17
   * @param vector defines the vector to transform
   * @param transformation defines the matrix to apply
   * @returns a new Vector2
   */
  static Transform(vector, transformation) {
    return Vector2.TransformToRef(vector, transformation, new Vector2());
  }
  /**
   * Transforms the given vector coordinates by the given transformation matrix and stores the result in the vector "result" coordinates
   * Example Playground https://playground.babylonjs.com/#QYBWV4#19
   * @param vector defines the vector to transform
   * @param transformation defines the matrix to apply
   * @param result defines the target vector
   * @returns result input
   */
  static TransformToRef(vector, transformation, result) {
    const m2 = transformation.m;
    const x2 = vector.x * m2[0] + vector.y * m2[4] + m2[12];
    const y2 = vector.x * m2[1] + vector.y * m2[5] + m2[13];
    result.x = x2;
    result.y = y2;
    return result;
  }
  /**
   * Determines if a given vector is included in a triangle
   * Example Playground https://playground.babylonjs.com/#QYBWV4#87
   * @param p defines the vector to test
   * @param p0 defines 1st triangle point
   * @param p1 defines 2nd triangle point
   * @param p2 defines 3rd triangle point
   * @returns true if the point "p" is in the triangle defined by the vectors "p0", "p1", "p2"
   */
  static PointInTriangle(p2, p0, p1, p22) {
    const a2 = 1 / 2 * (-p1.y * p22.x + p0.y * (-p1.x + p22.x) + p0.x * (p1.y - p22.y) + p1.x * p22.y);
    const sign = a2 < 0 ? -1 : 1;
    const s2 = (p0.y * p22.x - p0.x * p22.y + (p22.y - p0.y) * p2.x + (p0.x - p22.x) * p2.y) * sign;
    const t2 = (p0.x * p1.y - p0.y * p1.x + (p0.y - p1.y) * p2.x + (p1.x - p0.x) * p2.y) * sign;
    return s2 > 0 && t2 > 0 && s2 + t2 < 2 * a2 * sign;
  }
  /**
   * Gets the distance between the vectors "value1" and "value2"
   * Example Playground https://playground.babylonjs.com/#QYBWV4#71
   * @param value1 defines first vector
   * @param value2 defines second vector
   * @returns the distance between vectors
   */
  static Distance(value1, value2) {
    return Math.sqrt(Vector2.DistanceSquared(value1, value2));
  }
  /**
   * Returns the squared distance between the vectors "value1" and "value2"
   * Example Playground https://playground.babylonjs.com/#QYBWV4#72
   * @param value1 defines first vector
   * @param value2 defines second vector
   * @returns the squared distance between vectors
   */
  static DistanceSquared(value1, value2) {
    const x2 = value1.x - value2.x;
    const y2 = value1.y - value2.y;
    return x2 * x2 + y2 * y2;
  }
  /**
   * Gets a new Vector2 located at the center of the vectors "value1" and "value2"
   * Example Playground https://playground.babylonjs.com/#QYBWV4#86
   * Example Playground https://playground.babylonjs.com/#QYBWV4#66
   * @param value1 defines first vector
   * @param value2 defines second vector
   * @returns a new Vector2
   */
  static Center(value1, value2) {
    return Vector2.CenterToRef(value1, value2, new Vector2());
  }
  /**
   * Gets the center of the vectors "value1" and "value2" and stores the result in the vector "ref"
   * Example Playground https://playground.babylonjs.com/#QYBWV4#66
   * @param value1 defines first vector
   * @param value2 defines second vector
   * @param ref defines third vector
   * @returns ref
   */
  static CenterToRef(value1, value2, ref) {
    return ref.copyFromFloats((value1.x + value2.x) / 2, (value1.y + value2.y) / 2);
  }
  /**
   * Gets the shortest distance (float) between the point "p" and the segment defined by the two points "segA" and "segB".
   * Example Playground https://playground.babylonjs.com/#QYBWV4#77
   * @param p defines the middle point
   * @param segA defines one point of the segment
   * @param segB defines the other point of the segment
   * @returns the shortest distance
   */
  static DistanceOfPointFromSegment(p2, segA, segB) {
    const l2 = Vector2.DistanceSquared(segA, segB);
    if (l2 === 0) {
      return Vector2.Distance(p2, segA);
    }
    const v2 = segB.subtract(segA);
    const t2 = Math.max(0, Math.min(1, Vector2.Dot(p2.subtract(segA), v2) / l2));
    const proj = segA.add(v2.multiplyByFloats(t2, t2));
    return Vector2.Distance(p2, proj);
  }
}
Vector2._V8PerformanceHack = new Vector2(0.5, 0.5);
Vector2._ZeroReadOnly = Vector2.Zero();
Object.defineProperties(Vector2.prototype, {
  dimension: { value: [2] },
  rank: { value: 1 }
});
class Vector3 {
  /** Gets or sets the x coordinate */
  get x() {
    return this._x;
  }
  set x(value) {
    this._x = value;
    this._isDirty = true;
  }
  /** Gets or sets the y coordinate */
  get y() {
    return this._y;
  }
  set y(value) {
    this._y = value;
    this._isDirty = true;
  }
  /** Gets or sets the z coordinate */
  get z() {
    return this._z;
  }
  set z(value) {
    this._z = value;
    this._isDirty = true;
  }
  /**
   * Creates a new Vector3 object from the given x, y, z (floats) coordinates.
   * @param x defines the first coordinates (on X axis)
   * @param y defines the second coordinates (on Y axis)
   * @param z defines the third coordinates (on Z axis)
   */
  constructor(x2 = 0, y2 = 0, z2 = 0) {
    this._isDirty = true;
    this._x = x2;
    this._y = y2;
    this._z = z2;
  }
  /**
   * Creates a string representation of the Vector3
   * Example Playground https://playground.babylonjs.com/#R1F8YU#67
   * @returns a string with the Vector3 coordinates.
   */
  toString() {
    return `{X: ${this._x} Y: ${this._y} Z: ${this._z}}`;
  }
  /**
   * Gets the class name
   * @returns the string "Vector3"
   */
  getClassName() {
    return "Vector3";
  }
  /**
   * Creates the Vector3 hash code
   * @returns a number which tends to be unique between Vector3 instances
   */
  getHashCode() {
    const x2 = _ExtractAsInt(this._x);
    const y2 = _ExtractAsInt(this._y);
    const z2 = _ExtractAsInt(this._z);
    let hash = x2;
    hash = hash * 397 ^ y2;
    hash = hash * 397 ^ z2;
    return hash;
  }
  // Operators
  /**
   * Creates an array containing three elements : the coordinates of the Vector3
   * Example Playground https://playground.babylonjs.com/#R1F8YU#10
   * @returns a new array of numbers
   */
  asArray() {
    return [this._x, this._y, this._z];
  }
  /**
   * Populates the given array or Float32Array from the given index with the successive coordinates of the Vector3
   * Example Playground https://playground.babylonjs.com/#R1F8YU#65
   * @param array defines the destination array
   * @param index defines the offset in the destination array
   * @returns the current Vector3
   */
  toArray(array, index2 = 0) {
    array[index2] = this._x;
    array[index2 + 1] = this._y;
    array[index2 + 2] = this._z;
    return this;
  }
  /**
   * Update the current vector from an array
   * Example Playground https://playground.babylonjs.com/#R1F8YU#24
   * @param array defines the destination array
   * @param offset defines the offset in the destination array
   * @returns the current Vector3
   */
  fromArray(array, offset = 0) {
    Vector3.FromArrayToRef(array, offset, this);
    return this;
  }
  /**
   * Converts the current Vector3 into a quaternion (considering that the Vector3 contains Euler angles representation of a rotation)
   * Example Playground https://playground.babylonjs.com/#R1F8YU#66
   * @returns a new Quaternion object, computed from the Vector3 coordinates
   */
  toQuaternion() {
    return Quaternion.RotationYawPitchRoll(this._y, this._x, this._z);
  }
  /**
   * Adds the given vector to the current Vector3
   * Example Playground https://playground.babylonjs.com/#R1F8YU#4
   * @param otherVector defines the second operand
   * @returns the current updated Vector3
   */
  addInPlace(otherVector) {
    this._x += otherVector._x;
    this._y += otherVector._y;
    this._z += otherVector._z;
    this._isDirty = true;
    return this;
  }
  /**
   * Adds the given coordinates to the current Vector3
   * Example Playground https://playground.babylonjs.com/#R1F8YU#5
   * @param x defines the x coordinate of the operand
   * @param y defines the y coordinate of the operand
   * @param z defines the z coordinate of the operand
   * @returns the current updated Vector3
   */
  addInPlaceFromFloats(x2, y2, z2) {
    this._x += x2;
    this._y += y2;
    this._z += z2;
    this._isDirty = true;
    return this;
  }
  /**
   * Gets a new Vector3, result of the addition the current Vector3 and the given vector
   * Example Playground https://playground.babylonjs.com/#R1F8YU#3
   * @param otherVector defines the second operand
   * @returns the resulting Vector3
   */
  add(otherVector) {
    return new Vector3(this._x + otherVector._x, this._y + otherVector._y, this._z + otherVector._z);
  }
  /**
   * Adds the current Vector3 to the given one and stores the result in the vector "result"
   * Example Playground https://playground.babylonjs.com/#R1F8YU#6
   * @param otherVector defines the second operand
   * @param result defines the Vector3 object where to store the result
   * @returns the result
   */
  addToRef(otherVector, result) {
    result._x = this._x + otherVector._x;
    result._y = this._y + otherVector._y;
    result._z = this._z + otherVector._z;
    result._isDirty = true;
    return result;
  }
  /**
   * Subtract the given vector from the current Vector3
   * Example Playground https://playground.babylonjs.com/#R1F8YU#61
   * @param otherVector defines the second operand
   * @returns the current updated Vector3
   */
  subtractInPlace(otherVector) {
    this._x -= otherVector._x;
    this._y -= otherVector._y;
    this._z -= otherVector._z;
    this._isDirty = true;
    return this;
  }
  /**
   * Returns a new Vector3, result of the subtraction of the given vector from the current Vector3
   * Example Playground https://playground.babylonjs.com/#R1F8YU#60
   * @param otherVector defines the second operand
   * @returns the resulting Vector3
   */
  subtract(otherVector) {
    return new Vector3(this._x - otherVector._x, this._y - otherVector._y, this._z - otherVector._z);
  }
  /**
   * Subtracts the given vector from the current Vector3 and stores the result in the vector "result".
   * Example Playground https://playground.babylonjs.com/#R1F8YU#63
   * @param otherVector defines the second operand
   * @param result defines the Vector3 object where to store the result
   * @returns the result
   */
  subtractToRef(otherVector, result) {
    return this.subtractFromFloatsToRef(otherVector._x, otherVector._y, otherVector._z, result);
  }
  /**
   * Returns a new Vector3 set with the subtraction of the given floats from the current Vector3 coordinates
   * Example Playground https://playground.babylonjs.com/#R1F8YU#62
   * @param x defines the x coordinate of the operand
   * @param y defines the y coordinate of the operand
   * @param z defines the z coordinate of the operand
   * @returns the resulting Vector3
   */
  subtractFromFloats(x2, y2, z2) {
    return new Vector3(this._x - x2, this._y - y2, this._z - z2);
  }
  /**
   * Subtracts the given floats from the current Vector3 coordinates and set the given vector "result" with this result
   * Example Playground https://playground.babylonjs.com/#R1F8YU#64
   * @param x defines the x coordinate of the operand
   * @param y defines the y coordinate of the operand
   * @param z defines the z coordinate of the operand
   * @param result defines the Vector3 object where to store the result
   * @returns the result
   */
  subtractFromFloatsToRef(x2, y2, z2, result) {
    result._x = this._x - x2;
    result._y = this._y - y2;
    result._z = this._z - z2;
    result._isDirty = true;
    return result;
  }
  /**
   * Gets a new Vector3 set with the current Vector3 negated coordinates
   * Example Playground https://playground.babylonjs.com/#R1F8YU#35
   * @returns a new Vector3
   */
  negate() {
    return new Vector3(-this._x, -this._y, -this._z);
  }
  /**
   * Negate this vector in place
   * Example Playground https://playground.babylonjs.com/#R1F8YU#36
   * @returns this
   */
  negateInPlace() {
    this._x *= -1;
    this._y *= -1;
    this._z *= -1;
    this._isDirty = true;
    return this;
  }
  /**
   * Negate the current Vector3 and stores the result in the given vector "result" coordinates
   * Example Playground https://playground.babylonjs.com/#R1F8YU#37
   * @param result defines the Vector3 object where to store the result
   * @returns the result
   */
  negateToRef(result) {
    result._x = this._x * -1;
    result._y = this._y * -1;
    result._z = this._z * -1;
    result._isDirty = true;
    return result;
  }
  /**
   * Multiplies the Vector3 coordinates by the float "scale"
   * Example Playground https://playground.babylonjs.com/#R1F8YU#56
   * @param scale defines the multiplier factor
   * @returns the current updated Vector3
   */
  scaleInPlace(scale) {
    this._x *= scale;
    this._y *= scale;
    this._z *= scale;
    this._isDirty = true;
    return this;
  }
  /**
   * Returns a new Vector3 set with the current Vector3 coordinates multiplied by the float "scale"
   * Example Playground https://playground.babylonjs.com/#R1F8YU#53
   * @param scale defines the multiplier factor
   * @returns a new Vector3
   */
  scale(scale) {
    return new Vector3(this._x * scale, this._y * scale, this._z * scale);
  }
  /**
   * Multiplies the current Vector3 coordinates by the float "scale" and stores the result in the given vector "result" coordinates
   * Example Playground https://playground.babylonjs.com/#R1F8YU#57
   * @param scale defines the multiplier factor
   * @param result defines the Vector3 object where to store the result
   * @returns the result
   */
  scaleToRef(scale, result) {
    result._x = this._x * scale;
    result._y = this._y * scale;
    result._z = this._z * scale;
    result._isDirty = true;
    return result;
  }
  /**
   * Creates a vector normal (perpendicular) to the current Vector3 and stores the result in the given vector
   * Out of the infinite possibilities the normal chosen is the one formed by rotating the current vector
   * 90 degrees about an axis which lies perpendicular to the current vector
   * and its projection on the xz plane. In the case of a current vector in the xz plane
   * the normal is calculated to be along the y axis.
   * Example Playground https://playground.babylonjs.com/#R1F8YU#230
   * Example Playground https://playground.babylonjs.com/#R1F8YU#231
   * @param result defines the Vector3 object where to store the resultant normal
   * @returns the result
   */
  getNormalToRef(result) {
    const radius = this.length();
    let theta = Math.acos(this.y / radius);
    const phi = Math.atan2(this.z, this.x);
    if (theta > Math.PI / 2) {
      theta -= Math.PI / 2;
    } else {
      theta += Math.PI / 2;
    }
    const x2 = radius * Math.sin(theta) * Math.cos(phi);
    const y2 = radius * Math.cos(theta);
    const z2 = radius * Math.sin(theta) * Math.sin(phi);
    result.set(x2, y2, z2);
    return result;
  }
  /**
   * Rotates the vector using the given unit quaternion and stores the new vector in result
   * Example Playground https://playground.babylonjs.com/#R1F8YU#9
   * @param q the unit quaternion representing the rotation
   * @param result the output vector
   * @returns the result
   */
  applyRotationQuaternionToRef(q, result) {
    const vx = this._x, vy = this._y, vz = this._z;
    const qx = q._x, qy = q._y, qz = q._z, qw = q._w;
    const tx = 2 * (qy * vz - qz * vy);
    const ty = 2 * (qz * vx - qx * vz);
    const tz = 2 * (qx * vy - qy * vx);
    result._x = vx + qw * tx + qy * tz - qz * ty;
    result._y = vy + qw * ty + qz * tx - qx * tz;
    result._z = vz + qw * tz + qx * ty - qy * tx;
    result._isDirty = true;
    return result;
  }
  /**
   * Rotates the vector in place using the given unit quaternion
   * Example Playground https://playground.babylonjs.com/#R1F8YU#8
   * @param q the unit quaternion representing the rotation
   * @returns the current updated Vector3
   */
  applyRotationQuaternionInPlace(q) {
    return this.applyRotationQuaternionToRef(q, this);
  }
  /**
   * Rotates the vector using the given unit quaternion and returns the new vector
   * Example Playground https://playground.babylonjs.com/#R1F8YU#7
   * @param q the unit quaternion representing the rotation
   * @returns a new Vector3
   */
  applyRotationQuaternion(q) {
    return this.applyRotationQuaternionToRef(q, new Vector3());
  }
  /**
   * Scale the current Vector3 values by a factor and add the result to a given Vector3
   * Example Playground https://playground.babylonjs.com/#R1F8YU#55
   * @param scale defines the scale factor
   * @param result defines the Vector3 object where to store the result
   * @returns result input
   */
  scaleAndAddToRef(scale, result) {
    result._x += this._x * scale;
    result._y += this._y * scale;
    result._z += this._z * scale;
    result._isDirty = true;
    return result;
  }
  /**
   * Projects the current point Vector3 to a plane along a ray starting from a specified origin and passing through the current point Vector3.
   * Example Playground https://playground.babylonjs.com/#R1F8YU#48
   * @param plane defines the plane to project to
   * @param origin defines the origin of the projection ray
   * @returns the projected vector3
   */
  projectOnPlane(plane, origin) {
    return this.projectOnPlaneToRef(plane, origin, new Vector3());
  }
  /**
   * Projects the current point Vector3 to a plane along a ray starting from a specified origin and passing through the current point Vector3.
   * Example Playground https://playground.babylonjs.com/#R1F8YU#49
   * @param plane defines the plane to project to
   * @param origin defines the origin of the projection ray
   * @param result defines the Vector3 where to store the result
   * @returns result input
   */
  projectOnPlaneToRef(plane, origin, result) {
    const n3 = plane.normal;
    const d2 = plane.d;
    const V2 = MathTmp.Vector3[0];
    this.subtractToRef(origin, V2);
    V2.normalize();
    const denom = Vector3.Dot(V2, n3);
    if (Math.abs(denom) < 1e-10) {
      result.setAll(Infinity);
    } else {
      const t2 = -(Vector3.Dot(origin, n3) + d2) / denom;
      const scaledV = V2.scaleInPlace(t2);
      origin.addToRef(scaledV, result);
    }
    return result;
  }
  /**
   * Returns true if the current Vector3 and the given vector coordinates are strictly equal
   * Example Playground https://playground.babylonjs.com/#R1F8YU#19
   * @param otherVector defines the second operand
   * @returns true if both vectors are equals
   */
  equals(otherVector) {
    return otherVector && this._x === otherVector._x && this._y === otherVector._y && this._z === otherVector._z;
  }
  /**
   * Returns true if the current Vector3 and the given vector coordinates are distant less than epsilon
   * Example Playground https://playground.babylonjs.com/#R1F8YU#21
   * @param otherVector defines the second operand
   * @param epsilon defines the minimal distance to define values as equals
   * @returns true if both vectors are distant less than epsilon
   */
  equalsWithEpsilon(otherVector, epsilon = Epsilon) {
    return otherVector && WithinEpsilon(this._x, otherVector._x, epsilon) && WithinEpsilon(this._y, otherVector._y, epsilon) && WithinEpsilon(this._z, otherVector._z, epsilon);
  }
  /**
   * Returns true if the current Vector3 coordinates equals the given floats
   * Example Playground https://playground.babylonjs.com/#R1F8YU#20
   * @param x defines the x coordinate of the operand
   * @param y defines the y coordinate of the operand
   * @param z defines the z coordinate of the operand
   * @returns true if both vectors are equal
   */
  equalsToFloats(x2, y2, z2) {
    return this._x === x2 && this._y === y2 && this._z === z2;
  }
  /**
   * Multiplies the current Vector3 coordinates by the given ones
   * Example Playground https://playground.babylonjs.com/#R1F8YU#32
   * @param otherVector defines the second operand
   * @returns the current updated Vector3
   */
  multiplyInPlace(otherVector) {
    this._x *= otherVector._x;
    this._y *= otherVector._y;
    this._z *= otherVector._z;
    this._isDirty = true;
    return this;
  }
  /**
   * Returns a new Vector3, result of the multiplication of the current Vector3 by the given vector
   * Example Playground https://playground.babylonjs.com/#R1F8YU#31
   * @param otherVector defines the second operand
   * @returns the new Vector3
   */
  multiply(otherVector) {
    return this.multiplyByFloats(otherVector._x, otherVector._y, otherVector._z);
  }
  /**
   * Multiplies the current Vector3 by the given one and stores the result in the given vector "result"
   * Example Playground https://playground.babylonjs.com/#R1F8YU#33
   * @param otherVector defines the second operand
   * @param result defines the Vector3 object where to store the result
   * @returns the result
   */
  multiplyToRef(otherVector, result) {
    result._x = this._x * otherVector._x;
    result._y = this._y * otherVector._y;
    result._z = this._z * otherVector._z;
    result._isDirty = true;
    return result;
  }
  /**
   * Returns a new Vector3 set with the result of the multiplication of the current Vector3 coordinates by the given floats
   * Example Playground https://playground.babylonjs.com/#R1F8YU#34
   * @param x defines the x coordinate of the operand
   * @param y defines the y coordinate of the operand
   * @param z defines the z coordinate of the operand
   * @returns the new Vector3
   */
  multiplyByFloats(x2, y2, z2) {
    return new Vector3(this._x * x2, this._y * y2, this._z * z2);
  }
  /**
   * Returns a new Vector3 set with the result of the division of the current Vector3 coordinates by the given ones
   * Example Playground https://playground.babylonjs.com/#R1F8YU#16
   * @param otherVector defines the second operand
   * @returns the new Vector3
   */
  divide(otherVector) {
    return new Vector3(this._x / otherVector._x, this._y / otherVector._y, this._z / otherVector._z);
  }
  /**
   * Divides the current Vector3 coordinates by the given ones and stores the result in the given vector "result"
   * Example Playground https://playground.babylonjs.com/#R1F8YU#18
   * @param otherVector defines the second operand
   * @param result defines the Vector3 object where to store the result
   * @returns the result
   */
  divideToRef(otherVector, result) {
    result._x = this._x / otherVector._x;
    result._y = this._y / otherVector._y;
    result._z = this._z / otherVector._z;
    result._isDirty = true;
    return result;
  }
  /**
   * Divides the current Vector3 coordinates by the given ones.
   * Example Playground https://playground.babylonjs.com/#R1F8YU#17
   * @param otherVector defines the second operand
   * @returns the current updated Vector3
   */
  divideInPlace(otherVector) {
    this._x = this._x / otherVector._x;
    this._y = this._y / otherVector._y;
    this._z = this._z / otherVector._z;
    this._isDirty = true;
    return this;
  }
  /**
   * Updates the current Vector3 with the minimal coordinate values between its and the given vector ones
   * Example Playground https://playground.babylonjs.com/#R1F8YU#29
   * @param other defines the second operand
   * @returns the current updated Vector3
   */
  minimizeInPlace(other) {
    return this.minimizeInPlaceFromFloats(other._x, other._y, other._z);
  }
  /**
   * Updates the current Vector3 with the maximal coordinate values between its and the given vector ones.
   * Example Playground https://playground.babylonjs.com/#R1F8YU#27
   * @param other defines the second operand
   * @returns the current updated Vector3
   */
  maximizeInPlace(other) {
    return this.maximizeInPlaceFromFloats(other._x, other._y, other._z);
  }
  /**
   * Updates the current Vector3 with the minimal coordinate values between its and the given coordinates
   * Example Playground https://playground.babylonjs.com/#R1F8YU#30
   * @param x defines the x coordinate of the operand
   * @param y defines the y coordinate of the operand
   * @param z defines the z coordinate of the operand
   * @returns the current updated Vector3
   */
  minimizeInPlaceFromFloats(x2, y2, z2) {
    if (x2 < this._x) {
      this.x = x2;
    }
    if (y2 < this._y) {
      this.y = y2;
    }
    if (z2 < this._z) {
      this.z = z2;
    }
    return this;
  }
  /**
   * Updates the current Vector3 with the maximal coordinate values between its and the given coordinates.
   * Example Playground https://playground.babylonjs.com/#R1F8YU#28
   * @param x defines the x coordinate of the operand
   * @param y defines the y coordinate of the operand
   * @param z defines the z coordinate of the operand
   * @returns the current updated Vector3
   */
  maximizeInPlaceFromFloats(x2, y2, z2) {
    if (x2 > this._x) {
      this.x = x2;
    }
    if (y2 > this._y) {
      this.y = y2;
    }
    if (z2 > this._z) {
      this.z = z2;
    }
    return this;
  }
  /**
   * Due to float precision, scale of a mesh could be uniform but float values are off by a small fraction
   * Check if is non uniform within a certain amount of decimal places to account for this
   * @param epsilon the amount the values can differ
   * @returns if the vector is non uniform to a certain number of decimal places
   */
  isNonUniformWithinEpsilon(epsilon) {
    const absX = Math.abs(this._x);
    const absY = Math.abs(this._y);
    if (!WithinEpsilon(absX, absY, epsilon)) {
      return true;
    }
    const absZ = Math.abs(this._z);
    if (!WithinEpsilon(absX, absZ, epsilon)) {
      return true;
    }
    if (!WithinEpsilon(absY, absZ, epsilon)) {
      return true;
    }
    return false;
  }
  /**
   * Gets a boolean indicating that the vector is non uniform meaning x, y or z are not all the same
   */
  get isNonUniform() {
    const absX = Math.abs(this._x);
    const absY = Math.abs(this._y);
    if (absX !== absY) {
      return true;
    }
    const absZ = Math.abs(this._z);
    if (absX !== absZ) {
      return true;
    }
    return false;
  }
  /**
   * Gets the current Vector3's floored values and stores them in result
   * @param result the vector to store the result in
   * @returns the result vector
   */
  floorToRef(result) {
    result._x = Math.floor(this._x);
    result._y = Math.floor(this._y);
    result._z = Math.floor(this._z);
    result._isDirty = true;
    return result;
  }
  /**
   * Gets a new Vector3 from current Vector3 floored values
   * Example Playground https://playground.babylonjs.com/#R1F8YU#22
   * @returns a new Vector3
   */
  floor() {
    return new Vector3(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
  }
  /**
   * Gets the current Vector3's fractional values and stores them in result
   * @param result the vector to store the result in
   * @returns the result vector
   */
  fractToRef(result) {
    result._x = this.x - Math.floor(this._x);
    result._y = this.y - Math.floor(this._y);
    result._z = this.z - Math.floor(this._z);
    result._isDirty = true;
    return result;
  }
  /**
   * Gets a new Vector3 from current Vector3 fractional values
   * Example Playground https://playground.babylonjs.com/#R1F8YU#23
   * @returns a new Vector3
   */
  fract() {
    return new Vector3(this.x - Math.floor(this._x), this.y - Math.floor(this._y), this.z - Math.floor(this._z));
  }
  // Properties
  /**
   * Gets the length of the Vector3
   * Example Playground https://playground.babylonjs.com/#R1F8YU#25
   * @returns the length of the Vector3
   */
  length() {
    return Math.sqrt(this.lengthSquared());
  }
  /**
   * Gets the squared length of the Vector3
   * Example Playground https://playground.babylonjs.com/#R1F8YU#26
   * @returns squared length of the Vector3
   */
  lengthSquared() {
    return this._x * this._x + this._y * this._y + this._z * this._z;
  }
  /**
   * Gets a boolean indicating if the vector contains a zero in one of its components
   * Example Playground https://playground.babylonjs.com/#R1F8YU#1
   */
  get hasAZeroComponent() {
    return this._x * this._y * this._z === 0;
  }
  /**
   * Normalize the current Vector3.
   * Please note that this is an in place operation.
   * Example Playground https://playground.babylonjs.com/#R1F8YU#122
   * @returns the current updated Vector3
   */
  normalize() {
    return this.normalizeFromLength(this.length());
  }
  /**
   * Reorders the x y z properties of the vector in place
   * Example Playground https://playground.babylonjs.com/#R1F8YU#44
   * @param order new ordering of the properties (eg. for vector 1,2,3 with "ZYX" will produce 3,2,1)
   * @returns the current updated vector
   */
  reorderInPlace(order) {
    order = order.toLowerCase();
    if (order === "xyz") {
      return this;
    }
    const tem = MathTmp.Vector3[0].copyFrom(this);
    this.x = tem[order[0]];
    this.y = tem[order[1]];
    this.z = tem[order[2]];
    return this;
  }
  /**
   * Rotates the vector around 0,0,0 by a quaternion
   * Example Playground https://playground.babylonjs.com/#R1F8YU#47
   * @param quaternion the rotation quaternion
   * @param result vector to store the result
   * @returns the resulting vector
   */
  rotateByQuaternionToRef(quaternion, result) {
    quaternion.toRotationMatrix(MathTmp.Matrix[0]);
    Vector3.TransformCoordinatesToRef(this, MathTmp.Matrix[0], result);
    return result;
  }
  /**
   * Rotates a vector around a given point
   * Example Playground https://playground.babylonjs.com/#R1F8YU#46
   * @param quaternion the rotation quaternion
   * @param point the point to rotate around
   * @param result vector to store the result
   * @returns the resulting vector
   */
  rotateByQuaternionAroundPointToRef(quaternion, point, result) {
    this.subtractToRef(point, MathTmp.Vector3[0]);
    MathTmp.Vector3[0].rotateByQuaternionToRef(quaternion, MathTmp.Vector3[0]);
    point.addToRef(MathTmp.Vector3[0], result);
    return result;
  }
  /**
   * Returns a new Vector3 as the cross product of the current vector and the "other" one
   * The cross product is then orthogonal to both current and "other"
   * Example Playground https://playground.babylonjs.com/#R1F8YU#14
   * @param other defines the right operand
   * @returns the cross product
   */
  cross(other) {
    return Vector3.CrossToRef(this, other, new Vector3());
  }
  /**
   * Normalize the current Vector3 with the given input length.
   * Please note that this is an in place operation.
   * Example Playground https://playground.babylonjs.com/#R1F8YU#123
   * @param len the length of the vector
   * @returns the current updated Vector3
   */
  normalizeFromLength(len) {
    if (len === 0 || len === 1) {
      return this;
    }
    return this.scaleInPlace(1 / len);
  }
  /**
   * Normalize the current Vector3 to a new vector
   * Example Playground https://playground.babylonjs.com/#R1F8YU#124
   * @returns the new Vector3
   */
  normalizeToNew() {
    return this.normalizeToRef(new Vector3());
  }
  /**
   * Normalize the current Vector3 to the reference
   * Example Playground https://playground.babylonjs.com/#R1F8YU#125
   * @param result define the Vector3 to update
   * @returns the updated Vector3
   */
  normalizeToRef(result) {
    const len = this.length();
    if (len === 0 || len === 1) {
      result._x = this._x;
      result._y = this._y;
      result._z = this._z;
      result._isDirty = true;
      return result;
    }
    return this.scaleToRef(1 / len, result);
  }
  /**
   * Creates a new Vector3 copied from the current Vector3
   * Example Playground https://playground.babylonjs.com/#R1F8YU#11
   * @returns the new Vector3
   */
  clone() {
    return new Vector3(this._x, this._y, this._z);
  }
  /**
   * Copies the given vector coordinates to the current Vector3 ones
   * Example Playground https://playground.babylonjs.com/#R1F8YU#12
   * @param source defines the source Vector3
   * @returns the current updated Vector3
   */
  copyFrom(source) {
    return this.copyFromFloats(source._x, source._y, source._z);
  }
  /**
   * Copies the given floats to the current Vector3 coordinates
   * Example Playground https://playground.babylonjs.com/#R1F8YU#13
   * @param x defines the x coordinate of the operand
   * @param y defines the y coordinate of the operand
   * @param z defines the z coordinate of the operand
   * @returns the current updated Vector3
   */
  copyFromFloats(x2, y2, z2) {
    this._x = x2;
    this._y = y2;
    this._z = z2;
    this._isDirty = true;
    return this;
  }
  /**
   * Copies the given floats to the current Vector3 coordinates
   * Example Playground https://playground.babylonjs.com/#R1F8YU#58
   * @param x defines the x coordinate of the operand
   * @param y defines the y coordinate of the operand
   * @param z defines the z coordinate of the operand
   * @returns the current updated Vector3
   */
  set(x2, y2, z2) {
    return this.copyFromFloats(x2, y2, z2);
  }
  /**
   * Copies the given float to the current Vector3 coordinates
   * Example Playground https://playground.babylonjs.com/#R1F8YU#59
   * @param v defines the x, y and z coordinates of the operand
   * @returns the current updated Vector3
   */
  setAll(v2) {
    this._x = this._y = this._z = v2;
    this._isDirty = true;
    return this;
  }
  // Statics
  /**
   * Get the clip factor between two vectors
   * Example Playground https://playground.babylonjs.com/#R1F8YU#126
   * @param vector0 defines the first operand
   * @param vector1 defines the second operand
   * @param axis defines the axis to use
   * @param size defines the size along the axis
   * @returns the clip factor
   */
  static GetClipFactor(vector0, vector1, axis, size) {
    const d0 = Vector3.Dot(vector0, axis);
    const d1 = Vector3.Dot(vector1, axis);
    return (d0 - size) / (d0 - d1);
  }
  /**
   * Get angle between two vectors
   * Example Playground https://playground.babylonjs.com/#R1F8YU#86
   * @param vector0 the starting point
   * @param vector1 the ending point
   * @param normal direction of the normal
   * @returns the angle between vector0 and vector1
   */
  static GetAngleBetweenVectors(vector0, vector1, normal) {
    const v0 = vector0.normalizeToRef(MathTmp.Vector3[1]);
    const v1 = vector1.normalizeToRef(MathTmp.Vector3[2]);
    let dot = Vector3.Dot(v0, v1);
    dot = Clamp(dot, -1, 1);
    const angle = Math.acos(dot);
    const n3 = MathTmp.Vector3[3];
    Vector3.CrossToRef(v0, v1, n3);
    if (Vector3.Dot(n3, normal) > 0) {
      return isNaN(angle) ? 0 : angle;
    }
    return isNaN(angle) ? -Math.PI : -Math.acos(dot);
  }
  /**
   * Get angle between two vectors projected on a plane
   * Example Playground https://playground.babylonjs.com/#R1F8YU#87
   * Expectation compute time: 0.01 ms (median) and 0.02 ms (percentile 95%)
   * @param vector0 angle between vector0 and vector1
   * @param vector1 angle between vector0 and vector1
   * @param normal Normal of the projection plane
   * @returns the angle in radians (float) between vector0 and vector1 projected on the plane with the specified normal
   */
  static GetAngleBetweenVectorsOnPlane(vector0, vector1, normal) {
    MathTmp.Vector3[0].copyFrom(vector0);
    const v0 = MathTmp.Vector3[0];
    MathTmp.Vector3[1].copyFrom(vector1);
    const v1 = MathTmp.Vector3[1];
    MathTmp.Vector3[2].copyFrom(normal);
    const vNormal = MathTmp.Vector3[2];
    const right = MathTmp.Vector3[3];
    const forward = MathTmp.Vector3[4];
    v0.normalize();
    v1.normalize();
    vNormal.normalize();
    Vector3.CrossToRef(vNormal, v0, right);
    Vector3.CrossToRef(right, vNormal, forward);
    const angle = Math.atan2(Vector3.Dot(v1, right), Vector3.Dot(v1, forward));
    return NormalizeRadians(angle);
  }
  /**
   * Gets the rotation that aligns the roll axis (Y) to the line joining the start point to the target point and stores it in the ref Vector3
   * Example PG https://playground.babylonjs.com/#R1F8YU#189
   * @param start the starting point
   * @param target the target point
   * @param ref the vector3 to store the result
   * @returns ref in the form (pitch, yaw, 0)
   */
  static PitchYawRollToMoveBetweenPointsToRef(start, target, ref) {
    const diff = TmpVectors.Vector3[0];
    target.subtractToRef(start, diff);
    ref._y = Math.atan2(diff.x, diff.z) || 0;
    ref._x = Math.atan2(Math.sqrt(diff.x ** 2 + diff.z ** 2), diff.y) || 0;
    ref._z = 0;
    ref._isDirty = true;
    return ref;
  }
  /**
   * Gets the rotation that aligns the roll axis (Y) to the line joining the start point to the target point
   * Example PG https://playground.babylonjs.com/#R1F8YU#188
   * @param start the starting point
   * @param target the target point
   * @returns the rotation in the form (pitch, yaw, 0)
   */
  static PitchYawRollToMoveBetweenPoints(start, target) {
    const ref = Vector3.Zero();
    return Vector3.PitchYawRollToMoveBetweenPointsToRef(start, target, ref);
  }
  /**
   * Slerp between two vectors. See also `SmoothToRef`
   * Slerp is a spherical linear interpolation
   * giving a slow in and out effect
   * Example Playground 1 https://playground.babylonjs.com/#R1F8YU#108
   * Example Playground 2 https://playground.babylonjs.com/#R1F8YU#109
   * @param vector0 Start vector
   * @param vector1 End vector
   * @param slerp amount (will be clamped between 0 and 1)
   * @param result The slerped vector
   * @returns The slerped vector
   */
  static SlerpToRef(vector0, vector1, slerp, result) {
    slerp = Clamp(slerp, 0, 1);
    const vector0Dir = MathTmp.Vector3[0];
    const vector1Dir = MathTmp.Vector3[1];
    vector0Dir.copyFrom(vector0);
    const vector0Length = vector0Dir.length();
    vector0Dir.normalizeFromLength(vector0Length);
    vector1Dir.copyFrom(vector1);
    const vector1Length = vector1Dir.length();
    vector1Dir.normalizeFromLength(vector1Length);
    const dot = Vector3.Dot(vector0Dir, vector1Dir);
    let scale0;
    let scale1;
    if (dot < 1 - Epsilon) {
      const omega = Math.acos(dot);
      const invSin = 1 / Math.sin(omega);
      scale0 = Math.sin((1 - slerp) * omega) * invSin;
      scale1 = Math.sin(slerp * omega) * invSin;
    } else {
      scale0 = 1 - slerp;
      scale1 = slerp;
    }
    vector0Dir.scaleInPlace(scale0);
    vector1Dir.scaleInPlace(scale1);
    result.copyFrom(vector0Dir).addInPlace(vector1Dir);
    result.scaleInPlace(Lerp(vector0Length, vector1Length, slerp));
    return result;
  }
  /**
   * Smooth interpolation between two vectors using Slerp
   * Example Playground https://playground.babylonjs.com/#R1F8YU#110
   * @param source source vector
   * @param goal goal vector
   * @param deltaTime current interpolation frame
   * @param lerpTime total interpolation time
   * @param result the smoothed vector
   * @returns the smoothed vector
   */
  static SmoothToRef(source, goal, deltaTime, lerpTime, result) {
    Vector3.SlerpToRef(source, goal, lerpTime === 0 ? 1 : deltaTime / lerpTime, result);
    return result;
  }
  /**
   * Returns a new Vector3 set from the index "offset" of the given array
   * Example Playground https://playground.babylonjs.com/#R1F8YU#83
   * @param array defines the source array
   * @param offset defines the offset in the source array
   * @returns the new Vector3
   */
  static FromArray(array, offset = 0) {
    return new Vector3(array[offset], array[offset + 1], array[offset + 2]);
  }
  /**
   * Returns a new Vector3 set from the index "offset" of the given Float32Array
   * @param array defines the source array
   * @param offset defines the offset in the source array
   * @returns the new Vector3
   * @deprecated Please use FromArray instead.
   */
  static FromFloatArray(array, offset) {
    return Vector3.FromArray(array, offset);
  }
  /**
   * Sets the given vector "result" with the element values from the index "offset" of the given array
   * Example Playground https://playground.babylonjs.com/#R1F8YU#84
   * @param array defines the source array
   * @param offset defines the offset in the source array
   * @param result defines the Vector3 where to store the result
   * @returns result input
   */
  static FromArrayToRef(array, offset, result) {
    result._x = array[offset];
    result._y = array[offset + 1];
    result._z = array[offset + 2];
    result._isDirty = true;
    return result;
  }
  /**
   * Sets the given vector "result" with the element values from the index "offset" of the given Float32Array
   * @param array defines the source array
   * @param offset defines the offset in the source array
   * @param result defines the Vector3 where to store the result
   * @deprecated Please use FromArrayToRef instead.
   * @returns result input
   */
  static FromFloatArrayToRef(array, offset, result) {
    return Vector3.FromArrayToRef(array, offset, result);
  }
  /**
   * Sets the given vector "result" with the given floats.
   * Example Playground https://playground.babylonjs.com/#R1F8YU#85
   * @param x defines the x coordinate of the source
   * @param y defines the y coordinate of the source
   * @param z defines the z coordinate of the source
   * @param result defines the Vector3 where to store the result
   * @returns the result vector
   */
  static FromFloatsToRef(x2, y2, z2, result) {
    result.copyFromFloats(x2, y2, z2);
    return result;
  }
  /**
   * Returns a new Vector3 set to (0.0, 0.0, 0.0)
   * @returns a new empty Vector3
   */
  static Zero() {
    return new Vector3(0, 0, 0);
  }
  /**
   * Returns a new Vector3 set to (1.0, 1.0, 1.0)
   * @returns a new Vector3
   */
  static One() {
    return new Vector3(1, 1, 1);
  }
  /**
   * Returns a new Vector3 set to (0.0, 1.0, 0.0)
   * Example Playground https://playground.babylonjs.com/#R1F8YU#71
   * @returns a new up Vector3
   */
  static Up() {
    return new Vector3(0, 1, 0);
  }
  /**
   * Gets an up Vector3 that must not be updated
   */
  static get UpReadOnly() {
    return Vector3._UpReadOnly;
  }
  /**
   * Gets a down Vector3 that must not be updated
   */
  static get DownReadOnly() {
    return Vector3._DownReadOnly;
  }
  /**
   * Gets a right Vector3 that must not be updated
   */
  static get RightReadOnly() {
    return Vector3._RightReadOnly;
  }
  /**
   * Gets a left Vector3 that must not be updated
   */
  static get LeftReadOnly() {
    return Vector3._LeftReadOnly;
  }
  /**
   * Gets a forward Vector3 that must not be updated
   */
  static get LeftHandedForwardReadOnly() {
    return Vector3._LeftHandedForwardReadOnly;
  }
  /**
   * Gets a forward Vector3 that must not be updated
   */
  static get RightHandedForwardReadOnly() {
    return Vector3._RightHandedForwardReadOnly;
  }
  /**
   * Gets a backward Vector3 that must not be updated
   */
  static get LeftHandedBackwardReadOnly() {
    return Vector3._LeftHandedBackwardReadOnly;
  }
  /**
   * Gets a backward Vector3 that must not be updated
   */
  static get RightHandedBackwardReadOnly() {
    return Vector3._RightHandedBackwardReadOnly;
  }
  /**
   * Gets a zero Vector3 that must not be updated
   */
  static get ZeroReadOnly() {
    return Vector3._ZeroReadOnly;
  }
  /**
   * Gets a one Vector3 that must not be updated
   */
  static get OneReadOnly() {
    return Vector3._OneReadOnly;
  }
  /**
   * Returns a new Vector3 set to (0.0, -1.0, 0.0)
   * Example Playground https://playground.babylonjs.com/#R1F8YU#71
   * @returns a new down Vector3
   */
  static Down() {
    return new Vector3(0, -1, 0);
  }
  /**
   * Returns a new Vector3 set to (0.0, 0.0, 1.0)
   * Example Playground https://playground.babylonjs.com/#R1F8YU#71
   * @param rightHandedSystem is the scene right-handed (negative z)
   * @returns a new forward Vector3
   */
  static Forward(rightHandedSystem = false) {
    return new Vector3(0, 0, rightHandedSystem ? -1 : 1);
  }
  /**
   * Returns a new Vector3 set to (0.0, 0.0, -1.0)
   * Example Playground https://playground.babylonjs.com/#R1F8YU#71
   * @param rightHandedSystem is the scene right-handed (negative-z)
   * @returns a new Backward Vector3
   */
  static Backward(rightHandedSystem = false) {
    return new Vector3(0, 0, rightHandedSystem ? 1 : -1);
  }
  /**
   * Returns a new Vector3 set to (1.0, 0.0, 0.0)
   * Example Playground https://playground.babylonjs.com/#R1F8YU#71
   * @returns a new right Vector3
   */
  static Right() {
    return new Vector3(1, 0, 0);
  }
  /**
   * Returns a new Vector3 set to (-1.0, 0.0, 0.0)
   * Example Playground https://playground.babylonjs.com/#R1F8YU#71
   * @returns a new left Vector3
   */
  static Left() {
    return new Vector3(-1, 0, 0);
  }
  /**
   * Returns a new Vector3 with random values between min and max
   * @param min the minimum random value
   * @param max the maximum random value
   * @returns a Vector3 with random values between min and max
   */
  static Random(min = 0, max = 1) {
    return new Vector3(RandomRange(min, max), RandomRange(min, max), RandomRange(min, max));
  }
  /**
   * Sets a Vector3 with random values between min and max
   * @param min the minimum random value
   * @param max the maximum random value
   * @param ref the ref to store the values in
   * @returns the ref with random values between min and max
   */
  static RandomToRef(min = 0, max = 1, ref) {
    return ref.copyFromFloats(RandomRange(min, max), RandomRange(min, max), RandomRange(min, max));
  }
  /**
   * Returns a new Vector3 set with the result of the transformation by the given matrix of the given vector.
   * This method computes transformed coordinates only, not transformed direction vectors (ie. it takes translation in account)
   * Example Playground https://playground.babylonjs.com/#R1F8YU#111
   * @param vector defines the Vector3 to transform
   * @param transformation defines the transformation matrix
   * @returns the transformed Vector3
   */
  static TransformCoordinates(vector, transformation) {
    const result = Vector3.Zero();
    Vector3.TransformCoordinatesToRef(vector, transformation, result);
    return result;
  }
  /**
   * Sets the given vector "result" coordinates with the result of the transformation by the given matrix of the given vector
   * This method computes transformed coordinates only, not transformed direction vectors (ie. it takes translation in account)
   * Example Playground https://playground.babylonjs.com/#R1F8YU#113
   * @param vector defines the Vector3 to transform
   * @param transformation defines the transformation matrix
   * @param result defines the Vector3 where to store the result
   * @returns result input
   */
  static TransformCoordinatesToRef(vector, transformation, result) {
    Vector3.TransformCoordinatesFromFloatsToRef(vector._x, vector._y, vector._z, transformation, result);
    return result;
  }
  /**
   * Sets the given vector "result" coordinates with the result of the transformation by the given matrix of the given floats (x, y, z)
   * This method computes transformed coordinates only, not transformed direction vectors
   * Example Playground https://playground.babylonjs.com/#R1F8YU#115
   * @param x define the x coordinate of the source vector
   * @param y define the y coordinate of the source vector
   * @param z define the z coordinate of the source vector
   * @param transformation defines the transformation matrix
   * @param result defines the Vector3 where to store the result
   * @returns result input
   */
  static TransformCoordinatesFromFloatsToRef(x2, y2, z2, transformation, result) {
    const m2 = transformation.m;
    const rx = x2 * m2[0] + y2 * m2[4] + z2 * m2[8] + m2[12];
    const ry = x2 * m2[1] + y2 * m2[5] + z2 * m2[9] + m2[13];
    const rz = x2 * m2[2] + y2 * m2[6] + z2 * m2[10] + m2[14];
    const rw = 1 / (x2 * m2[3] + y2 * m2[7] + z2 * m2[11] + m2[15]);
    result._x = rx * rw;
    result._y = ry * rw;
    result._z = rz * rw;
    result._isDirty = true;
    return result;
  }
  /**
   * Returns a new Vector3 set with the result of the normal transformation by the given matrix of the given vector
   * This methods computes transformed normalized direction vectors only (ie. it does not apply translation)
   * Example Playground https://playground.babylonjs.com/#R1F8YU#112
   * @param vector defines the Vector3 to transform
   * @param transformation defines the transformation matrix
   * @returns the new Vector3
   */
  static TransformNormal(vector, transformation) {
    const result = Vector3.Zero();
    Vector3.TransformNormalToRef(vector, transformation, result);
    return result;
  }
  /**
   * Sets the given vector "result" with the result of the normal transformation by the given matrix of the given vector
   * This methods computes transformed normalized direction vectors only (ie. it does not apply translation)
   * Example Playground https://playground.babylonjs.com/#R1F8YU#114
   * @param vector defines the Vector3 to transform
   * @param transformation defines the transformation matrix
   * @param result defines the Vector3 where to store the result
   * @returns result input
   */
  static TransformNormalToRef(vector, transformation, result) {
    this.TransformNormalFromFloatsToRef(vector._x, vector._y, vector._z, transformation, result);
    return result;
  }
  /**
   * Sets the given vector "result" with the result of the normal transformation by the given matrix of the given floats (x, y, z)
   * This methods computes transformed normalized direction vectors only (ie. it does not apply translation)
   * Example Playground https://playground.babylonjs.com/#R1F8YU#116
   * @param x define the x coordinate of the source vector
   * @param y define the y coordinate of the source vector
   * @param z define the z coordinate of the source vector
   * @param transformation defines the transformation matrix
   * @param result defines the Vector3 where to store the result
   * @returns result input
   */
  static TransformNormalFromFloatsToRef(x2, y2, z2, transformation, result) {
    const m2 = transformation.m;
    result._x = x2 * m2[0] + y2 * m2[4] + z2 * m2[8];
    result._y = x2 * m2[1] + y2 * m2[5] + z2 * m2[9];
    result._z = x2 * m2[2] + y2 * m2[6] + z2 * m2[10];
    result._isDirty = true;
    return result;
  }
  /**
   * Returns a new Vector3 located for "amount" on the CatmullRom interpolation spline defined by the vectors "value1", "value2", "value3", "value4"
   * Example Playground https://playground.babylonjs.com/#R1F8YU#69
   * @param value1 defines the first control point
   * @param value2 defines the second control point
   * @param value3 defines the third control point
   * @param value4 defines the fourth control point
   * @param amount defines the amount on the spline to use
   * @returns the new Vector3
   */
  static CatmullRom(value1, value2, value3, value4, amount) {
    const squared = amount * amount;
    const cubed = amount * squared;
    const x2 = 0.5 * (2 * value2._x + (-value1._x + value3._x) * amount + (2 * value1._x - 5 * value2._x + 4 * value3._x - value4._x) * squared + (-value1._x + 3 * value2._x - 3 * value3._x + value4._x) * cubed);
    const y2 = 0.5 * (2 * value2._y + (-value1._y + value3._y) * amount + (2 * value1._y - 5 * value2._y + 4 * value3._y - value4._y) * squared + (-value1._y + 3 * value2._y - 3 * value3._y + value4._y) * cubed);
    const z2 = 0.5 * (2 * value2._z + (-value1._z + value3._z) * amount + (2 * value1._z - 5 * value2._z + 4 * value3._z - value4._z) * squared + (-value1._z + 3 * value2._z - 3 * value3._z + value4._z) * cubed);
    return new Vector3(x2, y2, z2);
  }
  /**
   * Returns a new Vector3 set with the coordinates of "value", if the vector "value" is in the cube defined by the vectors "min" and "max"
   * If a coordinate value of "value" is lower than one of the "min" coordinate, then this "value" coordinate is set with the "min" one
   * If a coordinate value of "value" is greater than one of the "max" coordinate, then this "value" coordinate is set with the "max" one
   * Example Playground https://playground.babylonjs.com/#R1F8YU#76
   * @param value defines the current value
   * @param min defines the lower range value
   * @param max defines the upper range value
   * @returns the new Vector3
   */
  static Clamp(value, min, max) {
    const result = new Vector3();
    Vector3.ClampToRef(value, min, max, result);
    return result;
  }
  /**
   * Sets the given vector "result" with the coordinates of "value", if the vector "value" is in the cube defined by the vectors "min" and "max"
   * If a coordinate value of "value" is lower than one of the "min" coordinate, then this "value" coordinate is set with the "min" one
   * If a coordinate value of "value" is greater than one of the "max" coordinate, then this "value" coordinate is set with the "max" one
   * Example Playground https://playground.babylonjs.com/#R1F8YU#77
   * @param value defines the current value
   * @param min defines the lower range value
   * @param max defines the upper range value
   * @param result defines the Vector3 where to store the result
   * @returns result input
   */
  static ClampToRef(value, min, max, result) {
    let x2 = value._x;
    x2 = x2 > max._x ? max._x : x2;
    x2 = x2 < min._x ? min._x : x2;
    let y2 = value._y;
    y2 = y2 > max._y ? max._y : y2;
    y2 = y2 < min._y ? min._y : y2;
    let z2 = value._z;
    z2 = z2 > max._z ? max._z : z2;
    z2 = z2 < min._z ? min._z : z2;
    result.copyFromFloats(x2, y2, z2);
    return result;
  }
  /**
   * Checks if a given vector is inside a specific range
   * Example Playground https://playground.babylonjs.com/#R1F8YU#75
   * @param v defines the vector to test
   * @param min defines the minimum range
   * @param max defines the maximum range
   */
  static CheckExtends(v2, min, max) {
    min.minimizeInPlace(v2);
    max.maximizeInPlace(v2);
  }
  /**
   * Returns a new Vector3 located for "amount" (float) on the Hermite interpolation spline defined by the vectors "value1", "tangent1", "value2", "tangent2"
   * Example Playground https://playground.babylonjs.com/#R1F8YU#89
   * @param value1 defines the first control point
   * @param tangent1 defines the first tangent vector
   * @param value2 defines the second control point
   * @param tangent2 defines the second tangent vector
   * @param amount defines the amount on the interpolation spline (between 0 and 1)
   * @returns the new Vector3
   */
  static Hermite(value1, tangent1, value2, tangent2, amount) {
    const squared = amount * amount;
    const cubed = amount * squared;
    const part1 = 2 * cubed - 3 * squared + 1;
    const part2 = -2 * cubed + 3 * squared;
    const part3 = cubed - 2 * squared + amount;
    const part4 = cubed - squared;
    const x2 = value1._x * part1 + value2._x * part2 + tangent1._x * part3 + tangent2._x * part4;
    const y2 = value1._y * part1 + value2._y * part2 + tangent1._y * part3 + tangent2._y * part4;
    const z2 = value1._z * part1 + value2._z * part2 + tangent1._z * part3 + tangent2._z * part4;
    return new Vector3(x2, y2, z2);
  }
  /**
   * Returns a new Vector3 which is the 1st derivative of the Hermite spline defined by the vectors "value1", "value2", "tangent1", "tangent2".
   * Example Playground https://playground.babylonjs.com/#R1F8YU#90
   * @param value1 defines the first control point
   * @param tangent1 defines the first tangent
   * @param value2 defines the second control point
   * @param tangent2 defines the second tangent
   * @param time define where the derivative must be done
   * @returns 1st derivative
   */
  static Hermite1stDerivative(value1, tangent1, value2, tangent2, time) {
    const result = new Vector3();
    this.Hermite1stDerivativeToRef(value1, tangent1, value2, tangent2, time, result);
    return result;
  }
  /**
   * Update a Vector3 with the 1st derivative of the Hermite spline defined by the vectors "value1", "value2", "tangent1", "tangent2".
   * Example Playground https://playground.babylonjs.com/#R1F8YU#91
   * @param value1 defines the first control point
   * @param tangent1 defines the first tangent
   * @param value2 defines the second control point
   * @param tangent2 defines the second tangent
   * @param time define where the derivative must be done
   * @param result define where to store the derivative
   * @returns result input
   */
  static Hermite1stDerivativeToRef(value1, tangent1, value2, tangent2, time, result) {
    const t2 = time * time;
    result._x = (t2 - time) * 6 * value1._x + (3 * t2 - 4 * time + 1) * tangent1._x + (-t2 + time) * 6 * value2._x + (3 * t2 - 2 * time) * tangent2._x;
    result._y = (t2 - time) * 6 * value1._y + (3 * t2 - 4 * time + 1) * tangent1._y + (-t2 + time) * 6 * value2._y + (3 * t2 - 2 * time) * tangent2._y;
    result._z = (t2 - time) * 6 * value1._z + (3 * t2 - 4 * time + 1) * tangent1._z + (-t2 + time) * 6 * value2._z + (3 * t2 - 2 * time) * tangent2._z;
    result._isDirty = true;
    return result;
  }
  /**
   * Returns a new Vector3 located for "amount" (float) on the linear interpolation between the vectors "start" and "end"
   * Example Playground https://playground.babylonjs.com/#R1F8YU#95
   * @param start defines the start value
   * @param end defines the end value
   * @param amount max defines amount between both (between 0 and 1)
   * @returns the new Vector3
   */
  static Lerp(start, end, amount) {
    const result = new Vector3(0, 0, 0);
    Vector3.LerpToRef(start, end, amount, result);
    return result;
  }
  /**
   * Sets the given vector "result" with the result of the linear interpolation from the vector "start" for "amount" to the vector "end"
   * Example Playground https://playground.babylonjs.com/#R1F8YU#93
   * @param start defines the start value
   * @param end defines the end value
   * @param amount max defines amount between both (between 0 and 1)
   * @param result defines the Vector3 where to store the result
   * @returns result input
   */
  static LerpToRef(start, end, amount, result) {
    result._x = start._x + (end._x - start._x) * amount;
    result._y = start._y + (end._y - start._y) * amount;
    result._z = start._z + (end._z - start._z) * amount;
    result._isDirty = true;
    return result;
  }
  /**
   * Returns the dot product (float) between the vectors "left" and "right"
   * Example Playground https://playground.babylonjs.com/#R1F8YU#82
   * @param left defines the left operand
   * @param right defines the right operand
   * @returns the dot product
   */
  static Dot(left, right) {
    return left._x * right._x + left._y * right._y + left._z * right._z;
  }
  /**
   * Returns the dot product (float) between the current vectors and "otherVector"
   * @param otherVector defines the right operand
   * @returns the dot product
   */
  dot(otherVector) {
    return this._x * otherVector._x + this._y * otherVector._y + this._z * otherVector._z;
  }
  /**
   * Returns a new Vector3 as the cross product of the vectors "left" and "right"
   * The cross product is then orthogonal to both "left" and "right"
   * Example Playground https://playground.babylonjs.com/#R1F8YU#15
   * @param left defines the left operand
   * @param right defines the right operand
   * @returns the cross product
   */
  static Cross(left, right) {
    const result = new Vector3();
    Vector3.CrossToRef(left, right, result);
    return result;
  }
  /**
   * Sets the given vector "result" with the cross product of "left" and "right"
   * The cross product is then orthogonal to both "left" and "right"
   * Example Playground https://playground.babylonjs.com/#R1F8YU#78
   * @param left defines the left operand
   * @param right defines the right operand
   * @param result defines the Vector3 where to store the result
   * @returns result input
   */
  static CrossToRef(left, right, result) {
    const x2 = left._y * right._z - left._z * right._y;
    const y2 = left._z * right._x - left._x * right._z;
    const z2 = left._x * right._y - left._y * right._x;
    result.copyFromFloats(x2, y2, z2);
    return result;
  }
  /**
   * Returns a new Vector3 as the normalization of the given vector
   * Example Playground https://playground.babylonjs.com/#R1F8YU#98
   * @param vector defines the Vector3 to normalize
   * @returns the new Vector3
   */
  static Normalize(vector) {
    const result = Vector3.Zero();
    Vector3.NormalizeToRef(vector, result);
    return result;
  }
  /**
   * Sets the given vector "result" with the normalization of the given first vector
   * Example Playground https://playground.babylonjs.com/#R1F8YU#98
   * @param vector defines the Vector3 to normalize
   * @param result defines the Vector3 where to store the result
   * @returns result input
   */
  static NormalizeToRef(vector, result) {
    vector.normalizeToRef(result);
    return result;
  }
  /**
   * Project a Vector3 onto screen space
   * Example Playground https://playground.babylonjs.com/#R1F8YU#101
   * @param vector defines the Vector3 to project
   * @param world defines the world matrix to use
   * @param transform defines the transform (view x projection) matrix to use
   * @param viewport defines the screen viewport to use
   * @returns the new Vector3
   */
  static Project(vector, world, transform, viewport) {
    const result = new Vector3();
    Vector3.ProjectToRef(vector, world, transform, viewport, result);
    return result;
  }
  /**
   * Project a Vector3 onto screen space to reference
   * Example Playground https://playground.babylonjs.com/#R1F8YU#102
   * @param vector defines the Vector3 to project
   * @param world defines the world matrix to use
   * @param transform defines the transform (view x projection) matrix to use
   * @param viewport defines the screen viewport to use
   * @param result the vector in which the screen space will be stored
   * @returns result input
   */
  static ProjectToRef(vector, world, transform, viewport, result) {
    var _a2;
    const cw = viewport.width;
    const ch = viewport.height;
    const cx = viewport.x;
    const cy = viewport.y;
    const viewportMatrix = MathTmp.Matrix[1];
    const isNDCHalfZRange = (_a2 = EngineStore.LastCreatedEngine) == null ? void 0 : _a2.isNDCHalfZRange;
    const zScale = isNDCHalfZRange ? 1 : 0.5;
    const zOffset = isNDCHalfZRange ? 0 : 0.5;
    Matrix.FromValuesToRef(cw / 2, 0, 0, 0, 0, -ch / 2, 0, 0, 0, 0, zScale, 0, cx + cw / 2, ch / 2 + cy, zOffset, 1, viewportMatrix);
    const matrix = MathTmp.Matrix[0];
    world.multiplyToRef(transform, matrix);
    matrix.multiplyToRef(viewportMatrix, matrix);
    Vector3.TransformCoordinatesToRef(vector, matrix, result);
    return result;
  }
  /**
   * Reflects a vector off the plane defined by a normalized normal
   * @param inDirection defines the vector direction
   * @param normal defines the normal - Must be normalized
   * @returns the resulting vector
   */
  static Reflect(inDirection, normal) {
    return this.ReflectToRef(inDirection, normal, new Vector3());
  }
  /**
   * Reflects a vector off the plane defined by a normalized normal to reference
   * @param inDirection defines the vector direction
   * @param normal defines the normal - Must be normalized
   * @param ref defines the Vector3 where to store the result
   * @returns the resulting vector
   */
  static ReflectToRef(inDirection, normal, ref) {
    const tmp = TmpVectors.Vector3[0];
    tmp.copyFrom(normal).scaleInPlace(2 * Vector3.Dot(inDirection, normal));
    return ref.copyFrom(inDirection).subtractInPlace(tmp);
  }
  /**
   * @internal
   */
  static _UnprojectFromInvertedMatrixToRef(source, matrix, result) {
    Vector3.TransformCoordinatesToRef(source, matrix, result);
    const m2 = matrix.m;
    const num = source._x * m2[3] + source._y * m2[7] + source._z * m2[11] + m2[15];
    if (WithinEpsilon(num, 1)) {
      result.scaleInPlace(1 / num);
    }
    return result;
  }
  /**
   * Unproject from screen space to object space
   * Example Playground https://playground.babylonjs.com/#R1F8YU#121
   * @param source defines the screen space Vector3 to use
   * @param viewportWidth defines the current width of the viewport
   * @param viewportHeight defines the current height of the viewport
   * @param world defines the world matrix to use (can be set to Identity to go to world space)
   * @param transform defines the transform (view x projection) matrix to use
   * @returns the new Vector3
   */
  static UnprojectFromTransform(source, viewportWidth, viewportHeight, world, transform) {
    return this.Unproject(source, viewportWidth, viewportHeight, world, transform, Matrix.IdentityReadOnly);
  }
  /**
   * Unproject from screen space to object space
   * Example Playground https://playground.babylonjs.com/#R1F8YU#117
   * @param source defines the screen space Vector3 to use
   * @param viewportWidth defines the current width of the viewport
   * @param viewportHeight defines the current height of the viewport
   * @param world defines the world matrix to use (can be set to Identity to go to world space)
   * @param view defines the view matrix to use
   * @param projection defines the projection matrix to use
   * @returns the new Vector3
   */
  static Unproject(source, viewportWidth, viewportHeight, world, view, projection) {
    const result = new Vector3();
    Vector3.UnprojectToRef(source, viewportWidth, viewportHeight, world, view, projection, result);
    return result;
  }
  /**
   * Unproject from screen space to object space
   * Example Playground https://playground.babylonjs.com/#R1F8YU#119
   * @param source defines the screen space Vector3 to use
   * @param viewportWidth defines the current width of the viewport
   * @param viewportHeight defines the current height of the viewport
   * @param world defines the world matrix to use (can be set to Identity to go to world space)
   * @param view defines the view matrix to use
   * @param projection defines the projection matrix to use
   * @param result defines the Vector3 where to store the result
   * @returns result input
   */
  static UnprojectToRef(source, viewportWidth, viewportHeight, world, view, projection, result) {
    Vector3.UnprojectFloatsToRef(source._x, source._y, source._z, viewportWidth, viewportHeight, world, view, projection, result);
    return result;
  }
  /**
   * Unproject from screen space to object space
   * Example Playground https://playground.babylonjs.com/#R1F8YU#120
   * @param sourceX defines the screen space x coordinate to use
   * @param sourceY defines the screen space y coordinate to use
   * @param sourceZ defines the screen space z coordinate to use
   * @param viewportWidth defines the current width of the viewport
   * @param viewportHeight defines the current height of the viewport
   * @param world defines the world matrix to use (can be set to Identity to go to world space)
   * @param view defines the view matrix to use
   * @param projection defines the projection matrix to use
   * @param result defines the Vector3 where to store the result
   * @returns result input
   */
  static UnprojectFloatsToRef(sourceX, sourceY, sourceZ, viewportWidth, viewportHeight, world, view, projection, result) {
    var _a2;
    const matrix = MathTmp.Matrix[0];
    world.multiplyToRef(view, matrix);
    matrix.multiplyToRef(projection, matrix);
    matrix.invert();
    const screenSource = MathTmp.Vector3[0];
    screenSource.x = sourceX / viewportWidth * 2 - 1;
    screenSource.y = -(sourceY / viewportHeight * 2 - 1);
    if ((_a2 = EngineStore.LastCreatedEngine) == null ? void 0 : _a2.isNDCHalfZRange) {
      screenSource.z = sourceZ;
    } else {
      screenSource.z = 2 * sourceZ - 1;
    }
    Vector3._UnprojectFromInvertedMatrixToRef(screenSource, matrix, result);
    return result;
  }
  /**
   * Gets the minimal coordinate values between two Vector3
   * Example Playground https://playground.babylonjs.com/#R1F8YU#97
   * @param left defines the first operand
   * @param right defines the second operand
   * @returns the new Vector3
   */
  static Minimize(left, right) {
    const min = new Vector3();
    min.copyFrom(left);
    min.minimizeInPlace(right);
    return min;
  }
  /**
   * Gets the maximal coordinate values between two Vector3
   * Example Playground https://playground.babylonjs.com/#R1F8YU#96
   * @param left defines the first operand
   * @param right defines the second operand
   * @returns the new Vector3
   */
  static Maximize(left, right) {
    const max = new Vector3();
    max.copyFrom(left);
    max.maximizeInPlace(right);
    return max;
  }
  /**
   * Returns the distance between the vectors "value1" and "value2"
   * Example Playground https://playground.babylonjs.com/#R1F8YU#81
   * @param value1 defines the first operand
   * @param value2 defines the second operand
   * @returns the distance
   */
  static Distance(value1, value2) {
    return Math.sqrt(Vector3.DistanceSquared(value1, value2));
  }
  /**
   * Returns the squared distance between the vectors "value1" and "value2"
   * Example Playground https://playground.babylonjs.com/#R1F8YU#80
   * @param value1 defines the first operand
   * @param value2 defines the second operand
   * @returns the squared distance
   */
  static DistanceSquared(value1, value2) {
    const x2 = value1._x - value2._x;
    const y2 = value1._y - value2._y;
    const z2 = value1._z - value2._z;
    return x2 * x2 + y2 * y2 + z2 * z2;
  }
  /**
   * Projects "vector" on the triangle determined by its extremities "p0", "p1" and "p2", stores the result in "ref"
   * and returns the distance to the projected point.
   * Example Playground https://playground.babylonjs.com/#R1F8YU#104
   * From http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.104.4264&rep=rep1&type=pdf
   *
   * @param vector the vector to get distance from
   * @param p0 extremity of the triangle
   * @param p1 extremity of the triangle
   * @param p2 extremity of the triangle
   * @param ref variable to store the result to
   * @returns The distance between "ref" and "vector"
   */
  static ProjectOnTriangleToRef(vector, p0, p1, p2, ref) {
    const p1p0 = MathTmp.Vector3[0];
    const p2p0 = MathTmp.Vector3[1];
    const p2p1 = MathTmp.Vector3[2];
    const normal = MathTmp.Vector3[3];
    const vectorp0 = MathTmp.Vector3[4];
    p1.subtractToRef(p0, p1p0);
    p2.subtractToRef(p0, p2p0);
    p2.subtractToRef(p1, p2p1);
    const p1p0L = p1p0.length();
    const p2p0L = p2p0.length();
    const p2p1L = p2p1.length();
    if (p1p0L < Epsilon || p2p0L < Epsilon || p2p1L < Epsilon) {
      ref.copyFrom(p0);
      return Vector3.Distance(vector, p0);
    }
    vector.subtractToRef(p0, vectorp0);
    Vector3.CrossToRef(p1p0, p2p0, normal);
    const nl = normal.length();
    if (nl < Epsilon) {
      ref.copyFrom(p0);
      return Vector3.Distance(vector, p0);
    }
    normal.normalizeFromLength(nl);
    let l2 = vectorp0.length();
    if (l2 < Epsilon) {
      ref.copyFrom(p0);
      return 0;
    }
    vectorp0.normalizeFromLength(l2);
    const cosA = Vector3.Dot(normal, vectorp0);
    const projVector = MathTmp.Vector3[5];
    const proj = MathTmp.Vector3[6];
    projVector.copyFrom(normal).scaleInPlace(-l2 * cosA);
    proj.copyFrom(vector).addInPlace(projVector);
    const v0 = MathTmp.Vector3[4];
    const v1 = MathTmp.Vector3[5];
    const v2 = MathTmp.Vector3[7];
    const tmp = MathTmp.Vector3[8];
    v0.copyFrom(p1p0).scaleInPlace(1 / p1p0L);
    tmp.copyFrom(p2p0).scaleInPlace(1 / p2p0L);
    v0.addInPlace(tmp).scaleInPlace(-1);
    v1.copyFrom(p1p0).scaleInPlace(-1 / p1p0L);
    tmp.copyFrom(p2p1).scaleInPlace(1 / p2p1L);
    v1.addInPlace(tmp).scaleInPlace(-1);
    v2.copyFrom(p2p1).scaleInPlace(-1 / p2p1L);
    tmp.copyFrom(p2p0).scaleInPlace(-1 / p2p0L);
    v2.addInPlace(tmp).scaleInPlace(-1);
    const projP = MathTmp.Vector3[9];
    let dot;
    projP.copyFrom(proj).subtractInPlace(p0);
    Vector3.CrossToRef(v0, projP, tmp);
    dot = Vector3.Dot(tmp, normal);
    const s0 = dot;
    projP.copyFrom(proj).subtractInPlace(p1);
    Vector3.CrossToRef(v1, projP, tmp);
    dot = Vector3.Dot(tmp, normal);
    const s1 = dot;
    projP.copyFrom(proj).subtractInPlace(p2);
    Vector3.CrossToRef(v2, projP, tmp);
    dot = Vector3.Dot(tmp, normal);
    const s2 = dot;
    const edge = MathTmp.Vector3[10];
    let e0, e1;
    if (s0 > 0 && s1 < 0) {
      edge.copyFrom(p1p0);
      e0 = p0;
      e1 = p1;
    } else if (s1 > 0 && s2 < 0) {
      edge.copyFrom(p2p1);
      e0 = p1;
      e1 = p2;
    } else {
      edge.copyFrom(p2p0).scaleInPlace(-1);
      e0 = p2;
      e1 = p0;
    }
    const tmp2 = MathTmp.Vector3[9];
    const tmp3 = MathTmp.Vector3[4];
    e0.subtractToRef(proj, tmp);
    e1.subtractToRef(proj, tmp2);
    Vector3.CrossToRef(tmp, tmp2, tmp3);
    const isOutside = Vector3.Dot(tmp3, normal) < 0;
    if (!isOutside) {
      ref.copyFrom(proj);
      return Math.abs(l2 * cosA);
    }
    const r3 = MathTmp.Vector3[5];
    Vector3.CrossToRef(edge, tmp3, r3);
    r3.normalize();
    const e0proj = MathTmp.Vector3[9];
    e0proj.copyFrom(e0).subtractInPlace(proj);
    const e0projL = e0proj.length();
    if (e0projL < Epsilon) {
      ref.copyFrom(e0);
      return Vector3.Distance(vector, e0);
    }
    e0proj.normalizeFromLength(e0projL);
    const cosG = Vector3.Dot(r3, e0proj);
    const triProj = MathTmp.Vector3[7];
    triProj.copyFrom(proj).addInPlace(r3.scaleInPlace(e0projL * cosG));
    tmp.copyFrom(triProj).subtractInPlace(e0);
    l2 = edge.length();
    edge.normalizeFromLength(l2);
    let t2 = Vector3.Dot(tmp, edge) / Math.max(l2, Epsilon);
    t2 = Clamp(t2, 0, 1);
    triProj.copyFrom(e0).addInPlace(edge.scaleInPlace(t2 * l2));
    ref.copyFrom(triProj);
    return Vector3.Distance(vector, triProj);
  }
  /**
   * Returns a new Vector3 located at the center between "value1" and "value2"
   * Example Playground https://playground.babylonjs.com/#R1F8YU#72
   * @param value1 defines the first operand
   * @param value2 defines the second operand
   * @returns the new Vector3
   */
  static Center(value1, value2) {
    return Vector3.CenterToRef(value1, value2, Vector3.Zero());
  }
  /**
   * Gets the center of the vectors "value1" and "value2" and stores the result in the vector "ref"
   * Example Playground https://playground.babylonjs.com/#R1F8YU#73
   * @param value1 defines first vector
   * @param value2 defines second vector
   * @param ref defines third vector
   * @returns ref
   */
  static CenterToRef(value1, value2, ref) {
    return ref.copyFromFloats((value1._x + value2._x) / 2, (value1._y + value2._y) / 2, (value1._z + value2._z) / 2);
  }
  /**
   * Given three orthogonal normalized left-handed oriented Vector3 axis in space (target system),
   * RotationFromAxis() returns the rotation Euler angles (ex : rotation.x, rotation.y, rotation.z) to apply
   * to something in order to rotate it from its local system to the given target system
   * Note: axis1, axis2 and axis3 are normalized during this operation
   * Example Playground https://playground.babylonjs.com/#R1F8YU#106
   * @param axis1 defines the first axis
   * @param axis2 defines the second axis
   * @param axis3 defines the third axis
   * @returns a new Vector3
   * @see https://doc.babylonjs.com/features/featuresDeepDive/mesh/transforms/center_origin/target_align
   */
  static RotationFromAxis(axis1, axis2, axis3) {
    const rotation = new Vector3();
    Vector3.RotationFromAxisToRef(axis1, axis2, axis3, rotation);
    return rotation;
  }
  /**
   * The same than RotationFromAxis but updates the given ref Vector3 parameter instead of returning a new Vector3
   * Example Playground https://playground.babylonjs.com/#R1F8YU#107
   * @param axis1 defines the first axis
   * @param axis2 defines the second axis
   * @param axis3 defines the third axis
   * @param ref defines the Vector3 where to store the result
   * @returns result input
   */
  static RotationFromAxisToRef(axis1, axis2, axis3, ref) {
    const quat = MathTmp.Quaternion[0];
    Quaternion.RotationQuaternionFromAxisToRef(axis1, axis2, axis3, quat);
    quat.toEulerAnglesToRef(ref);
    return ref;
  }
}
Vector3._V8PerformanceHack = new Vector3(0.5, 0.5, 0.5);
Vector3._UpReadOnly = Vector3.Up();
Vector3._DownReadOnly = Vector3.Down();
Vector3._LeftHandedForwardReadOnly = Vector3.Forward(false);
Vector3._RightHandedForwardReadOnly = Vector3.Forward(true);
Vector3._LeftHandedBackwardReadOnly = Vector3.Backward(false);
Vector3._RightHandedBackwardReadOnly = Vector3.Backward(true);
Vector3._RightReadOnly = Vector3.Right();
Vector3._LeftReadOnly = Vector3.Left();
Vector3._ZeroReadOnly = Vector3.Zero();
Vector3._OneReadOnly = Vector3.One();
Object.defineProperties(Vector3.prototype, {
  dimension: { value: [3] },
  rank: { value: 1 }
});
class Vector4 {
  /**
   * Creates a Vector4 object from the given floats.
   * @param x x value of the vector
   * @param y y value of the vector
   * @param z z value of the vector
   * @param w w value of the vector
   */
  constructor(x2 = 0, y2 = 0, z2 = 0, w = 0) {
    this.x = x2;
    this.y = y2;
    this.z = z2;
    this.w = w;
  }
  /**
   * Returns the string with the Vector4 coordinates.
   * @returns a string containing all the vector values
   */
  toString() {
    return `{X: ${this.x} Y: ${this.y} Z: ${this.z} W: ${this.w}}`;
  }
  /**
   * Returns the string "Vector4".
   * @returns "Vector4"
   */
  getClassName() {
    return "Vector4";
  }
  /**
   * Returns the Vector4 hash code.
   * @returns a unique hash code
   */
  getHashCode() {
    const x2 = _ExtractAsInt(this.x);
    const y2 = _ExtractAsInt(this.y);
    const z2 = _ExtractAsInt(this.z);
    const w = _ExtractAsInt(this.w);
    let hash = x2;
    hash = hash * 397 ^ y2;
    hash = hash * 397 ^ z2;
    hash = hash * 397 ^ w;
    return hash;
  }
  // Operators
  /**
   * Returns a new array populated with 4 elements : the Vector4 coordinates.
   * @returns the resulting array
   */
  asArray() {
    return [this.x, this.y, this.z, this.w];
  }
  /**
   * Populates the given array from the given index with the Vector4 coordinates.
   * @param array array to populate
   * @param index index of the array to start at (default: 0)
   * @returns the Vector4.
   */
  toArray(array, index2) {
    if (index2 === void 0) {
      index2 = 0;
    }
    array[index2] = this.x;
    array[index2 + 1] = this.y;
    array[index2 + 2] = this.z;
    array[index2 + 3] = this.w;
    return this;
  }
  /**
   * Update the current vector from an array
   * @param array defines the destination array
   * @param offset defines the offset in the destination array
   * @returns the current Vector3
   */
  fromArray(array, offset = 0) {
    Vector4.FromArrayToRef(array, offset, this);
    return this;
  }
  /**
   * Adds the given vector to the current Vector4.
   * @param otherVector the vector to add
   * @returns the updated Vector4.
   */
  addInPlace(otherVector) {
    this.x += otherVector.x;
    this.y += otherVector.y;
    this.z += otherVector.z;
    this.w += otherVector.w;
    return this;
  }
  /**
   * Adds the given coordinates to the current Vector4
   * @param x defines the x coordinate of the operand
   * @param y defines the y coordinate of the operand
   * @param z defines the z coordinate of the operand
   * @param w defines the w coordinate of the operand
   * @returns the current updated Vector4
   */
  addInPlaceFromFloats(x2, y2, z2, w) {
    this.x += x2;
    this.y += y2;
    this.z += z2;
    this.w += w;
    return this;
  }
  /**
   * Returns a new Vector4 as the result of the addition of the current Vector4 and the given one.
   * @param otherVector the vector to add
   * @returns the resulting vector
   */
  add(otherVector) {
    return new Vector4(this.x + otherVector.x, this.y + otherVector.y, this.z + otherVector.z, this.w + otherVector.w);
  }
  /**
   * Updates the given vector "result" with the result of the addition of the current Vector4 and the given one.
   * @param otherVector the vector to add
   * @param result the vector to store the result
   * @returns result input
   */
  addToRef(otherVector, result) {
    result.x = this.x + otherVector.x;
    result.y = this.y + otherVector.y;
    result.z = this.z + otherVector.z;
    result.w = this.w + otherVector.w;
    return result;
  }
  /**
   * Subtract in place the given vector from the current Vector4.
   * @param otherVector the vector to subtract
   * @returns the updated Vector4.
   */
  subtractInPlace(otherVector) {
    this.x -= otherVector.x;
    this.y -= otherVector.y;
    this.z -= otherVector.z;
    this.w -= otherVector.w;
    return this;
  }
  /**
   * Returns a new Vector4 with the result of the subtraction of the given vector from the current Vector4.
   * @param otherVector the vector to add
   * @returns the new vector with the result
   */
  subtract(otherVector) {
    return new Vector4(this.x - otherVector.x, this.y - otherVector.y, this.z - otherVector.z, this.w - otherVector.w);
  }
  /**
   * Sets the given vector "result" with the result of the subtraction of the given vector from the current Vector4.
   * @param otherVector the vector to subtract
   * @param result the vector to store the result
   * @returns result input
   */
  subtractToRef(otherVector, result) {
    result.x = this.x - otherVector.x;
    result.y = this.y - otherVector.y;
    result.z = this.z - otherVector.z;
    result.w = this.w - otherVector.w;
    return result;
  }
  /**
   * Returns a new Vector4 set with the result of the subtraction of the given floats from the current Vector4 coordinates.
   * @param x value to subtract
   * @param y value to subtract
   * @param z value to subtract
   * @param w value to subtract
   * @returns new vector containing the result
   */
  subtractFromFloats(x2, y2, z2, w) {
    return new Vector4(this.x - x2, this.y - y2, this.z - z2, this.w - w);
  }
  /**
   * Sets the given vector "result" set with the result of the subtraction of the given floats from the current Vector4 coordinates.
   * @param x value to subtract
   * @param y value to subtract
   * @param z value to subtract
   * @param w value to subtract
   * @param result the vector to store the result in
   * @returns result input
   */
  subtractFromFloatsToRef(x2, y2, z2, w, result) {
    result.x = this.x - x2;
    result.y = this.y - y2;
    result.z = this.z - z2;
    result.w = this.w - w;
    return result;
  }
  /**
   * Returns a new Vector4 set with the current Vector4 negated coordinates.
   * @returns a new vector with the negated values
   */
  negate() {
    return new Vector4(-this.x, -this.y, -this.z, -this.w);
  }
  /**
   * Negate this vector in place
   * @returns this
   */
  negateInPlace() {
    this.x *= -1;
    this.y *= -1;
    this.z *= -1;
    this.w *= -1;
    return this;
  }
  /**
   * Negate the current Vector4 and stores the result in the given vector "result" coordinates
   * @param result defines the Vector3 object where to store the result
   * @returns the result
   */
  negateToRef(result) {
    result.x = -this.x;
    result.y = -this.y;
    result.z = -this.z;
    result.w = -this.w;
    return result;
  }
  /**
   * Multiplies the current Vector4 coordinates by scale (float).
   * @param scale the number to scale with
   * @returns the updated Vector4.
   */
  scaleInPlace(scale) {
    this.x *= scale;
    this.y *= scale;
    this.z *= scale;
    this.w *= scale;
    return this;
  }
  /**
   * Returns a new Vector4 set with the current Vector4 coordinates multiplied by scale (float).
   * @param scale the number to scale with
   * @returns a new vector with the result
   */
  scale(scale) {
    return new Vector4(this.x * scale, this.y * scale, this.z * scale, this.w * scale);
  }
  /**
   * Sets the given vector "result" with the current Vector4 coordinates multiplied by scale (float).
   * @param scale the number to scale with
   * @param result a vector to store the result in
   * @returns result input
   */
  scaleToRef(scale, result) {
    result.x = this.x * scale;
    result.y = this.y * scale;
    result.z = this.z * scale;
    result.w = this.w * scale;
    return result;
  }
  /**
   * Scale the current Vector4 values by a factor and add the result to a given Vector4
   * @param scale defines the scale factor
   * @param result defines the Vector4 object where to store the result
   * @returns result input
   */
  scaleAndAddToRef(scale, result) {
    result.x += this.x * scale;
    result.y += this.y * scale;
    result.z += this.z * scale;
    result.w += this.w * scale;
    return result;
  }
  /**
   * Boolean : True if the current Vector4 coordinates are stricly equal to the given ones.
   * @param otherVector the vector to compare against
   * @returns true if they are equal
   */
  equals(otherVector) {
    return otherVector && this.x === otherVector.x && this.y === otherVector.y && this.z === otherVector.z && this.w === otherVector.w;
  }
  /**
   * Boolean : True if the current Vector4 coordinates are each beneath the distance "epsilon" from the given vector ones.
   * @param otherVector vector to compare against
   * @param epsilon (Default: very small number)
   * @returns true if they are equal
   */
  equalsWithEpsilon(otherVector, epsilon = Epsilon) {
    return otherVector && WithinEpsilon(this.x, otherVector.x, epsilon) && WithinEpsilon(this.y, otherVector.y, epsilon) && WithinEpsilon(this.z, otherVector.z, epsilon) && WithinEpsilon(this.w, otherVector.w, epsilon);
  }
  /**
   * Boolean : True if the given floats are strictly equal to the current Vector4 coordinates.
   * @param x x value to compare against
   * @param y y value to compare against
   * @param z z value to compare against
   * @param w w value to compare against
   * @returns true if equal
   */
  equalsToFloats(x2, y2, z2, w) {
    return this.x === x2 && this.y === y2 && this.z === z2 && this.w === w;
  }
  /**
   * Multiplies in place the current Vector4 by the given one.
   * @param otherVector vector to multiple with
   * @returns the updated Vector4.
   */
  multiplyInPlace(otherVector) {
    this.x *= otherVector.x;
    this.y *= otherVector.y;
    this.z *= otherVector.z;
    this.w *= otherVector.w;
    return this;
  }
  /**
   * Returns a new Vector4 set with the multiplication result of the current Vector4 and the given one.
   * @param otherVector vector to multiple with
   * @returns resulting new vector
   */
  multiply(otherVector) {
    return new Vector4(this.x * otherVector.x, this.y * otherVector.y, this.z * otherVector.z, this.w * otherVector.w);
  }
  /**
   * Updates the given vector "result" with the multiplication result of the current Vector4 and the given one.
   * @param otherVector vector to multiple with
   * @param result vector to store the result
   * @returns result input
   */
  multiplyToRef(otherVector, result) {
    result.x = this.x * otherVector.x;
    result.y = this.y * otherVector.y;
    result.z = this.z * otherVector.z;
    result.w = this.w * otherVector.w;
    return result;
  }
  /**
   * Returns a new Vector4 set with the multiplication result of the given floats and the current Vector4 coordinates.
   * @param x x value multiply with
   * @param y y value multiply with
   * @param z z value multiply with
   * @param w w value multiply with
   * @returns resulting new vector
   */
  multiplyByFloats(x2, y2, z2, w) {
    return new Vector4(this.x * x2, this.y * y2, this.z * z2, this.w * w);
  }
  /**
   * Returns a new Vector4 set with the division result of the current Vector4 by the given one.
   * @param otherVector vector to devide with
   * @returns resulting new vector
   */
  divide(otherVector) {
    return new Vector4(this.x / otherVector.x, this.y / otherVector.y, this.z / otherVector.z, this.w / otherVector.w);
  }
  /**
   * Updates the given vector "result" with the division result of the current Vector4 by the given one.
   * @param otherVector vector to devide with
   * @param result vector to store the result
   * @returns result input
   */
  divideToRef(otherVector, result) {
    result.x = this.x / otherVector.x;
    result.y = this.y / otherVector.y;
    result.z = this.z / otherVector.z;
    result.w = this.w / otherVector.w;
    return result;
  }
  /**
   * Divides the current Vector3 coordinates by the given ones.
   * @param otherVector vector to devide with
   * @returns the updated Vector3.
   */
  divideInPlace(otherVector) {
    return this.divideToRef(otherVector, this);
  }
  /**
   * Updates the Vector4 coordinates with the minimum values between its own and the given vector ones
   * @param other defines the second operand
   * @returns the current updated Vector4
   */
  minimizeInPlace(other) {
    if (other.x < this.x) {
      this.x = other.x;
    }
    if (other.y < this.y) {
      this.y = other.y;
    }
    if (other.z < this.z) {
      this.z = other.z;
    }
    if (other.w < this.w) {
      this.w = other.w;
    }
    return this;
  }
  /**
   * Updates the Vector4 coordinates with the maximum values between its own and the given vector ones
   * @param other defines the second operand
   * @returns the current updated Vector4
   */
  maximizeInPlace(other) {
    if (other.x > this.x) {
      this.x = other.x;
    }
    if (other.y > this.y) {
      this.y = other.y;
    }
    if (other.z > this.z) {
      this.z = other.z;
    }
    if (other.w > this.w) {
      this.w = other.w;
    }
    return this;
  }
  /**
   * Updates the current Vector4 with the minimal coordinate values between its and the given coordinates
   * @param x defines the x coordinate of the operand
   * @param y defines the y coordinate of the operand
   * @param z defines the z coordinate of the operand
   * @param w defines the w coordinate of the operand
   * @returns the current updated Vector4
   */
  minimizeInPlaceFromFloats(x2, y2, z2, w) {
    this.x = Math.min(x2, this.x);
    this.y = Math.min(y2, this.y);
    this.z = Math.min(z2, this.z);
    this.w = Math.min(w, this.w);
    return this;
  }
  /**
   * Updates the current Vector4 with the maximal coordinate values between its and the given coordinates.
   * @param x defines the x coordinate of the operand
   * @param y defines the y coordinate of the operand
   * @param z defines the z coordinate of the operand
   * @param w defines the w coordinate of the operand
   * @returns the current updated Vector4
   */
  maximizeInPlaceFromFloats(x2, y2, z2, w) {
    this.x = Math.max(x2, this.x);
    this.y = Math.max(y2, this.y);
    this.z = Math.max(z2, this.z);
    this.w = Math.max(w, this.w);
    return this;
  }
  /**
   * Gets the current Vector4's floored values and stores them in result
   * @param result the vector to store the result in
   * @returns the result vector
   */
  floorToRef(result) {
    result.x = Math.floor(this.x);
    result.y = Math.floor(this.y);
    result.z = Math.floor(this.z);
    result.w = Math.floor(this.w);
    return result;
  }
  /**
   * Gets a new Vector4 from current Vector4 floored values
   * @returns a new Vector4
   */
  floor() {
    return new Vector4(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z), Math.floor(this.w));
  }
  /**
   * Gets the current Vector4's fractional values and stores them in result
   * @param result the vector to store the result in
   * @returns the result vector
   */
  fractToRef(result) {
    result.x = this.x - Math.floor(this.x);
    result.y = this.y - Math.floor(this.y);
    result.z = this.z - Math.floor(this.z);
    result.w = this.w - Math.floor(this.w);
    return result;
  }
  /**
   * Gets a new Vector4 from current Vector4 fractional values
   * @returns a new Vector4
   */
  fract() {
    return new Vector4(this.x - Math.floor(this.x), this.y - Math.floor(this.y), this.z - Math.floor(this.z), this.w - Math.floor(this.w));
  }
  // Properties
  /**
   * Returns the Vector4 length (float).
   * @returns the length
   */
  length() {
    return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
  }
  /**
   * Returns the Vector4 squared length (float).
   * @returns the length squared
   */
  lengthSquared() {
    return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
  }
  // Methods
  /**
   * Normalizes in place the Vector4.
   * @returns the updated Vector4.
   */
  normalize() {
    return this.normalizeFromLength(this.length());
  }
  /**
   * Normalize the current Vector4 with the given input length.
   * Please note that this is an in place operation.
   * @param len the length of the vector
   * @returns the current updated Vector4
   */
  normalizeFromLength(len) {
    if (len === 0 || len === 1) {
      return this;
    }
    return this.scaleInPlace(1 / len);
  }
  /**
   * Normalize the current Vector4 to a new vector
   * @returns the new Vector4
   */
  normalizeToNew() {
    return this.normalizeToRef(new Vector4());
  }
  /**
   * Normalize the current Vector4 to the reference
   * @param reference define the Vector4 to update
   * @returns the updated Vector4
   */
  normalizeToRef(reference) {
    const len = this.length();
    if (len === 0 || len === 1) {
      reference.x = this.x;
      reference.y = this.y;
      reference.z = this.z;
      reference.w = this.w;
      return reference;
    }
    return this.scaleToRef(1 / len, reference);
  }
  /**
   * Returns a new Vector3 from the Vector4 (x, y, z) coordinates.
   * @returns this converted to a new vector3
   */
  toVector3() {
    return new Vector3(this.x, this.y, this.z);
  }
  /**
   * Returns a new Vector4 copied from the current one.
   * @returns the new cloned vector
   */
  clone() {
    return new Vector4(this.x, this.y, this.z, this.w);
  }
  /**
   * Updates the current Vector4 with the given one coordinates.
   * @param source the source vector to copy from
   * @returns the updated Vector4.
   */
  copyFrom(source) {
    this.x = source.x;
    this.y = source.y;
    this.z = source.z;
    this.w = source.w;
    return this;
  }
  /**
   * Updates the current Vector4 coordinates with the given floats.
   * @param x float to copy from
   * @param y float to copy from
   * @param z float to copy from
   * @param w float to copy from
   * @returns the updated Vector4.
   */
  copyFromFloats(x2, y2, z2, w) {
    this.x = x2;
    this.y = y2;
    this.z = z2;
    this.w = w;
    return this;
  }
  /**
   * Updates the current Vector4 coordinates with the given floats.
   * @param x float to set from
   * @param y float to set from
   * @param z float to set from
   * @param w float to set from
   * @returns the updated Vector4.
   */
  set(x2, y2, z2, w) {
    return this.copyFromFloats(x2, y2, z2, w);
  }
  /**
   * Copies the given float to the current Vector4 coordinates
   * @param v defines the x, y, z and w coordinates of the operand
   * @returns the current updated Vector4
   */
  setAll(v2) {
    this.x = this.y = this.z = this.w = v2;
    return this;
  }
  /**
   * Returns the dot product (float) between the current vectors and "otherVector"
   * @param otherVector defines the right operand
   * @returns the dot product
   */
  dot(otherVector) {
    return this.x * otherVector.x + this.y * otherVector.y + this.z * otherVector.z + this.w * otherVector.w;
  }
  // Statics
  /**
   * Returns a new Vector4 set from the starting index of the given array.
   * @param array the array to pull values from
   * @param offset the offset into the array to start at
   * @returns the new vector
   */
  static FromArray(array, offset) {
    if (!offset) {
      offset = 0;
    }
    return new Vector4(array[offset], array[offset + 1], array[offset + 2], array[offset + 3]);
  }
  /**
   * Updates the given vector "result" from the starting index of the given array.
   * @param array the array to pull values from
   * @param offset the offset into the array to start at
   * @param result the vector to store the result in
   * @returns result input
   */
  static FromArrayToRef(array, offset, result) {
    result.x = array[offset];
    result.y = array[offset + 1];
    result.z = array[offset + 2];
    result.w = array[offset + 3];
    return result;
  }
  /**
   * Updates the given vector "result" from the starting index of the given Float32Array.
   * @param array the array to pull values from
   * @param offset the offset into the array to start at
   * @param result the vector to store the result in
   * @returns result input
   */
  static FromFloatArrayToRef(array, offset, result) {
    Vector4.FromArrayToRef(array, offset, result);
    return result;
  }
  /**
   * Updates the given vector "result" coordinates from the given floats.
   * @param x float to set from
   * @param y float to set from
   * @param z float to set from
   * @param w float to set from
   * @param result the vector to the floats in
   * @returns result input
   */
  static FromFloatsToRef(x2, y2, z2, w, result) {
    result.x = x2;
    result.y = y2;
    result.z = z2;
    result.w = w;
    return result;
  }
  /**
   * Returns a new Vector4 set to (0.0, 0.0, 0.0, 0.0)
   * @returns the new vector
   */
  static Zero() {
    return new Vector4(0, 0, 0, 0);
  }
  /**
   * Returns a new Vector4 set to (1.0, 1.0, 1.0, 1.0)
   * @returns the new vector
   */
  static One() {
    return new Vector4(1, 1, 1, 1);
  }
  /**
   * Returns a new Vector4 with random values between min and max
   * @param min the minimum random value
   * @param max the maximum random value
   * @returns a Vector4 with random values between min and max
   */
  static Random(min = 0, max = 1) {
    return new Vector4(RandomRange(min, max), RandomRange(min, max), RandomRange(min, max), RandomRange(min, max));
  }
  /**
   * Sets a Vector4 with random values between min and max
   * @param min the minimum random value
   * @param max the maximum random value
   * @param ref the ref to store the values in
   * @returns the ref with random values between min and max
   */
  static RandomToRef(min = 0, max = 1, ref) {
    ref.x = RandomRange(min, max);
    ref.y = RandomRange(min, max);
    ref.z = RandomRange(min, max);
    ref.w = RandomRange(min, max);
    return ref;
  }
  /**
   * Returns a new Vector4 set with the coordinates of "value", if the vector "value" is in the cube defined by the vectors "min" and "max"
   * If a coordinate value of "value" is lower than one of the "min" coordinate, then this "value" coordinate is set with the "min" one
   * If a coordinate value of "value" is greater than one of the "max" coordinate, then this "value" coordinate is set with the "max" one
   * @param value defines the current value
   * @param min defines the lower range value
   * @param max defines the upper range value
   * @returns the new Vector4
   */
  static Clamp(value, min, max) {
    return Vector4.ClampToRef(value, min, max, new Vector4());
  }
  /**
   * Sets the given vector "result" with the coordinates of "value", if the vector "value" is in the cube defined by the vectors "min" and "max"
   * If a coordinate value of "value" is lower than one of the "min" coordinate, then this "value" coordinate is set with the "min" one
   * If a coordinate value of "value" is greater than one of the "max" coordinate, then this "value" coordinate is set with the "max" one
   * @param value defines the current value
   * @param min defines the lower range value
   * @param max defines the upper range value
   * @param result defines the Vector4 where to store the result
   * @returns result input
   */
  static ClampToRef(value, min, max, result) {
    result.x = Clamp(value.x, min.x, max.x);
    result.y = Clamp(value.y, min.y, max.y);
    result.z = Clamp(value.z, min.z, max.z);
    result.w = Clamp(value.w, min.w, max.w);
    return result;
  }
  /**
   * Checks if a given vector is inside a specific range
   * Example Playground https://playground.babylonjs.com/#R1F8YU#75
   * @param v defines the vector to test
   * @param min defines the minimum range
   * @param max defines the maximum range
   */
  static CheckExtends(v2, min, max) {
    min.minimizeInPlace(v2);
    max.maximizeInPlace(v2);
  }
  /**
   * Gets a zero Vector4 that must not be updated
   */
  static get ZeroReadOnly() {
    return Vector4._ZeroReadOnly;
  }
  /**
   * Returns a new normalized Vector4 from the given one.
   * @param vector the vector to normalize
   * @returns the vector
   */
  static Normalize(vector) {
    return Vector4.NormalizeToRef(vector, new Vector4());
  }
  /**
   * Updates the given vector "result" from the normalization of the given one.
   * @param vector the vector to normalize
   * @param result the vector to store the result in
   * @returns result input
   */
  static NormalizeToRef(vector, result) {
    vector.normalizeToRef(result);
    return result;
  }
  /**
   * Returns a vector with the minimum values from the left and right vectors
   * @param left left vector to minimize
   * @param right right vector to minimize
   * @returns a new vector with the minimum of the left and right vector values
   */
  static Minimize(left, right) {
    const min = new Vector4();
    min.copyFrom(left);
    min.minimizeInPlace(right);
    return min;
  }
  /**
   * Returns a vector with the maximum values from the left and right vectors
   * @param left left vector to maximize
   * @param right right vector to maximize
   * @returns a new vector with the maximum of the left and right vector values
   */
  static Maximize(left, right) {
    const max = new Vector4();
    max.copyFrom(left);
    max.maximizeInPlace(right);
    return max;
  }
  /**
   * Returns the distance (float) between the vectors "value1" and "value2".
   * @param value1 value to calulate the distance between
   * @param value2 value to calulate the distance between
   * @returns the distance between the two vectors
   */
  static Distance(value1, value2) {
    return Math.sqrt(Vector4.DistanceSquared(value1, value2));
  }
  /**
   * Returns the squared distance (float) between the vectors "value1" and "value2".
   * @param value1 value to calulate the distance between
   * @param value2 value to calulate the distance between
   * @returns the distance between the two vectors squared
   */
  static DistanceSquared(value1, value2) {
    const x2 = value1.x - value2.x;
    const y2 = value1.y - value2.y;
    const z2 = value1.z - value2.z;
    const w = value1.w - value2.w;
    return x2 * x2 + y2 * y2 + z2 * z2 + w * w;
  }
  /**
   * Returns a new Vector4 located at the center between the vectors "value1" and "value2".
   * @param value1 value to calulate the center between
   * @param value2 value to calulate the center between
   * @returns the center between the two vectors
   */
  static Center(value1, value2) {
    return Vector4.CenterToRef(value1, value2, new Vector4());
  }
  /**
   * Gets the center of the vectors "value1" and "value2" and stores the result in the vector "ref"
   * @param value1 defines first vector
   * @param value2 defines second vector
   * @param ref defines third vector
   * @returns ref
   */
  static CenterToRef(value1, value2, ref) {
    ref.x = (value1.x + value2.x) / 2;
    ref.y = (value1.y + value2.y) / 2;
    ref.z = (value1.z + value2.z) / 2;
    ref.w = (value1.w + value2.w) / 2;
    return ref;
  }
  /**
   * Returns a new Vector4 set with the result of the transformation by the given matrix of the given vector.
   * This method computes tranformed coordinates only, not transformed direction vectors (ie. it takes translation in account)
   * The difference with Vector3.TransformCoordinates is that the w component is not used to divide the other coordinates but is returned in the w coordinate instead
   * @param vector defines the Vector3 to transform
   * @param transformation defines the transformation matrix
   * @returns the transformed Vector4
   */
  static TransformCoordinates(vector, transformation) {
    return Vector4.TransformCoordinatesToRef(vector, transformation, new Vector4());
  }
  /**
   * Sets the given vector "result" coordinates with the result of the transformation by the given matrix of the given vector
   * This method computes tranformed coordinates only, not transformed direction vectors (ie. it takes translation in account)
   * The difference with Vector3.TransformCoordinatesToRef is that the w component is not used to divide the other coordinates but is returned in the w coordinate instead
   * @param vector defines the Vector3 to transform
   * @param transformation defines the transformation matrix
   * @param result defines the Vector4 where to store the result
   * @returns result input
   */
  static TransformCoordinatesToRef(vector, transformation, result) {
    Vector4.TransformCoordinatesFromFloatsToRef(vector._x, vector._y, vector._z, transformation, result);
    return result;
  }
  /**
   * Sets the given vector "result" coordinates with the result of the transformation by the given matrix of the given floats (x, y, z)
   * This method computes tranformed coordinates only, not transformed direction vectors
   * The difference with Vector3.TransformCoordinatesFromFloatsToRef is that the w component is not used to divide the other coordinates but is returned in the w coordinate instead
   * @param x define the x coordinate of the source vector
   * @param y define the y coordinate of the source vector
   * @param z define the z coordinate of the source vector
   * @param transformation defines the transformation matrix
   * @param result defines the Vector4 where to store the result
   * @returns result input
   */
  static TransformCoordinatesFromFloatsToRef(x2, y2, z2, transformation, result) {
    const m2 = transformation.m;
    const rx = x2 * m2[0] + y2 * m2[4] + z2 * m2[8] + m2[12];
    const ry = x2 * m2[1] + y2 * m2[5] + z2 * m2[9] + m2[13];
    const rz = x2 * m2[2] + y2 * m2[6] + z2 * m2[10] + m2[14];
    const rw = x2 * m2[3] + y2 * m2[7] + z2 * m2[11] + m2[15];
    result.x = rx;
    result.y = ry;
    result.z = rz;
    result.w = rw;
    return result;
  }
  /**
   * Returns a new Vector4 set with the result of the normal transformation by the given matrix of the given vector.
   * This methods computes transformed normalized direction vectors only.
   * @param vector the vector to transform
   * @param transformation the transformation matrix to apply
   * @returns the new vector
   */
  static TransformNormal(vector, transformation) {
    return Vector4.TransformNormalToRef(vector, transformation, new Vector4());
  }
  /**
   * Sets the given vector "result" with the result of the normal transformation by the given matrix of the given vector.
   * This methods computes transformed normalized direction vectors only.
   * @param vector the vector to transform
   * @param transformation the transformation matrix to apply
   * @param result the vector to store the result in
   * @returns result input
   */
  static TransformNormalToRef(vector, transformation, result) {
    const m2 = transformation.m;
    const x2 = vector.x * m2[0] + vector.y * m2[4] + vector.z * m2[8];
    const y2 = vector.x * m2[1] + vector.y * m2[5] + vector.z * m2[9];
    const z2 = vector.x * m2[2] + vector.y * m2[6] + vector.z * m2[10];
    result.x = x2;
    result.y = y2;
    result.z = z2;
    result.w = vector.w;
    return result;
  }
  /**
   * Sets the given vector "result" with the result of the normal transformation by the given matrix of the given floats (x, y, z, w).
   * This methods computes transformed normalized direction vectors only.
   * @param x value to transform
   * @param y value to transform
   * @param z value to transform
   * @param w value to transform
   * @param transformation the transformation matrix to apply
   * @param result the vector to store the results in
   * @returns result input
   */
  static TransformNormalFromFloatsToRef(x2, y2, z2, w, transformation, result) {
    const m2 = transformation.m;
    result.x = x2 * m2[0] + y2 * m2[4] + z2 * m2[8];
    result.y = x2 * m2[1] + y2 * m2[5] + z2 * m2[9];
    result.z = x2 * m2[2] + y2 * m2[6] + z2 * m2[10];
    result.w = w;
    return result;
  }
  /**
   * Creates a new Vector4 from a Vector3
   * @param source defines the source data
   * @param w defines the 4th component (default is 0)
   * @returns a new Vector4
   */
  static FromVector3(source, w = 0) {
    return new Vector4(source._x, source._y, source._z, w);
  }
  /**
   * Returns the dot product (float) between the vectors "left" and "right"
   * @param left defines the left operand
   * @param right defines the right operand
   * @returns the dot product
   */
  static Dot(left, right) {
    return left.x * right.x + left.y * right.y + left.z * right.z + left.w * right.w;
  }
}
Vector4._V8PerformanceHack = new Vector4(0.5, 0.5, 0.5, 0.5);
Vector4._ZeroReadOnly = Vector4.Zero();
Object.defineProperties(Vector4.prototype, {
  dimension: { value: [4] },
  rank: { value: 1 }
});
class Quaternion {
  /** Gets or sets the x coordinate */
  get x() {
    return this._x;
  }
  set x(value) {
    this._x = value;
    this._isDirty = true;
  }
  /** Gets or sets the y coordinate */
  get y() {
    return this._y;
  }
  set y(value) {
    this._y = value;
    this._isDirty = true;
  }
  /** Gets or sets the z coordinate */
  get z() {
    return this._z;
  }
  set z(value) {
    this._z = value;
    this._isDirty = true;
  }
  /** Gets or sets the w coordinate */
  get w() {
    return this._w;
  }
  set w(value) {
    this._w = value;
    this._isDirty = true;
  }
  /**
   * Creates a new Quaternion from the given floats
   * @param x defines the first component (0 by default)
   * @param y defines the second component (0 by default)
   * @param z defines the third component (0 by default)
   * @param w defines the fourth component (1.0 by default)
   */
  constructor(x2 = 0, y2 = 0, z2 = 0, w = 1) {
    this._isDirty = true;
    this._x = x2;
    this._y = y2;
    this._z = z2;
    this._w = w;
  }
  /**
   * Gets a string representation for the current quaternion
   * @returns a string with the Quaternion coordinates
   */
  toString() {
    return `{X: ${this._x} Y: ${this._y} Z: ${this._z} W: ${this._w}}`;
  }
  /**
   * Gets the class name of the quaternion
   * @returns the string "Quaternion"
   */
  getClassName() {
    return "Quaternion";
  }
  /**
   * Gets a hash code for this quaternion
   * @returns the quaternion hash code
   */
  getHashCode() {
    const x2 = _ExtractAsInt(this._x);
    const y2 = _ExtractAsInt(this._y);
    const z2 = _ExtractAsInt(this._z);
    const w = _ExtractAsInt(this._w);
    let hash = x2;
    hash = hash * 397 ^ y2;
    hash = hash * 397 ^ z2;
    hash = hash * 397 ^ w;
    return hash;
  }
  /**
   * Copy the quaternion to an array
   * Example Playground https://playground.babylonjs.com/#L49EJ7#13
   * @returns a new array populated with 4 elements from the quaternion coordinates
   */
  asArray() {
    return [this._x, this._y, this._z, this._w];
  }
  /**
   * Stores from the starting index in the given array the Quaternion successive values
   * Example Playground https://playground.babylonjs.com/#L49EJ7#59
   * @param array defines the array where to store the x,y,z,w components
   * @param index defines an optional index in the target array to define where to start storing values
   * @returns the current Quaternion object
   */
  toArray(array, index2 = 0) {
    array[index2] = this._x;
    array[index2 + 1] = this._y;
    array[index2 + 2] = this._z;
    array[index2 + 3] = this._w;
    return this;
  }
  fromArray(array, index2 = 0) {
    return Quaternion.FromArrayToRef(array, index2, this);
  }
  /**
   * Check if two quaternions are equals
   * Example Playground https://playground.babylonjs.com/#L49EJ7#38
   * @param otherQuaternion defines the second operand
   * @returns true if the current quaternion and the given one coordinates are strictly equals
   */
  equals(otherQuaternion) {
    return otherQuaternion && this._x === otherQuaternion._x && this._y === otherQuaternion._y && this._z === otherQuaternion._z && this._w === otherQuaternion._w;
  }
  /**
   * Gets a boolean if two quaternions are equals (using an epsilon value)
   * Example Playground https://playground.babylonjs.com/#L49EJ7#37
   * @param otherQuaternion defines the other quaternion
   * @param epsilon defines the minimal distance to consider equality
   * @returns true if the given quaternion coordinates are close to the current ones by a distance of epsilon.
   */
  equalsWithEpsilon(otherQuaternion, epsilon = Epsilon) {
    return otherQuaternion && WithinEpsilon(this._x, otherQuaternion._x, epsilon) && WithinEpsilon(this._y, otherQuaternion._y, epsilon) && WithinEpsilon(this._z, otherQuaternion._z, epsilon) && WithinEpsilon(this._w, otherQuaternion._w, epsilon);
  }
  /**
   * Clone the current quaternion
   * Example Playground https://playground.babylonjs.com/#L49EJ7#12
   * @returns a new quaternion copied from the current one
   */
  clone() {
    return new Quaternion(this._x, this._y, this._z, this._w);
  }
  /**
   * Copy a quaternion to the current one
   * Example Playground https://playground.babylonjs.com/#L49EJ7#86
   * @param other defines the other quaternion
   * @returns the updated current quaternion
   */
  copyFrom(other) {
    this._x = other._x;
    this._y = other._y;
    this._z = other._z;
    this._w = other._w;
    this._isDirty = true;
    return this;
  }
  /**
   * Updates the current quaternion with the given float coordinates
   * Example Playground https://playground.babylonjs.com/#L49EJ7#87
   * @param x defines the x coordinate
   * @param y defines the y coordinate
   * @param z defines the z coordinate
   * @param w defines the w coordinate
   * @returns the updated current quaternion
   */
  copyFromFloats(x2, y2, z2, w) {
    this._x = x2;
    this._y = y2;
    this._z = z2;
    this._w = w;
    this._isDirty = true;
    return this;
  }
  /**
   * Updates the current quaternion from the given float coordinates
   * Example Playground https://playground.babylonjs.com/#L49EJ7#56
   * @param x defines the x coordinate
   * @param y defines the y coordinate
   * @param z defines the z coordinate
   * @param w defines the w coordinate
   * @returns the updated current quaternion
   */
  set(x2, y2, z2, w) {
    return this.copyFromFloats(x2, y2, z2, w);
  }
  setAll(value) {
    return this.copyFromFloats(value, value, value, value);
  }
  /**
   * Adds two quaternions
   * Example Playground https://playground.babylonjs.com/#L49EJ7#10
   * @param other defines the second operand
   * @returns a new quaternion as the addition result of the given one and the current quaternion
   */
  add(other) {
    return new Quaternion(this._x + other._x, this._y + other._y, this._z + other._z, this._w + other._w);
  }
  /**
   * Add a quaternion to the current one
   * Example Playground https://playground.babylonjs.com/#L49EJ7#11
   * @param other defines the quaternion to add
   * @returns the current quaternion
   */
  addInPlace(other) {
    this._x += other._x;
    this._y += other._y;
    this._z += other._z;
    this._w += other._w;
    this._isDirty = true;
    return this;
  }
  addToRef(other, result) {
    result._x = this._x + other._x;
    result._y = this._y + other._y;
    result._z = this._z + other._z;
    result._w = this._w + other._w;
    result._isDirty = true;
    return result;
  }
  addInPlaceFromFloats(x2, y2, z2, w) {
    this._x += x2;
    this._y += y2;
    this._z += z2;
    this._w += w;
    this._isDirty = true;
    return this;
  }
  subtractToRef(other, result) {
    result._x = this._x - other._x;
    result._y = this._y - other._y;
    result._z = this._z - other._z;
    result._w = this._w - other._w;
    result._isDirty = true;
    return result;
  }
  subtractFromFloats(x2, y2, z2, w) {
    return this.subtractFromFloatsToRef(x2, y2, z2, w, new Quaternion());
  }
  subtractFromFloatsToRef(x2, y2, z2, w, result) {
    result._x = this._x - x2;
    result._y = this._y - y2;
    result._z = this._z - z2;
    result._w = this._w - w;
    result._isDirty = true;
    return result;
  }
  /**
   * Subtract two quaternions
   * Example Playground https://playground.babylonjs.com/#L49EJ7#57
   * @param other defines the second operand
   * @returns a new quaternion as the subtraction result of the given one from the current one
   */
  subtract(other) {
    return new Quaternion(this._x - other._x, this._y - other._y, this._z - other._z, this._w - other._w);
  }
  /**
   * Subtract a quaternion to the current one
   * Example Playground https://playground.babylonjs.com/#L49EJ7#58
   * @param other defines the quaternion to subtract
   * @returns the current quaternion
   */
  subtractInPlace(other) {
    this._x -= other._x;
    this._y -= other._y;
    this._z -= other._z;
    this._w -= other._w;
    this._isDirty = true;
    return this;
  }
  /**
   * Multiplies the current quaternion by a scale factor
   * Example Playground https://playground.babylonjs.com/#L49EJ7#88
   * @param value defines the scale factor
   * @returns a new quaternion set by multiplying the current quaternion coordinates by the float "scale"
   */
  scale(value) {
    return new Quaternion(this._x * value, this._y * value, this._z * value, this._w * value);
  }
  /**
   * Scale the current quaternion values by a factor and stores the result to a given quaternion
   * Example Playground https://playground.babylonjs.com/#L49EJ7#89
   * @param scale defines the scale factor
   * @param result defines the Quaternion object where to store the result
   * @returns result input
   */
  scaleToRef(scale, result) {
    result._x = this._x * scale;
    result._y = this._y * scale;
    result._z = this._z * scale;
    result._w = this._w * scale;
    result._isDirty = true;
    return result;
  }
  /**
   * Multiplies in place the current quaternion by a scale factor
   * Example Playground https://playground.babylonjs.com/#L49EJ7#90
   * @param value defines the scale factor
   * @returns the current modified quaternion
   */
  scaleInPlace(value) {
    this._x *= value;
    this._y *= value;
    this._z *= value;
    this._w *= value;
    this._isDirty = true;
    return this;
  }
  /**
   * Scale the current quaternion values by a factor and add the result to a given quaternion
   * Example Playground https://playground.babylonjs.com/#L49EJ7#91
   * @param scale defines the scale factor
   * @param result defines the Quaternion object where to store the result
   * @returns result input
   */
  scaleAndAddToRef(scale, result) {
    result._x += this._x * scale;
    result._y += this._y * scale;
    result._z += this._z * scale;
    result._w += this._w * scale;
    result._isDirty = true;
    return result;
  }
  /**
   * Multiplies two quaternions
   * Example Playground https://playground.babylonjs.com/#L49EJ7#43
   * @param q1 defines the second operand
   * @returns a new quaternion set as the multiplication result of the current one with the given one "q1"
   */
  multiply(q1) {
    const result = new Quaternion(0, 0, 0, 1);
    this.multiplyToRef(q1, result);
    return result;
  }
  /**
   * Sets the given "result" as the multiplication result of the current one with the given one "q1"
   * Example Playground https://playground.babylonjs.com/#L49EJ7#45
   * @param q1 defines the second operand
   * @param result defines the target quaternion
   * @returns the current quaternion
   */
  multiplyToRef(q1, result) {
    const x2 = this._x * q1._w + this._y * q1._z - this._z * q1._y + this._w * q1._x;
    const y2 = -this._x * q1._z + this._y * q1._w + this._z * q1._x + this._w * q1._y;
    const z2 = this._x * q1._y - this._y * q1._x + this._z * q1._w + this._w * q1._z;
    const w = -this._x * q1._x - this._y * q1._y - this._z * q1._z + this._w * q1._w;
    result.copyFromFloats(x2, y2, z2, w);
    return result;
  }
  /**
   * Updates the current quaternion with the multiplication of itself with the given one "q1"
   * Example Playground https://playground.babylonjs.com/#L49EJ7#46
   * @param other defines the second operand
   * @returns the currentupdated quaternion
   */
  multiplyInPlace(other) {
    return this.multiplyToRef(other, this);
  }
  multiplyByFloats(x2, y2, z2, w) {
    this._x *= x2;
    this._y *= y2;
    this._z *= z2;
    this._w *= w;
    this._isDirty = true;
    return this;
  }
  /**
   * @internal
   * Do not use
   */
  divide(_other) {
    throw new ReferenceError("Can not divide a quaternion");
  }
  /**
   * @internal
   * Do not use
   */
  divideToRef(_other, _result) {
    throw new ReferenceError("Can not divide a quaternion");
  }
  /**
   * @internal
   * Do not use
   */
  divideInPlace(_other) {
    throw new ReferenceError("Can not divide a quaternion");
  }
  /**
   * @internal
   * Do not use
   */
  minimizeInPlace() {
    throw new ReferenceError("Can not minimize a quaternion");
  }
  /**
   * @internal
   * Do not use
   */
  minimizeInPlaceFromFloats() {
    throw new ReferenceError("Can not minimize a quaternion");
  }
  /**
   * @internal
   * Do not use
   */
  maximizeInPlace() {
    throw new ReferenceError("Can not maximize a quaternion");
  }
  /**
   * @internal
   * Do not use
   */
  maximizeInPlaceFromFloats() {
    throw new ReferenceError("Can not maximize a quaternion");
  }
  negate() {
    return this.negateToRef(new Quaternion());
  }
  negateInPlace() {
    this._x = -this._x;
    this._y = -this._y;
    this._z = -this._z;
    this._w = -this._w;
    this._isDirty = true;
    return this;
  }
  negateToRef(result) {
    result._x = -this._x;
    result._y = -this._y;
    result._z = -this._z;
    result._w = -this._w;
    result._isDirty = true;
    return result;
  }
  equalsToFloats(x2, y2, z2, w) {
    return this._x === x2 && this._y === y2 && this._z === z2 && this._w === w;
  }
  /**
   * @internal
   * Do not use
   */
  floorToRef(_result) {
    throw new ReferenceError("Can not floor a quaternion");
  }
  /**
   * @internal
   * Do not use
   */
  floor() {
    throw new ReferenceError("Can not floor a quaternion");
  }
  /**
   * @internal
   * Do not use
   */
  fractToRef(_result) {
    throw new ReferenceError("Can not fract a quaternion");
  }
  /**
   * @internal
   * Do not use
   */
  fract() {
    throw new ReferenceError("Can not fract a quaternion");
  }
  /**
   * Conjugates the current quaternion and stores the result in the given quaternion
   * Example Playground https://playground.babylonjs.com/#L49EJ7#81
   * @param ref defines the target quaternion
   * @returns result input
   */
  conjugateToRef(ref) {
    ref.copyFromFloats(-this._x, -this._y, -this._z, this._w);
    return ref;
  }
  /**
   * Conjugates in place the current quaternion
   * Example Playground https://playground.babylonjs.com/#L49EJ7#82
   * @returns the current updated quaternion
   */
  conjugateInPlace() {
    this._x *= -1;
    this._y *= -1;
    this._z *= -1;
    this._isDirty = true;
    return this;
  }
  /**
   * Conjugates (1-q) the current quaternion
   * Example Playground https://playground.babylonjs.com/#L49EJ7#83
   * @returns a new quaternion
   */
  conjugate() {
    return new Quaternion(-this._x, -this._y, -this._z, this._w);
  }
  /**
   * Returns the inverse of the current quaternion
   * Example Playground https://playground.babylonjs.com/#L49EJ7#84
   * @returns a new quaternion
   */
  invert() {
    const conjugate = this.conjugate();
    const lengthSquared = this.lengthSquared();
    if (lengthSquared == 0 || lengthSquared == 1) {
      return conjugate;
    }
    conjugate.scaleInPlace(1 / lengthSquared);
    return conjugate;
  }
  /**
   * Invert in place the current quaternion
   * Example Playground https://playground.babylonjs.com/#L49EJ7#85
   * @returns this quaternion
   */
  invertInPlace() {
    this.conjugateInPlace();
    const lengthSquared = this.lengthSquared();
    if (lengthSquared == 0 || lengthSquared == 1) {
      return this;
    }
    this.scaleInPlace(1 / lengthSquared);
    return this;
  }
  /**
   * Gets squared length of current quaternion
   * Example Playground https://playground.babylonjs.com/#L49EJ7#29
   * @returns the quaternion length (float)
   */
  lengthSquared() {
    return this._x * this._x + this._y * this._y + this._z * this._z + this._w * this._w;
  }
  /**
   * Gets length of current quaternion
   * Example Playground https://playground.babylonjs.com/#L49EJ7#28
   * @returns the quaternion length (float)
   */
  length() {
    return Math.sqrt(this.lengthSquared());
  }
  /**
   * Normalize in place the current quaternion
   * Example Playground https://playground.babylonjs.com/#L49EJ7#54
   * @returns the current updated quaternion
   */
  normalize() {
    return this.normalizeFromLength(this.length());
  }
  /**
   * Normalize the current quaternion with the given input length.
   * Please note that this is an in place operation.
   * @param len the length of the quaternion
   * @returns the current updated Quaternion
   */
  normalizeFromLength(len) {
    if (len === 0 || len === 1) {
      return this;
    }
    return this.scaleInPlace(1 / len);
  }
  /**
   * Normalize a copy of the current quaternion
   * Example Playground https://playground.babylonjs.com/#L49EJ7#55
   * @returns the normalized quaternion
   */
  normalizeToNew() {
    const normalized = new Quaternion(0, 0, 0, 1);
    this.normalizeToRef(normalized);
    return normalized;
  }
  /**
   * Normalize the current Quaternion to the reference
   * @param reference define the Quaternion to update
   * @returns the updated Quaternion
   */
  normalizeToRef(reference) {
    const len = this.length();
    if (len === 0 || len === 1) {
      return reference.copyFromFloats(this._x, this._y, this._z, this._w);
    }
    return this.scaleToRef(1 / len, reference);
  }
  /**
   * Returns a new Vector3 set with the Euler angles translated from the current quaternion
   * Example Playground https://playground.babylonjs.com/#L49EJ7#32
   * @returns a new Vector3 containing the Euler angles
   * @see https://doc.babylonjs.com/features/featuresDeepDive/mesh/transforms/center_origin/rotation_conventions
   */
  toEulerAngles() {
    const result = Vector3.Zero();
    this.toEulerAnglesToRef(result);
    return result;
  }
  /**
   * Sets the given vector3 "result" with the Euler angles translated from the current quaternion
   * Example Playground https://playground.babylonjs.com/#L49EJ7#31
   * @param result defines the vector which will be filled with the Euler angles
   * @returns result input
   * @see https://doc.babylonjs.com/features/featuresDeepDive/mesh/transforms/center_origin/rotation_conventions
   */
  toEulerAnglesToRef(result) {
    const qz = this._z;
    const qx = this._x;
    const qy = this._y;
    const qw = this._w;
    const zAxisY = qy * qz - qx * qw;
    const limit = 0.4999999;
    if (zAxisY < -limit) {
      result._y = 2 * Math.atan2(qy, qw);
      result._x = Math.PI / 2;
      result._z = 0;
      result._isDirty = true;
    } else if (zAxisY > limit) {
      result._y = 2 * Math.atan2(qy, qw);
      result._x = -Math.PI / 2;
      result._z = 0;
      result._isDirty = true;
    } else {
      const sqw = qw * qw;
      const sqz = qz * qz;
      const sqx = qx * qx;
      const sqy = qy * qy;
      result._z = Math.atan2(2 * (qx * qy + qz * qw), -sqz - sqx + sqy + sqw);
      result._x = Math.asin(-2 * zAxisY);
      result._y = Math.atan2(2 * (qz * qx + qy * qw), sqz - sqx - sqy + sqw);
      result._isDirty = true;
    }
    return result;
  }
  /**
   * Sets the given vector3 "result" with the Alpha, Beta, Gamma Euler angles translated from the current quaternion
   * @param result defines the vector which will be filled with the Euler angles
   * @returns result input
   * @see https://doc.babylonjs.com/features/featuresDeepDive/mesh/transforms/center_origin/rotation_conventions
   */
  toAlphaBetaGammaToRef(result) {
    const qz = this._z;
    const qx = this._x;
    const qy = this._y;
    const qw = this._w;
    const sinHalfBeta = Math.sqrt(qx * qx + qy * qy);
    const cosHalfBeta = Math.sqrt(qz * qz + qw * qw);
    const beta = 2 * Math.atan2(sinHalfBeta, cosHalfBeta);
    const gammaPlusAlpha = 2 * Math.atan2(qz, qw);
    const gammaMinusAlpha = 2 * Math.atan2(qy, qx);
    const gamma = (gammaPlusAlpha + gammaMinusAlpha) / 2;
    const alpha = (gammaPlusAlpha - gammaMinusAlpha) / 2;
    result.set(alpha, beta, gamma);
    return result;
  }
  /**
   * Updates the given rotation matrix with the current quaternion values
   * Example Playground https://playground.babylonjs.com/#L49EJ7#67
   * @param result defines the target matrix
   * @returns the updated matrix with the rotation
   */
  toRotationMatrix(result) {
    Matrix.FromQuaternionToRef(this, result);
    return result;
  }
  /**
   * Updates the current quaternion from the given rotation matrix values
   * Example Playground https://playground.babylonjs.com/#L49EJ7#41
   * @param matrix defines the source matrix
   * @returns the current updated quaternion
   */
  fromRotationMatrix(matrix) {
    Quaternion.FromRotationMatrixToRef(matrix, this);
    return this;
  }
  /**
   * Returns the dot product (float) between the current quaternions and "other"
   * @param other defines the right operand
   * @returns the dot product
   */
  dot(other) {
    return this._x * other._x + this._y * other._y + this._z * other._z + this._w * other._w;
  }
  // Statics
  /**
   * Creates a new quaternion from a rotation matrix
   * Example Playground https://playground.babylonjs.com/#L49EJ7#101
   * @param matrix defines the source matrix
   * @returns a new quaternion created from the given rotation matrix values
   */
  static FromRotationMatrix(matrix) {
    const result = new Quaternion();
    Quaternion.FromRotationMatrixToRef(matrix, result);
    return result;
  }
  /**
   * Updates the given quaternion with the given rotation matrix values
   * Example Playground https://playground.babylonjs.com/#L49EJ7#102
   * @param matrix defines the source matrix
   * @param result defines the target quaternion
   * @returns result input
   */
  static FromRotationMatrixToRef(matrix, result) {
    const data = matrix.m;
    const m11 = data[0], m12 = data[4], m13 = data[8];
    const m21 = data[1], m22 = data[5], m23 = data[9];
    const m31 = data[2], m32 = data[6], m33 = data[10];
    const trace = m11 + m22 + m33;
    let s2;
    if (trace > 0) {
      s2 = 0.5 / Math.sqrt(trace + 1);
      result._w = 0.25 / s2;
      result._x = (m32 - m23) * s2;
      result._y = (m13 - m31) * s2;
      result._z = (m21 - m12) * s2;
      result._isDirty = true;
    } else if (m11 > m22 && m11 > m33) {
      s2 = 2 * Math.sqrt(1 + m11 - m22 - m33);
      result._w = (m32 - m23) / s2;
      result._x = 0.25 * s2;
      result._y = (m12 + m21) / s2;
      result._z = (m13 + m31) / s2;
      result._isDirty = true;
    } else if (m22 > m33) {
      s2 = 2 * Math.sqrt(1 + m22 - m11 - m33);
      result._w = (m13 - m31) / s2;
      result._x = (m12 + m21) / s2;
      result._y = 0.25 * s2;
      result._z = (m23 + m32) / s2;
      result._isDirty = true;
    } else {
      s2 = 2 * Math.sqrt(1 + m33 - m11 - m22);
      result._w = (m21 - m12) / s2;
      result._x = (m13 + m31) / s2;
      result._y = (m23 + m32) / s2;
      result._z = 0.25 * s2;
      result._isDirty = true;
    }
    return result;
  }
  /**
   * Returns the dot product (float) between the quaternions "left" and "right"
   * Example Playground https://playground.babylonjs.com/#L49EJ7#61
   * @param left defines the left operand
   * @param right defines the right operand
   * @returns the dot product
   */
  static Dot(left, right) {
    return left._x * right._x + left._y * right._y + left._z * right._z + left._w * right._w;
  }
  /**
   * Checks if the orientations of two rotation quaternions are close to each other
   * Example Playground https://playground.babylonjs.com/#L49EJ7#60
   * @param quat0 defines the first quaternion to check
   * @param quat1 defines the second quaternion to check
   * @param epsilon defines closeness, 0 same orientation, 1 PI apart, default 0.1
   * @returns true if the two quaternions are close to each other within epsilon
   */
  static AreClose(quat0, quat1, epsilon = 0.1) {
    const dot = Quaternion.Dot(quat0, quat1);
    return 1 - dot * dot <= epsilon;
  }
  /**
   * Smooth interpolation between two quaternions using Slerp
   * Example Playground https://playground.babylonjs.com/#L49EJ7#93
   * @param source source quaternion
   * @param goal goal quaternion
   * @param deltaTime current interpolation frame
   * @param lerpTime total interpolation time
   * @param result the smoothed quaternion
   * @returns the smoothed quaternion
   */
  static SmoothToRef(source, goal, deltaTime, lerpTime, result) {
    let slerp = lerpTime === 0 ? 1 : deltaTime / lerpTime;
    slerp = Clamp(slerp, 0, 1);
    Quaternion.SlerpToRef(source, goal, slerp, result);
    return result;
  }
  /**
   * Creates an empty quaternion
   * @returns a new quaternion set to (0.0, 0.0, 0.0)
   */
  static Zero() {
    return new Quaternion(0, 0, 0, 0);
  }
  /**
   * Inverse a given quaternion
   * Example Playground https://playground.babylonjs.com/#L49EJ7#103
   * @param q defines the source quaternion
   * @returns a new quaternion as the inverted current quaternion
   */
  static Inverse(q) {
    return new Quaternion(-q._x, -q._y, -q._z, q._w);
  }
  /**
   * Inverse a given quaternion
   * Example Playground https://playground.babylonjs.com/#L49EJ7#104
   * @param q defines the source quaternion
   * @param result the quaternion the result will be stored in
   * @returns the result quaternion
   */
  static InverseToRef(q, result) {
    result.set(-q._x, -q._y, -q._z, q._w);
    return result;
  }
  /**
   * Creates an identity quaternion
   * @returns the identity quaternion
   */
  static Identity() {
    return new Quaternion(0, 0, 0, 1);
  }
  /**
   * Gets a boolean indicating if the given quaternion is identity
   * @param quaternion defines the quaternion to check
   * @returns true if the quaternion is identity
   */
  static IsIdentity(quaternion) {
    return quaternion && quaternion._x === 0 && quaternion._y === 0 && quaternion._z === 0 && quaternion._w === 1;
  }
  /**
   * Creates a quaternion from a rotation around an axis
   * Example Playground https://playground.babylonjs.com/#L49EJ7#72
   * @param axis defines the axis to use
   * @param angle defines the angle to use
   * @returns a new quaternion created from the given axis (Vector3) and angle in radians (float)
   */
  static RotationAxis(axis, angle) {
    return Quaternion.RotationAxisToRef(axis, angle, new Quaternion());
  }
  /**
   * Creates a rotation around an axis and stores it into the given quaternion
   * Example Playground https://playground.babylonjs.com/#L49EJ7#73
   * @param axis defines the axis to use
   * @param angle defines the angle to use
   * @param result defines the target quaternion
   * @returns the target quaternion
   */
  static RotationAxisToRef(axis, angle, result) {
    result._w = Math.cos(angle / 2);
    const sinByLength = Math.sin(angle / 2) / axis.length();
    result._x = axis._x * sinByLength;
    result._y = axis._y * sinByLength;
    result._z = axis._z * sinByLength;
    result._isDirty = true;
    return result;
  }
  /**
   * Creates a new quaternion from data stored into an array
   * Example Playground https://playground.babylonjs.com/#L49EJ7#63
   * @param array defines the data source
   * @param offset defines the offset in the source array where the data starts
   * @returns a new quaternion
   */
  static FromArray(array, offset) {
    if (!offset) {
      offset = 0;
    }
    return new Quaternion(array[offset], array[offset + 1], array[offset + 2], array[offset + 3]);
  }
  /**
   * Updates the given quaternion "result" from the starting index of the given array.
   * Example Playground https://playground.babylonjs.com/#L49EJ7#64
   * @param array the array to pull values from
   * @param offset the offset into the array to start at
   * @param result the quaternion to store the result in
   * @returns result input
   */
  static FromArrayToRef(array, offset, result) {
    result._x = array[offset];
    result._y = array[offset + 1];
    result._z = array[offset + 2];
    result._w = array[offset + 3];
    result._isDirty = true;
    return result;
  }
  /**
   * Sets the given quaternion "result" with the given floats.
   * @param x defines the x coordinate of the source
   * @param y defines the y coordinate of the source
   * @param z defines the z coordinate of the source
   * @param w defines the w coordinate of the source
   * @param result defines the quaternion where to store the result
   * @returns the result quaternion
   */
  static FromFloatsToRef(x2, y2, z2, w, result) {
    result.copyFromFloats(x2, y2, z2, w);
    return result;
  }
  /**
   * Create a quaternion from Euler rotation angles
   * Example Playground https://playground.babylonjs.com/#L49EJ7#33
   * @param x Pitch
   * @param y Yaw
   * @param z Roll
   * @returns the new Quaternion
   */
  static FromEulerAngles(x2, y2, z2) {
    const q = new Quaternion();
    Quaternion.RotationYawPitchRollToRef(y2, x2, z2, q);
    return q;
  }
  /**
   * Updates a quaternion from Euler rotation angles
   * Example Playground https://playground.babylonjs.com/#L49EJ7#34
   * @param x Pitch
   * @param y Yaw
   * @param z Roll
   * @param result the quaternion to store the result
   * @returns the updated quaternion
   */
  static FromEulerAnglesToRef(x2, y2, z2, result) {
    Quaternion.RotationYawPitchRollToRef(y2, x2, z2, result);
    return result;
  }
  /**
   * Create a quaternion from Euler rotation vector
   * Example Playground https://playground.babylonjs.com/#L49EJ7#35
   * @param vec the Euler vector (x Pitch, y Yaw, z Roll)
   * @returns the new Quaternion
   */
  static FromEulerVector(vec) {
    const q = new Quaternion();
    Quaternion.RotationYawPitchRollToRef(vec._y, vec._x, vec._z, q);
    return q;
  }
  /**
   * Updates a quaternion from Euler rotation vector
   * Example Playground https://playground.babylonjs.com/#L49EJ7#36
   * @param vec the Euler vector (x Pitch, y Yaw, z Roll)
   * @param result the quaternion to store the result
   * @returns the updated quaternion
   */
  static FromEulerVectorToRef(vec, result) {
    Quaternion.RotationYawPitchRollToRef(vec._y, vec._x, vec._z, result);
    return result;
  }
  /**
   * Updates a quaternion so that it rotates vector vecFrom to vector vecTo
   * Example Playground - https://playground.babylonjs.com/#L49EJ7#70
   * @param vecFrom defines the direction vector from which to rotate
   * @param vecTo defines the direction vector to which to rotate
   * @param result the quaternion to store the result
   * @param epsilon defines the minimal dot value to define vecs as opposite. Default: `BABYLON.Epsilon`
   * @returns the updated quaternion
   */
  static FromUnitVectorsToRef(vecFrom, vecTo, result, epsilon = Epsilon) {
    const r3 = Vector3.Dot(vecFrom, vecTo) + 1;
    if (r3 < epsilon) {
      if (Math.abs(vecFrom.x) > Math.abs(vecFrom.z)) {
        result.set(-vecFrom.y, vecFrom.x, 0, 0);
      } else {
        result.set(0, -vecFrom.z, vecFrom.y, 0);
      }
    } else {
      Vector3.CrossToRef(vecFrom, vecTo, TmpVectors.Vector3[0]);
      result.set(TmpVectors.Vector3[0].x, TmpVectors.Vector3[0].y, TmpVectors.Vector3[0].z, r3);
    }
    return result.normalize();
  }
  /**
   * Creates a new quaternion from the given Euler float angles (y, x, z)
   * Example Playground https://playground.babylonjs.com/#L49EJ7#77
   * @param yaw defines the rotation around Y axis
   * @param pitch defines the rotation around X axis
   * @param roll defines the rotation around Z axis
   * @returns the new quaternion
   */
  static RotationYawPitchRoll(yaw, pitch, roll) {
    const q = new Quaternion();
    Quaternion.RotationYawPitchRollToRef(yaw, pitch, roll, q);
    return q;
  }
  /**
   * Creates a new rotation from the given Euler float angles (y, x, z) and stores it in the target quaternion
   * Example Playground https://playground.babylonjs.com/#L49EJ7#78
   * @param yaw defines the rotation around Y axis
   * @param pitch defines the rotation around X axis
   * @param roll defines the rotation around Z axis
   * @param result defines the target quaternion
   * @returns result input
   */
  static RotationYawPitchRollToRef(yaw, pitch, roll, result) {
    const halfRoll = roll * 0.5;
    const halfPitch = pitch * 0.5;
    const halfYaw = yaw * 0.5;
    const sinRoll = Math.sin(halfRoll);
    const cosRoll = Math.cos(halfRoll);
    const sinPitch = Math.sin(halfPitch);
    const cosPitch = Math.cos(halfPitch);
    const sinYaw = Math.sin(halfYaw);
    const cosYaw = Math.cos(halfYaw);
    result._x = cosYaw * sinPitch * cosRoll + sinYaw * cosPitch * sinRoll;
    result._y = sinYaw * cosPitch * cosRoll - cosYaw * sinPitch * sinRoll;
    result._z = cosYaw * cosPitch * sinRoll - sinYaw * sinPitch * cosRoll;
    result._w = cosYaw * cosPitch * cosRoll + sinYaw * sinPitch * sinRoll;
    result._isDirty = true;
    return result;
  }
  /**
   * Creates a new quaternion from the given Euler float angles expressed in z-x-z orientation
   * Example Playground https://playground.babylonjs.com/#L49EJ7#68
   * @param alpha defines the rotation around first axis
   * @param beta defines the rotation around second axis
   * @param gamma defines the rotation around third axis
   * @returns the new quaternion
   */
  static RotationAlphaBetaGamma(alpha, beta, gamma) {
    const result = new Quaternion();
    Quaternion.RotationAlphaBetaGammaToRef(alpha, beta, gamma, result);
    return result;
  }
  /**
   * Creates a new quaternion from the given Euler float angles expressed in z-x-z orientation and stores it in the target quaternion
   * Example Playground https://playground.babylonjs.com/#L49EJ7#69
   * @param alpha defines the rotation around first axis
   * @param beta defines the rotation around second axis
   * @param gamma defines the rotation around third axis
   * @param result defines the target quaternion
   * @returns result input
   */
  static RotationAlphaBetaGammaToRef(alpha, beta, gamma, result) {
    const halfGammaPlusAlpha = (gamma + alpha) * 0.5;
    const halfGammaMinusAlpha = (gamma - alpha) * 0.5;
    const halfBeta = beta * 0.5;
    result._x = Math.cos(halfGammaMinusAlpha) * Math.sin(halfBeta);
    result._y = Math.sin(halfGammaMinusAlpha) * Math.sin(halfBeta);
    result._z = Math.sin(halfGammaPlusAlpha) * Math.cos(halfBeta);
    result._w = Math.cos(halfGammaPlusAlpha) * Math.cos(halfBeta);
    result._isDirty = true;
    return result;
  }
  /**
   * Creates a new quaternion containing the rotation value to reach the target (axis1, axis2, axis3) orientation as a rotated XYZ system (axis1, axis2 and axis3 are normalized during this operation)
   * Example Playground https://playground.babylonjs.com/#L49EJ7#75
   * @param axis1 defines the first axis
   * @param axis2 defines the second axis
   * @param axis3 defines the third axis
   * @returns the new quaternion
   */
  static RotationQuaternionFromAxis(axis1, axis2, axis3) {
    const quat = new Quaternion(0, 0, 0, 0);
    Quaternion.RotationQuaternionFromAxisToRef(axis1, axis2, axis3, quat);
    return quat;
  }
  /**
   * Creates a rotation value to reach the target (axis1, axis2, axis3) orientation as a rotated XYZ system (axis1, axis2 and axis3 are normalized during this operation) and stores it in the target quaternion
   * Example Playground https://playground.babylonjs.com/#L49EJ7#76
   * @param axis1 defines the first axis
   * @param axis2 defines the second axis
   * @param axis3 defines the third axis
   * @param ref defines the target quaternion
   * @returns result input
   */
  static RotationQuaternionFromAxisToRef(axis1, axis2, axis3, ref) {
    const rotMat = MathTmp.Matrix[0];
    axis1 = axis1.normalizeToRef(MathTmp.Vector3[0]);
    axis2 = axis2.normalizeToRef(MathTmp.Vector3[1]);
    axis3 = axis3.normalizeToRef(MathTmp.Vector3[2]);
    Matrix.FromXYZAxesToRef(axis1, axis2, axis3, rotMat);
    Quaternion.FromRotationMatrixToRef(rotMat, ref);
    return ref;
  }
  /**
   * Creates a new rotation value to orient an object to look towards the given forward direction, the up direction being oriented like "up".
   * This function works in left handed mode
   * Example Playground https://playground.babylonjs.com/#L49EJ7#96
   * @param forward defines the forward direction - Must be normalized and orthogonal to up.
   * @param up defines the up vector for the entity - Must be normalized and orthogonal to forward.
   * @returns A new quaternion oriented toward the specified forward and up.
   */
  static FromLookDirectionLH(forward, up) {
    const quat = new Quaternion();
    Quaternion.FromLookDirectionLHToRef(forward, up, quat);
    return quat;
  }
  /**
   * Creates a new rotation value to orient an object to look towards the given forward direction with the up direction being oriented like "up", and stores it in the target quaternion.
   * This function works in left handed mode
   * Example Playground https://playground.babylonjs.com/#L49EJ7#97
   * @param forward defines the forward direction - Must be normalized and orthogonal to up.
   * @param up defines the up vector for the entity - Must be normalized and orthogonal to forward.
   * @param ref defines the target quaternion.
   * @returns result input
   */
  static FromLookDirectionLHToRef(forward, up, ref) {
    const rotMat = MathTmp.Matrix[0];
    Matrix.LookDirectionLHToRef(forward, up, rotMat);
    Quaternion.FromRotationMatrixToRef(rotMat, ref);
    return ref;
  }
  /**
   * Creates a new rotation value to orient an object to look towards the given forward direction, the up direction being oriented like "up".
   * This function works in right handed mode
   * Example Playground https://playground.babylonjs.com/#L49EJ7#98
   * @param forward defines the forward direction - Must be normalized and orthogonal to up.
   * @param up defines the up vector for the entity - Must be normalized and orthogonal to forward.
   * @returns A new quaternion oriented toward the specified forward and up.
   */
  static FromLookDirectionRH(forward, up) {
    const quat = new Quaternion();
    Quaternion.FromLookDirectionRHToRef(forward, up, quat);
    return quat;
  }
  /**
   * Creates a new rotation value to orient an object to look towards the given forward direction with the up direction being oriented like "up", and stores it in the target quaternion.
   * This function works in right handed mode
   * Example Playground https://playground.babylonjs.com/#L49EJ7#105
   * @param forward defines the forward direction - Must be normalized and orthogonal to up.
   * @param up defines the up vector for the entity - Must be normalized and orthogonal to forward.
   * @param ref defines the target quaternion.
   * @returns result input
   */
  static FromLookDirectionRHToRef(forward, up, ref) {
    const rotMat = MathTmp.Matrix[0];
    Matrix.LookDirectionRHToRef(forward, up, rotMat);
    return Quaternion.FromRotationMatrixToRef(rotMat, ref);
  }
  /**
   * Interpolates between two quaternions
   * Example Playground https://playground.babylonjs.com/#L49EJ7#79
   * @param left defines first quaternion
   * @param right defines second quaternion
   * @param amount defines the gradient to use
   * @returns the new interpolated quaternion
   */
  static Slerp(left, right, amount) {
    const result = Quaternion.Identity();
    Quaternion.SlerpToRef(left, right, amount, result);
    return result;
  }
  /**
   * Interpolates between two quaternions and stores it into a target quaternion
   * Example Playground https://playground.babylonjs.com/#L49EJ7#92
   * @param left defines first quaternion
   * @param right defines second quaternion
   * @param amount defines the gradient to use
   * @param result defines the target quaternion
   * @returns result input
   */
  static SlerpToRef(left, right, amount, result) {
    let num2;
    let num3;
    let num4 = left._x * right._x + left._y * right._y + left._z * right._z + left._w * right._w;
    let flag = false;
    if (num4 < 0) {
      flag = true;
      num4 = -num4;
    }
    if (num4 > 0.999999) {
      num3 = 1 - amount;
      num2 = flag ? -amount : amount;
    } else {
      const num5 = Math.acos(num4);
      const num6 = 1 / Math.sin(num5);
      num3 = Math.sin((1 - amount) * num5) * num6;
      num2 = flag ? -Math.sin(amount * num5) * num6 : Math.sin(amount * num5) * num6;
    }
    result._x = num3 * left._x + num2 * right._x;
    result._y = num3 * left._y + num2 * right._y;
    result._z = num3 * left._z + num2 * right._z;
    result._w = num3 * left._w + num2 * right._w;
    result._isDirty = true;
    return result;
  }
  /**
   * Interpolate between two quaternions using Hermite interpolation
   * Example Playground https://playground.babylonjs.com/#L49EJ7#47
   * @see https://doc.babylonjs.com/features/featuresDeepDive/mesh/drawCurves#hermite-quaternion-spline
   * @param value1 defines first quaternion
   * @param tangent1 defines the incoming tangent
   * @param value2 defines second quaternion
   * @param tangent2 defines the outgoing tangent
   * @param amount defines the target quaternion
   * @returns the new interpolated quaternion
   */
  static Hermite(value1, tangent1, value2, tangent2, amount) {
    const squared = amount * amount;
    const cubed = amount * squared;
    const part1 = 2 * cubed - 3 * squared + 1;
    const part2 = -2 * cubed + 3 * squared;
    const part3 = cubed - 2 * squared + amount;
    const part4 = cubed - squared;
    const x2 = value1._x * part1 + value2._x * part2 + tangent1._x * part3 + tangent2._x * part4;
    const y2 = value1._y * part1 + value2._y * part2 + tangent1._y * part3 + tangent2._y * part4;
    const z2 = value1._z * part1 + value2._z * part2 + tangent1._z * part3 + tangent2._z * part4;
    const w = value1._w * part1 + value2._w * part2 + tangent1._w * part3 + tangent2._w * part4;
    return new Quaternion(x2, y2, z2, w);
  }
  /**
   * Returns a new Quaternion which is the 1st derivative of the Hermite spline defined by the quaternions "value1", "value2", "tangent1", "tangent2".
   * Example Playground https://playground.babylonjs.com/#L49EJ7#48
   * @param value1 defines the first control point
   * @param tangent1 defines the first tangent
   * @param value2 defines the second control point
   * @param tangent2 defines the second tangent
   * @param time define where the derivative must be done
   * @returns 1st derivative
   */
  static Hermite1stDerivative(value1, tangent1, value2, tangent2, time) {
    const result = new Quaternion();
    this.Hermite1stDerivativeToRef(value1, tangent1, value2, tangent2, time, result);
    return result;
  }
  /**
   * Update a Quaternion with the 1st derivative of the Hermite spline defined by the quaternions "value1", "value2", "tangent1", "tangent2".
   * Example Playground https://playground.babylonjs.com/#L49EJ7#49
   * @param value1 defines the first control point
   * @param tangent1 defines the first tangent
   * @param value2 defines the second control point
   * @param tangent2 defines the second tangent
   * @param time define where the derivative must be done
   * @param result define where to store the derivative
   * @returns result input
   */
  static Hermite1stDerivativeToRef(value1, tangent1, value2, tangent2, time, result) {
    const t2 = time * time;
    result._x = (t2 - time) * 6 * value1._x + (3 * t2 - 4 * time + 1) * tangent1._x + (-t2 + time) * 6 * value2._x + (3 * t2 - 2 * time) * tangent2._x;
    result._y = (t2 - time) * 6 * value1._y + (3 * t2 - 4 * time + 1) * tangent1._y + (-t2 + time) * 6 * value2._y + (3 * t2 - 2 * time) * tangent2._y;
    result._z = (t2 - time) * 6 * value1._z + (3 * t2 - 4 * time + 1) * tangent1._z + (-t2 + time) * 6 * value2._z + (3 * t2 - 2 * time) * tangent2._z;
    result._w = (t2 - time) * 6 * value1._w + (3 * t2 - 4 * time + 1) * tangent1._w + (-t2 + time) * 6 * value2._w + (3 * t2 - 2 * time) * tangent2._w;
    result._isDirty = true;
    return result;
  }
  /**
   * Returns a new Quaternion as the normalization of the given Quaternion
   * @param quat defines the Quaternion to normalize
   * @returns the new Quaternion
   */
  static Normalize(quat) {
    const result = Quaternion.Zero();
    Quaternion.NormalizeToRef(quat, result);
    return result;
  }
  /**
   * Sets the given Quaternion "result" with the normalization of the given first Quaternion
   * @param quat defines the Quaternion to normalize
   * @param result defines the Quaternion where to store the result
   * @returns result input
   */
  static NormalizeToRef(quat, result) {
    quat.normalizeToRef(result);
    return result;
  }
  /**
   * Returns a new Quaternion set with the coordinates of "value", if the quaternion "value" is in the cube defined by the quaternions "min" and "max"
   * If a coordinate value of "value" is lower than one of the "min" coordinate, then this "value" coordinate is set with the "min" one
   * If a coordinate value of "value" is greater than one of the "max" coordinate, then this "value" coordinate is set with the "max" one
   * @param value defines the current value
   * @param min defines the lower range value
   * @param max defines the upper range value
   * @returns the new Quaternion
   */
  static Clamp(value, min, max) {
    const result = new Quaternion();
    Quaternion.ClampToRef(value, min, max, result);
    return result;
  }
  /**
   * Sets the given quaternion "result" with the coordinates of "value", if the quaternion "value" is in the cube defined by the quaternions "min" and "max"
   * If a coordinate value of "value" is lower than one of the "min" coordinate, then this "value" coordinate is set with the "min" one
   * If a coordinate value of "value" is greater than one of the "max" coordinate, then this "value" coordinate is set with the "max" one
   * @param value defines the current value
   * @param min defines the lower range value
   * @param max defines the upper range value
   * @param result defines the Quaternion where to store the result
   * @returns result input
   */
  static ClampToRef(value, min, max, result) {
    return result.copyFromFloats(Clamp(value.x, min.x, max.x), Clamp(value.y, min.y, max.y), Clamp(value.z, min.z, max.z), Clamp(value.w, min.w, max.w));
  }
  /**
   * Returns a new Quaternion with random values between min and max
   * @param min the minimum random value
   * @param max the maximum random value
   * @returns a Quaternion with random values between min and max
   */
  static Random(min = 0, max = 1) {
    return new Quaternion(RandomRange(min, max), RandomRange(min, max), RandomRange(min, max), RandomRange(min, max));
  }
  /**
   * Sets a Quaternion with random values between min and max
   * @param min the minimum random value
   * @param max the maximum random value
   * @param ref the ref to store the values in
   * @returns the ref with random values between min and max
   */
  static RandomToRef(min = 0, max = 1, ref) {
    return ref.copyFromFloats(RandomRange(min, max), RandomRange(min, max), RandomRange(min, max), RandomRange(min, max));
  }
  /**
   * Do not use
   * @internal
   */
  static Minimize() {
    throw new ReferenceError("Quaternion.Minimize does not make sense");
  }
  /**
   * Do not use
   * @internal
   */
  static Maximize() {
    throw new ReferenceError("Quaternion.Maximize does not make sense");
  }
  /**
   * Returns the distance (float) between the quaternions "value1" and "value2".
   * @param value1 value to calulate the distance between
   * @param value2 value to calulate the distance between
   * @returns the distance between the two quaternions
   */
  static Distance(value1, value2) {
    return Math.sqrt(Quaternion.DistanceSquared(value1, value2));
  }
  /**
   * Returns the squared distance (float) between the quaternions "value1" and "value2".
   * @param value1 value to calulate the distance between
   * @param value2 value to calulate the distance between
   * @returns the distance between the two quaternions squared
   */
  static DistanceSquared(value1, value2) {
    const x2 = value1.x - value2.x;
    const y2 = value1.y - value2.y;
    const z2 = value1.z - value2.z;
    const w = value1.w - value2.w;
    return x2 * x2 + y2 * y2 + z2 * z2 + w * w;
  }
  /**
   * Returns a new Quaternion located at the center between the quaternions "value1" and "value2".
   * @param value1 value to calulate the center between
   * @param value2 value to calulate the center between
   * @returns the center between the two quaternions
   */
  static Center(value1, value2) {
    return Quaternion.CenterToRef(value1, value2, Quaternion.Zero());
  }
  /**
   * Gets the center of the quaternions "value1" and "value2" and stores the result in the quaternion "ref"
   * @param value1 defines first quaternion
   * @param value2 defines second quaternion
   * @param ref defines third quaternion
   * @returns ref
   */
  static CenterToRef(value1, value2, ref) {
    return ref.copyFromFloats((value1.x + value2.x) / 2, (value1.y + value2.y) / 2, (value1.z + value2.z) / 2, (value1.w + value2.w) / 2);
  }
}
Quaternion._V8PerformanceHack = new Quaternion(0.5, 0.5, 0.5, 0.5);
Object.defineProperties(Quaternion.prototype, {
  dimension: { value: [4] },
  rank: { value: 1 }
});
class Matrix {
  /**
   * Gets the precision of matrix computations
   */
  static get Use64Bits() {
    return PerformanceConfigurator.MatrixUse64Bits;
  }
  /**
   * Gets the internal data of the matrix
   */
  get m() {
    return this._m;
  }
  /**
   * Update the updateFlag to indicate that the matrix has been updated
   */
  markAsUpdated() {
    this.updateFlag = Matrix._UpdateFlagSeed++;
    this._isIdentity = false;
    this._isIdentity3x2 = false;
    this._isIdentityDirty = true;
    this._isIdentity3x2Dirty = true;
  }
  _updateIdentityStatus(isIdentity, isIdentityDirty = false, isIdentity3x2 = false, isIdentity3x2Dirty = true) {
    this._isIdentity = isIdentity;
    this._isIdentity3x2 = isIdentity || isIdentity3x2;
    this._isIdentityDirty = this._isIdentity ? false : isIdentityDirty;
    this._isIdentity3x2Dirty = this._isIdentity3x2 ? false : isIdentity3x2Dirty;
  }
  /**
   * Creates an empty matrix (filled with zeros)
   */
  constructor() {
    this._isIdentity = false;
    this._isIdentityDirty = true;
    this._isIdentity3x2 = true;
    this._isIdentity3x2Dirty = true;
    this.updateFlag = -1;
    if (PerformanceConfigurator.MatrixTrackPrecisionChange) {
      PerformanceConfigurator.MatrixTrackedMatrices.push(this);
    }
    this._m = new PerformanceConfigurator.MatrixCurrentType(16);
    this.markAsUpdated();
  }
  // Properties
  /**
   * Check if the current matrix is identity
   * @returns true is the matrix is the identity matrix
   */
  isIdentity() {
    if (this._isIdentityDirty) {
      this._isIdentityDirty = false;
      const m2 = this._m;
      this._isIdentity = m2[0] === 1 && m2[1] === 0 && m2[2] === 0 && m2[3] === 0 && m2[4] === 0 && m2[5] === 1 && m2[6] === 0 && m2[7] === 0 && m2[8] === 0 && m2[9] === 0 && m2[10] === 1 && m2[11] === 0 && m2[12] === 0 && m2[13] === 0 && m2[14] === 0 && m2[15] === 1;
    }
    return this._isIdentity;
  }
  /**
   * Check if the current matrix is identity as a texture matrix (3x2 store in 4x4)
   * @returns true is the matrix is the identity matrix
   */
  isIdentityAs3x2() {
    if (this._isIdentity3x2Dirty) {
      this._isIdentity3x2Dirty = false;
      if (this._m[0] !== 1 || this._m[5] !== 1 || this._m[15] !== 1) {
        this._isIdentity3x2 = false;
      } else if (this._m[1] !== 0 || this._m[2] !== 0 || this._m[3] !== 0 || this._m[4] !== 0 || this._m[6] !== 0 || this._m[7] !== 0 || this._m[8] !== 0 || this._m[9] !== 0 || this._m[10] !== 0 || this._m[11] !== 0 || this._m[12] !== 0 || this._m[13] !== 0 || this._m[14] !== 0) {
        this._isIdentity3x2 = false;
      } else {
        this._isIdentity3x2 = true;
      }
    }
    return this._isIdentity3x2;
  }
  /**
   * Gets the determinant of the matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#34
   * @returns the matrix determinant
   */
  determinant() {
    if (this._isIdentity === true) {
      return 1;
    }
    const m2 = this._m;
    const m00 = m2[0], m01 = m2[1], m02 = m2[2], m03 = m2[3];
    const m10 = m2[4], m11 = m2[5], m12 = m2[6], m13 = m2[7];
    const m20 = m2[8], m21 = m2[9], m22 = m2[10], m23 = m2[11];
    const m30 = m2[12], m31 = m2[13], m32 = m2[14], m33 = m2[15];
    const det_22_33 = m22 * m33 - m32 * m23;
    const det_21_33 = m21 * m33 - m31 * m23;
    const det_21_32 = m21 * m32 - m31 * m22;
    const det_20_33 = m20 * m33 - m30 * m23;
    const det_20_32 = m20 * m32 - m22 * m30;
    const det_20_31 = m20 * m31 - m30 * m21;
    const cofact_00 = +(m11 * det_22_33 - m12 * det_21_33 + m13 * det_21_32);
    const cofact_01 = -(m10 * det_22_33 - m12 * det_20_33 + m13 * det_20_32);
    const cofact_02 = +(m10 * det_21_33 - m11 * det_20_33 + m13 * det_20_31);
    const cofact_03 = -(m10 * det_21_32 - m11 * det_20_32 + m12 * det_20_31);
    return m00 * cofact_00 + m01 * cofact_01 + m02 * cofact_02 + m03 * cofact_03;
  }
  // Methods
  /**
   * Gets a string with the Matrix values
   * @returns a string with the Matrix values
   */
  toString() {
    return `{${this.m[0]}, ${this.m[1]}, ${this.m[2]}, ${this.m[3]}
${this.m[4]}, ${this.m[5]}, ${this.m[6]}, ${this.m[7]}
${this.m[8]}, ${this.m[9]}, ${this.m[10]}, ${this.m[11]}
${this.m[12]}, ${this.m[13]}, ${this.m[14]}, ${this.m[15]}}`;
  }
  toArray(array = null, index2 = 0) {
    if (!array) {
      return this._m;
    }
    const m2 = this._m;
    for (let i2 = 0; i2 < 16; i2++) {
      array[index2 + i2] = m2[i2];
    }
    return this;
  }
  /**
   * Returns the matrix as a Float32Array or Array<number>
   * Example Playground - https://playground.babylonjs.com/#AV9X17#114
   * @returns the matrix underlying array.
   */
  asArray() {
    return this._m;
  }
  fromArray(array, index2 = 0) {
    return Matrix.FromArrayToRef(array, index2, this);
  }
  copyFromFloats(...floats) {
    return Matrix.FromArrayToRef(floats, 0, this);
  }
  set(...values) {
    const m2 = this._m;
    for (let i2 = 0; i2 < 16; i2++) {
      m2[i2] = values[i2];
    }
    this.markAsUpdated();
    return this;
  }
  setAll(value) {
    const m2 = this._m;
    for (let i2 = 0; i2 < 16; i2++) {
      m2[i2] = value;
    }
    this.markAsUpdated();
    return this;
  }
  /**
   * Inverts the current matrix in place
   * Example Playground - https://playground.babylonjs.com/#AV9X17#118
   * @returns the current inverted matrix
   */
  invert() {
    this.invertToRef(this);
    return this;
  }
  /**
   * Sets all the matrix elements to zero
   * @returns the current matrix
   */
  reset() {
    Matrix.FromValuesToRef(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, this);
    this._updateIdentityStatus(false);
    return this;
  }
  /**
   * Adds the current matrix with a second one
   * Example Playground - https://playground.babylonjs.com/#AV9X17#44
   * @param other defines the matrix to add
   * @returns a new matrix as the addition of the current matrix and the given one
   */
  add(other) {
    const result = new Matrix();
    this.addToRef(other, result);
    return result;
  }
  /**
   * Sets the given matrix "result" to the addition of the current matrix and the given one
   * Example Playground - https://playground.babylonjs.com/#AV9X17#45
   * @param other defines the matrix to add
   * @param result defines the target matrix
   * @returns result input
   */
  addToRef(other, result) {
    const m2 = this._m;
    const resultM = result._m;
    const otherM = other.m;
    for (let index2 = 0; index2 < 16; index2++) {
      resultM[index2] = m2[index2] + otherM[index2];
    }
    result.markAsUpdated();
    return result;
  }
  /**
   * Adds in place the given matrix to the current matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#46
   * @param other defines the second operand
   * @returns the current updated matrix
   */
  addToSelf(other) {
    const m2 = this._m;
    const otherM = other.m;
    m2[0] += otherM[0];
    m2[1] += otherM[1];
    m2[2] += otherM[2];
    m2[3] += otherM[3];
    m2[4] += otherM[4];
    m2[5] += otherM[5];
    m2[6] += otherM[6];
    m2[7] += otherM[7];
    m2[8] += otherM[8];
    m2[9] += otherM[9];
    m2[10] += otherM[10];
    m2[11] += otherM[11];
    m2[12] += otherM[12];
    m2[13] += otherM[13];
    m2[14] += otherM[14];
    m2[15] += otherM[15];
    this.markAsUpdated();
    return this;
  }
  addInPlace(other) {
    const m2 = this._m, otherM = other.m;
    for (let i2 = 0; i2 < 16; i2++) {
      m2[i2] += otherM[i2];
    }
    this.markAsUpdated();
    return this;
  }
  addInPlaceFromFloats(...floats) {
    const m2 = this._m;
    for (let i2 = 0; i2 < 16; i2++) {
      m2[i2] += floats[i2];
    }
    this.markAsUpdated();
    return this;
  }
  subtract(other) {
    const m2 = this._m, otherM = other.m;
    for (let i2 = 0; i2 < 16; i2++) {
      m2[i2] -= otherM[i2];
    }
    this.markAsUpdated();
    return this;
  }
  subtractToRef(other, result) {
    const m2 = this._m, otherM = other.m, resultM = result._m;
    for (let i2 = 0; i2 < 16; i2++) {
      resultM[i2] = m2[i2] - otherM[i2];
    }
    result.markAsUpdated();
    return result;
  }
  subtractInPlace(other) {
    const m2 = this._m, otherM = other.m;
    for (let i2 = 0; i2 < 16; i2++) {
      m2[i2] -= otherM[i2];
    }
    this.markAsUpdated();
    return this;
  }
  subtractFromFloats(...floats) {
    return this.subtractFromFloatsToRef(...floats, new Matrix());
  }
  subtractFromFloatsToRef(...args) {
    const result = args.pop(), m2 = this._m, resultM = result._m, values = args;
    for (let i2 = 0; i2 < 16; i2++) {
      resultM[i2] = m2[i2] - values[i2];
    }
    result.markAsUpdated();
    return result;
  }
  /**
   * Sets the given matrix to the current inverted Matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#119
   * @param other defines the target matrix
   * @returns result input
   */
  invertToRef(other) {
    if (this._isIdentity === true) {
      Matrix.IdentityToRef(other);
      return other;
    }
    const m2 = this._m;
    const m00 = m2[0], m01 = m2[1], m02 = m2[2], m03 = m2[3];
    const m10 = m2[4], m11 = m2[5], m12 = m2[6], m13 = m2[7];
    const m20 = m2[8], m21 = m2[9], m22 = m2[10], m23 = m2[11];
    const m30 = m2[12], m31 = m2[13], m32 = m2[14], m33 = m2[15];
    const det_22_33 = m22 * m33 - m32 * m23;
    const det_21_33 = m21 * m33 - m31 * m23;
    const det_21_32 = m21 * m32 - m31 * m22;
    const det_20_33 = m20 * m33 - m30 * m23;
    const det_20_32 = m20 * m32 - m22 * m30;
    const det_20_31 = m20 * m31 - m30 * m21;
    const cofact_00 = +(m11 * det_22_33 - m12 * det_21_33 + m13 * det_21_32);
    const cofact_01 = -(m10 * det_22_33 - m12 * det_20_33 + m13 * det_20_32);
    const cofact_02 = +(m10 * det_21_33 - m11 * det_20_33 + m13 * det_20_31);
    const cofact_03 = -(m10 * det_21_32 - m11 * det_20_32 + m12 * det_20_31);
    const det = m00 * cofact_00 + m01 * cofact_01 + m02 * cofact_02 + m03 * cofact_03;
    if (det === 0) {
      other.copyFrom(this);
      return other;
    }
    const detInv = 1 / det;
    const det_12_33 = m12 * m33 - m32 * m13;
    const det_11_33 = m11 * m33 - m31 * m13;
    const det_11_32 = m11 * m32 - m31 * m12;
    const det_10_33 = m10 * m33 - m30 * m13;
    const det_10_32 = m10 * m32 - m30 * m12;
    const det_10_31 = m10 * m31 - m30 * m11;
    const det_12_23 = m12 * m23 - m22 * m13;
    const det_11_23 = m11 * m23 - m21 * m13;
    const det_11_22 = m11 * m22 - m21 * m12;
    const det_10_23 = m10 * m23 - m20 * m13;
    const det_10_22 = m10 * m22 - m20 * m12;
    const det_10_21 = m10 * m21 - m20 * m11;
    const cofact_10 = -(m01 * det_22_33 - m02 * det_21_33 + m03 * det_21_32);
    const cofact_11 = +(m00 * det_22_33 - m02 * det_20_33 + m03 * det_20_32);
    const cofact_12 = -(m00 * det_21_33 - m01 * det_20_33 + m03 * det_20_31);
    const cofact_13 = +(m00 * det_21_32 - m01 * det_20_32 + m02 * det_20_31);
    const cofact_20 = +(m01 * det_12_33 - m02 * det_11_33 + m03 * det_11_32);
    const cofact_21 = -(m00 * det_12_33 - m02 * det_10_33 + m03 * det_10_32);
    const cofact_22 = +(m00 * det_11_33 - m01 * det_10_33 + m03 * det_10_31);
    const cofact_23 = -(m00 * det_11_32 - m01 * det_10_32 + m02 * det_10_31);
    const cofact_30 = -(m01 * det_12_23 - m02 * det_11_23 + m03 * det_11_22);
    const cofact_31 = +(m00 * det_12_23 - m02 * det_10_23 + m03 * det_10_22);
    const cofact_32 = -(m00 * det_11_23 - m01 * det_10_23 + m03 * det_10_21);
    const cofact_33 = +(m00 * det_11_22 - m01 * det_10_22 + m02 * det_10_21);
    Matrix.FromValuesToRef(cofact_00 * detInv, cofact_10 * detInv, cofact_20 * detInv, cofact_30 * detInv, cofact_01 * detInv, cofact_11 * detInv, cofact_21 * detInv, cofact_31 * detInv, cofact_02 * detInv, cofact_12 * detInv, cofact_22 * detInv, cofact_32 * detInv, cofact_03 * detInv, cofact_13 * detInv, cofact_23 * detInv, cofact_33 * detInv, other);
    return other;
  }
  /**
   * add a value at the specified position in the current Matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#47
   * @param index the index of the value within the matrix. between 0 and 15.
   * @param value the value to be added
   * @returns the current updated matrix
   */
  addAtIndex(index2, value) {
    this._m[index2] += value;
    this.markAsUpdated();
    return this;
  }
  /**
   * mutiply the specified position in the current Matrix by a value
   * @param index the index of the value within the matrix. between 0 and 15.
   * @param value the value to be added
   * @returns the current updated matrix
   */
  multiplyAtIndex(index2, value) {
    this._m[index2] *= value;
    this.markAsUpdated();
    return this;
  }
  /**
   * Inserts the translation vector (using 3 floats) in the current matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#120
   * @param x defines the 1st component of the translation
   * @param y defines the 2nd component of the translation
   * @param z defines the 3rd component of the translation
   * @returns the current updated matrix
   */
  setTranslationFromFloats(x2, y2, z2) {
    this._m[12] = x2;
    this._m[13] = y2;
    this._m[14] = z2;
    this.markAsUpdated();
    return this;
  }
  /**
   * Adds the translation vector (using 3 floats) in the current matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#20
   * Example Playground - https://playground.babylonjs.com/#AV9X17#48
   * @param x defines the 1st component of the translation
   * @param y defines the 2nd component of the translation
   * @param z defines the 3rd component of the translation
   * @returns the current updated matrix
   */
  addTranslationFromFloats(x2, y2, z2) {
    this._m[12] += x2;
    this._m[13] += y2;
    this._m[14] += z2;
    this.markAsUpdated();
    return this;
  }
  /**
   * Inserts the translation vector in the current matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#121
   * @param vector3 defines the translation to insert
   * @returns the current updated matrix
   */
  setTranslation(vector3) {
    return this.setTranslationFromFloats(vector3._x, vector3._y, vector3._z);
  }
  /**
   * Gets the translation value of the current matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#122
   * @returns a new Vector3 as the extracted translation from the matrix
   */
  getTranslation() {
    return new Vector3(this._m[12], this._m[13], this._m[14]);
  }
  /**
   * Fill a Vector3 with the extracted translation from the matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#123
   * @param result defines the Vector3 where to store the translation
   * @returns the current matrix
   */
  getTranslationToRef(result) {
    result.x = this._m[12];
    result.y = this._m[13];
    result.z = this._m[14];
    return result;
  }
  /**
   * Remove rotation and scaling part from the matrix
   * @returns the updated matrix
   */
  removeRotationAndScaling() {
    const m2 = this.m;
    Matrix.FromValuesToRef(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, m2[12], m2[13], m2[14], m2[15], this);
    this._updateIdentityStatus(m2[12] === 0 && m2[13] === 0 && m2[14] === 0 && m2[15] === 1);
    return this;
  }
  /**
   * Copy the current matrix from the given one
   * Example Playground - https://playground.babylonjs.com/#AV9X17#21
   * @param other defines the source matrix
   * @returns the current updated matrix
   */
  copyFrom(other) {
    other.copyToArray(this._m);
    const o2 = other;
    this.updateFlag = o2.updateFlag;
    this._updateIdentityStatus(o2._isIdentity, o2._isIdentityDirty, o2._isIdentity3x2, o2._isIdentity3x2Dirty);
    return this;
  }
  /**
   * Populates the given array from the starting index with the current matrix values
   * @param array defines the target array
   * @param offset defines the offset in the target array where to start storing values
   * @returns the current matrix
   */
  copyToArray(array, offset = 0) {
    const source = this._m;
    array[offset] = source[0];
    array[offset + 1] = source[1];
    array[offset + 2] = source[2];
    array[offset + 3] = source[3];
    array[offset + 4] = source[4];
    array[offset + 5] = source[5];
    array[offset + 6] = source[6];
    array[offset + 7] = source[7];
    array[offset + 8] = source[8];
    array[offset + 9] = source[9];
    array[offset + 10] = source[10];
    array[offset + 11] = source[11];
    array[offset + 12] = source[12];
    array[offset + 13] = source[13];
    array[offset + 14] = source[14];
    array[offset + 15] = source[15];
    return this;
  }
  /**
   * Multiply two matrices
   * Example Playground - https://playground.babylonjs.com/#AV9X17#15
   * A.multiply(B) means apply B to A so result is B x A
   * @param other defines the second operand
   * @returns a new matrix set with the multiplication result of the current Matrix and the given one
   */
  multiply(other) {
    const result = new Matrix();
    this.multiplyToRef(other, result);
    return result;
  }
  /**
   * This method performs component-by-component in-place multiplication, rather than true matrix multiplication.
   * Use multiply or multiplyToRef for matrix multiplication.
   * @param other defines the second operand
   * @returns the current updated matrix
   */
  multiplyInPlace(other) {
    const m2 = this._m, otherM = other.m;
    for (let i2 = 0; i2 < 16; i2++) {
      m2[i2] *= otherM[i2];
    }
    this.markAsUpdated();
    return this;
  }
  /**
   * This method performs a component-by-component multiplication of the current matrix with the array of transmitted numbers.
   * Use multiply or multiplyToRef for matrix multiplication.
   * @param floats defines the array of numbers to multiply the matrix by
   * @returns the current updated matrix
   */
  multiplyByFloats(...floats) {
    const m2 = this._m;
    for (let i2 = 0; i2 < 16; i2++) {
      m2[i2] *= floats[i2];
    }
    this.markAsUpdated();
    return this;
  }
  /**
   * Multiples the current matrix by the given floats and stores them in the given ref
   * @param args The floats and ref
   * @returns The updated ref
   */
  multiplyByFloatsToRef(...args) {
    const result = args.pop(), m2 = this._m, resultM = result._m, values = args;
    for (let i2 = 0; i2 < 16; i2++) {
      resultM[i2] = m2[i2] * values[i2];
    }
    result.markAsUpdated();
    return result;
  }
  /**
   * Sets the given matrix "result" with the multiplication result of the current Matrix and the given one
   * A.multiplyToRef(B, R) means apply B to A and store in R and R = B x A
   * Example Playground - https://playground.babylonjs.com/#AV9X17#16
   * @param other defines the second operand
   * @param result defines the matrix where to store the multiplication
   * @returns result input
   */
  multiplyToRef(other, result) {
    if (this._isIdentity) {
      result.copyFrom(other);
      return result;
    }
    if (other._isIdentity) {
      result.copyFrom(this);
      return result;
    }
    this.multiplyToArray(other, result._m, 0);
    result.markAsUpdated();
    return result;
  }
  /**
   * Sets the Float32Array "result" from the given index "offset" with the multiplication of the current matrix and the given one
   * @param other defines the second operand
   * @param result defines the array where to store the multiplication
   * @param offset defines the offset in the target array where to start storing values
   * @returns the current matrix
   */
  multiplyToArray(other, result, offset) {
    const m2 = this._m;
    const otherM = other.m;
    const tm0 = m2[0], tm1 = m2[1], tm2 = m2[2], tm3 = m2[3];
    const tm4 = m2[4], tm5 = m2[5], tm6 = m2[6], tm7 = m2[7];
    const tm8 = m2[8], tm9 = m2[9], tm10 = m2[10], tm11 = m2[11];
    const tm12 = m2[12], tm13 = m2[13], tm14 = m2[14], tm15 = m2[15];
    const om0 = otherM[0], om1 = otherM[1], om2 = otherM[2], om3 = otherM[3];
    const om4 = otherM[4], om5 = otherM[5], om6 = otherM[6], om7 = otherM[7];
    const om8 = otherM[8], om9 = otherM[9], om10 = otherM[10], om11 = otherM[11];
    const om12 = otherM[12], om13 = otherM[13], om14 = otherM[14], om15 = otherM[15];
    result[offset] = tm0 * om0 + tm1 * om4 + tm2 * om8 + tm3 * om12;
    result[offset + 1] = tm0 * om1 + tm1 * om5 + tm2 * om9 + tm3 * om13;
    result[offset + 2] = tm0 * om2 + tm1 * om6 + tm2 * om10 + tm3 * om14;
    result[offset + 3] = tm0 * om3 + tm1 * om7 + tm2 * om11 + tm3 * om15;
    result[offset + 4] = tm4 * om0 + tm5 * om4 + tm6 * om8 + tm7 * om12;
    result[offset + 5] = tm4 * om1 + tm5 * om5 + tm6 * om9 + tm7 * om13;
    result[offset + 6] = tm4 * om2 + tm5 * om6 + tm6 * om10 + tm7 * om14;
    result[offset + 7] = tm4 * om3 + tm5 * om7 + tm6 * om11 + tm7 * om15;
    result[offset + 8] = tm8 * om0 + tm9 * om4 + tm10 * om8 + tm11 * om12;
    result[offset + 9] = tm8 * om1 + tm9 * om5 + tm10 * om9 + tm11 * om13;
    result[offset + 10] = tm8 * om2 + tm9 * om6 + tm10 * om10 + tm11 * om14;
    result[offset + 11] = tm8 * om3 + tm9 * om7 + tm10 * om11 + tm11 * om15;
    result[offset + 12] = tm12 * om0 + tm13 * om4 + tm14 * om8 + tm15 * om12;
    result[offset + 13] = tm12 * om1 + tm13 * om5 + tm14 * om9 + tm15 * om13;
    result[offset + 14] = tm12 * om2 + tm13 * om6 + tm14 * om10 + tm15 * om14;
    result[offset + 15] = tm12 * om3 + tm13 * om7 + tm14 * om11 + tm15 * om15;
    return this;
  }
  divide(other) {
    return this.divideToRef(other, new Matrix());
  }
  divideToRef(other, result) {
    const m2 = this._m, otherM = other.m, resultM = result._m;
    for (let i2 = 0; i2 < 16; i2++) {
      resultM[i2] = m2[i2] / otherM[i2];
    }
    result.markAsUpdated();
    return result;
  }
  divideInPlace(other) {
    const m2 = this._m, otherM = other.m;
    for (let i2 = 0; i2 < 16; i2++) {
      m2[i2] /= otherM[i2];
    }
    this.markAsUpdated();
    return this;
  }
  minimizeInPlace(other) {
    const m2 = this._m, otherM = other.m;
    for (let i2 = 0; i2 < 16; i2++) {
      m2[i2] = Math.min(m2[i2], otherM[i2]);
    }
    this.markAsUpdated();
    return this;
  }
  minimizeInPlaceFromFloats(...floats) {
    const m2 = this._m;
    for (let i2 = 0; i2 < 16; i2++) {
      m2[i2] = Math.min(m2[i2], floats[i2]);
    }
    this.markAsUpdated();
    return this;
  }
  maximizeInPlace(other) {
    const m2 = this._m, otherM = other.m;
    for (let i2 = 0; i2 < 16; i2++) {
      m2[i2] = Math.min(m2[i2], otherM[i2]);
    }
    this.markAsUpdated();
    return this;
  }
  maximizeInPlaceFromFloats(...floats) {
    const m2 = this._m;
    for (let i2 = 0; i2 < 16; i2++) {
      m2[i2] = Math.min(m2[i2], floats[i2]);
    }
    this.markAsUpdated();
    return this;
  }
  negate() {
    return this.negateToRef(new Matrix());
  }
  negateInPlace() {
    const m2 = this._m;
    for (let i2 = 0; i2 < 16; i2++) {
      m2[i2] = -m2[i2];
    }
    this.markAsUpdated();
    return this;
  }
  negateToRef(result) {
    const m2 = this._m, resultM = result._m;
    for (let i2 = 0; i2 < 16; i2++) {
      resultM[i2] = -m2[i2];
    }
    result.markAsUpdated();
    return result;
  }
  /**
   * Check equality between this matrix and a second one
   * @param value defines the second matrix to compare
   * @returns true is the current matrix and the given one values are strictly equal
   */
  equals(value) {
    const other = value;
    if (!other) {
      return false;
    }
    if (this._isIdentity || other._isIdentity) {
      if (!this._isIdentityDirty && !other._isIdentityDirty) {
        return this._isIdentity && other._isIdentity;
      }
    }
    const m2 = this.m;
    const om = other.m;
    return m2[0] === om[0] && m2[1] === om[1] && m2[2] === om[2] && m2[3] === om[3] && m2[4] === om[4] && m2[5] === om[5] && m2[6] === om[6] && m2[7] === om[7] && m2[8] === om[8] && m2[9] === om[9] && m2[10] === om[10] && m2[11] === om[11] && m2[12] === om[12] && m2[13] === om[13] && m2[14] === om[14] && m2[15] === om[15];
  }
  equalsWithEpsilon(other, epsilon = 0) {
    const m2 = this._m, otherM = other.m;
    for (let i2 = 0; i2 < 16; i2++) {
      if (!WithinEpsilon(m2[i2], otherM[i2], epsilon)) {
        return false;
      }
    }
    return true;
  }
  equalsToFloats(...floats) {
    const m2 = this._m;
    for (let i2 = 0; i2 < 16; i2++) {
      if (m2[i2] != floats[i2]) {
        return false;
      }
    }
    return true;
  }
  floor() {
    return this.floorToRef(new Matrix());
  }
  floorToRef(result) {
    const m2 = this._m, resultM = result._m;
    for (let i2 = 0; i2 < 16; i2++) {
      resultM[i2] = Math.floor(m2[i2]);
    }
    result.markAsUpdated();
    return result;
  }
  fract() {
    return this.fractToRef(new Matrix());
  }
  fractToRef(result) {
    const m2 = this._m, resultM = result._m;
    for (let i2 = 0; i2 < 16; i2++) {
      resultM[i2] = m2[i2] - Math.floor(m2[i2]);
    }
    result.markAsUpdated();
    return result;
  }
  /**
   * Clone the current matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#18
   * @returns a new matrix from the current matrix
   */
  clone() {
    const matrix = new Matrix();
    matrix.copyFrom(this);
    return matrix;
  }
  /**
   * Returns the name of the current matrix class
   * @returns the string "Matrix"
   */
  getClassName() {
    return "Matrix";
  }
  /**
   * Gets the hash code of the current matrix
   * @returns the hash code
   */
  getHashCode() {
    let hash = _ExtractAsInt(this._m[0]);
    for (let i2 = 1; i2 < 16; i2++) {
      hash = hash * 397 ^ _ExtractAsInt(this._m[i2]);
    }
    return hash;
  }
  /**
   * Decomposes the current Matrix into a translation, rotation and scaling components of the provided node
   * Example Playground - https://playground.babylonjs.com/#AV9X17#13
   * @param node the node to decompose the matrix to
   * @returns true if operation was successful
   */
  decomposeToTransformNode(node) {
    node.rotationQuaternion = node.rotationQuaternion || new Quaternion();
    return this.decompose(node.scaling, node.rotationQuaternion, node.position);
  }
  /**
   * Decomposes the current Matrix into a translation, rotation and scaling components
   * Example Playground - https://playground.babylonjs.com/#AV9X17#12
   * @param scale defines the scale vector3 given as a reference to update
   * @param rotation defines the rotation quaternion given as a reference to update
   * @param translation defines the translation vector3 given as a reference to update
   * @param preserveScalingNode Use scaling sign coming from this node. Otherwise scaling sign might change.
   * @param useAbsoluteScaling Use scaling sign coming from this absoluteScaling when true or scaling otherwise.
   * @returns true if operation was successful
   */
  decompose(scale, rotation, translation, preserveScalingNode, useAbsoluteScaling = true) {
    if (this._isIdentity) {
      if (translation) {
        translation.setAll(0);
      }
      if (scale) {
        scale.setAll(1);
      }
      if (rotation) {
        rotation.copyFromFloats(0, 0, 0, 1);
      }
      return true;
    }
    const m2 = this._m;
    if (translation) {
      translation.copyFromFloats(m2[12], m2[13], m2[14]);
    }
    scale = scale || MathTmp.Vector3[0];
    scale.x = Math.sqrt(m2[0] * m2[0] + m2[1] * m2[1] + m2[2] * m2[2]);
    scale.y = Math.sqrt(m2[4] * m2[4] + m2[5] * m2[5] + m2[6] * m2[6]);
    scale.z = Math.sqrt(m2[8] * m2[8] + m2[9] * m2[9] + m2[10] * m2[10]);
    if (preserveScalingNode) {
      const signX = (useAbsoluteScaling ? preserveScalingNode.absoluteScaling.x : preserveScalingNode.scaling.x) < 0 ? -1 : 1;
      const signY = (useAbsoluteScaling ? preserveScalingNode.absoluteScaling.y : preserveScalingNode.scaling.y) < 0 ? -1 : 1;
      const signZ = (useAbsoluteScaling ? preserveScalingNode.absoluteScaling.z : preserveScalingNode.scaling.z) < 0 ? -1 : 1;
      scale.x *= signX;
      scale.y *= signY;
      scale.z *= signZ;
    } else {
      if (this.determinant() <= 0) {
        scale.y *= -1;
      }
    }
    if (scale._x === 0 || scale._y === 0 || scale._z === 0) {
      if (rotation) {
        rotation.copyFromFloats(0, 0, 0, 1);
      }
      return false;
    }
    if (rotation) {
      const sx = 1 / scale._x, sy = 1 / scale._y, sz = 1 / scale._z;
      Matrix.FromValuesToRef(m2[0] * sx, m2[1] * sx, m2[2] * sx, 0, m2[4] * sy, m2[5] * sy, m2[6] * sy, 0, m2[8] * sz, m2[9] * sz, m2[10] * sz, 0, 0, 0, 0, 1, MathTmp.Matrix[0]);
      Quaternion.FromRotationMatrixToRef(MathTmp.Matrix[0], rotation);
    }
    return true;
  }
  /**
   * Gets specific row of the matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#36
   * @param index defines the number of the row to get
   * @returns the index-th row of the current matrix as a new Vector4
   */
  getRow(index2) {
    if (index2 < 0 || index2 > 3) {
      return null;
    }
    const i2 = index2 * 4;
    return new Vector4(this._m[i2 + 0], this._m[i2 + 1], this._m[i2 + 2], this._m[i2 + 3]);
  }
  /**
   * Gets specific row of the matrix to ref
   * Example Playground - https://playground.babylonjs.com/#AV9X17#36
   * @param index defines the number of the row to get
   * @param rowVector vector to store the index-th row of the current matrix
   * @returns result input
   */
  getRowToRef(index2, rowVector) {
    if (index2 >= 0 && index2 <= 3) {
      const i2 = index2 * 4;
      rowVector.x = this._m[i2 + 0];
      rowVector.y = this._m[i2 + 1];
      rowVector.z = this._m[i2 + 2];
      rowVector.w = this._m[i2 + 3];
    }
    return rowVector;
  }
  /**
   * Sets the index-th row of the current matrix to the vector4 values
   * Example Playground - https://playground.babylonjs.com/#AV9X17#36
   * @param index defines the number of the row to set
   * @param row defines the target vector4
   * @returns the updated current matrix
   */
  setRow(index2, row) {
    return this.setRowFromFloats(index2, row.x, row.y, row.z, row.w);
  }
  /**
   * Compute the transpose of the matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#40
   * @returns the new transposed matrix
   */
  transpose() {
    const result = new Matrix();
    Matrix.TransposeToRef(this, result);
    return result;
  }
  /**
   * Compute the transpose of the matrix and store it in a given matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#41
   * @param result defines the target matrix
   * @returns result input
   */
  transposeToRef(result) {
    Matrix.TransposeToRef(this, result);
    return result;
  }
  /**
   * Sets the index-th row of the current matrix with the given 4 x float values
   * Example Playground - https://playground.babylonjs.com/#AV9X17#36
   * @param index defines the row index
   * @param x defines the x component to set
   * @param y defines the y component to set
   * @param z defines the z component to set
   * @param w defines the w component to set
   * @returns the updated current matrix
   */
  setRowFromFloats(index2, x2, y2, z2, w) {
    if (index2 < 0 || index2 > 3) {
      return this;
    }
    const i2 = index2 * 4;
    this._m[i2 + 0] = x2;
    this._m[i2 + 1] = y2;
    this._m[i2 + 2] = z2;
    this._m[i2 + 3] = w;
    this.markAsUpdated();
    return this;
  }
  /**
   * Compute a new matrix set with the current matrix values multiplied by scale (float)
   * @param scale defines the scale factor
   * @returns a new matrix
   */
  scale(scale) {
    const result = new Matrix();
    this.scaleToRef(scale, result);
    return result;
  }
  /**
   * Scale the current matrix values by a factor to a given result matrix
   * @param scale defines the scale factor
   * @param result defines the matrix to store the result
   * @returns result input
   */
  scaleToRef(scale, result) {
    for (let index2 = 0; index2 < 16; index2++) {
      result._m[index2] = this._m[index2] * scale;
    }
    result.markAsUpdated();
    return result;
  }
  /**
   * Scale the current matrix values by a factor and add the result to a given matrix
   * @param scale defines the scale factor
   * @param result defines the Matrix to store the result
   * @returns result input
   */
  scaleAndAddToRef(scale, result) {
    for (let index2 = 0; index2 < 16; index2++) {
      result._m[index2] += this._m[index2] * scale;
    }
    result.markAsUpdated();
    return result;
  }
  scaleInPlace(scale) {
    const m2 = this._m;
    for (let i2 = 0; i2 < 16; i2++) {
      m2[i2] *= scale;
    }
    this.markAsUpdated();
    return this;
  }
  /**
   * Writes to the given matrix a normal matrix, computed from this one (using values from identity matrix for fourth row and column).
   * Example Playground - https://playground.babylonjs.com/#AV9X17#17
   * @param ref matrix to store the result
   * @returns the reference matrix
   */
  toNormalMatrix(ref) {
    const tmp = MathTmp.Matrix[0];
    this.invertToRef(tmp);
    tmp.transposeToRef(ref);
    const m2 = ref._m;
    Matrix.FromValuesToRef(m2[0], m2[1], m2[2], 0, m2[4], m2[5], m2[6], 0, m2[8], m2[9], m2[10], 0, 0, 0, 0, 1, ref);
    return ref;
  }
  /**
   * Gets only rotation part of the current matrix
   * @returns a new matrix sets to the extracted rotation matrix from the current one
   */
  getRotationMatrix() {
    const result = new Matrix();
    this.getRotationMatrixToRef(result);
    return result;
  }
  /**
   * Extracts the rotation matrix from the current one and sets it as the given "result"
   * @param result defines the target matrix to store data to
   * @returns result input
   */
  getRotationMatrixToRef(result) {
    const scale = MathTmp.Vector3[0];
    if (!this.decompose(scale)) {
      Matrix.IdentityToRef(result);
      return result;
    }
    const m2 = this._m;
    const sx = 1 / scale._x, sy = 1 / scale._y, sz = 1 / scale._z;
    Matrix.FromValuesToRef(m2[0] * sx, m2[1] * sx, m2[2] * sx, 0, m2[4] * sy, m2[5] * sy, m2[6] * sy, 0, m2[8] * sz, m2[9] * sz, m2[10] * sz, 0, 0, 0, 0, 1, result);
    return result;
  }
  /**
   * Toggles model matrix from being right handed to left handed in place and vice versa
   * @returns the current updated matrix
   */
  toggleModelMatrixHandInPlace() {
    const m2 = this._m;
    m2[2] *= -1;
    m2[6] *= -1;
    m2[8] *= -1;
    m2[9] *= -1;
    m2[14] *= -1;
    this.markAsUpdated();
    return this;
  }
  /**
   * Toggles projection matrix from being right handed to left handed in place and vice versa
   * @returns the current updated matrix
   */
  toggleProjectionMatrixHandInPlace() {
    const m2 = this._m;
    m2[8] *= -1;
    m2[9] *= -1;
    m2[10] *= -1;
    m2[11] *= -1;
    this.markAsUpdated();
    return this;
  }
  // Statics
  /**
   * Creates a matrix from an array
   * Example Playground - https://playground.babylonjs.com/#AV9X17#42
   * @param array defines the source array
   * @param offset defines an offset in the source array
   * @returns a new Matrix set from the starting index of the given array
   */
  static FromArray(array, offset = 0) {
    const result = new Matrix();
    Matrix.FromArrayToRef(array, offset, result);
    return result;
  }
  /**
   * Copy the content of an array into a given matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#43
   * @param array defines the source array
   * @param offset defines an offset in the source array
   * @param result defines the target matrix
   * @returns result input
   */
  static FromArrayToRef(array, offset, result) {
    for (let index2 = 0; index2 < 16; index2++) {
      result._m[index2] = array[index2 + offset];
    }
    result.markAsUpdated();
    return result;
  }
  /**
   * Stores an array into a matrix after having multiplied each component by a given factor
   * Example Playground - https://playground.babylonjs.com/#AV9X17#50
   * @param array defines the source array
   * @param offset defines the offset in the source array
   * @param scale defines the scaling factor
   * @param result defines the target matrix
   * @returns result input
   */
  static FromFloat32ArrayToRefScaled(array, offset, scale, result) {
    result._m[0] = array[0 + offset] * scale;
    result._m[1] = array[1 + offset] * scale;
    result._m[2] = array[2 + offset] * scale;
    result._m[3] = array[3 + offset] * scale;
    result._m[4] = array[4 + offset] * scale;
    result._m[5] = array[5 + offset] * scale;
    result._m[6] = array[6 + offset] * scale;
    result._m[7] = array[7 + offset] * scale;
    result._m[8] = array[8 + offset] * scale;
    result._m[9] = array[9 + offset] * scale;
    result._m[10] = array[10 + offset] * scale;
    result._m[11] = array[11 + offset] * scale;
    result._m[12] = array[12 + offset] * scale;
    result._m[13] = array[13 + offset] * scale;
    result._m[14] = array[14 + offset] * scale;
    result._m[15] = array[15 + offset] * scale;
    result.markAsUpdated();
    return result;
  }
  /**
   * Gets an identity matrix that must not be updated
   */
  static get IdentityReadOnly() {
    return Matrix._IdentityReadOnly;
  }
  /**
   * Stores a list of values (16) inside a given matrix
   * @param initialM11 defines 1st value of 1st row
   * @param initialM12 defines 2nd value of 1st row
   * @param initialM13 defines 3rd value of 1st row
   * @param initialM14 defines 4th value of 1st row
   * @param initialM21 defines 1st value of 2nd row
   * @param initialM22 defines 2nd value of 2nd row
   * @param initialM23 defines 3rd value of 2nd row
   * @param initialM24 defines 4th value of 2nd row
   * @param initialM31 defines 1st value of 3rd row
   * @param initialM32 defines 2nd value of 3rd row
   * @param initialM33 defines 3rd value of 3rd row
   * @param initialM34 defines 4th value of 3rd row
   * @param initialM41 defines 1st value of 4th row
   * @param initialM42 defines 2nd value of 4th row
   * @param initialM43 defines 3rd value of 4th row
   * @param initialM44 defines 4th value of 4th row
   * @param result defines the target matrix
   */
  static FromValuesToRef(initialM11, initialM12, initialM13, initialM14, initialM21, initialM22, initialM23, initialM24, initialM31, initialM32, initialM33, initialM34, initialM41, initialM42, initialM43, initialM44, result) {
    const m2 = result._m;
    m2[0] = initialM11;
    m2[1] = initialM12;
    m2[2] = initialM13;
    m2[3] = initialM14;
    m2[4] = initialM21;
    m2[5] = initialM22;
    m2[6] = initialM23;
    m2[7] = initialM24;
    m2[8] = initialM31;
    m2[9] = initialM32;
    m2[10] = initialM33;
    m2[11] = initialM34;
    m2[12] = initialM41;
    m2[13] = initialM42;
    m2[14] = initialM43;
    m2[15] = initialM44;
    result.markAsUpdated();
  }
  /**
   * Creates new matrix from a list of values (16)
   * @param initialM11 defines 1st value of 1st row
   * @param initialM12 defines 2nd value of 1st row
   * @param initialM13 defines 3rd value of 1st row
   * @param initialM14 defines 4th value of 1st row
   * @param initialM21 defines 1st value of 2nd row
   * @param initialM22 defines 2nd value of 2nd row
   * @param initialM23 defines 3rd value of 2nd row
   * @param initialM24 defines 4th value of 2nd row
   * @param initialM31 defines 1st value of 3rd row
   * @param initialM32 defines 2nd value of 3rd row
   * @param initialM33 defines 3rd value of 3rd row
   * @param initialM34 defines 4th value of 3rd row
   * @param initialM41 defines 1st value of 4th row
   * @param initialM42 defines 2nd value of 4th row
   * @param initialM43 defines 3rd value of 4th row
   * @param initialM44 defines 4th value of 4th row
   * @returns the new matrix
   */
  static FromValues(initialM11, initialM12, initialM13, initialM14, initialM21, initialM22, initialM23, initialM24, initialM31, initialM32, initialM33, initialM34, initialM41, initialM42, initialM43, initialM44) {
    const result = new Matrix();
    const m2 = result._m;
    m2[0] = initialM11;
    m2[1] = initialM12;
    m2[2] = initialM13;
    m2[3] = initialM14;
    m2[4] = initialM21;
    m2[5] = initialM22;
    m2[6] = initialM23;
    m2[7] = initialM24;
    m2[8] = initialM31;
    m2[9] = initialM32;
    m2[10] = initialM33;
    m2[11] = initialM34;
    m2[12] = initialM41;
    m2[13] = initialM42;
    m2[14] = initialM43;
    m2[15] = initialM44;
    result.markAsUpdated();
    return result;
  }
  /**
   * Creates a new matrix composed by merging scale (vector3), rotation (quaternion) and translation (vector3)
   * Example Playground - https://playground.babylonjs.com/#AV9X17#24
   * @param scale defines the scale vector3
   * @param rotation defines the rotation quaternion
   * @param translation defines the translation vector3
   * @returns a new matrix
   */
  static Compose(scale, rotation, translation) {
    const result = new Matrix();
    Matrix.ComposeToRef(scale, rotation, translation, result);
    return result;
  }
  /**
   * Sets a matrix to a value composed by merging scale (vector3), rotation (quaternion) and translation (vector3)
   * Example Playground - https://playground.babylonjs.com/#AV9X17#25
   * @param scale defines the scale vector3
   * @param rotation defines the rotation quaternion
   * @param translation defines the translation vector3
   * @param result defines the target matrix
   * @returns result input
   */
  static ComposeToRef(scale, rotation, translation, result) {
    const m2 = result._m;
    const x2 = rotation._x, y2 = rotation._y, z2 = rotation._z, w = rotation._w;
    const x22 = x2 + x2, y22 = y2 + y2, z22 = z2 + z2;
    const xx = x2 * x22, xy = x2 * y22, xz = x2 * z22;
    const yy = y2 * y22, yz = y2 * z22, zz = z2 * z22;
    const wx = w * x22, wy = w * y22, wz = w * z22;
    const sx = scale._x, sy = scale._y, sz = scale._z;
    m2[0] = (1 - (yy + zz)) * sx;
    m2[1] = (xy + wz) * sx;
    m2[2] = (xz - wy) * sx;
    m2[3] = 0;
    m2[4] = (xy - wz) * sy;
    m2[5] = (1 - (xx + zz)) * sy;
    m2[6] = (yz + wx) * sy;
    m2[7] = 0;
    m2[8] = (xz + wy) * sz;
    m2[9] = (yz - wx) * sz;
    m2[10] = (1 - (xx + yy)) * sz;
    m2[11] = 0;
    m2[12] = translation._x;
    m2[13] = translation._y;
    m2[14] = translation._z;
    m2[15] = 1;
    result.markAsUpdated();
    return result;
  }
  /**
   * Creates a new identity matrix
   * @returns a new identity matrix
   */
  static Identity() {
    const identity = Matrix.FromValues(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1);
    identity._updateIdentityStatus(true);
    return identity;
  }
  /**
   * Creates a new identity matrix and stores the result in a given matrix
   * @param result defines the target matrix
   * @returns result input
   */
  static IdentityToRef(result) {
    Matrix.FromValuesToRef(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, result);
    result._updateIdentityStatus(true);
    return result;
  }
  /**
   * Creates a new zero matrix
   * @returns a new zero matrix
   */
  static Zero() {
    const zero = Matrix.FromValues(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    zero._updateIdentityStatus(false);
    return zero;
  }
  /**
   * Creates a new rotation matrix for "angle" radians around the X axis
   * Example Playground - https://playground.babylonjs.com/#AV9X17#97
   * @param angle defines the angle (in radians) to use
   * @returns the new matrix
   */
  static RotationX(angle) {
    const result = new Matrix();
    Matrix.RotationXToRef(angle, result);
    return result;
  }
  /**
   * Creates a new matrix as the invert of a given matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#124
   * @param source defines the source matrix
   * @returns the new matrix
   */
  static Invert(source) {
    const result = new Matrix();
    source.invertToRef(result);
    return result;
  }
  /**
   * Creates a new rotation matrix for "angle" radians around the X axis and stores it in a given matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#98
   * @param angle defines the angle (in radians) to use
   * @param result defines the target matrix
   * @returns result input
   */
  static RotationXToRef(angle, result) {
    const s2 = Math.sin(angle);
    const c2 = Math.cos(angle);
    Matrix.FromValuesToRef(1, 0, 0, 0, 0, c2, s2, 0, 0, -s2, c2, 0, 0, 0, 0, 1, result);
    result._updateIdentityStatus(c2 === 1 && s2 === 0);
    return result;
  }
  /**
   * Creates a new rotation matrix for "angle" radians around the Y axis
   * Example Playground - https://playground.babylonjs.com/#AV9X17#99
   * @param angle defines the angle (in radians) to use
   * @returns the new matrix
   */
  static RotationY(angle) {
    const result = new Matrix();
    Matrix.RotationYToRef(angle, result);
    return result;
  }
  /**
   * Creates a new rotation matrix for "angle" radians around the Y axis and stores it in a given matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#100
   * @param angle defines the angle (in radians) to use
   * @param result defines the target matrix
   * @returns result input
   */
  static RotationYToRef(angle, result) {
    const s2 = Math.sin(angle);
    const c2 = Math.cos(angle);
    Matrix.FromValuesToRef(c2, 0, -s2, 0, 0, 1, 0, 0, s2, 0, c2, 0, 0, 0, 0, 1, result);
    result._updateIdentityStatus(c2 === 1 && s2 === 0);
    return result;
  }
  /**
   * Creates a new rotation matrix for "angle" radians around the Z axis
   * Example Playground - https://playground.babylonjs.com/#AV9X17#101
   * @param angle defines the angle (in radians) to use
   * @returns the new matrix
   */
  static RotationZ(angle) {
    const result = new Matrix();
    Matrix.RotationZToRef(angle, result);
    return result;
  }
  /**
   * Creates a new rotation matrix for "angle" radians around the Z axis and stores it in a given matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#102
   * @param angle defines the angle (in radians) to use
   * @param result defines the target matrix
   * @returns result input
   */
  static RotationZToRef(angle, result) {
    const s2 = Math.sin(angle);
    const c2 = Math.cos(angle);
    Matrix.FromValuesToRef(c2, s2, 0, 0, -s2, c2, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, result);
    result._updateIdentityStatus(c2 === 1 && s2 === 0);
    return result;
  }
  /**
   * Creates a new rotation matrix for "angle" radians around the given axis
   * Example Playground - https://playground.babylonjs.com/#AV9X17#96
   * @param axis defines the axis to use
   * @param angle defines the angle (in radians) to use
   * @returns the new matrix
   */
  static RotationAxis(axis, angle) {
    const result = new Matrix();
    Matrix.RotationAxisToRef(axis, angle, result);
    return result;
  }
  /**
   * Creates a new rotation matrix for "angle" radians around the given axis and stores it in a given matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#94
   * @param axis defines the axis to use
   * @param angle defines the angle (in radians) to use
   * @param result defines the target matrix
   * @returns result input
   */
  static RotationAxisToRef(axis, angle, result) {
    const s2 = Math.sin(-angle);
    const c2 = Math.cos(-angle);
    const c1 = 1 - c2;
    axis = axis.normalizeToRef(MathTmp.Vector3[0]);
    const m2 = result._m;
    m2[0] = axis._x * axis._x * c1 + c2;
    m2[1] = axis._x * axis._y * c1 - axis._z * s2;
    m2[2] = axis._x * axis._z * c1 + axis._y * s2;
    m2[3] = 0;
    m2[4] = axis._y * axis._x * c1 + axis._z * s2;
    m2[5] = axis._y * axis._y * c1 + c2;
    m2[6] = axis._y * axis._z * c1 - axis._x * s2;
    m2[7] = 0;
    m2[8] = axis._z * axis._x * c1 - axis._y * s2;
    m2[9] = axis._z * axis._y * c1 + axis._x * s2;
    m2[10] = axis._z * axis._z * c1 + c2;
    m2[11] = 0;
    m2[12] = 0;
    m2[13] = 0;
    m2[14] = 0;
    m2[15] = 1;
    result.markAsUpdated();
    return result;
  }
  /**
   * Takes normalised vectors and returns a rotation matrix to align "from" with "to".
   * Taken from http://www.iquilezles.org/www/articles/noacos/noacos.htm
   * Example Playground - https://playground.babylonjs.com/#AV9X17#93
   * @param from defines the vector to align
   * @param to defines the vector to align to
   * @param result defines the target matrix
   * @param useYAxisForCoplanar defines a boolean indicating that we should favor Y axis for coplanar vectors (default is false)
   * @returns result input
   */
  static RotationAlignToRef(from, to, result, useYAxisForCoplanar = false) {
    const c2 = Vector3.Dot(to, from);
    const m2 = result._m;
    if (c2 < -1 + Epsilon) {
      m2[0] = -1;
      m2[1] = 0;
      m2[2] = 0;
      m2[3] = 0;
      m2[4] = 0;
      m2[5] = useYAxisForCoplanar ? 1 : -1;
      m2[6] = 0;
      m2[7] = 0;
      m2[8] = 0;
      m2[9] = 0;
      m2[10] = useYAxisForCoplanar ? -1 : 1;
      m2[11] = 0;
    } else {
      const v2 = Vector3.Cross(to, from);
      const k2 = 1 / (1 + c2);
      m2[0] = v2._x * v2._x * k2 + c2;
      m2[1] = v2._y * v2._x * k2 - v2._z;
      m2[2] = v2._z * v2._x * k2 + v2._y;
      m2[3] = 0;
      m2[4] = v2._x * v2._y * k2 + v2._z;
      m2[5] = v2._y * v2._y * k2 + c2;
      m2[6] = v2._z * v2._y * k2 - v2._x;
      m2[7] = 0;
      m2[8] = v2._x * v2._z * k2 - v2._y;
      m2[9] = v2._y * v2._z * k2 + v2._x;
      m2[10] = v2._z * v2._z * k2 + c2;
      m2[11] = 0;
    }
    m2[12] = 0;
    m2[13] = 0;
    m2[14] = 0;
    m2[15] = 1;
    result.markAsUpdated();
    return result;
  }
  /**
   * Creates a rotation matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#103
   * Example Playground - https://playground.babylonjs.com/#AV9X17#105
   * @param yaw defines the yaw angle in radians (Y axis)
   * @param pitch defines the pitch angle in radians (X axis)
   * @param roll defines the roll angle in radians (Z axis)
   * @returns the new rotation matrix
   */
  static RotationYawPitchRoll(yaw, pitch, roll) {
    const result = new Matrix();
    Matrix.RotationYawPitchRollToRef(yaw, pitch, roll, result);
    return result;
  }
  /**
   * Creates a rotation matrix and stores it in a given matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#104
   * @param yaw defines the yaw angle in radians (Y axis)
   * @param pitch defines the pitch angle in radians (X axis)
   * @param roll defines the roll angle in radians (Z axis)
   * @param result defines the target matrix
   * @returns result input
   */
  static RotationYawPitchRollToRef(yaw, pitch, roll, result) {
    Quaternion.RotationYawPitchRollToRef(yaw, pitch, roll, MathTmp.Quaternion[0]);
    MathTmp.Quaternion[0].toRotationMatrix(result);
    return result;
  }
  /**
   * Creates a scaling matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#107
   * @param x defines the scale factor on X axis
   * @param y defines the scale factor on Y axis
   * @param z defines the scale factor on Z axis
   * @returns the new matrix
   */
  static Scaling(x2, y2, z2) {
    const result = new Matrix();
    Matrix.ScalingToRef(x2, y2, z2, result);
    return result;
  }
  /**
   * Creates a scaling matrix and stores it in a given matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#108
   * @param x defines the scale factor on X axis
   * @param y defines the scale factor on Y axis
   * @param z defines the scale factor on Z axis
   * @param result defines the target matrix
   * @returns result input
   */
  static ScalingToRef(x2, y2, z2, result) {
    Matrix.FromValuesToRef(x2, 0, 0, 0, 0, y2, 0, 0, 0, 0, z2, 0, 0, 0, 0, 1, result);
    result._updateIdentityStatus(x2 === 1 && y2 === 1 && z2 === 1);
    return result;
  }
  /**
   * Creates a translation matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#109
   * @param x defines the translation on X axis
   * @param y defines the translation on Y axis
   * @param z defines the translationon Z axis
   * @returns the new matrix
   */
  static Translation(x2, y2, z2) {
    const result = new Matrix();
    Matrix.TranslationToRef(x2, y2, z2, result);
    return result;
  }
  /**
   * Creates a translation matrix and stores it in a given matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#110
   * @param x defines the translation on X axis
   * @param y defines the translation on Y axis
   * @param z defines the translationon Z axis
   * @param result defines the target matrix
   * @returns result input
   */
  static TranslationToRef(x2, y2, z2, result) {
    Matrix.FromValuesToRef(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, x2, y2, z2, 1, result);
    result._updateIdentityStatus(x2 === 0 && y2 === 0 && z2 === 0);
    return result;
  }
  /**
   * Returns a new Matrix whose values are the interpolated values for "gradient" (float) between the ones of the matrices "startValue" and "endValue".
   * Example Playground - https://playground.babylonjs.com/#AV9X17#55
   * @param startValue defines the start value
   * @param endValue defines the end value
   * @param gradient defines the gradient factor
   * @returns the new matrix
   */
  static Lerp(startValue, endValue, gradient) {
    const result = new Matrix();
    Matrix.LerpToRef(startValue, endValue, gradient, result);
    return result;
  }
  /**
   * Set the given matrix "result" as the interpolated values for "gradient" (float) between the ones of the matrices "startValue" and "endValue".
   * Example Playground - https://playground.babylonjs.com/#AV9X17#54
   * @param startValue defines the start value
   * @param endValue defines the end value
   * @param gradient defines the gradient factor
   * @param result defines the Matrix object where to store data
   * @returns result input
   */
  static LerpToRef(startValue, endValue, gradient, result) {
    const resultM = result._m;
    const startM = startValue.m;
    const endM = endValue.m;
    for (let index2 = 0; index2 < 16; index2++) {
      resultM[index2] = startM[index2] * (1 - gradient) + endM[index2] * gradient;
    }
    result.markAsUpdated();
    return result;
  }
  /**
   * Builds a new matrix whose values are computed by:
   * * decomposing the "startValue" and "endValue" matrices into their respective scale, rotation and translation matrices
   * * interpolating for "gradient" (float) the values between each of these decomposed matrices between the start and the end
   * * recomposing a new matrix from these 3 interpolated scale, rotation and translation matrices
   * Example Playground - https://playground.babylonjs.com/#AV9X17#22
   * Example Playground - https://playground.babylonjs.com/#AV9X17#51
   * @param startValue defines the first matrix
   * @param endValue defines the second matrix
   * @param gradient defines the gradient between the two matrices
   * @returns the new matrix
   */
  static DecomposeLerp(startValue, endValue, gradient) {
    const result = new Matrix();
    Matrix.DecomposeLerpToRef(startValue, endValue, gradient, result);
    return result;
  }
  /**
   * Update a matrix to values which are computed by:
   * * decomposing the "startValue" and "endValue" matrices into their respective scale, rotation and translation matrices
   * * interpolating for "gradient" (float) the values between each of these decomposed matrices between the start and the end
   * * recomposing a new matrix from these 3 interpolated scale, rotation and translation matrices
   * Example Playground - https://playground.babylonjs.com/#AV9X17#23
   * Example Playground - https://playground.babylonjs.com/#AV9X17#53
   * @param startValue defines the first matrix
   * @param endValue defines the second matrix
   * @param gradient defines the gradient between the two matrices
   * @param result defines the target matrix
   * @returns result input
   */
  static DecomposeLerpToRef(startValue, endValue, gradient, result) {
    const startScale = MathTmp.Vector3[0];
    const startRotation = MathTmp.Quaternion[0];
    const startTranslation = MathTmp.Vector3[1];
    startValue.decompose(startScale, startRotation, startTranslation);
    const endScale = MathTmp.Vector3[2];
    const endRotation = MathTmp.Quaternion[1];
    const endTranslation = MathTmp.Vector3[3];
    endValue.decompose(endScale, endRotation, endTranslation);
    const resultScale = MathTmp.Vector3[4];
    Vector3.LerpToRef(startScale, endScale, gradient, resultScale);
    const resultRotation = MathTmp.Quaternion[2];
    Quaternion.SlerpToRef(startRotation, endRotation, gradient, resultRotation);
    const resultTranslation = MathTmp.Vector3[5];
    Vector3.LerpToRef(startTranslation, endTranslation, gradient, resultTranslation);
    Matrix.ComposeToRef(resultScale, resultRotation, resultTranslation, result);
    return result;
  }
  /**
   * Creates a new matrix that transforms vertices from world space to camera space. It takes three vectors as arguments that together describe the position and orientation of the camera.
   * This function generates a matrix suitable for a left handed coordinate system
   * Example Playground - https://playground.babylonjs.com/#AV9X17#58
   * Example Playground - https://playground.babylonjs.com/#AV9X17#59
   * @param eye defines the final position of the entity
   * @param target defines where the entity should look at
   * @param up defines the up vector for the entity
   * @returns the new matrix
   */
  static LookAtLH(eye, target, up) {
    const result = new Matrix();
    Matrix.LookAtLHToRef(eye, target, up, result);
    return result;
  }
  /**
   * Sets the given "result" Matrix to a matrix that transforms vertices from world space to camera space. It takes three vectors as arguments that together describe the position and orientation of the camera.
   * This function generates a matrix suitable for a left handed coordinate system
   * Example Playground - https://playground.babylonjs.com/#AV9X17#60
   * Example Playground - https://playground.babylonjs.com/#AV9X17#61
   * @param eye defines the final position of the entity
   * @param target defines where the entity should look at
   * @param up defines the up vector for the entity
   * @param result defines the target matrix
   * @returns result input
   */
  static LookAtLHToRef(eye, target, up, result) {
    const xAxis = MathTmp.Vector3[0];
    const yAxis = MathTmp.Vector3[1];
    const zAxis = MathTmp.Vector3[2];
    target.subtractToRef(eye, zAxis);
    zAxis.normalize();
    Vector3.CrossToRef(up, zAxis, xAxis);
    const xSquareLength = xAxis.lengthSquared();
    if (xSquareLength === 0) {
      xAxis.x = 1;
    } else {
      xAxis.normalizeFromLength(Math.sqrt(xSquareLength));
    }
    Vector3.CrossToRef(zAxis, xAxis, yAxis);
    yAxis.normalize();
    const ex = -Vector3.Dot(xAxis, eye);
    const ey = -Vector3.Dot(yAxis, eye);
    const ez = -Vector3.Dot(zAxis, eye);
    Matrix.FromValuesToRef(xAxis._x, yAxis._x, zAxis._x, 0, xAxis._y, yAxis._y, zAxis._y, 0, xAxis._z, yAxis._z, zAxis._z, 0, ex, ey, ez, 1, result);
    return result;
  }
  /**
   * Creates a new matrix that transforms vertices from world space to camera space. It takes three vectors as arguments that together describe the position and orientation of the camera.
   * This function generates a matrix suitable for a right handed coordinate system
   * Example Playground - https://playground.babylonjs.com/#AV9X17#62
   * Example Playground - https://playground.babylonjs.com/#AV9X17#63
   * @param eye defines the final position of the entity
   * @param target defines where the entity should look at
   * @param up defines the up vector for the entity
   * @returns the new matrix
   */
  static LookAtRH(eye, target, up) {
    const result = new Matrix();
    Matrix.LookAtRHToRef(eye, target, up, result);
    return result;
  }
  /**
   * Sets the given "result" Matrix to a matrix that transforms vertices from world space to camera space. It takes three vectors as arguments that together describe the position and orientation of the camera.
   * This function generates a matrix suitable for a right handed coordinate system
   * Example Playground - https://playground.babylonjs.com/#AV9X17#64
   * Example Playground - https://playground.babylonjs.com/#AV9X17#65
   * @param eye defines the final position of the entity
   * @param target defines where the entity should look at
   * @param up defines the up vector for the entity
   * @param result defines the target matrix
   * @returns result input
   */
  static LookAtRHToRef(eye, target, up, result) {
    const xAxis = MathTmp.Vector3[0];
    const yAxis = MathTmp.Vector3[1];
    const zAxis = MathTmp.Vector3[2];
    eye.subtractToRef(target, zAxis);
    zAxis.normalize();
    Vector3.CrossToRef(up, zAxis, xAxis);
    const xSquareLength = xAxis.lengthSquared();
    if (xSquareLength === 0) {
      xAxis.x = 1;
    } else {
      xAxis.normalizeFromLength(Math.sqrt(xSquareLength));
    }
    Vector3.CrossToRef(zAxis, xAxis, yAxis);
    yAxis.normalize();
    const ex = -Vector3.Dot(xAxis, eye);
    const ey = -Vector3.Dot(yAxis, eye);
    const ez = -Vector3.Dot(zAxis, eye);
    Matrix.FromValuesToRef(xAxis._x, yAxis._x, zAxis._x, 0, xAxis._y, yAxis._y, zAxis._y, 0, xAxis._z, yAxis._z, zAxis._z, 0, ex, ey, ez, 1, result);
    return result;
  }
  /**
   * Creates a new matrix that transforms vertices from world space to camera space. It takes two vectors as arguments that together describe the orientation of the camera. The position is assumed to be at the origin (0,0,0)
   * This function generates a matrix suitable for a left handed coordinate system
   * Example Playground - https://playground.babylonjs.com/#AV9X17#66
   * @param forward defines the forward direction - Must be normalized and orthogonal to up.
   * @param up defines the up vector for the entity - Must be normalized and orthogonal to forward.
   * @returns the new matrix
   */
  static LookDirectionLH(forward, up) {
    const result = new Matrix();
    Matrix.LookDirectionLHToRef(forward, up, result);
    return result;
  }
  /**
   * Sets the given "result" Matrix to a matrix that transforms vertices from world space to camera space. It takes two vectors as arguments that together describe the orientation of the camera. The position is assumed to be at the origin (0,0,0)
   * This function generates a matrix suitable for a left handed coordinate system
   * Example Playground - https://playground.babylonjs.com/#AV9X17#67
   * @param forward defines the forward direction - Must be normalized and orthogonal to up.
   * @param up defines the up vector for the entity - Must be normalized and orthogonal to forward.
   * @param result defines the target matrix
   * @returns result input
   */
  static LookDirectionLHToRef(forward, up, result) {
    const back = MathTmp.Vector3[0];
    back.copyFrom(forward);
    back.scaleInPlace(-1);
    const left = MathTmp.Vector3[1];
    Vector3.CrossToRef(up, back, left);
    Matrix.FromValuesToRef(left._x, left._y, left._z, 0, up._x, up._y, up._z, 0, back._x, back._y, back._z, 0, 0, 0, 0, 1, result);
    return result;
  }
  /**
   * Creates a new matrix that transforms vertices from world space to camera space. It takes two vectors as arguments that together describe the orientation of the camera. The position is assumed to be at the origin (0,0,0)
   * This function generates a matrix suitable for a right handed coordinate system
   * Example Playground - https://playground.babylonjs.com/#AV9X17#68
   * @param forward defines the forward direction - Must be normalized and orthogonal to up.
   * @param up defines the up vector for the entity - Must be normalized and orthogonal to forward.
   * @returns the new matrix
   */
  static LookDirectionRH(forward, up) {
    const result = new Matrix();
    Matrix.LookDirectionRHToRef(forward, up, result);
    return result;
  }
  /**
   * Sets the given "result" Matrix to a matrix that transforms vertices from world space to camera space. It takes two vectors as arguments that together describe the orientation of the camera. The position is assumed to be at the origin (0,0,0)
   * This function generates a matrix suitable for a right handed coordinate system
   * Example Playground - https://playground.babylonjs.com/#AV9X17#69
   * @param forward defines the forward direction - Must be normalized and orthogonal to up.
   * @param up defines the up vector for the entity - Must be normalized and orthogonal to forward.
   * @param result defines the target matrix
   * @returns result input
   */
  static LookDirectionRHToRef(forward, up, result) {
    const right = MathTmp.Vector3[2];
    Vector3.CrossToRef(up, forward, right);
    Matrix.FromValuesToRef(right._x, right._y, right._z, 0, up._x, up._y, up._z, 0, forward._x, forward._y, forward._z, 0, 0, 0, 0, 1, result);
    return result;
  }
  /**
   * Create a left-handed orthographic projection matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#70
   * @param width defines the viewport width
   * @param height defines the viewport height
   * @param znear defines the near clip plane
   * @param zfar defines the far clip plane
   * @param halfZRange true to generate NDC coordinates between 0 and 1 instead of -1 and 1 (default: false)
   * @returns a new matrix as a left-handed orthographic projection matrix
   */
  static OrthoLH(width, height, znear, zfar, halfZRange) {
    const matrix = new Matrix();
    Matrix.OrthoLHToRef(width, height, znear, zfar, matrix, halfZRange);
    return matrix;
  }
  /**
   * Store a left-handed orthographic projection to a given matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#71
   * @param width defines the viewport width
   * @param height defines the viewport height
   * @param znear defines the near clip plane
   * @param zfar defines the far clip plane
   * @param result defines the target matrix
   * @param halfZRange true to generate NDC coordinates between 0 and 1 instead of -1 and 1 (default: false)
   * @returns result input
   */
  static OrthoLHToRef(width, height, znear, zfar, result, halfZRange) {
    const n3 = znear;
    const f2 = zfar;
    const a2 = 2 / width;
    const b2 = 2 / height;
    const c2 = 2 / (f2 - n3);
    const d2 = -(f2 + n3) / (f2 - n3);
    Matrix.FromValuesToRef(a2, 0, 0, 0, 0, b2, 0, 0, 0, 0, c2, 0, 0, 0, d2, 1, result);
    if (halfZRange) {
      result.multiplyToRef(mtxConvertNDCToHalfZRange, result);
    }
    result._updateIdentityStatus(a2 === 1 && b2 === 1 && c2 === 1 && d2 === 0);
    return result;
  }
  /**
   * Create a left-handed orthographic projection matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#72
   * @param left defines the viewport left coordinate
   * @param right defines the viewport right coordinate
   * @param bottom defines the viewport bottom coordinate
   * @param top defines the viewport top coordinate
   * @param znear defines the near clip plane
   * @param zfar defines the far clip plane
   * @param halfZRange true to generate NDC coordinates between 0 and 1 instead of -1 and 1 (default: false)
   * @returns a new matrix as a left-handed orthographic projection matrix
   */
  static OrthoOffCenterLH(left, right, bottom, top, znear, zfar, halfZRange) {
    const matrix = new Matrix();
    Matrix.OrthoOffCenterLHToRef(left, right, bottom, top, znear, zfar, matrix, halfZRange);
    return matrix;
  }
  /**
   * Stores a left-handed orthographic projection into a given matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#73
   * @param left defines the viewport left coordinate
   * @param right defines the viewport right coordinate
   * @param bottom defines the viewport bottom coordinate
   * @param top defines the viewport top coordinate
   * @param znear defines the near clip plane
   * @param zfar defines the far clip plane
   * @param result defines the target matrix
   * @param halfZRange true to generate NDC coordinates between 0 and 1 instead of -1 and 1 (default: false)
   * @returns result input
   */
  static OrthoOffCenterLHToRef(left, right, bottom, top, znear, zfar, result, halfZRange) {
    const n3 = znear;
    const f2 = zfar;
    const a2 = 2 / (right - left);
    const b2 = 2 / (top - bottom);
    const c2 = 2 / (f2 - n3);
    const d2 = -(f2 + n3) / (f2 - n3);
    const i0 = (left + right) / (left - right);
    const i1 = (top + bottom) / (bottom - top);
    Matrix.FromValuesToRef(a2, 0, 0, 0, 0, b2, 0, 0, 0, 0, c2, 0, i0, i1, d2, 1, result);
    if (halfZRange) {
      result.multiplyToRef(mtxConvertNDCToHalfZRange, result);
    }
    result.markAsUpdated();
    return result;
  }
  /**
   * Stores a left-handed oblique projection into a given matrix
   * @param left defines the viewport left coordinate
   * @param right defines the viewport right coordinate
   * @param bottom defines the viewport bottom coordinate
   * @param top defines the viewport top coordinate
   * @param znear defines the near clip plane
   * @param zfar defines the far clip plane
   * @param length Length of the shear
   * @param angle Angle (along X/Y Plane) to apply shear
   * @param distance Distance from shear point
   * @param result defines the target matrix
   * @param halfZRange true to generate NDC coordinates between 0 and 1 instead of -1 and 1 (default: false)
   * @returns result input
   */
  static ObliqueOffCenterLHToRef(left, right, bottom, top, znear, zfar, length, angle, distance, result, halfZRange) {
    const a2 = -length * Math.cos(angle);
    const b2 = -length * Math.sin(angle);
    Matrix.TranslationToRef(0, 0, -distance, MathTmp.Matrix[1]);
    Matrix.FromValuesToRef(1, 0, 0, 0, 0, 1, 0, 0, a2, b2, 1, 0, 0, 0, 0, 1, MathTmp.Matrix[0]);
    MathTmp.Matrix[1].multiplyToRef(MathTmp.Matrix[0], MathTmp.Matrix[0]);
    Matrix.TranslationToRef(0, 0, distance, MathTmp.Matrix[1]);
    MathTmp.Matrix[0].multiplyToRef(MathTmp.Matrix[1], MathTmp.Matrix[0]);
    Matrix.OrthoOffCenterLHToRef(left, right, bottom, top, znear, zfar, result, halfZRange);
    MathTmp.Matrix[0].multiplyToRef(result, result);
    return result;
  }
  /**
   * Creates a right-handed orthographic projection matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#76
   * @param left defines the viewport left coordinate
   * @param right defines the viewport right coordinate
   * @param bottom defines the viewport bottom coordinate
   * @param top defines the viewport top coordinate
   * @param znear defines the near clip plane
   * @param zfar defines the far clip plane
   * @param halfZRange true to generate NDC coordinates between 0 and 1 instead of -1 and 1 (default: false)
   * @returns a new matrix as a right-handed orthographic projection matrix
   */
  static OrthoOffCenterRH(left, right, bottom, top, znear, zfar, halfZRange) {
    const matrix = new Matrix();
    Matrix.OrthoOffCenterRHToRef(left, right, bottom, top, znear, zfar, matrix, halfZRange);
    return matrix;
  }
  /**
   * Stores a right-handed orthographic projection into a given matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#77
   * @param left defines the viewport left coordinate
   * @param right defines the viewport right coordinate
   * @param bottom defines the viewport bottom coordinate
   * @param top defines the viewport top coordinate
   * @param znear defines the near clip plane
   * @param zfar defines the far clip plane
   * @param result defines the target matrix
   * @param halfZRange true to generate NDC coordinates between 0 and 1 instead of -1 and 1 (default: false)
   * @returns result input
   */
  static OrthoOffCenterRHToRef(left, right, bottom, top, znear, zfar, result, halfZRange) {
    Matrix.OrthoOffCenterLHToRef(left, right, bottom, top, znear, zfar, result, halfZRange);
    result._m[10] *= -1;
    return result;
  }
  /**
   * Stores a right-handed oblique projection into a given matrix
   * @param left defines the viewport left coordinate
   * @param right defines the viewport right coordinate
   * @param bottom defines the viewport bottom coordinate
   * @param top defines the viewport top coordinate
   * @param znear defines the near clip plane
   * @param zfar defines the far clip plane
   * @param length Length of the shear
   * @param angle Angle (along X/Y Plane) to apply shear
   * @param distance Distance from shear point
   * @param result defines the target matrix
   * @param halfZRange true to generate NDC coordinates between 0 and 1 instead of -1 and 1 (default: false)
   * @returns result input
   */
  static ObliqueOffCenterRHToRef(left, right, bottom, top, znear, zfar, length, angle, distance, result, halfZRange) {
    const a2 = length * Math.cos(angle);
    const b2 = length * Math.sin(angle);
    Matrix.TranslationToRef(0, 0, distance, MathTmp.Matrix[1]);
    Matrix.FromValuesToRef(1, 0, 0, 0, 0, 1, 0, 0, a2, b2, 1, 0, 0, 0, 0, 1, MathTmp.Matrix[0]);
    MathTmp.Matrix[1].multiplyToRef(MathTmp.Matrix[0], MathTmp.Matrix[0]);
    Matrix.TranslationToRef(0, 0, -distance, MathTmp.Matrix[1]);
    MathTmp.Matrix[0].multiplyToRef(MathTmp.Matrix[1], MathTmp.Matrix[0]);
    Matrix.OrthoOffCenterRHToRef(left, right, bottom, top, znear, zfar, result, halfZRange);
    MathTmp.Matrix[0].multiplyToRef(result, result);
    return result;
  }
  /**
   * Creates a left-handed perspective projection matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#85
   * @param width defines the viewport width
   * @param height defines the viewport height
   * @param znear defines the near clip plane
   * @param zfar defines the far clip plane
   * @param halfZRange true to generate NDC coordinates between 0 and 1 instead of -1 and 1 (default: false)
   * @param projectionPlaneTilt optional tilt angle of the projection plane around the X axis (horizontal)
   * @returns a new matrix as a left-handed perspective projection matrix
   */
  static PerspectiveLH(width, height, znear, zfar, halfZRange, projectionPlaneTilt = 0) {
    const matrix = new Matrix();
    const n3 = znear;
    const f2 = zfar;
    const a2 = 2 * n3 / width;
    const b2 = 2 * n3 / height;
    const c2 = (f2 + n3) / (f2 - n3);
    const d2 = -2 * f2 * n3 / (f2 - n3);
    const rot = Math.tan(projectionPlaneTilt);
    Matrix.FromValuesToRef(a2, 0, 0, 0, 0, b2, 0, rot, 0, 0, c2, 1, 0, 0, d2, 0, matrix);
    if (halfZRange) {
      matrix.multiplyToRef(mtxConvertNDCToHalfZRange, matrix);
    }
    matrix._updateIdentityStatus(false);
    return matrix;
  }
  /**
   * Creates a left-handed perspective projection matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#78
   * @param fov defines the horizontal field of view
   * @param aspect defines the aspect ratio
   * @param znear defines the near clip plane
   * @param zfar defines the far clip plane. If 0, assume we are in "infinite zfar" mode
   * @param halfZRange true to generate NDC coordinates between 0 and 1 instead of -1 and 1 (default: false)
   * @param projectionPlaneTilt optional tilt angle of the projection plane around the X axis (horizontal)
   * @param reverseDepthBufferMode true to indicate that we are in a reverse depth buffer mode (meaning znear and zfar have been inverted when calling the function)
   * @returns a new matrix as a left-handed perspective projection matrix
   */
  static PerspectiveFovLH(fov, aspect, znear, zfar, halfZRange, projectionPlaneTilt = 0, reverseDepthBufferMode = false) {
    const matrix = new Matrix();
    Matrix.PerspectiveFovLHToRef(fov, aspect, znear, zfar, matrix, true, halfZRange, projectionPlaneTilt, reverseDepthBufferMode);
    return matrix;
  }
  /**
   * Stores a left-handed perspective projection into a given matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#81
   * @param fov defines the horizontal field of view
   * @param aspect defines the aspect ratio
   * @param znear defines the near clip plane
   * @param zfar defines the far clip plane. If 0, assume we are in "infinite zfar" mode
   * @param result defines the target matrix
   * @param isVerticalFovFixed defines it the fov is vertically fixed (default) or horizontally
   * @param halfZRange true to generate NDC coordinates between 0 and 1 instead of -1 and 1 (default: false)
   * @param projectionPlaneTilt optional tilt angle of the projection plane around the X axis (horizontal)
   * @param reverseDepthBufferMode true to indicate that we are in a reverse depth buffer mode (meaning znear and zfar have been inverted when calling the function)
   * @returns result input
   */
  static PerspectiveFovLHToRef(fov, aspect, znear, zfar, result, isVerticalFovFixed = true, halfZRange, projectionPlaneTilt = 0, reverseDepthBufferMode = false) {
    const n3 = znear;
    const f2 = zfar;
    const t2 = 1 / Math.tan(fov * 0.5);
    const a2 = isVerticalFovFixed ? t2 / aspect : t2;
    const b2 = isVerticalFovFixed ? t2 : t2 * aspect;
    const c2 = reverseDepthBufferMode && n3 === 0 ? -1 : f2 !== 0 ? (f2 + n3) / (f2 - n3) : 1;
    const d2 = reverseDepthBufferMode && n3 === 0 ? 2 * f2 : f2 !== 0 ? -2 * f2 * n3 / (f2 - n3) : -2 * n3;
    const rot = Math.tan(projectionPlaneTilt);
    Matrix.FromValuesToRef(a2, 0, 0, 0, 0, b2, 0, rot, 0, 0, c2, 1, 0, 0, d2, 0, result);
    if (halfZRange) {
      result.multiplyToRef(mtxConvertNDCToHalfZRange, result);
    }
    result._updateIdentityStatus(false);
    return result;
  }
  /**
   * Stores a left-handed perspective projection into a given matrix with depth reversed
   * Example Playground - https://playground.babylonjs.com/#AV9X17#89
   * @param fov defines the horizontal field of view
   * @param aspect defines the aspect ratio
   * @param znear defines the near clip plane
   * @param zfar not used as infinity is used as far clip
   * @param result defines the target matrix
   * @param isVerticalFovFixed defines it the fov is vertically fixed (default) or horizontally
   * @param halfZRange true to generate NDC coordinates between 0 and 1 instead of -1 and 1 (default: false)
   * @param projectionPlaneTilt optional tilt angle of the projection plane around the X axis (horizontal)
   * @returns result input
   */
  static PerspectiveFovReverseLHToRef(fov, aspect, znear, zfar, result, isVerticalFovFixed = true, halfZRange, projectionPlaneTilt = 0) {
    const t2 = 1 / Math.tan(fov * 0.5);
    const a2 = isVerticalFovFixed ? t2 / aspect : t2;
    const b2 = isVerticalFovFixed ? t2 : t2 * aspect;
    const rot = Math.tan(projectionPlaneTilt);
    Matrix.FromValuesToRef(a2, 0, 0, 0, 0, b2, 0, rot, 0, 0, -znear, 1, 0, 0, 1, 0, result);
    if (halfZRange) {
      result.multiplyToRef(mtxConvertNDCToHalfZRange, result);
    }
    result._updateIdentityStatus(false);
    return result;
  }
  /**
   * Creates a right-handed perspective projection matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#83
   * @param fov defines the horizontal field of view
   * @param aspect defines the aspect ratio
   * @param znear defines the near clip plane
   * @param zfar defines the far clip plane. If 0, assume we are in "infinite zfar" mode
   * @param halfZRange true to generate NDC coordinates between 0 and 1 instead of -1 and 1 (default: false)
   * @param projectionPlaneTilt optional tilt angle of the projection plane around the X axis (horizontal)
   * @param reverseDepthBufferMode true to indicate that we are in a reverse depth buffer mode (meaning znear and zfar have been inverted when calling the function)
   * @returns a new matrix as a right-handed perspective projection matrix
   */
  static PerspectiveFovRH(fov, aspect, znear, zfar, halfZRange, projectionPlaneTilt = 0, reverseDepthBufferMode = false) {
    const matrix = new Matrix();
    Matrix.PerspectiveFovRHToRef(fov, aspect, znear, zfar, matrix, true, halfZRange, projectionPlaneTilt, reverseDepthBufferMode);
    return matrix;
  }
  /**
   * Stores a right-handed perspective projection into a given matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#84
   * @param fov defines the horizontal field of view
   * @param aspect defines the aspect ratio
   * @param znear defines the near clip plane
   * @param zfar defines the far clip plane. If 0, assume we are in "infinite zfar" mode
   * @param result defines the target matrix
   * @param isVerticalFovFixed defines it the fov is vertically fixed (default) or horizontally
   * @param halfZRange true to generate NDC coordinates between 0 and 1 instead of -1 and 1 (default: false)
   * @param projectionPlaneTilt optional tilt angle of the projection plane around the X axis (horizontal)
   * @param reverseDepthBufferMode true to indicate that we are in a reverse depth buffer mode (meaning znear and zfar have been inverted when calling the function)
   * @returns result input
   */
  static PerspectiveFovRHToRef(fov, aspect, znear, zfar, result, isVerticalFovFixed = true, halfZRange, projectionPlaneTilt = 0, reverseDepthBufferMode = false) {
    const n3 = znear;
    const f2 = zfar;
    const t2 = 1 / Math.tan(fov * 0.5);
    const a2 = isVerticalFovFixed ? t2 / aspect : t2;
    const b2 = isVerticalFovFixed ? t2 : t2 * aspect;
    const c2 = reverseDepthBufferMode && n3 === 0 ? 1 : f2 !== 0 ? -(f2 + n3) / (f2 - n3) : -1;
    const d2 = reverseDepthBufferMode && n3 === 0 ? 2 * f2 : f2 !== 0 ? -2 * f2 * n3 / (f2 - n3) : -2 * n3;
    const rot = Math.tan(projectionPlaneTilt);
    Matrix.FromValuesToRef(a2, 0, 0, 0, 0, b2, 0, rot, 0, 0, c2, -1, 0, 0, d2, 0, result);
    if (halfZRange) {
      result.multiplyToRef(mtxConvertNDCToHalfZRange, result);
    }
    result._updateIdentityStatus(false);
    return result;
  }
  /**
   * Stores a right-handed perspective projection into a given matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#90
   * @param fov defines the horizontal field of view
   * @param aspect defines the aspect ratio
   * @param znear defines the near clip plane
   * @param zfar not used as infinity is used as far clip
   * @param result defines the target matrix
   * @param isVerticalFovFixed defines it the fov is vertically fixed (default) or horizontally
   * @param halfZRange true to generate NDC coordinates between 0 and 1 instead of -1 and 1 (default: false)
   * @param projectionPlaneTilt optional tilt angle of the projection plane around the X axis (horizontal)
   * @returns result input
   */
  static PerspectiveFovReverseRHToRef(fov, aspect, znear, zfar, result, isVerticalFovFixed = true, halfZRange, projectionPlaneTilt = 0) {
    const t2 = 1 / Math.tan(fov * 0.5);
    const a2 = isVerticalFovFixed ? t2 / aspect : t2;
    const b2 = isVerticalFovFixed ? t2 : t2 * aspect;
    const rot = Math.tan(projectionPlaneTilt);
    Matrix.FromValuesToRef(a2, 0, 0, 0, 0, b2, 0, rot, 0, 0, -znear, -1, 0, 0, -1, 0, result);
    if (halfZRange) {
      result.multiplyToRef(mtxConvertNDCToHalfZRange, result);
    }
    result._updateIdentityStatus(false);
    return result;
  }
  /**
   * Computes a complete transformation matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#113
   * @param viewport defines the viewport to use
   * @param world defines the world matrix
   * @param view defines the view matrix
   * @param projection defines the projection matrix
   * @param zmin defines the near clip plane
   * @param zmax defines the far clip plane
   * @returns the transformation matrix
   */
  static GetFinalMatrix(viewport, world, view, projection, zmin, zmax) {
    const cw = viewport.width;
    const ch = viewport.height;
    const cx = viewport.x;
    const cy = viewport.y;
    const viewportMatrix = Matrix.FromValues(cw / 2, 0, 0, 0, 0, -ch / 2, 0, 0, 0, 0, zmax - zmin, 0, cx + cw / 2, ch / 2 + cy, zmin, 1);
    const matrix = new Matrix();
    world.multiplyToRef(view, matrix);
    matrix.multiplyToRef(projection, matrix);
    return matrix.multiplyToRef(viewportMatrix, matrix);
  }
  /**
   * Extracts a 2x2 matrix from a given matrix and store the result in a Float32Array
   * @param matrix defines the matrix to use
   * @returns a new Float32Array array with 4 elements : the 2x2 matrix extracted from the given matrix
   */
  static GetAsMatrix2x2(matrix) {
    const m2 = matrix.m;
    const arr = [m2[0], m2[1], m2[4], m2[5]];
    return PerformanceConfigurator.MatrixUse64Bits ? arr : new Float32Array(arr);
  }
  /**
   * Extracts a 3x3 matrix from a given matrix and store the result in a Float32Array
   * @param matrix defines the matrix to use
   * @returns a new Float32Array array with 9 elements : the 3x3 matrix extracted from the given matrix
   */
  static GetAsMatrix3x3(matrix) {
    const m2 = matrix.m;
    const arr = [m2[0], m2[1], m2[2], m2[4], m2[5], m2[6], m2[8], m2[9], m2[10]];
    return PerformanceConfigurator.MatrixUse64Bits ? arr : new Float32Array(arr);
  }
  /**
   * Compute the transpose of a given matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#111
   * @param matrix defines the matrix to transpose
   * @returns the new matrix
   */
  static Transpose(matrix) {
    const result = new Matrix();
    Matrix.TransposeToRef(matrix, result);
    return result;
  }
  /**
   * Compute the transpose of a matrix and store it in a target matrix
   * Example Playground - https://playground.babylonjs.com/#AV9X17#112
   * @param matrix defines the matrix to transpose
   * @param result defines the target matrix
   * @returns result input
   */
  static TransposeToRef(matrix, result) {
    const mm = matrix.m;
    const rm0 = mm[0];
    const rm1 = mm[4];
    const rm2 = mm[8];
    const rm3 = mm[12];
    const rm4 = mm[1];
    const rm5 = mm[5];
    const rm6 = mm[9];
    const rm7 = mm[13];
    const rm8 = mm[2];
    const rm9 = mm[6];
    const rm10 = mm[10];
    const rm11 = mm[14];
    const rm12 = mm[3];
    const rm13 = mm[7];
    const rm14 = mm[11];
    const rm15 = mm[15];
    const rm = result._m;
    rm[0] = rm0;
    rm[1] = rm1;
    rm[2] = rm2;
    rm[3] = rm3;
    rm[4] = rm4;
    rm[5] = rm5;
    rm[6] = rm6;
    rm[7] = rm7;
    rm[8] = rm8;
    rm[9] = rm9;
    rm[10] = rm10;
    rm[11] = rm11;
    rm[12] = rm12;
    rm[13] = rm13;
    rm[14] = rm14;
    rm[15] = rm15;
    result.markAsUpdated();
    result._updateIdentityStatus(matrix._isIdentity, matrix._isIdentityDirty);
    return result;
  }
  /**
   * Computes a reflection matrix from a plane
   * Example Playground - https://playground.babylonjs.com/#AV9X17#87
   * @param plane defines the reflection plane
   * @returns a new matrix
   */
  static Reflection(plane) {
    const matrix = new Matrix();
    Matrix.ReflectionToRef(plane, matrix);
    return matrix;
  }
  /**
   * Computes a reflection matrix from a plane
   * Example Playground - https://playground.babylonjs.com/#AV9X17#88
   * @param plane defines the reflection plane
   * @param result defines the target matrix
   * @returns result input
   */
  static ReflectionToRef(plane, result) {
    plane.normalize();
    const x2 = plane.normal.x;
    const y2 = plane.normal.y;
    const z2 = plane.normal.z;
    const temp = -2 * x2;
    const temp2 = -2 * y2;
    const temp3 = -2 * z2;
    Matrix.FromValuesToRef(temp * x2 + 1, temp2 * x2, temp3 * x2, 0, temp * y2, temp2 * y2 + 1, temp3 * y2, 0, temp * z2, temp2 * z2, temp3 * z2 + 1, 0, temp * plane.d, temp2 * plane.d, temp3 * plane.d, 1, result);
    return result;
  }
  /**
   * Sets the given matrix as a rotation matrix composed from the 3 left handed axes
   * @param xaxis defines the value of the 1st axis
   * @param yaxis defines the value of the 2nd axis
   * @param zaxis defines the value of the 3rd axis
   * @param result defines the target matrix
   * @returns result input
   */
  static FromXYZAxesToRef(xaxis, yaxis, zaxis, result) {
    Matrix.FromValuesToRef(xaxis._x, xaxis._y, xaxis._z, 0, yaxis._x, yaxis._y, yaxis._z, 0, zaxis._x, zaxis._y, zaxis._z, 0, 0, 0, 0, 1, result);
    return result;
  }
  /**
   * Creates a rotation matrix from a quaternion and stores it in a target matrix
   * @param quat defines the quaternion to use
   * @param result defines the target matrix
   * @returns result input
   */
  static FromQuaternionToRef(quat, result) {
    const xx = quat._x * quat._x;
    const yy = quat._y * quat._y;
    const zz = quat._z * quat._z;
    const xy = quat._x * quat._y;
    const zw = quat._z * quat._w;
    const zx = quat._z * quat._x;
    const yw = quat._y * quat._w;
    const yz = quat._y * quat._z;
    const xw = quat._x * quat._w;
    result._m[0] = 1 - 2 * (yy + zz);
    result._m[1] = 2 * (xy + zw);
    result._m[2] = 2 * (zx - yw);
    result._m[3] = 0;
    result._m[4] = 2 * (xy - zw);
    result._m[5] = 1 - 2 * (zz + xx);
    result._m[6] = 2 * (yz + xw);
    result._m[7] = 0;
    result._m[8] = 2 * (zx + yw);
    result._m[9] = 2 * (yz - xw);
    result._m[10] = 1 - 2 * (yy + xx);
    result._m[11] = 0;
    result._m[12] = 0;
    result._m[13] = 0;
    result._m[14] = 0;
    result._m[15] = 1;
    result.markAsUpdated();
    return result;
  }
}
Matrix._UpdateFlagSeed = 0;
Matrix._IdentityReadOnly = Matrix.Identity();
Object.defineProperties(Matrix.prototype, {
  dimension: { value: [4, 4] },
  rank: { value: 2 }
});
class MathTmp {
}
MathTmp.Vector3 = BuildTuple(11, Vector3.Zero);
MathTmp.Matrix = BuildTuple(2, Matrix.Identity);
MathTmp.Quaternion = BuildTuple(3, Quaternion.Zero);
class TmpVectors {
}
TmpVectors.Vector2 = BuildTuple(3, Vector2.Zero);
TmpVectors.Vector3 = BuildTuple(13, Vector3.Zero);
TmpVectors.Vector4 = BuildTuple(3, Vector4.Zero);
TmpVectors.Quaternion = BuildTuple(3, Quaternion.Zero);
TmpVectors.Matrix = BuildTuple(8, Matrix.Identity);
RegisterClass("BABYLON.Vector2", Vector2);
RegisterClass("BABYLON.Vector3", Vector3);
RegisterClass("BABYLON.Vector4", Vector4);
RegisterClass("BABYLON.Matrix", Matrix);
const mtxConvertNDCToHalfZRange = Matrix.FromValues(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0.5, 0, 0, 0, 0.5, 1);
const warnedMap = {};
function _WarnImport(name2, warnOnce = false) {
  if (warnOnce && warnedMap[name2]) {
    return;
  }
  warnedMap[name2] = true;
  return `${name2} needs to be imported before as it contains a side-effect required by your code.`;
}
class AndOrNotEvaluator {
  /**
   * Evaluate a query
   * @param query defines the query to evaluate
   * @param evaluateCallback defines the callback used to filter result
   * @returns true if the query matches
   */
  static Eval(query, evaluateCallback) {
    if (!query.match(/\([^()]*\)/g)) {
      query = AndOrNotEvaluator._HandleParenthesisContent(query, evaluateCallback);
    } else {
      query = query.replace(/\([^()]*\)/g, (r3) => {
        r3 = r3.slice(1, r3.length - 1);
        return AndOrNotEvaluator._HandleParenthesisContent(r3, evaluateCallback);
      });
    }
    if (query === "true") {
      return true;
    }
    if (query === "false") {
      return false;
    }
    return AndOrNotEvaluator.Eval(query, evaluateCallback);
  }
  static _HandleParenthesisContent(parenthesisContent, evaluateCallback) {
    evaluateCallback = evaluateCallback || ((r3) => {
      return r3 === "true" ? true : false;
    });
    let result;
    const or = parenthesisContent.split("||");
    for (const i2 in or) {
      if (Object.prototype.hasOwnProperty.call(or, i2)) {
        let ori = AndOrNotEvaluator._SimplifyNegation(or[i2].trim());
        const and = ori.split("&&");
        if (and.length > 1) {
          for (let j2 = 0; j2 < and.length; ++j2) {
            const andj = AndOrNotEvaluator._SimplifyNegation(and[j2].trim());
            if (andj !== "true" && andj !== "false") {
              if (andj[0] === "!") {
                result = !evaluateCallback(andj.substring(1));
              } else {
                result = evaluateCallback(andj);
              }
            } else {
              result = andj === "true" ? true : false;
            }
            if (!result) {
              ori = "false";
              break;
            }
          }
        }
        if (result || ori === "true") {
          result = true;
          break;
        }
        if (ori !== "true" && ori !== "false") {
          if (ori[0] === "!") {
            result = !evaluateCallback(ori.substring(1));
          } else {
            result = evaluateCallback(ori);
          }
        } else {
          result = ori === "true" ? true : false;
        }
      }
    }
    return result ? "true" : "false";
  }
  static _SimplifyNegation(booleanString) {
    booleanString = booleanString.replace(/^[\s!]+/, (r3) => {
      r3 = r3.replace(/[\s]/g, () => "");
      return r3.length % 2 ? "!" : "";
    });
    booleanString = booleanString.trim();
    if (booleanString === "!true") {
      booleanString = "false";
    } else if (booleanString === "!false") {
      booleanString = "true";
    }
    return booleanString;
  }
}
class Tags {
  /**
   * Adds support for tags on the given object
   * @param obj defines the object to use
   */
  static EnableFor(obj) {
    obj._tags = obj._tags || {};
    obj.hasTags = () => {
      return Tags.HasTags(obj);
    };
    obj.addTags = (tagsString) => {
      return Tags.AddTagsTo(obj, tagsString);
    };
    obj.removeTags = (tagsString) => {
      return Tags.RemoveTagsFrom(obj, tagsString);
    };
    obj.matchesTagsQuery = (tagsQuery) => {
      return Tags.MatchesQuery(obj, tagsQuery);
    };
  }
  /**
   * Removes tags support
   * @param obj defines the object to use
   */
  static DisableFor(obj) {
    delete obj._tags;
    delete obj.hasTags;
    delete obj.addTags;
    delete obj.removeTags;
    delete obj.matchesTagsQuery;
  }
  /**
   * Gets a boolean indicating if the given object has tags
   * @param obj defines the object to use
   * @returns a boolean
   */
  static HasTags(obj) {
    if (!obj._tags) {
      return false;
    }
    const tags = obj._tags;
    for (const i2 in tags) {
      if (Object.prototype.hasOwnProperty.call(tags, i2)) {
        return true;
      }
    }
    return false;
  }
  /**
   * Gets the tags available on a given object
   * @param obj defines the object to use
   * @param asString defines if the tags must be returned as a string instead of an array of strings
   * @returns the tags
   */
  static GetTags(obj, asString = true) {
    if (!obj._tags) {
      return null;
    }
    if (asString) {
      const tagsArray = [];
      for (const tag in obj._tags) {
        if (Object.prototype.hasOwnProperty.call(obj._tags, tag) && obj._tags[tag] === true) {
          tagsArray.push(tag);
        }
      }
      return tagsArray.join(" ");
    } else {
      return obj._tags;
    }
  }
  /**
   * Adds tags to an object
   * @param obj defines the object to use
   * @param tagsString defines the tag string. The tags 'true' and 'false' are reserved and cannot be used as tags.
   * A tag cannot start with '||', '&&', and '!'. It cannot contain whitespaces
   */
  static AddTagsTo(obj, tagsString) {
    if (!tagsString) {
      return;
    }
    if (typeof tagsString !== "string") {
      return;
    }
    const tags = tagsString.split(" ");
    tags.forEach(function(tag) {
      Tags._AddTagTo(obj, tag);
    });
  }
  /**
   * @internal
   */
  static _AddTagTo(obj, tag) {
    tag = tag.trim();
    if (tag === "" || tag === "true" || tag === "false") {
      return;
    }
    if (tag.match(/[\s]/) || tag.match(/^([!]|([|]|[&]){2})/)) {
      return;
    }
    Tags.EnableFor(obj);
    obj._tags[tag] = true;
  }
  /**
   * Removes specific tags from a specific object
   * @param obj defines the object to use
   * @param tagsString defines the tags to remove
   */
  static RemoveTagsFrom(obj, tagsString) {
    if (!Tags.HasTags(obj)) {
      return;
    }
    const tags = tagsString.split(" ");
    for (const t2 in tags) {
      Tags._RemoveTagFrom(obj, tags[t2]);
    }
  }
  /**
   * @internal
   */
  static _RemoveTagFrom(obj, tag) {
    delete obj._tags[tag];
  }
  /**
   * Defines if tags hosted on an object match a given query
   * @param obj defines the object to use
   * @param tagsQuery defines the tag query
   * @returns a boolean
   */
  static MatchesQuery(obj, tagsQuery) {
    if (tagsQuery === void 0) {
      return true;
    }
    if (tagsQuery === "") {
      return Tags.HasTags(obj);
    }
    return AndOrNotEvaluator.Eval(tagsQuery, (r3) => Tags.HasTags(obj) && obj._tags[r3]);
  }
}
function colorChannelToLinearSpace(color) {
  return Math.pow(color, ToLinearSpace);
}
function colorChannelToLinearSpaceExact(color) {
  if (color <= 0.04045) {
    return 0.0773993808 * color;
  }
  return Math.pow(0.947867299 * (color + 0.055), 2.4);
}
function colorChannelToGammaSpace(color) {
  return Math.pow(color, ToGammaSpace);
}
function colorChannelToGammaSpaceExact(color) {
  if (color <= 31308e-7) {
    return 12.92 * color;
  }
  return 1.055 * Math.pow(color, 0.41666) - 0.055;
}
class Color3 {
  /**
   * Creates a new Color3 object from red, green, blue values, all between 0 and 1
   * @param r defines the red component (between 0 and 1, default is 0)
   * @param g defines the green component (between 0 and 1, default is 0)
   * @param b defines the blue component (between 0 and 1, default is 0)
   */
  constructor(r3 = 0, g2 = 0, b2 = 0) {
    this.r = r3;
    this.g = g2;
    this.b = b2;
  }
  /**
   * Creates a string with the Color3 current values
   * @returns the string representation of the Color3 object
   */
  toString() {
    return "{R: " + this.r + " G:" + this.g + " B:" + this.b + "}";
  }
  /**
   * Returns the string "Color3"
   * @returns "Color3"
   */
  getClassName() {
    return "Color3";
  }
  /**
   * Compute the Color3 hash code
   * @returns an unique number that can be used to hash Color3 objects
   */
  getHashCode() {
    let hash = this.r * 255 | 0;
    hash = hash * 397 ^ (this.g * 255 | 0);
    hash = hash * 397 ^ (this.b * 255 | 0);
    return hash;
  }
  // Operators
  /**
   * Stores in the given array from the given starting index the red, green, blue values as successive elements
   * @param array defines the array where to store the r,g,b components
   * @param index defines an optional index in the target array to define where to start storing values
   * @returns the current Color3 object
   */
  toArray(array, index2 = 0) {
    array[index2] = this.r;
    array[index2 + 1] = this.g;
    array[index2 + 2] = this.b;
    return this;
  }
  /**
   * Update the current color with values stored in an array from the starting index of the given array
   * @param array defines the source array
   * @param offset defines an offset in the source array
   * @returns the current Color3 object
   */
  fromArray(array, offset = 0) {
    Color3.FromArrayToRef(array, offset, this);
    return this;
  }
  /**
   * Returns a new Color4 object from the current Color3 and the given alpha
   * @param alpha defines the alpha component on the new Color4 object (default is 1)
   * @returns a new Color4 object
   */
  toColor4(alpha = 1) {
    return new Color4(this.r, this.g, this.b, alpha);
  }
  /**
   * Returns a new array populated with 3 numeric elements : red, green and blue values
   * @returns the new array
   */
  asArray() {
    return [this.r, this.g, this.b];
  }
  /**
   * Returns the luminance value
   * @returns a float value
   */
  toLuminance() {
    return this.r * 0.3 + this.g * 0.59 + this.b * 0.11;
  }
  /**
   * Multiply each Color3 rgb values by the given Color3 rgb values in a new Color3 object
   * @param otherColor defines the second operand
   * @returns the new Color3 object
   */
  multiply(otherColor) {
    return new Color3(this.r * otherColor.r, this.g * otherColor.g, this.b * otherColor.b);
  }
  /**
   * Multiply the rgb values of the Color3 and the given Color3 and stores the result in the object "result"
   * @param otherColor defines the second operand
   * @param result defines the Color3 object where to store the result
   * @returns the result Color3
   */
  multiplyToRef(otherColor, result) {
    result.r = this.r * otherColor.r;
    result.g = this.g * otherColor.g;
    result.b = this.b * otherColor.b;
    return result;
  }
  /**
   * Multiplies the current Color3 coordinates by the given ones
   * @param otherColor defines the second operand
   * @returns the current updated Color3
   */
  multiplyInPlace(otherColor) {
    this.r *= otherColor.r;
    this.g *= otherColor.g;
    this.b *= otherColor.b;
    return this;
  }
  /**
   * Returns a new Color3 set with the result of the multiplication of the current Color3 coordinates by the given floats
   * @param r defines the r coordinate of the operand
   * @param g defines the g coordinate of the operand
   * @param b defines the b coordinate of the operand
   * @returns the new Color3
   */
  multiplyByFloats(r3, g2, b2) {
    return new Color3(this.r * r3, this.g * g2, this.b * b2);
  }
  /**
   * @internal
   * Do not use
   */
  divide(_other) {
    throw new ReferenceError("Can not divide a color");
  }
  /**
   * @internal
   * Do not use
   */
  divideToRef(_other, _result) {
    throw new ReferenceError("Can not divide a color");
  }
  /**
   * @internal
   * Do not use
   */
  divideInPlace(_other) {
    throw new ReferenceError("Can not divide a color");
  }
  /**
   * Updates the current Color3 with the minimal coordinate values between its and the given color ones
   * @param other defines the second operand
   * @returns the current updated Color3
   */
  minimizeInPlace(other) {
    return this.minimizeInPlaceFromFloats(other.r, other.g, other.b);
  }
  /**
   * Updates the current Color3 with the maximal coordinate values between its and the given color ones.
   * @param other defines the second operand
   * @returns the current updated Color3
   */
  maximizeInPlace(other) {
    return this.maximizeInPlaceFromFloats(other.r, other.g, other.b);
  }
  /**
   * Updates the current Color3 with the minimal coordinate values between its and the given coordinates
   * @param r defines the r coordinate of the operand
   * @param g defines the g coordinate of the operand
   * @param b defines the b coordinate of the operand
   * @returns the current updated Color3
   */
  minimizeInPlaceFromFloats(r3, g2, b2) {
    this.r = Math.min(r3, this.r);
    this.g = Math.min(g2, this.g);
    this.b = Math.min(b2, this.b);
    return this;
  }
  /**
   * Updates the current Color3 with the maximal coordinate values between its and the given coordinates.
   * @param r defines the r coordinate of the operand
   * @param g defines the g coordinate of the operand
   * @param b defines the b coordinate of the operand
   * @returns the current updated Color3
   */
  maximizeInPlaceFromFloats(r3, g2, b2) {
    this.r = Math.max(r3, this.r);
    this.g = Math.max(g2, this.g);
    this.b = Math.max(b2, this.b);
    return this;
  }
  /**
   * @internal
   * Do not use
   */
  floorToRef(_result) {
    throw new ReferenceError("Can not floor a color");
  }
  /**
   * @internal
   * Do not use
   */
  floor() {
    throw new ReferenceError("Can not floor a color");
  }
  /**
   * @internal
   * Do not use
   */
  fractToRef(_result) {
    throw new ReferenceError("Can not fract a color");
  }
  /**
   * @internal
   * Do not use
   */
  fract() {
    throw new ReferenceError("Can not fract a color");
  }
  /**
   * Determines equality between Color3 objects
   * @param otherColor defines the second operand
   * @returns true if the rgb values are equal to the given ones
   */
  equals(otherColor) {
    return otherColor && this.r === otherColor.r && this.g === otherColor.g && this.b === otherColor.b;
  }
  /**
   * Alias for equalsToFloats
   * @param r red color component
   * @param g green color component
   * @param b blue color component
   * @returns boolean
   */
  equalsFloats(r3, g2, b2) {
    return this.equalsToFloats(r3, g2, b2);
  }
  /**
   * Determines equality between the current Color3 object and a set of r,b,g values
   * @param r defines the red component to check
   * @param g defines the green component to check
   * @param b defines the blue component to check
   * @returns true if the rgb values are equal to the given ones
   */
  equalsToFloats(r3, g2, b2) {
    return this.r === r3 && this.g === g2 && this.b === b2;
  }
  /**
   * Returns true if the current Color3 and the given color coordinates are distant less than epsilon
   * @param otherColor defines the second operand
   * @param epsilon defines the minimal distance to define values as equals
   * @returns true if both colors are distant less than epsilon
   */
  equalsWithEpsilon(otherColor, epsilon = Epsilon) {
    return WithinEpsilon(this.r, otherColor.r, epsilon) && WithinEpsilon(this.g, otherColor.g, epsilon) && WithinEpsilon(this.b, otherColor.b, epsilon);
  }
  /**
   * @internal
   * Do not use
   */
  negate() {
    throw new ReferenceError("Can not negate a color");
  }
  /**
   * @internal
   * Do not use
   */
  negateInPlace() {
    throw new ReferenceError("Can not negate a color");
  }
  /**
   * @internal
   * Do not use
   */
  negateToRef(_result) {
    throw new ReferenceError("Can not negate a color");
  }
  /**
   * Creates a new Color3 with the current Color3 values multiplied by scale
   * @param scale defines the scaling factor to apply
   * @returns a new Color3 object
   */
  scale(scale) {
    return new Color3(this.r * scale, this.g * scale, this.b * scale);
  }
  /**
   * Multiplies the Color3 values by the float "scale"
   * @param scale defines the scaling factor to apply
   * @returns the current updated Color3
   */
  scaleInPlace(scale) {
    this.r *= scale;
    this.g *= scale;
    this.b *= scale;
    return this;
  }
  /**
   * Multiplies the rgb values by scale and stores the result into "result"
   * @param scale defines the scaling factor
   * @param result defines the Color3 object where to store the result
   * @returns the result Color3
   */
  scaleToRef(scale, result) {
    result.r = this.r * scale;
    result.g = this.g * scale;
    result.b = this.b * scale;
    return result;
  }
  /**
   * Scale the current Color3 values by a factor and add the result to a given Color3
   * @param scale defines the scale factor
   * @param result defines color to store the result into
   * @returns the result Color3
   */
  scaleAndAddToRef(scale, result) {
    result.r += this.r * scale;
    result.g += this.g * scale;
    result.b += this.b * scale;
    return result;
  }
  /**
   * Clamps the rgb values by the min and max values and stores the result into "result"
   * @param min defines minimum clamping value (default is 0)
   * @param max defines maximum clamping value (default is 1)
   * @param result defines color to store the result into
   * @returns the result Color3
   */
  clampToRef(min = 0, max = 1, result) {
    result.r = Clamp(this.r, min, max);
    result.g = Clamp(this.g, min, max);
    result.b = Clamp(this.b, min, max);
    return result;
  }
  /**
   * Creates a new Color3 set with the added values of the current Color3 and of the given one
   * @param otherColor defines the second operand
   * @returns the new Color3
   */
  add(otherColor) {
    return new Color3(this.r + otherColor.r, this.g + otherColor.g, this.b + otherColor.b);
  }
  /**
   * Adds the given color to the current Color3
   * @param otherColor defines the second operand
   * @returns the current updated Color3
   */
  addInPlace(otherColor) {
    this.r += otherColor.r;
    this.g += otherColor.g;
    this.b += otherColor.b;
    return this;
  }
  /**
   * Adds the given coordinates to the current Color3
   * @param r defines the r coordinate of the operand
   * @param g defines the g coordinate of the operand
   * @param b defines the b coordinate of the operand
   * @returns the current updated Color3
   */
  addInPlaceFromFloats(r3, g2, b2) {
    this.r += r3;
    this.g += g2;
    this.b += b2;
    return this;
  }
  /**
   * Stores the result of the addition of the current Color3 and given one rgb values into "result"
   * @param otherColor defines the second operand
   * @param result defines Color3 object to store the result into
   * @returns the unmodified current Color3
   */
  addToRef(otherColor, result) {
    result.r = this.r + otherColor.r;
    result.g = this.g + otherColor.g;
    result.b = this.b + otherColor.b;
    return result;
  }
  /**
   * Returns a new Color3 set with the subtracted values of the given one from the current Color3
   * @param otherColor defines the second operand
   * @returns the new Color3
   */
  subtract(otherColor) {
    return new Color3(this.r - otherColor.r, this.g - otherColor.g, this.b - otherColor.b);
  }
  /**
   * Stores the result of the subtraction of given one from the current Color3 rgb values into "result"
   * @param otherColor defines the second operand
   * @param result defines Color3 object to store the result into
   * @returns the unmodified current Color3
   */
  subtractToRef(otherColor, result) {
    result.r = this.r - otherColor.r;
    result.g = this.g - otherColor.g;
    result.b = this.b - otherColor.b;
    return result;
  }
  /**
   * Subtract the given color from the current Color3
   * @param otherColor defines the second operand
   * @returns the current updated Color3
   */
  subtractInPlace(otherColor) {
    this.r -= otherColor.r;
    this.g -= otherColor.g;
    this.b -= otherColor.b;
    return this;
  }
  /**
   * Returns a new Color3 set with the subtraction of the given floats from the current Color3 coordinates
   * @param r defines the r coordinate of the operand
   * @param g defines the g coordinate of the operand
   * @param b defines the b coordinate of the operand
   * @returns the resulting Color3
   */
  subtractFromFloats(r3, g2, b2) {
    return new Color3(this.r - r3, this.g - g2, this.b - b2);
  }
  /**
   * Subtracts the given floats from the current Color3 coordinates and set the given color "result" with this result
   * @param r defines the r coordinate of the operand
   * @param g defines the g coordinate of the operand
   * @param b defines the b coordinate of the operand
   * @param result defines the Color3 object where to store the result
   * @returns the result
   */
  subtractFromFloatsToRef(r3, g2, b2, result) {
    result.r = this.r - r3;
    result.g = this.g - g2;
    result.b = this.b - b2;
    return result;
  }
  /**
   * Copy the current object
   * @returns a new Color3 copied the current one
   */
  clone() {
    return new Color3(this.r, this.g, this.b);
  }
  /**
   * Copies the rgb values from the source in the current Color3
   * @param source defines the source Color3 object
   * @returns the updated Color3 object
   */
  copyFrom(source) {
    this.r = source.r;
    this.g = source.g;
    this.b = source.b;
    return this;
  }
  /**
   * Updates the Color3 rgb values from the given floats
   * @param r defines the red component to read from
   * @param g defines the green component to read from
   * @param b defines the blue component to read from
   * @returns the current Color3 object
   */
  copyFromFloats(r3, g2, b2) {
    this.r = r3;
    this.g = g2;
    this.b = b2;
    return this;
  }
  /**
   * Updates the Color3 rgb values from the given floats
   * @param r defines the red component to read from
   * @param g defines the green component to read from
   * @param b defines the blue component to read from
   * @returns the current Color3 object
   */
  set(r3, g2, b2) {
    return this.copyFromFloats(r3, g2, b2);
  }
  /**
   * Copies the given float to the current Color3 coordinates
   * @param v defines the r, g and b coordinates of the operand
   * @returns the current updated Color3
   */
  setAll(v2) {
    this.r = this.g = this.b = v2;
    return this;
  }
  /**
   * Compute the Color3 hexadecimal code as a string
   * @returns a string containing the hexadecimal representation of the Color3 object
   */
  toHexString() {
    const intR = Math.round(this.r * 255);
    const intG = Math.round(this.g * 255);
    const intB = Math.round(this.b * 255);
    return "#" + ToHex(intR) + ToHex(intG) + ToHex(intB);
  }
  /**
   * Updates the Color3 rgb values from the string containing valid hexadecimal values
   * @param hex defines a string containing valid hexadecimal values
   * @returns the current Color3 object
   */
  fromHexString(hex) {
    if (hex.substring(0, 1) !== "#" || hex.length !== 7) {
      return this;
    }
    this.r = parseInt(hex.substring(1, 3), 16) / 255;
    this.g = parseInt(hex.substring(3, 5), 16) / 255;
    this.b = parseInt(hex.substring(5, 7), 16) / 255;
    return this;
  }
  /**
   * Converts current color in rgb space to HSV values
   * @returns a new color3 representing the HSV values
   */
  toHSV() {
    return this.toHSVToRef(new Color3());
  }
  /**
   * Converts current color in rgb space to HSV values
   * @param result defines the Color3 where to store the HSV values
   * @returns the updated result
   */
  toHSVToRef(result) {
    const r3 = this.r;
    const g2 = this.g;
    const b2 = this.b;
    const max = Math.max(r3, g2, b2);
    const min = Math.min(r3, g2, b2);
    let h2 = 0;
    let s2 = 0;
    const v2 = max;
    const dm = max - min;
    if (max !== 0) {
      s2 = dm / max;
    }
    if (max != min) {
      if (max == r3) {
        h2 = (g2 - b2) / dm;
        if (g2 < b2) {
          h2 += 6;
        }
      } else if (max == g2) {
        h2 = (b2 - r3) / dm + 2;
      } else if (max == b2) {
        h2 = (r3 - g2) / dm + 4;
      }
      h2 *= 60;
    }
    result.r = h2;
    result.g = s2;
    result.b = v2;
    return result;
  }
  /**
   * Computes a new Color3 converted from the current one to linear space
   * @param exact defines if the conversion will be done in an exact way which is slower but more accurate (default is false)
   * @returns a new Color3 object
   */
  toLinearSpace(exact = false) {
    const convertedColor = new Color3();
    this.toLinearSpaceToRef(convertedColor, exact);
    return convertedColor;
  }
  /**
   * Converts the Color3 values to linear space and stores the result in "convertedColor"
   * @param convertedColor defines the Color3 object where to store the linear space version
   * @param exact defines if the conversion will be done in an exact way which is slower but more accurate (default is false)
   * @returns the unmodified Color3
   */
  toLinearSpaceToRef(convertedColor, exact = false) {
    if (exact) {
      convertedColor.r = colorChannelToLinearSpaceExact(this.r);
      convertedColor.g = colorChannelToLinearSpaceExact(this.g);
      convertedColor.b = colorChannelToLinearSpaceExact(this.b);
    } else {
      convertedColor.r = colorChannelToLinearSpace(this.r);
      convertedColor.g = colorChannelToLinearSpace(this.g);
      convertedColor.b = colorChannelToLinearSpace(this.b);
    }
    return this;
  }
  /**
   * Computes a new Color3 converted from the current one to gamma space
   * @param exact defines if the conversion will be done in an exact way which is slower but more accurate (default is false)
   * @returns a new Color3 object
   */
  toGammaSpace(exact = false) {
    const convertedColor = new Color3();
    this.toGammaSpaceToRef(convertedColor, exact);
    return convertedColor;
  }
  /**
   * Converts the Color3 values to gamma space and stores the result in "convertedColor"
   * @param convertedColor defines the Color3 object where to store the gamma space version
   * @param exact defines if the conversion will be done in an exact way which is slower but more accurate (default is false)
   * @returns the unmodified Color3
   */
  toGammaSpaceToRef(convertedColor, exact = false) {
    if (exact) {
      convertedColor.r = colorChannelToGammaSpaceExact(this.r);
      convertedColor.g = colorChannelToGammaSpaceExact(this.g);
      convertedColor.b = colorChannelToGammaSpaceExact(this.b);
    } else {
      convertedColor.r = colorChannelToGammaSpace(this.r);
      convertedColor.g = colorChannelToGammaSpace(this.g);
      convertedColor.b = colorChannelToGammaSpace(this.b);
    }
    return this;
  }
  /**
   * Converts Hue, saturation and value to a Color3 (RGB)
   * @param hue defines the hue (value between 0 and 360)
   * @param saturation defines the saturation (value between 0 and 1)
   * @param value defines the value (value between 0 and 1)
   * @param result defines the Color3 where to store the RGB values
   * @returns the updated result
   */
  static HSVtoRGBToRef(hue, saturation, value, result) {
    const chroma = value * saturation;
    const h2 = hue / 60;
    const x2 = chroma * (1 - Math.abs(h2 % 2 - 1));
    let r3 = 0;
    let g2 = 0;
    let b2 = 0;
    if (h2 >= 0 && h2 <= 1) {
      r3 = chroma;
      g2 = x2;
    } else if (h2 >= 1 && h2 <= 2) {
      r3 = x2;
      g2 = chroma;
    } else if (h2 >= 2 && h2 <= 3) {
      g2 = chroma;
      b2 = x2;
    } else if (h2 >= 3 && h2 <= 4) {
      g2 = x2;
      b2 = chroma;
    } else if (h2 >= 4 && h2 <= 5) {
      r3 = x2;
      b2 = chroma;
    } else if (h2 >= 5 && h2 <= 6) {
      r3 = chroma;
      b2 = x2;
    }
    const m2 = value - chroma;
    result.r = r3 + m2;
    result.g = g2 + m2;
    result.b = b2 + m2;
    return result;
  }
  /**
   * Converts Hue, saturation and value to a new Color3 (RGB)
   * @param hue defines the hue (value between 0 and 360)
   * @param saturation defines the saturation (value between 0 and 1)
   * @param value defines the value (value between 0 and 1)
   * @returns a new Color3 object
   */
  static FromHSV(hue, saturation, value) {
    const result = new Color3(0, 0, 0);
    Color3.HSVtoRGBToRef(hue, saturation, value, result);
    return result;
  }
  /**
   * Creates a new Color3 from the string containing valid hexadecimal values
   * @param hex defines a string containing valid hexadecimal values
   * @returns a new Color3 object
   */
  static FromHexString(hex) {
    return new Color3(0, 0, 0).fromHexString(hex);
  }
  /**
   * Creates a new Color3 from the starting index of the given array
   * @param array defines the source array
   * @param offset defines an offset in the source array
   * @returns a new Color3 object
   */
  static FromArray(array, offset = 0) {
    return new Color3(array[offset], array[offset + 1], array[offset + 2]);
  }
  /**
   * Creates a new Color3 from the starting index element of the given array
   * @param array defines the source array to read from
   * @param offset defines the offset in the source array
   * @param result defines the target Color3 object
   */
  static FromArrayToRef(array, offset = 0, result) {
    result.r = array[offset];
    result.g = array[offset + 1];
    result.b = array[offset + 2];
  }
  /**
   * Creates a new Color3 from integer values (\< 256)
   * @param r defines the red component to read from (value between 0 and 255)
   * @param g defines the green component to read from (value between 0 and 255)
   * @param b defines the blue component to read from (value between 0 and 255)
   * @returns a new Color3 object
   */
  static FromInts(r3, g2, b2) {
    return new Color3(r3 / 255, g2 / 255, b2 / 255);
  }
  /**
   * Creates a new Color3 with values linearly interpolated of "amount" between the start Color3 and the end Color3
   * @param start defines the start Color3 value
   * @param end defines the end Color3 value
   * @param amount defines the gradient value between start and end
   * @returns a new Color3 object
   */
  static Lerp(start, end, amount) {
    const result = new Color3(0, 0, 0);
    Color3.LerpToRef(start, end, amount, result);
    return result;
  }
  /**
   * Creates a new Color3 with values linearly interpolated of "amount" between the start Color3 and the end Color3
   * @param left defines the start value
   * @param right defines the end value
   * @param amount defines the gradient factor
   * @param result defines the Color3 object where to store the result
   */
  static LerpToRef(left, right, amount, result) {
    result.r = left.r + (right.r - left.r) * amount;
    result.g = left.g + (right.g - left.g) * amount;
    result.b = left.b + (right.b - left.b) * amount;
  }
  /**
   * Returns a new Color3 located for "amount" (float) on the Hermite interpolation spline defined by the vectors "value1", "tangent1", "value2", "tangent2"
   * @param value1 defines the first control point
   * @param tangent1 defines the first tangent Color3
   * @param value2 defines the second control point
   * @param tangent2 defines the second tangent Color3
   * @param amount defines the amount on the interpolation spline (between 0 and 1)
   * @returns the new Color3
   */
  static Hermite(value1, tangent1, value2, tangent2, amount) {
    const squared = amount * amount;
    const cubed = amount * squared;
    const part1 = 2 * cubed - 3 * squared + 1;
    const part2 = -2 * cubed + 3 * squared;
    const part3 = cubed - 2 * squared + amount;
    const part4 = cubed - squared;
    const r3 = value1.r * part1 + value2.r * part2 + tangent1.r * part3 + tangent2.r * part4;
    const g2 = value1.g * part1 + value2.g * part2 + tangent1.g * part3 + tangent2.g * part4;
    const b2 = value1.b * part1 + value2.b * part2 + tangent1.b * part3 + tangent2.b * part4;
    return new Color3(r3, g2, b2);
  }
  /**
   * Returns a new Color3 which is the 1st derivative of the Hermite spline defined by the colors "value1", "value2", "tangent1", "tangent2".
   * @param value1 defines the first control point
   * @param tangent1 defines the first tangent
   * @param value2 defines the second control point
   * @param tangent2 defines the second tangent
   * @param time define where the derivative must be done
   * @returns 1st derivative
   */
  static Hermite1stDerivative(value1, tangent1, value2, tangent2, time) {
    const result = Color3.Black();
    this.Hermite1stDerivativeToRef(value1, tangent1, value2, tangent2, time, result);
    return result;
  }
  /**
   * Returns a new Color3 which is the 1st derivative of the Hermite spline defined by the colors "value1", "value2", "tangent1", "tangent2".
   * @param value1 defines the first control point
   * @param tangent1 defines the first tangent
   * @param value2 defines the second control point
   * @param tangent2 defines the second tangent
   * @param time define where the derivative must be done
   * @param result define where to store the derivative
   */
  static Hermite1stDerivativeToRef(value1, tangent1, value2, tangent2, time, result) {
    const t2 = time * time;
    result.r = (t2 - time) * 6 * value1.r + (3 * t2 - 4 * time + 1) * tangent1.r + (-t2 + time) * 6 * value2.r + (3 * t2 - 2 * time) * tangent2.r;
    result.g = (t2 - time) * 6 * value1.g + (3 * t2 - 4 * time + 1) * tangent1.g + (-t2 + time) * 6 * value2.g + (3 * t2 - 2 * time) * tangent2.g;
    result.b = (t2 - time) * 6 * value1.b + (3 * t2 - 4 * time + 1) * tangent1.b + (-t2 + time) * 6 * value2.b + (3 * t2 - 2 * time) * tangent2.b;
  }
  /**
   * Returns a Color3 value containing a red color
   * @returns a new Color3 object
   */
  static Red() {
    return new Color3(1, 0, 0);
  }
  /**
   * Returns a Color3 value containing a green color
   * @returns a new Color3 object
   */
  static Green() {
    return new Color3(0, 1, 0);
  }
  /**
   * Returns a Color3 value containing a blue color
   * @returns a new Color3 object
   */
  static Blue() {
    return new Color3(0, 0, 1);
  }
  /**
   * Returns a Color3 value containing a black color
   * @returns a new Color3 object
   */
  static Black() {
    return new Color3(0, 0, 0);
  }
  /**
   * Gets a Color3 value containing a black color that must not be updated
   */
  static get BlackReadOnly() {
    return Color3._BlackReadOnly;
  }
  /**
   * Returns a Color3 value containing a white color
   * @returns a new Color3 object
   */
  static White() {
    return new Color3(1, 1, 1);
  }
  /**
   * Returns a Color3 value containing a purple color
   * @returns a new Color3 object
   */
  static Purple() {
    return new Color3(0.5, 0, 0.5);
  }
  /**
   * Returns a Color3 value containing a magenta color
   * @returns a new Color3 object
   */
  static Magenta() {
    return new Color3(1, 0, 1);
  }
  /**
   * Returns a Color3 value containing a yellow color
   * @returns a new Color3 object
   */
  static Yellow() {
    return new Color3(1, 1, 0);
  }
  /**
   * Returns a Color3 value containing a gray color
   * @returns a new Color3 object
   */
  static Gray() {
    return new Color3(0.5, 0.5, 0.5);
  }
  /**
   * Returns a Color3 value containing a teal color
   * @returns a new Color3 object
   */
  static Teal() {
    return new Color3(0, 1, 1);
  }
  /**
   * Returns a Color3 value containing a random color
   * @returns a new Color3 object
   */
  static Random() {
    return new Color3(Math.random(), Math.random(), Math.random());
  }
}
Color3._V8PerformanceHack = new Color3(0.5, 0.5, 0.5);
Color3._BlackReadOnly = Color3.Black();
Object.defineProperties(Color3.prototype, {
  dimension: { value: [3] },
  rank: { value: 1 }
});
class Color4 {
  /**
   * Creates a new Color4 object from red, green, blue values, all between 0 and 1
   * @param r defines the red component (between 0 and 1, default is 0)
   * @param g defines the green component (between 0 and 1, default is 0)
   * @param b defines the blue component (between 0 and 1, default is 0)
   * @param a defines the alpha component (between 0 and 1, default is 1)
   */
  constructor(r3 = 0, g2 = 0, b2 = 0, a2 = 1) {
    this.r = r3;
    this.g = g2;
    this.b = b2;
    this.a = a2;
  }
  // Operators
  /**
   * Creates a new array populated with 4 numeric elements : red, green, blue, alpha values
   * @returns the new array
   */
  asArray() {
    return [this.r, this.g, this.b, this.a];
  }
  /**
   * Stores from the starting index in the given array the Color4 successive values
   * @param array defines the array where to store the r,g,b components
   * @param index defines an optional index in the target array to define where to start storing values
   * @returns the current Color4 object
   */
  toArray(array, index2 = 0) {
    array[index2] = this.r;
    array[index2 + 1] = this.g;
    array[index2 + 2] = this.b;
    array[index2 + 3] = this.a;
    return this;
  }
  /**
   * Update the current color with values stored in an array from the starting index of the given array
   * @param array defines the source array
   * @param offset defines an offset in the source array
   * @returns the current Color4 object
   */
  fromArray(array, offset = 0) {
    this.r = array[offset];
    this.g = array[offset + 1];
    this.b = array[offset + 2];
    this.a = array[offset + 3];
    return this;
  }
  /**
   * Determines equality between Color4 objects
   * @param otherColor defines the second operand
   * @returns true if the rgba values are equal to the given ones
   */
  equals(otherColor) {
    return otherColor && this.r === otherColor.r && this.g === otherColor.g && this.b === otherColor.b && this.a === otherColor.a;
  }
  /**
   * Creates a new Color4 set with the added values of the current Color4 and of the given one
   * @param otherColor defines the second operand
   * @returns a new Color4 object
   */
  add(otherColor) {
    return new Color4(this.r + otherColor.r, this.g + otherColor.g, this.b + otherColor.b, this.a + otherColor.a);
  }
  /**
   * Updates the given color "result" with the result of the addition of the current Color4 and the given one.
   * @param otherColor the color to add
   * @param result the color to store the result
   * @returns result input
   */
  addToRef(otherColor, result) {
    result.r = this.r + otherColor.r;
    result.g = this.g + otherColor.g;
    result.b = this.b + otherColor.b;
    result.a = this.a + otherColor.a;
    return result;
  }
  /**
   * Adds in place the given Color4 values to the current Color4 object
   * @param otherColor defines the second operand
   * @returns the current updated Color4 object
   */
  addInPlace(otherColor) {
    this.r += otherColor.r;
    this.g += otherColor.g;
    this.b += otherColor.b;
    this.a += otherColor.a;
    return this;
  }
  /**
   * Adds the given coordinates to the current Color4
   * @param r defines the r coordinate of the operand
   * @param g defines the g coordinate of the operand
   * @param b defines the b coordinate of the operand
   * @param a defines the a coordinate of the operand
   * @returns the current updated Color4
   */
  addInPlaceFromFloats(r3, g2, b2, a2) {
    this.r += r3;
    this.g += g2;
    this.b += b2;
    this.a += a2;
    return this;
  }
  /**
   * Creates a new Color4 set with the subtracted values of the given one from the current Color4
   * @param otherColor defines the second operand
   * @returns a new Color4 object
   */
  subtract(otherColor) {
    return new Color4(this.r - otherColor.r, this.g - otherColor.g, this.b - otherColor.b, this.a - otherColor.a);
  }
  /**
   * Subtracts the given ones from the current Color4 values and stores the results in "result"
   * @param otherColor defines the second operand
   * @param result defines the Color4 object where to store the result
   * @returns the result Color4 object
   */
  subtractToRef(otherColor, result) {
    result.r = this.r - otherColor.r;
    result.g = this.g - otherColor.g;
    result.b = this.b - otherColor.b;
    result.a = this.a - otherColor.a;
    return result;
  }
  /**
   * Subtract in place the given color from the current Color4.
   * @param otherColor the color to subtract
   * @returns the updated Color4.
   */
  subtractInPlace(otherColor) {
    this.r -= otherColor.r;
    this.g -= otherColor.g;
    this.b -= otherColor.b;
    this.a -= otherColor.a;
    return this;
  }
  /**
   * Returns a new Color4 set with the result of the subtraction of the given floats from the current Color4 coordinates.
   * @param r value to subtract
   * @param g value to subtract
   * @param b value to subtract
   * @param a value to subtract
   * @returns new color containing the result
   */
  subtractFromFloats(r3, g2, b2, a2) {
    return new Color4(this.r - r3, this.g - g2, this.b - b2, this.a - a2);
  }
  /**
   * Sets the given color "result" set with the result of the subtraction of the given floats from the current Color4 coordinates.
   * @param r value to subtract
   * @param g value to subtract
   * @param b value to subtract
   * @param a value to subtract
   * @param result the color to store the result in
   * @returns result input
   */
  subtractFromFloatsToRef(r3, g2, b2, a2, result) {
    result.r = this.r - r3;
    result.g = this.g - g2;
    result.b = this.b - b2;
    result.a = this.a - a2;
    return result;
  }
  /**
   * Creates a new Color4 with the current Color4 values multiplied by scale
   * @param scale defines the scaling factor to apply
   * @returns a new Color4 object
   */
  scale(scale) {
    return new Color4(this.r * scale, this.g * scale, this.b * scale, this.a * scale);
  }
  /**
   * Multiplies the Color4 values by the float "scale"
   * @param scale defines the scaling factor to apply
   * @returns the current updated Color4
   */
  scaleInPlace(scale) {
    this.r *= scale;
    this.g *= scale;
    this.b *= scale;
    this.a *= scale;
    return this;
  }
  /**
   * Multiplies the current Color4 values by scale and stores the result in "result"
   * @param scale defines the scaling factor to apply
   * @param result defines the Color4 object where to store the result
   * @returns the result Color4
   */
  scaleToRef(scale, result) {
    result.r = this.r * scale;
    result.g = this.g * scale;
    result.b = this.b * scale;
    result.a = this.a * scale;
    return result;
  }
  /**
   * Scale the current Color4 values by a factor and add the result to a given Color4
   * @param scale defines the scale factor
   * @param result defines the Color4 object where to store the result
   * @returns the result Color4
   */
  scaleAndAddToRef(scale, result) {
    result.r += this.r * scale;
    result.g += this.g * scale;
    result.b += this.b * scale;
    result.a += this.a * scale;
    return result;
  }
  /**
   * Clamps the rgb values by the min and max values and stores the result into "result"
   * @param min defines minimum clamping value (default is 0)
   * @param max defines maximum clamping value (default is 1)
   * @param result defines color to store the result into.
   * @returns the result Color4
   */
  clampToRef(min = 0, max = 1, result) {
    result.r = Clamp(this.r, min, max);
    result.g = Clamp(this.g, min, max);
    result.b = Clamp(this.b, min, max);
    result.a = Clamp(this.a, min, max);
    return result;
  }
  /**
   * Multiply an Color4 value by another and return a new Color4 object
   * @param color defines the Color4 value to multiply by
   * @returns a new Color4 object
   */
  multiply(color) {
    return new Color4(this.r * color.r, this.g * color.g, this.b * color.b, this.a * color.a);
  }
  /**
   * Multiply a Color4 value by another and push the result in a reference value
   * @param color defines the Color4 value to multiply by
   * @param result defines the Color4 to fill the result in
   * @returns the result Color4
   */
  multiplyToRef(color, result) {
    result.r = this.r * color.r;
    result.g = this.g * color.g;
    result.b = this.b * color.b;
    result.a = this.a * color.a;
    return result;
  }
  /**
   * Multiplies in place the current Color4 by the given one.
   * @param otherColor color to multiple with
   * @returns the updated Color4.
   */
  multiplyInPlace(otherColor) {
    this.r *= otherColor.r;
    this.g *= otherColor.g;
    this.b *= otherColor.b;
    this.a *= otherColor.a;
    return this;
  }
  /**
   * Returns a new Color4 set with the multiplication result of the given floats and the current Color4 coordinates.
   * @param r value multiply with
   * @param g value multiply with
   * @param b value multiply with
   * @param a value multiply with
   * @returns resulting new color
   */
  multiplyByFloats(r3, g2, b2, a2) {
    return new Color4(this.r * r3, this.g * g2, this.b * b2, this.a * a2);
  }
  /**
   * @internal
   * Do not use
   */
  divide(_other) {
    throw new ReferenceError("Can not divide a color");
  }
  /**
   * @internal
   * Do not use
   */
  divideToRef(_other, _result) {
    throw new ReferenceError("Can not divide a color");
  }
  /**
   * @internal
   * Do not use
   */
  divideInPlace(_other) {
    throw new ReferenceError("Can not divide a color");
  }
  /**
   * Updates the Color4 coordinates with the minimum values between its own and the given color ones
   * @param other defines the second operand
   * @returns the current updated Color4
   */
  minimizeInPlace(other) {
    this.r = Math.min(this.r, other.r);
    this.g = Math.min(this.g, other.g);
    this.b = Math.min(this.b, other.b);
    this.a = Math.min(this.a, other.a);
    return this;
  }
  /**
   * Updates the Color4 coordinates with the maximum values between its own and the given color ones
   * @param other defines the second operand
   * @returns the current updated Color4
   */
  maximizeInPlace(other) {
    this.r = Math.max(this.r, other.r);
    this.g = Math.max(this.g, other.g);
    this.b = Math.max(this.b, other.b);
    this.a = Math.max(this.a, other.a);
    return this;
  }
  /**
   * Updates the current Color4 with the minimal coordinate values between its and the given coordinates
   * @param r defines the r coordinate of the operand
   * @param g defines the g coordinate of the operand
   * @param b defines the b coordinate of the operand
   * @param a defines the a coordinate of the operand
   * @returns the current updated Color4
   */
  minimizeInPlaceFromFloats(r3, g2, b2, a2) {
    this.r = Math.min(r3, this.r);
    this.g = Math.min(g2, this.g);
    this.b = Math.min(b2, this.b);
    this.a = Math.min(a2, this.a);
    return this;
  }
  /**
   * Updates the current Color4 with the maximal coordinate values between its and the given coordinates.
   * @param r defines the r coordinate of the operand
   * @param g defines the g coordinate of the operand
   * @param b defines the b coordinate of the operand
   * @param a defines the a coordinate of the operand
   * @returns the current updated Color4
   */
  maximizeInPlaceFromFloats(r3, g2, b2, a2) {
    this.r = Math.max(r3, this.r);
    this.g = Math.max(g2, this.g);
    this.b = Math.max(b2, this.b);
    this.a = Math.max(a2, this.a);
    return this;
  }
  /**
   * @internal
   * Do not use
   */
  floorToRef(_result) {
    throw new ReferenceError("Can not floor a color");
  }
  /**
   * @internal
   * Do not use
   */
  floor() {
    throw new ReferenceError("Can not floor a color");
  }
  /**
   * @internal
   * Do not use
   */
  fractToRef(_result) {
    throw new ReferenceError("Can not fract a color");
  }
  /**
   * @internal
   * Do not use
   */
  fract() {
    throw new ReferenceError("Can not fract a color");
  }
  /**
   * @internal
   * Do not use
   */
  negate() {
    throw new ReferenceError("Can not negate a color");
  }
  /**
   * @internal
   * Do not use
   */
  negateInPlace() {
    throw new ReferenceError("Can not negate a color");
  }
  /**
   * @internal
   * Do not use
   */
  negateToRef(_result) {
    throw new ReferenceError("Can not negate a color");
  }
  /**
   * Boolean : True if the current Color4 coordinates are each beneath the distance "epsilon" from the given color ones.
   * @param otherColor color to compare against
   * @param epsilon (Default: very small number)
   * @returns true if they are equal
   */
  equalsWithEpsilon(otherColor, epsilon = Epsilon) {
    return WithinEpsilon(this.r, otherColor.r, epsilon) && WithinEpsilon(this.g, otherColor.g, epsilon) && WithinEpsilon(this.b, otherColor.b, epsilon) && WithinEpsilon(this.a, otherColor.a, epsilon);
  }
  /**
   * Boolean : True if the given floats are strictly equal to the current Color4 coordinates.
   * @param x x value to compare against
   * @param y y value to compare against
   * @param z z value to compare against
   * @param w w value to compare against
   * @returns true if equal
   */
  equalsToFloats(x2, y2, z2, w) {
    return this.r === x2 && this.g === y2 && this.b === z2 && this.a === w;
  }
  /**
   * Creates a string with the Color4 current values
   * @returns the string representation of the Color4 object
   */
  toString() {
    return "{R: " + this.r + " G:" + this.g + " B:" + this.b + " A:" + this.a + "}";
  }
  /**
   * Returns the string "Color4"
   * @returns "Color4"
   */
  getClassName() {
    return "Color4";
  }
  /**
   * Compute the Color4 hash code
   * @returns an unique number that can be used to hash Color4 objects
   */
  getHashCode() {
    let hash = this.r * 255 | 0;
    hash = hash * 397 ^ (this.g * 255 | 0);
    hash = hash * 397 ^ (this.b * 255 | 0);
    hash = hash * 397 ^ (this.a * 255 | 0);
    return hash;
  }
  /**
   * Creates a new Color4 copied from the current one
   * @returns a new Color4 object
   */
  clone() {
    const result = new Color4();
    return result.copyFrom(this);
  }
  /**
   * Copies the given Color4 values into the current one
   * @param source defines the source Color4 object
   * @returns the current updated Color4 object
   */
  copyFrom(source) {
    this.r = source.r;
    this.g = source.g;
    this.b = source.b;
    this.a = source.a;
    return this;
  }
  /**
   * Copies the given float values into the current one
   * @param r defines the red component to read from
   * @param g defines the green component to read from
   * @param b defines the blue component to read from
   * @param a defines the alpha component to read from
   * @returns the current updated Color4 object
   */
  copyFromFloats(r3, g2, b2, a2) {
    this.r = r3;
    this.g = g2;
    this.b = b2;
    this.a = a2;
    return this;
  }
  /**
   * Copies the given float values into the current one
   * @param r defines the red component to read from
   * @param g defines the green component to read from
   * @param b defines the blue component to read from
   * @param a defines the alpha component to read from
   * @returns the current updated Color4 object
   */
  set(r3, g2, b2, a2) {
    return this.copyFromFloats(r3, g2, b2, a2);
  }
  /**
   * Copies the given float to the current Vector4 coordinates
   * @param v defines the r, g, b, and a coordinates of the operand
   * @returns the current updated Vector4
   */
  setAll(v2) {
    this.r = this.g = this.b = this.a = v2;
    return this;
  }
  /**
   * Compute the Color4 hexadecimal code as a string
   * @param returnAsColor3 defines if the string should only contains RGB values (off by default)
   * @returns a string containing the hexadecimal representation of the Color4 object
   */
  toHexString(returnAsColor3 = false) {
    const intR = Math.round(this.r * 255);
    const intG = Math.round(this.g * 255);
    const intB = Math.round(this.b * 255);
    if (returnAsColor3) {
      return "#" + ToHex(intR) + ToHex(intG) + ToHex(intB);
    }
    const intA = Math.round(this.a * 255);
    return "#" + ToHex(intR) + ToHex(intG) + ToHex(intB) + ToHex(intA);
  }
  /**
   * Updates the Color4 rgba values from the string containing valid hexadecimal values.
   *
   * A valid hex string is either in the format #RRGGBB or #RRGGBBAA.
   *
   * When a hex string without alpha is passed, the resulting Color4 keeps
   * its previous alpha value.
   *
   * An invalid string does not modify this object
   *
   * @param hex defines a string containing valid hexadecimal values
   * @returns the current updated Color4 object
   */
  fromHexString(hex) {
    if (hex.substring(0, 1) !== "#" || hex.length !== 9 && hex.length !== 7) {
      return this;
    }
    this.r = parseInt(hex.substring(1, 3), 16) / 255;
    this.g = parseInt(hex.substring(3, 5), 16) / 255;
    this.b = parseInt(hex.substring(5, 7), 16) / 255;
    if (hex.length === 9) {
      this.a = parseInt(hex.substring(7, 9), 16) / 255;
    }
    return this;
  }
  /**
   * Computes a new Color4 converted from the current one to linear space
   * @param exact defines if the conversion will be done in an exact way which is slower but more accurate (default is false)
   * @returns a new Color4 object
   */
  toLinearSpace(exact = false) {
    const convertedColor = new Color4();
    this.toLinearSpaceToRef(convertedColor, exact);
    return convertedColor;
  }
  /**
   * Converts the Color4 values to linear space and stores the result in "convertedColor"
   * @param convertedColor defines the Color4 object where to store the linear space version
   * @param exact defines if the conversion will be done in an exact way which is slower but more accurate (default is false)
   * @returns the unmodified Color4
   */
  toLinearSpaceToRef(convertedColor, exact = false) {
    if (exact) {
      convertedColor.r = colorChannelToLinearSpaceExact(this.r);
      convertedColor.g = colorChannelToLinearSpaceExact(this.g);
      convertedColor.b = colorChannelToLinearSpaceExact(this.b);
    } else {
      convertedColor.r = colorChannelToLinearSpace(this.r);
      convertedColor.g = colorChannelToLinearSpace(this.g);
      convertedColor.b = colorChannelToLinearSpace(this.b);
    }
    convertedColor.a = this.a;
    return this;
  }
  /**
   * Computes a new Color4 converted from the current one to gamma space
   * @param exact defines if the conversion will be done in an exact way which is slower but more accurate (default is false)
   * @returns a new Color4 object
   */
  toGammaSpace(exact = false) {
    const convertedColor = new Color4();
    this.toGammaSpaceToRef(convertedColor, exact);
    return convertedColor;
  }
  /**
   * Converts the Color4 values to gamma space and stores the result in "convertedColor"
   * @param convertedColor defines the Color4 object where to store the gamma space version
   * @param exact defines if the conversion will be done in an exact way which is slower but more accurate (default is false)
   * @returns the unmodified Color4
   */
  toGammaSpaceToRef(convertedColor, exact = false) {
    if (exact) {
      convertedColor.r = colorChannelToGammaSpaceExact(this.r);
      convertedColor.g = colorChannelToGammaSpaceExact(this.g);
      convertedColor.b = colorChannelToGammaSpaceExact(this.b);
    } else {
      convertedColor.r = colorChannelToGammaSpace(this.r);
      convertedColor.g = colorChannelToGammaSpace(this.g);
      convertedColor.b = colorChannelToGammaSpace(this.b);
    }
    convertedColor.a = this.a;
    return this;
  }
  // Statics
  /**
   * Creates a new Color4 from the string containing valid hexadecimal values.
   *
   * A valid hex string is either in the format #RRGGBB or #RRGGBBAA.
   *
   * When a hex string without alpha is passed, the resulting Color4 has
   * its alpha value set to 1.0.
   *
   * An invalid string results in a Color with all its channels set to 0.0,
   * i.e. "transparent black".
   *
   * @param hex defines a string containing valid hexadecimal values
   * @returns a new Color4 object
   */
  static FromHexString(hex) {
    if (hex.substring(0, 1) !== "#" || hex.length !== 9 && hex.length !== 7) {
      return new Color4(0, 0, 0, 0);
    }
    return new Color4(0, 0, 0, 1).fromHexString(hex);
  }
  /**
   * Creates a new Color4 object set with the linearly interpolated values of "amount" between the left Color4 object and the right Color4 object
   * @param left defines the start value
   * @param right defines the end value
   * @param amount defines the gradient factor
   * @returns a new Color4 object
   */
  static Lerp(left, right, amount) {
    return Color4.LerpToRef(left, right, amount, new Color4());
  }
  /**
   * Set the given "result" with the linearly interpolated values of "amount" between the left Color4 object and the right Color4 object
   * @param left defines the start value
   * @param right defines the end value
   * @param amount defines the gradient factor
   * @param result defines the Color4 object where to store data
   * @returns the updated result
   */
  static LerpToRef(left, right, amount, result) {
    result.r = left.r + (right.r - left.r) * amount;
    result.g = left.g + (right.g - left.g) * amount;
    result.b = left.b + (right.b - left.b) * amount;
    result.a = left.a + (right.a - left.a) * amount;
    return result;
  }
  /**
   * Interpolate between two Color4 using Hermite interpolation
   * @param value1 defines first Color4
   * @param tangent1 defines the incoming tangent
   * @param value2 defines second Color4
   * @param tangent2 defines the outgoing tangent
   * @param amount defines the target Color4
   * @returns the new interpolated Color4
   */
  static Hermite(value1, tangent1, value2, tangent2, amount) {
    const squared = amount * amount;
    const cubed = amount * squared;
    const part1 = 2 * cubed - 3 * squared + 1;
    const part2 = -2 * cubed + 3 * squared;
    const part3 = cubed - 2 * squared + amount;
    const part4 = cubed - squared;
    const r3 = value1.r * part1 + value2.r * part2 + tangent1.r * part3 + tangent2.r * part4;
    const g2 = value1.g * part1 + value2.g * part2 + tangent1.g * part3 + tangent2.g * part4;
    const b2 = value1.b * part1 + value2.b * part2 + tangent1.b * part3 + tangent2.b * part4;
    const a2 = value1.a * part1 + value2.a * part2 + tangent1.a * part3 + tangent2.a * part4;
    return new Color4(r3, g2, b2, a2);
  }
  /**
   * Returns a new Color4 which is the 1st derivative of the Hermite spline defined by the colors "value1", "value2", "tangent1", "tangent2".
   * @param value1 defines the first control point
   * @param tangent1 defines the first tangent
   * @param value2 defines the second control point
   * @param tangent2 defines the second tangent
   * @param time define where the derivative must be done
   * @returns 1st derivative
   */
  static Hermite1stDerivative(value1, tangent1, value2, tangent2, time) {
    const result = new Color4();
    this.Hermite1stDerivativeToRef(value1, tangent1, value2, tangent2, time, result);
    return result;
  }
  /**
   * Update a Color4 with the 1st derivative of the Hermite spline defined by the colors "value1", "value2", "tangent1", "tangent2".
   * @param value1 defines the first control point
   * @param tangent1 defines the first tangent
   * @param value2 defines the second control point
   * @param tangent2 defines the second tangent
   * @param time define where the derivative must be done
   * @param result define where to store the derivative
   */
  static Hermite1stDerivativeToRef(value1, tangent1, value2, tangent2, time, result) {
    const t2 = time * time;
    result.r = (t2 - time) * 6 * value1.r + (3 * t2 - 4 * time + 1) * tangent1.r + (-t2 + time) * 6 * value2.r + (3 * t2 - 2 * time) * tangent2.r;
    result.g = (t2 - time) * 6 * value1.g + (3 * t2 - 4 * time + 1) * tangent1.g + (-t2 + time) * 6 * value2.g + (3 * t2 - 2 * time) * tangent2.g;
    result.b = (t2 - time) * 6 * value1.b + (3 * t2 - 4 * time + 1) * tangent1.b + (-t2 + time) * 6 * value2.b + (3 * t2 - 2 * time) * tangent2.b;
    result.a = (t2 - time) * 6 * value1.a + (3 * t2 - 4 * time + 1) * tangent1.a + (-t2 + time) * 6 * value2.a + (3 * t2 - 2 * time) * tangent2.a;
  }
  /**
   * Creates a new Color4 from a Color3 and an alpha value
   * @param color3 defines the source Color3 to read from
   * @param alpha defines the alpha component (1.0 by default)
   * @returns a new Color4 object
   */
  static FromColor3(color3, alpha = 1) {
    return new Color4(color3.r, color3.g, color3.b, alpha);
  }
  /**
   * Creates a new Color4 from the starting index element of the given array
   * @param array defines the source array to read from
   * @param offset defines the offset in the source array
   * @returns a new Color4 object
   */
  static FromArray(array, offset = 0) {
    return new Color4(array[offset], array[offset + 1], array[offset + 2], array[offset + 3]);
  }
  /**
   * Creates a new Color4 from the starting index element of the given array
   * @param array defines the source array to read from
   * @param offset defines the offset in the source array
   * @param result defines the target Color4 object
   */
  static FromArrayToRef(array, offset = 0, result) {
    result.r = array[offset];
    result.g = array[offset + 1];
    result.b = array[offset + 2];
    result.a = array[offset + 3];
  }
  /**
   * Creates a new Color3 from integer values (less than 256)
   * @param r defines the red component to read from (value between 0 and 255)
   * @param g defines the green component to read from (value between 0 and 255)
   * @param b defines the blue component to read from (value between 0 and 255)
   * @param a defines the alpha component to read from (value between 0 and 255)
   * @returns a new Color3 object
   */
  static FromInts(r3, g2, b2, a2) {
    return new Color4(r3 / 255, g2 / 255, b2 / 255, a2 / 255);
  }
  /**
   * Check the content of a given array and convert it to an array containing RGBA data
   * If the original array was already containing count * 4 values then it is returned directly
   * @param colors defines the array to check
   * @param count defines the number of RGBA data to expect
   * @returns an array containing count * 4 values (RGBA)
   */
  static CheckColors4(colors, count) {
    if (colors.length === count * 3) {
      const colors4 = [];
      for (let index2 = 0; index2 < colors.length; index2 += 3) {
        const newIndex = index2 / 3 * 4;
        colors4[newIndex] = colors[index2];
        colors4[newIndex + 1] = colors[index2 + 1];
        colors4[newIndex + 2] = colors[index2 + 2];
        colors4[newIndex + 3] = 1;
      }
      return colors4;
    }
    return colors;
  }
}
Color4._V8PerformanceHack = new Color4(0.5, 0.5, 0.5, 0.5);
Object.defineProperties(Color4.prototype, {
  dimension: { value: [4] },
  rank: { value: 1 }
});
class TmpColors {
}
TmpColors.Color3 = BuildArray(3, Color3.Black);
TmpColors.Color4 = BuildArray(3, () => new Color4(0, 0, 0, 0));
RegisterClass("BABYLON.Color3", Color3);
RegisterClass("BABYLON.Color4", Color4);
const _copySource = function(creationFunction, source, instanciate, options = {}) {
  const destination = creationFunction();
  if (Tags && Tags.HasTags(source)) {
    Tags.AddTagsTo(destination, Tags.GetTags(source, true));
  }
  const classStore = GetMergedStore(destination);
  const textureMap = {};
  for (const property in classStore) {
    const propertyDescriptor = classStore[property];
    const sourceProperty = source[property];
    const propertyType = propertyDescriptor.type;
    if (sourceProperty !== void 0 && sourceProperty !== null && (property !== "uniqueId" || SerializationHelper.AllowLoadingUniqueId)) {
      switch (propertyType) {
        case 0:
        case 6:
        case 9:
        case 11:
          destination[property] = sourceProperty;
          break;
        case 1:
          if (options.cloneTexturesOnlyOnce && textureMap[sourceProperty.uniqueId]) {
            destination[property] = textureMap[sourceProperty.uniqueId];
          } else {
            destination[property] = instanciate || sourceProperty.isRenderTarget ? sourceProperty : sourceProperty.clone();
            textureMap[sourceProperty.uniqueId] = destination[property];
          }
          break;
        case 2:
        case 3:
        case 4:
        case 5:
        case 7:
        case 8:
        case 10:
        case 12:
          destination[property] = instanciate ? sourceProperty : sourceProperty.clone();
          break;
      }
    }
  }
  return destination;
};
class SerializationHelper {
  /**
   * Appends the serialized animations from the source animations
   * @param source Source containing the animations
   * @param destination Target to store the animations
   */
  static AppendSerializedAnimations(source, destination) {
    if (source.animations) {
      destination.animations = [];
      for (let animationIndex = 0; animationIndex < source.animations.length; animationIndex++) {
        const animation = source.animations[animationIndex];
        destination.animations.push(animation.serialize());
      }
    }
  }
  /**
   * Static function used to serialized a specific entity
   * @param entity defines the entity to serialize
   * @param serializationObject defines the optional target object where serialization data will be stored
   * @returns a JSON compatible object representing the serialization of the entity
   */
  static Serialize(entity, serializationObject) {
    if (!serializationObject) {
      serializationObject = {};
    }
    if (Tags) {
      serializationObject.tags = Tags.GetTags(entity);
    }
    const serializedProperties = GetMergedStore(entity);
    for (const property in serializedProperties) {
      const propertyDescriptor = serializedProperties[property];
      const targetPropertyName = propertyDescriptor.sourceName || property;
      const propertyType = propertyDescriptor.type;
      const sourceProperty = entity[property];
      if (sourceProperty !== void 0 && sourceProperty !== null && (property !== "uniqueId" || SerializationHelper.AllowLoadingUniqueId)) {
        switch (propertyType) {
          case 0:
            serializationObject[targetPropertyName] = sourceProperty;
            break;
          case 1:
            serializationObject[targetPropertyName] = sourceProperty.serialize();
            break;
          case 2:
            serializationObject[targetPropertyName] = sourceProperty.asArray();
            break;
          case 3:
            serializationObject[targetPropertyName] = sourceProperty.serialize();
            break;
          case 4:
            serializationObject[targetPropertyName] = sourceProperty.asArray();
            break;
          case 5:
            serializationObject[targetPropertyName] = sourceProperty.asArray();
            break;
          case 6:
            serializationObject[targetPropertyName] = sourceProperty.id;
            break;
          case 7:
            serializationObject[targetPropertyName] = sourceProperty.serialize();
            break;
          case 8:
            serializationObject[targetPropertyName] = sourceProperty.asArray();
            break;
          case 9:
            serializationObject[targetPropertyName] = sourceProperty.serialize();
            break;
          case 10:
            serializationObject[targetPropertyName] = sourceProperty.asArray();
            break;
          case 11:
            serializationObject[targetPropertyName] = sourceProperty.id;
            break;
          case 12:
            serializationObject[targetPropertyName] = sourceProperty.asArray();
            break;
        }
      }
    }
    return serializationObject;
  }
  /**
   * Given a source json and a destination object in a scene, this function will parse the source and will try to apply its content to the destination object
   * @param source the source json data
   * @param destination the destination object
   * @param scene the scene where the object is
   * @param rootUrl root url to use to load assets
   */
  static ParseProperties(source, destination, scene, rootUrl) {
    if (!rootUrl) {
      rootUrl = "";
    }
    const classStore = GetMergedStore(destination);
    for (const property in classStore) {
      const propertyDescriptor = classStore[property];
      const sourceProperty = source[propertyDescriptor.sourceName || property];
      const propertyType = propertyDescriptor.type;
      if (sourceProperty !== void 0 && sourceProperty !== null && (property !== "uniqueId" || SerializationHelper.AllowLoadingUniqueId)) {
        const dest = destination;
        switch (propertyType) {
          case 0:
            dest[property] = sourceProperty;
            break;
          case 1:
            if (scene) {
              dest[property] = SerializationHelper._TextureParser(sourceProperty, scene, rootUrl);
            }
            break;
          case 2:
            dest[property] = Color3.FromArray(sourceProperty);
            break;
          case 3:
            dest[property] = SerializationHelper._FresnelParametersParser(sourceProperty);
            break;
          case 4:
            dest[property] = Vector2.FromArray(sourceProperty);
            break;
          case 5:
            dest[property] = Vector3.FromArray(sourceProperty);
            break;
          case 6:
            if (scene) {
              dest[property] = scene.getLastMeshById(sourceProperty);
            }
            break;
          case 7:
            dest[property] = SerializationHelper._ColorCurvesParser(sourceProperty);
            break;
          case 8:
            dest[property] = Color4.FromArray(sourceProperty);
            break;
          case 9:
            dest[property] = SerializationHelper._ImageProcessingConfigurationParser(sourceProperty);
            break;
          case 10:
            dest[property] = Quaternion.FromArray(sourceProperty);
            break;
          case 11:
            if (scene) {
              dest[property] = scene.getCameraById(sourceProperty);
            }
            break;
          case 12:
            dest[property] = Matrix.FromArray(sourceProperty);
            break;
        }
      }
    }
  }
  /**
   * Creates a new entity from a serialization data object
   * @param creationFunction defines a function used to instanciated the new entity
   * @param source defines the source serialization data
   * @param scene defines the hosting scene
   * @param rootUrl defines the root url for resources
   * @returns a new entity
   */
  static Parse(creationFunction, source, scene, rootUrl = null) {
    const destination = creationFunction();
    if (Tags) {
      Tags.AddTagsTo(destination, source.tags);
    }
    SerializationHelper.ParseProperties(source, destination, scene, rootUrl);
    return destination;
  }
  /**
   * Clones an object
   * @param creationFunction defines the function used to instanciate the new object
   * @param source defines the source object
   * @param options defines the options to use
   * @returns the cloned object
   */
  static Clone(creationFunction, source, options = {}) {
    return _copySource(creationFunction, source, false, options);
  }
  /**
   * Instanciates a new object based on a source one (some data will be shared between both object)
   * @param creationFunction defines the function used to instanciate the new object
   * @param source defines the source object
   * @returns the new object
   */
  static Instanciate(creationFunction, source) {
    return _copySource(creationFunction, source, true);
  }
}
SerializationHelper.AllowLoadingUniqueId = false;
SerializationHelper._ImageProcessingConfigurationParser = (sourceProperty) => {
  throw _WarnImport("ImageProcessingConfiguration");
};
SerializationHelper._FresnelParametersParser = (sourceProperty) => {
  throw _WarnImport("FresnelParameters");
};
SerializationHelper._ColorCurvesParser = (sourceProperty) => {
  throw _WarnImport("ColorCurves");
};
SerializationHelper._TextureParser = (sourceProperty, scene, rootUrl) => {
  throw _WarnImport("Texture");
};
class _InternalNodeDataInfo {
  constructor() {
    this._doNotSerialize = false;
    this._isDisposed = false;
    this._sceneRootNodesIndex = -1;
    this._isEnabled = true;
    this._isParentEnabled = true;
    this._isReady = true;
    this._onEnabledStateChangedObservable = new Observable();
    this._onClonedObservable = new Observable();
  }
}
class Node {
  /**
   * Add a new node constructor
   * @param type defines the type name of the node to construct
   * @param constructorFunc defines the constructor function
   */
  static AddNodeConstructor(type, constructorFunc) {
    this._NodeConstructors[type] = constructorFunc;
  }
  /**
   * Returns a node constructor based on type name
   * @param type defines the type name
   * @param name defines the new node name
   * @param scene defines the hosting scene
   * @param options defines optional options to transmit to constructors
   * @returns the new constructor or null
   */
  static Construct(type, name2, scene, options) {
    const constructorFunc = this._NodeConstructors[type];
    if (!constructorFunc) {
      return null;
    }
    return constructorFunc(name2, scene, options);
  }
  /**
   * Gets or sets the accessibility tag to describe the node for accessibility purpose.
   */
  set accessibilityTag(value) {
    this._accessibilityTag = value;
    this.onAccessibilityTagChangedObservable.notifyObservers(value);
  }
  get accessibilityTag() {
    return this._accessibilityTag;
  }
  /**
   * Gets or sets a boolean used to define if the node must be serialized
   */
  get doNotSerialize() {
    if (this._nodeDataStorage._doNotSerialize) {
      return true;
    }
    if (this._parentNode) {
      return this._parentNode.doNotSerialize;
    }
    return false;
  }
  set doNotSerialize(value) {
    this._nodeDataStorage._doNotSerialize = value;
  }
  /**
   * Gets a boolean indicating if the node has been disposed
   * @returns true if the node was disposed
   */
  isDisposed() {
    return this._nodeDataStorage._isDisposed;
  }
  /**
   * Gets or sets the parent of the node (without keeping the current position in the scene)
   * @see https://doc.babylonjs.com/features/featuresDeepDive/mesh/transforms/parent_pivot/parent
   */
  set parent(parent) {
    if (this._parentNode === parent) {
      return;
    }
    const previousParentNode = this._parentNode;
    if (this._parentNode && this._parentNode._children !== void 0 && this._parentNode._children !== null) {
      const index2 = this._parentNode._children.indexOf(this);
      if (index2 !== -1) {
        this._parentNode._children.splice(index2, 1);
      }
      if (!parent && !this._nodeDataStorage._isDisposed) {
        this._addToSceneRootNodes();
      }
    }
    this._parentNode = parent;
    this._isDirty = true;
    if (this._parentNode) {
      if (this._parentNode._children === void 0 || this._parentNode._children === null) {
        this._parentNode._children = new Array();
      }
      this._parentNode._children.push(this);
      if (!previousParentNode) {
        this._removeFromSceneRootNodes();
      }
    }
    this._syncParentEnabledState();
  }
  get parent() {
    return this._parentNode;
  }
  /**
   * @internal
   */
  _serializeAsParent(serializationObject) {
    serializationObject.parentId = this.uniqueId;
  }
  /** @internal */
  _addToSceneRootNodes() {
    if (this._nodeDataStorage._sceneRootNodesIndex === -1) {
      this._nodeDataStorage._sceneRootNodesIndex = this._scene.rootNodes.length;
      this._scene.rootNodes.push(this);
    }
  }
  /** @internal */
  _removeFromSceneRootNodes() {
    if (this._nodeDataStorage._sceneRootNodesIndex !== -1) {
      const rootNodes = this._scene.rootNodes;
      const lastIdx = rootNodes.length - 1;
      rootNodes[this._nodeDataStorage._sceneRootNodesIndex] = rootNodes[lastIdx];
      rootNodes[this._nodeDataStorage._sceneRootNodesIndex]._nodeDataStorage._sceneRootNodesIndex = this._nodeDataStorage._sceneRootNodesIndex;
      this._scene.rootNodes.pop();
      this._nodeDataStorage._sceneRootNodesIndex = -1;
    }
  }
  /**
   * Gets or sets the animation properties override
   */
  get animationPropertiesOverride() {
    if (!this._animationPropertiesOverride) {
      return this._scene.animationPropertiesOverride;
    }
    return this._animationPropertiesOverride;
  }
  set animationPropertiesOverride(value) {
    this._animationPropertiesOverride = value;
  }
  /**
   * Gets a string identifying the name of the class
   * @returns "Node" string
   */
  getClassName() {
    return "Node";
  }
  /**
   * Sets a callback that will be raised when the node will be disposed
   */
  set onDispose(callback) {
    if (this._onDisposeObserver) {
      this.onDisposeObservable.remove(this._onDisposeObserver);
    }
    this._onDisposeObserver = this.onDisposeObservable.add(callback);
  }
  /**
   * An event triggered when the enabled state of the node changes
   */
  get onEnabledStateChangedObservable() {
    return this._nodeDataStorage._onEnabledStateChangedObservable;
  }
  /**
   * An event triggered when the node is cloned
   */
  get onClonedObservable() {
    return this._nodeDataStorage._onClonedObservable;
  }
  /**
   * Creates a new Node
   * @param name the name and id to be given to this node
   * @param scene the scene this node will be added to
   * @param isPure indicates this Node is just a Node, and not a derived class like Mesh or Camera
   */
  constructor(name2, scene = null, isPure = true) {
    this._isDirty = false;
    this._nodeDataStorage = new _InternalNodeDataInfo();
    this.state = "";
    this.metadata = null;
    this.reservedDataStore = null;
    this._accessibilityTag = null;
    this.onAccessibilityTagChangedObservable = new Observable();
    this._parentContainer = null;
    this.animations = [];
    this._ranges = {};
    this.onReady = null;
    this._currentRenderId = -1;
    this._parentUpdateId = -1;
    this._childUpdateId = -1;
    this._waitingParentId = null;
    this._waitingParentInstanceIndex = null;
    this._waitingParsedUniqueId = null;
    this._cache = {};
    this._parentNode = null;
    this._children = null;
    this._worldMatrix = Matrix.Identity();
    this._worldMatrixDeterminant = 0;
    this._worldMatrixDeterminantIsDirty = true;
    this._animationPropertiesOverride = null;
    this._isNode = true;
    this.onDisposeObservable = new Observable();
    this._onDisposeObserver = null;
    this._behaviors = new Array();
    this.name = name2;
    this.id = name2;
    this._scene = scene || EngineStore.LastCreatedScene;
    this.uniqueId = this._scene.getUniqueId();
    this._initCache();
    if (isPure) {
      this._addToSceneRootNodes();
    }
  }
  /**
   * Gets the scene of the node
   * @returns a scene
   */
  getScene() {
    return this._scene;
  }
  /**
   * Gets the engine of the node
   * @returns a Engine
   */
  getEngine() {
    return this._scene.getEngine();
  }
  /**
   * Attach a behavior to the node
   * @see https://doc.babylonjs.com/features/featuresDeepDive/behaviors
   * @param behavior defines the behavior to attach
   * @param attachImmediately defines that the behavior must be attached even if the scene is still loading
   * @returns the current Node
   */
  addBehavior(behavior, attachImmediately = false) {
    const index2 = this._behaviors.indexOf(behavior);
    if (index2 !== -1) {
      return this;
    }
    behavior.init();
    if (this._scene.isLoading && !attachImmediately) {
      this._scene.onDataLoadedObservable.addOnce(() => {
        behavior.attach(this);
      });
    } else {
      behavior.attach(this);
    }
    this._behaviors.push(behavior);
    return this;
  }
  /**
   * Remove an attached behavior
   * @see https://doc.babylonjs.com/features/featuresDeepDive/behaviors
   * @param behavior defines the behavior to attach
   * @returns the current Node
   */
  removeBehavior(behavior) {
    const index2 = this._behaviors.indexOf(behavior);
    if (index2 === -1) {
      return this;
    }
    this._behaviors[index2].detach();
    this._behaviors.splice(index2, 1);
    return this;
  }
  /**
   * Gets the list of attached behaviors
   * @see https://doc.babylonjs.com/features/featuresDeepDive/behaviors
   */
  get behaviors() {
    return this._behaviors;
  }
  /**
   * Gets an attached behavior by name
   * @param name defines the name of the behavior to look for
   * @see https://doc.babylonjs.com/features/featuresDeepDive/behaviors
   * @returns null if behavior was not found else the requested behavior
   */
  getBehaviorByName(name2) {
    for (const behavior of this._behaviors) {
      if (behavior.name === name2) {
        return behavior;
      }
    }
    return null;
  }
  /**
   * Returns the latest update of the World matrix
   * @returns a Matrix
   */
  getWorldMatrix() {
    if (this._currentRenderId !== this._scene.getRenderId()) {
      this.computeWorldMatrix();
    }
    return this._worldMatrix;
  }
  /** @internal */
  _getWorldMatrixDeterminant() {
    if (this._worldMatrixDeterminantIsDirty) {
      this._worldMatrixDeterminantIsDirty = false;
      this._worldMatrixDeterminant = this._worldMatrix.determinant();
    }
    return this._worldMatrixDeterminant;
  }
  /**
   * Returns directly the latest state of the mesh World matrix.
   * A Matrix is returned.
   */
  get worldMatrixFromCache() {
    return this._worldMatrix;
  }
  // override it in derived class if you add new variables to the cache
  // and call the parent class method
  /** @internal */
  _initCache() {
    this._cache = {};
  }
  /**
   * @internal
   */
  updateCache(force) {
    if (!force && this.isSynchronized()) {
      return;
    }
    this._updateCache();
  }
  /**
   * @internal
   */
  _getActionManagerForTrigger(trigger, _initialCall = true) {
    if (!this.parent) {
      return null;
    }
    return this.parent._getActionManagerForTrigger(trigger, false);
  }
  // override it in derived class if you add new variables to the cache
  // and call the parent class method if !ignoreParentClass
  /**
   * @internal
   */
  _updateCache(_ignoreParentClass) {
  }
  // override it in derived class if you add new variables to the cache
  /** @internal */
  _isSynchronized() {
    return true;
  }
  /** @internal */
  _markSyncedWithParent() {
    if (this._parentNode) {
      this._parentUpdateId = this._parentNode._childUpdateId;
    }
  }
  /** @internal */
  isSynchronizedWithParent() {
    if (!this._parentNode) {
      return true;
    }
    if (this._parentNode._isDirty || this._parentUpdateId !== this._parentNode._childUpdateId) {
      return false;
    }
    return this._parentNode.isSynchronized();
  }
  /** @internal */
  isSynchronized() {
    if (this._parentNode && !this.isSynchronizedWithParent()) {
      return false;
    }
    return this._isSynchronized();
  }
  /**
   * Is this node ready to be used/rendered
   * @param _completeCheck defines if a complete check (including materials and lights) has to be done (false by default)
   * @returns true if the node is ready
   */
  isReady(_completeCheck = false) {
    return this._nodeDataStorage._isReady;
  }
  /**
   * Flag the  node as dirty (Forcing it to update everything)
   * @param _property helps children apply precise "dirtyfication"
   * @returns this node
   */
  markAsDirty(_property) {
    this._currentRenderId = Number.MAX_VALUE;
    this._isDirty = true;
    return this;
  }
  /**
   * Is this node enabled?
   * If the node has a parent, all ancestors will be checked and false will be returned if any are false (not enabled), otherwise will return true
   * @param checkAncestors indicates if this method should check the ancestors. The default is to check the ancestors. If set to false, the method will return the value of this node without checking ancestors
   * @returns whether this node (and its parent) is enabled
   */
  isEnabled(checkAncestors = true) {
    if (checkAncestors === false) {
      return this._nodeDataStorage._isEnabled;
    }
    if (!this._nodeDataStorage._isEnabled) {
      return false;
    }
    return this._nodeDataStorage._isParentEnabled;
  }
  /** @internal */
  _syncParentEnabledState() {
    this._nodeDataStorage._isParentEnabled = this._parentNode ? this._parentNode.isEnabled() : true;
    if (this._children) {
      this._children.forEach((c2) => {
        c2._syncParentEnabledState();
      });
    }
  }
  /**
   * Set the enabled state of this node
   * @param value defines the new enabled state
   */
  setEnabled(value) {
    if (this._nodeDataStorage._isEnabled === value) {
      return;
    }
    this._nodeDataStorage._isEnabled = value;
    this._syncParentEnabledState();
    this._nodeDataStorage._onEnabledStateChangedObservable.notifyObservers(value);
  }
  /**
   * Is this node a descendant of the given node?
   * The function will iterate up the hierarchy until the ancestor was found or no more parents defined
   * @param ancestor defines the parent node to inspect
   * @returns a boolean indicating if this node is a descendant of the given node
   */
  isDescendantOf(ancestor) {
    if (this.parent) {
      if (this.parent === ancestor) {
        return true;
      }
      return this.parent.isDescendantOf(ancestor);
    }
    return false;
  }
  /**
   * @internal
   */
  _getDescendants(results, directDescendantsOnly = false, predicate) {
    if (!this._children) {
      return;
    }
    for (let index2 = 0; index2 < this._children.length; index2++) {
      const item = this._children[index2];
      if (!predicate || predicate(item)) {
        results.push(item);
      }
      if (!directDescendantsOnly) {
        item._getDescendants(results, false, predicate);
      }
    }
  }
  /**
   * Will return all nodes that have this node as ascendant
   * @param directDescendantsOnly defines if true only direct descendants of 'this' will be considered, if false direct and also indirect (children of children, an so on in a recursive manner) descendants of 'this' will be considered
   * @param predicate defines an optional predicate that will be called on every evaluated child, the predicate must return true for a given child to be part of the result, otherwise it will be ignored
   * @returns all children nodes of all types
   */
  getDescendants(directDescendantsOnly, predicate) {
    const results = [];
    this._getDescendants(results, directDescendantsOnly, predicate);
    return results;
  }
  /**
   * Get all child-meshes of this node
   * @param directDescendantsOnly defines if true only direct descendants of 'this' will be considered, if false direct and also indirect (children of children, an so on in a recursive manner) descendants of 'this' will be considered (Default: false)
   * @param predicate defines an optional predicate that will be called on every evaluated child, the predicate must return true for a given child to be part of the result, otherwise it will be ignored
   * @returns an array of AbstractMesh
   */
  getChildMeshes(directDescendantsOnly, predicate) {
    const results = [];
    this._getDescendants(results, directDescendantsOnly, (node) => {
      return (!predicate || predicate(node)) && node.cullingStrategy !== void 0;
    });
    return results;
  }
  /**
   * Get all direct children of this node
   * @param predicate defines an optional predicate that will be called on every evaluated child, the predicate must return true for a given child to be part of the result, otherwise it will be ignored
   * @param directDescendantsOnly defines if true only direct descendants of 'this' will be considered, if false direct and also indirect (children of children, an so on in a recursive manner) descendants of 'this' will be considered (Default: true)
   * @returns an array of Node
   */
  getChildren(predicate, directDescendantsOnly = true) {
    return this.getDescendants(directDescendantsOnly, predicate);
  }
  /**
   * @internal
   */
  _setReady(state) {
    if (state === this._nodeDataStorage._isReady) {
      return;
    }
    if (!state) {
      this._nodeDataStorage._isReady = false;
      return;
    }
    if (this.onReady) {
      this.onReady(this);
    }
    this._nodeDataStorage._isReady = true;
  }
  /**
   * Get an animation by name
   * @param name defines the name of the animation to look for
   * @returns null if not found else the requested animation
   */
  getAnimationByName(name2) {
    for (let i2 = 0; i2 < this.animations.length; i2++) {
      const animation = this.animations[i2];
      if (animation.name === name2) {
        return animation;
      }
    }
    return null;
  }
  /**
   * Creates an animation range for this node
   * @param name defines the name of the range
   * @param from defines the starting key
   * @param to defines the end key
   */
  createAnimationRange(name2, from, to) {
    if (!this._ranges[name2]) {
      this._ranges[name2] = Node._AnimationRangeFactory(name2, from, to);
      for (let i2 = 0, nAnimations = this.animations.length; i2 < nAnimations; i2++) {
        if (this.animations[i2]) {
          this.animations[i2].createRange(name2, from, to);
        }
      }
    }
  }
  /**
   * Delete a specific animation range
   * @param name defines the name of the range to delete
   * @param deleteFrames defines if animation frames from the range must be deleted as well
   */
  deleteAnimationRange(name2, deleteFrames = true) {
    for (let i2 = 0, nAnimations = this.animations.length; i2 < nAnimations; i2++) {
      if (this.animations[i2]) {
        this.animations[i2].deleteRange(name2, deleteFrames);
      }
    }
    this._ranges[name2] = null;
  }
  /**
   * Get an animation range by name
   * @param name defines the name of the animation range to look for
   * @returns null if not found else the requested animation range
   */
  getAnimationRange(name2) {
    return this._ranges[name2] || null;
  }
  /**
   * Clone the current node
   * @param name Name of the new clone
   * @param newParent New parent for the clone
   * @param doNotCloneChildren Do not clone children hierarchy
   * @returns the new transform node
   */
  clone(name2, newParent, doNotCloneChildren) {
    const result = SerializationHelper.Clone(() => new Node(name2, this.getScene()), this);
    if (newParent) {
      result.parent = newParent;
    }
    if (!doNotCloneChildren) {
      const directDescendants = this.getDescendants(true);
      for (let index2 = 0; index2 < directDescendants.length; index2++) {
        const child = directDescendants[index2];
        child.clone(name2 + "." + child.name, result);
      }
    }
    return result;
  }
  /**
   * Gets the list of all animation ranges defined on this node
   * @returns an array
   */
  getAnimationRanges() {
    const animationRanges = [];
    let name2;
    for (name2 in this._ranges) {
      animationRanges.push(this._ranges[name2]);
    }
    return animationRanges;
  }
  /**
   * Will start the animation sequence
   * @param name defines the range frames for animation sequence
   * @param loop defines if the animation should loop (false by default)
   * @param speedRatio defines the speed factor in which to run the animation (1 by default)
   * @param onAnimationEnd defines a function to be executed when the animation ended (undefined by default)
   * @returns the object created for this animation. If range does not exist, it will return null
   */
  beginAnimation(name2, loop, speedRatio, onAnimationEnd) {
    const range = this.getAnimationRange(name2);
    if (!range) {
      return null;
    }
    return this._scene.beginAnimation(this, range.from, range.to, loop, speedRatio, onAnimationEnd);
  }
  /**
   * Serialize animation ranges into a JSON compatible object
   * @returns serialization object
   */
  serializeAnimationRanges() {
    const serializationRanges = [];
    for (const name2 in this._ranges) {
      const localRange = this._ranges[name2];
      if (!localRange) {
        continue;
      }
      const range = {};
      range.name = name2;
      range.from = localRange.from;
      range.to = localRange.to;
      serializationRanges.push(range);
    }
    return serializationRanges;
  }
  /**
   * Computes the world matrix of the node
   * @param _force defines if the cache version should be invalidated forcing the world matrix to be created from scratch
   * @returns the world matrix
   */
  computeWorldMatrix(_force) {
    if (!this._worldMatrix) {
      this._worldMatrix = Matrix.Identity();
    }
    return this._worldMatrix;
  }
  /**
   * Releases resources associated with this node.
   * @param doNotRecurse Set to true to not recurse into each children (recurse into each children by default)
   * @param disposeMaterialAndTextures Set to true to also dispose referenced materials and textures (false by default)
   */
  dispose(doNotRecurse, disposeMaterialAndTextures = false) {
    this._nodeDataStorage._isDisposed = true;
    if (!doNotRecurse) {
      const nodes = this.getDescendants(true);
      for (const node of nodes) {
        node.dispose(doNotRecurse, disposeMaterialAndTextures);
      }
    }
    if (!this.parent) {
      this._removeFromSceneRootNodes();
    } else {
      this.parent = null;
    }
    this.onDisposeObservable.notifyObservers(this);
    this.onDisposeObservable.clear();
    this.onEnabledStateChangedObservable.clear();
    this.onClonedObservable.clear();
    for (const behavior of this._behaviors) {
      behavior.detach();
    }
    this._behaviors.length = 0;
    this.metadata = null;
  }
  /**
   * Parse animation range data from a serialization object and store them into a given node
   * @param node defines where to store the animation ranges
   * @param parsedNode defines the serialization object to read data from
   * @param _scene defines the hosting scene
   */
  static ParseAnimationRanges(node, parsedNode, _scene) {
    if (parsedNode.ranges) {
      for (let index2 = 0; index2 < parsedNode.ranges.length; index2++) {
        const data = parsedNode.ranges[index2];
        node.createAnimationRange(data.name, data.from, data.to);
      }
    }
  }
  /**
   * Return the minimum and maximum world vectors of the entire hierarchy under current node
   * @param includeDescendants Include bounding info from descendants as well (true by default)
   * @param predicate defines a callback function that can be customize to filter what meshes should be included in the list used to compute the bounding vectors
   * @returns the new bounding vectors
   */
  getHierarchyBoundingVectors(includeDescendants = true, predicate = null) {
    this.getScene().incrementRenderId();
    this.computeWorldMatrix(true);
    let min;
    let max;
    const thisAbstractMesh = this;
    if (thisAbstractMesh.getBoundingInfo && thisAbstractMesh.subMeshes) {
      const boundingInfo = thisAbstractMesh.getBoundingInfo();
      min = boundingInfo.boundingBox.minimumWorld.clone();
      max = boundingInfo.boundingBox.maximumWorld.clone();
    } else {
      min = new Vector3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE);
      max = new Vector3(-Number.MAX_VALUE, -Number.MAX_VALUE, -Number.MAX_VALUE);
    }
    if (includeDescendants) {
      const descendants = this.getDescendants(false);
      for (const descendant of descendants) {
        const childMesh = descendant;
        childMesh.computeWorldMatrix(true);
        if (predicate && !predicate(childMesh)) {
          continue;
        }
        if (!childMesh.getBoundingInfo || childMesh.getTotalVertices() === 0) {
          continue;
        }
        const childBoundingInfo = childMesh.getBoundingInfo();
        const boundingBox = childBoundingInfo.boundingBox;
        const minBox = boundingBox.minimumWorld;
        const maxBox = boundingBox.maximumWorld;
        Vector3.CheckExtends(minBox, min, max);
        Vector3.CheckExtends(maxBox, min, max);
      }
    }
    return {
      min,
      max
    };
  }
}
Node._AnimationRangeFactory = (_name, _from, _to) => {
  throw _WarnImport("AnimationRange");
};
Node._NodeConstructors = {};
__decorate([
  serialize()
], Node.prototype, "name", void 0);
__decorate([
  serialize()
], Node.prototype, "id", void 0);
__decorate([
  serialize()
], Node.prototype, "uniqueId", void 0);
__decorate([
  serialize()
], Node.prototype, "state", void 0);
__decorate([
  serialize()
], Node.prototype, "metadata", void 0);
function IsWindowObjectExist() {
  return typeof window !== "undefined";
}
function IsNavigatorAvailable() {
  return typeof navigator !== "undefined";
}
function IsDocumentAvailable() {
  return typeof document !== "undefined";
}
function GetDOMTextContent(element) {
  let result = "";
  let child = element.firstChild;
  while (child) {
    if (child.nodeType === 3) {
      result += child.textContent;
    }
    child = child.nextSibling;
  }
  return result;
}
class Logger {
  static _CheckLimit(message, limit) {
    let entry = Logger._LogLimitOutputs[message];
    if (!entry) {
      entry = { limit, current: 1 };
      Logger._LogLimitOutputs[message] = entry;
    } else {
      entry.current++;
    }
    return entry.current <= entry.limit;
  }
  static _GenerateLimitMessage(message, level = 1) {
    const entry = Logger._LogLimitOutputs[message];
    if (!entry || !Logger.MessageLimitReached) {
      return;
    }
    const type = this._Levels[level];
    if (entry.current === entry.limit) {
      Logger[type.name](Logger.MessageLimitReached.replace(/%LIMIT%/g, "" + entry.limit).replace(/%TYPE%/g, type.name ?? ""));
    }
  }
  static _AddLogEntry(entry) {
    Logger._LogCache = entry + Logger._LogCache;
    if (Logger.OnNewCacheEntry) {
      Logger.OnNewCacheEntry(entry);
    }
  }
  static _FormatMessage(message) {
    const padStr = (i2) => i2 < 10 ? "0" + i2 : "" + i2;
    const date = /* @__PURE__ */ new Date();
    return "[" + padStr(date.getHours()) + ":" + padStr(date.getMinutes()) + ":" + padStr(date.getSeconds()) + "]: " + message;
  }
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  static _LogDisabled(message, limit) {
  }
  static _LogEnabled(level = 1, message, limit) {
    const msg = Array.isArray(message) ? message[0] : message;
    if (limit !== void 0 && !Logger._CheckLimit(msg, limit)) {
      return;
    }
    const formattedMessage = Logger._FormatMessage(msg);
    const type = this._Levels[level];
    const optionals = Array.isArray(message) ? message.slice(1) : [];
    type.logFunc && type.logFunc("BJS - " + formattedMessage, ...optionals);
    const entry = `<div style='color:${type.color}'>${formattedMessage}</div><br>`;
    Logger._AddLogEntry(entry);
    Logger._GenerateLimitMessage(msg, level);
  }
  /**
   * Gets current log cache (list of logs)
   */
  static get LogCache() {
    return Logger._LogCache;
  }
  /**
   * Clears the log cache
   */
  static ClearLogCache() {
    Logger._LogCache = "";
    Logger._LogLimitOutputs = {};
    Logger.errorsCount = 0;
  }
  /**
   * Sets the current log level. This property is a bit field, allowing you to combine different levels (MessageLogLevel / WarningLogLevel / ErrorLogLevel).
   * Use NoneLogLevel to disable logging and AllLogLevel for a quick way to enable all levels.
   */
  static set LogLevels(level) {
    Logger.Log = Logger._LogDisabled;
    Logger.Warn = Logger._LogDisabled;
    Logger.Error = Logger._LogDisabled;
    [Logger.MessageLogLevel, Logger.WarningLogLevel, Logger.ErrorLogLevel].forEach((l2) => {
      if ((level & l2) === l2) {
        const type = this._Levels[l2];
        Logger[type.name] = Logger._LogEnabled.bind(Logger, l2);
      }
    });
  }
}
Logger.NoneLogLevel = 0;
Logger.MessageLogLevel = 1;
Logger.WarningLogLevel = 2;
Logger.ErrorLogLevel = 4;
Logger.AllLogLevel = 7;
Logger.MessageLimitReached = "Too many %TYPE%s (%LIMIT%), no more %TYPE%s will be reported for this message.";
Logger._LogCache = "";
Logger._LogLimitOutputs = {};
Logger._Levels = [
  {},
  { color: "white", logFunc: console.log, name: "Log" },
  { color: "orange", logFunc: console.warn, name: "Warn" },
  {},
  { color: "red", logFunc: console.error, name: "Error" }
];
Logger.errorsCount = 0;
Logger.Log = Logger._LogEnabled.bind(Logger, Logger.MessageLogLevel);
Logger.Warn = Logger._LogEnabled.bind(Logger, Logger.WarningLogLevel);
Logger.Error = Logger._LogEnabled.bind(Logger, Logger.ErrorLogLevel);
const CloneValue = (source, destinationObject, shallowCopyValues) => {
  if (!source) {
    return null;
  }
  if (source.getClassName && source.getClassName() === "Mesh") {
    return null;
  }
  if (source.getClassName && (source.getClassName() === "SubMesh" || source.getClassName() === "PhysicsBody")) {
    return source.clone(destinationObject);
  } else if (source.clone) {
    return source.clone();
  } else if (Array.isArray(source)) {
    return source.slice();
  } else if (shallowCopyValues && typeof source === "object") {
    return { ...source };
  }
  return null;
};
function GetAllPropertyNames(obj) {
  const props = [];
  do {
    Object.getOwnPropertyNames(obj).forEach(function(prop) {
      if (props.indexOf(prop) === -1) {
        props.push(prop);
      }
    });
  } while (obj = Object.getPrototypeOf(obj));
  return props;
}
class DeepCopier {
  /**
   * Tries to copy an object by duplicating every property
   * @param source defines the source object
   * @param destination defines the target object
   * @param doNotCopyList defines a list of properties to avoid
   * @param mustCopyList defines a list of properties to copy (even if they start with _)
   * @param shallowCopyValues defines wether properties referencing objects (none cloneable) must be shallow copied (false by default)
   * @remarks shallowCopyValues will not instantite the copied values which makes it only usable for "JSON objects"
   */
  static DeepCopy(source, destination, doNotCopyList, mustCopyList, shallowCopyValues = false) {
    const properties = GetAllPropertyNames(source);
    for (const prop of properties) {
      if (prop[0] === "_" && (!mustCopyList || mustCopyList.indexOf(prop) === -1)) {
        continue;
      }
      if (prop.endsWith("Observable")) {
        continue;
      }
      if (doNotCopyList && doNotCopyList.indexOf(prop) !== -1) {
        continue;
      }
      const sourceValue = source[prop];
      const typeOfSourceValue = typeof sourceValue;
      if (typeOfSourceValue === "function") {
        continue;
      }
      try {
        if (typeOfSourceValue === "object") {
          if (sourceValue instanceof Uint8Array) {
            destination[prop] = Uint8Array.from(sourceValue);
          } else if (sourceValue instanceof Array) {
            destination[prop] = [];
            if (sourceValue.length > 0) {
              if (typeof sourceValue[0] == "object") {
                for (let index2 = 0; index2 < sourceValue.length; index2++) {
                  const clonedValue = CloneValue(sourceValue[index2], destination, shallowCopyValues);
                  if (destination[prop].indexOf(clonedValue) === -1) {
                    destination[prop].push(clonedValue);
                  }
                }
              } else {
                destination[prop] = sourceValue.slice(0);
              }
            }
          } else {
            destination[prop] = CloneValue(sourceValue, destination, shallowCopyValues);
          }
        } else {
          destination[prop] = sourceValue;
        }
      } catch (e2) {
        Logger.Warn(e2.message);
      }
    }
  }
}
class PrecisionDate {
  /**
   * Gets either window.performance.now() if supported or Date.now() else
   */
  static get Now() {
    if (IsWindowObjectExist() && window.performance && window.performance.now) {
      return window.performance.now();
    }
    return Date.now();
  }
}
function createXMLHttpRequest() {
  if (typeof _native !== "undefined" && _native.XMLHttpRequest) {
    return new _native.XMLHttpRequest();
  } else {
    return new XMLHttpRequest();
  }
}
class WebRequest {
  constructor() {
    this._xhr = createXMLHttpRequest();
    this._requestURL = "";
  }
  /**
   * This function can be called to check if there are request modifiers for network requests
   * @returns true if there are any custom requests available
   */
  static get IsCustomRequestAvailable() {
    return Object.keys(WebRequest.CustomRequestHeaders).length > 0 || WebRequest.CustomRequestModifiers.length > 0;
  }
  /**
   * Returns the requested URL once open has been called
   */
  get requestURL() {
    return this._requestURL;
  }
  _injectCustomRequestHeaders() {
    if (this._shouldSkipRequestModifications(this._requestURL)) {
      return;
    }
    for (const key in WebRequest.CustomRequestHeaders) {
      const val = WebRequest.CustomRequestHeaders[key];
      if (val) {
        this._xhr.setRequestHeader(key, val);
      }
    }
  }
  _shouldSkipRequestModifications(url) {
    return WebRequest.SkipRequestModificationForBabylonCDN && (url.includes("preview.babylonjs.com") || url.includes("cdn.babylonjs.com"));
  }
  /**
   * Gets or sets a function to be called when loading progress changes
   */
  get onprogress() {
    return this._xhr.onprogress;
  }
  set onprogress(value) {
    this._xhr.onprogress = value;
  }
  /**
   * Returns client's state
   */
  get readyState() {
    return this._xhr.readyState;
  }
  /**
   * Returns client's status
   */
  get status() {
    return this._xhr.status;
  }
  /**
   * Returns client's status as a text
   */
  get statusText() {
    return this._xhr.statusText;
  }
  /**
   * Returns client's response
   */
  get response() {
    return this._xhr.response;
  }
  /**
   * Returns client's response url
   */
  get responseURL() {
    return this._xhr.responseURL;
  }
  /**
   * Returns client's response as text
   */
  get responseText() {
    return this._xhr.responseText;
  }
  /**
   * Gets or sets the expected response type
   */
  get responseType() {
    return this._xhr.responseType;
  }
  set responseType(value) {
    this._xhr.responseType = value;
  }
  /**
   * Gets or sets the timeout value in milliseconds
   */
  get timeout() {
    return this._xhr.timeout;
  }
  set timeout(value) {
    this._xhr.timeout = value;
  }
  addEventListener(type, listener, options) {
    this._xhr.addEventListener(type, listener, options);
  }
  removeEventListener(type, listener, options) {
    this._xhr.removeEventListener(type, listener, options);
  }
  /**
   * Cancels any network activity
   */
  abort() {
    this._xhr.abort();
  }
  /**
   * Initiates the request. The optional argument provides the request body. The argument is ignored if request method is GET or HEAD
   * @param body defines an optional request body
   */
  send(body) {
    if (WebRequest.CustomRequestHeaders) {
      this._injectCustomRequestHeaders();
    }
    this._xhr.send(body);
  }
  /**
   * Sets the request method, request URL
   * @param method defines the method to use (GET, POST, etc..)
   * @param url defines the url to connect with
   */
  open(method, url) {
    for (const update of WebRequest.CustomRequestModifiers) {
      if (this._shouldSkipRequestModifications(url)) {
        return;
      }
      url = update(this._xhr, url) || url;
    }
    url = url.replace("file:http:", "http:");
    url = url.replace("file:https:", "https:");
    this._requestURL = url;
    this._xhr.open(method, url, true);
  }
  /**
   * Sets the value of a request header.
   * @param name The name of the header whose value is to be set
   * @param value The value to set as the body of the header
   */
  setRequestHeader(name2, value) {
    this._xhr.setRequestHeader(name2, value);
  }
  /**
   * Get the string containing the text of a particular header's value.
   * @param name The name of the header
   * @returns The string containing the text of the given header name
   */
  getResponseHeader(name2) {
    return this._xhr.getResponseHeader(name2);
  }
}
WebRequest.CustomRequestHeaders = {};
WebRequest.CustomRequestModifiers = new Array();
WebRequest.SkipRequestModificationForBabylonCDN = true;
class FilesInputStore {
}
FilesInputStore.FilesToLoad = {};
class RetryStrategy {
  /**
   * Function used to defines an exponential back off strategy
   * @param maxRetries defines the maximum number of retries (3 by default)
   * @param baseInterval defines the interval between retries
   * @returns the strategy function to use
   */
  static ExponentialBackoff(maxRetries = 3, baseInterval = 500) {
    return (url, request, retryIndex) => {
      if (request.status !== 0 || retryIndex >= maxRetries || url.indexOf("file:") !== -1) {
        return -1;
      }
      return Math.pow(2, retryIndex) * baseInterval;
    };
  }
}
class BaseError extends Error {
}
BaseError._setPrototypeOf = Object.setPrototypeOf || ((o2, proto) => {
  o2.__proto__ = proto;
  return o2;
});
const ErrorCodes = {
  // Mesh errors 0-999
  /** Invalid or empty mesh vertex positions. */
  MeshInvalidPositionsError: 0,
  // Texture errors 1000-1999
  /** Unsupported texture found. */
  UnsupportedTextureError: 1e3,
  // GLTFLoader errors 2000-2999
  /** Unexpected magic number found in GLTF file header. */
  GLTFLoaderUnexpectedMagicError: 2e3,
  // SceneLoader errors 3000-3999
  /** SceneLoader generic error code. Ideally wraps the inner exception. */
  SceneLoaderError: 3e3,
  // File related errors 4000-4999
  /** Load file error */
  LoadFileError: 4e3,
  /** Request file error */
  RequestFileError: 4001,
  /** Read file error */
  ReadFileError: 4002
};
class RuntimeError extends BaseError {
  /**
   * Creates a new RuntimeError
   * @param message defines the message of the error
   * @param errorCode the error code
   * @param innerError the error that caused the outer error
   */
  constructor(message, errorCode, innerError) {
    super(message);
    this.errorCode = errorCode;
    this.innerError = innerError;
    this.name = "RuntimeError";
    BaseError._setPrototypeOf(this, RuntimeError.prototype);
  }
}
class AbortError extends BaseError {
  constructor(message = "Operation aborted") {
    super(message);
    this.name = "AbortError";
    BaseError._setPrototypeOf(this, AbortError.prototype);
  }
}
const Decode = (buffer) => {
  if (typeof TextDecoder !== "undefined") {
    return new TextDecoder().decode(buffer);
  }
  let result = "";
  for (let i2 = 0; i2 < buffer.byteLength; i2++) {
    result += String.fromCharCode(buffer[i2]);
  }
  return result;
};
const EncodeArrayBufferToBase64 = (buffer) => {
  const keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
  let output = "";
  let chr1, chr2, chr3, enc1, enc2, enc3, enc4;
  let i2 = 0;
  const bytes = ArrayBuffer.isView(buffer) ? new Uint8Array(buffer.buffer, buffer.byteOffset, buffer.byteLength) : new Uint8Array(buffer);
  while (i2 < bytes.length) {
    chr1 = bytes[i2++];
    chr2 = i2 < bytes.length ? bytes[i2++] : Number.NaN;
    chr3 = i2 < bytes.length ? bytes[i2++] : Number.NaN;
    enc1 = chr1 >> 2;
    enc2 = (chr1 & 3) << 4 | chr2 >> 4;
    enc3 = (chr2 & 15) << 2 | chr3 >> 6;
    enc4 = chr3 & 63;
    if (isNaN(chr2)) {
      enc3 = enc4 = 64;
    } else if (isNaN(chr3)) {
      enc4 = 64;
    }
    output += keyStr.charAt(enc1) + keyStr.charAt(enc2) + keyStr.charAt(enc3) + keyStr.charAt(enc4);
  }
  return output;
};
const DecodeBase64ToString = (base64Data) => {
  return atob(base64Data);
};
const DecodeBase64ToBinary = (base64Data) => {
  const decodedString = DecodeBase64ToString(base64Data);
  const bufferLength = decodedString.length;
  const bufferView = new Uint8Array(new ArrayBuffer(bufferLength));
  for (let i2 = 0; i2 < bufferLength; i2++) {
    bufferView[i2] = decodedString.charCodeAt(i2);
  }
  return bufferView.buffer;
};
const defaultAttributeKeywordName = "attribute";
const defaultVaryingKeywordName = "varying";
class ShaderCodeNode {
  constructor() {
    this.children = [];
  }
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  isValid(preprocessors) {
    return true;
  }
  process(preprocessors, options) {
    var _a2, _b, _c, _d, _e, _f;
    let result = "";
    if (this.line) {
      let value = this.line;
      const processor = options.processor;
      if (processor) {
        if (processor.lineProcessor) {
          value = processor.lineProcessor(value, options.isFragment, options.processingContext);
        }
        const attributeKeyword = ((_a2 = options.processor) == null ? void 0 : _a2.attributeKeywordName) ?? defaultAttributeKeywordName;
        const varyingKeyword = options.isFragment && ((_b = options.processor) == null ? void 0 : _b.varyingFragmentKeywordName) ? (_c = options.processor) == null ? void 0 : _c.varyingFragmentKeywordName : !options.isFragment && ((_d = options.processor) == null ? void 0 : _d.varyingVertexKeywordName) ? (_e = options.processor) == null ? void 0 : _e.varyingVertexKeywordName : defaultVaryingKeywordName;
        if (!options.isFragment && processor.attributeProcessor && this.line.startsWith(attributeKeyword)) {
          value = processor.attributeProcessor(this.line, preprocessors, options.processingContext);
        } else if (processor.varyingProcessor && (((_f = processor.varyingCheck) == null ? void 0 : _f.call(processor, this.line, options.isFragment)) || !processor.varyingCheck && this.line.startsWith(varyingKeyword))) {
          value = processor.varyingProcessor(this.line, options.isFragment, preprocessors, options.processingContext);
        } else if (processor.uniformProcessor && processor.uniformRegexp && processor.uniformRegexp.test(this.line)) {
          if (!options.lookForClosingBracketForUniformBuffer) {
            value = processor.uniformProcessor(this.line, options.isFragment, preprocessors, options.processingContext);
          }
        } else if (processor.uniformBufferProcessor && processor.uniformBufferRegexp && processor.uniformBufferRegexp.test(this.line)) {
          if (!options.lookForClosingBracketForUniformBuffer) {
            value = processor.uniformBufferProcessor(this.line, options.isFragment, options.processingContext);
            options.lookForClosingBracketForUniformBuffer = true;
          }
        } else if (processor.textureProcessor && processor.textureRegexp && processor.textureRegexp.test(this.line)) {
          value = processor.textureProcessor(this.line, options.isFragment, preprocessors, options.processingContext);
        } else if ((processor.uniformProcessor || processor.uniformBufferProcessor) && this.line.startsWith("uniform") && !options.lookForClosingBracketForUniformBuffer) {
          const regex = /uniform\s+(?:(?:highp)?|(?:lowp)?)\s*(\S+)\s+(\S+)\s*;/;
          if (regex.test(this.line)) {
            if (processor.uniformProcessor) {
              value = processor.uniformProcessor(this.line, options.isFragment, preprocessors, options.processingContext);
            }
          } else {
            if (processor.uniformBufferProcessor) {
              value = processor.uniformBufferProcessor(this.line, options.isFragment, options.processingContext);
              options.lookForClosingBracketForUniformBuffer = true;
            }
          }
        }
        if (options.lookForClosingBracketForUniformBuffer && this.line.indexOf("}") !== -1) {
          options.lookForClosingBracketForUniformBuffer = false;
          if (processor.endOfUniformBufferProcessor) {
            value = processor.endOfUniformBufferProcessor(this.line, options.isFragment, options.processingContext);
          }
        }
      }
      result += value + "\n";
    }
    this.children.forEach((child) => {
      result += child.process(preprocessors, options);
    });
    if (this.additionalDefineKey) {
      preprocessors[this.additionalDefineKey] = this.additionalDefineValue || "true";
    }
    return result;
  }
}
class ShaderCodeCursor {
  constructor() {
    this._lines = [];
  }
  get currentLine() {
    return this._lines[this.lineIndex];
  }
  get canRead() {
    return this.lineIndex < this._lines.length - 1;
  }
  set lines(value) {
    this._lines.length = 0;
    for (const line of value) {
      if (!line || line === "\r") {
        continue;
      }
      if (line[0] === "#") {
        this._lines.push(line);
        continue;
      }
      const trimmedLine = line.trim();
      if (!trimmedLine) {
        continue;
      }
      if (trimmedLine.startsWith("//")) {
        this._lines.push(line);
        continue;
      }
      const semicolonIndex = trimmedLine.indexOf(";");
      if (semicolonIndex === -1) {
        this._lines.push(trimmedLine);
      } else if (semicolonIndex === trimmedLine.length - 1) {
        if (trimmedLine.length > 1) {
          this._lines.push(trimmedLine);
        }
      } else {
        const split = line.split(";");
        for (let index2 = 0; index2 < split.length; index2++) {
          let subLine = split[index2];
          if (!subLine) {
            continue;
          }
          subLine = subLine.trim();
          if (!subLine) {
            continue;
          }
          this._lines.push(subLine + (index2 !== split.length - 1 ? ";" : ""));
        }
      }
    }
  }
}
class ShaderCodeConditionNode extends ShaderCodeNode {
  process(preprocessors, options) {
    for (let index2 = 0; index2 < this.children.length; index2++) {
      const node = this.children[index2];
      if (node.isValid(preprocessors)) {
        return node.process(preprocessors, options);
      }
    }
    return "";
  }
}
class ShaderCodeTestNode extends ShaderCodeNode {
  isValid(preprocessors) {
    return this.testExpression.isTrue(preprocessors);
  }
}
class ShaderDefineExpression {
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  isTrue(preprocessors) {
    return true;
  }
  static postfixToInfix(postfix) {
    const stack = [];
    for (const c2 of postfix) {
      if (ShaderDefineExpression._OperatorPriority[c2] === void 0) {
        stack.push(c2);
      } else {
        const v1 = stack[stack.length - 1], v2 = stack[stack.length - 2];
        stack.length -= 2;
        stack.push(`(${v2}${c2}${v1})`);
      }
    }
    return stack[stack.length - 1];
  }
  /**
   * Converts an infix expression to a postfix expression.
   *
   * This method is used to transform infix expressions, which are more human-readable,
   * into postfix expressions, also known as Reverse Polish Notation (RPN), that can be
   * evaluated more efficiently by a computer. The conversion is based on the operator
   * priority defined in _OperatorPriority.
   *
   * The function employs a stack-based algorithm for the conversion and caches the result
   * to improve performance. The cache keeps track of each converted expression's access time
   * to manage the cache size and optimize memory usage. When the cache size exceeds a specified
   * limit, the least recently accessed items in the cache are deleted.
   *
   * The cache mechanism is particularly helpful for shader compilation, where the same infix
   * expressions might be encountered repeatedly, hence the caching can speed up the process.
   *
   * @param infix - The infix expression to be converted.
   * @returns The postfix expression as an array of strings.
   */
  static infixToPostfix(infix) {
    const cacheItem = ShaderDefineExpression._InfixToPostfixCache.get(infix);
    if (cacheItem) {
      cacheItem.accessTime = Date.now();
      return cacheItem.result;
    }
    if (!infix.includes("&&") && !infix.includes("||") && !infix.includes(")") && !infix.includes("(")) {
      return [infix];
    }
    const result = [];
    let stackIdx = -1;
    const pushOperand = () => {
      operand = operand.trim();
      if (operand !== "") {
        result.push(operand);
        operand = "";
      }
    };
    const push = (s2) => {
      if (stackIdx < ShaderDefineExpression._Stack.length - 1) {
        ShaderDefineExpression._Stack[++stackIdx] = s2;
      }
    };
    const peek = () => ShaderDefineExpression._Stack[stackIdx];
    const pop = () => stackIdx === -1 ? "!!INVALID EXPRESSION!!" : ShaderDefineExpression._Stack[stackIdx--];
    let idx = 0, operand = "";
    while (idx < infix.length) {
      const c2 = infix.charAt(idx), token = idx < infix.length - 1 ? infix.substring(idx, 2 + idx) : "";
      if (c2 === "(") {
        operand = "";
        push(c2);
      } else if (c2 === ")") {
        pushOperand();
        while (stackIdx !== -1 && peek() !== "(") {
          result.push(pop());
        }
        pop();
      } else if (ShaderDefineExpression._OperatorPriority[token] > 1) {
        pushOperand();
        while (stackIdx !== -1 && ShaderDefineExpression._OperatorPriority[peek()] >= ShaderDefineExpression._OperatorPriority[token]) {
          result.push(pop());
        }
        push(token);
        idx++;
      } else {
        operand += c2;
      }
      idx++;
    }
    pushOperand();
    while (stackIdx !== -1) {
      if (peek() === "(") {
        pop();
      } else {
        result.push(pop());
      }
    }
    if (ShaderDefineExpression._InfixToPostfixCache.size >= ShaderDefineExpression.InfixToPostfixCacheLimitSize) {
      ShaderDefineExpression.ClearCache();
    }
    ShaderDefineExpression._InfixToPostfixCache.set(infix, { result, accessTime: Date.now() });
    return result;
  }
  static ClearCache() {
    const sortedCache = Array.from(ShaderDefineExpression._InfixToPostfixCache.entries()).sort((a2, b2) => a2[1].accessTime - b2[1].accessTime);
    for (let i2 = 0; i2 < ShaderDefineExpression.InfixToPostfixCacheCleanupSize; i2++) {
      ShaderDefineExpression._InfixToPostfixCache.delete(sortedCache[i2][0]);
    }
  }
}
ShaderDefineExpression.InfixToPostfixCacheLimitSize = 5e4;
ShaderDefineExpression.InfixToPostfixCacheCleanupSize = 25e3;
ShaderDefineExpression._InfixToPostfixCache = /* @__PURE__ */ new Map();
ShaderDefineExpression._OperatorPriority = {
  ")": 0,
  "(": 1,
  "||": 2,
  "&&": 3
};
ShaderDefineExpression._Stack = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""];
class ShaderDefineIsDefinedOperator extends ShaderDefineExpression {
  constructor(define, not = false) {
    super();
    this.define = define;
    this.not = not;
  }
  isTrue(preprocessors) {
    let condition = preprocessors[this.define] !== void 0;
    if (this.not) {
      condition = !condition;
    }
    return condition;
  }
}
class ShaderDefineOrOperator extends ShaderDefineExpression {
  isTrue(preprocessors) {
    return this.leftOperand.isTrue(preprocessors) || this.rightOperand.isTrue(preprocessors);
  }
}
class ShaderDefineAndOperator extends ShaderDefineExpression {
  isTrue(preprocessors) {
    return this.leftOperand.isTrue(preprocessors) && this.rightOperand.isTrue(preprocessors);
  }
}
class ShaderDefineArithmeticOperator extends ShaderDefineExpression {
  constructor(define, operand, testValue) {
    super();
    this.define = define;
    this.operand = operand;
    this.testValue = testValue;
  }
  isTrue(preprocessors) {
    let value = preprocessors[this.define];
    if (value === void 0) {
      value = this.define;
    }
    let condition = false;
    const left = parseInt(value);
    const right = parseInt(this.testValue);
    switch (this.operand) {
      case ">":
        condition = left > right;
        break;
      case "<":
        condition = left < right;
        break;
      case "<=":
        condition = left <= right;
        break;
      case ">=":
        condition = left >= right;
        break;
      case "==":
        condition = left === right;
        break;
      case "!=":
        condition = left !== right;
        break;
    }
    return condition;
  }
}
const EngineFunctionContext = {};
function _ConcatenateShader(source, defines, shaderVersion = "") {
  return shaderVersion + (defines ? defines + "\n" : "") + source;
}
function _loadFile(url, onSuccess, onProgress, offlineProvider, useArrayBuffer, onError, injectedLoadFile) {
  const loadFile = injectedLoadFile || EngineFunctionContext.loadFile;
  if (loadFile) {
    const request = loadFile(url, onSuccess, onProgress, offlineProvider, useArrayBuffer, onError);
    return request;
  }
  throw _WarnImport("FileTools");
}
function _getGlobalDefines(defines, isNDCHalfZRange, useReverseDepthBuffer, useExactSrgbConversions) {
  if (defines) {
    if (isNDCHalfZRange) {
      defines["IS_NDC_HALF_ZRANGE"] = "";
    } else {
      delete defines["IS_NDC_HALF_ZRANGE"];
    }
    if (useReverseDepthBuffer) {
      defines["USE_REVERSE_DEPTHBUFFER"] = "";
    } else {
      delete defines["USE_REVERSE_DEPTHBUFFER"];
    }
    if (useExactSrgbConversions) {
      defines["USE_EXACT_SRGB_CONVERSIONS"] = "";
    } else {
      delete defines["USE_EXACT_SRGB_CONVERSIONS"];
    }
    return;
  } else {
    let s2 = "";
    if (isNDCHalfZRange) {
      s2 += "#define IS_NDC_HALF_ZRANGE";
    }
    if (useReverseDepthBuffer) {
      if (s2) {
        s2 += "\n";
      }
      s2 += "#define USE_REVERSE_DEPTHBUFFER";
    }
    if (useExactSrgbConversions) {
      if (s2) {
        s2 += "\n";
      }
      s2 += "#define USE_EXACT_SRGB_CONVERSIONS";
    }
    return s2;
  }
}
function allocateAndCopyTypedBuffer(type, sizeOrDstBuffer, sizeInBytes = false, copyBuffer) {
  switch (type) {
    case 3: {
      const buffer2 = sizeOrDstBuffer instanceof ArrayBuffer ? new Int8Array(sizeOrDstBuffer) : new Int8Array(sizeOrDstBuffer);
      if (copyBuffer) {
        buffer2.set(new Int8Array(copyBuffer));
      }
      return buffer2;
    }
    case 0: {
      const buffer2 = sizeOrDstBuffer instanceof ArrayBuffer ? new Uint8Array(sizeOrDstBuffer) : new Uint8Array(sizeOrDstBuffer);
      if (copyBuffer) {
        buffer2.set(new Uint8Array(copyBuffer));
      }
      return buffer2;
    }
    case 4: {
      const buffer2 = sizeOrDstBuffer instanceof ArrayBuffer ? new Int16Array(sizeOrDstBuffer) : new Int16Array(sizeInBytes ? sizeOrDstBuffer / 2 : sizeOrDstBuffer);
      if (copyBuffer) {
        buffer2.set(new Int16Array(copyBuffer));
      }
      return buffer2;
    }
    case 5:
    case 8:
    case 9:
    case 10:
    case 2: {
      const buffer2 = sizeOrDstBuffer instanceof ArrayBuffer ? new Uint16Array(sizeOrDstBuffer) : new Uint16Array(sizeInBytes ? sizeOrDstBuffer / 2 : sizeOrDstBuffer);
      if (copyBuffer) {
        buffer2.set(new Uint16Array(copyBuffer));
      }
      return buffer2;
    }
    case 6: {
      const buffer2 = sizeOrDstBuffer instanceof ArrayBuffer ? new Int32Array(sizeOrDstBuffer) : new Int32Array(sizeInBytes ? sizeOrDstBuffer / 4 : sizeOrDstBuffer);
      if (copyBuffer) {
        buffer2.set(new Int32Array(copyBuffer));
      }
      return buffer2;
    }
    case 7:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15: {
      const buffer2 = sizeOrDstBuffer instanceof ArrayBuffer ? new Uint32Array(sizeOrDstBuffer) : new Uint32Array(sizeInBytes ? sizeOrDstBuffer / 4 : sizeOrDstBuffer);
      if (copyBuffer) {
        buffer2.set(new Uint32Array(copyBuffer));
      }
      return buffer2;
    }
    case 1: {
      const buffer2 = sizeOrDstBuffer instanceof ArrayBuffer ? new Float32Array(sizeOrDstBuffer) : new Float32Array(sizeInBytes ? sizeOrDstBuffer / 4 : sizeOrDstBuffer);
      if (copyBuffer) {
        buffer2.set(new Float32Array(copyBuffer));
      }
      return buffer2;
    }
  }
  const buffer = sizeOrDstBuffer instanceof ArrayBuffer ? new Uint8Array(sizeOrDstBuffer) : new Uint8Array(sizeOrDstBuffer);
  if (copyBuffer) {
    buffer.set(new Uint8Array(copyBuffer));
  }
  return buffer;
}
const regexSE = /defined\s*?\((.+?)\)/g;
const regexSERevert = /defined\s*?\[(.+?)\]/g;
const regexShaderInclude = /#include\s?<(.+)>(\((.*)\))*(\[(.*)\])*/g;
const regexShaderDecl = /__decl__/;
const regexLightX = /light\{X\}.(\w*)/g;
const regexX = /\{X\}/g;
const reusableMatches = [];
const _MoveCursorRegex = /(#ifdef)|(#else)|(#elif)|(#endif)|(#ifndef)|(#if)/;
function Initialize(options) {
  if (options.processor && options.processor.initializeShaders) {
    options.processor.initializeShaders(options.processingContext);
  }
}
function Process(sourceCode, options, callback, engine2) {
  var _a2;
  if ((_a2 = options.processor) == null ? void 0 : _a2.preProcessShaderCode) {
    sourceCode = options.processor.preProcessShaderCode(sourceCode, options.isFragment);
  }
  _ProcessIncludes(sourceCode, options, (codeWithIncludes) => {
    if (options.processCodeAfterIncludes) {
      codeWithIncludes = options.processCodeAfterIncludes(options.isFragment ? "fragment" : "vertex", codeWithIncludes, options.defines);
    }
    const migratedCode = _ProcessShaderConversion(codeWithIncludes, options, engine2);
    callback(migratedCode, codeWithIncludes);
  });
}
function Finalize(vertexCode, fragmentCode, options) {
  if (!options.processor || !options.processor.finalizeShaders) {
    return { vertexCode, fragmentCode };
  }
  return options.processor.finalizeShaders(vertexCode, fragmentCode, options.processingContext);
}
function _ProcessPrecision(source, options) {
  var _a2;
  if ((_a2 = options.processor) == null ? void 0 : _a2.noPrecision) {
    return source;
  }
  const shouldUseHighPrecisionShader = options.shouldUseHighPrecisionShader;
  if (source.indexOf("precision highp float") === -1) {
    if (!shouldUseHighPrecisionShader) {
      source = "precision mediump float;\n" + source;
    } else {
      source = "precision highp float;\n" + source;
    }
  } else {
    if (!shouldUseHighPrecisionShader) {
      source = source.replace("precision highp float", "precision mediump float");
    }
  }
  return source;
}
function _ExtractOperation(expression) {
  const regex = /defined\((.+)\)/;
  const match = regex.exec(expression);
  if (match && match.length) {
    return new ShaderDefineIsDefinedOperator(match[1].trim(), expression[0] === "!");
  }
  const operators = ["==", "!=", ">=", "<=", "<", ">"];
  let operator = "";
  let indexOperator = 0;
  for (operator of operators) {
    indexOperator = expression.indexOf(operator);
    if (indexOperator > -1) {
      break;
    }
  }
  if (indexOperator === -1) {
    return new ShaderDefineIsDefinedOperator(expression);
  }
  const define = expression.substring(0, indexOperator).trim();
  const value = expression.substring(indexOperator + operator.length).trim();
  return new ShaderDefineArithmeticOperator(define, operator, value);
}
function _BuildSubExpression(expression) {
  expression = expression.replace(regexSE, "defined[$1]");
  const postfix = ShaderDefineExpression.infixToPostfix(expression);
  const stack = [];
  for (const c2 of postfix) {
    if (c2 !== "||" && c2 !== "&&") {
      stack.push(c2);
    } else if (stack.length >= 2) {
      let v1 = stack[stack.length - 1], v2 = stack[stack.length - 2];
      stack.length -= 2;
      const operator = c2 == "&&" ? new ShaderDefineAndOperator() : new ShaderDefineOrOperator();
      if (typeof v1 === "string") {
        v1 = v1.replace(regexSERevert, "defined($1)");
      }
      if (typeof v2 === "string") {
        v2 = v2.replace(regexSERevert, "defined($1)");
      }
      operator.leftOperand = typeof v2 === "string" ? _ExtractOperation(v2) : v2;
      operator.rightOperand = typeof v1 === "string" ? _ExtractOperation(v1) : v1;
      stack.push(operator);
    }
  }
  let result = stack[stack.length - 1];
  if (typeof result === "string") {
    result = result.replace(regexSERevert, "defined($1)");
  }
  return typeof result === "string" ? _ExtractOperation(result) : result;
}
function _BuildExpression(line, start) {
  const node = new ShaderCodeTestNode();
  const command = line.substring(0, start);
  let expression = line.substring(start);
  expression = expression.substring(0, (expression.indexOf("//") + 1 || expression.length + 1) - 1).trim();
  if (command === "#ifdef") {
    node.testExpression = new ShaderDefineIsDefinedOperator(expression);
  } else if (command === "#ifndef") {
    node.testExpression = new ShaderDefineIsDefinedOperator(expression, true);
  } else {
    node.testExpression = _BuildSubExpression(expression);
  }
  return node;
}
function _MoveCursorWithinIf(cursor, rootNode, ifNode) {
  let line = cursor.currentLine;
  while (_MoveCursor(cursor, ifNode)) {
    line = cursor.currentLine;
    const first5 = line.substring(0, 5).toLowerCase();
    if (first5 === "#else") {
      const elseNode = new ShaderCodeNode();
      rootNode.children.push(elseNode);
      _MoveCursor(cursor, elseNode);
      return;
    } else if (first5 === "#elif") {
      const elifNode = _BuildExpression(line, 5);
      rootNode.children.push(elifNode);
      ifNode = elifNode;
    }
  }
}
function _MoveCursor(cursor, rootNode) {
  while (cursor.canRead) {
    cursor.lineIndex++;
    const line = cursor.currentLine;
    if (line.indexOf("#") >= 0) {
      const matches = _MoveCursorRegex.exec(line);
      if (matches && matches.length) {
        const keyword = matches[0];
        switch (keyword) {
          case "#ifdef": {
            const newRootNode = new ShaderCodeConditionNode();
            rootNode.children.push(newRootNode);
            const ifNode = _BuildExpression(line, 6);
            newRootNode.children.push(ifNode);
            _MoveCursorWithinIf(cursor, newRootNode, ifNode);
            break;
          }
          case "#else":
          case "#elif":
            return true;
          case "#endif":
            return false;
          case "#ifndef": {
            const newRootNode = new ShaderCodeConditionNode();
            rootNode.children.push(newRootNode);
            const ifNode = _BuildExpression(line, 7);
            newRootNode.children.push(ifNode);
            _MoveCursorWithinIf(cursor, newRootNode, ifNode);
            break;
          }
          case "#if": {
            const newRootNode = new ShaderCodeConditionNode();
            const ifNode = _BuildExpression(line, 3);
            rootNode.children.push(newRootNode);
            newRootNode.children.push(ifNode);
            _MoveCursorWithinIf(cursor, newRootNode, ifNode);
            break;
          }
        }
        continue;
      }
    }
    const newNode = new ShaderCodeNode();
    newNode.line = line;
    rootNode.children.push(newNode);
    if (line[0] === "#" && line[1] === "d") {
      const split = line.replace(";", "").split(" ");
      newNode.additionalDefineKey = split[1];
      if (split.length === 3) {
        newNode.additionalDefineValue = split[2];
      }
    }
  }
  return false;
}
function _EvaluatePreProcessors(sourceCode, preprocessors, options) {
  const rootNode = new ShaderCodeNode();
  const cursor = new ShaderCodeCursor();
  cursor.lineIndex = -1;
  cursor.lines = sourceCode.split("\n");
  _MoveCursor(cursor, rootNode);
  return rootNode.process(preprocessors, options);
}
function _PreparePreProcessors(options, engine2) {
  var _a2;
  const defines = options.defines;
  const preprocessors = {};
  for (const define of defines) {
    const keyValue = define.replace("#define", "").replace(";", "").trim();
    const split = keyValue.split(" ");
    preprocessors[split[0]] = split.length > 1 ? split[1] : "";
  }
  if (((_a2 = options.processor) == null ? void 0 : _a2.shaderLanguage) === 0) {
    preprocessors["GL_ES"] = "true";
  }
  preprocessors["__VERSION__"] = options.version;
  preprocessors[options.platformName] = "true";
  _getGlobalDefines(preprocessors, engine2 == null ? void 0 : engine2.isNDCHalfZRange, engine2 == null ? void 0 : engine2.useReverseDepthBuffer, engine2 == null ? void 0 : engine2.useExactSrgbConversions);
  return preprocessors;
}
function _ProcessShaderConversion(sourceCode, options, engine2) {
  let preparedSourceCode = _ProcessPrecision(sourceCode, options);
  if (!options.processor) {
    return preparedSourceCode;
  }
  if (options.processor.shaderLanguage === 0 && preparedSourceCode.indexOf("#version 3") !== -1) {
    preparedSourceCode = preparedSourceCode.replace("#version 300 es", "");
    if (!options.processor.parseGLES3) {
      return preparedSourceCode;
    }
  }
  const defines = options.defines;
  const preprocessors = _PreparePreProcessors(options, engine2);
  if (options.processor.preProcessor) {
    preparedSourceCode = options.processor.preProcessor(preparedSourceCode, defines, preprocessors, options.isFragment, options.processingContext);
  }
  preparedSourceCode = _EvaluatePreProcessors(preparedSourceCode, preprocessors, options);
  if (options.processor.postProcessor) {
    preparedSourceCode = options.processor.postProcessor(preparedSourceCode, defines, options.isFragment, options.processingContext, engine2 ? {
      drawBuffersExtensionDisabled: engine2.getCaps().drawBuffersExtension ? false : true
    } : {});
  }
  if (engine2 == null ? void 0 : engine2._features.needShaderCodeInlining) {
    preparedSourceCode = engine2.inlineShaderCode(preparedSourceCode);
  }
  return preparedSourceCode;
}
function _ProcessIncludes(sourceCode, options, callback) {
  reusableMatches.length = 0;
  let match;
  while ((match = regexShaderInclude.exec(sourceCode)) !== null) {
    reusableMatches.push(match);
  }
  let returnValue = String(sourceCode);
  let parts = [sourceCode];
  let keepProcessing = false;
  for (const match2 of reusableMatches) {
    let includeFile = match2[1];
    if (includeFile.indexOf("__decl__") !== -1) {
      includeFile = includeFile.replace(regexShaderDecl, "");
      if (options.supportsUniformBuffers) {
        includeFile = includeFile.replace("Vertex", "Ubo").replace("Fragment", "Ubo");
      }
      includeFile = includeFile + "Declaration";
    }
    if (options.includesShadersStore[includeFile]) {
      let includeContent = options.includesShadersStore[includeFile];
      if (match2[2]) {
        const splits = match2[3].split(",");
        for (let index2 = 0; index2 < splits.length; index2 += 2) {
          const source = new RegExp(splits[index2], "g");
          const dest = splits[index2 + 1];
          includeContent = includeContent.replace(source, dest);
        }
      }
      if (match2[4]) {
        const indexString = match2[5];
        if (indexString.indexOf("..") !== -1) {
          const indexSplits = indexString.split("..");
          const minIndex = parseInt(indexSplits[0]);
          let maxIndex = parseInt(indexSplits[1]);
          let sourceIncludeContent = includeContent.slice(0);
          includeContent = "";
          if (isNaN(maxIndex)) {
            maxIndex = options.indexParameters[indexSplits[1]];
          }
          for (let i2 = minIndex; i2 < maxIndex; i2++) {
            if (!options.supportsUniformBuffers) {
              sourceIncludeContent = sourceIncludeContent.replace(regexLightX, (str, p1) => {
                return p1 + "{X}";
              });
            }
            includeContent += sourceIncludeContent.replace(regexX, i2.toString()) + "\n";
          }
        } else {
          if (!options.supportsUniformBuffers) {
            includeContent = includeContent.replace(regexLightX, (str, p1) => {
              return p1 + "{X}";
            });
          }
          includeContent = includeContent.replace(regexX, indexString);
        }
      }
      const newParts = [];
      for (const part of parts) {
        const splitPart = part.split(match2[0]);
        for (let i2 = 0; i2 < splitPart.length - 1; i2++) {
          newParts.push(splitPart[i2]);
          newParts.push(includeContent);
        }
        newParts.push(splitPart[splitPart.length - 1]);
      }
      parts = newParts;
      keepProcessing = keepProcessing || includeContent.indexOf("#include<") >= 0 || includeContent.indexOf("#include <") >= 0;
    } else {
      const includeShaderUrl = options.shadersRepository + "ShadersInclude/" + includeFile + ".fx";
      _functionContainer.loadFile(includeShaderUrl, (fileContent) => {
        options.includesShadersStore[includeFile] = fileContent;
        _ProcessIncludes(parts.join(""), options, callback);
      });
      return;
    }
  }
  reusableMatches.length = 0;
  returnValue = parts.join("");
  if (keepProcessing) {
    _ProcessIncludes(returnValue.toString(), options, callback);
  } else {
    callback(returnValue);
  }
}
const _functionContainer = {
  /**
   * Loads a file from a url
   * @param url url to load
   * @param onSuccess callback called when the file successfully loads
   * @param onProgress callback called while file is loading (if the server supports this mode)
   * @param offlineProvider defines the offline provider for caching
   * @param useArrayBuffer defines a boolean indicating that date must be returned as ArrayBuffer
   * @param onError callback called when the file fails to load
   * @returns a file request object
   * @internal
   */
  loadFile: (url, onSuccess, onProgress, offlineProvider, useArrayBuffer, onError) => {
    throw _WarnImport("FileTools");
  }
};
let _immediateQueue = [];
class TimingTools {
  /**
   * Execute a function after the current execution block
   * @param action defines the action to execute after the current execution block
   */
  static SetImmediate(action) {
    if (_immediateQueue.length === 0) {
      setTimeout(() => {
        const functionsToCall = _immediateQueue;
        _immediateQueue = [];
        for (const func of functionsToCall) {
          func();
        }
      }, 1);
    }
    _immediateQueue.push(action);
  }
}
function _runWithCondition(condition, onSuccess, onError) {
  try {
    if (condition()) {
      onSuccess();
      return true;
    }
  } catch (e2) {
    onError == null ? void 0 : onError(e2);
    return true;
  }
  return false;
}
const _retryWithInterval = (condition, onSuccess, onError, step = 16, maxTimeout = 3e4, checkConditionOnCall = true, additionalStringOnTimeout) => {
  if (checkConditionOnCall) {
    if (_runWithCondition(condition, onSuccess, onError)) {
      return null;
    }
  }
  const int = setInterval(() => {
    if (_runWithCondition(condition, onSuccess, onError)) {
      clearInterval(int);
    } else {
      maxTimeout -= step;
      if (maxTimeout < 0) {
        clearInterval(int);
        onError == null ? void 0 : onError(new Error("Operation timed out after maximum retries. " + (additionalStringOnTimeout || "")), true);
      }
    }
  }, step);
  return () => clearInterval(int);
};
class ShaderStore {
  /**
   * Gets the shaders repository path for a given shader language
   * @param shaderLanguage the shader language
   * @returns the path to the shaders repository
   */
  static GetShadersRepository(shaderLanguage = 0) {
    return shaderLanguage === 0 ? ShaderStore.ShadersRepository : ShaderStore.ShadersRepositoryWGSL;
  }
  /**
   * Gets the shaders store of a given shader language
   * @param shaderLanguage the shader language
   * @returns the shaders store
   */
  static GetShadersStore(shaderLanguage = 0) {
    return shaderLanguage === 0 ? ShaderStore.ShadersStore : ShaderStore.ShadersStoreWGSL;
  }
  /**
   * Gets the include shaders store of a given shader language
   * @param shaderLanguage the shader language
   * @returns the include shaders store
   */
  static GetIncludesShadersStore(shaderLanguage = 0) {
    return shaderLanguage === 0 ? ShaderStore.IncludesShadersStore : ShaderStore.IncludesShadersStoreWGSL;
  }
}
ShaderStore.ShadersRepository = "src/Shaders/";
ShaderStore.ShadersStore = {};
ShaderStore.IncludesShadersStore = {};
ShaderStore.ShadersRepositoryWGSL = "src/ShadersWGSL/";
ShaderStore.ShadersStoreWGSL = {};
ShaderStore.IncludesShadersStoreWGSL = {};
class WebGLPipelineContext {
  constructor() {
    this._valueCache = {};
    this.vertexCompilationError = null;
    this.fragmentCompilationError = null;
    this.programLinkError = null;
    this.programValidationError = null;
    this._isDisposed = false;
  }
  get isAsync() {
    return this.isParallelCompiled;
  }
  get isReady() {
    if (this.program) {
      if (this.isParallelCompiled) {
        return this.engine._isRenderingStateCompiled(this);
      }
      return true;
    }
    return false;
  }
  _handlesSpectorRebuildCallback(onCompiled) {
    if (onCompiled && this.program) {
      onCompiled(this.program);
    }
  }
  setEngine(engine2) {
    this.engine = engine2;
  }
  _fillEffectInformation(effect, uniformBuffersNames, uniformsNames, uniforms, samplerList, samplers, attributesNames, attributes) {
    const engine2 = this.engine;
    if (engine2.supportsUniformBuffers) {
      for (const name2 in uniformBuffersNames) {
        effect.bindUniformBlock(name2, uniformBuffersNames[name2]);
      }
    }
    const effectAvailableUniforms = this.engine.getUniforms(this, uniformsNames);
    effectAvailableUniforms.forEach((uniform, index3) => {
      uniforms[uniformsNames[index3]] = uniform;
    });
    this._uniforms = uniforms;
    let index2;
    for (index2 = 0; index2 < samplerList.length; index2++) {
      const sampler = effect.getUniform(samplerList[index2]);
      if (sampler == null) {
        samplerList.splice(index2, 1);
        index2--;
      }
    }
    samplerList.forEach((name2, index3) => {
      samplers[name2] = index3;
    });
    for (const attr of engine2.getAttributes(this, attributesNames)) {
      attributes.push(attr);
    }
  }
  /**
   * Release all associated resources.
   **/
  dispose() {
    this._uniforms = {};
    this._isDisposed = true;
  }
  /**
   * @internal
   */
  _cacheMatrix(uniformName, matrix) {
    const cache = this._valueCache[uniformName];
    const flag = matrix.updateFlag;
    if (cache !== void 0 && cache === flag) {
      return false;
    }
    this._valueCache[uniformName] = flag;
    return true;
  }
  /**
   * @internal
   */
  _cacheFloat2(uniformName, x2, y2) {
    let cache = this._valueCache[uniformName];
    if (!cache || cache.length !== 2) {
      cache = [x2, y2];
      this._valueCache[uniformName] = cache;
      return true;
    }
    let changed = false;
    if (cache[0] !== x2) {
      cache[0] = x2;
      changed = true;
    }
    if (cache[1] !== y2) {
      cache[1] = y2;
      changed = true;
    }
    return changed;
  }
  /**
   * @internal
   */
  _cacheFloat3(uniformName, x2, y2, z2) {
    let cache = this._valueCache[uniformName];
    if (!cache || cache.length !== 3) {
      cache = [x2, y2, z2];
      this._valueCache[uniformName] = cache;
      return true;
    }
    let changed = false;
    if (cache[0] !== x2) {
      cache[0] = x2;
      changed = true;
    }
    if (cache[1] !== y2) {
      cache[1] = y2;
      changed = true;
    }
    if (cache[2] !== z2) {
      cache[2] = z2;
      changed = true;
    }
    return changed;
  }
  /**
   * @internal
   */
  _cacheFloat4(uniformName, x2, y2, z2, w) {
    let cache = this._valueCache[uniformName];
    if (!cache || cache.length !== 4) {
      cache = [x2, y2, z2, w];
      this._valueCache[uniformName] = cache;
      return true;
    }
    let changed = false;
    if (cache[0] !== x2) {
      cache[0] = x2;
      changed = true;
    }
    if (cache[1] !== y2) {
      cache[1] = y2;
      changed = true;
    }
    if (cache[2] !== z2) {
      cache[2] = z2;
      changed = true;
    }
    if (cache[3] !== w) {
      cache[3] = w;
      changed = true;
    }
    return changed;
  }
  /**
   * Sets an integer value on a uniform variable.
   * @param uniformName Name of the variable.
   * @param value Value to be set.
   */
  setInt(uniformName, value) {
    const cache = this._valueCache[uniformName];
    if (cache !== void 0 && cache === value) {
      return;
    }
    if (this.engine.setInt(this._uniforms[uniformName], value)) {
      this._valueCache[uniformName] = value;
    }
  }
  /**
   * Sets a int2 on a uniform variable.
   * @param uniformName Name of the variable.
   * @param x First int in int2.
   * @param y Second int in int2.
   */
  setInt2(uniformName, x2, y2) {
    if (this._cacheFloat2(uniformName, x2, y2)) {
      if (!this.engine.setInt2(this._uniforms[uniformName], x2, y2)) {
        this._valueCache[uniformName] = null;
      }
    }
  }
  /**
   * Sets a int3 on a uniform variable.
   * @param uniformName Name of the variable.
   * @param x First int in int3.
   * @param y Second int in int3.
   * @param z Third int in int3.
   */
  setInt3(uniformName, x2, y2, z2) {
    if (this._cacheFloat3(uniformName, x2, y2, z2)) {
      if (!this.engine.setInt3(this._uniforms[uniformName], x2, y2, z2)) {
        this._valueCache[uniformName] = null;
      }
    }
  }
  /**
   * Sets a int4 on a uniform variable.
   * @param uniformName Name of the variable.
   * @param x First int in int4.
   * @param y Second int in int4.
   * @param z Third int in int4.
   * @param w Fourth int in int4.
   */
  setInt4(uniformName, x2, y2, z2, w) {
    if (this._cacheFloat4(uniformName, x2, y2, z2, w)) {
      if (!this.engine.setInt4(this._uniforms[uniformName], x2, y2, z2, w)) {
        this._valueCache[uniformName] = null;
      }
    }
  }
  /**
   * Sets an int array on a uniform variable.
   * @param uniformName Name of the variable.
   * @param array array to be set.
   */
  setIntArray(uniformName, array) {
    this._valueCache[uniformName] = null;
    this.engine.setIntArray(this._uniforms[uniformName], array);
  }
  /**
   * Sets an int array 2 on a uniform variable. (Array is specified as single array eg. [1,2,3,4] will result in [[1,2],[3,4]] in the shader)
   * @param uniformName Name of the variable.
   * @param array array to be set.
   */
  setIntArray2(uniformName, array) {
    this._valueCache[uniformName] = null;
    this.engine.setIntArray2(this._uniforms[uniformName], array);
  }
  /**
   * Sets an int array 3 on a uniform variable. (Array is specified as single array eg. [1,2,3,4,5,6] will result in [[1,2,3],[4,5,6]] in the shader)
   * @param uniformName Name of the variable.
   * @param array array to be set.
   */
  setIntArray3(uniformName, array) {
    this._valueCache[uniformName] = null;
    this.engine.setIntArray3(this._uniforms[uniformName], array);
  }
  /**
   * Sets an int array 4 on a uniform variable. (Array is specified as single array eg. [1,2,3,4,5,6,7,8] will result in [[1,2,3,4],[5,6,7,8]] in the shader)
   * @param uniformName Name of the variable.
   * @param array array to be set.
   */
  setIntArray4(uniformName, array) {
    this._valueCache[uniformName] = null;
    this.engine.setIntArray4(this._uniforms[uniformName], array);
  }
  /**
   * Sets an unsigned integer value on a uniform variable.
   * @param uniformName Name of the variable.
   * @param value Value to be set.
   */
  setUInt(uniformName, value) {
    const cache = this._valueCache[uniformName];
    if (cache !== void 0 && cache === value) {
      return;
    }
    if (this.engine.setUInt(this._uniforms[uniformName], value)) {
      this._valueCache[uniformName] = value;
    }
  }
  /**
   * Sets an unsigned int2 value on a uniform variable.
   * @param uniformName Name of the variable.
   * @param x First unsigned int in uint2.
   * @param y Second unsigned int in uint2.
   */
  setUInt2(uniformName, x2, y2) {
    if (this._cacheFloat2(uniformName, x2, y2)) {
      if (!this.engine.setUInt2(this._uniforms[uniformName], x2, y2)) {
        this._valueCache[uniformName] = null;
      }
    }
  }
  /**
   * Sets an unsigned int3 value on a uniform variable.
   * @param uniformName Name of the variable.
   * @param x First unsigned int in uint3.
   * @param y Second unsigned int in uint3.
   * @param z Third unsigned int in uint3.
   */
  setUInt3(uniformName, x2, y2, z2) {
    if (this._cacheFloat3(uniformName, x2, y2, z2)) {
      if (!this.engine.setUInt3(this._uniforms[uniformName], x2, y2, z2)) {
        this._valueCache[uniformName] = null;
      }
    }
  }
  /**
   * Sets an unsigned int4 value on a uniform variable.
   * @param uniformName Name of the variable.
   * @param x First unsigned int in uint4.
   * @param y Second unsigned int in uint4.
   * @param z Third unsigned int in uint4.
   * @param w Fourth unsigned int in uint4.
   */
  setUInt4(uniformName, x2, y2, z2, w) {
    if (this._cacheFloat4(uniformName, x2, y2, z2, w)) {
      if (!this.engine.setUInt4(this._uniforms[uniformName], x2, y2, z2, w)) {
        this._valueCache[uniformName] = null;
      }
    }
  }
  /**
   * Sets an unsigned int array on a uniform variable.
   * @param uniformName Name of the variable.
   * @param array array to be set.
   */
  setUIntArray(uniformName, array) {
    this._valueCache[uniformName] = null;
    this.engine.setUIntArray(this._uniforms[uniformName], array);
  }
  /**
   * Sets an unsigned int array 2 on a uniform variable. (Array is specified as single array eg. [1,2,3,4] will result in [[1,2],[3,4]] in the shader)
   * @param uniformName Name of the variable.
   * @param array array to be set.
   */
  setUIntArray2(uniformName, array) {
    this._valueCache[uniformName] = null;
    this.engine.setUIntArray2(this._uniforms[uniformName], array);
  }
  /**
   * Sets an unsigned int array 3 on a uniform variable. (Array is specified as single array eg. [1,2,3,4,5,6] will result in [[1,2,3],[4,5,6]] in the shader)
   * @param uniformName Name of the variable.
   * @param array array to be set.
   */
  setUIntArray3(uniformName, array) {
    this._valueCache[uniformName] = null;
    this.engine.setUIntArray3(this._uniforms[uniformName], array);
  }
  /**
   * Sets an unsigned int array 4 on a uniform variable. (Array is specified as single array eg. [1,2,3,4,5,6,7,8] will result in [[1,2,3,4],[5,6,7,8]] in the shader)
   * @param uniformName Name of the variable.
   * @param array array to be set.
   */
  setUIntArray4(uniformName, array) {
    this._valueCache[uniformName] = null;
    this.engine.setUIntArray4(this._uniforms[uniformName], array);
  }
  /**
   * Sets an array on a uniform variable.
   * @param uniformName Name of the variable.
   * @param array array to be set.
   */
  setArray(uniformName, array) {
    this._valueCache[uniformName] = null;
    this.engine.setArray(this._uniforms[uniformName], array);
  }
  /**
   * Sets an array 2 on a uniform variable. (Array is specified as single array eg. [1,2,3,4] will result in [[1,2],[3,4]] in the shader)
   * @param uniformName Name of the variable.
   * @param array array to be set.
   */
  setArray2(uniformName, array) {
    this._valueCache[uniformName] = null;
    this.engine.setArray2(this._uniforms[uniformName], array);
  }
  /**
   * Sets an array 3 on a uniform variable. (Array is specified as single array eg. [1,2,3,4,5,6] will result in [[1,2,3],[4,5,6]] in the shader)
   * @param uniformName Name of the variable.
   * @param array array to be set.
   */
  setArray3(uniformName, array) {
    this._valueCache[uniformName] = null;
    this.engine.setArray3(this._uniforms[uniformName], array);
  }
  /**
   * Sets an array 4 on a uniform variable. (Array is specified as single array eg. [1,2,3,4,5,6,7,8] will result in [[1,2,3,4],[5,6,7,8]] in the shader)
   * @param uniformName Name of the variable.
   * @param array array to be set.
   */
  setArray4(uniformName, array) {
    this._valueCache[uniformName] = null;
    this.engine.setArray4(this._uniforms[uniformName], array);
  }
  /**
   * Sets matrices on a uniform variable.
   * @param uniformName Name of the variable.
   * @param matrices matrices to be set.
   */
  setMatrices(uniformName, matrices) {
    if (!matrices) {
      return;
    }
    this._valueCache[uniformName] = null;
    this.engine.setMatrices(this._uniforms[uniformName], matrices);
  }
  /**
   * Sets matrix on a uniform variable.
   * @param uniformName Name of the variable.
   * @param matrix matrix to be set.
   */
  setMatrix(uniformName, matrix) {
    if (this._cacheMatrix(uniformName, matrix)) {
      if (!this.engine.setMatrices(this._uniforms[uniformName], matrix.asArray())) {
        this._valueCache[uniformName] = null;
      }
    }
  }
  /**
   * Sets a 3x3 matrix on a uniform variable. (Specified as [1,2,3,4,5,6,7,8,9] will result in [1,2,3][4,5,6][7,8,9] matrix)
   * @param uniformName Name of the variable.
   * @param matrix matrix to be set.
   */
  setMatrix3x3(uniformName, matrix) {
    this._valueCache[uniformName] = null;
    this.engine.setMatrix3x3(this._uniforms[uniformName], matrix);
  }
  /**
   * Sets a 2x2 matrix on a uniform variable. (Specified as [1,2,3,4] will result in [1,2][3,4] matrix)
   * @param uniformName Name of the variable.
   * @param matrix matrix to be set.
   */
  setMatrix2x2(uniformName, matrix) {
    this._valueCache[uniformName] = null;
    this.engine.setMatrix2x2(this._uniforms[uniformName], matrix);
  }
  /**
   * Sets a float on a uniform variable.
   * @param uniformName Name of the variable.
   * @param value value to be set.
   */
  setFloat(uniformName, value) {
    const cache = this._valueCache[uniformName];
    if (cache !== void 0 && cache === value) {
      return;
    }
    if (this.engine.setFloat(this._uniforms[uniformName], value)) {
      this._valueCache[uniformName] = value;
    }
  }
  /**
   * Sets a Vector2 on a uniform variable.
   * @param uniformName Name of the variable.
   * @param vector2 vector2 to be set.
   */
  setVector2(uniformName, vector2) {
    if (this._cacheFloat2(uniformName, vector2.x, vector2.y)) {
      if (!this.engine.setFloat2(this._uniforms[uniformName], vector2.x, vector2.y)) {
        this._valueCache[uniformName] = null;
      }
    }
  }
  /**
   * Sets a float2 on a uniform variable.
   * @param uniformName Name of the variable.
   * @param x First float in float2.
   * @param y Second float in float2.
   */
  setFloat2(uniformName, x2, y2) {
    if (this._cacheFloat2(uniformName, x2, y2)) {
      if (!this.engine.setFloat2(this._uniforms[uniformName], x2, y2)) {
        this._valueCache[uniformName] = null;
      }
    }
  }
  /**
   * Sets a Vector3 on a uniform variable.
   * @param uniformName Name of the variable.
   * @param vector3 Value to be set.
   */
  setVector3(uniformName, vector3) {
    if (this._cacheFloat3(uniformName, vector3.x, vector3.y, vector3.z)) {
      if (!this.engine.setFloat3(this._uniforms[uniformName], vector3.x, vector3.y, vector3.z)) {
        this._valueCache[uniformName] = null;
      }
    }
  }
  /**
   * Sets a float3 on a uniform variable.
   * @param uniformName Name of the variable.
   * @param x First float in float3.
   * @param y Second float in float3.
   * @param z Third float in float3.
   */
  setFloat3(uniformName, x2, y2, z2) {
    if (this._cacheFloat3(uniformName, x2, y2, z2)) {
      if (!this.engine.setFloat3(this._uniforms[uniformName], x2, y2, z2)) {
        this._valueCache[uniformName] = null;
      }
    }
  }
  /**
   * Sets a Vector4 on a uniform variable.
   * @param uniformName Name of the variable.
   * @param vector4 Value to be set.
   */
  setVector4(uniformName, vector4) {
    if (this._cacheFloat4(uniformName, vector4.x, vector4.y, vector4.z, vector4.w)) {
      if (!this.engine.setFloat4(this._uniforms[uniformName], vector4.x, vector4.y, vector4.z, vector4.w)) {
        this._valueCache[uniformName] = null;
      }
    }
  }
  /**
   * Sets a Quaternion on a uniform variable.
   * @param uniformName Name of the variable.
   * @param quaternion Value to be set.
   */
  setQuaternion(uniformName, quaternion) {
    if (this._cacheFloat4(uniformName, quaternion.x, quaternion.y, quaternion.z, quaternion.w)) {
      if (!this.engine.setFloat4(this._uniforms[uniformName], quaternion.x, quaternion.y, quaternion.z, quaternion.w)) {
        this._valueCache[uniformName] = null;
      }
    }
  }
  /**
   * Sets a float4 on a uniform variable.
   * @param uniformName Name of the variable.
   * @param x First float in float4.
   * @param y Second float in float4.
   * @param z Third float in float4.
   * @param w Fourth float in float4.
   */
  setFloat4(uniformName, x2, y2, z2, w) {
    if (this._cacheFloat4(uniformName, x2, y2, z2, w)) {
      if (!this.engine.setFloat4(this._uniforms[uniformName], x2, y2, z2, w)) {
        this._valueCache[uniformName] = null;
      }
    }
  }
  /**
   * Sets a Color3 on a uniform variable.
   * @param uniformName Name of the variable.
   * @param color3 Value to be set.
   */
  setColor3(uniformName, color3) {
    if (this._cacheFloat3(uniformName, color3.r, color3.g, color3.b)) {
      if (!this.engine.setFloat3(this._uniforms[uniformName], color3.r, color3.g, color3.b)) {
        this._valueCache[uniformName] = null;
      }
    }
  }
  /**
   * Sets a Color4 on a uniform variable.
   * @param uniformName Name of the variable.
   * @param color3 Value to be set.
   * @param alpha Alpha value to be set.
   */
  setColor4(uniformName, color3, alpha) {
    if (this._cacheFloat4(uniformName, color3.r, color3.g, color3.b, alpha)) {
      if (!this.engine.setFloat4(this._uniforms[uniformName], color3.r, color3.g, color3.b, alpha)) {
        this._valueCache[uniformName] = null;
      }
    }
  }
  /**
   * Sets a Color4 on a uniform variable
   * @param uniformName defines the name of the variable
   * @param color4 defines the value to be set
   */
  setDirectColor4(uniformName, color4) {
    if (this._cacheFloat4(uniformName, color4.r, color4.g, color4.b, color4.a)) {
      if (!this.engine.setFloat4(this._uniforms[uniformName], color4.r, color4.g, color4.b, color4.a)) {
        this._valueCache[uniformName] = null;
      }
    }
  }
  _getVertexShaderCode() {
    return this.vertexShader ? this.engine._getShaderSource(this.vertexShader) : null;
  }
  _getFragmentShaderCode() {
    return this.fragmentShader ? this.engine._getShaderSource(this.fragmentShader) : null;
  }
}
const _stateObject = /* @__PURE__ */ new WeakMap();
const singleStateObject = {
  _webGLVersion: 2,
  cachedPipelines: {}
};
function getStateObject(context) {
  let state = _stateObject.get(context);
  if (!state) {
    if (!context) {
      return singleStateObject;
    }
    state = {
      // use feature detection. instanceof returns false. This only exists on WebGL2 context
      _webGLVersion: context.TEXTURE_BINDING_3D ? 2 : 1,
      _context: context,
      // when using the function without an engine we need to set it to enable parallel compilation
      parallelShaderCompile: context.getExtension("KHR_parallel_shader_compile") || void 0,
      cachedPipelines: {}
    };
    _stateObject.set(context, state);
  }
  return state;
}
function deleteStateObject(context) {
  _stateObject.delete(context);
}
function createRawShaderProgram(pipelineContext, vertexCode, fragmentCode, context, transformFeedbackVaryings, _createShaderProgramInjection) {
  const stateObject = getStateObject(context);
  if (!_createShaderProgramInjection) {
    _createShaderProgramInjection = stateObject._createShaderProgramInjection ?? _createShaderProgram;
  }
  const vertexShader = _compileRawShader(vertexCode, "vertex", context, stateObject._contextWasLost);
  const fragmentShader = _compileRawShader(fragmentCode, "fragment", context, stateObject._contextWasLost);
  return _createShaderProgramInjection(pipelineContext, vertexShader, fragmentShader, context, transformFeedbackVaryings, stateObject.validateShaderPrograms);
}
function createShaderProgram(pipelineContext, vertexCode, fragmentCode, defines, context, transformFeedbackVaryings = null, _createShaderProgramInjection) {
  const stateObject = getStateObject(context);
  if (!_createShaderProgramInjection) {
    _createShaderProgramInjection = stateObject._createShaderProgramInjection ?? _createShaderProgram;
  }
  const shaderVersion = stateObject._webGLVersion > 1 ? "#version 300 es\n#define WEBGL2 \n" : "";
  const vertexShader = _compileShader(vertexCode, "vertex", defines, shaderVersion, context, stateObject._contextWasLost);
  const fragmentShader = _compileShader(fragmentCode, "fragment", defines, shaderVersion, context, stateObject._contextWasLost);
  return _createShaderProgramInjection(pipelineContext, vertexShader, fragmentShader, context, transformFeedbackVaryings, stateObject.validateShaderPrograms);
}
function createPipelineContext(context, _shaderProcessingContext) {
  const pipelineContext = new WebGLPipelineContext();
  const stateObject = getStateObject(context);
  if (stateObject.parallelShaderCompile && !stateObject.disableParallelShaderCompile) {
    pipelineContext.isParallelCompiled = true;
  }
  pipelineContext.context = stateObject._context;
  return pipelineContext;
}
function _createShaderProgram(pipelineContext, vertexShader, fragmentShader, context, _transformFeedbackVaryings = null, validateShaderPrograms) {
  const shaderProgram = context.createProgram();
  pipelineContext.program = shaderProgram;
  if (!shaderProgram) {
    throw new Error("Unable to create program");
  }
  context.attachShader(shaderProgram, vertexShader);
  context.attachShader(shaderProgram, fragmentShader);
  context.linkProgram(shaderProgram);
  pipelineContext.context = context;
  pipelineContext.vertexShader = vertexShader;
  pipelineContext.fragmentShader = fragmentShader;
  if (!pipelineContext.isParallelCompiled) {
    _finalizePipelineContext(pipelineContext, context, validateShaderPrograms);
  }
  return shaderProgram;
}
function _isRenderingStateCompiled(pipelineContext, gl, validateShaderPrograms) {
  const webGLPipelineContext = pipelineContext;
  if (webGLPipelineContext._isDisposed) {
    return false;
  }
  const stateObject = getStateObject(gl);
  if (stateObject && stateObject.parallelShaderCompile && stateObject.parallelShaderCompile.COMPLETION_STATUS_KHR && webGLPipelineContext.program) {
    if (gl.getProgramParameter(webGLPipelineContext.program, stateObject.parallelShaderCompile.COMPLETION_STATUS_KHR)) {
      _finalizePipelineContext(webGLPipelineContext, gl, validateShaderPrograms);
      return true;
    }
  }
  return false;
}
function _finalizePipelineContext(pipelineContext, gl, validateShaderPrograms) {
  const context = pipelineContext.context;
  const vertexShader = pipelineContext.vertexShader;
  const fragmentShader = pipelineContext.fragmentShader;
  const program = pipelineContext.program;
  const linked = context.getProgramParameter(program, context.LINK_STATUS);
  if (!linked) {
    if (!gl.getShaderParameter(vertexShader, gl.COMPILE_STATUS)) {
      const log = gl.getShaderInfoLog(vertexShader);
      if (log) {
        pipelineContext.vertexCompilationError = log;
        throw new Error("VERTEX SHADER " + log);
      }
    }
    if (!gl.getShaderParameter(fragmentShader, gl.COMPILE_STATUS)) {
      const log = gl.getShaderInfoLog(fragmentShader);
      if (log) {
        pipelineContext.fragmentCompilationError = log;
        throw new Error("FRAGMENT SHADER " + log);
      }
    }
    const error = context.getProgramInfoLog(program);
    if (error) {
      pipelineContext.programLinkError = error;
      throw new Error(error);
    }
  }
  if (
    /*this.*/
    validateShaderPrograms
  ) {
    context.validateProgram(program);
    const validated = context.getProgramParameter(program, context.VALIDATE_STATUS);
    if (!validated) {
      const error = context.getProgramInfoLog(program);
      if (error) {
        pipelineContext.programValidationError = error;
        throw new Error(error);
      }
    }
  }
  context.deleteShader(vertexShader);
  context.deleteShader(fragmentShader);
  pipelineContext.vertexShader = void 0;
  pipelineContext.fragmentShader = void 0;
  if (pipelineContext.onCompiled) {
    pipelineContext.onCompiled();
    pipelineContext.onCompiled = void 0;
  }
}
function _preparePipelineContext(pipelineContext, vertexSourceCode, fragmentSourceCode, createAsRaw, _rawVertexSourceCode, _rawFragmentSourceCode, rebuildRebind, defines, transformFeedbackVaryings, _key = "", onReady, createRawShaderProgramInjection, createShaderProgramInjection) {
  const stateObject = getStateObject(pipelineContext.context);
  if (!createRawShaderProgramInjection) {
    createRawShaderProgramInjection = stateObject.createRawShaderProgramInjection ?? createRawShaderProgram;
  }
  if (!createShaderProgramInjection) {
    createShaderProgramInjection = stateObject.createShaderProgramInjection ?? createShaderProgram;
  }
  const webGLRenderingState = pipelineContext;
  if (createAsRaw) {
    webGLRenderingState.program = createRawShaderProgramInjection(webGLRenderingState, vertexSourceCode, fragmentSourceCode, webGLRenderingState.context, transformFeedbackVaryings);
  } else {
    webGLRenderingState.program = createShaderProgramInjection(webGLRenderingState, vertexSourceCode, fragmentSourceCode, defines, webGLRenderingState.context, transformFeedbackVaryings);
  }
  webGLRenderingState.program.__SPECTOR_rebuildProgram = rebuildRebind;
  onReady();
}
function _compileShader(source, type, defines, shaderVersion, gl, _contextWasLost) {
  return _compileRawShader(_ConcatenateShader(source, defines, shaderVersion), type, gl, _contextWasLost);
}
function _compileRawShader(source, type, gl, _contextWasLost) {
  const shader2 = gl.createShader(type === "vertex" ? gl.VERTEX_SHADER : gl.FRAGMENT_SHADER);
  if (!shader2) {
    let error = gl.NO_ERROR;
    let tempError = gl.NO_ERROR;
    while ((tempError = gl.getError()) !== gl.NO_ERROR) {
      error = tempError;
    }
    throw new Error(`Something went wrong while creating a gl ${type} shader object. gl error=${error}, gl isContextLost=${gl.isContextLost()}, _contextWasLost=${_contextWasLost}`);
  }
  gl.shaderSource(shader2, source);
  gl.compileShader(shader2);
  return shader2;
}
function _setProgram(program, gl) {
  gl.useProgram(program);
}
function _executeWhenRenderingStateIsCompiled(pipelineContext, action) {
  const webGLPipelineContext = pipelineContext;
  if (!webGLPipelineContext.isParallelCompiled) {
    action(pipelineContext);
    return;
  }
  const oldHandler = webGLPipelineContext.onCompiled;
  webGLPipelineContext.onCompiled = () => {
    oldHandler == null ? void 0 : oldHandler();
    action(pipelineContext);
  };
}
function getCachedPipeline(name2, context) {
  const stateObject = getStateObject(context);
  return stateObject.cachedPipelines[name2];
}
function resetCachedPipeline(pipeline) {
  const name2 = pipeline._name;
  const context = pipeline.context;
  if (name2 && context) {
    const stateObject = getStateObject(context);
    const cachedPipeline = stateObject.cachedPipelines[name2];
    cachedPipeline == null ? void 0 : cachedPipeline.dispose();
    delete stateObject.cachedPipelines[name2];
  }
}
function _processShaderCode(processorOptions, baseName, processFinalCode, onFinalCodeReady, shaderLanguage, engine2, effectContext) {
  let vertexSource;
  let fragmentSource;
  const hostDocument = IsWindowObjectExist() ? engine2 == null ? void 0 : engine2.getHostDocument() : null;
  if (typeof baseName === "string") {
    vertexSource = baseName;
  } else if (baseName.vertexSource) {
    vertexSource = "source:" + baseName.vertexSource;
  } else if (baseName.vertexElement) {
    vertexSource = (hostDocument == null ? void 0 : hostDocument.getElementById(baseName.vertexElement)) || baseName.vertexElement;
  } else {
    vertexSource = baseName.vertex || baseName;
  }
  if (typeof baseName === "string") {
    fragmentSource = baseName;
  } else if (baseName.fragmentSource) {
    fragmentSource = "source:" + baseName.fragmentSource;
  } else if (baseName.fragmentElement) {
    fragmentSource = (hostDocument == null ? void 0 : hostDocument.getElementById(baseName.fragmentElement)) || baseName.fragmentElement;
  } else {
    fragmentSource = baseName.fragment || baseName;
  }
  const shaderCodes = [void 0, void 0];
  const shadersLoaded = () => {
    if (shaderCodes[0] && shaderCodes[1]) {
      processorOptions.isFragment = true;
      const [migratedVertexCode, fragmentCode] = shaderCodes;
      Process(fragmentCode, processorOptions, (migratedFragmentCode, codeBeforeMigration) => {
        if (effectContext) {
          effectContext._fragmentSourceCodeBeforeMigration = codeBeforeMigration;
        }
        if (processFinalCode) {
          migratedFragmentCode = processFinalCode("fragment", migratedFragmentCode);
        }
        const finalShaders = Finalize(migratedVertexCode, migratedFragmentCode, processorOptions);
        processorOptions = null;
        const finalCode = _useFinalCode(finalShaders.vertexCode, finalShaders.fragmentCode, baseName, shaderLanguage);
        onFinalCodeReady == null ? void 0 : onFinalCodeReady(finalCode.vertexSourceCode, finalCode.fragmentSourceCode);
      }, engine2);
    }
  };
  _loadShader(vertexSource, "Vertex", "", (vertexCode) => {
    Initialize(processorOptions);
    Process(vertexCode, processorOptions, (migratedVertexCode, codeBeforeMigration) => {
      if (effectContext) {
        effectContext._rawVertexSourceCode = vertexCode;
        effectContext._vertexSourceCodeBeforeMigration = codeBeforeMigration;
      }
      if (processFinalCode) {
        migratedVertexCode = processFinalCode("vertex", migratedVertexCode);
      }
      shaderCodes[0] = migratedVertexCode;
      shadersLoaded();
    }, engine2);
  }, shaderLanguage);
  _loadShader(fragmentSource, "Fragment", "Pixel", (fragmentCode) => {
    if (effectContext) {
      effectContext._rawFragmentSourceCode = fragmentCode;
    }
    shaderCodes[1] = fragmentCode;
    shadersLoaded();
  }, shaderLanguage);
}
function _loadShader(shader2, key, optionalKey, callback, shaderLanguage, _loadFileInjection) {
  if (typeof HTMLElement !== "undefined") {
    if (shader2 instanceof HTMLElement) {
      const shaderCode = GetDOMTextContent(shader2);
      callback(shaderCode);
      return;
    }
  }
  if (shader2.substring(0, 7) === "source:") {
    callback(shader2.substring(7));
    return;
  }
  if (shader2.substring(0, 7) === "base64:") {
    const shaderBinary = window.atob(shader2.substring(7));
    callback(shaderBinary);
    return;
  }
  const shaderStore = ShaderStore.GetShadersStore(shaderLanguage);
  if (shaderStore[shader2 + key + "Shader"]) {
    callback(shaderStore[shader2 + key + "Shader"]);
    return;
  }
  if (optionalKey && shaderStore[shader2 + optionalKey + "Shader"]) {
    callback(shaderStore[shader2 + optionalKey + "Shader"]);
    return;
  }
  let shaderUrl;
  if (shader2[0] === "." || shader2[0] === "/" || shader2.indexOf("http") > -1) {
    shaderUrl = shader2;
  } else {
    shaderUrl = ShaderStore.GetShadersRepository(shaderLanguage) + shader2;
  }
  _loadFileInjection = _loadFileInjection || _loadFile;
  if (!_loadFileInjection) {
    throw new Error("loadFileInjection is not defined");
  }
  _loadFileInjection(shaderUrl + "." + key.toLowerCase() + ".fx", callback);
}
function _useFinalCode(migratedVertexCode, migratedFragmentCode, baseName, shaderLanguage) {
  if (baseName) {
    const vertex = baseName.vertexElement || baseName.vertex || baseName.spectorName || baseName;
    const fragment = baseName.fragmentElement || baseName.fragment || baseName.spectorName || baseName;
    return {
      vertexSourceCode: (shaderLanguage === 1 ? "//" : "") + "#define SHADER_NAME vertex:" + vertex + "\n" + migratedVertexCode,
      fragmentSourceCode: (shaderLanguage === 1 ? "//" : "") + "#define SHADER_NAME fragment:" + fragment + "\n" + migratedFragmentCode
    };
  } else {
    return {
      vertexSourceCode: migratedVertexCode,
      fragmentSourceCode: migratedFragmentCode
    };
  }
}
const createAndPreparePipelineContext = (options, createPipelineContext2, _preparePipelineContext2, _executeWhenRenderingStateIsCompiled2) => {
  try {
    const stateObject = options.context ? getStateObject(options.context) : null;
    if (stateObject) {
      stateObject.disableParallelShaderCompile = options.disableParallelCompilation;
    }
    const pipelineContext = options.existingPipelineContext || createPipelineContext2(options.shaderProcessingContext);
    pipelineContext._name = options.name;
    if (options.name && stateObject) {
      stateObject.cachedPipelines[options.name] = pipelineContext;
    }
    _preparePipelineContext2(pipelineContext, options.vertex, options.fragment, !!options.createAsRaw, "", "", options.rebuildRebind, options.defines, options.transformFeedbackVaryings, "", () => {
      _executeWhenRenderingStateIsCompiled2(pipelineContext, () => {
        var _a2;
        (_a2 = options.onRenderingStateCompiled) == null ? void 0 : _a2.call(options, pipelineContext);
      });
    });
    return pipelineContext;
  } catch (e2) {
    Logger.Error("Error compiling effect");
    throw e2;
  }
};
class Effect {
  /**
   * Gets or sets the relative url used to load shaders if using the engine in non-minified mode
   */
  static get ShadersRepository() {
    return ShaderStore.ShadersRepository;
  }
  static set ShadersRepository(repo) {
    ShaderStore.ShadersRepository = repo;
  }
  /**
   * Gets a boolean indicating that the effect was already disposed
   */
  get isDisposed() {
    return this._isDisposed;
  }
  /**
   * Observable that will be called when effect is bound.
   */
  get onBindObservable() {
    if (!this._onBindObservable) {
      this._onBindObservable = new Observable();
    }
    return this._onBindObservable;
  }
  /**
   * Gets the shader language type used to write vertex and fragment source code.
   */
  get shaderLanguage() {
    return this._shaderLanguage;
  }
  /**
   * Instantiates an effect.
   * An effect can be used to create/manage/execute vertex and fragment shaders.
   * @param baseName Name of the effect.
   * @param attributesNamesOrOptions List of attribute names that will be passed to the shader or set of all options to create the effect.
   * @param uniformsNamesOrEngine List of uniform variable names that will be passed to the shader or the engine that will be used to render effect.
   * @param samplers List of sampler variables that will be passed to the shader.
   * @param engine Engine to be used to render the effect
   * @param defines Define statements to be added to the shader.
   * @param fallbacks Possible fallbacks for this effect to improve performance when needed.
   * @param onCompiled Callback that will be called when the shader is compiled.
   * @param onError Callback that will be called if an error occurs during shader compilation.
   * @param indexParameters Parameters to be used with Babylons include syntax to iterate over an array (eg. \{lights: 10\})
   * @param key Effect Key identifying uniquely compiled shader variants
   * @param shaderLanguage the language the shader is written in (default: GLSL)
   * @param extraInitializationsAsync additional async code to run before preparing the effect
   */
  constructor(baseName, attributesNamesOrOptions, uniformsNamesOrEngine, samplers = null, engine2, defines = null, fallbacks = null, onCompiled = null, onError = null, indexParameters, key = "", shaderLanguage = 0, extraInitializationsAsync) {
    this.defines = "";
    this.onCompiled = null;
    this.onError = null;
    this.onBind = null;
    this.uniqueId = 0;
    this.onCompileObservable = new Observable();
    this.onErrorObservable = new Observable();
    this._onBindObservable = null;
    this._isDisposed = false;
    this._refCount = 1;
    this._bonesComputationForcedToCPU = false;
    this._uniformBuffersNames = {};
    this._multiTarget = false;
    this._samplers = {};
    this._isReady = false;
    this._compilationError = "";
    this._allFallbacksProcessed = false;
    this._uniforms = {};
    this._key = "";
    this._fallbacks = null;
    this._vertexSourceCodeOverride = "";
    this._fragmentSourceCodeOverride = "";
    this._transformFeedbackVaryings = null;
    this._disableParallelShaderCompilation = false;
    this._pipelineContext = null;
    this._vertexSourceCode = "";
    this._fragmentSourceCode = "";
    this._vertexSourceCodeBeforeMigration = "";
    this._fragmentSourceCodeBeforeMigration = "";
    this._rawVertexSourceCode = "";
    this._rawFragmentSourceCode = "";
    this._processCodeAfterIncludes = void 0;
    this._processFinalCode = null;
    this.name = baseName;
    this._key = key;
    const pipelineName = this._key.replace(/\r/g, "").replace(/\n/g, "|");
    let cachedPipeline = void 0;
    if (attributesNamesOrOptions.attributes) {
      const options = attributesNamesOrOptions;
      this._engine = uniformsNamesOrEngine;
      this._attributesNames = options.attributes;
      this._uniformsNames = options.uniformsNames.concat(options.samplers);
      this._samplerList = options.samplers.slice();
      this.defines = options.defines;
      this.onError = options.onError;
      this.onCompiled = options.onCompiled;
      this._fallbacks = options.fallbacks;
      this._indexParameters = options.indexParameters;
      this._transformFeedbackVaryings = options.transformFeedbackVaryings || null;
      this._multiTarget = !!options.multiTarget;
      this._shaderLanguage = options.shaderLanguage ?? 0;
      this._disableParallelShaderCompilation = !!options.disableParallelShaderCompilation;
      if (options.uniformBuffersNames) {
        this._uniformBuffersNamesList = options.uniformBuffersNames.slice();
        for (let i2 = 0; i2 < options.uniformBuffersNames.length; i2++) {
          this._uniformBuffersNames[options.uniformBuffersNames[i2]] = i2;
        }
      }
      this._processFinalCode = options.processFinalCode ?? null;
      this._processCodeAfterIncludes = options.processCodeAfterIncludes ?? void 0;
      extraInitializationsAsync = options.extraInitializationsAsync;
      cachedPipeline = options.existingPipelineContext;
    } else {
      this._engine = engine2;
      this.defines = defines == null ? "" : defines;
      this._uniformsNames = uniformsNamesOrEngine.concat(samplers);
      this._samplerList = samplers ? samplers.slice() : [];
      this._attributesNames = attributesNamesOrOptions;
      this._uniformBuffersNamesList = [];
      this._shaderLanguage = shaderLanguage;
      this.onError = onError;
      this.onCompiled = onCompiled;
      this._indexParameters = indexParameters;
      this._fallbacks = fallbacks;
    }
    if (this._engine.shaderPlatformName === "WEBGL2") {
      cachedPipeline = getCachedPipeline(pipelineName, this._engine._gl) ?? cachedPipeline;
    }
    this._attributeLocationByName = {};
    this.uniqueId = Effect._UniqueIdSeed++;
    if (!cachedPipeline) {
      this._processShaderCodeAsync(null, false, null, extraInitializationsAsync);
    } else {
      this._pipelineContext = cachedPipeline;
      this._pipelineContext.setEngine(this._engine);
      this._onRenderingStateCompiled(this._pipelineContext);
      if (this._pipelineContext.program) {
        this._pipelineContext.program.__SPECTOR_rebuildProgram = this._rebuildProgram.bind(this);
      }
    }
    this._engine.onReleaseEffectsObservable.addOnce(() => {
      if (this.isDisposed) {
        return;
      }
      this.dispose(true);
    });
  }
  /** @internal */
  async _processShaderCodeAsync(shaderProcessor = null, keepExistingPipelineContext = false, shaderProcessingContext = null, extraInitializationsAsync) {
    if (extraInitializationsAsync) {
      await extraInitializationsAsync();
    }
    this._processingContext = shaderProcessingContext || this._engine._getShaderProcessingContext(this._shaderLanguage, false);
    const processorOptions = {
      defines: this.defines.split("\n"),
      indexParameters: this._indexParameters,
      isFragment: false,
      shouldUseHighPrecisionShader: this._engine._shouldUseHighPrecisionShader,
      processor: shaderProcessor ?? this._engine._getShaderProcessor(this._shaderLanguage),
      supportsUniformBuffers: this._engine.supportsUniformBuffers,
      shadersRepository: ShaderStore.GetShadersRepository(this._shaderLanguage),
      includesShadersStore: ShaderStore.GetIncludesShadersStore(this._shaderLanguage),
      version: (this._engine.version * 100).toString(),
      platformName: this._engine.shaderPlatformName,
      processingContext: this._processingContext,
      isNDCHalfZRange: this._engine.isNDCHalfZRange,
      useReverseDepthBuffer: this._engine.useReverseDepthBuffer,
      processCodeAfterIncludes: this._processCodeAfterIncludes
    };
    _processShaderCode(processorOptions, this.name, this._processFinalCode, (migratedVertexCode, migratedFragmentCode) => {
      this._vertexSourceCode = migratedVertexCode;
      this._fragmentSourceCode = migratedFragmentCode;
      this._prepareEffect(keepExistingPipelineContext);
    }, this._shaderLanguage, this._engine, this);
  }
  /**
   * Unique key for this effect
   */
  get key() {
    return this._key;
  }
  /**
   * If the effect has been compiled and prepared.
   * @returns if the effect is compiled and prepared.
   */
  isReady() {
    try {
      return this._isReadyInternal();
    } catch {
      return false;
    }
  }
  _isReadyInternal() {
    if (this._engine.isDisposed) {
      return true;
    }
    if (this._isReady) {
      return true;
    }
    if (this._pipelineContext) {
      return this._pipelineContext.isReady;
    }
    return false;
  }
  /**
   * The engine the effect was initialized with.
   * @returns the engine.
   */
  getEngine() {
    return this._engine;
  }
  /**
   * The pipeline context for this effect
   * @returns the associated pipeline context
   */
  getPipelineContext() {
    return this._pipelineContext;
  }
  /**
   * The set of names of attribute variables for the shader.
   * @returns An array of attribute names.
   */
  getAttributesNames() {
    return this._attributesNames;
  }
  /**
   * Returns the attribute at the given index.
   * @param index The index of the attribute.
   * @returns The location of the attribute.
   */
  getAttributeLocation(index2) {
    return this._attributes[index2];
  }
  /**
   * Returns the attribute based on the name of the variable.
   * @param name of the attribute to look up.
   * @returns the attribute location.
   */
  getAttributeLocationByName(name2) {
    return this._attributeLocationByName[name2];
  }
  /**
   * The number of attributes.
   * @returns the number of attributes.
   */
  getAttributesCount() {
    return this._attributes.length;
  }
  /**
   * Gets the index of a uniform variable.
   * @param uniformName of the uniform to look up.
   * @returns the index.
   */
  getUniformIndex(uniformName) {
    return this._uniformsNames.indexOf(uniformName);
  }
  /**
   * Returns the attribute based on the name of the variable.
   * @param uniformName of the uniform to look up.
   * @returns the location of the uniform.
   */
  getUniform(uniformName) {
    return this._uniforms[uniformName];
  }
  /**
   * Returns an array of sampler variable names
   * @returns The array of sampler variable names.
   */
  getSamplers() {
    return this._samplerList;
  }
  /**
   * Returns an array of uniform variable names
   * @returns The array of uniform variable names.
   */
  getUniformNames() {
    return this._uniformsNames;
  }
  /**
   * Returns an array of uniform buffer variable names
   * @returns The array of uniform buffer variable names.
   */
  getUniformBuffersNames() {
    return this._uniformBuffersNamesList;
  }
  /**
   * Returns the index parameters used to create the effect
   * @returns The index parameters object
   */
  getIndexParameters() {
    return this._indexParameters;
  }
  /**
   * The error from the last compilation.
   * @returns the error string.
   */
  getCompilationError() {
    return this._compilationError;
  }
  /**
   * Gets a boolean indicating that all fallbacks were used during compilation
   * @returns true if all fallbacks were used
   */
  allFallbacksProcessed() {
    return this._allFallbacksProcessed;
  }
  /**
   * Wait until compilation before fulfilling.
   * @returns a promise to wait for completion.
   */
  whenCompiledAsync() {
    return new Promise((resolve) => {
      this.executeWhenCompiled(resolve);
    });
  }
  /**
   * Adds a callback to the onCompiled observable and call the callback immediately if already ready.
   * @param func The callback to be used.
   */
  executeWhenCompiled(func) {
    if (this.isReady()) {
      func(this);
      return;
    }
    this.onCompileObservable.add((effect) => {
      func(effect);
    });
    if (!this._pipelineContext || this._pipelineContext.isAsync) {
      this._checkIsReady(null);
    }
  }
  _checkIsReady(previousPipelineContext) {
    _retryWithInterval(() => {
      return this._isReadyInternal() || this._isDisposed;
    }, () => {
    }, (e2) => {
      this._processCompilationErrors(e2, previousPipelineContext);
    }, 16, 3e4, true, ` - Effect: ${typeof this.name === "string" ? this.name : this.key}`);
  }
  /**
   * Gets the vertex shader source code of this effect
   * This is the final source code that will be compiled, after all the processing has been done (pre-processing applied, code injection/replacement, etc)
   */
  get vertexSourceCode() {
    var _a2;
    return this._vertexSourceCodeOverride && this._fragmentSourceCodeOverride ? this._vertexSourceCodeOverride : ((_a2 = this._pipelineContext) == null ? void 0 : _a2._getVertexShaderCode()) ?? this._vertexSourceCode;
  }
  /**
   * Gets the fragment shader source code of this effect
   * This is the final source code that will be compiled, after all the processing has been done (pre-processing applied, code injection/replacement, etc)
   */
  get fragmentSourceCode() {
    var _a2;
    return this._vertexSourceCodeOverride && this._fragmentSourceCodeOverride ? this._fragmentSourceCodeOverride : ((_a2 = this._pipelineContext) == null ? void 0 : _a2._getFragmentShaderCode()) ?? this._fragmentSourceCode;
  }
  /**
   * Gets the vertex shader source code before migration.
   * This is the source code after the include directives have been replaced by their contents but before the code is migrated, i.e. before ShaderProcess._ProcessShaderConversion is executed.
   * This method is, among other things, responsible for parsing #if/#define directives as well as converting GLES2 syntax to GLES3 (in the case of WebGL).
   */
  get vertexSourceCodeBeforeMigration() {
    return this._vertexSourceCodeBeforeMigration;
  }
  /**
   * Gets the fragment shader source code before migration.
   * This is the source code after the include directives have been replaced by their contents but before the code is migrated, i.e. before ShaderProcess._ProcessShaderConversion is executed.
   * This method is, among other things, responsible for parsing #if/#define directives as well as converting GLES2 syntax to GLES3 (in the case of WebGL).
   */
  get fragmentSourceCodeBeforeMigration() {
    return this._fragmentSourceCodeBeforeMigration;
  }
  /**
   * Gets the vertex shader source code before it has been modified by any processing
   */
  get rawVertexSourceCode() {
    return this._rawVertexSourceCode;
  }
  /**
   * Gets the fragment shader source code before it has been modified by any processing
   */
  get rawFragmentSourceCode() {
    return this._rawFragmentSourceCode;
  }
  getPipelineGenerationOptions() {
    return {
      platformName: this._engine.shaderPlatformName,
      shaderLanguage: this._shaderLanguage,
      shaderNameOrContent: this.name,
      key: this._key,
      defines: this.defines.split("\n"),
      addGlobalDefines: false,
      extendedProcessingOptions: {
        indexParameters: this._indexParameters,
        isNDCHalfZRange: this._engine.isNDCHalfZRange,
        useReverseDepthBuffer: this._engine.useReverseDepthBuffer,
        supportsUniformBuffers: this._engine.supportsUniformBuffers
      },
      extendedCreatePipelineOptions: {
        transformFeedbackVaryings: this._transformFeedbackVaryings,
        createAsRaw: !!(this._vertexSourceCodeOverride && this._fragmentSourceCodeOverride)
      }
    };
  }
  /**
   * Recompiles the webGL program
   * @param vertexSourceCode The source code for the vertex shader.
   * @param fragmentSourceCode The source code for the fragment shader.
   * @param onCompiled Callback called when completed.
   * @param onError Callback called on error.
   * @internal
   */
  _rebuildProgram(vertexSourceCode, fragmentSourceCode, onCompiled, onError) {
    this._isReady = false;
    this._vertexSourceCodeOverride = vertexSourceCode;
    this._fragmentSourceCodeOverride = fragmentSourceCode;
    this.onError = (effect, error) => {
      if (onError) {
        onError(error);
      }
    };
    this.onCompiled = () => {
      var _a2, _b;
      const scenes = this.getEngine().scenes;
      if (scenes) {
        for (let i2 = 0; i2 < scenes.length; i2++) {
          scenes[i2].markAllMaterialsAsDirty(63);
        }
      }
      (_b = (_a2 = this._pipelineContext)._handlesSpectorRebuildCallback) == null ? void 0 : _b.call(_a2, onCompiled);
    };
    this._fallbacks = null;
    this._prepareEffect();
  }
  _onRenderingStateCompiled(pipelineContext) {
    this._pipelineContext = pipelineContext;
    this._pipelineContext.setEngine(this._engine);
    this._attributes = [];
    this._pipelineContext._fillEffectInformation(this, this._uniformBuffersNames, this._uniformsNames, this._uniforms, this._samplerList, this._samplers, this._attributesNames, this._attributes);
    if (this._attributesNames) {
      for (let i2 = 0; i2 < this._attributesNames.length; i2++) {
        const name2 = this._attributesNames[i2];
        this._attributeLocationByName[name2] = this._attributes[i2];
      }
    }
    this._engine.bindSamplers(this);
    this._compilationError = "";
    this._isReady = true;
    if (this.onCompiled) {
      this.onCompiled(this);
    }
    this.onCompileObservable.notifyObservers(this);
    this.onCompileObservable.clear();
    if (this._fallbacks) {
      this._fallbacks.unBindMesh();
    }
    if (Effect.AutomaticallyClearCodeCache) {
      this.clearCodeCache();
    }
  }
  /**
   * Prepares the effect
   * @internal
   */
  _prepareEffect(keepExistingPipelineContext = false) {
    const previousPipelineContext = this._pipelineContext;
    this._isReady = false;
    try {
      const overrides = !!(this._vertexSourceCodeOverride && this._fragmentSourceCodeOverride);
      const defines = overrides ? null : this.defines;
      const vertex = overrides ? this._vertexSourceCodeOverride : this._vertexSourceCode;
      const fragment = overrides ? this._fragmentSourceCodeOverride : this._fragmentSourceCode;
      const engine2 = this._engine;
      this._pipelineContext = createAndPreparePipelineContext({
        existingPipelineContext: keepExistingPipelineContext ? previousPipelineContext : null,
        vertex,
        fragment,
        context: engine2.shaderPlatformName === "WEBGL2" || engine2.shaderPlatformName === "WEBGL1" ? engine2._gl : void 0,
        rebuildRebind: (vertexSourceCode, fragmentSourceCode, onCompiled, onError) => this._rebuildProgram(vertexSourceCode, fragmentSourceCode, onCompiled, onError),
        defines,
        transformFeedbackVaryings: this._transformFeedbackVaryings,
        name: this._key.replace(/\r/g, "").replace(/\n/g, "|"),
        createAsRaw: overrides,
        disableParallelCompilation: this._disableParallelShaderCompilation,
        shaderProcessingContext: this._processingContext,
        onRenderingStateCompiled: (pipelineContext) => {
          if (previousPipelineContext && !keepExistingPipelineContext) {
            this._engine._deletePipelineContext(previousPipelineContext);
          }
          if (pipelineContext) {
            this._onRenderingStateCompiled(pipelineContext);
          }
        }
      }, this._engine.createPipelineContext.bind(this._engine), this._engine._preparePipelineContext.bind(this._engine), this._engine._executeWhenRenderingStateIsCompiled.bind(this._engine));
      if (this._pipelineContext.isAsync) {
        this._checkIsReady(previousPipelineContext);
      }
    } catch (e2) {
      this._processCompilationErrors(e2, previousPipelineContext);
    }
  }
  _getShaderCodeAndErrorLine(code, error, isFragment) {
    const regexp = isFragment ? /FRAGMENT SHADER ERROR: 0:(\d+?):/ : /VERTEX SHADER ERROR: 0:(\d+?):/;
    let errorLine = null;
    if (error && code) {
      const res = error.match(regexp);
      if (res && res.length === 2) {
        const lineNumber = parseInt(res[1]);
        const lines = code.split("\n", -1);
        if (lines.length >= lineNumber) {
          errorLine = `Offending line [${lineNumber}] in ${isFragment ? "fragment" : "vertex"} code: ${lines[lineNumber - 1]}`;
        }
      }
    }
    return [code, errorLine];
  }
  _processCompilationErrors(e2, previousPipelineContext = null) {
    var _a2, _b, _c;
    this._compilationError = e2.message;
    const attributesNames = this._attributesNames;
    const fallbacks = this._fallbacks;
    Logger.Error("Unable to compile effect:");
    Logger.Error("Uniforms: " + this._uniformsNames.map(function(uniform) {
      return " " + uniform;
    }));
    Logger.Error("Attributes: " + attributesNames.map(function(attribute) {
      return " " + attribute;
    }));
    Logger.Error("Defines:\n" + this.defines);
    if (Effect.LogShaderCodeOnCompilationError) {
      let lineErrorVertex = null, lineErrorFragment = null, code = null;
      if ((_a2 = this._pipelineContext) == null ? void 0 : _a2._getVertexShaderCode()) {
        [code, lineErrorVertex] = this._getShaderCodeAndErrorLine(this._pipelineContext._getVertexShaderCode(), this._compilationError, false);
        if (code) {
          Logger.Error("Vertex code:");
          Logger.Error(code);
        }
      }
      if ((_b = this._pipelineContext) == null ? void 0 : _b._getFragmentShaderCode()) {
        [code, lineErrorFragment] = this._getShaderCodeAndErrorLine((_c = this._pipelineContext) == null ? void 0 : _c._getFragmentShaderCode(), this._compilationError, true);
        if (code) {
          Logger.Error("Fragment code:");
          Logger.Error(code);
        }
      }
      if (lineErrorVertex) {
        Logger.Error(lineErrorVertex);
      }
      if (lineErrorFragment) {
        Logger.Error(lineErrorFragment);
      }
    }
    Logger.Error("Error: " + this._compilationError);
    const notifyErrors = () => {
      if (this.onError) {
        this.onError(this, this._compilationError);
      }
      this.onErrorObservable.notifyObservers(this);
      this._engine.onEffectErrorObservable.notifyObservers({ effect: this, errors: this._compilationError });
    };
    if (previousPipelineContext) {
      this._pipelineContext = previousPipelineContext;
      this._isReady = true;
      notifyErrors();
    }
    if (fallbacks) {
      this._pipelineContext = null;
      if (fallbacks.hasMoreFallbacks) {
        this._allFallbacksProcessed = false;
        Logger.Error("Trying next fallback.");
        this.defines = fallbacks.reduce(this.defines, this);
        this._prepareEffect();
      } else {
        this._allFallbacksProcessed = true;
        notifyErrors();
        this.onErrorObservable.clear();
        if (this._fallbacks) {
          this._fallbacks.unBindMesh();
        }
      }
    } else {
      this._allFallbacksProcessed = true;
      if (!previousPipelineContext) {
        notifyErrors();
      }
    }
  }
  /**
   * Checks if the effect is supported. (Must be called after compilation)
   */
  get isSupported() {
    return this._compilationError === "";
  }
  /**
   * Binds a texture to the engine to be used as output of the shader.
   * @param channel Name of the output variable.
   * @param texture Texture to bind.
   * @internal
   */
  _bindTexture(channel, texture) {
    this._engine._bindTexture(this._samplers[channel], texture, channel);
  }
  /**
   * Sets a texture on the engine to be used in the shader.
   * @param channel Name of the sampler variable.
   * @param texture Texture to set.
   */
  setTexture(channel, texture) {
    this._engine.setTexture(this._samplers[channel], this._uniforms[channel], texture, channel);
  }
  /**
   * Sets an array of textures on the engine to be used in the shader.
   * @param channel Name of the variable.
   * @param textures Textures to set.
   */
  setTextureArray(channel, textures) {
    const exName = channel + "Ex";
    if (this._samplerList.indexOf(exName + "0") === -1) {
      const initialPos = this._samplerList.indexOf(channel);
      for (let index2 = 1; index2 < textures.length; index2++) {
        const currentExName = exName + (index2 - 1).toString();
        this._samplerList.splice(initialPos + index2, 0, currentExName);
      }
      let channelIndex = 0;
      for (const key of this._samplerList) {
        this._samplers[key] = channelIndex;
        channelIndex += 1;
      }
    }
    this._engine.setTextureArray(this._samplers[channel], this._uniforms[channel], textures, channel);
  }
  /**
   * Binds a buffer to a uniform.
   * @param buffer Buffer to bind.
   * @param name Name of the uniform variable to bind to.
   */
  bindUniformBuffer(buffer, name2) {
    const bufferName = this._uniformBuffersNames[name2];
    if (bufferName === void 0 || Effect._BaseCache[bufferName] === buffer && this._engine._features.useUBOBindingCache) {
      return;
    }
    Effect._BaseCache[bufferName] = buffer;
    this._engine.bindUniformBufferBase(buffer, bufferName, name2);
  }
  /**
   * Binds block to a uniform.
   * @param blockName Name of the block to bind.
   * @param index Index to bind.
   */
  bindUniformBlock(blockName, index2) {
    this._engine.bindUniformBlock(this._pipelineContext, blockName, index2);
  }
  /**
   * Sets an integer value on a uniform variable.
   * @param uniformName Name of the variable.
   * @param value Value to be set.
   * @returns this effect.
   */
  setInt(uniformName, value) {
    this._pipelineContext.setInt(uniformName, value);
    return this;
  }
  /**
   * Sets an int2 value on a uniform variable.
   * @param uniformName Name of the variable.
   * @param x First int in int2.
   * @param y Second int in int2.
   * @returns this effect.
   */
  setInt2(uniformName, x2, y2) {
    this._pipelineContext.setInt2(uniformName, x2, y2);
    return this;
  }
  /**
   * Sets an int3 value on a uniform variable.
   * @param uniformName Name of the variable.
   * @param x First int in int3.
   * @param y Second int in int3.
   * @param z Third int in int3.
   * @returns this effect.
   */
  setInt3(uniformName, x2, y2, z2) {
    this._pipelineContext.setInt3(uniformName, x2, y2, z2);
    return this;
  }
  /**
   * Sets an int4 value on a uniform variable.
   * @param uniformName Name of the variable.
   * @param x First int in int4.
   * @param y Second int in int4.
   * @param z Third int in int4.
   * @param w Fourth int in int4.
   * @returns this effect.
   */
  setInt4(uniformName, x2, y2, z2, w) {
    this._pipelineContext.setInt4(uniformName, x2, y2, z2, w);
    return this;
  }
  /**
   * Sets an int array on a uniform variable.
   * @param uniformName Name of the variable.
   * @param array array to be set.
   * @returns this effect.
   */
  setIntArray(uniformName, array) {
    this._pipelineContext.setIntArray(uniformName, array);
    return this;
  }
  /**
   * Sets an int array 2 on a uniform variable. (Array is specified as single array eg. [1,2,3,4] will result in [[1,2],[3,4]] in the shader)
   * @param uniformName Name of the variable.
   * @param array array to be set.
   * @returns this effect.
   */
  setIntArray2(uniformName, array) {
    this._pipelineContext.setIntArray2(uniformName, array);
    return this;
  }
  /**
   * Sets an int array 3 on a uniform variable. (Array is specified as single array eg. [1,2,3,4,5,6] will result in [[1,2,3],[4,5,6]] in the shader)
   * @param uniformName Name of the variable.
   * @param array array to be set.
   * @returns this effect.
   */
  setIntArray3(uniformName, array) {
    this._pipelineContext.setIntArray3(uniformName, array);
    return this;
  }
  /**
   * Sets an int array 4 on a uniform variable. (Array is specified as single array eg. [1,2,3,4,5,6,7,8] will result in [[1,2,3,4],[5,6,7,8]] in the shader)
   * @param uniformName Name of the variable.
   * @param array array to be set.
   * @returns this effect.
   */
  setIntArray4(uniformName, array) {
    this._pipelineContext.setIntArray4(uniformName, array);
    return this;
  }
  /**
   * Sets an unsigned integer value on a uniform variable.
   * @param uniformName Name of the variable.
   * @param value Value to be set.
   * @returns this effect.
   */
  setUInt(uniformName, value) {
    this._pipelineContext.setUInt(uniformName, value);
    return this;
  }
  /**
   * Sets an unsigned int2 value on a uniform variable.
   * @param uniformName Name of the variable.
   * @param x First unsigned int in uint2.
   * @param y Second unsigned int in uint2.
   * @returns this effect.
   */
  setUInt2(uniformName, x2, y2) {
    this._pipelineContext.setUInt2(uniformName, x2, y2);
    return this;
  }
  /**
   * Sets an unsigned int3 value on a uniform variable.
   * @param uniformName Name of the variable.
   * @param x First unsigned int in uint3.
   * @param y Second unsigned int in uint3.
   * @param z Third unsigned int in uint3.
   * @returns this effect.
   */
  setUInt3(uniformName, x2, y2, z2) {
    this._pipelineContext.setUInt3(uniformName, x2, y2, z2);
    return this;
  }
  /**
   * Sets an unsigned int4 value on a uniform variable.
   * @param uniformName Name of the variable.
   * @param x First unsigned int in uint4.
   * @param y Second unsigned int in uint4.
   * @param z Third unsigned int in uint4.
   * @param w Fourth unsigned int in uint4.
   * @returns this effect.
   */
  setUInt4(uniformName, x2, y2, z2, w) {
    this._pipelineContext.setUInt4(uniformName, x2, y2, z2, w);
    return this;
  }
  /**
   * Sets an unsigned int array on a uniform variable.
   * @param uniformName Name of the variable.
   * @param array array to be set.
   * @returns this effect.
   */
  setUIntArray(uniformName, array) {
    this._pipelineContext.setUIntArray(uniformName, array);
    return this;
  }
  /**
   * Sets an unsigned int array 2 on a uniform variable. (Array is specified as single array eg. [1,2,3,4] will result in [[1,2],[3,4]] in the shader)
   * @param uniformName Name of the variable.
   * @param array array to be set.
   * @returns this effect.
   */
  setUIntArray2(uniformName, array) {
    this._pipelineContext.setUIntArray2(uniformName, array);
    return this;
  }
  /**
   * Sets an unsigned int array 3 on a uniform variable. (Array is specified as single array eg. [1,2,3,4,5,6] will result in [[1,2,3],[4,5,6]] in the shader)
   * @param uniformName Name of the variable.
   * @param array array to be set.
   * @returns this effect.
   */
  setUIntArray3(uniformName, array) {
    this._pipelineContext.setUIntArray3(uniformName, array);
    return this;
  }
  /**
   * Sets an unsigned int array 4 on a uniform variable. (Array is specified as single array eg. [1,2,3,4,5,6,7,8] will result in [[1,2,3,4],[5,6,7,8]] in the shader)
   * @param uniformName Name of the variable.
   * @param array array to be set.
   * @returns this effect.
   */
  setUIntArray4(uniformName, array) {
    this._pipelineContext.setUIntArray4(uniformName, array);
    return this;
  }
  /**
   * Sets an float array on a uniform variable.
   * @param uniformName Name of the variable.
   * @param array array to be set.
   * @returns this effect.
   */
  setFloatArray(uniformName, array) {
    this._pipelineContext.setArray(uniformName, array);
    return this;
  }
  /**
   * Sets an float array 2 on a uniform variable. (Array is specified as single array eg. [1,2,3,4] will result in [[1,2],[3,4]] in the shader)
   * @param uniformName Name of the variable.
   * @param array array to be set.
   * @returns this effect.
   */
  setFloatArray2(uniformName, array) {
    this._pipelineContext.setArray2(uniformName, array);
    return this;
  }
  /**
   * Sets an float array 3 on a uniform variable. (Array is specified as single array eg. [1,2,3,4,5,6] will result in [[1,2,3],[4,5,6]] in the shader)
   * @param uniformName Name of the variable.
   * @param array array to be set.
   * @returns this effect.
   */
  setFloatArray3(uniformName, array) {
    this._pipelineContext.setArray3(uniformName, array);
    return this;
  }
  /**
   * Sets an float array 4 on a uniform variable. (Array is specified as single array eg. [1,2,3,4,5,6,7,8] will result in [[1,2,3,4],[5,6,7,8]] in the shader)
   * @param uniformName Name of the variable.
   * @param array array to be set.
   * @returns this effect.
   */
  setFloatArray4(uniformName, array) {
    this._pipelineContext.setArray4(uniformName, array);
    return this;
  }
  /**
   * Sets an array on a uniform variable.
   * @param uniformName Name of the variable.
   * @param array array to be set.
   * @returns this effect.
   */
  setArray(uniformName, array) {
    this._pipelineContext.setArray(uniformName, array);
    return this;
  }
  /**
   * Sets an array 2 on a uniform variable. (Array is specified as single array eg. [1,2,3,4] will result in [[1,2],[3,4]] in the shader)
   * @param uniformName Name of the variable.
   * @param array array to be set.
   * @returns this effect.
   */
  setArray2(uniformName, array) {
    this._pipelineContext.setArray2(uniformName, array);
    return this;
  }
  /**
   * Sets an array 3 on a uniform variable. (Array is specified as single array eg. [1,2,3,4,5,6] will result in [[1,2,3],[4,5,6]] in the shader)
   * @param uniformName Name of the variable.
   * @param array array to be set.
   * @returns this effect.
   */
  setArray3(uniformName, array) {
    this._pipelineContext.setArray3(uniformName, array);
    return this;
  }
  /**
   * Sets an array 4 on a uniform variable. (Array is specified as single array eg. [1,2,3,4,5,6,7,8] will result in [[1,2,3,4],[5,6,7,8]] in the shader)
   * @param uniformName Name of the variable.
   * @param array array to be set.
   * @returns this effect.
   */
  setArray4(uniformName, array) {
    this._pipelineContext.setArray4(uniformName, array);
    return this;
  }
  /**
   * Sets matrices on a uniform variable.
   * @param uniformName Name of the variable.
   * @param matrices matrices to be set.
   * @returns this effect.
   */
  setMatrices(uniformName, matrices) {
    this._pipelineContext.setMatrices(uniformName, matrices);
    return this;
  }
  /**
   * Sets matrix on a uniform variable.
   * @param uniformName Name of the variable.
   * @param matrix matrix to be set.
   * @returns this effect.
   */
  setMatrix(uniformName, matrix) {
    this._pipelineContext.setMatrix(uniformName, matrix);
    return this;
  }
  /**
   * Sets a 3x3 matrix on a uniform variable. (Specified as [1,2,3,4,5,6,7,8,9] will result in [1,2,3][4,5,6][7,8,9] matrix)
   * @param uniformName Name of the variable.
   * @param matrix matrix to be set.
   * @returns this effect.
   */
  setMatrix3x3(uniformName, matrix) {
    this._pipelineContext.setMatrix3x3(uniformName, matrix);
    return this;
  }
  /**
   * Sets a 2x2 matrix on a uniform variable. (Specified as [1,2,3,4] will result in [1,2][3,4] matrix)
   * @param uniformName Name of the variable.
   * @param matrix matrix to be set.
   * @returns this effect.
   */
  setMatrix2x2(uniformName, matrix) {
    this._pipelineContext.setMatrix2x2(uniformName, matrix);
    return this;
  }
  /**
   * Sets a float on a uniform variable.
   * @param uniformName Name of the variable.
   * @param value value to be set.
   * @returns this effect.
   */
  setFloat(uniformName, value) {
    this._pipelineContext.setFloat(uniformName, value);
    return this;
  }
  /**
   * Sets a boolean on a uniform variable.
   * @param uniformName Name of the variable.
   * @param bool value to be set.
   * @returns this effect.
   */
  setBool(uniformName, bool) {
    this._pipelineContext.setInt(uniformName, bool ? 1 : 0);
    return this;
  }
  /**
   * Sets a Vector2 on a uniform variable.
   * @param uniformName Name of the variable.
   * @param vector2 vector2 to be set.
   * @returns this effect.
   */
  setVector2(uniformName, vector2) {
    this._pipelineContext.setVector2(uniformName, vector2);
    return this;
  }
  /**
   * Sets a float2 on a uniform variable.
   * @param uniformName Name of the variable.
   * @param x First float in float2.
   * @param y Second float in float2.
   * @returns this effect.
   */
  setFloat2(uniformName, x2, y2) {
    this._pipelineContext.setFloat2(uniformName, x2, y2);
    return this;
  }
  /**
   * Sets a Vector3 on a uniform variable.
   * @param uniformName Name of the variable.
   * @param vector3 Value to be set.
   * @returns this effect.
   */
  setVector3(uniformName, vector3) {
    this._pipelineContext.setVector3(uniformName, vector3);
    return this;
  }
  /**
   * Sets a float3 on a uniform variable.
   * @param uniformName Name of the variable.
   * @param x First float in float3.
   * @param y Second float in float3.
   * @param z Third float in float3.
   * @returns this effect.
   */
  setFloat3(uniformName, x2, y2, z2) {
    this._pipelineContext.setFloat3(uniformName, x2, y2, z2);
    return this;
  }
  /**
   * Sets a Vector4 on a uniform variable.
   * @param uniformName Name of the variable.
   * @param vector4 Value to be set.
   * @returns this effect.
   */
  setVector4(uniformName, vector4) {
    this._pipelineContext.setVector4(uniformName, vector4);
    return this;
  }
  /**
   * Sets a Quaternion on a uniform variable.
   * @param uniformName Name of the variable.
   * @param quaternion Value to be set.
   * @returns this effect.
   */
  setQuaternion(uniformName, quaternion) {
    this._pipelineContext.setQuaternion(uniformName, quaternion);
    return this;
  }
  /**
   * Sets a float4 on a uniform variable.
   * @param uniformName Name of the variable.
   * @param x First float in float4.
   * @param y Second float in float4.
   * @param z Third float in float4.
   * @param w Fourth float in float4.
   * @returns this effect.
   */
  setFloat4(uniformName, x2, y2, z2, w) {
    this._pipelineContext.setFloat4(uniformName, x2, y2, z2, w);
    return this;
  }
  /**
   * Sets a Color3 on a uniform variable.
   * @param uniformName Name of the variable.
   * @param color3 Value to be set.
   * @returns this effect.
   */
  setColor3(uniformName, color3) {
    this._pipelineContext.setColor3(uniformName, color3);
    return this;
  }
  /**
   * Sets a Color4 on a uniform variable.
   * @param uniformName Name of the variable.
   * @param color3 Value to be set.
   * @param alpha Alpha value to be set.
   * @returns this effect.
   */
  setColor4(uniformName, color3, alpha) {
    this._pipelineContext.setColor4(uniformName, color3, alpha);
    return this;
  }
  /**
   * Sets a Color4 on a uniform variable
   * @param uniformName defines the name of the variable
   * @param color4 defines the value to be set
   * @returns this effect.
   */
  setDirectColor4(uniformName, color4) {
    this._pipelineContext.setDirectColor4(uniformName, color4);
    return this;
  }
  /**
   * Use this wisely: It will remove the cached code from this effect
   * It is probably ok to call it if you are not using ShadowDepthWrapper or if everything is already up and running
   * DO NOT CALL IT if you want to have support for context lost recovery
   */
  clearCodeCache() {
    this._vertexSourceCode = "";
    this._fragmentSourceCode = "";
    this._fragmentSourceCodeBeforeMigration = "";
    this._vertexSourceCodeBeforeMigration = "";
  }
  /**
   * Release all associated resources.
   * @param force specifies if the effect must be released no matter what
   **/
  dispose(force = false) {
    if (force) {
      this._refCount = 0;
    } else {
      if (Effect.PersistentMode) {
        return;
      }
      this._refCount--;
    }
    if (this._refCount > 0 || this._isDisposed) {
      return;
    }
    if (this._pipelineContext) {
      resetCachedPipeline(this._pipelineContext);
    }
    this._engine._releaseEffect(this);
    this.clearCodeCache();
    this._isDisposed = true;
  }
  /**
   * This function will add a new shader to the shader store
   * @param name the name of the shader
   * @param pixelShader optional pixel shader content
   * @param vertexShader optional vertex shader content
   * @param shaderLanguage the language the shader is written in (default: GLSL)
   */
  static RegisterShader(name2, pixelShader, vertexShader, shaderLanguage = 0) {
    if (pixelShader) {
      ShaderStore.GetShadersStore(shaderLanguage)[`${name2}PixelShader`] = pixelShader;
    }
    if (vertexShader) {
      ShaderStore.GetShadersStore(shaderLanguage)[`${name2}VertexShader`] = vertexShader;
    }
  }
  /**
   * Resets the cache of effects.
   */
  static ResetCache() {
    Effect._BaseCache = {};
  }
}
Effect.LogShaderCodeOnCompilationError = true;
Effect.PersistentMode = false;
Effect.AutomaticallyClearCodeCache = false;
Effect._UniqueIdSeed = 0;
Effect._BaseCache = {};
Effect.ShadersStore = ShaderStore.ShadersStore;
Effect.IncludesShadersStore = ShaderStore.IncludesShadersStore;
class DepthCullingState {
  /**
   * Initializes the state.
   * @param reset
   */
  constructor(reset = true) {
    this._isDepthTestDirty = false;
    this._isDepthMaskDirty = false;
    this._isDepthFuncDirty = false;
    this._isCullFaceDirty = false;
    this._isCullDirty = false;
    this._isZOffsetDirty = false;
    this._isFrontFaceDirty = false;
    if (reset) {
      this.reset();
    }
  }
  get isDirty() {
    return this._isDepthFuncDirty || this._isDepthTestDirty || this._isDepthMaskDirty || this._isCullFaceDirty || this._isCullDirty || this._isZOffsetDirty || this._isFrontFaceDirty;
  }
  get zOffset() {
    return this._zOffset;
  }
  set zOffset(value) {
    if (this._zOffset === value) {
      return;
    }
    this._zOffset = value;
    this._isZOffsetDirty = true;
  }
  get zOffsetUnits() {
    return this._zOffsetUnits;
  }
  set zOffsetUnits(value) {
    if (this._zOffsetUnits === value) {
      return;
    }
    this._zOffsetUnits = value;
    this._isZOffsetDirty = true;
  }
  get cullFace() {
    return this._cullFace;
  }
  set cullFace(value) {
    if (this._cullFace === value) {
      return;
    }
    this._cullFace = value;
    this._isCullFaceDirty = true;
  }
  get cull() {
    return this._cull;
  }
  set cull(value) {
    if (this._cull === value) {
      return;
    }
    this._cull = value;
    this._isCullDirty = true;
  }
  get depthFunc() {
    return this._depthFunc;
  }
  set depthFunc(value) {
    if (this._depthFunc === value) {
      return;
    }
    this._depthFunc = value;
    this._isDepthFuncDirty = true;
  }
  get depthMask() {
    return this._depthMask;
  }
  set depthMask(value) {
    if (this._depthMask === value) {
      return;
    }
    this._depthMask = value;
    this._isDepthMaskDirty = true;
  }
  get depthTest() {
    return this._depthTest;
  }
  set depthTest(value) {
    if (this._depthTest === value) {
      return;
    }
    this._depthTest = value;
    this._isDepthTestDirty = true;
  }
  get frontFace() {
    return this._frontFace;
  }
  set frontFace(value) {
    if (this._frontFace === value) {
      return;
    }
    this._frontFace = value;
    this._isFrontFaceDirty = true;
  }
  reset() {
    this._depthMask = true;
    this._depthTest = true;
    this._depthFunc = null;
    this._cullFace = null;
    this._cull = null;
    this._zOffset = 0;
    this._zOffsetUnits = 0;
    this._frontFace = null;
    this._isDepthTestDirty = true;
    this._isDepthMaskDirty = true;
    this._isDepthFuncDirty = false;
    this._isCullFaceDirty = false;
    this._isCullDirty = false;
    this._isZOffsetDirty = true;
    this._isFrontFaceDirty = false;
  }
  apply(gl) {
    if (!this.isDirty) {
      return;
    }
    if (this._isCullDirty) {
      if (this.cull) {
        gl.enable(gl.CULL_FACE);
      } else {
        gl.disable(gl.CULL_FACE);
      }
      this._isCullDirty = false;
    }
    if (this._isCullFaceDirty) {
      gl.cullFace(this.cullFace);
      this._isCullFaceDirty = false;
    }
    if (this._isDepthMaskDirty) {
      gl.depthMask(this.depthMask);
      this._isDepthMaskDirty = false;
    }
    if (this._isDepthTestDirty) {
      if (this.depthTest) {
        gl.enable(gl.DEPTH_TEST);
      } else {
        gl.disable(gl.DEPTH_TEST);
      }
      this._isDepthTestDirty = false;
    }
    if (this._isDepthFuncDirty) {
      gl.depthFunc(this.depthFunc);
      this._isDepthFuncDirty = false;
    }
    if (this._isZOffsetDirty) {
      if (this.zOffset || this.zOffsetUnits) {
        gl.enable(gl.POLYGON_OFFSET_FILL);
        gl.polygonOffset(this.zOffset, this.zOffsetUnits);
      } else {
        gl.disable(gl.POLYGON_OFFSET_FILL);
      }
      this._isZOffsetDirty = false;
    }
    if (this._isFrontFaceDirty) {
      gl.frontFace(this.frontFace);
      this._isFrontFaceDirty = false;
    }
  }
}
class StencilStateComposer {
  get isDirty() {
    return this._isStencilTestDirty || this._isStencilMaskDirty || this._isStencilFuncDirty || this._isStencilOpDirty;
  }
  get func() {
    return this._func;
  }
  set func(value) {
    if (this._func === value) {
      return;
    }
    this._func = value;
    this._isStencilFuncDirty = true;
  }
  get funcRef() {
    return this._funcRef;
  }
  set funcRef(value) {
    if (this._funcRef === value) {
      return;
    }
    this._funcRef = value;
    this._isStencilFuncDirty = true;
  }
  get funcMask() {
    return this._funcMask;
  }
  set funcMask(value) {
    if (this._funcMask === value) {
      return;
    }
    this._funcMask = value;
    this._isStencilFuncDirty = true;
  }
  get opStencilFail() {
    return this._opStencilFail;
  }
  set opStencilFail(value) {
    if (this._opStencilFail === value) {
      return;
    }
    this._opStencilFail = value;
    this._isStencilOpDirty = true;
  }
  get opDepthFail() {
    return this._opDepthFail;
  }
  set opDepthFail(value) {
    if (this._opDepthFail === value) {
      return;
    }
    this._opDepthFail = value;
    this._isStencilOpDirty = true;
  }
  get opStencilDepthPass() {
    return this._opStencilDepthPass;
  }
  set opStencilDepthPass(value) {
    if (this._opStencilDepthPass === value) {
      return;
    }
    this._opStencilDepthPass = value;
    this._isStencilOpDirty = true;
  }
  get mask() {
    return this._mask;
  }
  set mask(value) {
    if (this._mask === value) {
      return;
    }
    this._mask = value;
    this._isStencilMaskDirty = true;
  }
  get enabled() {
    return this._enabled;
  }
  set enabled(value) {
    if (this._enabled === value) {
      return;
    }
    this._enabled = value;
    this._isStencilTestDirty = true;
  }
  constructor(reset = true) {
    this._isStencilTestDirty = false;
    this._isStencilMaskDirty = false;
    this._isStencilFuncDirty = false;
    this._isStencilOpDirty = false;
    this.useStencilGlobalOnly = false;
    if (reset) {
      this.reset();
    }
  }
  reset() {
    var _a2;
    this.stencilMaterial = void 0;
    (_a2 = this.stencilGlobal) == null ? void 0 : _a2.reset();
    this._isStencilTestDirty = true;
    this._isStencilMaskDirty = true;
    this._isStencilFuncDirty = true;
    this._isStencilOpDirty = true;
  }
  apply(gl) {
    var _a2;
    if (!gl) {
      return;
    }
    const stencilMaterialEnabled = !this.useStencilGlobalOnly && !!((_a2 = this.stencilMaterial) == null ? void 0 : _a2.enabled);
    this.enabled = stencilMaterialEnabled ? this.stencilMaterial.enabled : this.stencilGlobal.enabled;
    this.func = stencilMaterialEnabled ? this.stencilMaterial.func : this.stencilGlobal.func;
    this.funcRef = stencilMaterialEnabled ? this.stencilMaterial.funcRef : this.stencilGlobal.funcRef;
    this.funcMask = stencilMaterialEnabled ? this.stencilMaterial.funcMask : this.stencilGlobal.funcMask;
    this.opStencilFail = stencilMaterialEnabled ? this.stencilMaterial.opStencilFail : this.stencilGlobal.opStencilFail;
    this.opDepthFail = stencilMaterialEnabled ? this.stencilMaterial.opDepthFail : this.stencilGlobal.opDepthFail;
    this.opStencilDepthPass = stencilMaterialEnabled ? this.stencilMaterial.opStencilDepthPass : this.stencilGlobal.opStencilDepthPass;
    this.mask = stencilMaterialEnabled ? this.stencilMaterial.mask : this.stencilGlobal.mask;
    if (!this.isDirty) {
      return;
    }
    if (this._isStencilTestDirty) {
      if (this.enabled) {
        gl.enable(gl.STENCIL_TEST);
      } else {
        gl.disable(gl.STENCIL_TEST);
      }
      this._isStencilTestDirty = false;
    }
    if (this._isStencilMaskDirty) {
      gl.stencilMask(this.mask);
      this._isStencilMaskDirty = false;
    }
    if (this._isStencilFuncDirty) {
      gl.stencilFunc(this.func, this.funcRef, this.funcMask);
      this._isStencilFuncDirty = false;
    }
    if (this._isStencilOpDirty) {
      gl.stencilOp(this.opStencilFail, this.opDepthFail, this.opStencilDepthPass);
      this._isStencilOpDirty = false;
    }
  }
}
class StencilState {
  constructor() {
    this.reset();
  }
  reset() {
    this.enabled = false;
    this.mask = 255;
    this.func = StencilState.ALWAYS;
    this.funcRef = 1;
    this.funcMask = 255;
    this.opStencilFail = StencilState.KEEP;
    this.opDepthFail = StencilState.KEEP;
    this.opStencilDepthPass = StencilState.REPLACE;
  }
  get stencilFunc() {
    return this.func;
  }
  set stencilFunc(value) {
    this.func = value;
  }
  get stencilFuncRef() {
    return this.funcRef;
  }
  set stencilFuncRef(value) {
    this.funcRef = value;
  }
  get stencilFuncMask() {
    return this.funcMask;
  }
  set stencilFuncMask(value) {
    this.funcMask = value;
  }
  get stencilOpStencilFail() {
    return this.opStencilFail;
  }
  set stencilOpStencilFail(value) {
    this.opStencilFail = value;
  }
  get stencilOpDepthFail() {
    return this.opDepthFail;
  }
  set stencilOpDepthFail(value) {
    this.opDepthFail = value;
  }
  get stencilOpStencilDepthPass() {
    return this.opStencilDepthPass;
  }
  set stencilOpStencilDepthPass(value) {
    this.opStencilDepthPass = value;
  }
  get stencilMask() {
    return this.mask;
  }
  set stencilMask(value) {
    this.mask = value;
  }
  get stencilTest() {
    return this.enabled;
  }
  set stencilTest(value) {
    this.enabled = value;
  }
}
StencilState.ALWAYS = 519;
StencilState.KEEP = 7680;
StencilState.REPLACE = 7681;
class AlphaState {
  /**
   * Initializes the state.
   */
  constructor() {
    this._blendFunctionParameters = new Array(4);
    this._blendEquationParameters = new Array(2);
    this._blendConstants = new Array(4);
    this._isBlendConstantsDirty = false;
    this._alphaBlend = false;
    this._isAlphaBlendDirty = false;
    this._isBlendFunctionParametersDirty = false;
    this._isBlendEquationParametersDirty = false;
    this.reset();
  }
  get isDirty() {
    return this._isAlphaBlendDirty || this._isBlendFunctionParametersDirty || this._isBlendEquationParametersDirty;
  }
  get alphaBlend() {
    return this._alphaBlend;
  }
  set alphaBlend(value) {
    if (this._alphaBlend === value) {
      return;
    }
    this._alphaBlend = value;
    this._isAlphaBlendDirty = true;
  }
  setAlphaBlendConstants(r3, g2, b2, a2) {
    if (this._blendConstants[0] === r3 && this._blendConstants[1] === g2 && this._blendConstants[2] === b2 && this._blendConstants[3] === a2) {
      return;
    }
    this._blendConstants[0] = r3;
    this._blendConstants[1] = g2;
    this._blendConstants[2] = b2;
    this._blendConstants[3] = a2;
    this._isBlendConstantsDirty = true;
  }
  setAlphaBlendFunctionParameters(value0, value1, value2, value3) {
    if (this._blendFunctionParameters[0] === value0 && this._blendFunctionParameters[1] === value1 && this._blendFunctionParameters[2] === value2 && this._blendFunctionParameters[3] === value3) {
      return;
    }
    this._blendFunctionParameters[0] = value0;
    this._blendFunctionParameters[1] = value1;
    this._blendFunctionParameters[2] = value2;
    this._blendFunctionParameters[3] = value3;
    this._isBlendFunctionParametersDirty = true;
  }
  setAlphaEquationParameters(rgb, alpha) {
    if (this._blendEquationParameters[0] === rgb && this._blendEquationParameters[1] === alpha) {
      return;
    }
    this._blendEquationParameters[0] = rgb;
    this._blendEquationParameters[1] = alpha;
    this._isBlendEquationParametersDirty = true;
  }
  reset() {
    this._alphaBlend = false;
    this._blendFunctionParameters[0] = null;
    this._blendFunctionParameters[1] = null;
    this._blendFunctionParameters[2] = null;
    this._blendFunctionParameters[3] = null;
    this._blendEquationParameters[0] = null;
    this._blendEquationParameters[1] = null;
    this._blendConstants[0] = null;
    this._blendConstants[1] = null;
    this._blendConstants[2] = null;
    this._blendConstants[3] = null;
    this._isAlphaBlendDirty = true;
    this._isBlendFunctionParametersDirty = false;
    this._isBlendEquationParametersDirty = false;
    this._isBlendConstantsDirty = false;
  }
  apply(gl) {
    if (!this.isDirty) {
      return;
    }
    if (this._isAlphaBlendDirty) {
      if (this._alphaBlend) {
        gl.enable(gl.BLEND);
      } else {
        gl.disable(gl.BLEND);
      }
      this._isAlphaBlendDirty = false;
    }
    if (this._isBlendFunctionParametersDirty) {
      gl.blendFuncSeparate(this._blendFunctionParameters[0], this._blendFunctionParameters[1], this._blendFunctionParameters[2], this._blendFunctionParameters[3]);
      this._isBlendFunctionParametersDirty = false;
    }
    if (this._isBlendEquationParametersDirty) {
      gl.blendEquationSeparate(this._blendEquationParameters[0], this._blendEquationParameters[1]);
      this._isBlendEquationParametersDirty = false;
    }
    if (this._isBlendConstantsDirty) {
      gl.blendColor(this._blendConstants[0], this._blendConstants[1], this._blendConstants[2], this._blendConstants[3]);
      this._isBlendConstantsDirty = false;
    }
  }
}
class TextureSampler {
  /**
   * | Value | Type               | Description |
   * | ----- | ------------------ | ----------- |
   * | 0     | CLAMP_ADDRESSMODE  |             |
   * | 1     | WRAP_ADDRESSMODE   |             |
   * | 2     | MIRROR_ADDRESSMODE |             |
   */
  get wrapU() {
    return this._cachedWrapU;
  }
  set wrapU(value) {
    this._cachedWrapU = value;
  }
  /**
   * | Value | Type               | Description |
   * | ----- | ------------------ | ----------- |
   * | 0     | CLAMP_ADDRESSMODE  |             |
   * | 1     | WRAP_ADDRESSMODE   |             |
   * | 2     | MIRROR_ADDRESSMODE |             |
   */
  get wrapV() {
    return this._cachedWrapV;
  }
  set wrapV(value) {
    this._cachedWrapV = value;
  }
  /**
   * | Value | Type               | Description |
   * | ----- | ------------------ | ----------- |
   * | 0     | CLAMP_ADDRESSMODE  |             |
   * | 1     | WRAP_ADDRESSMODE   |             |
   * | 2     | MIRROR_ADDRESSMODE |             |
   */
  get wrapR() {
    return this._cachedWrapR;
  }
  set wrapR(value) {
    this._cachedWrapR = value;
  }
  /**
   * With compliant hardware and browser (supporting anisotropic filtering)
   * this defines the level of anisotropic filtering in the texture.
   * The higher the better but the slower.
   */
  get anisotropicFilteringLevel() {
    return this._cachedAnisotropicFilteringLevel;
  }
  set anisotropicFilteringLevel(value) {
    this._cachedAnisotropicFilteringLevel = value;
  }
  /**
   * Gets or sets the comparison function (513, 514, etc). Set 0 to not use a comparison function
   */
  get comparisonFunction() {
    return this._comparisonFunction;
  }
  set comparisonFunction(value) {
    this._comparisonFunction = value;
  }
  /**
   * Indicates to use the mip maps (if available on the texture).
   * Thanks to this flag, you can instruct the sampler to not sample the mipmaps even if they exist (and if the sampling mode is set to a value that normally samples the mipmaps!)
   */
  get useMipMaps() {
    return this._useMipMaps;
  }
  set useMipMaps(value) {
    this._useMipMaps = value;
  }
  /**
   * Creates a Sampler instance
   */
  constructor() {
    this.samplingMode = -1;
    this._useMipMaps = true;
    this._cachedWrapU = null;
    this._cachedWrapV = null;
    this._cachedWrapR = null;
    this._cachedAnisotropicFilteringLevel = null;
    this._comparisonFunction = 0;
  }
  /**
   * Sets all the parameters of the sampler
   * @param wrapU u address mode (default: TEXTURE_WRAP_ADDRESSMODE)
   * @param wrapV v address mode (default: TEXTURE_WRAP_ADDRESSMODE)
   * @param wrapR r address mode (default: TEXTURE_WRAP_ADDRESSMODE)
   * @param anisotropicFilteringLevel anisotropic level (default: 1)
   * @param samplingMode sampling mode (default: 2)
   * @param comparisonFunction comparison function (default: 0 - no comparison function)
   * @returns the current sampler instance
   */
  setParameters(wrapU = 1, wrapV = 1, wrapR = 1, anisotropicFilteringLevel = 1, samplingMode = 2, comparisonFunction = 0) {
    this._cachedWrapU = wrapU;
    this._cachedWrapV = wrapV;
    this._cachedWrapR = wrapR;
    this._cachedAnisotropicFilteringLevel = anisotropicFilteringLevel;
    this.samplingMode = samplingMode;
    this._comparisonFunction = comparisonFunction;
    return this;
  }
  /**
   * Compares this sampler with another one
   * @param other sampler to compare with
   * @returns true if the samplers have the same parametres, else false
   */
  compareSampler(other) {
    return this._cachedWrapU === other._cachedWrapU && this._cachedWrapV === other._cachedWrapV && this._cachedWrapR === other._cachedWrapR && this._cachedAnisotropicFilteringLevel === other._cachedAnisotropicFilteringLevel && this.samplingMode === other.samplingMode && this._comparisonFunction === other._comparisonFunction && this._useMipMaps === other._useMipMaps;
  }
}
var InternalTextureSource;
(function(InternalTextureSource2) {
  InternalTextureSource2[InternalTextureSource2["Unknown"] = 0] = "Unknown";
  InternalTextureSource2[InternalTextureSource2["Url"] = 1] = "Url";
  InternalTextureSource2[InternalTextureSource2["Temp"] = 2] = "Temp";
  InternalTextureSource2[InternalTextureSource2["Raw"] = 3] = "Raw";
  InternalTextureSource2[InternalTextureSource2["Dynamic"] = 4] = "Dynamic";
  InternalTextureSource2[InternalTextureSource2["RenderTarget"] = 5] = "RenderTarget";
  InternalTextureSource2[InternalTextureSource2["MultiRenderTarget"] = 6] = "MultiRenderTarget";
  InternalTextureSource2[InternalTextureSource2["Cube"] = 7] = "Cube";
  InternalTextureSource2[InternalTextureSource2["CubeRaw"] = 8] = "CubeRaw";
  InternalTextureSource2[InternalTextureSource2["CubePrefiltered"] = 9] = "CubePrefiltered";
  InternalTextureSource2[InternalTextureSource2["Raw3D"] = 10] = "Raw3D";
  InternalTextureSource2[InternalTextureSource2["Raw2DArray"] = 11] = "Raw2DArray";
  InternalTextureSource2[InternalTextureSource2["DepthStencil"] = 12] = "DepthStencil";
  InternalTextureSource2[InternalTextureSource2["CubeRawRGBD"] = 13] = "CubeRawRGBD";
  InternalTextureSource2[InternalTextureSource2["Depth"] = 14] = "Depth";
})(InternalTextureSource || (InternalTextureSource = {}));
class InternalTexture extends TextureSampler {
  /**
   * Gets a boolean indicating if the texture uses mipmaps
   * TODO implements useMipMaps as a separate setting from generateMipMaps
   */
  get useMipMaps() {
    return this.generateMipMaps;
  }
  set useMipMaps(value) {
    this.generateMipMaps = value;
  }
  /** Gets the unique id of the internal texture */
  get uniqueId() {
    return this._uniqueId;
  }
  /** @internal */
  _setUniqueId(id) {
    this._uniqueId = id;
  }
  /**
   * Gets the Engine the texture belongs to.
   * @returns The babylon engine
   */
  getEngine() {
    return this._engine;
  }
  /**
   * Gets the data source type of the texture
   */
  get source() {
    return this._source;
  }
  /**
   * Creates a new InternalTexture
   * @param engine defines the engine to use
   * @param source defines the type of data that will be used
   * @param delayAllocation if the texture allocation should be delayed (default: false)
   */
  constructor(engine2, source, delayAllocation = false) {
    super();
    this.isReady = false;
    this.isCube = false;
    this.is3D = false;
    this.is2DArray = false;
    this.isMultiview = false;
    this.url = "";
    this.generateMipMaps = false;
    this.samples = 0;
    this.type = -1;
    this.format = -1;
    this.onLoadedObservable = new Observable();
    this.onErrorObservable = new Observable();
    this.onRebuildCallback = null;
    this.width = 0;
    this.height = 0;
    this.depth = 0;
    this.baseWidth = 0;
    this.baseHeight = 0;
    this.baseDepth = 0;
    this.invertY = false;
    this._invertVScale = false;
    this._associatedChannel = -1;
    this._source = 0;
    this._buffer = null;
    this._bufferView = null;
    this._bufferViewArray = null;
    this._bufferViewArrayArray = null;
    this._size = 0;
    this._extension = "";
    this._files = null;
    this._workingCanvas = null;
    this._workingContext = null;
    this._cachedCoordinatesMode = null;
    this._isDisabled = false;
    this._compression = null;
    this._sphericalPolynomial = null;
    this._sphericalPolynomialPromise = null;
    this._sphericalPolynomialComputed = false;
    this._lodGenerationScale = 0;
    this._lodGenerationOffset = 0;
    this._useSRGBBuffer = false;
    this._creationFlags = 0;
    this._lodTextureHigh = null;
    this._lodTextureMid = null;
    this._lodTextureLow = null;
    this._isRGBD = false;
    this._linearSpecularLOD = false;
    this._irradianceTexture = null;
    this._hardwareTexture = null;
    this._maxLodLevel = null;
    this._references = 1;
    this._gammaSpace = null;
    this._premulAlpha = false;
    this._dynamicTextureSource = null;
    this._autoMSAAManagement = false;
    this._engine = engine2;
    this._source = source;
    this._uniqueId = InternalTexture._Counter++;
    if (!delayAllocation) {
      this._hardwareTexture = engine2._createHardwareTexture();
    }
  }
  /**
   * Increments the number of references (ie. the number of Texture that point to it)
   */
  incrementReferences() {
    this._references++;
  }
  /**
   * Change the size of the texture (not the size of the content)
   * @param width defines the new width
   * @param height defines the new height
   * @param depth defines the new depth (1 by default)
   */
  updateSize(width, height, depth = 1) {
    this._engine.updateTextureDimensions(this, width, height, depth);
    this.width = width;
    this.height = height;
    this.depth = depth;
    this.baseWidth = width;
    this.baseHeight = height;
    this.baseDepth = depth;
    this._size = width * height * depth;
  }
  /** @internal */
  _rebuild() {
    this.isReady = false;
    this._cachedCoordinatesMode = null;
    this._cachedWrapU = null;
    this._cachedWrapV = null;
    this._cachedWrapR = null;
    this._cachedAnisotropicFilteringLevel = null;
    if (this.onRebuildCallback) {
      const data = this.onRebuildCallback(this);
      const swapAndSetIsReady = (proxyInternalTexture) => {
        proxyInternalTexture._swapAndDie(this, false);
        this.isReady = data.isReady;
      };
      if (data.isAsync) {
        data.proxy.then(swapAndSetIsReady);
      } else {
        swapAndSetIsReady(data.proxy);
      }
      return;
    }
    let proxy;
    switch (this.source) {
      case 2:
        break;
      case 1:
        proxy = this._engine.createTexture(
          this._originalUrl ?? this.url,
          !this.generateMipMaps,
          this.invertY,
          null,
          this.samplingMode,
          // Do not use Proxy here as it could be fully synchronous
          // and proxy would be undefined.
          (temp) => {
            temp._swapAndDie(this, false);
            this.isReady = true;
          },
          null,
          this._buffer,
          void 0,
          this.format,
          this._extension,
          void 0,
          void 0,
          void 0,
          this._useSRGBBuffer
        );
        return;
      case 3:
        proxy = this._engine.createRawTexture(this._bufferView, this.baseWidth, this.baseHeight, this.format, this.generateMipMaps, this.invertY, this.samplingMode, this._compression, this.type, this._creationFlags, this._useSRGBBuffer);
        proxy._swapAndDie(this, false);
        this.isReady = true;
        break;
      case 10:
        proxy = this._engine.createRawTexture3D(this._bufferView, this.baseWidth, this.baseHeight, this.baseDepth, this.format, this.generateMipMaps, this.invertY, this.samplingMode, this._compression, this.type);
        proxy._swapAndDie(this, false);
        this.isReady = true;
        break;
      case 11:
        proxy = this._engine.createRawTexture2DArray(this._bufferView, this.baseWidth, this.baseHeight, this.baseDepth, this.format, this.generateMipMaps, this.invertY, this.samplingMode, this._compression, this.type);
        proxy._swapAndDie(this, false);
        this.isReady = true;
        break;
      case 4:
        proxy = this._engine.createDynamicTexture(this.baseWidth, this.baseHeight, this.generateMipMaps, this.samplingMode);
        proxy._swapAndDie(this, false);
        if (this._dynamicTextureSource) {
          this._engine.updateDynamicTexture(this, this._dynamicTextureSource, this.invertY, this._premulAlpha, this.format, true);
        }
        break;
      case 7:
        proxy = this._engine.createCubeTexture(this.url, null, this._files, !this.generateMipMaps, () => {
          proxy._swapAndDie(this, false);
          this.isReady = true;
        }, null, this.format, this._extension, false, 0, 0, null, void 0, this._useSRGBBuffer, ArrayBuffer.isView(this._buffer) ? this._buffer : null);
        return;
      case 8:
        proxy = this._engine.createRawCubeTexture(this._bufferViewArray, this.width, this._originalFormat ?? this.format, this.type, this.generateMipMaps, this.invertY, this.samplingMode, this._compression);
        proxy._swapAndDie(this, false);
        this.isReady = true;
        break;
      case 13:
        return;
      case 9:
        proxy = this._engine.createPrefilteredCubeTexture(this.url, null, this._lodGenerationScale, this._lodGenerationOffset, (proxy2) => {
          if (proxy2) {
            proxy2._swapAndDie(this, false);
          }
          this.isReady = true;
        }, null, this.format, this._extension);
        proxy._sphericalPolynomial = this._sphericalPolynomial;
        return;
    }
  }
  /**
   * @internal
   */
  _swapAndDie(target, swapAll = true) {
    var _a2;
    (_a2 = this._hardwareTexture) == null ? void 0 : _a2.setUsage(target._source, this.generateMipMaps, this.is2DArray, this.isCube, this.is3D, this.width, this.height, this.depth);
    target._hardwareTexture = this._hardwareTexture;
    if (swapAll) {
      target._isRGBD = this._isRGBD;
    }
    if (this._lodTextureHigh) {
      if (target._lodTextureHigh) {
        target._lodTextureHigh.dispose();
      }
      target._lodTextureHigh = this._lodTextureHigh;
    }
    if (this._lodTextureMid) {
      if (target._lodTextureMid) {
        target._lodTextureMid.dispose();
      }
      target._lodTextureMid = this._lodTextureMid;
    }
    if (this._lodTextureLow) {
      if (target._lodTextureLow) {
        target._lodTextureLow.dispose();
      }
      target._lodTextureLow = this._lodTextureLow;
    }
    if (this._irradianceTexture) {
      if (target._irradianceTexture) {
        target._irradianceTexture.dispose();
      }
      target._irradianceTexture = this._irradianceTexture;
    }
    const cache = this._engine.getLoadedTexturesCache();
    let index2 = cache.indexOf(this);
    if (index2 !== -1) {
      cache.splice(index2, 1);
    }
    index2 = cache.indexOf(target);
    if (index2 === -1) {
      cache.push(target);
    }
  }
  /**
   * Dispose the current allocated resources
   */
  dispose() {
    this._references--;
    if (this._references === 0) {
      this.onLoadedObservable.clear();
      this.onErrorObservable.clear();
      this._engine._releaseTexture(this);
      this._hardwareTexture = null;
      this._dynamicTextureSource = null;
    }
  }
}
InternalTexture._Counter = 0;
const _registeredTextureLoaders = /* @__PURE__ */ new Map();
function registerTextureLoader(extension, loaderFactory) {
  if (unregisterTextureLoader(extension)) {
    Logger.Warn(`Extension with the name '${name}' already exists`);
  }
  _registeredTextureLoaders.set(extension, loaderFactory);
}
function unregisterTextureLoader(extension) {
  return _registeredTextureLoaders.delete(extension);
}
function _GetCompatibleTextureLoader(extension, mimeType) {
  if (mimeType === "image/ktx" || mimeType === "image/ktx2") {
    extension = ".ktx";
  }
  if (!_registeredTextureLoaders.has(extension)) {
    if (extension.endsWith(".ies")) {
      registerTextureLoader(".ies", () => __vitePreload(() => import("./iesTextureLoader.Cy-STKM_.js"), true ? [] : void 0, import.meta.url).then((module) => new module._IESTextureLoader()));
    }
    if (extension.endsWith(".dds")) {
      registerTextureLoader(".dds", () => __vitePreload(() => import("./ddsTextureLoader.DUd-KOWO.js"), true ? __vite__mapDeps([0,1,2]) : void 0, import.meta.url).then((module) => new module._DDSTextureLoader()));
    }
    if (extension.endsWith(".basis")) {
      registerTextureLoader(".basis", () => __vitePreload(() => import("./basisTextureLoader.ByOruv8d.js"), true ? [] : void 0, import.meta.url).then((module) => new module._BasisTextureLoader()));
    }
    if (extension.endsWith(".env")) {
      registerTextureLoader(".env", () => __vitePreload(() => import("./envTextureLoader.Cjhw_n9e.js"), true ? __vite__mapDeps([3,4,5,6]) : void 0, import.meta.url).then((module) => new module._ENVTextureLoader()));
    }
    if (extension.endsWith(".hdr")) {
      registerTextureLoader(".hdr", () => __vitePreload(() => import("./hdrTextureLoader.DEodtYmE.js"), true ? __vite__mapDeps([7,8]) : void 0, import.meta.url).then((module) => new module._HDRTextureLoader()));
    }
    if (extension.endsWith(".ktx") || extension.endsWith(".ktx2")) {
      registerTextureLoader(".ktx", () => __vitePreload(() => import("./ktxTextureLoader.HssuqEIa.js"), true ? __vite__mapDeps([9,10]) : void 0, import.meta.url).then((module) => new module._KTXTextureLoader()));
      registerTextureLoader(".ktx2", () => __vitePreload(() => import("./ktxTextureLoader.HssuqEIa.js"), true ? __vite__mapDeps([9,10]) : void 0, import.meta.url).then((module) => new module._KTXTextureLoader()));
    }
    if (extension.endsWith(".tga")) {
      registerTextureLoader(".tga", () => __vitePreload(() => import("./tgaTextureLoader.DwoxqtAX.js"), true ? [] : void 0, import.meta.url).then((module) => new module._TGATextureLoader()));
    }
    if (extension.endsWith(".exr")) {
      registerTextureLoader(".exr", () => __vitePreload(() => import("./exrTextureLoader.DTPiJ2uS.js"), true ? [] : void 0, import.meta.url).then((module) => new module._ExrTextureLoader()));
    }
  }
  const registered = _registeredTextureLoaders.get(extension);
  return registered ? Promise.resolve(registered(mimeType)) : null;
}
function QueueNewFrame(func, requester) {
  if (!IsWindowObjectExist()) {
    if (typeof requestAnimationFrame === "function") {
      return requestAnimationFrame(func);
    }
  } else {
    const { requestAnimationFrame: requestAnimationFrame2 } = requester || window;
    if (typeof requestAnimationFrame2 === "function") {
      return requestAnimationFrame2(func);
    }
  }
  return setTimeout(func, 16);
}
class AbstractEngine {
  /**
   * Gets the current frame id
   */
  get frameId() {
    return this._frameId;
  }
  /**
   * Gets a boolean indicating if the engine runs in WebGPU or not.
   */
  get isWebGPU() {
    return this._isWebGPU;
  }
  /**
   * @internal
   */
  _getShaderProcessor(shaderLanguage) {
    return this._shaderProcessor;
  }
  /**
   * Gets the shader platform name used by the effects.
   */
  get shaderPlatformName() {
    return this._shaderPlatformName;
  }
  _clearEmptyResources() {
    this._emptyTexture = null;
    this._emptyCubeTexture = null;
    this._emptyTexture3D = null;
    this._emptyTexture2DArray = null;
  }
  /**
   * Gets or sets a boolean indicating if depth buffer should be reverse, going from far to near.
   * This can provide greater z depth for distant objects.
   */
  get useReverseDepthBuffer() {
    return this._useReverseDepthBuffer;
  }
  set useReverseDepthBuffer(useReverse) {
    if (useReverse === this._useReverseDepthBuffer) {
      return;
    }
    this._useReverseDepthBuffer = useReverse;
    if (useReverse) {
      this._depthCullingState.depthFunc = 518;
    } else {
      this._depthCullingState.depthFunc = 515;
    }
  }
  /**
   * Enable or disable color writing
   * @param enable defines the state to set
   */
  setColorWrite(enable) {
    if (enable !== this._colorWrite) {
      this._colorWriteChanged = true;
      this._colorWrite = enable;
    }
  }
  /**
   * Gets a boolean indicating if color writing is enabled
   * @returns the current color writing state
   */
  getColorWrite() {
    return this._colorWrite;
  }
  /**
   * Gets the depth culling state manager
   */
  get depthCullingState() {
    return this._depthCullingState;
  }
  /**
   * Gets the alpha state manager
   */
  get alphaState() {
    return this._alphaState;
  }
  /**
   * Gets the stencil state manager
   */
  get stencilState() {
    return this._stencilState;
  }
  /**
   * Gets the stencil state composer
   */
  get stencilStateComposer() {
    return this._stencilStateComposer;
  }
  /** @internal */
  _getGlobalDefines(defines) {
    if (defines) {
      if (this.isNDCHalfZRange) {
        defines["IS_NDC_HALF_ZRANGE"] = "";
      } else {
        delete defines["IS_NDC_HALF_ZRANGE"];
      }
      if (this.useReverseDepthBuffer) {
        defines["USE_REVERSE_DEPTHBUFFER"] = "";
      } else {
        delete defines["USE_REVERSE_DEPTHBUFFER"];
      }
      if (this.useExactSrgbConversions) {
        defines["USE_EXACT_SRGB_CONVERSIONS"] = "";
      } else {
        delete defines["USE_EXACT_SRGB_CONVERSIONS"];
      }
      return;
    } else {
      let s2 = "";
      if (this.isNDCHalfZRange) {
        s2 += "#define IS_NDC_HALF_ZRANGE";
      }
      if (this.useReverseDepthBuffer) {
        if (s2) {
          s2 += "\n";
        }
        s2 += "#define USE_REVERSE_DEPTHBUFFER";
      }
      if (this.useExactSrgbConversions) {
        if (s2) {
          s2 += "\n";
        }
        s2 += "#define USE_EXACT_SRGB_CONVERSIONS";
      }
      return s2;
    }
  }
  _rebuildInternalTextures() {
    const currentState = this._internalTexturesCache.slice();
    for (const internalTexture of currentState) {
      internalTexture._rebuild();
    }
  }
  _rebuildRenderTargetWrappers() {
    const currentState = this._renderTargetWrapperCache.slice();
    for (const renderTargetWrapper of currentState) {
      renderTargetWrapper._rebuild();
    }
  }
  _rebuildEffects() {
    for (const key in this._compiledEffects) {
      const effect = this._compiledEffects[key];
      effect._pipelineContext = null;
      effect._prepareEffect();
    }
    Effect.ResetCache();
  }
  _rebuildGraphicsResources() {
    var _a2;
    this.wipeCaches(true);
    this._rebuildEffects();
    (_a2 = this._rebuildComputeEffects) == null ? void 0 : _a2.call(this);
    this._rebuildBuffers();
    this._rebuildInternalTextures();
    this._rebuildTextures();
    this._rebuildRenderTargetWrappers();
    this.wipeCaches(true);
  }
  _flagContextRestored() {
    Logger.Warn(this.name + " context successfully restored.");
    this.onContextRestoredObservable.notifyObservers(this);
    this._contextWasLost = false;
  }
  _restoreEngineAfterContextLost(initEngine) {
    setTimeout(async () => {
      this._clearEmptyResources();
      const depthTest = this._depthCullingState.depthTest;
      const depthFunc = this._depthCullingState.depthFunc;
      const depthMask = this._depthCullingState.depthMask;
      const stencilTest = this._stencilState.stencilTest;
      await initEngine();
      this._rebuildGraphicsResources();
      this._depthCullingState.depthTest = depthTest;
      this._depthCullingState.depthFunc = depthFunc;
      this._depthCullingState.depthMask = depthMask;
      this._stencilState.stencilTest = stencilTest;
      this._flagContextRestored();
    }, 0);
  }
  /** Gets a boolean indicating if the engine was disposed */
  get isDisposed() {
    return this._isDisposed;
  }
  /**
   * Enables or disables the snapshot rendering mode
   * Note that the WebGL engine does not support snapshot rendering so setting the value won't have any effect for this engine
   */
  get snapshotRendering() {
    return false;
  }
  set snapshotRendering(activate) {
  }
  /**
   * Gets or sets the snapshot rendering mode
   */
  get snapshotRenderingMode() {
    return 0;
  }
  set snapshotRenderingMode(mode) {
  }
  /**
   * Returns the string "AbstractEngine"
   * @returns "AbstractEngine"
   */
  getClassName() {
    return "AbstractEngine";
  }
  /**
   * Gets the default empty texture
   */
  get emptyTexture() {
    if (!this._emptyTexture) {
      this._emptyTexture = this.createRawTexture(new Uint8Array(4), 1, 1, 5, false, false, 1);
    }
    return this._emptyTexture;
  }
  /**
   * Gets the default empty 3D texture
   */
  get emptyTexture3D() {
    if (!this._emptyTexture3D) {
      this._emptyTexture3D = this.createRawTexture3D(new Uint8Array(4), 1, 1, 1, 5, false, false, 1);
    }
    return this._emptyTexture3D;
  }
  /**
   * Gets the default empty 2D array texture
   */
  get emptyTexture2DArray() {
    if (!this._emptyTexture2DArray) {
      this._emptyTexture2DArray = this.createRawTexture2DArray(new Uint8Array(4), 1, 1, 1, 5, false, false, 1);
    }
    return this._emptyTexture2DArray;
  }
  /**
   * Gets the default empty cube texture
   */
  get emptyCubeTexture() {
    if (!this._emptyCubeTexture) {
      const faceData = new Uint8Array(4);
      const cubeData = [faceData, faceData, faceData, faceData, faceData, faceData];
      this._emptyCubeTexture = this.createRawCubeTexture(cubeData, 1, 5, 0, false, false, 1);
    }
    return this._emptyCubeTexture;
  }
  /**
   * Gets the list of current active render loop functions
   * @returns a read only array with the current render loop functions
   */
  get activeRenderLoops() {
    return this._activeRenderLoops;
  }
  /**
   * stop executing a render loop function and remove it from the execution array
   * @param renderFunction defines the function to be removed. If not provided all functions will be removed.
   */
  stopRenderLoop(renderFunction) {
    if (!renderFunction) {
      this._activeRenderLoops.length = 0;
      this._cancelFrame();
      return;
    }
    const index2 = this._activeRenderLoops.indexOf(renderFunction);
    if (index2 >= 0) {
      this._activeRenderLoops.splice(index2, 1);
      if (this._activeRenderLoops.length == 0) {
        this._cancelFrame();
      }
    }
  }
  _cancelFrame() {
    if (this._frameHandler !== 0) {
      const handlerToCancel = this._frameHandler;
      this._frameHandler = 0;
      if (!IsWindowObjectExist()) {
        if (typeof cancelAnimationFrame === "function") {
          return cancelAnimationFrame(handlerToCancel);
        }
      } else {
        const { cancelAnimationFrame: cancelAnimationFrame2 } = this.getHostWindow() || window;
        if (typeof cancelAnimationFrame2 === "function") {
          return cancelAnimationFrame2(handlerToCancel);
        }
      }
      return clearTimeout(handlerToCancel);
    }
  }
  /**
   * Begin a new frame
   */
  beginFrame() {
    this.onBeginFrameObservable.notifyObservers(this);
  }
  /**
   * End the current frame
   */
  endFrame() {
    this._frameId++;
    this.onEndFrameObservable.notifyObservers(this);
  }
  /** Gets or sets max frame per second allowed. Will return undefined if not capped */
  get maxFPS() {
    return this._maxFPS;
  }
  set maxFPS(value) {
    this._maxFPS = value;
    if (value === void 0) {
      return;
    }
    if (value <= 0) {
      this._minFrameTime = Number.MAX_VALUE;
      return;
    }
    this._minFrameTime = 1e3 / (value + 1);
  }
  _isOverFrameTime(timestamp) {
    if (!timestamp) {
      return false;
    }
    const elapsedTime = timestamp - this._lastFrameTime;
    if (this._maxFPS === void 0 || elapsedTime >= this._minFrameTime) {
      this._lastFrameTime = timestamp;
      return false;
    }
    return true;
  }
  _processFrame(timestamp) {
    this._frameHandler = 0;
    if (!this._contextWasLost && !this._isOverFrameTime(timestamp)) {
      let shouldRender = true;
      if (this.isDisposed || !this.renderEvenInBackground && this._windowIsBackground) {
        shouldRender = false;
      }
      if (shouldRender) {
        this.beginFrame();
        if (!this.skipFrameRender && !this._renderViews()) {
          this._renderFrame();
        }
        this.endFrame();
      }
    }
  }
  /** @internal */
  _renderLoop(timestamp) {
    this._processFrame(timestamp);
    if (this._activeRenderLoops.length > 0 && this._frameHandler === 0) {
      this._frameHandler = this._queueNewFrame(this._boundRenderFunction, this.getHostWindow());
    }
  }
  /** @internal */
  _renderFrame() {
    for (let index2 = 0; index2 < this._activeRenderLoops.length; index2++) {
      const renderFunction = this._activeRenderLoops[index2];
      renderFunction();
    }
  }
  /** @internal */
  _renderViews() {
    return false;
  }
  /**
   * Can be used to override the current requestAnimationFrame requester.
   * @internal
   */
  _queueNewFrame(bindedRenderFunction, requester) {
    return QueueNewFrame(bindedRenderFunction, requester);
  }
  /**
   * Register and execute a render loop. The engine can have more than one render function
   * @param renderFunction defines the function to continuously execute
   */
  runRenderLoop(renderFunction) {
    if (this._activeRenderLoops.indexOf(renderFunction) !== -1) {
      return;
    }
    this._activeRenderLoops.push(renderFunction);
    if (this._activeRenderLoops.length === 1 && this._frameHandler === 0) {
      this._frameHandler = this._queueNewFrame(this._boundRenderFunction, this.getHostWindow());
    }
  }
  /**
   * Gets a boolean indicating if depth testing is enabled
   * @returns the current state
   */
  getDepthBuffer() {
    return this._depthCullingState.depthTest;
  }
  /**
   * Enable or disable depth buffering
   * @param enable defines the state to set
   */
  setDepthBuffer(enable) {
    this._depthCullingState.depthTest = enable;
  }
  /**
   * Set the z offset Factor to apply to current rendering
   * @param value defines the offset to apply
   */
  setZOffset(value) {
    this._depthCullingState.zOffset = this.useReverseDepthBuffer ? -value : value;
  }
  /**
   * Gets the current value of the zOffset Factor
   * @returns the current zOffset Factor state
   */
  getZOffset() {
    const zOffset = this._depthCullingState.zOffset;
    return this.useReverseDepthBuffer ? -zOffset : zOffset;
  }
  /**
   * Set the z offset Units to apply to current rendering
   * @param value defines the offset to apply
   */
  setZOffsetUnits(value) {
    this._depthCullingState.zOffsetUnits = this.useReverseDepthBuffer ? -value : value;
  }
  /**
   * Gets the current value of the zOffset Units
   * @returns the current zOffset Units state
   */
  getZOffsetUnits() {
    const zOffsetUnits = this._depthCullingState.zOffsetUnits;
    return this.useReverseDepthBuffer ? -zOffsetUnits : zOffsetUnits;
  }
  /**
   * Gets host window
   * @returns the host window object
   */
  getHostWindow() {
    if (!IsWindowObjectExist()) {
      return null;
    }
    if (this._renderingCanvas && this._renderingCanvas.ownerDocument && this._renderingCanvas.ownerDocument.defaultView) {
      return this._renderingCanvas.ownerDocument.defaultView;
    }
    return window;
  }
  /**
   * (WebGPU only) True (default) to be in compatibility mode, meaning rendering all existing scenes without artifacts (same rendering than WebGL).
   * Setting the property to false will improve performances but may not work in some scenes if some precautions are not taken.
   * See https://doc.babylonjs.com/setup/support/webGPU/webGPUOptimization/webGPUNonCompatibilityMode for more details
   */
  get compatibilityMode() {
    return this._compatibilityMode;
  }
  set compatibilityMode(mode) {
    this._compatibilityMode = true;
  }
  _rebuildTextures() {
    for (const scene of this.scenes) {
      scene._rebuildTextures();
    }
    for (const scene of this._virtualScenes) {
      scene._rebuildTextures();
    }
  }
  /**
   * @internal
   */
  _releaseRenderTargetWrapper(rtWrapper) {
    const index2 = this._renderTargetWrapperCache.indexOf(rtWrapper);
    if (index2 !== -1) {
      this._renderTargetWrapperCache.splice(index2, 1);
    }
  }
  /**
   * Gets the current viewport
   */
  get currentViewport() {
    return this._cachedViewport;
  }
  /**
   * Set the WebGL's viewport
   * @param viewport defines the viewport element to be used
   * @param requiredWidth defines the width required for rendering. If not provided the rendering canvas' width is used
   * @param requiredHeight defines the height required for rendering. If not provided the rendering canvas' height is used
   */
  setViewport(viewport, requiredWidth, requiredHeight) {
    const width = requiredWidth || this.getRenderWidth();
    const height = requiredHeight || this.getRenderHeight();
    const x2 = viewport.x || 0;
    const y2 = viewport.y || 0;
    this._cachedViewport = viewport;
    this._viewport(x2 * width, y2 * height, width * viewport.width, height * viewport.height);
  }
  /**
   * Create an image to use with canvas
   * @returns IImage interface
   */
  createCanvasImage() {
    return document.createElement("img");
  }
  /**
   * Create a 2D path to use with canvas
   * @returns IPath2D interface
   * @param d SVG path string
   */
  createCanvasPath2D(d2) {
    return new Path2D(d2);
  }
  /**
   * Returns a string describing the current engine
   */
  get description() {
    let description = this.name + this.version;
    if (this._caps.parallelShaderCompile) {
      description += " - Parallel shader compilation";
    }
    return description;
  }
  _createTextureBase(url, noMipmap, invertY, scene, samplingMode = 3, onLoad = null, onError = null, prepareTexture, prepareTextureProcess, buffer = null, fallback = null, format = null, forcedExtension = null, mimeType, loaderOptions, useSRGBBuffer) {
    url = url || "";
    const fromData = url.substr(0, 5) === "data:";
    const fromBlob = url.substr(0, 5) === "blob:";
    const isBase64 = fromData && url.indexOf(";base64,") !== -1;
    const texture = fallback ? fallback : new InternalTexture(
      this,
      1
      /* InternalTextureSource.Url */
    );
    if (texture !== fallback) {
      texture.label = url.substring(0, 60);
    }
    const originalUrl = url;
    if (this._transformTextureUrl && !isBase64 && !fallback && !buffer) {
      url = this._transformTextureUrl(url);
    }
    if (originalUrl !== url) {
      texture._originalUrl = originalUrl;
    }
    const lastDot = url.lastIndexOf(".");
    let extension = forcedExtension ? forcedExtension : lastDot > -1 ? url.substring(lastDot).toLowerCase() : "";
    const queryStringIndex = extension.indexOf("?");
    if (queryStringIndex > -1) {
      extension = extension.split("?")[0];
    }
    const loaderPromise = _GetCompatibleTextureLoader(extension, mimeType);
    if (scene) {
      scene.addPendingData(texture);
    }
    texture.url = url;
    texture.generateMipMaps = !noMipmap;
    texture.samplingMode = samplingMode;
    texture.invertY = invertY;
    texture._useSRGBBuffer = this._getUseSRGBBuffer(!!useSRGBBuffer, noMipmap);
    if (!this._doNotHandleContextLost) {
      texture._buffer = buffer;
    }
    let onLoadObserver = null;
    if (onLoad && !fallback) {
      onLoadObserver = texture.onLoadedObservable.add(onLoad);
    }
    if (!fallback) {
      this._internalTexturesCache.push(texture);
    }
    const onInternalError = (message, exception) => {
      if (scene) {
        scene.removePendingData(texture);
      }
      if (url === originalUrl) {
        if (onLoadObserver) {
          texture.onLoadedObservable.remove(onLoadObserver);
        }
        if (EngineStore.UseFallbackTexture && url !== EngineStore.FallbackTexture) {
          this._createTextureBase(EngineStore.FallbackTexture, noMipmap, texture.invertY, scene, samplingMode, null, onError, prepareTexture, prepareTextureProcess, buffer, texture);
        }
        message = (message || "Unknown error") + (EngineStore.UseFallbackTexture ? " - Fallback texture was used" : "");
        texture.onErrorObservable.notifyObservers({ message, exception });
        if (onError) {
          onError(message, exception);
        }
      } else {
        Logger.Warn(`Failed to load ${url}, falling back to ${originalUrl}`);
        this._createTextureBase(originalUrl, noMipmap, texture.invertY, scene, samplingMode, onLoad, onError, prepareTexture, prepareTextureProcess, buffer, texture, format, forcedExtension, mimeType, loaderOptions, useSRGBBuffer);
      }
    };
    if (loaderPromise) {
      const callback = async (data) => {
        const loader = await loaderPromise;
        loader.loadData(data, texture, (width, height, loadMipmap, isCompressed, done, loadFailed) => {
          if (loadFailed) {
            onInternalError("TextureLoader failed to load data");
          } else {
            prepareTexture(texture, extension, scene, { width, height }, texture.invertY, !loadMipmap, isCompressed, () => {
              done();
              return false;
            }, samplingMode);
          }
        }, loaderOptions);
      };
      if (!buffer) {
        this._loadFile(url, (data) => callback(new Uint8Array(data)), void 0, scene ? scene.offlineProvider : void 0, true, (request, exception) => {
          onInternalError("Unable to load " + (request ? request.responseURL : url, exception));
        });
      } else {
        if (buffer instanceof ArrayBuffer) {
          callback(new Uint8Array(buffer));
        } else if (ArrayBuffer.isView(buffer)) {
          callback(buffer);
        } else {
          if (onError) {
            onError("Unable to load: only ArrayBuffer or ArrayBufferView is supported", null);
          }
        }
      }
    } else {
      const onload = (img) => {
        if (fromBlob && !this._doNotHandleContextLost) {
          texture._buffer = img;
        }
        prepareTexture(texture, extension, scene, img, texture.invertY, noMipmap, false, prepareTextureProcess, samplingMode);
      };
      if (!fromData || isBase64) {
        if (buffer && (typeof buffer.decoding === "string" || buffer.close)) {
          onload(buffer);
        } else {
          AbstractEngine._FileToolsLoadImage(url || "", onload, onInternalError, scene ? scene.offlineProvider : null, mimeType, texture.invertY && this._features.needsInvertingBitmap ? { imageOrientation: "flipY" } : void 0, this);
        }
      } else if (typeof buffer === "string" || buffer instanceof ArrayBuffer || ArrayBuffer.isView(buffer) || buffer instanceof Blob) {
        AbstractEngine._FileToolsLoadImage(buffer, onload, onInternalError, scene ? scene.offlineProvider : null, mimeType, texture.invertY && this._features.needsInvertingBitmap ? { imageOrientation: "flipY" } : void 0, this);
      } else if (buffer) {
        onload(buffer);
      }
    }
    return texture;
  }
  _rebuildBuffers() {
    for (const uniformBuffer of this._uniformBuffers) {
      uniformBuffer._rebuildAfterContextLost();
    }
  }
  /** @internal */
  get _shouldUseHighPrecisionShader() {
    return !!(this._caps.highPrecisionShaderSupported && this._highPrecisionShadersAllowed);
  }
  /**
   * Gets host document
   * @returns the host document object
   */
  getHostDocument() {
    if (this._renderingCanvas && this._renderingCanvas.ownerDocument) {
      return this._renderingCanvas.ownerDocument;
    }
    return IsDocumentAvailable() ? document : null;
  }
  /**
   * Gets the list of loaded textures
   * @returns an array containing all loaded textures
   */
  getLoadedTexturesCache() {
    return this._internalTexturesCache;
  }
  /**
   * Clears the list of texture accessible through engine.
   * This can help preventing texture load conflict due to name collision.
   */
  clearInternalTexturesCache() {
    this._internalTexturesCache.length = 0;
  }
  /**
   * Gets the object containing all engine capabilities
   * @returns the EngineCapabilities object
   */
  getCaps() {
    return this._caps;
  }
  /**
   * Reset the texture cache to empty state
   */
  resetTextureCache() {
    for (const key in this._boundTexturesCache) {
      if (!Object.prototype.hasOwnProperty.call(this._boundTexturesCache, key)) {
        continue;
      }
      this._boundTexturesCache[key] = null;
    }
    this._currentTextureChannel = -1;
  }
  /**
   * Gets or sets the name of the engine
   */
  get name() {
    return this._name;
  }
  set name(value) {
    this._name = value;
  }
  /**
   * Returns the current npm package of the sdk
   */
  // Not mixed with Version for tooling purpose.
  static get NpmPackage() {
    return "babylonjs@7.54.1";
  }
  /**
   * Returns the current version of the framework
   */
  static get Version() {
    return "7.54.1";
  }
  /**
   * Gets the HTML canvas attached with the current webGL context
   * @returns a HTML canvas
   */
  getRenderingCanvas() {
    return this._renderingCanvas;
  }
  /**
   * Gets the audio context specified in engine initialization options
   * @deprecated please use AudioEngineV2 instead
   * @returns an Audio Context
   */
  getAudioContext() {
    return this._audioContext;
  }
  /**
   * Gets the audio destination specified in engine initialization options
   * @deprecated please use AudioEngineV2 instead
   * @returns an audio destination node
   */
  getAudioDestination() {
    return this._audioDestination;
  }
  /**
   * Defines the hardware scaling level.
   * By default the hardware scaling level is computed from the window device ratio.
   * if level = 1 then the engine will render at the exact resolution of the canvas. If level = 0.5 then the engine will render at twice the size of the canvas.
   * @param level defines the level to use
   */
  setHardwareScalingLevel(level) {
    this._hardwareScalingLevel = level;
    this.resize();
  }
  /**
   * Gets the current hardware scaling level.
   * By default the hardware scaling level is computed from the window device ratio.
   * if level = 1 then the engine will render at the exact resolution of the canvas. If level = 0.5 then the engine will render at twice the size of the canvas.
   * @returns a number indicating the current hardware scaling level
   */
  getHardwareScalingLevel() {
    return this._hardwareScalingLevel;
  }
  /**
   * Gets or sets a boolean indicating if resources should be retained to be able to handle context lost events
   * @see https://doc.babylonjs.com/features/featuresDeepDive/scene/optimize_your_scene#handling-webgl-context-lost
   */
  get doNotHandleContextLost() {
    return this._doNotHandleContextLost;
  }
  set doNotHandleContextLost(value) {
    this._doNotHandleContextLost = value;
  }
  /**
   * Returns true if the stencil buffer has been enabled through the creation option of the context.
   */
  get isStencilEnable() {
    return this._isStencilEnable;
  }
  /**
   * Gets the options used for engine creation
   * @returns EngineOptions object
   */
  getCreationOptions() {
    return this._creationOptions;
  }
  /**
   * Creates a new engine
   * @param antialias defines whether anti-aliasing should be enabled. If undefined, it means that the underlying engine is free to enable it or not
   * @param options defines further options to be sent to the creation context
   * @param adaptToDeviceRatio defines whether to adapt to the device's viewport characteristics (default: false)
   */
  constructor(antialias, options, adaptToDeviceRatio) {
    var _a2, _b;
    this._colorWrite = true;
    this._colorWriteChanged = true;
    this._depthCullingState = new DepthCullingState();
    this._stencilStateComposer = new StencilStateComposer();
    this._stencilState = new StencilState();
    this._alphaState = new AlphaState();
    this._alphaMode = 1;
    this._alphaEquation = 0;
    this._activeRequests = [];
    this._badOS = false;
    this._badDesktopOS = false;
    this._compatibilityMode = true;
    this._internalTexturesCache = new Array();
    this._currentRenderTarget = null;
    this._boundTexturesCache = {};
    this._activeChannel = 0;
    this._currentTextureChannel = -1;
    this._viewportCached = { x: 0, y: 0, z: 0, w: 0 };
    this._isWebGPU = false;
    this.onCanvasBlurObservable = new Observable();
    this.onCanvasFocusObservable = new Observable();
    this.onNewSceneAddedObservable = new Observable();
    this.onResizeObservable = new Observable();
    this.onCanvasPointerOutObservable = new Observable();
    this.onEffectErrorObservable = new Observable();
    this.disablePerformanceMonitorInBackground = false;
    this.disableVertexArrayObjects = false;
    this._frameId = 0;
    this.hostInformation = {
      isMobile: false
    };
    this.isFullscreen = false;
    this.enableOfflineSupport = false;
    this.disableManifestCheck = false;
    this.disableContextMenu = true;
    this.currentRenderPassId = 0;
    this.isPointerLock = false;
    this.postProcesses = [];
    this.canvasTabIndex = 1;
    this._contextWasLost = false;
    this._useReverseDepthBuffer = false;
    this.isNDCHalfZRange = false;
    this.hasOriginBottomLeft = true;
    this._renderTargetWrapperCache = new Array();
    this._compiledEffects = {};
    this._isDisposed = false;
    this.scenes = [];
    this._virtualScenes = new Array();
    this.onBeforeTextureInitObservable = new Observable();
    this.renderEvenInBackground = true;
    this.preventCacheWipeBetweenFrames = false;
    this._frameHandler = 0;
    this._activeRenderLoops = new Array();
    this._windowIsBackground = false;
    this._boundRenderFunction = (timestamp) => this._renderLoop(timestamp);
    this._lastFrameTime = 0;
    this.skipFrameRender = false;
    this.onBeforeShaderCompilationObservable = new Observable();
    this.onAfterShaderCompilationObservable = new Observable();
    this.onBeginFrameObservable = new Observable();
    this.onEndFrameObservable = new Observable();
    this._transformTextureUrl = null;
    this._uniformBuffers = new Array();
    this._storageBuffers = new Array();
    this._highPrecisionShadersAllowed = true;
    this.onContextLostObservable = new Observable();
    this.onContextRestoredObservable = new Observable();
    this._name = "";
    this.premultipliedAlpha = true;
    this.adaptToDeviceRatio = false;
    this._lastDevicePixelRatio = 1;
    this._doNotHandleContextLost = false;
    this.cullBackFaces = null;
    this._renderPassNames = ["main"];
    this._fps = 60;
    this._deltaTime = 0;
    this._deterministicLockstep = false;
    this._lockstepMaxSteps = 4;
    this._timeStep = 1 / 60;
    this.onDisposeObservable = new Observable();
    this.onReleaseEffectsObservable = new Observable();
    EngineStore.Instances.push(this);
    this.startTime = PrecisionDate.Now;
    this._stencilStateComposer.stencilGlobal = this._stencilState;
    PerformanceConfigurator.SetMatrixPrecision(!!options.useHighPrecisionMatrix);
    if (IsNavigatorAvailable() && navigator.userAgent) {
      this._badOS = /iPad/i.test(navigator.userAgent) || /iPhone/i.test(navigator.userAgent);
      this._badDesktopOS = /^((?!chrome|android).)*safari/i.test(navigator.userAgent);
    }
    this.adaptToDeviceRatio = adaptToDeviceRatio ?? false;
    options.antialias = antialias ?? options.antialias;
    options.deterministicLockstep = options.deterministicLockstep ?? false;
    options.lockstepMaxSteps = options.lockstepMaxSteps ?? 4;
    options.timeStep = options.timeStep ?? 1 / 60;
    options.stencil = options.stencil ?? true;
    this._audioContext = ((_a2 = options.audioEngineOptions) == null ? void 0 : _a2.audioContext) ?? null;
    this._audioDestination = ((_b = options.audioEngineOptions) == null ? void 0 : _b.audioDestination) ?? null;
    this.premultipliedAlpha = options.premultipliedAlpha ?? true;
    this._doNotHandleContextLost = !!options.doNotHandleContextLost;
    this._isStencilEnable = options.stencil ? true : false;
    this.useExactSrgbConversions = options.useExactSrgbConversions ?? false;
    const devicePixelRatio = IsWindowObjectExist() ? window.devicePixelRatio || 1 : 1;
    const limitDeviceRatio = options.limitDeviceRatio || devicePixelRatio;
    adaptToDeviceRatio = adaptToDeviceRatio || options.adaptToDeviceRatio || false;
    this._hardwareScalingLevel = adaptToDeviceRatio ? 1 / Math.min(limitDeviceRatio, devicePixelRatio) : 1;
    this._lastDevicePixelRatio = devicePixelRatio;
    this._creationOptions = options;
  }
  /**
   * Resize the view according to the canvas' size
   * @param forceSetSize true to force setting the sizes of the underlying canvas
   */
  resize(forceSetSize = false) {
    var _a2, _b;
    let width;
    let height;
    if (this.adaptToDeviceRatio) {
      const devicePixelRatio = IsWindowObjectExist() ? window.devicePixelRatio || 1 : 1;
      const changeRatio = this._lastDevicePixelRatio / devicePixelRatio;
      this._lastDevicePixelRatio = devicePixelRatio;
      this._hardwareScalingLevel *= changeRatio;
    }
    if (IsWindowObjectExist() && IsDocumentAvailable()) {
      if (this._renderingCanvas) {
        const boundingRect = (_b = (_a2 = this._renderingCanvas).getBoundingClientRect) == null ? void 0 : _b.call(_a2);
        width = this._renderingCanvas.clientWidth || (boundingRect == null ? void 0 : boundingRect.width) || this._renderingCanvas.width * this._hardwareScalingLevel || 100;
        height = this._renderingCanvas.clientHeight || (boundingRect == null ? void 0 : boundingRect.height) || this._renderingCanvas.height * this._hardwareScalingLevel || 100;
      } else {
        width = window.innerWidth;
        height = window.innerHeight;
      }
    } else {
      width = this._renderingCanvas ? this._renderingCanvas.width : 100;
      height = this._renderingCanvas ? this._renderingCanvas.height : 100;
    }
    this.setSize(width / this._hardwareScalingLevel, height / this._hardwareScalingLevel, forceSetSize);
  }
  /**
   * Force a specific size of the canvas
   * @param width defines the new canvas' width
   * @param height defines the new canvas' height
   * @param forceSetSize true to force setting the sizes of the underlying canvas
   * @returns true if the size was changed
   */
  setSize(width, height, forceSetSize = false) {
    if (!this._renderingCanvas) {
      return false;
    }
    width = width | 0;
    height = height | 0;
    if (!forceSetSize && this._renderingCanvas.width === width && this._renderingCanvas.height === height) {
      return false;
    }
    this._renderingCanvas.width = width;
    this._renderingCanvas.height = height;
    if (this.scenes) {
      for (let index2 = 0; index2 < this.scenes.length; index2++) {
        const scene = this.scenes[index2];
        for (let camIndex = 0; camIndex < scene.cameras.length; camIndex++) {
          const cam = scene.cameras[camIndex];
          cam._currentRenderId = 0;
        }
      }
      if (this.onResizeObservable.hasObservers()) {
        this.onResizeObservable.notifyObservers(this);
      }
    }
    return true;
  }
  // eslint-disable-next-line jsdoc/require-returns-check
  /**
   * Creates a raw texture
   * @param data defines the data to store in the texture
   * @param width defines the width of the texture
   * @param height defines the height of the texture
   * @param format defines the format of the data
   * @param generateMipMaps defines if the engine should generate the mip levels
   * @param invertY defines if data must be stored with Y axis inverted
   * @param samplingMode defines the required sampling mode (Texture.NEAREST_SAMPLINGMODE by default)
   * @param compression defines the compression used (null by default)
   * @param type defines the type fo the data (Engine.TEXTURETYPE_UNSIGNED_BYTE by default)
   * @param creationFlags specific flags to use when creating the texture (1 for storage textures, for eg)
   * @param useSRGBBuffer defines if the texture must be loaded in a sRGB GPU buffer (if supported by the GPU).
   * @returns the raw texture inside an InternalTexture
   */
  createRawTexture(data, width, height, format, generateMipMaps, invertY, samplingMode, compression, type, creationFlags, useSRGBBuffer) {
    throw _WarnImport("engine.rawTexture");
  }
  // eslint-disable-next-line jsdoc/require-returns-check
  /**
   * Creates a new raw cube texture
   * @param data defines the array of data to use to create each face
   * @param size defines the size of the textures
   * @param format defines the format of the data
   * @param type defines the type of the data (like Engine.TEXTURETYPE_UNSIGNED_BYTE)
   * @param generateMipMaps  defines if the engine should generate the mip levels
   * @param invertY defines if data must be stored with Y axis inverted
   * @param samplingMode defines the required sampling mode (like Texture.NEAREST_SAMPLINGMODE)
   * @param compression defines the compression used (null by default)
   * @returns the cube texture as an InternalTexture
   */
  createRawCubeTexture(data, size, format, type, generateMipMaps, invertY, samplingMode, compression) {
    throw _WarnImport("engine.rawTexture");
  }
  // eslint-disable-next-line jsdoc/require-returns-check
  /**
   * Creates a new raw 3D texture
   * @param data defines the data used to create the texture
   * @param width defines the width of the texture
   * @param height defines the height of the texture
   * @param depth defines the depth of the texture
   * @param format defines the format of the texture
   * @param generateMipMaps defines if the engine must generate mip levels
   * @param invertY defines if data must be stored with Y axis inverted
   * @param samplingMode defines the required sampling mode (like Texture.NEAREST_SAMPLINGMODE)
   * @param compression defines the compressed used (can be null)
   * @param textureType defines the compressed used (can be null)
   * @param creationFlags specific flags to use when creating the texture (1 for storage textures, for eg)
   * @returns a new raw 3D texture (stored in an InternalTexture)
   */
  createRawTexture3D(data, width, height, depth, format, generateMipMaps, invertY, samplingMode, compression, textureType, creationFlags) {
    throw _WarnImport("engine.rawTexture");
  }
  // eslint-disable-next-line jsdoc/require-returns-check
  /**
   * Creates a new raw 2D array texture
   * @param data defines the data used to create the texture
   * @param width defines the width of the texture
   * @param height defines the height of the texture
   * @param depth defines the number of layers of the texture
   * @param format defines the format of the texture
   * @param generateMipMaps defines if the engine must generate mip levels
   * @param invertY defines if data must be stored with Y axis inverted
   * @param samplingMode defines the required sampling mode (like Texture.NEAREST_SAMPLINGMODE)
   * @param compression defines the compressed used (can be null)
   * @param textureType defines the compressed used (can be null)
   * @param creationFlags specific flags to use when creating the texture (1 for storage textures, for eg)
   * @returns a new raw 2D array texture (stored in an InternalTexture)
   */
  createRawTexture2DArray(data, width, height, depth, format, generateMipMaps, invertY, samplingMode, compression, textureType, creationFlags) {
    throw _WarnImport("engine.rawTexture");
  }
  /**
   * Shared initialization across engines types.
   * @param canvas The canvas associated with this instance of the engine.
   */
  _sharedInit(canvas) {
    this._renderingCanvas = canvas;
  }
  _setupMobileChecks() {
    if (!(navigator && navigator.userAgent)) {
      return;
    }
    this._checkForMobile = () => {
      const currentUA = navigator.userAgent;
      this.hostInformation.isMobile = currentUA.indexOf("Mobile") !== -1 || // Needed for iOS 13+ detection on iPad (inspired by solution from https://stackoverflow.com/questions/9038625/detect-if-device-is-ios)
      currentUA.indexOf("Mac") !== -1 && IsDocumentAvailable() && "ontouchend" in document;
    };
    this._checkForMobile();
    if (IsWindowObjectExist()) {
      window.addEventListener("resize", this._checkForMobile);
    }
  }
  /**
   * creates and returns a new video element
   * @param constraints video constraints
   * @returns video element
   */
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  createVideoElement(constraints) {
    return document.createElement("video");
  }
  /**
   * @internal
   */
  _reportDrawCall(numDrawCalls = 1) {
    var _a2;
    (_a2 = this._drawCalls) == null ? void 0 : _a2.addCount(numDrawCalls, false);
  }
  /**
   * Gets the current framerate
   * @returns a number representing the framerate
   */
  getFps() {
    return this._fps;
  }
  /**
   * Gets the time spent between current and previous frame
   * @returns a number representing the delta time in ms
   */
  getDeltaTime() {
    return this._deltaTime;
  }
  /**
   * Gets a boolean indicating that the engine is running in deterministic lock step mode
   * @see https://doc.babylonjs.com/features/featuresDeepDive/animation/advanced_animations#deterministic-lockstep
   * @returns true if engine is in deterministic lock step mode
   */
  isDeterministicLockStep() {
    return this._deterministicLockstep;
  }
  /**
   * Gets the max steps when engine is running in deterministic lock step
   * @see https://doc.babylonjs.com/features/featuresDeepDive/animation/advanced_animations#deterministic-lockstep
   * @returns the max steps
   */
  getLockstepMaxSteps() {
    return this._lockstepMaxSteps;
  }
  /**
   * Returns the time in ms between steps when using deterministic lock step.
   * @returns time step in (ms)
   */
  getTimeStep() {
    return this._timeStep * 1e3;
  }
  /**
   * Engine abstraction for loading and creating an image bitmap from a given source string.
   * @param imageSource source to load the image from.
   * @param options An object that sets options for the image's extraction.
   */
  _createImageBitmapFromSource(imageSource, options) {
    throw new Error("createImageBitmapFromSource is not implemented");
  }
  /**
   * Engine abstraction for createImageBitmap
   * @param image source for image
   * @param options An object that sets options for the image's extraction.
   * @returns ImageBitmap
   */
  createImageBitmap(image, options) {
    return createImageBitmap(image, options);
  }
  /**
   * Resize an image and returns the image data as an uint8array
   * @param image image to resize
   * @param bufferWidth destination buffer width
   * @param bufferHeight destination buffer height
   */
  resizeImageBitmap(image, bufferWidth, bufferHeight) {
    throw new Error("resizeImageBitmap is not implemented");
  }
  /**
   * Get Font size information
   * @param font font name
   */
  getFontOffset(font) {
    throw new Error("getFontOffset is not implemented");
  }
  static _CreateCanvas(width, height) {
    if (typeof document === "undefined") {
      return new OffscreenCanvas(width, height);
    }
    const canvas = document.createElement("canvas");
    canvas.width = width;
    canvas.height = height;
    return canvas;
  }
  /**
   * Create a canvas. This method is overridden by other engines
   * @param width width
   * @param height height
   * @returns ICanvas interface
   */
  createCanvas(width, height) {
    return AbstractEngine._CreateCanvas(width, height);
  }
  /**
   * Loads an image as an HTMLImageElement.
   * @param input url string, ArrayBuffer, or Blob to load
   * @param onLoad callback called when the image successfully loads
   * @param onError callback called when the image fails to load
   * @param offlineProvider offline provider for caching
   * @param mimeType optional mime type
   * @param imageBitmapOptions optional the options to use when creating an ImageBitmap
   * @param engine the engine instance to use
   * @returns the HTMLImageElement of the loaded image
   * @internal
   */
  static _FileToolsLoadImage(input, onLoad, onError, offlineProvider, mimeType, imageBitmapOptions, engine2) {
    throw _WarnImport("FileTools");
  }
  /**
   * @internal
   */
  _loadFile(url, onSuccess, onProgress, offlineProvider, useArrayBuffer, onError) {
    const request = _loadFile(url, onSuccess, onProgress, offlineProvider, useArrayBuffer, onError);
    this._activeRequests.push(request);
    request.onCompleteObservable.add(() => {
      const index2 = this._activeRequests.indexOf(request);
      if (index2 !== -1) {
        this._activeRequests.splice(index2, 1);
      }
    });
    return request;
  }
  /**
   * Loads a file from a url
   * @param url url to load
   * @param onSuccess callback called when the file successfully loads
   * @param onProgress callback called while file is loading (if the server supports this mode)
   * @param offlineProvider defines the offline provider for caching
   * @param useArrayBuffer defines a boolean indicating that date must be returned as ArrayBuffer
   * @param onError callback called when the file fails to load
   * @returns a file request object
   * @internal
   */
  static _FileToolsLoadFile(url, onSuccess, onProgress, offlineProvider, useArrayBuffer, onError) {
    if (EngineFunctionContext.loadFile) {
      return EngineFunctionContext.loadFile(url, onSuccess, onProgress, offlineProvider, useArrayBuffer, onError);
    }
    throw _WarnImport("FileTools");
  }
  /**
   * Dispose and release all associated resources
   */
  dispose() {
    var _a2;
    this.releaseEffects();
    this._isDisposed = true;
    this.stopRenderLoop();
    if (this._emptyTexture) {
      this._releaseTexture(this._emptyTexture);
      this._emptyTexture = null;
    }
    if (this._emptyCubeTexture) {
      this._releaseTexture(this._emptyCubeTexture);
      this._emptyCubeTexture = null;
    }
    this._renderingCanvas = null;
    if (this.onBeforeTextureInitObservable) {
      this.onBeforeTextureInitObservable.clear();
    }
    while (this.postProcesses.length) {
      this.postProcesses[0].dispose();
    }
    while (this.scenes.length) {
      this.scenes[0].dispose();
    }
    while (this._virtualScenes.length) {
      this._virtualScenes[0].dispose();
    }
    (_a2 = this.releaseComputeEffects) == null ? void 0 : _a2.call(this);
    Effect.ResetCache();
    for (const request of this._activeRequests) {
      request.abort();
    }
    this._boundRenderFunction = null;
    this.onDisposeObservable.notifyObservers(this);
    this.onDisposeObservable.clear();
    this.onResizeObservable.clear();
    this.onCanvasBlurObservable.clear();
    this.onCanvasFocusObservable.clear();
    this.onCanvasPointerOutObservable.clear();
    this.onNewSceneAddedObservable.clear();
    this.onEffectErrorObservable.clear();
    if (IsWindowObjectExist()) {
      window.removeEventListener("resize", this._checkForMobile);
    }
    const index2 = EngineStore.Instances.indexOf(this);
    if (index2 >= 0) {
      EngineStore.Instances.splice(index2, 1);
    }
    if (!EngineStore.Instances.length) {
      EngineStore.OnEnginesDisposedObservable.notifyObservers(this);
      EngineStore.OnEnginesDisposedObservable.clear();
    }
    this.onBeginFrameObservable.clear();
    this.onEndFrameObservable.clear();
  }
  /**
   * Method called to create the default loading screen.
   * This can be overridden in your own app.
   * @param canvas The rendering canvas element
   */
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  static DefaultLoadingScreenFactory(canvas) {
    throw _WarnImport("LoadingScreen");
  }
  /**
   * Will flag all materials in all scenes in all engines as dirty to trigger new shader compilation
   * @param flag defines which part of the materials must be marked as dirty
   * @param predicate defines a predicate used to filter which materials should be affected
   */
  static MarkAllMaterialsAsDirty(flag, predicate) {
    for (let engineIndex = 0; engineIndex < EngineStore.Instances.length; engineIndex++) {
      const engine2 = EngineStore.Instances[engineIndex];
      for (let sceneIndex = 0; sceneIndex < engine2.scenes.length; sceneIndex++) {
        engine2.scenes[sceneIndex].markAllMaterialsAsDirty(flag, predicate);
      }
    }
  }
}
AbstractEngine._RenderPassIdCounter = 0;
AbstractEngine._RescalePostProcessFactory = null;
AbstractEngine.CollisionsEpsilon = 1e-3;
AbstractEngine.QueueNewFrame = QueueNewFrame;
const Base64DataUrlRegEx = new RegExp(/^data:([^,]+\/[^,]+)?;base64,/i);
class LoadFileError extends RuntimeError {
  /**
   * Creates a new LoadFileError
   * @param message defines the message of the error
   * @param object defines the optional web request
   */
  constructor(message, object) {
    super(message, ErrorCodes.LoadFileError);
    this.name = "LoadFileError";
    BaseError._setPrototypeOf(this, LoadFileError.prototype);
    if (object instanceof WebRequest) {
      this.request = object;
    } else {
      this.file = object;
    }
  }
}
class RequestFileError extends RuntimeError {
  /**
   * Creates a new LoadFileError
   * @param message defines the message of the error
   * @param request defines the optional web request
   */
  constructor(message, request) {
    super(message, ErrorCodes.RequestFileError);
    this.request = request;
    this.name = "RequestFileError";
    BaseError._setPrototypeOf(this, RequestFileError.prototype);
  }
}
class ReadFileError extends RuntimeError {
  /**
   * Creates a new ReadFileError
   * @param message defines the message of the error
   * @param file defines the optional file
   */
  constructor(message, file) {
    super(message, ErrorCodes.ReadFileError);
    this.file = file;
    this.name = "ReadFileError";
    BaseError._setPrototypeOf(this, ReadFileError.prototype);
  }
}
const CleanUrl = (url) => {
  url = url.replace(/#/gm, "%23");
  return url;
};
const FileToolsOptions = {
  /**
   * Gets or sets the retry strategy to apply when an error happens while loading an asset.
   * When defining this function, return the wait time before trying again or return -1 to
   * stop retrying and error out.
   */
  DefaultRetryStrategy: RetryStrategy.ExponentialBackoff(),
  /**
   * Gets or sets the base URL to use to load assets
   */
  BaseUrl: "",
  /**
   * Default behaviour for cors in the application.
   * It can be a string if the expected behavior is identical in the entire app.
   * Or a callback to be able to set it per url or on a group of them (in case of Video source for instance)
   */
  CorsBehavior: "anonymous",
  /**
   * Gets or sets a function used to pre-process url before using them to load assets
   * @param url
   * @returns the processed url
   */
  PreprocessUrl: (url) => url,
  /**
   * Gets or sets the base URL to use to load scripts
   * Used for both JS and WASM
   */
  ScriptBaseUrl: "",
  /**
   * Gets or sets a function used to pre-process script url before using them to load.
   * Used for both JS and WASM
   * @param url defines the url to process
   * @returns the processed url
   */
  ScriptPreprocessUrl: (url) => url,
  /**
   * Gets or sets a function used to clean the url before using it to load assets
   * @param url defines the url to clean
   * @returns the cleaned url
   */
  CleanUrl
};
const SetCorsBehavior = (url, element) => {
  if (url && url.indexOf("data:") === 0) {
    return;
  }
  if (FileToolsOptions.CorsBehavior) {
    if (typeof FileToolsOptions.CorsBehavior === "string" || FileToolsOptions.CorsBehavior instanceof String) {
      element.crossOrigin = FileToolsOptions.CorsBehavior;
    } else {
      const result = FileToolsOptions.CorsBehavior(url);
      if (result) {
        element.crossOrigin = result;
      }
    }
  }
};
const LoadImage = (input, onLoad, onError, offlineProvider, mimeType = "", imageBitmapOptions, engine2 = EngineStore.LastCreatedEngine) => {
  if (typeof HTMLImageElement === "undefined" && !(engine2 == null ? void 0 : engine2._features.forceBitmapOverHTMLImageElement)) {
    onError("LoadImage is only supported in web or BabylonNative environments.");
    return null;
  }
  let url;
  let usingObjectURL = false;
  if (input instanceof ArrayBuffer || ArrayBuffer.isView(input)) {
    if (typeof Blob !== "undefined" && typeof URL !== "undefined") {
      url = URL.createObjectURL(new Blob([input], { type: mimeType }));
      usingObjectURL = true;
    } else {
      url = `data:${mimeType};base64,` + EncodeArrayBufferToBase64(input);
    }
  } else if (input instanceof Blob) {
    url = URL.createObjectURL(input);
    usingObjectURL = true;
  } else {
    url = FileToolsOptions.CleanUrl(input);
    url = FileToolsOptions.PreprocessUrl(url);
  }
  const onErrorHandler = (exception) => {
    if (onError) {
      const inputText = url || input.toString();
      onError(`Error while trying to load image: ${inputText.indexOf("http") === 0 || inputText.length <= 128 ? inputText : inputText.slice(0, 128) + "..."}`, exception);
    }
  };
  if (engine2 == null ? void 0 : engine2._features.forceBitmapOverHTMLImageElement) {
    LoadFile(url, (data) => {
      engine2.createImageBitmap(new Blob([data], { type: mimeType }), { premultiplyAlpha: "none", ...imageBitmapOptions }).then((imgBmp) => {
        onLoad(imgBmp);
        if (usingObjectURL) {
          URL.revokeObjectURL(url);
        }
      }).catch((reason) => {
        if (onError) {
          onError("Error while trying to load image: " + input, reason);
        }
      });
    }, void 0, offlineProvider || void 0, true, (request, exception) => {
      onErrorHandler(exception);
    });
    return null;
  }
  const img = new Image();
  SetCorsBehavior(url, img);
  const handlersList = [];
  const loadHandlersList = () => {
    handlersList.forEach((handler) => {
      handler.target.addEventListener(handler.name, handler.handler);
    });
  };
  const unloadHandlersList = () => {
    handlersList.forEach((handler) => {
      handler.target.removeEventListener(handler.name, handler.handler);
    });
    handlersList.length = 0;
  };
  const loadHandler = () => {
    unloadHandlersList();
    onLoad(img);
    if (usingObjectURL && img.src) {
      URL.revokeObjectURL(img.src);
    }
  };
  const errorHandler = (err) => {
    unloadHandlersList();
    onErrorHandler(err);
    if (usingObjectURL && img.src) {
      URL.revokeObjectURL(img.src);
    }
  };
  const cspHandler = (err) => {
    if (err.blockedURI !== img.src || err.disposition === "report") {
      return;
    }
    unloadHandlersList();
    const cspException = new Error(`CSP violation of policy ${err.effectiveDirective} ${err.blockedURI}. Current policy is ${err.originalPolicy}`);
    EngineStore.UseFallbackTexture = false;
    onErrorHandler(cspException);
    if (usingObjectURL && img.src) {
      URL.revokeObjectURL(img.src);
    }
    img.src = "";
  };
  handlersList.push({ target: img, name: "load", handler: loadHandler });
  handlersList.push({ target: img, name: "error", handler: errorHandler });
  handlersList.push({ target: document, name: "securitypolicyviolation", handler: cspHandler });
  loadHandlersList();
  const fromBlob = url.substring(0, 5) === "blob:";
  const fromData = url.substring(0, 5) === "data:";
  const noOfflineSupport = () => {
    if (fromBlob || fromData || !WebRequest.IsCustomRequestAvailable) {
      img.src = url;
    } else {
      LoadFile(url, (data, _2, contentType) => {
        const type = !mimeType && contentType ? contentType : mimeType;
        const blob = new Blob([data], { type });
        const url2 = URL.createObjectURL(blob);
        usingObjectURL = true;
        img.src = url2;
      }, void 0, offlineProvider || void 0, true, (_request, exception) => {
        onErrorHandler(exception);
      });
    }
  };
  const loadFromOfflineSupport = () => {
    if (offlineProvider) {
      offlineProvider.loadImage(url, img);
    }
  };
  if (!fromBlob && !fromData && offlineProvider && offlineProvider.enableTexturesOffline) {
    offlineProvider.open(loadFromOfflineSupport, noOfflineSupport);
  } else {
    if (url.indexOf("file:") !== -1) {
      const textureName = decodeURIComponent(url.substring(5).toLowerCase());
      if (FilesInputStore.FilesToLoad[textureName] && typeof URL !== "undefined") {
        try {
          let blobURL;
          try {
            blobURL = URL.createObjectURL(FilesInputStore.FilesToLoad[textureName]);
          } catch (ex) {
            blobURL = URL.createObjectURL(FilesInputStore.FilesToLoad[textureName]);
          }
          img.src = blobURL;
          usingObjectURL = true;
        } catch (e2) {
          img.src = "";
        }
        return img;
      }
    }
    noOfflineSupport();
  }
  return img;
};
const ReadFile = (file, onSuccess, onProgress, useArrayBuffer, onError) => {
  const reader = new FileReader();
  const fileRequest = {
    onCompleteObservable: new Observable(),
    abort: () => reader.abort()
  };
  reader.onloadend = () => fileRequest.onCompleteObservable.notifyObservers(fileRequest);
  if (onError) {
    reader.onerror = () => {
      onError(new ReadFileError(`Unable to read ${file.name}`, file));
    };
  }
  reader.onload = (e2) => {
    onSuccess(e2.target["result"]);
  };
  if (onProgress) {
    reader.onprogress = onProgress;
  }
  if (!useArrayBuffer) {
    reader.readAsText(file);
  } else {
    reader.readAsArrayBuffer(file);
  }
  return fileRequest;
};
const LoadFile = (fileOrUrl, onSuccess, onProgress, offlineProvider, useArrayBuffer, onError, onOpened) => {
  if (fileOrUrl.name) {
    return ReadFile(fileOrUrl, onSuccess, onProgress, useArrayBuffer, onError ? (error) => {
      onError(void 0, error);
    } : void 0);
  }
  const url = fileOrUrl;
  if (url.indexOf("file:") !== -1) {
    let fileName = decodeURIComponent(url.substring(5).toLowerCase());
    if (fileName.indexOf("./") === 0) {
      fileName = fileName.substring(2);
    }
    const file = FilesInputStore.FilesToLoad[fileName];
    if (file) {
      return ReadFile(file, onSuccess, onProgress, useArrayBuffer, onError ? (error) => onError(void 0, new LoadFileError(error.message, error.file)) : void 0);
    }
  }
  const { match, type } = TestBase64DataUrl(url);
  if (match) {
    const fileRequest = {
      onCompleteObservable: new Observable(),
      abort: () => () => {
      }
    };
    try {
      const data = useArrayBuffer ? DecodeBase64UrlToBinary(url) : DecodeBase64UrlToString(url);
      onSuccess(data, void 0, type);
    } catch (error) {
      if (onError) {
        onError(void 0, error);
      } else {
        Logger.Error(error.message || "Failed to parse the Data URL");
      }
    }
    TimingTools.SetImmediate(() => {
      fileRequest.onCompleteObservable.notifyObservers(fileRequest);
    });
    return fileRequest;
  }
  return RequestFile(url, (data, request) => {
    onSuccess(data, request == null ? void 0 : request.responseURL, request == null ? void 0 : request.getResponseHeader("content-type"));
  }, onProgress, offlineProvider, useArrayBuffer, onError ? (error) => {
    onError(error.request, new LoadFileError(error.message, error.request));
  } : void 0, onOpened);
};
const RequestFile = (url, onSuccess, onProgress, offlineProvider, useArrayBuffer, onError, onOpened) => {
  url = FileToolsOptions.CleanUrl(url);
  url = FileToolsOptions.PreprocessUrl(url);
  const loadUrl = FileToolsOptions.BaseUrl + url;
  let aborted = false;
  const fileRequest = {
    onCompleteObservable: new Observable(),
    abort: () => aborted = true
  };
  const requestFile = () => {
    let request = new WebRequest();
    let retryHandle = null;
    let onReadyStateChange;
    const unbindEvents = () => {
      if (!request) {
        return;
      }
      if (onProgress) {
        request.removeEventListener("progress", onProgress);
      }
      if (onReadyStateChange) {
        request.removeEventListener("readystatechange", onReadyStateChange);
      }
      request.removeEventListener("loadend", onLoadEnd);
    };
    let onLoadEnd = () => {
      unbindEvents();
      fileRequest.onCompleteObservable.notifyObservers(fileRequest);
      fileRequest.onCompleteObservable.clear();
      onProgress = void 0;
      onReadyStateChange = null;
      onLoadEnd = null;
      onError = void 0;
      onOpened = void 0;
      onSuccess = void 0;
    };
    fileRequest.abort = () => {
      aborted = true;
      if (onLoadEnd) {
        onLoadEnd();
      }
      if (request && request.readyState !== (XMLHttpRequest.DONE || 4)) {
        request.abort();
      }
      if (retryHandle !== null) {
        clearTimeout(retryHandle);
        retryHandle = null;
      }
      request = null;
    };
    const handleError = (error) => {
      const message = error.message || "Unknown error";
      if (onError && request) {
        onError(new RequestFileError(message, request));
      } else {
        Logger.Error(message);
      }
    };
    const retryLoop = (retryIndex) => {
      if (!request) {
        return;
      }
      request.open("GET", loadUrl);
      if (onOpened) {
        try {
          onOpened(request);
        } catch (e2) {
          handleError(e2);
          return;
        }
      }
      if (useArrayBuffer) {
        request.responseType = "arraybuffer";
      }
      if (onProgress) {
        request.addEventListener("progress", onProgress);
      }
      if (onLoadEnd) {
        request.addEventListener("loadend", onLoadEnd);
      }
      onReadyStateChange = () => {
        if (aborted || !request) {
          return;
        }
        if (request.readyState === (XMLHttpRequest.DONE || 4)) {
          if (onReadyStateChange) {
            request.removeEventListener("readystatechange", onReadyStateChange);
          }
          if (request.status >= 200 && request.status < 300 || request.status === 0 && (!IsWindowObjectExist() || IsFileURL())) {
            const data = useArrayBuffer ? request.response : request.responseText;
            if (data !== null) {
              try {
                if (onSuccess) {
                  onSuccess(data, request);
                }
              } catch (e2) {
                handleError(e2);
              }
              return;
            }
          }
          const retryStrategy = FileToolsOptions.DefaultRetryStrategy;
          if (retryStrategy) {
            const waitTime = retryStrategy(loadUrl, request, retryIndex);
            if (waitTime !== -1) {
              unbindEvents();
              request = new WebRequest();
              retryHandle = setTimeout(() => retryLoop(retryIndex + 1), waitTime);
              return;
            }
          }
          const error = new RequestFileError("Error status: " + request.status + " " + request.statusText + " - Unable to load " + loadUrl, request);
          if (onError) {
            onError(error);
          }
        }
      };
      request.addEventListener("readystatechange", onReadyStateChange);
      request.send();
    };
    retryLoop(0);
  };
  if (offlineProvider && offlineProvider.enableSceneOffline) {
    const noOfflineSupport = (request) => {
      if (request && request.status > 400) {
        if (onError) {
          onError(request);
        }
      } else {
        requestFile();
      }
    };
    const loadFromOfflineSupport = () => {
      if (offlineProvider) {
        offlineProvider.loadFile(FileToolsOptions.BaseUrl + url, (data) => {
          if (!aborted && onSuccess) {
            onSuccess(data);
          }
          fileRequest.onCompleteObservable.notifyObservers(fileRequest);
        }, onProgress ? (event) => {
          if (!aborted && onProgress) {
            onProgress(event);
          }
        } : void 0, noOfflineSupport, useArrayBuffer);
      }
    };
    offlineProvider.open(loadFromOfflineSupport, noOfflineSupport);
  } else {
    requestFile();
  }
  return fileRequest;
};
const IsFileURL = () => {
  return typeof location !== "undefined" && location.protocol === "file:";
};
const IsBase64DataUrl = (uri) => {
  return Base64DataUrlRegEx.test(uri);
};
const TestBase64DataUrl = (uri) => {
  const results = Base64DataUrlRegEx.exec(uri);
  if (results === null || results.length === 0) {
    return { match: false, type: "" };
  } else {
    const type = results[0].replace("data:", "").replace("base64,", "");
    return { match: true, type };
  }
};
function DecodeBase64UrlToBinary(uri) {
  return DecodeBase64ToBinary(uri.split(",")[1]);
}
const DecodeBase64UrlToString = (uri) => {
  return DecodeBase64ToString(uri.split(",")[1]);
};
const initSideEffects = () => {
  AbstractEngine._FileToolsLoadImage = LoadImage;
  EngineFunctionContext.loadFile = LoadFile;
  _functionContainer.loadFile = LoadFile;
};
initSideEffects();
let FileTools;
const _injectLTSFileTools = (DecodeBase64UrlToBinary2, DecodeBase64UrlToString2, FileToolsOptions2, IsBase64DataUrl2, IsFileURL2, LoadFile2, LoadImage2, ReadFile2, RequestFile2, SetCorsBehavior2) => {
  FileTools = {
    DecodeBase64UrlToBinary: DecodeBase64UrlToBinary2,
    DecodeBase64UrlToString: DecodeBase64UrlToString2,
    DefaultRetryStrategy: FileToolsOptions2.DefaultRetryStrategy,
    BaseUrl: FileToolsOptions2.BaseUrl,
    CorsBehavior: FileToolsOptions2.CorsBehavior,
    PreprocessUrl: FileToolsOptions2.PreprocessUrl,
    IsBase64DataUrl: IsBase64DataUrl2,
    IsFileURL: IsFileURL2,
    LoadFile: LoadFile2,
    LoadImage: LoadImage2,
    ReadFile: ReadFile2,
    RequestFile: RequestFile2,
    SetCorsBehavior: SetCorsBehavior2
  };
  Object.defineProperty(FileTools, "DefaultRetryStrategy", {
    get: function() {
      return FileToolsOptions2.DefaultRetryStrategy;
    },
    set: function(value) {
      FileToolsOptions2.DefaultRetryStrategy = value;
    }
  });
  Object.defineProperty(FileTools, "BaseUrl", {
    get: function() {
      return FileToolsOptions2.BaseUrl;
    },
    set: function(value) {
      FileToolsOptions2.BaseUrl = value;
    }
  });
  Object.defineProperty(FileTools, "PreprocessUrl", {
    get: function() {
      return FileToolsOptions2.PreprocessUrl;
    },
    set: function(value) {
      FileToolsOptions2.PreprocessUrl = value;
    }
  });
  Object.defineProperty(FileTools, "CorsBehavior", {
    get: function() {
      return FileToolsOptions2.CorsBehavior;
    },
    set: function(value) {
      FileToolsOptions2.CorsBehavior = value;
    }
  });
};
_injectLTSFileTools(DecodeBase64UrlToBinary, DecodeBase64UrlToString, FileToolsOptions, IsBase64DataUrl, IsFileURL, LoadFile, LoadImage, ReadFile, RequestFile, SetCorsBehavior);
class InstantiationTools {
  /**
   * Tries to instantiate a new object from a given class name
   * @param className defines the class name to instantiate
   * @returns the new object or null if the system was not able to do the instantiation
   */
  static Instantiate(className) {
    if (this.RegisteredExternalClasses && this.RegisteredExternalClasses[className]) {
      return this.RegisteredExternalClasses[className];
    }
    const internalClass = GetClass(className);
    if (internalClass) {
      return internalClass;
    }
    Logger.Warn(className + " not found, you may have missed an import.");
    const arr = className.split(".");
    let fn = window || this;
    for (let i2 = 0, len = arr.length; i2 < len; i2++) {
      fn = fn[arr[i2]];
    }
    if (typeof fn !== "function") {
      return null;
    }
    return fn;
  }
}
InstantiationTools.RegisteredExternalClasses = {};
function RandomGUID() {
  return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, (c2) => {
    const r3 = Math.random() * 16 | 0, v2 = c2 === "x" ? r3 : r3 & 3 | 8;
    return v2.toString(16);
  });
}
function IsExponentOfTwo(value) {
  let count = 1;
  do {
    count *= 2;
  } while (count < value);
  return count === value;
}
function Mix(a2, b2, alpha) {
  return a2 * (1 - alpha) + b2 * alpha;
}
function NearestPOT(x2) {
  const c2 = CeilingPOT(x2);
  const f2 = FloorPOT(x2);
  return c2 - x2 > x2 - f2 ? f2 : c2;
}
function CeilingPOT(x2) {
  x2--;
  x2 |= x2 >> 1;
  x2 |= x2 >> 2;
  x2 |= x2 >> 4;
  x2 |= x2 >> 8;
  x2 |= x2 >> 16;
  x2++;
  return x2;
}
function FloorPOT(x2) {
  x2 = x2 | x2 >> 1;
  x2 = x2 | x2 >> 2;
  x2 = x2 | x2 >> 4;
  x2 = x2 | x2 >> 8;
  x2 = x2 | x2 >> 16;
  return x2 - (x2 >> 1);
}
function GetExponentOfTwo(value, max, mode = 2) {
  let pot;
  switch (mode) {
    case 1:
      pot = FloorPOT(value);
      break;
    case 2:
      pot = NearestPOT(value);
      break;
    case 3:
    default:
      pot = CeilingPOT(value);
      break;
  }
  return Math.min(pot, max);
}
class Tools {
  /**
   * Gets or sets the base URL to use to load assets
   */
  static get BaseUrl() {
    return FileToolsOptions.BaseUrl;
  }
  static set BaseUrl(value) {
    FileToolsOptions.BaseUrl = value;
  }
  /**
   * Gets or sets the clean URL function to use to load assets
   */
  static get CleanUrl() {
    return FileToolsOptions.CleanUrl;
  }
  static set CleanUrl(value) {
    FileToolsOptions.CleanUrl = value;
  }
  /**
   * This function checks whether a URL is absolute or not.
   * It will also detect data and blob URLs
   * @param url the url to check
   * @returns is the url absolute or relative
   */
  static IsAbsoluteUrl(url) {
    if (url.indexOf("//") === 0) {
      return true;
    }
    if (url.indexOf("://") === -1) {
      return false;
    }
    if (url.indexOf(".") === -1) {
      return false;
    }
    if (url.indexOf("/") === -1) {
      return false;
    }
    if (url.indexOf(":") > url.indexOf("/")) {
      return false;
    }
    if (url.indexOf("://") < url.indexOf(".")) {
      return true;
    }
    if (url.indexOf("data:") === 0 || url.indexOf("blob:") === 0) {
      return true;
    }
    return false;
  }
  /**
   * Sets the base URL to use to load scripts
   */
  static set ScriptBaseUrl(value) {
    FileToolsOptions.ScriptBaseUrl = value;
  }
  static get ScriptBaseUrl() {
    return FileToolsOptions.ScriptBaseUrl;
  }
  /**
   * Sets both the script base URL and the assets base URL to the same value.
   * Setter only!
   */
  static set CDNBaseUrl(value) {
    Tools.ScriptBaseUrl = value;
    Tools.AssetBaseUrl = value;
  }
  /**
   * Sets a preprocessing function to run on a source URL before importing it
   * Note that this function will execute AFTER the base URL is appended to the URL
   */
  static set ScriptPreprocessUrl(func) {
    FileToolsOptions.ScriptPreprocessUrl = func;
  }
  static get ScriptPreprocessUrl() {
    return FileToolsOptions.ScriptPreprocessUrl;
  }
  /**
   * Gets or sets the retry strategy to apply when an error happens while loading an asset
   */
  static get DefaultRetryStrategy() {
    return FileToolsOptions.DefaultRetryStrategy;
  }
  static set DefaultRetryStrategy(strategy) {
    FileToolsOptions.DefaultRetryStrategy = strategy;
  }
  /**
   * Default behavior for cors in the application.
   * It can be a string if the expected behavior is identical in the entire app.
   * Or a callback to be able to set it per url or on a group of them (in case of Video source for instance)
   */
  static get CorsBehavior() {
    return FileToolsOptions.CorsBehavior;
  }
  static set CorsBehavior(value) {
    FileToolsOptions.CorsBehavior = value;
  }
  /**
   * Gets or sets a global variable indicating if fallback texture must be used when a texture cannot be loaded
   * @ignorenaming
   */
  static get UseFallbackTexture() {
    return EngineStore.UseFallbackTexture;
  }
  static set UseFallbackTexture(value) {
    EngineStore.UseFallbackTexture = value;
  }
  /**
   * Use this object to register external classes like custom textures or material
   * to allow the loaders to instantiate them
   */
  static get RegisteredExternalClasses() {
    return InstantiationTools.RegisteredExternalClasses;
  }
  static set RegisteredExternalClasses(classes) {
    InstantiationTools.RegisteredExternalClasses = classes;
  }
  /**
   * Texture content used if a texture cannot loaded
   * @ignorenaming
   */
  // eslint-disable-next-line @typescript-eslint/naming-convention
  static get fallbackTexture() {
    return EngineStore.FallbackTexture;
  }
  // eslint-disable-next-line @typescript-eslint/naming-convention
  static set fallbackTexture(value) {
    EngineStore.FallbackTexture = value;
  }
  /**
   * Read the content of a byte array at a specified coordinates (taking in account wrapping)
   * @param u defines the coordinate on X axis
   * @param v defines the coordinate on Y axis
   * @param width defines the width of the source data
   * @param height defines the height of the source data
   * @param pixels defines the source byte array
   * @param color defines the output color
   */
  static FetchToRef(u2, v2, width, height, pixels, color) {
    const wrappedU = Math.abs(u2) * width % width | 0;
    const wrappedV = Math.abs(v2) * height % height | 0;
    const position = (wrappedU + wrappedV * width) * 4;
    color.r = pixels[position] / 255;
    color.g = pixels[position + 1] / 255;
    color.b = pixels[position + 2] / 255;
    color.a = pixels[position + 3] / 255;
  }
  /**
   * Interpolates between a and b via alpha
   * @param a The lower value (returned when alpha = 0)
   * @param b The upper value (returned when alpha = 1)
   * @param alpha The interpolation-factor
   * @returns The mixed value
   */
  static Mix(a2, b2, alpha) {
    return 0;
  }
  /**
   * Tries to instantiate a new object from a given class name
   * @param className defines the class name to instantiate
   * @returns the new object or null if the system was not able to do the instantiation
   */
  static Instantiate(className) {
    return InstantiationTools.Instantiate(className);
  }
  /**
   * Polyfill for setImmediate
   * @param action defines the action to execute after the current execution block
   */
  static SetImmediate(action) {
    TimingTools.SetImmediate(action);
  }
  /**
   * Function indicating if a number is an exponent of 2
   * @param value defines the value to test
   * @returns true if the value is an exponent of 2
   */
  static IsExponentOfTwo(value) {
    return true;
  }
  /**
   * Returns the nearest 32-bit single precision float representation of a Number
   * @param value A Number.  If the parameter is of a different type, it will get converted
   * to a number or to NaN if it cannot be converted
   * @returns number
   */
  static FloatRound(value) {
    return Math.fround(value);
  }
  /**
   * Extracts the filename from a path
   * @param path defines the path to use
   * @returns the filename
   */
  static GetFilename(path) {
    const index2 = path.lastIndexOf("/");
    if (index2 < 0) {
      return path;
    }
    return path.substring(index2 + 1);
  }
  /**
   * Extracts the "folder" part of a path (everything before the filename).
   * @param uri The URI to extract the info from
   * @param returnUnchangedIfNoSlash Do not touch the URI if no slashes are present
   * @returns The "folder" part of the path
   */
  static GetFolderPath(uri, returnUnchangedIfNoSlash = false) {
    const index2 = uri.lastIndexOf("/");
    if (index2 < 0) {
      if (returnUnchangedIfNoSlash) {
        return uri;
      }
      return "";
    }
    return uri.substring(0, index2 + 1);
  }
  /**
   * Convert an angle in radians to degrees
   * @param angle defines the angle to convert
   * @returns the angle in degrees
   */
  static ToDegrees(angle) {
    return angle * 180 / Math.PI;
  }
  /**
   * Convert an angle in degrees to radians
   * @param angle defines the angle to convert
   * @returns the angle in radians
   */
  static ToRadians(angle) {
    return angle * Math.PI / 180;
  }
  /**
   * Smooth angle changes (kind of low-pass filter), in particular for device orientation "shaking"
   * Use trigonometric functions to avoid discontinuity (0/360, -180/180)
   * @param previousAngle defines last angle value, in degrees
   * @param newAngle defines new angle value, in degrees
   * @param smoothFactor defines smoothing sensitivity; min 0: no smoothing, max 1: new data ignored
   * @returns the angle in degrees
   */
  static SmoothAngleChange(previousAngle, newAngle, smoothFactor = 0.9) {
    const previousAngleRad = this.ToRadians(previousAngle);
    const newAngleRad = this.ToRadians(newAngle);
    return this.ToDegrees(Math.atan2((1 - smoothFactor) * Math.sin(newAngleRad) + smoothFactor * Math.sin(previousAngleRad), (1 - smoothFactor) * Math.cos(newAngleRad) + smoothFactor * Math.cos(previousAngleRad)));
  }
  /**
   * Returns an array if obj is not an array
   * @param obj defines the object to evaluate as an array
   * @param allowsNullUndefined defines a boolean indicating if obj is allowed to be null or undefined
   * @returns either obj directly if obj is an array or a new array containing obj
   */
  static MakeArray(obj, allowsNullUndefined) {
    if (allowsNullUndefined !== true && (obj === void 0 || obj == null)) {
      return null;
    }
    return Array.isArray(obj) ? obj : [obj];
  }
  /**
   * Gets the pointer prefix to use
   * @param engine defines the engine we are finding the prefix for
   * @returns "pointer" if touch is enabled. Else returns "mouse"
   */
  static GetPointerPrefix(engine2) {
    return IsWindowObjectExist() && !window.PointerEvent ? "mouse" : "pointer";
  }
  /**
   * Sets the cors behavior on a dom element. This will add the required Tools.CorsBehavior to the element.
   * @param url define the url we are trying
   * @param element define the dom element where to configure the cors policy
   * @param element.crossOrigin
   */
  static SetCorsBehavior(url, element) {
    SetCorsBehavior(url, element);
  }
  /**
   * Sets the referrerPolicy behavior on a dom element.
   * @param referrerPolicy define the referrer policy to use
   * @param element define the dom element where to configure the referrer policy
   * @param element.referrerPolicy
   */
  static SetReferrerPolicyBehavior(referrerPolicy, element) {
    element.referrerPolicy = referrerPolicy;
  }
  // External files
  /**
   * Gets or sets a function used to pre-process url before using them to load assets
   */
  static get PreprocessUrl() {
    return FileToolsOptions.PreprocessUrl;
  }
  static set PreprocessUrl(processor) {
    FileToolsOptions.PreprocessUrl = processor;
  }
  /**
   * Loads an image as an HTMLImageElement.
   * @param input url string, ArrayBuffer, or Blob to load
   * @param onLoad callback called when the image successfully loads
   * @param onError callback called when the image fails to load
   * @param offlineProvider offline provider for caching
   * @param mimeType optional mime type
   * @param imageBitmapOptions optional the options to use when creating an ImageBitmap
   * @returns the HTMLImageElement of the loaded image
   */
  static LoadImage(input, onLoad, onError, offlineProvider, mimeType, imageBitmapOptions) {
    return LoadImage(input, onLoad, onError, offlineProvider, mimeType, imageBitmapOptions);
  }
  /**
   * Loads a file from a url
   * @param url url string, ArrayBuffer, or Blob to load
   * @param onSuccess callback called when the file successfully loads
   * @param onProgress callback called while file is loading (if the server supports this mode)
   * @param offlineProvider defines the offline provider for caching
   * @param useArrayBuffer defines a boolean indicating that date must be returned as ArrayBuffer
   * @param onError callback called when the file fails to load
   * @returns a file request object
   */
  static LoadFile(url, onSuccess, onProgress, offlineProvider, useArrayBuffer, onError) {
    return LoadFile(url, onSuccess, onProgress, offlineProvider, useArrayBuffer, onError);
  }
  /**
   * Loads a file from a url
   * @param url the file url to load
   * @param useArrayBuffer defines a boolean indicating that date must be returned as ArrayBuffer
   * @returns a promise containing an ArrayBuffer corresponding to the loaded file
   */
  static LoadFileAsync(url, useArrayBuffer = true) {
    return new Promise((resolve, reject) => {
      LoadFile(url, (data) => {
        resolve(data);
      }, void 0, void 0, useArrayBuffer, (request, exception) => {
        reject(exception);
      });
    });
  }
  /**
   * This function will convert asset URLs if the AssetBaseUrl parameter is set.
   * Any URL with `assets.babylonjs.com/core` will be replaced with the value of AssetBaseUrl.
   * @param url the URL to convert
   * @returns a new URL
   */
  static GetAssetUrl(url) {
    if (!url) {
      return "";
    }
    if (Tools.AssetBaseUrl && url.startsWith(Tools._DefaultAssetsUrl)) {
      const baseUrl = Tools.AssetBaseUrl[Tools.AssetBaseUrl.length - 1] === "/" ? Tools.AssetBaseUrl.substring(0, Tools.AssetBaseUrl.length - 1) : Tools.AssetBaseUrl;
      return url.replace(Tools._DefaultAssetsUrl, baseUrl);
    }
    return url;
  }
  /**
   * Get a script URL including preprocessing
   * @param scriptUrl the script Url to process
   * @param forceAbsoluteUrl force the script to be an absolute url (adding the current base url if necessary)
   * @returns a modified URL to use
   */
  static GetBabylonScriptURL(scriptUrl, forceAbsoluteUrl) {
    if (!scriptUrl) {
      return "";
    }
    if (Tools.ScriptBaseUrl && scriptUrl.startsWith(Tools._DefaultCdnUrl)) {
      const baseUrl = Tools.ScriptBaseUrl[Tools.ScriptBaseUrl.length - 1] === "/" ? Tools.ScriptBaseUrl.substring(0, Tools.ScriptBaseUrl.length - 1) : Tools.ScriptBaseUrl;
      scriptUrl = scriptUrl.replace(Tools._DefaultCdnUrl, baseUrl);
    }
    scriptUrl = Tools.ScriptPreprocessUrl(scriptUrl);
    if (forceAbsoluteUrl) {
      scriptUrl = Tools.GetAbsoluteUrl(scriptUrl);
    }
    return scriptUrl;
  }
  /**
   * This function is used internally by babylon components to load a script (identified by an url). When the url returns, the
   * content of this file is added into a new script element, attached to the DOM (body element)
   * @param scriptUrl defines the url of the script to load
   * @param onSuccess defines the callback called when the script is loaded
   * @param onError defines the callback to call if an error occurs
   * @param scriptId defines the id of the script element
   */
  static LoadBabylonScript(scriptUrl, onSuccess, onError, scriptId) {
    scriptUrl = Tools.GetBabylonScriptURL(scriptUrl);
    Tools.LoadScript(scriptUrl, onSuccess, onError);
  }
  /**
   * Load an asynchronous script (identified by an url). When the url returns, the
   * content of this file is added into a new script element, attached to the DOM (body element)
   * @param scriptUrl defines the url of the script to laod
   * @returns a promise request object
   */
  static LoadBabylonScriptAsync(scriptUrl) {
    scriptUrl = Tools.GetBabylonScriptURL(scriptUrl);
    return Tools.LoadScriptAsync(scriptUrl);
  }
  /**
   * This function is used internally by babylon components to load a script (identified by an url). When the url returns, the
   * content of this file is added into a new script element, attached to the DOM (body element)
   * @param scriptUrl defines the url of the script to load
   * @param onSuccess defines the callback called when the script is loaded
   * @param onError defines the callback to call if an error occurs
   * @param scriptId defines the id of the script element
   * @param useModule defines if we should use the module strategy to load the script
   */
  static LoadScript(scriptUrl, onSuccess, onError, scriptId, useModule = false) {
    if (typeof importScripts === "function") {
      try {
        importScripts(scriptUrl);
        if (onSuccess) {
          onSuccess();
        }
      } catch (e2) {
        onError == null ? void 0 : onError(`Unable to load script '${scriptUrl}' in worker`, e2);
      }
      return;
    } else if (!IsWindowObjectExist()) {
      onError == null ? void 0 : onError(`Cannot load script '${scriptUrl}' outside of a window or a worker`);
      return;
    }
    const head = document.getElementsByTagName("head")[0];
    const script = document.createElement("script");
    if (useModule) {
      script.setAttribute("type", "module");
      script.innerText = scriptUrl;
    } else {
      script.setAttribute("type", "text/javascript");
      script.setAttribute("src", scriptUrl);
    }
    if (scriptId) {
      script.id = scriptId;
    }
    script.onload = () => {
      if (onSuccess) {
        onSuccess();
      }
    };
    script.onerror = (e2) => {
      if (onError) {
        onError(`Unable to load script '${scriptUrl}'`, e2);
      }
    };
    head.appendChild(script);
  }
  /**
   * Load an asynchronous script (identified by an url). When the url returns, the
   * content of this file is added into a new script element, attached to the DOM (body element)
   * @param scriptUrl defines the url of the script to load
   * @param scriptId defines the id of the script element
   * @returns a promise request object
   */
  static LoadScriptAsync(scriptUrl, scriptId) {
    return new Promise((resolve, reject) => {
      this.LoadScript(scriptUrl, () => {
        resolve();
      }, (message, exception) => {
        reject(exception || new Error(message));
      }, scriptId);
    });
  }
  /**
   * Loads a file from a blob
   * @param fileToLoad defines the blob to use
   * @param callback defines the callback to call when data is loaded
   * @param progressCallback defines the callback to call during loading process
   * @returns a file request object
   */
  static ReadFileAsDataURL(fileToLoad, callback, progressCallback) {
    const reader = new FileReader();
    const request = {
      onCompleteObservable: new Observable(),
      abort: () => reader.abort()
    };
    reader.onloadend = () => {
      request.onCompleteObservable.notifyObservers(request);
    };
    reader.onload = (e2) => {
      callback(e2.target["result"]);
    };
    reader.onprogress = progressCallback;
    reader.readAsDataURL(fileToLoad);
    return request;
  }
  /**
   * Reads a file from a File object
   * @param file defines the file to load
   * @param onSuccess defines the callback to call when data is loaded
   * @param onProgress defines the callback to call during loading process
   * @param useArrayBuffer defines a boolean indicating that data must be returned as an ArrayBuffer
   * @param onError defines the callback to call when an error occurs
   * @returns a file request object
   */
  static ReadFile(file, onSuccess, onProgress, useArrayBuffer, onError) {
    return ReadFile(file, onSuccess, onProgress, useArrayBuffer, onError);
  }
  /**
   * Creates a data url from a given string content
   * @param content defines the content to convert
   * @returns the new data url link
   */
  static FileAsURL(content) {
    const fileBlob = new Blob([content]);
    const url = window.URL;
    const link = url.createObjectURL(fileBlob);
    return link;
  }
  /**
   * Format the given number to a specific decimal format
   * @param value defines the number to format
   * @param decimals defines the number of decimals to use
   * @returns the formatted string
   */
  static Format(value, decimals = 2) {
    return value.toFixed(decimals);
  }
  /**
   * Tries to copy an object by duplicating every property
   * @param source defines the source object
   * @param destination defines the target object
   * @param doNotCopyList defines a list of properties to avoid
   * @param mustCopyList defines a list of properties to copy (even if they start with _)
   */
  static DeepCopy(source, destination, doNotCopyList, mustCopyList) {
    DeepCopier.DeepCopy(source, destination, doNotCopyList, mustCopyList);
  }
  /**
   * Gets a boolean indicating if the given object has no own property
   * @param obj defines the object to test
   * @returns true if object has no own property
   */
  static IsEmpty(obj) {
    for (const i2 in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, i2)) {
        return false;
      }
    }
    return true;
  }
  /**
   * Function used to register events at window level
   * @param windowElement defines the Window object to use
   * @param events defines the events to register
   */
  static RegisterTopRootEvents(windowElement, events) {
    for (let index2 = 0; index2 < events.length; index2++) {
      const event = events[index2];
      windowElement.addEventListener(event.name, event.handler, false);
      try {
        if (window.parent) {
          window.parent.addEventListener(event.name, event.handler, false);
        }
      } catch (e2) {
      }
    }
  }
  /**
   * Function used to unregister events from window level
   * @param windowElement defines the Window object to use
   * @param events defines the events to unregister
   */
  static UnregisterTopRootEvents(windowElement, events) {
    for (let index2 = 0; index2 < events.length; index2++) {
      const event = events[index2];
      windowElement.removeEventListener(event.name, event.handler);
      try {
        if (windowElement.parent) {
          windowElement.parent.removeEventListener(event.name, event.handler);
        }
      } catch (e2) {
      }
    }
  }
  /**
   * Dumps the current bound framebuffer
   * @param width defines the rendering width
   * @param height defines the rendering height
   * @param engine defines the hosting engine
   * @param successCallback defines the callback triggered once the data are available
   * @param mimeType defines the mime type of the result
   * @param fileName defines the filename to download. If present, the result will automatically be downloaded
   * @param quality The quality of the image if lossy mimeType is used (e.g. image/jpeg, image/webp). See {@link https://developer.mozilla.org/en-US/docs/Web/API/HTMLCanvasElement/toBlob | HTMLCanvasElement.toBlob()}'s `quality` parameter.
   * @returns a void promise
   */
  static async DumpFramebuffer(width, height, engine2, successCallback, mimeType = "image/png", fileName, quality) {
    throw _WarnImport("DumpTools");
  }
  /**
   * Dumps an array buffer
   * @param width defines the rendering width
   * @param height defines the rendering height
   * @param data the data array
   * @param successCallback defines the callback triggered once the data are available
   * @param mimeType defines the mime type of the result
   * @param fileName defines the filename to download. If present, the result will automatically be downloaded
   * @param invertY true to invert the picture in the Y dimension
   * @param toArrayBuffer true to convert the data to an ArrayBuffer (encoded as `mimeType`) instead of a base64 string
   * @param quality The quality of the image if lossy mimeType is used (e.g. image/jpeg, image/webp). See {@link https://developer.mozilla.org/en-US/docs/Web/API/HTMLCanvasElement/toBlob | HTMLCanvasElement.toBlob()}'s `quality` parameter.
   */
  static DumpData(width, height, data, successCallback, mimeType = "image/png", fileName, invertY = false, toArrayBuffer = false, quality) {
    throw _WarnImport("DumpTools");
  }
  // eslint-disable-next-line jsdoc/require-returns-check
  /**
   * Dumps an array buffer
   * @param width defines the rendering width
   * @param height defines the rendering height
   * @param data the data array
   * @param mimeType defines the mime type of the result
   * @param fileName defines the filename to download. If present, the result will automatically be downloaded
   * @param invertY true to invert the picture in the Y dimension
   * @param toArrayBuffer true to convert the data to an ArrayBuffer (encoded as `mimeType`) instead of a base64 string
   * @param quality The quality of the image if lossy mimeType is used (e.g. image/jpeg, image/webp). See {@link https://developer.mozilla.org/en-US/docs/Web/API/HTMLCanvasElement/toBlob | HTMLCanvasElement.toBlob()}'s `quality` parameter.
   * @returns a promise that resolve to the final data
   */
  static DumpDataAsync(width, height, data, mimeType = "image/png", fileName, invertY = false, toArrayBuffer = false, quality) {
    throw _WarnImport("DumpTools");
  }
  static _IsOffScreenCanvas(canvas) {
    return canvas.convertToBlob !== void 0;
  }
  /**
   * Converts the canvas data to blob.
   * This acts as a polyfill for browsers not supporting the to blob function.
   * @param canvas Defines the canvas to extract the data from (can be an offscreen canvas)
   * @param successCallback Defines the callback triggered once the data are available
   * @param mimeType Defines the mime type of the result
   * @param quality The quality of the image if lossy mimeType is used (e.g. image/jpeg, image/webp). See {@link https://developer.mozilla.org/en-US/docs/Web/API/HTMLCanvasElement/toBlob | HTMLCanvasElement.toBlob()}'s `quality` parameter.
   */
  static ToBlob(canvas, successCallback, mimeType = "image/png", quality) {
    if (!Tools._IsOffScreenCanvas(canvas) && !canvas.toBlob) {
      canvas.toBlob = function(callback, type, quality2) {
        setTimeout(() => {
          const binStr = atob(this.toDataURL(type, quality2).split(",")[1]), len = binStr.length, arr = new Uint8Array(len);
          for (let i2 = 0; i2 < len; i2++) {
            arr[i2] = binStr.charCodeAt(i2);
          }
          callback(new Blob([arr]));
        });
      };
    }
    if (Tools._IsOffScreenCanvas(canvas)) {
      canvas.convertToBlob({
        type: mimeType,
        quality
      }).then((blob) => successCallback(blob));
    } else {
      canvas.toBlob(function(blob) {
        successCallback(blob);
      }, mimeType, quality);
    }
  }
  /**
   * Download a Blob object
   * @param blob the Blob object
   * @param fileName the file name to download
   */
  static DownloadBlob(blob, fileName) {
    if ("download" in document.createElement("a")) {
      if (!fileName) {
        const date = /* @__PURE__ */ new Date();
        const stringDate = (date.getFullYear() + "-" + (date.getMonth() + 1)).slice(2) + "-" + date.getDate() + "_" + date.getHours() + "-" + ("0" + date.getMinutes()).slice(-2);
        fileName = "screenshot_" + stringDate + ".png";
      }
      Tools.Download(blob, fileName);
    } else {
      if (blob && typeof URL !== "undefined") {
        const url = URL.createObjectURL(blob);
        const newWindow = window.open("");
        if (!newWindow) {
          return;
        }
        const img = newWindow.document.createElement("img");
        img.onload = function() {
          URL.revokeObjectURL(url);
        };
        img.src = url;
        newWindow.document.body.appendChild(img);
      }
    }
  }
  /**
   * Encodes the canvas data to base 64, or automatically downloads the result if `fileName` is defined.
   * @param canvas The canvas to get the data from, which can be an offscreen canvas.
   * @param successCallback The callback which is triggered once the data is available. If `fileName` is defined, the callback will be invoked after the download occurs, and the `data` argument will be an empty string.
   * @param mimeType The mime type of the result.
   * @param fileName The name of the file to download. If defined, the result will automatically be downloaded. If not defined, and `successCallback` is also not defined, the result will automatically be downloaded with an auto-generated file name.
   * @param quality The quality of the image if lossy mimeType is used (e.g. image/jpeg, image/webp). See {@link https://developer.mozilla.org/en-US/docs/Web/API/HTMLCanvasElement/toBlob | HTMLCanvasElement.toBlob()}'s `quality` parameter.
   */
  static EncodeScreenshotCanvasData(canvas, successCallback, mimeType = "image/png", fileName, quality) {
    if (typeof fileName === "string" || !successCallback) {
      this.ToBlob(canvas, function(blob) {
        if (blob) {
          Tools.DownloadBlob(blob, fileName);
        }
        if (successCallback) {
          successCallback("");
        }
      }, mimeType, quality);
    } else if (successCallback) {
      if (Tools._IsOffScreenCanvas(canvas)) {
        canvas.convertToBlob({
          type: mimeType,
          quality
        }).then((blob) => {
          const reader = new FileReader();
          reader.readAsDataURL(blob);
          reader.onloadend = () => {
            const base64data = reader.result;
            successCallback(base64data);
          };
        });
        return;
      }
      const base64Image = canvas.toDataURL(mimeType, quality);
      successCallback(base64Image);
    }
  }
  /**
   * Downloads a blob in the browser
   * @param blob defines the blob to download
   * @param fileName defines the name of the downloaded file
   */
  static Download(blob, fileName) {
    if (typeof URL === "undefined") {
      return;
    }
    const url = window.URL.createObjectURL(blob);
    const a2 = document.createElement("a");
    document.body.appendChild(a2);
    a2.style.display = "none";
    a2.href = url;
    a2.download = fileName;
    a2.addEventListener("click", () => {
      if (a2.parentElement) {
        a2.parentElement.removeChild(a2);
      }
    });
    a2.click();
    window.URL.revokeObjectURL(url);
  }
  /**
   * Will return the right value of the noPreventDefault variable
   * Needed to keep backwards compatibility to the old API.
   *
   * @param args arguments passed to the attachControl function
   * @returns the correct value for noPreventDefault
   */
  static BackCompatCameraNoPreventDefault(args) {
    if (typeof args[0] === "boolean") {
      return args[0];
    } else if (typeof args[1] === "boolean") {
      return args[1];
    }
    return false;
  }
  /**
   * Captures a screenshot of the current rendering
   * @see https://doc.babylonjs.com/features/featuresDeepDive/scene/renderToPNG
   * @param engine defines the rendering engine
   * @param camera defines the source camera
   * @param size This parameter can be set to a single number or to an object with the
   * following (optional) properties: precision, width, height. If a single number is passed,
   * it will be used for both width and height. If an object is passed, the screenshot size
   * will be derived from the parameters. The precision property is a multiplier allowing
   * rendering at a higher or lower resolution
   * @param successCallback defines the callback receives a single parameter which contains the
   * screenshot as a string of base64-encoded characters. This string can be assigned to the
   * src parameter of an <img> to display it
   * @param mimeType defines the MIME type of the screenshot image (default: image/png).
   * Check your browser for supported MIME types
   * @param forceDownload force the system to download the image even if a successCallback is provided
   * @param quality The quality of the image if lossy mimeType is used (e.g. image/jpeg, image/webp). See {@link https://developer.mozilla.org/en-US/docs/Web/API/HTMLCanvasElement/toBlob | HTMLCanvasElement.toBlob()}'s `quality` parameter.
   */
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  static CreateScreenshot(engine2, camera, size, successCallback, mimeType = "image/png", forceDownload = false, quality) {
    throw _WarnImport("ScreenshotTools");
  }
  // eslint-disable-next-line jsdoc/require-returns-check
  /**
   * Captures a screenshot of the current rendering
   * @see https://doc.babylonjs.com/features/featuresDeepDive/scene/renderToPNG
   * @param engine defines the rendering engine
   * @param camera defines the source camera
   * @param size This parameter can be set to a single number or to an object with the
   * following (optional) properties: precision, width, height. If a single number is passed,
   * it will be used for both width and height. If an object is passed, the screenshot size
   * will be derived from the parameters. The precision property is a multiplier allowing
   * rendering at a higher or lower resolution
   * @param mimeType defines the MIME type of the screenshot image (default: image/png).
   * Check your browser for supported MIME types
   * @param quality The quality of the image if lossy mimeType is used (e.g. image/jpeg, image/webp). See {@link https://developer.mozilla.org/en-US/docs/Web/API/HTMLCanvasElement/toBlob | HTMLCanvasElement.toBlob()}'s `quality` parameter.
   * @returns screenshot as a string of base64-encoded characters. This string can be assigned
   * to the src parameter of an <img> to display it
   */
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  static CreateScreenshotAsync(engine2, camera, size, mimeType = "image/png", quality) {
    throw _WarnImport("ScreenshotTools");
  }
  /**
   * Generates an image screenshot from the specified camera.
   * @see https://doc.babylonjs.com/features/featuresDeepDive/scene/renderToPNG
   * @param engine The engine to use for rendering
   * @param camera The camera to use for rendering
   * @param size This parameter can be set to a single number or to an object with the
   * following (optional) properties: precision, width, height. If a single number is passed,
   * it will be used for both width and height. If an object is passed, the screenshot size
   * will be derived from the parameters. The precision property is a multiplier allowing
   * rendering at a higher or lower resolution
   * @param successCallback The callback receives a single parameter which contains the
   * screenshot as a string of base64-encoded characters. This string can be assigned to the
   * src parameter of an <img> to display it
   * @param mimeType The MIME type of the screenshot image (default: image/png).
   * Check your browser for supported MIME types
   * @param samples Texture samples (default: 1)
   * @param antialiasing Whether antialiasing should be turned on or not (default: false)
   * @param fileName A name for for the downloaded file.
   * @param renderSprites Whether the sprites should be rendered or not (default: false)
   * @param enableStencilBuffer Whether the stencil buffer should be enabled or not (default: false)
   * @param useLayerMask if the camera's layer mask should be used to filter what should be rendered (default: true)
   * @param quality The quality of the image if lossy mimeType is used (e.g. image/jpeg, image/webp). See {@link https://developer.mozilla.org/en-US/docs/Web/API/HTMLCanvasElement/toBlob | HTMLCanvasElement.toBlob()}'s `quality` parameter.
   * @param customizeTexture An optional callback that can be used to modify the render target texture before taking the screenshot. This can be used, for instance, to enable camera post-processes before taking the screenshot.
   */
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  static CreateScreenshotUsingRenderTarget(engine2, camera, size, successCallback, mimeType = "image/png", samples = 1, antialiasing = false, fileName, renderSprites = false, enableStencilBuffer = false, useLayerMask = true, quality, customizeTexture) {
    throw _WarnImport("ScreenshotTools");
  }
  // eslint-disable-next-line jsdoc/require-returns-check
  /**
   * Generates an image screenshot from the specified camera.
   * @see https://doc.babylonjs.com/features/featuresDeepDive/scene/renderToPNG
   * @param engine The engine to use for rendering
   * @param camera The camera to use for rendering
   * @param size This parameter can be set to a single number or to an object with the
   * following (optional) properties: precision, width, height. If a single number is passed,
   * it will be used for both width and height. If an object is passed, the screenshot size
   * will be derived from the parameters. The precision property is a multiplier allowing
   * rendering at a higher or lower resolution
   * @param mimeType The MIME type of the screenshot image (default: image/png).
   * Check your browser for supported MIME types
   * @param samples Texture samples (default: 1)
   * @param antialiasing Whether antialiasing should be turned on or not (default: false)
   * @param fileName A name for for the downloaded file.
   * @param renderSprites Whether the sprites should be rendered or not (default: false)
   * @param enableStencilBuffer Whether the stencil buffer should be enabled or not (default: false)
   * @param useLayerMask if the camera's layer mask should be used to filter what should be rendered (default: true)
   * @param quality The quality of the image if lossy mimeType is used (e.g. image/jpeg, image/webp). See {@link https://developer.mozilla.org/en-US/docs/Web/API/HTMLCanvasElement/toBlob | HTMLCanvasElement.toBlob()}'s `quality` parameter.
   * @param customizeTexture An optional callback that can be used to modify the render target texture before taking the screenshot. This can be used, for instance, to enable camera post-processes before taking the screenshot.
   * @returns screenshot as a string of base64-encoded characters. This string can be assigned
   * to the src parameter of an <img> to display it
   */
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  static CreateScreenshotUsingRenderTargetAsync(engine2, camera, size, mimeType = "image/png", samples = 1, antialiasing = false, fileName, renderSprites = false, enableStencilBuffer = false, useLayerMask = true, quality, customizeTexture) {
    throw _WarnImport("ScreenshotTools");
  }
  /**
   * Implementation from http://stackoverflow.com/questions/105034/how-to-create-a-guid-uuid-in-javascript/2117523#answer-2117523
   * Be aware Math.random() could cause collisions, but:
   * "All but 6 of the 128 bits of the ID are randomly generated, which means that for any two ids, there's a 1 in 2^^122 (or 5.3x10^^36) chance they'll collide"
   * @returns a pseudo random id
   */
  static RandomId() {
    return RandomGUID();
  }
  /**
   * Test if the given uri is a base64 string
   * @deprecated Please use FileTools.IsBase64DataUrl instead.
   * @param uri The uri to test
   * @returns True if the uri is a base64 string or false otherwise
   */
  static IsBase64(uri) {
    return IsBase64DataUrl(uri);
  }
  /**
   * Decode the given base64 uri.
   * @deprecated Please use FileTools.DecodeBase64UrlToBinary instead.
   * @param uri The uri to decode
   * @returns The decoded base64 data.
   */
  static DecodeBase64(uri) {
    return DecodeBase64UrlToBinary(uri);
  }
  /**
   * Gets a value indicating the number of loading errors
   * @ignorenaming
   */
  // eslint-disable-next-line @typescript-eslint/naming-convention
  static get errorsCount() {
    return Logger.errorsCount;
  }
  /**
   * Log a message to the console
   * @param message defines the message to log
   */
  static Log(message) {
    Logger.Log(message);
  }
  /**
   * Write a warning message to the console
   * @param message defines the message to log
   */
  static Warn(message) {
    Logger.Warn(message);
  }
  /**
   * Write an error message to the console
   * @param message defines the message to log
   */
  static Error(message) {
    Logger.Error(message);
  }
  /**
   * Gets current log cache (list of logs)
   */
  static get LogCache() {
    return Logger.LogCache;
  }
  /**
   * Clears the log cache
   */
  static ClearLogCache() {
    Logger.ClearLogCache();
  }
  /**
   * Sets the current log level (MessageLogLevel / WarningLogLevel / ErrorLogLevel)
   */
  static set LogLevels(level) {
    Logger.LogLevels = level;
  }
  /**
   * Sets the current performance log level
   */
  static set PerformanceLogLevel(level) {
    if ((level & Tools.PerformanceUserMarkLogLevel) === Tools.PerformanceUserMarkLogLevel) {
      Tools.StartPerformanceCounter = Tools._StartUserMark;
      Tools.EndPerformanceCounter = Tools._EndUserMark;
      return;
    }
    if ((level & Tools.PerformanceConsoleLogLevel) === Tools.PerformanceConsoleLogLevel) {
      Tools.StartPerformanceCounter = Tools._StartPerformanceConsole;
      Tools.EndPerformanceCounter = Tools._EndPerformanceConsole;
      return;
    }
    Tools.StartPerformanceCounter = Tools._StartPerformanceCounterDisabled;
    Tools.EndPerformanceCounter = Tools._EndPerformanceCounterDisabled;
  }
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  static _StartPerformanceCounterDisabled(counterName, condition) {
  }
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  static _EndPerformanceCounterDisabled(counterName, condition) {
  }
  static _StartUserMark(counterName, condition = true) {
    if (!Tools._Performance) {
      if (!IsWindowObjectExist()) {
        return;
      }
      Tools._Performance = window.performance;
    }
    if (!condition || !Tools._Performance.mark) {
      return;
    }
    Tools._Performance.mark(counterName + "-Begin");
  }
  static _EndUserMark(counterName, condition = true) {
    if (!condition || !Tools._Performance.mark) {
      return;
    }
    Tools._Performance.mark(counterName + "-End");
    Tools._Performance.measure(counterName, counterName + "-Begin", counterName + "-End");
  }
  static _StartPerformanceConsole(counterName, condition = true) {
    if (!condition) {
      return;
    }
    Tools._StartUserMark(counterName, condition);
    if (console.time) {
      console.time(counterName);
    }
  }
  static _EndPerformanceConsole(counterName, condition = true) {
    if (!condition) {
      return;
    }
    Tools._EndUserMark(counterName, condition);
    console.timeEnd(counterName);
  }
  /**
   * Gets either window.performance.now() if supported or Date.now() else
   */
  static get Now() {
    return PrecisionDate.Now;
  }
  /**
   * This method will return the name of the class used to create the instance of the given object.
   * It will works only on Javascript basic data types (number, string, ...) and instance of class declared with the @className decorator.
   * @param object the object to get the class name from
   * @param isType defines if the object is actually a type
   * @returns the name of the class, will be "object" for a custom data type not using the @className decorator
   */
  static GetClassName(object, isType = false) {
    let name2 = null;
    if (!isType && object.getClassName) {
      name2 = object.getClassName();
    } else {
      if (object instanceof Object) {
        const classObj = isType ? object : Object.getPrototypeOf(object);
        name2 = classObj.constructor["__bjsclassName__"];
      }
      if (!name2) {
        name2 = typeof object;
      }
    }
    return name2;
  }
  /**
   * Gets the first element of an array satisfying a given predicate
   * @param array defines the array to browse
   * @param predicate defines the predicate to use
   * @returns null if not found or the element
   */
  static First(array, predicate) {
    for (const el of array) {
      if (predicate(el)) {
        return el;
      }
    }
    return null;
  }
  /**
   * This method will return the name of the full name of the class, including its owning module (if any).
   * It will works only on Javascript basic data types (number, string, ...) and instance of class declared with the @className decorator or implementing a method getClassName():string (in which case the module won't be specified).
   * @param object the object to get the class name from
   * @param isType defines if the object is actually a type
   * @returns a string that can have two forms: "moduleName.className" if module was specified when the class' Name was registered or "className" if there was not module specified.
   * @ignorenaming
   */
  // eslint-disable-next-line @typescript-eslint/naming-convention
  static getFullClassName(object, isType = false) {
    let className = null;
    let moduleName = null;
    if (!isType && object.getClassName) {
      className = object.getClassName();
    } else {
      if (object instanceof Object) {
        const classObj = isType ? object : Object.getPrototypeOf(object);
        className = classObj.constructor["__bjsclassName__"];
        moduleName = classObj.constructor["__bjsmoduleName__"];
      }
      if (!className) {
        className = typeof object;
      }
    }
    if (!className) {
      return null;
    }
    return (moduleName != null ? moduleName + "." : "") + className;
  }
  /**
   * Returns a promise that resolves after the given amount of time.
   * @param delay Number of milliseconds to delay
   * @returns Promise that resolves after the given amount of time
   */
  static DelayAsync(delay) {
    return new Promise((resolve) => {
      setTimeout(() => {
        resolve();
      }, delay);
    });
  }
  /**
   * Utility function to detect if the current user agent is Safari
   * @returns whether or not the current user agent is safari
   */
  static IsSafari() {
    if (!IsNavigatorAvailable()) {
      return false;
    }
    return /^((?!chrome|android).)*safari/i.test(navigator.userAgent);
  }
}
Tools.AssetBaseUrl = "";
Tools.UseCustomRequestHeaders = false;
Tools.CustomRequestHeaders = WebRequest.CustomRequestHeaders;
Tools.GetDOMTextContent = GetDOMTextContent;
Tools._DefaultCdnUrl = "https://cdn.babylonjs.com";
Tools._DefaultAssetsUrl = "https://assets.babylonjs.com/core";
Tools.GetAbsoluteUrl = typeof document === "object" ? (url) => {
  const a2 = document.createElement("a");
  a2.href = url;
  return a2.href;
} : typeof URL === "function" && typeof location === "object" ? (url) => new URL(url, location.origin).href : () => {
  throw new Error("Unable to get absolute URL. Override BABYLON.Tools.GetAbsoluteUrl to a custom implementation for the current context.");
};
Tools.NoneLogLevel = Logger.NoneLogLevel;
Tools.MessageLogLevel = Logger.MessageLogLevel;
Tools.WarningLogLevel = Logger.WarningLogLevel;
Tools.ErrorLogLevel = Logger.ErrorLogLevel;
Tools.AllLogLevel = Logger.AllLogLevel;
Tools.IsWindowObjectExist = IsWindowObjectExist;
Tools.PerformanceNoneLogLevel = 0;
Tools.PerformanceUserMarkLogLevel = 1;
Tools.PerformanceConsoleLogLevel = 2;
Tools.StartPerformanceCounter = Tools._StartPerformanceCounterDisabled;
Tools.EndPerformanceCounter = Tools._EndPerformanceCounterDisabled;
class AsyncLoop {
  /**
   * Constructor.
   * @param iterations the number of iterations.
   * @param func the function to run each iteration
   * @param successCallback the callback that will be called upon successful execution
   * @param offset starting offset.
   */
  constructor(iterations, func, successCallback, offset = 0) {
    this.iterations = iterations;
    this.index = offset - 1;
    this._done = false;
    this._fn = func;
    this._successCallback = successCallback;
  }
  /**
   * Execute the next iteration. Must be called after the last iteration was finished.
   */
  executeNext() {
    if (!this._done) {
      if (this.index + 1 < this.iterations) {
        ++this.index;
        this._fn(this);
      } else {
        this.breakLoop();
      }
    }
  }
  /**
   * Break the loop and run the success callback.
   */
  breakLoop() {
    this._done = true;
    this._successCallback();
  }
  /**
   * Create and run an async loop.
   * @param iterations the number of iterations.
   * @param fn the function to run each iteration
   * @param successCallback the callback that will be called upon successful execution
   * @param offset starting offset.
   * @returns the created async loop object
   */
  static Run(iterations, fn, successCallback, offset = 0) {
    const loop = new AsyncLoop(iterations, fn, successCallback, offset);
    loop.executeNext();
    return loop;
  }
  /**
   * A for-loop that will run a given number of iterations synchronous and the rest async.
   * @param iterations total number of iterations
   * @param syncedIterations number of synchronous iterations in each async iteration.
   * @param fn the function to call each iteration.
   * @param callback a success call back that will be called when iterating stops.
   * @param breakFunction a break condition (optional)
   * @param timeout timeout settings for the setTimeout function. default - 0.
   * @returns the created async loop object
   */
  static SyncAsyncForLoop(iterations, syncedIterations, fn, callback, breakFunction, timeout = 0) {
    return AsyncLoop.Run(Math.ceil(iterations / syncedIterations), (loop) => {
      if (breakFunction && breakFunction()) {
        loop.breakLoop();
      } else {
        setTimeout(() => {
          for (let i2 = 0; i2 < syncedIterations; ++i2) {
            const iteration = loop.index * syncedIterations + i2;
            if (iteration >= iterations) {
              break;
            }
            fn(iteration);
            if (breakFunction && breakFunction()) {
              loop.breakLoop();
              break;
            }
          }
          loop.executeNext();
        }, timeout);
      }
    }, callback);
  }
}
Tools.Mix = Mix;
Tools.IsExponentOfTwo = IsExponentOfTwo;
EngineStore.FallbackTexture = "data:image/jpg;base64,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";
function inlineScheduler(coroutine, onStep, onError) {
  try {
    const step = coroutine.next();
    if (step.done) {
      onStep(step);
    } else if (!step.value) {
      onStep(step);
    } else {
      step.value.then(() => {
        step.value = void 0;
        onStep(step);
      }, onError);
    }
  } catch (error) {
    onError(error);
  }
}
function createYieldingScheduler(yieldAfterMS = 25) {
  let startTime;
  return (coroutine, onStep, onError) => {
    const currentTime = performance.now();
    if (startTime === void 0 || currentTime - startTime > yieldAfterMS) {
      startTime = currentTime;
      setTimeout(() => {
        inlineScheduler(coroutine, onStep, onError);
      }, 0);
    } else {
      inlineScheduler(coroutine, onStep, onError);
    }
  };
}
function runCoroutine(coroutine, scheduler, onSuccess, onError, abortSignal) {
  const resume = () => {
    let reschedule;
    const onStep = (stepResult) => {
      if (stepResult.done) {
        onSuccess(stepResult.value);
      } else {
        if (reschedule === void 0) {
          reschedule = true;
        } else {
          resume();
        }
      }
    };
    do {
      reschedule = void 0;
      {
        scheduler(coroutine, onStep, onError);
      }
      if (reschedule === void 0) {
        reschedule = false;
      }
    } while (reschedule);
  };
  resume();
}
function runCoroutineSync(coroutine, abortSignal) {
  let result;
  runCoroutine(coroutine, inlineScheduler, (r3) => result = r3, (e2) => {
    throw e2;
  });
  return result;
}
function runCoroutineAsync(coroutine, scheduler, abortSignal) {
  return new Promise((resolve, reject) => {
    runCoroutine(coroutine, scheduler, resolve, reject);
  });
}
function makeSyncFunction(coroutineFactory, abortSignal) {
  return (...params) => {
    return runCoroutineSync(coroutineFactory(...params));
  };
}
class SmartArray {
  /**
   * Instantiates a Smart Array.
   * @param capacity defines the default capacity of the array.
   */
  constructor(capacity) {
    this.length = 0;
    this.data = new Array(capacity);
    this._id = SmartArray._GlobalId++;
  }
  /**
   * Pushes a value at the end of the active data.
   * @param value defines the object to push in the array.
   */
  push(value) {
    this.data[this.length++] = value;
    if (this.length > this.data.length) {
      this.data.length *= 2;
    }
  }
  /**
   * Iterates over the active data and apply the lambda to them.
   * @param func defines the action to apply on each value.
   */
  forEach(func) {
    for (let index2 = 0; index2 < this.length; index2++) {
      func(this.data[index2]);
    }
  }
  /**
   * Sorts the full sets of data.
   * @param compareFn defines the comparison function to apply.
   */
  sort(compareFn) {
    this.data.sort(compareFn);
  }
  /**
   * Resets the active data to an empty array.
   */
  reset() {
    this.length = 0;
  }
  /**
   * Releases all the data from the array as well as the array.
   */
  dispose() {
    this.reset();
    if (this.data) {
      this.data.length = 0;
    }
  }
  /**
   * Concats the active data with a given array.
   * @param array defines the data to concatenate with.
   */
  concat(array) {
    if (array.length === 0) {
      return;
    }
    if (this.length + array.length > this.data.length) {
      this.data.length = (this.length + array.length) * 2;
    }
    for (let index2 = 0; index2 < array.length; index2++) {
      this.data[this.length++] = (array.data || array)[index2];
    }
  }
  /**
   * Returns the position of a value in the active data.
   * @param value defines the value to find the index for
   * @returns the index if found in the active data otherwise -1
   */
  indexOf(value) {
    const position = this.data.indexOf(value);
    if (position >= this.length) {
      return -1;
    }
    return position;
  }
  /**
   * Returns whether an element is part of the active data.
   * @param value defines the value to look for
   * @returns true if found in the active data otherwise false
   */
  contains(value) {
    return this.indexOf(value) !== -1;
  }
}
SmartArray._GlobalId = 0;
class SmartArrayNoDuplicate extends SmartArray {
  constructor() {
    super(...arguments);
    this._duplicateId = 0;
  }
  /**
   * Pushes a value at the end of the active data.
   * THIS DOES NOT PREVENT DUPPLICATE DATA
   * @param value defines the object to push in the array.
   */
  push(value) {
    super.push(value);
    if (!value.__smartArrayFlags) {
      value.__smartArrayFlags = {};
    }
    value.__smartArrayFlags[this._id] = this._duplicateId;
  }
  /**
   * Pushes a value at the end of the active data.
   * If the data is already present, it won t be added again
   * @param value defines the object to push in the array.
   * @returns true if added false if it was already present
   */
  pushNoDuplicate(value) {
    if (value.__smartArrayFlags && value.__smartArrayFlags[this._id] === this._duplicateId) {
      return false;
    }
    this.push(value);
    return true;
  }
  /**
   * Resets the active data to an empty array.
   */
  reset() {
    super.reset();
    this._duplicateId++;
  }
  /**
   * Concats the active data with a given array.
   * This ensures no duplicate will be present in the result.
   * @param array defines the data to concatenate with.
   */
  concatWithNoDuplicate(array) {
    if (array.length === 0) {
      return;
    }
    if (this.length + array.length > this.data.length) {
      this.data.length = (this.length + array.length) * 2;
    }
    for (let index2 = 0; index2 < array.length; index2++) {
      const item = (array.data || array)[index2];
      this.pushNoDuplicate(item);
    }
  }
}
class Viewport {
  /**
   * Creates a Viewport object located at (x, y) and sized (width, height)
   * @param x defines viewport left coordinate
   * @param y defines viewport top coordinate
   * @param width defines the viewport width
   * @param height defines the viewport height
   */
  constructor(x2, y2, width, height) {
    this.x = x2;
    this.y = y2;
    this.width = width;
    this.height = height;
  }
  /**
   * Creates a new viewport using absolute sizing (from 0-> width, 0-> height instead of 0->1)
   * @param renderWidth defines the rendering width
   * @param renderHeight defines the rendering height
   * @returns a new Viewport
   */
  toGlobal(renderWidth, renderHeight) {
    return new Viewport(this.x * renderWidth, this.y * renderHeight, this.width * renderWidth, this.height * renderHeight);
  }
  /**
   * Stores absolute viewport value into a target viewport (from 0-> width, 0-> height instead of 0->1)
   * @param renderWidth defines the rendering width
   * @param renderHeight defines the rendering height
   * @param ref defines the target viewport
   * @returns the current viewport
   */
  toGlobalToRef(renderWidth, renderHeight, ref) {
    ref.x = this.x * renderWidth;
    ref.y = this.y * renderHeight;
    ref.width = this.width * renderWidth;
    ref.height = this.height * renderHeight;
    return this;
  }
  /**
   * Returns a new Viewport copied from the current one
   * @returns a new Viewport
   */
  clone() {
    return new Viewport(this.x, this.y, this.width, this.height);
  }
}
class Plane {
  /**
   * Creates a Plane object according to the given floats a, b, c, d and the plane equation : ax + by + cz + d = 0
   * @param a a component of the plane
   * @param b b component of the plane
   * @param c c component of the plane
   * @param d d component of the plane
   */
  constructor(a2, b2, c2, d2) {
    this.normal = new Vector3(a2, b2, c2);
    this.d = d2;
  }
  /**
   * @returns the plane coordinates as a new array of 4 elements [a, b, c, d].
   */
  asArray() {
    return [this.normal.x, this.normal.y, this.normal.z, this.d];
  }
  // Methods
  /**
   * @returns a new plane copied from the current Plane.
   */
  clone() {
    return new Plane(this.normal.x, this.normal.y, this.normal.z, this.d);
  }
  /**
   * @returns the string "Plane".
   */
  getClassName() {
    return "Plane";
  }
  /**
   * @returns the Plane hash code.
   */
  getHashCode() {
    let hash = this.normal.getHashCode();
    hash = hash * 397 ^ (this.d | 0);
    return hash;
  }
  /**
   * Normalize the current Plane in place.
   * @returns the updated Plane.
   */
  normalize() {
    const norm = Math.sqrt(this.normal.x * this.normal.x + this.normal.y * this.normal.y + this.normal.z * this.normal.z);
    let magnitude = 0;
    if (norm !== 0) {
      magnitude = 1 / norm;
    }
    this.normal.x *= magnitude;
    this.normal.y *= magnitude;
    this.normal.z *= magnitude;
    this.d *= magnitude;
    return this;
  }
  /**
   * Applies a transformation the plane and returns the result
   * @param transformation the transformation matrix to be applied to the plane
   * @returns a new Plane as the result of the transformation of the current Plane by the given matrix.
   */
  transform(transformation) {
    const invertedMatrix = Plane._TmpMatrix;
    transformation.invertToRef(invertedMatrix);
    const m2 = invertedMatrix.m;
    const x2 = this.normal.x;
    const y2 = this.normal.y;
    const z2 = this.normal.z;
    const d2 = this.d;
    const normalX = x2 * m2[0] + y2 * m2[1] + z2 * m2[2] + d2 * m2[3];
    const normalY = x2 * m2[4] + y2 * m2[5] + z2 * m2[6] + d2 * m2[7];
    const normalZ = x2 * m2[8] + y2 * m2[9] + z2 * m2[10] + d2 * m2[11];
    const finalD = x2 * m2[12] + y2 * m2[13] + z2 * m2[14] + d2 * m2[15];
    return new Plane(normalX, normalY, normalZ, finalD);
  }
  /**
   * Compute the dot product between the point and the plane normal
   * @param point point to calculate the dot product with
   * @returns the dot product (float) of the point coordinates and the plane normal.
   */
  dotCoordinate(point) {
    return this.normal.x * point.x + this.normal.y * point.y + this.normal.z * point.z + this.d;
  }
  /**
   * Updates the current Plane from the plane defined by the three given points.
   * @param point1 one of the points used to construct the plane
   * @param point2 one of the points used to construct the plane
   * @param point3 one of the points used to construct the plane
   * @returns the updated Plane.
   */
  copyFromPoints(point1, point2, point3) {
    const x1 = point2.x - point1.x;
    const y1 = point2.y - point1.y;
    const z1 = point2.z - point1.z;
    const x2 = point3.x - point1.x;
    const y2 = point3.y - point1.y;
    const z2 = point3.z - point1.z;
    const yz = y1 * z2 - z1 * y2;
    const xz = z1 * x2 - x1 * z2;
    const xy = x1 * y2 - y1 * x2;
    const pyth = Math.sqrt(yz * yz + xz * xz + xy * xy);
    let invPyth;
    if (pyth !== 0) {
      invPyth = 1 / pyth;
    } else {
      invPyth = 0;
    }
    this.normal.x = yz * invPyth;
    this.normal.y = xz * invPyth;
    this.normal.z = xy * invPyth;
    this.d = -(this.normal.x * point1.x + this.normal.y * point1.y + this.normal.z * point1.z);
    return this;
  }
  /**
   * Checks if the plane is facing a given direction (meaning if the plane's normal is pointing in the opposite direction of the given vector).
   * Note that for this function to work as expected you should make sure that:
   *   - direction and the plane normal are normalized
   *   - epsilon is a number just bigger than -1, something like -0.99 for eg
   * @param direction the direction to check if the plane is facing
   * @param epsilon value the dot product is compared against (returns true if dot <= epsilon)
   * @returns True if the plane is facing the given direction
   */
  isFrontFacingTo(direction, epsilon) {
    const dot = Vector3.Dot(this.normal, direction);
    return dot <= epsilon;
  }
  /**
   * Calculates the distance to a point
   * @param point point to calculate distance to
   * @returns the signed distance (float) from the given point to the Plane.
   */
  signedDistanceTo(point) {
    return Vector3.Dot(point, this.normal) + this.d;
  }
  // Statics
  /**
   * Creates a plane from an  array
   * @param array the array to create a plane from
   * @returns a new Plane from the given array.
   */
  static FromArray(array) {
    return new Plane(array[0], array[1], array[2], array[3]);
  }
  /**
   * Creates a plane from three points
   * @param point1 point used to create the plane
   * @param point2 point used to create the plane
   * @param point3 point used to create the plane
   * @returns a new Plane defined by the three given points.
   */
  static FromPoints(point1, point2, point3) {
    const result = new Plane(0, 0, 0, 0);
    result.copyFromPoints(point1, point2, point3);
    return result;
  }
  /**
   * Creates a plane from an origin point and a normal
   * @param origin origin of the plane to be constructed
   * @param normal normal of the plane to be constructed
   * @returns a new Plane the normal vector to this plane at the given origin point.
   */
  static FromPositionAndNormal(origin, normal) {
    const plane = new Plane(0, 0, 0, 0);
    return this.FromPositionAndNormalToRef(origin, normal, plane);
  }
  /**
   * Updates the given Plane "result" from an origin point and a normal.
   * @param origin origin of the plane to be constructed
   * @param normal the normalized normals of the plane to be constructed
   * @param result defines the Plane where to store the result
   * @returns result input
   */
  static FromPositionAndNormalToRef(origin, normal, result) {
    result.normal.copyFrom(normal);
    result.normal.normalize();
    result.d = -origin.dot(result.normal);
    return result;
  }
  /**
   * Calculates the distance from a plane and a point
   * @param origin origin of the plane to be constructed
   * @param normal normal of the plane to be constructed
   * @param point point to calculate distance to
   * @returns the signed distance between the plane defined by the normal vector at the "origin"" point and the given other point.
   */
  static SignedDistanceToPlaneFromPositionAndNormal(origin, normal, point) {
    const d2 = -(normal.x * origin.x + normal.y * origin.y + normal.z * origin.z);
    return Vector3.Dot(point, normal) + d2;
  }
}
Plane._TmpMatrix = Matrix.Identity();
class Frustum {
  /**
   * Gets the planes representing the frustum
   * @param transform matrix to be applied to the returned planes
   * @returns a new array of 6 Frustum planes computed by the given transformation matrix.
   */
  static GetPlanes(transform) {
    const frustumPlanes = [];
    for (let index2 = 0; index2 < 6; index2++) {
      frustumPlanes.push(new Plane(0, 0, 0, 0));
    }
    Frustum.GetPlanesToRef(transform, frustumPlanes);
    return frustumPlanes;
  }
  /**
   * Gets the near frustum plane transformed by the transform matrix
   * @param transform transformation matrix to be applied to the resulting frustum plane
   * @param frustumPlane the resulting frustum plane
   */
  static GetNearPlaneToRef(transform, frustumPlane) {
    const m2 = transform.m;
    frustumPlane.normal.x = m2[3] + m2[2];
    frustumPlane.normal.y = m2[7] + m2[6];
    frustumPlane.normal.z = m2[11] + m2[10];
    frustumPlane.d = m2[15] + m2[14];
    frustumPlane.normalize();
  }
  /**
   * Gets the far frustum plane transformed by the transform matrix
   * @param transform transformation matrix to be applied to the resulting frustum plane
   * @param frustumPlane the resulting frustum plane
   */
  static GetFarPlaneToRef(transform, frustumPlane) {
    const m2 = transform.m;
    frustumPlane.normal.x = m2[3] - m2[2];
    frustumPlane.normal.y = m2[7] - m2[6];
    frustumPlane.normal.z = m2[11] - m2[10];
    frustumPlane.d = m2[15] - m2[14];
    frustumPlane.normalize();
  }
  /**
   * Gets the left frustum plane transformed by the transform matrix
   * @param transform transformation matrix to be applied to the resulting frustum plane
   * @param frustumPlane the resulting frustum plane
   */
  static GetLeftPlaneToRef(transform, frustumPlane) {
    const m2 = transform.m;
    frustumPlane.normal.x = m2[3] + m2[0];
    frustumPlane.normal.y = m2[7] + m2[4];
    frustumPlane.normal.z = m2[11] + m2[8];
    frustumPlane.d = m2[15] + m2[12];
    frustumPlane.normalize();
  }
  /**
   * Gets the right frustum plane transformed by the transform matrix
   * @param transform transformation matrix to be applied to the resulting frustum plane
   * @param frustumPlane the resulting frustum plane
   */
  static GetRightPlaneToRef(transform, frustumPlane) {
    const m2 = transform.m;
    frustumPlane.normal.x = m2[3] - m2[0];
    frustumPlane.normal.y = m2[7] - m2[4];
    frustumPlane.normal.z = m2[11] - m2[8];
    frustumPlane.d = m2[15] - m2[12];
    frustumPlane.normalize();
  }
  /**
   * Gets the top frustum plane transformed by the transform matrix
   * @param transform transformation matrix to be applied to the resulting frustum plane
   * @param frustumPlane the resulting frustum plane
   */
  static GetTopPlaneToRef(transform, frustumPlane) {
    const m2 = transform.m;
    frustumPlane.normal.x = m2[3] - m2[1];
    frustumPlane.normal.y = m2[7] - m2[5];
    frustumPlane.normal.z = m2[11] - m2[9];
    frustumPlane.d = m2[15] - m2[13];
    frustumPlane.normalize();
  }
  /**
   * Gets the bottom frustum plane transformed by the transform matrix
   * @param transform transformation matrix to be applied to the resulting frustum plane
   * @param frustumPlane the resulting frustum plane
   */
  static GetBottomPlaneToRef(transform, frustumPlane) {
    const m2 = transform.m;
    frustumPlane.normal.x = m2[3] + m2[1];
    frustumPlane.normal.y = m2[7] + m2[5];
    frustumPlane.normal.z = m2[11] + m2[9];
    frustumPlane.d = m2[15] + m2[13];
    frustumPlane.normalize();
  }
  /**
   * Sets the given array "frustumPlanes" with the 6 Frustum planes computed by the given transformation matrix.
   * @param transform transformation matrix to be applied to the resulting frustum planes
   * @param frustumPlanes the resulting frustum planes
   */
  static GetPlanesToRef(transform, frustumPlanes) {
    Frustum.GetNearPlaneToRef(transform, frustumPlanes[0]);
    Frustum.GetFarPlaneToRef(transform, frustumPlanes[1]);
    Frustum.GetLeftPlaneToRef(transform, frustumPlanes[2]);
    Frustum.GetRightPlaneToRef(transform, frustumPlanes[3]);
    Frustum.GetTopPlaneToRef(transform, frustumPlanes[4]);
    Frustum.GetBottomPlaneToRef(transform, frustumPlanes[5]);
  }
  /**
   * Tests if a point is located between the frustum planes.
   * @param point defines the point to test
   * @param frustumPlanes defines the frustum planes to test
   * @returns true if the point is located between the frustum planes
   */
  static IsPointInFrustum(point, frustumPlanes) {
    for (let i2 = 0; i2 < 6; i2++) {
      if (frustumPlanes[i2].dotCoordinate(point) < 0) {
        return false;
      }
    }
    return true;
  }
}
class Camera extends Node {
  /**
   * Define the current local position of the camera in the scene
   */
  get position() {
    return this._position;
  }
  set position(newPosition) {
    this._position = newPosition;
  }
  /**
   * The vector the camera should consider as up.
   * (default is Vector3(0, 1, 0) aka Vector3.Up())
   */
  set upVector(vec) {
    this._upVector = vec;
  }
  get upVector() {
    return this._upVector;
  }
  /**
   * The screen area in scene units squared
   */
  get screenArea() {
    let x2 = 0;
    let y2 = 0;
    if (this.mode === Camera.PERSPECTIVE_CAMERA) {
      if (this.fovMode === Camera.FOVMODE_VERTICAL_FIXED) {
        y2 = this.minZ * 2 * Math.tan(this.fov / 2);
        x2 = this.getEngine().getAspectRatio(this) * y2;
      } else {
        x2 = this.minZ * 2 * Math.tan(this.fov / 2);
        y2 = x2 / this.getEngine().getAspectRatio(this);
      }
    } else {
      const halfWidth = this.getEngine().getRenderWidth() / 2;
      const halfHeight = this.getEngine().getRenderHeight() / 2;
      x2 = (this.orthoRight ?? halfWidth) - (this.orthoLeft ?? -halfWidth);
      y2 = (this.orthoTop ?? halfHeight) - (this.orthoBottom ?? -halfHeight);
    }
    return x2 * y2;
  }
  /**
   * Define the current limit on the left side for an orthographic camera
   * In scene unit
   */
  set orthoLeft(value) {
    this._orthoLeft = value;
    for (const rigCamera of this._rigCameras) {
      rigCamera.orthoLeft = value;
    }
  }
  get orthoLeft() {
    return this._orthoLeft;
  }
  /**
   * Define the current limit on the right side for an orthographic camera
   * In scene unit
   */
  set orthoRight(value) {
    this._orthoRight = value;
    for (const rigCamera of this._rigCameras) {
      rigCamera.orthoRight = value;
    }
  }
  get orthoRight() {
    return this._orthoRight;
  }
  /**
   * Define the current limit on the bottom side for an orthographic camera
   * In scene unit
   */
  set orthoBottom(value) {
    this._orthoBottom = value;
    for (const rigCamera of this._rigCameras) {
      rigCamera.orthoBottom = value;
    }
  }
  get orthoBottom() {
    return this._orthoBottom;
  }
  /**
   * Define the current limit on the top side for an orthographic camera
   * In scene unit
   */
  set orthoTop(value) {
    this._orthoTop = value;
    for (const rigCamera of this._rigCameras) {
      rigCamera.orthoTop = value;
    }
  }
  get orthoTop() {
    return this._orthoTop;
  }
  /**
   * Define the mode of the camera (Camera.PERSPECTIVE_CAMERA or Camera.ORTHOGRAPHIC_CAMERA)
   */
  set mode(mode) {
    this._mode = mode;
    for (const rigCamera of this._rigCameras) {
      rigCamera.mode = mode;
    }
  }
  get mode() {
    return this._mode;
  }
  /**
   * Gets a flag indicating that the camera has moved in some way since the last call to Camera.update()
   */
  get hasMoved() {
    return this._hasMoved;
  }
  /**
   * Instantiates a new camera object.
   * This should not be used directly but through the inherited cameras: ArcRotate, Free...
   * @see https://doc.babylonjs.com/features/featuresDeepDive/cameras
   * @param name Defines the name of the camera in the scene
   * @param position Defines the position of the camera
   * @param scene Defines the scene the camera belongs too
   * @param setActiveOnSceneIfNoneActive Defines if the camera should be set as active after creation if no other camera have been defined in the scene
   */
  constructor(name2, position, scene, setActiveOnSceneIfNoneActive = true) {
    super(name2, scene, false);
    this._position = Vector3.Zero();
    this._upVector = Vector3.Up();
    this.oblique = null;
    this._orthoLeft = null;
    this._orthoRight = null;
    this._orthoBottom = null;
    this._orthoTop = null;
    this.fov = 0.8;
    this.projectionPlaneTilt = 0;
    this.minZ = 1;
    this.maxZ = 1e4;
    this.inertia = 0.9;
    this._mode = Camera.PERSPECTIVE_CAMERA;
    this.isIntermediate = false;
    this.viewport = new Viewport(0, 0, 1, 1);
    this.layerMask = 268435455;
    this.fovMode = Camera.FOVMODE_VERTICAL_FIXED;
    this.cameraRigMode = Camera.RIG_MODE_NONE;
    this.customRenderTargets = [];
    this.outputRenderTarget = null;
    this.onViewMatrixChangedObservable = new Observable();
    this.onProjectionMatrixChangedObservable = new Observable();
    this.onAfterCheckInputsObservable = new Observable();
    this.onRestoreStateObservable = new Observable();
    this.isRigCamera = false;
    this._hasMoved = false;
    this._rigCameras = new Array();
    this._skipRendering = false;
    this._projectionMatrix = new Matrix();
    this._postProcesses = new Array();
    this._activeMeshes = new SmartArray(256);
    this._globalPosition = Vector3.Zero();
    this._computedViewMatrix = Matrix.Identity();
    this._doNotComputeProjectionMatrix = false;
    this._transformMatrix = Matrix.Zero();
    this._refreshFrustumPlanes = true;
    this._absoluteRotation = Quaternion.Identity();
    this._isCamera = true;
    this._isLeftCamera = false;
    this._isRightCamera = false;
    this.getScene().addCamera(this);
    if (setActiveOnSceneIfNoneActive && !this.getScene().activeCamera) {
      this.getScene().activeCamera = this;
    }
    this.position = position;
    this.renderPassId = this.getScene().getEngine().createRenderPassId(`Camera ${name2}`);
  }
  /**
   * Store current camera state (fov, position, etc..)
   * @returns the camera
   */
  storeState() {
    this._stateStored = true;
    this._storedFov = this.fov;
    return this;
  }
  /**
   * Returns true if a state has been stored by calling storeState method.
   * @returns true if state has been stored.
   */
  hasStateStored() {
    return !!this._stateStored;
  }
  /**
   * Restores the camera state values if it has been stored. You must call storeState() first
   * @returns true if restored and false otherwise
   */
  _restoreStateValues() {
    if (!this._stateStored) {
      return false;
    }
    this.fov = this._storedFov;
    return true;
  }
  /**
   * Restored camera state. You must call storeState() first.
   * @returns true if restored and false otherwise
   */
  restoreState() {
    if (this._restoreStateValues()) {
      this.onRestoreStateObservable.notifyObservers(this);
      return true;
    }
    return false;
  }
  /**
   * Gets the class name of the camera.
   * @returns the class name
   */
  getClassName() {
    return "Camera";
  }
  /**
   * Gets a string representation of the camera useful for debug purpose.
   * @param fullDetails Defines that a more verbose level of logging is required
   * @returns the string representation
   */
  toString(fullDetails) {
    let ret = "Name: " + this.name;
    ret += ", type: " + this.getClassName();
    if (this.animations) {
      for (let i2 = 0; i2 < this.animations.length; i2++) {
        ret += ", animation[0]: " + this.animations[i2].toString(fullDetails);
      }
    }
    return ret;
  }
  /**
   * Automatically tilts the projection plane, using `projectionPlaneTilt`, to correct the perspective effect on vertical lines.
   */
  applyVerticalCorrection() {
    const rot = this.absoluteRotation.toEulerAngles();
    this.projectionPlaneTilt = this._scene.useRightHandedSystem ? -rot.x : rot.x;
  }
  /**
   * Gets the current world space position of the camera.
   */
  get globalPosition() {
    return this._globalPosition;
  }
  /**
   * Gets the list of active meshes this frame (meshes no culled or excluded by lod s in the frame)
   * @returns the active meshe list
   */
  getActiveMeshes() {
    return this._activeMeshes;
  }
  /**
   * Check whether a mesh is part of the current active mesh list of the camera
   * @param mesh Defines the mesh to check
   * @returns true if active, false otherwise
   */
  isActiveMesh(mesh) {
    return this._activeMeshes.indexOf(mesh) !== -1;
  }
  /**
   * Is this camera ready to be used/rendered
   * @param completeCheck defines if a complete check (including post processes) has to be done (false by default)
   * @returns true if the camera is ready
   */
  isReady(completeCheck = false) {
    if (completeCheck) {
      for (const pp of this._postProcesses) {
        if (pp && !pp.isReady()) {
          return false;
        }
      }
    }
    return super.isReady(completeCheck);
  }
  /** @internal */
  _initCache() {
    super._initCache();
    this._cache.position = new Vector3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE);
    this._cache.upVector = new Vector3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE);
    this._cache.mode = void 0;
    this._cache.minZ = void 0;
    this._cache.maxZ = void 0;
    this._cache.fov = void 0;
    this._cache.fovMode = void 0;
    this._cache.aspectRatio = void 0;
    this._cache.orthoLeft = void 0;
    this._cache.orthoRight = void 0;
    this._cache.orthoBottom = void 0;
    this._cache.orthoTop = void 0;
    this._cache.obliqueAngle = void 0;
    this._cache.obliqueLength = void 0;
    this._cache.obliqueOffset = void 0;
    this._cache.renderWidth = void 0;
    this._cache.renderHeight = void 0;
  }
  /**
   * @internal
   */
  _updateCache(ignoreParentClass) {
    if (!ignoreParentClass) {
      super._updateCache();
    }
    this._cache.position.copyFrom(this.position);
    this._cache.upVector.copyFrom(this.upVector);
  }
  /** @internal */
  _isSynchronized() {
    return this._isSynchronizedViewMatrix() && this._isSynchronizedProjectionMatrix();
  }
  /** @internal */
  _isSynchronizedViewMatrix() {
    if (!super._isSynchronized()) {
      return false;
    }
    return this._cache.position.equals(this.position) && this._cache.upVector.equals(this.upVector) && this.isSynchronizedWithParent();
  }
  /** @internal */
  _isSynchronizedProjectionMatrix() {
    let isSynchronized = this._cache.mode === this.mode && this._cache.minZ === this.minZ && this._cache.maxZ === this.maxZ;
    if (!isSynchronized) {
      return false;
    }
    const engine2 = this.getEngine();
    if (this.mode === Camera.PERSPECTIVE_CAMERA) {
      isSynchronized = this._cache.fov === this.fov && this._cache.fovMode === this.fovMode && this._cache.aspectRatio === engine2.getAspectRatio(this) && this._cache.projectionPlaneTilt === this.projectionPlaneTilt;
    } else {
      isSynchronized = this._cache.orthoLeft === this.orthoLeft && this._cache.orthoRight === this.orthoRight && this._cache.orthoBottom === this.orthoBottom && this._cache.orthoTop === this.orthoTop && this._cache.renderWidth === engine2.getRenderWidth() && this._cache.renderHeight === engine2.getRenderHeight();
      if (this.oblique) {
        isSynchronized = isSynchronized && this._cache.obliqueAngle === this.oblique.angle && this._cache.obliqueLength === this.oblique.length && this._cache.obliqueOffset === this.oblique.offset;
      }
    }
    return isSynchronized;
  }
  /**
   * Attach the input controls to a specific dom element to get the input from.
   * This function is here because typescript removes the typing of the last function.
   * @param _ignored defines an ignored parameter kept for backward compatibility.
   * @param _noPreventDefault Defines whether event caught by the controls should call preventdefault() (https://developer.mozilla.org/en-US/docs/Web/API/Event/preventDefault)
   */
  attachControl(_ignored, _noPreventDefault) {
  }
  /**
   * Detach the current controls from the specified dom element.
   * This function is here because typescript removes the typing of the last function.
   * @param _ignored defines an ignored parameter kept for backward compatibility.
   */
  detachControl(_ignored) {
  }
  /**
   * Update the camera state according to the different inputs gathered during the frame.
   */
  update() {
    this._hasMoved = false;
    this._checkInputs();
    if (this.cameraRigMode !== Camera.RIG_MODE_NONE) {
      this._updateRigCameras();
    }
    this.getViewMatrix();
    this.getProjectionMatrix();
  }
  /** @internal */
  _checkInputs() {
    this.onAfterCheckInputsObservable.notifyObservers(this);
  }
  /** @internal */
  get rigCameras() {
    return this._rigCameras;
  }
  /**
   * Gets the post process used by the rig cameras
   */
  get rigPostProcess() {
    return this._rigPostProcess;
  }
  /**
   * Internal, gets the first post process.
   * @returns the first post process to be run on this camera.
   */
  _getFirstPostProcess() {
    for (let ppIndex = 0; ppIndex < this._postProcesses.length; ppIndex++) {
      if (this._postProcesses[ppIndex] !== null) {
        return this._postProcesses[ppIndex];
      }
    }
    return null;
  }
  _cascadePostProcessesToRigCams() {
    const firstPostProcess = this._getFirstPostProcess();
    if (firstPostProcess) {
      firstPostProcess.markTextureDirty();
    }
    for (let i2 = 0, len = this._rigCameras.length; i2 < len; i2++) {
      const cam = this._rigCameras[i2];
      const rigPostProcess = cam._rigPostProcess;
      if (rigPostProcess) {
        const isPass = rigPostProcess.getEffectName() === "pass";
        if (isPass) {
          cam.isIntermediate = this._postProcesses.length === 0;
        }
        cam._postProcesses = this._postProcesses.slice(0).concat(rigPostProcess);
        rigPostProcess.markTextureDirty();
      } else {
        cam._postProcesses = this._postProcesses.slice(0);
      }
    }
  }
  /**
   * Attach a post process to the camera.
   * @see https://doc.babylonjs.com/features/featuresDeepDive/postProcesses/usePostProcesses#attach-postprocess
   * @param postProcess The post process to attach to the camera
   * @param insertAt The position of the post process in case several of them are in use in the scene
   * @returns the position the post process has been inserted at
   */
  attachPostProcess(postProcess, insertAt = null) {
    if (!postProcess.isReusable() && this._postProcesses.indexOf(postProcess) > -1) {
      Logger.Error("You're trying to reuse a post process not defined as reusable.");
      return 0;
    }
    if (insertAt == null || insertAt < 0) {
      this._postProcesses.push(postProcess);
    } else if (this._postProcesses[insertAt] === null) {
      this._postProcesses[insertAt] = postProcess;
    } else {
      this._postProcesses.splice(insertAt, 0, postProcess);
    }
    this._cascadePostProcessesToRigCams();
    if (this._scene.prePassRenderer) {
      this._scene.prePassRenderer.markAsDirty();
    }
    return this._postProcesses.indexOf(postProcess);
  }
  /**
   * Detach a post process to the camera.
   * @see https://doc.babylonjs.com/features/featuresDeepDive/postProcesses/usePostProcesses#attach-postprocess
   * @param postProcess The post process to detach from the camera
   */
  detachPostProcess(postProcess) {
    const idx = this._postProcesses.indexOf(postProcess);
    if (idx !== -1) {
      this._postProcesses[idx] = null;
    }
    if (this._scene.prePassRenderer) {
      this._scene.prePassRenderer.markAsDirty();
    }
    this._cascadePostProcessesToRigCams();
  }
  /**
   * Gets the current world matrix of the camera
   * @returns the world matrix
   */
  getWorldMatrix() {
    if (this._isSynchronizedViewMatrix()) {
      return this._worldMatrix;
    }
    this.getViewMatrix();
    return this._worldMatrix;
  }
  /** @internal */
  _getViewMatrix() {
    return Matrix.Identity();
  }
  /**
   * Gets the current view matrix of the camera.
   * @param force forces the camera to recompute the matrix without looking at the cached state
   * @returns the view matrix
   */
  getViewMatrix(force) {
    if (!force && this._isSynchronizedViewMatrix()) {
      return this._computedViewMatrix;
    }
    this._hasMoved = true;
    this.updateCache();
    this._computedViewMatrix = this._getViewMatrix();
    this._currentRenderId = this.getScene().getRenderId();
    this._childUpdateId++;
    this._refreshFrustumPlanes = true;
    if (this._cameraRigParams && this._cameraRigParams.vrPreViewMatrix) {
      this._computedViewMatrix.multiplyToRef(this._cameraRigParams.vrPreViewMatrix, this._computedViewMatrix);
    }
    if (this.parent && this.parent.onViewMatrixChangedObservable) {
      this.parent.onViewMatrixChangedObservable.notifyObservers(this.parent);
    }
    this.onViewMatrixChangedObservable.notifyObservers(this);
    this._computedViewMatrix.invertToRef(this._worldMatrix);
    return this._computedViewMatrix;
  }
  /**
   * Freeze the projection matrix.
   * It will prevent the cache check of the camera projection compute and can speed up perf
   * if no parameter of the camera are meant to change
   * @param projection Defines manually a projection if necessary
   */
  freezeProjectionMatrix(projection) {
    this._doNotComputeProjectionMatrix = true;
    if (projection !== void 0) {
      this._projectionMatrix = projection;
    }
  }
  /**
   * Unfreeze the projection matrix if it has previously been freezed by freezeProjectionMatrix.
   */
  unfreezeProjectionMatrix() {
    this._doNotComputeProjectionMatrix = false;
  }
  /**
   * Gets the current projection matrix of the camera.
   * @param force forces the camera to recompute the matrix without looking at the cached state
   * @returns the projection matrix
   */
  getProjectionMatrix(force) {
    var _a2, _b, _c;
    if (this._doNotComputeProjectionMatrix || !force && this._isSynchronizedProjectionMatrix()) {
      return this._projectionMatrix;
    }
    this._cache.mode = this.mode;
    this._cache.minZ = this.minZ;
    this._cache.maxZ = this.maxZ;
    this._refreshFrustumPlanes = true;
    const engine2 = this.getEngine();
    const scene = this.getScene();
    const reverseDepth = engine2.useReverseDepthBuffer;
    if (this.mode === Camera.PERSPECTIVE_CAMERA) {
      this._cache.fov = this.fov;
      this._cache.fovMode = this.fovMode;
      this._cache.aspectRatio = engine2.getAspectRatio(this);
      this._cache.projectionPlaneTilt = this.projectionPlaneTilt;
      if (this.minZ <= 0) {
        this.minZ = 0.1;
      }
      let getProjectionMatrix;
      if (scene.useRightHandedSystem) {
        getProjectionMatrix = Matrix.PerspectiveFovRHToRef;
      } else {
        getProjectionMatrix = Matrix.PerspectiveFovLHToRef;
      }
      getProjectionMatrix(this.fov, engine2.getAspectRatio(this), reverseDepth ? this.maxZ : this.minZ, reverseDepth ? this.minZ : this.maxZ, this._projectionMatrix, this.fovMode === Camera.FOVMODE_VERTICAL_FIXED, engine2.isNDCHalfZRange, this.projectionPlaneTilt, reverseDepth);
    } else {
      const halfWidth = engine2.getRenderWidth() / 2;
      const halfHeight = engine2.getRenderHeight() / 2;
      if (scene.useRightHandedSystem) {
        if (this.oblique) {
          Matrix.ObliqueOffCenterRHToRef(this.orthoLeft ?? -halfWidth, this.orthoRight ?? halfWidth, this.orthoBottom ?? -halfHeight, this.orthoTop ?? halfHeight, reverseDepth ? this.maxZ : this.minZ, reverseDepth ? this.minZ : this.maxZ, this.oblique.length, this.oblique.angle, this._computeObliqueDistance(this.oblique.offset), this._projectionMatrix, engine2.isNDCHalfZRange);
        } else {
          Matrix.OrthoOffCenterRHToRef(this.orthoLeft ?? -halfWidth, this.orthoRight ?? halfWidth, this.orthoBottom ?? -halfHeight, this.orthoTop ?? halfHeight, reverseDepth ? this.maxZ : this.minZ, reverseDepth ? this.minZ : this.maxZ, this._projectionMatrix, engine2.isNDCHalfZRange);
        }
      } else {
        if (this.oblique) {
          Matrix.ObliqueOffCenterLHToRef(this.orthoLeft ?? -halfWidth, this.orthoRight ?? halfWidth, this.orthoBottom ?? -halfHeight, this.orthoTop ?? halfHeight, reverseDepth ? this.maxZ : this.minZ, reverseDepth ? this.minZ : this.maxZ, this.oblique.length, this.oblique.angle, this._computeObliqueDistance(this.oblique.offset), this._projectionMatrix, engine2.isNDCHalfZRange);
        } else {
          Matrix.OrthoOffCenterLHToRef(this.orthoLeft ?? -halfWidth, this.orthoRight ?? halfWidth, this.orthoBottom ?? -halfHeight, this.orthoTop ?? halfHeight, reverseDepth ? this.maxZ : this.minZ, reverseDepth ? this.minZ : this.maxZ, this._projectionMatrix, engine2.isNDCHalfZRange);
        }
      }
      this._cache.orthoLeft = this.orthoLeft;
      this._cache.orthoRight = this.orthoRight;
      this._cache.orthoBottom = this.orthoBottom;
      this._cache.orthoTop = this.orthoTop;
      this._cache.obliqueAngle = (_a2 = this.oblique) == null ? void 0 : _a2.angle;
      this._cache.obliqueLength = (_b = this.oblique) == null ? void 0 : _b.length;
      this._cache.obliqueOffset = (_c = this.oblique) == null ? void 0 : _c.offset;
      this._cache.renderWidth = engine2.getRenderWidth();
      this._cache.renderHeight = engine2.getRenderHeight();
    }
    this.onProjectionMatrixChangedObservable.notifyObservers(this);
    return this._projectionMatrix;
  }
  /**
   * Gets the transformation matrix (ie. the multiplication of view by projection matrices)
   * @returns a Matrix
   */
  getTransformationMatrix() {
    this._computedViewMatrix.multiplyToRef(this._projectionMatrix, this._transformMatrix);
    return this._transformMatrix;
  }
  _computeObliqueDistance(offset) {
    const arcRotateCamera = this;
    const targetCamera = this;
    return (arcRotateCamera.radius || (targetCamera.target ? Vector3.Distance(this.position, targetCamera.target) : this.position.length())) + offset;
  }
  /** @internal */
  _updateFrustumPlanes() {
    if (!this._refreshFrustumPlanes) {
      return;
    }
    this.getTransformationMatrix();
    if (!this._frustumPlanes) {
      this._frustumPlanes = Frustum.GetPlanes(this._transformMatrix);
    } else {
      Frustum.GetPlanesToRef(this._transformMatrix, this._frustumPlanes);
    }
    this._refreshFrustumPlanes = false;
  }
  /**
   * Checks if a cullable object (mesh...) is in the camera frustum
   * This checks the bounding box center. See isCompletelyInFrustum for a full bounding check
   * @param target The object to check
   * @param checkRigCameras If the rig cameras should be checked (eg. with VR camera both eyes should be checked) (Default: false)
   * @returns true if the object is in frustum otherwise false
   */
  isInFrustum(target, checkRigCameras = false) {
    this._updateFrustumPlanes();
    if (checkRigCameras && this.rigCameras.length > 0) {
      let result = false;
      this.rigCameras.forEach((cam) => {
        cam._updateFrustumPlanes();
        result = result || target.isInFrustum(cam._frustumPlanes);
      });
      return result;
    } else {
      return target.isInFrustum(this._frustumPlanes);
    }
  }
  /**
   * Checks if a cullable object (mesh...) is in the camera frustum
   * Unlike isInFrustum this checks the full bounding box
   * @param target The object to check
   * @returns true if the object is in frustum otherwise false
   */
  isCompletelyInFrustum(target) {
    this._updateFrustumPlanes();
    return target.isCompletelyInFrustum(this._frustumPlanes);
  }
  // eslint-disable-next-line jsdoc/require-returns-check
  /**
   * Gets a ray in the forward direction from the camera.
   * @param length Defines the length of the ray to create
   * @param transform Defines the transform to apply to the ray, by default the world matrix is used to create a workd space ray
   * @param origin Defines the start point of the ray which defaults to the camera position
   * @returns the forward ray
   */
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  getForwardRay(length = 100, transform, origin) {
    throw _WarnImport("Ray");
  }
  // eslint-disable-next-line jsdoc/require-returns-check
  /**
   * Gets a ray in the forward direction from the camera.
   * @param refRay the ray to (re)use when setting the values
   * @param length Defines the length of the ray to create
   * @param transform Defines the transform to apply to the ray, by default the world matrx is used to create a workd space ray
   * @param origin Defines the start point of the ray which defaults to the camera position
   * @returns the forward ray
   */
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  getForwardRayToRef(refRay, length = 100, transform, origin) {
    throw _WarnImport("Ray");
  }
  /**
   * Releases resources associated with this node.
   * @param doNotRecurse Set to true to not recurse into each children (recurse into each children by default)
   * @param disposeMaterialAndTextures Set to true to also dispose referenced materials and textures (false by default)
   */
  dispose(doNotRecurse, disposeMaterialAndTextures = false) {
    this.onViewMatrixChangedObservable.clear();
    this.onProjectionMatrixChangedObservable.clear();
    this.onAfterCheckInputsObservable.clear();
    this.onRestoreStateObservable.clear();
    if (this.inputs) {
      this.inputs.clear();
    }
    this.getScene().stopAnimation(this);
    this.getScene().removeCamera(this);
    while (this._rigCameras.length > 0) {
      const camera = this._rigCameras.pop();
      if (camera) {
        camera.dispose();
      }
    }
    if (this._parentContainer) {
      const index2 = this._parentContainer.cameras.indexOf(this);
      if (index2 > -1) {
        this._parentContainer.cameras.splice(index2, 1);
      }
      this._parentContainer = null;
    }
    if (this._rigPostProcess) {
      this._rigPostProcess.dispose(this);
      this._rigPostProcess = null;
      this._postProcesses.length = 0;
    } else if (this.cameraRigMode !== Camera.RIG_MODE_NONE) {
      this._rigPostProcess = null;
      this._postProcesses.length = 0;
    } else {
      let i3 = this._postProcesses.length;
      while (--i3 >= 0) {
        const postProcess = this._postProcesses[i3];
        if (postProcess) {
          postProcess.dispose(this);
        }
      }
    }
    let i2 = this.customRenderTargets.length;
    while (--i2 >= 0) {
      this.customRenderTargets[i2].dispose();
    }
    this.customRenderTargets.length = 0;
    this._activeMeshes.dispose();
    this.getScene().getEngine().releaseRenderPassId(this.renderPassId);
    super.dispose(doNotRecurse, disposeMaterialAndTextures);
  }
  /**
   * Gets the left camera of a rig setup in case of Rigged Camera
   */
  get isLeftCamera() {
    return this._isLeftCamera;
  }
  /**
   * Gets the right camera of a rig setup in case of Rigged Camera
   */
  get isRightCamera() {
    return this._isRightCamera;
  }
  /**
   * Gets the left camera of a rig setup in case of Rigged Camera
   */
  get leftCamera() {
    if (this._rigCameras.length < 1) {
      return null;
    }
    return this._rigCameras[0];
  }
  /**
   * Gets the right camera of a rig setup in case of Rigged Camera
   */
  get rightCamera() {
    if (this._rigCameras.length < 2) {
      return null;
    }
    return this._rigCameras[1];
  }
  /**
   * Gets the left camera target of a rig setup in case of Rigged Camera
   * @returns the target position
   */
  getLeftTarget() {
    if (this._rigCameras.length < 1) {
      return null;
    }
    return this._rigCameras[0].getTarget();
  }
  /**
   * Gets the right camera target of a rig setup in case of Rigged Camera
   * @returns the target position
   */
  getRightTarget() {
    if (this._rigCameras.length < 2) {
      return null;
    }
    return this._rigCameras[1].getTarget();
  }
  /**
   * @internal
   */
  setCameraRigMode(mode, rigParams) {
    if (this.cameraRigMode === mode) {
      return;
    }
    while (this._rigCameras.length > 0) {
      const camera = this._rigCameras.pop();
      if (camera) {
        camera.dispose();
      }
    }
    this.cameraRigMode = mode;
    this._cameraRigParams = {};
    this._cameraRigParams.interaxialDistance = rigParams.interaxialDistance || 0.0637;
    this._cameraRigParams.stereoHalfAngle = Tools.ToRadians(this._cameraRigParams.interaxialDistance / 0.0637);
    if (this.cameraRigMode !== Camera.RIG_MODE_NONE) {
      const leftCamera = this.createRigCamera(this.name + "_L", 0);
      if (leftCamera) {
        leftCamera._isLeftCamera = true;
      }
      const rightCamera = this.createRigCamera(this.name + "_R", 1);
      if (rightCamera) {
        rightCamera._isRightCamera = true;
      }
      if (leftCamera && rightCamera) {
        this._rigCameras.push(leftCamera);
        this._rigCameras.push(rightCamera);
      }
    }
    this._setRigMode(rigParams);
    this._cascadePostProcessesToRigCams();
    this.update();
  }
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  _setRigMode(rigParams) {
  }
  /** @internal */
  _getVRProjectionMatrix() {
    Matrix.PerspectiveFovLHToRef(this._cameraRigParams.vrMetrics.aspectRatioFov, this._cameraRigParams.vrMetrics.aspectRatio, this.minZ, this.maxZ, this._cameraRigParams.vrWorkMatrix, true, this.getEngine().isNDCHalfZRange);
    this._cameraRigParams.vrWorkMatrix.multiplyToRef(this._cameraRigParams.vrHMatrix, this._projectionMatrix);
    return this._projectionMatrix;
  }
  /**
   * @internal
   */
  setCameraRigParameter(name2, value) {
    if (!this._cameraRigParams) {
      this._cameraRigParams = {};
    }
    this._cameraRigParams[name2] = value;
    if (name2 === "interaxialDistance") {
      this._cameraRigParams.stereoHalfAngle = Tools.ToRadians(value / 0.0637);
    }
  }
  /**
   * needs to be overridden by children so sub has required properties to be copied
   * @internal
   */
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  createRigCamera(name2, cameraIndex) {
    return null;
  }
  /**
   * May need to be overridden by children
   * @internal
   */
  _updateRigCameras() {
    for (let i2 = 0; i2 < this._rigCameras.length; i2++) {
      this._rigCameras[i2].minZ = this.minZ;
      this._rigCameras[i2].maxZ = this.maxZ;
      this._rigCameras[i2].fov = this.fov;
      this._rigCameras[i2].upVector.copyFrom(this.upVector);
    }
    if (this.cameraRigMode === Camera.RIG_MODE_STEREOSCOPIC_ANAGLYPH) {
      this._rigCameras[0].viewport = this._rigCameras[1].viewport = this.viewport;
    }
  }
  /** @internal */
  _setupInputs() {
  }
  /**
   * Serialiaze the camera setup to a json representation
   * @returns the JSON representation
   */
  serialize() {
    const serializationObject = SerializationHelper.Serialize(this);
    serializationObject.uniqueId = this.uniqueId;
    serializationObject.type = this.getClassName();
    if (this.parent) {
      this.parent._serializeAsParent(serializationObject);
    }
    if (this.inputs) {
      this.inputs.serialize(serializationObject);
    }
    SerializationHelper.AppendSerializedAnimations(this, serializationObject);
    serializationObject.ranges = this.serializeAnimationRanges();
    serializationObject.isEnabled = this.isEnabled();
    return serializationObject;
  }
  /**
   * Clones the current camera.
   * @param name The cloned camera name
   * @param newParent The cloned camera's new parent (none by default)
   * @returns the cloned camera
   */
  clone(name2, newParent = null) {
    const camera = SerializationHelper.Clone(Camera.GetConstructorFromName(this.getClassName(), name2, this.getScene(), this.interaxialDistance, this.isStereoscopicSideBySide), this);
    camera.name = name2;
    camera.parent = newParent;
    this.onClonedObservable.notifyObservers(camera);
    return camera;
  }
  /**
   * Gets the direction of the camera relative to a given local axis.
   * @param localAxis Defines the reference axis to provide a relative direction.
   * @returns the direction
   */
  getDirection(localAxis) {
    const result = Vector3.Zero();
    this.getDirectionToRef(localAxis, result);
    return result;
  }
  /**
   * Returns the current camera absolute rotation
   */
  get absoluteRotation() {
    this.getWorldMatrix().decompose(void 0, this._absoluteRotation);
    return this._absoluteRotation;
  }
  /**
   * Gets the direction of the camera relative to a given local axis into a passed vector.
   * @param localAxis Defines the reference axis to provide a relative direction.
   * @param result Defines the vector to store the result in
   */
  getDirectionToRef(localAxis, result) {
    Vector3.TransformNormalToRef(localAxis, this.getWorldMatrix(), result);
  }
  /**
   * Gets a camera constructor for a given camera type
   * @param type The type of the camera to construct (should be equal to one of the camera class name)
   * @param name The name of the camera the result will be able to instantiate
   * @param scene The scene the result will construct the camera in
   * @param interaxial_distance In case of stereoscopic setup, the distance between both eyes
   * @param isStereoscopicSideBySide In case of stereoscopic setup, should the sereo be side b side
   * @returns a factory method to construct the camera
   */
  // eslint-disable-next-line @typescript-eslint/naming-convention
  static GetConstructorFromName(type, name2, scene, interaxial_distance = 0, isStereoscopicSideBySide = true) {
    const constructorFunc = Node.Construct(type, name2, scene, {
      // eslint-disable-next-line @typescript-eslint/naming-convention
      interaxial_distance,
      isStereoscopicSideBySide
    });
    if (constructorFunc) {
      return constructorFunc;
    }
    return () => Camera._CreateDefaultParsedCamera(name2, scene);
  }
  /**
   * Compute the world  matrix of the camera.
   * @returns the camera world matrix
   */
  computeWorldMatrix() {
    return this.getWorldMatrix();
  }
  /**
   * Parse a JSON and creates the camera from the parsed information
   * @param parsedCamera The JSON to parse
   * @param scene The scene to instantiate the camera in
   * @returns the newly constructed camera
   */
  static Parse(parsedCamera, scene) {
    const type = parsedCamera.type;
    const construct = Camera.GetConstructorFromName(type, parsedCamera.name, scene, parsedCamera.interaxial_distance, parsedCamera.isStereoscopicSideBySide);
    const camera = SerializationHelper.Parse(construct, parsedCamera, scene);
    if (parsedCamera.parentId !== void 0) {
      camera._waitingParentId = parsedCamera.parentId;
    }
    if (parsedCamera.parentInstanceIndex !== void 0) {
      camera._waitingParentInstanceIndex = parsedCamera.parentInstanceIndex;
    }
    if (camera.inputs) {
      camera.inputs.parse(parsedCamera);
      camera._setupInputs();
    }
    if (parsedCamera.upVector) {
      camera.upVector = Vector3.FromArray(parsedCamera.upVector);
    }
    if (camera.setPosition) {
      camera.position.copyFromFloats(0, 0, 0);
      camera.setPosition(Vector3.FromArray(parsedCamera.position));
    }
    if (parsedCamera.target) {
      if (camera.setTarget) {
        camera.setTarget(Vector3.FromArray(parsedCamera.target));
      }
    }
    if (parsedCamera.cameraRigMode) {
      const rigParams = parsedCamera.interaxial_distance ? { interaxialDistance: parsedCamera.interaxial_distance } : {};
      camera.setCameraRigMode(parsedCamera.cameraRigMode, rigParams);
    }
    if (parsedCamera.animations) {
      for (let animationIndex = 0; animationIndex < parsedCamera.animations.length; animationIndex++) {
        const parsedAnimation = parsedCamera.animations[animationIndex];
        const internalClass = GetClass("BABYLON.Animation");
        if (internalClass) {
          camera.animations.push(internalClass.Parse(parsedAnimation));
        }
      }
      Node.ParseAnimationRanges(camera, parsedCamera, scene);
    }
    if (parsedCamera.autoAnimate) {
      scene.beginAnimation(camera, parsedCamera.autoAnimateFrom, parsedCamera.autoAnimateTo, parsedCamera.autoAnimateLoop, parsedCamera.autoAnimateSpeed || 1);
    }
    if (parsedCamera.isEnabled !== void 0) {
      camera.setEnabled(parsedCamera.isEnabled);
    }
    return camera;
  }
  /** @internal */
  _calculateHandednessMultiplier() {
    let handednessMultiplier = this.getScene().useRightHandedSystem ? -1 : 1;
    if (this.parent && this.parent._getWorldMatrixDeterminant() < 0) {
      handednessMultiplier *= -1;
    }
    return handednessMultiplier;
  }
}
Camera._CreateDefaultParsedCamera = (name2, scene) => {
  throw _WarnImport("UniversalCamera");
};
Camera.PERSPECTIVE_CAMERA = 0;
Camera.ORTHOGRAPHIC_CAMERA = 1;
Camera.FOVMODE_VERTICAL_FIXED = 0;
Camera.FOVMODE_HORIZONTAL_FIXED = 1;
Camera.RIG_MODE_NONE = 0;
Camera.RIG_MODE_STEREOSCOPIC_ANAGLYPH = 10;
Camera.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_PARALLEL = 11;
Camera.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_CROSSEYED = 12;
Camera.RIG_MODE_STEREOSCOPIC_OVERUNDER = 13;
Camera.RIG_MODE_STEREOSCOPIC_INTERLACED = 14;
Camera.RIG_MODE_VR = 20;
Camera.RIG_MODE_CUSTOM = 22;
Camera.ForceAttachControlToAlwaysPreventDefault = false;
__decorate([
  serializeAsVector3("position")
], Camera.prototype, "_position", void 0);
__decorate([
  serializeAsVector3("upVector")
], Camera.prototype, "_upVector", void 0);
__decorate([
  serialize()
], Camera.prototype, "orthoLeft", null);
__decorate([
  serialize()
], Camera.prototype, "orthoRight", null);
__decorate([
  serialize()
], Camera.prototype, "orthoBottom", null);
__decorate([
  serialize()
], Camera.prototype, "orthoTop", null);
__decorate([
  serialize()
], Camera.prototype, "fov", void 0);
__decorate([
  serialize()
], Camera.prototype, "projectionPlaneTilt", void 0);
__decorate([
  serialize()
], Camera.prototype, "minZ", void 0);
__decorate([
  serialize()
], Camera.prototype, "maxZ", void 0);
__decorate([
  serialize()
], Camera.prototype, "inertia", void 0);
__decorate([
  serialize()
], Camera.prototype, "mode", null);
__decorate([
  serialize()
], Camera.prototype, "layerMask", void 0);
__decorate([
  serialize()
], Camera.prototype, "fovMode", void 0);
__decorate([
  serialize()
], Camera.prototype, "cameraRigMode", void 0);
__decorate([
  serialize()
], Camera.prototype, "interaxialDistance", void 0);
__decorate([
  serialize()
], Camera.prototype, "isStereoscopicSideBySide", void 0);
class DataBuffer {
  /**
   * Gets the underlying buffer
   */
  get underlyingResource() {
    return null;
  }
  /**
   * Constructs the buffer
   */
  constructor() {
    this.references = 0;
    this.capacity = 0;
    this.is32Bits = false;
    this.uniqueId = DataBuffer._Counter++;
  }
}
DataBuffer._Counter = 0;
function GetFloatValue(dataView, type, byteOffset, normalized) {
  switch (type) {
    case 5120: {
      let value = dataView.getInt8(byteOffset);
      if (normalized) {
        value = Math.max(value / 127, -1);
      }
      return value;
    }
    case 5121: {
      let value = dataView.getUint8(byteOffset);
      if (normalized) {
        value = value / 255;
      }
      return value;
    }
    case 5122: {
      let value = dataView.getInt16(byteOffset, true);
      if (normalized) {
        value = Math.max(value / 32767, -1);
      }
      return value;
    }
    case 5123: {
      let value = dataView.getUint16(byteOffset, true);
      if (normalized) {
        value = value / 65535;
      }
      return value;
    }
    case 5124: {
      return dataView.getInt32(byteOffset, true);
    }
    case 5125: {
      return dataView.getUint32(byteOffset, true);
    }
    case 5126: {
      return dataView.getFloat32(byteOffset, true);
    }
    default: {
      throw new Error(`Invalid component type ${type}`);
    }
  }
}
function SetFloatValue(dataView, type, byteOffset, normalized, value) {
  switch (type) {
    case 5120: {
      if (normalized) {
        value = Math.round(value * 127);
      }
      dataView.setInt8(byteOffset, value);
      break;
    }
    case 5121: {
      if (normalized) {
        value = Math.round(value * 255);
      }
      dataView.setUint8(byteOffset, value);
      break;
    }
    case 5122: {
      if (normalized) {
        value = Math.round(value * 32767);
      }
      dataView.setInt16(byteOffset, value, true);
      break;
    }
    case 5123: {
      if (normalized) {
        value = Math.round(value * 65535);
      }
      dataView.setUint16(byteOffset, value, true);
      break;
    }
    case 5124: {
      dataView.setInt32(byteOffset, value, true);
      break;
    }
    case 5125: {
      dataView.setUint32(byteOffset, value, true);
      break;
    }
    case 5126: {
      dataView.setFloat32(byteOffset, value, true);
      break;
    }
    default: {
      throw new Error(`Invalid component type ${type}`);
    }
  }
}
function GetTypeByteLength(type) {
  switch (type) {
    case 5120:
    case 5121:
      return 1;
    case 5122:
    case 5123:
      return 2;
    case 5124:
    case 5125:
    case 5126:
      return 4;
    default:
      throw new Error(`Invalid type '${type}'`);
  }
}
function GetTypedArrayConstructor(componentType) {
  switch (componentType) {
    case 5120:
      return Int8Array;
    case 5121:
      return Uint8Array;
    case 5122:
      return Int16Array;
    case 5123:
      return Uint16Array;
    case 5124:
      return Int32Array;
    case 5125:
      return Uint32Array;
    case 5126:
      return Float32Array;
    default:
      throw new Error(`Invalid component type '${componentType}'`);
  }
}
function EnumerateFloatValues(data, byteOffset, byteStride, componentCount, componentType, count, normalized, callback) {
  const oldValues = new Array(componentCount);
  const newValues = new Array(componentCount);
  if (data instanceof Array) {
    let offset = byteOffset / 4;
    const stride = byteStride / 4;
    for (let index2 = 0; index2 < count; index2 += componentCount) {
      for (let componentIndex = 0; componentIndex < componentCount; componentIndex++) {
        oldValues[componentIndex] = newValues[componentIndex] = data[offset + componentIndex];
      }
      callback(newValues, index2);
      for (let componentIndex = 0; componentIndex < componentCount; componentIndex++) {
        if (oldValues[componentIndex] !== newValues[componentIndex]) {
          data[offset + componentIndex] = newValues[componentIndex];
        }
      }
      offset += stride;
    }
  } else {
    const dataView = !ArrayBuffer.isView(data) ? new DataView(data) : new DataView(data.buffer, data.byteOffset, data.byteLength);
    const componentByteLength = GetTypeByteLength(componentType);
    for (let index2 = 0; index2 < count; index2 += componentCount) {
      for (let componentIndex = 0, componentByteOffset = byteOffset; componentIndex < componentCount; componentIndex++, componentByteOffset += componentByteLength) {
        oldValues[componentIndex] = newValues[componentIndex] = GetFloatValue(dataView, componentType, componentByteOffset, normalized);
      }
      callback(newValues, index2);
      for (let componentIndex = 0, componentByteOffset = byteOffset; componentIndex < componentCount; componentIndex++, componentByteOffset += componentByteLength) {
        if (oldValues[componentIndex] !== newValues[componentIndex]) {
          SetFloatValue(dataView, componentType, componentByteOffset, normalized, newValues[componentIndex]);
        }
      }
      byteOffset += byteStride;
    }
  }
}
function GetFloatData(data, size, type, byteOffset, byteStride, normalized, totalVertices, forceCopy) {
  const tightlyPackedByteStride = size * GetTypeByteLength(type);
  const count = totalVertices * size;
  if (type !== 5126 || byteStride !== tightlyPackedByteStride) {
    const copy = new Float32Array(count);
    EnumerateFloatValues(data, byteOffset, byteStride, size, type, count, normalized, (values, index2) => {
      for (let i2 = 0; i2 < size; i2++) {
        copy[index2 + i2] = values[i2];
      }
    });
    return copy;
  }
  if (!(data instanceof Array || data instanceof Float32Array) || byteOffset !== 0 || data.length !== count) {
    if (data instanceof Array) {
      const offset = byteOffset / 4;
      return data.slice(offset, offset + count);
    } else if (data instanceof ArrayBuffer) {
      return new Float32Array(data, byteOffset, count);
    } else {
      const offset = data.byteOffset + byteOffset;
      if ((offset & 3) !== 0) {
        Logger.Warn("Float array must be aligned to 4-bytes border");
        forceCopy = true;
      }
      if (forceCopy) {
        return new Float32Array(data.buffer.slice(offset, offset + count * Float32Array.BYTES_PER_ELEMENT));
      } else {
        return new Float32Array(data.buffer, offset, count);
      }
    }
  }
  if (forceCopy) {
    return data.slice();
  }
  return data;
}
function CopyFloatData(input, size, type, byteOffset, byteStride, normalized, totalVertices, output) {
  const tightlyPackedByteStride = size * GetTypeByteLength(type);
  const count = totalVertices * size;
  if (output.length !== count) {
    throw new Error("Output length is not valid");
  }
  if (type !== 5126 || byteStride !== tightlyPackedByteStride) {
    EnumerateFloatValues(input, byteOffset, byteStride, size, type, count, normalized, (values, index2) => {
      for (let i2 = 0; i2 < size; i2++) {
        output[index2 + i2] = values[i2];
      }
    });
    return;
  }
  if (input instanceof Array) {
    const offset = byteOffset / 4;
    output.set(input, offset);
  } else if (input instanceof ArrayBuffer) {
    const floatData = new Float32Array(input, byteOffset, count);
    output.set(floatData);
  } else {
    const offset = input.byteOffset + byteOffset;
    if ((offset & 3) !== 0) {
      Logger.Warn("Float array must be aligned to 4-bytes border");
      output.set(new Float32Array(input.buffer.slice(offset, offset + count * Float32Array.BYTES_PER_ELEMENT)));
      return;
    }
    const floatData = new Float32Array(input.buffer, offset, count);
    output.set(floatData);
  }
}
class Buffer {
  /**
   * Gets a boolean indicating if the Buffer is disposed
   */
  get isDisposed() {
    return this._isDisposed;
  }
  /**
   * Constructor
   * @param engine the engine
   * @param data the data to use for this buffer
   * @param updatable whether the data is updatable
   * @param stride the stride (optional)
   * @param postponeInternalCreation whether to postpone creating the internal WebGL buffer (optional)
   * @param instanced whether the buffer is instanced (optional)
   * @param useBytes set to true if the stride in in bytes (optional)
   * @param divisor sets an optional divisor for instances (1 by default)
   * @param label defines the label of the buffer (for debug purpose)
   */
  constructor(engine2, data, updatable, stride = 0, postponeInternalCreation = false, instanced = false, useBytes = false, divisor, label) {
    this._isAlreadyOwned = false;
    this._isDisposed = false;
    if (engine2 && engine2.getScene) {
      this._engine = engine2.getScene().getEngine();
    } else {
      this._engine = engine2;
    }
    this._updatable = updatable;
    this._instanced = instanced;
    this._divisor = divisor || 1;
    this._label = label;
    if (data instanceof DataBuffer) {
      this._data = null;
      this._buffer = data;
    } else {
      this._data = data;
      this._buffer = null;
    }
    this.byteStride = useBytes ? stride : stride * Float32Array.BYTES_PER_ELEMENT;
    if (!postponeInternalCreation) {
      this.create();
    }
  }
  /**
   * Create a new VertexBuffer based on the current buffer
   * @param kind defines the vertex buffer kind (position, normal, etc.)
   * @param offset defines offset in the buffer (0 by default)
   * @param size defines the size in floats of attributes (position is 3 for instance)
   * @param stride defines the stride size in floats in the buffer (the offset to apply to reach next value when data is interleaved)
   * @param instanced defines if the vertex buffer contains indexed data
   * @param useBytes defines if the offset and stride are in bytes     *
   * @param divisor sets an optional divisor for instances (1 by default)
   * @returns the new vertex buffer
   */
  createVertexBuffer(kind, offset, size, stride, instanced, useBytes = false, divisor) {
    const byteOffset = useBytes ? offset : offset * Float32Array.BYTES_PER_ELEMENT;
    const byteStride = stride ? useBytes ? stride : stride * Float32Array.BYTES_PER_ELEMENT : this.byteStride;
    return new VertexBuffer(this._engine, this, kind, this._updatable, true, byteStride, instanced === void 0 ? this._instanced : instanced, byteOffset, size, void 0, void 0, true, this._divisor || divisor);
  }
  // Properties
  /**
   * Gets a boolean indicating if the Buffer is updatable?
   * @returns true if the buffer is updatable
   */
  isUpdatable() {
    return this._updatable;
  }
  /**
   * Gets current buffer's data
   * @returns a DataArray or null
   */
  getData() {
    return this._data;
  }
  /**
   * Gets underlying native buffer
   * @returns underlying native buffer
   */
  getBuffer() {
    return this._buffer;
  }
  /**
   * Gets the stride in float32 units (i.e. byte stride / 4).
   * May not be an integer if the byte stride is not divisible by 4.
   * @returns the stride in float32 units
   * @deprecated Please use byteStride instead.
   */
  getStrideSize() {
    return this.byteStride / Float32Array.BYTES_PER_ELEMENT;
  }
  // Methods
  /**
   * Store data into the buffer. Creates the buffer if not used already.
   * If the buffer was already used, it will be updated only if it is updatable, otherwise it will do nothing.
   * @param data defines the data to store
   */
  create(data = null) {
    if (!data && this._buffer) {
      return;
    }
    data = data || this._data;
    if (!data) {
      return;
    }
    if (!this._buffer) {
      if (this._updatable) {
        this._buffer = this._engine.createDynamicVertexBuffer(data, this._label);
        this._data = data;
      } else {
        this._buffer = this._engine.createVertexBuffer(data, void 0, this._label);
      }
    } else if (this._updatable) {
      this._engine.updateDynamicVertexBuffer(this._buffer, data);
      this._data = data;
    }
  }
  /** @internal */
  _rebuild() {
    if (!this._data) {
      if (!this._buffer) {
        return;
      }
      if (this._buffer.capacity > 0) {
        if (this._updatable) {
          this._buffer = this._engine.createDynamicVertexBuffer(this._buffer.capacity, this._label);
        } else {
          this._buffer = this._engine.createVertexBuffer(this._buffer.capacity, void 0, this._label);
        }
        return;
      }
      Logger.Warn(`Missing data for buffer "${this._label}" ${this._buffer ? "(uniqueId: " + this._buffer.uniqueId + ")" : ""}. Buffer reconstruction failed.`);
      this._buffer = null;
    } else {
      this._buffer = null;
      this.create(this._data);
    }
  }
  /**
   * Update current buffer data
   * @param data defines the data to store
   */
  update(data) {
    this.create(data);
  }
  /**
   * Updates the data directly.
   * @param data the new data
   * @param offset the new offset
   * @param vertexCount the vertex count (optional)
   * @param useBytes set to true if the offset is in bytes
   */
  updateDirectly(data, offset, vertexCount, useBytes = false) {
    if (!this._buffer) {
      return;
    }
    if (this._updatable) {
      this._engine.updateDynamicVertexBuffer(this._buffer, data, useBytes ? offset : offset * Float32Array.BYTES_PER_ELEMENT, vertexCount ? vertexCount * this.byteStride : void 0);
      if (offset === 0 && vertexCount === void 0) {
        this._data = data;
      } else {
        this._data = null;
      }
    }
  }
  /** @internal */
  _increaseReferences() {
    if (!this._buffer) {
      return;
    }
    if (!this._isAlreadyOwned) {
      this._isAlreadyOwned = true;
      return;
    }
    this._buffer.references++;
  }
  /**
   * Release all resources
   */
  dispose() {
    if (!this._buffer) {
      return;
    }
    if (this._engine._releaseBuffer(this._buffer)) {
      this._isDisposed = true;
      this._data = null;
      this._buffer = null;
    }
  }
}
class VertexBuffer {
  /**
   * Gets a boolean indicating if the Buffer is disposed
   */
  get isDisposed() {
    return this._isDisposed;
  }
  /**
   * Gets or sets the instance divisor when in instanced mode
   */
  get instanceDivisor() {
    return this._instanceDivisor;
  }
  set instanceDivisor(value) {
    const isInstanced = value != 0;
    this._instanceDivisor = value;
    if (isInstanced !== this._instanced) {
      this._instanced = isInstanced;
      this._computeHashCode();
    }
  }
  /**
   * Gets the max possible amount of vertices stored within the current vertex buffer.
   * We do not have the end offset or count so this will be too big for concatenated vertex buffers.
   * @internal
   */
  get _maxVerticesCount() {
    const data = this.getData();
    if (!data) {
      return 0;
    }
    if (Array.isArray(data)) {
      return data.length / (this.byteStride / 4) - this.byteOffset / 4;
    }
    return (data.byteLength - this.byteOffset) / this.byteStride;
  }
  /** @internal */
  constructor(engine2, data, kind, updatableOrOptions, postponeInternalCreation, stride, instanced, offset, size, type, normalized = false, useBytes = false, divisor = 1, takeBufferOwnership = false) {
    this._isDisposed = false;
    let updatable = false;
    this.engine = engine2;
    if (typeof updatableOrOptions === "object" && updatableOrOptions !== null) {
      updatable = updatableOrOptions.updatable ?? false;
      postponeInternalCreation = updatableOrOptions.postponeInternalCreation;
      stride = updatableOrOptions.stride;
      instanced = updatableOrOptions.instanced;
      offset = updatableOrOptions.offset;
      size = updatableOrOptions.size;
      type = updatableOrOptions.type;
      normalized = updatableOrOptions.normalized ?? false;
      useBytes = updatableOrOptions.useBytes ?? false;
      divisor = updatableOrOptions.divisor ?? 1;
      takeBufferOwnership = updatableOrOptions.takeBufferOwnership ?? false;
      this._label = updatableOrOptions.label;
    } else {
      updatable = !!updatableOrOptions;
    }
    if (data instanceof Buffer) {
      this._buffer = data;
      this._ownsBuffer = takeBufferOwnership;
    } else {
      this._buffer = new Buffer(engine2, data, updatable, stride, postponeInternalCreation, instanced, useBytes, divisor, this._label);
      this._ownsBuffer = true;
    }
    this.uniqueId = VertexBuffer._Counter++;
    this._kind = kind;
    if (type === void 0) {
      const vertexData = this.getData();
      this.type = vertexData ? VertexBuffer.GetDataType(vertexData) : VertexBuffer.FLOAT;
    } else {
      this.type = type;
    }
    const typeByteLength = GetTypeByteLength(this.type);
    if (useBytes) {
      this._size = size || (stride ? stride / typeByteLength : VertexBuffer.DeduceStride(kind));
      this.byteStride = stride || this._buffer.byteStride || this._size * typeByteLength;
      this.byteOffset = offset || 0;
    } else {
      this._size = size || stride || VertexBuffer.DeduceStride(kind);
      this.byteStride = stride ? stride * typeByteLength : this._buffer.byteStride || this._size * typeByteLength;
      this.byteOffset = (offset || 0) * typeByteLength;
    }
    this.normalized = normalized;
    this._instanced = instanced !== void 0 ? instanced : false;
    this._instanceDivisor = instanced ? divisor : 0;
    this._alignBuffer();
    this._computeHashCode();
  }
  _computeHashCode() {
    this.hashCode = (this.type - 5120 << 0) + ((this.normalized ? 1 : 0) << 3) + (this._size << 4) + ((this._instanced ? 1 : 0) << 6) + /* keep 5 bits free */
    (this.byteStride << 12);
  }
  /** @internal */
  _rebuild() {
    var _a2;
    (_a2 = this._buffer) == null ? void 0 : _a2._rebuild();
  }
  /**
   * Returns the kind of the VertexBuffer (string)
   * @returns a string
   */
  getKind() {
    return this._kind;
  }
  // Properties
  /**
   * Gets a boolean indicating if the VertexBuffer is updatable?
   * @returns true if the buffer is updatable
   */
  isUpdatable() {
    return this._buffer.isUpdatable();
  }
  /**
   * Gets current buffer's data
   * @returns a DataArray or null
   */
  getData() {
    return this._buffer.getData();
  }
  /**
   * Gets current buffer's data as a float array. Float data is constructed if the vertex buffer data cannot be returned directly.
   * @param totalVertices number of vertices in the buffer to take into account
   * @param forceCopy defines a boolean indicating that the returned array must be cloned upon returning it
   * @returns a float array containing vertex data
   */
  getFloatData(totalVertices, forceCopy) {
    const data = this.getData();
    if (!data) {
      return null;
    }
    return GetFloatData(data, this._size, this.type, this.byteOffset, this.byteStride, this.normalized, totalVertices, forceCopy);
  }
  /**
   * Gets underlying native buffer
   * @returns underlying native buffer
   */
  getBuffer() {
    return this._buffer.getBuffer();
  }
  /**
   * Gets the Buffer instance that wraps the native GPU buffer
   * @returns the wrapper buffer
   */
  getWrapperBuffer() {
    return this._buffer;
  }
  /**
   * Gets the stride in float32 units (i.e. byte stride / 4).
   * May not be an integer if the byte stride is not divisible by 4.
   * @returns the stride in float32 units
   * @deprecated Please use byteStride instead.
   */
  getStrideSize() {
    return this.byteStride / GetTypeByteLength(this.type);
  }
  /**
   * Returns the offset as a multiple of the type byte length.
   * @returns the offset in bytes
   * @deprecated Please use byteOffset instead.
   */
  getOffset() {
    return this.byteOffset / GetTypeByteLength(this.type);
  }
  /**
   * Returns the number of components or the byte size per vertex attribute
   * @param sizeInBytes If true, returns the size in bytes or else the size in number of components of the vertex attribute (default: false)
   * @returns the number of components
   */
  getSize(sizeInBytes = false) {
    return sizeInBytes ? this._size * GetTypeByteLength(this.type) : this._size;
  }
  /**
   * Gets a boolean indicating is the internal buffer of the VertexBuffer is instanced
   * @returns true if this buffer is instanced
   */
  getIsInstanced() {
    return this._instanced;
  }
  /**
   * Returns the instancing divisor, zero for non-instanced (integer).
   * @returns a number
   */
  getInstanceDivisor() {
    return this._instanceDivisor;
  }
  // Methods
  /**
   * Store data into the buffer. If the buffer was already used it will be either recreated or updated depending on isUpdatable property
   * @param data defines the data to store
   */
  create(data) {
    this._buffer.create(data);
    this._alignBuffer();
  }
  /**
   * Updates the underlying buffer according to the passed numeric array or Float32Array.
   * This function will create a new buffer if the current one is not updatable
   * @param data defines the data to store
   */
  update(data) {
    this._buffer.update(data);
    this._alignBuffer();
  }
  /**
   * Updates directly the underlying WebGLBuffer according to the passed numeric array or Float32Array.
   * Returns the directly updated WebGLBuffer.
   * @param data the new data
   * @param offset the new offset
   * @param useBytes set to true if the offset is in bytes
   */
  updateDirectly(data, offset, useBytes = false) {
    this._buffer.updateDirectly(data, offset, void 0, useBytes);
    this._alignBuffer();
  }
  /**
   * Disposes the VertexBuffer and the underlying WebGLBuffer.
   */
  dispose() {
    if (this._ownsBuffer) {
      this._buffer.dispose();
    }
    this._isDisposed = true;
  }
  /**
   * Enumerates each value of this vertex buffer as numbers.
   * @param count the number of values to enumerate
   * @param callback the callback function called for each value
   */
  forEach(count, callback) {
    EnumerateFloatValues(this._buffer.getData(), this.byteOffset, this.byteStride, this._size, this.type, count, this.normalized, (values, index2) => {
      for (let i2 = 0; i2 < this._size; i2++) {
        callback(values[i2], index2 + i2);
      }
    });
  }
  /** @internal */
  _alignBuffer() {
  }
  /**
   * Deduces the stride given a kind.
   * @param kind The kind string to deduce
   * @returns The deduced stride
   */
  static DeduceStride(kind) {
    switch (kind) {
      case VertexBuffer.UVKind:
      case VertexBuffer.UV2Kind:
      case VertexBuffer.UV3Kind:
      case VertexBuffer.UV4Kind:
      case VertexBuffer.UV5Kind:
      case VertexBuffer.UV6Kind:
        return 2;
      case VertexBuffer.NormalKind:
      case VertexBuffer.PositionKind:
        return 3;
      case VertexBuffer.ColorKind:
      case VertexBuffer.ColorInstanceKind:
      case VertexBuffer.MatricesIndicesKind:
      case VertexBuffer.MatricesIndicesExtraKind:
      case VertexBuffer.MatricesWeightsKind:
      case VertexBuffer.MatricesWeightsExtraKind:
      case VertexBuffer.TangentKind:
        return 4;
      default:
        throw new Error("Invalid kind '" + kind + "'");
    }
  }
  /**
   * Gets the vertex buffer type of the given data array.
   * @param data the data array
   * @returns the vertex buffer type
   */
  static GetDataType(data) {
    if (data instanceof Int8Array) {
      return VertexBuffer.BYTE;
    } else if (data instanceof Uint8Array) {
      return VertexBuffer.UNSIGNED_BYTE;
    } else if (data instanceof Int16Array) {
      return VertexBuffer.SHORT;
    } else if (data instanceof Uint16Array) {
      return VertexBuffer.UNSIGNED_SHORT;
    } else if (data instanceof Int32Array) {
      return VertexBuffer.INT;
    } else if (data instanceof Uint32Array) {
      return VertexBuffer.UNSIGNED_INT;
    } else {
      return VertexBuffer.FLOAT;
    }
  }
  /**
   * Gets the byte length of the given type.
   * @param type the type
   * @returns the number of bytes
   * @deprecated Use `getTypeByteLength` from `bufferUtils` instead
   */
  static GetTypeByteLength(type) {
    return GetTypeByteLength(type);
  }
  /**
   * Enumerates each value of the given parameters as numbers.
   * @param data the data to enumerate
   * @param byteOffset the byte offset of the data
   * @param byteStride the byte stride of the data
   * @param componentCount the number of components per element
   * @param componentType the type of the component
   * @param count the number of values to enumerate
   * @param normalized whether the data is normalized
   * @param callback the callback function called for each value
   * @deprecated Use `EnumerateFloatValues` from `bufferUtils` instead
   */
  static ForEach(data, byteOffset, byteStride, componentCount, componentType, count, normalized, callback) {
    EnumerateFloatValues(data, byteOffset, byteStride, componentCount, componentType, count, normalized, (values, index2) => {
      for (let componentIndex = 0; componentIndex < componentCount; componentIndex++) {
        callback(values[componentIndex], index2 + componentIndex);
      }
    });
  }
  /**
   * Gets the given data array as a float array. Float data is constructed if the data array cannot be returned directly.
   * @param data the input data array
   * @param size the number of components
   * @param type the component type
   * @param byteOffset the byte offset of the data
   * @param byteStride the byte stride of the data
   * @param normalized whether the data is normalized
   * @param totalVertices number of vertices in the buffer to take into account
   * @param forceCopy defines a boolean indicating that the returned array must be cloned upon returning it
   * @returns a float array containing vertex data
   * @deprecated Use `GetFloatData` from `bufferUtils` instead
   */
  static GetFloatData(data, size, type, byteOffset, byteStride, normalized, totalVertices, forceCopy) {
    return GetFloatData(data, size, type, byteOffset, byteStride, normalized, totalVertices, forceCopy);
  }
}
VertexBuffer._Counter = 0;
VertexBuffer.BYTE = 5120;
VertexBuffer.UNSIGNED_BYTE = 5121;
VertexBuffer.SHORT = 5122;
VertexBuffer.UNSIGNED_SHORT = 5123;
VertexBuffer.INT = 5124;
VertexBuffer.UNSIGNED_INT = 5125;
VertexBuffer.FLOAT = 5126;
VertexBuffer.PositionKind = `position`;
VertexBuffer.NormalKind = `normal`;
VertexBuffer.TangentKind = `tangent`;
VertexBuffer.UVKind = `uv`;
VertexBuffer.UV2Kind = `uv2`;
VertexBuffer.UV3Kind = `uv3`;
VertexBuffer.UV4Kind = `uv4`;
VertexBuffer.UV5Kind = `uv5`;
VertexBuffer.UV6Kind = `uv6`;
VertexBuffer.ColorKind = `color`;
VertexBuffer.ColorInstanceKind = `instanceColor`;
VertexBuffer.MatricesIndicesKind = `matricesIndices`;
VertexBuffer.MatricesWeightsKind = `matricesWeights`;
VertexBuffer.MatricesIndicesExtraKind = `matricesIndicesExtra`;
VertexBuffer.MatricesWeightsExtraKind = `matricesWeightsExtra`;
class IntersectionInfo {
  constructor(bu, bv, distance) {
    this.bu = bu;
    this.bv = bv;
    this.distance = distance;
    this.faceId = 0;
    this.subMeshId = 0;
  }
}
class BoundingBox {
  /**
   * Creates a new bounding box
   * @param min defines the minimum vector (in local space)
   * @param max defines the maximum vector (in local space)
   * @param worldMatrix defines the new world matrix
   */
  constructor(min, max, worldMatrix) {
    this.vectors = BuildArray(8, Vector3.Zero);
    this.center = Vector3.Zero();
    this.centerWorld = Vector3.Zero();
    this.extendSize = Vector3.Zero();
    this.extendSizeWorld = Vector3.Zero();
    this.directions = BuildArray(3, Vector3.Zero);
    this.vectorsWorld = BuildArray(8, Vector3.Zero);
    this.minimumWorld = Vector3.Zero();
    this.maximumWorld = Vector3.Zero();
    this.minimum = Vector3.Zero();
    this.maximum = Vector3.Zero();
    this._drawWrapperFront = null;
    this._drawWrapperBack = null;
    this.reConstruct(min, max, worldMatrix);
  }
  // Methods
  /**
   * Recreates the entire bounding box from scratch as if we call the constructor in place
   * @param min defines the new minimum vector (in local space)
   * @param max defines the new maximum vector (in local space)
   * @param worldMatrix defines the new world matrix
   */
  reConstruct(min, max, worldMatrix) {
    const minX = min.x, minY = min.y, minZ = min.z, maxX = max.x, maxY = max.y, maxZ = max.z;
    const vectors = this.vectors;
    this.minimum.copyFromFloats(minX, minY, minZ);
    this.maximum.copyFromFloats(maxX, maxY, maxZ);
    vectors[0].copyFromFloats(minX, minY, minZ);
    vectors[1].copyFromFloats(maxX, maxY, maxZ);
    vectors[2].copyFromFloats(maxX, minY, minZ);
    vectors[3].copyFromFloats(minX, maxY, minZ);
    vectors[4].copyFromFloats(minX, minY, maxZ);
    vectors[5].copyFromFloats(maxX, maxY, minZ);
    vectors[6].copyFromFloats(minX, maxY, maxZ);
    vectors[7].copyFromFloats(maxX, minY, maxZ);
    max.addToRef(min, this.center).scaleInPlace(0.5);
    max.subtractToRef(min, this.extendSize).scaleInPlace(0.5);
    this._worldMatrix = worldMatrix || Matrix.IdentityReadOnly;
    this._update(this._worldMatrix);
  }
  /**
   * Scale the current bounding box by applying a scale factor
   * @param factor defines the scale factor to apply
   * @returns the current bounding box
   */
  scale(factor) {
    const tmpVectors = BoundingBox._TmpVector3;
    const diff = this.maximum.subtractToRef(this.minimum, tmpVectors[0]);
    const len = diff.length();
    diff.normalizeFromLength(len);
    const distance = len * factor;
    const newRadius = diff.scaleInPlace(distance * 0.5);
    const min = this.center.subtractToRef(newRadius, tmpVectors[1]);
    const max = this.center.addToRef(newRadius, tmpVectors[2]);
    this.reConstruct(min, max, this._worldMatrix);
    return this;
  }
  /**
   * Gets the world matrix of the bounding box
   * @returns a matrix
   */
  getWorldMatrix() {
    return this._worldMatrix;
  }
  /**
   * @internal
   */
  _update(world) {
    const minWorld = this.minimumWorld;
    const maxWorld = this.maximumWorld;
    const directions = this.directions;
    const vectorsWorld = this.vectorsWorld;
    const vectors = this.vectors;
    if (!world.isIdentity()) {
      minWorld.setAll(Number.MAX_VALUE);
      maxWorld.setAll(-Number.MAX_VALUE);
      for (let index2 = 0; index2 < 8; ++index2) {
        const v2 = vectorsWorld[index2];
        Vector3.TransformCoordinatesToRef(vectors[index2], world, v2);
        minWorld.minimizeInPlace(v2);
        maxWorld.maximizeInPlace(v2);
      }
      maxWorld.subtractToRef(minWorld, this.extendSizeWorld).scaleInPlace(0.5);
      maxWorld.addToRef(minWorld, this.centerWorld).scaleInPlace(0.5);
    } else {
      minWorld.copyFrom(this.minimum);
      maxWorld.copyFrom(this.maximum);
      for (let index2 = 0; index2 < 8; ++index2) {
        vectorsWorld[index2].copyFrom(vectors[index2]);
      }
      this.extendSizeWorld.copyFrom(this.extendSize);
      this.centerWorld.copyFrom(this.center);
    }
    Vector3.FromArrayToRef(world.m, 0, directions[0]);
    Vector3.FromArrayToRef(world.m, 4, directions[1]);
    Vector3.FromArrayToRef(world.m, 8, directions[2]);
    this._worldMatrix = world;
  }
  /**
   * Tests if the bounding box is intersecting the frustum planes
   * @param frustumPlanes defines the frustum planes to test
   * @returns true if there is an intersection
   */
  isInFrustum(frustumPlanes) {
    return BoundingBox.IsInFrustum(this.vectorsWorld, frustumPlanes);
  }
  /**
   * Tests if the bounding box is entirely inside the frustum planes
   * @param frustumPlanes defines the frustum planes to test
   * @returns true if there is an inclusion
   */
  isCompletelyInFrustum(frustumPlanes) {
    return BoundingBox.IsCompletelyInFrustum(this.vectorsWorld, frustumPlanes);
  }
  /**
   * Tests if a point is inside the bounding box
   * @param point defines the point to test
   * @returns true if the point is inside the bounding box
   */
  intersectsPoint(point) {
    const min = this.minimumWorld;
    const max = this.maximumWorld;
    const minX = min.x, minY = min.y, minZ = min.z, maxX = max.x, maxY = max.y, maxZ = max.z;
    const pointX = point.x, pointY = point.y, pointZ = point.z;
    const delta = -Epsilon;
    if (maxX - pointX < delta || delta > pointX - minX) {
      return false;
    }
    if (maxY - pointY < delta || delta > pointY - minY) {
      return false;
    }
    if (maxZ - pointZ < delta || delta > pointZ - minZ) {
      return false;
    }
    return true;
  }
  /**
   * Tests if the bounding box intersects with a bounding sphere
   * @param sphere defines the sphere to test
   * @returns true if there is an intersection
   */
  intersectsSphere(sphere) {
    return BoundingBox.IntersectsSphere(this.minimumWorld, this.maximumWorld, sphere.centerWorld, sphere.radiusWorld);
  }
  /**
   * Tests if the bounding box intersects with a box defined by a min and max vectors
   * @param min defines the min vector to use
   * @param max defines the max vector to use
   * @returns true if there is an intersection
   */
  intersectsMinMax(min, max) {
    const myMin = this.minimumWorld;
    const myMax = this.maximumWorld;
    const myMinX = myMin.x, myMinY = myMin.y, myMinZ = myMin.z, myMaxX = myMax.x, myMaxY = myMax.y, myMaxZ = myMax.z;
    const minX = min.x, minY = min.y, minZ = min.z, maxX = max.x, maxY = max.y, maxZ = max.z;
    if (myMaxX < minX || myMinX > maxX) {
      return false;
    }
    if (myMaxY < minY || myMinY > maxY) {
      return false;
    }
    if (myMaxZ < minZ || myMinZ > maxZ) {
      return false;
    }
    return true;
  }
  /**
   * Disposes the resources of the class
   */
  dispose() {
    var _a2, _b;
    (_a2 = this._drawWrapperFront) == null ? void 0 : _a2.dispose();
    (_b = this._drawWrapperBack) == null ? void 0 : _b.dispose();
  }
  // Statics
  /**
   * Tests if two bounding boxes are intersections
   * @param box0 defines the first box to test
   * @param box1 defines the second box to test
   * @returns true if there is an intersection
   */
  static Intersects(box0, box1) {
    return box0.intersectsMinMax(box1.minimumWorld, box1.maximumWorld);
  }
  /**
   * Tests if a bounding box defines by a min/max vectors intersects a sphere
   * @param minPoint defines the minimum vector of the bounding box
   * @param maxPoint defines the maximum vector of the bounding box
   * @param sphereCenter defines the sphere center
   * @param sphereRadius defines the sphere radius
   * @returns true if there is an intersection
   */
  static IntersectsSphere(minPoint, maxPoint, sphereCenter, sphereRadius) {
    const vector = BoundingBox._TmpVector3[0];
    Vector3.ClampToRef(sphereCenter, minPoint, maxPoint, vector);
    const num = Vector3.DistanceSquared(sphereCenter, vector);
    return num <= sphereRadius * sphereRadius;
  }
  /**
   * Tests if a bounding box defined with 8 vectors is entirely inside frustum planes
   * @param boundingVectors defines an array of 8 vectors representing a bounding box
   * @param frustumPlanes defines the frustum planes to test
   * @returns true if there is an inclusion
   */
  static IsCompletelyInFrustum(boundingVectors, frustumPlanes) {
    for (let p2 = 0; p2 < 6; ++p2) {
      const frustumPlane = frustumPlanes[p2];
      for (let i2 = 0; i2 < 8; ++i2) {
        if (frustumPlane.dotCoordinate(boundingVectors[i2]) < 0) {
          return false;
        }
      }
    }
    return true;
  }
  /**
   * Tests if a bounding box defined with 8 vectors intersects frustum planes
   * @param boundingVectors defines an array of 8 vectors representing a bounding box
   * @param frustumPlanes defines the frustum planes to test
   * @returns true if there is an intersection
   */
  static IsInFrustum(boundingVectors, frustumPlanes) {
    for (let p2 = 0; p2 < 6; ++p2) {
      let canReturnFalse = true;
      const frustumPlane = frustumPlanes[p2];
      for (let i2 = 0; i2 < 8; ++i2) {
        if (frustumPlane.dotCoordinate(boundingVectors[i2]) >= 0) {
          canReturnFalse = false;
          break;
        }
      }
      if (canReturnFalse) {
        return false;
      }
    }
    return true;
  }
}
BoundingBox._TmpVector3 = BuildArray(3, Vector3.Zero);
class BoundingSphere {
  /**
   * Creates a new bounding sphere
   * @param min defines the minimum vector (in local space)
   * @param max defines the maximum vector (in local space)
   * @param worldMatrix defines the new world matrix
   */
  constructor(min, max, worldMatrix) {
    this.center = Vector3.Zero();
    this.centerWorld = Vector3.Zero();
    this.minimum = Vector3.Zero();
    this.maximum = Vector3.Zero();
    this.reConstruct(min, max, worldMatrix);
  }
  /**
   * Recreates the entire bounding sphere from scratch as if we call the constructor in place
   * @param min defines the new minimum vector (in local space)
   * @param max defines the new maximum vector (in local space)
   * @param worldMatrix defines the new world matrix
   */
  reConstruct(min, max, worldMatrix) {
    this.minimum.copyFrom(min);
    this.maximum.copyFrom(max);
    const distance = Vector3.Distance(min, max);
    max.addToRef(min, this.center).scaleInPlace(0.5);
    this.radius = distance * 0.5;
    this._update(worldMatrix || Matrix.IdentityReadOnly);
  }
  /**
   * Scale the current bounding sphere by applying a scale factor
   * @param factor defines the scale factor to apply
   * @returns the current bounding box
   */
  scale(factor) {
    const newRadius = this.radius * factor;
    const tmpVectors = BoundingSphere._TmpVector3;
    const tempRadiusVector = tmpVectors[0].setAll(newRadius);
    const min = this.center.subtractToRef(tempRadiusVector, tmpVectors[1]);
    const max = this.center.addToRef(tempRadiusVector, tmpVectors[2]);
    this.reConstruct(min, max, this._worldMatrix);
    return this;
  }
  /**
   * Gets the world matrix of the bounding box
   * @returns a matrix
   */
  getWorldMatrix() {
    return this._worldMatrix;
  }
  // Methods
  /**
   * @internal
   */
  _update(worldMatrix) {
    if (!worldMatrix.isIdentity()) {
      Vector3.TransformCoordinatesToRef(this.center, worldMatrix, this.centerWorld);
      const tempVector = BoundingSphere._TmpVector3[0];
      Vector3.TransformNormalFromFloatsToRef(1, 1, 1, worldMatrix, tempVector);
      this.radiusWorld = Math.max(Math.abs(tempVector.x), Math.abs(tempVector.y), Math.abs(tempVector.z)) * this.radius;
    } else {
      this.centerWorld.copyFrom(this.center);
      this.radiusWorld = this.radius;
    }
  }
  /**
   * Tests if the bounding sphere is intersecting the frustum planes
   * @param frustumPlanes defines the frustum planes to test
   * @returns true if there is an intersection
   */
  isInFrustum(frustumPlanes) {
    const center = this.centerWorld;
    const radius = this.radiusWorld;
    for (let i2 = 0; i2 < 6; i2++) {
      if (frustumPlanes[i2].dotCoordinate(center) <= -radius) {
        return false;
      }
    }
    return true;
  }
  /**
   * Tests if the bounding sphere center is in between the frustum planes.
   * Used for optimistic fast inclusion.
   * @param frustumPlanes defines the frustum planes to test
   * @returns true if the sphere center is in between the frustum planes
   */
  isCenterInFrustum(frustumPlanes) {
    const center = this.centerWorld;
    for (let i2 = 0; i2 < 6; i2++) {
      if (frustumPlanes[i2].dotCoordinate(center) < 0) {
        return false;
      }
    }
    return true;
  }
  /**
   * Tests if a point is inside the bounding sphere
   * @param point defines the point to test
   * @returns true if the point is inside the bounding sphere
   */
  intersectsPoint(point) {
    const squareDistance = Vector3.DistanceSquared(this.centerWorld, point);
    if (this.radiusWorld * this.radiusWorld < squareDistance) {
      return false;
    }
    return true;
  }
  // Statics
  /**
   * Checks if two sphere intersect
   * @param sphere0 sphere 0
   * @param sphere1 sphere 1
   * @returns true if the spheres intersect
   */
  static Intersects(sphere0, sphere1) {
    const squareDistance = Vector3.DistanceSquared(sphere0.centerWorld, sphere1.centerWorld);
    const radiusSum = sphere0.radiusWorld + sphere1.radiusWorld;
    if (radiusSum * radiusSum < squareDistance) {
      return false;
    }
    return true;
  }
  /**
   * Creates a sphere from a center and a radius
   * @param center The center
   * @param radius radius
   * @param matrix Optional worldMatrix
   * @returns The sphere
   */
  static CreateFromCenterAndRadius(center, radius, matrix) {
    this._TmpVector3[0].copyFrom(center);
    this._TmpVector3[1].copyFromFloats(0, 0, radius);
    this._TmpVector3[2].copyFrom(center);
    this._TmpVector3[0].addInPlace(this._TmpVector3[1]);
    this._TmpVector3[2].subtractInPlace(this._TmpVector3[1]);
    const sphere = new BoundingSphere(this._TmpVector3[0], this._TmpVector3[2]);
    if (matrix) {
      sphere._worldMatrix = matrix;
    } else {
      sphere._worldMatrix = Matrix.Identity();
    }
    return sphere;
  }
}
BoundingSphere._TmpVector3 = BuildArray(3, Vector3.Zero);
const _result0 = { min: 0, max: 0 };
const _result1 = { min: 0, max: 0 };
const computeBoxExtents = (axis, box, result) => {
  const p2 = Vector3.Dot(box.centerWorld, axis);
  const r0 = Math.abs(Vector3.Dot(box.directions[0], axis)) * box.extendSize.x;
  const r1 = Math.abs(Vector3.Dot(box.directions[1], axis)) * box.extendSize.y;
  const r22 = Math.abs(Vector3.Dot(box.directions[2], axis)) * box.extendSize.z;
  const r3 = r0 + r1 + r22;
  result.min = p2 - r3;
  result.max = p2 + r3;
};
const axisOverlap = (axis, box0, box1) => {
  computeBoxExtents(axis, box0, _result0);
  computeBoxExtents(axis, box1, _result1);
  return !(_result0.min > _result1.max || _result1.min > _result0.max);
};
class BoundingInfo {
  /**
   * Constructs bounding info
   * @param minimum min vector of the bounding box/sphere
   * @param maximum max vector of the bounding box/sphere
   * @param worldMatrix defines the new world matrix
   */
  constructor(minimum, maximum, worldMatrix) {
    this._isLocked = false;
    this.boundingBox = new BoundingBox(minimum, maximum, worldMatrix);
    this.boundingSphere = new BoundingSphere(minimum, maximum, worldMatrix);
  }
  /**
   * Recreates the entire bounding info from scratch as if we call the constructor in place
   * @param min defines the new minimum vector (in local space)
   * @param max defines the new maximum vector (in local space)
   * @param worldMatrix defines the new world matrix
   */
  reConstruct(min, max, worldMatrix) {
    this.boundingBox.reConstruct(min, max, worldMatrix);
    this.boundingSphere.reConstruct(min, max, worldMatrix);
  }
  /**
   * min vector of the bounding box/sphere
   */
  get minimum() {
    return this.boundingBox.minimum;
  }
  /**
   * max vector of the bounding box/sphere
   */
  get maximum() {
    return this.boundingBox.maximum;
  }
  /**
   * If the info is locked and won't be updated to avoid perf overhead
   */
  get isLocked() {
    return this._isLocked;
  }
  set isLocked(value) {
    this._isLocked = value;
  }
  // Methods
  /**
   * Updates the bounding sphere and box
   * @param world world matrix to be used to update
   */
  update(world) {
    if (this._isLocked) {
      return;
    }
    this.boundingBox._update(world);
    this.boundingSphere._update(world);
  }
  /**
   * Recreate the bounding info to be centered around a specific point given a specific extend.
   * @param center New center of the bounding info
   * @param extend New extend of the bounding info
   * @returns the current bounding info
   */
  centerOn(center, extend) {
    const minimum = BoundingInfo._TmpVector3[0].copyFrom(center).subtractInPlace(extend);
    const maximum = BoundingInfo._TmpVector3[1].copyFrom(center).addInPlace(extend);
    this.boundingBox.reConstruct(minimum, maximum, this.boundingBox.getWorldMatrix());
    this.boundingSphere.reConstruct(minimum, maximum, this.boundingBox.getWorldMatrix());
    return this;
  }
  /**
   * Grows the bounding info to include the given point.
   * @param point The point that will be included in the current bounding info (in local space)
   * @returns the current bounding info
   */
  encapsulate(point) {
    const minimum = Vector3.Minimize(this.minimum, point);
    const maximum = Vector3.Maximize(this.maximum, point);
    this.reConstruct(minimum, maximum, this.boundingBox.getWorldMatrix());
    return this;
  }
  /**
   * Grows the bounding info to encapsulate the given bounding info.
   * @param toEncapsulate The bounding info that will be encapsulated in the current bounding info
   * @returns the current bounding info
   */
  encapsulateBoundingInfo(toEncapsulate) {
    const invw = TmpVectors.Matrix[0];
    this.boundingBox.getWorldMatrix().invertToRef(invw);
    const v2 = TmpVectors.Vector3[0];
    Vector3.TransformCoordinatesToRef(toEncapsulate.boundingBox.minimumWorld, invw, v2);
    this.encapsulate(v2);
    Vector3.TransformCoordinatesToRef(toEncapsulate.boundingBox.maximumWorld, invw, v2);
    this.encapsulate(v2);
    return this;
  }
  /**
   * Scale the current bounding info by applying a scale factor
   * @param factor defines the scale factor to apply
   * @returns the current bounding info
   */
  scale(factor) {
    this.boundingBox.scale(factor);
    this.boundingSphere.scale(factor);
    return this;
  }
  /**
   * Returns `true` if the bounding info is within the frustum defined by the passed array of planes.
   * @param frustumPlanes defines the frustum to test
   * @param strategy defines the strategy to use for the culling (default is BABYLON.AbstractMesh.CULLINGSTRATEGY_STANDARD)
   * The different strategies available are:
   * * BABYLON.AbstractMesh.CULLINGSTRATEGY_STANDARD most accurate but slower @see https://doc.babylonjs.com/typedoc/classes/BABYLON.AbstractMesh#CULLINGSTRATEGY_STANDARD
   * * BABYLON.AbstractMesh.CULLINGSTRATEGY_BOUNDINGSPHERE_ONLY faster but less accurate @see https://doc.babylonjs.com/typedoc/classes/BABYLON.AbstractMesh#CULLINGSTRATEGY_BOUNDINGSPHERE_ONLY
   * * BABYLON.AbstractMesh.CULLINGSTRATEGY_OPTIMISTIC_INCLUSION can be faster if always visible @see https://doc.babylonjs.com/typedoc/classes/BABYLON.AbstractMesh#CULLINGSTRATEGY_OPTIMISTIC_INCLUSION
   * * BABYLON.AbstractMesh.CULLINGSTRATEGY_OPTIMISTIC_INCLUSION_THEN_BSPHERE_ONLY can be faster if always visible @see https://doc.babylonjs.com/typedoc/classes/BABYLON.AbstractMesh#CULLINGSTRATEGY_OPTIMISTIC_INCLUSION_THEN_BSPHERE_ONLY
   * @returns true if the bounding info is in the frustum planes
   */
  isInFrustum(frustumPlanes, strategy = 0) {
    const inclusionTest = strategy === 2 || strategy === 3;
    if (inclusionTest) {
      if (this.boundingSphere.isCenterInFrustum(frustumPlanes)) {
        return true;
      }
    }
    if (!this.boundingSphere.isInFrustum(frustumPlanes)) {
      return false;
    }
    const bSphereOnlyTest = strategy === 1 || strategy === 3;
    if (bSphereOnlyTest) {
      return true;
    }
    return this.boundingBox.isInFrustum(frustumPlanes);
  }
  /**
   * Gets the world distance between the min and max points of the bounding box
   */
  get diagonalLength() {
    const boundingBox = this.boundingBox;
    const diag = boundingBox.maximumWorld.subtractToRef(boundingBox.minimumWorld, BoundingInfo._TmpVector3[0]);
    return diag.length();
  }
  /**
   * Checks if a cullable object (mesh...) is in the camera frustum
   * Unlike isInFrustum this checks the full bounding box
   * @param frustumPlanes Camera near/planes
   * @returns true if the object is in frustum otherwise false
   */
  isCompletelyInFrustum(frustumPlanes) {
    return this.boundingBox.isCompletelyInFrustum(frustumPlanes);
  }
  /**
   * @internal
   */
  _checkCollision(collider) {
    return collider._canDoCollision(this.boundingSphere.centerWorld, this.boundingSphere.radiusWorld, this.boundingBox.minimumWorld, this.boundingBox.maximumWorld);
  }
  /**
   * Checks if a point is inside the bounding box and bounding sphere or the mesh
   * @see https://doc.babylonjs.com/features/featuresDeepDive/mesh/interactions/mesh_intersect
   * @param point the point to check intersection with
   * @returns if the point intersects
   */
  intersectsPoint(point) {
    if (!this.boundingSphere.centerWorld) {
      return false;
    }
    if (!this.boundingSphere.intersectsPoint(point)) {
      return false;
    }
    if (!this.boundingBox.intersectsPoint(point)) {
      return false;
    }
    return true;
  }
  /**
   * Checks if another bounding info intersects the bounding box and bounding sphere or the mesh
   * @see https://doc.babylonjs.com/features/featuresDeepDive/mesh/interactions/mesh_intersect
   * @param boundingInfo the bounding info to check intersection with
   * @param precise if the intersection should be done using OBB
   * @returns if the bounding info intersects
   */
  intersects(boundingInfo, precise) {
    if (!BoundingSphere.Intersects(this.boundingSphere, boundingInfo.boundingSphere)) {
      return false;
    }
    if (!BoundingBox.Intersects(this.boundingBox, boundingInfo.boundingBox)) {
      return false;
    }
    if (!precise) {
      return true;
    }
    const box0 = this.boundingBox;
    const box1 = boundingInfo.boundingBox;
    if (!axisOverlap(box0.directions[0], box0, box1)) {
      return false;
    }
    if (!axisOverlap(box0.directions[1], box0, box1)) {
      return false;
    }
    if (!axisOverlap(box0.directions[2], box0, box1)) {
      return false;
    }
    if (!axisOverlap(box1.directions[0], box0, box1)) {
      return false;
    }
    if (!axisOverlap(box1.directions[1], box0, box1)) {
      return false;
    }
    if (!axisOverlap(box1.directions[2], box0, box1)) {
      return false;
    }
    if (!axisOverlap(Vector3.Cross(box0.directions[0], box1.directions[0]), box0, box1)) {
      return false;
    }
    if (!axisOverlap(Vector3.Cross(box0.directions[0], box1.directions[1]), box0, box1)) {
      return false;
    }
    if (!axisOverlap(Vector3.Cross(box0.directions[0], box1.directions[2]), box0, box1)) {
      return false;
    }
    if (!axisOverlap(Vector3.Cross(box0.directions[1], box1.directions[0]), box0, box1)) {
      return false;
    }
    if (!axisOverlap(Vector3.Cross(box0.directions[1], box1.directions[1]), box0, box1)) {
      return false;
    }
    if (!axisOverlap(Vector3.Cross(box0.directions[1], box1.directions[2]), box0, box1)) {
      return false;
    }
    if (!axisOverlap(Vector3.Cross(box0.directions[2], box1.directions[0]), box0, box1)) {
      return false;
    }
    if (!axisOverlap(Vector3.Cross(box0.directions[2], box1.directions[1]), box0, box1)) {
      return false;
    }
    if (!axisOverlap(Vector3.Cross(box0.directions[2], box1.directions[2]), box0, box1)) {
      return false;
    }
    return true;
  }
}
BoundingInfo._TmpVector3 = BuildArray(2, Vector3.Zero);
class MathHelpers {
  static extractMinAndMaxIndexed(positions, indices, indexStart, indexCount, minimum, maximum) {
    for (let index2 = indexStart; index2 < indexStart + indexCount; index2++) {
      const offset = indices[index2] * 3;
      const x2 = positions[offset];
      const y2 = positions[offset + 1];
      const z2 = positions[offset + 2];
      minimum.minimizeInPlaceFromFloats(x2, y2, z2);
      maximum.maximizeInPlaceFromFloats(x2, y2, z2);
    }
  }
  static extractMinAndMax(positions, start, count, stride, minimum, maximum) {
    for (let index2 = start, offset = start * stride; index2 < start + count; index2++, offset += stride) {
      const x2 = positions[offset];
      const y2 = positions[offset + 1];
      const z2 = positions[offset + 2];
      minimum.minimizeInPlaceFromFloats(x2, y2, z2);
      maximum.maximizeInPlaceFromFloats(x2, y2, z2);
    }
  }
}
__decorate([
  nativeOverride.filter((...[positions, indices]) => !Array.isArray(positions) && !Array.isArray(indices))
  // eslint-disable-next-line @typescript-eslint/naming-convention
], MathHelpers, "extractMinAndMaxIndexed", null);
__decorate([
  nativeOverride.filter((...[positions]) => !Array.isArray(positions))
  // eslint-disable-next-line @typescript-eslint/naming-convention
], MathHelpers, "extractMinAndMax", null);
function extractMinAndMaxIndexed(positions, indices, indexStart, indexCount, bias = null) {
  const minimum = new Vector3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE);
  const maximum = new Vector3(-Number.MAX_VALUE, -Number.MAX_VALUE, -Number.MAX_VALUE);
  MathHelpers.extractMinAndMaxIndexed(positions, indices, indexStart, indexCount, minimum, maximum);
  if (bias) {
    minimum.x -= minimum.x * bias.x + bias.y;
    minimum.y -= minimum.y * bias.x + bias.y;
    minimum.z -= minimum.z * bias.x + bias.y;
    maximum.x += maximum.x * bias.x + bias.y;
    maximum.y += maximum.y * bias.x + bias.y;
    maximum.z += maximum.z * bias.x + bias.y;
  }
  return {
    minimum,
    maximum
  };
}
function extractMinAndMax(positions, start, count, bias = null, stride) {
  const minimum = new Vector3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE);
  const maximum = new Vector3(-Number.MAX_VALUE, -Number.MAX_VALUE, -Number.MAX_VALUE);
  if (!stride) {
    stride = 3;
  }
  MathHelpers.extractMinAndMax(positions, start, count, stride, minimum, maximum);
  if (bias) {
    minimum.x -= minimum.x * bias.x + bias.y;
    minimum.y -= minimum.y * bias.x + bias.y;
    minimum.z -= minimum.z * bias.x + bias.y;
    maximum.x += maximum.x * bias.x + bias.y;
    maximum.y += maximum.y * bias.x + bias.y;
    maximum.z += maximum.z * bias.x + bias.y;
  }
  return {
    minimum,
    maximum
  };
}
class DrawWrapper {
  static GetEffect(effect) {
    return effect.getPipelineContext === void 0 ? effect.effect : effect;
  }
  constructor(engine2, createMaterialContext = true) {
    this._wasPreviouslyReady = false;
    this._forceRebindOnNextCall = true;
    this._wasPreviouslyUsingInstances = null;
    this.effect = null;
    this.defines = null;
    this.drawContext = engine2.createDrawContext();
    if (createMaterialContext) {
      this.materialContext = engine2.createMaterialContext();
    }
  }
  setEffect(effect, defines, resetContext = true) {
    var _a2;
    this.effect = effect;
    if (defines !== void 0) {
      this.defines = defines;
    }
    if (resetContext) {
      (_a2 = this.drawContext) == null ? void 0 : _a2.reset();
    }
  }
  /**
   * Dispose the effect wrapper and its resources
   * @param immediate if the effect should be disposed immediately or on the next frame.
   * If dispose() is not called during a scene or engine dispose, we want to delay the dispose of the underlying effect. Mostly to give a chance to user code to reuse the effect in some way.
   */
  dispose(immediate = false) {
    var _a2;
    if (this.effect) {
      const effect = this.effect;
      if (immediate) {
        effect.dispose();
      } else {
        TimingTools.SetImmediate(() => {
          effect.getEngine().onEndFrameObservable.addOnce(() => {
            effect.dispose();
          });
        });
      }
      this.effect = null;
    }
    (_a2 = this.drawContext) == null ? void 0 : _a2.dispose();
  }
}
class SubMesh {
  /**
   * Gets material defines used by the effect associated to the sub mesh
   */
  get materialDefines() {
    var _a2;
    return this._mainDrawWrapperOverride ? this._mainDrawWrapperOverride.defines : (_a2 = this._getDrawWrapper()) == null ? void 0 : _a2.defines;
  }
  /**
   * Sets material defines used by the effect associated to the sub mesh
   */
  set materialDefines(defines) {
    const drawWrapper = this._mainDrawWrapperOverride ?? this._getDrawWrapper(void 0, true);
    drawWrapper.defines = defines;
  }
  /**
   * @internal
   */
  _getDrawWrapper(passId, createIfNotExisting = false) {
    passId = passId ?? this._engine.currentRenderPassId;
    let drawWrapper = this._drawWrappers[passId];
    if (!drawWrapper && createIfNotExisting) {
      this._drawWrappers[passId] = drawWrapper = new DrawWrapper(this._mesh.getScene().getEngine());
    }
    return drawWrapper;
  }
  /**
   * @internal
   */
  _removeDrawWrapper(passId, disposeWrapper = true, immediate = false) {
    var _a2;
    if (disposeWrapper) {
      (_a2 = this._drawWrappers[passId]) == null ? void 0 : _a2.dispose(immediate);
    }
    this._drawWrappers[passId] = void 0;
  }
  /**
   * Gets associated (main) effect (possibly the effect override if defined)
   */
  get effect() {
    var _a2;
    return this._mainDrawWrapperOverride ? this._mainDrawWrapperOverride.effect : ((_a2 = this._getDrawWrapper()) == null ? void 0 : _a2.effect) ?? null;
  }
  /** @internal */
  get _drawWrapper() {
    return this._mainDrawWrapperOverride ?? this._getDrawWrapper(void 0, true);
  }
  /** @internal */
  get _drawWrapperOverride() {
    return this._mainDrawWrapperOverride;
  }
  /**
   * @internal
   */
  _setMainDrawWrapperOverride(wrapper) {
    this._mainDrawWrapperOverride = wrapper;
  }
  /**
   * Sets associated effect (effect used to render this submesh)
   * @param effect defines the effect to associate with
   * @param defines defines the set of defines used to compile this effect
   * @param materialContext material context associated to the effect
   * @param resetContext true to reset the draw context
   */
  setEffect(effect, defines = null, materialContext, resetContext = true) {
    const drawWrapper = this._drawWrapper;
    drawWrapper.setEffect(effect, defines, resetContext);
    if (materialContext !== void 0) {
      drawWrapper.materialContext = materialContext;
    }
    if (!effect) {
      drawWrapper.defines = null;
      drawWrapper.materialContext = void 0;
    }
  }
  /**
   * Resets the draw wrappers cache
   * @param passId If provided, releases only the draw wrapper corresponding to this render pass id
   * @param immediate If true, the draw wrapper will dispose the effect immediately (false by default)
   */
  resetDrawCache(passId, immediate = false) {
    if (this._drawWrappers) {
      if (passId !== void 0) {
        this._removeDrawWrapper(passId, true, immediate);
        return;
      } else {
        for (const drawWrapper of this._drawWrappers) {
          drawWrapper == null ? void 0 : drawWrapper.dispose(immediate);
        }
      }
    }
    this._drawWrappers = [];
  }
  /**
   * Add a new submesh to a mesh
   * @param materialIndex defines the material index to use
   * @param verticesStart defines vertex index start
   * @param verticesCount defines vertices count
   * @param indexStart defines index start
   * @param indexCount defines indices count
   * @param mesh defines the parent mesh
   * @param renderingMesh defines an optional rendering mesh
   * @param createBoundingBox defines if bounding box should be created for this submesh
   * @returns the new submesh
   */
  static AddToMesh(materialIndex, verticesStart, verticesCount, indexStart, indexCount, mesh, renderingMesh, createBoundingBox = true) {
    return new SubMesh(materialIndex, verticesStart, verticesCount, indexStart, indexCount, mesh, renderingMesh, createBoundingBox);
  }
  /**
   * Creates a new submesh
   * @param materialIndex defines the material index to use
   * @param verticesStart defines vertex index start
   * @param verticesCount defines vertices count
   * @param indexStart defines index start
   * @param indexCount defines indices count
   * @param mesh defines the parent mesh
   * @param renderingMesh defines an optional rendering mesh
   * @param createBoundingBox defines if bounding box should be created for this submesh
   * @param addToMesh defines a boolean indicating that the submesh must be added to the mesh.subMeshes array (true by default)
   */
  constructor(materialIndex, verticesStart, verticesCount, indexStart, indexCount, mesh, renderingMesh, createBoundingBox = true, addToMesh = true) {
    this.materialIndex = materialIndex;
    this.verticesStart = verticesStart;
    this.verticesCount = verticesCount;
    this.indexStart = indexStart;
    this.indexCount = indexCount;
    this._mainDrawWrapperOverride = null;
    this._linesIndexCount = 0;
    this._linesIndexBuffer = null;
    this._lastColliderWorldVertices = null;
    this._lastColliderTransformMatrix = null;
    this._wasDispatched = false;
    this._renderId = 0;
    this._alphaIndex = 0;
    this._distanceToCamera = 0;
    this._currentMaterial = null;
    this._mesh = mesh;
    this._renderingMesh = renderingMesh || mesh;
    if (addToMesh) {
      mesh.subMeshes.push(this);
    }
    this._engine = this._mesh.getScene().getEngine();
    this.resetDrawCache();
    this._trianglePlanes = [];
    this._id = mesh.subMeshes.length - 1;
    if (createBoundingBox) {
      this.refreshBoundingInfo();
      mesh.computeWorldMatrix(true);
    }
  }
  /**
   * Returns true if this submesh covers the entire parent mesh
   * @ignorenaming
   */
  // eslint-disable-next-line @typescript-eslint/naming-convention
  get IsGlobal() {
    return this.verticesStart === 0 && this.verticesCount === this._mesh.getTotalVertices() && this.indexStart === 0 && this.indexCount === this._mesh.getTotalIndices();
  }
  /**
   * Returns the submesh BoundingInfo object
   * @returns current bounding info (or mesh's one if the submesh is global)
   */
  getBoundingInfo() {
    if (this.IsGlobal || this._mesh.hasThinInstances) {
      return this._mesh.getBoundingInfo();
    }
    return this._boundingInfo;
  }
  /**
   * Sets the submesh BoundingInfo
   * @param boundingInfo defines the new bounding info to use
   * @returns the SubMesh
   */
  setBoundingInfo(boundingInfo) {
    this._boundingInfo = boundingInfo;
    return this;
  }
  /**
   * Returns the mesh of the current submesh
   * @returns the parent mesh
   */
  getMesh() {
    return this._mesh;
  }
  /**
   * Returns the rendering mesh of the submesh
   * @returns the rendering mesh (could be different from parent mesh)
   */
  getRenderingMesh() {
    return this._renderingMesh;
  }
  /**
   * Returns the replacement mesh of the submesh
   * @returns the replacement mesh (could be different from parent mesh)
   */
  getReplacementMesh() {
    return this._mesh._internalAbstractMeshDataInfo._actAsRegularMesh ? this._mesh : null;
  }
  /**
   * Returns the effective mesh of the submesh
   * @returns the effective mesh (could be different from parent mesh)
   */
  getEffectiveMesh() {
    const replacementMesh = this._mesh._internalAbstractMeshDataInfo._actAsRegularMesh ? this._mesh : null;
    return replacementMesh ? replacementMesh : this._renderingMesh;
  }
  /**
   * Returns the submesh material
   * @param getDefaultMaterial Defines whether or not to get the default material if nothing has been defined.
   * @returns null or the current material
   */
  getMaterial(getDefaultMaterial = true) {
    const rootMaterial = this._renderingMesh.getMaterialForRenderPass(this._engine.currentRenderPassId) ?? this._renderingMesh.material;
    if (!rootMaterial) {
      return getDefaultMaterial && this._mesh.getScene()._hasDefaultMaterial ? this._mesh.getScene().defaultMaterial : null;
    } else if (this._isMultiMaterial(rootMaterial)) {
      const effectiveMaterial = rootMaterial.getSubMaterial(this.materialIndex);
      if (this._currentMaterial !== effectiveMaterial) {
        this._currentMaterial = effectiveMaterial;
        this.resetDrawCache();
      }
      return effectiveMaterial;
    }
    return rootMaterial;
  }
  _isMultiMaterial(material) {
    return material.getSubMaterial !== void 0;
  }
  // Methods
  /**
   * Sets a new updated BoundingInfo object to the submesh
   * @param data defines an optional position array to use to determine the bounding info
   * @returns the SubMesh
   */
  refreshBoundingInfo(data = null) {
    this._lastColliderWorldVertices = null;
    if (this.IsGlobal || !this._renderingMesh || !this._renderingMesh.geometry) {
      return this;
    }
    if (!data) {
      data = this._renderingMesh.getVerticesData(VertexBuffer.PositionKind);
    }
    if (!data) {
      this._boundingInfo = this._mesh.getBoundingInfo();
      return this;
    }
    const indices = this._renderingMesh.getIndices();
    let extend;
    if (this.indexStart === 0 && this.indexCount === indices.length) {
      const boundingInfo = this._renderingMesh.getBoundingInfo();
      extend = { minimum: boundingInfo.minimum.clone(), maximum: boundingInfo.maximum.clone() };
    } else {
      extend = extractMinAndMaxIndexed(data, indices, this.indexStart, this.indexCount, this._renderingMesh.geometry.boundingBias);
    }
    if (this._boundingInfo) {
      this._boundingInfo.reConstruct(extend.minimum, extend.maximum);
    } else {
      this._boundingInfo = new BoundingInfo(extend.minimum, extend.maximum);
    }
    return this;
  }
  /**
   * @internal
   */
  _checkCollision(collider) {
    const boundingInfo = this.getBoundingInfo();
    return boundingInfo._checkCollision(collider);
  }
  /**
   * Updates the submesh BoundingInfo
   * @param world defines the world matrix to use to update the bounding info
   * @returns the submesh
   */
  updateBoundingInfo(world) {
    let boundingInfo = this.getBoundingInfo();
    if (!boundingInfo) {
      this.refreshBoundingInfo();
      boundingInfo = this.getBoundingInfo();
    }
    if (boundingInfo) {
      boundingInfo.update(world);
    }
    return this;
  }
  /**
   * True is the submesh bounding box intersects the frustum defined by the passed array of planes.
   * @param frustumPlanes defines the frustum planes
   * @returns true if the submesh is intersecting with the frustum
   */
  isInFrustum(frustumPlanes) {
    const boundingInfo = this.getBoundingInfo();
    if (!boundingInfo) {
      return false;
    }
    return boundingInfo.isInFrustum(frustumPlanes, this._mesh.cullingStrategy);
  }
  /**
   * True is the submesh bounding box is completely inside the frustum defined by the passed array of planes
   * @param frustumPlanes defines the frustum planes
   * @returns true if the submesh is inside the frustum
   */
  isCompletelyInFrustum(frustumPlanes) {
    const boundingInfo = this.getBoundingInfo();
    if (!boundingInfo) {
      return false;
    }
    return boundingInfo.isCompletelyInFrustum(frustumPlanes);
  }
  /**
   * Renders the submesh
   * @param enableAlphaMode defines if alpha needs to be used
   * @returns the submesh
   */
  render(enableAlphaMode) {
    this._renderingMesh.render(this, enableAlphaMode, this._mesh._internalAbstractMeshDataInfo._actAsRegularMesh ? this._mesh : void 0);
    return this;
  }
  /**
   * @internal
   */
  _getLinesIndexBuffer(indices, engine2) {
    if (!this._linesIndexBuffer) {
      const adjustedIndexCount = Math.floor(this.indexCount / 3) * 6;
      const shouldUseUint32 = this.verticesStart + this.verticesCount > 65535;
      const linesIndices = shouldUseUint32 ? new Uint32Array(adjustedIndexCount) : new Uint16Array(adjustedIndexCount);
      let offset = 0;
      if (indices.length === 0) {
        for (let index2 = this.indexStart; index2 < this.indexStart + this.indexCount; index2 += 3) {
          linesIndices[offset++] = index2;
          linesIndices[offset++] = index2 + 1;
          linesIndices[offset++] = index2 + 1;
          linesIndices[offset++] = index2 + 2;
          linesIndices[offset++] = index2 + 2;
          linesIndices[offset++] = index2;
        }
      } else {
        for (let index2 = this.indexStart; index2 < this.indexStart + this.indexCount; index2 += 3) {
          linesIndices[offset++] = indices[index2];
          linesIndices[offset++] = indices[index2 + 1];
          linesIndices[offset++] = indices[index2 + 1];
          linesIndices[offset++] = indices[index2 + 2];
          linesIndices[offset++] = indices[index2 + 2];
          linesIndices[offset++] = indices[index2];
        }
      }
      this._linesIndexBuffer = engine2.createIndexBuffer(linesIndices);
      this._linesIndexCount = linesIndices.length;
    }
    return this._linesIndexBuffer;
  }
  /**
   * Checks if the submesh intersects with a ray
   * @param ray defines the ray to test
   * @returns true is the passed ray intersects the submesh bounding box
   */
  canIntersects(ray) {
    const boundingInfo = this.getBoundingInfo();
    if (!boundingInfo) {
      return false;
    }
    return ray.intersectsBox(boundingInfo.boundingBox);
  }
  /**
   * Intersects current submesh with a ray
   * @param ray defines the ray to test
   * @param positions defines mesh's positions array
   * @param indices defines mesh's indices array
   * @param fastCheck defines if the first intersection will be used (and not the closest)
   * @param trianglePredicate defines an optional predicate used to select faces when a mesh intersection is detected
   * @returns intersection info or null if no intersection
   */
  intersects(ray, positions, indices, fastCheck, trianglePredicate) {
    const material = this.getMaterial();
    if (!material) {
      return null;
    }
    let step = 3;
    let checkStopper = false;
    switch (material.fillMode) {
      case 3:
      case 5:
      case 6:
      case 8:
        return null;
      case 7:
        step = 1;
        checkStopper = true;
        break;
    }
    if (material.fillMode === 4) {
      if (!indices.length) {
        return this._intersectUnIndexedLines(ray, positions, indices, this._mesh.intersectionThreshold, fastCheck);
      }
      return this._intersectLines(ray, positions, indices, this._mesh.intersectionThreshold, fastCheck);
    } else {
      if (!indices.length && this._mesh._unIndexed) {
        return this._intersectUnIndexedTriangles(ray, positions, indices, fastCheck, trianglePredicate);
      }
      return this._intersectTriangles(ray, positions, indices, step, checkStopper, fastCheck, trianglePredicate);
    }
  }
  /**
   * @internal
   */
  _intersectLines(ray, positions, indices, intersectionThreshold, fastCheck) {
    let intersectInfo = null;
    for (let index2 = this.indexStart; index2 < this.indexStart + this.indexCount; index2 += 2) {
      const p0 = positions[indices[index2]];
      const p1 = positions[indices[index2 + 1]];
      const length = ray.intersectionSegment(p0, p1, intersectionThreshold);
      if (length < 0) {
        continue;
      }
      if (fastCheck || !intersectInfo || length < intersectInfo.distance) {
        intersectInfo = new IntersectionInfo(null, null, length);
        intersectInfo.faceId = index2 / 2;
        if (fastCheck) {
          break;
        }
      }
    }
    return intersectInfo;
  }
  /**
   * @internal
   */
  _intersectUnIndexedLines(ray, positions, indices, intersectionThreshold, fastCheck) {
    let intersectInfo = null;
    for (let index2 = this.verticesStart; index2 < this.verticesStart + this.verticesCount; index2 += 2) {
      const p0 = positions[index2];
      const p1 = positions[index2 + 1];
      const length = ray.intersectionSegment(p0, p1, intersectionThreshold);
      if (length < 0) {
        continue;
      }
      if (fastCheck || !intersectInfo || length < intersectInfo.distance) {
        intersectInfo = new IntersectionInfo(null, null, length);
        intersectInfo.faceId = index2 / 2;
        if (fastCheck) {
          break;
        }
      }
    }
    return intersectInfo;
  }
  /**
   * @internal
   */
  _intersectTriangles(ray, positions, indices, step, checkStopper, fastCheck, trianglePredicate) {
    let intersectInfo = null;
    let faceId = -1;
    for (let index2 = this.indexStart; index2 < this.indexStart + this.indexCount - (3 - step); index2 += step) {
      faceId++;
      const indexA = indices[index2];
      const indexB = indices[index2 + 1];
      const indexC = indices[index2 + 2];
      if (checkStopper && indexC === 4294967295) {
        index2 += 2;
        continue;
      }
      const p0 = positions[indexA];
      const p1 = positions[indexB];
      const p2 = positions[indexC];
      if (!p0 || !p1 || !p2) {
        continue;
      }
      if (trianglePredicate && !trianglePredicate(p0, p1, p2, ray, indexA, indexB, indexC)) {
        continue;
      }
      const currentIntersectInfo = ray.intersectsTriangle(p0, p1, p2);
      if (currentIntersectInfo) {
        if (currentIntersectInfo.distance < 0) {
          continue;
        }
        if (fastCheck || !intersectInfo || currentIntersectInfo.distance < intersectInfo.distance) {
          intersectInfo = currentIntersectInfo;
          intersectInfo.faceId = faceId;
          if (fastCheck) {
            break;
          }
        }
      }
    }
    return intersectInfo;
  }
  /**
   * @internal
   */
  _intersectUnIndexedTriangles(ray, positions, indices, fastCheck, trianglePredicate) {
    let intersectInfo = null;
    for (let index2 = this.verticesStart; index2 < this.verticesStart + this.verticesCount; index2 += 3) {
      const p0 = positions[index2];
      const p1 = positions[index2 + 1];
      const p2 = positions[index2 + 2];
      if (trianglePredicate && !trianglePredicate(p0, p1, p2, ray, -1, -1, -1)) {
        continue;
      }
      const currentIntersectInfo = ray.intersectsTriangle(p0, p1, p2);
      if (currentIntersectInfo) {
        if (currentIntersectInfo.distance < 0) {
          continue;
        }
        if (fastCheck || !intersectInfo || currentIntersectInfo.distance < intersectInfo.distance) {
          intersectInfo = currentIntersectInfo;
          intersectInfo.faceId = index2 / 3;
          if (fastCheck) {
            break;
          }
        }
      }
    }
    return intersectInfo;
  }
  /** @internal */
  _rebuild() {
    if (this._linesIndexBuffer) {
      this._linesIndexBuffer = null;
    }
  }
  // Clone
  /**
   * Creates a new submesh from the passed mesh
   * @param newMesh defines the new hosting mesh
   * @param newRenderingMesh defines an optional rendering mesh
   * @returns the new submesh
   */
  clone(newMesh, newRenderingMesh) {
    const result = new SubMesh(this.materialIndex, this.verticesStart, this.verticesCount, this.indexStart, this.indexCount, newMesh, newRenderingMesh, false);
    if (!this.IsGlobal) {
      const boundingInfo = this.getBoundingInfo();
      if (!boundingInfo) {
        return result;
      }
      result._boundingInfo = new BoundingInfo(boundingInfo.minimum, boundingInfo.maximum);
    }
    return result;
  }
  // Dispose
  /**
   * Release associated resources
   * @param immediate If true, the effect will be disposed immediately (false by default)
   */
  dispose(immediate = false) {
    if (this._linesIndexBuffer) {
      this._mesh.getScene().getEngine()._releaseBuffer(this._linesIndexBuffer);
      this._linesIndexBuffer = null;
    }
    const index2 = this._mesh.subMeshes.indexOf(this);
    this._mesh.subMeshes.splice(index2, 1);
    this.resetDrawCache(void 0, immediate);
  }
  /**
   * Gets the class name
   * @returns the string "SubMesh".
   */
  getClassName() {
    return "SubMesh";
  }
  // Statics
  /**
   * Creates a new submesh from indices data
   * @param materialIndex the index of the main mesh material
   * @param startIndex the index where to start the copy in the mesh indices array
   * @param indexCount the number of indices to copy then from the startIndex
   * @param mesh the main mesh to create the submesh from
   * @param renderingMesh the optional rendering mesh
   * @param createBoundingBox defines if bounding box should be created for this submesh
   * @returns a new submesh
   */
  static CreateFromIndices(materialIndex, startIndex, indexCount, mesh, renderingMesh, createBoundingBox = true) {
    let minVertexIndex = Number.MAX_VALUE;
    let maxVertexIndex = -Number.MAX_VALUE;
    const whatWillRender = renderingMesh || mesh;
    const indices = whatWillRender.getIndices();
    for (let index2 = startIndex; index2 < startIndex + indexCount; index2++) {
      const vertexIndex = indices[index2];
      if (vertexIndex < minVertexIndex) {
        minVertexIndex = vertexIndex;
      }
      if (vertexIndex > maxVertexIndex) {
        maxVertexIndex = vertexIndex;
      }
    }
    return new SubMesh(materialIndex, minVertexIndex, maxVertexIndex - minVertexIndex + 1, startIndex, indexCount, mesh, renderingMesh, createBoundingBox);
  }
}
class VertexDataMaterialInfo {
}
class VertexData {
  /**
   * Creates a new VertexData
   */
  constructor() {
    this.uniqueId = 0;
    this.metadata = {};
    this._applyTo = makeSyncFunction(this._applyToCoroutine.bind(this));
    this.uniqueId = VertexData._UniqueIDGenerator;
    VertexData._UniqueIDGenerator++;
  }
  /**
   * Uses the passed data array to set the set the values for the specified kind of data
   * @param data a linear array of floating numbers
   * @param kind the type of data that is being set, eg positions, colors etc
   */
  set(data, kind) {
    if (!data.length) {
      Logger.Warn(`Setting vertex data kind '${kind}' with an empty array`);
    }
    switch (kind) {
      case VertexBuffer.PositionKind:
        this.positions = data;
        break;
      case VertexBuffer.NormalKind:
        this.normals = data;
        break;
      case VertexBuffer.TangentKind:
        this.tangents = data;
        break;
      case VertexBuffer.UVKind:
        this.uvs = data;
        break;
      case VertexBuffer.UV2Kind:
        this.uvs2 = data;
        break;
      case VertexBuffer.UV3Kind:
        this.uvs3 = data;
        break;
      case VertexBuffer.UV4Kind:
        this.uvs4 = data;
        break;
      case VertexBuffer.UV5Kind:
        this.uvs5 = data;
        break;
      case VertexBuffer.UV6Kind:
        this.uvs6 = data;
        break;
      case VertexBuffer.ColorKind:
        this.colors = data;
        break;
      case VertexBuffer.MatricesIndicesKind:
        this.matricesIndices = data;
        break;
      case VertexBuffer.MatricesWeightsKind:
        this.matricesWeights = data;
        break;
      case VertexBuffer.MatricesIndicesExtraKind:
        this.matricesIndicesExtra = data;
        break;
      case VertexBuffer.MatricesWeightsExtraKind:
        this.matricesWeightsExtra = data;
        break;
    }
  }
  /**
   * Associates the vertexData to the passed Mesh.
   * Sets it as updatable or not (default `false`)
   * @param mesh the mesh the vertexData is applied to
   * @param updatable when used and having the value true allows new data to update the vertexData
   * @returns the VertexData
   */
  applyToMesh(mesh, updatable) {
    this._applyTo(mesh, updatable, false);
    return this;
  }
  /**
   * Associates the vertexData to the passed Geometry.
   * Sets it as updatable or not (default `false`)
   * @param geometry the geometry the vertexData is applied to
   * @param updatable when used and having the value true allows new data to update the vertexData
   * @returns VertexData
   */
  applyToGeometry(geometry, updatable) {
    this._applyTo(geometry, updatable, false);
    return this;
  }
  /**
   * Updates the associated mesh
   * @param mesh the mesh to be updated
   * @returns VertexData
   */
  updateMesh(mesh) {
    this._update(mesh);
    return this;
  }
  /**
   * Updates the associated geometry
   * @param geometry the geometry to be updated
   * @returns VertexData.
   */
  updateGeometry(geometry) {
    this._update(geometry);
    return this;
  }
  /**
   * @internal
   */
  *_applyToCoroutine(meshOrGeometry, updatable = false, isAsync) {
    if (this.positions) {
      meshOrGeometry.setVerticesData(VertexBuffer.PositionKind, this.positions, updatable);
      if (isAsync) {
        yield;
      }
    }
    if (this.normals) {
      meshOrGeometry.setVerticesData(VertexBuffer.NormalKind, this.normals, updatable);
      if (isAsync) {
        yield;
      }
    }
    if (this.tangents) {
      meshOrGeometry.setVerticesData(VertexBuffer.TangentKind, this.tangents, updatable);
      if (isAsync) {
        yield;
      }
    }
    if (this.uvs) {
      meshOrGeometry.setVerticesData(VertexBuffer.UVKind, this.uvs, updatable);
      if (isAsync) {
        yield;
      }
    }
    if (this.uvs2) {
      meshOrGeometry.setVerticesData(VertexBuffer.UV2Kind, this.uvs2, updatable);
      if (isAsync) {
        yield;
      }
    }
    if (this.uvs3) {
      meshOrGeometry.setVerticesData(VertexBuffer.UV3Kind, this.uvs3, updatable);
      if (isAsync) {
        yield;
      }
    }
    if (this.uvs4) {
      meshOrGeometry.setVerticesData(VertexBuffer.UV4Kind, this.uvs4, updatable);
      if (isAsync) {
        yield;
      }
    }
    if (this.uvs5) {
      meshOrGeometry.setVerticesData(VertexBuffer.UV5Kind, this.uvs5, updatable);
      if (isAsync) {
        yield;
      }
    }
    if (this.uvs6) {
      meshOrGeometry.setVerticesData(VertexBuffer.UV6Kind, this.uvs6, updatable);
      if (isAsync) {
        yield;
      }
    }
    if (this.colors) {
      const stride = this.positions && this.colors.length === this.positions.length ? 3 : 4;
      meshOrGeometry.setVerticesData(VertexBuffer.ColorKind, this.colors, updatable, stride);
      if (this.hasVertexAlpha && meshOrGeometry.hasVertexAlpha !== void 0) {
        meshOrGeometry.hasVertexAlpha = true;
      }
      if (isAsync) {
        yield;
      }
    }
    if (this.matricesIndices) {
      meshOrGeometry.setVerticesData(VertexBuffer.MatricesIndicesKind, this.matricesIndices, updatable);
      if (isAsync) {
        yield;
      }
    }
    if (this.matricesWeights) {
      meshOrGeometry.setVerticesData(VertexBuffer.MatricesWeightsKind, this.matricesWeights, updatable);
      if (isAsync) {
        yield;
      }
    }
    if (this.matricesIndicesExtra) {
      meshOrGeometry.setVerticesData(VertexBuffer.MatricesIndicesExtraKind, this.matricesIndicesExtra, updatable);
      if (isAsync) {
        yield;
      }
    }
    if (this.matricesWeightsExtra) {
      meshOrGeometry.setVerticesData(VertexBuffer.MatricesWeightsExtraKind, this.matricesWeightsExtra, updatable);
      if (isAsync) {
        yield;
      }
    }
    if (this.indices) {
      meshOrGeometry.setIndices(this.indices, null, updatable);
      if (isAsync) {
        yield;
      }
    } else {
      meshOrGeometry.setIndices([], null);
    }
    if (meshOrGeometry.subMeshes && this.materialInfos && this.materialInfos.length > 1) {
      const mesh = meshOrGeometry;
      mesh.subMeshes = [];
      for (const matInfo of this.materialInfos) {
        new SubMesh(matInfo.materialIndex, matInfo.verticesStart, matInfo.verticesCount, matInfo.indexStart, matInfo.indexCount, mesh);
      }
    }
    return this;
  }
  _update(meshOrGeometry, updateExtends, makeItUnique) {
    if (this.positions) {
      meshOrGeometry.updateVerticesData(VertexBuffer.PositionKind, this.positions, updateExtends, makeItUnique);
    }
    if (this.normals) {
      meshOrGeometry.updateVerticesData(VertexBuffer.NormalKind, this.normals, updateExtends, makeItUnique);
    }
    if (this.tangents) {
      meshOrGeometry.updateVerticesData(VertexBuffer.TangentKind, this.tangents, updateExtends, makeItUnique);
    }
    if (this.uvs) {
      meshOrGeometry.updateVerticesData(VertexBuffer.UVKind, this.uvs, updateExtends, makeItUnique);
    }
    if (this.uvs2) {
      meshOrGeometry.updateVerticesData(VertexBuffer.UV2Kind, this.uvs2, updateExtends, makeItUnique);
    }
    if (this.uvs3) {
      meshOrGeometry.updateVerticesData(VertexBuffer.UV3Kind, this.uvs3, updateExtends, makeItUnique);
    }
    if (this.uvs4) {
      meshOrGeometry.updateVerticesData(VertexBuffer.UV4Kind, this.uvs4, updateExtends, makeItUnique);
    }
    if (this.uvs5) {
      meshOrGeometry.updateVerticesData(VertexBuffer.UV5Kind, this.uvs5, updateExtends, makeItUnique);
    }
    if (this.uvs6) {
      meshOrGeometry.updateVerticesData(VertexBuffer.UV6Kind, this.uvs6, updateExtends, makeItUnique);
    }
    if (this.colors) {
      meshOrGeometry.updateVerticesData(VertexBuffer.ColorKind, this.colors, updateExtends, makeItUnique);
    }
    if (this.matricesIndices) {
      meshOrGeometry.updateVerticesData(VertexBuffer.MatricesIndicesKind, this.matricesIndices, updateExtends, makeItUnique);
    }
    if (this.matricesWeights) {
      meshOrGeometry.updateVerticesData(VertexBuffer.MatricesWeightsKind, this.matricesWeights, updateExtends, makeItUnique);
    }
    if (this.matricesIndicesExtra) {
      meshOrGeometry.updateVerticesData(VertexBuffer.MatricesIndicesExtraKind, this.matricesIndicesExtra, updateExtends, makeItUnique);
    }
    if (this.matricesWeightsExtra) {
      meshOrGeometry.updateVerticesData(VertexBuffer.MatricesWeightsExtraKind, this.matricesWeightsExtra, updateExtends, makeItUnique);
    }
    if (this.indices) {
      meshOrGeometry.setIndices(this.indices, null);
    }
    return this;
  }
  static _TransformVector3Coordinates(coordinates, transformation, offset = 0, length = coordinates.length) {
    const coordinate = TmpVectors.Vector3[0];
    const transformedCoordinate = TmpVectors.Vector3[1];
    for (let index2 = offset; index2 < offset + length; index2 += 3) {
      Vector3.FromArrayToRef(coordinates, index2, coordinate);
      Vector3.TransformCoordinatesToRef(coordinate, transformation, transformedCoordinate);
      coordinates[index2] = transformedCoordinate.x;
      coordinates[index2 + 1] = transformedCoordinate.y;
      coordinates[index2 + 2] = transformedCoordinate.z;
    }
  }
  static _TransformVector3Normals(normals, transformation, offset = 0, length = normals.length) {
    const normal = TmpVectors.Vector3[0];
    const transformedNormal = TmpVectors.Vector3[1];
    for (let index2 = offset; index2 < offset + length; index2 += 3) {
      Vector3.FromArrayToRef(normals, index2, normal);
      Vector3.TransformNormalToRef(normal, transformation, transformedNormal);
      normals[index2] = transformedNormal.x;
      normals[index2 + 1] = transformedNormal.y;
      normals[index2 + 2] = transformedNormal.z;
    }
  }
  static _TransformVector4Normals(normals, transformation, offset = 0, length = normals.length) {
    const normal = TmpVectors.Vector4[0];
    const transformedNormal = TmpVectors.Vector4[1];
    for (let index2 = offset; index2 < offset + length; index2 += 4) {
      Vector4.FromArrayToRef(normals, index2, normal);
      Vector4.TransformNormalToRef(normal, transformation, transformedNormal);
      normals[index2] = transformedNormal.x;
      normals[index2 + 1] = transformedNormal.y;
      normals[index2 + 2] = transformedNormal.z;
      normals[index2 + 3] = transformedNormal.w;
    }
  }
  static _FlipFaces(indices, offset = 0, length = indices.length) {
    for (let index2 = offset; index2 < offset + length; index2 += 3) {
      const tmp = indices[index2 + 1];
      indices[index2 + 1] = indices[index2 + 2];
      indices[index2 + 2] = tmp;
    }
  }
  /**
   * Transforms each position and each normal of the vertexData according to the passed Matrix
   * @param matrix the transforming matrix
   * @returns the VertexData
   */
  transform(matrix) {
    const flip = matrix.determinant() < 0;
    if (this.positions) {
      VertexData._TransformVector3Coordinates(this.positions, matrix);
    }
    if (this.normals) {
      VertexData._TransformVector3Normals(this.normals, matrix);
    }
    if (this.tangents) {
      VertexData._TransformVector4Normals(this.tangents, matrix);
    }
    if (flip && this.indices) {
      VertexData._FlipFaces(this.indices);
    }
    return this;
  }
  /**
   * Generates an array of vertex data where each vertex data only has one material info
   * @returns An array of VertexData
   */
  splitBasedOnMaterialID() {
    if (!this.materialInfos || this.materialInfos.length < 2) {
      return [this];
    }
    const result = [];
    for (const materialInfo of this.materialInfos) {
      const vertexData = new VertexData();
      if (this.positions) {
        vertexData.positions = this.positions.slice(materialInfo.verticesStart * 3, (materialInfo.verticesCount + materialInfo.verticesStart) * 3);
      }
      if (this.normals) {
        vertexData.normals = this.normals.slice(materialInfo.verticesStart * 3, (materialInfo.verticesCount + materialInfo.verticesStart) * 3);
      }
      if (this.tangents) {
        vertexData.tangents = this.tangents.slice(materialInfo.verticesStart * 4, (materialInfo.verticesCount + materialInfo.verticesStart) * 4);
      }
      if (this.colors) {
        vertexData.colors = this.colors.slice(materialInfo.verticesStart * 4, (materialInfo.verticesCount + materialInfo.verticesStart) * 4);
      }
      if (this.uvs) {
        vertexData.uvs = this.uvs.slice(materialInfo.verticesStart * 2, (materialInfo.verticesCount + materialInfo.verticesStart) * 2);
      }
      if (this.uvs2) {
        vertexData.uvs2 = this.uvs2.slice(materialInfo.verticesStart * 2, (materialInfo.verticesCount + materialInfo.verticesStart) * 2);
      }
      if (this.uvs3) {
        vertexData.uvs3 = this.uvs3.slice(materialInfo.verticesStart * 2, (materialInfo.verticesCount + materialInfo.verticesStart) * 2);
      }
      if (this.uvs4) {
        vertexData.uvs4 = this.uvs4.slice(materialInfo.verticesStart * 2, (materialInfo.verticesCount + materialInfo.verticesStart) * 2);
      }
      if (this.uvs5) {
        vertexData.uvs5 = this.uvs5.slice(materialInfo.verticesStart * 2, (materialInfo.verticesCount + materialInfo.verticesStart) * 2);
      }
      if (this.uvs6) {
        vertexData.uvs6 = this.uvs6.slice(materialInfo.verticesStart * 2, (materialInfo.verticesCount + materialInfo.verticesStart) * 2);
      }
      if (this.matricesIndices) {
        vertexData.matricesIndices = this.matricesIndices.slice(materialInfo.verticesStart * 4, (materialInfo.verticesCount + materialInfo.verticesStart) * 4);
      }
      if (this.matricesIndicesExtra) {
        vertexData.matricesIndicesExtra = this.matricesIndicesExtra.slice(materialInfo.verticesStart * 4, (materialInfo.verticesCount + materialInfo.verticesStart) * 4);
      }
      if (this.matricesWeights) {
        vertexData.matricesWeights = this.matricesWeights.slice(materialInfo.verticesStart * 4, (materialInfo.verticesCount + materialInfo.verticesStart) * 4);
      }
      if (this.matricesWeightsExtra) {
        vertexData.matricesWeightsExtra = this.matricesWeightsExtra.slice(materialInfo.verticesStart * 4, (materialInfo.verticesCount + materialInfo.verticesStart) * 4);
      }
      if (this.indices) {
        vertexData.indices = [];
        for (let index2 = materialInfo.indexStart; index2 < materialInfo.indexStart + materialInfo.indexCount; index2++) {
          vertexData.indices.push(this.indices[index2] - materialInfo.verticesStart);
        }
      }
      const newMaterialInfo = new VertexDataMaterialInfo();
      newMaterialInfo.indexStart = 0;
      newMaterialInfo.indexCount = vertexData.indices ? vertexData.indices.length : 0;
      newMaterialInfo.materialIndex = materialInfo.materialIndex;
      newMaterialInfo.verticesStart = 0;
      newMaterialInfo.verticesCount = (vertexData.positions ? vertexData.positions.length : 0) / 3;
      vertexData.materialInfos = [newMaterialInfo];
      result.push(vertexData);
    }
    return result;
  }
  /**
   * Merges the passed VertexData into the current one
   * @param others the VertexData to be merged into the current one
   * @param use32BitsIndices defines a boolean indicating if indices must be store in a 32 bits array
   * @param forceCloneIndices defines a boolean indicating if indices are forced to be cloned
   * @param mergeMaterialIds defines a boolean indicating if we need to merge the material infos
   * @param enableCompletion defines a boolean indicating if the vertex data should be completed to be compatible
   * @returns the modified VertexData
   */
  merge(others, use32BitsIndices = false, forceCloneIndices = false, mergeMaterialIds = false, enableCompletion = false) {
    const vertexDatas = Array.isArray(others) ? others.map((other) => {
      return { vertexData: other };
    }) : [{ vertexData: others }];
    return runCoroutineSync(this._mergeCoroutine(void 0, vertexDatas, use32BitsIndices, false, forceCloneIndices, mergeMaterialIds, enableCompletion));
  }
  /**
   * @internal
   */
  *_mergeCoroutine(transform, vertexDatas, use32BitsIndices = false, isAsync, forceCloneIndices, mergeMaterialIds = false, enableCompletion = false) {
    var _a2, _b;
    this._validate();
    let others = vertexDatas.map((vertexData) => vertexData.vertexData);
    let root = this;
    if (enableCompletion) {
      for (const other of others) {
        if (!other) {
          continue;
        }
        other._validate();
        if (!this.normals && other.normals) {
          this.normals = new Float32Array(this.positions.length);
        }
        if (!this.tangents && other.tangents) {
          this.tangents = new Float32Array(this.positions.length / 3 * 4);
        }
        if (!this.uvs && other.uvs) {
          this.uvs = new Float32Array(this.positions.length / 3 * 2);
        }
        if (!this.uvs2 && other.uvs2) {
          this.uvs2 = new Float32Array(this.positions.length / 3 * 2);
        }
        if (!this.uvs3 && other.uvs3) {
          this.uvs3 = new Float32Array(this.positions.length / 3 * 2);
        }
        if (!this.uvs4 && other.uvs4) {
          this.uvs4 = new Float32Array(this.positions.length / 3 * 2);
        }
        if (!this.uvs5 && other.uvs5) {
          this.uvs5 = new Float32Array(this.positions.length / 3 * 2);
        }
        if (!this.uvs6 && other.uvs6) {
          this.uvs6 = new Float32Array(this.positions.length / 3 * 2);
        }
        if (!this.colors && other.colors) {
          this.colors = new Float32Array(this.positions.length / 3 * 4);
          this.colors.fill(1);
        }
        if (!this.matricesIndices && other.matricesIndices) {
          this.matricesIndices = new Float32Array(this.positions.length / 3 * 4);
        }
        if (!this.matricesWeights && other.matricesWeights) {
          this.matricesWeights = new Float32Array(this.positions.length / 3 * 4);
        }
        if (!this.matricesIndicesExtra && other.matricesIndicesExtra) {
          this.matricesIndicesExtra = new Float32Array(this.positions.length / 3 * 4);
        }
        if (!this.matricesWeightsExtra && other.matricesWeightsExtra) {
          this.matricesWeightsExtra = new Float32Array(this.positions.length / 3 * 4);
        }
      }
    }
    for (const other of others) {
      if (!other) {
        continue;
      }
      if (!enableCompletion) {
        other._validate();
        if (!this.normals !== !other.normals || !this.tangents !== !other.tangents || !this.uvs !== !other.uvs || !this.uvs2 !== !other.uvs2 || !this.uvs3 !== !other.uvs3 || !this.uvs4 !== !other.uvs4 || !this.uvs5 !== !other.uvs5 || !this.uvs6 !== !other.uvs6 || !this.colors !== !other.colors || !this.matricesIndices !== !other.matricesIndices || !this.matricesWeights !== !other.matricesWeights || !this.matricesIndicesExtra !== !other.matricesIndicesExtra || !this.matricesWeightsExtra !== !other.matricesWeightsExtra) {
          throw new Error("Cannot merge vertex data that do not have the same set of attributes");
        }
      } else {
        if (this.normals && !other.normals) {
          other.normals = new Float32Array(other.positions.length);
        }
        if (this.tangents && !other.tangents) {
          other.tangents = new Float32Array(other.positions.length / 3 * 4);
        }
        if (this.uvs && !other.uvs) {
          other.uvs = new Float32Array(other.positions.length / 3 * 2);
        }
        if (this.uvs2 && !other.uvs2) {
          other.uvs2 = new Float32Array(other.positions.length / 3 * 2);
        }
        if (this.uvs3 && !other.uvs3) {
          other.uvs3 = new Float32Array(other.positions.length / 3 * 2);
        }
        if (this.uvs4 && !other.uvs4) {
          other.uvs4 = new Float32Array(other.positions.length / 3 * 2);
        }
        if (this.uvs5 && !other.uvs5) {
          other.uvs5 = new Float32Array(other.positions.length / 3 * 2);
        }
        if (this.uvs6 && !other.uvs6) {
          other.uvs6 = new Float32Array(other.positions.length / 3 * 2);
        }
        if (this.colors && !other.colors) {
          other.colors = new Float32Array(other.positions.length / 3 * 4);
          other.colors.fill(1);
        }
        if (this.matricesIndices && !other.matricesIndices) {
          other.matricesIndices = new Float32Array(other.positions.length / 3 * 4);
        }
        if (this.matricesWeights && !other.matricesWeights) {
          other.matricesWeights = new Float32Array(other.positions.length / 3 * 4);
        }
        if (this.matricesIndicesExtra && !other.matricesIndicesExtra) {
          other.matricesIndicesExtra = new Float32Array(other.positions.length / 3 * 4);
        }
        if (this.matricesWeightsExtra && !other.matricesWeightsExtra) {
          other.matricesWeightsExtra = new Float32Array(other.positions.length / 3 * 4);
        }
      }
    }
    if (mergeMaterialIds) {
      let materialIndex = 0;
      let indexOffset = 0;
      let vertexOffset = 0;
      const materialInfos = [];
      let currentMaterialInfo = null;
      const vertexDataList = [];
      for (const split of this.splitBasedOnMaterialID()) {
        vertexDataList.push({ vertexData: split, transform });
      }
      for (const data of vertexDatas) {
        if (!data.vertexData) {
          continue;
        }
        for (const split of data.vertexData.splitBasedOnMaterialID()) {
          vertexDataList.push({ vertexData: split, transform: data.transform });
        }
      }
      vertexDataList.sort((a2, b2) => {
        const matInfoA = a2.vertexData.materialInfos ? a2.vertexData.materialInfos[0].materialIndex : 0;
        const matInfoB = b2.vertexData.materialInfos ? b2.vertexData.materialInfos[0].materialIndex : 0;
        if (matInfoA > matInfoB) {
          return 1;
        }
        if (matInfoA === matInfoB) {
          return 0;
        }
        return -1;
      });
      for (const vertexDataSource of vertexDataList) {
        const vertexData = vertexDataSource.vertexData;
        if (vertexData.materialInfos) {
          materialIndex = vertexData.materialInfos[0].materialIndex;
        } else {
          materialIndex = 0;
        }
        if (currentMaterialInfo && currentMaterialInfo.materialIndex === materialIndex) {
          currentMaterialInfo.indexCount += vertexData.indices.length;
          currentMaterialInfo.verticesCount += vertexData.positions.length / 3;
        } else {
          const materialInfo = new VertexDataMaterialInfo();
          materialInfo.materialIndex = materialIndex;
          materialInfo.indexStart = indexOffset;
          materialInfo.indexCount = vertexData.indices.length;
          materialInfo.verticesStart = vertexOffset;
          materialInfo.verticesCount = vertexData.positions.length / 3;
          materialInfos.push(materialInfo);
          currentMaterialInfo = materialInfo;
        }
        indexOffset += vertexData.indices.length;
        vertexOffset += vertexData.positions.length / 3;
      }
      const first = vertexDataList.splice(0, 1)[0];
      root = first.vertexData;
      transform = first.transform;
      others = vertexDataList.map((v2) => v2.vertexData);
      vertexDatas = vertexDataList;
      this.materialInfos = materialInfos;
    }
    const totalIndices = others.reduce((indexSum, vertexData) => {
      var _a3;
      return indexSum + (((_a3 = vertexData.indices) == null ? void 0 : _a3.length) ?? 0);
    }, ((_a2 = root.indices) == null ? void 0 : _a2.length) ?? 0);
    const sliceIndices = forceCloneIndices || others.some((vertexData) => vertexData.indices === root.indices);
    let indices = sliceIndices ? (_b = root.indices) == null ? void 0 : _b.slice() : root.indices;
    if (totalIndices > 0) {
      let indicesOffset = (indices == null ? void 0 : indices.length) ?? 0;
      if (!indices) {
        indices = new Array(totalIndices);
      }
      if (indices.length !== totalIndices) {
        if (Array.isArray(indices)) {
          indices.length = totalIndices;
        } else {
          const temp = use32BitsIndices || indices instanceof Uint32Array ? new Uint32Array(totalIndices) : new Uint16Array(totalIndices);
          temp.set(indices);
          indices = temp;
        }
        if (transform && transform.determinant() < 0) {
          VertexData._FlipFaces(indices, 0, indicesOffset);
        }
      }
      let positionsOffset = root.positions ? root.positions.length / 3 : 0;
      for (const { vertexData: other, transform: transform2 } of vertexDatas) {
        if (other.indices) {
          for (let index2 = 0; index2 < other.indices.length; index2++) {
            indices[indicesOffset + index2] = other.indices[index2] + positionsOffset;
          }
          if (transform2 && transform2.determinant() < 0) {
            VertexData._FlipFaces(indices, indicesOffset, other.indices.length);
          }
          positionsOffset += other.positions.length / 3;
          indicesOffset += other.indices.length;
          if (isAsync) {
            yield;
          }
        }
      }
    }
    this.indices = indices;
    this.positions = VertexData._MergeElement(VertexBuffer.PositionKind, root.positions, transform, vertexDatas.map((other) => [other.vertexData.positions, other.transform]));
    if (isAsync) {
      yield;
    }
    if (root.normals) {
      this.normals = VertexData._MergeElement(VertexBuffer.NormalKind, root.normals, transform, vertexDatas.map((other) => [other.vertexData.normals, other.transform]));
      if (isAsync) {
        yield;
      }
    }
    if (root.tangents) {
      this.tangents = VertexData._MergeElement(VertexBuffer.TangentKind, root.tangents, transform, vertexDatas.map((other) => [other.vertexData.tangents, other.transform]));
      if (isAsync) {
        yield;
      }
    }
    if (root.uvs) {
      this.uvs = VertexData._MergeElement(VertexBuffer.UVKind, root.uvs, transform, vertexDatas.map((other) => [other.vertexData.uvs, other.transform]));
      if (isAsync) {
        yield;
      }
    }
    if (root.uvs2) {
      this.uvs2 = VertexData._MergeElement(VertexBuffer.UV2Kind, root.uvs2, transform, vertexDatas.map((other) => [other.vertexData.uvs2, other.transform]));
      if (isAsync) {
        yield;
      }
    }
    if (root.uvs3) {
      this.uvs3 = VertexData._MergeElement(VertexBuffer.UV3Kind, root.uvs3, transform, vertexDatas.map((other) => [other.vertexData.uvs3, other.transform]));
      if (isAsync) {
        yield;
      }
    }
    if (root.uvs4) {
      this.uvs4 = VertexData._MergeElement(VertexBuffer.UV4Kind, root.uvs4, transform, vertexDatas.map((other) => [other.vertexData.uvs4, other.transform]));
      if (isAsync) {
        yield;
      }
    }
    if (root.uvs5) {
      this.uvs5 = VertexData._MergeElement(VertexBuffer.UV5Kind, root.uvs5, transform, vertexDatas.map((other) => [other.vertexData.uvs5, other.transform]));
      if (isAsync) {
        yield;
      }
    }
    if (root.uvs6) {
      this.uvs6 = VertexData._MergeElement(VertexBuffer.UV6Kind, root.uvs6, transform, vertexDatas.map((other) => [other.vertexData.uvs6, other.transform]));
      if (isAsync) {
        yield;
      }
    }
    if (root.colors) {
      this.colors = VertexData._MergeElement(VertexBuffer.ColorKind, root.colors, transform, vertexDatas.map((other) => [other.vertexData.colors, other.transform]));
      if (root.hasVertexAlpha !== void 0 || vertexDatas.some((other) => other.vertexData.hasVertexAlpha !== void 0)) {
        this.hasVertexAlpha = root.hasVertexAlpha || vertexDatas.some((other) => other.vertexData.hasVertexAlpha);
      }
      if (isAsync) {
        yield;
      }
    }
    if (root.matricesIndices) {
      this.matricesIndices = VertexData._MergeElement(VertexBuffer.MatricesIndicesKind, root.matricesIndices, transform, vertexDatas.map((other) => [other.vertexData.matricesIndices, other.transform]));
      if (isAsync) {
        yield;
      }
    }
    if (root.matricesWeights) {
      this.matricesWeights = VertexData._MergeElement(VertexBuffer.MatricesWeightsKind, root.matricesWeights, transform, vertexDatas.map((other) => [other.vertexData.matricesWeights, other.transform]));
      if (isAsync) {
        yield;
      }
    }
    if (root.matricesIndicesExtra) {
      this.matricesIndicesExtra = VertexData._MergeElement(VertexBuffer.MatricesIndicesExtraKind, root.matricesIndicesExtra, transform, vertexDatas.map((other) => [other.vertexData.matricesIndicesExtra, other.transform]));
      if (isAsync) {
        yield;
      }
    }
    if (root.matricesWeightsExtra) {
      this.matricesWeightsExtra = VertexData._MergeElement(VertexBuffer.MatricesWeightsExtraKind, root.matricesWeightsExtra, transform, vertexDatas.map((other) => [other.vertexData.matricesWeightsExtra, other.transform]));
    }
    return this;
  }
  static _MergeElement(kind, source, transform, others) {
    const nonNullOthers = others.filter((other) => other[0] !== null && other[0] !== void 0);
    if (!source && nonNullOthers.length == 0) {
      return source;
    }
    if (!source) {
      return this._MergeElement(kind, nonNullOthers[0][0], nonNullOthers[0][1], nonNullOthers.slice(1));
    }
    const len = nonNullOthers.reduce((sumLen, elements) => sumLen + elements[0].length, source.length);
    const transformRange = kind === VertexBuffer.PositionKind ? VertexData._TransformVector3Coordinates : kind === VertexBuffer.NormalKind ? VertexData._TransformVector3Normals : kind === VertexBuffer.TangentKind ? VertexData._TransformVector4Normals : () => {
    };
    if (source instanceof Float32Array) {
      const ret32 = new Float32Array(len);
      ret32.set(source);
      transform && transformRange(ret32, transform, 0, source.length);
      let offset = source.length;
      for (const [vertexData, transform2] of nonNullOthers) {
        ret32.set(vertexData, offset);
        transform2 && transformRange(ret32, transform2, offset, vertexData.length);
        offset += vertexData.length;
      }
      return ret32;
    } else {
      const ret = new Array(len);
      for (let i2 = 0; i2 < source.length; i2++) {
        ret[i2] = source[i2];
      }
      transform && transformRange(ret, transform, 0, source.length);
      let offset = source.length;
      for (const [vertexData, transform2] of nonNullOthers) {
        for (let i2 = 0; i2 < vertexData.length; i2++) {
          ret[offset + i2] = vertexData[i2];
        }
        transform2 && transformRange(ret, transform2, offset, vertexData.length);
        offset += vertexData.length;
      }
      return ret;
    }
  }
  _validate() {
    if (!this.positions) {
      throw new RuntimeError("Positions are required", ErrorCodes.MeshInvalidPositionsError);
    }
    const getElementCount = (kind, values) => {
      const stride = VertexBuffer.DeduceStride(kind);
      if (values.length % stride !== 0) {
        throw new Error("The " + kind + "s array count must be a multiple of " + stride);
      }
      return values.length / stride;
    };
    const positionsElementCount = getElementCount(VertexBuffer.PositionKind, this.positions);
    const validateElementCount = (kind, values) => {
      const elementCount = getElementCount(kind, values);
      if (elementCount !== positionsElementCount) {
        throw new Error("The " + kind + "s element count (" + elementCount + ") does not match the positions count (" + positionsElementCount + ")");
      }
    };
    if (this.normals) {
      validateElementCount(VertexBuffer.NormalKind, this.normals);
    }
    if (this.tangents) {
      validateElementCount(VertexBuffer.TangentKind, this.tangents);
    }
    if (this.uvs) {
      validateElementCount(VertexBuffer.UVKind, this.uvs);
    }
    if (this.uvs2) {
      validateElementCount(VertexBuffer.UV2Kind, this.uvs2);
    }
    if (this.uvs3) {
      validateElementCount(VertexBuffer.UV3Kind, this.uvs3);
    }
    if (this.uvs4) {
      validateElementCount(VertexBuffer.UV4Kind, this.uvs4);
    }
    if (this.uvs5) {
      validateElementCount(VertexBuffer.UV5Kind, this.uvs5);
    }
    if (this.uvs6) {
      validateElementCount(VertexBuffer.UV6Kind, this.uvs6);
    }
    if (this.colors) {
      validateElementCount(VertexBuffer.ColorKind, this.colors);
    }
    if (this.matricesIndices) {
      validateElementCount(VertexBuffer.MatricesIndicesKind, this.matricesIndices);
    }
    if (this.matricesWeights) {
      validateElementCount(VertexBuffer.MatricesWeightsKind, this.matricesWeights);
    }
    if (this.matricesIndicesExtra) {
      validateElementCount(VertexBuffer.MatricesIndicesExtraKind, this.matricesIndicesExtra);
    }
    if (this.matricesWeightsExtra) {
      validateElementCount(VertexBuffer.MatricesWeightsExtraKind, this.matricesWeightsExtra);
    }
  }
  /**
   * Clone the current vertex data
   * @returns a copy of the current data
   */
  clone() {
    const serializationObject = this.serialize();
    return VertexData.Parse(serializationObject);
  }
  /**
   * Serializes the VertexData
   * @returns a serialized object
   */
  serialize() {
    const serializationObject = {};
    if (this.positions) {
      serializationObject.positions = Array.from(this.positions);
    }
    if (this.normals) {
      serializationObject.normals = Array.from(this.normals);
    }
    if (this.tangents) {
      serializationObject.tangents = Array.from(this.tangents);
    }
    if (this.uvs) {
      serializationObject.uvs = Array.from(this.uvs);
    }
    if (this.uvs2) {
      serializationObject.uvs2 = Array.from(this.uvs2);
    }
    if (this.uvs3) {
      serializationObject.uvs3 = Array.from(this.uvs3);
    }
    if (this.uvs4) {
      serializationObject.uvs4 = Array.from(this.uvs4);
    }
    if (this.uvs5) {
      serializationObject.uvs5 = Array.from(this.uvs5);
    }
    if (this.uvs6) {
      serializationObject.uvs6 = Array.from(this.uvs6);
    }
    if (this.colors) {
      serializationObject.colors = Array.from(this.colors);
      serializationObject.hasVertexAlpha = this.hasVertexAlpha;
    }
    if (this.matricesIndices) {
      serializationObject.matricesIndices = Array.from(this.matricesIndices);
      serializationObject.matricesIndices._isExpanded = true;
    }
    if (this.matricesWeights) {
      serializationObject.matricesWeights = Array.from(this.matricesWeights);
    }
    if (this.matricesIndicesExtra) {
      serializationObject.matricesIndicesExtra = Array.from(this.matricesIndicesExtra);
      serializationObject.matricesIndicesExtra._isExpanded = true;
    }
    if (this.matricesWeightsExtra) {
      serializationObject.matricesWeightsExtra = Array.from(this.matricesWeightsExtra);
    }
    serializationObject.indices = this.indices ? Array.from(this.indices) : [];
    if (this.materialInfos) {
      serializationObject.materialInfos = [];
      for (const materialInfo of this.materialInfos) {
        const materialInfoSerializationObject = {
          indexStart: materialInfo.indexStart,
          indexCount: materialInfo.indexCount,
          materialIndex: materialInfo.materialIndex,
          verticesStart: materialInfo.verticesStart,
          verticesCount: materialInfo.verticesCount
        };
        serializationObject.materialInfos.push(materialInfoSerializationObject);
      }
    }
    return serializationObject;
  }
  // Statics
  /**
   * Extracts the vertexData from a mesh
   * @param mesh the mesh from which to extract the VertexData
   * @param copyWhenShared defines if the VertexData must be cloned when shared between multiple meshes, optional, default false
   * @param forceCopy indicating that the VertexData must be cloned, optional, default false
   * @returns the object VertexData associated to the passed mesh
   */
  static ExtractFromMesh(mesh, copyWhenShared, forceCopy) {
    return VertexData._ExtractFrom(mesh, copyWhenShared, forceCopy);
  }
  /**
   * Extracts the vertexData from the geometry
   * @param geometry the geometry from which to extract the VertexData
   * @param copyWhenShared defines if the VertexData must be cloned when the geometry is shared between multiple meshes, optional, default false
   * @param forceCopy indicating that the VertexData must be cloned, optional, default false
   * @returns the object VertexData associated to the passed mesh
   */
  static ExtractFromGeometry(geometry, copyWhenShared, forceCopy) {
    return VertexData._ExtractFrom(geometry, copyWhenShared, forceCopy);
  }
  static _ExtractFrom(meshOrGeometry, copyWhenShared, forceCopy) {
    const result = new VertexData();
    if (meshOrGeometry.isVerticesDataPresent(VertexBuffer.PositionKind)) {
      result.positions = meshOrGeometry.getVerticesData(VertexBuffer.PositionKind, copyWhenShared, forceCopy);
    }
    if (meshOrGeometry.isVerticesDataPresent(VertexBuffer.NormalKind)) {
      result.normals = meshOrGeometry.getVerticesData(VertexBuffer.NormalKind, copyWhenShared, forceCopy);
    }
    if (meshOrGeometry.isVerticesDataPresent(VertexBuffer.TangentKind)) {
      result.tangents = meshOrGeometry.getVerticesData(VertexBuffer.TangentKind, copyWhenShared, forceCopy);
    }
    if (meshOrGeometry.isVerticesDataPresent(VertexBuffer.UVKind)) {
      result.uvs = meshOrGeometry.getVerticesData(VertexBuffer.UVKind, copyWhenShared, forceCopy);
    }
    if (meshOrGeometry.isVerticesDataPresent(VertexBuffer.UV2Kind)) {
      result.uvs2 = meshOrGeometry.getVerticesData(VertexBuffer.UV2Kind, copyWhenShared, forceCopy);
    }
    if (meshOrGeometry.isVerticesDataPresent(VertexBuffer.UV3Kind)) {
      result.uvs3 = meshOrGeometry.getVerticesData(VertexBuffer.UV3Kind, copyWhenShared, forceCopy);
    }
    if (meshOrGeometry.isVerticesDataPresent(VertexBuffer.UV4Kind)) {
      result.uvs4 = meshOrGeometry.getVerticesData(VertexBuffer.UV4Kind, copyWhenShared, forceCopy);
    }
    if (meshOrGeometry.isVerticesDataPresent(VertexBuffer.UV5Kind)) {
      result.uvs5 = meshOrGeometry.getVerticesData(VertexBuffer.UV5Kind, copyWhenShared, forceCopy);
    }
    if (meshOrGeometry.isVerticesDataPresent(VertexBuffer.UV6Kind)) {
      result.uvs6 = meshOrGeometry.getVerticesData(VertexBuffer.UV6Kind, copyWhenShared, forceCopy);
    }
    if (meshOrGeometry.isVerticesDataPresent(VertexBuffer.ColorKind)) {
      const geometry = meshOrGeometry.geometry || meshOrGeometry;
      const vertexBuffer = geometry.getVertexBuffer(VertexBuffer.ColorKind);
      const colors = geometry.getVerticesData(VertexBuffer.ColorKind, copyWhenShared, forceCopy);
      if (vertexBuffer.getSize() === 3) {
        const newColors = new Float32Array(colors.length * 4 / 3);
        for (let i2 = 0, j2 = 0; i2 < colors.length; i2 += 3, j2 += 4) {
          newColors[j2] = colors[i2];
          newColors[j2 + 1] = colors[i2 + 1];
          newColors[j2 + 2] = colors[i2 + 2];
          newColors[j2 + 3] = 1;
        }
        result.colors = newColors;
      } else if (vertexBuffer.getSize() === 4) {
        result.colors = colors;
      } else {
        throw new Error(`Unexpected number of color components: ${vertexBuffer.getSize()}`);
      }
    }
    if (meshOrGeometry.isVerticesDataPresent(VertexBuffer.MatricesIndicesKind)) {
      result.matricesIndices = meshOrGeometry.getVerticesData(VertexBuffer.MatricesIndicesKind, copyWhenShared, forceCopy);
    }
    if (meshOrGeometry.isVerticesDataPresent(VertexBuffer.MatricesWeightsKind)) {
      result.matricesWeights = meshOrGeometry.getVerticesData(VertexBuffer.MatricesWeightsKind, copyWhenShared, forceCopy);
    }
    if (meshOrGeometry.isVerticesDataPresent(VertexBuffer.MatricesIndicesExtraKind)) {
      result.matricesIndicesExtra = meshOrGeometry.getVerticesData(VertexBuffer.MatricesIndicesExtraKind, copyWhenShared, forceCopy);
    }
    if (meshOrGeometry.isVerticesDataPresent(VertexBuffer.MatricesWeightsExtraKind)) {
      result.matricesWeightsExtra = meshOrGeometry.getVerticesData(VertexBuffer.MatricesWeightsExtraKind, copyWhenShared, forceCopy);
    }
    result.indices = meshOrGeometry.getIndices(copyWhenShared, forceCopy);
    return result;
  }
  /**
   * Creates the VertexData for a Ribbon
   * @param options an object used to set the following optional parameters for the ribbon, required but can be empty
   * * pathArray array of paths, each of which an array of successive Vector3
   * * closeArray creates a seam between the first and the last paths of the pathArray, optional, default false
   * * closePath creates a seam between the first and the last points of each path of the path array, optional, default false
   * * offset a positive integer, only used when pathArray contains a single path (offset = 10 means the point 1 is joined to the point 11), default rounded half size of the pathArray length
   * * sideOrientation optional and takes the values : Mesh.FRONTSIDE (default), Mesh.BACKSIDE or Mesh.DOUBLESIDE
   * * frontUvs only usable when you create a double-sided mesh, used to choose what parts of the texture image to crop and apply on the front side, optional, default vector4 (0, 0, 1, 1)
   * * backUVs only usable when you create a double-sided mesh, used to choose what parts of the texture image to crop and apply on the back side, optional, default vector4 (0, 0, 1, 1)
   * * invertUV swaps in the U and V coordinates when applying a texture, optional, default false
   * * uvs a linear array, of length 2 * number of vertices, of custom UV values, optional
   * * colors a linear array, of length 4 * number of vertices, of custom color values, optional
   * @returns the VertexData of the ribbon
   * @deprecated use CreateRibbonVertexData instead
   */
  static CreateRibbon(options) {
    throw _WarnImport("ribbonBuilder");
  }
  /**
   * Creates the VertexData for a box
   * @param options an object used to set the following optional parameters for the box, required but can be empty
   * * size sets the width, height and depth of the box to the value of size, optional default 1
   * * width sets the width (x direction) of the box, overwrites the width set by size, optional, default size
   * * height sets the height (y direction) of the box, overwrites the height set by size, optional, default size
   * * depth sets the depth (z direction) of the box, overwrites the depth set by size, optional, default size
   * * faceUV an array of 6 Vector4 elements used to set different images to each box side
   * * faceColors an array of 6 Color3 elements used to set different colors to each box side
   * * sideOrientation optional and takes the values : Mesh.FRONTSIDE (default), Mesh.BACKSIDE or Mesh.DOUBLESIDE
   * * frontUvs only usable when you create a double-sided mesh, used to choose what parts of the texture image to crop and apply on the front side, optional, default vector4 (0, 0, 1, 1)
   * * backUVs only usable when you create a double-sided mesh, used to choose what parts of the texture image to crop and apply on the back side, optional, default vector4 (0, 0, 1, 1)
   * @returns the VertexData of the box
   * @deprecated Please use CreateBoxVertexData from the BoxBuilder file instead
   */
  static CreateBox(options) {
    throw _WarnImport("boxBuilder");
  }
  /**
   * Creates the VertexData for a tiled box
   * @param options an object used to set the following optional parameters for the box, required but can be empty
   * * faceTiles sets the pattern, tile size and number of tiles for a face
   * * faceUV an array of 6 Vector4 elements used to set different images to each box side
   * * faceColors an array of 6 Color3 elements used to set different colors to each box side
   * * sideOrientation optional and takes the values : Mesh.FRONTSIDE (default), Mesh.BACKSIDE or Mesh.DOUBLESIDE
   * @param options.pattern
   * @param options.width
   * @param options.height
   * @param options.depth
   * @param options.tileSize
   * @param options.tileWidth
   * @param options.tileHeight
   * @param options.alignHorizontal
   * @param options.alignVertical
   * @param options.faceUV
   * @param options.faceColors
   * @param options.sideOrientation
   * @returns the VertexData of the box
   * @deprecated Please use CreateTiledBoxVertexData instead
   */
  static CreateTiledBox(options) {
    throw _WarnImport("tiledBoxBuilder");
  }
  /**
   * Creates the VertexData for a tiled plane
   * @param options an object used to set the following optional parameters for the box, required but can be empty
   * * pattern a limited pattern arrangement depending on the number
   * * tileSize sets the width, height and depth of the tile to the value of size, optional default 1
   * * tileWidth sets the width (x direction) of the tile, overwrites the width set by size, optional, default size
   * * tileHeight sets the height (y direction) of the tile, overwrites the height set by size, optional, default size
   * * sideOrientation optional and takes the values : Mesh.FRONTSIDE (default), Mesh.BACKSIDE or Mesh.DOUBLESIDE
   * * frontUvs only usable when you create a double-sided mesh, used to choose what parts of the texture image to crop and apply on the front side, optional, default vector4 (0, 0, 1, 1)
   * * backUVs only usable when you create a double-sided mesh, used to choose what parts of the texture image to crop and apply on the back side, optional, default vector4 (0, 0, 1, 1)
   * @returns the VertexData of the tiled plane
   * @deprecated use CreateTiledPlaneVertexData instead
   */
  static CreateTiledPlane(options) {
    throw _WarnImport("tiledPlaneBuilder");
  }
  /**
   * Creates the VertexData for an ellipsoid, defaults to a sphere
   * @param options an object used to set the following optional parameters for the box, required but can be empty
   * * segments sets the number of horizontal strips optional, default 32
   * * diameter sets the axes dimensions, diameterX, diameterY and diameterZ to the value of diameter, optional default 1
   * * diameterX sets the diameterX (x direction) of the ellipsoid, overwrites the diameterX set by diameter, optional, default diameter
   * * diameterY sets the diameterY (y direction) of the ellipsoid, overwrites the diameterY set by diameter, optional, default diameter
   * * diameterZ sets the diameterZ (z direction) of the ellipsoid, overwrites the diameterZ set by diameter, optional, default diameter
   * * arc a number from 0 to 1, to create an unclosed ellipsoid based on the fraction of the circumference (latitude) given by the arc value, optional, default 1
   * * slice a number from 0 to 1, to create an unclosed ellipsoid based on the fraction of the height (latitude) given by the arc value, optional, default 1
   * * sideOrientation optional and takes the values : Mesh.FRONTSIDE (default), Mesh.BACKSIDE or Mesh.DOUBLESIDE
   * * frontUvs only usable when you create a double-sided mesh, used to choose what parts of the texture image to crop and apply on the front side, optional, default vector4 (0, 0, 1, 1)
   * * backUVs only usable when you create a double-sided mesh, used to choose what parts of the texture image to crop and apply on the back side, optional, default vector4 (0, 0, 1, 1)
   * @returns the VertexData of the ellipsoid
   * @deprecated use CreateSphereVertexData instead
   */
  static CreateSphere(options) {
    throw _WarnImport("sphereBuilder");
  }
  /**
   * Creates the VertexData for a cylinder, cone or prism
   * @param options an object used to set the following optional parameters for the box, required but can be empty
   * * height sets the height (y direction) of the cylinder, optional, default 2
   * * diameterTop sets the diameter of the top of the cone, overwrites diameter,  optional, default diameter
   * * diameterBottom sets the diameter of the bottom of the cone, overwrites diameter,  optional, default diameter
   * * diameter sets the diameter of the top and bottom of the cone, optional default 1
   * * tessellation the number of prism sides, 3 for a triangular prism, optional, default 24
   * * subdivisions` the number of rings along the cylinder height, optional, default 1
   * * arc a number from 0 to 1, to create an unclosed cylinder based on the fraction of the circumference given by the arc value, optional, default 1
   * * faceColors an array of Color3 elements used to set different colors to the top, rings and bottom respectively
   * * faceUV an array of Vector4 elements used to set different images to the top, rings and bottom respectively
   * * hasRings when true makes each subdivision independently treated as a face for faceUV and faceColors, optional, default false
   * * enclose when true closes an open cylinder by adding extra flat faces between the height axis and vertical edges, think cut cake
   * * sideOrientation optional and takes the values : Mesh.FRONTSIDE (default), Mesh.BACKSIDE or Mesh.DOUBLESIDE
   * * frontUvs only usable when you create a double-sided mesh, used to choose what parts of the texture image to crop and apply on the front side, optional, default vector4 (0, 0, 1, 1)
   * * backUVs only usable when you create a double-sided mesh, used to choose what parts of the texture image to crop and apply on the back side, optional, default vector4 (0, 0, 1, 1)
   * @returns the VertexData of the cylinder, cone or prism
   * @deprecated please use CreateCylinderVertexData instead
   */
  static CreateCylinder(options) {
    throw _WarnImport("cylinderBuilder");
  }
  /**
   * Creates the VertexData for a torus
   * @param options an object used to set the following optional parameters for the box, required but can be empty
   * * diameter the diameter of the torus, optional default 1
   * * thickness the diameter of the tube forming the torus, optional default 0.5
   * * tessellation the number of prism sides, 3 for a triangular prism, optional, default 24
   * * sideOrientation optional and takes the values : Mesh.FRONTSIDE (default), Mesh.BACKSIDE or Mesh.DOUBLESIDE
   * * frontUvs only usable when you create a double-sided mesh, used to choose what parts of the texture image to crop and apply on the front side, optional, default vector4 (0, 0, 1, 1)
   * * backUVs only usable when you create a double-sided mesh, used to choose what parts of the texture image to crop and apply on the back side, optional, default vector4 (0, 0, 1, 1)
   * @returns the VertexData of the torus
   * @deprecated use CreateTorusVertexData instead
   */
  static CreateTorus(options) {
    throw _WarnImport("torusBuilder");
  }
  /**
   * Creates the VertexData of the LineSystem
   * @param options an object used to set the following optional parameters for the LineSystem, required but can be empty
   *  - lines an array of lines, each line being an array of successive Vector3
   *  - colors an array of line colors, each of the line colors being an array of successive Color4, one per line point
   * @returns the VertexData of the LineSystem
   * @deprecated use CreateLineSystemVertexData instead
   */
  static CreateLineSystem(options) {
    throw _WarnImport("linesBuilder");
  }
  /**
   * Create the VertexData for a DashedLines
   * @param options an object used to set the following optional parameters for the DashedLines, required but can be empty
   *  - points an array successive Vector3
   *  - dashSize the size of the dashes relative to the dash number, optional, default 3
   *  - gapSize the size of the gap between two successive dashes relative to the dash number, optional, default 1
   *  - dashNb the intended total number of dashes, optional, default 200
   * @returns the VertexData for the DashedLines
   * @deprecated use CreateDashedLinesVertexData instead
   */
  static CreateDashedLines(options) {
    throw _WarnImport("linesBuilder");
  }
  /**
   * Creates the VertexData for a Ground
   * @param options an object used to set the following optional parameters for the Ground, required but can be empty
   *  - width the width (x direction) of the ground, optional, default 1
   *  - height the height (z direction) of the ground, optional, default 1
   *  - subdivisions the number of subdivisions per side, optional, default 1
   * @returns the VertexData of the Ground
   * @deprecated Please use CreateGroundVertexData instead
   */
  static CreateGround(options) {
    throw _WarnImport("groundBuilder");
  }
  /**
   * Creates the VertexData for a TiledGround by subdividing the ground into tiles
   * @param options an object used to set the following optional parameters for the Ground, required but can be empty
   * * xmin the ground minimum X coordinate, optional, default -1
   * * zmin the ground minimum Z coordinate, optional, default -1
   * * xmax the ground maximum X coordinate, optional, default 1
   * * zmax the ground maximum Z coordinate, optional, default 1
   * * subdivisions a javascript object {w: positive integer, h: positive integer}, `w` and `h` are the numbers of subdivisions on the ground width and height creating 'tiles', default {w: 6, h: 6}
   * * precision a javascript object {w: positive integer, h: positive integer}, `w` and `h` are the numbers of subdivisions on the tile width and height, default {w: 2, h: 2}
   * @returns the VertexData of the TiledGround
   * @deprecated use CreateTiledGroundVertexData instead
   */
  static CreateTiledGround(options) {
    throw _WarnImport("groundBuilder");
  }
  /**
   * Creates the VertexData of the Ground designed from a heightmap
   * @param options an object used to set the following parameters for the Ground, required and provided by CreateGroundFromHeightMap
   * * width the width (x direction) of the ground
   * * height the height (z direction) of the ground
   * * subdivisions the number of subdivisions per side
   * * minHeight the minimum altitude on the ground, optional, default 0
   * * maxHeight the maximum altitude on the ground, optional default 1
   * * colorFilter the filter to apply to the image pixel colors to compute the height, optional Color3, default (0.3, 0.59, 0.11)
   * * buffer the array holding the image color data
   * * bufferWidth the width of image
   * * bufferHeight the height of image
   * * alphaFilter Remove any data where the alpha channel is below this value, defaults 0 (all data visible)
   * @returns the VertexData of the Ground designed from a heightmap
   * @deprecated use CreateGroundFromHeightMapVertexData instead
   */
  static CreateGroundFromHeightMap(options) {
    throw _WarnImport("groundBuilder");
  }
  /**
   * Creates the VertexData for a Plane
   * @param options an object used to set the following optional parameters for the plane, required but can be empty
   * * size sets the width and height of the plane to the value of size, optional default 1
   * * width sets the width (x direction) of the plane, overwrites the width set by size, optional, default size
   * * height sets the height (y direction) of the plane, overwrites the height set by size, optional, default size
   * * sideOrientation optional and takes the values : Mesh.FRONTSIDE (default), Mesh.BACKSIDE or Mesh.DOUBLESIDE
   * * frontUvs only usable when you create a double-sided mesh, used to choose what parts of the texture image to crop and apply on the front side, optional, default vector4 (0, 0, 1, 1)
   * * backUVs only usable when you create a double-sided mesh, used to choose what parts of the texture image to crop and apply on the back side, optional, default vector4 (0, 0, 1, 1)
   * @returns the VertexData of the box
   * @deprecated use CreatePlaneVertexData instead
   */
  static CreatePlane(options) {
    throw _WarnImport("planeBuilder");
  }
  /**
   * Creates the VertexData of the Disc or regular Polygon
   * @param options an object used to set the following optional parameters for the disc, required but can be empty
   * * radius the radius of the disc, optional default 0.5
   * * tessellation the number of polygon sides, optional, default 64
   * * arc a number from 0 to 1, to create an unclosed polygon based on the fraction of the circumference given by the arc value, optional, default 1
   * * sideOrientation optional and takes the values : Mesh.FRONTSIDE (default), Mesh.BACKSIDE or Mesh.DOUBLESIDE
   * * frontUvs only usable when you create a double-sided mesh, used to choose what parts of the texture image to crop and apply on the front side, optional, default vector4 (0, 0, 1, 1)
   * * backUVs only usable when you create a double-sided mesh, used to choose what parts of the texture image to crop and apply on the back side, optional, default vector4 (0, 0, 1, 1)
   * @returns the VertexData of the box
   * @deprecated use CreateDiscVertexData instead
   */
  static CreateDisc(options) {
    throw _WarnImport("discBuilder");
  }
  /**
   * Creates the VertexData for an irregular Polygon in the XoZ plane using a mesh built by polygonTriangulation.build()
   * All parameters are provided by CreatePolygon as needed
   * @param polygon a mesh built from polygonTriangulation.build()
   * @param sideOrientation takes the values Mesh.FRONTSIDE (default), Mesh.BACKSIDE or Mesh.DOUBLESIDE
   * @param fUV an array of Vector4 elements used to set different images to the top, rings and bottom respectively
   * @param fColors an array of Color3 elements used to set different colors to the top, rings and bottom respectively
   * @param frontUVs only usable when you create a double-sided mesh, used to choose what parts of the texture image to crop and apply on the front side, optional, default vector4 (0, 0, 1, 1)
   * @param backUVs only usable when you create a double-sided mesh, used to choose what parts of the texture image to crop and apply on the back side, optional, default vector4 (0, 0, 1, 1)
   * @param wrap a boolean, default false, when true and fUVs used texture is wrapped around all sides, when false texture is applied side
   * @returns the VertexData of the Polygon
   * @deprecated use CreatePolygonVertexData instead
   */
  static CreatePolygon(polygon, sideOrientation, fUV, fColors, frontUVs, backUVs, wrap) {
    throw _WarnImport("polygonBuilder");
  }
  /**
   * Creates the VertexData of the IcoSphere
   * @param options an object used to set the following optional parameters for the IcoSphere, required but can be empty
   * * radius the radius of the IcoSphere, optional default 1
   * * radiusX allows stretching in the x direction, optional, default radius
   * * radiusY allows stretching in the y direction, optional, default radius
   * * radiusZ allows stretching in the z direction, optional, default radius
   * * flat when true creates a flat shaded mesh, optional, default true
   * * subdivisions increasing the subdivisions increases the number of faces, optional, default 4
   * * sideOrientation optional and takes the values : Mesh.FRONTSIDE (default), Mesh.BACKSIDE or Mesh.DOUBLESIDE
   * * frontUvs only usable when you create a double-sided mesh, used to choose what parts of the texture image to crop and apply on the front side, optional, default vector4 (0, 0, 1, 1)
   * * backUVs only usable when you create a double-sided mesh, used to choose what parts of the texture image to crop and apply on the back side, optional, default vector4 (0, 0, 1, 1)
   * @returns the VertexData of the IcoSphere
   * @deprecated use CreateIcoSphereVertexData instead
   */
  static CreateIcoSphere(options) {
    throw _WarnImport("icoSphereBuilder");
  }
  // inspired from // http://stemkoski.github.io/Three.js/Polyhedra.html
  /**
   * Creates the VertexData for a Polyhedron
   * @param options an object used to set the following optional parameters for the polyhedron, required but can be empty
   * * type provided types are:
   *  * 0 : Tetrahedron, 1 : Octahedron, 2 : Dodecahedron, 3 : Icosahedron, 4 : Rhombicuboctahedron, 5 : Triangular Prism, 6 : Pentagonal Prism, 7 : Hexagonal Prism, 8 : Square Pyramid (J1)
   *  * 9 : Pentagonal Pyramid (J2), 10 : Triangular Dipyramid (J12), 11 : Pentagonal Dipyramid (J13), 12 : Elongated Square Dipyramid (J15), 13 : Elongated Pentagonal Dipyramid (J16), 14 : Elongated Pentagonal Cupola (J20)
   * * size the size of the IcoSphere, optional default 1
   * * sizeX allows stretching in the x direction, optional, default size
   * * sizeY allows stretching in the y direction, optional, default size
   * * sizeZ allows stretching in the z direction, optional, default size
   * * custom a number that overwrites the type to create from an extended set of polyhedron from https://www.babylonjs-playground.com/#21QRSK#15 with minimised editor
   * * faceUV an array of Vector4 elements used to set different images to the top, rings and bottom respectively
   * * faceColors an array of Color3 elements used to set different colors to the top, rings and bottom respectively
   * * flat when true creates a flat shaded mesh, optional, default true
   * * subdivisions increasing the subdivisions increases the number of faces, optional, default 4
   * * sideOrientation optional and takes the values : Mesh.FRONTSIDE (default), Mesh.BACKSIDE or Mesh.DOUBLESIDE
   * * frontUvs only usable when you create a double-sided mesh, used to choose what parts of the texture image to crop and apply on the front side, optional, default vector4 (0, 0, 1, 1)
   * * backUVs only usable when you create a double-sided mesh, used to choose what parts of the texture image to crop and apply on the back side, optional, default vector4 (0, 0, 1, 1)
   * @returns the VertexData of the Polyhedron
   * @deprecated use CreatePolyhedronVertexData instead
   */
  static CreatePolyhedron(options) {
    throw _WarnImport("polyhedronBuilder");
  }
  /**
   * Creates the VertexData for a Capsule, inspired from https://github.com/maximeq/three-js-capsule-geometry/blob/master/src/CapsuleBufferGeometry.js
   * @param options an object used to set the following optional parameters for the capsule, required but can be empty
   * @returns the VertexData of the Capsule
   * @deprecated Please use CreateCapsuleVertexData from the capsuleBuilder file instead
   */
  static CreateCapsule(options = {
    orientation: Vector3.Up(),
    subdivisions: 2,
    tessellation: 16,
    height: 1,
    radius: 0.25,
    capSubdivisions: 6
  }) {
    throw _WarnImport("capsuleBuilder");
  }
  // based on http://code.google.com/p/away3d/source/browse/trunk/fp10/Away3D/src/away3d/primitives/TorusKnot.as?spec=svn2473&r=2473
  /**
   * Creates the VertexData for a TorusKnot
   * @param options an object used to set the following optional parameters for the TorusKnot, required but can be empty
   * * radius the radius of the torus knot, optional, default 2
   * * tube the thickness of the tube, optional, default 0.5
   * * radialSegments the number of sides on each tube segments, optional, default 32
   * * tubularSegments the number of tubes to decompose the knot into, optional, default 32
   * * p the number of windings around the z axis, optional,  default 2
   * * q the number of windings around the x axis, optional,  default 3
   * * sideOrientation optional and takes the values : Mesh.FRONTSIDE (default), Mesh.BACKSIDE or Mesh.DOUBLESIDE
   * * frontUvs only usable when you create a double-sided mesh, used to choose what parts of the texture image to crop and apply on the front side, optional, default vector4 (0, 0, 1, 1)
   * * backUVs only usable when you create a double-sided mesh, used to choose what parts of the texture image to crop and apply on the back side, optional, default vector4 (0, 0, 1, 1)
   * @returns the VertexData of the Torus Knot
   * @deprecated use CreateTorusKnotVertexData instead
   */
  static CreateTorusKnot(options) {
    throw _WarnImport("torusKnotBuilder");
  }
  // Tools
  /**
   * Compute normals for given positions and indices
   * @param positions an array of vertex positions, [...., x, y, z, ......]
   * @param indices an array of indices in groups of three for each triangular facet, [...., i, j, k, ......]
   * @param normals an array of vertex normals, [...., x, y, z, ......]
   * @param options an object used to set the following optional parameters for the TorusKnot, optional
   * * facetNormals : optional array of facet normals (vector3)
   * * facetPositions : optional array of facet positions (vector3)
   * * facetPartitioning : optional partitioning array. facetPositions is required for facetPartitioning computation
   * * ratio : optional partitioning ratio / bounding box, required for facetPartitioning computation
   * * bInfo : optional bounding info, required for facetPartitioning computation
   * * bbSize : optional bounding box size data, required for facetPartitioning computation
   * * subDiv : optional partitioning data about subdivisions on  each axis (int), required for facetPartitioning computation
   * * useRightHandedSystem: optional boolean to for right handed system computation
   * * depthSort : optional boolean to enable the facet depth sort computation
   * * distanceTo : optional Vector3 to compute the facet depth from this location
   * * depthSortedFacets : optional array of depthSortedFacets to store the facet distances from the reference location
   */
  static ComputeNormals(positions, indices, normals, options) {
    let index2 = 0;
    let p1p2x = 0;
    let p1p2y = 0;
    let p1p2z = 0;
    let p3p2x = 0;
    let p3p2y = 0;
    let p3p2z = 0;
    let faceNormalx = 0;
    let faceNormaly = 0;
    let faceNormalz = 0;
    let length = 0;
    let v1x = 0;
    let v1y = 0;
    let v1z = 0;
    let v2x = 0;
    let v2y = 0;
    let v2z = 0;
    let v3x = 0;
    let v3y = 0;
    let v3z = 0;
    let computeFacetNormals = false;
    let computeFacetPositions = false;
    let computeFacetPartitioning = false;
    let computeDepthSort = false;
    let faceNormalSign = 1;
    let ratio = 0;
    let distanceTo = null;
    if (options) {
      computeFacetNormals = options.facetNormals ? true : false;
      computeFacetPositions = options.facetPositions ? true : false;
      computeFacetPartitioning = options.facetPartitioning ? true : false;
      faceNormalSign = options.useRightHandedSystem === true ? -1 : 1;
      ratio = options.ratio || 0;
      computeDepthSort = options.depthSort ? true : false;
      distanceTo = options.distanceTo;
      if (computeDepthSort) {
        if (distanceTo === void 0) {
          distanceTo = Vector3.Zero();
        }
      }
    }
    let xSubRatio = 0;
    let ySubRatio = 0;
    let zSubRatio = 0;
    let subSq = 0;
    if (computeFacetPartitioning && options && options.bbSize) {
      xSubRatio = options.subDiv.X * ratio / options.bbSize.x;
      ySubRatio = options.subDiv.Y * ratio / options.bbSize.y;
      zSubRatio = options.subDiv.Z * ratio / options.bbSize.z;
      subSq = options.subDiv.max * options.subDiv.max;
      options.facetPartitioning.length = 0;
    }
    for (index2 = 0; index2 < positions.length; index2++) {
      normals[index2] = 0;
    }
    const nbFaces = indices.length / 3 | 0;
    for (index2 = 0; index2 < nbFaces; index2++) {
      v1x = indices[index2 * 3] * 3;
      v1y = v1x + 1;
      v1z = v1x + 2;
      v2x = indices[index2 * 3 + 1] * 3;
      v2y = v2x + 1;
      v2z = v2x + 2;
      v3x = indices[index2 * 3 + 2] * 3;
      v3y = v3x + 1;
      v3z = v3x + 2;
      p1p2x = positions[v1x] - positions[v2x];
      p1p2y = positions[v1y] - positions[v2y];
      p1p2z = positions[v1z] - positions[v2z];
      p3p2x = positions[v3x] - positions[v2x];
      p3p2y = positions[v3y] - positions[v2y];
      p3p2z = positions[v3z] - positions[v2z];
      faceNormalx = faceNormalSign * (p1p2y * p3p2z - p1p2z * p3p2y);
      faceNormaly = faceNormalSign * (p1p2z * p3p2x - p1p2x * p3p2z);
      faceNormalz = faceNormalSign * (p1p2x * p3p2y - p1p2y * p3p2x);
      length = Math.sqrt(faceNormalx * faceNormalx + faceNormaly * faceNormaly + faceNormalz * faceNormalz);
      length = length === 0 ? 1 : length;
      faceNormalx /= length;
      faceNormaly /= length;
      faceNormalz /= length;
      if (computeFacetNormals && options) {
        options.facetNormals[index2].x = faceNormalx;
        options.facetNormals[index2].y = faceNormaly;
        options.facetNormals[index2].z = faceNormalz;
      }
      if (computeFacetPositions && options) {
        options.facetPositions[index2].x = (positions[v1x] + positions[v2x] + positions[v3x]) / 3;
        options.facetPositions[index2].y = (positions[v1y] + positions[v2y] + positions[v3y]) / 3;
        options.facetPositions[index2].z = (positions[v1z] + positions[v2z] + positions[v3z]) / 3;
      }
      if (computeFacetPartitioning && options) {
        const ox = Math.floor((options.facetPositions[index2].x - options.bInfo.minimum.x * ratio) * xSubRatio);
        const oy = Math.floor((options.facetPositions[index2].y - options.bInfo.minimum.y * ratio) * ySubRatio);
        const oz = Math.floor((options.facetPositions[index2].z - options.bInfo.minimum.z * ratio) * zSubRatio);
        const b1x = Math.floor((positions[v1x] - options.bInfo.minimum.x * ratio) * xSubRatio);
        const b1y = Math.floor((positions[v1y] - options.bInfo.minimum.y * ratio) * ySubRatio);
        const b1z = Math.floor((positions[v1z] - options.bInfo.minimum.z * ratio) * zSubRatio);
        const b2x = Math.floor((positions[v2x] - options.bInfo.minimum.x * ratio) * xSubRatio);
        const b2y = Math.floor((positions[v2y] - options.bInfo.minimum.y * ratio) * ySubRatio);
        const b2z = Math.floor((positions[v2z] - options.bInfo.minimum.z * ratio) * zSubRatio);
        const b3x = Math.floor((positions[v3x] - options.bInfo.minimum.x * ratio) * xSubRatio);
        const b3y = Math.floor((positions[v3y] - options.bInfo.minimum.y * ratio) * ySubRatio);
        const b3z = Math.floor((positions[v3z] - options.bInfo.minimum.z * ratio) * zSubRatio);
        const block_idx_v1 = b1x + options.subDiv.max * b1y + subSq * b1z;
        const block_idx_v2 = b2x + options.subDiv.max * b2y + subSq * b2z;
        const block_idx_v3 = b3x + options.subDiv.max * b3y + subSq * b3z;
        const block_idx_o = ox + options.subDiv.max * oy + subSq * oz;
        options.facetPartitioning[block_idx_o] = options.facetPartitioning[block_idx_o] ? options.facetPartitioning[block_idx_o] : new Array();
        options.facetPartitioning[block_idx_v1] = options.facetPartitioning[block_idx_v1] ? options.facetPartitioning[block_idx_v1] : new Array();
        options.facetPartitioning[block_idx_v2] = options.facetPartitioning[block_idx_v2] ? options.facetPartitioning[block_idx_v2] : new Array();
        options.facetPartitioning[block_idx_v3] = options.facetPartitioning[block_idx_v3] ? options.facetPartitioning[block_idx_v3] : new Array();
        options.facetPartitioning[block_idx_v1].push(index2);
        if (block_idx_v2 != block_idx_v1) {
          options.facetPartitioning[block_idx_v2].push(index2);
        }
        if (!(block_idx_v3 == block_idx_v2 || block_idx_v3 == block_idx_v1)) {
          options.facetPartitioning[block_idx_v3].push(index2);
        }
        if (!(block_idx_o == block_idx_v1 || block_idx_o == block_idx_v2 || block_idx_o == block_idx_v3)) {
          options.facetPartitioning[block_idx_o].push(index2);
        }
      }
      if (computeDepthSort && options && options.facetPositions) {
        const dsf = options.depthSortedFacets[index2];
        dsf.ind = index2 * 3;
        dsf.sqDistance = Vector3.DistanceSquared(options.facetPositions[index2], distanceTo);
      }
      normals[v1x] += faceNormalx;
      normals[v1y] += faceNormaly;
      normals[v1z] += faceNormalz;
      normals[v2x] += faceNormalx;
      normals[v2y] += faceNormaly;
      normals[v2z] += faceNormalz;
      normals[v3x] += faceNormalx;
      normals[v3y] += faceNormaly;
      normals[v3z] += faceNormalz;
    }
    for (index2 = 0; index2 < normals.length / 3; index2++) {
      faceNormalx = normals[index2 * 3];
      faceNormaly = normals[index2 * 3 + 1];
      faceNormalz = normals[index2 * 3 + 2];
      length = Math.sqrt(faceNormalx * faceNormalx + faceNormaly * faceNormaly + faceNormalz * faceNormalz);
      length = length === 0 ? 1 : length;
      faceNormalx /= length;
      faceNormaly /= length;
      faceNormalz /= length;
      normals[index2 * 3] = faceNormalx;
      normals[index2 * 3 + 1] = faceNormaly;
      normals[index2 * 3 + 2] = faceNormalz;
    }
  }
  /**
   * @internal
   */
  static _ComputeSides(sideOrientation, positions, indices, normals, uvs, frontUVs, backUVs) {
    const li = indices.length;
    const ln = normals.length;
    let i2;
    let n3;
    sideOrientation = sideOrientation || VertexData.DEFAULTSIDE;
    switch (sideOrientation) {
      case VertexData.FRONTSIDE:
        break;
      case VertexData.BACKSIDE:
        for (i2 = 0; i2 < li; i2 += 3) {
          const tmp = indices[i2];
          indices[i2] = indices[i2 + 2];
          indices[i2 + 2] = tmp;
        }
        for (n3 = 0; n3 < ln; n3++) {
          normals[n3] = -normals[n3];
        }
        break;
      case VertexData.DOUBLESIDE: {
        const lp = positions.length;
        const l2 = lp / 3;
        for (let p2 = 0; p2 < lp; p2++) {
          positions[lp + p2] = positions[p2];
        }
        for (i2 = 0; i2 < li; i2 += 3) {
          indices[i2 + li] = indices[i2 + 2] + l2;
          indices[i2 + 1 + li] = indices[i2 + 1] + l2;
          indices[i2 + 2 + li] = indices[i2] + l2;
        }
        for (n3 = 0; n3 < ln; n3++) {
          normals[ln + n3] = -normals[n3];
        }
        const lu = uvs.length;
        let u2 = 0;
        for (u2 = 0; u2 < lu; u2++) {
          uvs[u2 + lu] = uvs[u2];
        }
        frontUVs = frontUVs ? frontUVs : new Vector4(0, 0, 1, 1);
        backUVs = backUVs ? backUVs : new Vector4(0, 0, 1, 1);
        u2 = 0;
        for (i2 = 0; i2 < lu / 2; i2++) {
          uvs[u2] = frontUVs.x + (frontUVs.z - frontUVs.x) * uvs[u2];
          uvs[u2 + 1] = frontUVs.y + (frontUVs.w - frontUVs.y) * uvs[u2 + 1];
          uvs[u2 + lu] = backUVs.x + (backUVs.z - backUVs.x) * uvs[u2 + lu];
          uvs[u2 + lu + 1] = backUVs.y + (backUVs.w - backUVs.y) * uvs[u2 + lu + 1];
          u2 += 2;
        }
        break;
      }
    }
  }
  /**
   * Creates a VertexData from serialized data
   * @param parsedVertexData the parsed data from an imported file
   * @returns a VertexData
   */
  static Parse(parsedVertexData) {
    const vertexData = new VertexData();
    const positions = parsedVertexData.positions;
    if (positions) {
      vertexData.set(positions, VertexBuffer.PositionKind);
    }
    const normals = parsedVertexData.normals;
    if (normals) {
      vertexData.set(normals, VertexBuffer.NormalKind);
    }
    const tangents = parsedVertexData.tangents;
    if (tangents) {
      vertexData.set(tangents, VertexBuffer.TangentKind);
    }
    const uvs = parsedVertexData.uvs;
    if (uvs) {
      vertexData.set(uvs, VertexBuffer.UVKind);
    }
    const uvs2 = parsedVertexData.uvs2;
    if (uvs2) {
      vertexData.set(uvs2, VertexBuffer.UV2Kind);
    }
    const uvs3 = parsedVertexData.uvs3;
    if (uvs3) {
      vertexData.set(uvs3, VertexBuffer.UV3Kind);
    }
    const uvs4 = parsedVertexData.uvs4;
    if (uvs4) {
      vertexData.set(uvs4, VertexBuffer.UV4Kind);
    }
    const uvs5 = parsedVertexData.uvs5;
    if (uvs5) {
      vertexData.set(uvs5, VertexBuffer.UV5Kind);
    }
    const uvs6 = parsedVertexData.uvs6;
    if (uvs6) {
      vertexData.set(uvs6, VertexBuffer.UV6Kind);
    }
    const colors = parsedVertexData.colors;
    if (colors) {
      vertexData.set(Color4.CheckColors4(colors, positions.length / 3), VertexBuffer.ColorKind);
      if (parsedVertexData.hasVertexAlpha !== void 0) {
        vertexData.hasVertexAlpha = parsedVertexData.hasVertexAlpha;
      }
    }
    const matricesIndices = parsedVertexData.matricesIndices;
    if (matricesIndices) {
      vertexData.set(matricesIndices, VertexBuffer.MatricesIndicesKind);
    }
    const matricesWeights = parsedVertexData.matricesWeights;
    if (matricesWeights) {
      vertexData.set(matricesWeights, VertexBuffer.MatricesWeightsKind);
    }
    const indices = parsedVertexData.indices;
    if (indices) {
      vertexData.indices = indices;
    }
    const materialInfos = parsedVertexData.materialInfos;
    if (materialInfos) {
      vertexData.materialInfos = [];
      for (const materialInfoFromJSON of materialInfos) {
        const materialInfo = new VertexDataMaterialInfo();
        materialInfo.indexCount = materialInfoFromJSON.indexCount;
        materialInfo.indexStart = materialInfoFromJSON.indexStart;
        materialInfo.verticesCount = materialInfoFromJSON.verticesCount;
        materialInfo.verticesStart = materialInfoFromJSON.verticesStart;
        materialInfo.materialIndex = materialInfoFromJSON.materialIndex;
        vertexData.materialInfos.push(materialInfo);
      }
    }
    return vertexData;
  }
  /**
   * Applies VertexData created from the imported parameters to the geometry
   * @param parsedVertexData the parsed data from an imported file
   * @param geometry the geometry to apply the VertexData to
   */
  static ImportVertexData(parsedVertexData, geometry) {
    const vertexData = VertexData.Parse(parsedVertexData);
    geometry.setAllVerticesData(vertexData, parsedVertexData.updatable);
  }
}
VertexData.FRONTSIDE = 0;
VertexData.BACKSIDE = 1;
VertexData.DOUBLESIDE = 2;
VertexData.DEFAULTSIDE = 0;
VertexData._UniqueIDGenerator = 0;
__decorate([
  nativeOverride.filter((...[coordinates]) => !Array.isArray(coordinates))
], VertexData, "_TransformVector3Coordinates", null);
__decorate([
  nativeOverride.filter((...[normals]) => !Array.isArray(normals))
], VertexData, "_TransformVector3Normals", null);
__decorate([
  nativeOverride.filter((...[normals]) => !Array.isArray(normals))
], VertexData, "_TransformVector4Normals", null);
__decorate([
  nativeOverride.filter((...[indices]) => !Array.isArray(indices))
], VertexData, "_FlipFaces", null);
class SceneLoaderFlags {
  /**
   * Gets or sets a boolean indicating if entire scene must be loaded even if scene contains incremental data
   */
  static get ForceFullSceneLoadingForIncremental() {
    return SceneLoaderFlags._ForceFullSceneLoadingForIncremental;
  }
  static set ForceFullSceneLoadingForIncremental(value) {
    SceneLoaderFlags._ForceFullSceneLoadingForIncremental = value;
  }
  /**
   * Gets or sets a boolean indicating if loading screen must be displayed while loading a scene
   */
  static get ShowLoadingScreen() {
    return SceneLoaderFlags._ShowLoadingScreen;
  }
  static set ShowLoadingScreen(value) {
    SceneLoaderFlags._ShowLoadingScreen = value;
  }
  /**
   * Defines the current logging level (while loading the scene)
   * @ignorenaming
   */
  // eslint-disable-next-line @typescript-eslint/naming-convention
  static get loggingLevel() {
    return SceneLoaderFlags._LoggingLevel;
  }
  // eslint-disable-next-line @typescript-eslint/naming-convention
  static set loggingLevel(value) {
    SceneLoaderFlags._LoggingLevel = value;
  }
  /**
   * Gets or set a boolean indicating if matrix weights must be cleaned upon loading
   */
  static get CleanBoneMatrixWeights() {
    return SceneLoaderFlags._CleanBoneMatrixWeights;
  }
  static set CleanBoneMatrixWeights(value) {
    SceneLoaderFlags._CleanBoneMatrixWeights = value;
  }
}
SceneLoaderFlags._ForceFullSceneLoadingForIncremental = false;
SceneLoaderFlags._ShowLoadingScreen = true;
SceneLoaderFlags._CleanBoneMatrixWeights = false;
SceneLoaderFlags._LoggingLevel = 0;
let useOpenGLOrientationForUV = false;
class Geometry {
  /**
   *  Gets or sets the Bias Vector to apply on the bounding elements (box/sphere), the max extend is computed as v += v * bias.x + bias.y, the min is computed as v -= v * bias.x + bias.y
   */
  get boundingBias() {
    return this._boundingBias;
  }
  /**
   *  Gets or sets the Bias Vector to apply on the bounding elements (box/sphere), the max extend is computed as v += v * bias.x + bias.y, the min is computed as v -= v * bias.x + bias.y
   */
  set boundingBias(value) {
    if (this._boundingBias) {
      this._boundingBias.copyFrom(value);
    } else {
      this._boundingBias = value.clone();
    }
    this._updateBoundingInfo(true, null);
  }
  /**
   * Static function used to attach a new empty geometry to a mesh
   * @param mesh defines the mesh to attach the geometry to
   * @returns the new Geometry
   */
  static CreateGeometryForMesh(mesh) {
    const geometry = new Geometry(Geometry.RandomId(), mesh.getScene());
    geometry.applyToMesh(mesh);
    return geometry;
  }
  /** Get the list of meshes using this geometry */
  get meshes() {
    return this._meshes;
  }
  /**
   * Creates a new geometry
   * @param id defines the unique ID
   * @param scene defines the hosting scene
   * @param vertexData defines the VertexData used to get geometry data
   * @param updatable defines if geometry must be updatable (false by default)
   * @param mesh defines the mesh that will be associated with the geometry
   */
  constructor(id, scene, vertexData, updatable = false, mesh = null) {
    this.delayLoadState = 0;
    this._totalVertices = 0;
    this._isDisposed = false;
    this._extend = {
      minimum: new Vector3(-Number.MAX_VALUE, -Number.MAX_VALUE, -Number.MAX_VALUE),
      maximum: new Vector3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE)
    };
    this._indexBufferIsUpdatable = false;
    this._positionsCache = [];
    this._parentContainer = null;
    this.useBoundingInfoFromGeometry = false;
    this._scene = scene || EngineStore.LastCreatedScene;
    if (!this._scene) {
      return;
    }
    this.id = id;
    this.uniqueId = this._scene.getUniqueId();
    this._engine = this._scene.getEngine();
    this._meshes = [];
    this._vertexBuffers = {};
    this._indices = [];
    this._updatable = updatable;
    if (vertexData) {
      this.setAllVerticesData(vertexData, updatable);
    } else {
      this._totalVertices = 0;
    }
    if (this._engine.getCaps().vertexArrayObject) {
      this._vertexArrayObjects = {};
    }
    if (mesh) {
      this.applyToMesh(mesh);
      mesh.computeWorldMatrix(true);
    }
  }
  /**
   * Gets the current extend of the geometry
   */
  get extend() {
    return this._extend;
  }
  /**
   * Gets the hosting scene
   * @returns the hosting Scene
   */
  getScene() {
    return this._scene;
  }
  /**
   * Gets the hosting engine
   * @returns the hosting Engine
   */
  getEngine() {
    return this._engine;
  }
  /**
   * Defines if the geometry is ready to use
   * @returns true if the geometry is ready to be used
   */
  isReady() {
    return this.delayLoadState === 1 || this.delayLoadState === 0;
  }
  /**
   * Gets a value indicating that the geometry should not be serialized
   */
  get doNotSerialize() {
    for (let index2 = 0; index2 < this._meshes.length; index2++) {
      if (!this._meshes[index2].doNotSerialize) {
        return false;
      }
    }
    return true;
  }
  /** @internal */
  _rebuild() {
    if (this._vertexArrayObjects) {
      this._vertexArrayObjects = {};
    }
    if (this._meshes.length !== 0 && this._indices) {
      this._indexBuffer = this._engine.createIndexBuffer(this._indices, this._updatable, "Geometry_" + this.id + "_IndexBuffer");
    }
    const buffers = /* @__PURE__ */ new Set();
    for (const key in this._vertexBuffers) {
      buffers.add(this._vertexBuffers[key].getWrapperBuffer());
    }
    buffers.forEach((buffer) => {
      buffer._rebuild();
    });
  }
  /**
   * Affects all geometry data in one call
   * @param vertexData defines the geometry data
   * @param updatable defines if the geometry must be flagged as updatable (false as default)
   */
  setAllVerticesData(vertexData, updatable) {
    vertexData.applyToGeometry(this, updatable);
    this._notifyUpdate();
  }
  /**
   * Set specific vertex data
   * @param kind defines the data kind (Position, normal, etc...)
   * @param data defines the vertex data to use
   * @param updatable defines if the vertex must be flagged as updatable (false as default)
   * @param stride defines the stride to use (0 by default). This value is deduced from the kind value if not specified
   */
  setVerticesData(kind, data, updatable = false, stride) {
    if (updatable && Array.isArray(data)) {
      data = new Float32Array(data);
    }
    const buffer = new VertexBuffer(this._engine, data, kind, {
      updatable,
      postponeInternalCreation: this._meshes.length === 0,
      stride,
      label: "Geometry_" + this.id + "_" + kind
    });
    this.setVerticesBuffer(buffer);
  }
  /**
   * Removes a specific vertex data
   * @param kind defines the data kind (Position, normal, etc...)
   */
  removeVerticesData(kind) {
    if (this._vertexBuffers[kind]) {
      this._vertexBuffers[kind].dispose();
      delete this._vertexBuffers[kind];
    }
    if (this._vertexArrayObjects) {
      this._disposeVertexArrayObjects();
    }
  }
  /**
   * Affect a vertex buffer to the geometry. the vertexBuffer.getKind() function is used to determine where to store the data
   * @param buffer defines the vertex buffer to use
   * @param totalVertices defines the total number of vertices for position kind (could be null)
   * @param disposeExistingBuffer disposes the existing buffer, if any (default: true)
   */
  setVerticesBuffer(buffer, totalVertices = null, disposeExistingBuffer = true) {
    const kind = buffer.getKind();
    if (this._vertexBuffers[kind] && disposeExistingBuffer) {
      this._vertexBuffers[kind].dispose();
    }
    if (buffer._buffer) {
      buffer._buffer._increaseReferences();
    }
    this._vertexBuffers[kind] = buffer;
    const meshes = this._meshes;
    const numOfMeshes = meshes.length;
    if (kind === VertexBuffer.PositionKind) {
      this._totalVertices = totalVertices ?? buffer._maxVerticesCount;
      this._updateExtend(buffer.getFloatData(this._totalVertices));
      this._resetPointsArrayCache();
      const minimum = this._extend && this._extend.minimum || new Vector3(-Number.MAX_VALUE, -Number.MAX_VALUE, -Number.MAX_VALUE);
      const maximum = this._extend && this._extend.maximum || new Vector3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE);
      for (let index2 = 0; index2 < numOfMeshes; index2++) {
        const mesh = meshes[index2];
        mesh.buildBoundingInfo(minimum, maximum);
        mesh._createGlobalSubMesh(mesh.isUnIndexed);
        mesh.computeWorldMatrix(true);
        mesh.synchronizeInstances();
      }
    }
    this._notifyUpdate(kind);
  }
  /**
   * Update a specific vertex buffer
   * This function will directly update the underlying DataBuffer according to the passed numeric array or Float32Array
   * It will do nothing if the buffer is not updatable
   * @param kind defines the data kind (Position, normal, etc...)
   * @param data defines the data to use
   * @param offset defines the offset in the target buffer where to store the data
   * @param useBytes set to true if the offset is in bytes
   */
  updateVerticesDataDirectly(kind, data, offset, useBytes = false) {
    const vertexBuffer = this.getVertexBuffer(kind);
    if (!vertexBuffer) {
      return;
    }
    vertexBuffer.updateDirectly(data, offset, useBytes);
    this._notifyUpdate(kind);
  }
  /**
   * Update a specific vertex buffer
   * This function will create a new buffer if the current one is not updatable
   * @param kind defines the data kind (Position, normal, etc...)
   * @param data defines the data to use
   * @param updateExtends defines if the geometry extends must be recomputed (false by default)
   */
  updateVerticesData(kind, data, updateExtends = false) {
    const vertexBuffer = this.getVertexBuffer(kind);
    if (!vertexBuffer) {
      return;
    }
    vertexBuffer.update(data);
    if (kind === VertexBuffer.PositionKind) {
      this._updateBoundingInfo(updateExtends, data);
    }
    this._notifyUpdate(kind);
  }
  _updateBoundingInfo(updateExtends, data) {
    if (updateExtends) {
      this._updateExtend(data);
    }
    this._resetPointsArrayCache();
    if (updateExtends) {
      const meshes = this._meshes;
      for (const mesh of meshes) {
        if (mesh.hasBoundingInfo) {
          mesh.getBoundingInfo().reConstruct(this._extend.minimum, this._extend.maximum);
        } else {
          mesh.buildBoundingInfo(this._extend.minimum, this._extend.maximum);
        }
        const subMeshes = mesh.subMeshes;
        for (const subMesh of subMeshes) {
          subMesh.refreshBoundingInfo();
        }
      }
    }
  }
  /**
   * @internal
   */
  _bind(effect, indexToBind, overrideVertexBuffers, overrideVertexArrayObjects) {
    if (!effect) {
      return;
    }
    if (indexToBind === void 0) {
      indexToBind = this._indexBuffer;
    }
    const vbs = this.getVertexBuffers();
    if (!vbs) {
      return;
    }
    if (indexToBind != this._indexBuffer || !this._vertexArrayObjects && !overrideVertexArrayObjects) {
      this._engine.bindBuffers(vbs, indexToBind, effect, overrideVertexBuffers);
      return;
    }
    const vaos = overrideVertexArrayObjects ? overrideVertexArrayObjects : this._vertexArrayObjects;
    const engine2 = this._engine;
    if (!vaos[effect.key]) {
      vaos[effect.key] = engine2.recordVertexArrayObject(vbs, indexToBind, effect, overrideVertexBuffers);
    }
    engine2.bindVertexArrayObject(vaos[effect.key], indexToBind);
  }
  /**
   * Gets total number of vertices
   * @returns the total number of vertices
   */
  getTotalVertices() {
    if (!this.isReady()) {
      return 0;
    }
    return this._totalVertices;
  }
  /**
   * Gets a specific vertex data attached to this geometry. Float data is constructed if the vertex buffer data cannot be returned directly.
   * @param kind defines the data kind (Position, normal, etc...)
   * @param copyWhenShared defines if the returned array must be cloned upon returning it if the current geometry is shared between multiple meshes
   * @param forceCopy defines a boolean indicating that the returned array must be cloned upon returning it
   * @returns a float array containing vertex data
   */
  getVerticesData(kind, copyWhenShared, forceCopy) {
    const vertexBuffer = this.getVertexBuffer(kind);
    if (!vertexBuffer) {
      return null;
    }
    return vertexBuffer.getFloatData(this._totalVertices, forceCopy || copyWhenShared && this._meshes.length !== 1);
  }
  /**
   * Copies the requested vertex data kind into the given vertex data map. Float data is constructed if the map doesn't have the data.
   * @param kind defines the data kind (Position, normal, etc...)
   * @param vertexData defines the map that stores the resulting data
   */
  copyVerticesData(kind, vertexData) {
    const vertexBuffer = this.getVertexBuffer(kind);
    if (!vertexBuffer) {
      return;
    }
    vertexData[kind] || (vertexData[kind] = new Float32Array(this._totalVertices * vertexBuffer.getSize()));
    const data = vertexBuffer.getData();
    if (data) {
      CopyFloatData(data, vertexBuffer.getSize(), vertexBuffer.type, vertexBuffer.byteOffset, vertexBuffer.byteStride, vertexBuffer.normalized, this._totalVertices, vertexData[kind]);
    }
  }
  /**
   * Returns a boolean defining if the vertex data for the requested `kind` is updatable
   * @param kind defines the data kind (Position, normal, etc...)
   * @returns true if the vertex buffer with the specified kind is updatable
   */
  isVertexBufferUpdatable(kind) {
    const vb = this._vertexBuffers[kind];
    if (!vb) {
      return false;
    }
    return vb.isUpdatable();
  }
  /**
   * Gets a specific vertex buffer
   * @param kind defines the data kind (Position, normal, etc...)
   * @returns a VertexBuffer
   */
  getVertexBuffer(kind) {
    if (!this.isReady()) {
      return null;
    }
    return this._vertexBuffers[kind];
  }
  /**
   * Returns all vertex buffers
   * @returns an object holding all vertex buffers indexed by kind
   */
  getVertexBuffers() {
    if (!this.isReady()) {
      return null;
    }
    return this._vertexBuffers;
  }
  /**
   * Gets a boolean indicating if specific vertex buffer is present
   * @param kind defines the data kind (Position, normal, etc...)
   * @returns true if data is present
   */
  isVerticesDataPresent(kind) {
    if (!this._vertexBuffers) {
      if (this._delayInfo) {
        return this._delayInfo.indexOf(kind) !== -1;
      }
      return false;
    }
    return this._vertexBuffers[kind] !== void 0;
  }
  /**
   * Gets a list of all attached data kinds (Position, normal, etc...)
   * @returns a list of string containing all kinds
   */
  getVerticesDataKinds() {
    const result = [];
    let kind;
    if (!this._vertexBuffers && this._delayInfo) {
      for (kind in this._delayInfo) {
        result.push(kind);
      }
    } else {
      for (kind in this._vertexBuffers) {
        result.push(kind);
      }
    }
    return result;
  }
  /**
   * Update index buffer
   * @param indices defines the indices to store in the index buffer
   * @param offset defines the offset in the target buffer where to store the data
   * @param gpuMemoryOnly defines a boolean indicating that only the GPU memory must be updated leaving the CPU version of the indices unchanged (false by default)
   */
  updateIndices(indices, offset, gpuMemoryOnly = false) {
    if (!this._indexBuffer) {
      return;
    }
    if (!this._indexBufferIsUpdatable) {
      this.setIndices(indices, null, true);
    } else {
      const needToUpdateSubMeshes = indices.length !== this._indices.length;
      if (!gpuMemoryOnly) {
        this._indices = indices.slice();
      }
      this._engine.updateDynamicIndexBuffer(this._indexBuffer, indices, offset);
      if (needToUpdateSubMeshes) {
        for (const mesh of this._meshes) {
          mesh._createGlobalSubMesh(true);
        }
      }
    }
  }
  /**
   * Sets the index buffer for this geometry.
   * @param indexBuffer Defines the index buffer to use for this geometry
   * @param totalVertices Defines the total number of vertices used by the buffer
   * @param totalIndices Defines the total number of indices in the index buffer
   * @param is32Bits Defines if the indices are 32 bits. If null (default), the value is guessed from the number of vertices
   */
  setIndexBuffer(indexBuffer, totalVertices, totalIndices, is32Bits = null) {
    this._indices = [];
    this._indexBufferIsUpdatable = false;
    this._indexBuffer = indexBuffer;
    this._totalVertices = totalVertices;
    this._totalIndices = totalIndices;
    if (is32Bits === null) {
      indexBuffer.is32Bits = totalVertices > 65535;
    } else {
      indexBuffer.is32Bits = is32Bits;
    }
    for (const mesh of this._meshes) {
      mesh._createGlobalSubMesh(true);
      mesh.synchronizeInstances();
    }
    this._notifyUpdate();
  }
  /**
   * Creates a new index buffer
   * @param indices defines the indices to store in the index buffer
   * @param totalVertices defines the total number of vertices (could be null)
   * @param updatable defines if the index buffer must be flagged as updatable (false by default)
   * @param dontForceSubMeshRecreation defines a boolean indicating that we don't want to force the recreation of sub-meshes if we don't have to (false by default)
   */
  setIndices(indices, totalVertices = null, updatable = false, dontForceSubMeshRecreation = false) {
    if (this._indexBuffer) {
      this._engine._releaseBuffer(this._indexBuffer);
    }
    this._indices = indices;
    this._indexBufferIsUpdatable = updatable;
    if (this._meshes.length !== 0 && this._indices) {
      this._indexBuffer = this._engine.createIndexBuffer(this._indices, updatable, "Geometry_" + this.id + "_IndexBuffer");
    }
    if (totalVertices != void 0) {
      this._totalVertices = totalVertices;
    }
    for (const mesh of this._meshes) {
      mesh._createGlobalSubMesh(!dontForceSubMeshRecreation);
      mesh.synchronizeInstances();
    }
    this._notifyUpdate();
  }
  /**
   * Return the total number of indices
   * @returns the total number of indices
   */
  getTotalIndices() {
    if (!this.isReady()) {
      return 0;
    }
    return this._totalIndices !== void 0 ? this._totalIndices : this._indices.length;
  }
  /**
   * Gets the index buffer array
   * @param copyWhenShared defines if the returned array must be cloned upon returning it if the current geometry is shared between multiple meshes
   * @param forceCopy defines a boolean indicating that the returned array must be cloned upon returning it
   * @returns the index buffer array
   */
  getIndices(copyWhenShared, forceCopy) {
    if (!this.isReady()) {
      return null;
    }
    const orig = this._indices;
    if (!forceCopy && (!copyWhenShared || this._meshes.length === 1)) {
      return orig;
    } else {
      return orig.slice();
    }
  }
  /**
   * Gets the index buffer
   * @returns the index buffer
   */
  getIndexBuffer() {
    if (!this.isReady()) {
      return null;
    }
    return this._indexBuffer;
  }
  /**
   * @internal
   */
  _releaseVertexArrayObject(effect = null) {
    if (!effect || !this._vertexArrayObjects) {
      return;
    }
    if (this._vertexArrayObjects[effect.key]) {
      this._engine.releaseVertexArrayObject(this._vertexArrayObjects[effect.key]);
      delete this._vertexArrayObjects[effect.key];
    }
  }
  /**
   * Release the associated resources for a specific mesh
   * @param mesh defines the source mesh
   * @param shouldDispose defines if the geometry must be disposed if there is no more mesh pointing to it
   */
  releaseForMesh(mesh, shouldDispose) {
    const meshes = this._meshes;
    const index2 = meshes.indexOf(mesh);
    if (index2 === -1) {
      return;
    }
    meshes.splice(index2, 1);
    if (this._vertexArrayObjects) {
      mesh._invalidateInstanceVertexArrayObject();
    }
    mesh._geometry = null;
    if (meshes.length === 0 && shouldDispose) {
      this.dispose();
    }
  }
  /**
   * Apply current geometry to a given mesh
   * @param mesh defines the mesh to apply geometry to
   */
  applyToMesh(mesh) {
    if (mesh._geometry === this) {
      return;
    }
    const previousGeometry = mesh._geometry;
    if (previousGeometry) {
      previousGeometry.releaseForMesh(mesh);
    }
    if (this._vertexArrayObjects) {
      mesh._invalidateInstanceVertexArrayObject();
    }
    const meshes = this._meshes;
    mesh._geometry = this;
    mesh._internalAbstractMeshDataInfo._positions = null;
    this._scene.pushGeometry(this);
    meshes.push(mesh);
    if (this.isReady()) {
      this._applyToMesh(mesh);
    } else if (this._boundingInfo) {
      mesh.setBoundingInfo(this._boundingInfo);
    }
  }
  _updateExtend(data = null) {
    if (this.useBoundingInfoFromGeometry && this._boundingInfo) {
      this._extend = {
        minimum: this._boundingInfo.minimum.clone(),
        maximum: this._boundingInfo.maximum.clone()
      };
    } else {
      if (!data) {
        data = this.getVerticesData(VertexBuffer.PositionKind);
        if (!data) {
          return;
        }
      }
      this._extend = extractMinAndMax(data, 0, this._totalVertices, this.boundingBias, 3);
    }
  }
  _applyToMesh(mesh) {
    const numOfMeshes = this._meshes.length;
    for (const kind in this._vertexBuffers) {
      if (numOfMeshes === 1) {
        this._vertexBuffers[kind].create();
      }
      if (kind === VertexBuffer.PositionKind) {
        if (!this._extend) {
          this._updateExtend();
        }
        mesh.buildBoundingInfo(this._extend.minimum, this._extend.maximum);
        mesh._createGlobalSubMesh(mesh.isUnIndexed);
        mesh._updateBoundingInfo();
      }
    }
    if (numOfMeshes === 1 && this._indices && this._indices.length > 0) {
      this._indexBuffer = this._engine.createIndexBuffer(this._indices, this._updatable, "Geometry_" + this.id + "_IndexBuffer");
    }
    mesh._syncGeometryWithMorphTargetManager();
    mesh.synchronizeInstances();
  }
  _notifyUpdate(kind) {
    if (this.onGeometryUpdated) {
      this.onGeometryUpdated(this, kind);
    }
    if (this._vertexArrayObjects) {
      this._disposeVertexArrayObjects();
    }
    for (const mesh of this._meshes) {
      mesh._markSubMeshesAsAttributesDirty();
    }
  }
  /**
   * Load the geometry if it was flagged as delay loaded
   * @param scene defines the hosting scene
   * @param onLoaded defines a callback called when the geometry is loaded
   */
  load(scene, onLoaded) {
    if (this.delayLoadState === 2) {
      return;
    }
    if (this.isReady()) {
      if (onLoaded) {
        onLoaded();
      }
      return;
    }
    this.delayLoadState = 2;
    this._queueLoad(scene, onLoaded);
  }
  _queueLoad(scene, onLoaded) {
    if (!this.delayLoadingFile) {
      return;
    }
    scene.addPendingData(this);
    scene._loadFile(this.delayLoadingFile, (data) => {
      if (!this._delayLoadingFunction) {
        return;
      }
      this._delayLoadingFunction(JSON.parse(data), this);
      this.delayLoadState = 1;
      this._delayInfo = [];
      scene.removePendingData(this);
      const meshes = this._meshes;
      const numOfMeshes = meshes.length;
      for (let index2 = 0; index2 < numOfMeshes; index2++) {
        this._applyToMesh(meshes[index2]);
      }
      if (onLoaded) {
        onLoaded();
      }
    }, void 0, true);
  }
  /**
   * Invert the geometry to move from a right handed system to a left handed one.
   */
  toLeftHanded() {
    const tIndices = this.getIndices(false);
    if (tIndices != null && tIndices.length > 0) {
      for (let i2 = 0; i2 < tIndices.length; i2 += 3) {
        const tTemp = tIndices[i2 + 0];
        tIndices[i2 + 0] = tIndices[i2 + 2];
        tIndices[i2 + 2] = tTemp;
      }
      this.setIndices(tIndices);
    }
    const tPositions = this.getVerticesData(VertexBuffer.PositionKind, false);
    if (tPositions != null && tPositions.length > 0) {
      for (let i2 = 0; i2 < tPositions.length; i2 += 3) {
        tPositions[i2 + 2] = -tPositions[i2 + 2];
      }
      this.setVerticesData(VertexBuffer.PositionKind, tPositions, false);
    }
    const tNormals = this.getVerticesData(VertexBuffer.NormalKind, false);
    if (tNormals != null && tNormals.length > 0) {
      for (let i2 = 0; i2 < tNormals.length; i2 += 3) {
        tNormals[i2 + 2] = -tNormals[i2 + 2];
      }
      this.setVerticesData(VertexBuffer.NormalKind, tNormals, false);
    }
  }
  // Cache
  /** @internal */
  _resetPointsArrayCache() {
    this._positions = null;
  }
  /** @internal */
  _generatePointsArray() {
    if (this._positions) {
      return true;
    }
    const data = this.getVerticesData(VertexBuffer.PositionKind);
    if (!data || data.length === 0) {
      return false;
    }
    for (let index2 = this._positionsCache.length * 3, arrayIdx = this._positionsCache.length; index2 < data.length; index2 += 3, ++arrayIdx) {
      this._positionsCache[arrayIdx] = Vector3.FromArray(data, index2);
    }
    for (let index2 = 0, arrayIdx = 0; index2 < data.length; index2 += 3, ++arrayIdx) {
      this._positionsCache[arrayIdx].set(data[0 + index2], data[1 + index2], data[2 + index2]);
    }
    this._positionsCache.length = data.length / 3;
    this._positions = this._positionsCache;
    return true;
  }
  /**
   * Gets a value indicating if the geometry is disposed
   * @returns true if the geometry was disposed
   */
  isDisposed() {
    return this._isDisposed;
  }
  _disposeVertexArrayObjects() {
    if (this._vertexArrayObjects) {
      for (const kind in this._vertexArrayObjects) {
        this._engine.releaseVertexArrayObject(this._vertexArrayObjects[kind]);
      }
      this._vertexArrayObjects = {};
      const meshes = this._meshes;
      const numOfMeshes = meshes.length;
      for (let index2 = 0; index2 < numOfMeshes; index2++) {
        meshes[index2]._invalidateInstanceVertexArrayObject();
      }
    }
  }
  /**
   * Free all associated resources
   */
  dispose() {
    const meshes = this._meshes;
    const numOfMeshes = meshes.length;
    let index2;
    for (index2 = 0; index2 < numOfMeshes; index2++) {
      this.releaseForMesh(meshes[index2]);
    }
    this._meshes.length = 0;
    this._disposeVertexArrayObjects();
    for (const kind in this._vertexBuffers) {
      this._vertexBuffers[kind].dispose();
    }
    this._vertexBuffers = {};
    this._totalVertices = 0;
    if (this._indexBuffer) {
      this._engine._releaseBuffer(this._indexBuffer);
    }
    this._indexBuffer = null;
    this._indices = [];
    this.delayLoadState = 0;
    this.delayLoadingFile = null;
    this._delayLoadingFunction = null;
    this._delayInfo = [];
    this._boundingInfo = null;
    this._scene.removeGeometry(this);
    if (this._parentContainer) {
      const index3 = this._parentContainer.geometries.indexOf(this);
      if (index3 > -1) {
        this._parentContainer.geometries.splice(index3, 1);
      }
      this._parentContainer = null;
    }
    this._isDisposed = true;
  }
  /**
   * Clone the current geometry into a new geometry
   * @param id defines the unique ID of the new geometry
   * @returns a new geometry object
   */
  copy(id) {
    const vertexData = new VertexData();
    vertexData.indices = [];
    const indices = this.getIndices();
    if (indices) {
      for (let index2 = 0; index2 < indices.length; index2++) {
        vertexData.indices.push(indices[index2]);
      }
    }
    let updatable = false;
    let stopChecking = false;
    let kind;
    for (kind in this._vertexBuffers) {
      const data = this.getVerticesData(kind);
      if (data) {
        if (data instanceof Float32Array) {
          vertexData.set(new Float32Array(data), kind);
        } else {
          vertexData.set(data.slice(0), kind);
        }
        if (!stopChecking) {
          const vb = this.getVertexBuffer(kind);
          if (vb) {
            updatable = vb.isUpdatable();
            stopChecking = !updatable;
          }
        }
      }
    }
    const geometry = new Geometry(id, this._scene, vertexData, updatable);
    geometry.delayLoadState = this.delayLoadState;
    geometry.delayLoadingFile = this.delayLoadingFile;
    geometry._delayLoadingFunction = this._delayLoadingFunction;
    for (kind in this._delayInfo) {
      geometry._delayInfo = geometry._delayInfo || [];
      geometry._delayInfo.push(kind);
    }
    geometry._boundingInfo = new BoundingInfo(this._extend.minimum, this._extend.maximum);
    return geometry;
  }
  /**
   * Serialize the current geometry info (and not the vertices data) into a JSON object
   * @returns a JSON representation of the current geometry data (without the vertices data)
   */
  serialize() {
    const serializationObject = {};
    serializationObject.id = this.id;
    serializationObject.uniqueId = this.uniqueId;
    serializationObject.updatable = this._updatable;
    if (Tags && Tags.HasTags(this)) {
      serializationObject.tags = Tags.GetTags(this);
    }
    return serializationObject;
  }
  _toNumberArray(origin) {
    if (Array.isArray(origin)) {
      return origin;
    } else {
      return Array.prototype.slice.call(origin);
    }
  }
  /**
   * Release any memory retained by the cached data on the Geometry.
   *
   * Call this function to reduce memory footprint of the mesh.
   * Vertex buffers will not store CPU data anymore (this will prevent picking, collisions or physics to work correctly)
   */
  clearCachedData() {
    this._indices = [];
    this._resetPointsArrayCache();
    for (const vbName in this._vertexBuffers) {
      if (!Object.prototype.hasOwnProperty.call(this._vertexBuffers, vbName)) {
        continue;
      }
      this._vertexBuffers[vbName]._buffer._data = null;
    }
  }
  /**
   * Serialize all vertices data into a JSON object
   * @returns a JSON representation of the current geometry data
   */
  serializeVerticeData() {
    const serializationObject = this.serialize();
    if (this.isVerticesDataPresent(VertexBuffer.PositionKind)) {
      serializationObject.positions = this._toNumberArray(this.getVerticesData(VertexBuffer.PositionKind));
      if (this.isVertexBufferUpdatable(VertexBuffer.PositionKind)) {
        serializationObject.positions._updatable = true;
      }
    }
    if (this.isVerticesDataPresent(VertexBuffer.NormalKind)) {
      serializationObject.normals = this._toNumberArray(this.getVerticesData(VertexBuffer.NormalKind));
      if (this.isVertexBufferUpdatable(VertexBuffer.NormalKind)) {
        serializationObject.normals._updatable = true;
      }
    }
    if (this.isVerticesDataPresent(VertexBuffer.TangentKind)) {
      serializationObject.tangents = this._toNumberArray(this.getVerticesData(VertexBuffer.TangentKind));
      if (this.isVertexBufferUpdatable(VertexBuffer.TangentKind)) {
        serializationObject.tangents._updatable = true;
      }
    }
    if (this.isVerticesDataPresent(VertexBuffer.UVKind)) {
      serializationObject.uvs = this._toNumberArray(this.getVerticesData(VertexBuffer.UVKind));
      if (this.isVertexBufferUpdatable(VertexBuffer.UVKind)) {
        serializationObject.uvs._updatable = true;
      }
    }
    if (this.isVerticesDataPresent(VertexBuffer.UV2Kind)) {
      serializationObject.uvs2 = this._toNumberArray(this.getVerticesData(VertexBuffer.UV2Kind));
      if (this.isVertexBufferUpdatable(VertexBuffer.UV2Kind)) {
        serializationObject.uvs2._updatable = true;
      }
    }
    if (this.isVerticesDataPresent(VertexBuffer.UV3Kind)) {
      serializationObject.uvs3 = this._toNumberArray(this.getVerticesData(VertexBuffer.UV3Kind));
      if (this.isVertexBufferUpdatable(VertexBuffer.UV3Kind)) {
        serializationObject.uvs3._updatable = true;
      }
    }
    if (this.isVerticesDataPresent(VertexBuffer.UV4Kind)) {
      serializationObject.uvs4 = this._toNumberArray(this.getVerticesData(VertexBuffer.UV4Kind));
      if (this.isVertexBufferUpdatable(VertexBuffer.UV4Kind)) {
        serializationObject.uvs4._updatable = true;
      }
    }
    if (this.isVerticesDataPresent(VertexBuffer.UV5Kind)) {
      serializationObject.uvs5 = this._toNumberArray(this.getVerticesData(VertexBuffer.UV5Kind));
      if (this.isVertexBufferUpdatable(VertexBuffer.UV5Kind)) {
        serializationObject.uvs5._updatable = true;
      }
    }
    if (this.isVerticesDataPresent(VertexBuffer.UV6Kind)) {
      serializationObject.uvs6 = this._toNumberArray(this.getVerticesData(VertexBuffer.UV6Kind));
      if (this.isVertexBufferUpdatable(VertexBuffer.UV6Kind)) {
        serializationObject.uvs6._updatable = true;
      }
    }
    if (this.isVerticesDataPresent(VertexBuffer.ColorKind)) {
      serializationObject.colors = this._toNumberArray(this.getVerticesData(VertexBuffer.ColorKind));
      if (this.isVertexBufferUpdatable(VertexBuffer.ColorKind)) {
        serializationObject.colors._updatable = true;
      }
    }
    if (this.isVerticesDataPresent(VertexBuffer.MatricesIndicesKind)) {
      serializationObject.matricesIndices = this._toNumberArray(this.getVerticesData(VertexBuffer.MatricesIndicesKind));
      serializationObject.matricesIndices._isExpanded = true;
      if (this.isVertexBufferUpdatable(VertexBuffer.MatricesIndicesKind)) {
        serializationObject.matricesIndices._updatable = true;
      }
    }
    if (this.isVerticesDataPresent(VertexBuffer.MatricesWeightsKind)) {
      serializationObject.matricesWeights = this._toNumberArray(this.getVerticesData(VertexBuffer.MatricesWeightsKind));
      if (this.isVertexBufferUpdatable(VertexBuffer.MatricesWeightsKind)) {
        serializationObject.matricesWeights._updatable = true;
      }
    }
    serializationObject.indices = this._toNumberArray(this.getIndices());
    return serializationObject;
  }
  // Statics
  /**
   * Extracts a clone of a mesh geometry
   * @param mesh defines the source mesh
   * @param id defines the unique ID of the new geometry object
   * @returns the new geometry object
   */
  static ExtractFromMesh(mesh, id) {
    const geometry = mesh._geometry;
    if (!geometry) {
      return null;
    }
    return geometry.copy(id);
  }
  /**
   * You should now use Tools.RandomId(), this method is still here for legacy reasons.
   * Implementation from http://stackoverflow.com/questions/105034/how-to-create-a-guid-uuid-in-javascript/2117523#answer-2117523
   * Be aware Math.random() could cause collisions, but:
   * "All but 6 of the 128 bits of the ID are randomly generated, which means that for any two ids, there's a 1 in 2^^122 (or 5.3x10^^36) chance they'll collide"
   * @returns a string containing a new GUID
   */
  static RandomId() {
    return Tools.RandomId();
  }
  static _GetGeometryByLoadedUniqueId(uniqueId, scene) {
    for (let index2 = 0; index2 < scene.geometries.length; index2++) {
      if (scene.geometries[index2]._loadedUniqueId === uniqueId) {
        return scene.geometries[index2];
      }
    }
    return null;
  }
  /**
   * @internal
   */
  static _ImportGeometry(parsedGeometry, mesh) {
    const scene = mesh.getScene();
    const geometryUniqueId = parsedGeometry.geometryUniqueId;
    const geometryId = parsedGeometry.geometryId;
    if (geometryUniqueId || geometryId) {
      const geometry = geometryUniqueId ? this._GetGeometryByLoadedUniqueId(geometryUniqueId, scene) : scene.getGeometryById(geometryId);
      if (geometry) {
        geometry.applyToMesh(mesh);
      }
    } else if (parsedGeometry instanceof ArrayBuffer) {
      const binaryInfo = mesh._binaryInfo;
      if (binaryInfo.positionsAttrDesc && binaryInfo.positionsAttrDesc.count > 0) {
        const positionsData = new Float32Array(parsedGeometry, binaryInfo.positionsAttrDesc.offset, binaryInfo.positionsAttrDesc.count);
        mesh.setVerticesData(VertexBuffer.PositionKind, positionsData, false);
      }
      if (binaryInfo.normalsAttrDesc && binaryInfo.normalsAttrDesc.count > 0) {
        const normalsData = new Float32Array(parsedGeometry, binaryInfo.normalsAttrDesc.offset, binaryInfo.normalsAttrDesc.count);
        mesh.setVerticesData(VertexBuffer.NormalKind, normalsData, false);
      }
      if (binaryInfo.tangetsAttrDesc && binaryInfo.tangetsAttrDesc.count > 0) {
        const tangentsData = new Float32Array(parsedGeometry, binaryInfo.tangetsAttrDesc.offset, binaryInfo.tangetsAttrDesc.count);
        mesh.setVerticesData(VertexBuffer.TangentKind, tangentsData, false);
      }
      if (binaryInfo.uvsAttrDesc && binaryInfo.uvsAttrDesc.count > 0) {
        const uvsData = new Float32Array(parsedGeometry, binaryInfo.uvsAttrDesc.offset, binaryInfo.uvsAttrDesc.count);
        mesh.setVerticesData(VertexBuffer.UVKind, uvsData, false);
      }
      if (binaryInfo.uvs2AttrDesc && binaryInfo.uvs2AttrDesc.count > 0) {
        const uvs2Data = new Float32Array(parsedGeometry, binaryInfo.uvs2AttrDesc.offset, binaryInfo.uvs2AttrDesc.count);
        mesh.setVerticesData(VertexBuffer.UV2Kind, uvs2Data, false);
      }
      if (binaryInfo.uvs3AttrDesc && binaryInfo.uvs3AttrDesc.count > 0) {
        const uvs3Data = new Float32Array(parsedGeometry, binaryInfo.uvs3AttrDesc.offset, binaryInfo.uvs3AttrDesc.count);
        mesh.setVerticesData(VertexBuffer.UV3Kind, uvs3Data, false);
      }
      if (binaryInfo.uvs4AttrDesc && binaryInfo.uvs4AttrDesc.count > 0) {
        const uvs4Data = new Float32Array(parsedGeometry, binaryInfo.uvs4AttrDesc.offset, binaryInfo.uvs4AttrDesc.count);
        mesh.setVerticesData(VertexBuffer.UV4Kind, uvs4Data, false);
      }
      if (binaryInfo.uvs5AttrDesc && binaryInfo.uvs5AttrDesc.count > 0) {
        const uvs5Data = new Float32Array(parsedGeometry, binaryInfo.uvs5AttrDesc.offset, binaryInfo.uvs5AttrDesc.count);
        mesh.setVerticesData(VertexBuffer.UV5Kind, uvs5Data, false);
      }
      if (binaryInfo.uvs6AttrDesc && binaryInfo.uvs6AttrDesc.count > 0) {
        const uvs6Data = new Float32Array(parsedGeometry, binaryInfo.uvs6AttrDesc.offset, binaryInfo.uvs6AttrDesc.count);
        mesh.setVerticesData(VertexBuffer.UV6Kind, uvs6Data, false);
      }
      if (binaryInfo.colorsAttrDesc && binaryInfo.colorsAttrDesc.count > 0) {
        const colorsData = new Float32Array(parsedGeometry, binaryInfo.colorsAttrDesc.offset, binaryInfo.colorsAttrDesc.count);
        mesh.setVerticesData(VertexBuffer.ColorKind, colorsData, false, binaryInfo.colorsAttrDesc.stride);
      }
      if (binaryInfo.matricesIndicesAttrDesc && binaryInfo.matricesIndicesAttrDesc.count > 0) {
        const matricesIndicesData = new Int32Array(parsedGeometry, binaryInfo.matricesIndicesAttrDesc.offset, binaryInfo.matricesIndicesAttrDesc.count);
        const floatIndices = [];
        for (let i2 = 0; i2 < matricesIndicesData.length; i2++) {
          const index2 = matricesIndicesData[i2];
          floatIndices.push(index2 & 255);
          floatIndices.push((index2 & 65280) >> 8);
          floatIndices.push((index2 & 16711680) >> 16);
          floatIndices.push(index2 >> 24 & 255);
        }
        mesh.setVerticesData(VertexBuffer.MatricesIndicesKind, floatIndices, false);
      }
      if (binaryInfo.matricesIndicesExtraAttrDesc && binaryInfo.matricesIndicesExtraAttrDesc.count > 0) {
        const matricesIndicesData = new Int32Array(parsedGeometry, binaryInfo.matricesIndicesExtraAttrDesc.offset, binaryInfo.matricesIndicesExtraAttrDesc.count);
        const floatIndices = [];
        for (let i2 = 0; i2 < matricesIndicesData.length; i2++) {
          const index2 = matricesIndicesData[i2];
          floatIndices.push(index2 & 255);
          floatIndices.push((index2 & 65280) >> 8);
          floatIndices.push((index2 & 16711680) >> 16);
          floatIndices.push(index2 >> 24 & 255);
        }
        mesh.setVerticesData(VertexBuffer.MatricesIndicesExtraKind, floatIndices, false);
      }
      if (binaryInfo.matricesWeightsAttrDesc && binaryInfo.matricesWeightsAttrDesc.count > 0) {
        const matricesWeightsData = new Float32Array(parsedGeometry, binaryInfo.matricesWeightsAttrDesc.offset, binaryInfo.matricesWeightsAttrDesc.count);
        mesh.setVerticesData(VertexBuffer.MatricesWeightsKind, matricesWeightsData, false);
      }
      if (binaryInfo.indicesAttrDesc && binaryInfo.indicesAttrDesc.count > 0) {
        const indicesData = new Int32Array(parsedGeometry, binaryInfo.indicesAttrDesc.offset, binaryInfo.indicesAttrDesc.count);
        mesh.setIndices(indicesData, null);
      }
      if (binaryInfo.subMeshesAttrDesc && binaryInfo.subMeshesAttrDesc.count > 0) {
        const subMeshesData = new Int32Array(parsedGeometry, binaryInfo.subMeshesAttrDesc.offset, binaryInfo.subMeshesAttrDesc.count * 5);
        mesh.subMeshes = [];
        for (let i2 = 0; i2 < binaryInfo.subMeshesAttrDesc.count; i2++) {
          const materialIndex = subMeshesData[i2 * 5 + 0];
          const verticesStart = subMeshesData[i2 * 5 + 1];
          const verticesCount = subMeshesData[i2 * 5 + 2];
          const indexStart = subMeshesData[i2 * 5 + 3];
          const indexCount = subMeshesData[i2 * 5 + 4];
          SubMesh.AddToMesh(materialIndex, verticesStart, verticesCount, indexStart, indexCount, mesh);
        }
      }
    } else if (parsedGeometry.positions && parsedGeometry.normals && parsedGeometry.indices) {
      mesh.setVerticesData(VertexBuffer.PositionKind, parsedGeometry.positions, parsedGeometry.positions._updatable);
      mesh.setVerticesData(VertexBuffer.NormalKind, parsedGeometry.normals, parsedGeometry.normals._updatable);
      if (parsedGeometry.tangents) {
        mesh.setVerticesData(VertexBuffer.TangentKind, parsedGeometry.tangents, parsedGeometry.tangents._updatable);
      }
      if (parsedGeometry.uvs) {
        mesh.setVerticesData(VertexBuffer.UVKind, parsedGeometry.uvs, parsedGeometry.uvs._updatable);
      }
      if (parsedGeometry.uvs2) {
        mesh.setVerticesData(VertexBuffer.UV2Kind, parsedGeometry.uvs2, parsedGeometry.uvs2._updatable);
      }
      if (parsedGeometry.uvs3) {
        mesh.setVerticesData(VertexBuffer.UV3Kind, parsedGeometry.uvs3, parsedGeometry.uvs3._updatable);
      }
      if (parsedGeometry.uvs4) {
        mesh.setVerticesData(VertexBuffer.UV4Kind, parsedGeometry.uvs4, parsedGeometry.uvs4._updatable);
      }
      if (parsedGeometry.uvs5) {
        mesh.setVerticesData(VertexBuffer.UV5Kind, parsedGeometry.uvs5, parsedGeometry.uvs5._updatable);
      }
      if (parsedGeometry.uvs6) {
        mesh.setVerticesData(VertexBuffer.UV6Kind, parsedGeometry.uvs6, parsedGeometry.uvs6._updatable);
      }
      if (parsedGeometry.colors) {
        mesh.setVerticesData(VertexBuffer.ColorKind, Color4.CheckColors4(parsedGeometry.colors, parsedGeometry.positions.length / 3), parsedGeometry.colors._updatable);
      }
      if (parsedGeometry.matricesIndices) {
        if (!parsedGeometry.matricesIndices._isExpanded) {
          const floatIndices = [];
          for (let i2 = 0; i2 < parsedGeometry.matricesIndices.length; i2++) {
            const matricesIndex = parsedGeometry.matricesIndices[i2];
            floatIndices.push(matricesIndex & 255);
            floatIndices.push((matricesIndex & 65280) >> 8);
            floatIndices.push((matricesIndex & 16711680) >> 16);
            floatIndices.push(matricesIndex >> 24 & 255);
          }
          mesh.setVerticesData(VertexBuffer.MatricesIndicesKind, floatIndices, parsedGeometry.matricesIndices._updatable);
        } else {
          delete parsedGeometry.matricesIndices._isExpanded;
          mesh.setVerticesData(VertexBuffer.MatricesIndicesKind, parsedGeometry.matricesIndices, parsedGeometry.matricesIndices._updatable);
        }
      }
      if (parsedGeometry.matricesIndicesExtra) {
        if (!parsedGeometry.matricesIndicesExtra._isExpanded) {
          const floatIndices = [];
          for (let i2 = 0; i2 < parsedGeometry.matricesIndicesExtra.length; i2++) {
            const matricesIndex = parsedGeometry.matricesIndicesExtra[i2];
            floatIndices.push(matricesIndex & 255);
            floatIndices.push((matricesIndex & 65280) >> 8);
            floatIndices.push((matricesIndex & 16711680) >> 16);
            floatIndices.push(matricesIndex >> 24 & 255);
          }
          mesh.setVerticesData(VertexBuffer.MatricesIndicesExtraKind, floatIndices, parsedGeometry.matricesIndicesExtra._updatable);
        } else {
          delete parsedGeometry.matricesIndices._isExpanded;
          mesh.setVerticesData(VertexBuffer.MatricesIndicesExtraKind, parsedGeometry.matricesIndicesExtra, parsedGeometry.matricesIndicesExtra._updatable);
        }
      }
      if (parsedGeometry.matricesWeights) {
        Geometry._CleanMatricesWeights(parsedGeometry, mesh);
        mesh.setVerticesData(VertexBuffer.MatricesWeightsKind, parsedGeometry.matricesWeights, parsedGeometry.matricesWeights._updatable);
      }
      if (parsedGeometry.matricesWeightsExtra) {
        mesh.setVerticesData(VertexBuffer.MatricesWeightsExtraKind, parsedGeometry.matricesWeightsExtra, parsedGeometry.matricesWeights._updatable);
      }
      mesh.setIndices(parsedGeometry.indices, null);
    }
    if (parsedGeometry.subMeshes) {
      mesh.subMeshes = [];
      for (let subIndex = 0; subIndex < parsedGeometry.subMeshes.length; subIndex++) {
        const parsedSubMesh = parsedGeometry.subMeshes[subIndex];
        SubMesh.AddToMesh(parsedSubMesh.materialIndex, parsedSubMesh.verticesStart, parsedSubMesh.verticesCount, parsedSubMesh.indexStart, parsedSubMesh.indexCount, mesh);
      }
    }
    if (mesh._shouldGenerateFlatShading) {
      mesh.convertToFlatShadedMesh();
      mesh._shouldGenerateFlatShading = false;
    }
    mesh.computeWorldMatrix(true);
    scene.onMeshImportedObservable.notifyObservers(mesh);
  }
  static _CleanMatricesWeights(parsedGeometry, mesh) {
    const epsilon = 1e-3;
    if (!SceneLoaderFlags.CleanBoneMatrixWeights) {
      return;
    }
    let noInfluenceBoneIndex = 0;
    if (parsedGeometry.skeletonId > -1) {
      const skeleton = mesh.getScene().getLastSkeletonById(parsedGeometry.skeletonId);
      if (!skeleton) {
        return;
      }
      noInfluenceBoneIndex = skeleton.bones.length;
    } else {
      return;
    }
    const matricesIndices = mesh.getVerticesData(VertexBuffer.MatricesIndicesKind);
    const matricesIndicesExtra = mesh.getVerticesData(VertexBuffer.MatricesIndicesExtraKind);
    const matricesWeights = parsedGeometry.matricesWeights;
    const matricesWeightsExtra = parsedGeometry.matricesWeightsExtra;
    const influencers = parsedGeometry.numBoneInfluencer;
    const size = matricesWeights.length;
    for (let i2 = 0; i2 < size; i2 += 4) {
      let weight = 0;
      let firstZeroWeight = -1;
      for (let j2 = 0; j2 < 4; j2++) {
        const w = matricesWeights[i2 + j2];
        weight += w;
        if (w < epsilon && firstZeroWeight < 0) {
          firstZeroWeight = j2;
        }
      }
      if (matricesWeightsExtra) {
        for (let j2 = 0; j2 < 4; j2++) {
          const w = matricesWeightsExtra[i2 + j2];
          weight += w;
          if (w < epsilon && firstZeroWeight < 0) {
            firstZeroWeight = j2 + 4;
          }
        }
      }
      if (firstZeroWeight < 0 || firstZeroWeight > influencers - 1) {
        firstZeroWeight = influencers - 1;
      }
      if (weight > epsilon) {
        const mweight = 1 / weight;
        for (let j2 = 0; j2 < 4; j2++) {
          matricesWeights[i2 + j2] *= mweight;
        }
        if (matricesWeightsExtra) {
          for (let j2 = 0; j2 < 4; j2++) {
            matricesWeightsExtra[i2 + j2] *= mweight;
          }
        }
      } else {
        if (firstZeroWeight >= 4) {
          matricesWeightsExtra[i2 + firstZeroWeight - 4] = 1 - weight;
          matricesIndicesExtra[i2 + firstZeroWeight - 4] = noInfluenceBoneIndex;
        } else {
          matricesWeights[i2 + firstZeroWeight] = 1 - weight;
          matricesIndices[i2 + firstZeroWeight] = noInfluenceBoneIndex;
        }
      }
    }
    mesh.setVerticesData(VertexBuffer.MatricesIndicesKind, matricesIndices);
    if (parsedGeometry.matricesWeightsExtra) {
      mesh.setVerticesData(VertexBuffer.MatricesIndicesExtraKind, matricesIndicesExtra);
    }
  }
  /**
   * Create a new geometry from persisted data (Using .babylon file format)
   * @param parsedVertexData defines the persisted data
   * @param scene defines the hosting scene
   * @param rootUrl defines the root url to use to load assets (like delayed data)
   * @returns the new geometry object
   */
  static Parse(parsedVertexData, scene, rootUrl) {
    const geometry = new Geometry(parsedVertexData.id, scene, void 0, parsedVertexData.updatable);
    geometry._loadedUniqueId = parsedVertexData.uniqueId;
    if (Tags) {
      Tags.AddTagsTo(geometry, parsedVertexData.tags);
    }
    if (parsedVertexData.delayLoadingFile) {
      geometry.delayLoadState = 4;
      geometry.delayLoadingFile = rootUrl + parsedVertexData.delayLoadingFile;
      geometry._boundingInfo = new BoundingInfo(Vector3.FromArray(parsedVertexData.boundingBoxMinimum), Vector3.FromArray(parsedVertexData.boundingBoxMaximum));
      geometry._delayInfo = [];
      if (parsedVertexData.hasUVs) {
        geometry._delayInfo.push(VertexBuffer.UVKind);
      }
      if (parsedVertexData.hasUVs2) {
        geometry._delayInfo.push(VertexBuffer.UV2Kind);
      }
      if (parsedVertexData.hasUVs3) {
        geometry._delayInfo.push(VertexBuffer.UV3Kind);
      }
      if (parsedVertexData.hasUVs4) {
        geometry._delayInfo.push(VertexBuffer.UV4Kind);
      }
      if (parsedVertexData.hasUVs5) {
        geometry._delayInfo.push(VertexBuffer.UV5Kind);
      }
      if (parsedVertexData.hasUVs6) {
        geometry._delayInfo.push(VertexBuffer.UV6Kind);
      }
      if (parsedVertexData.hasColors) {
        geometry._delayInfo.push(VertexBuffer.ColorKind);
      }
      if (parsedVertexData.hasMatricesIndices) {
        geometry._delayInfo.push(VertexBuffer.MatricesIndicesKind);
      }
      if (parsedVertexData.hasMatricesWeights) {
        geometry._delayInfo.push(VertexBuffer.MatricesWeightsKind);
      }
      geometry._delayLoadingFunction = VertexData.ImportVertexData;
    } else {
      VertexData.ImportVertexData(parsedVertexData, geometry);
    }
    scene.pushGeometry(geometry, true);
    return geometry;
  }
}
const convertRHSToLHS = Matrix.Compose(Vector3.One(), Quaternion.FromEulerAngles(0, Math.PI, 0), Vector3.Zero());
class TransformNode extends Node {
  /**
   * Gets or sets the billboard mode. Default is 0.
   *
   * | Value | Type | Description |
   * | --- | --- | --- |
   * | 0 | BILLBOARDMODE_NONE |  |
   * | 1 | BILLBOARDMODE_X |  |
   * | 2 | BILLBOARDMODE_Y |  |
   * | 4 | BILLBOARDMODE_Z |  |
   * | 7 | BILLBOARDMODE_ALL |  |
   *
   */
  get billboardMode() {
    return this._billboardMode;
  }
  set billboardMode(value) {
    if (this._billboardMode === value) {
      return;
    }
    this._billboardMode = value;
    this._cache.useBillboardPosition = (this._billboardMode & TransformNode.BILLBOARDMODE_USE_POSITION) !== 0;
    this._computeUseBillboardPath();
  }
  /**
   * Gets or sets a boolean indicating that parent rotation should be preserved when using billboards.
   * This could be useful for glTF objects where parent rotation helps converting from right handed to left handed
   */
  get preserveParentRotationForBillboard() {
    return this._preserveParentRotationForBillboard;
  }
  set preserveParentRotationForBillboard(value) {
    if (value === this._preserveParentRotationForBillboard) {
      return;
    }
    this._preserveParentRotationForBillboard = value;
    this._computeUseBillboardPath();
  }
  _computeUseBillboardPath() {
    this._cache.useBillboardPath = this._billboardMode !== TransformNode.BILLBOARDMODE_NONE && !this.preserveParentRotationForBillboard;
  }
  /**
   * Gets or sets the distance of the object to max, often used by skybox
   */
  get infiniteDistance() {
    return this._infiniteDistance;
  }
  set infiniteDistance(value) {
    if (this._infiniteDistance === value) {
      return;
    }
    this._infiniteDistance = value;
  }
  constructor(name2, scene = null, isPure = true) {
    super(name2, scene, false);
    this._forward = new Vector3(0, 0, 1);
    this._up = new Vector3(0, 1, 0);
    this._right = new Vector3(1, 0, 0);
    this._position = Vector3.Zero();
    this._rotation = Vector3.Zero();
    this._rotationQuaternion = null;
    this._scaling = Vector3.One();
    this._transformToBoneReferal = null;
    this._isAbsoluteSynced = false;
    this._billboardMode = TransformNode.BILLBOARDMODE_NONE;
    this._preserveParentRotationForBillboard = false;
    this.scalingDeterminant = 1;
    this._infiniteDistance = false;
    this.ignoreNonUniformScaling = false;
    this.reIntegrateRotationIntoRotationQuaternion = false;
    this._poseMatrix = null;
    this._localMatrix = Matrix.Zero();
    this._usePivotMatrix = false;
    this._absolutePosition = Vector3.Zero();
    this._absoluteScaling = Vector3.Zero();
    this._absoluteRotationQuaternion = Quaternion.Identity();
    this._pivotMatrix = Matrix.Identity();
    this._postMultiplyPivotMatrix = false;
    this._isWorldMatrixFrozen = false;
    this._indexInSceneTransformNodesArray = -1;
    this.onAfterWorldMatrixUpdateObservable = new Observable();
    this._nonUniformScaling = false;
    if (isPure) {
      this.getScene().addTransformNode(this);
    }
  }
  /**
   * Gets a string identifying the name of the class
   * @returns "TransformNode" string
   */
  getClassName() {
    return "TransformNode";
  }
  /**
   * Gets or set the node position (default is (0.0, 0.0, 0.0))
   */
  get position() {
    return this._position;
  }
  set position(newPosition) {
    this._position = newPosition;
    this._markAsDirtyInternal();
  }
  /**
   * return true if a pivot has been set
   * @returns true if a pivot matrix is used
   */
  isUsingPivotMatrix() {
    return this._usePivotMatrix;
  }
  /**
   * @returns true if pivot matrix must be cancelled in the world matrix. When this parameter is set to true (default), the inverse of the pivot matrix is also applied at the end to cancel the transformation effect.
   */
  isUsingPostMultiplyPivotMatrix() {
    return this._postMultiplyPivotMatrix;
  }
  /**
   * Gets or sets the rotation property : a Vector3 defining the rotation value in radians around each local axis X, Y, Z  (default is (0.0, 0.0, 0.0)).
   * If rotation quaternion is set, this Vector3 will be ignored and copy from the quaternion
   */
  get rotation() {
    return this._rotation;
  }
  set rotation(newRotation) {
    this._rotation = newRotation;
    this._rotationQuaternion = null;
    this._markAsDirtyInternal();
  }
  /**
   * Gets or sets the scaling property : a Vector3 defining the node scaling along each local axis X, Y, Z (default is (1.0, 1.0, 1.0)).
   */
  get scaling() {
    return this._scaling;
  }
  set scaling(newScaling) {
    this._scaling = newScaling;
    this._markAsDirtyInternal();
  }
  /**
   * Gets or sets the rotation Quaternion property : this a Quaternion object defining the node rotation by using a unit quaternion (undefined by default, but can be null).
   * If set, only the rotationQuaternion is then used to compute the node rotation (ie. node.rotation will be ignored)
   */
  get rotationQuaternion() {
    return this._rotationQuaternion;
  }
  set rotationQuaternion(quaternion) {
    this._rotationQuaternion = quaternion;
    if (quaternion) {
      this._rotation.setAll(0);
    }
    this._markAsDirtyInternal();
  }
  _markAsDirtyInternal() {
    if (this._isDirty) {
      return;
    }
    this._isDirty = true;
    if (this.customMarkAsDirty) {
      this.customMarkAsDirty();
    }
  }
  /**
   * The forward direction of that transform in world space.
   */
  get forward() {
    Vector3.TransformNormalFromFloatsToRef(0, 0, this.getScene().useRightHandedSystem ? -1 : 1, this.getWorldMatrix(), this._forward);
    return this._forward.normalize();
  }
  /**
   * The up direction of that transform in world space.
   */
  get up() {
    Vector3.TransformNormalFromFloatsToRef(0, 1, 0, this.getWorldMatrix(), this._up);
    return this._up.normalize();
  }
  /**
   * The right direction of that transform in world space.
   */
  get right() {
    Vector3.TransformNormalFromFloatsToRef(this.getScene().useRightHandedSystem ? -1 : 1, 0, 0, this.getWorldMatrix(), this._right);
    return this._right.normalize();
  }
  /**
   * Copies the parameter passed Matrix into the mesh Pose matrix.
   * @param matrix the matrix to copy the pose from
   * @returns this TransformNode.
   */
  updatePoseMatrix(matrix) {
    if (!this._poseMatrix) {
      this._poseMatrix = matrix.clone();
      return this;
    }
    this._poseMatrix.copyFrom(matrix);
    return this;
  }
  /**
   * Returns the mesh Pose matrix.
   * @returns the pose matrix
   */
  getPoseMatrix() {
    if (!this._poseMatrix) {
      this._poseMatrix = Matrix.Identity();
    }
    return this._poseMatrix;
  }
  /** @internal */
  _isSynchronized() {
    const cache = this._cache;
    if (this._billboardMode !== cache.billboardMode || this._billboardMode !== TransformNode.BILLBOARDMODE_NONE) {
      return false;
    }
    if (cache.pivotMatrixUpdated) {
      return false;
    }
    if (this._infiniteDistance) {
      return false;
    }
    if (this._position._isDirty) {
      return false;
    }
    if (this._scaling._isDirty) {
      return false;
    }
    if (this._rotationQuaternion && this._rotationQuaternion._isDirty || this._rotation._isDirty) {
      return false;
    }
    return true;
  }
  /** @internal */
  _initCache() {
    super._initCache();
    const cache = this._cache;
    cache.localMatrixUpdated = false;
    cache.billboardMode = -1;
    cache.infiniteDistance = false;
    cache.useBillboardPosition = false;
    cache.useBillboardPath = false;
  }
  /**
   * Returns the current mesh absolute position.
   * Returns a Vector3.
   */
  get absolutePosition() {
    return this.getAbsolutePosition();
  }
  /**
   * Returns the current mesh absolute scaling.
   * Returns a Vector3.
   */
  get absoluteScaling() {
    this._syncAbsoluteScalingAndRotation();
    return this._absoluteScaling;
  }
  /**
   * Returns the current mesh absolute rotation.
   * Returns a Quaternion.
   */
  get absoluteRotationQuaternion() {
    this._syncAbsoluteScalingAndRotation();
    return this._absoluteRotationQuaternion;
  }
  /**
   * Sets a new matrix to apply before all other transformation
   * @param matrix defines the transform matrix
   * @returns the current TransformNode
   */
  setPreTransformMatrix(matrix) {
    return this.setPivotMatrix(matrix, false);
  }
  /**
   * Sets a new pivot matrix to the current node
   * @param matrix defines the new pivot matrix to use
   * @param postMultiplyPivotMatrix defines if the pivot matrix must be cancelled in the world matrix. When this parameter is set to true (default), the inverse of the pivot matrix is also applied at the end to cancel the transformation effect
   * @returns the current TransformNode
   */
  setPivotMatrix(matrix, postMultiplyPivotMatrix = true) {
    this._pivotMatrix.copyFrom(matrix);
    this._usePivotMatrix = !this._pivotMatrix.isIdentity();
    this._cache.pivotMatrixUpdated = true;
    this._postMultiplyPivotMatrix = postMultiplyPivotMatrix;
    if (this._postMultiplyPivotMatrix) {
      if (!this._pivotMatrixInverse) {
        this._pivotMatrixInverse = Matrix.Invert(this._pivotMatrix);
      } else {
        this._pivotMatrix.invertToRef(this._pivotMatrixInverse);
      }
    }
    return this;
  }
  /**
   * Returns the mesh pivot matrix.
   * Default : Identity.
   * @returns the matrix
   */
  getPivotMatrix() {
    return this._pivotMatrix;
  }
  /**
   * Instantiate (when possible) or clone that node with its hierarchy
   * @param newParent defines the new parent to use for the instance (or clone)
   * @param options defines options to configure how copy is done
   * @param options.doNotInstantiate defines if the model must be instantiated or just cloned
   * @param onNewNodeCreated defines an option callback to call when a clone or an instance is created
   * @returns an instance (or a clone) of the current node with its hierarchy
   */
  instantiateHierarchy(newParent = null, options, onNewNodeCreated) {
    const clone = this.clone("Clone of " + (this.name || this.id), newParent || this.parent, true);
    if (clone) {
      if (onNewNodeCreated) {
        onNewNodeCreated(this, clone);
      }
    }
    for (const child of this.getChildTransformNodes(true)) {
      child.instantiateHierarchy(clone, options, onNewNodeCreated);
    }
    return clone;
  }
  /**
   * Prevents the World matrix to be computed any longer
   * @param newWorldMatrix defines an optional matrix to use as world matrix
   * @param decompose defines whether to decompose the given newWorldMatrix or directly assign
   * @returns the TransformNode.
   */
  freezeWorldMatrix(newWorldMatrix = null, decompose = false) {
    if (newWorldMatrix) {
      if (decompose) {
        this._rotation.setAll(0);
        this._rotationQuaternion = this._rotationQuaternion || Quaternion.Identity();
        newWorldMatrix.decompose(this._scaling, this._rotationQuaternion, this._position);
        this.computeWorldMatrix(true);
      } else {
        this._worldMatrix = newWorldMatrix;
        this._absolutePosition.copyFromFloats(this._worldMatrix.m[12], this._worldMatrix.m[13], this._worldMatrix.m[14]);
        this._afterComputeWorldMatrix();
      }
    } else {
      this._isWorldMatrixFrozen = false;
      this.computeWorldMatrix(true);
    }
    this._isDirty = false;
    this._isWorldMatrixFrozen = true;
    return this;
  }
  /**
   * Allows back the World matrix computation.
   * @returns the TransformNode.
   */
  unfreezeWorldMatrix() {
    this._isWorldMatrixFrozen = false;
    this.computeWorldMatrix(true);
    return this;
  }
  /**
   * True if the World matrix has been frozen.
   */
  get isWorldMatrixFrozen() {
    return this._isWorldMatrixFrozen;
  }
  /**
   * Returns the mesh absolute position in the World.
   * @returns a Vector3.
   */
  getAbsolutePosition() {
    this.computeWorldMatrix();
    return this._absolutePosition;
  }
  /**
   * Sets the mesh absolute position in the World from a Vector3 or an Array(3).
   * @param absolutePosition the absolute position to set
   * @returns the TransformNode.
   */
  setAbsolutePosition(absolutePosition) {
    if (!absolutePosition) {
      return this;
    }
    let absolutePositionX;
    let absolutePositionY;
    let absolutePositionZ;
    if (absolutePosition.x === void 0) {
      if (arguments.length < 3) {
        return this;
      }
      absolutePositionX = arguments[0];
      absolutePositionY = arguments[1];
      absolutePositionZ = arguments[2];
    } else {
      absolutePositionX = absolutePosition.x;
      absolutePositionY = absolutePosition.y;
      absolutePositionZ = absolutePosition.z;
    }
    if (this.parent) {
      const invertParentWorldMatrix = TmpVectors.Matrix[0];
      this.parent.getWorldMatrix().invertToRef(invertParentWorldMatrix);
      Vector3.TransformCoordinatesFromFloatsToRef(absolutePositionX, absolutePositionY, absolutePositionZ, invertParentWorldMatrix, this.position);
    } else {
      this.position.x = absolutePositionX;
      this.position.y = absolutePositionY;
      this.position.z = absolutePositionZ;
    }
    this._absolutePosition.copyFrom(absolutePosition);
    return this;
  }
  /**
   * Sets the mesh position in its local space.
   * @param vector3 the position to set in localspace
   * @returns the TransformNode.
   */
  setPositionWithLocalVector(vector3) {
    this.computeWorldMatrix();
    this.position = Vector3.TransformNormal(vector3, this._localMatrix);
    return this;
  }
  /**
   * Returns the mesh position in the local space from the current World matrix values.
   * @returns a new Vector3.
   */
  getPositionExpressedInLocalSpace() {
    this.computeWorldMatrix();
    const invLocalWorldMatrix = TmpVectors.Matrix[0];
    this._localMatrix.invertToRef(invLocalWorldMatrix);
    return Vector3.TransformNormal(this.position, invLocalWorldMatrix);
  }
  /**
   * Translates the mesh along the passed Vector3 in its local space.
   * @param vector3 the distance to translate in localspace
   * @returns the TransformNode.
   */
  locallyTranslate(vector3) {
    this.computeWorldMatrix(true);
    this.position = Vector3.TransformCoordinates(vector3, this._localMatrix);
    return this;
  }
  /**
   * Orients a mesh towards a target point. Mesh must be drawn facing user.
   * @param targetPoint the position (must be in same space as current mesh) to look at
   * @param yawCor optional yaw (y-axis) correction in radians
   * @param pitchCor optional pitch (x-axis) correction in radians
   * @param rollCor optional roll (z-axis) correction in radians
   * @param space the chosen space of the target
   * @returns the TransformNode.
   */
  lookAt(targetPoint, yawCor = 0, pitchCor = 0, rollCor = 0, space = 0) {
    const dv = TransformNode._LookAtVectorCache;
    const pos = space === 0 ? this.position : this.getAbsolutePosition();
    targetPoint.subtractToRef(pos, dv);
    this.setDirection(dv, yawCor, pitchCor, rollCor);
    if (space === 1 && this.parent) {
      if (this.rotationQuaternion) {
        const rotationMatrix = TmpVectors.Matrix[0];
        this.rotationQuaternion.toRotationMatrix(rotationMatrix);
        const parentRotationMatrix = TmpVectors.Matrix[1];
        this.parent.getWorldMatrix().getRotationMatrixToRef(parentRotationMatrix);
        parentRotationMatrix.invert();
        rotationMatrix.multiplyToRef(parentRotationMatrix, rotationMatrix);
        this.rotationQuaternion.fromRotationMatrix(rotationMatrix);
      } else {
        const quaternionRotation = TmpVectors.Quaternion[0];
        Quaternion.FromEulerVectorToRef(this.rotation, quaternionRotation);
        const rotationMatrix = TmpVectors.Matrix[0];
        quaternionRotation.toRotationMatrix(rotationMatrix);
        const parentRotationMatrix = TmpVectors.Matrix[1];
        this.parent.getWorldMatrix().getRotationMatrixToRef(parentRotationMatrix);
        parentRotationMatrix.invert();
        rotationMatrix.multiplyToRef(parentRotationMatrix, rotationMatrix);
        quaternionRotation.fromRotationMatrix(rotationMatrix);
        quaternionRotation.toEulerAnglesToRef(this.rotation);
      }
    }
    return this;
  }
  /**
   * Returns a new Vector3 that is the localAxis, expressed in the mesh local space, rotated like the mesh.
   * This Vector3 is expressed in the World space.
   * @param localAxis axis to rotate
   * @returns a new Vector3 that is the localAxis, expressed in the mesh local space, rotated like the mesh.
   */
  getDirection(localAxis) {
    const result = Vector3.Zero();
    this.getDirectionToRef(localAxis, result);
    return result;
  }
  /**
   * Sets the Vector3 "result" as the rotated Vector3 "localAxis" in the same rotation than the mesh.
   * localAxis is expressed in the mesh local space.
   * result is computed in the World space from the mesh World matrix.
   * @param localAxis axis to rotate
   * @param result the resulting transformnode
   * @returns this TransformNode.
   */
  getDirectionToRef(localAxis, result) {
    Vector3.TransformNormalToRef(localAxis, this.getWorldMatrix(), result);
    return this;
  }
  /**
   * Sets this transform node rotation to the given local axis.
   * @param localAxis the axis in local space
   * @param yawCor optional yaw (y-axis) correction in radians
   * @param pitchCor optional pitch (x-axis) correction in radians
   * @param rollCor optional roll (z-axis) correction in radians
   * @returns this TransformNode
   */
  setDirection(localAxis, yawCor = 0, pitchCor = 0, rollCor = 0) {
    const yaw = -Math.atan2(localAxis.z, localAxis.x) + Math.PI / 2;
    const len = Math.sqrt(localAxis.x * localAxis.x + localAxis.z * localAxis.z);
    const pitch = -Math.atan2(localAxis.y, len);
    if (this.rotationQuaternion) {
      Quaternion.RotationYawPitchRollToRef(yaw + yawCor, pitch + pitchCor, rollCor, this.rotationQuaternion);
    } else {
      this.rotation.x = pitch + pitchCor;
      this.rotation.y = yaw + yawCor;
      this.rotation.z = rollCor;
    }
    return this;
  }
  /**
   * Sets a new pivot point to the current node
   * @param point defines the new pivot point to use
   * @param space defines if the point is in world or local space (local by default)
   * @returns the current TransformNode
   */
  setPivotPoint(point, space = 0) {
    if (this.getScene().getRenderId() == 0) {
      this.computeWorldMatrix(true);
    }
    const wm = this.getWorldMatrix();
    if (space == 1) {
      const tmat = TmpVectors.Matrix[0];
      wm.invertToRef(tmat);
      point = Vector3.TransformCoordinates(point, tmat);
    }
    return this.setPivotMatrix(Matrix.Translation(-point.x, -point.y, -point.z), true);
  }
  /**
   * Returns a new Vector3 set with the mesh pivot point coordinates in the local space.
   * @returns the pivot point
   */
  getPivotPoint() {
    const point = Vector3.Zero();
    this.getPivotPointToRef(point);
    return point;
  }
  /**
   * Sets the passed Vector3 "result" with the coordinates of the mesh pivot point in the local space.
   * @param result the vector3 to store the result
   * @returns this TransformNode.
   */
  getPivotPointToRef(result) {
    result.x = -this._pivotMatrix.m[12];
    result.y = -this._pivotMatrix.m[13];
    result.z = -this._pivotMatrix.m[14];
    return this;
  }
  /**
   * Returns a new Vector3 set with the mesh pivot point World coordinates.
   * @returns a new Vector3 set with the mesh pivot point World coordinates.
   */
  getAbsolutePivotPoint() {
    const point = Vector3.Zero();
    this.getAbsolutePivotPointToRef(point);
    return point;
  }
  /**
   * Sets the Vector3 "result" coordinates with the mesh pivot point World coordinates.
   * @param result vector3 to store the result
   * @returns this TransformNode.
   */
  getAbsolutePivotPointToRef(result) {
    this.getPivotPointToRef(result);
    Vector3.TransformCoordinatesToRef(result, this.getWorldMatrix(), result);
    return this;
  }
  /**
   * Flag the transform node as dirty (Forcing it to update everything)
   * @param property if set to "rotation" the objects rotationQuaternion will be set to null
   * @returns this  node
   */
  markAsDirty(property) {
    if (this._isDirty) {
      return this;
    }
    if (this._children) {
      for (const child of this._children) {
        child.markAsDirty(property);
      }
    }
    return super.markAsDirty(property);
  }
  /**
   * Defines the passed node as the parent of the current node.
   * The node will remain exactly where it is and its position / rotation will be updated accordingly.
   * If you don't want to preserve the current rotation / position, assign the parent through parent accessor.
   * Note that if the mesh has a pivot matrix / point defined it will be applied after the parent was updated.
   * In that case the node will not remain in the same space as it is, as the pivot will be applied.
   * To avoid this, you can set updatePivot to true and the pivot will be updated to identity
   * @see https://doc.babylonjs.com/features/featuresDeepDive/mesh/transforms/parent_pivot/parent
   * @param node the node ot set as the parent
   * @param preserveScalingSign if true, keep scaling sign of child. Otherwise, scaling sign might change.
   * @param updatePivot if true, update the pivot matrix to keep the node in the same space as before
   * @returns this TransformNode.
   */
  setParent(node, preserveScalingSign = false, updatePivot = false) {
    if (!node && !this.parent) {
      return this;
    }
    const quatRotation = TmpVectors.Quaternion[0];
    const position = TmpVectors.Vector3[0];
    const scale = TmpVectors.Vector3[1];
    const invParentMatrix = TmpVectors.Matrix[1];
    Matrix.IdentityToRef(invParentMatrix);
    const composedMatrix = TmpVectors.Matrix[0];
    this.computeWorldMatrix(true);
    let currentRotation = this.rotationQuaternion;
    if (!currentRotation) {
      currentRotation = TransformNode._TmpRotation;
      Quaternion.RotationYawPitchRollToRef(this._rotation.y, this._rotation.x, this._rotation.z, currentRotation);
    }
    Matrix.ComposeToRef(this.scaling, currentRotation, this.position, composedMatrix);
    if (this.parent) {
      composedMatrix.multiplyToRef(this.parent.computeWorldMatrix(true), composedMatrix);
    }
    if (node) {
      node.computeWorldMatrix(true).invertToRef(invParentMatrix);
      composedMatrix.multiplyToRef(invParentMatrix, composedMatrix);
    }
    composedMatrix.decompose(scale, quatRotation, position, preserveScalingSign ? this : void 0);
    if (this.rotationQuaternion) {
      this.rotationQuaternion.copyFrom(quatRotation);
    } else {
      quatRotation.toEulerAnglesToRef(this.rotation);
    }
    this.scaling.copyFrom(scale);
    this.position.copyFrom(position);
    this.parent = node;
    if (updatePivot) {
      this.setPivotMatrix(Matrix.Identity());
    }
    return this;
  }
  /**
   * Adds the passed mesh as a child to the current mesh.
   * The node will remain exactly where it is and its position / rotation will be updated accordingly.
   * This method is equivalent to calling setParent().
   * @param mesh defines the child mesh
   * @param preserveScalingSign if true, keep scaling sign of child. Otherwise, scaling sign might change.
   * @returns the current mesh
   */
  addChild(mesh, preserveScalingSign = false) {
    mesh.setParent(this, preserveScalingSign);
    return this;
  }
  /**
   * Removes the passed mesh from the current mesh children list
   * @param mesh defines the child mesh
   * @param preserveScalingSign if true, keep scaling sign of child. Otherwise, scaling sign might change.
   * @returns the current mesh
   */
  removeChild(mesh, preserveScalingSign = false) {
    if (mesh.parent !== this)
      return this;
    mesh.setParent(null, preserveScalingSign);
    return this;
  }
  /**
   * True if the scaling property of this object is non uniform eg. (1,2,1)
   */
  get nonUniformScaling() {
    return this._nonUniformScaling;
  }
  /**
   * @internal
   */
  _updateNonUniformScalingState(value) {
    if (this._nonUniformScaling === value) {
      return false;
    }
    this._nonUniformScaling = value;
    return true;
  }
  /**
   * Attach the current TransformNode to another TransformNode associated with a bone
   * @param bone Bone affecting the TransformNode
   * @param affectedTransformNode TransformNode associated with the bone
   * @returns this object
   */
  attachToBone(bone, affectedTransformNode) {
    this._currentParentWhenAttachingToBone = this.parent;
    this._transformToBoneReferal = affectedTransformNode;
    this.parent = bone;
    bone.getSkeleton().prepare(true);
    if (bone.getFinalMatrix().determinant() < 0) {
      this.scalingDeterminant *= -1;
    }
    return this;
  }
  /**
   * Detach the transform node if its associated with a bone
   * @param resetToPreviousParent Indicates if the parent that was in effect when attachToBone was called should be set back or if we should set parent to null instead (defaults to the latter)
   * @returns this object
   */
  detachFromBone(resetToPreviousParent = false) {
    if (!this.parent) {
      if (resetToPreviousParent) {
        this.parent = this._currentParentWhenAttachingToBone;
      }
      return this;
    }
    if (this.parent.getWorldMatrix().determinant() < 0) {
      this.scalingDeterminant *= -1;
    }
    this._transformToBoneReferal = null;
    if (resetToPreviousParent) {
      this.parent = this._currentParentWhenAttachingToBone;
    } else {
      this.parent = null;
    }
    return this;
  }
  /**
   * Rotates the mesh around the axis vector for the passed angle (amount) expressed in radians, in the given space.
   * space (default LOCAL) can be either Space.LOCAL, either Space.WORLD.
   * Note that the property `rotationQuaternion` is then automatically updated and the property `rotation` is set to (0,0,0) and no longer used.
   * The passed axis is also normalized.
   * @param axis the axis to rotate around
   * @param amount the amount to rotate in radians
   * @param space Space to rotate in (Default: local)
   * @returns the TransformNode.
   */
  rotate(axis, amount, space) {
    axis.normalize();
    if (!this.rotationQuaternion) {
      this.rotationQuaternion = this.rotation.toQuaternion();
      this.rotation.setAll(0);
    }
    let rotationQuaternion;
    if (!space || space === 0) {
      rotationQuaternion = Quaternion.RotationAxisToRef(axis, amount, TransformNode._RotationAxisCache);
      this.rotationQuaternion.multiplyToRef(rotationQuaternion, this.rotationQuaternion);
    } else {
      if (this.parent) {
        const parentWorldMatrix = this.parent.getWorldMatrix();
        const invertParentWorldMatrix = TmpVectors.Matrix[0];
        parentWorldMatrix.invertToRef(invertParentWorldMatrix);
        axis = Vector3.TransformNormal(axis, invertParentWorldMatrix);
        if (parentWorldMatrix.determinant() < 0) {
          amount *= -1;
        }
      }
      rotationQuaternion = Quaternion.RotationAxisToRef(axis, amount, TransformNode._RotationAxisCache);
      rotationQuaternion.multiplyToRef(this.rotationQuaternion, this.rotationQuaternion);
    }
    return this;
  }
  /**
   * Rotates the mesh around the axis vector for the passed angle (amount) expressed in radians, in world space.
   * Note that the property `rotationQuaternion` is then automatically updated and the property `rotation` is set to (0,0,0) and no longer used.
   * The passed axis is also normalized. .
   * Method is based on http://www.euclideanspace.com/maths/geometry/affine/aroundPoint/index.htm
   * @param point the point to rotate around
   * @param axis the axis to rotate around
   * @param amount the amount to rotate in radians
   * @returns the TransformNode
   */
  rotateAround(point, axis, amount) {
    axis.normalize();
    if (!this.rotationQuaternion) {
      this.rotationQuaternion = Quaternion.RotationYawPitchRoll(this.rotation.y, this.rotation.x, this.rotation.z);
      this.rotation.setAll(0);
    }
    const tmpVector = TmpVectors.Vector3[0];
    const finalScale = TmpVectors.Vector3[1];
    const finalTranslation = TmpVectors.Vector3[2];
    const finalRotation = TmpVectors.Quaternion[0];
    const translationMatrix = TmpVectors.Matrix[0];
    const translationMatrixInv = TmpVectors.Matrix[1];
    const rotationMatrix = TmpVectors.Matrix[2];
    const finalMatrix = TmpVectors.Matrix[3];
    point.subtractToRef(this.position, tmpVector);
    Matrix.TranslationToRef(tmpVector.x, tmpVector.y, tmpVector.z, translationMatrix);
    Matrix.TranslationToRef(-tmpVector.x, -tmpVector.y, -tmpVector.z, translationMatrixInv);
    Matrix.RotationAxisToRef(axis, amount, rotationMatrix);
    translationMatrixInv.multiplyToRef(rotationMatrix, finalMatrix);
    finalMatrix.multiplyToRef(translationMatrix, finalMatrix);
    finalMatrix.decompose(finalScale, finalRotation, finalTranslation);
    this.position.addInPlace(finalTranslation);
    finalRotation.multiplyToRef(this.rotationQuaternion, this.rotationQuaternion);
    return this;
  }
  /**
   * Translates the mesh along the axis vector for the passed distance in the given space.
   * space (default LOCAL) can be either Space.LOCAL, either Space.WORLD.
   * @param axis the axis to translate in
   * @param distance the distance to translate
   * @param space Space to rotate in (Default: local)
   * @returns the TransformNode.
   */
  translate(axis, distance, space) {
    const displacementVector = axis.scale(distance);
    if (!space || space === 0) {
      const tempV3 = this.getPositionExpressedInLocalSpace().add(displacementVector);
      this.setPositionWithLocalVector(tempV3);
    } else {
      this.setAbsolutePosition(this.getAbsolutePosition().add(displacementVector));
    }
    return this;
  }
  /**
   * Adds a rotation step to the mesh current rotation.
   * x, y, z are Euler angles expressed in radians.
   * This methods updates the current mesh rotation, either mesh.rotation, either mesh.rotationQuaternion if it's set.
   * This means this rotation is made in the mesh local space only.
   * It's useful to set a custom rotation order different from the BJS standard one YXZ.
   * Example : this rotates the mesh first around its local X axis, then around its local Z axis, finally around its local Y axis.
   * ```javascript
   * mesh.addRotation(x1, 0, 0).addRotation(0, 0, z2).addRotation(0, 0, y3);
   * ```
   * Note that `addRotation()` accumulates the passed rotation values to the current ones and computes the .rotation or .rotationQuaternion updated values.
   * Under the hood, only quaternions are used. So it's a little faster is you use .rotationQuaternion because it doesn't need to translate them back to Euler angles.
   * @param x Rotation to add
   * @param y Rotation to add
   * @param z Rotation to add
   * @returns the TransformNode.
   */
  addRotation(x2, y2, z2) {
    let rotationQuaternion;
    if (this.rotationQuaternion) {
      rotationQuaternion = this.rotationQuaternion;
    } else {
      rotationQuaternion = TmpVectors.Quaternion[1];
      Quaternion.RotationYawPitchRollToRef(this.rotation.y, this.rotation.x, this.rotation.z, rotationQuaternion);
    }
    const accumulation = TmpVectors.Quaternion[0];
    Quaternion.RotationYawPitchRollToRef(y2, x2, z2, accumulation);
    rotationQuaternion.multiplyInPlace(accumulation);
    if (!this.rotationQuaternion) {
      rotationQuaternion.toEulerAnglesToRef(this.rotation);
    }
    return this;
  }
  /**
   * @internal
   */
  _getEffectiveParent() {
    return this.parent;
  }
  /**
   * Returns whether the transform node world matrix computation needs the camera information to be computed.
   * This is the case when the node is a billboard or has an infinite distance for instance.
   * @returns true if the world matrix computation needs the camera information to be computed
   */
  isWorldMatrixCameraDependent() {
    return this._infiniteDistance && !this.parent || this._billboardMode !== TransformNode.BILLBOARDMODE_NONE && !this.preserveParentRotationForBillboard;
  }
  /**
   * Computes the world matrix of the node
   * @param force defines if the cache version should be invalidated forcing the world matrix to be created from scratch
   * @param camera defines the camera used if different from the scene active camera (This is used with modes like Billboard or infinite distance)
   * @returns the world matrix
   */
  computeWorldMatrix(force = false, camera = null) {
    if (this._isWorldMatrixFrozen && !this._isDirty) {
      return this._worldMatrix;
    }
    const currentRenderId = this.getScene().getRenderId();
    if (!this._isDirty && !force && (this._currentRenderId === currentRenderId || this.isSynchronized())) {
      this._currentRenderId = currentRenderId;
      return this._worldMatrix;
    }
    camera = camera || this.getScene().activeCamera;
    this._updateCache();
    const cache = this._cache;
    cache.pivotMatrixUpdated = false;
    cache.billboardMode = this.billboardMode;
    cache.infiniteDistance = this.infiniteDistance;
    cache.parent = this._parentNode;
    this._currentRenderId = currentRenderId;
    this._childUpdateId += 1;
    this._isDirty = false;
    this._position._isDirty = false;
    this._rotation._isDirty = false;
    this._scaling._isDirty = false;
    const parent = this._getEffectiveParent();
    const scaling = TransformNode._TmpScaling;
    let translation = this._position;
    if (this._infiniteDistance) {
      if (!this.parent && camera) {
        const cameraWorldMatrix = camera.getWorldMatrix();
        const cameraGlobalPosition = new Vector3(cameraWorldMatrix.m[12], cameraWorldMatrix.m[13], cameraWorldMatrix.m[14]);
        translation = TransformNode._TmpTranslation;
        translation.copyFromFloats(this._position.x + cameraGlobalPosition.x, this._position.y + cameraGlobalPosition.y, this._position.z + cameraGlobalPosition.z);
      }
    }
    scaling.copyFromFloats(this._scaling.x * this.scalingDeterminant, this._scaling.y * this.scalingDeterminant, this._scaling.z * this.scalingDeterminant);
    let rotation;
    if (this._rotationQuaternion) {
      this._rotationQuaternion._isDirty = false;
      rotation = this._rotationQuaternion;
      if (this.reIntegrateRotationIntoRotationQuaternion) {
        const len = this.rotation.lengthSquared();
        if (len) {
          this._rotationQuaternion.multiplyInPlace(Quaternion.RotationYawPitchRoll(this._rotation.y, this._rotation.x, this._rotation.z));
          this._rotation.copyFromFloats(0, 0, 0);
        }
      }
    } else {
      rotation = TransformNode._TmpRotation;
      Quaternion.RotationYawPitchRollToRef(this._rotation.y, this._rotation.x, this._rotation.z, rotation);
    }
    if (this._usePivotMatrix) {
      const scaleMatrix = TmpVectors.Matrix[1];
      Matrix.ScalingToRef(scaling.x, scaling.y, scaling.z, scaleMatrix);
      const rotationMatrix = TmpVectors.Matrix[0];
      rotation.toRotationMatrix(rotationMatrix);
      this._pivotMatrix.multiplyToRef(scaleMatrix, TmpVectors.Matrix[4]);
      TmpVectors.Matrix[4].multiplyToRef(rotationMatrix, this._localMatrix);
      if (this._postMultiplyPivotMatrix) {
        this._localMatrix.multiplyToRef(this._pivotMatrixInverse, this._localMatrix);
      }
      this._localMatrix.addTranslationFromFloats(translation.x, translation.y, translation.z);
    } else {
      Matrix.ComposeToRef(scaling, rotation, translation, this._localMatrix);
    }
    if (parent && parent.getWorldMatrix) {
      if (force) {
        parent.computeWorldMatrix(force);
      }
      if (cache.useBillboardPath) {
        if (this._transformToBoneReferal) {
          const bone = this.parent;
          bone.getSkeleton().prepare();
          bone.getFinalMatrix().multiplyToRef(this._transformToBoneReferal.getWorldMatrix(), TmpVectors.Matrix[7]);
        } else {
          TmpVectors.Matrix[7].copyFrom(parent.getWorldMatrix());
        }
        const translation2 = TmpVectors.Vector3[5];
        const scale = TmpVectors.Vector3[6];
        const orientation = TmpVectors.Quaternion[0];
        TmpVectors.Matrix[7].decompose(scale, orientation, translation2);
        Matrix.ScalingToRef(scale.x, scale.y, scale.z, TmpVectors.Matrix[7]);
        TmpVectors.Matrix[7].setTranslation(translation2);
        if (TransformNode.BillboardUseParentOrientation) {
          this._position.applyRotationQuaternionToRef(orientation, translation2);
          this._localMatrix.setTranslation(translation2);
        }
        this._localMatrix.multiplyToRef(TmpVectors.Matrix[7], this._worldMatrix);
      } else {
        if (this._transformToBoneReferal) {
          const bone = this.parent;
          bone.getSkeleton().prepare();
          this._localMatrix.multiplyToRef(bone.getFinalMatrix(), TmpVectors.Matrix[6]);
          TmpVectors.Matrix[6].multiplyToRef(this._transformToBoneReferal.getWorldMatrix(), this._worldMatrix);
        } else {
          this._localMatrix.multiplyToRef(parent.getWorldMatrix(), this._worldMatrix);
        }
      }
      this._markSyncedWithParent();
    } else {
      this._worldMatrix.copyFrom(this._localMatrix);
    }
    if (cache.useBillboardPath && camera && this.billboardMode && !cache.useBillboardPosition) {
      const storedTranslation = TmpVectors.Vector3[0];
      this._worldMatrix.getTranslationToRef(storedTranslation);
      TmpVectors.Matrix[1].copyFrom(camera.getViewMatrix());
      if (this._scene.useRightHandedSystem) {
        TmpVectors.Matrix[1].multiplyToRef(convertRHSToLHS, TmpVectors.Matrix[1]);
      }
      TmpVectors.Matrix[1].setTranslationFromFloats(0, 0, 0);
      TmpVectors.Matrix[1].invertToRef(TmpVectors.Matrix[0]);
      if ((this.billboardMode & TransformNode.BILLBOARDMODE_ALL) !== TransformNode.BILLBOARDMODE_ALL) {
        TmpVectors.Matrix[0].decompose(void 0, TmpVectors.Quaternion[0], void 0);
        const eulerAngles = TmpVectors.Vector3[1];
        TmpVectors.Quaternion[0].toEulerAnglesToRef(eulerAngles);
        if ((this.billboardMode & TransformNode.BILLBOARDMODE_X) !== TransformNode.BILLBOARDMODE_X) {
          eulerAngles.x = 0;
        }
        if ((this.billboardMode & TransformNode.BILLBOARDMODE_Y) !== TransformNode.BILLBOARDMODE_Y) {
          eulerAngles.y = 0;
        }
        if ((this.billboardMode & TransformNode.BILLBOARDMODE_Z) !== TransformNode.BILLBOARDMODE_Z) {
          eulerAngles.z = 0;
        }
        Matrix.RotationYawPitchRollToRef(eulerAngles.y, eulerAngles.x, eulerAngles.z, TmpVectors.Matrix[0]);
      }
      this._worldMatrix.setTranslationFromFloats(0, 0, 0);
      this._worldMatrix.multiplyToRef(TmpVectors.Matrix[0], this._worldMatrix);
      this._worldMatrix.setTranslation(TmpVectors.Vector3[0]);
    } else if (cache.useBillboardPath && camera && cache.useBillboardPosition) {
      const storedTranslation = TmpVectors.Vector3[0];
      this._worldMatrix.getTranslationToRef(storedTranslation);
      const cameraPosition = camera.globalPosition;
      this._worldMatrix.invertToRef(TmpVectors.Matrix[1]);
      const camInObjSpace = TmpVectors.Vector3[1];
      Vector3.TransformCoordinatesToRef(cameraPosition, TmpVectors.Matrix[1], camInObjSpace);
      camInObjSpace.normalize();
      const yaw = -Math.atan2(camInObjSpace.z, camInObjSpace.x) + Math.PI / 2;
      const len = Math.sqrt(camInObjSpace.x * camInObjSpace.x + camInObjSpace.z * camInObjSpace.z);
      const pitch = -Math.atan2(camInObjSpace.y, len);
      Quaternion.RotationYawPitchRollToRef(yaw, pitch, 0, TmpVectors.Quaternion[0]);
      if ((this.billboardMode & TransformNode.BILLBOARDMODE_ALL) !== TransformNode.BILLBOARDMODE_ALL) {
        const eulerAngles = TmpVectors.Vector3[1];
        TmpVectors.Quaternion[0].toEulerAnglesToRef(eulerAngles);
        if ((this.billboardMode & TransformNode.BILLBOARDMODE_X) !== TransformNode.BILLBOARDMODE_X) {
          eulerAngles.x = 0;
        }
        if ((this.billboardMode & TransformNode.BILLBOARDMODE_Y) !== TransformNode.BILLBOARDMODE_Y) {
          eulerAngles.y = 0;
        }
        if ((this.billboardMode & TransformNode.BILLBOARDMODE_Z) !== TransformNode.BILLBOARDMODE_Z) {
          eulerAngles.z = 0;
        }
        Matrix.RotationYawPitchRollToRef(eulerAngles.y, eulerAngles.x, eulerAngles.z, TmpVectors.Matrix[0]);
      } else {
        Matrix.FromQuaternionToRef(TmpVectors.Quaternion[0], TmpVectors.Matrix[0]);
      }
      this._worldMatrix.setTranslationFromFloats(0, 0, 0);
      this._worldMatrix.multiplyToRef(TmpVectors.Matrix[0], this._worldMatrix);
      this._worldMatrix.setTranslation(TmpVectors.Vector3[0]);
    }
    if (!this.ignoreNonUniformScaling) {
      if (this._scaling.isNonUniformWithinEpsilon(1e-6)) {
        this._updateNonUniformScalingState(true);
      } else if (parent && parent._nonUniformScaling) {
        this._updateNonUniformScalingState(parent._nonUniformScaling);
      } else {
        this._updateNonUniformScalingState(false);
      }
    } else {
      this._updateNonUniformScalingState(false);
    }
    this._afterComputeWorldMatrix();
    this._absolutePosition.copyFromFloats(this._worldMatrix.m[12], this._worldMatrix.m[13], this._worldMatrix.m[14]);
    this._isAbsoluteSynced = false;
    this.onAfterWorldMatrixUpdateObservable.notifyObservers(this);
    if (!this._poseMatrix) {
      this._poseMatrix = Matrix.Invert(this._worldMatrix);
    }
    this._worldMatrixDeterminantIsDirty = true;
    return this._worldMatrix;
  }
  /**
   * Resets this nodeTransform's local matrix to Matrix.Identity().
   * @param independentOfChildren indicates if all child nodeTransform's world-space transform should be preserved.
   */
  resetLocalMatrix(independentOfChildren = true) {
    this.computeWorldMatrix();
    if (independentOfChildren) {
      const children = this.getChildren();
      for (let i2 = 0; i2 < children.length; ++i2) {
        const child = children[i2];
        if (child) {
          child.computeWorldMatrix();
          const bakedMatrix = TmpVectors.Matrix[0];
          child._localMatrix.multiplyToRef(this._localMatrix, bakedMatrix);
          const tmpRotationQuaternion = TmpVectors.Quaternion[0];
          bakedMatrix.decompose(child.scaling, tmpRotationQuaternion, child.position);
          if (child.rotationQuaternion) {
            child.rotationQuaternion.copyFrom(tmpRotationQuaternion);
          } else {
            tmpRotationQuaternion.toEulerAnglesToRef(child.rotation);
          }
        }
      }
    }
    this.scaling.copyFromFloats(1, 1, 1);
    this.position.copyFromFloats(0, 0, 0);
    this.rotation.copyFromFloats(0, 0, 0);
    if (this.rotationQuaternion) {
      this.rotationQuaternion = Quaternion.Identity();
    }
    this._worldMatrix = Matrix.Identity();
  }
  _afterComputeWorldMatrix() {
  }
  /**
   * If you'd like to be called back after the mesh position, rotation or scaling has been updated.
   * @param func callback function to add
   *
   * @returns the TransformNode.
   */
  registerAfterWorldMatrixUpdate(func) {
    this.onAfterWorldMatrixUpdateObservable.add(func);
    return this;
  }
  /**
   * Removes a registered callback function.
   * @param func callback function to remove
   * @returns the TransformNode.
   */
  unregisterAfterWorldMatrixUpdate(func) {
    this.onAfterWorldMatrixUpdateObservable.removeCallback(func);
    return this;
  }
  /**
   * Gets the position of the current mesh in camera space
   * @param camera defines the camera to use
   * @returns a position
   */
  getPositionInCameraSpace(camera = null) {
    if (!camera) {
      camera = this.getScene().activeCamera;
    }
    return Vector3.TransformCoordinates(this.getAbsolutePosition(), camera.getViewMatrix());
  }
  /**
   * Returns the distance from the mesh to the active camera
   * @param camera defines the camera to use
   * @returns the distance
   */
  getDistanceToCamera(camera = null) {
    if (!camera) {
      camera = this.getScene().activeCamera;
    }
    return this.getAbsolutePosition().subtract(camera.globalPosition).length();
  }
  /**
   * Clone the current transform node
   * @param name Name of the new clone
   * @param newParent New parent for the clone
   * @param doNotCloneChildren Do not clone children hierarchy
   * @returns the new transform node
   */
  clone(name2, newParent, doNotCloneChildren) {
    const result = SerializationHelper.Clone(() => new TransformNode(name2, this.getScene()), this);
    result.name = name2;
    result.id = name2;
    if (newParent) {
      result.parent = newParent;
    }
    if (!doNotCloneChildren) {
      const directDescendants = this.getDescendants(true);
      for (let index2 = 0; index2 < directDescendants.length; index2++) {
        const child = directDescendants[index2];
        if (child.clone) {
          child.clone(name2 + "." + child.name, result);
        }
      }
    }
    return result;
  }
  /**
   * Serializes the objects information.
   * @param currentSerializationObject defines the object to serialize in
   * @returns the serialized object
   */
  serialize(currentSerializationObject) {
    const serializationObject = SerializationHelper.Serialize(this, currentSerializationObject);
    serializationObject.type = this.getClassName();
    serializationObject.uniqueId = this.uniqueId;
    if (this.parent) {
      this.parent._serializeAsParent(serializationObject);
    }
    serializationObject.localMatrix = this.getPivotMatrix().asArray();
    serializationObject.isEnabled = this.isEnabled();
    SerializationHelper.AppendSerializedAnimations(this, serializationObject);
    serializationObject.ranges = this.serializeAnimationRanges();
    return serializationObject;
  }
  // Statics
  /**
   * Returns a new TransformNode object parsed from the source provided.
   * @param parsedTransformNode is the source.
   * @param scene the scene the object belongs to
   * @param rootUrl is a string, it's the root URL to prefix the `delayLoadingFile` property with
   * @returns a new TransformNode object parsed from the source provided.
   */
  static Parse(parsedTransformNode, scene, rootUrl) {
    const transformNode = SerializationHelper.Parse(() => new TransformNode(parsedTransformNode.name, scene), parsedTransformNode, scene, rootUrl);
    if (parsedTransformNode.localMatrix) {
      transformNode.setPreTransformMatrix(Matrix.FromArray(parsedTransformNode.localMatrix));
    } else if (parsedTransformNode.pivotMatrix) {
      transformNode.setPivotMatrix(Matrix.FromArray(parsedTransformNode.pivotMatrix));
    }
    transformNode.setEnabled(parsedTransformNode.isEnabled);
    transformNode._waitingParsedUniqueId = parsedTransformNode.uniqueId;
    if (parsedTransformNode.parentId !== void 0) {
      transformNode._waitingParentId = parsedTransformNode.parentId;
    }
    if (parsedTransformNode.parentInstanceIndex !== void 0) {
      transformNode._waitingParentInstanceIndex = parsedTransformNode.parentInstanceIndex;
    }
    if (parsedTransformNode.animations) {
      for (let animationIndex = 0; animationIndex < parsedTransformNode.animations.length; animationIndex++) {
        const parsedAnimation = parsedTransformNode.animations[animationIndex];
        const internalClass = GetClass("BABYLON.Animation");
        if (internalClass) {
          transformNode.animations.push(internalClass.Parse(parsedAnimation));
        }
      }
      Node.ParseAnimationRanges(transformNode, parsedTransformNode, scene);
    }
    if (parsedTransformNode.autoAnimate) {
      scene.beginAnimation(transformNode, parsedTransformNode.autoAnimateFrom, parsedTransformNode.autoAnimateTo, parsedTransformNode.autoAnimateLoop, parsedTransformNode.autoAnimateSpeed || 1);
    }
    return transformNode;
  }
  /**
   * Get all child-transformNodes of this node
   * @param directDescendantsOnly defines if true only direct descendants of 'this' will be considered, if false direct and also indirect (children of children, an so on in a recursive manner) descendants of 'this' will be considered
   * @param predicate defines an optional predicate that will be called on every evaluated child, the predicate must return true for a given child to be part of the result, otherwise it will be ignored
   * @returns an array of TransformNode
   */
  getChildTransformNodes(directDescendantsOnly, predicate) {
    const results = [];
    this._getDescendants(results, directDescendantsOnly, (node) => {
      return (!predicate || predicate(node)) && node instanceof TransformNode;
    });
    return results;
  }
  /**
   * Releases resources associated with this transform node.
   * @param doNotRecurse Set to true to not recurse into each children (recurse into each children by default)
   * @param disposeMaterialAndTextures Set to true to also dispose referenced materials and textures (false by default)
   */
  dispose(doNotRecurse, disposeMaterialAndTextures = false) {
    this.getScene().stopAnimation(this);
    this.getScene().removeTransformNode(this);
    if (this._parentContainer) {
      const index2 = this._parentContainer.transformNodes.indexOf(this);
      if (index2 > -1) {
        this._parentContainer.transformNodes.splice(index2, 1);
      }
      this._parentContainer = null;
    }
    this.onAfterWorldMatrixUpdateObservable.clear();
    if (doNotRecurse) {
      const transformNodes = this.getChildTransformNodes(true);
      for (const transformNode of transformNodes) {
        transformNode.parent = null;
        transformNode.computeWorldMatrix(true);
      }
    }
    super.dispose(doNotRecurse, disposeMaterialAndTextures);
  }
  /**
   * Uniformly scales the mesh to fit inside of a unit cube (1 X 1 X 1 units)
   * @param includeDescendants Use the hierarchy's bounding box instead of the mesh's bounding box. Default is false
   * @param ignoreRotation ignore rotation when computing the scale (ie. object will be axis aligned). Default is false
   * @param predicate predicate that is passed in to getHierarchyBoundingVectors when selecting which object should be included when scaling
   * @returns the current mesh
   */
  normalizeToUnitCube(includeDescendants = true, ignoreRotation = false, predicate) {
    let storedRotation = null;
    let storedRotationQuaternion = null;
    if (ignoreRotation) {
      if (this.rotationQuaternion) {
        storedRotationQuaternion = this.rotationQuaternion.clone();
        this.rotationQuaternion.copyFromFloats(0, 0, 0, 1);
      } else if (this.rotation) {
        storedRotation = this.rotation.clone();
        this.rotation.copyFromFloats(0, 0, 0);
      }
    }
    const boundingVectors = this.getHierarchyBoundingVectors(includeDescendants, predicate);
    const sizeVec = boundingVectors.max.subtract(boundingVectors.min);
    const maxDimension = Math.max(sizeVec.x, sizeVec.y, sizeVec.z);
    if (maxDimension === 0) {
      return this;
    }
    const scale = 1 / maxDimension;
    this.scaling.scaleInPlace(scale);
    if (ignoreRotation) {
      if (this.rotationQuaternion && storedRotationQuaternion) {
        this.rotationQuaternion.copyFrom(storedRotationQuaternion);
      } else if (this.rotation && storedRotation) {
        this.rotation.copyFrom(storedRotation);
      }
    }
    return this;
  }
  _syncAbsoluteScalingAndRotation() {
    if (!this._isAbsoluteSynced) {
      this._worldMatrix.decompose(this._absoluteScaling, this._absoluteRotationQuaternion);
      this._isAbsoluteSynced = true;
    }
  }
}
TransformNode.BILLBOARDMODE_NONE = 0;
TransformNode.BILLBOARDMODE_X = 1;
TransformNode.BILLBOARDMODE_Y = 2;
TransformNode.BILLBOARDMODE_Z = 4;
TransformNode.BILLBOARDMODE_ALL = 7;
TransformNode.BILLBOARDMODE_USE_POSITION = 128;
TransformNode.BillboardUseParentOrientation = false;
TransformNode._TmpRotation = Quaternion.Zero();
TransformNode._TmpScaling = Vector3.Zero();
TransformNode._TmpTranslation = Vector3.Zero();
TransformNode._LookAtVectorCache = new Vector3(0, 0, 0);
TransformNode._RotationAxisCache = new Quaternion();
__decorate([
  serializeAsVector3("position")
], TransformNode.prototype, "_position", void 0);
__decorate([
  serializeAsVector3("rotation")
], TransformNode.prototype, "_rotation", void 0);
__decorate([
  serializeAsQuaternion("rotationQuaternion")
], TransformNode.prototype, "_rotationQuaternion", void 0);
__decorate([
  serializeAsVector3("scaling")
], TransformNode.prototype, "_scaling", void 0);
__decorate([
  serialize("billboardMode")
], TransformNode.prototype, "_billboardMode", void 0);
__decorate([
  serialize()
], TransformNode.prototype, "scalingDeterminant", void 0);
__decorate([
  serialize("infiniteDistance")
], TransformNode.prototype, "_infiniteDistance", void 0);
__decorate([
  serialize()
], TransformNode.prototype, "ignoreNonUniformScaling", void 0);
__decorate([
  serialize()
], TransformNode.prototype, "reIntegrateRotationIntoRotationQuaternion", void 0);
class PickingInfo {
  constructor() {
    this.hit = false;
    this.distance = 0;
    this.pickedPoint = null;
    this.pickedMesh = null;
    this.bu = 0;
    this.bv = 0;
    this.faceId = -1;
    this.subMeshFaceId = -1;
    this.subMeshId = 0;
    this.pickedSprite = null;
    this.thinInstanceIndex = -1;
    this.ray = null;
    this.originMesh = null;
    this.aimTransform = null;
    this.gripTransform = null;
  }
  /**
   * Gets the normal corresponding to the face the pick collided with
   * @param useWorldCoordinates If the resulting normal should be relative to the world (default: false)
   * @param useVerticesNormals If the vertices normals should be used to calculate the normal instead of the normal map (default: true)
   * @returns The normal corresponding to the face the pick collided with
   * @remarks Note that the returned normal will always point towards the picking ray.
   */
  getNormal(useWorldCoordinates = false, useVerticesNormals = true) {
    if (!this.pickedMesh || useVerticesNormals && !this.pickedMesh.isVerticesDataPresent(VertexBuffer.NormalKind)) {
      return null;
    }
    let indices = this.pickedMesh.getIndices();
    if ((indices == null ? void 0 : indices.length) === 0) {
      indices = null;
    }
    let result;
    const tmp0 = TmpVectors.Vector3[0];
    const tmp1 = TmpVectors.Vector3[1];
    const tmp2 = TmpVectors.Vector3[2];
    if (useVerticesNormals) {
      const normals = this.pickedMesh.getVerticesData(VertexBuffer.NormalKind);
      let normal0 = indices ? Vector3.FromArrayToRef(normals, indices[this.faceId * 3] * 3, tmp0) : tmp0.copyFromFloats(normals[this.faceId * 3 * 3], normals[this.faceId * 3 * 3 + 1], normals[this.faceId * 3 * 3 + 2]);
      let normal1 = indices ? Vector3.FromArrayToRef(normals, indices[this.faceId * 3 + 1] * 3, tmp1) : tmp1.copyFromFloats(normals[(this.faceId * 3 + 1) * 3], normals[(this.faceId * 3 + 1) * 3 + 1], normals[(this.faceId * 3 + 1) * 3 + 2]);
      let normal2 = indices ? Vector3.FromArrayToRef(normals, indices[this.faceId * 3 + 2] * 3, tmp2) : tmp2.copyFromFloats(normals[(this.faceId * 3 + 2) * 3], normals[(this.faceId * 3 + 2) * 3 + 1], normals[(this.faceId * 3 + 2) * 3 + 2]);
      normal0 = normal0.scale(this.bu);
      normal1 = normal1.scale(this.bv);
      normal2 = normal2.scale(1 - this.bu - this.bv);
      result = new Vector3(normal0.x + normal1.x + normal2.x, normal0.y + normal1.y + normal2.y, normal0.z + normal1.z + normal2.z);
    } else {
      const positions = this.pickedMesh.getVerticesData(VertexBuffer.PositionKind);
      const vertex1 = indices ? Vector3.FromArrayToRef(positions, indices[this.faceId * 3] * 3, tmp0) : tmp0.copyFromFloats(positions[this.faceId * 3 * 3], positions[this.faceId * 3 * 3 + 1], positions[this.faceId * 3 * 3 + 2]);
      const vertex2 = indices ? Vector3.FromArrayToRef(positions, indices[this.faceId * 3 + 1] * 3, tmp1) : tmp1.copyFromFloats(positions[(this.faceId * 3 + 1) * 3], positions[(this.faceId * 3 + 1) * 3 + 1], positions[(this.faceId * 3 + 1) * 3 + 2]);
      const vertex3 = indices ? Vector3.FromArrayToRef(positions, indices[this.faceId * 3 + 2] * 3, tmp2) : tmp2.copyFromFloats(positions[(this.faceId * 3 + 2) * 3], positions[(this.faceId * 3 + 2) * 3 + 1], positions[(this.faceId * 3 + 2) * 3 + 2]);
      const p1p2 = vertex1.subtract(vertex2);
      const p3p2 = vertex3.subtract(vertex2);
      result = Vector3.Cross(p1p2, p3p2);
    }
    const transformNormalToWorld = (pickedMesh, n3) => {
      let wm = pickedMesh.getWorldMatrix();
      if (pickedMesh.nonUniformScaling) {
        TmpVectors.Matrix[0].copyFrom(wm);
        wm = TmpVectors.Matrix[0];
        wm.setTranslationFromFloats(0, 0, 0);
        wm.invert();
        wm.transposeToRef(TmpVectors.Matrix[1]);
        wm = TmpVectors.Matrix[1];
      }
      Vector3.TransformNormalToRef(n3, wm, n3);
    };
    if (useWorldCoordinates) {
      transformNormalToWorld(this.pickedMesh, result);
    }
    if (this.ray) {
      const normalForDirectionChecking = TmpVectors.Vector3[0].copyFrom(result);
      if (!useWorldCoordinates) {
        transformNormalToWorld(this.pickedMesh, normalForDirectionChecking);
      }
      if (Vector3.Dot(normalForDirectionChecking, this.ray.direction) > 0) {
        result.negateInPlace();
      }
    }
    result.normalize();
    return result;
  }
  /**
   * Gets the texture coordinates of where the pick occurred
   * @param uvSet The UV set to use to calculate the texture coordinates (default: VertexBuffer.UVKind)
   * @returns The vector containing the coordinates of the texture
   */
  getTextureCoordinates(uvSet = VertexBuffer.UVKind) {
    if (!this.pickedMesh || !this.pickedMesh.isVerticesDataPresent(uvSet)) {
      return null;
    }
    const indices = this.pickedMesh.getIndices();
    if (!indices) {
      return null;
    }
    const uvs = this.pickedMesh.getVerticesData(uvSet);
    if (!uvs) {
      return null;
    }
    let uv0 = Vector2.FromArray(uvs, indices[this.faceId * 3] * 2);
    let uv1 = Vector2.FromArray(uvs, indices[this.faceId * 3 + 1] * 2);
    let uv2 = Vector2.FromArray(uvs, indices[this.faceId * 3 + 2] * 2);
    uv0 = uv0.scale(this.bu);
    uv1 = uv1.scale(this.bv);
    uv2 = uv2.scale(1 - this.bu - this.bv);
    return new Vector2(uv0.x + uv1.x + uv2.x, uv0.y + uv1.y + uv2.y);
  }
}
class UniformBuffer {
  /**
   * Instantiates a new Uniform buffer objects.
   *
   * Handles blocks of uniform on the GPU.
   *
   * If WebGL 2 is not available, this class falls back on traditional setUniformXXX calls.
   *
   * For more information, please refer to :
   * @see https://www.khronos.org/opengl/wiki/Uniform_Buffer_Object
   * @param engine Define the engine the buffer is associated with
   * @param data Define the data contained in the buffer
   * @param dynamic Define if the buffer is updatable
   * @param name to assign to the buffer (debugging purpose)
   * @param forceNoUniformBuffer define that this object must not rely on UBO objects
   */
  constructor(engine2, data, dynamic, name2, forceNoUniformBuffer = false) {
    this._valueCache = {};
    this._engine = engine2;
    this._noUBO = !engine2.supportsUniformBuffers || forceNoUniformBuffer;
    this._dynamic = dynamic;
    this._name = name2 ?? "no-name";
    this._data = data || [];
    this._uniformLocations = {};
    this._uniformSizes = {};
    this._uniformArraySizes = {};
    this._uniformLocationPointer = 0;
    this._needSync = false;
    if (this._engine._features.trackUbosInFrame) {
      this._buffers = [];
      this._bufferIndex = -1;
      this._createBufferOnWrite = false;
      this._currentFrameId = 0;
    }
    if (this._noUBO) {
      this.updateMatrix3x3 = this._updateMatrix3x3ForEffect;
      this.updateMatrix2x2 = this._updateMatrix2x2ForEffect;
      this.updateFloat = this._updateFloatForEffect;
      this.updateFloat2 = this._updateFloat2ForEffect;
      this.updateFloat3 = this._updateFloat3ForEffect;
      this.updateFloat4 = this._updateFloat4ForEffect;
      this.updateFloatArray = this._updateFloatArrayForEffect;
      this.updateArray = this._updateArrayForEffect;
      this.updateIntArray = this._updateIntArrayForEffect;
      this.updateUIntArray = this._updateUIntArrayForEffect;
      this.updateMatrix = this._updateMatrixForEffect;
      this.updateMatrices = this._updateMatricesForEffect;
      this.updateVector3 = this._updateVector3ForEffect;
      this.updateVector4 = this._updateVector4ForEffect;
      this.updateColor3 = this._updateColor3ForEffect;
      this.updateColor4 = this._updateColor4ForEffect;
      this.updateDirectColor4 = this._updateDirectColor4ForEffect;
      this.updateInt = this._updateIntForEffect;
      this.updateInt2 = this._updateInt2ForEffect;
      this.updateInt3 = this._updateInt3ForEffect;
      this.updateInt4 = this._updateInt4ForEffect;
      this.updateUInt = this._updateUIntForEffect;
      this.updateUInt2 = this._updateUInt2ForEffect;
      this.updateUInt3 = this._updateUInt3ForEffect;
      this.updateUInt4 = this._updateUInt4ForEffect;
    } else {
      this._engine._uniformBuffers.push(this);
      this.updateMatrix3x3 = this._updateMatrix3x3ForUniform;
      this.updateMatrix2x2 = this._updateMatrix2x2ForUniform;
      this.updateFloat = this._updateFloatForUniform;
      this.updateFloat2 = this._updateFloat2ForUniform;
      this.updateFloat3 = this._updateFloat3ForUniform;
      this.updateFloat4 = this._updateFloat4ForUniform;
      this.updateFloatArray = this._updateFloatArrayForUniform;
      this.updateArray = this._updateArrayForUniform;
      this.updateIntArray = this._updateIntArrayForUniform;
      this.updateUIntArray = this._updateUIntArrayForUniform;
      this.updateMatrix = this._updateMatrixForUniform;
      this.updateMatrices = this._updateMatricesForUniform;
      this.updateVector3 = this._updateVector3ForUniform;
      this.updateVector4 = this._updateVector4ForUniform;
      this.updateColor3 = this._updateColor3ForUniform;
      this.updateColor4 = this._updateColor4ForUniform;
      this.updateDirectColor4 = this._updateDirectColor4ForUniform;
      this.updateInt = this._updateIntForUniform;
      this.updateInt2 = this._updateInt2ForUniform;
      this.updateInt3 = this._updateInt3ForUniform;
      this.updateInt4 = this._updateInt4ForUniform;
      this.updateUInt = this._updateUIntForUniform;
      this.updateUInt2 = this._updateUInt2ForUniform;
      this.updateUInt3 = this._updateUInt3ForUniform;
      this.updateUInt4 = this._updateUInt4ForUniform;
    }
  }
  /**
   * Indicates if the buffer is using the WebGL2 UBO implementation,
   * or just falling back on setUniformXXX calls.
   */
  get useUbo() {
    return !this._noUBO;
  }
  /**
   * Indicates if the WebGL underlying uniform buffer is in sync
   * with the javascript cache data.
   */
  get isSync() {
    return !this._needSync;
  }
  /**
   * Indicates if the WebGL underlying uniform buffer is dynamic.
   * Also, a dynamic UniformBuffer will disable cache verification and always
   * update the underlying WebGL uniform buffer to the GPU.
   * @returns if Dynamic, otherwise false
   */
  isDynamic() {
    return this._dynamic !== void 0;
  }
  /**
   * The data cache on JS side.
   * @returns the underlying data as a float array
   */
  getData() {
    return this._bufferData;
  }
  /**
   * The underlying WebGL Uniform buffer.
   * @returns the webgl buffer
   */
  getBuffer() {
    return this._buffer;
  }
  /**
   * std140 layout specifies how to align data within an UBO structure.
   * See https://khronos.org/registry/OpenGL/specs/gl/glspec45.core.pdf#page=159
   * for specs.
   * @param size
   */
  _fillAlignment(size) {
    let alignment;
    if (size <= 2) {
      alignment = size;
    } else {
      alignment = 4;
    }
    if (this._uniformLocationPointer % alignment !== 0) {
      const oldPointer = this._uniformLocationPointer;
      this._uniformLocationPointer += alignment - this._uniformLocationPointer % alignment;
      const diff = this._uniformLocationPointer - oldPointer;
      for (let i2 = 0; i2 < diff; i2++) {
        this._data.push(0);
      }
    }
  }
  /**
   * Adds an uniform in the buffer.
   * Warning : the subsequents calls of this function must be in the same order as declared in the shader
   * for the layout to be correct ! The addUniform function only handles types like float, vec2, vec3, vec4, mat4,
   * meaning size=1,2,3,4 or 16. It does not handle struct types.
   * @param name Name of the uniform, as used in the uniform block in the shader.
   * @param size Data size, or data directly.
   * @param arraySize The number of elements in the array, 0 if not an array.
   */
  addUniform(name2, size, arraySize = 0) {
    if (this._noUBO) {
      return;
    }
    if (this._uniformLocations[name2] !== void 0) {
      return;
    }
    let data;
    if (arraySize > 0) {
      if (size instanceof Array) {
        throw "addUniform should not be use with Array in UBO: " + name2;
      }
      this._fillAlignment(4);
      this._uniformArraySizes[name2] = { strideSize: size, arraySize };
      if (size == 16) {
        size = size * arraySize;
      } else {
        const perElementPadding = 4 - size;
        const totalPadding = perElementPadding * arraySize;
        size = size * arraySize + totalPadding;
      }
      data = [];
      for (let i2 = 0; i2 < size; i2++) {
        data.push(0);
      }
    } else {
      if (size instanceof Array) {
        data = size;
        size = data.length;
      } else {
        size = size;
        data = [];
        for (let i2 = 0; i2 < size; i2++) {
          data.push(0);
        }
      }
      this._fillAlignment(size);
    }
    this._uniformSizes[name2] = size;
    this._uniformLocations[name2] = this._uniformLocationPointer;
    this._uniformLocationPointer += size;
    for (let i2 = 0; i2 < size; i2++) {
      this._data.push(data[i2]);
    }
    this._needSync = true;
  }
  /**
   * Adds a Matrix 4x4 to the uniform buffer.
   * @param name Name of the uniform, as used in the uniform block in the shader.
   * @param mat A 4x4 matrix.
   */
  addMatrix(name2, mat) {
    this.addUniform(name2, Array.prototype.slice.call(mat.asArray()));
  }
  /**
   * Adds a vec2 to the uniform buffer.
   * @param name Name of the uniform, as used in the uniform block in the shader.
   * @param x Define the x component value of the vec2
   * @param y Define the y component value of the vec2
   */
  addFloat2(name2, x2, y2) {
    const temp = [x2, y2];
    this.addUniform(name2, temp);
  }
  /**
   * Adds a vec3 to the uniform buffer.
   * @param name Name of the uniform, as used in the uniform block in the shader.
   * @param x Define the x component value of the vec3
   * @param y Define the y component value of the vec3
   * @param z Define the z component value of the vec3
   */
  addFloat3(name2, x2, y2, z2) {
    const temp = [x2, y2, z2];
    this.addUniform(name2, temp);
  }
  /**
   * Adds a vec3 to the uniform buffer.
   * @param name Name of the uniform, as used in the uniform block in the shader.
   * @param color Define the vec3 from a Color
   */
  addColor3(name2, color) {
    const temp = [color.r, color.g, color.b];
    this.addUniform(name2, temp);
  }
  /**
   * Adds a vec4 to the uniform buffer.
   * @param name Name of the uniform, as used in the uniform block in the shader.
   * @param color Define the rgb components from a Color
   * @param alpha Define the a component of the vec4
   */
  addColor4(name2, color, alpha) {
    const temp = [color.r, color.g, color.b, alpha];
    this.addUniform(name2, temp);
  }
  /**
   * Adds a vec3 to the uniform buffer.
   * @param name Name of the uniform, as used in the uniform block in the shader.
   * @param vector Define the vec3 components from a Vector
   */
  addVector3(name2, vector) {
    const temp = [vector.x, vector.y, vector.z];
    this.addUniform(name2, temp);
  }
  /**
   * Adds a Matrix 3x3 to the uniform buffer.
   * @param name Name of the uniform, as used in the uniform block in the shader.
   */
  addMatrix3x3(name2) {
    this.addUniform(name2, 12);
  }
  /**
   * Adds a Matrix 2x2 to the uniform buffer.
   * @param name Name of the uniform, as used in the uniform block in the shader.
   */
  addMatrix2x2(name2) {
    this.addUniform(name2, 8);
  }
  /**
   * Effectively creates the WebGL Uniform Buffer, once layout is completed with `addUniform`.
   */
  create() {
    if (this._noUBO) {
      return;
    }
    if (this._buffer) {
      return;
    }
    this._fillAlignment(4);
    this._bufferData = new Float32Array(this._data);
    this._rebuild();
    this._needSync = true;
  }
  // The result of this method is used for debugging purpose, as part of the buffer name
  // It is meant to more easily know what this buffer is about when debugging
  // Some buffers can have a lot of uniforms (several dozens), so the method only returns the first 10 of them
  // (should be enough to understand what the buffer is for)
  _getNames() {
    const names = [];
    let i2 = 0;
    for (const name2 in this._uniformLocations) {
      names.push(name2);
      if (++i2 === 10) {
        break;
      }
    }
    return names.join(",");
  }
  /** @internal */
  _rebuild() {
    if (this._noUBO || !this._bufferData) {
      return;
    }
    if (this._dynamic) {
      this._buffer = this._engine.createDynamicUniformBuffer(this._bufferData, this._name + "_UniformList:" + this._getNames());
    } else {
      this._buffer = this._engine.createUniformBuffer(this._bufferData, this._name + "_UniformList:" + this._getNames());
    }
    if (this._engine._features.trackUbosInFrame) {
      this._buffers.push([this._buffer, this._engine._features.checkUbosContentBeforeUpload ? this._bufferData.slice() : void 0]);
      this._bufferIndex = this._buffers.length - 1;
      this._createBufferOnWrite = false;
    }
  }
  /** @internal */
  _rebuildAfterContextLost() {
    if (this._engine._features.trackUbosInFrame) {
      this._buffers = [];
      this._currentFrameId = 0;
    }
    this._rebuild();
  }
  /** @internal */
  get _numBuffers() {
    return this._buffers.length;
  }
  /** @internal */
  get _indexBuffer() {
    return this._bufferIndex;
  }
  /** Gets the name of this buffer */
  get name() {
    return this._name;
  }
  /** Gets the current effect */
  get currentEffect() {
    return this._currentEffect;
  }
  _buffersEqual(buf1, buf2) {
    for (let i2 = 0; i2 < buf1.length; ++i2) {
      if (buf1[i2] !== buf2[i2]) {
        return false;
      }
    }
    return true;
  }
  _copyBuffer(src, dst) {
    for (let i2 = 0; i2 < src.length; ++i2) {
      dst[i2] = src[i2];
    }
  }
  /**
   * Updates the WebGL Uniform Buffer on the GPU.
   * If the `dynamic` flag is set to true, no cache comparison is done.
   * Otherwise, the buffer will be updated only if the cache differs.
   */
  update() {
    if (this._noUBO) {
      return;
    }
    this.bindUniformBuffer();
    if (!this._buffer) {
      this.create();
      return;
    }
    if (!this._dynamic && !this._needSync) {
      this._createBufferOnWrite = this._engine._features.trackUbosInFrame;
      return;
    }
    if (this._buffers && this._buffers.length > 1 && this._buffers[this._bufferIndex][1]) {
      if (this._buffersEqual(this._bufferData, this._buffers[this._bufferIndex][1])) {
        this._needSync = false;
        this._createBufferOnWrite = this._engine._features.trackUbosInFrame;
        return;
      } else {
        this._c